;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.iotevents-data.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.iotevents-data/BatchDisableAlarmResponse
  (s/keys :opt-un [:cognitect.aws.iotevents-data.BatchDisableAlarmResponse/errorEntries]))

(s/def :cognitect.aws.iotevents-data/EventType (s/spec string? :gen #(s/gen #{"STATE_CHANGE"})))

(s/def
  :cognitect.aws.iotevents-data/ThrottlingException
  (s/keys :opt-un [:cognitect.aws.iotevents-data.ThrottlingException/message]))

(s/def
  :cognitect.aws.iotevents-data/DescribeDetectorResponse
  (s/keys :opt-un [:cognitect.aws.iotevents-data.DescribeDetectorResponse/detector]))

(s/def
  :cognitect.aws.iotevents-data/Severity
  (s/spec (s/and int? #(<= 0 % 2147483647)) :gen #(gen/choose 0 2147483647)))

(s/def
  :cognitect.aws.iotevents-data/ErrorCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"InvalidRequestException"
        "ServiceUnavailableException"
        "InternalFailureException"
        "ResourceNotFoundException"
        "ThrottlingException"})))

(s/def
  :cognitect.aws.iotevents-data/ListAlarmsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.ListAlarmsResponse/nextToken
     :cognitect.aws.iotevents-data.ListAlarmsResponse/alarmSummaries]))

(s/def
  :cognitect.aws.iotevents-data/BatchUpdateDetectorErrorEntry
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/errorMessage
     :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/errorCode
     :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/messageId]))

(s/def
  :cognitect.aws.iotevents-data/ResetActionConfiguration
  (s/keys :opt-un [:cognitect.aws.iotevents-data.ResetActionConfiguration/note]))

(s/def
  :cognitect.aws.iotevents-data/DescribeAlarmRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.DescribeAlarmRequest/alarmModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.DescribeAlarmRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/AcknowledgeActionConfiguration
  (s/keys :opt-un [:cognitect.aws.iotevents-data.AcknowledgeActionConfiguration/note]))

(s/def
  :cognitect.aws.iotevents-data/DisableActionConfiguration
  (s/keys :opt-un [:cognitect.aws.iotevents-data.DisableActionConfiguration/note]))

(s/def
  :cognitect.aws.iotevents-data/AlarmModelName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/EnableAlarmActionRequests
  (s/coll-of :cognitect.aws.iotevents-data/EnableAlarmActionRequest :min-count 1))

(s/def
  :cognitect.aws.iotevents-data/InvalidRequestException
  (s/keys :opt-un [:cognitect.aws.iotevents-data.InvalidRequestException/message]))

(s/def
  :cognitect.aws.iotevents-data/EnableActionConfiguration
  (s/keys :opt-un [:cognitect.aws.iotevents-data.EnableActionConfiguration/note]))

(s/def
  :cognitect.aws.iotevents-data/BatchEnableAlarmRequest
  (s/keys :req-un [:cognitect.aws.iotevents-data.BatchEnableAlarmRequest/enableActionRequests]))

(s/def
  :cognitect.aws.iotevents-data/SimpleRuleEvaluation
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.SimpleRuleEvaluation/operator
     :cognitect.aws.iotevents-data.SimpleRuleEvaluation/inputPropertyValue
     :cognitect.aws.iotevents-data.SimpleRuleEvaluation/thresholdValue]))

(s/def :cognitect.aws.iotevents-data/TriggerType (s/spec string? :gen #(s/gen #{"SNOOZE_TIMEOUT"})))

(s/def
  :cognitect.aws.iotevents-data/AlarmStateName
  (s/spec
    string?
    :gen
    #(s/gen #{"LATCHED" "DISABLED" "NORMAL" "ACKNOWLEDGED" "ACTIVE" "SNOOZE_DISABLED"})))

(s/def :cognitect.aws.iotevents-data/ThresholdValue string?)

(s/def
  :cognitect.aws.iotevents-data/Message
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.Message/messageId
     :cognitect.aws.iotevents-data.Message/inputName
     :cognitect.aws.iotevents-data.Message/payload]
    :opt-un
    [:cognitect.aws.iotevents-data.Message/timestamp]))

(s/def :cognitect.aws.iotevents-data/errorMessage string?)

(s/def
  :cognitect.aws.iotevents-data/BatchAcknowledgeAlarmRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.BatchAcknowledgeAlarmRequest/acknowledgeActionRequests]))

(s/def
  :cognitect.aws.iotevents-data/TimestampValue
  (s/keys :opt-un [:cognitect.aws.iotevents-data.TimestampValue/timeInMillis]))

(s/def
  :cognitect.aws.iotevents-data/AlarmState
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.AlarmState/systemEvent
     :cognitect.aws.iotevents-data.AlarmState/stateName
     :cognitect.aws.iotevents-data.AlarmState/customerAction
     :cognitect.aws.iotevents-data.AlarmState/ruleEvaluation]))

(s/def
  :cognitect.aws.iotevents-data/UpdateDetectorRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.UpdateDetectorRequest/messageId
     :cognitect.aws.iotevents-data.UpdateDetectorRequest/detectorModelName
     :cognitect.aws.iotevents-data.UpdateDetectorRequest/state]
    :opt-un
    [:cognitect.aws.iotevents-data.UpdateDetectorRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/CustomerAction
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.CustomerAction/enableActionConfiguration
     :cognitect.aws.iotevents-data.CustomerAction/snoozeActionConfiguration
     :cognitect.aws.iotevents-data.CustomerAction/actionName
     :cognitect.aws.iotevents-data.CustomerAction/acknowledgeActionConfiguration
     :cognitect.aws.iotevents-data.CustomerAction/disableActionConfiguration
     :cognitect.aws.iotevents-data.CustomerAction/resetActionConfiguration]))

(s/def
  :cognitect.aws.iotevents-data/DetectorSummaries
  (s/coll-of :cognitect.aws.iotevents-data/DetectorSummary))

(s/def :cognitect.aws.iotevents-data/InputPropertyValue string?)

(s/def
  :cognitect.aws.iotevents-data/SystemEvent
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.SystemEvent/eventType
     :cognitect.aws.iotevents-data.SystemEvent/stateChangeConfiguration]))

(s/def :cognitect.aws.iotevents-data/ErrorMessage string?)

(s/def
  :cognitect.aws.iotevents-data/EnableAlarmActionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.EnableAlarmActionRequest/requestId
     :cognitect.aws.iotevents-data.EnableAlarmActionRequest/alarmModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.EnableAlarmActionRequest/note
     :cognitect.aws.iotevents-data.EnableAlarmActionRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/ListDetectorsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.ListDetectorsResponse/nextToken
     :cognitect.aws.iotevents-data.ListDetectorsResponse/detectorSummaries]))

(s/def
  :cognitect.aws.iotevents-data/VariableDefinitions
  (s/coll-of :cognitect.aws.iotevents-data/VariableDefinition))

(s/def
  :cognitect.aws.iotevents-data/BatchUpdateDetectorRequest
  (s/keys :req-un [:cognitect.aws.iotevents-data.BatchUpdateDetectorRequest/detectors]))

(s/def
  :cognitect.aws.iotevents-data/Note
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iotevents-data/Messages
  (s/coll-of :cognitect.aws.iotevents-data/Message :min-count 1))

(s/def
  :cognitect.aws.iotevents-data/VariableValue
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iotevents-data/ResetAlarmActionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.ResetAlarmActionRequest/requestId
     :cognitect.aws.iotevents-data.ResetAlarmActionRequest/alarmModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.ResetAlarmActionRequest/note
     :cognitect.aws.iotevents-data.ResetAlarmActionRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/KeyValue
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-_:]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/Detector
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.Detector/creationTime
     :cognitect.aws.iotevents-data.Detector/state
     :cognitect.aws.iotevents-data.Detector/lastUpdateTime
     :cognitect.aws.iotevents-data.Detector/detectorModelVersion
     :cognitect.aws.iotevents-data.Detector/detectorModelName
     :cognitect.aws.iotevents-data.Detector/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/BatchPutMessageErrorEntry
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/errorMessage
     :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/errorCode
     :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/messageId]))

(s/def
  :cognitect.aws.iotevents-data/DetectorStateSummary
  (s/keys :opt-un [:cognitect.aws.iotevents-data.DetectorStateSummary/stateName]))

(s/def
  :cognitect.aws.iotevents-data/BatchPutMessageErrorEntries
  (s/coll-of :cognitect.aws.iotevents-data/BatchPutMessageErrorEntry))

(s/def
  :cognitect.aws.iotevents-data/ResetAlarmActionRequests
  (s/coll-of :cognitect.aws.iotevents-data/ResetAlarmActionRequest :min-count 1))

(s/def
  :cognitect.aws.iotevents-data/BatchDeleteDetectorErrorEntry
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchDeleteDetectorErrorEntry/errorMessage
     :cognitect.aws.iotevents-data.BatchDeleteDetectorErrorEntry/errorCode
     :cognitect.aws.iotevents-data.BatchDeleteDetectorErrorEntry/messageId]))

(s/def
  :cognitect.aws.iotevents-data/ComparisonOperator
  (s/spec
    string?
    :gen
    #(s/gen #{"LESS" "LESS_OR_EQUAL" "GREATER" "EQUAL" "GREATER_OR_EQUAL" "NOT_EQUAL"})))

(s/def
  :cognitect.aws.iotevents-data/AcknowledgeAlarmActionRequests
  (s/coll-of :cognitect.aws.iotevents-data/AcknowledgeAlarmActionRequest :min-count 1))

(s/def
  :cognitect.aws.iotevents-data/UpdateDetectorRequests
  (s/coll-of :cognitect.aws.iotevents-data/UpdateDetectorRequest :min-count 1))

(s/def
  :cognitect.aws.iotevents-data/Alarm
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.Alarm/alarmModelVersion
     :cognitect.aws.iotevents-data.Alarm/creationTime
     :cognitect.aws.iotevents-data.Alarm/alarmModelName
     :cognitect.aws.iotevents-data.Alarm/lastUpdateTime
     :cognitect.aws.iotevents-data.Alarm/severity
     :cognitect.aws.iotevents-data.Alarm/keyValue
     :cognitect.aws.iotevents-data.Alarm/alarmState]))

(s/def
  :cognitect.aws.iotevents-data/DeleteDetectorRequests
  (s/coll-of :cognitect.aws.iotevents-data/DeleteDetectorRequest :min-count 1))

(s/def
  :cognitect.aws.iotevents-data/Payload
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.iotevents-data/MessageId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.iotevents-data/NextToken string?)

(s/def
  :cognitect.aws.iotevents-data/StateName
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iotevents-data/BatchAlarmActionErrorEntry
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchAlarmActionErrorEntry/errorMessage
     :cognitect.aws.iotevents-data.BatchAlarmActionErrorEntry/errorCode
     :cognitect.aws.iotevents-data.BatchAlarmActionErrorEntry/requestId]))

(s/def
  :cognitect.aws.iotevents-data/BatchPutMessageRequest
  (s/keys :req-un [:cognitect.aws.iotevents-data.BatchPutMessageRequest/messages]))

(s/def
  :cognitect.aws.iotevents-data/ListDetectorsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.ListDetectorsRequest/detectorModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.ListDetectorsRequest/maxResults
     :cognitect.aws.iotevents-data.ListDetectorsRequest/nextToken
     :cognitect.aws.iotevents-data.ListDetectorsRequest/stateName]))

(s/def
  :cognitect.aws.iotevents-data/DescribeDetectorRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.DescribeDetectorRequest/detectorModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.DescribeDetectorRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/StateChangeConfiguration
  (s/keys :opt-un [:cognitect.aws.iotevents-data.StateChangeConfiguration/triggerType]))

(s/def
  :cognitect.aws.iotevents-data/SnoozeAlarmActionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/requestId
     :cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/alarmModelName
     :cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/snoozeDuration]
    :opt-un
    [:cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/note
     :cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/DetectorState
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.DetectorState/stateName
     :cognitect.aws.iotevents-data.DetectorState/variables
     :cognitect.aws.iotevents-data.DetectorState/timers]))

(s/def
  :cognitect.aws.iotevents-data/SnoozeDuration
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iotevents-data/BatchSnoozeAlarmRequest
  (s/keys :req-un [:cognitect.aws.iotevents-data.BatchSnoozeAlarmRequest/snoozeActionRequests]))

(s/def
  :cognitect.aws.iotevents-data/RequestId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/AlarmModelVersion
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iotevents-data/DetectorModelVersion
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iotevents-data/Timer
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.Timer/name :cognitect.aws.iotevents-data.Timer/timestamp]))

(s/def
  :cognitect.aws.iotevents-data/BatchDisableAlarmRequest
  (s/keys :req-un [:cognitect.aws.iotevents-data.BatchDisableAlarmRequest/disableActionRequests]))

(s/def
  :cognitect.aws.iotevents-data/DetectorSummary
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.DetectorSummary/creationTime
     :cognitect.aws.iotevents-data.DetectorSummary/state
     :cognitect.aws.iotevents-data.DetectorSummary/lastUpdateTime
     :cognitect.aws.iotevents-data.DetectorSummary/detectorModelVersion
     :cognitect.aws.iotevents-data.DetectorSummary/detectorModelName
     :cognitect.aws.iotevents-data.DetectorSummary/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/SnoozeActionConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.SnoozeActionConfiguration/note
     :cognitect.aws.iotevents-data.SnoozeActionConfiguration/snoozeDuration]))

(s/def
  :cognitect.aws.iotevents-data/EphemeralInputName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9][a-zA-Z0-9_.-]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/BatchSnoozeAlarmResponse
  (s/keys :opt-un [:cognitect.aws.iotevents-data.BatchSnoozeAlarmResponse/errorEntries]))

(s/def
  :cognitect.aws.iotevents-data/ListAlarmsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.ListAlarmsRequest/alarmModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.ListAlarmsRequest/maxResults
     :cognitect.aws.iotevents-data.ListAlarmsRequest/nextToken]))

(s/def
  :cognitect.aws.iotevents-data/AcknowledgeAlarmActionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.AcknowledgeAlarmActionRequest/requestId
     :cognitect.aws.iotevents-data.AcknowledgeAlarmActionRequest/alarmModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.AcknowledgeAlarmActionRequest/note
     :cognitect.aws.iotevents-data.AcknowledgeAlarmActionRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/BatchAlarmActionErrorEntries
  (s/coll-of :cognitect.aws.iotevents-data/BatchAlarmActionErrorEntry))

(s/def
  :cognitect.aws.iotevents-data/Variable
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.Variable/name :cognitect.aws.iotevents-data.Variable/value]))

(s/def
  :cognitect.aws.iotevents-data/BatchDeleteDetectorResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchDeleteDetectorResponse/batchDeleteDetectorErrorEntries]))

(s/def
  :cognitect.aws.iotevents-data/TimerDefinitions
  (s/coll-of :cognitect.aws.iotevents-data/TimerDefinition))

(s/def
  :cognitect.aws.iotevents-data/MaxResults
  (s/spec (s/and int? #(<= 1 % 250)) :gen #(gen/choose 1 250)))

(s/def
  :cognitect.aws.iotevents-data/DetectorStateDefinition
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.DetectorStateDefinition/stateName
     :cognitect.aws.iotevents-data.DetectorStateDefinition/variables
     :cognitect.aws.iotevents-data.DetectorStateDefinition/timers]))

(s/def :cognitect.aws.iotevents-data/Variables (s/coll-of :cognitect.aws.iotevents-data/Variable))

(s/def
  :cognitect.aws.iotevents-data/EpochMilliTimestamp
  (s/spec (s/and int? #(<= 1 % 9223372036854775807)) :gen #(gen/choose 1 9223372036854775807)))

(s/def
  :cognitect.aws.iotevents-data/BatchDeleteDetectorErrorEntries
  (s/coll-of :cognitect.aws.iotevents-data/BatchDeleteDetectorErrorEntry))

(s/def :cognitect.aws.iotevents-data/Timestamp inst?)

(s/def
  :cognitect.aws.iotevents-data/DisableAlarmActionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.DisableAlarmActionRequest/requestId
     :cognitect.aws.iotevents-data.DisableAlarmActionRequest/alarmModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.DisableAlarmActionRequest/note
     :cognitect.aws.iotevents-data.DisableAlarmActionRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/DetectorModelName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/BatchUpdateDetectorResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchUpdateDetectorResponse/batchUpdateDetectorErrorEntries]))

(s/def
  :cognitect.aws.iotevents-data/DescribeAlarmResponse
  (s/keys :opt-un [:cognitect.aws.iotevents-data.DescribeAlarmResponse/alarm]))

(s/def
  :cognitect.aws.iotevents-data/BatchUpdateDetectorErrorEntries
  (s/coll-of :cognitect.aws.iotevents-data/BatchUpdateDetectorErrorEntry))

(s/def
  :cognitect.aws.iotevents-data/BatchEnableAlarmResponse
  (s/keys :opt-un [:cognitect.aws.iotevents-data.BatchEnableAlarmResponse/errorEntries]))

(s/def
  :cognitect.aws.iotevents-data/TimerDefinition
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.TimerDefinition/name
     :cognitect.aws.iotevents-data.TimerDefinition/seconds]))

(s/def
  :cognitect.aws.iotevents-data/DeleteDetectorRequest
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.DeleteDetectorRequest/messageId
     :cognitect.aws.iotevents-data.DeleteDetectorRequest/detectorModelName]
    :opt-un
    [:cognitect.aws.iotevents-data.DeleteDetectorRequest/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/InternalFailureException
  (s/keys :opt-un [:cognitect.aws.iotevents-data.InternalFailureException/message]))

(s/def
  :cognitect.aws.iotevents-data/RuleEvaluation
  (s/keys :opt-un [:cognitect.aws.iotevents-data.RuleEvaluation/simpleRuleEvaluation]))

(s/def
  :cognitect.aws.iotevents-data/Seconds
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iotevents-data/AlarmSummaries
  (s/coll-of :cognitect.aws.iotevents-data/AlarmSummary))

(s/def
  :cognitect.aws.iotevents-data/CustomerActionName
  (s/spec string? :gen #(s/gen #{"ACKNOWLEDGE" "DISABLE" "ENABLE" "SNOOZE" "RESET"})))

(s/def
  :cognitect.aws.iotevents-data/SnoozeAlarmActionRequests
  (s/coll-of :cognitect.aws.iotevents-data/SnoozeAlarmActionRequest :min-count 1))

(s/def
  :cognitect.aws.iotevents-data/BatchPutMessageResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.BatchPutMessageResponse/BatchPutMessageErrorEntries]))

(s/def
  :cognitect.aws.iotevents-data/BatchResetAlarmResponse
  (s/keys :opt-un [:cognitect.aws.iotevents-data.BatchResetAlarmResponse/errorEntries]))

(s/def
  :cognitect.aws.iotevents-data/BatchResetAlarmRequest
  (s/keys :req-un [:cognitect.aws.iotevents-data.BatchResetAlarmRequest/resetActionRequests]))

(s/def
  :cognitect.aws.iotevents-data/VariableName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z][a-zA-Z0-9_]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iotevents-data/BatchAcknowledgeAlarmResponse
  (s/keys :opt-un [:cognitect.aws.iotevents-data.BatchAcknowledgeAlarmResponse/errorEntries]))

(s/def
  :cognitect.aws.iotevents-data/VariableDefinition
  (s/keys
    :req-un
    [:cognitect.aws.iotevents-data.VariableDefinition/name
     :cognitect.aws.iotevents-data.VariableDefinition/value]))

(s/def
  :cognitect.aws.iotevents-data/TimerName
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iotevents-data/AlarmSummary
  (s/keys
    :opt-un
    [:cognitect.aws.iotevents-data.AlarmSummary/alarmModelVersion
     :cognitect.aws.iotevents-data.AlarmSummary/creationTime
     :cognitect.aws.iotevents-data.AlarmSummary/alarmModelName
     :cognitect.aws.iotevents-data.AlarmSummary/stateName
     :cognitect.aws.iotevents-data.AlarmSummary/lastUpdateTime
     :cognitect.aws.iotevents-data.AlarmSummary/keyValue]))

(s/def
  :cognitect.aws.iotevents-data/DisableAlarmActionRequests
  (s/coll-of :cognitect.aws.iotevents-data/DisableAlarmActionRequest :min-count 1))

(s/def :cognitect.aws.iotevents-data/Timers (s/coll-of :cognitect.aws.iotevents-data/Timer))

(s/def
  :cognitect.aws.iotevents-data/ResourceNotFoundException
  (s/keys :opt-un [:cognitect.aws.iotevents-data.ResourceNotFoundException/message]))

(s/def
  :cognitect.aws.iotevents-data/ServiceUnavailableException
  (s/keys :opt-un [:cognitect.aws.iotevents-data.ServiceUnavailableException/message]))

(s/def
  :cognitect.aws.iotevents-data/BatchDeleteDetectorRequest
  (s/keys :req-un [:cognitect.aws.iotevents-data.BatchDeleteDetectorRequest/detectors]))

(s/def
  :cognitect.aws.iotevents-data.BatchDisableAlarmResponse/errorEntries
  :cognitect.aws.iotevents-data/BatchAlarmActionErrorEntries)

(s/def
  :cognitect.aws.iotevents-data.ThrottlingException/message
  :cognitect.aws.iotevents-data/errorMessage)

(s/def
  :cognitect.aws.iotevents-data.DescribeDetectorResponse/detector
  :cognitect.aws.iotevents-data/Detector)

(s/def
  :cognitect.aws.iotevents-data.ListAlarmsResponse/alarmSummaries
  :cognitect.aws.iotevents-data/AlarmSummaries)

(s/def
  :cognitect.aws.iotevents-data.ListAlarmsResponse/nextToken
  :cognitect.aws.iotevents-data/NextToken)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/messageId
  :cognitect.aws.iotevents-data/MessageId)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/errorCode
  :cognitect.aws.iotevents-data/ErrorCode)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorErrorEntry/errorMessage
  :cognitect.aws.iotevents-data/ErrorMessage)

(s/def
  :cognitect.aws.iotevents-data.ResetActionConfiguration/note
  :cognitect.aws.iotevents-data/Note)

(s/def
  :cognitect.aws.iotevents-data.DescribeAlarmRequest/alarmModelName
  :cognitect.aws.iotevents-data/AlarmModelName)

(s/def
  :cognitect.aws.iotevents-data.DescribeAlarmRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.AcknowledgeActionConfiguration/note
  :cognitect.aws.iotevents-data/Note)

(s/def
  :cognitect.aws.iotevents-data.DisableActionConfiguration/note
  :cognitect.aws.iotevents-data/Note)

(s/def
  :cognitect.aws.iotevents-data.InvalidRequestException/message
  :cognitect.aws.iotevents-data/errorMessage)

(s/def
  :cognitect.aws.iotevents-data.EnableActionConfiguration/note
  :cognitect.aws.iotevents-data/Note)

(s/def
  :cognitect.aws.iotevents-data.BatchEnableAlarmRequest/enableActionRequests
  :cognitect.aws.iotevents-data/EnableAlarmActionRequests)

(s/def
  :cognitect.aws.iotevents-data.SimpleRuleEvaluation/inputPropertyValue
  :cognitect.aws.iotevents-data/InputPropertyValue)

(s/def
  :cognitect.aws.iotevents-data.SimpleRuleEvaluation/operator
  :cognitect.aws.iotevents-data/ComparisonOperator)

(s/def
  :cognitect.aws.iotevents-data.SimpleRuleEvaluation/thresholdValue
  :cognitect.aws.iotevents-data/ThresholdValue)

(s/def :cognitect.aws.iotevents-data.Message/messageId :cognitect.aws.iotevents-data/MessageId)

(s/def
  :cognitect.aws.iotevents-data.Message/inputName
  :cognitect.aws.iotevents-data/EphemeralInputName)

(s/def :cognitect.aws.iotevents-data.Message/payload :cognitect.aws.iotevents-data/Payload)

(s/def :cognitect.aws.iotevents-data.Message/timestamp :cognitect.aws.iotevents-data/TimestampValue)

(s/def
  :cognitect.aws.iotevents-data.BatchAcknowledgeAlarmRequest/acknowledgeActionRequests
  :cognitect.aws.iotevents-data/AcknowledgeAlarmActionRequests)

(s/def
  :cognitect.aws.iotevents-data.TimestampValue/timeInMillis
  :cognitect.aws.iotevents-data/EpochMilliTimestamp)

(s/def
  :cognitect.aws.iotevents-data.AlarmState/stateName
  :cognitect.aws.iotevents-data/AlarmStateName)

(s/def
  :cognitect.aws.iotevents-data.AlarmState/ruleEvaluation
  :cognitect.aws.iotevents-data/RuleEvaluation)

(s/def
  :cognitect.aws.iotevents-data.AlarmState/customerAction
  :cognitect.aws.iotevents-data/CustomerAction)

(s/def
  :cognitect.aws.iotevents-data.AlarmState/systemEvent
  :cognitect.aws.iotevents-data/SystemEvent)

(s/def
  :cognitect.aws.iotevents-data.UpdateDetectorRequest/messageId
  :cognitect.aws.iotevents-data/MessageId)

(s/def
  :cognitect.aws.iotevents-data.UpdateDetectorRequest/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def
  :cognitect.aws.iotevents-data.UpdateDetectorRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.UpdateDetectorRequest/state
  :cognitect.aws.iotevents-data/DetectorStateDefinition)

(s/def
  :cognitect.aws.iotevents-data.CustomerAction/actionName
  :cognitect.aws.iotevents-data/CustomerActionName)

(s/def
  :cognitect.aws.iotevents-data.CustomerAction/snoozeActionConfiguration
  :cognitect.aws.iotevents-data/SnoozeActionConfiguration)

(s/def
  :cognitect.aws.iotevents-data.CustomerAction/enableActionConfiguration
  :cognitect.aws.iotevents-data/EnableActionConfiguration)

(s/def
  :cognitect.aws.iotevents-data.CustomerAction/disableActionConfiguration
  :cognitect.aws.iotevents-data/DisableActionConfiguration)

(s/def
  :cognitect.aws.iotevents-data.CustomerAction/acknowledgeActionConfiguration
  :cognitect.aws.iotevents-data/AcknowledgeActionConfiguration)

(s/def
  :cognitect.aws.iotevents-data.CustomerAction/resetActionConfiguration
  :cognitect.aws.iotevents-data/ResetActionConfiguration)

(s/def :cognitect.aws.iotevents-data.SystemEvent/eventType :cognitect.aws.iotevents-data/EventType)

(s/def
  :cognitect.aws.iotevents-data.SystemEvent/stateChangeConfiguration
  :cognitect.aws.iotevents-data/StateChangeConfiguration)

(s/def
  :cognitect.aws.iotevents-data.EnableAlarmActionRequest/requestId
  :cognitect.aws.iotevents-data/RequestId)

(s/def
  :cognitect.aws.iotevents-data.EnableAlarmActionRequest/alarmModelName
  :cognitect.aws.iotevents-data/AlarmModelName)

(s/def
  :cognitect.aws.iotevents-data.EnableAlarmActionRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.EnableAlarmActionRequest/note
  :cognitect.aws.iotevents-data/Note)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsResponse/detectorSummaries
  :cognitect.aws.iotevents-data/DetectorSummaries)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsResponse/nextToken
  :cognitect.aws.iotevents-data/NextToken)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorRequest/detectors
  :cognitect.aws.iotevents-data/UpdateDetectorRequests)

(s/def
  :cognitect.aws.iotevents-data.ResetAlarmActionRequest/requestId
  :cognitect.aws.iotevents-data/RequestId)

(s/def
  :cognitect.aws.iotevents-data.ResetAlarmActionRequest/alarmModelName
  :cognitect.aws.iotevents-data/AlarmModelName)

(s/def
  :cognitect.aws.iotevents-data.ResetAlarmActionRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.ResetAlarmActionRequest/note
  :cognitect.aws.iotevents-data/Note)

(s/def
  :cognitect.aws.iotevents-data.Detector/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def :cognitect.aws.iotevents-data.Detector/keyValue :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.Detector/detectorModelVersion
  :cognitect.aws.iotevents-data/DetectorModelVersion)

(s/def :cognitect.aws.iotevents-data.Detector/state :cognitect.aws.iotevents-data/DetectorState)

(s/def :cognitect.aws.iotevents-data.Detector/creationTime :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.Detector/lastUpdateTime
  :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/messageId
  :cognitect.aws.iotevents-data/MessageId)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/errorCode
  :cognitect.aws.iotevents-data/ErrorCode)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageErrorEntry/errorMessage
  :cognitect.aws.iotevents-data/ErrorMessage)

(s/def
  :cognitect.aws.iotevents-data.DetectorStateSummary/stateName
  :cognitect.aws.iotevents-data/StateName)

(s/def
  :cognitect.aws.iotevents-data.BatchDeleteDetectorErrorEntry/messageId
  :cognitect.aws.iotevents-data/MessageId)

(s/def
  :cognitect.aws.iotevents-data.BatchDeleteDetectorErrorEntry/errorCode
  :cognitect.aws.iotevents-data/ErrorCode)

(s/def
  :cognitect.aws.iotevents-data.BatchDeleteDetectorErrorEntry/errorMessage
  :cognitect.aws.iotevents-data/ErrorMessage)

(s/def
  :cognitect.aws.iotevents-data.Alarm/alarmModelName
  :cognitect.aws.iotevents-data/AlarmModelName)

(s/def
  :cognitect.aws.iotevents-data.Alarm/alarmModelVersion
  :cognitect.aws.iotevents-data/AlarmModelVersion)

(s/def :cognitect.aws.iotevents-data.Alarm/keyValue :cognitect.aws.iotevents-data/KeyValue)

(s/def :cognitect.aws.iotevents-data.Alarm/alarmState :cognitect.aws.iotevents-data/AlarmState)

(s/def :cognitect.aws.iotevents-data.Alarm/severity :cognitect.aws.iotevents-data/Severity)

(s/def :cognitect.aws.iotevents-data.Alarm/creationTime :cognitect.aws.iotevents-data/Timestamp)

(s/def :cognitect.aws.iotevents-data.Alarm/lastUpdateTime :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.BatchAlarmActionErrorEntry/requestId
  :cognitect.aws.iotevents-data/RequestId)

(s/def
  :cognitect.aws.iotevents-data.BatchAlarmActionErrorEntry/errorCode
  :cognitect.aws.iotevents-data/ErrorCode)

(s/def
  :cognitect.aws.iotevents-data.BatchAlarmActionErrorEntry/errorMessage
  :cognitect.aws.iotevents-data/ErrorMessage)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageRequest/messages
  :cognitect.aws.iotevents-data/Messages)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsRequest/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsRequest/stateName
  :cognitect.aws.iotevents-data/StateName)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsRequest/nextToken
  :cognitect.aws.iotevents-data/NextToken)

(s/def
  :cognitect.aws.iotevents-data.ListDetectorsRequest/maxResults
  :cognitect.aws.iotevents-data/MaxResults)

(s/def
  :cognitect.aws.iotevents-data.DescribeDetectorRequest/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def
  :cognitect.aws.iotevents-data.DescribeDetectorRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.StateChangeConfiguration/triggerType
  :cognitect.aws.iotevents-data/TriggerType)

(s/def
  :cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/requestId
  :cognitect.aws.iotevents-data/RequestId)

(s/def
  :cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/alarmModelName
  :cognitect.aws.iotevents-data/AlarmModelName)

(s/def
  :cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/note
  :cognitect.aws.iotevents-data/Note)

(s/def
  :cognitect.aws.iotevents-data.SnoozeAlarmActionRequest/snoozeDuration
  :cognitect.aws.iotevents-data/SnoozeDuration)

(s/def
  :cognitect.aws.iotevents-data.DetectorState/stateName
  :cognitect.aws.iotevents-data/StateName)

(s/def
  :cognitect.aws.iotevents-data.DetectorState/variables
  :cognitect.aws.iotevents-data/Variables)

(s/def :cognitect.aws.iotevents-data.DetectorState/timers :cognitect.aws.iotevents-data/Timers)

(s/def
  :cognitect.aws.iotevents-data.BatchSnoozeAlarmRequest/snoozeActionRequests
  :cognitect.aws.iotevents-data/SnoozeAlarmActionRequests)

(s/def :cognitect.aws.iotevents-data.Timer/name :cognitect.aws.iotevents-data/TimerName)

(s/def :cognitect.aws.iotevents-data.Timer/timestamp :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.BatchDisableAlarmRequest/disableActionRequests
  :cognitect.aws.iotevents-data/DisableAlarmActionRequests)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/detectorModelVersion
  :cognitect.aws.iotevents-data/DetectorModelVersion)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/state
  :cognitect.aws.iotevents-data/DetectorStateSummary)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/creationTime
  :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.DetectorSummary/lastUpdateTime
  :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.SnoozeActionConfiguration/snoozeDuration
  :cognitect.aws.iotevents-data/SnoozeDuration)

(s/def
  :cognitect.aws.iotevents-data.SnoozeActionConfiguration/note
  :cognitect.aws.iotevents-data/Note)

(s/def
  :cognitect.aws.iotevents-data.BatchSnoozeAlarmResponse/errorEntries
  :cognitect.aws.iotevents-data/BatchAlarmActionErrorEntries)

(s/def
  :cognitect.aws.iotevents-data.ListAlarmsRequest/alarmModelName
  :cognitect.aws.iotevents-data/AlarmModelName)

(s/def
  :cognitect.aws.iotevents-data.ListAlarmsRequest/nextToken
  :cognitect.aws.iotevents-data/NextToken)

(s/def
  :cognitect.aws.iotevents-data.ListAlarmsRequest/maxResults
  :cognitect.aws.iotevents-data/MaxResults)

(s/def
  :cognitect.aws.iotevents-data.AcknowledgeAlarmActionRequest/requestId
  :cognitect.aws.iotevents-data/RequestId)

(s/def
  :cognitect.aws.iotevents-data.AcknowledgeAlarmActionRequest/alarmModelName
  :cognitect.aws.iotevents-data/AlarmModelName)

(s/def
  :cognitect.aws.iotevents-data.AcknowledgeAlarmActionRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.AcknowledgeAlarmActionRequest/note
  :cognitect.aws.iotevents-data/Note)

(s/def :cognitect.aws.iotevents-data.Variable/name :cognitect.aws.iotevents-data/VariableName)

(s/def :cognitect.aws.iotevents-data.Variable/value :cognitect.aws.iotevents-data/VariableValue)

(s/def
  :cognitect.aws.iotevents-data.BatchDeleteDetectorResponse/batchDeleteDetectorErrorEntries
  :cognitect.aws.iotevents-data/BatchDeleteDetectorErrorEntries)

(s/def
  :cognitect.aws.iotevents-data.DetectorStateDefinition/stateName
  :cognitect.aws.iotevents-data/StateName)

(s/def
  :cognitect.aws.iotevents-data.DetectorStateDefinition/variables
  :cognitect.aws.iotevents-data/VariableDefinitions)

(s/def
  :cognitect.aws.iotevents-data.DetectorStateDefinition/timers
  :cognitect.aws.iotevents-data/TimerDefinitions)

(s/def
  :cognitect.aws.iotevents-data.DisableAlarmActionRequest/requestId
  :cognitect.aws.iotevents-data/RequestId)

(s/def
  :cognitect.aws.iotevents-data.DisableAlarmActionRequest/alarmModelName
  :cognitect.aws.iotevents-data/AlarmModelName)

(s/def
  :cognitect.aws.iotevents-data.DisableAlarmActionRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.DisableAlarmActionRequest/note
  :cognitect.aws.iotevents-data/Note)

(s/def
  :cognitect.aws.iotevents-data.BatchUpdateDetectorResponse/batchUpdateDetectorErrorEntries
  :cognitect.aws.iotevents-data/BatchUpdateDetectorErrorEntries)

(s/def
  :cognitect.aws.iotevents-data.DescribeAlarmResponse/alarm
  :cognitect.aws.iotevents-data/Alarm)

(s/def
  :cognitect.aws.iotevents-data.BatchEnableAlarmResponse/errorEntries
  :cognitect.aws.iotevents-data/BatchAlarmActionErrorEntries)

(s/def :cognitect.aws.iotevents-data.TimerDefinition/name :cognitect.aws.iotevents-data/TimerName)

(s/def :cognitect.aws.iotevents-data.TimerDefinition/seconds :cognitect.aws.iotevents-data/Seconds)

(s/def
  :cognitect.aws.iotevents-data.DeleteDetectorRequest/messageId
  :cognitect.aws.iotevents-data/MessageId)

(s/def
  :cognitect.aws.iotevents-data.DeleteDetectorRequest/detectorModelName
  :cognitect.aws.iotevents-data/DetectorModelName)

(s/def
  :cognitect.aws.iotevents-data.DeleteDetectorRequest/keyValue
  :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.InternalFailureException/message
  :cognitect.aws.iotevents-data/errorMessage)

(s/def
  :cognitect.aws.iotevents-data.RuleEvaluation/simpleRuleEvaluation
  :cognitect.aws.iotevents-data/SimpleRuleEvaluation)

(s/def
  :cognitect.aws.iotevents-data.BatchPutMessageResponse/BatchPutMessageErrorEntries
  :cognitect.aws.iotevents-data/BatchPutMessageErrorEntries)

(s/def
  :cognitect.aws.iotevents-data.BatchResetAlarmResponse/errorEntries
  :cognitect.aws.iotevents-data/BatchAlarmActionErrorEntries)

(s/def
  :cognitect.aws.iotevents-data.BatchResetAlarmRequest/resetActionRequests
  :cognitect.aws.iotevents-data/ResetAlarmActionRequests)

(s/def
  :cognitect.aws.iotevents-data.BatchAcknowledgeAlarmResponse/errorEntries
  :cognitect.aws.iotevents-data/BatchAlarmActionErrorEntries)

(s/def
  :cognitect.aws.iotevents-data.VariableDefinition/name
  :cognitect.aws.iotevents-data/VariableName)

(s/def
  :cognitect.aws.iotevents-data.VariableDefinition/value
  :cognitect.aws.iotevents-data/VariableValue)

(s/def
  :cognitect.aws.iotevents-data.AlarmSummary/alarmModelName
  :cognitect.aws.iotevents-data/AlarmModelName)

(s/def
  :cognitect.aws.iotevents-data.AlarmSummary/alarmModelVersion
  :cognitect.aws.iotevents-data/AlarmModelVersion)

(s/def :cognitect.aws.iotevents-data.AlarmSummary/keyValue :cognitect.aws.iotevents-data/KeyValue)

(s/def
  :cognitect.aws.iotevents-data.AlarmSummary/stateName
  :cognitect.aws.iotevents-data/AlarmStateName)

(s/def
  :cognitect.aws.iotevents-data.AlarmSummary/creationTime
  :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.AlarmSummary/lastUpdateTime
  :cognitect.aws.iotevents-data/Timestamp)

(s/def
  :cognitect.aws.iotevents-data.ResourceNotFoundException/message
  :cognitect.aws.iotevents-data/errorMessage)

(s/def
  :cognitect.aws.iotevents-data.ServiceUnavailableException/message
  :cognitect.aws.iotevents-data/errorMessage)

(s/def
  :cognitect.aws.iotevents-data.BatchDeleteDetectorRequest/detectors
  :cognitect.aws.iotevents-data/DeleteDetectorRequests)

