;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.kendra-ranking.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.kendra-ranking/ThrottlingException
  (s/keys :opt-un [:cognitect.aws.kendra-ranking.ThrottlingException/Message]))

(s/def
  :cognitect.aws.kendra-ranking/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.kendra-ranking.TagResourceRequest/ResourceARN
     :cognitect.aws.kendra-ranking.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.kendra-ranking/ServiceQuotaExceededException
  (s/keys :opt-un [:cognitect.aws.kendra-ranking.ServiceQuotaExceededException/Message]))

(s/def
  :cognitect.aws.kendra-ranking/InternalServerException
  (s/keys :opt-un [:cognitect.aws.kendra-ranking.InternalServerException/Message]))

(s/def
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanSummaryList
  (s/coll-of :cognitect.aws.kendra-ranking/RescoreExecutionPlanSummary))

(s/def
  :cognitect.aws.kendra-ranking/RescoreResult
  (s/keys
    :opt-un
    [:cognitect.aws.kendra-ranking.RescoreResult/ResultItems
     :cognitect.aws.kendra-ranking.RescoreResult/RescoreId]))

(s/def
  :cognitect.aws.kendra-ranking/Tag
  (s/keys :req-un [:cognitect.aws.kendra-ranking.Tag/Key :cognitect.aws.kendra-ranking.Tag/Value]))

(s/def
  :cognitect.aws.kendra-ranking/DeleteRescoreExecutionPlanRequest
  (s/keys :req-un [:cognitect.aws.kendra-ranking.DeleteRescoreExecutionPlanRequest/Id]))

(s/def :cognitect.aws.kendra-ranking/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.kendra-ranking/TitleTokensList
  (s/coll-of :cognitect.aws.kendra-ranking/Tokens :min-count 1))

(s/def
  :cognitect.aws.kendra-ranking/ValidationException
  (s/keys :opt-un [:cognitect.aws.kendra-ranking.ValidationException/Message]))

(s/def
  :cognitect.aws.kendra-ranking/AccessDeniedException
  (s/keys :opt-un [:cognitect.aws.kendra-ranking.AccessDeniedException/Message]))

(s/def
  :cognitect.aws.kendra-ranking/ErrorMessage
  (s/spec #(re-matches (re-pattern "^\\P{C}*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.kendra-ranking/TagList
  (s/coll-of :cognitect.aws.kendra-ranking/Tag :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.kendra-ranking/RescoreResultItemList
  (s/coll-of :cognitect.aws.kendra-ranking/RescoreResultItem :min-count 1))

(s/def
  :cognitect.aws.kendra-ranking/CapacityUnitsConfiguration
  (s/keys :req-un [:cognitect.aws.kendra-ranking.CapacityUnitsConfiguration/RescoreCapacityUnits]))

(s/def
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.kendra-ranking/RescoreRequest
  (s/keys
    :req-un
    [:cognitect.aws.kendra-ranking.RescoreRequest/RescoreExecutionPlanId
     :cognitect.aws.kendra-ranking.RescoreRequest/SearchQuery
     :cognitect.aws.kendra-ranking.RescoreRequest/Documents]))

(s/def
  :cognitect.aws.kendra-ranking/AmazonResourceName
  (s/spec
    (s/and string? #(<= 1 (count %) 1011))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1011) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.kendra-ranking/CreateRescoreExecutionPlanResponse
  (s/keys
    :req-un
    [:cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanResponse/Id
     :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanResponse/Arn]))

(s/def
  :cognitect.aws.kendra-ranking/NextToken
  (s/spec #(re-matches (re-pattern "^\\P{C}*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.kendra-ranking/ListRescoreExecutionPlansResponse
  (s/keys
    :opt-un
    [:cognitect.aws.kendra-ranking.ListRescoreExecutionPlansResponse/SummaryItems
     :cognitect.aws.kendra-ranking.ListRescoreExecutionPlansResponse/NextToken]))

(s/def
  :cognitect.aws.kendra-ranking/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.kendra-ranking/RescoreCapacityUnit
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.kendra-ranking/MaxResultsIntegerForListRescoreExecutionPlansRequest
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.kendra-ranking/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.kendra-ranking.ListTagsForResourceRequest/ResourceARN]))

(s/def
  :cognitect.aws.kendra-ranking/BodyTokensList
  (s/coll-of :cognitect.aws.kendra-ranking/Tokens :min-count 1))

(s/def :cognitect.aws.kendra-ranking/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.kendra-ranking/CreateRescoreExecutionPlanRequest
  (s/keys
    :req-un
    [:cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/Name]
    :opt-un
    [:cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/Tags
     :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/Description
     :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/CapacityUnits
     :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/ClientToken]))

(s/def
  :cognitect.aws.kendra-ranking/DescribeRescoreExecutionPlanResponse
  (s/keys
    :opt-un
    [:cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Status
     :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/ErrorMessage
     :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Description
     :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Arn
     :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/CreatedAt
     :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/UpdatedAt
     :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Name
     :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/CapacityUnits
     :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Id]))

(s/def
  :cognitect.aws.kendra-ranking/ClientTokenName
  (s/spec #(re-matches (re-pattern "^$|[\\x00-\\x7F]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.kendra-ranking/DescribeRescoreExecutionPlanRequest
  (s/keys :req-un [:cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanRequest/Id]))

(s/def
  :cognitect.aws.kendra-ranking/UpdateRescoreExecutionPlanRequest
  (s/keys
    :req-un
    [:cognitect.aws.kendra-ranking.UpdateRescoreExecutionPlanRequest/Id]
    :opt-un
    [:cognitect.aws.kendra-ranking.UpdateRescoreExecutionPlanRequest/Description
     :cognitect.aws.kendra-ranking.UpdateRescoreExecutionPlanRequest/Name
     :cognitect.aws.kendra-ranking.UpdateRescoreExecutionPlanRequest/CapacityUnits]))

(s/def
  :cognitect.aws.kendra-ranking/Float
  (s/spec
    (s/and double? #(<= -100000 % 100000))
    :gen
    #(gen/double* {:infinite? false, :NaN? false, :min -100000, :max 100000})))

(s/def
  :cognitect.aws.kendra-ranking/GroupId
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.kendra-ranking/DocumentId
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.kendra-ranking/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.kendra-ranking.UntagResourceRequest/ResourceARN
     :cognitect.aws.kendra-ranking.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.kendra-ranking/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.kendra-ranking/Description
  (s/spec #(re-matches (re-pattern "^\\P{C}*$") %) :gen #(gen/string)))

(s/def :cognitect.aws.kendra-ranking/Timestamp inst?)

(s/def
  :cognitect.aws.kendra-ranking/Tokens
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.kendra-ranking/ListRescoreExecutionPlansRequest
  (s/keys
    :opt-un
    [:cognitect.aws.kendra-ranking.ListRescoreExecutionPlansRequest/NextToken
     :cognitect.aws.kendra-ranking.ListRescoreExecutionPlansRequest/MaxResults]))

(s/def
  :cognitect.aws.kendra-ranking/ResourceUnavailableException
  (s/keys :opt-un [:cognitect.aws.kendra-ranking.ResourceUnavailableException/Message]))

(s/def
  :cognitect.aws.kendra-ranking/DocumentTitle
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanStatus
  (s/spec string? :gen #(s/gen #{"UPDATING" "DELETING" "CREATING" "ACTIVE" "FAILED"})))

(s/def
  :cognitect.aws.kendra-ranking/DocumentBody
  (s/spec #(re-matches (re-pattern "^\\P{C}*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.kendra-ranking/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.kendra-ranking.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanSummary
  (s/keys
    :opt-un
    [:cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/Status
     :cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/CreatedAt
     :cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/UpdatedAt
     :cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/Name
     :cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/Id]))

(s/def
  :cognitect.aws.kendra-ranking/RescoreId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.kendra-ranking/Document
  (s/keys
    :req-un
    [:cognitect.aws.kendra-ranking.Document/Id
     :cognitect.aws.kendra-ranking.Document/OriginalScore]
    :opt-un
    [:cognitect.aws.kendra-ranking.Document/Body
     :cognitect.aws.kendra-ranking.Document/Title
     :cognitect.aws.kendra-ranking.Document/GroupId
     :cognitect.aws.kendra-ranking.Document/TokenizedBody
     :cognitect.aws.kendra-ranking.Document/TokenizedTitle]))

(s/def
  :cognitect.aws.kendra-ranking/SearchQuery
  (s/spec
    (s/and string? #(<= 1 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.kendra-ranking/RescoreResultItem
  (s/keys
    :opt-un
    [:cognitect.aws.kendra-ranking.RescoreResultItem/DocumentId
     :cognitect.aws.kendra-ranking.RescoreResultItem/Score]))

(s/def
  :cognitect.aws.kendra-ranking/ResourceNotFoundException
  (s/keys :opt-un [:cognitect.aws.kendra-ranking.ResourceNotFoundException/Message]))

(s/def
  :cognitect.aws.kendra-ranking/ConflictException
  (s/keys :opt-un [:cognitect.aws.kendra-ranking.ConflictException/Message]))

(s/def
  :cognitect.aws.kendra-ranking/DocumentList
  (s/coll-of :cognitect.aws.kendra-ranking/Document :min-count 1))

(s/def
  :cognitect.aws.kendra-ranking/TagKeyList
  (s/coll-of :cognitect.aws.kendra-ranking/TagKey :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.kendra-ranking.ThrottlingException/Message
  :cognitect.aws.kendra-ranking/ErrorMessage)

(s/def
  :cognitect.aws.kendra-ranking.TagResourceRequest/ResourceARN
  :cognitect.aws.kendra-ranking/AmazonResourceName)

(s/def :cognitect.aws.kendra-ranking.TagResourceRequest/Tags :cognitect.aws.kendra-ranking/TagList)

(s/def
  :cognitect.aws.kendra-ranking.ServiceQuotaExceededException/Message
  :cognitect.aws.kendra-ranking/ErrorMessage)

(s/def
  :cognitect.aws.kendra-ranking.InternalServerException/Message
  :cognitect.aws.kendra-ranking/ErrorMessage)

(s/def
  :cognitect.aws.kendra-ranking.RescoreResult/RescoreId
  :cognitect.aws.kendra-ranking/RescoreId)

(s/def
  :cognitect.aws.kendra-ranking.RescoreResult/ResultItems
  :cognitect.aws.kendra-ranking/RescoreResultItemList)

(s/def :cognitect.aws.kendra-ranking.Tag/Key :cognitect.aws.kendra-ranking/TagKey)

(s/def :cognitect.aws.kendra-ranking.Tag/Value :cognitect.aws.kendra-ranking/TagValue)

(s/def
  :cognitect.aws.kendra-ranking.DeleteRescoreExecutionPlanRequest/Id
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanId)

(s/def
  :cognitect.aws.kendra-ranking.ValidationException/Message
  :cognitect.aws.kendra-ranking/ErrorMessage)

(s/def
  :cognitect.aws.kendra-ranking.AccessDeniedException/Message
  :cognitect.aws.kendra-ranking/ErrorMessage)

(s/def
  :cognitect.aws.kendra-ranking.CapacityUnitsConfiguration/RescoreCapacityUnits
  :cognitect.aws.kendra-ranking/RescoreCapacityUnit)

(s/def
  :cognitect.aws.kendra-ranking.RescoreRequest/RescoreExecutionPlanId
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanId)

(s/def
  :cognitect.aws.kendra-ranking.RescoreRequest/SearchQuery
  :cognitect.aws.kendra-ranking/SearchQuery)

(s/def
  :cognitect.aws.kendra-ranking.RescoreRequest/Documents
  :cognitect.aws.kendra-ranking/DocumentList)

(s/def
  :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanResponse/Id
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanId)

(s/def
  :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanResponse/Arn
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanArn)

(s/def
  :cognitect.aws.kendra-ranking.ListRescoreExecutionPlansResponse/SummaryItems
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanSummaryList)

(s/def
  :cognitect.aws.kendra-ranking.ListRescoreExecutionPlansResponse/NextToken
  :cognitect.aws.kendra-ranking/NextToken)

(s/def
  :cognitect.aws.kendra-ranking.ListTagsForResourceRequest/ResourceARN
  :cognitect.aws.kendra-ranking/AmazonResourceName)

(s/def
  :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/Name
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanName)

(s/def
  :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/Description
  :cognitect.aws.kendra-ranking/Description)

(s/def
  :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/CapacityUnits
  :cognitect.aws.kendra-ranking/CapacityUnitsConfiguration)

(s/def
  :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/Tags
  :cognitect.aws.kendra-ranking/TagList)

(s/def
  :cognitect.aws.kendra-ranking.CreateRescoreExecutionPlanRequest/ClientToken
  :cognitect.aws.kendra-ranking/ClientTokenName)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/CreatedAt
  :cognitect.aws.kendra-ranking/Timestamp)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/UpdatedAt
  :cognitect.aws.kendra-ranking/Timestamp)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/ErrorMessage
  :cognitect.aws.kendra-ranking/ErrorMessage)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Id
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanId)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Arn
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanArn)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/CapacityUnits
  :cognitect.aws.kendra-ranking/CapacityUnitsConfiguration)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Name
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanName)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Description
  :cognitect.aws.kendra-ranking/Description)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanResponse/Status
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanStatus)

(s/def
  :cognitect.aws.kendra-ranking.DescribeRescoreExecutionPlanRequest/Id
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanId)

(s/def
  :cognitect.aws.kendra-ranking.UpdateRescoreExecutionPlanRequest/Id
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanId)

(s/def
  :cognitect.aws.kendra-ranking.UpdateRescoreExecutionPlanRequest/Name
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanName)

(s/def
  :cognitect.aws.kendra-ranking.UpdateRescoreExecutionPlanRequest/Description
  :cognitect.aws.kendra-ranking/Description)

(s/def
  :cognitect.aws.kendra-ranking.UpdateRescoreExecutionPlanRequest/CapacityUnits
  :cognitect.aws.kendra-ranking/CapacityUnitsConfiguration)

(s/def
  :cognitect.aws.kendra-ranking.UntagResourceRequest/ResourceARN
  :cognitect.aws.kendra-ranking/AmazonResourceName)

(s/def
  :cognitect.aws.kendra-ranking.UntagResourceRequest/TagKeys
  :cognitect.aws.kendra-ranking/TagKeyList)

(s/def
  :cognitect.aws.kendra-ranking.ListRescoreExecutionPlansRequest/NextToken
  :cognitect.aws.kendra-ranking/NextToken)

(s/def
  :cognitect.aws.kendra-ranking.ListRescoreExecutionPlansRequest/MaxResults
  :cognitect.aws.kendra-ranking/MaxResultsIntegerForListRescoreExecutionPlansRequest)

(s/def
  :cognitect.aws.kendra-ranking.ResourceUnavailableException/Message
  :cognitect.aws.kendra-ranking/ErrorMessage)

(s/def
  :cognitect.aws.kendra-ranking.ListTagsForResourceResponse/Tags
  :cognitect.aws.kendra-ranking/TagList)

(s/def
  :cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/Name
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanName)

(s/def
  :cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/Id
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanId)

(s/def
  :cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/CreatedAt
  :cognitect.aws.kendra-ranking/Timestamp)

(s/def
  :cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/UpdatedAt
  :cognitect.aws.kendra-ranking/Timestamp)

(s/def
  :cognitect.aws.kendra-ranking.RescoreExecutionPlanSummary/Status
  :cognitect.aws.kendra-ranking/RescoreExecutionPlanStatus)

(s/def :cognitect.aws.kendra-ranking.Document/Id :cognitect.aws.kendra-ranking/DocumentId)

(s/def :cognitect.aws.kendra-ranking.Document/GroupId :cognitect.aws.kendra-ranking/GroupId)

(s/def :cognitect.aws.kendra-ranking.Document/Title :cognitect.aws.kendra-ranking/DocumentTitle)

(s/def :cognitect.aws.kendra-ranking.Document/Body :cognitect.aws.kendra-ranking/DocumentBody)

(s/def
  :cognitect.aws.kendra-ranking.Document/TokenizedTitle
  :cognitect.aws.kendra-ranking/TitleTokensList)

(s/def
  :cognitect.aws.kendra-ranking.Document/TokenizedBody
  :cognitect.aws.kendra-ranking/BodyTokensList)

(s/def :cognitect.aws.kendra-ranking.Document/OriginalScore :cognitect.aws.kendra-ranking/Float)

(s/def
  :cognitect.aws.kendra-ranking.RescoreResultItem/DocumentId
  :cognitect.aws.kendra-ranking/DocumentId)

(s/def :cognitect.aws.kendra-ranking.RescoreResultItem/Score :cognitect.aws.kendra-ranking/Float)

(s/def
  :cognitect.aws.kendra-ranking.ResourceNotFoundException/Message
  :cognitect.aws.kendra-ranking/ErrorMessage)

(s/def
  :cognitect.aws.kendra-ranking.ConflictException/Message
  :cognitect.aws.kendra-ranking/ErrorMessage)

