;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.lakeformation.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntry
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Id]
    :opt-un
    [:cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Permissions
     :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/PermissionsWithGrantOption
     :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Resource
     :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Principal]))

(s/def
  :cognitect.aws.lakeformation/BatchGrantPermissionsResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.BatchGrantPermissionsResponse/Failures]))

(s/def
  :cognitect.aws.lakeformation/DataLakePrincipal
  (s/keys :opt-un [:cognitect.aws.lakeformation.DataLakePrincipal/DataLakePrincipalIdentifier]))

(s/def
  :cognitect.aws.lakeformation/ColumnWildcard
  (s/keys :opt-un [:cognitect.aws.lakeformation.ColumnWildcard/ExcludedColumnNames]))

(s/def
  :cognitect.aws.lakeformation/TableResource
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.TableResource/DatabaseName
     :cognitect.aws.lakeformation.TableResource/Name]))

(s/def :cognitect.aws.lakeformation/UpdateResourceResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/GrantPermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GrantPermissionsRequest/Principal
     :cognitect.aws.lakeformation.GrantPermissionsRequest/Resource
     :cognitect.aws.lakeformation.GrantPermissionsRequest/Permissions]
    :opt-un
    [:cognitect.aws.lakeformation.GrantPermissionsRequest/PermissionsWithGrantOption
     :cognitect.aws.lakeformation.GrantPermissionsRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/DataLakeSettings
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.DataLakeSettings/DataLakeAdmins
     :cognitect.aws.lakeformation.DataLakeSettings/CreateDatabaseDefaultPermissions
     :cognitect.aws.lakeformation.DataLakeSettings/CreateTableDefaultPermissions]))

(s/def
  :cognitect.aws.lakeformation/GetDataLakeSettingsRequest
  (s/keys :opt-un [:cognitect.aws.lakeformation.GetDataLakeSettingsRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/ErrorDetail
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ErrorDetail/ErrorMessage
     :cognitect.aws.lakeformation.ErrorDetail/ErrorCode]))

(s/def
  :cognitect.aws.lakeformation/DataLakePrincipalList
  (s/coll-of :cognitect.aws.lakeformation/DataLakePrincipal :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.lakeformation/ListPermissionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListPermissionsRequest/NextToken
     :cognitect.aws.lakeformation.ListPermissionsRequest/ResourceType
     :cognitect.aws.lakeformation.ListPermissionsRequest/CatalogId
     :cognitect.aws.lakeformation.ListPermissionsRequest/MaxResults
     :cognitect.aws.lakeformation.ListPermissionsRequest/Resource
     :cognitect.aws.lakeformation.ListPermissionsRequest/Principal]))

(s/def :cognitect.aws.lakeformation/PutDataLakeSettingsResponse (s/keys))

(s/def :cognitect.aws.lakeformation/Permission string?)

(s/def :cognitect.aws.lakeformation/Token string?)

(s/def
  :cognitect.aws.lakeformation/ResourceInfo
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ResourceInfo/RoleArn
     :cognitect.aws.lakeformation.ResourceInfo/LastModified
     :cognitect.aws.lakeformation.ResourceInfo/ResourceArn]))

(s/def
  :cognitect.aws.lakeformation/PutDataLakeSettingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.PutDataLakeSettingsRequest/DataLakeSettings]
    :opt-un
    [:cognitect.aws.lakeformation.PutDataLakeSettingsRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/ListResourcesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListResourcesResponse/NextToken
     :cognitect.aws.lakeformation.ListResourcesResponse/ResourceInfoList]))

(s/def :cognitect.aws.lakeformation/GrantPermissionsResponse (s/keys))

(s/def :cognitect.aws.lakeformation/StringValue string?)

(s/def
  :cognitect.aws.lakeformation/NameString
  (s/with-gen
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\t]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/GetDataLakeSettingsResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.GetDataLakeSettingsResponse/DataLakeSettings]))

(s/def :cognitect.aws.lakeformation/ComparisonOperator string?)

(s/def :cognitect.aws.lakeformation/NullableBoolean boolean?)

(s/def
  :cognitect.aws.lakeformation/DescriptionString
  (s/with-gen
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\r\\n\\t]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/BatchGrantPermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.BatchGrantPermissionsRequest/Entries]
    :opt-un
    [:cognitect.aws.lakeformation.BatchGrantPermissionsRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/Identifier
  (s/with-gen
    (s/and string? #(<= 1 (count %) 255))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 255 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/ListPermissionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListPermissionsResponse/NextToken
     :cognitect.aws.lakeformation.ListPermissionsResponse/PrincipalResourcePermissions]))

(s/def
  :cognitect.aws.lakeformation/BatchRevokePermissionsResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.BatchRevokePermissionsResponse/Failures]))

(s/def
  :cognitect.aws.lakeformation/StringValueList
  (s/coll-of :cognitect.aws.lakeformation/StringValue))

(s/def :cognitect.aws.lakeformation/RevokePermissionsResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/GetEffectivePermissionsForPathRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/ResourceArn]
    :opt-un
    [:cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/NextToken
     :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/CatalogId
     :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/MaxResults]))

(s/def :cognitect.aws.lakeformation/FieldNameString string?)

(s/def
  :cognitect.aws.lakeformation/PermissionList
  (s/coll-of :cognitect.aws.lakeformation/Permission))

(s/def :cognitect.aws.lakeformation/DeregisterResourceResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/PrincipalPermissionsList
  (s/coll-of :cognitect.aws.lakeformation/PrincipalPermissions))

(s/def :cognitect.aws.lakeformation/CatalogResource (s/keys))

(s/def
  :cognitect.aws.lakeformation/BatchPermissionsFailureList
  (s/coll-of :cognitect.aws.lakeformation/BatchPermissionsFailureEntry))

(s/def
  :cognitect.aws.lakeformation/BatchRevokePermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.BatchRevokePermissionsRequest/Entries]
    :opt-un
    [:cognitect.aws.lakeformation.BatchRevokePermissionsRequest/CatalogId]))

(s/def :cognitect.aws.lakeformation/ColumnNames (s/coll-of :cognitect.aws.lakeformation/NameString))

(s/def
  :cognitect.aws.lakeformation/BatchPermissionsFailureEntry
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.BatchPermissionsFailureEntry/RequestEntry
     :cognitect.aws.lakeformation.BatchPermissionsFailureEntry/Error]))

(s/def :cognitect.aws.lakeformation/ResourceArnString string?)

(s/def
  :cognitect.aws.lakeformation/GetEffectivePermissionsForPathResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.GetEffectivePermissionsForPathResponse/Permissions
     :cognitect.aws.lakeformation.GetEffectivePermissionsForPathResponse/NextToken]))

(s/def
  :cognitect.aws.lakeformation/FilterConditionList
  (s/coll-of :cognitect.aws.lakeformation/FilterCondition :min-count 1 :max-count 20))

(s/def
  :cognitect.aws.lakeformation/PrincipalPermissions
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.PrincipalPermissions/Permissions
     :cognitect.aws.lakeformation.PrincipalPermissions/Principal]))

(s/def :cognitect.aws.lakeformation/DataLakeResourceType string?)

(s/def
  :cognitect.aws.lakeformation/PageSize
  (s/with-gen
    (s/and int? #(<= 1 % 1000))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 1000 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntryList
  (s/coll-of :cognitect.aws.lakeformation/BatchPermissionsRequestEntry))

(s/def
  :cognitect.aws.lakeformation/DeregisterResourceRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.DeregisterResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.lakeformation/Resource
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.Resource/DataLocation
     :cognitect.aws.lakeformation.Resource/TableWithColumns
     :cognitect.aws.lakeformation.Resource/Catalog
     :cognitect.aws.lakeformation.Resource/Table
     :cognitect.aws.lakeformation.Resource/Database]))

(s/def
  :cognitect.aws.lakeformation/ResourceInfoList
  (s/coll-of :cognitect.aws.lakeformation/ResourceInfo))

(s/def
  :cognitect.aws.lakeformation/RegisterResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.RegisterResourceRequest/ResourceArn]
    :opt-un
    [:cognitect.aws.lakeformation.RegisterResourceRequest/UseServiceLinkedRole
     :cognitect.aws.lakeformation.RegisterResourceRequest/RoleArn]))

(s/def :cognitect.aws.lakeformation/RegisterResourceResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/CatalogIdString
  (s/with-gen
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\t]*")
      %)
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/DatabaseResource
  (s/keys :req-un [:cognitect.aws.lakeformation.DatabaseResource/Name]))

(s/def
  :cognitect.aws.lakeformation/UpdateResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.UpdateResourceRequest/RoleArn
     :cognitect.aws.lakeformation.UpdateResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.lakeformation/PrincipalResourcePermissions
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.PrincipalResourcePermissions/Permissions
     :cognitect.aws.lakeformation.PrincipalResourcePermissions/PermissionsWithGrantOption
     :cognitect.aws.lakeformation.PrincipalResourcePermissions/Resource
     :cognitect.aws.lakeformation.PrincipalResourcePermissions/Principal]))

(s/def
  :cognitect.aws.lakeformation/FilterCondition
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.FilterCondition/ComparisonOperator
     :cognitect.aws.lakeformation.FilterCondition/StringValueList
     :cognitect.aws.lakeformation.FilterCondition/Field]))

(s/def
  :cognitect.aws.lakeformation/DescribeResourceResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.DescribeResourceResponse/ResourceInfo]))

(s/def
  :cognitect.aws.lakeformation/DescribeResourceRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.DescribeResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.lakeformation/TableWithColumnsResource
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.TableWithColumnsResource/ColumnWildcard
     :cognitect.aws.lakeformation.TableWithColumnsResource/DatabaseName
     :cognitect.aws.lakeformation.TableWithColumnsResource/ColumnNames
     :cognitect.aws.lakeformation.TableWithColumnsResource/Name]))

(s/def
  :cognitect.aws.lakeformation/PrincipalResourcePermissionsList
  (s/coll-of :cognitect.aws.lakeformation/PrincipalResourcePermissions))

(s/def
  :cognitect.aws.lakeformation/RevokePermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.RevokePermissionsRequest/Principal
     :cognitect.aws.lakeformation.RevokePermissionsRequest/Resource
     :cognitect.aws.lakeformation.RevokePermissionsRequest/Permissions]
    :opt-un
    [:cognitect.aws.lakeformation.RevokePermissionsRequest/PermissionsWithGrantOption
     :cognitect.aws.lakeformation.RevokePermissionsRequest/CatalogId]))

(s/def :cognitect.aws.lakeformation/LastModifiedTimestamp inst?)

(s/def
  :cognitect.aws.lakeformation/DataLakePrincipalString
  (s/with-gen
    (s/and string? #(<= 1 (count %) 255))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 255 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/DataLocationResource
  (s/keys :req-un [:cognitect.aws.lakeformation.DataLocationResource/ResourceArn]))

(s/def
  :cognitect.aws.lakeformation/IAMRoleArn
  (s/with-gen #(re-matches (re-pattern "arn:aws:iam::[0-9]*:role/.*") %) #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/ListResourcesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListResourcesRequest/NextToken
     :cognitect.aws.lakeformation.ListResourcesRequest/FilterConditionList
     :cognitect.aws.lakeformation.ListResourcesRequest/MaxResults]))

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Id
  :cognitect.aws.lakeformation/Identifier)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/PermissionsWithGrantOption
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.BatchGrantPermissionsResponse/Failures
  :cognitect.aws.lakeformation/BatchPermissionsFailureList)

(s/def
  :cognitect.aws.lakeformation.DataLakePrincipal/DataLakePrincipalIdentifier
  :cognitect.aws.lakeformation/DataLakePrincipalString)

(s/def
  :cognitect.aws.lakeformation.ColumnWildcard/ExcludedColumnNames
  :cognitect.aws.lakeformation/ColumnNames)

(s/def
  :cognitect.aws.lakeformation.TableResource/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def :cognitect.aws.lakeformation.TableResource/Name :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/PermissionsWithGrantOption
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/DataLakeAdmins
  :cognitect.aws.lakeformation/DataLakePrincipalList)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/CreateDatabaseDefaultPermissions
  :cognitect.aws.lakeformation/PrincipalPermissionsList)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/CreateTableDefaultPermissions
  :cognitect.aws.lakeformation/PrincipalPermissionsList)

(s/def
  :cognitect.aws.lakeformation.GetDataLakeSettingsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def :cognitect.aws.lakeformation.ErrorDetail/ErrorCode :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.ErrorDetail/ErrorMessage
  :cognitect.aws.lakeformation/DescriptionString)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/ResourceType
  :cognitect.aws.lakeformation/DataLakeResourceType)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.ResourceInfo/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def :cognitect.aws.lakeformation.ResourceInfo/RoleArn :cognitect.aws.lakeformation/IAMRoleArn)

(s/def
  :cognitect.aws.lakeformation.ResourceInfo/LastModified
  :cognitect.aws.lakeformation/LastModifiedTimestamp)

(s/def
  :cognitect.aws.lakeformation.PutDataLakeSettingsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.PutDataLakeSettingsRequest/DataLakeSettings
  :cognitect.aws.lakeformation/DataLakeSettings)

(s/def
  :cognitect.aws.lakeformation.ListResourcesResponse/ResourceInfoList
  :cognitect.aws.lakeformation/ResourceInfoList)

(s/def
  :cognitect.aws.lakeformation.ListResourcesResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.GetDataLakeSettingsResponse/DataLakeSettings
  :cognitect.aws.lakeformation/DataLakeSettings)

(s/def
  :cognitect.aws.lakeformation.BatchGrantPermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.BatchGrantPermissionsRequest/Entries
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntryList)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsResponse/PrincipalResourcePermissions
  :cognitect.aws.lakeformation/PrincipalResourcePermissionsList)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.BatchRevokePermissionsResponse/Failures
  :cognitect.aws.lakeformation/BatchPermissionsFailureList)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.BatchRevokePermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.BatchRevokePermissionsRequest/Entries
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntryList)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsFailureEntry/RequestEntry
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntry)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsFailureEntry/Error
  :cognitect.aws.lakeformation/ErrorDetail)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathResponse/Permissions
  :cognitect.aws.lakeformation/PrincipalResourcePermissionsList)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.PrincipalPermissions/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.PrincipalPermissions/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.DeregisterResourceRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def :cognitect.aws.lakeformation.Resource/Catalog :cognitect.aws.lakeformation/CatalogResource)

(s/def :cognitect.aws.lakeformation.Resource/Database :cognitect.aws.lakeformation/DatabaseResource)

(s/def :cognitect.aws.lakeformation.Resource/Table :cognitect.aws.lakeformation/TableResource)

(s/def
  :cognitect.aws.lakeformation.Resource/TableWithColumns
  :cognitect.aws.lakeformation/TableWithColumnsResource)

(s/def
  :cognitect.aws.lakeformation.Resource/DataLocation
  :cognitect.aws.lakeformation/DataLocationResource)

(s/def
  :cognitect.aws.lakeformation.RegisterResourceRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.RegisterResourceRequest/UseServiceLinkedRole
  :cognitect.aws.lakeformation/NullableBoolean)

(s/def
  :cognitect.aws.lakeformation.RegisterResourceRequest/RoleArn
  :cognitect.aws.lakeformation/IAMRoleArn)

(s/def :cognitect.aws.lakeformation.DatabaseResource/Name :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.UpdateResourceRequest/RoleArn
  :cognitect.aws.lakeformation/IAMRoleArn)

(s/def
  :cognitect.aws.lakeformation.UpdateResourceRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.PrincipalResourcePermissions/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.PrincipalResourcePermissions/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.PrincipalResourcePermissions/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.PrincipalResourcePermissions/PermissionsWithGrantOption
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.FilterCondition/Field
  :cognitect.aws.lakeformation/FieldNameString)

(s/def
  :cognitect.aws.lakeformation.FilterCondition/ComparisonOperator
  :cognitect.aws.lakeformation/ComparisonOperator)

(s/def
  :cognitect.aws.lakeformation.FilterCondition/StringValueList
  :cognitect.aws.lakeformation/StringValueList)

(s/def
  :cognitect.aws.lakeformation.DescribeResourceResponse/ResourceInfo
  :cognitect.aws.lakeformation/ResourceInfo)

(s/def
  :cognitect.aws.lakeformation.DescribeResourceRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.TableWithColumnsResource/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.TableWithColumnsResource/Name
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.TableWithColumnsResource/ColumnNames
  :cognitect.aws.lakeformation/ColumnNames)

(s/def
  :cognitect.aws.lakeformation.TableWithColumnsResource/ColumnWildcard
  :cognitect.aws.lakeformation/ColumnWildcard)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/PermissionsWithGrantOption
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.DataLocationResource/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.ListResourcesRequest/FilterConditionList
  :cognitect.aws.lakeformation/FilterConditionList)

(s/def
  :cognitect.aws.lakeformation.ListResourcesRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.ListResourcesRequest/NextToken
  :cognitect.aws.lakeformation/Token)

