;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.lakeformation.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.lakeformation/TaggedTable
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.TaggedTable/LFTagsOnColumns
     :cognitect.aws.lakeformation.TaggedTable/LFTagsOnTable
     :cognitect.aws.lakeformation.TaggedTable/LFTagOnDatabase
     :cognitect.aws.lakeformation.TaggedTable/Table]))

(s/def
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntry
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Id]
    :opt-un
    [:cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Permissions
     :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/PermissionsWithGrantOption
     :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Resource
     :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Principal]))

(s/def
  :cognitect.aws.lakeformation/QueryPlanningContextDatabaseNameString
  (s/spec
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\t]*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/BatchGrantPermissionsResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.BatchGrantPermissionsResponse/Failures]))

(s/def
  :cognitect.aws.lakeformation/DeleteObjectInput
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.DeleteObjectInput/Uri]
    :opt-un
    [:cognitect.aws.lakeformation.DeleteObjectInput/ETag
     :cognitect.aws.lakeformation.DeleteObjectInput/PartitionValues]))

(s/def
  :cognitect.aws.lakeformation/AddLFTagsToResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.AddLFTagsToResourceRequest/Resource
     :cognitect.aws.lakeformation.AddLFTagsToResourceRequest/LFTags]
    :opt-un
    [:cognitect.aws.lakeformation.AddLFTagsToResourceRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/GetQueryStateRequestQueryIdString
  (s/spec
    (s/and string? #(<= 36 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 36 36) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/DataLakePrincipal
  (s/keys :opt-un [:cognitect.aws.lakeformation.DataLakePrincipal/DataLakePrincipalIdentifier]))

(s/def
  :cognitect.aws.lakeformation/ResourceType
  (s/spec string? :gen #(s/gen #{"DATABASE" "TABLE"})))

(s/def
  :cognitect.aws.lakeformation/ColumnWildcard
  (s/keys :opt-un [:cognitect.aws.lakeformation.ColumnWildcard/ExcludedColumnNames]))

(s/def :cognitect.aws.lakeformation/DeleteLFTagResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/ValueStringList
  (s/coll-of :cognitect.aws.lakeformation/ValueString :min-count 1))

(s/def
  :cognitect.aws.lakeformation/ColumnLFTag
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ColumnLFTag/LFTags
     :cognitect.aws.lakeformation.ColumnLFTag/Name]))

(s/def
  :cognitect.aws.lakeformation/TrueFalseString
  (s/spec
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\t]*")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.lakeformation/DeleteDataCellsFilterResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/TableResource
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.TableResource/DatabaseName]
    :opt-un
    [:cognitect.aws.lakeformation.TableResource/TableWildcard
     :cognitect.aws.lakeformation.TableResource/CatalogId
     :cognitect.aws.lakeformation.TableResource/Name]))

(s/def
  :cognitect.aws.lakeformation/GetTemporaryGluePartitionCredentialsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsResponse/SessionToken
     :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsResponse/SecretAccessKey
     :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsResponse/AccessKeyId
     :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsResponse/Expiration]))

(s/def
  :cognitect.aws.lakeformation/PartitionValueString
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.lakeformation/SessionTokenString string?)

(s/def :cognitect.aws.lakeformation/AccessKeyIdString string?)

(s/def :cognitect.aws.lakeformation/UpdateResourceResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/GetQueryStatisticsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.GetQueryStatisticsResponse/QuerySubmissionTime
     :cognitect.aws.lakeformation.GetQueryStatisticsResponse/PlanningStatistics
     :cognitect.aws.lakeformation.GetQueryStatisticsResponse/ExecutionStatistics]))

(s/def
  :cognitect.aws.lakeformation/GrantPermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GrantPermissionsRequest/Principal
     :cognitect.aws.lakeformation.GrantPermissionsRequest/Resource
     :cognitect.aws.lakeformation.GrantPermissionsRequest/Permissions]
    :opt-un
    [:cognitect.aws.lakeformation.GrantPermissionsRequest/PermissionsWithGrantOption
     :cognitect.aws.lakeformation.GrantPermissionsRequest/CatalogId]))

(s/def :cognitect.aws.lakeformation/CreateLFTagResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/DataLakeSettings
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.DataLakeSettings/DataLakeAdmins
     :cognitect.aws.lakeformation.DataLakeSettings/AuthorizedSessionTagValueList
     :cognitect.aws.lakeformation.DataLakeSettings/CreateDatabaseDefaultPermissions
     :cognitect.aws.lakeformation.DataLakeSettings/TrustedResourceOwners
     :cognitect.aws.lakeformation.DataLakeSettings/AllowExternalDataFiltering
     :cognitect.aws.lakeformation.DataLakeSettings/CreateTableDefaultPermissions
     :cognitect.aws.lakeformation.DataLakeSettings/ExternalDataFilteringAllowList]))

(s/def
  :cognitect.aws.lakeformation/GetDataLakeSettingsRequest
  (s/keys :opt-un [:cognitect.aws.lakeformation.GetDataLakeSettingsRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/SearchTablesByLFTagsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.SearchTablesByLFTagsResponse/TableList
     :cognitect.aws.lakeformation.SearchTablesByLFTagsResponse/NextToken]))

(s/def :cognitect.aws.lakeformation/StorageOptimizerConfigKey string?)

(s/def
  :cognitect.aws.lakeformation/ErrorDetail
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ErrorDetail/ErrorMessage
     :cognitect.aws.lakeformation.ErrorDetail/ErrorCode]))

(s/def :cognitect.aws.lakeformation/ValueString string?)

(s/def
  :cognitect.aws.lakeformation/DataLakePrincipalList
  (s/coll-of :cognitect.aws.lakeformation/DataLakePrincipal :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.lakeformation/ListPermissionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListPermissionsRequest/NextToken
     :cognitect.aws.lakeformation.ListPermissionsRequest/ResourceType
     :cognitect.aws.lakeformation.ListPermissionsRequest/CatalogId
     :cognitect.aws.lakeformation.ListPermissionsRequest/MaxResults
     :cognitect.aws.lakeformation.ListPermissionsRequest/Resource
     :cognitect.aws.lakeformation.ListPermissionsRequest/IncludeRelated
     :cognitect.aws.lakeformation.ListPermissionsRequest/Principal]))

(s/def
  :cognitect.aws.lakeformation/LFTagsList
  (s/coll-of :cognitect.aws.lakeformation/LFTagPair :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.lakeformation/RowFilter
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.RowFilter/FilterExpression
     :cognitect.aws.lakeformation.RowFilter/AllRowsWildcard]))

(s/def
  :cognitect.aws.lakeformation/LFTagKeyResource
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.LFTagKeyResource/TagKey
     :cognitect.aws.lakeformation.LFTagKeyResource/TagValues]
    :opt-un
    [:cognitect.aws.lakeformation.LFTagKeyResource/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/GetResourceLFTagsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.GetResourceLFTagsResponse/LFTagsOnColumns
     :cognitect.aws.lakeformation.GetResourceLFTagsResponse/LFTagsOnTable
     :cognitect.aws.lakeformation.GetResourceLFTagsResponse/LFTagOnDatabase]))

(s/def
  :cognitect.aws.lakeformation/ResourceShareList
  (s/coll-of :cognitect.aws.lakeformation/RAMResourceShareArn))

(s/def
  :cognitect.aws.lakeformation/LFTagValue
  (s/spec
    #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:\\*\\/=+\\-@%]*)$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/UpdateTableStorageOptimizerResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.UpdateTableStorageOptimizerResponse/Result]))

(s/def
  :cognitect.aws.lakeformation/CancelTransactionRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.CancelTransactionRequest/TransactionId]))

(s/def
  :cognitect.aws.lakeformation/StorageOptimizerConfig
  (s/map-of
    :cognitect.aws.lakeformation/StorageOptimizerConfigKey
    :cognitect.aws.lakeformation/StorageOptimizerConfigValue))

(s/def
  :cognitect.aws.lakeformation/RemoveLFTagsFromResourceResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.RemoveLFTagsFromResourceResponse/Failures]))

(s/def :cognitect.aws.lakeformation/PutDataLakeSettingsResponse (s/keys))

(s/def :cognitect.aws.lakeformation/CancelTransactionResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/DataCellsFilter
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.DataCellsFilter/TableCatalogId
     :cognitect.aws.lakeformation.DataCellsFilter/DatabaseName
     :cognitect.aws.lakeformation.DataCellsFilter/TableName
     :cognitect.aws.lakeformation.DataCellsFilter/Name]
    :opt-un
    [:cognitect.aws.lakeformation.DataCellsFilter/ColumnWildcard
     :cognitect.aws.lakeformation.DataCellsFilter/ColumnNames
     :cognitect.aws.lakeformation.DataCellsFilter/RowFilter]))

(s/def
  :cognitect.aws.lakeformation/Permission
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CREATE_TABLE" "DELETE" "ASSOCIATE_TAG" "DESCRIBE" "DATA_LOCATION_ACCESS" "ALTER_TAG"
        "CREATE_DATABASE" "INSERT" "DELETE_TAG" "SELECT" "CREATE_TAG" "ALTER" "ALL" "DROP"
        "DESCRIBE_TAG"})))

(s/def
  :cognitect.aws.lakeformation/ResourceShareType
  (s/spec string? :gen #(s/gen #{"FOREIGN" "ALL"})))

(s/def :cognitect.aws.lakeformation/Token string?)

(s/def
  :cognitect.aws.lakeformation/ExecutionStatistics
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ExecutionStatistics/WorkUnitsExecutedCount
     :cognitect.aws.lakeformation.ExecutionStatistics/AverageExecutionTimeMillis
     :cognitect.aws.lakeformation.ExecutionStatistics/DataScannedBytes]))

(s/def
  :cognitect.aws.lakeformation/LFTagError
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.LFTagError/LFTag :cognitect.aws.lakeformation.LFTagError/Error]))

(s/def
  :cognitect.aws.lakeformation/StartTransactionResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.StartTransactionResponse/TransactionId]))

(s/def
  :cognitect.aws.lakeformation/ResourceInfo
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ResourceInfo/RoleArn
     :cognitect.aws.lakeformation.ResourceInfo/LastModified
     :cognitect.aws.lakeformation.ResourceInfo/ResourceArn]))

(s/def
  :cognitect.aws.lakeformation/StorageOptimizerList
  (s/coll-of :cognitect.aws.lakeformation/StorageOptimizer))

(s/def
  :cognitect.aws.lakeformation/ListLFTagsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListLFTagsRequest/NextToken
     :cognitect.aws.lakeformation.ListLFTagsRequest/CatalogId
     :cognitect.aws.lakeformation.ListLFTagsRequest/ResourceShareType
     :cognitect.aws.lakeformation.ListLFTagsRequest/MaxResults]))

(s/def
  :cognitect.aws.lakeformation/ColumnLFTagsList
  (s/coll-of :cognitect.aws.lakeformation/ColumnLFTag))

(s/def
  :cognitect.aws.lakeformation/WorkUnitIdLong
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.lakeformation/PutDataLakeSettingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.PutDataLakeSettingsRequest/DataLakeSettings]
    :opt-un
    [:cognitect.aws.lakeformation.PutDataLakeSettingsRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/GetTableObjectsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.GetTableObjectsResponse/Objects
     :cognitect.aws.lakeformation.GetTableObjectsResponse/NextToken]))

(s/def
  :cognitect.aws.lakeformation/TransactionDescriptionList
  (s/coll-of :cognitect.aws.lakeformation/TransactionDescription))

(s/def
  :cognitect.aws.lakeformation/ListResourcesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListResourcesResponse/NextToken
     :cognitect.aws.lakeformation.ListResourcesResponse/ResourceInfoList]))

(s/def
  :cognitect.aws.lakeformation/PlanningStatistics
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.PlanningStatistics/QueueTimeMillis
     :cognitect.aws.lakeformation.PlanningStatistics/PlanningTimeMillis
     :cognitect.aws.lakeformation.PlanningStatistics/EstimatedDataToScanBytes
     :cognitect.aws.lakeformation.PlanningStatistics/WorkUnitsGeneratedCount]))

(s/def
  :cognitect.aws.lakeformation/SyntheticStartQueryPlanningRequestQueryString
  (s/spec
    (s/and string? #(<= 1 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/PartitionValuesList
  (s/coll-of :cognitect.aws.lakeformation/PartitionValueString :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.lakeformation/GetLFTagRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetLFTagRequest/TagKey]
    :opt-un
    [:cognitect.aws.lakeformation.GetLFTagRequest/CatalogId]))

(s/def :cognitect.aws.lakeformation/GrantPermissionsResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/TableObjectList
  (s/coll-of :cognitect.aws.lakeformation/TableObject))

(s/def :cognitect.aws.lakeformation/Result string?)

(s/def
  :cognitect.aws.lakeformation/WorkUnitRangeList
  (s/coll-of :cognitect.aws.lakeformation/WorkUnitRange))

(s/def
  :cognitect.aws.lakeformation/PartitionedTableObjectsList
  (s/coll-of :cognitect.aws.lakeformation/PartitionObjects))

(s/def :cognitect.aws.lakeformation/StringValue string?)

(s/def
  :cognitect.aws.lakeformation/LFTag
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.LFTag/TagKey :cognitect.aws.lakeformation.LFTag/TagValues]))

(s/def
  :cognitect.aws.lakeformation/OptimizerType
  (s/spec string? :gen #(s/gen #{"GARBAGE_COLLECTION" "COMPACTION" "ALL"})))

(s/def
  :cognitect.aws.lakeformation/StorageOptimizer
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.StorageOptimizer/Config
     :cognitect.aws.lakeformation.StorageOptimizer/Warnings
     :cognitect.aws.lakeformation.StorageOptimizer/ErrorMessage
     :cognitect.aws.lakeformation.StorageOptimizer/LastRunDetails
     :cognitect.aws.lakeformation.StorageOptimizer/StorageOptimizerType]))

(s/def
  :cognitect.aws.lakeformation/QueryPlanningContext
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.QueryPlanningContext/DatabaseName]
    :opt-un
    [:cognitect.aws.lakeformation.QueryPlanningContext/QueryParameters
     :cognitect.aws.lakeformation.QueryPlanningContext/TransactionId
     :cognitect.aws.lakeformation.QueryPlanningContext/QueryAsOfTime
     :cognitect.aws.lakeformation.QueryPlanningContext/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/StorageOptimizerConfigMap
  (s/map-of
    :cognitect.aws.lakeformation/OptimizerType
    :cognitect.aws.lakeformation/StorageOptimizerConfig))

(s/def :cognitect.aws.lakeformation/StorageOptimizerConfigValue string?)

(s/def
  :cognitect.aws.lakeformation/TransactionDescription
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.TransactionDescription/TransactionEndTime
     :cognitect.aws.lakeformation.TransactionDescription/TransactionStartTime
     :cognitect.aws.lakeformation.TransactionDescription/TransactionId
     :cognitect.aws.lakeformation.TransactionDescription/TransactionStatus]))

(s/def
  :cognitect.aws.lakeformation/NameString
  (s/spec
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\t]*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/GetDataLakeSettingsResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.GetDataLakeSettingsResponse/DataLakeSettings]))

(s/def
  :cognitect.aws.lakeformation/ComparisonOperator
  (s/spec
    string?
    :gen
    #(s/gen
      #{"NE" "CONTAINS" "LT" "GE" "LE" "NOT_CONTAINS" "BEGINS_WITH" "EQ" "GT" "IN" "BETWEEN"})))

(s/def
  :cognitect.aws.lakeformation/SearchDatabasesByLFTagsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.SearchDatabasesByLFTagsResponse/NextToken
     :cognitect.aws.lakeformation.SearchDatabasesByLFTagsResponse/DatabaseList]))

(s/def
  :cognitect.aws.lakeformation/ResultStream
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.lakeformation/LFTagKey
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:\\/=+\\-@%]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/VirtualObjectList
  (s/coll-of :cognitect.aws.lakeformation/VirtualObject :min-count 1 :max-count 100))

(s/def :cognitect.aws.lakeformation/NullableBoolean boolean?)

(s/def
  :cognitect.aws.lakeformation/TokenString
  (s/spec
    (s/and string? #(>= 4096 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/DeleteObjectsOnCancelRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/DatabaseName
     :cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/TableName
     :cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/TransactionId
     :cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/Objects]
    :opt-un
    [:cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/ListDataCellsFilterResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListDataCellsFilterResponse/NextToken
     :cognitect.aws.lakeformation.ListDataCellsFilterResponse/DataCellsFilters]))

(s/def
  :cognitect.aws.lakeformation/ListTransactionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListTransactionsResponse/Transactions
     :cognitect.aws.lakeformation.ListTransactionsResponse/NextToken]))

(s/def
  :cognitect.aws.lakeformation/AuthorizedSessionTagValueList
  (s/coll-of :cognitect.aws.lakeformation/NameString))

(s/def
  :cognitect.aws.lakeformation/PermissionTypeList
  (s/coll-of :cognitect.aws.lakeformation/PermissionType :min-count 1 :max-count 255))

(s/def
  :cognitect.aws.lakeformation/DetailsMap
  (s/keys :opt-un [:cognitect.aws.lakeformation.DetailsMap/ResourceShare]))

(s/def
  :cognitect.aws.lakeformation/GetTableObjectsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetTableObjectsRequest/DatabaseName
     :cognitect.aws.lakeformation.GetTableObjectsRequest/TableName]
    :opt-un
    [:cognitect.aws.lakeformation.GetTableObjectsRequest/TransactionId
     :cognitect.aws.lakeformation.GetTableObjectsRequest/NextToken
     :cognitect.aws.lakeformation.GetTableObjectsRequest/QueryAsOfTime
     :cognitect.aws.lakeformation.GetTableObjectsRequest/CatalogId
     :cognitect.aws.lakeformation.GetTableObjectsRequest/MaxResults
     :cognitect.aws.lakeformation.GetTableObjectsRequest/PartitionPredicate]))

(s/def :cognitect.aws.lakeformation/ExtendTransactionResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/TableLFTagsList
  (s/coll-of :cognitect.aws.lakeformation/TaggedTable))

(s/def
  :cognitect.aws.lakeformation/DescriptionString
  (s/spec
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\r\\n\\t]*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/QueryParameterMap
  (s/map-of :cognitect.aws.lakeformation/String :cognitect.aws.lakeformation/String))

(s/def
  :cognitect.aws.lakeformation/BatchGrantPermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.BatchGrantPermissionsRequest/Entries]
    :opt-un
    [:cognitect.aws.lakeformation.BatchGrantPermissionsRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/Identifier
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.lakeformation/ExpirationTimestamp inst?)

(s/def
  :cognitect.aws.lakeformation/ListPermissionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListPermissionsResponse/NextToken
     :cognitect.aws.lakeformation.ListPermissionsResponse/PrincipalResourcePermissions]))

(s/def
  :cognitect.aws.lakeformation/GetResourceLFTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetResourceLFTagsRequest/Resource]
    :opt-un
    [:cognitect.aws.lakeformation.GetResourceLFTagsRequest/ShowAssignedLFTags
     :cognitect.aws.lakeformation.GetResourceLFTagsRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/BatchRevokePermissionsResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.BatchRevokePermissionsResponse/Failures]))

(s/def
  :cognitect.aws.lakeformation/StringValueList
  (s/coll-of :cognitect.aws.lakeformation/StringValue))

(s/def
  :cognitect.aws.lakeformation/DataCellsFilterList
  (s/coll-of :cognitect.aws.lakeformation/DataCellsFilter))

(s/def
  :cognitect.aws.lakeformation/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.lakeformation/GetQueryStateResponse
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetQueryStateResponse/State]
    :opt-un
    [:cognitect.aws.lakeformation.GetQueryStateResponse/Error]))

(s/def :cognitect.aws.lakeformation/RevokePermissionsResponse (s/keys))

(s/def :cognitect.aws.lakeformation/QueryIdString string?)

(s/def
  :cognitect.aws.lakeformation/TrustedResourceOwners
  (s/coll-of :cognitect.aws.lakeformation/CatalogIdString))

(s/def
  :cognitect.aws.lakeformation/CreateLFTagRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.CreateLFTagRequest/TagKey
     :cognitect.aws.lakeformation.CreateLFTagRequest/TagValues]
    :opt-un
    [:cognitect.aws.lakeformation.CreateLFTagRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/Expression
  (s/coll-of :cognitect.aws.lakeformation/LFTag :min-count 1 :max-count 5))

(s/def
  :cognitect.aws.lakeformation/GetEffectivePermissionsForPathRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/ResourceArn]
    :opt-un
    [:cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/NextToken
     :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/CatalogId
     :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/MaxResults]))

(s/def
  :cognitect.aws.lakeformation/FieldNameString
  (s/spec string? :gen #(s/gen #{"LAST_MODIFIED" "RESOURCE_ARN" "ROLE_ARN"})))

(s/def :cognitect.aws.lakeformation/UpdateTableObjectsResponse (s/keys))

(s/def :cognitect.aws.lakeformation/SecretAccessKeyString string?)

(s/def
  :cognitect.aws.lakeformation/GetTemporaryGlueTableCredentialsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsResponse/SessionToken
     :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsResponse/SecretAccessKey
     :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsResponse/AccessKeyId
     :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsResponse/Expiration]))

(s/def
  :cognitect.aws.lakeformation/DataCellsFilterResource
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.DataCellsFilterResource/DatabaseName
     :cognitect.aws.lakeformation.DataCellsFilterResource/TableCatalogId
     :cognitect.aws.lakeformation.DataCellsFilterResource/TableName
     :cognitect.aws.lakeformation.DataCellsFilterResource/Name]))

(s/def
  :cognitect.aws.lakeformation/GetQueryStatisticsRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.GetQueryStatisticsRequest/QueryId]))

(s/def
  :cognitect.aws.lakeformation/TaggedDatabase
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.TaggedDatabase/LFTags
     :cognitect.aws.lakeformation.TaggedDatabase/Database]))

(s/def
  :cognitect.aws.lakeformation/PermissionType
  (s/spec string? :gen #(s/gen #{"COLUMN_PERMISSION" "CELL_FILTER_PERMISSION"})))

(s/def
  :cognitect.aws.lakeformation/GetLFTagResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.GetLFTagResponse/TagValues
     :cognitect.aws.lakeformation.GetLFTagResponse/TagKey
     :cognitect.aws.lakeformation.GetLFTagResponse/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/StartQueryPlanningResponse
  (s/keys :req-un [:cognitect.aws.lakeformation.StartQueryPlanningResponse/QueryId]))

(s/def :cognitect.aws.lakeformation/WorkUnitTokenString string?)

(s/def :cognitect.aws.lakeformation/LFTagErrors (s/coll-of :cognitect.aws.lakeformation/LFTagError))

(s/def
  :cognitect.aws.lakeformation/DeleteLFTagRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.DeleteLFTagRequest/TagKey]
    :opt-un
    [:cognitect.aws.lakeformation.DeleteLFTagRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/TransactionIdString
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{N}\\p{P}]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/AddLFTagsToResourceResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.AddLFTagsToResourceResponse/Failures]))

(s/def
  :cognitect.aws.lakeformation/UpdateTableStorageOptimizerRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.UpdateTableStorageOptimizerRequest/DatabaseName
     :cognitect.aws.lakeformation.UpdateTableStorageOptimizerRequest/TableName
     :cognitect.aws.lakeformation.UpdateTableStorageOptimizerRequest/StorageOptimizerConfig]
    :opt-un
    [:cognitect.aws.lakeformation.UpdateTableStorageOptimizerRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/ListLFTagsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListLFTagsResponse/NextToken
     :cognitect.aws.lakeformation.ListLFTagsResponse/LFTags]))

(s/def :cognitect.aws.lakeformation/ErrorMessageString string?)

(s/def
  :cognitect.aws.lakeformation/CommitTransactionRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.CommitTransactionRequest/TransactionId]))

(s/def
  :cognitect.aws.lakeformation/StartTransactionRequest
  (s/keys :opt-un [:cognitect.aws.lakeformation.StartTransactionRequest/TransactionType]))

(s/def
  :cognitect.aws.lakeformation/UpdateTableObjectsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.UpdateTableObjectsRequest/DatabaseName
     :cognitect.aws.lakeformation.UpdateTableObjectsRequest/TableName
     :cognitect.aws.lakeformation.UpdateTableObjectsRequest/WriteOperations]
    :opt-un
    [:cognitect.aws.lakeformation.UpdateTableObjectsRequest/TransactionId
     :cognitect.aws.lakeformation.UpdateTableObjectsRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/PermissionList
  (s/coll-of :cognitect.aws.lakeformation/Permission))

(s/def
  :cognitect.aws.lakeformation/GetQueryStateRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.GetQueryStateRequest/QueryId]))

(s/def
  :cognitect.aws.lakeformation/GetWorkUnitResultsResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.GetWorkUnitResultsResponse/ResultStream]))

(s/def
  :cognitect.aws.lakeformation/ExtendTransactionRequest
  (s/keys :opt-un [:cognitect.aws.lakeformation.ExtendTransactionRequest/TransactionId]))

(s/def
  :cognitect.aws.lakeformation/ObjectSize
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.lakeformation/DeregisterResourceResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/GetWorkUnitResultsRequestQueryIdString
  (s/spec
    (s/and string? #(<= 36 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 36 36) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/PrincipalPermissionsList
  (s/coll-of :cognitect.aws.lakeformation/PrincipalPermissions))

(s/def :cognitect.aws.lakeformation/CatalogResource (s/keys))

(s/def
  :cognitect.aws.lakeformation/LFTagPair
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.LFTagPair/TagKey
     :cognitect.aws.lakeformation.LFTagPair/TagValues]
    :opt-un
    [:cognitect.aws.lakeformation.LFTagPair/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/BatchPermissionsFailureList
  (s/coll-of :cognitect.aws.lakeformation/BatchPermissionsFailureEntry))

(s/def
  :cognitect.aws.lakeformation/URI
  (s/spec
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\r\\n\\t]*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/BatchRevokePermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.BatchRevokePermissionsRequest/Entries]
    :opt-un
    [:cognitect.aws.lakeformation.BatchRevokePermissionsRequest/CatalogId]))

(s/def :cognitect.aws.lakeformation/ColumnNames (s/coll-of :cognitect.aws.lakeformation/NameString))

(s/def
  :cognitect.aws.lakeformation/GetTemporaryGluePartitionCredentialsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/TableArn
     :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/Partition
     :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/SupportedPermissionTypes]
    :opt-un
    [:cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/Permissions
     :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/DurationSeconds
     :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/AuditContext]))

(s/def
  :cognitect.aws.lakeformation/AddObjectInput
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.AddObjectInput/Uri
     :cognitect.aws.lakeformation.AddObjectInput/ETag
     :cognitect.aws.lakeformation.AddObjectInput/Size]
    :opt-un
    [:cognitect.aws.lakeformation.AddObjectInput/PartitionValues]))

(s/def
  :cognitect.aws.lakeformation/CommitTransactionResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.CommitTransactionResponse/TransactionStatus]))

(s/def
  :cognitect.aws.lakeformation/WriteOperation
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.WriteOperation/AddObject
     :cognitect.aws.lakeformation.WriteOperation/DeleteObject]))

(s/def
  :cognitect.aws.lakeformation/SyntheticGetWorkUnitResultsRequestWorkUnitTokenString
  (s/spec
    (s/and string? #(<= 1 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/QueryStateString
  (s/spec string? :gen #(s/gen #{"EXPIRED" "PENDING" "ERROR" "WORKUNITS_AVAILABLE" "FINISHED"})))

(s/def
  :cognitect.aws.lakeformation/BatchPermissionsFailureEntry
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.BatchPermissionsFailureEntry/RequestEntry
     :cognitect.aws.lakeformation.BatchPermissionsFailureEntry/Error]))

(s/def
  :cognitect.aws.lakeformation/SearchDatabasesByLFTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.SearchDatabasesByLFTagsRequest/Expression]
    :opt-un
    [:cognitect.aws.lakeformation.SearchDatabasesByLFTagsRequest/NextToken
     :cognitect.aws.lakeformation.SearchDatabasesByLFTagsRequest/CatalogId
     :cognitect.aws.lakeformation.SearchDatabasesByLFTagsRequest/MaxResults]))

(s/def :cognitect.aws.lakeformation/BooleanNullable boolean?)

(s/def
  :cognitect.aws.lakeformation/ListTableStorageOptimizersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListTableStorageOptimizersResponse/NextToken
     :cognitect.aws.lakeformation.ListTableStorageOptimizersResponse/StorageOptimizerList]))

(s/def
  :cognitect.aws.lakeformation/WorkUnitRange
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.WorkUnitRange/WorkUnitIdMax
     :cognitect.aws.lakeformation.WorkUnitRange/WorkUnitIdMin
     :cognitect.aws.lakeformation.WorkUnitRange/WorkUnitToken]))

(s/def
  :cognitect.aws.lakeformation/RemoveLFTagsFromResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.RemoveLFTagsFromResourceRequest/Resource
     :cognitect.aws.lakeformation.RemoveLFTagsFromResourceRequest/LFTags]
    :opt-un
    [:cognitect.aws.lakeformation.RemoveLFTagsFromResourceRequest/CatalogId]))

(s/def :cognitect.aws.lakeformation/ResourceArnString string?)

(s/def
  :cognitect.aws.lakeformation/GetWorkUnitsRequestQueryIdString
  (s/spec
    (s/and string? #(<= 36 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 36 36) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/GetEffectivePermissionsForPathResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.GetEffectivePermissionsForPathResponse/Permissions
     :cognitect.aws.lakeformation.GetEffectivePermissionsForPathResponse/NextToken]))

(s/def
  :cognitect.aws.lakeformation/AuditContextString
  (s/spec
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\t]*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/FilterConditionList
  (s/coll-of :cognitect.aws.lakeformation/FilterCondition :min-count 1 :max-count 20))

(s/def
  :cognitect.aws.lakeformation/TagValueList
  (s/coll-of :cognitect.aws.lakeformation/LFTagValue :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.lakeformation/PrincipalPermissions
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.PrincipalPermissions/Permissions
     :cognitect.aws.lakeformation.PrincipalPermissions/Principal]))

(s/def
  :cognitect.aws.lakeformation/DeleteDataCellsFilterRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.DeleteDataCellsFilterRequest/DatabaseName
     :cognitect.aws.lakeformation.DeleteDataCellsFilterRequest/TableCatalogId
     :cognitect.aws.lakeformation.DeleteDataCellsFilterRequest/TableName
     :cognitect.aws.lakeformation.DeleteDataCellsFilterRequest/Name]))

(s/def
  :cognitect.aws.lakeformation/GetWorkUnitsResponse
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetWorkUnitsResponse/QueryId
     :cognitect.aws.lakeformation.GetWorkUnitsResponse/WorkUnitRanges]
    :opt-un
    [:cognitect.aws.lakeformation.GetWorkUnitsResponse/NextToken]))

(s/def
  :cognitect.aws.lakeformation/NumberOfBytes
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.lakeformation/DataLakeResourceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DATABASE" "LF_TAG_POLICY_DATABASE" "DATA_LOCATION" "CATALOG" "LF_TAG_POLICY" "LF_TAG"
        "TABLE" "LF_TAG_POLICY_TABLE"})))

(s/def :cognitect.aws.lakeformation/TableWildcard (s/keys))

(s/def
  :cognitect.aws.lakeformation/TransactionStatus
  (s/spec string? :gen #(s/gen #{"COMMITTED" "COMMIT_IN_PROGRESS" "ACTIVE" "ABORTED"})))

(s/def :cognitect.aws.lakeformation/CreateDataCellsFilterResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/ListTableStorageOptimizersRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/DatabaseName
     :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/TableName]
    :opt-un
    [:cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/NextToken
     :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/CatalogId
     :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/MaxResults
     :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/StorageOptimizerType]))

(s/def
  :cognitect.aws.lakeformation/NumberOfMilliseconds
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.lakeformation/PageSize
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def :cognitect.aws.lakeformation/AllRowsWildcard (s/keys))

(s/def
  :cognitect.aws.lakeformation/CredentialTimeoutDurationSecondInteger
  (s/spec (s/and int? #(<= 900 % 43200)) :gen #(gen/choose 900 43200)))

(s/def
  :cognitect.aws.lakeformation/PartitionValueList
  (s/keys :req-un [:cognitect.aws.lakeformation.PartitionValueList/Values]))

(s/def
  :cognitect.aws.lakeformation/DescribeTransactionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.DescribeTransactionResponse/TransactionDescription]))

(s/def
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntryList
  (s/coll-of :cognitect.aws.lakeformation/BatchPermissionsRequestEntry))

(s/def
  :cognitect.aws.lakeformation/GetTemporaryGlueTableCredentialsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/TableArn
     :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/SupportedPermissionTypes]
    :opt-un
    [:cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/Permissions
     :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/DurationSeconds
     :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/AuditContext]))

(s/def
  :cognitect.aws.lakeformation/DeregisterResourceRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.DeregisterResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.lakeformation/Resource
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.Resource/DataLocation
     :cognitect.aws.lakeformation.Resource/LFTag
     :cognitect.aws.lakeformation.Resource/TableWithColumns
     :cognitect.aws.lakeformation.Resource/LFTagPolicy
     :cognitect.aws.lakeformation.Resource/Catalog
     :cognitect.aws.lakeformation.Resource/DataCellsFilter
     :cognitect.aws.lakeformation.Resource/Table
     :cognitect.aws.lakeformation.Resource/Database]))

(s/def :cognitect.aws.lakeformation/MessageString string?)

(s/def
  :cognitect.aws.lakeformation/ListDataCellsFilterRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListDataCellsFilterRequest/NextToken
     :cognitect.aws.lakeformation.ListDataCellsFilterRequest/MaxResults
     :cognitect.aws.lakeformation.ListDataCellsFilterRequest/Table]))

(s/def
  :cognitect.aws.lakeformation/ResourceInfoList
  (s/coll-of :cognitect.aws.lakeformation/ResourceInfo))

(s/def
  :cognitect.aws.lakeformation/PredicateString
  (s/spec
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\r\\n\\t]*")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.lakeformation/Timestamp inst?)

(s/def :cognitect.aws.lakeformation/RAMResourceShareArn string?)

(s/def
  :cognitect.aws.lakeformation/RegisterResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.RegisterResourceRequest/ResourceArn]
    :opt-un
    [:cognitect.aws.lakeformation.RegisterResourceRequest/UseServiceLinkedRole
     :cognitect.aws.lakeformation.RegisterResourceRequest/RoleArn]))

(s/def
  :cognitect.aws.lakeformation/TransactionStatusFilter
  (s/spec string? :gen #(s/gen #{"COMPLETED" "COMMITTED" "ACTIVE" "ABORTED" "ALL"})))

(s/def
  :cognitect.aws.lakeformation/DatabaseLFTagsList
  (s/coll-of :cognitect.aws.lakeformation/TaggedDatabase))

(s/def :cognitect.aws.lakeformation/RegisterResourceResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/DescribeTransactionRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.DescribeTransactionRequest/TransactionId]))

(s/def
  :cognitect.aws.lakeformation/ETagString
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{N}\\p{P}]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/CatalogIdString
  (s/spec
    #(re-matches
      (re-pattern "[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDC00-\\uDBFF\\uDFFF\\t]*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lakeformation/GetQueryStatisticsRequestQueryIdString
  (s/spec
    (s/and string? #(<= 36 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 36 36) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/DatabaseResource
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.DatabaseResource/Name]
    :opt-un
    [:cognitect.aws.lakeformation.DatabaseResource/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/CreateDataCellsFilterRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.CreateDataCellsFilterRequest/TableData]))

(s/def
  :cognitect.aws.lakeformation/UpdateResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.UpdateResourceRequest/RoleArn
     :cognitect.aws.lakeformation.UpdateResourceRequest/ResourceArn]))

(s/def :cognitect.aws.lakeformation/UpdateLFTagResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/PartitionObjects
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.PartitionObjects/Objects
     :cognitect.aws.lakeformation.PartitionObjects/PartitionValues]))

(s/def
  :cognitect.aws.lakeformation/PrincipalResourcePermissions
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.PrincipalResourcePermissions/Permissions
     :cognitect.aws.lakeformation.PrincipalResourcePermissions/AdditionalDetails
     :cognitect.aws.lakeformation.PrincipalResourcePermissions/PermissionsWithGrantOption
     :cognitect.aws.lakeformation.PrincipalResourcePermissions/Resource
     :cognitect.aws.lakeformation.PrincipalResourcePermissions/Principal]))

(s/def
  :cognitect.aws.lakeformation/VirtualObject
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.VirtualObject/Uri]
    :opt-un
    [:cognitect.aws.lakeformation.VirtualObject/ETag]))

(s/def :cognitect.aws.lakeformation/DateTime inst?)

(s/def
  :cognitect.aws.lakeformation/GetWorkUnitResultsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetWorkUnitResultsRequest/QueryId
     :cognitect.aws.lakeformation.GetWorkUnitResultsRequest/WorkUnitId
     :cognitect.aws.lakeformation.GetWorkUnitResultsRequest/WorkUnitToken]))

(s/def
  :cognitect.aws.lakeformation/AuditContext
  (s/keys :opt-un [:cognitect.aws.lakeformation.AuditContext/AdditionalAuditContext]))

(s/def
  :cognitect.aws.lakeformation/TableObject
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.TableObject/Uri
     :cognitect.aws.lakeformation.TableObject/ETag
     :cognitect.aws.lakeformation.TableObject/Size]))

(s/def :cognitect.aws.lakeformation/DeleteObjectsOnCancelResponse (s/keys))

(s/def
  :cognitect.aws.lakeformation/FilterCondition
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.FilterCondition/ComparisonOperator
     :cognitect.aws.lakeformation.FilterCondition/StringValueList
     :cognitect.aws.lakeformation.FilterCondition/Field]))

(s/def
  :cognitect.aws.lakeformation/WriteOperationList
  (s/coll-of :cognitect.aws.lakeformation/WriteOperation :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.lakeformation/LFTagPolicyResource
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.LFTagPolicyResource/ResourceType
     :cognitect.aws.lakeformation.LFTagPolicyResource/Expression]
    :opt-un
    [:cognitect.aws.lakeformation.LFTagPolicyResource/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/DescribeResourceResponse
  (s/keys :opt-un [:cognitect.aws.lakeformation.DescribeResourceResponse/ResourceInfo]))

(s/def
  :cognitect.aws.lakeformation/DescribeResourceRequest
  (s/keys :req-un [:cognitect.aws.lakeformation.DescribeResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.lakeformation/GetWorkUnitResultsRequestWorkUnitIdLong
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.lakeformation/TableWithColumnsResource
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.TableWithColumnsResource/DatabaseName
     :cognitect.aws.lakeformation.TableWithColumnsResource/Name]
    :opt-un
    [:cognitect.aws.lakeformation.TableWithColumnsResource/ColumnWildcard
     :cognitect.aws.lakeformation.TableWithColumnsResource/ColumnNames
     :cognitect.aws.lakeformation.TableWithColumnsResource/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/PrincipalResourcePermissionsList
  (s/coll-of :cognitect.aws.lakeformation/PrincipalResourcePermissions))

(s/def
  :cognitect.aws.lakeformation/RevokePermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.RevokePermissionsRequest/Principal
     :cognitect.aws.lakeformation.RevokePermissionsRequest/Resource
     :cognitect.aws.lakeformation.RevokePermissionsRequest/Permissions]
    :opt-un
    [:cognitect.aws.lakeformation.RevokePermissionsRequest/PermissionsWithGrantOption
     :cognitect.aws.lakeformation.RevokePermissionsRequest/CatalogId]))

(s/def :cognitect.aws.lakeformation/LastModifiedTimestamp inst?)

(s/def
  :cognitect.aws.lakeformation/StartQueryPlanningRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.StartQueryPlanningRequest/QueryPlanningContext
     :cognitect.aws.lakeformation.StartQueryPlanningRequest/QueryString]))

(s/def
  :cognitect.aws.lakeformation/TransactionType
  (s/spec string? :gen #(s/gen #{"READ_AND_WRITE" "READ_ONLY"})))

(s/def
  :cognitect.aws.lakeformation/DataLakePrincipalString
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lakeformation/UpdateLFTagRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.UpdateLFTagRequest/TagKey]
    :opt-un
    [:cognitect.aws.lakeformation.UpdateLFTagRequest/TagValuesToDelete
     :cognitect.aws.lakeformation.UpdateLFTagRequest/TagValuesToAdd
     :cognitect.aws.lakeformation.UpdateLFTagRequest/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/DataLocationResource
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.DataLocationResource/ResourceArn]
    :opt-un
    [:cognitect.aws.lakeformation.DataLocationResource/CatalogId]))

(s/def
  :cognitect.aws.lakeformation/IAMRoleArn
  (s/spec #(re-matches (re-pattern "arn:aws:iam::[0-9]*:role/.*") %) :gen #(gen/string)))

(s/def :cognitect.aws.lakeformation/String string?)

(s/def
  :cognitect.aws.lakeformation/ListTransactionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListTransactionsRequest/StatusFilter
     :cognitect.aws.lakeformation.ListTransactionsRequest/NextToken
     :cognitect.aws.lakeformation.ListTransactionsRequest/CatalogId
     :cognitect.aws.lakeformation.ListTransactionsRequest/MaxResults]))

(s/def
  :cognitect.aws.lakeformation/SearchTablesByLFTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.SearchTablesByLFTagsRequest/Expression]
    :opt-un
    [:cognitect.aws.lakeformation.SearchTablesByLFTagsRequest/NextToken
     :cognitect.aws.lakeformation.SearchTablesByLFTagsRequest/CatalogId
     :cognitect.aws.lakeformation.SearchTablesByLFTagsRequest/MaxResults]))

(s/def
  :cognitect.aws.lakeformation/NumberOfItems
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.lakeformation/GetWorkUnitsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lakeformation.GetWorkUnitsRequest/QueryId]
    :opt-un
    [:cognitect.aws.lakeformation.GetWorkUnitsRequest/PageSize
     :cognitect.aws.lakeformation.GetWorkUnitsRequest/NextToken]))

(s/def
  :cognitect.aws.lakeformation/ListResourcesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lakeformation.ListResourcesRequest/NextToken
     :cognitect.aws.lakeformation.ListResourcesRequest/FilterConditionList
     :cognitect.aws.lakeformation.ListResourcesRequest/MaxResults]))

(s/def :cognitect.aws.lakeformation.TaggedTable/Table :cognitect.aws.lakeformation/TableResource)

(s/def
  :cognitect.aws.lakeformation.TaggedTable/LFTagOnDatabase
  :cognitect.aws.lakeformation/LFTagsList)

(s/def
  :cognitect.aws.lakeformation.TaggedTable/LFTagsOnTable
  :cognitect.aws.lakeformation/LFTagsList)

(s/def
  :cognitect.aws.lakeformation.TaggedTable/LFTagsOnColumns
  :cognitect.aws.lakeformation/ColumnLFTagsList)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Id
  :cognitect.aws.lakeformation/Identifier)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsRequestEntry/PermissionsWithGrantOption
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.BatchGrantPermissionsResponse/Failures
  :cognitect.aws.lakeformation/BatchPermissionsFailureList)

(s/def :cognitect.aws.lakeformation.DeleteObjectInput/Uri :cognitect.aws.lakeformation/URI)

(s/def :cognitect.aws.lakeformation.DeleteObjectInput/ETag :cognitect.aws.lakeformation/ETagString)

(s/def
  :cognitect.aws.lakeformation.DeleteObjectInput/PartitionValues
  :cognitect.aws.lakeformation/PartitionValuesList)

(s/def
  :cognitect.aws.lakeformation.AddLFTagsToResourceRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.AddLFTagsToResourceRequest/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.AddLFTagsToResourceRequest/LFTags
  :cognitect.aws.lakeformation/LFTagsList)

(s/def
  :cognitect.aws.lakeformation.DataLakePrincipal/DataLakePrincipalIdentifier
  :cognitect.aws.lakeformation/DataLakePrincipalString)

(s/def
  :cognitect.aws.lakeformation.ColumnWildcard/ExcludedColumnNames
  :cognitect.aws.lakeformation/ColumnNames)

(s/def :cognitect.aws.lakeformation.ColumnLFTag/Name :cognitect.aws.lakeformation/NameString)

(s/def :cognitect.aws.lakeformation.ColumnLFTag/LFTags :cognitect.aws.lakeformation/LFTagsList)

(s/def
  :cognitect.aws.lakeformation.TableResource/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.TableResource/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def :cognitect.aws.lakeformation.TableResource/Name :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.TableResource/TableWildcard
  :cognitect.aws.lakeformation/TableWildcard)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsResponse/AccessKeyId
  :cognitect.aws.lakeformation/AccessKeyIdString)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsResponse/SecretAccessKey
  :cognitect.aws.lakeformation/SecretAccessKeyString)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsResponse/SessionToken
  :cognitect.aws.lakeformation/SessionTokenString)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsResponse/Expiration
  :cognitect.aws.lakeformation/ExpirationTimestamp)

(s/def
  :cognitect.aws.lakeformation.GetQueryStatisticsResponse/ExecutionStatistics
  :cognitect.aws.lakeformation/ExecutionStatistics)

(s/def
  :cognitect.aws.lakeformation.GetQueryStatisticsResponse/PlanningStatistics
  :cognitect.aws.lakeformation/PlanningStatistics)

(s/def
  :cognitect.aws.lakeformation.GetQueryStatisticsResponse/QuerySubmissionTime
  :cognitect.aws.lakeformation/DateTime)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.GrantPermissionsRequest/PermissionsWithGrantOption
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/DataLakeAdmins
  :cognitect.aws.lakeformation/DataLakePrincipalList)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/CreateDatabaseDefaultPermissions
  :cognitect.aws.lakeformation/PrincipalPermissionsList)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/CreateTableDefaultPermissions
  :cognitect.aws.lakeformation/PrincipalPermissionsList)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/TrustedResourceOwners
  :cognitect.aws.lakeformation/TrustedResourceOwners)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/AllowExternalDataFiltering
  :cognitect.aws.lakeformation/NullableBoolean)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/ExternalDataFilteringAllowList
  :cognitect.aws.lakeformation/DataLakePrincipalList)

(s/def
  :cognitect.aws.lakeformation.DataLakeSettings/AuthorizedSessionTagValueList
  :cognitect.aws.lakeformation/AuthorizedSessionTagValueList)

(s/def
  :cognitect.aws.lakeformation.GetDataLakeSettingsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.SearchTablesByLFTagsResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.SearchTablesByLFTagsResponse/TableList
  :cognitect.aws.lakeformation/TableLFTagsList)

(s/def :cognitect.aws.lakeformation.ErrorDetail/ErrorCode :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.ErrorDetail/ErrorMessage
  :cognitect.aws.lakeformation/DescriptionString)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/ResourceType
  :cognitect.aws.lakeformation/DataLakeResourceType)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsRequest/IncludeRelated
  :cognitect.aws.lakeformation/TrueFalseString)

(s/def
  :cognitect.aws.lakeformation.RowFilter/FilterExpression
  :cognitect.aws.lakeformation/PredicateString)

(s/def
  :cognitect.aws.lakeformation.RowFilter/AllRowsWildcard
  :cognitect.aws.lakeformation/AllRowsWildcard)

(s/def
  :cognitect.aws.lakeformation.LFTagKeyResource/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def :cognitect.aws.lakeformation.LFTagKeyResource/TagKey :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.LFTagKeyResource/TagValues
  :cognitect.aws.lakeformation/TagValueList)

(s/def
  :cognitect.aws.lakeformation.GetResourceLFTagsResponse/LFTagOnDatabase
  :cognitect.aws.lakeformation/LFTagsList)

(s/def
  :cognitect.aws.lakeformation.GetResourceLFTagsResponse/LFTagsOnTable
  :cognitect.aws.lakeformation/LFTagsList)

(s/def
  :cognitect.aws.lakeformation.GetResourceLFTagsResponse/LFTagsOnColumns
  :cognitect.aws.lakeformation/ColumnLFTagsList)

(s/def
  :cognitect.aws.lakeformation.UpdateTableStorageOptimizerResponse/Result
  :cognitect.aws.lakeformation/Result)

(s/def
  :cognitect.aws.lakeformation.CancelTransactionRequest/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.RemoveLFTagsFromResourceResponse/Failures
  :cognitect.aws.lakeformation/LFTagErrors)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilter/TableCatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilter/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilter/TableName
  :cognitect.aws.lakeformation/NameString)

(s/def :cognitect.aws.lakeformation.DataCellsFilter/Name :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilter/RowFilter
  :cognitect.aws.lakeformation/RowFilter)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilter/ColumnNames
  :cognitect.aws.lakeformation/ColumnNames)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilter/ColumnWildcard
  :cognitect.aws.lakeformation/ColumnWildcard)

(s/def
  :cognitect.aws.lakeformation.ExecutionStatistics/AverageExecutionTimeMillis
  :cognitect.aws.lakeformation/NumberOfMilliseconds)

(s/def
  :cognitect.aws.lakeformation.ExecutionStatistics/DataScannedBytes
  :cognitect.aws.lakeformation/NumberOfBytes)

(s/def
  :cognitect.aws.lakeformation.ExecutionStatistics/WorkUnitsExecutedCount
  :cognitect.aws.lakeformation/NumberOfItems)

(s/def :cognitect.aws.lakeformation.LFTagError/LFTag :cognitect.aws.lakeformation/LFTagPair)

(s/def :cognitect.aws.lakeformation.LFTagError/Error :cognitect.aws.lakeformation/ErrorDetail)

(s/def
  :cognitect.aws.lakeformation.StartTransactionResponse/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.ResourceInfo/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def :cognitect.aws.lakeformation.ResourceInfo/RoleArn :cognitect.aws.lakeformation/IAMRoleArn)

(s/def
  :cognitect.aws.lakeformation.ResourceInfo/LastModified
  :cognitect.aws.lakeformation/LastModifiedTimestamp)

(s/def
  :cognitect.aws.lakeformation.ListLFTagsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.ListLFTagsRequest/ResourceShareType
  :cognitect.aws.lakeformation/ResourceShareType)

(s/def
  :cognitect.aws.lakeformation.ListLFTagsRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def :cognitect.aws.lakeformation.ListLFTagsRequest/NextToken :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.PutDataLakeSettingsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.PutDataLakeSettingsRequest/DataLakeSettings
  :cognitect.aws.lakeformation/DataLakeSettings)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsResponse/Objects
  :cognitect.aws.lakeformation/PartitionedTableObjectsList)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsResponse/NextToken
  :cognitect.aws.lakeformation/TokenString)

(s/def
  :cognitect.aws.lakeformation.ListResourcesResponse/ResourceInfoList
  :cognitect.aws.lakeformation/ResourceInfoList)

(s/def
  :cognitect.aws.lakeformation.ListResourcesResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.PlanningStatistics/EstimatedDataToScanBytes
  :cognitect.aws.lakeformation/NumberOfBytes)

(s/def
  :cognitect.aws.lakeformation.PlanningStatistics/PlanningTimeMillis
  :cognitect.aws.lakeformation/NumberOfMilliseconds)

(s/def
  :cognitect.aws.lakeformation.PlanningStatistics/QueueTimeMillis
  :cognitect.aws.lakeformation/NumberOfMilliseconds)

(s/def
  :cognitect.aws.lakeformation.PlanningStatistics/WorkUnitsGeneratedCount
  :cognitect.aws.lakeformation/NumberOfItems)

(s/def
  :cognitect.aws.lakeformation.GetLFTagRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def :cognitect.aws.lakeformation.GetLFTagRequest/TagKey :cognitect.aws.lakeformation/LFTagKey)

(s/def :cognitect.aws.lakeformation.LFTag/TagKey :cognitect.aws.lakeformation/LFTagKey)

(s/def :cognitect.aws.lakeformation.LFTag/TagValues :cognitect.aws.lakeformation/TagValueList)

(s/def
  :cognitect.aws.lakeformation.StorageOptimizer/StorageOptimizerType
  :cognitect.aws.lakeformation/OptimizerType)

(s/def
  :cognitect.aws.lakeformation.StorageOptimizer/Config
  :cognitect.aws.lakeformation/StorageOptimizerConfig)

(s/def
  :cognitect.aws.lakeformation.StorageOptimizer/ErrorMessage
  :cognitect.aws.lakeformation/MessageString)

(s/def
  :cognitect.aws.lakeformation.StorageOptimizer/Warnings
  :cognitect.aws.lakeformation/MessageString)

(s/def
  :cognitect.aws.lakeformation.StorageOptimizer/LastRunDetails
  :cognitect.aws.lakeformation/MessageString)

(s/def
  :cognitect.aws.lakeformation.QueryPlanningContext/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.QueryPlanningContext/DatabaseName
  :cognitect.aws.lakeformation/QueryPlanningContextDatabaseNameString)

(s/def
  :cognitect.aws.lakeformation.QueryPlanningContext/QueryAsOfTime
  :cognitect.aws.lakeformation/Timestamp)

(s/def
  :cognitect.aws.lakeformation.QueryPlanningContext/QueryParameters
  :cognitect.aws.lakeformation/QueryParameterMap)

(s/def
  :cognitect.aws.lakeformation.QueryPlanningContext/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.TransactionDescription/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.TransactionDescription/TransactionStatus
  :cognitect.aws.lakeformation/TransactionStatus)

(s/def
  :cognitect.aws.lakeformation.TransactionDescription/TransactionStartTime
  :cognitect.aws.lakeformation/Timestamp)

(s/def
  :cognitect.aws.lakeformation.TransactionDescription/TransactionEndTime
  :cognitect.aws.lakeformation/Timestamp)

(s/def
  :cognitect.aws.lakeformation.GetDataLakeSettingsResponse/DataLakeSettings
  :cognitect.aws.lakeformation/DataLakeSettings)

(s/def
  :cognitect.aws.lakeformation.SearchDatabasesByLFTagsResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.SearchDatabasesByLFTagsResponse/DatabaseList
  :cognitect.aws.lakeformation/DatabaseLFTagsList)

(s/def
  :cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/TableName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.DeleteObjectsOnCancelRequest/Objects
  :cognitect.aws.lakeformation/VirtualObjectList)

(s/def
  :cognitect.aws.lakeformation.ListDataCellsFilterResponse/DataCellsFilters
  :cognitect.aws.lakeformation/DataCellsFilterList)

(s/def
  :cognitect.aws.lakeformation.ListDataCellsFilterResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.ListTransactionsResponse/Transactions
  :cognitect.aws.lakeformation/TransactionDescriptionList)

(s/def
  :cognitect.aws.lakeformation.ListTransactionsResponse/NextToken
  :cognitect.aws.lakeformation/TokenString)

(s/def
  :cognitect.aws.lakeformation.DetailsMap/ResourceShare
  :cognitect.aws.lakeformation/ResourceShareList)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsRequest/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsRequest/TableName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsRequest/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsRequest/QueryAsOfTime
  :cognitect.aws.lakeformation/Timestamp)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsRequest/PartitionPredicate
  :cognitect.aws.lakeformation/PredicateString)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.GetTableObjectsRequest/NextToken
  :cognitect.aws.lakeformation/TokenString)

(s/def
  :cognitect.aws.lakeformation.BatchGrantPermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.BatchGrantPermissionsRequest/Entries
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntryList)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsResponse/PrincipalResourcePermissions
  :cognitect.aws.lakeformation/PrincipalResourcePermissionsList)

(s/def
  :cognitect.aws.lakeformation.ListPermissionsResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.GetResourceLFTagsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.GetResourceLFTagsRequest/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.GetResourceLFTagsRequest/ShowAssignedLFTags
  :cognitect.aws.lakeformation/BooleanNullable)

(s/def
  :cognitect.aws.lakeformation.BatchRevokePermissionsResponse/Failures
  :cognitect.aws.lakeformation/BatchPermissionsFailureList)

(s/def
  :cognitect.aws.lakeformation.GetQueryStateResponse/Error
  :cognitect.aws.lakeformation/ErrorMessageString)

(s/def
  :cognitect.aws.lakeformation.GetQueryStateResponse/State
  :cognitect.aws.lakeformation/QueryStateString)

(s/def
  :cognitect.aws.lakeformation.CreateLFTagRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def :cognitect.aws.lakeformation.CreateLFTagRequest/TagKey :cognitect.aws.lakeformation/LFTagKey)

(s/def
  :cognitect.aws.lakeformation.CreateLFTagRequest/TagValues
  :cognitect.aws.lakeformation/TagValueList)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsResponse/AccessKeyId
  :cognitect.aws.lakeformation/AccessKeyIdString)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsResponse/SecretAccessKey
  :cognitect.aws.lakeformation/SecretAccessKeyString)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsResponse/SessionToken
  :cognitect.aws.lakeformation/SessionTokenString)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsResponse/Expiration
  :cognitect.aws.lakeformation/ExpirationTimestamp)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilterResource/TableCatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilterResource/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilterResource/TableName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.DataCellsFilterResource/Name
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.GetQueryStatisticsRequest/QueryId
  :cognitect.aws.lakeformation/GetQueryStatisticsRequestQueryIdString)

(s/def
  :cognitect.aws.lakeformation.TaggedDatabase/Database
  :cognitect.aws.lakeformation/DatabaseResource)

(s/def :cognitect.aws.lakeformation.TaggedDatabase/LFTags :cognitect.aws.lakeformation/LFTagsList)

(s/def
  :cognitect.aws.lakeformation.GetLFTagResponse/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def :cognitect.aws.lakeformation.GetLFTagResponse/TagKey :cognitect.aws.lakeformation/LFTagKey)

(s/def
  :cognitect.aws.lakeformation.GetLFTagResponse/TagValues
  :cognitect.aws.lakeformation/TagValueList)

(s/def
  :cognitect.aws.lakeformation.StartQueryPlanningResponse/QueryId
  :cognitect.aws.lakeformation/QueryIdString)

(s/def
  :cognitect.aws.lakeformation.DeleteLFTagRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def :cognitect.aws.lakeformation.DeleteLFTagRequest/TagKey :cognitect.aws.lakeformation/LFTagKey)

(s/def
  :cognitect.aws.lakeformation.AddLFTagsToResourceResponse/Failures
  :cognitect.aws.lakeformation/LFTagErrors)

(s/def
  :cognitect.aws.lakeformation.UpdateTableStorageOptimizerRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.UpdateTableStorageOptimizerRequest/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.UpdateTableStorageOptimizerRequest/TableName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.UpdateTableStorageOptimizerRequest/StorageOptimizerConfig
  :cognitect.aws.lakeformation/StorageOptimizerConfigMap)

(s/def
  :cognitect.aws.lakeformation.ListLFTagsResponse/LFTags
  :cognitect.aws.lakeformation/LFTagsList)

(s/def :cognitect.aws.lakeformation.ListLFTagsResponse/NextToken :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.CommitTransactionRequest/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.StartTransactionRequest/TransactionType
  :cognitect.aws.lakeformation/TransactionType)

(s/def
  :cognitect.aws.lakeformation.UpdateTableObjectsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.UpdateTableObjectsRequest/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.UpdateTableObjectsRequest/TableName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.UpdateTableObjectsRequest/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.UpdateTableObjectsRequest/WriteOperations
  :cognitect.aws.lakeformation/WriteOperationList)

(s/def
  :cognitect.aws.lakeformation.GetQueryStateRequest/QueryId
  :cognitect.aws.lakeformation/GetQueryStateRequestQueryIdString)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitResultsResponse/ResultStream
  :cognitect.aws.lakeformation/ResultStream)

(s/def
  :cognitect.aws.lakeformation.ExtendTransactionRequest/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.LFTagPair/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def :cognitect.aws.lakeformation.LFTagPair/TagKey :cognitect.aws.lakeformation/LFTagKey)

(s/def :cognitect.aws.lakeformation.LFTagPair/TagValues :cognitect.aws.lakeformation/TagValueList)

(s/def
  :cognitect.aws.lakeformation.BatchRevokePermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.BatchRevokePermissionsRequest/Entries
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntryList)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/TableArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/Partition
  :cognitect.aws.lakeformation/PartitionValueList)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/DurationSeconds
  :cognitect.aws.lakeformation/CredentialTimeoutDurationSecondInteger)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/AuditContext
  :cognitect.aws.lakeformation/AuditContext)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGluePartitionCredentialsRequest/SupportedPermissionTypes
  :cognitect.aws.lakeformation/PermissionTypeList)

(s/def :cognitect.aws.lakeformation.AddObjectInput/Uri :cognitect.aws.lakeformation/URI)

(s/def :cognitect.aws.lakeformation.AddObjectInput/ETag :cognitect.aws.lakeformation/ETagString)

(s/def :cognitect.aws.lakeformation.AddObjectInput/Size :cognitect.aws.lakeformation/ObjectSize)

(s/def
  :cognitect.aws.lakeformation.AddObjectInput/PartitionValues
  :cognitect.aws.lakeformation/PartitionValuesList)

(s/def
  :cognitect.aws.lakeformation.CommitTransactionResponse/TransactionStatus
  :cognitect.aws.lakeformation/TransactionStatus)

(s/def
  :cognitect.aws.lakeformation.WriteOperation/AddObject
  :cognitect.aws.lakeformation/AddObjectInput)

(s/def
  :cognitect.aws.lakeformation.WriteOperation/DeleteObject
  :cognitect.aws.lakeformation/DeleteObjectInput)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsFailureEntry/RequestEntry
  :cognitect.aws.lakeformation/BatchPermissionsRequestEntry)

(s/def
  :cognitect.aws.lakeformation.BatchPermissionsFailureEntry/Error
  :cognitect.aws.lakeformation/ErrorDetail)

(s/def
  :cognitect.aws.lakeformation.SearchDatabasesByLFTagsRequest/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.SearchDatabasesByLFTagsRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.SearchDatabasesByLFTagsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.SearchDatabasesByLFTagsRequest/Expression
  :cognitect.aws.lakeformation/Expression)

(s/def
  :cognitect.aws.lakeformation.ListTableStorageOptimizersResponse/StorageOptimizerList
  :cognitect.aws.lakeformation/StorageOptimizerList)

(s/def
  :cognitect.aws.lakeformation.ListTableStorageOptimizersResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.WorkUnitRange/WorkUnitIdMax
  :cognitect.aws.lakeformation/WorkUnitIdLong)

(s/def
  :cognitect.aws.lakeformation.WorkUnitRange/WorkUnitIdMin
  :cognitect.aws.lakeformation/WorkUnitIdLong)

(s/def
  :cognitect.aws.lakeformation.WorkUnitRange/WorkUnitToken
  :cognitect.aws.lakeformation/WorkUnitTokenString)

(s/def
  :cognitect.aws.lakeformation.RemoveLFTagsFromResourceRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.RemoveLFTagsFromResourceRequest/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.RemoveLFTagsFromResourceRequest/LFTags
  :cognitect.aws.lakeformation/LFTagsList)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathResponse/Permissions
  :cognitect.aws.lakeformation/PrincipalResourcePermissionsList)

(s/def
  :cognitect.aws.lakeformation.GetEffectivePermissionsForPathResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.PrincipalPermissions/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.PrincipalPermissions/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.DeleteDataCellsFilterRequest/TableCatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.DeleteDataCellsFilterRequest/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.DeleteDataCellsFilterRequest/TableName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.DeleteDataCellsFilterRequest/Name
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitsResponse/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitsResponse/QueryId
  :cognitect.aws.lakeformation/QueryIdString)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitsResponse/WorkUnitRanges
  :cognitect.aws.lakeformation/WorkUnitRangeList)

(s/def
  :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/TableName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/StorageOptimizerType
  :cognitect.aws.lakeformation/OptimizerType)

(s/def
  :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.ListTableStorageOptimizersRequest/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.PartitionValueList/Values
  :cognitect.aws.lakeformation/ValueStringList)

(s/def
  :cognitect.aws.lakeformation.DescribeTransactionResponse/TransactionDescription
  :cognitect.aws.lakeformation/TransactionDescription)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/TableArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/DurationSeconds
  :cognitect.aws.lakeformation/CredentialTimeoutDurationSecondInteger)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/AuditContext
  :cognitect.aws.lakeformation/AuditContext)

(s/def
  :cognitect.aws.lakeformation.GetTemporaryGlueTableCredentialsRequest/SupportedPermissionTypes
  :cognitect.aws.lakeformation/PermissionTypeList)

(s/def
  :cognitect.aws.lakeformation.DeregisterResourceRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def :cognitect.aws.lakeformation.Resource/Catalog :cognitect.aws.lakeformation/CatalogResource)

(s/def :cognitect.aws.lakeformation.Resource/Database :cognitect.aws.lakeformation/DatabaseResource)

(s/def :cognitect.aws.lakeformation.Resource/Table :cognitect.aws.lakeformation/TableResource)

(s/def
  :cognitect.aws.lakeformation.Resource/TableWithColumns
  :cognitect.aws.lakeformation/TableWithColumnsResource)

(s/def
  :cognitect.aws.lakeformation.Resource/DataLocation
  :cognitect.aws.lakeformation/DataLocationResource)

(s/def
  :cognitect.aws.lakeformation.Resource/DataCellsFilter
  :cognitect.aws.lakeformation/DataCellsFilterResource)

(s/def :cognitect.aws.lakeformation.Resource/LFTag :cognitect.aws.lakeformation/LFTagKeyResource)

(s/def
  :cognitect.aws.lakeformation.Resource/LFTagPolicy
  :cognitect.aws.lakeformation/LFTagPolicyResource)

(s/def
  :cognitect.aws.lakeformation.ListDataCellsFilterRequest/Table
  :cognitect.aws.lakeformation/TableResource)

(s/def
  :cognitect.aws.lakeformation.ListDataCellsFilterRequest/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.ListDataCellsFilterRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.RegisterResourceRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.RegisterResourceRequest/UseServiceLinkedRole
  :cognitect.aws.lakeformation/NullableBoolean)

(s/def
  :cognitect.aws.lakeformation.RegisterResourceRequest/RoleArn
  :cognitect.aws.lakeformation/IAMRoleArn)

(s/def
  :cognitect.aws.lakeformation.DescribeTransactionRequest/TransactionId
  :cognitect.aws.lakeformation/TransactionIdString)

(s/def
  :cognitect.aws.lakeformation.DatabaseResource/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def :cognitect.aws.lakeformation.DatabaseResource/Name :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.CreateDataCellsFilterRequest/TableData
  :cognitect.aws.lakeformation/DataCellsFilter)

(s/def
  :cognitect.aws.lakeformation.UpdateResourceRequest/RoleArn
  :cognitect.aws.lakeformation/IAMRoleArn)

(s/def
  :cognitect.aws.lakeformation.UpdateResourceRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.PartitionObjects/PartitionValues
  :cognitect.aws.lakeformation/PartitionValuesList)

(s/def
  :cognitect.aws.lakeformation.PartitionObjects/Objects
  :cognitect.aws.lakeformation/TableObjectList)

(s/def
  :cognitect.aws.lakeformation.PrincipalResourcePermissions/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.PrincipalResourcePermissions/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.PrincipalResourcePermissions/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.PrincipalResourcePermissions/PermissionsWithGrantOption
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.PrincipalResourcePermissions/AdditionalDetails
  :cognitect.aws.lakeformation/DetailsMap)

(s/def :cognitect.aws.lakeformation.VirtualObject/Uri :cognitect.aws.lakeformation/URI)

(s/def :cognitect.aws.lakeformation.VirtualObject/ETag :cognitect.aws.lakeformation/ETagString)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitResultsRequest/QueryId
  :cognitect.aws.lakeformation/GetWorkUnitResultsRequestQueryIdString)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitResultsRequest/WorkUnitId
  :cognitect.aws.lakeformation/GetWorkUnitResultsRequestWorkUnitIdLong)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitResultsRequest/WorkUnitToken
  :cognitect.aws.lakeformation/SyntheticGetWorkUnitResultsRequestWorkUnitTokenString)

(s/def
  :cognitect.aws.lakeformation.AuditContext/AdditionalAuditContext
  :cognitect.aws.lakeformation/AuditContextString)

(s/def :cognitect.aws.lakeformation.TableObject/Uri :cognitect.aws.lakeformation/URI)

(s/def :cognitect.aws.lakeformation.TableObject/ETag :cognitect.aws.lakeformation/ETagString)

(s/def :cognitect.aws.lakeformation.TableObject/Size :cognitect.aws.lakeformation/ObjectSize)

(s/def
  :cognitect.aws.lakeformation.FilterCondition/Field
  :cognitect.aws.lakeformation/FieldNameString)

(s/def
  :cognitect.aws.lakeformation.FilterCondition/ComparisonOperator
  :cognitect.aws.lakeformation/ComparisonOperator)

(s/def
  :cognitect.aws.lakeformation.FilterCondition/StringValueList
  :cognitect.aws.lakeformation/StringValueList)

(s/def
  :cognitect.aws.lakeformation.LFTagPolicyResource/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.LFTagPolicyResource/ResourceType
  :cognitect.aws.lakeformation/ResourceType)

(s/def
  :cognitect.aws.lakeformation.LFTagPolicyResource/Expression
  :cognitect.aws.lakeformation/Expression)

(s/def
  :cognitect.aws.lakeformation.DescribeResourceResponse/ResourceInfo
  :cognitect.aws.lakeformation/ResourceInfo)

(s/def
  :cognitect.aws.lakeformation.DescribeResourceRequest/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.TableWithColumnsResource/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.TableWithColumnsResource/DatabaseName
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.TableWithColumnsResource/Name
  :cognitect.aws.lakeformation/NameString)

(s/def
  :cognitect.aws.lakeformation.TableWithColumnsResource/ColumnNames
  :cognitect.aws.lakeformation/ColumnNames)

(s/def
  :cognitect.aws.lakeformation.TableWithColumnsResource/ColumnWildcard
  :cognitect.aws.lakeformation/ColumnWildcard)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/Principal
  :cognitect.aws.lakeformation/DataLakePrincipal)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/Resource
  :cognitect.aws.lakeformation/Resource)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/Permissions
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.RevokePermissionsRequest/PermissionsWithGrantOption
  :cognitect.aws.lakeformation/PermissionList)

(s/def
  :cognitect.aws.lakeformation.StartQueryPlanningRequest/QueryPlanningContext
  :cognitect.aws.lakeformation/QueryPlanningContext)

(s/def
  :cognitect.aws.lakeformation.StartQueryPlanningRequest/QueryString
  :cognitect.aws.lakeformation/SyntheticStartQueryPlanningRequestQueryString)

(s/def
  :cognitect.aws.lakeformation.UpdateLFTagRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def :cognitect.aws.lakeformation.UpdateLFTagRequest/TagKey :cognitect.aws.lakeformation/LFTagKey)

(s/def
  :cognitect.aws.lakeformation.UpdateLFTagRequest/TagValuesToDelete
  :cognitect.aws.lakeformation/TagValueList)

(s/def
  :cognitect.aws.lakeformation.UpdateLFTagRequest/TagValuesToAdd
  :cognitect.aws.lakeformation/TagValueList)

(s/def
  :cognitect.aws.lakeformation.DataLocationResource/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.DataLocationResource/ResourceArn
  :cognitect.aws.lakeformation/ResourceArnString)

(s/def
  :cognitect.aws.lakeformation.ListTransactionsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.ListTransactionsRequest/StatusFilter
  :cognitect.aws.lakeformation/TransactionStatusFilter)

(s/def
  :cognitect.aws.lakeformation.ListTransactionsRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.ListTransactionsRequest/NextToken
  :cognitect.aws.lakeformation/TokenString)

(s/def
  :cognitect.aws.lakeformation.SearchTablesByLFTagsRequest/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.SearchTablesByLFTagsRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.SearchTablesByLFTagsRequest/CatalogId
  :cognitect.aws.lakeformation/CatalogIdString)

(s/def
  :cognitect.aws.lakeformation.SearchTablesByLFTagsRequest/Expression
  :cognitect.aws.lakeformation/Expression)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitsRequest/NextToken
  :cognitect.aws.lakeformation/Token)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitsRequest/PageSize
  :cognitect.aws.lakeformation/Integer)

(s/def
  :cognitect.aws.lakeformation.GetWorkUnitsRequest/QueryId
  :cognitect.aws.lakeformation/GetWorkUnitsRequestQueryIdString)

(s/def
  :cognitect.aws.lakeformation.ListResourcesRequest/FilterConditionList
  :cognitect.aws.lakeformation/FilterConditionList)

(s/def
  :cognitect.aws.lakeformation.ListResourcesRequest/MaxResults
  :cognitect.aws.lakeformation/PageSize)

(s/def
  :cognitect.aws.lakeformation.ListResourcesRequest/NextToken
  :cognitect.aws.lakeformation/Token)

