;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.location.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.location/MapStyle
  (s/spec #(re-matches (re-pattern "^[-._\\p{L}\\p{N}]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/DeleteGeofenceCollectionRequest
  (s/keys :req-un [:cognitect.aws.location.DeleteGeofenceCollectionRequest/CollectionName]))

(s/def :cognitect.aws.location/IntendedUse (s/spec string? :gen #(s/gen #{"Storage" "SingleUse"})))

(s/def
  :cognitect.aws.location/BatchPutGeofenceSuccessList
  (s/coll-of :cognitect.aws.location/BatchPutGeofenceSuccess))

(s/def
  :cognitect.aws.location/ListPlaceIndexesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.location.ListPlaceIndexesRequest/NextToken
     :cognitect.aws.location.ListPlaceIndexesRequest/MaxResults]))

(s/def
  :cognitect.aws.location/CreateGeofenceCollectionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateGeofenceCollectionResponse/CollectionArn
     :cognitect.aws.location.CreateGeofenceCollectionResponse/CollectionName
     :cognitect.aws.location.CreateGeofenceCollectionResponse/CreateTime]))

(s/def
  :cognitect.aws.location/DeletePlaceIndexRequest
  (s/keys :req-un [:cognitect.aws.location.DeletePlaceIndexRequest/IndexName]))

(s/def
  :cognitect.aws.location/DevicePositionList
  (s/coll-of :cognitect.aws.location/DevicePosition))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchUpdateDevicePositionRequest/TrackerName
     :cognitect.aws.location.BatchUpdateDevicePositionRequest/Updates]))

(s/def
  :cognitect.aws.location/ListTrackersResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListTrackersResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListTrackersResponse/NextToken]))

(s/def :cognitect.aws.location/LinearRing (s/coll-of :cognitect.aws.location/Position :min-count 4))

(s/def
  :cognitect.aws.location/CreatePlaceIndexRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CreatePlaceIndexRequest/DataSource
     :cognitect.aws.location.CreatePlaceIndexRequest/IndexName
     :cognitect.aws.location.CreatePlaceIndexRequest/PricingPlan]
    :opt-un
    [:cognitect.aws.location.CreatePlaceIndexRequest/DataSourceConfiguration
     :cognitect.aws.location.CreatePlaceIndexRequest/Description]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForPositionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionRequest/IndexName
     :cognitect.aws.location.SearchPlaceIndexForPositionRequest/Position]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionRequest/MaxResults]))

(s/def
  :cognitect.aws.location/BatchPutGeofenceError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceError/Error
     :cognitect.aws.location.BatchPutGeofenceError/GeofenceId]))

(s/def
  :cognitect.aws.location/BatchItemError
  (s/keys
    :opt-un
    [:cognitect.aws.location.BatchItemError/Message :cognitect.aws.location.BatchItemError/Code]))

(s/def
  :cognitect.aws.location/GetMapStyleDescriptorRequest
  (s/keys :req-un [:cognitect.aws.location.GetMapStyleDescriptorRequest/MapName]))

(s/def
  :cognitect.aws.location/CreateTrackerResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateTrackerResponse/CreateTime
     :cognitect.aws.location.CreateTrackerResponse/TrackerArn
     :cognitect.aws.location.CreateTrackerResponse/TrackerName]))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchEvaluateGeofencesError/DeviceId
     :cognitect.aws.location.BatchEvaluateGeofencesError/Error
     :cognitect.aws.location.BatchEvaluateGeofencesError/SampleTime]))

(s/def
  :cognitect.aws.location/DescribeTrackerResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.DescribeTrackerResponse/CreateTime
     :cognitect.aws.location.DescribeTrackerResponse/Description
     :cognitect.aws.location.DescribeTrackerResponse/TrackerArn
     :cognitect.aws.location.DescribeTrackerResponse/TrackerName
     :cognitect.aws.location.DescribeTrackerResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchDeleteGeofenceRequest/CollectionName
     :cognitect.aws.location.BatchDeleteGeofenceRequest/GeofenceIds]))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofenceCollectionsResponseEntry/CollectionName
     :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/CreateTime
     :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/Description
     :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/UpdateTime]))

(s/def
  :cognitect.aws.location/BatchItemErrorCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ThrottlingError" "ValidationError" "ResourceNotFoundError" "AccessDeniedError"
        "InternalServerError" "ConflictError"})))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionResponse
  (s/keys :req-un [:cognitect.aws.location.BatchUpdateDevicePositionResponse/Errors]))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofenceCollectionsResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListGeofenceCollectionsResponse/NextToken]))

(s/def
  :cognitect.aws.location/PlaceIndexSearchResultLimit
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def :cognitect.aws.location/ArnList (s/coll-of :cognitect.aws.location/Arn))

(s/def
  :cognitect.aws.location/ListGeofenceResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofenceResponseEntry/CreateTime
     :cognitect.aws.location.ListGeofenceResponseEntry/GeofenceId
     :cognitect.aws.location.ListGeofenceResponseEntry/Geometry
     :cognitect.aws.location.ListGeofenceResponseEntry/Status
     :cognitect.aws.location.ListGeofenceResponseEntry/UpdateTime]))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsResponseEntryList
  (s/coll-of :cognitect.aws.location/ListGeofenceCollectionsResponseEntry))

(s/def
  :cognitect.aws.location/ListTrackersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.location.ListTrackersRequest/NextToken
     :cognitect.aws.location.ListTrackersRequest/MaxResults]))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchGetDevicePositionResponse/DevicePositions
     :cognitect.aws.location.BatchGetDevicePositionResponse/Errors]))

(s/def
  :cognitect.aws.location/ListTrackersRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/CreatePlaceIndexResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CreatePlaceIndexResponse/CreateTime
     :cognitect.aws.location.CreatePlaceIndexResponse/IndexArn
     :cognitect.aws.location.CreatePlaceIndexResponse/IndexName]))

(s/def
  :cognitect.aws.location/DisassociateTrackerConsumerRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.DisassociateTrackerConsumerRequest/ConsumerArn
     :cognitect.aws.location.DisassociateTrackerConsumerRequest/TrackerName]))

(s/def
  :cognitect.aws.location/Token
  (s/spec
    (s/and string? #(<= 1 (count %) 2000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/GetMapGlyphsRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetMapGlyphsRequest/FontStack
     :cognitect.aws.location.GetMapGlyphsRequest/FontUnicodeRange
     :cognitect.aws.location.GetMapGlyphsRequest/MapName]))

(s/def
  :cognitect.aws.location/ListTrackerConsumersResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListTrackerConsumersResponse/ConsumerArns]
    :opt-un
    [:cognitect.aws.location.ListTrackerConsumersResponse/NextToken]))

(s/def
  :cognitect.aws.location/Id
  (s/spec #(re-matches (re-pattern "^[-._\\p{L}\\p{N}]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/PutGeofenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.PutGeofenceRequest/CollectionName
     :cognitect.aws.location.PutGeofenceRequest/GeofenceId
     :cognitect.aws.location.PutGeofenceRequest/Geometry]))

(s/def :cognitect.aws.location/DeleteMapResponse (s/keys))

(s/def
  :cognitect.aws.location/CreateMapRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateMapRequest/Configuration
     :cognitect.aws.location.CreateMapRequest/MapName
     :cognitect.aws.location.CreateMapRequest/PricingPlan]
    :opt-un
    [:cognitect.aws.location.CreateMapRequest/Description]))

(s/def
  :cognitect.aws.location/CountryCode
  (s/spec #(re-matches (re-pattern "^[A-Z]{3}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/ListPlaceIndexesRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForPositionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionResponse/Results
     :cognitect.aws.location.SearchPlaceIndexForPositionResponse/Summary]))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesErrorList
  (s/coll-of :cognitect.aws.location/BatchEvaluateGeofencesError))

(s/def
  :cognitect.aws.location/SearchForTextResultList
  (s/coll-of :cognitect.aws.location/SearchForTextResult))

(s/def
  :cognitect.aws.location/GeofenceGeometry
  (s/keys :opt-un [:cognitect.aws.location.GeofenceGeometry/Polygon]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForTextRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForTextRequest/IndexName
     :cognitect.aws.location.SearchPlaceIndexForTextRequest/Text]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForTextRequest/FilterBBox
     :cognitect.aws.location.SearchPlaceIndexForTextRequest/BiasPosition
     :cognitect.aws.location.SearchPlaceIndexForTextRequest/FilterCountries
     :cognitect.aws.location.SearchPlaceIndexForTextRequest/MaxResults]))

(s/def
  :cognitect.aws.location/DescribeGeofenceCollectionRequest
  (s/keys :req-un [:cognitect.aws.location.DescribeGeofenceCollectionRequest/CollectionName]))

(s/def
  :cognitect.aws.location/ListPlaceIndexesResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListPlaceIndexesResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListPlaceIndexesResponse/NextToken]))

(s/def
  :cognitect.aws.location/GetGeofenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetGeofenceRequest/CollectionName
     :cognitect.aws.location.GetGeofenceRequest/GeofenceId]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForTextResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForTextResponse/Results
     :cognitect.aws.location.SearchPlaceIndexForTextResponse/Summary]))

(s/def
  :cognitect.aws.location/BatchPutGeofenceResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceResponse/Errors
     :cognitect.aws.location.BatchPutGeofenceResponse/Successes]))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionRequestDeviceIdsList
  (s/coll-of :cognitect.aws.location/Id :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/LinearRings
  (s/coll-of :cognitect.aws.location/LinearRing :min-count 1))

(s/def
  :cognitect.aws.location/CreateMapResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateMapResponse/CreateTime
     :cognitect.aws.location.CreateMapResponse/MapArn
     :cognitect.aws.location.CreateMapResponse/MapName]))

(s/def
  :cognitect.aws.location/GetMapTileRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetMapTileRequest/MapName
     :cognitect.aws.location.GetMapTileRequest/X
     :cognitect.aws.location.GetMapTileRequest/Y
     :cognitect.aws.location.GetMapTileRequest/Z]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceErrorList
  (s/coll-of :cognitect.aws.location/BatchDeleteGeofenceError))

(s/def
  :cognitect.aws.location/ListMapsResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListMapsResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListMapsResponse/NextToken]))

(s/def
  :cognitect.aws.location/GetMapSpritesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.location.GetMapSpritesResponse/ContentType
     :cognitect.aws.location.GetMapSpritesResponse/Blob]))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesRequestDevicePositionUpdatesList
  (s/coll-of :cognitect.aws.location/DevicePositionUpdate :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/DescribePlaceIndexResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.DescribePlaceIndexResponse/CreateTime
     :cognitect.aws.location.DescribePlaceIndexResponse/DataSource
     :cognitect.aws.location.DescribePlaceIndexResponse/DataSourceConfiguration
     :cognitect.aws.location.DescribePlaceIndexResponse/Description
     :cognitect.aws.location.DescribePlaceIndexResponse/IndexArn
     :cognitect.aws.location.DescribePlaceIndexResponse/IndexName
     :cognitect.aws.location.DescribePlaceIndexResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/BatchPutGeofenceErrorList
  (s/coll-of :cognitect.aws.location/BatchPutGeofenceError))

(s/def
  :cognitect.aws.location/DescribeTrackerRequest
  (s/keys :req-un [:cognitect.aws.location.DescribeTrackerRequest/TrackerName]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForTextSummary
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForTextSummary/DataSource
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/Text]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForTextSummary/ResultBBox
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/FilterBBox
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/BiasPosition
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/FilterCountries
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/MaxResults]))

(s/def :cognitect.aws.location/DeleteGeofenceCollectionResponse (s/keys))

(s/def
  :cognitect.aws.location/DescribeMapResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.DescribeMapResponse/Configuration
     :cognitect.aws.location.DescribeMapResponse/CreateTime
     :cognitect.aws.location.DescribeMapResponse/DataSource
     :cognitect.aws.location.DescribeMapResponse/Description
     :cognitect.aws.location.DescribeMapResponse/MapArn
     :cognitect.aws.location.DescribeMapResponse/MapName
     :cognitect.aws.location.DescribeMapResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesResponse
  (s/keys :req-un [:cognitect.aws.location.BatchEvaluateGeofencesResponse/Errors]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceResponse
  (s/keys :req-un [:cognitect.aws.location.BatchDeleteGeofenceResponse/Errors]))

(s/def
  :cognitect.aws.location/GetDevicePositionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetDevicePositionRequest/DeviceId
     :cognitect.aws.location.GetDevicePositionRequest/TrackerName]))

(s/def
  :cognitect.aws.location/AssociateTrackerConsumerRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.AssociateTrackerConsumerRequest/ConsumerArn
     :cognitect.aws.location.AssociateTrackerConsumerRequest/TrackerName]))

(s/def :cognitect.aws.location/DeletePlaceIndexResponse (s/keys))

(s/def
  :cognitect.aws.location/DevicePosition
  (s/keys
    :req-un
    [:cognitect.aws.location.DevicePosition/Position
     :cognitect.aws.location.DevicePosition/ReceivedTime
     :cognitect.aws.location.DevicePosition/SampleTime]
    :opt-un
    [:cognitect.aws.location.DevicePosition/DeviceId]))

(s/def :cognitect.aws.location/AssociateTrackerConsumerResponse (s/keys))

(s/def
  :cognitect.aws.location/ListGeofencesRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofencesRequest/CollectionName]
    :opt-un
    [:cognitect.aws.location.ListGeofencesRequest/NextToken]))

(s/def
  :cognitect.aws.location/GetMapGlyphsRequestFontUnicodeRangeString
  (s/spec #(re-matches (re-pattern "^[0-9]+-[0-9]+\\.pbf$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/GetMapGlyphsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.location.GetMapGlyphsResponse/ContentType
     :cognitect.aws.location.GetMapGlyphsResponse/Blob]))

(s/def :cognitect.aws.location/DisassociateTrackerConsumerResponse (s/keys))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchGetDevicePositionRequest/DeviceIds
     :cognitect.aws.location.BatchGetDevicePositionRequest/TrackerName]))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionRequestUpdatesList
  (s/coll-of :cognitect.aws.location/DevicePositionUpdate :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchEvaluateGeofencesRequest/CollectionName
     :cognitect.aws.location.BatchEvaluateGeofencesRequest/DevicePositionUpdates]))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.location.ListGeofenceCollectionsRequest/NextToken
     :cognitect.aws.location.ListGeofenceCollectionsRequest/MaxResults]))

(s/def
  :cognitect.aws.location/ListTrackersResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListTrackersResponseEntry/CreateTime
     :cognitect.aws.location.ListTrackersResponseEntry/Description
     :cognitect.aws.location.ListTrackersResponseEntry/TrackerName
     :cognitect.aws.location.ListTrackersResponseEntry/UpdateTime]))

(s/def
  :cognitect.aws.location/GetMapTileResponse
  (s/keys
    :opt-un
    [:cognitect.aws.location.GetMapTileResponse/ContentType
     :cognitect.aws.location.GetMapTileResponse/Blob]))

(s/def
  :cognitect.aws.location/CountryCodeList
  (s/coll-of :cognitect.aws.location/CountryCode :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionErrorList
  (s/coll-of :cognitect.aws.location/BatchUpdateDevicePositionError))

(s/def
  :cognitect.aws.location/SearchForPositionResultList
  (s/coll-of :cognitect.aws.location/SearchForPositionResult))

(s/def
  :cognitect.aws.location/ListTrackersResponseEntryList
  (s/coll-of :cognitect.aws.location/ListTrackersResponseEntry))

(s/def
  :cognitect.aws.location/DevicePositionUpdate
  (s/keys
    :req-un
    [:cognitect.aws.location.DevicePositionUpdate/DeviceId
     :cognitect.aws.location.DevicePositionUpdate/Position
     :cognitect.aws.location.DevicePositionUpdate/SampleTime]))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/DescribeGeofenceCollectionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.DescribeGeofenceCollectionResponse/CollectionArn
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/CollectionName
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/CreateTime
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/Description
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/Arn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn(:[a-z0-9]+([.-][a-z0-9]+)*){2}(:([a-z0-9]+([.-][a-z0-9]+)*)?){2}:([^/].*)?$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.location/MapConfiguration
  (s/keys :req-un [:cognitect.aws.location.MapConfiguration/Style]))

(s/def
  :cognitect.aws.location/BatchPutGeofenceRequestEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceRequestEntry/GeofenceId
     :cognitect.aws.location.BatchPutGeofenceRequestEntry/Geometry]))

(s/def
  :cognitect.aws.location/PlaceGeometry
  (s/keys :opt-un [:cognitect.aws.location.PlaceGeometry/Point]))

(s/def
  :cognitect.aws.location/CreateTrackerRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateTrackerRequest/PricingPlan
     :cognitect.aws.location.CreateTrackerRequest/TrackerName]
    :opt-un
    [:cognitect.aws.location.CreateTrackerRequest/Description]))

(s/def
  :cognitect.aws.location/PricingPlan
  (s/spec
    string?
    :gen
    #(s/gen #{"RequestBasedUsage" "MobileAssetManagement" "MobileAssetTracking"})))

(s/def
  :cognitect.aws.location/ListMapsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.location.ListMapsRequest/NextToken
     :cognitect.aws.location.ListMapsRequest/MaxResults]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForPositionSummary
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionSummary/DataSource
     :cognitect.aws.location.SearchPlaceIndexForPositionSummary/Position]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionSummary/MaxResults]))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchGetDevicePositionError/DeviceId
     :cognitect.aws.location.BatchGetDevicePositionError/Error]))

(s/def
  :cognitect.aws.location/GetDevicePositionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.GetDevicePositionResponse/Position
     :cognitect.aws.location.GetDevicePositionResponse/ReceivedTime
     :cognitect.aws.location.GetDevicePositionResponse/SampleTime]
    :opt-un
    [:cognitect.aws.location.GetDevicePositionResponse/DeviceId]))

(s/def
  :cognitect.aws.location/GetMapSpritesRequestFileNameString
  (s/spec #(re-matches (re-pattern "^sprites(@2x)?\\.(png|json)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/CreateGeofenceCollectionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateGeofenceCollectionRequest/CollectionName
     :cognitect.aws.location.CreateGeofenceCollectionRequest/PricingPlan]
    :opt-un
    [:cognitect.aws.location.CreateGeofenceCollectionRequest/Description]))

(s/def
  :cognitect.aws.location/DescribeMapRequest
  (s/keys :req-un [:cognitect.aws.location.DescribeMapRequest/MapName]))

(s/def
  :cognitect.aws.location/Blob
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.location/BatchPutGeofenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceRequest/CollectionName
     :cognitect.aws.location.BatchPutGeofenceRequest/Entries]))

(s/def
  :cognitect.aws.location/GetMapTileRequestZString
  (s/spec #(re-matches (re-pattern "\\d+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/GetMapStyleDescriptorResponse
  (s/keys
    :opt-un
    [:cognitect.aws.location.GetMapStyleDescriptorResponse/ContentType
     :cognitect.aws.location.GetMapStyleDescriptorResponse/Blob]))

(s/def
  :cognitect.aws.location/BatchPutGeofenceRequestEntriesList
  (s/coll-of :cognitect.aws.location/BatchPutGeofenceRequestEntry :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionRequestTrackerNameString
  (s/spec #(re-matches (re-pattern "^[-._\\w]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/ListMapsResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListMapsResponseEntry/CreateTime
     :cognitect.aws.location.ListMapsResponseEntry/DataSource
     :cognitect.aws.location.ListMapsResponseEntry/Description
     :cognitect.aws.location.ListMapsResponseEntry/MapName
     :cognitect.aws.location.ListMapsResponseEntry/UpdateTime]))

(s/def
  :cognitect.aws.location/SearchForTextResult
  (s/keys :req-un [:cognitect.aws.location.SearchForTextResult/Place]))

(s/def
  :cognitect.aws.location/ListGeofenceResponseEntryList
  (s/coll-of :cognitect.aws.location/ListGeofenceResponseEntry))

(s/def
  :cognitect.aws.location/SearchForPositionResult
  (s/keys :req-un [:cognitect.aws.location.SearchForPositionResult/Place]))

(s/def
  :cognitect.aws.location/DeleteTrackerRequest
  (s/keys :req-un [:cognitect.aws.location.DeleteTrackerRequest/TrackerName]))

(s/def
  :cognitect.aws.location/DataSourceConfiguration
  (s/keys :opt-un [:cognitect.aws.location.DataSourceConfiguration/IntendedUse]))

(s/def
  :cognitect.aws.location/PutGeofenceResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.PutGeofenceResponse/CreateTime
     :cognitect.aws.location.PutGeofenceResponse/GeofenceId
     :cognitect.aws.location.PutGeofenceResponse/UpdateTime]))

(s/def :cognitect.aws.location/Timestamp inst?)

(s/def
  :cognitect.aws.location/Place
  (s/keys
    :req-un
    [:cognitect.aws.location.Place/Geometry]
    :opt-un
    [:cognitect.aws.location.Place/AddressNumber
     :cognitect.aws.location.Place/Neighborhood
     :cognitect.aws.location.Place/Country
     :cognitect.aws.location.Place/PostalCode
     :cognitect.aws.location.Place/Street
     :cognitect.aws.location.Place/SubRegion
     :cognitect.aws.location.Place/Label
     :cognitect.aws.location.Place/Municipality
     :cognitect.aws.location.Place/Region]))

(s/def
  :cognitect.aws.location/ListTrackerConsumersRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.ListTrackerConsumersRequest/TrackerName]
    :opt-un
    [:cognitect.aws.location.ListTrackerConsumersRequest/NextToken
     :cognitect.aws.location.ListTrackerConsumersRequest/MaxResults]))

(s/def
  :cognitect.aws.location/GetMapSpritesRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetMapSpritesRequest/FileName
     :cognitect.aws.location.GetMapSpritesRequest/MapName]))

(s/def :cognitect.aws.location/DeleteTrackerResponse (s/keys))

(s/def
  :cognitect.aws.location/ListGeofencesResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofencesResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListGeofencesResponse/NextToken]))

(s/def
  :cognitect.aws.location/GetDevicePositionHistoryRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetDevicePositionHistoryRequest/DeviceId
     :cognitect.aws.location.GetDevicePositionHistoryRequest/TrackerName]
    :opt-un
    [:cognitect.aws.location.GetDevicePositionHistoryRequest/StartTimeInclusive
     :cognitect.aws.location.GetDevicePositionHistoryRequest/NextToken
     :cognitect.aws.location.GetDevicePositionHistoryRequest/EndTimeExclusive]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchDeleteGeofenceError/Error
     :cognitect.aws.location.BatchDeleteGeofenceError/GeofenceId]))

(s/def
  :cognitect.aws.location/BoundingBox
  (s/coll-of :cognitect.aws.location/Double :min-count 4 :max-count 6))

(s/def
  :cognitect.aws.location/ListMapsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/Double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchUpdateDevicePositionError/DeviceId
     :cognitect.aws.location.BatchUpdateDevicePositionError/Error
     :cognitect.aws.location.BatchUpdateDevicePositionError/SampleTime]))

(s/def
  :cognitect.aws.location/GetGeofenceResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.GetGeofenceResponse/CreateTime
     :cognitect.aws.location.GetGeofenceResponse/GeofenceId
     :cognitect.aws.location.GetGeofenceResponse/Geometry
     :cognitect.aws.location.GetGeofenceResponse/Status
     :cognitect.aws.location.GetGeofenceResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceRequestGeofenceIdsList
  (s/coll-of :cognitect.aws.location/Id :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/Position
  (s/coll-of :cognitect.aws.location/Double :min-count 2 :max-count 2))

(s/def :cognitect.aws.location/SyntheticSearchPlaceIndexForTextSummaryString string?)

(s/def
  :cognitect.aws.location/SyntheticSearchPlaceIndexForTextRequestString
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/BatchPutGeofenceSuccess
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceSuccess/CreateTime
     :cognitect.aws.location.BatchPutGeofenceSuccess/GeofenceId
     :cognitect.aws.location.BatchPutGeofenceSuccess/UpdateTime]))

(s/def
  :cognitect.aws.location/ResourceName
  (s/spec #(re-matches (re-pattern "^[-._\\w]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/GetMapTileRequestXString
  (s/spec #(re-matches (re-pattern "\\d+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/ListMapsResponseEntryList
  (s/coll-of :cognitect.aws.location/ListMapsResponseEntry))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionErrorList
  (s/coll-of :cognitect.aws.location/BatchGetDevicePositionError))

(s/def
  :cognitect.aws.location/ListPlaceIndexesResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListPlaceIndexesResponseEntry/CreateTime
     :cognitect.aws.location.ListPlaceIndexesResponseEntry/DataSource
     :cognitect.aws.location.ListPlaceIndexesResponseEntry/Description
     :cognitect.aws.location.ListPlaceIndexesResponseEntry/IndexName
     :cognitect.aws.location.ListPlaceIndexesResponseEntry/UpdateTime]))

(s/def
  :cognitect.aws.location/ResourceDescription
  (s/spec
    (s/and string? #(<= 0 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.location/String string?)

(s/def
  :cognitect.aws.location/DeleteMapRequest
  (s/keys :req-un [:cognitect.aws.location.DeleteMapRequest/MapName]))

(s/def
  :cognitect.aws.location/DescribePlaceIndexRequest
  (s/keys :req-un [:cognitect.aws.location.DescribePlaceIndexRequest/IndexName]))

(s/def
  :cognitect.aws.location/ListPlaceIndexesResponseEntryList
  (s/coll-of :cognitect.aws.location/ListPlaceIndexesResponseEntry))

(s/def
  :cognitect.aws.location/GetMapTileRequestYString
  (s/spec #(re-matches (re-pattern "\\d+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/ListTrackerConsumersRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/GetDevicePositionHistoryResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.GetDevicePositionHistoryResponse/DevicePositions]
    :opt-un
    [:cognitect.aws.location.GetDevicePositionHistoryResponse/NextToken]))

(s/def
  :cognitect.aws.location.DeleteGeofenceCollectionRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListPlaceIndexesRequest/MaxResults
  :cognitect.aws.location/ListPlaceIndexesRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListPlaceIndexesRequest/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionResponse/CollectionArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionResponse/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DeletePlaceIndexRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionRequest/Updates
  :cognitect.aws.location/BatchUpdateDevicePositionRequestUpdatesList)

(s/def
  :cognitect.aws.location.ListTrackersResponse/Entries
  :cognitect.aws.location/ListTrackersResponseEntryList)

(s/def :cognitect.aws.location.ListTrackersResponse/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.CreatePlaceIndexRequest/DataSource :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.CreatePlaceIndexRequest/DataSourceConfiguration
  :cognitect.aws.location/DataSourceConfiguration)

(s/def
  :cognitect.aws.location.CreatePlaceIndexRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.CreatePlaceIndexRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CreatePlaceIndexRequest/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionRequest/MaxResults
  :cognitect.aws.location/PlaceIndexSearchResultLimit)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionRequest/Position
  :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.BatchPutGeofenceError/Error :cognitect.aws.location/BatchItemError)

(s/def :cognitect.aws.location.BatchPutGeofenceError/GeofenceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.BatchItemError/Code :cognitect.aws.location/BatchItemErrorCode)

(s/def :cognitect.aws.location.BatchItemError/Message :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.GetMapStyleDescriptorRequest/MapName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.CreateTrackerResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.CreateTrackerResponse/TrackerArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.CreateTrackerResponse/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.BatchEvaluateGeofencesError/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesError/Error
  :cognitect.aws.location/BatchItemError)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesError/SampleTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DescribeTrackerResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DescribeTrackerResponse/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.DescribeTrackerResponse/TrackerArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.DescribeTrackerResponse/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.DescribeTrackerResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.BatchDeleteGeofenceRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchDeleteGeofenceRequest/GeofenceIds
  :cognitect.aws.location/BatchDeleteGeofenceRequestGeofenceIdsList)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionResponse/Errors
  :cognitect.aws.location/BatchUpdateDevicePositionErrorList)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponse/Entries
  :cognitect.aws.location/ListGeofenceCollectionsResponseEntryList)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponse/NextToken
  :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.ListGeofenceResponseEntry/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.ListGeofenceResponseEntry/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.ListGeofenceResponseEntry/Geometry
  :cognitect.aws.location/GeofenceGeometry)

(s/def :cognitect.aws.location.ListGeofenceResponseEntry/Status :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListGeofenceResponseEntry/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListTrackersRequest/MaxResults
  :cognitect.aws.location/ListTrackersRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListTrackersRequest/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionResponse/DevicePositions
  :cognitect.aws.location/DevicePositionList)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionResponse/Errors
  :cognitect.aws.location/BatchGetDevicePositionErrorList)

(s/def
  :cognitect.aws.location.CreatePlaceIndexResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.CreatePlaceIndexResponse/IndexArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.CreatePlaceIndexResponse/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.DisassociateTrackerConsumerRequest/ConsumerArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.DisassociateTrackerConsumerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetMapGlyphsRequest/FontStack :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.GetMapGlyphsRequest/FontUnicodeRange
  :cognitect.aws.location/GetMapGlyphsRequestFontUnicodeRangeString)

(s/def :cognitect.aws.location.GetMapGlyphsRequest/MapName :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListTrackerConsumersResponse/ConsumerArns
  :cognitect.aws.location/ArnList)

(s/def :cognitect.aws.location.ListTrackerConsumersResponse/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.PutGeofenceRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.PutGeofenceRequest/GeofenceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.PutGeofenceRequest/Geometry :cognitect.aws.location/GeofenceGeometry)

(s/def
  :cognitect.aws.location.CreateMapRequest/Configuration
  :cognitect.aws.location/MapConfiguration)

(s/def
  :cognitect.aws.location.CreateMapRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.CreateMapRequest/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.CreateMapRequest/PricingPlan :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionResponse/Results
  :cognitect.aws.location/SearchForPositionResultList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionResponse/Summary
  :cognitect.aws.location/SearchPlaceIndexForPositionSummary)

(s/def :cognitect.aws.location.GeofenceGeometry/Polygon :cognitect.aws.location/LinearRings)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/BiasPosition
  :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/FilterBBox
  :cognitect.aws.location/BoundingBox)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/FilterCountries
  :cognitect.aws.location/CountryCodeList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/MaxResults
  :cognitect.aws.location/PlaceIndexSearchResultLimit)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/Text
  :cognitect.aws.location/SyntheticSearchPlaceIndexForTextRequestString)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponse/Entries
  :cognitect.aws.location/ListPlaceIndexesResponseEntryList)

(s/def :cognitect.aws.location.ListPlaceIndexesResponse/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.GetGeofenceRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetGeofenceRequest/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextResponse/Results
  :cognitect.aws.location/SearchForTextResultList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextResponse/Summary
  :cognitect.aws.location/SearchPlaceIndexForTextSummary)

(s/def
  :cognitect.aws.location.BatchPutGeofenceResponse/Errors
  :cognitect.aws.location/BatchPutGeofenceErrorList)

(s/def
  :cognitect.aws.location.BatchPutGeofenceResponse/Successes
  :cognitect.aws.location/BatchPutGeofenceSuccessList)

(s/def :cognitect.aws.location.CreateMapResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.CreateMapResponse/MapArn :cognitect.aws.location/Arn)

(s/def :cognitect.aws.location.CreateMapResponse/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetMapTileRequest/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetMapTileRequest/X :cognitect.aws.location/GetMapTileRequestXString)

(s/def :cognitect.aws.location.GetMapTileRequest/Y :cognitect.aws.location/GetMapTileRequestYString)

(s/def :cognitect.aws.location.GetMapTileRequest/Z :cognitect.aws.location/GetMapTileRequestZString)

(s/def
  :cognitect.aws.location.ListMapsResponse/Entries
  :cognitect.aws.location/ListMapsResponseEntryList)

(s/def :cognitect.aws.location.ListMapsResponse/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.GetMapSpritesResponse/Blob :cognitect.aws.location/Blob)

(s/def :cognitect.aws.location.GetMapSpritesResponse/ContentType :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DescribePlaceIndexResponse/DataSource :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/DataSourceConfiguration
  :cognitect.aws.location/DataSourceConfiguration)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.DescribePlaceIndexResponse/IndexArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DescribeTrackerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/BiasPosition
  :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/FilterBBox
  :cognitect.aws.location/BoundingBox)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/FilterCountries
  :cognitect.aws.location/CountryCodeList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/MaxResults
  :cognitect.aws.location/PlaceIndexSearchResultLimit)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/ResultBBox
  :cognitect.aws.location/BoundingBox)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/Text
  :cognitect.aws.location/SyntheticSearchPlaceIndexForTextSummaryString)

(s/def
  :cognitect.aws.location.DescribeMapResponse/Configuration
  :cognitect.aws.location/MapConfiguration)

(s/def :cognitect.aws.location.DescribeMapResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DescribeMapResponse/DataSource :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.DescribeMapResponse/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.DescribeMapResponse/MapArn :cognitect.aws.location/Arn)

(s/def :cognitect.aws.location.DescribeMapResponse/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.DescribeMapResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesResponse/Errors
  :cognitect.aws.location/BatchEvaluateGeofencesErrorList)

(s/def
  :cognitect.aws.location.BatchDeleteGeofenceResponse/Errors
  :cognitect.aws.location/BatchDeleteGeofenceErrorList)

(s/def :cognitect.aws.location.GetDevicePositionRequest/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.GetDevicePositionRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.AssociateTrackerConsumerRequest/ConsumerArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.AssociateTrackerConsumerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.DevicePosition/DeviceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.DevicePosition/Position :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.DevicePosition/ReceivedTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DevicePosition/SampleTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListGeofencesRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.ListGeofencesRequest/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.GetMapGlyphsResponse/Blob :cognitect.aws.location/Blob)

(s/def :cognitect.aws.location.GetMapGlyphsResponse/ContentType :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionRequest/DeviceIds
  :cognitect.aws.location/BatchGetDevicePositionRequestDeviceIdsList)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionRequest/TrackerName
  :cognitect.aws.location/BatchGetDevicePositionRequestTrackerNameString)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesRequest/DevicePositionUpdates
  :cognitect.aws.location/BatchEvaluateGeofencesRequestDevicePositionUpdatesList)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsRequest/MaxResults
  :cognitect.aws.location/ListGeofenceCollectionsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsRequest/NextToken
  :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.GetMapTileResponse/Blob :cognitect.aws.location/Blob)

(s/def :cognitect.aws.location.GetMapTileResponse/ContentType :cognitect.aws.location/String)

(s/def :cognitect.aws.location.DevicePositionUpdate/DeviceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.DevicePositionUpdate/Position :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.DevicePositionUpdate/SampleTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/CollectionArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.MapConfiguration/Style :cognitect.aws.location/MapStyle)

(s/def :cognitect.aws.location.BatchPutGeofenceRequestEntry/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.BatchPutGeofenceRequestEntry/Geometry
  :cognitect.aws.location/GeofenceGeometry)

(s/def :cognitect.aws.location.PlaceGeometry/Point :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.CreateTrackerRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.CreateTrackerRequest/PricingPlan :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.CreateTrackerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListMapsRequest/MaxResults
  :cognitect.aws.location/ListMapsRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListMapsRequest/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionSummary/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionSummary/MaxResults
  :cognitect.aws.location/PlaceIndexSearchResultLimit)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionSummary/Position
  :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.BatchGetDevicePositionError/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionError/Error
  :cognitect.aws.location/BatchItemError)

(s/def :cognitect.aws.location.GetDevicePositionResponse/DeviceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.GetDevicePositionResponse/Position :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.GetDevicePositionResponse/ReceivedTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.GetDevicePositionResponse/SampleTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionRequest/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def :cognitect.aws.location.DescribeMapRequest/MapName :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchPutGeofenceRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchPutGeofenceRequest/Entries
  :cognitect.aws.location/BatchPutGeofenceRequestEntriesList)

(s/def :cognitect.aws.location.GetMapStyleDescriptorResponse/Blob :cognitect.aws.location/Blob)

(s/def
  :cognitect.aws.location.GetMapStyleDescriptorResponse/ContentType
  :cognitect.aws.location/String)

(s/def :cognitect.aws.location.ListMapsResponseEntry/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.ListMapsResponseEntry/DataSource :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListMapsResponseEntry/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.ListMapsResponseEntry/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.ListMapsResponseEntry/UpdateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.SearchForTextResult/Place :cognitect.aws.location/Place)

(s/def :cognitect.aws.location.SearchForPositionResult/Place :cognitect.aws.location/Place)

(s/def
  :cognitect.aws.location.DeleteTrackerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.DataSourceConfiguration/IntendedUse
  :cognitect.aws.location/IntendedUse)

(s/def :cognitect.aws.location.PutGeofenceResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.PutGeofenceResponse/GeofenceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.PutGeofenceResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.Place/Label :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Municipality :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Neighborhood :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Geometry :cognitect.aws.location/PlaceGeometry)

(s/def :cognitect.aws.location.Place/SubRegion :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Region :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Country :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Street :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/AddressNumber :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/PostalCode :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListTrackerConsumersRequest/MaxResults
  :cognitect.aws.location/ListTrackerConsumersRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListTrackerConsumersRequest/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.ListTrackerConsumersRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.GetMapSpritesRequest/FileName
  :cognitect.aws.location/GetMapSpritesRequestFileNameString)

(s/def :cognitect.aws.location.GetMapSpritesRequest/MapName :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListGeofencesResponse/Entries
  :cognitect.aws.location/ListGeofenceResponseEntryList)

(s/def :cognitect.aws.location.ListGeofencesResponse/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.GetDevicePositionHistoryRequest/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryRequest/EndTimeExclusive
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryRequest/NextToken
  :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryRequest/StartTimeInclusive
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchDeleteGeofenceError/Error
  :cognitect.aws.location/BatchItemError)

(s/def :cognitect.aws.location.BatchDeleteGeofenceError/GeofenceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.BatchUpdateDevicePositionError/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionError/Error
  :cognitect.aws.location/BatchItemError)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionError/SampleTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.GetGeofenceResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.GetGeofenceResponse/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.GetGeofenceResponse/Geometry
  :cognitect.aws.location/GeofenceGeometry)

(s/def :cognitect.aws.location.GetGeofenceResponse/Status :cognitect.aws.location/String)

(s/def :cognitect.aws.location.GetGeofenceResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.BatchPutGeofenceSuccess/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.BatchPutGeofenceSuccess/GeofenceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.BatchPutGeofenceSuccess/UpdateTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DeleteMapRequest/MapName :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.DescribePlaceIndexRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryResponse/DevicePositions
  :cognitect.aws.location/DevicePositionList)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryResponse/NextToken
  :cognitect.aws.location/Token)

