;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.location.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.location/MapStyle
  (s/spec #(re-matches (re-pattern "^[-._\\w]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/DeleteGeofenceCollectionRequest
  (s/keys :req-un [:cognitect.aws.location.DeleteGeofenceCollectionRequest/CollectionName]))

(s/def :cognitect.aws.location/IntendedUse (s/spec string? :gen #(s/gen #{"Storage" "SingleUse"})))

(s/def
  :cognitect.aws.location/BatchPutGeofenceSuccessList
  (s/coll-of :cognitect.aws.location/BatchPutGeofenceSuccess))

(s/def
  :cognitect.aws.location/TruckDimensionsWidthDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/ListPlaceIndexesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.location.ListPlaceIndexesRequest/NextToken
     :cognitect.aws.location.ListPlaceIndexesRequest/MaxResults]))

(s/def
  :cognitect.aws.location/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.TagResourceRequest/ResourceArn
     :cognitect.aws.location.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.location/CreateGeofenceCollectionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateGeofenceCollectionResponse/CollectionArn
     :cognitect.aws.location.CreateGeofenceCollectionResponse/CollectionName
     :cognitect.aws.location.CreateGeofenceCollectionResponse/CreateTime]))

(s/def
  :cognitect.aws.location/ListDevicePositionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListDevicePositionsResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListDevicePositionsResponse/NextToken]))

(s/def
  :cognitect.aws.location/DeletePlaceIndexRequest
  (s/keys :req-un [:cognitect.aws.location.DeletePlaceIndexRequest/IndexName]))

(s/def
  :cognitect.aws.location/ListRouteCalculatorsResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListRouteCalculatorsResponseEntry/CalculatorName
     :cognitect.aws.location.ListRouteCalculatorsResponseEntry/CreateTime
     :cognitect.aws.location.ListRouteCalculatorsResponseEntry/DataSource
     :cognitect.aws.location.ListRouteCalculatorsResponseEntry/Description
     :cognitect.aws.location.ListRouteCalculatorsResponseEntry/UpdateTime]
    :opt-un
    [:cognitect.aws.location.ListRouteCalculatorsResponseEntry/PricingPlan]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForTextRequestTextString
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/DevicePositionList
  (s/coll-of :cognitect.aws.location/DevicePosition))

(s/def
  :cognitect.aws.location/ListGeofencesRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def :cognitect.aws.location/DistanceUnit (s/spec string? :gen #(s/gen #{"Miles" "Kilometers"})))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchUpdateDevicePositionRequest/TrackerName
     :cognitect.aws.location.BatchUpdateDevicePositionRequest/Updates]))

(s/def
  :cognitect.aws.location/ListTrackersResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListTrackersResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListTrackersResponse/NextToken]))

(s/def :cognitect.aws.location/LinearRing (s/coll-of :cognitect.aws.location/Position :min-count 4))

(s/def
  :cognitect.aws.location/TruckWeight
  (s/keys
    :opt-un
    [:cognitect.aws.location.TruckWeight/Unit :cognitect.aws.location.TruckWeight/Total]))

(s/def
  :cognitect.aws.location/LegDurationSecondsDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/CalculateRouteMatrixRequestDeparturePositionsList
  (s/coll-of :cognitect.aws.location/Position :min-count 1 :max-count 350))

(s/def
  :cognitect.aws.location/CreatePlaceIndexRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CreatePlaceIndexRequest/DataSource
     :cognitect.aws.location.CreatePlaceIndexRequest/IndexName]
    :opt-un
    [:cognitect.aws.location.CreatePlaceIndexRequest/DataSourceConfiguration
     :cognitect.aws.location.CreatePlaceIndexRequest/PricingPlan
     :cognitect.aws.location.CreatePlaceIndexRequest/Tags
     :cognitect.aws.location.CreatePlaceIndexRequest/Description]))

(s/def
  :cognitect.aws.location/BatchDeleteDevicePositionHistoryError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchDeleteDevicePositionHistoryError/DeviceId
     :cognitect.aws.location.BatchDeleteDevicePositionHistoryError/Error]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForPositionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionRequest/IndexName
     :cognitect.aws.location.SearchPlaceIndexForPositionRequest/Position]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionRequest/Language
     :cognitect.aws.location.SearchPlaceIndexForPositionRequest/MaxResults]))

(s/def
  :cognitect.aws.location/BatchPutGeofenceError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceError/Error
     :cognitect.aws.location.BatchPutGeofenceError/GeofenceId]))

(s/def
  :cognitect.aws.location/UpdateMapRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdateMapRequest/MapName]
    :opt-un
    [:cognitect.aws.location.UpdateMapRequest/PricingPlan
     :cognitect.aws.location.UpdateMapRequest/Description]))

(s/def :cognitect.aws.location/TravelMode (s/spec string? :gen #(s/gen #{"Car" "Truck" "Walking"})))

(s/def
  :cognitect.aws.location/BatchItemError
  (s/keys
    :opt-un
    [:cognitect.aws.location.BatchItemError/Message :cognitect.aws.location.BatchItemError/Code]))

(s/def
  :cognitect.aws.location/GetMapStyleDescriptorRequest
  (s/keys :req-un [:cognitect.aws.location.GetMapStyleDescriptorRequest/MapName]))

(s/def
  :cognitect.aws.location/CreateTrackerResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateTrackerResponse/CreateTime
     :cognitect.aws.location.CreateTrackerResponse/TrackerArn
     :cognitect.aws.location.CreateTrackerResponse/TrackerName]))

(s/def
  :cognitect.aws.location/Step
  (s/keys
    :req-un
    [:cognitect.aws.location.Step/Distance
     :cognitect.aws.location.Step/DurationSeconds
     :cognitect.aws.location.Step/EndPosition
     :cognitect.aws.location.Step/StartPosition]
    :opt-un
    [:cognitect.aws.location.Step/GeometryOffset]))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchEvaluateGeofencesError/DeviceId
     :cognitect.aws.location.BatchEvaluateGeofencesError/Error
     :cognitect.aws.location.BatchEvaluateGeofencesError/SampleTime]))

(s/def
  :cognitect.aws.location/CalculateRouteMatrixSummary
  (s/keys
    :req-un
    [:cognitect.aws.location.CalculateRouteMatrixSummary/DataSource
     :cognitect.aws.location.CalculateRouteMatrixSummary/DistanceUnit
     :cognitect.aws.location.CalculateRouteMatrixSummary/ErrorCount
     :cognitect.aws.location.CalculateRouteMatrixSummary/RouteCount]))

(s/def
  :cognitect.aws.location/PositionalAccuracy
  (s/keys :req-un [:cognitect.aws.location.PositionalAccuracy/Horizontal]))

(s/def
  :cognitect.aws.location/TagMap
  (s/map-of
    :cognitect.aws.location/TagKey
    :cognitect.aws.location/TagValue
    :min-count
    0
    :max-count
    50))

(s/def
  :cognitect.aws.location/GeoArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn(:[a-z0-9]+([.-][a-z0-9]+)*):geo(:([a-z0-9]+([.-][a-z0-9]+)*))(:[0-9]+):((\\*)|([-a-z]+[/][*-._\\w]+))$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.location/DescribeTrackerResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.DescribeTrackerResponse/CreateTime
     :cognitect.aws.location.DescribeTrackerResponse/Description
     :cognitect.aws.location.DescribeTrackerResponse/TrackerArn
     :cognitect.aws.location.DescribeTrackerResponse/TrackerName
     :cognitect.aws.location.DescribeTrackerResponse/UpdateTime]
    :opt-un
    [:cognitect.aws.location.DescribeTrackerResponse/PricingPlanDataSource
     :cognitect.aws.location.DescribeTrackerResponse/PricingPlan
     :cognitect.aws.location.DescribeTrackerResponse/Tags
     :cognitect.aws.location.DescribeTrackerResponse/KmsKeyId
     :cognitect.aws.location.DescribeTrackerResponse/PositionFiltering]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchDeleteGeofenceRequest/CollectionName
     :cognitect.aws.location.BatchDeleteGeofenceRequest/GeofenceIds]))

(s/def
  :cognitect.aws.location/GetPlaceResponse
  (s/keys :req-un [:cognitect.aws.location.GetPlaceResponse/Place]))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofenceCollectionsResponseEntry/CollectionName
     :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/CreateTime
     :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/Description
     :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/UpdateTime]
    :opt-un
    [:cognitect.aws.location.ListGeofenceCollectionsResponseEntry/PricingPlanDataSource
     :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/PricingPlan]))

(s/def
  :cognitect.aws.location/BatchItemErrorCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ThrottlingError" "ValidationError" "ResourceNotFoundError" "AccessDeniedError"
        "InternalServerError" "ConflictError"})))

(s/def
  :cognitect.aws.location/ListDevicePositionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.ListDevicePositionsRequest/TrackerName]
    :opt-un
    [:cognitect.aws.location.ListDevicePositionsRequest/NextToken
     :cognitect.aws.location.ListDevicePositionsRequest/MaxResults]))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionResponse
  (s/keys :req-un [:cognitect.aws.location.BatchUpdateDevicePositionResponse/Errors]))

(s/def
  :cognitect.aws.location/ListDevicePositionsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def :cognitect.aws.location/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.location/PropertyMapKeyString
  (s/spec
    (s/and string? #(<= 1 (count %) 20))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 20) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/RouteMatrixEntry
  (s/keys
    :opt-un
    [:cognitect.aws.location.RouteMatrixEntry/DurationSeconds
     :cognitect.aws.location.RouteMatrixEntry/Distance
     :cognitect.aws.location.RouteMatrixEntry/Error]))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofenceCollectionsResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListGeofenceCollectionsResponse/NextToken]))

(s/def
  :cognitect.aws.location/PlaceIndexSearchResultLimit
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def :cognitect.aws.location/ArnList (s/coll-of :cognitect.aws.location/Arn))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForSuggestionsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 15)) :gen #(gen/choose 1 15)))

(s/def
  :cognitect.aws.location/CalculateRouteMatrixRequestDestinationPositionsList
  (s/coll-of :cognitect.aws.location/Position :min-count 1 :max-count 350))

(s/def
  :cognitect.aws.location/ListGeofenceResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofenceResponseEntry/CreateTime
     :cognitect.aws.location.ListGeofenceResponseEntry/GeofenceId
     :cognitect.aws.location.ListGeofenceResponseEntry/Geometry
     :cognitect.aws.location.ListGeofenceResponseEntry/Status
     :cognitect.aws.location.ListGeofenceResponseEntry/UpdateTime]))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsResponseEntryList
  (s/coll-of :cognitect.aws.location/ListGeofenceCollectionsResponseEntry))

(s/def
  :cognitect.aws.location/ListTrackersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.location.ListTrackersRequest/NextToken
     :cognitect.aws.location.ListTrackersRequest/MaxResults]))

(s/def
  :cognitect.aws.location/BatchDeleteDevicePositionHistoryResponse
  (s/keys :req-un [:cognitect.aws.location.BatchDeleteDevicePositionHistoryResponse/Errors]))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchGetDevicePositionResponse/DevicePositions
     :cognitect.aws.location.BatchGetDevicePositionResponse/Errors]))

(s/def
  :cognitect.aws.location/ListTrackersRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/CreatePlaceIndexResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CreatePlaceIndexResponse/CreateTime
     :cognitect.aws.location.CreatePlaceIndexResponse/IndexArn
     :cognitect.aws.location.CreatePlaceIndexResponse/IndexName]))

(s/def
  :cognitect.aws.location/UpdateGeofenceCollectionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdateGeofenceCollectionRequest/CollectionName]
    :opt-un
    [:cognitect.aws.location.UpdateGeofenceCollectionRequest/PricingPlanDataSource
     :cognitect.aws.location.UpdateGeofenceCollectionRequest/PricingPlan
     :cognitect.aws.location.UpdateGeofenceCollectionRequest/Description]))

(s/def
  :cognitect.aws.location/ListDevicePositionsResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListDevicePositionsResponseEntry/DeviceId
     :cognitect.aws.location.ListDevicePositionsResponseEntry/Position
     :cognitect.aws.location.ListDevicePositionsResponseEntry/SampleTime]
    :opt-un
    [:cognitect.aws.location.ListDevicePositionsResponseEntry/PositionProperties
     :cognitect.aws.location.ListDevicePositionsResponseEntry/Accuracy]))

(s/def
  :cognitect.aws.location/DisassociateTrackerConsumerRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.DisassociateTrackerConsumerRequest/ConsumerArn
     :cognitect.aws.location.DisassociateTrackerConsumerRequest/TrackerName]))

(s/def
  :cognitect.aws.location/Token
  (s/spec
    (s/and string? #(<= 1 (count %) 2000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/CalculateRouteMatrixSummaryRouteCountInteger
  (s/spec (s/and int? #(<= 1 % 160000)) :gen #(gen/choose 1 160000)))

(s/def
  :cognitect.aws.location/GetMapGlyphsRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetMapGlyphsRequest/FontStack
     :cognitect.aws.location.GetMapGlyphsRequest/FontUnicodeRange
     :cognitect.aws.location.GetMapGlyphsRequest/MapName]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForSuggestionsSummary
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/DataSource
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/Text]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/FilterBBox
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/BiasPosition
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/FilterCountries
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/Language
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/MaxResults]))

(s/def :cognitect.aws.location/RouteMatrix (s/coll-of :cognitect.aws.location/RouteMatrixRow))

(s/def
  :cognitect.aws.location/ListTrackerConsumersResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListTrackerConsumersResponse/ConsumerArns]
    :opt-un
    [:cognitect.aws.location.ListTrackerConsumersResponse/NextToken]))

(s/def
  :cognitect.aws.location/Id
  (s/spec #(re-matches (re-pattern "^[-._\\p{L}\\p{N}]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/ListRouteCalculatorsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/TruckDimensions
  (s/keys
    :opt-un
    [:cognitect.aws.location.TruckDimensions/Unit
     :cognitect.aws.location.TruckDimensions/Length
     :cognitect.aws.location.TruckDimensions/Width
     :cognitect.aws.location.TruckDimensions/Height]))

(s/def
  :cognitect.aws.location/PutGeofenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.PutGeofenceRequest/CollectionName
     :cognitect.aws.location.PutGeofenceRequest/GeofenceId
     :cognitect.aws.location.PutGeofenceRequest/Geometry]))

(s/def :cognitect.aws.location/DeleteMapResponse (s/keys))

(s/def
  :cognitect.aws.location/CreateMapRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateMapRequest/Configuration
     :cognitect.aws.location.CreateMapRequest/MapName]
    :opt-un
    [:cognitect.aws.location.CreateMapRequest/PricingPlan
     :cognitect.aws.location.CreateMapRequest/Tags
     :cognitect.aws.location.CreateMapRequest/Description]))

(s/def
  :cognitect.aws.location/GetDevicePositionHistoryRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/UpdateGeofenceCollectionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdateGeofenceCollectionResponse/CollectionArn
     :cognitect.aws.location.UpdateGeofenceCollectionResponse/CollectionName
     :cognitect.aws.location.UpdateGeofenceCollectionResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/CountryCode
  (s/spec #(re-matches (re-pattern "^[A-Z]{3}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/ListPlaceIndexesRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/CalculateRouteSummary
  (s/keys
    :req-un
    [:cognitect.aws.location.CalculateRouteSummary/DataSource
     :cognitect.aws.location.CalculateRouteSummary/Distance
     :cognitect.aws.location.CalculateRouteSummary/DistanceUnit
     :cognitect.aws.location.CalculateRouteSummary/DurationSeconds
     :cognitect.aws.location.CalculateRouteSummary/RouteBBox]))

(s/def
  :cognitect.aws.location/BatchDeleteDevicePositionHistoryErrorList
  (s/coll-of :cognitect.aws.location/BatchDeleteDevicePositionHistoryError))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForPositionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionResponse/Results
     :cognitect.aws.location.SearchPlaceIndexForPositionResponse/Summary]))

(s/def
  :cognitect.aws.location/ListRouteCalculatorsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.location.ListRouteCalculatorsRequest/NextToken
     :cognitect.aws.location.ListRouteCalculatorsRequest/MaxResults]))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesErrorList
  (s/coll-of :cognitect.aws.location/BatchEvaluateGeofencesError))

(s/def
  :cognitect.aws.location/CalculateRouteRequestWaypointPositionsList
  (s/coll-of :cognitect.aws.location/Position :min-count 0 :max-count 23))

(s/def
  :cognitect.aws.location/SearchForTextResultList
  (s/coll-of :cognitect.aws.location/SearchForTextResult))

(s/def
  :cognitect.aws.location/GeofenceGeometry
  (s/keys
    :opt-un
    [:cognitect.aws.location.GeofenceGeometry/Circle
     :cognitect.aws.location.GeofenceGeometry/Polygon]))

(s/def
  :cognitect.aws.location/TruckDimensionsLengthDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForTextRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForTextRequest/IndexName
     :cognitect.aws.location.SearchPlaceIndexForTextRequest/Text]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForTextRequest/FilterBBox
     :cognitect.aws.location.SearchPlaceIndexForTextRequest/BiasPosition
     :cognitect.aws.location.SearchPlaceIndexForTextRequest/FilterCountries
     :cognitect.aws.location.SearchPlaceIndexForTextRequest/Language
     :cognitect.aws.location.SearchPlaceIndexForTextRequest/MaxResults]))

(s/def
  :cognitect.aws.location/DescribeGeofenceCollectionRequest
  (s/keys :req-un [:cognitect.aws.location.DescribeGeofenceCollectionRequest/CollectionName]))

(s/def
  :cognitect.aws.location/Leg
  (s/keys
    :req-un
    [:cognitect.aws.location.Leg/Distance
     :cognitect.aws.location.Leg/DurationSeconds
     :cognitect.aws.location.Leg/EndPosition
     :cognitect.aws.location.Leg/StartPosition
     :cognitect.aws.location.Leg/Steps]
    :opt-un
    [:cognitect.aws.location.Leg/Geometry]))

(s/def
  :cognitect.aws.location/ListPlaceIndexesResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListPlaceIndexesResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListPlaceIndexesResponse/NextToken]))

(s/def
  :cognitect.aws.location/GetGeofenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetGeofenceRequest/CollectionName
     :cognitect.aws.location.GetGeofenceRequest/GeofenceId]))

(s/def
  :cognitect.aws.location/UpdateRouteCalculatorResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdateRouteCalculatorResponse/CalculatorArn
     :cognitect.aws.location.UpdateRouteCalculatorResponse/CalculatorName
     :cognitect.aws.location.UpdateRouteCalculatorResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/ListRouteCalculatorsResponseEntryList
  (s/coll-of :cognitect.aws.location/ListRouteCalculatorsResponseEntry))

(s/def
  :cognitect.aws.location/DeleteRouteCalculatorRequest
  (s/keys :req-un [:cognitect.aws.location.DeleteRouteCalculatorRequest/CalculatorName]))

(s/def :cognitect.aws.location/DimensionUnit (s/spec string? :gen #(s/gen #{"Meters" "Feet"})))

(s/def :cognitect.aws.location/Boolean boolean?)

(s/def
  :cognitect.aws.location/PropertyMap
  (s/map-of
    :cognitect.aws.location/PropertyMapKeyString
    :cognitect.aws.location/PropertyMapValueString
    :min-count
    0
    :max-count
    3))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForTextResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForTextResponse/Results
     :cognitect.aws.location.SearchPlaceIndexForTextResponse/Summary]))

(s/def
  :cognitect.aws.location/LanguageTag
  (s/spec
    (s/and string? #(<= 2 (count %) 35))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 2 35) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/BatchPutGeofenceResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceResponse/Errors
     :cognitect.aws.location.BatchPutGeofenceResponse/Successes]))

(s/def
  :cognitect.aws.location/PositionFiltering
  (s/spec string? :gen #(s/gen #{"TimeBased" "AccuracyBased" "DistanceBased"})))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionRequestDeviceIdsList
  (s/coll-of :cognitect.aws.location/Id :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/LinearRings
  (s/coll-of :cognitect.aws.location/LinearRing :min-count 1))

(s/def
  :cognitect.aws.location/CreateMapResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateMapResponse/CreateTime
     :cognitect.aws.location.CreateMapResponse/MapArn
     :cognitect.aws.location.CreateMapResponse/MapName]))

(s/def
  :cognitect.aws.location/GetMapTileRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetMapTileRequest/MapName
     :cognitect.aws.location.GetMapTileRequest/X
     :cognitect.aws.location.GetMapTileRequest/Y
     :cognitect.aws.location.GetMapTileRequest/Z]))

(s/def
  :cognitect.aws.location/GetPlaceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetPlaceRequest/IndexName
     :cognitect.aws.location.GetPlaceRequest/PlaceId]
    :opt-un
    [:cognitect.aws.location.GetPlaceRequest/Language]))

(s/def
  :cognitect.aws.location/LegGeometry
  (s/keys :opt-un [:cognitect.aws.location.LegGeometry/LineString]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceErrorList
  (s/coll-of :cognitect.aws.location/BatchDeleteGeofenceError))

(s/def
  :cognitect.aws.location/ListMapsResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListMapsResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListMapsResponse/NextToken]))

(s/def
  :cognitect.aws.location/GetMapSpritesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.location.GetMapSpritesResponse/ContentType
     :cognitect.aws.location.GetMapSpritesResponse/Blob]))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesRequestDevicePositionUpdatesList
  (s/coll-of :cognitect.aws.location/DevicePositionUpdate :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/SearchForSuggestionsResultList
  (s/coll-of :cognitect.aws.location/SearchForSuggestionsResult))

(s/def
  :cognitect.aws.location/DescribePlaceIndexResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.DescribePlaceIndexResponse/CreateTime
     :cognitect.aws.location.DescribePlaceIndexResponse/DataSource
     :cognitect.aws.location.DescribePlaceIndexResponse/DataSourceConfiguration
     :cognitect.aws.location.DescribePlaceIndexResponse/Description
     :cognitect.aws.location.DescribePlaceIndexResponse/IndexArn
     :cognitect.aws.location.DescribePlaceIndexResponse/IndexName
     :cognitect.aws.location.DescribePlaceIndexResponse/UpdateTime]
    :opt-un
    [:cognitect.aws.location.DescribePlaceIndexResponse/PricingPlan
     :cognitect.aws.location.DescribePlaceIndexResponse/Tags]))

(s/def
  :cognitect.aws.location/BatchPutGeofenceErrorList
  (s/coll-of :cognitect.aws.location/BatchPutGeofenceError))

(s/def
  :cognitect.aws.location/SearchForTextResultRelevanceDouble
  (s/spec
    (s/and double? #(<= 0 % 1))
    :gen
    #(gen/double* {:infinite? false, :NaN? false, :min 0, :max 1})))

(s/def
  :cognitect.aws.location/RouteMatrixErrorCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DestinationPositionNotFound" "RouteNotFound" "RouteTooLong" "OtherValidationError"
        "DeparturePositionNotFound" "PositionsNotFound"})))

(s/def
  :cognitect.aws.location/CalculateRouteCarModeOptions
  (s/keys
    :opt-un
    [:cognitect.aws.location.CalculateRouteCarModeOptions/AvoidTolls
     :cognitect.aws.location.CalculateRouteCarModeOptions/AvoidFerries]))

(s/def
  :cognitect.aws.location/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.location/TruckDimensionsHeightDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/LegDistanceDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/RouteMatrixEntryError
  (s/keys
    :req-un
    [:cognitect.aws.location.RouteMatrixEntryError/Code]
    :opt-un
    [:cognitect.aws.location.RouteMatrixEntryError/Message]))

(s/def
  :cognitect.aws.location/TagValue
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9 _=@:.+-/]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/DescribeTrackerRequest
  (s/keys :req-un [:cognitect.aws.location.DescribeTrackerRequest/TrackerName]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForTextSummary
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForTextSummary/DataSource
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/Text]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForTextSummary/ResultBBox
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/FilterBBox
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/BiasPosition
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/FilterCountries
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/Language
     :cognitect.aws.location.SearchPlaceIndexForTextSummary/MaxResults]))

(s/def :cognitect.aws.location/DeleteGeofenceCollectionResponse (s/keys))

(s/def
  :cognitect.aws.location/DescribeMapResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.DescribeMapResponse/Configuration
     :cognitect.aws.location.DescribeMapResponse/CreateTime
     :cognitect.aws.location.DescribeMapResponse/DataSource
     :cognitect.aws.location.DescribeMapResponse/Description
     :cognitect.aws.location.DescribeMapResponse/MapArn
     :cognitect.aws.location.DescribeMapResponse/MapName
     :cognitect.aws.location.DescribeMapResponse/UpdateTime]
    :opt-un
    [:cognitect.aws.location.DescribeMapResponse/PricingPlan
     :cognitect.aws.location.DescribeMapResponse/Tags]))

(s/def
  :cognitect.aws.location/StepGeometryOffsetInteger
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesResponse
  (s/keys :req-un [:cognitect.aws.location.BatchEvaluateGeofencesResponse/Errors]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceResponse
  (s/keys :req-un [:cognitect.aws.location.BatchDeleteGeofenceResponse/Errors]))

(s/def
  :cognitect.aws.location/GetDevicePositionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetDevicePositionRequest/DeviceId
     :cognitect.aws.location.GetDevicePositionRequest/TrackerName]))

(s/def
  :cognitect.aws.location/VehicleWeightUnit
  (s/spec string? :gen #(s/gen #{"Kilograms" "Pounds"})))

(s/def
  :cognitect.aws.location/SearchForTextResultDistanceDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.location.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.location/AssociateTrackerConsumerRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.AssociateTrackerConsumerRequest/ConsumerArn
     :cognitect.aws.location.AssociateTrackerConsumerRequest/TrackerName]))

(s/def :cognitect.aws.location/DeleteRouteCalculatorResponse (s/keys))

(s/def
  :cognitect.aws.location/ListRouteCalculatorsResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListRouteCalculatorsResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListRouteCalculatorsResponse/NextToken]))

(s/def :cognitect.aws.location/DeletePlaceIndexResponse (s/keys))

(s/def
  :cognitect.aws.location/DevicePosition
  (s/keys
    :req-un
    [:cognitect.aws.location.DevicePosition/Position
     :cognitect.aws.location.DevicePosition/ReceivedTime
     :cognitect.aws.location.DevicePosition/SampleTime]
    :opt-un
    [:cognitect.aws.location.DevicePosition/PositionProperties
     :cognitect.aws.location.DevicePosition/DeviceId
     :cognitect.aws.location.DevicePosition/Accuracy]))

(s/def
  :cognitect.aws.location/SearchForSuggestionsResult
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchForSuggestionsResult/Text]
    :opt-un
    [:cognitect.aws.location.SearchForSuggestionsResult/PlaceId]))

(s/def
  :cognitect.aws.location/CalculateRouteMatrixResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CalculateRouteMatrixResponse/RouteMatrix
     :cognitect.aws.location.CalculateRouteMatrixResponse/Summary]
    :opt-un
    [:cognitect.aws.location.CalculateRouteMatrixResponse/SnappedDeparturePositions
     :cognitect.aws.location.CalculateRouteMatrixResponse/SnappedDestinationPositions]))

(s/def :cognitect.aws.location/AssociateTrackerConsumerResponse (s/keys))

(s/def
  :cognitect.aws.location/ListGeofencesRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofencesRequest/CollectionName]
    :opt-un
    [:cognitect.aws.location.ListGeofencesRequest/NextToken
     :cognitect.aws.location.ListGeofencesRequest/MaxResults]))

(s/def
  :cognitect.aws.location/DescribeRouteCalculatorRequest
  (s/keys :req-un [:cognitect.aws.location.DescribeRouteCalculatorRequest/CalculatorName]))

(s/def
  :cognitect.aws.location/GetMapGlyphsRequestFontUnicodeRangeString
  (s/spec #(re-matches (re-pattern "^[0-9]+-[0-9]+\\.pbf$") %) :gen #(gen/string)))

(s/def :cognitect.aws.location/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.location/GetMapGlyphsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.location.GetMapGlyphsResponse/ContentType
     :cognitect.aws.location.GetMapGlyphsResponse/Blob]))

(s/def
  :cognitect.aws.location/RouteMatrixEntryDistanceDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/CalculateRouteRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CalculateRouteRequest/CalculatorName
     :cognitect.aws.location.CalculateRouteRequest/DeparturePosition
     :cognitect.aws.location.CalculateRouteRequest/DestinationPosition]
    :opt-un
    [:cognitect.aws.location.CalculateRouteRequest/DepartureTime
     :cognitect.aws.location.CalculateRouteRequest/TruckModeOptions
     :cognitect.aws.location.CalculateRouteRequest/WaypointPositions
     :cognitect.aws.location.CalculateRouteRequest/IncludeLegGeometry
     :cognitect.aws.location.CalculateRouteRequest/TravelMode
     :cognitect.aws.location.CalculateRouteRequest/DistanceUnit
     :cognitect.aws.location.CalculateRouteRequest/CarModeOptions
     :cognitect.aws.location.CalculateRouteRequest/DepartNow]))

(s/def :cognitect.aws.location/DisassociateTrackerConsumerResponse (s/keys))

(s/def
  :cognitect.aws.location/BatchDeleteDevicePositionHistoryRequestDeviceIdsList
  (s/coll-of :cognitect.aws.location/Id :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchGetDevicePositionRequest/DeviceIds
     :cognitect.aws.location.BatchGetDevicePositionRequest/TrackerName]))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionRequestUpdatesList
  (s/coll-of :cognitect.aws.location/DevicePositionUpdate :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/TimeZone
  (s/keys
    :req-un
    [:cognitect.aws.location.TimeZone/Name]
    :opt-un
    [:cognitect.aws.location.TimeZone/Offset]))

(s/def
  :cognitect.aws.location/UpdateTrackerRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdateTrackerRequest/TrackerName]
    :opt-un
    [:cognitect.aws.location.UpdateTrackerRequest/PricingPlanDataSource
     :cognitect.aws.location.UpdateTrackerRequest/PricingPlan
     :cognitect.aws.location.UpdateTrackerRequest/Description
     :cognitect.aws.location.UpdateTrackerRequest/PositionFiltering]))

(s/def
  :cognitect.aws.location/PositionalAccuracyHorizontalDouble
  (s/spec
    (s/and double? #(<= 0 % 10000))
    :gen
    #(gen/double* {:infinite? false, :NaN? false, :min 0, :max 10000})))

(s/def
  :cognitect.aws.location/BatchEvaluateGeofencesRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchEvaluateGeofencesRequest/CollectionName
     :cognitect.aws.location.BatchEvaluateGeofencesRequest/DevicePositionUpdates]))

(s/def
  :cognitect.aws.location/KmsKeyId
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.location.ListGeofenceCollectionsRequest/NextToken
     :cognitect.aws.location.ListGeofenceCollectionsRequest/MaxResults]))

(s/def
  :cognitect.aws.location/UpdateTrackerResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdateTrackerResponse/TrackerArn
     :cognitect.aws.location.UpdateTrackerResponse/TrackerName
     :cognitect.aws.location.UpdateTrackerResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/CalculateRouteMatrixResponseSnappedDestinationPositionsList
  (s/coll-of :cognitect.aws.location/Position :min-count 1 :max-count 350))

(s/def
  :cognitect.aws.location/DescribeRouteCalculatorResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.DescribeRouteCalculatorResponse/CalculatorArn
     :cognitect.aws.location.DescribeRouteCalculatorResponse/CalculatorName
     :cognitect.aws.location.DescribeRouteCalculatorResponse/CreateTime
     :cognitect.aws.location.DescribeRouteCalculatorResponse/DataSource
     :cognitect.aws.location.DescribeRouteCalculatorResponse/Description
     :cognitect.aws.location.DescribeRouteCalculatorResponse/UpdateTime]
    :opt-un
    [:cognitect.aws.location.DescribeRouteCalculatorResponse/PricingPlan
     :cognitect.aws.location.DescribeRouteCalculatorResponse/Tags]))

(s/def
  :cognitect.aws.location/CalculateRouteMatrixResponseSnappedDeparturePositionsList
  (s/coll-of :cognitect.aws.location/Position :min-count 1 :max-count 350))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForSuggestionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/IndexName
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/Text]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/FilterBBox
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/BiasPosition
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/FilterCountries
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/Language
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/MaxResults]))

(s/def
  :cognitect.aws.location/ListTrackersResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListTrackersResponseEntry/CreateTime
     :cognitect.aws.location.ListTrackersResponseEntry/Description
     :cognitect.aws.location.ListTrackersResponseEntry/TrackerName
     :cognitect.aws.location.ListTrackersResponseEntry/UpdateTime]
    :opt-un
    [:cognitect.aws.location.ListTrackersResponseEntry/PricingPlanDataSource
     :cognitect.aws.location.ListTrackersResponseEntry/PricingPlan]))

(s/def
  :cognitect.aws.location/GetMapTileResponse
  (s/keys
    :opt-un
    [:cognitect.aws.location.GetMapTileResponse/ContentType
     :cognitect.aws.location.GetMapTileResponse/Blob]))

(s/def
  :cognitect.aws.location/CountryCodeList
  (s/coll-of :cognitect.aws.location/CountryCode :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.location/CalculateRouteResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CalculateRouteResponse/Legs
     :cognitect.aws.location.CalculateRouteResponse/Summary]))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionErrorList
  (s/coll-of :cognitect.aws.location/BatchUpdateDevicePositionError))

(s/def
  :cognitect.aws.location/RouteMatrixEntryDurationSecondsDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/SearchForPositionResultList
  (s/coll-of :cognitect.aws.location/SearchForPositionResult))

(s/def
  :cognitect.aws.location/ListTrackersResponseEntryList
  (s/coll-of :cognitect.aws.location/ListTrackersResponseEntry))

(s/def :cognitect.aws.location/PlaceId string?)

(s/def
  :cognitect.aws.location/DevicePositionUpdate
  (s/keys
    :req-un
    [:cognitect.aws.location.DevicePositionUpdate/DeviceId
     :cognitect.aws.location.DevicePositionUpdate/Position
     :cognitect.aws.location.DevicePositionUpdate/SampleTime]
    :opt-un
    [:cognitect.aws.location.DevicePositionUpdate/PositionProperties
     :cognitect.aws.location.DevicePositionUpdate/Accuracy]))

(s/def
  :cognitect.aws.location/UpdatePlaceIndexRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdatePlaceIndexRequest/IndexName]
    :opt-un
    [:cognitect.aws.location.UpdatePlaceIndexRequest/DataSourceConfiguration
     :cognitect.aws.location.UpdatePlaceIndexRequest/PricingPlan
     :cognitect.aws.location.UpdatePlaceIndexRequest/Description]))

(s/def
  :cognitect.aws.location/ListGeofenceCollectionsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/PropertyMapValueString
  (s/spec
    (s/and string? #(<= 1 (count %) 40))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 40) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/ListDevicePositionsResponseEntryList
  (s/coll-of :cognitect.aws.location/ListDevicePositionsResponseEntry))

(s/def
  :cognitect.aws.location/DescribeGeofenceCollectionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.DescribeGeofenceCollectionResponse/CollectionArn
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/CollectionName
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/CreateTime
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/Description
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/UpdateTime]
    :opt-un
    [:cognitect.aws.location.DescribeGeofenceCollectionResponse/PricingPlanDataSource
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/PricingPlan
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/Tags
     :cognitect.aws.location.DescribeGeofenceCollectionResponse/KmsKeyId]))

(s/def
  :cognitect.aws.location/CalculateRouteMatrixRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CalculateRouteMatrixRequest/CalculatorName
     :cognitect.aws.location.CalculateRouteMatrixRequest/DeparturePositions
     :cognitect.aws.location.CalculateRouteMatrixRequest/DestinationPositions]
    :opt-un
    [:cognitect.aws.location.CalculateRouteMatrixRequest/DepartureTime
     :cognitect.aws.location.CalculateRouteMatrixRequest/TruckModeOptions
     :cognitect.aws.location.CalculateRouteMatrixRequest/TravelMode
     :cognitect.aws.location.CalculateRouteMatrixRequest/DistanceUnit
     :cognitect.aws.location.CalculateRouteMatrixRequest/CarModeOptions
     :cognitect.aws.location.CalculateRouteMatrixRequest/DepartNow]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForSuggestionsRequestTextString
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/UpdateRouteCalculatorRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdateRouteCalculatorRequest/CalculatorName]
    :opt-un
    [:cognitect.aws.location.UpdateRouteCalculatorRequest/PricingPlan
     :cognitect.aws.location.UpdateRouteCalculatorRequest/Description]))

(s/def
  :cognitect.aws.location/Arn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn(:[a-z0-9]+([.-][a-z0-9]+)*){2}(:([a-z0-9]+([.-][a-z0-9]+)*)?){2}:([^/].*)?$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.location/MapConfiguration
  (s/keys :req-un [:cognitect.aws.location.MapConfiguration/Style]))

(s/def
  :cognitect.aws.location/CalculateRouteMatrixSummaryErrorCountInteger
  (s/spec (s/and int? #(<= 1 % 160000)) :gen #(gen/choose 1 160000)))

(s/def
  :cognitect.aws.location/BatchPutGeofenceRequestEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceRequestEntry/GeofenceId
     :cognitect.aws.location.BatchPutGeofenceRequestEntry/Geometry]))

(s/def
  :cognitect.aws.location/PlaceGeometry
  (s/keys :opt-un [:cognitect.aws.location.PlaceGeometry/Point]))

(s/def
  :cognitect.aws.location/CreateTrackerRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateTrackerRequest/TrackerName]
    :opt-un
    [:cognitect.aws.location.CreateTrackerRequest/PricingPlanDataSource
     :cognitect.aws.location.CreateTrackerRequest/PricingPlan
     :cognitect.aws.location.CreateTrackerRequest/Tags
     :cognitect.aws.location.CreateTrackerRequest/Description
     :cognitect.aws.location.CreateTrackerRequest/KmsKeyId
     :cognitect.aws.location.CreateTrackerRequest/PositionFiltering]))

(s/def
  :cognitect.aws.location/PricingPlan
  (s/spec
    string?
    :gen
    #(s/gen #{"RequestBasedUsage" "MobileAssetManagement" "MobileAssetTracking"})))

(s/def :cognitect.aws.location/LegList (s/coll-of :cognitect.aws.location/Leg))

(s/def
  :cognitect.aws.location/ListMapsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.location.ListMapsRequest/NextToken
     :cognitect.aws.location.ListMapsRequest/MaxResults]))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForPositionSummary
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionSummary/DataSource
     :cognitect.aws.location.SearchPlaceIndexForPositionSummary/Position]
    :opt-un
    [:cognitect.aws.location.SearchPlaceIndexForPositionSummary/Language
     :cognitect.aws.location.SearchPlaceIndexForPositionSummary/MaxResults]))

(s/def :cognitect.aws.location/StepList (s/coll-of :cognitect.aws.location/Step))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchGetDevicePositionError/DeviceId
     :cognitect.aws.location.BatchGetDevicePositionError/Error]))

(s/def
  :cognitect.aws.location/StepDurationSecondsDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/GetDevicePositionResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.GetDevicePositionResponse/Position
     :cognitect.aws.location.GetDevicePositionResponse/ReceivedTime
     :cognitect.aws.location.GetDevicePositionResponse/SampleTime]
    :opt-un
    [:cognitect.aws.location.GetDevicePositionResponse/PositionProperties
     :cognitect.aws.location.GetDevicePositionResponse/DeviceId
     :cognitect.aws.location.GetDevicePositionResponse/Accuracy]))

(s/def
  :cognitect.aws.location/GetMapSpritesRequestFileNameString
  (s/spec #(re-matches (re-pattern "^sprites(@2x)?\\.(png|json)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/CreateGeofenceCollectionRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateGeofenceCollectionRequest/CollectionName]
    :opt-un
    [:cognitect.aws.location.CreateGeofenceCollectionRequest/PricingPlanDataSource
     :cognitect.aws.location.CreateGeofenceCollectionRequest/PricingPlan
     :cognitect.aws.location.CreateGeofenceCollectionRequest/Tags
     :cognitect.aws.location.CreateGeofenceCollectionRequest/Description
     :cognitect.aws.location.CreateGeofenceCollectionRequest/KmsKeyId]))

(s/def
  :cognitect.aws.location/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.UntagResourceRequest/ResourceArn
     :cognitect.aws.location.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.location/TagKey
  (s/spec #(re-matches (re-pattern "^[a-zA-Z+-=._:/]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/CalculateRouteSummaryDistanceDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/CreateRouteCalculatorRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateRouteCalculatorRequest/CalculatorName
     :cognitect.aws.location.CreateRouteCalculatorRequest/DataSource]
    :opt-un
    [:cognitect.aws.location.CreateRouteCalculatorRequest/PricingPlan
     :cognitect.aws.location.CreateRouteCalculatorRequest/Tags
     :cognitect.aws.location.CreateRouteCalculatorRequest/Description]))

(s/def
  :cognitect.aws.location/DescribeMapRequest
  (s/keys :req-un [:cognitect.aws.location.DescribeMapRequest/MapName]))

(s/def
  :cognitect.aws.location/Blob
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.location/BatchPutGeofenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceRequest/CollectionName
     :cognitect.aws.location.BatchPutGeofenceRequest/Entries]))

(s/def
  :cognitect.aws.location/GetMapTileRequestZString
  (s/spec #(re-matches (re-pattern "\\d+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/GetMapStyleDescriptorResponse
  (s/keys
    :opt-un
    [:cognitect.aws.location.GetMapStyleDescriptorResponse/ContentType
     :cognitect.aws.location.GetMapStyleDescriptorResponse/Blob]))

(s/def
  :cognitect.aws.location/BatchPutGeofenceRequestEntriesList
  (s/coll-of :cognitect.aws.location/BatchPutGeofenceRequestEntry :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionRequestTrackerNameString
  (s/spec #(re-matches (re-pattern "^[-._\\w]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/ListMapsResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListMapsResponseEntry/CreateTime
     :cognitect.aws.location.ListMapsResponseEntry/DataSource
     :cognitect.aws.location.ListMapsResponseEntry/Description
     :cognitect.aws.location.ListMapsResponseEntry/MapName
     :cognitect.aws.location.ListMapsResponseEntry/UpdateTime]
    :opt-un
    [:cognitect.aws.location.ListMapsResponseEntry/PricingPlan]))

(s/def
  :cognitect.aws.location/SearchForTextResult
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchForTextResult/Place]
    :opt-un
    [:cognitect.aws.location.SearchForTextResult/PlaceId
     :cognitect.aws.location.SearchForTextResult/Distance
     :cognitect.aws.location.SearchForTextResult/Relevance]))

(s/def
  :cognitect.aws.location/ListGeofenceResponseEntryList
  (s/coll-of :cognitect.aws.location/ListGeofenceResponseEntry))

(s/def
  :cognitect.aws.location/SearchForPositionResult
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchForPositionResult/Distance
     :cognitect.aws.location.SearchForPositionResult/Place]
    :opt-un
    [:cognitect.aws.location.SearchForPositionResult/PlaceId]))

(s/def
  :cognitect.aws.location/DeleteTrackerRequest
  (s/keys :req-un [:cognitect.aws.location.DeleteTrackerRequest/TrackerName]))

(s/def
  :cognitect.aws.location/DataSourceConfiguration
  (s/keys :opt-un [:cognitect.aws.location.DataSourceConfiguration/IntendedUse]))

(s/def
  :cognitect.aws.location/PutGeofenceResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.PutGeofenceResponse/CreateTime
     :cognitect.aws.location.PutGeofenceResponse/GeofenceId
     :cognitect.aws.location.PutGeofenceResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/UpdatePlaceIndexResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdatePlaceIndexResponse/IndexArn
     :cognitect.aws.location.UpdatePlaceIndexResponse/IndexName
     :cognitect.aws.location.UpdatePlaceIndexResponse/UpdateTime]))

(s/def :cognitect.aws.location/Timestamp inst?)

(s/def
  :cognitect.aws.location/Place
  (s/keys
    :req-un
    [:cognitect.aws.location.Place/Geometry]
    :opt-un
    [:cognitect.aws.location.Place/AddressNumber
     :cognitect.aws.location.Place/Neighborhood
     :cognitect.aws.location.Place/Country
     :cognitect.aws.location.Place/PostalCode
     :cognitect.aws.location.Place/TimeZone
     :cognitect.aws.location.Place/Street
     :cognitect.aws.location.Place/UnitType
     :cognitect.aws.location.Place/UnitNumber
     :cognitect.aws.location.Place/SubRegion
     :cognitect.aws.location.Place/Label
     :cognitect.aws.location.Place/Municipality
     :cognitect.aws.location.Place/Interpolated
     :cognitect.aws.location.Place/Region]))

(s/def
  :cognitect.aws.location/StepDistanceDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/ListTrackerConsumersRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.ListTrackerConsumersRequest/TrackerName]
    :opt-un
    [:cognitect.aws.location.ListTrackerConsumersRequest/NextToken
     :cognitect.aws.location.ListTrackerConsumersRequest/MaxResults]))

(s/def
  :cognitect.aws.location/GetMapSpritesRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetMapSpritesRequest/FileName
     :cognitect.aws.location.GetMapSpritesRequest/MapName]))

(s/def
  :cognitect.aws.location/CalculateRouteSummaryDurationSecondsDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def :cognitect.aws.location/DeleteTrackerResponse (s/keys))

(s/def
  :cognitect.aws.location/UpdateMapResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.UpdateMapResponse/MapArn
     :cognitect.aws.location.UpdateMapResponse/MapName
     :cognitect.aws.location.UpdateMapResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/ListGeofencesResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.ListGeofencesResponse/Entries]
    :opt-un
    [:cognitect.aws.location.ListGeofencesResponse/NextToken]))

(s/def :cognitect.aws.location/RouteMatrixRow (s/coll-of :cognitect.aws.location/RouteMatrixEntry))

(s/def
  :cognitect.aws.location/TruckWeightTotalDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/GetDevicePositionHistoryRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.GetDevicePositionHistoryRequest/DeviceId
     :cognitect.aws.location.GetDevicePositionHistoryRequest/TrackerName]
    :opt-un
    [:cognitect.aws.location.GetDevicePositionHistoryRequest/StartTimeInclusive
     :cognitect.aws.location.GetDevicePositionHistoryRequest/NextToken
     :cognitect.aws.location.GetDevicePositionHistoryRequest/EndTimeExclusive
     :cognitect.aws.location.GetDevicePositionHistoryRequest/MaxResults]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchDeleteGeofenceError/Error
     :cognitect.aws.location.BatchDeleteGeofenceError/GeofenceId]))

(s/def
  :cognitect.aws.location/CreateRouteCalculatorResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.CreateRouteCalculatorResponse/CalculatorArn
     :cognitect.aws.location.CreateRouteCalculatorResponse/CalculatorName
     :cognitect.aws.location.CreateRouteCalculatorResponse/CreateTime]))

(s/def
  :cognitect.aws.location/BoundingBox
  (s/coll-of :cognitect.aws.location/Double :min-count 4 :max-count 4))

(s/def
  :cognitect.aws.location/ListMapsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.location/TagKeys
  (s/coll-of :cognitect.aws.location/String :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.location/Double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.location/BatchUpdateDevicePositionError
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchUpdateDevicePositionError/DeviceId
     :cognitect.aws.location.BatchUpdateDevicePositionError/Error
     :cognitect.aws.location.BatchUpdateDevicePositionError/SampleTime]))

(s/def
  :cognitect.aws.location/GetGeofenceResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.GetGeofenceResponse/CreateTime
     :cognitect.aws.location.GetGeofenceResponse/GeofenceId
     :cognitect.aws.location.GetGeofenceResponse/Geometry
     :cognitect.aws.location.GetGeofenceResponse/Status
     :cognitect.aws.location.GetGeofenceResponse/UpdateTime]))

(s/def
  :cognitect.aws.location/BatchDeleteGeofenceRequestGeofenceIdsList
  (s/coll-of :cognitect.aws.location/Id :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.location/Position
  (s/coll-of :cognitect.aws.location/Double :min-count 2 :max-count 2))

(s/def
  :cognitect.aws.location/CalculateRouteTruckModeOptions
  (s/keys
    :opt-un
    [:cognitect.aws.location.CalculateRouteTruckModeOptions/AvoidTolls
     :cognitect.aws.location.CalculateRouteTruckModeOptions/AvoidFerries
     :cognitect.aws.location.CalculateRouteTruckModeOptions/Weight
     :cognitect.aws.location.CalculateRouteTruckModeOptions/Dimensions]))

(s/def
  :cognitect.aws.location/BatchDeleteDevicePositionHistoryRequest
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchDeleteDevicePositionHistoryRequest/DeviceIds
     :cognitect.aws.location.BatchDeleteDevicePositionHistoryRequest/TrackerName]))

(s/def
  :cognitect.aws.location/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.location.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.location/BatchPutGeofenceSuccess
  (s/keys
    :req-un
    [:cognitect.aws.location.BatchPutGeofenceSuccess/CreateTime
     :cognitect.aws.location.BatchPutGeofenceSuccess/GeofenceId
     :cognitect.aws.location.BatchPutGeofenceSuccess/UpdateTime]))

(s/def
  :cognitect.aws.location/ResourceName
  (s/spec #(re-matches (re-pattern "^[-._\\w]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.location/LineString (s/coll-of :cognitect.aws.location/Position :min-count 2))

(s/def
  :cognitect.aws.location/GetMapTileRequestXString
  (s/spec #(re-matches (re-pattern "\\d+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/ListMapsResponseEntryList
  (s/coll-of :cognitect.aws.location/ListMapsResponseEntry))

(s/def
  :cognitect.aws.location/Circle
  (s/keys :req-un [:cognitect.aws.location.Circle/Center :cognitect.aws.location.Circle/Radius]))

(s/def
  :cognitect.aws.location/BatchGetDevicePositionErrorList
  (s/coll-of :cognitect.aws.location/BatchGetDevicePositionError))

(s/def
  :cognitect.aws.location/ListPlaceIndexesResponseEntry
  (s/keys
    :req-un
    [:cognitect.aws.location.ListPlaceIndexesResponseEntry/CreateTime
     :cognitect.aws.location.ListPlaceIndexesResponseEntry/DataSource
     :cognitect.aws.location.ListPlaceIndexesResponseEntry/Description
     :cognitect.aws.location.ListPlaceIndexesResponseEntry/IndexName
     :cognitect.aws.location.ListPlaceIndexesResponseEntry/UpdateTime]
    :opt-un
    [:cognitect.aws.location.ListPlaceIndexesResponseEntry/PricingPlan]))

(s/def
  :cognitect.aws.location/ResourceDescription
  (s/spec
    (s/and string? #(<= 0 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.location/SearchPlaceIndexForSuggestionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.SearchPlaceIndexForSuggestionsResponse/Results
     :cognitect.aws.location.SearchPlaceIndexForSuggestionsResponse/Summary]))

(s/def :cognitect.aws.location/String string?)

(s/def
  :cognitect.aws.location/DeleteMapRequest
  (s/keys :req-un [:cognitect.aws.location.DeleteMapRequest/MapName]))

(s/def
  :cognitect.aws.location/SearchForPositionResultDistanceDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.location/DescribePlaceIndexRequest
  (s/keys :req-un [:cognitect.aws.location.DescribePlaceIndexRequest/IndexName]))

(s/def
  :cognitect.aws.location/ListPlaceIndexesResponseEntryList
  (s/coll-of :cognitect.aws.location/ListPlaceIndexesResponseEntry))

(s/def
  :cognitect.aws.location/GetMapTileRequestYString
  (s/spec #(re-matches (re-pattern "\\d+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.location/ListTrackerConsumersRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def :cognitect.aws.location/SensitiveString string?)

(s/def
  :cognitect.aws.location/GetDevicePositionHistoryResponse
  (s/keys
    :req-un
    [:cognitect.aws.location.GetDevicePositionHistoryResponse/DevicePositions]
    :opt-un
    [:cognitect.aws.location.GetDevicePositionHistoryResponse/NextToken]))

(s/def
  :cognitect.aws.location.DeleteGeofenceCollectionRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListPlaceIndexesRequest/MaxResults
  :cognitect.aws.location/ListPlaceIndexesRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListPlaceIndexesRequest/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.TagResourceRequest/ResourceArn :cognitect.aws.location/Arn)

(s/def :cognitect.aws.location.TagResourceRequest/Tags :cognitect.aws.location/TagMap)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionResponse/CollectionArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionResponse/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListDevicePositionsResponse/Entries
  :cognitect.aws.location/ListDevicePositionsResponseEntryList)

(s/def :cognitect.aws.location.ListDevicePositionsResponse/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.DeletePlaceIndexRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListRouteCalculatorsResponseEntry/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListRouteCalculatorsResponseEntry/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListRouteCalculatorsResponseEntry/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListRouteCalculatorsResponseEntry/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.ListRouteCalculatorsResponseEntry/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.ListRouteCalculatorsResponseEntry/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionRequest/Updates
  :cognitect.aws.location/BatchUpdateDevicePositionRequestUpdatesList)

(s/def
  :cognitect.aws.location.ListTrackersResponse/Entries
  :cognitect.aws.location/ListTrackersResponseEntryList)

(s/def :cognitect.aws.location.ListTrackersResponse/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.TruckWeight/Total :cognitect.aws.location/TruckWeightTotalDouble)

(s/def :cognitect.aws.location.TruckWeight/Unit :cognitect.aws.location/VehicleWeightUnit)

(s/def :cognitect.aws.location.CreatePlaceIndexRequest/DataSource :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.CreatePlaceIndexRequest/DataSourceConfiguration
  :cognitect.aws.location/DataSourceConfiguration)

(s/def
  :cognitect.aws.location.CreatePlaceIndexRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.CreatePlaceIndexRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CreatePlaceIndexRequest/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def :cognitect.aws.location.CreatePlaceIndexRequest/Tags :cognitect.aws.location/TagMap)

(s/def
  :cognitect.aws.location.BatchDeleteDevicePositionHistoryError/DeviceId
  :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.BatchDeleteDevicePositionHistoryError/Error
  :cognitect.aws.location/BatchItemError)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionRequest/Language
  :cognitect.aws.location/LanguageTag)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionRequest/MaxResults
  :cognitect.aws.location/PlaceIndexSearchResultLimit)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionRequest/Position
  :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.BatchPutGeofenceError/Error :cognitect.aws.location/BatchItemError)

(s/def :cognitect.aws.location.BatchPutGeofenceError/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.UpdateMapRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.UpdateMapRequest/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.UpdateMapRequest/PricingPlan :cognitect.aws.location/PricingPlan)

(s/def :cognitect.aws.location.BatchItemError/Code :cognitect.aws.location/BatchItemErrorCode)

(s/def :cognitect.aws.location.BatchItemError/Message :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.GetMapStyleDescriptorRequest/MapName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.CreateTrackerResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.CreateTrackerResponse/TrackerArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.CreateTrackerResponse/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.Step/Distance :cognitect.aws.location/StepDistanceDouble)

(s/def
  :cognitect.aws.location.Step/DurationSeconds
  :cognitect.aws.location/StepDurationSecondsDouble)

(s/def :cognitect.aws.location.Step/EndPosition :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.Step/GeometryOffset
  :cognitect.aws.location/StepGeometryOffsetInteger)

(s/def :cognitect.aws.location.Step/StartPosition :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.BatchEvaluateGeofencesError/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesError/Error
  :cognitect.aws.location/BatchItemError)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesError/SampleTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixSummary/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixSummary/DistanceUnit
  :cognitect.aws.location/DistanceUnit)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixSummary/ErrorCount
  :cognitect.aws.location/CalculateRouteMatrixSummaryErrorCountInteger)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixSummary/RouteCount
  :cognitect.aws.location/CalculateRouteMatrixSummaryRouteCountInteger)

(s/def
  :cognitect.aws.location.PositionalAccuracy/Horizontal
  :cognitect.aws.location/PositionalAccuracyHorizontalDouble)

(s/def :cognitect.aws.location.DescribeTrackerResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DescribeTrackerResponse/Tags :cognitect.aws.location/TagMap)

(s/def
  :cognitect.aws.location.DescribeTrackerResponse/PositionFiltering
  :cognitect.aws.location/PositionFiltering)

(s/def
  :cognitect.aws.location.DescribeTrackerResponse/PricingPlanDataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.DescribeTrackerResponse/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.DescribeTrackerResponse/KmsKeyId :cognitect.aws.location/KmsKeyId)

(s/def
  :cognitect.aws.location.DescribeTrackerResponse/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.DescribeTrackerResponse/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.DescribeTrackerResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DescribeTrackerResponse/TrackerArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.BatchDeleteGeofenceRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchDeleteGeofenceRequest/GeofenceIds
  :cognitect.aws.location/BatchDeleteGeofenceRequestGeofenceIdsList)

(s/def :cognitect.aws.location.GetPlaceResponse/Place :cognitect.aws.location/Place)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/PricingPlanDataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponseEntry/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListDevicePositionsRequest/MaxResults
  :cognitect.aws.location/ListDevicePositionsRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListDevicePositionsRequest/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.ListDevicePositionsRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionResponse/Errors
  :cognitect.aws.location/BatchUpdateDevicePositionErrorList)

(s/def
  :cognitect.aws.location.RouteMatrixEntry/Distance
  :cognitect.aws.location/RouteMatrixEntryDistanceDouble)

(s/def
  :cognitect.aws.location.RouteMatrixEntry/DurationSeconds
  :cognitect.aws.location/RouteMatrixEntryDurationSecondsDouble)

(s/def :cognitect.aws.location.RouteMatrixEntry/Error :cognitect.aws.location/RouteMatrixEntryError)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponse/Entries
  :cognitect.aws.location/ListGeofenceCollectionsResponseEntryList)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsResponse/NextToken
  :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.ListGeofenceResponseEntry/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.ListGeofenceResponseEntry/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.ListGeofenceResponseEntry/Geometry
  :cognitect.aws.location/GeofenceGeometry)

(s/def :cognitect.aws.location.ListGeofenceResponseEntry/Status :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListGeofenceResponseEntry/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListTrackersRequest/MaxResults
  :cognitect.aws.location/ListTrackersRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListTrackersRequest/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.BatchDeleteDevicePositionHistoryResponse/Errors
  :cognitect.aws.location/BatchDeleteDevicePositionHistoryErrorList)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionResponse/DevicePositions
  :cognitect.aws.location/DevicePositionList)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionResponse/Errors
  :cognitect.aws.location/BatchGetDevicePositionErrorList)

(s/def
  :cognitect.aws.location.CreatePlaceIndexResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.CreatePlaceIndexResponse/IndexArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.CreatePlaceIndexResponse/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.UpdateGeofenceCollectionRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.UpdateGeofenceCollectionRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.UpdateGeofenceCollectionRequest/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.UpdateGeofenceCollectionRequest/PricingPlanDataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListDevicePositionsResponseEntry/Accuracy
  :cognitect.aws.location/PositionalAccuracy)

(s/def :cognitect.aws.location.ListDevicePositionsResponseEntry/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.ListDevicePositionsResponseEntry/Position
  :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.ListDevicePositionsResponseEntry/PositionProperties
  :cognitect.aws.location/PropertyMap)

(s/def
  :cognitect.aws.location.ListDevicePositionsResponseEntry/SampleTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DisassociateTrackerConsumerRequest/ConsumerArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.DisassociateTrackerConsumerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetMapGlyphsRequest/FontStack :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.GetMapGlyphsRequest/FontUnicodeRange
  :cognitect.aws.location/GetMapGlyphsRequestFontUnicodeRangeString)

(s/def :cognitect.aws.location.GetMapGlyphsRequest/MapName :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/BiasPosition
  :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/FilterBBox
  :cognitect.aws.location/BoundingBox)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/FilterCountries
  :cognitect.aws.location/CountryCodeList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/Language
  :cognitect.aws.location/LanguageTag)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/MaxResults
  :cognitect.aws.location/Integer)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsSummary/Text
  :cognitect.aws.location/SensitiveString)

(s/def
  :cognitect.aws.location.ListTrackerConsumersResponse/ConsumerArns
  :cognitect.aws.location/ArnList)

(s/def :cognitect.aws.location.ListTrackerConsumersResponse/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.TruckDimensions/Height
  :cognitect.aws.location/TruckDimensionsHeightDouble)

(s/def
  :cognitect.aws.location.TruckDimensions/Length
  :cognitect.aws.location/TruckDimensionsLengthDouble)

(s/def :cognitect.aws.location.TruckDimensions/Unit :cognitect.aws.location/DimensionUnit)

(s/def
  :cognitect.aws.location.TruckDimensions/Width
  :cognitect.aws.location/TruckDimensionsWidthDouble)

(s/def
  :cognitect.aws.location.PutGeofenceRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.PutGeofenceRequest/GeofenceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.PutGeofenceRequest/Geometry :cognitect.aws.location/GeofenceGeometry)

(s/def
  :cognitect.aws.location.CreateMapRequest/Configuration
  :cognitect.aws.location/MapConfiguration)

(s/def
  :cognitect.aws.location.CreateMapRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.CreateMapRequest/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.CreateMapRequest/PricingPlan :cognitect.aws.location/PricingPlan)

(s/def :cognitect.aws.location.CreateMapRequest/Tags :cognitect.aws.location/TagMap)

(s/def
  :cognitect.aws.location.UpdateGeofenceCollectionResponse/CollectionArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.UpdateGeofenceCollectionResponse/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.UpdateGeofenceCollectionResponse/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.CalculateRouteSummary/DataSource :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.CalculateRouteSummary/Distance
  :cognitect.aws.location/CalculateRouteSummaryDistanceDouble)

(s/def
  :cognitect.aws.location.CalculateRouteSummary/DistanceUnit
  :cognitect.aws.location/DistanceUnit)

(s/def
  :cognitect.aws.location.CalculateRouteSummary/DurationSeconds
  :cognitect.aws.location/CalculateRouteSummaryDurationSecondsDouble)

(s/def :cognitect.aws.location.CalculateRouteSummary/RouteBBox :cognitect.aws.location/BoundingBox)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionResponse/Results
  :cognitect.aws.location/SearchForPositionResultList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionResponse/Summary
  :cognitect.aws.location/SearchPlaceIndexForPositionSummary)

(s/def
  :cognitect.aws.location.ListRouteCalculatorsRequest/MaxResults
  :cognitect.aws.location/ListRouteCalculatorsRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListRouteCalculatorsRequest/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.GeofenceGeometry/Circle :cognitect.aws.location/Circle)

(s/def :cognitect.aws.location.GeofenceGeometry/Polygon :cognitect.aws.location/LinearRings)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/BiasPosition
  :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/FilterBBox
  :cognitect.aws.location/BoundingBox)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/FilterCountries
  :cognitect.aws.location/CountryCodeList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/Language
  :cognitect.aws.location/LanguageTag)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/MaxResults
  :cognitect.aws.location/PlaceIndexSearchResultLimit)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextRequest/Text
  :cognitect.aws.location/SearchPlaceIndexForTextRequestTextString)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.Leg/Distance :cognitect.aws.location/LegDistanceDouble)

(s/def :cognitect.aws.location.Leg/DurationSeconds :cognitect.aws.location/LegDurationSecondsDouble)

(s/def :cognitect.aws.location.Leg/EndPosition :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.Leg/Geometry :cognitect.aws.location/LegGeometry)

(s/def :cognitect.aws.location.Leg/StartPosition :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.Leg/Steps :cognitect.aws.location/StepList)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponse/Entries
  :cognitect.aws.location/ListPlaceIndexesResponseEntryList)

(s/def :cognitect.aws.location.ListPlaceIndexesResponse/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.GetGeofenceRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetGeofenceRequest/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.UpdateRouteCalculatorResponse/CalculatorArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.UpdateRouteCalculatorResponse/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.UpdateRouteCalculatorResponse/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DeleteRouteCalculatorRequest/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextResponse/Results
  :cognitect.aws.location/SearchForTextResultList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextResponse/Summary
  :cognitect.aws.location/SearchPlaceIndexForTextSummary)

(s/def
  :cognitect.aws.location.BatchPutGeofenceResponse/Errors
  :cognitect.aws.location/BatchPutGeofenceErrorList)

(s/def
  :cognitect.aws.location.BatchPutGeofenceResponse/Successes
  :cognitect.aws.location/BatchPutGeofenceSuccessList)

(s/def :cognitect.aws.location.CreateMapResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.CreateMapResponse/MapArn :cognitect.aws.location/GeoArn)

(s/def :cognitect.aws.location.CreateMapResponse/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetMapTileRequest/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetMapTileRequest/X :cognitect.aws.location/GetMapTileRequestXString)

(s/def :cognitect.aws.location.GetMapTileRequest/Y :cognitect.aws.location/GetMapTileRequestYString)

(s/def :cognitect.aws.location.GetMapTileRequest/Z :cognitect.aws.location/GetMapTileRequestZString)

(s/def :cognitect.aws.location.GetPlaceRequest/IndexName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetPlaceRequest/Language :cognitect.aws.location/LanguageTag)

(s/def :cognitect.aws.location.GetPlaceRequest/PlaceId :cognitect.aws.location/PlaceId)

(s/def :cognitect.aws.location.LegGeometry/LineString :cognitect.aws.location/LineString)

(s/def
  :cognitect.aws.location.ListMapsResponse/Entries
  :cognitect.aws.location/ListMapsResponseEntryList)

(s/def :cognitect.aws.location.ListMapsResponse/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.GetMapSpritesResponse/Blob :cognitect.aws.location/Blob)

(s/def :cognitect.aws.location.GetMapSpritesResponse/ContentType :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DescribePlaceIndexResponse/Tags :cognitect.aws.location/TagMap)

(s/def :cognitect.aws.location.DescribePlaceIndexResponse/IndexArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/DataSourceConfiguration
  :cognitect.aws.location/DataSourceConfiguration)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DescribePlaceIndexResponse/DataSource :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.DescribePlaceIndexResponse/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CalculateRouteCarModeOptions/AvoidFerries
  :cognitect.aws.location/Boolean)

(s/def
  :cognitect.aws.location.CalculateRouteCarModeOptions/AvoidTolls
  :cognitect.aws.location/Boolean)

(s/def
  :cognitect.aws.location.RouteMatrixEntryError/Code
  :cognitect.aws.location/RouteMatrixErrorCode)

(s/def :cognitect.aws.location.RouteMatrixEntryError/Message :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.DescribeTrackerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/BiasPosition
  :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/FilterBBox
  :cognitect.aws.location/BoundingBox)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/FilterCountries
  :cognitect.aws.location/CountryCodeList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/Language
  :cognitect.aws.location/LanguageTag)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/MaxResults
  :cognitect.aws.location/PlaceIndexSearchResultLimit)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/ResultBBox
  :cognitect.aws.location/BoundingBox)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForTextSummary/Text
  :cognitect.aws.location/SensitiveString)

(s/def :cognitect.aws.location.DescribeMapResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DescribeMapResponse/MapArn :cognitect.aws.location/GeoArn)

(s/def :cognitect.aws.location.DescribeMapResponse/Tags :cognitect.aws.location/TagMap)

(s/def :cognitect.aws.location.DescribeMapResponse/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.DescribeMapResponse/PricingPlan :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.DescribeMapResponse/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.DescribeMapResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DescribeMapResponse/Configuration
  :cognitect.aws.location/MapConfiguration)

(s/def :cognitect.aws.location.DescribeMapResponse/DataSource :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesResponse/Errors
  :cognitect.aws.location/BatchEvaluateGeofencesErrorList)

(s/def
  :cognitect.aws.location.BatchDeleteGeofenceResponse/Errors
  :cognitect.aws.location/BatchDeleteGeofenceErrorList)

(s/def :cognitect.aws.location.GetDevicePositionRequest/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.GetDevicePositionRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.ListTagsForResourceRequest/ResourceArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.AssociateTrackerConsumerRequest/ConsumerArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.AssociateTrackerConsumerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListRouteCalculatorsResponse/Entries
  :cognitect.aws.location/ListRouteCalculatorsResponseEntryList)

(s/def :cognitect.aws.location.ListRouteCalculatorsResponse/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.DevicePosition/Accuracy :cognitect.aws.location/PositionalAccuracy)

(s/def :cognitect.aws.location.DevicePosition/DeviceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.DevicePosition/Position :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.DevicePosition/PositionProperties
  :cognitect.aws.location/PropertyMap)

(s/def :cognitect.aws.location.DevicePosition/ReceivedTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.DevicePosition/SampleTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.SearchForSuggestionsResult/PlaceId :cognitect.aws.location/PlaceId)

(s/def :cognitect.aws.location.SearchForSuggestionsResult/Text :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixResponse/RouteMatrix
  :cognitect.aws.location/RouteMatrix)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixResponse/SnappedDeparturePositions
  :cognitect.aws.location/CalculateRouteMatrixResponseSnappedDeparturePositionsList)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixResponse/SnappedDestinationPositions
  :cognitect.aws.location/CalculateRouteMatrixResponseSnappedDestinationPositionsList)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixResponse/Summary
  :cognitect.aws.location/CalculateRouteMatrixSummary)

(s/def
  :cognitect.aws.location.ListGeofencesRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListGeofencesRequest/MaxResults
  :cognitect.aws.location/ListGeofencesRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListGeofencesRequest/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.DescribeRouteCalculatorRequest/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.GetMapGlyphsResponse/Blob :cognitect.aws.location/Blob)

(s/def :cognitect.aws.location.GetMapGlyphsResponse/ContentType :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.CalculateRouteRequest/DistanceUnit
  :cognitect.aws.location/DistanceUnit)

(s/def :cognitect.aws.location.CalculateRouteRequest/TravelMode :cognitect.aws.location/TravelMode)

(s/def
  :cognitect.aws.location.CalculateRouteRequest/CarModeOptions
  :cognitect.aws.location/CalculateRouteCarModeOptions)

(s/def
  :cognitect.aws.location.CalculateRouteRequest/TruckModeOptions
  :cognitect.aws.location/CalculateRouteTruckModeOptions)

(s/def
  :cognitect.aws.location.CalculateRouteRequest/DepartureTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.CalculateRouteRequest/DestinationPosition
  :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.CalculateRouteRequest/DepartNow :cognitect.aws.location/Boolean)

(s/def
  :cognitect.aws.location.CalculateRouteRequest/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CalculateRouteRequest/IncludeLegGeometry
  :cognitect.aws.location/Boolean)

(s/def
  :cognitect.aws.location.CalculateRouteRequest/DeparturePosition
  :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.CalculateRouteRequest/WaypointPositions
  :cognitect.aws.location/CalculateRouteRequestWaypointPositionsList)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionRequest/DeviceIds
  :cognitect.aws.location/BatchGetDevicePositionRequestDeviceIdsList)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionRequest/TrackerName
  :cognitect.aws.location/BatchGetDevicePositionRequestTrackerNameString)

(s/def :cognitect.aws.location.TimeZone/Name :cognitect.aws.location/String)

(s/def :cognitect.aws.location.TimeZone/Offset :cognitect.aws.location/Integer)

(s/def
  :cognitect.aws.location.UpdateTrackerRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.UpdateTrackerRequest/PositionFiltering
  :cognitect.aws.location/PositionFiltering)

(s/def :cognitect.aws.location.UpdateTrackerRequest/PricingPlan :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.UpdateTrackerRequest/PricingPlanDataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.UpdateTrackerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchEvaluateGeofencesRequest/DevicePositionUpdates
  :cognitect.aws.location/BatchEvaluateGeofencesRequestDevicePositionUpdatesList)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsRequest/MaxResults
  :cognitect.aws.location/ListGeofenceCollectionsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.location.ListGeofenceCollectionsRequest/NextToken
  :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.UpdateTrackerResponse/TrackerArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.UpdateTrackerResponse/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.UpdateTrackerResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DescribeRouteCalculatorResponse/CalculatorArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.DescribeRouteCalculatorResponse/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.DescribeRouteCalculatorResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DescribeRouteCalculatorResponse/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.DescribeRouteCalculatorResponse/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.DescribeRouteCalculatorResponse/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def :cognitect.aws.location.DescribeRouteCalculatorResponse/Tags :cognitect.aws.location/TagMap)

(s/def
  :cognitect.aws.location.DescribeRouteCalculatorResponse/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/BiasPosition
  :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/FilterBBox
  :cognitect.aws.location/BoundingBox)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/FilterCountries
  :cognitect.aws.location/CountryCodeList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/Language
  :cognitect.aws.location/LanguageTag)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/MaxResults
  :cognitect.aws.location/SearchPlaceIndexForSuggestionsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsRequest/Text
  :cognitect.aws.location/SearchPlaceIndexForSuggestionsRequestTextString)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/PricingPlanDataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListTrackersResponseEntry/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.GetMapTileResponse/Blob :cognitect.aws.location/Blob)

(s/def :cognitect.aws.location.GetMapTileResponse/ContentType :cognitect.aws.location/String)

(s/def :cognitect.aws.location.CalculateRouteResponse/Legs :cognitect.aws.location/LegList)

(s/def
  :cognitect.aws.location.CalculateRouteResponse/Summary
  :cognitect.aws.location/CalculateRouteSummary)

(s/def
  :cognitect.aws.location.DevicePositionUpdate/Accuracy
  :cognitect.aws.location/PositionalAccuracy)

(s/def :cognitect.aws.location.DevicePositionUpdate/DeviceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.DevicePositionUpdate/Position :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.DevicePositionUpdate/PositionProperties
  :cognitect.aws.location/PropertyMap)

(s/def :cognitect.aws.location.DevicePositionUpdate/SampleTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.UpdatePlaceIndexRequest/DataSourceConfiguration
  :cognitect.aws.location/DataSourceConfiguration)

(s/def
  :cognitect.aws.location.UpdatePlaceIndexRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.UpdatePlaceIndexRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.UpdatePlaceIndexRequest/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/Tags
  :cognitect.aws.location/TagMap)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/CollectionArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/PricingPlanDataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/KmsKeyId
  :cognitect.aws.location/KmsKeyId)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.DescribeGeofenceCollectionResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixRequest/DeparturePositions
  :cognitect.aws.location/CalculateRouteMatrixRequestDeparturePositionsList)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixRequest/DistanceUnit
  :cognitect.aws.location/DistanceUnit)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixRequest/TravelMode
  :cognitect.aws.location/TravelMode)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixRequest/CarModeOptions
  :cognitect.aws.location/CalculateRouteCarModeOptions)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixRequest/TruckModeOptions
  :cognitect.aws.location/CalculateRouteTruckModeOptions)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixRequest/DepartureTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixRequest/DepartNow
  :cognitect.aws.location/Boolean)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixRequest/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CalculateRouteMatrixRequest/DestinationPositions
  :cognitect.aws.location/CalculateRouteMatrixRequestDestinationPositionsList)

(s/def
  :cognitect.aws.location.UpdateRouteCalculatorRequest/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.UpdateRouteCalculatorRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.UpdateRouteCalculatorRequest/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def :cognitect.aws.location.MapConfiguration/Style :cognitect.aws.location/MapStyle)

(s/def :cognitect.aws.location.BatchPutGeofenceRequestEntry/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.BatchPutGeofenceRequestEntry/Geometry
  :cognitect.aws.location/GeofenceGeometry)

(s/def :cognitect.aws.location.PlaceGeometry/Point :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.CreateTrackerRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.CreateTrackerRequest/KmsKeyId :cognitect.aws.location/KmsKeyId)

(s/def
  :cognitect.aws.location.CreateTrackerRequest/PositionFiltering
  :cognitect.aws.location/PositionFiltering)

(s/def :cognitect.aws.location.CreateTrackerRequest/PricingPlan :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.CreateTrackerRequest/PricingPlanDataSource
  :cognitect.aws.location/String)

(s/def :cognitect.aws.location.CreateTrackerRequest/Tags :cognitect.aws.location/TagMap)

(s/def
  :cognitect.aws.location.CreateTrackerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListMapsRequest/MaxResults
  :cognitect.aws.location/ListMapsRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListMapsRequest/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionSummary/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionSummary/Language
  :cognitect.aws.location/LanguageTag)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionSummary/MaxResults
  :cognitect.aws.location/PlaceIndexSearchResultLimit)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForPositionSummary/Position
  :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.BatchGetDevicePositionError/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.BatchGetDevicePositionError/Error
  :cognitect.aws.location/BatchItemError)

(s/def
  :cognitect.aws.location.GetDevicePositionResponse/Accuracy
  :cognitect.aws.location/PositionalAccuracy)

(s/def :cognitect.aws.location.GetDevicePositionResponse/DeviceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.GetDevicePositionResponse/Position :cognitect.aws.location/Position)

(s/def
  :cognitect.aws.location.GetDevicePositionResponse/PositionProperties
  :cognitect.aws.location/PropertyMap)

(s/def
  :cognitect.aws.location.GetDevicePositionResponse/ReceivedTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.GetDevicePositionResponse/SampleTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionRequest/KmsKeyId
  :cognitect.aws.location/KmsKeyId)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionRequest/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.CreateGeofenceCollectionRequest/PricingPlanDataSource
  :cognitect.aws.location/String)

(s/def :cognitect.aws.location.CreateGeofenceCollectionRequest/Tags :cognitect.aws.location/TagMap)

(s/def :cognitect.aws.location.UntagResourceRequest/ResourceArn :cognitect.aws.location/Arn)

(s/def :cognitect.aws.location.UntagResourceRequest/TagKeys :cognitect.aws.location/TagKeys)

(s/def
  :cognitect.aws.location.CreateRouteCalculatorRequest/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CreateRouteCalculatorRequest/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.CreateRouteCalculatorRequest/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.CreateRouteCalculatorRequest/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def :cognitect.aws.location.CreateRouteCalculatorRequest/Tags :cognitect.aws.location/TagMap)

(s/def :cognitect.aws.location.DescribeMapRequest/MapName :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchPutGeofenceRequest/CollectionName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchPutGeofenceRequest/Entries
  :cognitect.aws.location/BatchPutGeofenceRequestEntriesList)

(s/def :cognitect.aws.location.GetMapStyleDescriptorResponse/Blob :cognitect.aws.location/Blob)

(s/def
  :cognitect.aws.location.GetMapStyleDescriptorResponse/ContentType
  :cognitect.aws.location/String)

(s/def :cognitect.aws.location.ListMapsResponseEntry/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.ListMapsResponseEntry/DataSource :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListMapsResponseEntry/Description
  :cognitect.aws.location/ResourceDescription)

(s/def :cognitect.aws.location.ListMapsResponseEntry/MapName :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListMapsResponseEntry/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def :cognitect.aws.location.ListMapsResponseEntry/UpdateTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.SearchForTextResult/Distance
  :cognitect.aws.location/SearchForTextResultDistanceDouble)

(s/def :cognitect.aws.location.SearchForTextResult/Place :cognitect.aws.location/Place)

(s/def :cognitect.aws.location.SearchForTextResult/PlaceId :cognitect.aws.location/PlaceId)

(s/def
  :cognitect.aws.location.SearchForTextResult/Relevance
  :cognitect.aws.location/SearchForTextResultRelevanceDouble)

(s/def
  :cognitect.aws.location.SearchForPositionResult/Distance
  :cognitect.aws.location/SearchForPositionResultDistanceDouble)

(s/def :cognitect.aws.location.SearchForPositionResult/Place :cognitect.aws.location/Place)

(s/def :cognitect.aws.location.SearchForPositionResult/PlaceId :cognitect.aws.location/PlaceId)

(s/def
  :cognitect.aws.location.DeleteTrackerRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.DataSourceConfiguration/IntendedUse
  :cognitect.aws.location/IntendedUse)

(s/def :cognitect.aws.location.PutGeofenceResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.PutGeofenceResponse/GeofenceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.PutGeofenceResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.UpdatePlaceIndexResponse/IndexArn :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.UpdatePlaceIndexResponse/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.UpdatePlaceIndexResponse/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.Place/Label :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/UnitNumber :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Municipality :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/UnitType :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Neighborhood :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Geometry :cognitect.aws.location/PlaceGeometry)

(s/def :cognitect.aws.location.Place/SubRegion :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/TimeZone :cognitect.aws.location/TimeZone)

(s/def :cognitect.aws.location.Place/Region :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Interpolated :cognitect.aws.location/Boolean)

(s/def :cognitect.aws.location.Place/Country :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/Street :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/AddressNumber :cognitect.aws.location/String)

(s/def :cognitect.aws.location.Place/PostalCode :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListTrackerConsumersRequest/MaxResults
  :cognitect.aws.location/ListTrackerConsumersRequestMaxResultsInteger)

(s/def :cognitect.aws.location.ListTrackerConsumersRequest/NextToken :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.ListTrackerConsumersRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.GetMapSpritesRequest/FileName
  :cognitect.aws.location/GetMapSpritesRequestFileNameString)

(s/def :cognitect.aws.location.GetMapSpritesRequest/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.UpdateMapResponse/MapArn :cognitect.aws.location/GeoArn)

(s/def :cognitect.aws.location.UpdateMapResponse/MapName :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.UpdateMapResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListGeofencesResponse/Entries
  :cognitect.aws.location/ListGeofenceResponseEntryList)

(s/def :cognitect.aws.location.ListGeofencesResponse/NextToken :cognitect.aws.location/Token)

(s/def :cognitect.aws.location.GetDevicePositionHistoryRequest/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryRequest/EndTimeExclusive
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryRequest/MaxResults
  :cognitect.aws.location/GetDevicePositionHistoryRequestMaxResultsInteger)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryRequest/NextToken
  :cognitect.aws.location/Token)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryRequest/StartTimeInclusive
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.BatchDeleteGeofenceError/Error
  :cognitect.aws.location/BatchItemError)

(s/def :cognitect.aws.location.BatchDeleteGeofenceError/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.CreateRouteCalculatorResponse/CalculatorArn
  :cognitect.aws.location/Arn)

(s/def
  :cognitect.aws.location.CreateRouteCalculatorResponse/CalculatorName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.CreateRouteCalculatorResponse/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.BatchUpdateDevicePositionError/DeviceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionError/Error
  :cognitect.aws.location/BatchItemError)

(s/def
  :cognitect.aws.location.BatchUpdateDevicePositionError/SampleTime
  :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.GetGeofenceResponse/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.GetGeofenceResponse/GeofenceId :cognitect.aws.location/Id)

(s/def
  :cognitect.aws.location.GetGeofenceResponse/Geometry
  :cognitect.aws.location/GeofenceGeometry)

(s/def :cognitect.aws.location.GetGeofenceResponse/Status :cognitect.aws.location/String)

(s/def :cognitect.aws.location.GetGeofenceResponse/UpdateTime :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.CalculateRouteTruckModeOptions/AvoidFerries
  :cognitect.aws.location/Boolean)

(s/def
  :cognitect.aws.location.CalculateRouteTruckModeOptions/AvoidTolls
  :cognitect.aws.location/Boolean)

(s/def
  :cognitect.aws.location.CalculateRouteTruckModeOptions/Dimensions
  :cognitect.aws.location/TruckDimensions)

(s/def
  :cognitect.aws.location.CalculateRouteTruckModeOptions/Weight
  :cognitect.aws.location/TruckWeight)

(s/def
  :cognitect.aws.location.BatchDeleteDevicePositionHistoryRequest/DeviceIds
  :cognitect.aws.location/BatchDeleteDevicePositionHistoryRequestDeviceIdsList)

(s/def
  :cognitect.aws.location.BatchDeleteDevicePositionHistoryRequest/TrackerName
  :cognitect.aws.location/ResourceName)

(s/def :cognitect.aws.location.ListTagsForResourceResponse/Tags :cognitect.aws.location/TagMap)

(s/def :cognitect.aws.location.BatchPutGeofenceSuccess/CreateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.BatchPutGeofenceSuccess/GeofenceId :cognitect.aws.location/Id)

(s/def :cognitect.aws.location.BatchPutGeofenceSuccess/UpdateTime :cognitect.aws.location/Timestamp)

(s/def :cognitect.aws.location.Circle/Center :cognitect.aws.location/Position)

(s/def :cognitect.aws.location.Circle/Radius :cognitect.aws.location/Double)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/CreateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/DataSource
  :cognitect.aws.location/String)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/Description
  :cognitect.aws.location/ResourceDescription)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/PricingPlan
  :cognitect.aws.location/PricingPlan)

(s/def
  :cognitect.aws.location.ListPlaceIndexesResponseEntry/UpdateTime
  :cognitect.aws.location/Timestamp)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsResponse/Results
  :cognitect.aws.location/SearchForSuggestionsResultList)

(s/def
  :cognitect.aws.location.SearchPlaceIndexForSuggestionsResponse/Summary
  :cognitect.aws.location/SearchPlaceIndexForSuggestionsSummary)

(s/def :cognitect.aws.location.DeleteMapRequest/MapName :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.DescribePlaceIndexRequest/IndexName
  :cognitect.aws.location/ResourceName)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryResponse/DevicePositions
  :cognitect.aws.location/DevicePositionList)

(s/def
  :cognitect.aws.location.GetDevicePositionHistoryResponse/NextToken
  :cognitect.aws.location/Token)

