;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.lookoutequipment.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.lookoutequipment/MissingCompleteSensorData
  (s/keys :req-un [:cognitect.aws.lookoutequipment.MissingCompleteSensorData/AffectedSensorCount]))

(s/def
  :cognitect.aws.lookoutequipment/ComponentName
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z._\\-]{1,200}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/ListInferenceSchedulersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/ModelName
     :cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/Status
     :cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/NextToken
     :cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/InferenceSchedulerNameBeginsWith
     :cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/MaxResults]))

(s/def
  :cognitect.aws.lookoutequipment/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.TagResourceRequest/ResourceArn
     :cognitect.aws.lookoutequipment.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.lookoutequipment/LabelGroupArn
  (s/spec
    #(re-matches
      (re-pattern "arn:aws(-[^:]+)?:lookoutequipment:[a-zA-Z0-9\\-]*:[0-9]{12}:label-group\\/.+")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/ListLabelGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListLabelGroupsRequest/NextToken
     :cognitect.aws.lookoutequipment.ListLabelGroupsRequest/MaxResults
     :cognitect.aws.lookoutequipment.ListLabelGroupsRequest/LabelGroupNameBeginsWith]))

(s/def
  :cognitect.aws.lookoutequipment/ListInferenceSchedulersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListInferenceSchedulersResponse/NextToken
     :cognitect.aws.lookoutequipment.ListInferenceSchedulersResponse/InferenceSchedulerSummaries]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeLabelRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.DescribeLabelRequest/LabelGroupName
     :cognitect.aws.lookoutequipment.DescribeLabelRequest/LabelId]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceExecutionSummaries
  (s/coll-of :cognitect.aws.lookoutequipment/InferenceExecutionSummary))

(s/def
  :cognitect.aws.lookoutequipment/DatasetSchema
  (s/keys :opt-un [:cognitect.aws.lookoutequipment.DatasetSchema/InlineDataSchema]))

(s/def
  :cognitect.aws.lookoutequipment/ListSensorStatisticsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.ListSensorStatisticsRequest/DatasetName]
    :opt-un
    [:cognitect.aws.lookoutequipment.ListSensorStatisticsRequest/NextToken
     :cognitect.aws.lookoutequipment.ListSensorStatisticsRequest/MaxResults
     :cognitect.aws.lookoutequipment.ListSensorStatisticsRequest/IngestionJobId]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceEventSummaries
  (s/coll-of :cognitect.aws.lookoutequipment/InferenceEventSummary))

(s/def
  :cognitect.aws.lookoutequipment/ListDataIngestionJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListDataIngestionJobsRequest/DatasetName
     :cognitect.aws.lookoutequipment.ListDataIngestionJobsRequest/Status
     :cognitect.aws.lookoutequipment.ListDataIngestionJobsRequest/NextToken
     :cognitect.aws.lookoutequipment.ListDataIngestionJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.lookoutequipment/SensorStatisticsSummary
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.SensorStatisticsSummary/LargeTimestampGaps
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/DataExists
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/DataStartTime
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/MonotonicValues
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/MissingValues
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/DuplicateTimestamps
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/DataEndTime
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/MultipleOperatingModes
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/InvalidDateEntries
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/SensorName
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/InvalidValues
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/ComponentName
     :cognitect.aws.lookoutequipment.SensorStatisticsSummary/CategoricalValues]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceS3OutputConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.InferenceS3OutputConfiguration/Bucket]
    :opt-un
    [:cognitect.aws.lookoutequipment.InferenceS3OutputConfiguration/Prefix]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeLabelGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/FaultCodes
     :cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/LabelGroupName
     :cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/CreatedAt
     :cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/UpdatedAt
     :cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/LabelGroupArn]))

(s/def
  :cognitect.aws.lookoutequipment/Tag
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.Tag/Key :cognitect.aws.lookoutequipment.Tag/Value]))

(s/def
  :cognitect.aws.lookoutequipment/IngestionJobStatus
  (s/spec string? :gen #(s/gen #{"SUCCESS" "IN_PROGRESS" "FAILED"})))

(s/def
  :cognitect.aws.lookoutequipment/ModelSummary
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ModelSummary/ModelName
     :cognitect.aws.lookoutequipment.ModelSummary/DatasetName
     :cognitect.aws.lookoutequipment.ModelSummary/DatasetArn
     :cognitect.aws.lookoutequipment.ModelSummary/Status
     :cognitect.aws.lookoutequipment.ModelSummary/CreatedAt
     :cognitect.aws.lookoutequipment.ModelSummary/ModelArn]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeModelRequest
  (s/keys :req-un [:cognitect.aws.lookoutequipment.DescribeModelRequest/ModelName]))

(s/def
  :cognitect.aws.lookoutequipment/CreateLabelGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.CreateLabelGroupResponse/LabelGroupName
     :cognitect.aws.lookoutequipment.CreateLabelGroupResponse/LabelGroupArn]))

(s/def
  :cognitect.aws.lookoutequipment/CreateModelRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.CreateModelRequest/ModelName
     :cognitect.aws.lookoutequipment.CreateModelRequest/DatasetName
     :cognitect.aws.lookoutequipment.CreateModelRequest/ClientToken]
    :opt-un
    [:cognitect.aws.lookoutequipment.CreateModelRequest/ServerSideKmsKeyId
     :cognitect.aws.lookoutequipment.CreateModelRequest/OffCondition
     :cognitect.aws.lookoutequipment.CreateModelRequest/LabelsInputConfiguration
     :cognitect.aws.lookoutequipment.CreateModelRequest/RoleArn
     :cognitect.aws.lookoutequipment.CreateModelRequest/Tags
     :cognitect.aws.lookoutequipment.CreateModelRequest/DatasetSchema
     :cognitect.aws.lookoutequipment.CreateModelRequest/EvaluationDataEndTime
     :cognitect.aws.lookoutequipment.CreateModelRequest/TrainingDataEndTime
     :cognitect.aws.lookoutequipment.CreateModelRequest/TrainingDataStartTime
     :cognitect.aws.lookoutequipment.CreateModelRequest/EvaluationDataStartTime
     :cognitect.aws.lookoutequipment.CreateModelRequest/DataPreProcessingConfiguration]))

(s/def
  :cognitect.aws.lookoutequipment/DeleteLabelRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.DeleteLabelRequest/LabelGroupName
     :cognitect.aws.lookoutequipment.DeleteLabelRequest/LabelId]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceEventSummary
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.InferenceEventSummary/InferenceSchedulerName
     :cognitect.aws.lookoutequipment.InferenceEventSummary/InferenceSchedulerArn
     :cognitect.aws.lookoutequipment.InferenceEventSummary/EventDurationInSeconds
     :cognitect.aws.lookoutequipment.InferenceEventSummary/Diagnostics
     :cognitect.aws.lookoutequipment.InferenceEventSummary/EventStartTime
     :cognitect.aws.lookoutequipment.InferenceEventSummary/EventEndTime]))

(s/def
  :cognitect.aws.lookoutequipment/UpdateInferenceSchedulerRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/InferenceSchedulerName]
    :opt-un
    [:cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/DataInputConfiguration
     :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/RoleArn
     :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/DataOutputConfiguration
     :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/DataDelayOffsetInMinutes
     :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/DataUploadFrequency]))

(s/def :cognitect.aws.lookoutequipment/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.lookoutequipment/BoundedLengthString
  (s/spec #(re-matches (re-pattern "[\\P{M}\\p{M}]{1,5000}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/ListInferenceExecutionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListInferenceExecutionsResponse/NextToken
     :cognitect.aws.lookoutequipment.ListInferenceExecutionsResponse/InferenceExecutionSummaries]))

(s/def
  :cognitect.aws.lookoutequipment/ModelStatus
  (s/spec string? :gen #(s/gen #{"SUCCESS" "IN_PROGRESS" "FAILED"})))

(s/def
  :cognitect.aws.lookoutequipment/UnsupportedTimestamps
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.UnsupportedTimestamps/TotalNumberOfUnsupportedTimestamps]))

(s/def
  :cognitect.aws.lookoutequipment/ListDatasetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListDatasetsRequest/NextToken
     :cognitect.aws.lookoutequipment.ListDatasetsRequest/DatasetNameBeginsWith
     :cognitect.aws.lookoutequipment.ListDatasetsRequest/MaxResults]))

(s/def
  :cognitect.aws.lookoutequipment/IdempotenceToken
  (s/spec #(re-matches (re-pattern "\\p{ASCII}{1,256}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/DeleteModelRequest
  (s/keys :req-un [:cognitect.aws.lookoutequipment.DeleteModelRequest/ModelName]))

(s/def
  :cognitect.aws.lookoutequipment/ListLabelsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.ListLabelsRequest/LabelGroupName]
    :opt-un
    [:cognitect.aws.lookoutequipment.ListLabelsRequest/Equipment
     :cognitect.aws.lookoutequipment.ListLabelsRequest/NextToken
     :cognitect.aws.lookoutequipment.ListLabelsRequest/IntervalStartTime
     :cognitect.aws.lookoutequipment.ListLabelsRequest/IntervalEndTime
     :cognitect.aws.lookoutequipment.ListLabelsRequest/MaxResults
     :cognitect.aws.lookoutequipment.ListLabelsRequest/FaultCode]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeLabelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.DescribeLabelResponse/EndTime
     :cognitect.aws.lookoutequipment.DescribeLabelResponse/Equipment
     :cognitect.aws.lookoutequipment.DescribeLabelResponse/StartTime
     :cognitect.aws.lookoutequipment.DescribeLabelResponse/LabelId
     :cognitect.aws.lookoutequipment.DescribeLabelResponse/Rating
     :cognitect.aws.lookoutequipment.DescribeLabelResponse/LabelGroupName
     :cognitect.aws.lookoutequipment.DescribeLabelResponse/CreatedAt
     :cognitect.aws.lookoutequipment.DescribeLabelResponse/Notes
     :cognitect.aws.lookoutequipment.DescribeLabelResponse/LabelGroupArn
     :cognitect.aws.lookoutequipment.DescribeLabelResponse/FaultCode]))

(s/def
  :cognitect.aws.lookoutequipment/DeleteDatasetRequest
  (s/keys :req-un [:cognitect.aws.lookoutequipment.DeleteDatasetRequest/DatasetName]))

(s/def
  :cognitect.aws.lookoutequipment/TimeZoneOffset
  (s/spec #(re-matches (re-pattern "^(\\+|\\-)[0-9]{2}\\:[0-9]{2}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/IngestionS3InputConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.IngestionS3InputConfiguration/Bucket]
    :opt-un
    [:cognitect.aws.lookoutequipment.IngestionS3InputConfiguration/Prefix
     :cognitect.aws.lookoutequipment.IngestionS3InputConfiguration/KeyPattern]))

(s/def
  :cognitect.aws.lookoutequipment/TagList
  (s/coll-of :cognitect.aws.lookoutequipment/Tag :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.lookoutequipment/InferenceInputConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.InferenceInputConfiguration/S3InputConfiguration
     :cognitect.aws.lookoutequipment.InferenceInputConfiguration/InputTimeZoneOffset
     :cognitect.aws.lookoutequipment.InferenceInputConfiguration/InferenceInputNameConfiguration]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceExecutionStatus
  (s/spec string? :gen #(s/gen #{"SUCCESS" "IN_PROGRESS" "FAILED"})))

(s/def
  :cognitect.aws.lookoutequipment/LabelRating
  (s/spec string? :gen #(s/gen #{"NEUTRAL" "ANOMALY" "NO_ANOMALY"})))

(s/def
  :cognitect.aws.lookoutequipment/AmazonResourceArn
  (s/spec
    (s/and string? #(<= 1 (count %) 1011))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1011) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lookoutequipment/IngestedFilesSummary
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.IngestedFilesSummary/TotalNumberOfFiles
     :cognitect.aws.lookoutequipment.IngestedFilesSummary/IngestedNumberOfFiles]
    :opt-un
    [:cognitect.aws.lookoutequipment.IngestedFilesSummary/DiscardedFiles]))

(s/def
  :cognitect.aws.lookoutequipment/NameOrArn
  (s/spec
    #(re-matches (re-pattern "^[A-Za-z0-9][A-Za-z0-9:_/+=,@.-]{0,2048}$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/EventDurationInSeconds
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.lookoutequipment/S3Prefix
  (s/spec
    #(re-matches (re-pattern "(^$)|([\\u0009\\u000A\\u000D\\u0020-\\u00FF]{1,1023}/$)") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/ModelMetrics
  (s/spec
    (s/and string? #(<= 1 (count %) 50000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lookoutequipment/IngestionJobId
  (s/spec #(re-matches (re-pattern "[A-Fa-f0-9]{0,32}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/ModelName
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z_-]{1,200}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/LabelsS3InputConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.LabelsS3InputConfiguration/Bucket]
    :opt-un
    [:cognitect.aws.lookoutequipment.LabelsS3InputConfiguration/Prefix]))

(s/def
  :cognitect.aws.lookoutequipment/CreateLabelGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.CreateLabelGroupRequest/LabelGroupName
     :cognitect.aws.lookoutequipment.CreateLabelGroupRequest/ClientToken]
    :opt-un
    [:cognitect.aws.lookoutequipment.CreateLabelGroupRequest/Tags
     :cognitect.aws.lookoutequipment.CreateLabelGroupRequest/FaultCodes]))

(s/def
  :cognitect.aws.lookoutequipment/S3Key
  (s/spec #(re-matches (re-pattern "[\\P{M}\\p{M}]{1,1024}[^/]$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/ListDataIngestionJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListDataIngestionJobsResponse/NextToken
     :cognitect.aws.lookoutequipment.ListDataIngestionJobsResponse/DataIngestionJobSummaries]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeDataIngestionJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/IngestionInputConfiguration
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/IngestedDataSize
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/DataQualitySummary
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/RoleArn
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/DatasetArn
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/Status
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/StatusDetail
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/DataStartTime
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/IngestedFilesSummary
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/DataEndTime
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/CreatedAt
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/FailedReason
     :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/JobId]))

(s/def
  :cognitect.aws.lookoutequipment/CategoricalValues
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.CategoricalValues/Status]
    :opt-un
    [:cognitect.aws.lookoutequipment.CategoricalValues/NumberOfCategory]))

(s/def
  :cognitect.aws.lookoutequipment/DataUploadFrequency
  (s/spec string? :gen #(s/gen #{"PT5M" "PT10M" "PT1H" "PT15M" "PT30M"})))

(s/def
  :cognitect.aws.lookoutequipment/DatasetStatus
  (s/spec string? :gen #(s/gen #{"INGESTION_IN_PROGRESS" "ACTIVE" "CREATED"})))

(s/def
  :cognitect.aws.lookoutequipment/ListModelsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListModelsResponse/NextToken
     :cognitect.aws.lookoutequipment.ListModelsResponse/ModelSummaries]))

(s/def
  :cognitect.aws.lookoutequipment/CreateInferenceSchedulerResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.CreateInferenceSchedulerResponse/InferenceSchedulerName
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerResponse/InferenceSchedulerArn
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerResponse/Status]))

(s/def
  :cognitect.aws.lookoutequipment/KmsKeyArn
  (s/spec
    #(re-matches (re-pattern "arn:aws[a-z\\-]*:kms:[a-z0-9\\-]*:\\d{12}:[\\w\\-\\/]+") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.lookoutequipment/Boolean boolean?)

(s/def
  :cognitect.aws.lookoutequipment/LabelId
  (s/spec #(re-matches (re-pattern "[A-Fa-f0-9]{0,32}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/DescribeDatasetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.DescribeDatasetResponse/Schema
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/IngestionInputConfiguration
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/ServerSideKmsKeyId
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DatasetName
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DataQualitySummary
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/RoleArn
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DatasetArn
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/Status
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/LastUpdatedAt
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DataStartTime
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/IngestedFilesSummary
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DataEndTime
     :cognitect.aws.lookoutequipment.DescribeDatasetResponse/CreatedAt]))

(s/def
  :cognitect.aws.lookoutequipment/ListInferenceEventsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListInferenceEventsResponse/NextToken
     :cognitect.aws.lookoutequipment.ListInferenceEventsResponse/InferenceEventSummaries]))

(s/def
  :cognitect.aws.lookoutequipment/SensorsWithShortDateRange
  (s/keys :req-un [:cognitect.aws.lookoutequipment.SensorsWithShortDateRange/AffectedSensorCount]))

(s/def
  :cognitect.aws.lookoutequipment/CreateLabelResponse
  (s/keys :opt-un [:cognitect.aws.lookoutequipment.CreateLabelResponse/LabelId]))

(s/def
  :cognitect.aws.lookoutequipment/MissingSensorData
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.MissingSensorData/AffectedSensorCount
     :cognitect.aws.lookoutequipment.MissingSensorData/TotalNumberOfMissingValues]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeModelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.DescribeModelResponse/Schema
     :cognitect.aws.lookoutequipment.DescribeModelResponse/ModelName
     :cognitect.aws.lookoutequipment.DescribeModelResponse/ServerSideKmsKeyId
     :cognitect.aws.lookoutequipment.DescribeModelResponse/OffCondition
     :cognitect.aws.lookoutequipment.DescribeModelResponse/DatasetName
     :cognitect.aws.lookoutequipment.DescribeModelResponse/LabelsInputConfiguration
     :cognitect.aws.lookoutequipment.DescribeModelResponse/ModelMetrics
     :cognitect.aws.lookoutequipment.DescribeModelResponse/RoleArn
     :cognitect.aws.lookoutequipment.DescribeModelResponse/DatasetArn
     :cognitect.aws.lookoutequipment.DescribeModelResponse/Status
     :cognitect.aws.lookoutequipment.DescribeModelResponse/EvaluationDataEndTime
     :cognitect.aws.lookoutequipment.DescribeModelResponse/TrainingDataEndTime
     :cognitect.aws.lookoutequipment.DescribeModelResponse/TrainingExecutionEndTime
     :cognitect.aws.lookoutequipment.DescribeModelResponse/TrainingDataStartTime
     :cognitect.aws.lookoutequipment.DescribeModelResponse/LastUpdatedTime
     :cognitect.aws.lookoutequipment.DescribeModelResponse/CreatedAt
     :cognitect.aws.lookoutequipment.DescribeModelResponse/FailedReason
     :cognitect.aws.lookoutequipment.DescribeModelResponse/TrainingExecutionStartTime
     :cognitect.aws.lookoutequipment.DescribeModelResponse/EvaluationDataStartTime
     :cognitect.aws.lookoutequipment.DescribeModelResponse/DataPreProcessingConfiguration
     :cognitect.aws.lookoutequipment.DescribeModelResponse/ModelArn]))

(s/def
  :cognitect.aws.lookoutequipment/S3Bucket
  (s/spec #(re-matches (re-pattern "^[a-z0-9][\\.\\-a-z0-9]{1,61}[a-z0-9]$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/IamRoleArn
  (s/spec
    #(re-matches (re-pattern "arn:aws(-[^:]+)?:iam::[0-9]{12}:role/.+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/DatasetSummaries
  (s/coll-of :cognitect.aws.lookoutequipment/DatasetSummary))

(s/def
  :cognitect.aws.lookoutequipment/DeleteLabelGroupRequest
  (s/keys :req-un [:cognitect.aws.lookoutequipment.DeleteLabelGroupRequest/LabelGroupName]))

(s/def
  :cognitect.aws.lookoutequipment/NextToken
  (s/spec #(re-matches (re-pattern "\\p{ASCII}{0,8192}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/DatasetArn
  (s/spec
    #(re-matches
      (re-pattern "arn:aws(-[^:]+)?:lookoutequipment:[a-zA-Z0-9\\-]*:[0-9]{12}:dataset\\/.+")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/InferenceSchedulerSummaries
  (s/coll-of :cognitect.aws.lookoutequipment/InferenceSchedulerSummary))

(s/def
  :cognitect.aws.lookoutequipment/CreateDatasetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.CreateDatasetResponse/DatasetName
     :cognitect.aws.lookoutequipment.CreateDatasetResponse/DatasetArn
     :cognitect.aws.lookoutequipment.CreateDatasetResponse/Status]))

(s/def
  :cognitect.aws.lookoutequipment/CreateLabelRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.CreateLabelRequest/LabelGroupName
     :cognitect.aws.lookoutequipment.CreateLabelRequest/StartTime
     :cognitect.aws.lookoutequipment.CreateLabelRequest/EndTime
     :cognitect.aws.lookoutequipment.CreateLabelRequest/Rating
     :cognitect.aws.lookoutequipment.CreateLabelRequest/ClientToken]
    :opt-un
    [:cognitect.aws.lookoutequipment.CreateLabelRequest/Equipment
     :cognitect.aws.lookoutequipment.CreateLabelRequest/Notes
     :cognitect.aws.lookoutequipment.CreateLabelRequest/FaultCode]))

(s/def
  :cognitect.aws.lookoutequipment/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.lookoutequipment/ModelArn
  (s/spec
    #(re-matches
      (re-pattern "arn:aws(-[^:]+)?:lookoutequipment:[a-zA-Z0-9\\-]*:[0-9]{12}:model\\/.+")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/TagValue
  (s/spec #(re-matches (re-pattern "[\\s\\w+-=\\.:/@]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/MultipleOperatingModes
  (s/keys :req-un [:cognitect.aws.lookoutequipment.MultipleOperatingModes/Status]))

(s/def
  :cognitect.aws.lookoutequipment/StartInferenceSchedulerResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/InferenceSchedulerName
     :cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/ModelName
     :cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/InferenceSchedulerArn
     :cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/Status
     :cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/ModelArn]))

(s/def
  :cognitect.aws.lookoutequipment/DataPreProcessingConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.DataPreProcessingConfiguration/TargetSamplingRate]))

(s/def
  :cognitect.aws.lookoutequipment/DataQualitySummary
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.DataQualitySummary/InsufficientSensorData
     :cognitect.aws.lookoutequipment.DataQualitySummary/MissingSensorData
     :cognitect.aws.lookoutequipment.DataQualitySummary/InvalidSensorData
     :cognitect.aws.lookoutequipment.DataQualitySummary/UnsupportedTimestamps
     :cognitect.aws.lookoutequipment.DataQualitySummary/DuplicateTimestamps]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceSchedulerSummary
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.InferenceSchedulerSummary/InferenceSchedulerName
     :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/ModelName
     :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/InferenceSchedulerArn
     :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/Status
     :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/DataDelayOffsetInMinutes
     :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/DataUploadFrequency
     :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/LatestInferenceResult
     :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/ModelArn]))

(s/def
  :cognitect.aws.lookoutequipment/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.lookoutequipment.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.lookoutequipment/ListDatasetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListDatasetsResponse/NextToken
     :cognitect.aws.lookoutequipment.ListDatasetsResponse/DatasetSummaries]))

(s/def
  :cognitect.aws.lookoutequipment/ListInferenceExecutionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/InferenceSchedulerName]
    :opt-un
    [:cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/Status
     :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/NextToken
     :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/DataEndTimeBefore
     :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/DataStartTimeAfter
     :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/MaxResults]))

(s/def
  :cognitect.aws.lookoutequipment/DatasetIdentifier
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z_-]{1,200}$") %) :gen #(gen/string)))

(s/def :cognitect.aws.lookoutequipment/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.lookoutequipment/InferenceS3InputConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.InferenceS3InputConfiguration/Bucket]
    :opt-un
    [:cognitect.aws.lookoutequipment.InferenceS3InputConfiguration/Prefix]))

(s/def
  :cognitect.aws.lookoutequipment/LabelGroupSummary
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.LabelGroupSummary/LabelGroupName
     :cognitect.aws.lookoutequipment.LabelGroupSummary/CreatedAt
     :cognitect.aws.lookoutequipment.LabelGroupSummary/UpdatedAt
     :cognitect.aws.lookoutequipment.LabelGroupSummary/LabelGroupArn]))

(s/def
  :cognitect.aws.lookoutequipment/FaultCodes
  (s/coll-of :cognitect.aws.lookoutequipment/FaultCode :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.lookoutequipment/SensorStatisticsSummaries
  (s/coll-of :cognitect.aws.lookoutequipment/SensorStatisticsSummary))

(s/def
  :cognitect.aws.lookoutequipment/ModelSummaries
  (s/coll-of :cognitect.aws.lookoutequipment/ModelSummary))

(s/def
  :cognitect.aws.lookoutequipment/OffCondition
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lookoutequipment/CreateDatasetRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.CreateDatasetRequest/DatasetName
     :cognitect.aws.lookoutequipment.CreateDatasetRequest/ClientToken]
    :opt-un
    [:cognitect.aws.lookoutequipment.CreateDatasetRequest/ServerSideKmsKeyId
     :cognitect.aws.lookoutequipment.CreateDatasetRequest/Tags
     :cognitect.aws.lookoutequipment.CreateDatasetRequest/DatasetSchema]))

(s/def
  :cognitect.aws.lookoutequipment/DatasetSummary
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.DatasetSummary/DatasetName
     :cognitect.aws.lookoutequipment.DatasetSummary/DatasetArn
     :cognitect.aws.lookoutequipment.DatasetSummary/Status
     :cognitect.aws.lookoutequipment.DatasetSummary/CreatedAt]))

(s/def
  :cognitect.aws.lookoutequipment/StopInferenceSchedulerRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.StopInferenceSchedulerRequest/InferenceSchedulerName]))

(s/def
  :cognitect.aws.lookoutequipment/ListLabelGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListLabelGroupsResponse/NextToken
     :cognitect.aws.lookoutequipment.ListLabelGroupsResponse/LabelGroupSummaries]))

(s/def
  :cognitect.aws.lookoutequipment/DataDelayOffsetInMinutes
  (s/spec (s/and int? #(<= 0 % 60)) :gen #(gen/choose 0 60)))

(s/def
  :cognitect.aws.lookoutequipment/InferenceInputNameConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.InferenceInputNameConfiguration/ComponentTimestampDelimiter
     :cognitect.aws.lookoutequipment.InferenceInputNameConfiguration/TimestampFormat]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeInferenceSchedulerRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.DescribeInferenceSchedulerRequest/InferenceSchedulerName]))

(s/def
  :cognitect.aws.lookoutequipment/S3Object
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.S3Object/Bucket :cognitect.aws.lookoutequipment.S3Object/Key]))

(s/def
  :cognitect.aws.lookoutequipment/ListInferenceEventsRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.ListInferenceEventsRequest/InferenceSchedulerName
     :cognitect.aws.lookoutequipment.ListInferenceEventsRequest/IntervalStartTime
     :cognitect.aws.lookoutequipment.ListInferenceEventsRequest/IntervalEndTime]
    :opt-un
    [:cognitect.aws.lookoutequipment.ListInferenceEventsRequest/NextToken
     :cognitect.aws.lookoutequipment.ListInferenceEventsRequest/MaxResults]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeDataIngestionJobRequest
  (s/keys :req-un [:cognitect.aws.lookoutequipment.DescribeDataIngestionJobRequest/JobId]))

(s/def
  :cognitect.aws.lookoutequipment/LabelGroupSummaries
  (s/coll-of :cognitect.aws.lookoutequipment/LabelGroupSummary))

(s/def
  :cognitect.aws.lookoutequipment/Comments
  (s/spec #(re-matches (re-pattern "[\\P{M}\\p{M}]{1,2560}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/Float
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.lookoutequipment/StartDataIngestionJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.StartDataIngestionJobRequest/DatasetName
     :cognitect.aws.lookoutequipment.StartDataIngestionJobRequest/IngestionInputConfiguration
     :cognitect.aws.lookoutequipment.StartDataIngestionJobRequest/RoleArn
     :cognitect.aws.lookoutequipment.StartDataIngestionJobRequest/ClientToken]))

(s/def
  :cognitect.aws.lookoutequipment/TargetSamplingRate
  (s/spec
    string?
    :gen
    #(s/gen #{"PT30S" "PT15S" "PT5M" "PT10M" "PT1H" "PT1M" "PT10S" "PT15M" "PT30M" "PT5S" "PT1S"})))

(s/def
  :cognitect.aws.lookoutequipment/InferenceExecutionSummary
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.InferenceExecutionSummary/CustomerResultObject
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/InferenceSchedulerName
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/ModelName
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/InferenceSchedulerArn
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/ScheduledStartTime
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/DataInputConfiguration
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/DataOutputConfiguration
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/Status
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/DataStartTime
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/DataEndTime
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/FailedReason
     :cognitect.aws.lookoutequipment.InferenceExecutionSummary/ModelArn]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceSchedulerIdentifier
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z_-]{1,200}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/DuplicateTimestamps
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.DuplicateTimestamps/TotalNumberOfDuplicateTimestamps]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeLabelGroupRequest
  (s/keys :req-un [:cognitect.aws.lookoutequipment.DescribeLabelGroupRequest/LabelGroupName]))

(s/def
  :cognitect.aws.lookoutequipment/CountPercent
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.CountPercent/Count
     :cognitect.aws.lookoutequipment.CountPercent/Percentage]))

(s/def
  :cognitect.aws.lookoutequipment/LargeTimestampGaps
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.LargeTimestampGaps/Status]
    :opt-un
    [:cognitect.aws.lookoutequipment.LargeTimestampGaps/MaxTimestampGapInDays
     :cognitect.aws.lookoutequipment.LargeTimestampGaps/NumberOfLargeTimestampGaps]))

(s/def
  :cognitect.aws.lookoutequipment/ListLabelsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListLabelsResponse/NextToken
     :cognitect.aws.lookoutequipment.ListLabelsResponse/LabelSummaries]))

(s/def
  :cognitect.aws.lookoutequipment/MaxResults
  (s/spec (s/and int? #(<= 1 % 500)) :gen #(gen/choose 1 500)))

(s/def
  :cognitect.aws.lookoutequipment/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.UntagResourceRequest/ResourceArn
     :cognitect.aws.lookoutequipment.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.lookoutequipment/TagKey
  (s/spec #(re-matches (re-pattern "^(?!aws:)[a-zA-Z+-=._:/]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/LabelsInputConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.LabelsInputConfiguration/S3InputConfiguration
     :cognitect.aws.lookoutequipment.LabelsInputConfiguration/LabelGroupName]))

(s/def
  :cognitect.aws.lookoutequipment/StartDataIngestionJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.StartDataIngestionJobResponse/Status
     :cognitect.aws.lookoutequipment.StartDataIngestionJobResponse/JobId]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceSchedulerName
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z_-]{1,200}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/UpdateLabelGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.UpdateLabelGroupRequest/LabelGroupName]
    :opt-un
    [:cognitect.aws.lookoutequipment.UpdateLabelGroupRequest/FaultCodes]))

(s/def
  :cognitect.aws.lookoutequipment/Monotonicity
  (s/spec string? :gen #(s/gen #{"DECREASING" "INCREASING" "STATIC"})))

(s/def
  :cognitect.aws.lookoutequipment/MonotonicValues
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.MonotonicValues/Status]
    :opt-un
    [:cognitect.aws.lookoutequipment.MonotonicValues/Monotonicity]))

(s/def
  :cognitect.aws.lookoutequipment/InsufficientSensorData
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.InsufficientSensorData/MissingCompleteSensorData
     :cognitect.aws.lookoutequipment.InsufficientSensorData/SensorsWithShortDateRange]))

(s/def
  :cognitect.aws.lookoutequipment/Equipment
  (s/spec #(re-matches (re-pattern "[\\P{M}\\p{M}]{1,200}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/StatisticalIssueStatus
  (s/spec string? :gen #(s/gen #{"POTENTIAL_ISSUE_DETECTED" "NO_ISSUE_DETECTED"})))

(s/def
  :cognitect.aws.lookoutequipment/DescribeDatasetRequest
  (s/keys :req-un [:cognitect.aws.lookoutequipment.DescribeDatasetRequest/DatasetName]))

(s/def :cognitect.aws.lookoutequipment/Timestamp inst?)

(s/def
  :cognitect.aws.lookoutequipment/DataSizeInBytes
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.lookoutequipment/InlineDataSchema
  (s/spec
    (s/and string? #(<= 1 (count %) 1000000))
    :gen
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose 1 1000000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lookoutequipment/SensorName
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z:#$.\\-_]{1,200}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/InvalidSensorData
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.InvalidSensorData/AffectedSensorCount
     :cognitect.aws.lookoutequipment.InvalidSensorData/TotalNumberOfInvalidValues]))

(s/def
  :cognitect.aws.lookoutequipment/CreateModelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.CreateModelResponse/Status
     :cognitect.aws.lookoutequipment.CreateModelResponse/ModelArn]))

(s/def
  :cognitect.aws.lookoutequipment/ComponentTimestampDelimiter
  (s/spec #(re-matches (re-pattern "^(\\-|\\_|\\s)?$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/LatestInferenceResult
  (s/spec string? :gen #(s/gen #{"NORMAL" "ANOMALOUS"})))

(s/def
  :cognitect.aws.lookoutequipment/ListOfDiscardedFiles
  (s/coll-of :cognitect.aws.lookoutequipment/S3Object :min-count 0))

(s/def
  :cognitect.aws.lookoutequipment/IngestionInputConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.IngestionInputConfiguration/S3InputConfiguration]))

(s/def
  :cognitect.aws.lookoutequipment/LabelSummary
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.LabelSummary/EndTime
     :cognitect.aws.lookoutequipment.LabelSummary/Equipment
     :cognitect.aws.lookoutequipment.LabelSummary/StartTime
     :cognitect.aws.lookoutequipment.LabelSummary/LabelId
     :cognitect.aws.lookoutequipment.LabelSummary/Rating
     :cognitect.aws.lookoutequipment.LabelSummary/LabelGroupName
     :cognitect.aws.lookoutequipment.LabelSummary/CreatedAt
     :cognitect.aws.lookoutequipment.LabelSummary/LabelGroupArn
     :cognitect.aws.lookoutequipment.LabelSummary/FaultCode]))

(s/def
  :cognitect.aws.lookoutequipment/DescribeInferenceSchedulerResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/InferenceSchedulerName
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/ModelName
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/ServerSideKmsKeyId
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/InferenceSchedulerArn
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/DataInputConfiguration
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/RoleArn
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/DataOutputConfiguration
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/Status
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/CreatedAt
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/DataDelayOffsetInMinutes
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/UpdatedAt
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/DataUploadFrequency
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/LatestInferenceResult
     :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/ModelArn]))

(s/def
  :cognitect.aws.lookoutequipment/StartInferenceSchedulerRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.StartInferenceSchedulerRequest/InferenceSchedulerName]))

(s/def
  :cognitect.aws.lookoutequipment/ListSensorStatisticsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListSensorStatisticsResponse/NextToken
     :cognitect.aws.lookoutequipment.ListSensorStatisticsResponse/SensorStatisticsSummaries]))

(s/def
  :cognitect.aws.lookoutequipment/LabelSummaries
  (s/coll-of :cognitect.aws.lookoutequipment/LabelSummary))

(s/def
  :cognitect.aws.lookoutequipment/KeyPattern
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.lookoutequipment/ListModelsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.ListModelsRequest/ModelNameBeginsWith
     :cognitect.aws.lookoutequipment.ListModelsRequest/Status
     :cognitect.aws.lookoutequipment.ListModelsRequest/NextToken
     :cognitect.aws.lookoutequipment.ListModelsRequest/DatasetNameBeginsWith
     :cognitect.aws.lookoutequipment.ListModelsRequest/MaxResults]))

(s/def
  :cognitect.aws.lookoutequipment/DatasetName
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z_-]{1,200}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/InferenceSchedulerArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:aws(-[^:]+)?:lookoutequipment:[a-zA-Z0-9\\-]*:[0-9]{12}:inference-scheduler\\/.+")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.lookoutequipment.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceOutputConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.InferenceOutputConfiguration/S3OutputConfiguration]
    :opt-un
    [:cognitect.aws.lookoutequipment.InferenceOutputConfiguration/KmsKeyId]))

(s/def
  :cognitect.aws.lookoutequipment/StopInferenceSchedulerResponse
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/InferenceSchedulerName
     :cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/ModelName
     :cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/InferenceSchedulerArn
     :cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/Status
     :cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/ModelArn]))

(s/def
  :cognitect.aws.lookoutequipment/FaultCode
  (s/spec #(re-matches (re-pattern "[\\P{M}\\p{M}]{1,100}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/CreateInferenceSchedulerRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/ModelName
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/InferenceSchedulerName
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/DataUploadFrequency
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/DataInputConfiguration
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/DataOutputConfiguration
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/RoleArn
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/ClientToken]
    :opt-un
    [:cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/ServerSideKmsKeyId
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/Tags
     :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/DataDelayOffsetInMinutes]))

(s/def
  :cognitect.aws.lookoutequipment/InferenceSchedulerStatus
  (s/spec string? :gen #(s/gen #{"PENDING" "STOPPED" "STOPPING" "RUNNING"})))

(s/def
  :cognitect.aws.lookoutequipment/DataIngestionJobSummaries
  (s/coll-of :cognitect.aws.lookoutequipment/DataIngestionJobSummary))

(s/def
  :cognitect.aws.lookoutequipment/DataIngestionJobSummary
  (s/keys
    :opt-un
    [:cognitect.aws.lookoutequipment.DataIngestionJobSummary/IngestionInputConfiguration
     :cognitect.aws.lookoutequipment.DataIngestionJobSummary/DatasetName
     :cognitect.aws.lookoutequipment.DataIngestionJobSummary/DatasetArn
     :cognitect.aws.lookoutequipment.DataIngestionJobSummary/Status
     :cognitect.aws.lookoutequipment.DataIngestionJobSummary/JobId]))

(s/def
  :cognitect.aws.lookoutequipment/LabelGroupName
  (s/spec #(re-matches (re-pattern "^[0-9a-zA-Z_-]{1,200}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/DeleteInferenceSchedulerRequest
  (s/keys
    :req-un
    [:cognitect.aws.lookoutequipment.DeleteInferenceSchedulerRequest/InferenceSchedulerName]))

(s/def
  :cognitect.aws.lookoutequipment/FileNameTimestampFormat
  (s/spec
    #(re-matches (re-pattern "^EPOCH|yyyy-MM-dd-HH-mm-ss|yyyyMMddHHmmss$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.lookoutequipment/TagKeyList
  (s/coll-of :cognitect.aws.lookoutequipment/TagKey :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.lookoutequipment.MissingCompleteSensorData/AffectedSensorCount
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/MaxResults
  :cognitect.aws.lookoutequipment/MaxResults)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/InferenceSchedulerNameBeginsWith
  :cognitect.aws.lookoutequipment/InferenceSchedulerIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceSchedulersRequest/Status
  :cognitect.aws.lookoutequipment/InferenceSchedulerStatus)

(s/def
  :cognitect.aws.lookoutequipment.TagResourceRequest/ResourceArn
  :cognitect.aws.lookoutequipment/AmazonResourceArn)

(s/def
  :cognitect.aws.lookoutequipment.TagResourceRequest/Tags
  :cognitect.aws.lookoutequipment/TagList)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelGroupsRequest/LabelGroupNameBeginsWith
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelGroupsRequest/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelGroupsRequest/MaxResults
  :cognitect.aws.lookoutequipment/MaxResults)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceSchedulersResponse/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceSchedulersResponse/InferenceSchedulerSummaries
  :cognitect.aws.lookoutequipment/InferenceSchedulerSummaries)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelRequest/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelRequest/LabelId
  :cognitect.aws.lookoutequipment/LabelId)

(s/def
  :cognitect.aws.lookoutequipment.DatasetSchema/InlineDataSchema
  :cognitect.aws.lookoutequipment/InlineDataSchema)

(s/def
  :cognitect.aws.lookoutequipment.ListSensorStatisticsRequest/DatasetName
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.ListSensorStatisticsRequest/IngestionJobId
  :cognitect.aws.lookoutequipment/IngestionJobId)

(s/def
  :cognitect.aws.lookoutequipment.ListSensorStatisticsRequest/MaxResults
  :cognitect.aws.lookoutequipment/MaxResults)

(s/def
  :cognitect.aws.lookoutequipment.ListSensorStatisticsRequest/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListDataIngestionJobsRequest/DatasetName
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.ListDataIngestionJobsRequest/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListDataIngestionJobsRequest/MaxResults
  :cognitect.aws.lookoutequipment/MaxResults)

(s/def
  :cognitect.aws.lookoutequipment.ListDataIngestionJobsRequest/Status
  :cognitect.aws.lookoutequipment/IngestionJobStatus)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/ComponentName
  :cognitect.aws.lookoutequipment/ComponentName)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/DataStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/InvalidValues
  :cognitect.aws.lookoutequipment/CountPercent)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/DataEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/MissingValues
  :cognitect.aws.lookoutequipment/CountPercent)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/CategoricalValues
  :cognitect.aws.lookoutequipment/CategoricalValues)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/InvalidDateEntries
  :cognitect.aws.lookoutequipment/CountPercent)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/MultipleOperatingModes
  :cognitect.aws.lookoutequipment/MultipleOperatingModes)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/DuplicateTimestamps
  :cognitect.aws.lookoutequipment/CountPercent)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/LargeTimestampGaps
  :cognitect.aws.lookoutequipment/LargeTimestampGaps)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/MonotonicValues
  :cognitect.aws.lookoutequipment/MonotonicValues)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/SensorName
  :cognitect.aws.lookoutequipment/SensorName)

(s/def
  :cognitect.aws.lookoutequipment.SensorStatisticsSummary/DataExists
  :cognitect.aws.lookoutequipment/Boolean)

(s/def
  :cognitect.aws.lookoutequipment.InferenceS3OutputConfiguration/Bucket
  :cognitect.aws.lookoutequipment/S3Bucket)

(s/def
  :cognitect.aws.lookoutequipment.InferenceS3OutputConfiguration/Prefix
  :cognitect.aws.lookoutequipment/S3Prefix)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/LabelGroupArn
  :cognitect.aws.lookoutequipment/LabelGroupArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/FaultCodes
  :cognitect.aws.lookoutequipment/FaultCodes)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelGroupResponse/UpdatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def :cognitect.aws.lookoutequipment.Tag/Key :cognitect.aws.lookoutequipment/TagKey)

(s/def :cognitect.aws.lookoutequipment.Tag/Value :cognitect.aws.lookoutequipment/TagValue)

(s/def
  :cognitect.aws.lookoutequipment.ModelSummary/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.ModelSummary/ModelArn
  :cognitect.aws.lookoutequipment/ModelArn)

(s/def
  :cognitect.aws.lookoutequipment.ModelSummary/DatasetName
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.ModelSummary/DatasetArn
  :cognitect.aws.lookoutequipment/DatasetArn)

(s/def
  :cognitect.aws.lookoutequipment.ModelSummary/Status
  :cognitect.aws.lookoutequipment/ModelStatus)

(s/def
  :cognitect.aws.lookoutequipment.ModelSummary/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelRequest/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelGroupResponse/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelGroupResponse/LabelGroupArn
  :cognitect.aws.lookoutequipment/LabelGroupArn)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/DatasetSchema
  :cognitect.aws.lookoutequipment/DatasetSchema)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/TrainingDataStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/ServerSideKmsKeyId
  :cognitect.aws.lookoutequipment/NameOrArn)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/Tags
  :cognitect.aws.lookoutequipment/TagList)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/EvaluationDataEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/DataPreProcessingConfiguration
  :cognitect.aws.lookoutequipment/DataPreProcessingConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/RoleArn
  :cognitect.aws.lookoutequipment/IamRoleArn)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/OffCondition
  :cognitect.aws.lookoutequipment/OffCondition)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/TrainingDataEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/LabelsInputConfiguration
  :cognitect.aws.lookoutequipment/LabelsInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/ClientToken
  :cognitect.aws.lookoutequipment/IdempotenceToken)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/DatasetName
  :cognitect.aws.lookoutequipment/DatasetIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelRequest/EvaluationDataStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DeleteLabelRequest/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.DeleteLabelRequest/LabelId
  :cognitect.aws.lookoutequipment/LabelId)

(s/def
  :cognitect.aws.lookoutequipment.InferenceEventSummary/InferenceSchedulerArn
  :cognitect.aws.lookoutequipment/InferenceSchedulerArn)

(s/def
  :cognitect.aws.lookoutequipment.InferenceEventSummary/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerName)

(s/def
  :cognitect.aws.lookoutequipment.InferenceEventSummary/EventStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.InferenceEventSummary/EventEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.InferenceEventSummary/Diagnostics
  :cognitect.aws.lookoutequipment/ModelMetrics)

(s/def
  :cognitect.aws.lookoutequipment.InferenceEventSummary/EventDurationInSeconds
  :cognitect.aws.lookoutequipment/EventDurationInSeconds)

(s/def
  :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/DataDelayOffsetInMinutes
  :cognitect.aws.lookoutequipment/DataDelayOffsetInMinutes)

(s/def
  :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/DataUploadFrequency
  :cognitect.aws.lookoutequipment/DataUploadFrequency)

(s/def
  :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/DataInputConfiguration
  :cognitect.aws.lookoutequipment/InferenceInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/DataOutputConfiguration
  :cognitect.aws.lookoutequipment/InferenceOutputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.UpdateInferenceSchedulerRequest/RoleArn
  :cognitect.aws.lookoutequipment/IamRoleArn)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceExecutionsResponse/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceExecutionsResponse/InferenceExecutionSummaries
  :cognitect.aws.lookoutequipment/InferenceExecutionSummaries)

(s/def
  :cognitect.aws.lookoutequipment.UnsupportedTimestamps/TotalNumberOfUnsupportedTimestamps
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.ListDatasetsRequest/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListDatasetsRequest/MaxResults
  :cognitect.aws.lookoutequipment/MaxResults)

(s/def
  :cognitect.aws.lookoutequipment.ListDatasetsRequest/DatasetNameBeginsWith
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.DeleteModelRequest/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelsRequest/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelsRequest/IntervalStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelsRequest/IntervalEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelsRequest/FaultCode
  :cognitect.aws.lookoutequipment/FaultCode)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelsRequest/Equipment
  :cognitect.aws.lookoutequipment/Equipment)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelsRequest/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelsRequest/MaxResults
  :cognitect.aws.lookoutequipment/MaxResults)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/LabelGroupArn
  :cognitect.aws.lookoutequipment/LabelGroupArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/EndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/Rating
  :cognitect.aws.lookoutequipment/LabelRating)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/LabelId
  :cognitect.aws.lookoutequipment/LabelId)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/StartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/Notes
  :cognitect.aws.lookoutequipment/Comments)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/Equipment
  :cognitect.aws.lookoutequipment/Equipment)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/FaultCode
  :cognitect.aws.lookoutequipment/FaultCode)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelResponse/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.DeleteDatasetRequest/DatasetName
  :cognitect.aws.lookoutequipment/DatasetIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.IngestionS3InputConfiguration/Bucket
  :cognitect.aws.lookoutequipment/S3Bucket)

(s/def
  :cognitect.aws.lookoutequipment.IngestionS3InputConfiguration/Prefix
  :cognitect.aws.lookoutequipment/S3Prefix)

(s/def
  :cognitect.aws.lookoutequipment.IngestionS3InputConfiguration/KeyPattern
  :cognitect.aws.lookoutequipment/KeyPattern)

(s/def
  :cognitect.aws.lookoutequipment.InferenceInputConfiguration/S3InputConfiguration
  :cognitect.aws.lookoutequipment/InferenceS3InputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.InferenceInputConfiguration/InputTimeZoneOffset
  :cognitect.aws.lookoutequipment/TimeZoneOffset)

(s/def
  :cognitect.aws.lookoutequipment.InferenceInputConfiguration/InferenceInputNameConfiguration
  :cognitect.aws.lookoutequipment/InferenceInputNameConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.IngestedFilesSummary/TotalNumberOfFiles
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.IngestedFilesSummary/IngestedNumberOfFiles
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.IngestedFilesSummary/DiscardedFiles
  :cognitect.aws.lookoutequipment/ListOfDiscardedFiles)

(s/def
  :cognitect.aws.lookoutequipment.LabelsS3InputConfiguration/Bucket
  :cognitect.aws.lookoutequipment/S3Bucket)

(s/def
  :cognitect.aws.lookoutequipment.LabelsS3InputConfiguration/Prefix
  :cognitect.aws.lookoutequipment/S3Prefix)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelGroupRequest/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelGroupRequest/FaultCodes
  :cognitect.aws.lookoutequipment/FaultCodes)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelGroupRequest/ClientToken
  :cognitect.aws.lookoutequipment/IdempotenceToken)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelGroupRequest/Tags
  :cognitect.aws.lookoutequipment/TagList)

(s/def
  :cognitect.aws.lookoutequipment.ListDataIngestionJobsResponse/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListDataIngestionJobsResponse/DataIngestionJobSummaries
  :cognitect.aws.lookoutequipment/DataIngestionJobSummaries)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/DataStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/DataEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/JobId
  :cognitect.aws.lookoutequipment/IngestionJobId)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/IngestedFilesSummary
  :cognitect.aws.lookoutequipment/IngestedFilesSummary)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/StatusDetail
  :cognitect.aws.lookoutequipment/BoundedLengthString)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/DatasetArn
  :cognitect.aws.lookoutequipment/DatasetArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/DataQualitySummary
  :cognitect.aws.lookoutequipment/DataQualitySummary)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/RoleArn
  :cognitect.aws.lookoutequipment/IamRoleArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/IngestedDataSize
  :cognitect.aws.lookoutequipment/DataSizeInBytes)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/IngestionInputConfiguration
  :cognitect.aws.lookoutequipment/IngestionInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/FailedReason
  :cognitect.aws.lookoutequipment/BoundedLengthString)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobResponse/Status
  :cognitect.aws.lookoutequipment/IngestionJobStatus)

(s/def
  :cognitect.aws.lookoutequipment.CategoricalValues/Status
  :cognitect.aws.lookoutequipment/StatisticalIssueStatus)

(s/def
  :cognitect.aws.lookoutequipment.CategoricalValues/NumberOfCategory
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.ListModelsResponse/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListModelsResponse/ModelSummaries
  :cognitect.aws.lookoutequipment/ModelSummaries)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerResponse/InferenceSchedulerArn
  :cognitect.aws.lookoutequipment/InferenceSchedulerArn)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerResponse/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerName)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerResponse/Status
  :cognitect.aws.lookoutequipment/InferenceSchedulerStatus)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DataStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DataEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/IngestedFilesSummary
  :cognitect.aws.lookoutequipment/IngestedFilesSummary)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/ServerSideKmsKeyId
  :cognitect.aws.lookoutequipment/KmsKeyArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/LastUpdatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DatasetArn
  :cognitect.aws.lookoutequipment/DatasetArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DataQualitySummary
  :cognitect.aws.lookoutequipment/DataQualitySummary)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/RoleArn
  :cognitect.aws.lookoutequipment/IamRoleArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/Schema
  :cognitect.aws.lookoutequipment/InlineDataSchema)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/IngestionInputConfiguration
  :cognitect.aws.lookoutequipment/IngestionInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/DatasetName
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetResponse/Status
  :cognitect.aws.lookoutequipment/DatasetStatus)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceEventsResponse/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceEventsResponse/InferenceEventSummaries
  :cognitect.aws.lookoutequipment/InferenceEventSummaries)

(s/def
  :cognitect.aws.lookoutequipment.SensorsWithShortDateRange/AffectedSensorCount
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelResponse/LabelId
  :cognitect.aws.lookoutequipment/LabelId)

(s/def
  :cognitect.aws.lookoutequipment.MissingSensorData/AffectedSensorCount
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.MissingSensorData/TotalNumberOfMissingValues
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/TrainingExecutionStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/LastUpdatedTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/TrainingDataStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/ServerSideKmsKeyId
  :cognitect.aws.lookoutequipment/KmsKeyArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/ModelMetrics
  :cognitect.aws.lookoutequipment/ModelMetrics)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/EvaluationDataEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/DatasetArn
  :cognitect.aws.lookoutequipment/DatasetArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/ModelArn
  :cognitect.aws.lookoutequipment/ModelArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/TrainingExecutionEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/DataPreProcessingConfiguration
  :cognitect.aws.lookoutequipment/DataPreProcessingConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/RoleArn
  :cognitect.aws.lookoutequipment/IamRoleArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/OffCondition
  :cognitect.aws.lookoutequipment/OffCondition)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/TrainingDataEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/Schema
  :cognitect.aws.lookoutequipment/InlineDataSchema)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/LabelsInputConfiguration
  :cognitect.aws.lookoutequipment/LabelsInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/FailedReason
  :cognitect.aws.lookoutequipment/BoundedLengthString)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/DatasetName
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/EvaluationDataStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeModelResponse/Status
  :cognitect.aws.lookoutequipment/ModelStatus)

(s/def
  :cognitect.aws.lookoutequipment.DeleteLabelGroupRequest/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.CreateDatasetResponse/DatasetName
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.CreateDatasetResponse/DatasetArn
  :cognitect.aws.lookoutequipment/DatasetArn)

(s/def
  :cognitect.aws.lookoutequipment.CreateDatasetResponse/Status
  :cognitect.aws.lookoutequipment/DatasetStatus)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelRequest/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelRequest/StartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelRequest/EndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelRequest/Rating
  :cognitect.aws.lookoutequipment/LabelRating)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelRequest/FaultCode
  :cognitect.aws.lookoutequipment/FaultCode)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelRequest/Notes
  :cognitect.aws.lookoutequipment/Comments)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelRequest/Equipment
  :cognitect.aws.lookoutequipment/Equipment)

(s/def
  :cognitect.aws.lookoutequipment.CreateLabelRequest/ClientToken
  :cognitect.aws.lookoutequipment/IdempotenceToken)

(s/def
  :cognitect.aws.lookoutequipment.MultipleOperatingModes/Status
  :cognitect.aws.lookoutequipment/StatisticalIssueStatus)

(s/def
  :cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/ModelArn
  :cognitect.aws.lookoutequipment/ModelArn)

(s/def
  :cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerName)

(s/def
  :cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/InferenceSchedulerArn
  :cognitect.aws.lookoutequipment/InferenceSchedulerArn)

(s/def
  :cognitect.aws.lookoutequipment.StartInferenceSchedulerResponse/Status
  :cognitect.aws.lookoutequipment/InferenceSchedulerStatus)

(s/def
  :cognitect.aws.lookoutequipment.DataPreProcessingConfiguration/TargetSamplingRate
  :cognitect.aws.lookoutequipment/TargetSamplingRate)

(s/def
  :cognitect.aws.lookoutequipment.DataQualitySummary/InsufficientSensorData
  :cognitect.aws.lookoutequipment/InsufficientSensorData)

(s/def
  :cognitect.aws.lookoutequipment.DataQualitySummary/MissingSensorData
  :cognitect.aws.lookoutequipment/MissingSensorData)

(s/def
  :cognitect.aws.lookoutequipment.DataQualitySummary/InvalidSensorData
  :cognitect.aws.lookoutequipment/InvalidSensorData)

(s/def
  :cognitect.aws.lookoutequipment.DataQualitySummary/UnsupportedTimestamps
  :cognitect.aws.lookoutequipment/UnsupportedTimestamps)

(s/def
  :cognitect.aws.lookoutequipment.DataQualitySummary/DuplicateTimestamps
  :cognitect.aws.lookoutequipment/DuplicateTimestamps)

(s/def
  :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/ModelArn
  :cognitect.aws.lookoutequipment/ModelArn)

(s/def
  :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerName)

(s/def
  :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/InferenceSchedulerArn
  :cognitect.aws.lookoutequipment/InferenceSchedulerArn)

(s/def
  :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/Status
  :cognitect.aws.lookoutequipment/InferenceSchedulerStatus)

(s/def
  :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/DataDelayOffsetInMinutes
  :cognitect.aws.lookoutequipment/DataDelayOffsetInMinutes)

(s/def
  :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/DataUploadFrequency
  :cognitect.aws.lookoutequipment/DataUploadFrequency)

(s/def
  :cognitect.aws.lookoutequipment.InferenceSchedulerSummary/LatestInferenceResult
  :cognitect.aws.lookoutequipment/LatestInferenceResult)

(s/def
  :cognitect.aws.lookoutequipment.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.lookoutequipment/AmazonResourceArn)

(s/def
  :cognitect.aws.lookoutequipment.ListDatasetsResponse/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListDatasetsResponse/DatasetSummaries
  :cognitect.aws.lookoutequipment/DatasetSummaries)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/MaxResults
  :cognitect.aws.lookoutequipment/MaxResults)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/DataStartTimeAfter
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/DataEndTimeBefore
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceExecutionsRequest/Status
  :cognitect.aws.lookoutequipment/InferenceExecutionStatus)

(s/def
  :cognitect.aws.lookoutequipment.InferenceS3InputConfiguration/Bucket
  :cognitect.aws.lookoutequipment/S3Bucket)

(s/def
  :cognitect.aws.lookoutequipment.InferenceS3InputConfiguration/Prefix
  :cognitect.aws.lookoutequipment/S3Prefix)

(s/def
  :cognitect.aws.lookoutequipment.LabelGroupSummary/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.LabelGroupSummary/LabelGroupArn
  :cognitect.aws.lookoutequipment/LabelGroupArn)

(s/def
  :cognitect.aws.lookoutequipment.LabelGroupSummary/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.LabelGroupSummary/UpdatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.CreateDatasetRequest/DatasetName
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.CreateDatasetRequest/DatasetSchema
  :cognitect.aws.lookoutequipment/DatasetSchema)

(s/def
  :cognitect.aws.lookoutequipment.CreateDatasetRequest/ServerSideKmsKeyId
  :cognitect.aws.lookoutequipment/NameOrArn)

(s/def
  :cognitect.aws.lookoutequipment.CreateDatasetRequest/ClientToken
  :cognitect.aws.lookoutequipment/IdempotenceToken)

(s/def
  :cognitect.aws.lookoutequipment.CreateDatasetRequest/Tags
  :cognitect.aws.lookoutequipment/TagList)

(s/def
  :cognitect.aws.lookoutequipment.DatasetSummary/DatasetName
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.DatasetSummary/DatasetArn
  :cognitect.aws.lookoutequipment/DatasetArn)

(s/def
  :cognitect.aws.lookoutequipment.DatasetSummary/Status
  :cognitect.aws.lookoutequipment/DatasetStatus)

(s/def
  :cognitect.aws.lookoutequipment.DatasetSummary/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.StopInferenceSchedulerRequest/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelGroupsResponse/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelGroupsResponse/LabelGroupSummaries
  :cognitect.aws.lookoutequipment/LabelGroupSummaries)

(s/def
  :cognitect.aws.lookoutequipment.InferenceInputNameConfiguration/TimestampFormat
  :cognitect.aws.lookoutequipment/FileNameTimestampFormat)

(s/def
  :cognitect.aws.lookoutequipment.InferenceInputNameConfiguration/ComponentTimestampDelimiter
  :cognitect.aws.lookoutequipment/ComponentTimestampDelimiter)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerRequest/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerIdentifier)

(s/def :cognitect.aws.lookoutequipment.S3Object/Bucket :cognitect.aws.lookoutequipment/S3Bucket)

(s/def :cognitect.aws.lookoutequipment.S3Object/Key :cognitect.aws.lookoutequipment/S3Key)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceEventsRequest/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceEventsRequest/MaxResults
  :cognitect.aws.lookoutequipment/MaxResults)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceEventsRequest/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceEventsRequest/IntervalStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.ListInferenceEventsRequest/IntervalEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDataIngestionJobRequest/JobId
  :cognitect.aws.lookoutequipment/IngestionJobId)

(s/def
  :cognitect.aws.lookoutequipment.StartDataIngestionJobRequest/DatasetName
  :cognitect.aws.lookoutequipment/DatasetIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.StartDataIngestionJobRequest/IngestionInputConfiguration
  :cognitect.aws.lookoutequipment/IngestionInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.StartDataIngestionJobRequest/RoleArn
  :cognitect.aws.lookoutequipment/IamRoleArn)

(s/def
  :cognitect.aws.lookoutequipment.StartDataIngestionJobRequest/ClientToken
  :cognitect.aws.lookoutequipment/IdempotenceToken)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/DataStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/ScheduledStartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/DataOutputConfiguration
  :cognitect.aws.lookoutequipment/InferenceOutputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/DataEndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/ModelArn
  :cognitect.aws.lookoutequipment/ModelArn)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/DataInputConfiguration
  :cognitect.aws.lookoutequipment/InferenceInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerName)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/FailedReason
  :cognitect.aws.lookoutequipment/BoundedLengthString)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/InferenceSchedulerArn
  :cognitect.aws.lookoutequipment/InferenceSchedulerArn)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/CustomerResultObject
  :cognitect.aws.lookoutequipment/S3Object)

(s/def
  :cognitect.aws.lookoutequipment.InferenceExecutionSummary/Status
  :cognitect.aws.lookoutequipment/InferenceExecutionStatus)

(s/def
  :cognitect.aws.lookoutequipment.DuplicateTimestamps/TotalNumberOfDuplicateTimestamps
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.DescribeLabelGroupRequest/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def :cognitect.aws.lookoutequipment.CountPercent/Count :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.CountPercent/Percentage
  :cognitect.aws.lookoutequipment/Float)

(s/def
  :cognitect.aws.lookoutequipment.LargeTimestampGaps/Status
  :cognitect.aws.lookoutequipment/StatisticalIssueStatus)

(s/def
  :cognitect.aws.lookoutequipment.LargeTimestampGaps/NumberOfLargeTimestampGaps
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.LargeTimestampGaps/MaxTimestampGapInDays
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelsResponse/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListLabelsResponse/LabelSummaries
  :cognitect.aws.lookoutequipment/LabelSummaries)

(s/def
  :cognitect.aws.lookoutequipment.UntagResourceRequest/ResourceArn
  :cognitect.aws.lookoutequipment/AmazonResourceArn)

(s/def
  :cognitect.aws.lookoutequipment.UntagResourceRequest/TagKeys
  :cognitect.aws.lookoutequipment/TagKeyList)

(s/def
  :cognitect.aws.lookoutequipment.LabelsInputConfiguration/S3InputConfiguration
  :cognitect.aws.lookoutequipment/LabelsS3InputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.LabelsInputConfiguration/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.StartDataIngestionJobResponse/JobId
  :cognitect.aws.lookoutequipment/IngestionJobId)

(s/def
  :cognitect.aws.lookoutequipment.StartDataIngestionJobResponse/Status
  :cognitect.aws.lookoutequipment/IngestionJobStatus)

(s/def
  :cognitect.aws.lookoutequipment.UpdateLabelGroupRequest/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.UpdateLabelGroupRequest/FaultCodes
  :cognitect.aws.lookoutequipment/FaultCodes)

(s/def
  :cognitect.aws.lookoutequipment.MonotonicValues/Status
  :cognitect.aws.lookoutequipment/StatisticalIssueStatus)

(s/def
  :cognitect.aws.lookoutequipment.MonotonicValues/Monotonicity
  :cognitect.aws.lookoutequipment/Monotonicity)

(s/def
  :cognitect.aws.lookoutequipment.InsufficientSensorData/MissingCompleteSensorData
  :cognitect.aws.lookoutequipment/MissingCompleteSensorData)

(s/def
  :cognitect.aws.lookoutequipment.InsufficientSensorData/SensorsWithShortDateRange
  :cognitect.aws.lookoutequipment/SensorsWithShortDateRange)

(s/def
  :cognitect.aws.lookoutequipment.DescribeDatasetRequest/DatasetName
  :cognitect.aws.lookoutequipment/DatasetIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.InvalidSensorData/AffectedSensorCount
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.InvalidSensorData/TotalNumberOfInvalidValues
  :cognitect.aws.lookoutequipment/Integer)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelResponse/ModelArn
  :cognitect.aws.lookoutequipment/ModelArn)

(s/def
  :cognitect.aws.lookoutequipment.CreateModelResponse/Status
  :cognitect.aws.lookoutequipment/ModelStatus)

(s/def
  :cognitect.aws.lookoutequipment.IngestionInputConfiguration/S3InputConfiguration
  :cognitect.aws.lookoutequipment/IngestionS3InputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.LabelSummary/LabelGroupArn
  :cognitect.aws.lookoutequipment/LabelGroupArn)

(s/def
  :cognitect.aws.lookoutequipment.LabelSummary/EndTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.LabelSummary/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.LabelSummary/Rating
  :cognitect.aws.lookoutequipment/LabelRating)

(s/def :cognitect.aws.lookoutequipment.LabelSummary/LabelId :cognitect.aws.lookoutequipment/LabelId)

(s/def
  :cognitect.aws.lookoutequipment.LabelSummary/StartTime
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.LabelSummary/Equipment
  :cognitect.aws.lookoutequipment/Equipment)

(s/def
  :cognitect.aws.lookoutequipment.LabelSummary/FaultCode
  :cognitect.aws.lookoutequipment/FaultCode)

(s/def
  :cognitect.aws.lookoutequipment.LabelSummary/LabelGroupName
  :cognitect.aws.lookoutequipment/LabelGroupName)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/CreatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/DataOutputConfiguration
  :cognitect.aws.lookoutequipment/InferenceOutputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/UpdatedAt
  :cognitect.aws.lookoutequipment/Timestamp)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/ServerSideKmsKeyId
  :cognitect.aws.lookoutequipment/KmsKeyArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/DataUploadFrequency
  :cognitect.aws.lookoutequipment/DataUploadFrequency)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/ModelArn
  :cognitect.aws.lookoutequipment/ModelArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/RoleArn
  :cognitect.aws.lookoutequipment/IamRoleArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/DataDelayOffsetInMinutes
  :cognitect.aws.lookoutequipment/DataDelayOffsetInMinutes)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/DataInputConfiguration
  :cognitect.aws.lookoutequipment/InferenceInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerName)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/LatestInferenceResult
  :cognitect.aws.lookoutequipment/LatestInferenceResult)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/InferenceSchedulerArn
  :cognitect.aws.lookoutequipment/InferenceSchedulerArn)

(s/def
  :cognitect.aws.lookoutequipment.DescribeInferenceSchedulerResponse/Status
  :cognitect.aws.lookoutequipment/InferenceSchedulerStatus)

(s/def
  :cognitect.aws.lookoutequipment.StartInferenceSchedulerRequest/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerIdentifier)

(s/def
  :cognitect.aws.lookoutequipment.ListSensorStatisticsResponse/SensorStatisticsSummaries
  :cognitect.aws.lookoutequipment/SensorStatisticsSummaries)

(s/def
  :cognitect.aws.lookoutequipment.ListSensorStatisticsResponse/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListModelsRequest/NextToken
  :cognitect.aws.lookoutequipment/NextToken)

(s/def
  :cognitect.aws.lookoutequipment.ListModelsRequest/MaxResults
  :cognitect.aws.lookoutequipment/MaxResults)

(s/def
  :cognitect.aws.lookoutequipment.ListModelsRequest/Status
  :cognitect.aws.lookoutequipment/ModelStatus)

(s/def
  :cognitect.aws.lookoutequipment.ListModelsRequest/ModelNameBeginsWith
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.ListModelsRequest/DatasetNameBeginsWith
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.ListTagsForResourceResponse/Tags
  :cognitect.aws.lookoutequipment/TagList)

(s/def
  :cognitect.aws.lookoutequipment.InferenceOutputConfiguration/S3OutputConfiguration
  :cognitect.aws.lookoutequipment/InferenceS3OutputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.InferenceOutputConfiguration/KmsKeyId
  :cognitect.aws.lookoutequipment/NameOrArn)

(s/def
  :cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/ModelArn
  :cognitect.aws.lookoutequipment/ModelArn)

(s/def
  :cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerName)

(s/def
  :cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/InferenceSchedulerArn
  :cognitect.aws.lookoutequipment/InferenceSchedulerArn)

(s/def
  :cognitect.aws.lookoutequipment.StopInferenceSchedulerResponse/Status
  :cognitect.aws.lookoutequipment/InferenceSchedulerStatus)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/DataOutputConfiguration
  :cognitect.aws.lookoutequipment/InferenceOutputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/ServerSideKmsKeyId
  :cognitect.aws.lookoutequipment/NameOrArn)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/Tags
  :cognitect.aws.lookoutequipment/TagList)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/ModelName
  :cognitect.aws.lookoutequipment/ModelName)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/DataUploadFrequency
  :cognitect.aws.lookoutequipment/DataUploadFrequency)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/RoleArn
  :cognitect.aws.lookoutequipment/IamRoleArn)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/DataDelayOffsetInMinutes
  :cognitect.aws.lookoutequipment/DataDelayOffsetInMinutes)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/DataInputConfiguration
  :cognitect.aws.lookoutequipment/InferenceInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerName)

(s/def
  :cognitect.aws.lookoutequipment.CreateInferenceSchedulerRequest/ClientToken
  :cognitect.aws.lookoutequipment/IdempotenceToken)

(s/def
  :cognitect.aws.lookoutequipment.DataIngestionJobSummary/JobId
  :cognitect.aws.lookoutequipment/IngestionJobId)

(s/def
  :cognitect.aws.lookoutequipment.DataIngestionJobSummary/DatasetName
  :cognitect.aws.lookoutequipment/DatasetName)

(s/def
  :cognitect.aws.lookoutequipment.DataIngestionJobSummary/DatasetArn
  :cognitect.aws.lookoutequipment/DatasetArn)

(s/def
  :cognitect.aws.lookoutequipment.DataIngestionJobSummary/IngestionInputConfiguration
  :cognitect.aws.lookoutequipment/IngestionInputConfiguration)

(s/def
  :cognitect.aws.lookoutequipment.DataIngestionJobSummary/Status
  :cognitect.aws.lookoutequipment/IngestionJobStatus)

(s/def
  :cognitect.aws.lookoutequipment.DeleteInferenceSchedulerRequest/InferenceSchedulerName
  :cognitect.aws.lookoutequipment/InferenceSchedulerIdentifier)

