;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.macie.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.macie/ErrorCode
  (s/spec
    (s/and string? #(>= 10 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 10) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.macie/ListMemberAccountsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.macie.ListMemberAccountsRequest/maxResults
     :cognitect.aws.macie.ListMemberAccountsRequest/nextToken]))

(s/def
  :cognitect.aws.macie/MemberAccount
  (s/keys :opt-un [:cognitect.aws.macie.MemberAccount/accountId]))

(s/def
  :cognitect.aws.macie/Prefix
  (s/spec
    (s/and string? #(>= 10000 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 10000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.macie/S3ResourcesClassificationUpdate
  (s/coll-of :cognitect.aws.macie/S3ResourceClassificationUpdate))

(s/def
  :cognitect.aws.macie/ExceptionMessage
  (s/spec
    (s/and string? #(>= 10000 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 10000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.macie/FailedS3Resource
  (s/keys
    :opt-un
    [:cognitect.aws.macie.FailedS3Resource/errorMessage
     :cognitect.aws.macie.FailedS3Resource/errorCode
     :cognitect.aws.macie.FailedS3Resource/failedItem]))

(s/def
  :cognitect.aws.macie/S3ResourceClassificationUpdate
  (s/keys
    :req-un
    [:cognitect.aws.macie.S3ResourceClassificationUpdate/bucketName
     :cognitect.aws.macie.S3ResourceClassificationUpdate/classificationTypeUpdate]
    :opt-un
    [:cognitect.aws.macie.S3ResourceClassificationUpdate/prefix]))

(s/def :cognitect.aws.macie/S3Resources (s/coll-of :cognitect.aws.macie/S3Resource))

(s/def
  :cognitect.aws.macie/S3ResourcesClassification
  (s/coll-of :cognitect.aws.macie/S3ResourceClassification))

(s/def :cognitect.aws.macie/S3ContinuousClassificationType (s/spec string? :gen #(s/gen #{"FULL"})))

(s/def
  :cognitect.aws.macie/UpdateS3ResourcesResult
  (s/keys :opt-un [:cognitect.aws.macie.UpdateS3ResourcesResult/failedS3Resources]))

(s/def
  :cognitect.aws.macie/S3Resource
  (s/keys
    :req-un
    [:cognitect.aws.macie.S3Resource/bucketName]
    :opt-un
    [:cognitect.aws.macie.S3Resource/prefix]))

(s/def
  :cognitect.aws.macie/S3ResourceClassification
  (s/keys
    :req-un
    [:cognitect.aws.macie.S3ResourceClassification/bucketName
     :cognitect.aws.macie.S3ResourceClassification/classificationType]
    :opt-un
    [:cognitect.aws.macie.S3ResourceClassification/prefix]))

(s/def
  :cognitect.aws.macie/NextToken
  (s/spec
    (s/and string? #(>= 500 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.macie/AssociateMemberAccountRequest
  (s/keys :req-un [:cognitect.aws.macie.AssociateMemberAccountRequest/memberAccountId]))

(s/def
  :cognitect.aws.macie/DisassociateS3ResourcesResult
  (s/keys :opt-un [:cognitect.aws.macie.DisassociateS3ResourcesResult/failedS3Resources]))

(s/def
  :cognitect.aws.macie/ClassificationTypeUpdate
  (s/keys
    :opt-un
    [:cognitect.aws.macie.ClassificationTypeUpdate/oneTime
     :cognitect.aws.macie.ClassificationTypeUpdate/continuous]))

(s/def
  :cognitect.aws.macie/AssociateS3ResourcesRequest
  (s/keys
    :req-un
    [:cognitect.aws.macie.AssociateS3ResourcesRequest/s3Resources]
    :opt-un
    [:cognitect.aws.macie.AssociateS3ResourcesRequest/memberAccountId]))

(s/def
  :cognitect.aws.macie/DisassociateMemberAccountRequest
  (s/keys :req-un [:cognitect.aws.macie.DisassociateMemberAccountRequest/memberAccountId]))

(s/def
  :cognitect.aws.macie/S3OneTimeClassificationType
  (s/spec string? :gen #(s/gen #{"FULL" "NONE"})))

(s/def :cognitect.aws.macie/MemberAccounts (s/coll-of :cognitect.aws.macie/MemberAccount))

(s/def
  :cognitect.aws.macie/ListS3ResourcesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.macie.ListS3ResourcesRequest/maxResults
     :cognitect.aws.macie.ListS3ResourcesRequest/nextToken
     :cognitect.aws.macie.ListS3ResourcesRequest/memberAccountId]))

(s/def :cognitect.aws.macie/FailedS3Resources (s/coll-of :cognitect.aws.macie/FailedS3Resource))

(s/def
  :cognitect.aws.macie/ListMemberAccountsResult
  (s/keys
    :opt-un
    [:cognitect.aws.macie.ListMemberAccountsResult/nextToken
     :cognitect.aws.macie.ListMemberAccountsResult/memberAccounts]))

(s/def
  :cognitect.aws.macie/ListS3ResourcesResult
  (s/keys
    :opt-un
    [:cognitect.aws.macie.ListS3ResourcesResult/s3Resources
     :cognitect.aws.macie.ListS3ResourcesResult/nextToken]))

(s/def
  :cognitect.aws.macie/UpdateS3ResourcesRequest
  (s/keys
    :req-un
    [:cognitect.aws.macie.UpdateS3ResourcesRequest/s3ResourcesUpdate]
    :opt-un
    [:cognitect.aws.macie.UpdateS3ResourcesRequest/memberAccountId]))

(s/def
  :cognitect.aws.macie/BucketName
  (s/spec
    (s/and string? #(>= 500 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.macie/MaxResults
  (s/spec (s/and int? #(>= 250 %)) :gen #(gen/choose Long/MIN_VALUE 250)))

(s/def
  :cognitect.aws.macie/ClassificationType
  (s/keys
    :req-un
    [:cognitect.aws.macie.ClassificationType/oneTime
     :cognitect.aws.macie.ClassificationType/continuous]))

(s/def
  :cognitect.aws.macie/AssociateS3ResourcesResult
  (s/keys :opt-un [:cognitect.aws.macie.AssociateS3ResourcesResult/failedS3Resources]))

(s/def
  :cognitect.aws.macie/AWSAccountId
  (s/spec #(re-matches (re-pattern "[0-9]{12}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.macie/DisassociateS3ResourcesRequest
  (s/keys
    :req-un
    [:cognitect.aws.macie.DisassociateS3ResourcesRequest/associatedS3Resources]
    :opt-un
    [:cognitect.aws.macie.DisassociateS3ResourcesRequest/memberAccountId]))

(s/def :cognitect.aws.macie.ListMemberAccountsRequest/nextToken :cognitect.aws.macie/NextToken)

(s/def :cognitect.aws.macie.ListMemberAccountsRequest/maxResults :cognitect.aws.macie/MaxResults)

(s/def :cognitect.aws.macie.MemberAccount/accountId :cognitect.aws.macie/AWSAccountId)

(s/def :cognitect.aws.macie.FailedS3Resource/failedItem :cognitect.aws.macie/S3Resource)

(s/def :cognitect.aws.macie.FailedS3Resource/errorCode :cognitect.aws.macie/ErrorCode)

(s/def :cognitect.aws.macie.FailedS3Resource/errorMessage :cognitect.aws.macie/ExceptionMessage)

(s/def
  :cognitect.aws.macie.S3ResourceClassificationUpdate/bucketName
  :cognitect.aws.macie/BucketName)

(s/def :cognitect.aws.macie.S3ResourceClassificationUpdate/prefix :cognitect.aws.macie/Prefix)

(s/def
  :cognitect.aws.macie.S3ResourceClassificationUpdate/classificationTypeUpdate
  :cognitect.aws.macie/ClassificationTypeUpdate)

(s/def
  :cognitect.aws.macie.UpdateS3ResourcesResult/failedS3Resources
  :cognitect.aws.macie/FailedS3Resources)

(s/def :cognitect.aws.macie.S3Resource/bucketName :cognitect.aws.macie/BucketName)

(s/def :cognitect.aws.macie.S3Resource/prefix :cognitect.aws.macie/Prefix)

(s/def :cognitect.aws.macie.S3ResourceClassification/bucketName :cognitect.aws.macie/BucketName)

(s/def :cognitect.aws.macie.S3ResourceClassification/prefix :cognitect.aws.macie/Prefix)

(s/def
  :cognitect.aws.macie.S3ResourceClassification/classificationType
  :cognitect.aws.macie/ClassificationType)

(s/def
  :cognitect.aws.macie.AssociateMemberAccountRequest/memberAccountId
  :cognitect.aws.macie/AWSAccountId)

(s/def
  :cognitect.aws.macie.DisassociateS3ResourcesResult/failedS3Resources
  :cognitect.aws.macie/FailedS3Resources)

(s/def
  :cognitect.aws.macie.ClassificationTypeUpdate/oneTime
  :cognitect.aws.macie/S3OneTimeClassificationType)

(s/def
  :cognitect.aws.macie.ClassificationTypeUpdate/continuous
  :cognitect.aws.macie/S3ContinuousClassificationType)

(s/def
  :cognitect.aws.macie.AssociateS3ResourcesRequest/memberAccountId
  :cognitect.aws.macie/AWSAccountId)

(s/def
  :cognitect.aws.macie.AssociateS3ResourcesRequest/s3Resources
  :cognitect.aws.macie/S3ResourcesClassification)

(s/def
  :cognitect.aws.macie.DisassociateMemberAccountRequest/memberAccountId
  :cognitect.aws.macie/AWSAccountId)

(s/def
  :cognitect.aws.macie.ListS3ResourcesRequest/memberAccountId
  :cognitect.aws.macie/AWSAccountId)

(s/def :cognitect.aws.macie.ListS3ResourcesRequest/nextToken :cognitect.aws.macie/NextToken)

(s/def :cognitect.aws.macie.ListS3ResourcesRequest/maxResults :cognitect.aws.macie/MaxResults)

(s/def
  :cognitect.aws.macie.ListMemberAccountsResult/memberAccounts
  :cognitect.aws.macie/MemberAccounts)

(s/def :cognitect.aws.macie.ListMemberAccountsResult/nextToken :cognitect.aws.macie/NextToken)

(s/def
  :cognitect.aws.macie.ListS3ResourcesResult/s3Resources
  :cognitect.aws.macie/S3ResourcesClassification)

(s/def :cognitect.aws.macie.ListS3ResourcesResult/nextToken :cognitect.aws.macie/NextToken)

(s/def
  :cognitect.aws.macie.UpdateS3ResourcesRequest/memberAccountId
  :cognitect.aws.macie/AWSAccountId)

(s/def
  :cognitect.aws.macie.UpdateS3ResourcesRequest/s3ResourcesUpdate
  :cognitect.aws.macie/S3ResourcesClassificationUpdate)

(s/def
  :cognitect.aws.macie.ClassificationType/oneTime
  :cognitect.aws.macie/S3OneTimeClassificationType)

(s/def
  :cognitect.aws.macie.ClassificationType/continuous
  :cognitect.aws.macie/S3ContinuousClassificationType)

(s/def
  :cognitect.aws.macie.AssociateS3ResourcesResult/failedS3Resources
  :cognitect.aws.macie/FailedS3Resources)

(s/def
  :cognitect.aws.macie.DisassociateS3ResourcesRequest/memberAccountId
  :cognitect.aws.macie/AWSAccountId)

(s/def
  :cognitect.aws.macie.DisassociateS3ResourcesRequest/associatedS3Resources
  :cognitect.aws.macie/S3Resources)

