;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.marketplace-agreement.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.marketplace-agreement/ThrottlingException
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.ThrottlingException/message
     :cognitect.aws.marketplace-agreement.ThrottlingException/requestId]))

(s/def
  :cognitect.aws.marketplace-agreement/ValidationExceptionFieldList
  (s/coll-of :cognitect.aws.marketplace-agreement/ValidationExceptionField))

(s/def
  :cognitect.aws.marketplace-agreement/AgreementStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ARCHIVED"
        "REPLACED"
        "EXPIRED"
        "SUPERSEDED"
        "ROLLED_BACK"
        "TERMINATED"
        "ACTIVE"
        "CANCELLED"
        "RENEWED"})))

(s/def
  :cognitect.aws.marketplace-agreement/InternalServerException
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.InternalServerException/message
     :cognitect.aws.marketplace-agreement.InternalServerException/requestId]))

(s/def
  :cognitect.aws.marketplace-agreement/ResourceType
  (s/spec string? :gen #(s/gen #{"Agreement"})))

(s/def
  :cognitect.aws.marketplace-agreement/AgreementType
  (s/spec #(re-matches (re-pattern "^[A-Za-z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/ScheduleItem
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.ScheduleItem/chargeDate
     :cognitect.aws.marketplace-agreement.ScheduleItem/chargeAmount]))

(s/def
  :cognitect.aws.marketplace-agreement/GrantList
  (s/coll-of :cognitect.aws.marketplace-agreement/GrantItem))

(s/def
  :cognitect.aws.marketplace-agreement/UnversionedTermType
  (s/spec #(re-matches (re-pattern "^[A-Za-z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/ValidationExceptionField
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-agreement.ValidationExceptionField/message
     :cognitect.aws.marketplace-agreement.ValidationExceptionField/name]))

(s/def
  :cognitect.aws.marketplace-agreement/Resources
  (s/coll-of :cognitect.aws.marketplace-agreement/Resource))

(s/def
  :cognitect.aws.marketplace-agreement/GetAgreementTermsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.GetAgreementTermsOutput/acceptedTerms
     :cognitect.aws.marketplace-agreement.GetAgreementTermsOutput/nextToken]))

(s/def
  :cognitect.aws.marketplace-agreement/Dimension
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-agreement.Dimension/dimensionKey
     :cognitect.aws.marketplace-agreement.Dimension/dimensionValue]))

(s/def
  :cognitect.aws.marketplace-agreement/GrantItem
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.GrantItem/dimensionKey
     :cognitect.aws.marketplace-agreement.GrantItem/maxQuantity]))

(s/def
  :cognitect.aws.marketplace-agreement/BoundedString
  (s/spec #(re-matches (re-pattern "^(.)+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/ConfigurableUpfrontRateCardList
  (s/coll-of :cognitect.aws.marketplace-agreement/ConfigurableUpfrontRateCardItem))

(s/def
  :cognitect.aws.marketplace-agreement/Selector
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.Selector/value
     :cognitect.aws.marketplace-agreement.Selector/type]))

(s/def
  :cognitect.aws.marketplace-agreement/ExceptionMessage
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.marketplace-agreement/Filter
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.Filter/values
     :cognitect.aws.marketplace-agreement.Filter/name]))

(s/def
  :cognitect.aws.marketplace-agreement/UsageBasedPricingTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.UsageBasedPricingTerm/rateCards
     :cognitect.aws.marketplace-agreement.UsageBasedPricingTerm/currencyCode
     :cognitect.aws.marketplace-agreement.UsageBasedPricingTerm/type]))

(s/def
  :cognitect.aws.marketplace-agreement/DimensionList
  (s/coll-of :cognitect.aws.marketplace-agreement/Dimension :min-count 1))

(s/def
  :cognitect.aws.marketplace-agreement/ValidationException
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.ValidationException/message
     :cognitect.aws.marketplace-agreement.ValidationException/requestId
     :cognitect.aws.marketplace-agreement.ValidationException/fields
     :cognitect.aws.marketplace-agreement.ValidationException/reason]))

(s/def
  :cognitect.aws.marketplace-agreement/AccessDeniedException
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.AccessDeniedException/message
     :cognitect.aws.marketplace-agreement.AccessDeniedException/requestId]))

(s/def
  :cognitect.aws.marketplace-agreement/ByolPricingTerm
  (s/keys :opt-un [:cognitect.aws.marketplace-agreement.ByolPricingTerm/type]))

(s/def
  :cognitect.aws.marketplace-agreement/RenewalTermConfiguration
  (s/keys :req-un [:cognitect.aws.marketplace-agreement.RenewalTermConfiguration/enableAutoRenew]))

(s/def
  :cognitect.aws.marketplace-agreement/ValidationExceptionReason
  (s/spec
    string?
    :gen
    #(s/gen
      #{"INVALID_FILTER_NAME"
        "INVALID_AGREEMENT_ID"
        "INVALID_CATALOG"
        "INVALID_MAX_RESULTS"
        "OTHER"
        "UNSUPPORTED_FILTERS"
        "INVALID_SORT_BY"
        "INVALID_NEXT_TOKEN"
        "INVALID_FILTER_VALUES"
        "MISSING_AGREEMENT_ID"
        "INVALID_SORT_ORDER"})))

(s/def
  :cognitect.aws.marketplace-agreement/ConfigurableUpfrontRateCardItem
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.ConfigurableUpfrontRateCardItem/constraints
     :cognitect.aws.marketplace-agreement.ConfigurableUpfrontRateCardItem/rateCard
     :cognitect.aws.marketplace-agreement.ConfigurableUpfrontRateCardItem/selector]))

(s/def
  :cognitect.aws.marketplace-agreement/RenewalTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.RenewalTerm/configuration
     :cognitect.aws.marketplace-agreement.RenewalTerm/type]))

(s/def
  :cognitect.aws.marketplace-agreement/AcceptedTermList
  (s/coll-of :cognitect.aws.marketplace-agreement/AcceptedTerm))

(s/def
  :cognitect.aws.marketplace-agreement/SupportTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.SupportTerm/refundPolicy
     :cognitect.aws.marketplace-agreement.SupportTerm/type]))

(s/def
  :cognitect.aws.marketplace-agreement/FilterValueList
  (s/coll-of :cognitect.aws.marketplace-agreement/FilterValue :min-count 1 :max-count 1))

(s/def
  :cognitect.aws.marketplace-agreement/AcceptedTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.AcceptedTerm/fixedUpfrontPricingTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/renewalTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/legalTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/paymentScheduleTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/byolPricingTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/configurableUpfrontPricingTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/supportTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/freeTrialPricingTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/usageBasedPricingTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/validityTerm
     :cognitect.aws.marketplace-agreement.AcceptedTerm/recurringPaymentTerm]))

(s/def
  :cognitect.aws.marketplace-agreement/CurrencyCode
  (s/spec #(re-matches (re-pattern "^[A-Z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/ResourceId
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9_/-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/EstimatedCharges
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.EstimatedCharges/agreementValue
     :cognitect.aws.marketplace-agreement.EstimatedCharges/currencyCode]))

(s/def
  :cognitect.aws.marketplace-agreement/SearchAgreementsInput
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.SearchAgreementsInput/filters
     :cognitect.aws.marketplace-agreement.SearchAgreementsInput/sort
     :cognitect.aws.marketplace-agreement.SearchAgreementsInput/maxResults
     :cognitect.aws.marketplace-agreement.SearchAgreementsInput/nextToken
     :cognitect.aws.marketplace-agreement.SearchAgreementsInput/catalog]))

(s/def
  :cognitect.aws.marketplace-agreement/Sort
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.Sort/sortBy
     :cognitect.aws.marketplace-agreement.Sort/sortOrder]))

(s/def
  :cognitect.aws.marketplace-agreement/PaymentScheduleTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.PaymentScheduleTerm/schedule
     :cognitect.aws.marketplace-agreement.PaymentScheduleTerm/currencyCode
     :cognitect.aws.marketplace-agreement.PaymentScheduleTerm/type]))

(s/def
  :cognitect.aws.marketplace-agreement/RateCardItem
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.RateCardItem/dimensionKey
     :cognitect.aws.marketplace-agreement.RateCardItem/price]))

(s/def
  :cognitect.aws.marketplace-agreement/RecurringPaymentTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.RecurringPaymentTerm/billingPeriod
     :cognitect.aws.marketplace-agreement.RecurringPaymentTerm/currencyCode
     :cognitect.aws.marketplace-agreement.RecurringPaymentTerm/type
     :cognitect.aws.marketplace-agreement.RecurringPaymentTerm/price]))

(s/def :cognitect.aws.marketplace-agreement/Boolean boolean?)

(s/def
  :cognitect.aws.marketplace-agreement/DescribeAgreementInput
  (s/keys :req-un [:cognitect.aws.marketplace-agreement.DescribeAgreementInput/agreementId]))

(s/def
  :cognitect.aws.marketplace-agreement/AgreementViewSummaryList
  (s/coll-of :cognitect.aws.marketplace-agreement/AgreementViewSummary))

(s/def
  :cognitect.aws.marketplace-agreement/NextToken
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9+/=]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/AgreementResourceType
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/FixedUpfrontPricingTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/currencyCode
     :cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/grants
     :cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/duration
     :cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/type
     :cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/price]))

(s/def
  :cognitect.aws.marketplace-agreement/Acceptor
  (s/keys :opt-un [:cognitect.aws.marketplace-agreement.Acceptor/accountId]))

(s/def
  :cognitect.aws.marketplace-agreement/AgreementViewSummary
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.AgreementViewSummary/proposalSummary
     :cognitect.aws.marketplace-agreement.AgreementViewSummary/acceptanceTime
     :cognitect.aws.marketplace-agreement.AgreementViewSummary/proposer
     :cognitect.aws.marketplace-agreement.AgreementViewSummary/startTime
     :cognitect.aws.marketplace-agreement.AgreementViewSummary/agreementId
     :cognitect.aws.marketplace-agreement.AgreementViewSummary/status
     :cognitect.aws.marketplace-agreement.AgreementViewSummary/acceptor
     :cognitect.aws.marketplace-agreement.AgreementViewSummary/agreementType
     :cognitect.aws.marketplace-agreement.AgreementViewSummary/endTime]))

(s/def
  :cognitect.aws.marketplace-agreement/Proposer
  (s/keys :opt-un [:cognitect.aws.marketplace-agreement.Proposer/accountId]))

(s/def
  :cognitect.aws.marketplace-agreement/FreeTrialPricingTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.FreeTrialPricingTerm/grants
     :cognitect.aws.marketplace-agreement.FreeTrialPricingTerm/duration
     :cognitect.aws.marketplace-agreement.FreeTrialPricingTerm/type]))

(s/def
  :cognitect.aws.marketplace-agreement/ConfigurableUpfrontPricingTermConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTermConfiguration/dimensions
     :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTermConfiguration/selectorValue]))

(s/def
  :cognitect.aws.marketplace-agreement/Constraints
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.Constraints/quantityConfiguration
     :cognitect.aws.marketplace-agreement.Constraints/multipleDimensionSelection]))

(s/def
  :cognitect.aws.marketplace-agreement/GetAgreementTermsInput
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-agreement.GetAgreementTermsInput/agreementId]
    :opt-un
    [:cognitect.aws.marketplace-agreement.GetAgreementTermsInput/maxResults
     :cognitect.aws.marketplace-agreement.GetAgreementTermsInput/nextToken]))

(s/def
  :cognitect.aws.marketplace-agreement/RequestId
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/DocumentItem
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.DocumentItem/url
     :cognitect.aws.marketplace-agreement.DocumentItem/type
     :cognitect.aws.marketplace-agreement.DocumentItem/version]))

(s/def
  :cognitect.aws.marketplace-agreement/FilterList
  (s/coll-of :cognitect.aws.marketplace-agreement/Filter :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.marketplace-agreement/LegalTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.LegalTerm/documents
     :cognitect.aws.marketplace-agreement.LegalTerm/type]))

(s/def
  :cognitect.aws.marketplace-agreement/ZeroValueInteger
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.marketplace-agreement/SortBy
  (s/spec #(re-matches (re-pattern "^[A-Za-z_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/UsageBasedRateCardItem
  (s/keys :opt-un [:cognitect.aws.marketplace-agreement.UsageBasedRateCardItem/rateCard]))

(s/def
  :cognitect.aws.marketplace-agreement/SortOrder
  (s/spec string? :gen #(s/gen #{"ASCENDING" "DESCENDING"})))

(s/def
  :cognitect.aws.marketplace-agreement/ConfigurableUpfrontPricingTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTerm/configuration
     :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTerm/rateCards
     :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTerm/currencyCode
     :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTerm/type]))

(s/def
  :cognitect.aws.marketplace-agreement/MaxResults
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.marketplace-agreement/Resource
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.Resource/id
     :cognitect.aws.marketplace-agreement.Resource/type]))

(s/def
  :cognitect.aws.marketplace-agreement/UsageBasedRateCardList
  (s/coll-of :cognitect.aws.marketplace-agreement/UsageBasedRateCardItem))

(s/def
  :cognitect.aws.marketplace-agreement/Catalog
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.marketplace-agreement/Timestamp inst?)

(s/def
  :cognitect.aws.marketplace-agreement/FilterName
  (s/spec #(re-matches (re-pattern "^[A-Za-z_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/SearchAgreementsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.SearchAgreementsOutput/nextToken
     :cognitect.aws.marketplace-agreement.SearchAgreementsOutput/agreementViewSummaries]))

(s/def
  :cognitect.aws.marketplace-agreement/ProposalSummary
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.ProposalSummary/offerId
     :cognitect.aws.marketplace-agreement.ProposalSummary/resources]))

(s/def
  :cognitect.aws.marketplace-agreement/ValidityTerm
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.ValidityTerm/agreementEndDate
     :cognitect.aws.marketplace-agreement.ValidityTerm/agreementStartDate
     :cognitect.aws.marketplace-agreement.ValidityTerm/agreementDuration
     :cognitect.aws.marketplace-agreement.ValidityTerm/type]))

(s/def
  :cognitect.aws.marketplace-agreement/FilterValue
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9+:_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/AWSAccountId
  (s/spec #(re-matches (re-pattern "^[0-9]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/ScheduleList
  (s/coll-of :cognitect.aws.marketplace-agreement/ScheduleItem))

(s/def
  :cognitect.aws.marketplace-agreement/OfferId
  (s/spec #(re-matches (re-pattern "^\\S{1,64}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-agreement/DescribeAgreementOutput
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.DescribeAgreementOutput/proposalSummary
     :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/acceptanceTime
     :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/proposer
     :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/startTime
     :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/agreementId
     :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/status
     :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/estimatedCharges
     :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/acceptor
     :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/agreementType
     :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/endTime]))

(s/def
  :cognitect.aws.marketplace-agreement/RateCardList
  (s/coll-of :cognitect.aws.marketplace-agreement/RateCardItem))

(s/def
  :cognitect.aws.marketplace-agreement/ResourceNotFoundException
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-agreement.ResourceNotFoundException/message
     :cognitect.aws.marketplace-agreement.ResourceNotFoundException/resourceId
     :cognitect.aws.marketplace-agreement.ResourceNotFoundException/requestId
     :cognitect.aws.marketplace-agreement.ResourceNotFoundException/resourceType]))

(s/def
  :cognitect.aws.marketplace-agreement/DocumentList
  (s/coll-of :cognitect.aws.marketplace-agreement/DocumentItem))

(s/def
  :cognitect.aws.marketplace-agreement/PositiveIntegerWithDefaultValueOne
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.marketplace-agreement.ThrottlingException/message
  :cognitect.aws.marketplace-agreement/ExceptionMessage)

(s/def
  :cognitect.aws.marketplace-agreement.ThrottlingException/requestId
  :cognitect.aws.marketplace-agreement/RequestId)

(s/def
  :cognitect.aws.marketplace-agreement.InternalServerException/message
  :cognitect.aws.marketplace-agreement/ExceptionMessage)

(s/def
  :cognitect.aws.marketplace-agreement.InternalServerException/requestId
  :cognitect.aws.marketplace-agreement/RequestId)

(s/def
  :cognitect.aws.marketplace-agreement.ScheduleItem/chargeAmount
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.ScheduleItem/chargeDate
  :cognitect.aws.marketplace-agreement/Timestamp)

(s/def
  :cognitect.aws.marketplace-agreement.ValidationExceptionField/message
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.ValidationExceptionField/name
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.GetAgreementTermsOutput/acceptedTerms
  :cognitect.aws.marketplace-agreement/AcceptedTermList)

(s/def
  :cognitect.aws.marketplace-agreement.GetAgreementTermsOutput/nextToken
  :cognitect.aws.marketplace-agreement/NextToken)

(s/def
  :cognitect.aws.marketplace-agreement.Dimension/dimensionKey
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.Dimension/dimensionValue
  :cognitect.aws.marketplace-agreement/ZeroValueInteger)

(s/def
  :cognitect.aws.marketplace-agreement.GrantItem/dimensionKey
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.GrantItem/maxQuantity
  :cognitect.aws.marketplace-agreement/PositiveIntegerWithDefaultValueOne)

(s/def
  :cognitect.aws.marketplace-agreement.Selector/type
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.Selector/value
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.Filter/name
  :cognitect.aws.marketplace-agreement/FilterName)

(s/def
  :cognitect.aws.marketplace-agreement.Filter/values
  :cognitect.aws.marketplace-agreement/FilterValueList)

(s/def
  :cognitect.aws.marketplace-agreement.UsageBasedPricingTerm/currencyCode
  :cognitect.aws.marketplace-agreement/CurrencyCode)

(s/def
  :cognitect.aws.marketplace-agreement.UsageBasedPricingTerm/rateCards
  :cognitect.aws.marketplace-agreement/UsageBasedRateCardList)

(s/def
  :cognitect.aws.marketplace-agreement.UsageBasedPricingTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.ValidationException/fields
  :cognitect.aws.marketplace-agreement/ValidationExceptionFieldList)

(s/def
  :cognitect.aws.marketplace-agreement.ValidationException/message
  :cognitect.aws.marketplace-agreement/ExceptionMessage)

(s/def
  :cognitect.aws.marketplace-agreement.ValidationException/reason
  :cognitect.aws.marketplace-agreement/ValidationExceptionReason)

(s/def
  :cognitect.aws.marketplace-agreement.ValidationException/requestId
  :cognitect.aws.marketplace-agreement/RequestId)

(s/def
  :cognitect.aws.marketplace-agreement.AccessDeniedException/message
  :cognitect.aws.marketplace-agreement/ExceptionMessage)

(s/def
  :cognitect.aws.marketplace-agreement.AccessDeniedException/requestId
  :cognitect.aws.marketplace-agreement/RequestId)

(s/def
  :cognitect.aws.marketplace-agreement.ByolPricingTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.RenewalTermConfiguration/enableAutoRenew
  :cognitect.aws.marketplace-agreement/Boolean)

(s/def
  :cognitect.aws.marketplace-agreement.ConfigurableUpfrontRateCardItem/constraints
  :cognitect.aws.marketplace-agreement/Constraints)

(s/def
  :cognitect.aws.marketplace-agreement.ConfigurableUpfrontRateCardItem/rateCard
  :cognitect.aws.marketplace-agreement/RateCardList)

(s/def
  :cognitect.aws.marketplace-agreement.ConfigurableUpfrontRateCardItem/selector
  :cognitect.aws.marketplace-agreement/Selector)

(s/def
  :cognitect.aws.marketplace-agreement.RenewalTerm/configuration
  :cognitect.aws.marketplace-agreement/RenewalTermConfiguration)

(s/def
  :cognitect.aws.marketplace-agreement.RenewalTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.SupportTerm/refundPolicy
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.SupportTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/configurableUpfrontPricingTerm
  :cognitect.aws.marketplace-agreement/ConfigurableUpfrontPricingTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/recurringPaymentTerm
  :cognitect.aws.marketplace-agreement/RecurringPaymentTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/supportTerm
  :cognitect.aws.marketplace-agreement/SupportTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/freeTrialPricingTerm
  :cognitect.aws.marketplace-agreement/FreeTrialPricingTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/validityTerm
  :cognitect.aws.marketplace-agreement/ValidityTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/legalTerm
  :cognitect.aws.marketplace-agreement/LegalTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/paymentScheduleTerm
  :cognitect.aws.marketplace-agreement/PaymentScheduleTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/usageBasedPricingTerm
  :cognitect.aws.marketplace-agreement/UsageBasedPricingTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/byolPricingTerm
  :cognitect.aws.marketplace-agreement/ByolPricingTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/fixedUpfrontPricingTerm
  :cognitect.aws.marketplace-agreement/FixedUpfrontPricingTerm)

(s/def
  :cognitect.aws.marketplace-agreement.AcceptedTerm/renewalTerm
  :cognitect.aws.marketplace-agreement/RenewalTerm)

(s/def
  :cognitect.aws.marketplace-agreement.EstimatedCharges/agreementValue
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.EstimatedCharges/currencyCode
  :cognitect.aws.marketplace-agreement/CurrencyCode)

(s/def
  :cognitect.aws.marketplace-agreement.SearchAgreementsInput/catalog
  :cognitect.aws.marketplace-agreement/Catalog)

(s/def
  :cognitect.aws.marketplace-agreement.SearchAgreementsInput/filters
  :cognitect.aws.marketplace-agreement/FilterList)

(s/def
  :cognitect.aws.marketplace-agreement.SearchAgreementsInput/maxResults
  :cognitect.aws.marketplace-agreement/MaxResults)

(s/def
  :cognitect.aws.marketplace-agreement.SearchAgreementsInput/nextToken
  :cognitect.aws.marketplace-agreement/NextToken)

(s/def
  :cognitect.aws.marketplace-agreement.SearchAgreementsInput/sort
  :cognitect.aws.marketplace-agreement/Sort)

(s/def :cognitect.aws.marketplace-agreement.Sort/sortBy :cognitect.aws.marketplace-agreement/SortBy)

(s/def
  :cognitect.aws.marketplace-agreement.Sort/sortOrder
  :cognitect.aws.marketplace-agreement/SortOrder)

(s/def
  :cognitect.aws.marketplace-agreement.PaymentScheduleTerm/currencyCode
  :cognitect.aws.marketplace-agreement/CurrencyCode)

(s/def
  :cognitect.aws.marketplace-agreement.PaymentScheduleTerm/schedule
  :cognitect.aws.marketplace-agreement/ScheduleList)

(s/def
  :cognitect.aws.marketplace-agreement.PaymentScheduleTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.RateCardItem/dimensionKey
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.RateCardItem/price
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.RecurringPaymentTerm/billingPeriod
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.RecurringPaymentTerm/currencyCode
  :cognitect.aws.marketplace-agreement/CurrencyCode)

(s/def
  :cognitect.aws.marketplace-agreement.RecurringPaymentTerm/price
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.RecurringPaymentTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementInput/agreementId
  :cognitect.aws.marketplace-agreement/ResourceId)

(s/def
  :cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/currencyCode
  :cognitect.aws.marketplace-agreement/CurrencyCode)

(s/def
  :cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/duration
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/grants
  :cognitect.aws.marketplace-agreement/GrantList)

(s/def
  :cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/price
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.FixedUpfrontPricingTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.Acceptor/accountId
  :cognitect.aws.marketplace-agreement/AWSAccountId)

(s/def
  :cognitect.aws.marketplace-agreement.AgreementViewSummary/proposalSummary
  :cognitect.aws.marketplace-agreement/ProposalSummary)

(s/def
  :cognitect.aws.marketplace-agreement.AgreementViewSummary/agreementId
  :cognitect.aws.marketplace-agreement/ResourceId)

(s/def
  :cognitect.aws.marketplace-agreement.AgreementViewSummary/startTime
  :cognitect.aws.marketplace-agreement/Timestamp)

(s/def
  :cognitect.aws.marketplace-agreement.AgreementViewSummary/acceptanceTime
  :cognitect.aws.marketplace-agreement/Timestamp)

(s/def
  :cognitect.aws.marketplace-agreement.AgreementViewSummary/endTime
  :cognitect.aws.marketplace-agreement/Timestamp)

(s/def
  :cognitect.aws.marketplace-agreement.AgreementViewSummary/agreementType
  :cognitect.aws.marketplace-agreement/AgreementType)

(s/def
  :cognitect.aws.marketplace-agreement.AgreementViewSummary/status
  :cognitect.aws.marketplace-agreement/AgreementStatus)

(s/def
  :cognitect.aws.marketplace-agreement.AgreementViewSummary/proposer
  :cognitect.aws.marketplace-agreement/Proposer)

(s/def
  :cognitect.aws.marketplace-agreement.AgreementViewSummary/acceptor
  :cognitect.aws.marketplace-agreement/Acceptor)

(s/def
  :cognitect.aws.marketplace-agreement.Proposer/accountId
  :cognitect.aws.marketplace-agreement/AWSAccountId)

(s/def
  :cognitect.aws.marketplace-agreement.FreeTrialPricingTerm/duration
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.FreeTrialPricingTerm/grants
  :cognitect.aws.marketplace-agreement/GrantList)

(s/def
  :cognitect.aws.marketplace-agreement.FreeTrialPricingTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTermConfiguration/dimensions
  :cognitect.aws.marketplace-agreement/DimensionList)

(s/def
  :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTermConfiguration/selectorValue
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.Constraints/multipleDimensionSelection
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.Constraints/quantityConfiguration
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.GetAgreementTermsInput/agreementId
  :cognitect.aws.marketplace-agreement/ResourceId)

(s/def
  :cognitect.aws.marketplace-agreement.GetAgreementTermsInput/maxResults
  :cognitect.aws.marketplace-agreement/MaxResults)

(s/def
  :cognitect.aws.marketplace-agreement.GetAgreementTermsInput/nextToken
  :cognitect.aws.marketplace-agreement/NextToken)

(s/def
  :cognitect.aws.marketplace-agreement.DocumentItem/type
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.DocumentItem/url
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.DocumentItem/version
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.LegalTerm/documents
  :cognitect.aws.marketplace-agreement/DocumentList)

(s/def
  :cognitect.aws.marketplace-agreement.LegalTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.UsageBasedRateCardItem/rateCard
  :cognitect.aws.marketplace-agreement/RateCardList)

(s/def
  :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTerm/configuration
  :cognitect.aws.marketplace-agreement/ConfigurableUpfrontPricingTermConfiguration)

(s/def
  :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTerm/currencyCode
  :cognitect.aws.marketplace-agreement/CurrencyCode)

(s/def
  :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTerm/rateCards
  :cognitect.aws.marketplace-agreement/ConfigurableUpfrontRateCardList)

(s/def
  :cognitect.aws.marketplace-agreement.ConfigurableUpfrontPricingTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.Resource/id
  :cognitect.aws.marketplace-agreement/ResourceId)

(s/def
  :cognitect.aws.marketplace-agreement.Resource/type
  :cognitect.aws.marketplace-agreement/AgreementResourceType)

(s/def
  :cognitect.aws.marketplace-agreement.SearchAgreementsOutput/agreementViewSummaries
  :cognitect.aws.marketplace-agreement/AgreementViewSummaryList)

(s/def
  :cognitect.aws.marketplace-agreement.SearchAgreementsOutput/nextToken
  :cognitect.aws.marketplace-agreement/NextToken)

(s/def
  :cognitect.aws.marketplace-agreement.ProposalSummary/offerId
  :cognitect.aws.marketplace-agreement/OfferId)

(s/def
  :cognitect.aws.marketplace-agreement.ProposalSummary/resources
  :cognitect.aws.marketplace-agreement/Resources)

(s/def
  :cognitect.aws.marketplace-agreement.ValidityTerm/agreementDuration
  :cognitect.aws.marketplace-agreement/BoundedString)

(s/def
  :cognitect.aws.marketplace-agreement.ValidityTerm/agreementEndDate
  :cognitect.aws.marketplace-agreement/Timestamp)

(s/def
  :cognitect.aws.marketplace-agreement.ValidityTerm/agreementStartDate
  :cognitect.aws.marketplace-agreement/Timestamp)

(s/def
  :cognitect.aws.marketplace-agreement.ValidityTerm/type
  :cognitect.aws.marketplace-agreement/UnversionedTermType)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/proposalSummary
  :cognitect.aws.marketplace-agreement/ProposalSummary)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/agreementId
  :cognitect.aws.marketplace-agreement/ResourceId)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/startTime
  :cognitect.aws.marketplace-agreement/Timestamp)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/acceptanceTime
  :cognitect.aws.marketplace-agreement/Timestamp)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/endTime
  :cognitect.aws.marketplace-agreement/Timestamp)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/estimatedCharges
  :cognitect.aws.marketplace-agreement/EstimatedCharges)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/agreementType
  :cognitect.aws.marketplace-agreement/AgreementType)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/status
  :cognitect.aws.marketplace-agreement/AgreementStatus)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/proposer
  :cognitect.aws.marketplace-agreement/Proposer)

(s/def
  :cognitect.aws.marketplace-agreement.DescribeAgreementOutput/acceptor
  :cognitect.aws.marketplace-agreement/Acceptor)

(s/def
  :cognitect.aws.marketplace-agreement.ResourceNotFoundException/message
  :cognitect.aws.marketplace-agreement/ExceptionMessage)

(s/def
  :cognitect.aws.marketplace-agreement.ResourceNotFoundException/requestId
  :cognitect.aws.marketplace-agreement/RequestId)

(s/def
  :cognitect.aws.marketplace-agreement.ResourceNotFoundException/resourceId
  :cognitect.aws.marketplace-agreement/ResourceId)

(s/def
  :cognitect.aws.marketplace-agreement.ResourceNotFoundException/resourceType
  :cognitect.aws.marketplace-agreement/ResourceType)

