;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.marketplace-catalog.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.marketplace-catalog/EntitySummary
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.EntitySummary/LastModifiedDate
     :cognitect.aws.marketplace-catalog.EntitySummary/Visibility
     :cognitect.aws.marketplace-catalog.EntitySummary/EntityArn
     :cognitect.aws.marketplace-catalog.EntitySummary/EntityId
     :cognitect.aws.marketplace-catalog.EntitySummary/Name
     :cognitect.aws.marketplace-catalog.EntitySummary/EntityType]))

(s/def
  :cognitect.aws.marketplace-catalog/ChangeSetSummaryList
  (s/coll-of :cognitect.aws.marketplace-catalog/ChangeSetSummaryListItem))

(s/def
  :cognitect.aws.marketplace-catalog/ErrorDetail
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.ErrorDetail/ErrorMessage
     :cognitect.aws.marketplace-catalog.ErrorDetail/ErrorCode]))

(s/def
  :cognitect.aws.marketplace-catalog/ExceptionMessageContent
  (s/spec #(re-matches (re-pattern "^(.)+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/ListEntitiesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.ListEntitiesResponse/EntitySummaryList
     :cognitect.aws.marketplace-catalog.ListEntitiesResponse/NextToken]))

(s/def
  :cognitect.aws.marketplace-catalog/Filter
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.Filter/ValueList
     :cognitect.aws.marketplace-catalog.Filter/Name]))

(s/def
  :cognitect.aws.marketplace-catalog/ListChangeSetsRequest
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-catalog.ListChangeSetsRequest/Catalog]
    :opt-un
    [:cognitect.aws.marketplace-catalog.ListChangeSetsRequest/Sort
     :cognitect.aws.marketplace-catalog.ListChangeSetsRequest/NextToken
     :cognitect.aws.marketplace-catalog.ListChangeSetsRequest/MaxResults
     :cognitect.aws.marketplace-catalog.ListChangeSetsRequest/FilterList]))

(s/def
  :cognitect.aws.marketplace-catalog/CancelChangeSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-catalog.CancelChangeSetRequest/Catalog
     :cognitect.aws.marketplace-catalog.CancelChangeSetRequest/ChangeSetId]))

(s/def
  :cognitect.aws.marketplace-catalog/ChangeSetDescription
  (s/coll-of :cognitect.aws.marketplace-catalog/ChangeSummary))

(s/def
  :cognitect.aws.marketplace-catalog/DescribeChangeSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/EndTime
     :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/FailureDescription
     :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/StartTime
     :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/ChangeSet
     :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/ChangeSetArn
     :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/ChangeSetName
     :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/ChangeSetId
     :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/Status
     :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/FailureCode]))

(s/def
  :cognitect.aws.marketplace-catalog/ChangeSummary
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.ChangeSummary/ChangeType
     :cognitect.aws.marketplace-catalog.ChangeSummary/Details
     :cognitect.aws.marketplace-catalog.ChangeSummary/ErrorDetailList
     :cognitect.aws.marketplace-catalog.ChangeSummary/Entity
     :cognitect.aws.marketplace-catalog.ChangeSummary/ChangeName]))

(s/def
  :cognitect.aws.marketplace-catalog/ChangeName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/FilterValueContent
  (s/spec #(re-matches (re-pattern "^(.)+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/ResourceId
  (s/spec #(re-matches (re-pattern "^[\\w\\-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/DescribeChangeSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-catalog.DescribeChangeSetRequest/Catalog
     :cognitect.aws.marketplace-catalog.DescribeChangeSetRequest/ChangeSetId]))

(s/def
  :cognitect.aws.marketplace-catalog/Sort
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.Sort/SortBy
     :cognitect.aws.marketplace-catalog.Sort/SortOrder]))

(s/def
  :cognitect.aws.marketplace-catalog/DateTimeISO8601
  (s/spec
    #(re-matches
      (re-pattern
        "^([\\d]{4})\\-(1[0-2]|0[1-9])\\-(3[01]|0[1-9]|[12][\\d])T(2[0-3]|[01][\\d]):([0-5][\\d]):([0-5][\\d])Z$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/Json
  (s/spec #(re-matches (re-pattern "^[\\s]*\\{[\\s\\S]*\\}[\\s]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/ListEntitiesRequest
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-catalog.ListEntitiesRequest/Catalog
     :cognitect.aws.marketplace-catalog.ListEntitiesRequest/EntityType]
    :opt-un
    [:cognitect.aws.marketplace-catalog.ListEntitiesRequest/Sort
     :cognitect.aws.marketplace-catalog.ListEntitiesRequest/NextToken
     :cognitect.aws.marketplace-catalog.ListEntitiesRequest/MaxResults
     :cognitect.aws.marketplace-catalog.ListEntitiesRequest/FilterList]))

(s/def
  :cognitect.aws.marketplace-catalog/EntityType
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/EntityNameString
  (s/spec #(re-matches (re-pattern "^\\\\S+[\\\\S\\\\s]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/CancelChangeSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.CancelChangeSetResponse/ChangeSetArn
     :cognitect.aws.marketplace-catalog.CancelChangeSetResponse/ChangeSetId]))

(s/def
  :cognitect.aws.marketplace-catalog/Identifier
  (s/spec #(re-matches (re-pattern "^[\\w\\-@]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/ResourceIdList
  (s/coll-of :cognitect.aws.marketplace-catalog/ResourceId))

(s/def
  :cognitect.aws.marketplace-catalog/NextToken
  (s/spec #(re-matches (re-pattern "^[\\w+=.:@\\-\\/]$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/DescribeEntityResponse
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.DescribeEntityResponse/Details
     :cognitect.aws.marketplace-catalog.DescribeEntityResponse/LastModifiedDate
     :cognitect.aws.marketplace-catalog.DescribeEntityResponse/EntityIdentifier
     :cognitect.aws.marketplace-catalog.DescribeEntityResponse/EntityArn
     :cognitect.aws.marketplace-catalog.DescribeEntityResponse/EntityType]))

(s/def
  :cognitect.aws.marketplace-catalog/RequestedChangeList
  (s/coll-of :cognitect.aws.marketplace-catalog/Change :min-count 1 :max-count 20))

(s/def
  :cognitect.aws.marketplace-catalog/ClientRequestToken
  (s/spec #(re-matches (re-pattern "^[\\w\\-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/Change
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-catalog.Change/ChangeType
     :cognitect.aws.marketplace-catalog.Change/Entity
     :cognitect.aws.marketplace-catalog.Change/Details]
    :opt-un
    [:cognitect.aws.marketplace-catalog.Change/ChangeName]))

(s/def
  :cognitect.aws.marketplace-catalog/ChangeSetSummaryListItem
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/EndTime
     :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/StartTime
     :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/ChangeSetArn
     :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/ChangeSetName
     :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/ChangeSetId
     :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/Status
     :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/EntityIdList
     :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/FailureCode]))

(s/def
  :cognitect.aws.marketplace-catalog/FilterList
  (s/coll-of :cognitect.aws.marketplace-catalog/Filter :min-count 1 :max-count 8))

(s/def
  :cognitect.aws.marketplace-catalog/StartChangeSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.StartChangeSetResponse/ChangeSetArn
     :cognitect.aws.marketplace-catalog.StartChangeSetResponse/ChangeSetId]))

(s/def
  :cognitect.aws.marketplace-catalog/VisibilityValue
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/SortBy
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/FailureCode
  (s/spec string? :gen #(s/gen #{"SERVER_FAULT" "CLIENT_ERROR"})))

(s/def
  :cognitect.aws.marketplace-catalog/SortOrder
  (s/spec string? :gen #(s/gen #{"ASCENDING" "DESCENDING"})))

(s/def
  :cognitect.aws.marketplace-catalog/ValueList
  (s/coll-of :cognitect.aws.marketplace-catalog/FilterValueContent :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.marketplace-catalog/MaxResultInteger
  (s/spec (s/and int? #(<= 1 % 20)) :gen #(gen/choose 1 20)))

(s/def
  :cognitect.aws.marketplace-catalog/ErrorCodeString
  (s/spec #(re-matches (re-pattern "^[a-zA-Z_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/ARN
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9:*/-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/Catalog
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/DescribeEntityRequest
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-catalog.DescribeEntityRequest/Catalog
     :cognitect.aws.marketplace-catalog.DescribeEntityRequest/EntityId]))

(s/def
  :cognitect.aws.marketplace-catalog/ChangeType
  (s/spec #(re-matches (re-pattern "^[A-Z][\\w]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/FilterName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/ChangeStatus
  (s/spec string? :gen #(s/gen #{"APPLYING" "PREPARING" "SUCCEEDED" "FAILED" "CANCELLED"})))

(s/def
  :cognitect.aws.marketplace-catalog/ChangeSetName
  (s/spec #(re-matches (re-pattern "^[\\w\\s+=.:@-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.marketplace-catalog/EntitySummaryList
  (s/coll-of :cognitect.aws.marketplace-catalog/EntitySummary))

(s/def
  :cognitect.aws.marketplace-catalog/StartChangeSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-catalog.StartChangeSetRequest/Catalog
     :cognitect.aws.marketplace-catalog.StartChangeSetRequest/ChangeSet]
    :opt-un
    [:cognitect.aws.marketplace-catalog.StartChangeSetRequest/ClientRequestToken
     :cognitect.aws.marketplace-catalog.StartChangeSetRequest/ChangeSetName]))

(s/def
  :cognitect.aws.marketplace-catalog/ListChangeSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.marketplace-catalog.ListChangeSetsResponse/NextToken
     :cognitect.aws.marketplace-catalog.ListChangeSetsResponse/ChangeSetSummaryList]))

(s/def
  :cognitect.aws.marketplace-catalog/ErrorDetailList
  (s/coll-of :cognitect.aws.marketplace-catalog/ErrorDetail))

(s/def
  :cognitect.aws.marketplace-catalog/Entity
  (s/keys
    :req-un
    [:cognitect.aws.marketplace-catalog.Entity/Type]
    :opt-un
    [:cognitect.aws.marketplace-catalog.Entity/Identifier]))

(s/def
  :cognitect.aws.marketplace-catalog.EntitySummary/Name
  :cognitect.aws.marketplace-catalog/EntityNameString)

(s/def
  :cognitect.aws.marketplace-catalog.EntitySummary/EntityType
  :cognitect.aws.marketplace-catalog/EntityType)

(s/def
  :cognitect.aws.marketplace-catalog.EntitySummary/EntityId
  :cognitect.aws.marketplace-catalog/ResourceId)

(s/def
  :cognitect.aws.marketplace-catalog.EntitySummary/EntityArn
  :cognitect.aws.marketplace-catalog/ARN)

(s/def
  :cognitect.aws.marketplace-catalog.EntitySummary/LastModifiedDate
  :cognitect.aws.marketplace-catalog/DateTimeISO8601)

(s/def
  :cognitect.aws.marketplace-catalog.EntitySummary/Visibility
  :cognitect.aws.marketplace-catalog/VisibilityValue)

(s/def
  :cognitect.aws.marketplace-catalog.ErrorDetail/ErrorCode
  :cognitect.aws.marketplace-catalog/ErrorCodeString)

(s/def
  :cognitect.aws.marketplace-catalog.ErrorDetail/ErrorMessage
  :cognitect.aws.marketplace-catalog/ExceptionMessageContent)

(s/def
  :cognitect.aws.marketplace-catalog.ListEntitiesResponse/EntitySummaryList
  :cognitect.aws.marketplace-catalog/EntitySummaryList)

(s/def
  :cognitect.aws.marketplace-catalog.ListEntitiesResponse/NextToken
  :cognitect.aws.marketplace-catalog/NextToken)

(s/def :cognitect.aws.marketplace-catalog.Filter/Name :cognitect.aws.marketplace-catalog/FilterName)

(s/def
  :cognitect.aws.marketplace-catalog.Filter/ValueList
  :cognitect.aws.marketplace-catalog/ValueList)

(s/def
  :cognitect.aws.marketplace-catalog.ListChangeSetsRequest/Catalog
  :cognitect.aws.marketplace-catalog/Catalog)

(s/def
  :cognitect.aws.marketplace-catalog.ListChangeSetsRequest/FilterList
  :cognitect.aws.marketplace-catalog/FilterList)

(s/def
  :cognitect.aws.marketplace-catalog.ListChangeSetsRequest/Sort
  :cognitect.aws.marketplace-catalog/Sort)

(s/def
  :cognitect.aws.marketplace-catalog.ListChangeSetsRequest/MaxResults
  :cognitect.aws.marketplace-catalog/MaxResultInteger)

(s/def
  :cognitect.aws.marketplace-catalog.ListChangeSetsRequest/NextToken
  :cognitect.aws.marketplace-catalog/NextToken)

(s/def
  :cognitect.aws.marketplace-catalog.CancelChangeSetRequest/Catalog
  :cognitect.aws.marketplace-catalog/Catalog)

(s/def
  :cognitect.aws.marketplace-catalog.CancelChangeSetRequest/ChangeSetId
  :cognitect.aws.marketplace-catalog/ResourceId)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/EndTime
  :cognitect.aws.marketplace-catalog/DateTimeISO8601)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/ChangeSetArn
  :cognitect.aws.marketplace-catalog/ARN)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/ChangeSet
  :cognitect.aws.marketplace-catalog/ChangeSetDescription)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/FailureDescription
  :cognitect.aws.marketplace-catalog/ExceptionMessageContent)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/StartTime
  :cognitect.aws.marketplace-catalog/DateTimeISO8601)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/FailureCode
  :cognitect.aws.marketplace-catalog/FailureCode)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/ChangeSetId
  :cognitect.aws.marketplace-catalog/ResourceId)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/ChangeSetName
  :cognitect.aws.marketplace-catalog/ChangeSetName)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetResponse/Status
  :cognitect.aws.marketplace-catalog/ChangeStatus)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSummary/ChangeType
  :cognitect.aws.marketplace-catalog/ChangeType)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSummary/Entity
  :cognitect.aws.marketplace-catalog/Entity)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSummary/Details
  :cognitect.aws.marketplace-catalog/Json)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSummary/ErrorDetailList
  :cognitect.aws.marketplace-catalog/ErrorDetailList)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSummary/ChangeName
  :cognitect.aws.marketplace-catalog/ChangeName)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetRequest/Catalog
  :cognitect.aws.marketplace-catalog/Catalog)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeChangeSetRequest/ChangeSetId
  :cognitect.aws.marketplace-catalog/ResourceId)

(s/def :cognitect.aws.marketplace-catalog.Sort/SortBy :cognitect.aws.marketplace-catalog/SortBy)

(s/def
  :cognitect.aws.marketplace-catalog.Sort/SortOrder
  :cognitect.aws.marketplace-catalog/SortOrder)

(s/def
  :cognitect.aws.marketplace-catalog.ListEntitiesRequest/Catalog
  :cognitect.aws.marketplace-catalog/Catalog)

(s/def
  :cognitect.aws.marketplace-catalog.ListEntitiesRequest/EntityType
  :cognitect.aws.marketplace-catalog/EntityType)

(s/def
  :cognitect.aws.marketplace-catalog.ListEntitiesRequest/FilterList
  :cognitect.aws.marketplace-catalog/FilterList)

(s/def
  :cognitect.aws.marketplace-catalog.ListEntitiesRequest/Sort
  :cognitect.aws.marketplace-catalog/Sort)

(s/def
  :cognitect.aws.marketplace-catalog.ListEntitiesRequest/NextToken
  :cognitect.aws.marketplace-catalog/NextToken)

(s/def
  :cognitect.aws.marketplace-catalog.ListEntitiesRequest/MaxResults
  :cognitect.aws.marketplace-catalog/MaxResultInteger)

(s/def
  :cognitect.aws.marketplace-catalog.CancelChangeSetResponse/ChangeSetId
  :cognitect.aws.marketplace-catalog/ResourceId)

(s/def
  :cognitect.aws.marketplace-catalog.CancelChangeSetResponse/ChangeSetArn
  :cognitect.aws.marketplace-catalog/ARN)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeEntityResponse/EntityType
  :cognitect.aws.marketplace-catalog/EntityType)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeEntityResponse/EntityIdentifier
  :cognitect.aws.marketplace-catalog/Identifier)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeEntityResponse/EntityArn
  :cognitect.aws.marketplace-catalog/ARN)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeEntityResponse/LastModifiedDate
  :cognitect.aws.marketplace-catalog/DateTimeISO8601)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeEntityResponse/Details
  :cognitect.aws.marketplace-catalog/Json)

(s/def
  :cognitect.aws.marketplace-catalog.Change/ChangeType
  :cognitect.aws.marketplace-catalog/ChangeType)

(s/def :cognitect.aws.marketplace-catalog.Change/Entity :cognitect.aws.marketplace-catalog/Entity)

(s/def :cognitect.aws.marketplace-catalog.Change/Details :cognitect.aws.marketplace-catalog/Json)

(s/def
  :cognitect.aws.marketplace-catalog.Change/ChangeName
  :cognitect.aws.marketplace-catalog/ChangeName)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/ChangeSetId
  :cognitect.aws.marketplace-catalog/ResourceId)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/ChangeSetArn
  :cognitect.aws.marketplace-catalog/ARN)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/ChangeSetName
  :cognitect.aws.marketplace-catalog/ChangeSetName)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/StartTime
  :cognitect.aws.marketplace-catalog/DateTimeISO8601)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/EndTime
  :cognitect.aws.marketplace-catalog/DateTimeISO8601)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/Status
  :cognitect.aws.marketplace-catalog/ChangeStatus)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/EntityIdList
  :cognitect.aws.marketplace-catalog/ResourceIdList)

(s/def
  :cognitect.aws.marketplace-catalog.ChangeSetSummaryListItem/FailureCode
  :cognitect.aws.marketplace-catalog/FailureCode)

(s/def
  :cognitect.aws.marketplace-catalog.StartChangeSetResponse/ChangeSetId
  :cognitect.aws.marketplace-catalog/ResourceId)

(s/def
  :cognitect.aws.marketplace-catalog.StartChangeSetResponse/ChangeSetArn
  :cognitect.aws.marketplace-catalog/ARN)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeEntityRequest/Catalog
  :cognitect.aws.marketplace-catalog/Catalog)

(s/def
  :cognitect.aws.marketplace-catalog.DescribeEntityRequest/EntityId
  :cognitect.aws.marketplace-catalog/ResourceId)

(s/def
  :cognitect.aws.marketplace-catalog.StartChangeSetRequest/Catalog
  :cognitect.aws.marketplace-catalog/Catalog)

(s/def
  :cognitect.aws.marketplace-catalog.StartChangeSetRequest/ChangeSet
  :cognitect.aws.marketplace-catalog/RequestedChangeList)

(s/def
  :cognitect.aws.marketplace-catalog.StartChangeSetRequest/ChangeSetName
  :cognitect.aws.marketplace-catalog/ChangeSetName)

(s/def
  :cognitect.aws.marketplace-catalog.StartChangeSetRequest/ClientRequestToken
  :cognitect.aws.marketplace-catalog/ClientRequestToken)

(s/def
  :cognitect.aws.marketplace-catalog.ListChangeSetsResponse/ChangeSetSummaryList
  :cognitect.aws.marketplace-catalog/ChangeSetSummaryList)

(s/def
  :cognitect.aws.marketplace-catalog.ListChangeSetsResponse/NextToken
  :cognitect.aws.marketplace-catalog/NextToken)

(s/def :cognitect.aws.marketplace-catalog.Entity/Type :cognitect.aws.marketplace-catalog/EntityType)

(s/def
  :cognitect.aws.marketplace-catalog.Entity/Identifier
  :cognitect.aws.marketplace-catalog/Identifier)

