;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.mediaconvert.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.mediaconvert/DvbSdtSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DvbSdtSettings/OutputSdt
     :cognitect.aws.mediaconvert.DvbSdtSettings/ServiceName
     :cognitect.aws.mediaconvert.DvbSdtSettings/SdtInterval
     :cognitect.aws.mediaconvert.DvbSdtSettings/ServiceProviderName]))

(s/def
  :cognitect.aws.mediaconvert/__doubleMin0Max2147483647
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/AudioDescription
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AudioDescription/CustomLanguageCode
     :cognitect.aws.mediaconvert.AudioDescription/StreamName
     :cognitect.aws.mediaconvert.AudioDescription/RemixSettings
     :cognitect.aws.mediaconvert.AudioDescription/AudioType
     :cognitect.aws.mediaconvert.AudioDescription/CodecSettings
     :cognitect.aws.mediaconvert.AudioDescription/LanguageCodeControl
     :cognitect.aws.mediaconvert.AudioDescription/AudioTypeControl
     :cognitect.aws.mediaconvert.AudioDescription/LanguageCode
     :cognitect.aws.mediaconvert.AudioDescription/AudioSourceName
     :cognitect.aws.mediaconvert.AudioDescription/AudioChannelTaggingSettings
     :cognitect.aws.mediaconvert.AudioDescription/AudioNormalizationSettings]))

(s/def
  :cognitect.aws.mediaconvert/__listOfOutputGroupDetail
  (s/coll-of :cognitect.aws.mediaconvert/OutputGroupDetail))

(s/def
  :cognitect.aws.mediaconvert/OutputChannelMapping
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.OutputChannelMapping/InputChannelsFineTune
     :cognitect.aws.mediaconvert.OutputChannelMapping/InputChannels]))

(s/def
  :cognitect.aws.mediaconvert/Xavc4kIntraVbrProfileSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.Xavc4kIntraVbrProfileSettings/XavcClass]))

(s/def
  :cognitect.aws.mediaconvert/AudioSelector
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AudioSelector/Pids
     :cognitect.aws.mediaconvert.AudioSelector/CustomLanguageCode
     :cognitect.aws.mediaconvert.AudioSelector/RemixSettings
     :cognitect.aws.mediaconvert.AudioSelector/Offset
     :cognitect.aws.mediaconvert.AudioSelector/DefaultSelection
     :cognitect.aws.mediaconvert.AudioSelector/AudioDurationCorrection
     :cognitect.aws.mediaconvert.AudioSelector/Tracks
     :cognitect.aws.mediaconvert.AudioSelector/LanguageCode
     :cognitect.aws.mediaconvert.AudioSelector/ExternalAudioFileInput
     :cognitect.aws.mediaconvert.AudioSelector/HlsRenditionGroupSettings
     :cognitect.aws.mediaconvert.AudioSelector/ProgramSelection
     :cognitect.aws.mediaconvert.AudioSelector/SelectorType]))

(s/def
  :cognitect.aws.mediaconvert/GifFramerateConversionAlgorithm
  (s/spec string? :gen #(s/gen #{"DUPLICATE_DROP" "INTERPOLATE"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfDashAdditionalManifest
  (s/coll-of :cognitect.aws.mediaconvert/DashAdditionalManifest))

(s/def
  :cognitect.aws.mediaconvert/M2tsPcrControl
  (s/spec string? :gen #(s/gen #{"CONFIGURED_PCR_PERIOD" "PCR_EVERY_PES_PACKET"})))

(s/def
  :cognitect.aws.mediaconvert/Vc3SlowPal
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/CmfcIFrameOnlyManifest
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/AvcIntraClass
  (s/spec string? :gen #(s/gen #{"CLASS_200" "CLASS_50" "CLASS_100" "CLASS_4K_2K"})))

(s/def
  :cognitect.aws.mediaconvert/HlsCaptionLanguageSetting
  (s/spec string? :gen #(s/gen #{"INSERT" "NONE" "OMIT"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin11Max11Pattern01D20305D205D
  (s/spec
    #(re-matches (re-pattern "^((([0-1]\\d)|(2[0-3]))(:[0-5]\\d){2}([:;][0-5]\\d))$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max30
  (s/spec (s/and int? #(<= 0 % 30)) :gen #(gen/choose 0 30)))

(s/def
  :cognitect.aws.mediaconvert/__mapOfAudioSelector
  (s/map-of :cognitect.aws.mediaconvert/__string :cognitect.aws.mediaconvert/AudioSelector))

(s/def
  :cognitect.aws.mediaconvert/AacRawFormat
  (s/spec string? :gen #(s/gen #{"LATM_LOAS" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin32000Max192000
  (s/spec (s/and int? #(<= 32000 % 192000)) :gen #(gen/choose 32000 192000)))

(s/def
  :cognitect.aws.mediaconvert/CaptionSourceFramerate
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CaptionSourceFramerate/FramerateDenominator
     :cognitect.aws.mediaconvert.CaptionSourceFramerate/FramerateNumerator]))

(s/def
  :cognitect.aws.mediaconvert/AccelerationMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "PREFERRED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfInputClipping
  (s/coll-of :cognitect.aws.mediaconvert/InputClipping))

(s/def
  :cognitect.aws.mediaconvert/S3ObjectCannedAcl
  (s/spec
    string?
    :gen
    #(s/gen #{"PUBLIC_READ" "BUCKET_OWNER_READ" "BUCKET_OWNER_FULL_CONTROL" "AUTHENTICATED_READ"})))

(s/def
  :cognitect.aws.mediaconvert/DvbSubtitleOutlineColor
  (s/spec string? :gen #(s/gen #{"AUTO" "GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})))

(s/def
  :cognitect.aws.mediaconvert/VideoOverlayPlayBackMode
  (s/spec string? :gen #(s/gen #{"ONCE" "REPEAT"})))

(s/def
  :cognitect.aws.mediaconvert/AvailBlanking
  (s/keys :opt-un [:cognitect.aws.mediaconvert.AvailBlanking/AvailBlankingImage]))

(s/def
  :cognitect.aws.mediaconvert/Vc3FramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def :cognitect.aws.mediaconvert/Commitment (s/spec string? :gen #(s/gen #{"ONE_YEAR"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max5
  (s/spec (s/and int? #(<= 0 % 5)) :gen #(gen/choose 0 5)))

(s/def
  :cognitect.aws.mediaconvert/ExceptionBody
  (s/keys :opt-un [:cognitect.aws.mediaconvert.ExceptionBody/Message]))

(s/def
  :cognitect.aws.mediaconvert/PresetSpeke20Audio
  (s/spec
    string?
    :gen
    #(s/gen #{"PRESET_AUDIO_2" "PRESET_AUDIO_3" "UNENCRYPTED" "PRESET_AUDIO_1" "SHARED"})))

(s/def
  :cognitect.aws.mediaconvert/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.TagResourceRequest/Arn
     :cognitect.aws.mediaconvert.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.mediaconvert/XavcFramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def :cognitect.aws.mediaconvert/ProresTelecine (s/spec string? :gen #(s/gen #{"HARD" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/MovSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MovSettings/Mpeg2FourCCControl
     :cognitect.aws.mediaconvert.MovSettings/CslgAtom
     :cognitect.aws.mediaconvert.MovSettings/ClapAtom
     :cognitect.aws.mediaconvert.MovSettings/PaddingControl
     :cognitect.aws.mediaconvert.MovSettings/Reference]))

(s/def
  :cognitect.aws.mediaconvert/HlsEncryptionType
  (s/spec string? :gen #(s/gen #{"SAMPLE_AES" "AES128"})))

(s/def
  :cognitect.aws.mediaconvert/OutputGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.OutputGroupSettings/Type
     :cognitect.aws.mediaconvert.OutputGroupSettings/CmafGroupSettings
     :cognitect.aws.mediaconvert.OutputGroupSettings/MsSmoothGroupSettings
     :cognitect.aws.mediaconvert.OutputGroupSettings/HlsGroupSettings
     :cognitect.aws.mediaconvert.OutputGroupSettings/DashIsoGroupSettings
     :cognitect.aws.mediaconvert.OutputGroupSettings/FileGroupSettings]))

(s/def
  :cognitect.aws.mediaconvert/DashManifestStyle
  (s/spec string? :gen #(s/gen #{"COMPACT" "DISTINCT" "BASIC"})))

(s/def
  :cognitect.aws.mediaconvert/JobTemplate
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.JobTemplate/Settings :cognitect.aws.mediaconvert.JobTemplate/Name]
    :opt-un
    [:cognitect.aws.mediaconvert.JobTemplate/Type
     :cognitect.aws.mediaconvert.JobTemplate/Category
     :cognitect.aws.mediaconvert.JobTemplate/Queue
     :cognitect.aws.mediaconvert.JobTemplate/Priority
     :cognitect.aws.mediaconvert.JobTemplate/AccelerationSettings
     :cognitect.aws.mediaconvert.JobTemplate/Description
     :cognitect.aws.mediaconvert.JobTemplate/HopDestinations
     :cognitect.aws.mediaconvert.JobTemplate/Arn
     :cognitect.aws.mediaconvert.JobTemplate/CreatedAt
     :cognitect.aws.mediaconvert.JobTemplate/StatusUpdateInterval
     :cognitect.aws.mediaconvert.JobTemplate/LastUpdated]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin920Max1023
  (s/spec (s/and int? #(<= 920 % 1023)) :gen #(gen/choose 920 1023)))

(s/def
  :cognitect.aws.mediaconvert/Vp9QualityTuningLevel
  (s/spec string? :gen #(s/gen #{"MULTI_PASS_HQ" "MULTI_PASS"})))

(s/def
  :cognitect.aws.mediaconvert/ColorSpaceConversion
  (s/spec
    string?
    :gen
    #(s/gen
      #{"FORCE_709"
        "FORCE_601"
        "FORCE_P3D65_SDR"
        "NONE"
        "FORCE_P3DCI"
        "FORCE_P3D65_HDR"
        "FORCE_HDR10"
        "FORCE_HLG_2020"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfInsertableImage
  (s/coll-of :cognitect.aws.mediaconvert/InsertableImage))

(s/def
  :cognitect.aws.mediaconvert/PresetSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.PresetSettings/ContainerSettings
     :cognitect.aws.mediaconvert.PresetSettings/CaptionDescriptions
     :cognitect.aws.mediaconvert.PresetSettings/VideoDescription
     :cognitect.aws.mediaconvert.PresetSettings/AudioDescriptions]))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2TemporalAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/AvcIntraSlowPal
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/Mp3Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Mp3Settings/RateControlMode
     :cognitect.aws.mediaconvert.Mp3Settings/SampleRate
     :cognitect.aws.mediaconvert.Mp3Settings/VbrQuality
     :cognitect.aws.mediaconvert.Mp3Settings/Bitrate
     :cognitect.aws.mediaconvert.Mp3Settings/Channels]))

(s/def
  :cognitect.aws.mediaconvert/ProresSlowPal
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/Xavc4kProfileCodecProfile
  (s/spec string? :gen #(s/gen #{"HIGH_422" "HIGH"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max3600
  (s/spec (s/and int? #(<= 0 % 3600)) :gen #(gen/choose 0 3600)))

(s/def
  :cognitect.aws.mediaconvert/__stringMin6Max8Pattern09aFAF609aFAF2
  (s/spec #(re-matches (re-pattern "^[0-9a-fA-F]{6}([0-9a-fA-F]{2})?$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__stringMin14PatternS3SccSCCTtmlTTMLDfxpDFXPStlSTLSrtSRTXmlXMLSmiSMIVttVTTWebvttWEBVTTHttpsSccSCCTtmlTTMLDfxpDFXPStlSTLSrtSRTXmlXMLSmiSMIVttVTTWebvttWEBVTT
  (s/spec
    #(re-matches
      (re-pattern
        "^((s3://(.*?)\\.(scc|SCC|ttml|TTML|dfxp|DFXP|stl|STL|srt|SRT|xml|XML|smi|SMI|vtt|VTT|webvtt|WEBVTT))|(https?://(.*?)\\.(scc|SCC|ttml|TTML|dfxp|DFXP|stl|STL|srt|SRT|xml|XML|smi|SMI|vtt|VTT|webvtt|WEBVTT)(\\?([^&=]+=[^&]+&)*[^&=]+=[^&]+)?))$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin2Max4096
  (s/spec (s/and int? #(<= 2 % 4096)) :gen #(gen/choose 2 4096)))

(s/def
  :cognitect.aws.mediaconvert/WarningGroup
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.WarningGroup/Count :cognitect.aws.mediaconvert.WarningGroup/Code]))

(s/def :cognitect.aws.mediaconvert/AvcIntraTelecine (s/spec string? :gen #(s/gen #{"HARD" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/AudioChannelTag
  (s/spec
    string?
    :gen
    #(s/gen
      #{"LC"
        "TCS"
        "LW"
        "TBL"
        "RSD"
        "RT"
        "NAR"
        "VHR"
        "L"
        "CS"
        "LS"
        "LT"
        "M"
        "VHL"
        "TBC"
        "LFE"
        "R"
        "C"
        "RC"
        "RW"
        "RSR"
        "LSD"
        "VHC"
        "LFE2"
        "RSL"
        "TBR"
        "RS"
        "HI"})))

(s/def
  :cognitect.aws.mediaconvert/InputTemplate
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.InputTemplate/Crop
     :cognitect.aws.mediaconvert.InputTemplate/DenoiseFilter
     :cognitect.aws.mediaconvert.InputTemplate/FilterStrength
     :cognitect.aws.mediaconvert.InputTemplate/ProgramNumber
     :cognitect.aws.mediaconvert.InputTemplate/InputClippings
     :cognitect.aws.mediaconvert.InputTemplate/TimecodeSource
     :cognitect.aws.mediaconvert.InputTemplate/CaptionSelectors
     :cognitect.aws.mediaconvert.InputTemplate/VideoSelector
     :cognitect.aws.mediaconvert.InputTemplate/AdvancedInputFilter
     :cognitect.aws.mediaconvert.InputTemplate/Position
     :cognitect.aws.mediaconvert.InputTemplate/AudioSelectorGroups
     :cognitect.aws.mediaconvert.InputTemplate/FilterEnable
     :cognitect.aws.mediaconvert.InputTemplate/ImageInserter
     :cognitect.aws.mediaconvert.InputTemplate/PsiControl
     :cognitect.aws.mediaconvert.InputTemplate/DolbyVisionMetadataXml
     :cognitect.aws.mediaconvert.InputTemplate/VideoOverlays
     :cognitect.aws.mediaconvert.InputTemplate/DynamicAudioSelectors
     :cognitect.aws.mediaconvert.InputTemplate/AudioSelectors
     :cognitect.aws.mediaconvert.InputTemplate/TimecodeStart
     :cognitect.aws.mediaconvert.InputTemplate/AdvancedInputFilterSettings
     :cognitect.aws.mediaconvert.InputTemplate/DeblockFilter
     :cognitect.aws.mediaconvert.InputTemplate/InputScanType]))

(s/def
  :cognitect.aws.mediaconvert/HlsAdditionalManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.HlsAdditionalManifest/ManifestNameModifier
     :cognitect.aws.mediaconvert.HlsAdditionalManifest/SelectedOutputs]))

(s/def
  :cognitect.aws.mediaconvert/SccDestinationFramerate
  (s/spec
    string?
    :gen
    #(s/gen
      #{"FRAMERATE_25"
        "FRAMERATE_23_97"
        "FRAMERATE_29_97_NON_DROPFRAME"
        "FRAMERATE_24"
        "FRAMERATE_29_97_DROPFRAME"})))

(s/def
  :cognitect.aws.mediaconvert/InputVideoGenerator
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.InputVideoGenerator/SampleRate
     :cognitect.aws.mediaconvert.InputVideoGenerator/FramerateDenominator
     :cognitect.aws.mediaconvert.InputVideoGenerator/Duration
     :cognitect.aws.mediaconvert.InputVideoGenerator/FramerateNumerator
     :cognitect.aws.mediaconvert.InputVideoGenerator/Channels]))

(s/def
  :cognitect.aws.mediaconvert/GetQueueResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.GetQueueResponse/Queue]))

(s/def
  :cognitect.aws.mediaconvert/CmafInitializationVectorInManifest
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/H265DynamicSubGop
  (s/spec string? :gen #(s/gen #{"ADAPTIVE" "STATIC"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin14PatternS3Mov09PngHttpsMov09Png
  (s/spec
    #(re-matches
      (re-pattern
        "^((s3://(.*)(\\.mov|[0-9]+\\.png))|(https?://(.*)(\\.mov|[0-9]+\\.png)(\\?([^&=]+=[^&]+&)*[^&=]+=[^&]+)?))$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/VideoDescription
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoDescription/Crop
     :cognitect.aws.mediaconvert.VideoDescription/DropFrameTimecode
     :cognitect.aws.mediaconvert.VideoDescription/TimecodeInsertion
     :cognitect.aws.mediaconvert.VideoDescription/Sharpness
     :cognitect.aws.mediaconvert.VideoDescription/CodecSettings
     :cognitect.aws.mediaconvert.VideoDescription/AfdSignaling
     :cognitect.aws.mediaconvert.VideoDescription/VideoPreprocessors
     :cognitect.aws.mediaconvert.VideoDescription/TimecodeTrack
     :cognitect.aws.mediaconvert.VideoDescription/Width
     :cognitect.aws.mediaconvert.VideoDescription/ScalingBehavior
     :cognitect.aws.mediaconvert.VideoDescription/AntiAlias
     :cognitect.aws.mediaconvert.VideoDescription/ColorMetadata
     :cognitect.aws.mediaconvert.VideoDescription/Position
     :cognitect.aws.mediaconvert.VideoDescription/Height
     :cognitect.aws.mediaconvert.VideoDescription/RespondToAfd
     :cognitect.aws.mediaconvert.VideoDescription/ChromaPositionMode
     :cognitect.aws.mediaconvert.VideoDescription/FixedAfd]))

(s/def :cognitect.aws.mediaconvert/DeletePresetResponse (s/keys))

(s/def
  :cognitect.aws.mediaconvert/__listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12
  (s/coll-of
    :cognitect.aws.mediaconvert/__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12))

(s/def
  :cognitect.aws.mediaconvert/__stringPattern0xAFaF0908190908
  (s/spec
    #(re-matches (re-pattern "(^0x[A-Fa-f0-9]{0,8}$|^[1-9][0-9]{0,8}$)") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/DeinterlacerMode
  (s/spec string? :gen #(s/gen #{"DEINTERLACE" "ADAPTIVE" "INVERSE_TELECINE"})))

(s/def
  :cognitect.aws.mediaconvert/ProresChromaSampling
  (s/spec string? :gen #(s/gen #{"SUBSAMPLE_TO_422" "PRESERVE_444_SAMPLING"})))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2CodecProfile
  (s/spec string? :gen #(s/gen #{"MAIN" "PROFILE_422"})))

(s/def
  :cognitect.aws.mediaconvert/H265SpatialAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/DvbSubtitleBackgroundColor
  (s/spec string? :gen #(s/gen #{"AUTO" "NONE" "WHITE" "BLACK"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max32
  (s/spec (s/and int? #(<= 1 % 32)) :gen #(gen/choose 1 32)))

(s/def
  :cognitect.aws.mediaconvert/CmafPtsOffsetHandlingForBFrames
  (s/spec string? :gen #(s/gen #{"MATCH_INITIAL_PTS" "ZERO_BASED"})))

(s/def
  :cognitect.aws.mediaconvert/MovReference
  (s/spec string? :gen #(s/gen #{"SELF_CONTAINED" "EXTERNAL"})))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2SpatialAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/MotionImageInsertionMode
  (s/spec string? :gen #(s/gen #{"MOV" "PNG"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin32000Max3024000
  (s/spec (s/and int? #(<= 32000 % 3024000)) :gen #(gen/choose 32000 3024000)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin48000Max48000
  (s/spec (s/and int? #(<= 48000 % 48000)) :gen #(gen/choose 48000 48000)))

(s/def
  :cognitect.aws.mediaconvert/ImscStylePassthrough
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/H265FramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfAutomatedAbrRule
  (s/coll-of :cognitect.aws.mediaconvert/AutomatedAbrRule))

(s/def
  :cognitect.aws.mediaconvert/MsSmoothFragmentLengthControl
  (s/spec string? :gen #(s/gen #{"EXACT" "GOP_MULTIPLE"})))

(s/def
  :cognitect.aws.mediaconvert/CreateJobTemplateResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.CreateJobTemplateResponse/JobTemplate]))

(s/def
  :cognitect.aws.mediaconvert/WavFormat
  (s/spec string? :gen #(s/gen #{"RF64" "EXTENSIBLE" "RIFF"})))

(s/def
  :cognitect.aws.mediaconvert/AudioTypeControl
  (s/spec string? :gen #(s/gen #{"FOLLOW_INPUT" "USE_CONFIGURED"})))

(s/def
  :cognitect.aws.mediaconvert/RequiredFlag
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/H265TemporalAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/Vp9FramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative180Max180
  (s/spec (s/and int? #(<= -180 % 180)) :gen #(gen/choose -180 180)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin3Max15
  (s/spec (s/and int? #(<= 3 % 15)) :gen #(gen/choose 3 15)))

(s/def :cognitect.aws.mediaconvert/__listOfInput (s/coll-of :cognitect.aws.mediaconvert/Input))

(s/def
  :cognitect.aws.mediaconvert/__stringMin32Max32Pattern09aFAF32
  (s/spec #(re-matches (re-pattern "^[0-9a-fA-F]{32}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__doubleMinNegative60Max3
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/MotionImageInserter
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MotionImageInserter/Offset
     :cognitect.aws.mediaconvert.MotionImageInserter/Framerate
     :cognitect.aws.mediaconvert.MotionImageInserter/StartTime
     :cognitect.aws.mediaconvert.MotionImageInserter/InsertionMode
     :cognitect.aws.mediaconvert.MotionImageInserter/Input
     :cognitect.aws.mediaconvert.MotionImageInserter/Playback]))

(s/def
  :cognitect.aws.mediaconvert/M2tsSegmentationStyle
  (s/spec string? :gen #(s/gen #{"MAINTAIN_CADENCE" "RESET_CADENCE"})))

(s/def
  :cognitect.aws.mediaconvert/FileSourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.FileSourceSettings/Framerate
     :cognitect.aws.mediaconvert.FileSourceSettings/SourceFile
     :cognitect.aws.mediaconvert.FileSourceSettings/Convert608To708
     :cognitect.aws.mediaconvert.FileSourceSettings/ByteRateLimit
     :cognitect.aws.mediaconvert.FileSourceSettings/TimeDelta
     :cognitect.aws.mediaconvert.FileSourceSettings/ConvertPaintToPop
     :cognitect.aws.mediaconvert.FileSourceSettings/TimeDeltaUnits]))

(s/def
  :cognitect.aws.mediaconvert/__stringMin0
  (s/spec
    (s/and string? #(<= 0 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.mediaconvert/M2tsKlvMetadata
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/AccelerationStatus
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "NOT_ACCELERATED" "NOT_APPLICABLE" "ACCELERATED"})))

(s/def
  :cognitect.aws.mediaconvert/Vp8Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Vp8Settings/RateControlMode
     :cognitect.aws.mediaconvert.Vp8Settings/ParDenominator
     :cognitect.aws.mediaconvert.Vp8Settings/QualityTuningLevel
     :cognitect.aws.mediaconvert.Vp8Settings/FramerateDenominator
     :cognitect.aws.mediaconvert.Vp8Settings/FramerateControl
     :cognitect.aws.mediaconvert.Vp8Settings/HrdBufferSize
     :cognitect.aws.mediaconvert.Vp8Settings/FramerateNumerator
     :cognitect.aws.mediaconvert.Vp8Settings/MaxBitrate
     :cognitect.aws.mediaconvert.Vp8Settings/ParNumerator
     :cognitect.aws.mediaconvert.Vp8Settings/GopSize
     :cognitect.aws.mediaconvert.Vp8Settings/ParControl
     :cognitect.aws.mediaconvert.Vp8Settings/FramerateConversionAlgorithm
     :cognitect.aws.mediaconvert.Vp8Settings/Bitrate]))

(s/def
  :cognitect.aws.mediaconvert/ForceIncludeRenditionSize
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ForceIncludeRenditionSize/Width
     :cognitect.aws.mediaconvert.ForceIncludeRenditionSize/Height]))

(s/def
  :cognitect.aws.mediaconvert/__stringMax2048PatternS3Https
  (s/spec
    #(re-matches (re-pattern "^s3://([^\\/]+\\/+)+((([^\\/]*)))|^https?://[^\\/].*[^&]$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternArnAwsUsGovCnKmsAZ26EastWestCentralNorthSouthEastWest1912D12KeyAFAF098AFAF094AFAF094AFAF094AFAF0912MrkAFAF0932
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws(-us-gov|-cn)?:kms:[a-z-]{2,6}-(east|west|central|((north|south)(east|west)?))-[1-9]{1,2}:\\d{12}:key/([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}|mrk-[a-fA-F0-9]{32})$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/CmfcTimedMetadata
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/XavcTemporalAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/Av1Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Av1Settings/RateControlMode
     :cognitect.aws.mediaconvert.Av1Settings/AdaptiveQuantization
     :cognitect.aws.mediaconvert.Av1Settings/FramerateDenominator
     :cognitect.aws.mediaconvert.Av1Settings/FramerateControl
     :cognitect.aws.mediaconvert.Av1Settings/FilmGrainSynthesis
     :cognitect.aws.mediaconvert.Av1Settings/NumberBFramesBetweenReferenceFrames
     :cognitect.aws.mediaconvert.Av1Settings/QvbrSettings
     :cognitect.aws.mediaconvert.Av1Settings/SpatialAdaptiveQuantization
     :cognitect.aws.mediaconvert.Av1Settings/FramerateNumerator
     :cognitect.aws.mediaconvert.Av1Settings/MaxBitrate
     :cognitect.aws.mediaconvert.Av1Settings/BitDepth
     :cognitect.aws.mediaconvert.Av1Settings/GopSize
     :cognitect.aws.mediaconvert.Av1Settings/Slices
     :cognitect.aws.mediaconvert.Av1Settings/FramerateConversionAlgorithm]))

(s/def
  :cognitect.aws.mediaconvert/Mp4FreeSpaceBox
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/DvbddsHandling
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "NONE" "NO_DISPLAY_WINDOW"})))

(s/def
  :cognitect.aws.mediaconvert/DolbyVisionProfile
  (s/spec string? :gen #(s/gen #{"PROFILE_8_1" "PROFILE_5"})))

(s/def :cognitect.aws.mediaconvert/Vp9RateControlMode (s/spec string? :gen #(s/gen #{"VBR"})))

(s/def :cognitect.aws.mediaconvert/__timestampUnix inst?)

(s/def :cognitect.aws.mediaconvert/DisassociateCertificateResponse (s/keys))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max10
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.mediaconvert/DvbSubtitleFontColor
  (s/spec string? :gen #(s/gen #{"AUTO" "HEX" "GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})))

(s/def
  :cognitect.aws.mediaconvert/BandwidthReductionFilterStrength
  (s/spec string? :gen #(s/gen #{"AUTO" "LOW" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.mediaconvert/ProresSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ProresSettings/InterlaceMode
     :cognitect.aws.mediaconvert.ProresSettings/ChromaSampling
     :cognitect.aws.mediaconvert.ProresSettings/ParDenominator
     :cognitect.aws.mediaconvert.ProresSettings/ScanTypeConversionMode
     :cognitect.aws.mediaconvert.ProresSettings/FramerateDenominator
     :cognitect.aws.mediaconvert.ProresSettings/FramerateControl
     :cognitect.aws.mediaconvert.ProresSettings/SlowPal
     :cognitect.aws.mediaconvert.ProresSettings/FramerateNumerator
     :cognitect.aws.mediaconvert.ProresSettings/CodecProfile
     :cognitect.aws.mediaconvert.ProresSettings/ParNumerator
     :cognitect.aws.mediaconvert.ProresSettings/ParControl
     :cognitect.aws.mediaconvert.ProresSettings/Telecine
     :cognitect.aws.mediaconvert.ProresSettings/FramerateConversionAlgorithm]))

(s/def :cognitect.aws.mediaconvert/DeleteQueueResponse (s/keys))

(s/def
  :cognitect.aws.mediaconvert/MxfXavcProfileSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MxfXavcProfileSettings/DurationMode
     :cognitect.aws.mediaconvert.MxfXavcProfileSettings/MaxAncDataSize]))

(s/def
  :cognitect.aws.mediaconvert/Av1FramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def
  :cognitect.aws.mediaconvert/ListJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListJobsResponse/NextToken
     :cognitect.aws.mediaconvert.ListJobsResponse/Jobs]))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosCodingMode
  (s/spec
    string?
    :gen
    #(s/gen #{"CODING_MODE_AUTO" "CODING_MODE_7_1_4" "CODING_MODE_5_1_4" "CODING_MODE_9_1_6"})))

(s/def
  :cognitect.aws.mediaconvert/HlsTargetDurationCompatibilityMode
  (s/spec string? :gen #(s/gen #{"LEGACY" "SPEC_COMPLIANT"})))

(s/def
  :cognitect.aws.mediaconvert/XavcSpatialAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/DecryptionMode
  (s/spec string? :gen #(s/gen #{"AES_GCM" "AES_CBC" "AES_CTR"})))

(s/def
  :cognitect.aws.mediaconvert/M3u8AudioDuration
  (s/spec string? :gen #(s/gen #{"DEFAULT_CODEC_DURATION" "MATCH_VIDEO_DURATION"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin3Max3Pattern1809aFAF09aEAE
  (s/spec #(re-matches (re-pattern "^[1-8][0-9a-fA-F][0-9a-eA-E]$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/Eac3CodingMode
  (s/spec string? :gen #(s/gen #{"CODING_MODE_1_0" "CODING_MODE_2_0" "CODING_MODE_3_2"})))

(s/def
  :cognitect.aws.mediaconvert/NexGuardFileMarkerSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.NexGuardFileMarkerSettings/Payload
     :cognitect.aws.mediaconvert.NexGuardFileMarkerSettings/Strength
     :cognitect.aws.mediaconvert.NexGuardFileMarkerSettings/Preset
     :cognitect.aws.mediaconvert.NexGuardFileMarkerSettings/License]))

(s/def
  :cognitect.aws.mediaconvert/__mapOfDynamicAudioSelector
  (s/map-of :cognitect.aws.mediaconvert/__string :cognitect.aws.mediaconvert/DynamicAudioSelector))

(s/def
  :cognitect.aws.mediaconvert/EmbeddedDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.EmbeddedDestinationSettings/Destination708ServiceNumber
     :cognitect.aws.mediaconvert.EmbeddedDestinationSettings/Destination608ChannelNumber]))

(s/def
  :cognitect.aws.mediaconvert/BurninSubtitleAlignment
  (s/spec string? :gen #(s/gen #{"LEFT" "AUTO" "CENTERED"})))

(s/def
  :cognitect.aws.mediaconvert/Ac3LfeFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/HlsProgressiveWriteHlsManifest
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin3Max3PatternAZaZ3
  (s/spec #(re-matches (re-pattern "^[A-Za-z]{3}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/UpdatePresetResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.UpdatePresetResponse/Preset]))

(s/def
  :cognitect.aws.mediaconvert/__mapOfCaptionSelector
  (s/map-of :cognitect.aws.mediaconvert/__string :cognitect.aws.mediaconvert/CaptionSelector))

(s/def
  :cognitect.aws.mediaconvert/__integerMin8000Max96000
  (s/spec (s/and int? #(<= 8000 % 96000)) :gen #(gen/choose 8000 96000)))

(s/def :cognitect.aws.mediaconvert/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.mediaconvert/HlsGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.HlsGroupSettings/SegmentLength
     :cognitect.aws.mediaconvert.HlsGroupSettings/TimestampDeltaMilliseconds
     :cognitect.aws.mediaconvert.HlsGroupSettings/ImageBasedTrickPlay
     :cognitect.aws.mediaconvert.HlsGroupSettings/ProgramDateTimePeriod
     :cognitect.aws.mediaconvert.HlsGroupSettings/SegmentControl
     :cognitect.aws.mediaconvert.HlsGroupSettings/AdditionalManifests
     :cognitect.aws.mediaconvert.HlsGroupSettings/AdMarkers
     :cognitect.aws.mediaconvert.HlsGroupSettings/CaptionSegmentLengthControl
     :cognitect.aws.mediaconvert.HlsGroupSettings/BaseUrl
     :cognitect.aws.mediaconvert.HlsGroupSettings/SegmentLengthControl
     :cognitect.aws.mediaconvert.HlsGroupSettings/Destination
     :cognitect.aws.mediaconvert.HlsGroupSettings/MinFinalSegmentLength
     :cognitect.aws.mediaconvert.HlsGroupSettings/CaptionLanguageMappings
     :cognitect.aws.mediaconvert.HlsGroupSettings/TimedMetadataId3Frame
     :cognitect.aws.mediaconvert.HlsGroupSettings/DirectoryStructure
     :cognitect.aws.mediaconvert.HlsGroupSettings/DestinationSettings
     :cognitect.aws.mediaconvert.HlsGroupSettings/MinSegmentLength
     :cognitect.aws.mediaconvert.HlsGroupSettings/ImageBasedTrickPlaySettings
     :cognitect.aws.mediaconvert.HlsGroupSettings/StreamInfResolution
     :cognitect.aws.mediaconvert.HlsGroupSettings/ProgramDateTime
     :cognitect.aws.mediaconvert.HlsGroupSettings/OutputSelection
     :cognitect.aws.mediaconvert.HlsGroupSettings/CaptionLanguageSetting
     :cognitect.aws.mediaconvert.HlsGroupSettings/ManifestDurationFormat
     :cognitect.aws.mediaconvert.HlsGroupSettings/AudioOnlyHeader
     :cognitect.aws.mediaconvert.HlsGroupSettings/TimedMetadataId3Period
     :cognitect.aws.mediaconvert.HlsGroupSettings/ManifestCompression
     :cognitect.aws.mediaconvert.HlsGroupSettings/SegmentsPerSubdirectory
     :cognitect.aws.mediaconvert.HlsGroupSettings/Encryption
     :cognitect.aws.mediaconvert.HlsGroupSettings/TargetDurationCompatibilityMode
     :cognitect.aws.mediaconvert.HlsGroupSettings/ProgressiveWriteHlsManifest
     :cognitect.aws.mediaconvert.HlsGroupSettings/CodecSpecification
     :cognitect.aws.mediaconvert.HlsGroupSettings/ClientCache]))

(s/def
  :cognitect.aws.mediaconvert/NoiseReducer
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.NoiseReducer/Filter
     :cognitect.aws.mediaconvert.NoiseReducer/TemporalFilterSettings
     :cognitect.aws.mediaconvert.NoiseReducer/SpatialFilterSettings
     :cognitect.aws.mediaconvert.NoiseReducer/FilterSettings]))

(s/def
  :cognitect.aws.mediaconvert/HlsTimedMetadataId3Frame
  (s/spec string? :gen #(s/gen #{"TDRL" "NONE" "PRIV"})))

(s/def
  :cognitect.aws.mediaconvert/H264FramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/Mp4CslgAtom
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/H265WriteMp4PackagingType
  (s/spec string? :gen #(s/gen #{"HVC1" "HEV1"})))

(s/def :cognitect.aws.mediaconvert/__boolean boolean?)

(s/def
  :cognitect.aws.mediaconvert/__listOfAudioDescription
  (s/coll-of :cognitect.aws.mediaconvert/AudioDescription))

(s/def
  :cognitect.aws.mediaconvert/__listOfTeletextPageType
  (s/coll-of :cognitect.aws.mediaconvert/TeletextPageType))

(s/def
  :cognitect.aws.mediaconvert/UncompressedFourcc
  (s/spec string? :gen #(s/gen #{"I420" "I422" "I444"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3PassthroughControl
  (s/spec string? :gen #(s/gen #{"WHEN_POSSIBLE" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.mediaconvert/Endpoint
  (s/keys :opt-un [:cognitect.aws.mediaconvert.Endpoint/Url]))

(s/def
  :cognitect.aws.mediaconvert/__doubleMin0Max1
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin32Max8182
  (s/spec (s/and int? #(<= 32 % 8182)) :gen #(gen/choose 32 8182)))

(s/def
  :cognitect.aws.mediaconvert/F4vMoovPlacement
  (s/spec string? :gen #(s/gen #{"NORMAL" "PROGRESSIVE_DOWNLOAD"})))

(s/def
  :cognitect.aws.mediaconvert/DashIsoWriteSegmentTimelineInRepresentation
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1000Max300000000
  (s/spec (s/and int? #(<= 1000 % 300000000)) :gen #(gen/choose 1000 300000000)))

(s/def
  :cognitect.aws.mediaconvert/DvbSubDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontFileBold
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/TeletextSpacing
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/OutlineColor
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontScript
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/OutlineSize
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/DdsYCoordinate
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/DdsHandling
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/HexFontColor
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ShadowColor
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ShadowOpacity
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ShadowYOffset
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FallbackFont
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/BackgroundColor
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/Width
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontFileBoldItalic
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ApplyFontColor
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/SubtitlingType
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/YPosition
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontColor
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/XPosition
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontFileRegular
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontResolution
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/Height
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontSize
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/BackgroundOpacity
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontOpacity
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/StylePassthrough
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/DdsXCoordinate
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ShadowXOffset
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/Alignment
     :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontFileItalic]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max500
  (s/spec (s/and int? #(<= 0 % 500)) :gen #(gen/choose 0 500)))

(s/def
  :cognitect.aws.mediaconvert/DropFrameTimecode
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/DashIsoPtsOffsetHandlingForBFrames
  (s/spec string? :gen #(s/gen #{"MATCH_INITIAL_PTS" "ZERO_BASED"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin24Max512PatternAZaZ0902
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9+\\/]+={0,2}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/S3StorageClass
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DEEP_ARCHIVE"
        "GLACIER"
        "ONEZONE_IA"
        "STANDARD_IA"
        "STANDARD"
        "INTELLIGENT_TIERING"
        "REDUCED_REDUNDANCY"})))

(s/def
  :cognitect.aws.mediaconvert/QueueTransition
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.QueueTransition/SourceQueue
     :cognitect.aws.mediaconvert.QueueTransition/Timestamp
     :cognitect.aws.mediaconvert.QueueTransition/DestinationQueue]))

(s/def
  :cognitect.aws.mediaconvert/CreateJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.CreateJobRequest/Role
     :cognitect.aws.mediaconvert.CreateJobRequest/Settings]
    :opt-un
    [:cognitect.aws.mediaconvert.CreateJobRequest/JobEngineVersion
     :cognitect.aws.mediaconvert.CreateJobRequest/ClientRequestToken
     :cognitect.aws.mediaconvert.CreateJobRequest/Queue
     :cognitect.aws.mediaconvert.CreateJobRequest/Tags
     :cognitect.aws.mediaconvert.CreateJobRequest/JobTemplate
     :cognitect.aws.mediaconvert.CreateJobRequest/Priority
     :cognitect.aws.mediaconvert.CreateJobRequest/UserMetadata
     :cognitect.aws.mediaconvert.CreateJobRequest/AccelerationSettings
     :cognitect.aws.mediaconvert.CreateJobRequest/HopDestinations
     :cognitect.aws.mediaconvert.CreateJobRequest/SimulateReservedQueue
     :cognitect.aws.mediaconvert.CreateJobRequest/StatusUpdateInterval
     :cognitect.aws.mediaconvert.CreateJobRequest/BillingTagsSource]))

(s/def
  :cognitect.aws.mediaconvert/HlsClientCache
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/CmafManifestDurationFormat
  (s/spec string? :gen #(s/gen #{"FLOATING_POINT" "INTEGER"})))

(s/def
  :cognitect.aws.mediaconvert/H264ScanTypeConversionMode
  (s/spec string? :gen #(s/gen #{"INTERLACED_OPTIMIZE" "INTERLACED"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1000Max288000000
  (s/spec (s/and int? #(<= 1000 % 288000000)) :gen #(gen/choose 1000 288000000)))

(s/def
  :cognitect.aws.mediaconvert/TeletextPageType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"PAGE_TYPE_INITIAL"
        "PAGE_TYPE_ADDL_INFO"
        "PAGE_TYPE_PROGRAM_SCHEDULE"
        "PAGE_TYPE_HEARING_IMPAIRED_SUBTITLE"
        "PAGE_TYPE_SUBTITLE"})))

(s/def
  :cognitect.aws.mediaconvert/DvbSubSubtitleFallbackFont
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MONOSPACED_SERIF"
        "BEST_MATCH"
        "PROPORTIONAL_SANSSERIF"
        "PROPORTIONAL_SERIF"
        "MONOSPACED_SANSSERIF"})))

(s/def
  :cognitect.aws.mediaconvert/H265FramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfVideoOverlay
  (s/coll-of :cognitect.aws.mediaconvert/VideoOverlay))

(s/def
  :cognitect.aws.mediaconvert/H264UnregisteredSeiTimecode
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/VideoSelector
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoSelector/Pid
     :cognitect.aws.mediaconvert.VideoSelector/MaxLuminance
     :cognitect.aws.mediaconvert.VideoSelector/ProgramNumber
     :cognitect.aws.mediaconvert.VideoSelector/PadVideo
     :cognitect.aws.mediaconvert.VideoSelector/Hdr10Metadata
     :cognitect.aws.mediaconvert.VideoSelector/EmbeddedTimecodeOverride
     :cognitect.aws.mediaconvert.VideoSelector/AlphaBehavior
     :cognitect.aws.mediaconvert.VideoSelector/ColorSpace
     :cognitect.aws.mediaconvert.VideoSelector/SampleRange
     :cognitect.aws.mediaconvert.VideoSelector/Rotate
     :cognitect.aws.mediaconvert.VideoSelector/ColorSpaceUsage]))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternAZaZ23AZaZ
  (s/spec #(re-matches (re-pattern "^[A-Za-z]{2,3}(-[A-Za-z-]+)?$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max4
  (s/spec (s/and int? #(<= 1 % 4)) :gen #(gen/choose 1 4)))

(s/def
  :cognitect.aws.mediaconvert/Eac3SurroundMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "NOT_INDICATED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/Av1FramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative70Max0
  (s/spec (s/and int? #(<= -70 % 0)) :gen #(gen/choose -70 0)))

(s/def
  :cognitect.aws.mediaconvert/XavcHdIntraCbgProfileSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.XavcHdIntraCbgProfileSettings/XavcClass]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max2
  (s/spec (s/and int? #(<= 1 % 2)) :gen #(gen/choose 1 2)))

(s/def
  :cognitect.aws.mediaconvert/XavcEntropyEncoding
  (s/spec string? :gen #(s/gen #{"CABAC" "AUTO" "CAVLC"})))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2SceneChangeDetect
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/DvbSubtitleAlignment
  (s/spec string? :gen #(s/gen #{"LEFT" "AUTO" "CENTERED"})))

(s/def
  :cognitect.aws.mediaconvert/BurninSubtitleFallbackFont
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MONOSPACED_SERIF"
        "BEST_MATCH"
        "PROPORTIONAL_SANSSERIF"
        "PROPORTIONAL_SERIF"
        "MONOSPACED_SANSSERIF"})))

(s/def
  :cognitect.aws.mediaconvert/ListPresetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListPresetsResponse/Presets
     :cognitect.aws.mediaconvert.ListPresetsResponse/NextToken]))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative60Max6
  (s/spec (s/and int? #(<= -60 % 6)) :gen #(gen/choose -60 6)))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternDD
  (s/spec #(re-matches (re-pattern "^(\\d+(\\/\\d+)*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/HlsAudioOnlyContainer
  (s/spec string? :gen #(s/gen #{"AUTOMATIC" "M2TS"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfQueueTransition
  (s/coll-of :cognitect.aws.mediaconvert/QueueTransition))

(s/def
  :cognitect.aws.mediaconvert/InputFilterEnable
  (s/spec string? :gen #(s/gen #{"DISABLE" "AUTO" "FORCE"})))

(s/def
  :cognitect.aws.mediaconvert/H264EndOfStreamMarkers
  (s/spec string? :gen #(s/gen #{"INCLUDE" "SUPPRESS"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternHttpsKantarmedia
  (s/spec #(re-matches (re-pattern "^https:\\/\\/.*.kantarmedia.*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max150
  (s/spec (s/and int? #(<= 1 % 150)) :gen #(gen/choose 1 150)))

(s/def
  :cognitect.aws.mediaconvert/StatusUpdateInterval
  (s/spec
    string?
    :gen
    #(s/gen
      #{"SECONDS_540"
        "SECONDS_120"
        "SECONDS_600"
        "SECONDS_420"
        "SECONDS_240"
        "SECONDS_360"
        "SECONDS_12"
        "SECONDS_20"
        "SECONDS_10"
        "SECONDS_60"
        "SECONDS_30"
        "SECONDS_300"
        "SECONDS_480"
        "SECONDS_180"
        "SECONDS_15"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosDynamicRangeControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/Id3Insertion
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Id3Insertion/Timecode
     :cognitect.aws.mediaconvert.Id3Insertion/Id3]))

(s/def
  :cognitect.aws.mediaconvert/Mp4Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Mp4Settings/Mp4MajorBrand
     :cognitect.aws.mediaconvert.Mp4Settings/CttsVersion
     :cognitect.aws.mediaconvert.Mp4Settings/CslgAtom
     :cognitect.aws.mediaconvert.Mp4Settings/MoovPlacement
     :cognitect.aws.mediaconvert.Mp4Settings/FreeSpaceBox
     :cognitect.aws.mediaconvert.Mp4Settings/AudioDuration]))

(s/def
  :cognitect.aws.mediaconvert/AudioDurationCorrection
  (s/spec string? :gen #(s/gen #{"DISABLED" "AUTO" "FRAME" "FORCE" "TRACK"})))

(s/def
  :cognitect.aws.mediaconvert/DolbyVisionMapping
  (s/spec string? :gen #(s/gen #{"HDR10_NOMAP" "HDR10_1000"})))

(s/def
  :cognitect.aws.mediaconvert/H264QualityTuningLevel
  (s/spec string? :gen #(s/gen #{"MULTI_PASS_HQ" "SINGLE_PASS" "SINGLE_PASS_HQ"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternArnAwsUsGovAcm
  (s/spec #(re-matches (re-pattern "^arn:aws(-us-gov)?:acm:") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin100000Max100000000
  (s/spec (s/and int? #(<= 100000 % 100000000)) :gen #(gen/choose 100000 100000000)))

(s/def
  :cognitect.aws.mediaconvert/AacCodingMode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AD_RECEIVER_MIX"
        "CODING_MODE_1_0"
        "CODING_MODE_1_1"
        "CODING_MODE_2_0"
        "CODING_MODE_5_1"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosDownmixControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/UncompressedTelecine
  (s/spec string? :gen #(s/gen #{"HARD" "NONE"})))

(s/def :cognitect.aws.mediaconvert/TsPtsOffset (s/spec string? :gen #(s/gen #{"SECONDS" "AUTO"})))

(s/def
  :cognitect.aws.mediaconvert/CmafEncryptionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CmafEncryptionSettings/Type
     :cognitect.aws.mediaconvert.CmafEncryptionSettings/ConstantInitializationVector
     :cognitect.aws.mediaconvert.CmafEncryptionSettings/InitializationVectorInManifest
     :cognitect.aws.mediaconvert.CmafEncryptionSettings/SpekeKeyProvider
     :cognitect.aws.mediaconvert.CmafEncryptionSettings/EncryptionMethod
     :cognitect.aws.mediaconvert.CmafEncryptionSettings/StaticKeyProvider]))

(s/def
  :cognitect.aws.mediaconvert/HlsEncryptionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.HlsEncryptionSettings/Type
     :cognitect.aws.mediaconvert.HlsEncryptionSettings/ConstantInitializationVector
     :cognitect.aws.mediaconvert.HlsEncryptionSettings/InitializationVectorInManifest
     :cognitect.aws.mediaconvert.HlsEncryptionSettings/SpekeKeyProvider
     :cognitect.aws.mediaconvert.HlsEncryptionSettings/OfflineEncrypted
     :cognitect.aws.mediaconvert.HlsEncryptionSettings/EncryptionMethod
     :cognitect.aws.mediaconvert.HlsEncryptionSettings/StaticKeyProvider]))

(s/def
  :cognitect.aws.mediaconvert/__double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/H264EntropyEncoding
  (s/spec string? :gen #(s/gen #{"CABAC" "CAVLC"})))

(s/def
  :cognitect.aws.mediaconvert/H265RateControlMode
  (s/spec string? :gen #(s/gen #{"VBR" "CBR" "QVBR"})))

(s/def
  :cognitect.aws.mediaconvert/DeinterlaceAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"INTERPOLATE_TICKER" "INTERPOLATE" "BLEND" "LINEAR_INTERPOLATION" "BLEND_TICKER"})))

(s/def
  :cognitect.aws.mediaconvert/AdvancedInputFilterSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AdvancedInputFilterSettings/Sharpening
     :cognitect.aws.mediaconvert.AdvancedInputFilterSettings/AddTexture]))

(s/def :cognitect.aws.mediaconvert/Av1BitDepth (s/spec string? :gen #(s/gen #{"BIT_10" "BIT_8"})))

(s/def
  :cognitect.aws.mediaconvert/AudioNormalizationLoudnessLogging
  (s/spec string? :gen #(s/gen #{"DONT_LOG" "LOG"})))

(s/def
  :cognitect.aws.mediaconvert/HlsDirectoryStructure
  (s/spec string? :gen #(s/gen #{"SINGLE_DIRECTORY" "SUBDIRECTORY_PER_STREAM"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternWS
  (s/spec #(re-matches (re-pattern "^[\\w\\s]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/H265AdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"AUTO" "LOW" "MAX" "HIGHER" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.mediaconvert/HlsStreamInfResolution
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/AssociateCertificateRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.AssociateCertificateRequest/Arn]))

(s/def :cognitect.aws.mediaconvert/MpdScte35Esam (s/spec string? :gen #(s/gen #{"INSERT" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin64000Max640000
  (s/spec (s/and int? #(<= 64000 % 640000)) :gen #(gen/choose 64000 640000)))

(s/def
  :cognitect.aws.mediaconvert/InputSampleRange
  (s/spec string? :gen #(s/gen #{"LIMITED_RANGE" "FULL_RANGE" "FOLLOW"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative1Max3
  (s/spec (s/and int? #(<= -1 % 3)) :gen #(gen/choose -1 3)))

(s/def
  :cognitect.aws.mediaconvert/H264CodecLevel
  (s/spec
    string?
    :gen
    #(s/gen
      #{"LEVEL_2_1"
        "LEVEL_1_3"
        "LEVEL_5"
        "LEVEL_1"
        "LEVEL_3_2"
        "AUTO"
        "LEVEL_4_1"
        "LEVEL_5_1"
        "LEVEL_5_2"
        "LEVEL_4"
        "LEVEL_2"
        "LEVEL_3"
        "LEVEL_1_1"
        "LEVEL_4_2"
        "LEVEL_3_1"
        "LEVEL_2_2"
        "LEVEL_1_2"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin16000Max48000
  (s/spec (s/and int? #(<= 16000 % 48000)) :gen #(gen/choose 16000 48000)))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative1Max2147483647
  (s/spec (s/and int? #(<= -1 % 2147483647)) :gen #(gen/choose -1 2147483647)))

(s/def
  :cognitect.aws.mediaconvert/XavcHdProfileBitrateClass
  (s/spec string? :gen #(s/gen #{"BITRATE_CLASS_35" "BITRATE_CLASS_25" "BITRATE_CLASS_50"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin32000Max48000
  (s/spec (s/and int? #(<= 32000 % 48000)) :gen #(gen/choose 32000 48000)))

(s/def
  :cognitect.aws.mediaconvert/MpdKlvMetadata
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/ListVersionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListVersionsResponse/Versions
     :cognitect.aws.mediaconvert.ListVersionsResponse/NextToken]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max96
  (s/spec (s/and int? #(<= 0 % 96)) :gen #(gen/choose 0 96)))

(s/def
  :cognitect.aws.mediaconvert/MsSmoothAdditionalManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MsSmoothAdditionalManifest/ManifestNameModifier
     :cognitect.aws.mediaconvert.MsSmoothAdditionalManifest/SelectedOutputs]))

(s/def
  :cognitect.aws.mediaconvert/__listOf__integerMin32Max8182
  (s/coll-of :cognitect.aws.mediaconvert/__integerMin32Max8182))

(s/def
  :cognitect.aws.mediaconvert/HlsInitializationVectorInManifest
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/MxfXavcDurationMode
  (s/spec string? :gen #(s/gen #{"ALLOW_ANY_DURATION" "DROP_FRAMES_FOR_COMPLIANCE"})))

(s/def
  :cognitect.aws.mediaconvert/CmafWriteDASHManifest
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/ContainerSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ContainerSettings/CmfcSettings
     :cognitect.aws.mediaconvert.ContainerSettings/M2tsSettings
     :cognitect.aws.mediaconvert.ContainerSettings/MxfSettings
     :cognitect.aws.mediaconvert.ContainerSettings/Mp4Settings
     :cognitect.aws.mediaconvert.ContainerSettings/MpdSettings
     :cognitect.aws.mediaconvert.ContainerSettings/Container
     :cognitect.aws.mediaconvert.ContainerSettings/MovSettings
     :cognitect.aws.mediaconvert.ContainerSettings/M3u8Settings
     :cognitect.aws.mediaconvert.ContainerSettings/F4vSettings]))

(s/def
  :cognitect.aws.mediaconvert/M2tsAudioDuration
  (s/spec string? :gen #(s/gen #{"DEFAULT_CODEC_DURATION" "MATCH_VIDEO_DURATION"})))

(s/def
  :cognitect.aws.mediaconvert/TimecodeTrack
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/ColorSpaceUsage
  (s/spec string? :gen #(s/gen #{"FORCE" "FALLBACK"})))

(s/def
  :cognitect.aws.mediaconvert/Input
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Input/Crop
     :cognitect.aws.mediaconvert.Input/DenoiseFilter
     :cognitect.aws.mediaconvert.Input/FilterStrength
     :cognitect.aws.mediaconvert.Input/ProgramNumber
     :cognitect.aws.mediaconvert.Input/InputClippings
     :cognitect.aws.mediaconvert.Input/TimecodeSource
     :cognitect.aws.mediaconvert.Input/SupplementalImps
     :cognitect.aws.mediaconvert.Input/CaptionSelectors
     :cognitect.aws.mediaconvert.Input/VideoSelector
     :cognitect.aws.mediaconvert.Input/AdvancedInputFilter
     :cognitect.aws.mediaconvert.Input/VideoGenerator
     :cognitect.aws.mediaconvert.Input/Position
     :cognitect.aws.mediaconvert.Input/AudioSelectorGroups
     :cognitect.aws.mediaconvert.Input/FilterEnable
     :cognitect.aws.mediaconvert.Input/ImageInserter
     :cognitect.aws.mediaconvert.Input/PsiControl
     :cognitect.aws.mediaconvert.Input/DolbyVisionMetadataXml
     :cognitect.aws.mediaconvert.Input/VideoOverlays
     :cognitect.aws.mediaconvert.Input/DynamicAudioSelectors
     :cognitect.aws.mediaconvert.Input/AudioSelectors
     :cognitect.aws.mediaconvert.Input/TimecodeStart
     :cognitect.aws.mediaconvert.Input/AdvancedInputFilterSettings
     :cognitect.aws.mediaconvert.Input/FileInput
     :cognitect.aws.mediaconvert.Input/DeblockFilter
     :cognitect.aws.mediaconvert.Input/InputScanType
     :cognitect.aws.mediaconvert.Input/DecryptionSettings]))

(s/def
  :cognitect.aws.mediaconvert/Xavc4kIntraCbgProfileSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.Xavc4kIntraCbgProfileSettings/XavcClass]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin32000Max384000
  (s/spec (s/and int? #(<= 32000 % 384000)) :gen #(gen/choose 32000 384000)))

(s/def
  :cognitect.aws.mediaconvert/MinTopRenditionSize
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MinTopRenditionSize/Width
     :cognitect.aws.mediaconvert.MinTopRenditionSize/Height]))

(s/def :cognitect.aws.mediaconvert/M2tsNielsenId3 (s/spec string? :gen #(s/gen #{"INSERT" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/SpekeKeyProvider
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.SpekeKeyProvider/ResourceId
     :cognitect.aws.mediaconvert.SpekeKeyProvider/EncryptionContractConfiguration
     :cognitect.aws.mediaconvert.SpekeKeyProvider/Url
     :cognitect.aws.mediaconvert.SpekeKeyProvider/CertificateArn
     :cognitect.aws.mediaconvert.SpekeKeyProvider/SystemIds]))

(s/def
  :cognitect.aws.mediaconvert/NielsenNonLinearWatermarkSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/AssetName
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/UniqueTicPerAudioTrack
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/EpisodeId
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/ActiveWatermarkProcess
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/SourceId
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/AdiFilename
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/AssetId
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/CbetSourceId
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/SourceWatermarkStatus
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/TicServerUrl
     :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/MetadataDestination]))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative5Max10
  (s/spec (s/and int? #(<= -5 % 10)) :gen #(gen/choose -5 10)))

(s/def
  :cognitect.aws.mediaconvert/InputDeblockFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/NielsenConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.NielsenConfiguration/BreakoutCode
     :cognitect.aws.mediaconvert.NielsenConfiguration/DistributorId]))

(s/def
  :cognitect.aws.mediaconvert/AccelerationSettings
  (s/keys :req-un [:cognitect.aws.mediaconvert.AccelerationSettings/Mode]))

(s/def
  :cognitect.aws.mediaconvert/DashIsoGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DashIsoGroupSettings/PtsOffsetHandlingForBFrames
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/SegmentLength
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/MinBufferTime
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/WriteSegmentTimelineInRepresentation
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/FragmentLength
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/HbbtvCompliance
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/ImageBasedTrickPlay
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/SegmentControl
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/AdditionalManifests
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/DashManifestStyle
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/BaseUrl
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/SegmentLengthControl
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/Destination
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/MinFinalSegmentLength
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/MpdManifestBandwidthType
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/DestinationSettings
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/VideoCompositionOffsets
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/ImageBasedTrickPlaySettings
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/MpdProfile
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/Encryption
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/AudioChannelConfigSchemeIdUri
     :cognitect.aws.mediaconvert.DashIsoGroupSettings/DashIFrameTrickPlayNameModifier]))

(s/def
  :cognitect.aws.mediaconvert/CaptionSourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CaptionSourceSettings/TrackSourceSettings
     :cognitect.aws.mediaconvert.CaptionSourceSettings/DvbSubSourceSettings
     :cognitect.aws.mediaconvert.CaptionSourceSettings/WebvttHlsSourceSettings
     :cognitect.aws.mediaconvert.CaptionSourceSettings/TeletextSourceSettings
     :cognitect.aws.mediaconvert.CaptionSourceSettings/SourceType
     :cognitect.aws.mediaconvert.CaptionSourceSettings/AncillarySourceSettings
     :cognitect.aws.mediaconvert.CaptionSourceSettings/FileSourceSettings
     :cognitect.aws.mediaconvert.CaptionSourceSettings/EmbeddedSourceSettings]))

(s/def
  :cognitect.aws.mediaconvert/InsertableImage
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.InsertableImage/StartTime
     :cognitect.aws.mediaconvert.InsertableImage/Opacity
     :cognitect.aws.mediaconvert.InsertableImage/ImageX
     :cognitect.aws.mediaconvert.InsertableImage/Width
     :cognitect.aws.mediaconvert.InsertableImage/Layer
     :cognitect.aws.mediaconvert.InsertableImage/Duration
     :cognitect.aws.mediaconvert.InsertableImage/FadeIn
     :cognitect.aws.mediaconvert.InsertableImage/ImageInserterInput
     :cognitect.aws.mediaconvert.InsertableImage/Height
     :cognitect.aws.mediaconvert.InsertableImage/ImageY
     :cognitect.aws.mediaconvert.InsertableImage/FadeOut]))

(s/def
  :cognitect.aws.mediaconvert/__listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12
  (s/coll-of :cognitect.aws.mediaconvert/__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12))

(s/def
  :cognitect.aws.mediaconvert/Vp8FramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/CmfcAudioDuration
  (s/spec string? :gen #(s/gen #{"DEFAULT_CODEC_DURATION" "MATCH_VIDEO_DURATION"})))

(s/def
  :cognitect.aws.mediaconvert/DvbSubtitleStylePassthrough
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max8
  (s/spec (s/and int? #(<= 1 % 8)) :gen #(gen/choose 1 8)))

(s/def
  :cognitect.aws.mediaconvert/ServiceOverride
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ServiceOverride/Value
     :cognitect.aws.mediaconvert.ServiceOverride/Message
     :cognitect.aws.mediaconvert.ServiceOverride/Name
     :cognitect.aws.mediaconvert.ServiceOverride/OverrideValue]))

(s/def
  :cognitect.aws.mediaconvert/JobStatus
  (s/spec string? :gen #(s/gen #{"CANCELED" "ERROR" "SUBMITTED" "PROGRESSING" "COMPLETE"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternS3
  (s/spec #(re-matches (re-pattern "^s3:\\/\\/") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/AacSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AacSettings/RateControlMode
     :cognitect.aws.mediaconvert.AacSettings/CodingMode
     :cognitect.aws.mediaconvert.AacSettings/SampleRate
     :cognitect.aws.mediaconvert.AacSettings/VbrQuality
     :cognitect.aws.mediaconvert.AacSettings/Specification
     :cognitect.aws.mediaconvert.AacSettings/CodecProfile
     :cognitect.aws.mediaconvert.AacSettings/RawFormat
     :cognitect.aws.mediaconvert.AacSettings/AudioDescriptionBroadcasterMix
     :cognitect.aws.mediaconvert.AacSettings/Bitrate]))

(s/def
  :cognitect.aws.mediaconvert/ColorConversion3DLUTSetting
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/OutputMasteringLuminance
     :cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/OutputColorSpace
     :cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/InputMasteringLuminance
     :cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/FileInput
     :cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/InputColorSpace]))

(s/def
  :cognitect.aws.mediaconvert/XavcSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.XavcSettings/AdaptiveQuantization
     :cognitect.aws.mediaconvert.XavcSettings/FramerateDenominator
     :cognitect.aws.mediaconvert.XavcSettings/FramerateControl
     :cognitect.aws.mediaconvert.XavcSettings/XavcHdIntraCbgProfileSettings
     :cognitect.aws.mediaconvert.XavcSettings/SlowPal
     :cognitect.aws.mediaconvert.XavcSettings/XavcHdProfileSettings
     :cognitect.aws.mediaconvert.XavcSettings/Profile
     :cognitect.aws.mediaconvert.XavcSettings/Xavc4kProfileSettings
     :cognitect.aws.mediaconvert.XavcSettings/SpatialAdaptiveQuantization
     :cognitect.aws.mediaconvert.XavcSettings/FramerateNumerator
     :cognitect.aws.mediaconvert.XavcSettings/Softness
     :cognitect.aws.mediaconvert.XavcSettings/Xavc4kIntraVbrProfileSettings
     :cognitect.aws.mediaconvert.XavcSettings/Xavc4kIntraCbgProfileSettings
     :cognitect.aws.mediaconvert.XavcSettings/TemporalAdaptiveQuantization
     :cognitect.aws.mediaconvert.XavcSettings/FramerateConversionAlgorithm
     :cognitect.aws.mediaconvert.XavcSettings/EntropyEncoding]))

(s/def
  :cognitect.aws.mediaconvert/MpdTimedMetadata
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/FileGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.FileGroupSettings/Destination
     :cognitect.aws.mediaconvert.FileGroupSettings/DestinationSettings]))

(s/def
  :cognitect.aws.mediaconvert/__stringMax1000
  (s/spec
    (s/and string? #(>= 1000 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.mediaconvert/BurninSubtitleBackgroundColor
  (s/spec string? :gen #(s/gen #{"AUTO" "NONE" "WHITE" "BLACK"})))

(s/def
  :cognitect.aws.mediaconvert/H265FlickerAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/CreateJobTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.CreateJobTemplateRequest/Settings
     :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Name]
    :opt-un
    [:cognitect.aws.mediaconvert.CreateJobTemplateRequest/Category
     :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Queue
     :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Tags
     :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Priority
     :cognitect.aws.mediaconvert.CreateJobTemplateRequest/AccelerationSettings
     :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Description
     :cognitect.aws.mediaconvert.CreateJobTemplateRequest/HopDestinations
     :cognitect.aws.mediaconvert.CreateJobTemplateRequest/StatusUpdateInterval]))

(s/def
  :cognitect.aws.mediaconvert/__stringMin1Max50
  (s/spec
    (s/and string? #(<= 1 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.mediaconvert/__stringPattern01D20305D205D
  (s/spec
    #(re-matches (re-pattern "^((([0-1]\\d)|(2[0-3]))(:[0-5]\\d){2}([:;][0-5]\\d))$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/NoiseFilterPostTemporalSharpening
  (s/spec string? :gen #(s/gen #{"DISABLED" "AUTO" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin1Max256
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.mediaconvert/ProresParControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/AutomatedAbrRule
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AutomatedAbrRule/MinTopRenditionSize
     :cognitect.aws.mediaconvert.AutomatedAbrRule/Type
     :cognitect.aws.mediaconvert.AutomatedAbrRule/ForceIncludeRenditions
     :cognitect.aws.mediaconvert.AutomatedAbrRule/MinBottomRenditionSize
     :cognitect.aws.mediaconvert.AutomatedAbrRule/AllowedRenditions]))

(s/def
  :cognitect.aws.mediaconvert/__stringMin14PatternS3XmlXMLHttpsXmlXML
  (s/spec
    #(re-matches
      (re-pattern
        "^((s3://(.*?)\\.(xml|XML))|(https?://(.*?)\\.(xml|XML)(\\?([^&=]+=[^&]+&)*[^&=]+=[^&]+)?))$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/PartnerWatermarking
  (s/keys :opt-un [:cognitect.aws.mediaconvert.PartnerWatermarking/NexguardFileMarkerSettings]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin32Max8192
  (s/spec (s/and int? #(<= 32 % 8192)) :gen #(gen/choose 32 8192)))

(s/def :cognitect.aws.mediaconvert/H264Syntax (s/spec string? :gen #(s/gen #{"RP2027" "DEFAULT"})))

(s/def
  :cognitect.aws.mediaconvert/AacAudioDescriptionBroadcasterMix
  (s/spec string? :gen #(s/gen #{"NORMAL" "BROADCASTER_MIXED_AD"})))

(s/def
  :cognitect.aws.mediaconvert/Rectangle
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Rectangle/Y
     :cognitect.aws.mediaconvert.Rectangle/Width
     :cognitect.aws.mediaconvert.Rectangle/Height
     :cognitect.aws.mediaconvert.Rectangle/X]))

(s/def
  :cognitect.aws.mediaconvert/MxfProfile
  (s/spec string? :gen #(s/gen #{"XAVC" "XDCAM" "OP1A" "XDCAM_RDD9" "D_10"})))

(s/def
  :cognitect.aws.mediaconvert/ListJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListJobsRequest/Order
     :cognitect.aws.mediaconvert.ListJobsRequest/Queue
     :cognitect.aws.mediaconvert.ListJobsRequest/Status
     :cognitect.aws.mediaconvert.ListJobsRequest/NextToken
     :cognitect.aws.mediaconvert.ListJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediaconvert/Xavc4kProfileQualityTuningLevel
  (s/spec string? :gen #(s/gen #{"MULTI_PASS_HQ" "SINGLE_PASS" "SINGLE_PASS_HQ"})))

(s/def
  :cognitect.aws.mediaconvert/TeletextDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.TeletextDestinationSettings/PageNumber
     :cognitect.aws.mediaconvert.TeletextDestinationSettings/PageTypes]))

(s/def
  :cognitect.aws.mediaconvert/EncryptionContractConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.EncryptionContractConfiguration/SpekeAudioPreset
     :cognitect.aws.mediaconvert.EncryptionContractConfiguration/SpekeVideoPreset]))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2IntraDcPrecision
  (s/spec
    string?
    :gen
    #(s/gen
      #{"INTRA_DC_PRECISION_10"
        "AUTO"
        "INTRA_DC_PRECISION_9"
        "INTRA_DC_PRECISION_11"
        "INTRA_DC_PRECISION_8"})))

(s/def
  :cognitect.aws.mediaconvert/AudioDefaultSelection
  (s/spec string? :gen #(s/gen #{"NOT_DEFAULT" "DEFAULT"})))

(s/def
  :cognitect.aws.mediaconvert/DashAdditionalManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DashAdditionalManifest/ManifestNameModifier
     :cognitect.aws.mediaconvert.DashAdditionalManifest/SelectedOutputs]))

(s/def
  :cognitect.aws.mediaconvert/MxfSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MxfSettings/AfdSignaling
     :cognitect.aws.mediaconvert.MxfSettings/Profile
     :cognitect.aws.mediaconvert.MxfSettings/XavcProfileSettings]))

(s/def
  :cognitect.aws.mediaconvert/__listOfWarningGroup
  (s/coll-of :cognitect.aws.mediaconvert/WarningGroup))

(s/def
  :cognitect.aws.mediaconvert/SearchJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.SearchJobsRequest/Order
     :cognitect.aws.mediaconvert.SearchJobsRequest/InputFile
     :cognitect.aws.mediaconvert.SearchJobsRequest/Queue
     :cognitect.aws.mediaconvert.SearchJobsRequest/Status
     :cognitect.aws.mediaconvert.SearchJobsRequest/NextToken
     :cognitect.aws.mediaconvert.SearchJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediaconvert/Av1SpatialAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/XavcAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"AUTO" "LOW" "MAX" "HIGHER" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.mediaconvert/TimecodeBurninPosition
  (s/spec
    string?
    :gen
    #(s/gen
      #{"TOP_CENTER"
        "MIDDLE_LEFT"
        "MIDDLE_CENTER"
        "MIDDLE_RIGHT"
        "BOTTOM_LEFT"
        "TOP_LEFT"
        "BOTTOM_CENTER"
        "TOP_RIGHT"
        "BOTTOM_RIGHT"})))

(s/def
  :cognitect.aws.mediaconvert/Ac3MetadataControl
  (s/spec string? :gen #(s/gen #{"FOLLOW_INPUT" "USE_CONFIGURED"})))

(s/def
  :cognitect.aws.mediaconvert/AudioSelectorType
  (s/spec string? :gen #(s/gen #{"LANGUAGE_CODE" "HLS_RENDITION_GROUP" "TRACK" "PID"})))

(s/def :cognitect.aws.mediaconvert/AacRateControlMode (s/spec string? :gen #(s/gen #{"VBR" "CBR"})))

(s/def
  :cognitect.aws.mediaconvert/M3u8DataPtsControl
  (s/spec string? :gen #(s/gen #{"AUTO" "ALIGN_TO_VIDEO"})))

(s/def
  :cognitect.aws.mediaconvert/MpdTimedMetadataBoxVersion
  (s/spec string? :gen #(s/gen #{"VERSION_0" "VERSION_1"})))

(s/def
  :cognitect.aws.mediaconvert/HlsSegmentLengthControl
  (s/spec string? :gen #(s/gen #{"EXACT" "GOP_MULTIPLE"})))

(s/def :cognitect.aws.mediaconvert/Mp3RateControlMode (s/spec string? :gen #(s/gen #{"VBR" "CBR"})))

(s/def
  :cognitect.aws.mediaconvert/HlsImageBasedTrickPlaySettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/IntervalCadence
     :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/ThumbnailInterval
     :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/ThumbnailWidth
     :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/TileWidth
     :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/TileHeight
     :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/ThumbnailHeight]))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosBitstreamMode
  (s/spec string? :gen #(s/gen #{"COMPLETE_MAIN"})))

(s/def
  :cognitect.aws.mediaconvert/VideoDetail
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoDetail/WidthInPx
     :cognitect.aws.mediaconvert.VideoDetail/HeightInPx]))

(s/def
  :cognitect.aws.mediaconvert/Hdr10Plus
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Hdr10Plus/MasteringMonitorNits
     :cognitect.aws.mediaconvert.Hdr10Plus/TargetMonitorNits]))

(s/def
  :cognitect.aws.mediaconvert/HlsProgramDateTime
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/NotFoundException
  (s/keys :opt-un [:cognitect.aws.mediaconvert.NotFoundException/Message]))

(s/def
  :cognitect.aws.mediaconvert/VideoOverlayUnit
  (s/spec string? :gen #(s/gen #{"PIXELS" "PERCENTAGE"})))

(s/def
  :cognitect.aws.mediaconvert/H265UnregisteredSeiTimecode
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/H264Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.H264Settings/RateControlMode
     :cognitect.aws.mediaconvert.H264Settings/UnregisteredSeiTimecode
     :cognitect.aws.mediaconvert.H264Settings/BandwidthReductionFilter
     :cognitect.aws.mediaconvert.H264Settings/InterlaceMode
     :cognitect.aws.mediaconvert.H264Settings/MinIInterval
     :cognitect.aws.mediaconvert.H264Settings/ParDenominator
     :cognitect.aws.mediaconvert.H264Settings/ScanTypeConversionMode
     :cognitect.aws.mediaconvert.H264Settings/GopBReference
     :cognitect.aws.mediaconvert.H264Settings/NumberReferenceFrames
     :cognitect.aws.mediaconvert.H264Settings/QualityTuningLevel
     :cognitect.aws.mediaconvert.H264Settings/RepeatPps
     :cognitect.aws.mediaconvert.H264Settings/AdaptiveQuantization
     :cognitect.aws.mediaconvert.H264Settings/FramerateDenominator
     :cognitect.aws.mediaconvert.H264Settings/HrdBufferFinalFillPercentage
     :cognitect.aws.mediaconvert.H264Settings/FramerateControl
     :cognitect.aws.mediaconvert.H264Settings/EndOfStreamMarkers
     :cognitect.aws.mediaconvert.H264Settings/HrdBufferSize
     :cognitect.aws.mediaconvert.H264Settings/SlowPal
     :cognitect.aws.mediaconvert.H264Settings/DynamicSubGop
     :cognitect.aws.mediaconvert.H264Settings/NumberBFramesBetweenReferenceFrames
     :cognitect.aws.mediaconvert.H264Settings/SaliencyAwareEncoding
     :cognitect.aws.mediaconvert.H264Settings/QvbrSettings
     :cognitect.aws.mediaconvert.H264Settings/FieldEncoding
     :cognitect.aws.mediaconvert.H264Settings/Syntax
     :cognitect.aws.mediaconvert.H264Settings/GopClosedCadence
     :cognitect.aws.mediaconvert.H264Settings/SpatialAdaptiveQuantization
     :cognitect.aws.mediaconvert.H264Settings/FramerateNumerator
     :cognitect.aws.mediaconvert.H264Settings/Softness
     :cognitect.aws.mediaconvert.H264Settings/GopSizeUnits
     :cognitect.aws.mediaconvert.H264Settings/MaxBitrate
     :cognitect.aws.mediaconvert.H264Settings/CodecProfile
     :cognitect.aws.mediaconvert.H264Settings/FlickerAdaptiveQuantization
     :cognitect.aws.mediaconvert.H264Settings/ParNumerator
     :cognitect.aws.mediaconvert.H264Settings/GopSize
     :cognitect.aws.mediaconvert.H264Settings/ParControl
     :cognitect.aws.mediaconvert.H264Settings/CodecLevel
     :cognitect.aws.mediaconvert.H264Settings/Telecine
     :cognitect.aws.mediaconvert.H264Settings/HrdBufferInitialFillPercentage
     :cognitect.aws.mediaconvert.H264Settings/Slices
     :cognitect.aws.mediaconvert.H264Settings/TemporalAdaptiveQuantization
     :cognitect.aws.mediaconvert.H264Settings/FramerateConversionAlgorithm
     :cognitect.aws.mediaconvert.H264Settings/EntropyEncoding
     :cognitect.aws.mediaconvert.H264Settings/SceneChangeDetect
     :cognitect.aws.mediaconvert.H264Settings/WriteMp4PackagingType
     :cognitect.aws.mediaconvert.H264Settings/Bitrate]))

(s/def
  :cognitect.aws.mediaconvert/Xavc4kIntraCbgProfileClass
  (s/spec string? :gen #(s/gen #{"CLASS_300" "CLASS_480" "CLASS_100"})))

(s/def
  :cognitect.aws.mediaconvert/__doubleMinNegative59Max0
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin1
  (s/spec
    (s/and string? #(<= 1 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative1000Max1000
  (s/spec (s/and int? #(<= -1000 % 1000)) :gen #(gen/choose -1000 1000)))

(s/def
  :cognitect.aws.mediaconvert/VideoCodecSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoCodecSettings/Vc3Settings
     :cognitect.aws.mediaconvert.VideoCodecSettings/Av1Settings
     :cognitect.aws.mediaconvert.VideoCodecSettings/Codec
     :cognitect.aws.mediaconvert.VideoCodecSettings/GifSettings
     :cognitect.aws.mediaconvert.VideoCodecSettings/AvcIntraSettings
     :cognitect.aws.mediaconvert.VideoCodecSettings/UncompressedSettings
     :cognitect.aws.mediaconvert.VideoCodecSettings/Vp8Settings
     :cognitect.aws.mediaconvert.VideoCodecSettings/Vp9Settings
     :cognitect.aws.mediaconvert.VideoCodecSettings/H265Settings
     :cognitect.aws.mediaconvert.VideoCodecSettings/XavcSettings
     :cognitect.aws.mediaconvert.VideoCodecSettings/FrameCaptureSettings
     :cognitect.aws.mediaconvert.VideoCodecSettings/Mpeg2Settings
     :cognitect.aws.mediaconvert.VideoCodecSettings/H264Settings
     :cognitect.aws.mediaconvert.VideoCodecSettings/ProresSettings]))

(s/def
  :cognitect.aws.mediaconvert/M2tsBufferModel
  (s/spec string? :gen #(s/gen #{"NONE" "MULTIPLEX"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Eac3Settings/LtRtSurroundMixLevel
     :cognitect.aws.mediaconvert.Eac3Settings/CodingMode
     :cognitect.aws.mediaconvert.Eac3Settings/PhaseControl
     :cognitect.aws.mediaconvert.Eac3Settings/SampleRate
     :cognitect.aws.mediaconvert.Eac3Settings/PassthroughControl
     :cognitect.aws.mediaconvert.Eac3Settings/DynamicRangeCompressionLine
     :cognitect.aws.mediaconvert.Eac3Settings/SurroundMode
     :cognitect.aws.mediaconvert.Eac3Settings/AttenuationControl
     :cognitect.aws.mediaconvert.Eac3Settings/DcFilter
     :cognitect.aws.mediaconvert.Eac3Settings/LfeFilter
     :cognitect.aws.mediaconvert.Eac3Settings/LfeControl
     :cognitect.aws.mediaconvert.Eac3Settings/LoRoCenterMixLevel
     :cognitect.aws.mediaconvert.Eac3Settings/StereoDownmix
     :cognitect.aws.mediaconvert.Eac3Settings/LtRtCenterMixLevel
     :cognitect.aws.mediaconvert.Eac3Settings/SurroundExMode
     :cognitect.aws.mediaconvert.Eac3Settings/MetadataControl
     :cognitect.aws.mediaconvert.Eac3Settings/LoRoSurroundMixLevel
     :cognitect.aws.mediaconvert.Eac3Settings/BitstreamMode
     :cognitect.aws.mediaconvert.Eac3Settings/Dialnorm
     :cognitect.aws.mediaconvert.Eac3Settings/DynamicRangeCompressionRf
     :cognitect.aws.mediaconvert.Eac3Settings/Bitrate]))

(s/def
  :cognitect.aws.mediaconvert/Ac3CodingMode
  (s/spec
    string?
    :gen
    #(s/gen #{"CODING_MODE_1_0" "CODING_MODE_3_2_LFE" "CODING_MODE_1_1" "CODING_MODE_2_0"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin22050Max48000
  (s/spec (s/and int? #(<= 22050 % 48000)) :gen #(gen/choose 22050 48000)))

(s/def
  :cognitect.aws.mediaconvert/NielsenUniqueTicPerAudioTrackType
  (s/spec string? :gen #(s/gen #{"RESERVE_UNIQUE_TICS_PER_TRACK" "SAME_TICS_PER_TRACK"})))

(s/def
  :cognitect.aws.mediaconvert/UncompressedInterlaceMode
  (s/spec string? :gen #(s/gen #{"PROGRESSIVE" "INTERLACED"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin10Max48
  (s/spec (s/and int? #(<= 10 % 48)) :gen #(gen/choose 10 48)))

(s/def
  :cognitect.aws.mediaconvert/SpekeKeyProviderCmaf
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/DashSignaledSystemIds
     :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/ResourceId
     :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/EncryptionContractConfiguration
     :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/HlsSignaledSystemIds
     :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/Url
     :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/CertificateArn]))

(s/def
  :cognitect.aws.mediaconvert/HlsManifestDurationFormat
  (s/spec string? :gen #(s/gen #{"FLOATING_POINT" "INTEGER"})))

(s/def
  :cognitect.aws.mediaconvert/DashIsoSegmentControl
  (s/spec string? :gen #(s/gen #{"SINGLE_FILE" "SEGMENTED_FILES"})))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2InterlaceMode
  (s/spec
    string?
    :gen
    #(s/gen #{"BOTTOM_FIELD" "FOLLOW_TOP_FIELD" "PROGRESSIVE" "FOLLOW_BOTTOM_FIELD" "TOP_FIELD"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max64
  (s/spec (s/and int? #(<= 1 % 64)) :gen #(gen/choose 1 64)))

(s/def
  :cognitect.aws.mediaconvert/M3u8Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.M3u8Settings/PatInterval
     :cognitect.aws.mediaconvert.M3u8Settings/Scte35Source
     :cognitect.aws.mediaconvert.M3u8Settings/PtsOffsetMode
     :cognitect.aws.mediaconvert.M3u8Settings/AudioFramesPerPes
     :cognitect.aws.mediaconvert.M3u8Settings/TransportStreamId
     :cognitect.aws.mediaconvert.M3u8Settings/PcrControl
     :cognitect.aws.mediaconvert.M3u8Settings/Scte35Pid
     :cognitect.aws.mediaconvert.M3u8Settings/ProgramNumber
     :cognitect.aws.mediaconvert.M3u8Settings/PcrPid
     :cognitect.aws.mediaconvert.M3u8Settings/PmtPid
     :cognitect.aws.mediaconvert.M3u8Settings/VideoPid
     :cognitect.aws.mediaconvert.M3u8Settings/PtsOffset
     :cognitect.aws.mediaconvert.M3u8Settings/AudioPids
     :cognitect.aws.mediaconvert.M3u8Settings/TimedMetadata
     :cognitect.aws.mediaconvert.M3u8Settings/NielsenId3
     :cognitect.aws.mediaconvert.M3u8Settings/MaxPcrInterval
     :cognitect.aws.mediaconvert.M3u8Settings/PmtInterval
     :cognitect.aws.mediaconvert.M3u8Settings/TimedMetadataPid
     :cognitect.aws.mediaconvert.M3u8Settings/AudioDuration
     :cognitect.aws.mediaconvert.M3u8Settings/DataPTSControl
     :cognitect.aws.mediaconvert.M3u8Settings/PrivateMetadataPid]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max47185920
  (s/spec (s/and int? #(<= 0 % 47185920)) :gen #(gen/choose 0 47185920)))

(s/def
  :cognitect.aws.mediaconvert/RespondToAfd
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE" "RESPOND"})))

(s/def
  :cognitect.aws.mediaconvert/QueueListBy
  (s/spec string? :gen #(s/gen #{"CREATION_DATE" "NAME"})))

(s/def
  :cognitect.aws.mediaconvert/H264RateControlMode
  (s/spec string? :gen #(s/gen #{"VBR" "CBR" "QVBR"})))

(s/def :cognitect.aws.mediaconvert/DeleteJobTemplateResponse (s/keys))

(s/def
  :cognitect.aws.mediaconvert/__listOfJobTemplate
  (s/coll-of :cognitect.aws.mediaconvert/JobTemplate))

(s/def
  :cognitect.aws.mediaconvert/BurninSubtitleFontColor
  (s/spec string? :gen #(s/gen #{"AUTO" "HEX" "GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})))

(s/def :cognitect.aws.mediaconvert/__listOfOutput (s/coll-of :cognitect.aws.mediaconvert/Output))

(s/def
  :cognitect.aws.mediaconvert/ImscAccessibilitySubs
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin1Max20
  (s/spec
    (s/and string? #(<= 1 (count %) 20))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 20) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.mediaconvert/H265TemporalIds
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12
  (s/spec
    #(re-matches
      (re-pattern "^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2FramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max4
  (s/spec (s/and int? #(<= 0 % 4)) :gen #(gen/choose 0 4)))

(s/def
  :cognitect.aws.mediaconvert/H265InterlaceMode
  (s/spec
    string?
    :gen
    #(s/gen #{"BOTTOM_FIELD" "FOLLOW_TOP_FIELD" "PROGRESSIVE" "FOLLOW_BOTTOM_FIELD" "TOP_FIELD"})))

(s/def
  :cognitect.aws.mediaconvert/H264GopSizeUnits
  (s/spec string? :gen #(s/gen #{"SECONDS" "AUTO" "FRAMES"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max10000000
  (s/spec (s/and int? #(<= 1 % 10000000)) :gen #(gen/choose 1 10000000)))

(s/def
  :cognitect.aws.mediaconvert/ColorMetadata
  (s/spec string? :gen #(s/gen #{"INSERT" "IGNORE"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMax256
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.mediaconvert/NielsenSourceWatermarkStatusType
  (s/spec string? :gen #(s/gen #{"WATERMARKED" "CLEAN"})))

(s/def
  :cognitect.aws.mediaconvert/HlsSegmentControl
  (s/spec string? :gen #(s/gen #{"SINGLE_FILE" "SEGMENTED_FILES"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosDynamicRangeCompressionLine
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def
  :cognitect.aws.mediaconvert/JobTemplateListBy
  (s/spec string? :gen #(s/gen #{"SYSTEM" "CREATION_DATE" "NAME"})))

(s/def
  :cognitect.aws.mediaconvert/GifSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.GifSettings/FramerateDenominator
     :cognitect.aws.mediaconvert.GifSettings/FramerateControl
     :cognitect.aws.mediaconvert.GifSettings/FramerateNumerator
     :cognitect.aws.mediaconvert.GifSettings/FramerateConversionAlgorithm]))

(s/def
  :cognitect.aws.mediaconvert/SampleRangeConversion
  (s/spec string? :gen #(s/gen #{"NONE" "LIMITED_RANGE_CLIP" "LIMITED_RANGE_SQUEEZE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max16
  (s/spec (s/and int? #(<= 0 % 16)) :gen #(gen/choose 0 16)))

(s/def
  :cognitect.aws.mediaconvert/H264Telecine
  (s/spec string? :gen #(s/gen #{"SOFT" "HARD" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/CmafManifestCompression
  (s/spec string? :gen #(s/gen #{"GZIP" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max17895697
  (s/spec (s/and int? #(<= 1 % 17895697)) :gen #(gen/choose 1 17895697)))

(s/def
  :cognitect.aws.mediaconvert/H265SampleAdaptiveOffsetFilterMode
  (s/spec string? :gen #(s/gen #{"ADAPTIVE" "DEFAULT" "OFF"})))

(s/def
  :cognitect.aws.mediaconvert/M2tsEbpAudioInterval
  (s/spec string? :gen #(s/gen #{"VIDEO_AND_FIXED_INTERVALS" "VIDEO_INTERVAL"})))

(s/def
  :cognitect.aws.mediaconvert/H265AlternateTransferFunctionSei
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__listOf__integerMin1Max2147483647
  (s/coll-of :cognitect.aws.mediaconvert/__integerMin1Max2147483647))

(s/def
  :cognitect.aws.mediaconvert/M2tsEsRateInPes
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/AacCodecProfile
  (s/spec string? :gen #(s/gen #{"LC" "HEV2" "HEV1"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfColorConversion3DLUTSetting
  (s/coll-of :cognitect.aws.mediaconvert/ColorConversion3DLUTSetting))

(s/def
  :cognitect.aws.mediaconvert/H265GopBReference
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative50Max50
  (s/spec (s/and int? #(<= -50 % 50)) :gen #(gen/choose -50 50)))

(s/def
  :cognitect.aws.mediaconvert/Ac3DynamicRangeCompressionRf
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin16000Max320000
  (s/spec (s/and int? #(<= 16000 % 320000)) :gen #(gen/choose 16000 320000)))

(s/def
  :cognitect.aws.mediaconvert/WebvttDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.WebvttDestinationSettings/Accessibility
     :cognitect.aws.mediaconvert.WebvttDestinationSettings/StylePassthrough]))

(s/def
  :cognitect.aws.mediaconvert/Mp4MoovPlacement
  (s/spec string? :gen #(s/gen #{"NORMAL" "PROGRESSIVE_DOWNLOAD"})))

(s/def
  :cognitect.aws.mediaconvert/GifFramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/XavcHdProfileSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.XavcHdProfileSettings/InterlaceMode
     :cognitect.aws.mediaconvert.XavcHdProfileSettings/GopBReference
     :cognitect.aws.mediaconvert.XavcHdProfileSettings/QualityTuningLevel
     :cognitect.aws.mediaconvert.XavcHdProfileSettings/HrdBufferSize
     :cognitect.aws.mediaconvert.XavcHdProfileSettings/BitrateClass
     :cognitect.aws.mediaconvert.XavcHdProfileSettings/GopClosedCadence
     :cognitect.aws.mediaconvert.XavcHdProfileSettings/FlickerAdaptiveQuantization
     :cognitect.aws.mediaconvert.XavcHdProfileSettings/Telecine
     :cognitect.aws.mediaconvert.XavcHdProfileSettings/Slices]))

(s/def
  :cognitect.aws.mediaconvert/ExtendedDataServices
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ExtendedDataServices/CopyProtectionAction
     :cognitect.aws.mediaconvert.ExtendedDataServices/VchipAction]))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternS3ASSETMAPXml
  (s/spec #(re-matches (re-pattern "^s3:\\/\\/.*\\/(ASSETMAP.xml)?$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max0
  (s/spec (s/and int? #(<= 0 % 0)) :gen #(gen/choose 0 0)))

(s/def
  :cognitect.aws.mediaconvert/ColorCorrector
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ColorCorrector/ClipLimits
     :cognitect.aws.mediaconvert.ColorCorrector/MaxLuminance
     :cognitect.aws.mediaconvert.ColorCorrector/Saturation
     :cognitect.aws.mediaconvert.ColorCorrector/Contrast
     :cognitect.aws.mediaconvert.ColorCorrector/Hdr10Metadata
     :cognitect.aws.mediaconvert.ColorCorrector/SdrReferenceWhiteLevel
     :cognitect.aws.mediaconvert.ColorCorrector/HdrToSdrToneMapper
     :cognitect.aws.mediaconvert.ColorCorrector/SampleRangeConversion
     :cognitect.aws.mediaconvert.ColorCorrector/Brightness
     :cognitect.aws.mediaconvert.ColorCorrector/Hue
     :cognitect.aws.mediaconvert.ColorCorrector/ColorSpaceConversion]))

(s/def
  :cognitect.aws.mediaconvert/AvcIntraFramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfCaptionDescription
  (s/coll-of :cognitect.aws.mediaconvert/CaptionDescription))

(s/def
  :cognitect.aws.mediaconvert/AncillaryTerminateCaptions
  (s/spec string? :gen #(s/gen #{"DISABLED" "END_OF_INPUT"})))

(s/def
  :cognitect.aws.mediaconvert/ReservationPlanStatus
  (s/spec string? :gen #(s/gen #{"EXPIRED" "ACTIVE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max2048
  (s/spec (s/and int? #(<= 1 % 2048)) :gen #(gen/choose 1 2048)))

(s/def
  :cognitect.aws.mediaconvert/HlsIFrameOnlyManifest
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/__listOf__stringPatternS3ASSETMAPXml
  (s/coll-of :cognitect.aws.mediaconvert/__stringPatternS3ASSETMAPXml))

(s/def
  :cognitect.aws.mediaconvert/Eac3PhaseControl
  (s/spec string? :gen #(s/gen #{"SHIFT_90_DEGREES" "NO_SHIFT"})))

(s/def
  :cognitect.aws.mediaconvert/JobTemplateSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.JobTemplateSettings/Esam
     :cognitect.aws.mediaconvert.JobTemplateSettings/KantarWatermark
     :cognitect.aws.mediaconvert.JobTemplateSettings/NielsenNonLinearWatermark
     :cognitect.aws.mediaconvert.JobTemplateSettings/ExtendedDataServices
     :cognitect.aws.mediaconvert.JobTemplateSettings/Inputs
     :cognitect.aws.mediaconvert.JobTemplateSettings/TimedMetadataInsertion
     :cognitect.aws.mediaconvert.JobTemplateSettings/MotionImageInserter
     :cognitect.aws.mediaconvert.JobTemplateSettings/FollowSource
     :cognitect.aws.mediaconvert.JobTemplateSettings/ColorConversion3DLUTSettings
     :cognitect.aws.mediaconvert.JobTemplateSettings/TimecodeConfig
     :cognitect.aws.mediaconvert.JobTemplateSettings/AdAvailOffset
     :cognitect.aws.mediaconvert.JobTemplateSettings/OutputGroups
     :cognitect.aws.mediaconvert.JobTemplateSettings/NielsenConfiguration
     :cognitect.aws.mediaconvert.JobTemplateSettings/AvailBlanking]))

(s/def
  :cognitect.aws.mediaconvert/SearchJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.SearchJobsResponse/NextToken
     :cognitect.aws.mediaconvert.SearchJobsResponse/Jobs]))

(s/def
  :cognitect.aws.mediaconvert/CmfcKlvMetadata
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1000Max1152000000
  (s/spec (s/and int? #(<= 1000 % 1152000000)) :gen #(gen/choose 1000 1152000000)))

(s/def
  :cognitect.aws.mediaconvert/Vp9FramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def
  :cognitect.aws.mediaconvert/DynamicAudioSelector
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DynamicAudioSelector/Offset
     :cognitect.aws.mediaconvert.DynamicAudioSelector/AudioDurationCorrection
     :cognitect.aws.mediaconvert.DynamicAudioSelector/LanguageCode
     :cognitect.aws.mediaconvert.DynamicAudioSelector/ExternalAudioFileInput
     :cognitect.aws.mediaconvert.DynamicAudioSelector/SelectorType]))

(s/def
  :cognitect.aws.mediaconvert/__listOfHopDestination
  (s/coll-of :cognitect.aws.mediaconvert/HopDestination))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2DynamicSubGop
  (s/spec string? :gen #(s/gen #{"ADAPTIVE" "STATIC"})))

(s/def
  :cognitect.aws.mediaconvert/Ac3DynamicRangeCompressionProfile
  (s/spec string? :gen #(s/gen #{"FILM_STANDARD" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfOutputGroup
  (s/coll-of :cognitect.aws.mediaconvert/OutputGroup))

(s/def
  :cognitect.aws.mediaconvert/__doubleMinNegative6Max3
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max50000
  (s/spec (s/and int? #(<= 0 % 50000)) :gen #(gen/choose 0 50000)))

(s/def
  :cognitect.aws.mediaconvert/CaptionDestinationType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"EMBEDDED_PLUS_SCTE20"
        "SCC"
        "SRT"
        "SCTE20_PLUS_EMBEDDED"
        "TELETEXT"
        "DVB_SUB"
        "SMI"
        "BURN_IN"
        "WEBVTT"
        "EMBEDDED"
        "TTML"
        "IMSC"})))

(s/def
  :cognitect.aws.mediaconvert/CreateQueueResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.CreateQueueResponse/Queue]))

(s/def
  :cognitect.aws.mediaconvert/MsSmoothEncryptionSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.MsSmoothEncryptionSettings/SpekeKeyProvider]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin24Max60000
  (s/spec (s/and int? #(<= 24 % 60000)) :gen #(gen/choose 24 60000)))

(s/def
  :cognitect.aws.mediaconvert/__listOfJobEngineVersion
  (s/coll-of :cognitect.aws.mediaconvert/JobEngineVersion))

(s/def
  :cognitect.aws.mediaconvert/AllowedRenditionSize
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AllowedRenditionSize/Width
     :cognitect.aws.mediaconvert.AllowedRenditionSize/Required
     :cognitect.aws.mediaconvert.AllowedRenditionSize/Height]))

(s/def
  :cognitect.aws.mediaconvert/H265ScanTypeConversionMode
  (s/spec string? :gen #(s/gen #{"INTERLACED_OPTIMIZE" "INTERLACED"})))

(s/def :cognitect.aws.mediaconvert/DeletePolicyResponse (s/keys))

(s/def
  :cognitect.aws.mediaconvert/UncompressedFramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def
  :cognitect.aws.mediaconvert/MxfAfdSignaling
  (s/spec string? :gen #(s/gen #{"NO_COPY" "COPY_FROM_VIDEO"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max1
  (s/spec (s/and int? #(<= 1 % 1)) :gen #(gen/choose 1 1)))

(s/def
  :cognitect.aws.mediaconvert/AutomatedAbrSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AutomatedAbrSettings/MaxRenditions
     :cognitect.aws.mediaconvert.AutomatedAbrSettings/MaxAbrBitrate
     :cognitect.aws.mediaconvert.AutomatedAbrSettings/MinAbrBitrate
     :cognitect.aws.mediaconvert.AutomatedAbrSettings/Rules]))

(s/def
  :cognitect.aws.mediaconvert/Vc3Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Vc3Settings/InterlaceMode
     :cognitect.aws.mediaconvert.Vc3Settings/ScanTypeConversionMode
     :cognitect.aws.mediaconvert.Vc3Settings/FramerateDenominator
     :cognitect.aws.mediaconvert.Vc3Settings/Vc3Class
     :cognitect.aws.mediaconvert.Vc3Settings/FramerateControl
     :cognitect.aws.mediaconvert.Vc3Settings/SlowPal
     :cognitect.aws.mediaconvert.Vc3Settings/FramerateNumerator
     :cognitect.aws.mediaconvert.Vc3Settings/Telecine
     :cognitect.aws.mediaconvert.Vc3Settings/FramerateConversionAlgorithm]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max3
  (s/spec (s/and int? #(<= 0 % 3)) :gen #(gen/choose 0 3)))

(s/def
  :cognitect.aws.mediaconvert/UncompressedSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.UncompressedSettings/InterlaceMode
     :cognitect.aws.mediaconvert.UncompressedSettings/ScanTypeConversionMode
     :cognitect.aws.mediaconvert.UncompressedSettings/FramerateDenominator
     :cognitect.aws.mediaconvert.UncompressedSettings/FramerateControl
     :cognitect.aws.mediaconvert.UncompressedSettings/SlowPal
     :cognitect.aws.mediaconvert.UncompressedSettings/Fourcc
     :cognitect.aws.mediaconvert.UncompressedSettings/FramerateNumerator
     :cognitect.aws.mediaconvert.UncompressedSettings/Telecine
     :cognitect.aws.mediaconvert.UncompressedSettings/FramerateConversionAlgorithm]))

(s/def
  :cognitect.aws.mediaconvert/Vp8QualityTuningLevel
  (s/spec string? :gen #(s/gen #{"MULTI_PASS_HQ" "MULTI_PASS"})))

(s/def
  :cognitect.aws.mediaconvert/MpdAudioDuration
  (s/spec string? :gen #(s/gen #{"DEFAULT_CODEC_DURATION" "MATCH_VIDEO_DURATION"})))

(s/def
  :cognitect.aws.mediaconvert/AacSpecification
  (s/spec string? :gen #(s/gen #{"MPEG4" "MPEG2"})))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2CodecLevel
  (s/spec string? :gen #(s/gen #{"HIGH1440" "AUTO" "LOW" "MAIN" "HIGH"})))

(s/def
  :cognitect.aws.mediaconvert/CmfcSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CmfcSettings/Scte35Source
     :cognitect.aws.mediaconvert.CmfcSettings/AudioTrackType
     :cognitect.aws.mediaconvert.CmfcSettings/TimedMetadataValue
     :cognitect.aws.mediaconvert.CmfcSettings/TimedMetadata
     :cognitect.aws.mediaconvert.CmfcSettings/IFrameOnlyManifest
     :cognitect.aws.mediaconvert.CmfcSettings/DescriptiveVideoServiceFlag
     :cognitect.aws.mediaconvert.CmfcSettings/TimedMetadataSchemeIdUri
     :cognitect.aws.mediaconvert.CmfcSettings/KlvMetadata
     :cognitect.aws.mediaconvert.CmfcSettings/AudioDuration
     :cognitect.aws.mediaconvert.CmfcSettings/AudioGroupId
     :cognitect.aws.mediaconvert.CmfcSettings/Scte35Esam
     :cognitect.aws.mediaconvert.CmfcSettings/TimedMetadataBoxVersion
     :cognitect.aws.mediaconvert.CmfcSettings/AudioRenditionSets
     :cognitect.aws.mediaconvert.CmfcSettings/ManifestMetadataSignaling]))

(s/def
  :cognitect.aws.mediaconvert/CaptionDescription
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CaptionDescription/CustomLanguageCode
     :cognitect.aws.mediaconvert.CaptionDescription/DestinationSettings
     :cognitect.aws.mediaconvert.CaptionDescription/LanguageCode
     :cognitect.aws.mediaconvert.CaptionDescription/CaptionSelectorName
     :cognitect.aws.mediaconvert.CaptionDescription/LanguageDescription]))

(s/def
  :cognitect.aws.mediaconvert/VideoTimecodeInsertion
  (s/spec string? :gen #(s/gen #{"DISABLED" "PIC_TIMING_SEI"})))

(s/def
  :cognitect.aws.mediaconvert/BandwidthReductionFilterSharpening
  (s/spec string? :gen #(s/gen #{"LOW" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.mediaconvert/M3u8Scte35Source
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/ImscDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ImscDestinationSettings/Accessibility
     :cognitect.aws.mediaconvert.ImscDestinationSettings/StylePassthrough]))

(s/def
  :cognitect.aws.mediaconvert/Queue
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.Queue/Name]
    :opt-un
    [:cognitect.aws.mediaconvert.Queue/ReservationPlan
     :cognitect.aws.mediaconvert.Queue/Type
     :cognitect.aws.mediaconvert.Queue/SubmittedJobsCount
     :cognitect.aws.mediaconvert.Queue/PricingPlan
     :cognitect.aws.mediaconvert.Queue/Status
     :cognitect.aws.mediaconvert.Queue/ProgressingJobsCount
     :cognitect.aws.mediaconvert.Queue/Description
     :cognitect.aws.mediaconvert.Queue/ConcurrentJobs
     :cognitect.aws.mediaconvert.Queue/Arn
     :cognitect.aws.mediaconvert.Queue/CreatedAt
     :cognitect.aws.mediaconvert.Queue/ServiceOverrides
     :cognitect.aws.mediaconvert.Queue/LastUpdated]))

(s/def
  :cognitect.aws.mediaconvert/UpdateQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.UpdateQueueRequest/Name]
    :opt-un
    [:cognitect.aws.mediaconvert.UpdateQueueRequest/Status
     :cognitect.aws.mediaconvert.UpdateQueueRequest/Description
     :cognitect.aws.mediaconvert.UpdateQueueRequest/ConcurrentJobs
     :cognitect.aws.mediaconvert.UpdateQueueRequest/ReservationPlanSettings]))

(s/def
  :cognitect.aws.mediaconvert/DashIsoEncryptionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DashIsoEncryptionSettings/SpekeKeyProvider
     :cognitect.aws.mediaconvert.DashIsoEncryptionSettings/PlaybackDeviceCompatibility]))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternAZaZ0902
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9+\\/]+={0,2}$") %) :gen #(gen/string)))

(s/def :cognitect.aws.mediaconvert/CancelJobResponse (s/keys))

(s/def
  :cognitect.aws.mediaconvert/Eac3LfeFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/XavcHdProfileQualityTuningLevel
  (s/spec string? :gen #(s/gen #{"MULTI_PASS_HQ" "SINGLE_PASS" "SINGLE_PASS_HQ"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max7
  (s/spec (s/and int? #(<= 0 % 7)) :gen #(gen/choose 0 7)))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative2Max3
  (s/spec (s/and int? #(<= -2 % 3)) :gen #(gen/choose -2 3)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max512
  (s/spec (s/and int? #(<= 1 % 512)) :gen #(gen/choose 1 512)))

(s/def
  :cognitect.aws.mediaconvert/CaptionSelector
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CaptionSelector/CustomLanguageCode
     :cognitect.aws.mediaconvert.CaptionSelector/LanguageCode
     :cognitect.aws.mediaconvert.CaptionSelector/SourceSettings]))

(s/def
  :cognitect.aws.mediaconvert/DolbyVisionLevel6Mode
  (s/spec string? :gen #(s/gen #{"SPECIFY" "RECALCULATE" "PASSTHROUGH"})))

(s/def
  :cognitect.aws.mediaconvert/DeinterlacerControl
  (s/spec string? :gen #(s/gen #{"NORMAL" "FORCE_ALL_FRAMES"})))

(s/def
  :cognitect.aws.mediaconvert/S3DestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.S3DestinationSettings/AccessControl
     :cognitect.aws.mediaconvert.S3DestinationSettings/Encryption
     :cognitect.aws.mediaconvert.S3DestinationSettings/StorageClass]))

(s/def
  :cognitect.aws.mediaconvert/TeletextSourceSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.TeletextSourceSettings/PageNumber]))

(s/def
  :cognitect.aws.mediaconvert/AudioNormalizationAlgorithm
  (s/spec string? :gen #(s/gen #{"ITU_BS_1770_1" "ITU_BS_1770_2" "ITU_BS_1770_4" "ITU_BS_1770_3"})))

(s/def
  :cognitect.aws.mediaconvert/Xavc4kIntraVbrProfileClass
  (s/spec string? :gen #(s/gen #{"CLASS_300" "CLASS_480" "CLASS_100"})))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2RateControlMode
  (s/spec string? :gen #(s/gen #{"VBR" "CBR"})))

(s/def
  :cognitect.aws.mediaconvert/AudioChannelTaggingSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AudioChannelTaggingSettings/ChannelTag
     :cognitect.aws.mediaconvert.AudioChannelTaggingSettings/ChannelTags]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin16Max24
  (s/spec (s/and int? #(<= 16 % 24)) :gen #(gen/choose 16 24)))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2ParControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/XavcInterlaceMode
  (s/spec
    string?
    :gen
    #(s/gen #{"BOTTOM_FIELD" "FOLLOW_TOP_FIELD" "PROGRESSIVE" "FOLLOW_BOTTOM_FIELD" "TOP_FIELD"})))

(s/def
  :cognitect.aws.mediaconvert/RemixSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.RemixSettings/AudioDescriptionDataChannel
     :cognitect.aws.mediaconvert.RemixSettings/AudioDescriptionAudioChannel
     :cognitect.aws.mediaconvert.RemixSettings/ChannelMapping
     :cognitect.aws.mediaconvert.RemixSettings/ChannelsOut
     :cognitect.aws.mediaconvert.RemixSettings/ChannelsIn]))

(s/def
  :cognitect.aws.mediaconvert/EsamSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.EsamSettings/ManifestConfirmConditionNotification
     :cognitect.aws.mediaconvert.EsamSettings/SignalProcessingNotification
     :cognitect.aws.mediaconvert.EsamSettings/ResponseSignalPreroll]))

(s/def
  :cognitect.aws.mediaconvert/H264RepeatPps
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def :cognitect.aws.mediaconvert/__string string?)

(s/def
  :cognitect.aws.mediaconvert/__integerMin90Max105
  (s/spec (s/and int? #(<= 90 % 105)) :gen #(gen/choose 90 105)))

(s/def
  :cognitect.aws.mediaconvert/Xavc4kProfileSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Xavc4kProfileSettings/GopBReference
     :cognitect.aws.mediaconvert.Xavc4kProfileSettings/QualityTuningLevel
     :cognitect.aws.mediaconvert.Xavc4kProfileSettings/HrdBufferSize
     :cognitect.aws.mediaconvert.Xavc4kProfileSettings/BitrateClass
     :cognitect.aws.mediaconvert.Xavc4kProfileSettings/GopClosedCadence
     :cognitect.aws.mediaconvert.Xavc4kProfileSettings/CodecProfile
     :cognitect.aws.mediaconvert.Xavc4kProfileSettings/FlickerAdaptiveQuantization
     :cognitect.aws.mediaconvert.Xavc4kProfileSettings/Slices]))

(s/def
  :cognitect.aws.mediaconvert/FrameCaptureSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.FrameCaptureSettings/MaxCaptures
     :cognitect.aws.mediaconvert.FrameCaptureSettings/FramerateDenominator
     :cognitect.aws.mediaconvert.FrameCaptureSettings/Quality
     :cognitect.aws.mediaconvert.FrameCaptureSettings/FramerateNumerator]))

(s/def
  :cognitect.aws.mediaconvert/H264WriteMp4PackagingType
  (s/spec string? :gen #(s/gen #{"AVC1" "AVC3"})))

(s/def
  :cognitect.aws.mediaconvert/HlsKeyProviderType
  (s/spec string? :gen #(s/gen #{"SPEKE" "STATIC_KEY"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max1152000000
  (s/spec (s/and int? #(<= 0 % 1152000000)) :gen #(gen/choose 0 1152000000)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin50Max86400000
  (s/spec (s/and int? #(<= 50 % 86400000)) :gen #(gen/choose 50 86400000)))

(s/def
  :cognitect.aws.mediaconvert/CaptionSourceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"SCC"
        "STL"
        "SRT"
        "TELETEXT"
        "DVB_SUB"
        "SMI"
        "WEBVTT"
        "SCTE20"
        "EMBEDDED"
        "TTML"
        "SMPTE_TT"
        "NULL_SOURCE"
        "IMSC"
        "ANCILLARY"})))

(s/def
  :cognitect.aws.mediaconvert/XavcProfile
  (s/spec
    string?
    :gen
    #(s/gen #{"XAVC_4K" "XAVC_HD_INTRA_CBG" "XAVC_HD" "XAVC_4K_INTRA_VBR" "XAVC_4K_INTRA_CBG"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternHttpsD
  (s/spec
    #(re-matches (re-pattern "^https:\\/\\/[^:@\\/]*(:\\d*)?(\\/.*)?$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/MovPaddingControl
  (s/spec string? :gen #(s/gen #{"OMNEON" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/OutputGroupDetail
  (s/keys :opt-un [:cognitect.aws.mediaconvert.OutputGroupDetail/OutputDetails]))

(s/def
  :cognitect.aws.mediaconvert/MpdScte35Source
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/PresetSpeke20Video
  (s/spec
    string?
    :gen
    #(s/gen
      #{"PRESET_VIDEO_5"
        "PRESET_VIDEO_6"
        "PRESET_VIDEO_4"
        "PRESET_VIDEO_1"
        "UNENCRYPTED"
        "PRESET_VIDEO_8"
        "PRESET_VIDEO_2"
        "PRESET_VIDEO_7"
        "SHARED"
        "PRESET_VIDEO_3"})))

(s/def
  :cognitect.aws.mediaconvert/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.ListTagsForResourceRequest/Arn]))

(s/def
  :cognitect.aws.mediaconvert/H265SceneChangeDetect
  (s/spec string? :gen #(s/gen #{"DISABLED" "TRANSITION_DETECTION" "ENABLED"})))

(s/def :cognitect.aws.mediaconvert/AntiAlias (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/H264AdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"AUTO" "LOW" "MAX" "HIGHER" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.mediaconvert/XavcFramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def
  :cognitect.aws.mediaconvert/MsSmoothManifestEncoding
  (s/spec string? :gen #(s/gen #{"UTF16" "UTF8"})))

(s/def
  :cognitect.aws.mediaconvert/VchipAction
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "STRIP"})))

(s/def :cognitect.aws.mediaconvert/CmfcScte35Esam (s/spec string? :gen #(s/gen #{"INSERT" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfHlsAdditionalManifest
  (s/coll-of :cognitect.aws.mediaconvert/HlsAdditionalManifest))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternW
  (s/spec #(re-matches (re-pattern "^[\\w-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max1001
  (s/spec (s/and int? #(<= 1 % 1001)) :gen #(gen/choose 1 1001)))

(s/def
  :cognitect.aws.mediaconvert/DisassociateCertificateRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.DisassociateCertificateRequest/Arn]))

(s/def
  :cognitect.aws.mediaconvert/__mapOfAudioSelectorGroup
  (s/map-of :cognitect.aws.mediaconvert/__string :cognitect.aws.mediaconvert/AudioSelectorGroup))

(s/def
  :cognitect.aws.mediaconvert/CmafEncryptionType
  (s/spec string? :gen #(s/gen #{"SAMPLE_AES" "AES_CTR"})))

(s/def
  :cognitect.aws.mediaconvert/EmbeddedTimecodeOverride
  (s/spec string? :gen #(s/gen #{"USE_MDPM" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/HlsCodecSpecification
  (s/spec string? :gen #(s/gen #{"RFC_4281" "RFC_6381"})))

(s/def
  :cognitect.aws.mediaconvert/ListPresetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListPresetsRequest/Order
     :cognitect.aws.mediaconvert.ListPresetsRequest/Category
     :cognitect.aws.mediaconvert.ListPresetsRequest/ListBy
     :cognitect.aws.mediaconvert.ListPresetsRequest/NextToken
     :cognitect.aws.mediaconvert.ListPresetsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediaconvert/DeleteQueueRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.DeleteQueueRequest/Name]))

(s/def
  :cognitect.aws.mediaconvert/Job
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.Job/Settings :cognitect.aws.mediaconvert.Job/Role]
    :opt-un
    [:cognitect.aws.mediaconvert.Job/Messages
     :cognitect.aws.mediaconvert.Job/AccelerationStatus
     :cognitect.aws.mediaconvert.Job/ClientRequestToken
     :cognitect.aws.mediaconvert.Job/JobEngineVersionRequested
     :cognitect.aws.mediaconvert.Job/Warnings
     :cognitect.aws.mediaconvert.Job/CurrentPhase
     :cognitect.aws.mediaconvert.Job/Queue
     :cognitect.aws.mediaconvert.Job/OutputGroupDetails
     :cognitect.aws.mediaconvert.Job/Status
     :cognitect.aws.mediaconvert.Job/RetryCount
     :cognitect.aws.mediaconvert.Job/JobTemplate
     :cognitect.aws.mediaconvert.Job/Priority
     :cognitect.aws.mediaconvert.Job/UserMetadata
     :cognitect.aws.mediaconvert.Job/ErrorMessage
     :cognitect.aws.mediaconvert.Job/AccelerationSettings
     :cognitect.aws.mediaconvert.Job/ErrorCode
     :cognitect.aws.mediaconvert.Job/Timing
     :cognitect.aws.mediaconvert.Job/HopDestinations
     :cognitect.aws.mediaconvert.Job/JobPercentComplete
     :cognitect.aws.mediaconvert.Job/JobEngineVersionUsed
     :cognitect.aws.mediaconvert.Job/Arn
     :cognitect.aws.mediaconvert.Job/CreatedAt
     :cognitect.aws.mediaconvert.Job/SimulateReservedQueue
     :cognitect.aws.mediaconvert.Job/QueueTransitions
     :cognitect.aws.mediaconvert.Job/StatusUpdateInterval
     :cognitect.aws.mediaconvert.Job/BillingTagsSource
     :cognitect.aws.mediaconvert.Job/Id]))

(s/def
  :cognitect.aws.mediaconvert/AudioNormalizationAlgorithmControl
  (s/spec string? :gen #(s/gen #{"CORRECT_AUDIO" "MEASURE_ONLY"})))

(s/def
  :cognitect.aws.mediaconvert/M2tsEbpPlacement
  (s/spec string? :gen #(s/gen #{"VIDEO_AND_AUDIO_PIDS" "VIDEO_PID"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max4096
  (s/spec (s/and int? #(<= 1 % 4096)) :gen #(gen/choose 1 4096)))

(s/def
  :cognitect.aws.mediaconvert/GetPresetResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.GetPresetResponse/Preset]))

(s/def
  :cognitect.aws.mediaconvert/__doubleMinNegative60Max6
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647
  (s/spec (s/and int? #(<= 0 % 2147483647)) :gen #(gen/choose 0 2147483647)))

(s/def
  :cognitect.aws.mediaconvert/FlacSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.FlacSettings/SampleRate
     :cognitect.aws.mediaconvert.FlacSettings/BitDepth
     :cognitect.aws.mediaconvert.FlacSettings/Channels]))

(s/def
  :cognitect.aws.mediaconvert/CaptionSourceByteRateLimit
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfOutputChannelMapping
  (s/coll-of :cognitect.aws.mediaconvert/OutputChannelMapping))

(s/def
  :cognitect.aws.mediaconvert/CmafImageBasedTrickPlay
  (s/spec string? :gen #(s/gen #{"THUMBNAIL" "NONE" "ADVANCED" "THUMBNAIL_AND_FULLFRAME"})))

(s/def
  :cognitect.aws.mediaconvert/DynamicAudioSelectorType
  (s/spec string? :gen #(s/gen #{"LANGUAGE_CODE" "ALL_TRACKS"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647
  (s/spec (s/and int? #(<= -2147483648 % 2147483647)) :gen #(gen/choose -2147483648 2147483647)))

(s/def :cognitect.aws.mediaconvert/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.mediaconvert/NoiseFilterPostTemporalSharpeningStrength
  (s/spec string? :gen #(s/gen #{"LOW" "HIGH" "MEDIUM"})))

(s/def
  :cognitect.aws.mediaconvert/CreatePresetRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.CreatePresetRequest/Settings
     :cognitect.aws.mediaconvert.CreatePresetRequest/Name]
    :opt-un
    [:cognitect.aws.mediaconvert.CreatePresetRequest/Category
     :cognitect.aws.mediaconvert.CreatePresetRequest/Tags
     :cognitect.aws.mediaconvert.CreatePresetRequest/Description]))

(s/def
  :cognitect.aws.mediaconvert/GetJobRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.GetJobRequest/Id]))

(s/def
  :cognitect.aws.mediaconvert/AiffSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AiffSettings/SampleRate
     :cognitect.aws.mediaconvert.AiffSettings/BitDepth
     :cognitect.aws.mediaconvert.AiffSettings/Channels]))

(s/def
  :cognitect.aws.mediaconvert/JobEngineVersion
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.JobEngineVersion/ExpirationDate
     :cognitect.aws.mediaconvert.JobEngineVersion/Version]))

(s/def
  :cognitect.aws.mediaconvert/M2tsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.M2tsSettings/PatInterval
     :cognitect.aws.mediaconvert.M2tsSettings/Scte35Source
     :cognitect.aws.mediaconvert.M2tsSettings/BufferModel
     :cognitect.aws.mediaconvert.M2tsSettings/DvbTdtSettings
     :cognitect.aws.mediaconvert.M2tsSettings/PtsOffsetMode
     :cognitect.aws.mediaconvert.M2tsSettings/AudioFramesPerPes
     :cognitect.aws.mediaconvert.M2tsSettings/FragmentTime
     :cognitect.aws.mediaconvert.M2tsSettings/TransportStreamId
     :cognitect.aws.mediaconvert.M2tsSettings/DvbSdtSettings
     :cognitect.aws.mediaconvert.M2tsSettings/PcrControl
     :cognitect.aws.mediaconvert.M2tsSettings/Scte35Pid
     :cognitect.aws.mediaconvert.M2tsSettings/MinEbpInterval
     :cognitect.aws.mediaconvert.M2tsSettings/ProgramNumber
     :cognitect.aws.mediaconvert.M2tsSettings/PcrPid
     :cognitect.aws.mediaconvert.M2tsSettings/PmtPid
     :cognitect.aws.mediaconvert.M2tsSettings/VideoPid
     :cognitect.aws.mediaconvert.M2tsSettings/RateMode
     :cognitect.aws.mediaconvert.M2tsSettings/PtsOffset
     :cognitect.aws.mediaconvert.M2tsSettings/AudioPids
     :cognitect.aws.mediaconvert.M2tsSettings/PreventBufferUnderflow
     :cognitect.aws.mediaconvert.M2tsSettings/NielsenId3
     :cognitect.aws.mediaconvert.M2tsSettings/MaxPcrInterval
     :cognitect.aws.mediaconvert.M2tsSettings/PmtInterval
     :cognitect.aws.mediaconvert.M2tsSettings/SegmentationStyle
     :cognitect.aws.mediaconvert.M2tsSettings/NullPacketBitrate
     :cognitect.aws.mediaconvert.M2tsSettings/SegmentationMarkers
     :cognitect.aws.mediaconvert.M2tsSettings/EbpPlacement
     :cognitect.aws.mediaconvert.M2tsSettings/AudioBufferModel
     :cognitect.aws.mediaconvert.M2tsSettings/EsRateInPes
     :cognitect.aws.mediaconvert.M2tsSettings/TimedMetadataPid
     :cognitect.aws.mediaconvert.M2tsSettings/KlvMetadata
     :cognitect.aws.mediaconvert.M2tsSettings/ForceTsVideoEbpOrder
     :cognitect.aws.mediaconvert.M2tsSettings/AudioDuration
     :cognitect.aws.mediaconvert.M2tsSettings/Scte35Esam
     :cognitect.aws.mediaconvert.M2tsSettings/DvbSubPids
     :cognitect.aws.mediaconvert.M2tsSettings/DataPTSControl
     :cognitect.aws.mediaconvert.M2tsSettings/EbpAudioInterval
     :cognitect.aws.mediaconvert.M2tsSettings/DvbNitSettings
     :cognitect.aws.mediaconvert.M2tsSettings/PrivateMetadataPid
     :cognitect.aws.mediaconvert.M2tsSettings/DvbTeletextPid
     :cognitect.aws.mediaconvert.M2tsSettings/Bitrate
     :cognitect.aws.mediaconvert.M2tsSettings/SegmentationTime]))

(s/def
  :cognitect.aws.mediaconvert/AvcIntraUhdQualityTuningLevel
  (s/spec string? :gen #(s/gen #{"SINGLE_PASS" "MULTI_PASS"})))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2ScanTypeConversionMode
  (s/spec string? :gen #(s/gen #{"INTERLACED_OPTIMIZE" "INTERLACED"})))

(s/def
  :cognitect.aws.mediaconvert/DeletePresetRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.DeletePresetRequest/Name]))

(s/def
  :cognitect.aws.mediaconvert/__stringMin14PatternS3CubeCUBEHttpsCubeCUBE
  (s/spec
    #(re-matches
      (re-pattern
        "^((s3://(.*?)\\.(cube|CUBE))|(https?://(.*?)\\.(cube|CUBE)(\\?([^&=]+=[^&]+&)*[^&=]+=[^&]+)?))$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/H265SlowPal
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/H265QvbrSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.H265QvbrSettings/QvbrQualityLevelFineTune
     :cognitect.aws.mediaconvert.H265QvbrSettings/QvbrQualityLevel
     :cognitect.aws.mediaconvert.H265QvbrSettings/MaxAverageBitrate]))

(s/def
  :cognitect.aws.mediaconvert/Vc3FramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/NoiseReducerFilterSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.NoiseReducerFilterSettings/Strength]))

(s/def
  :cognitect.aws.mediaconvert/XavcHdIntraCbgProfileClass
  (s/spec string? :gen #(s/gen #{"CLASS_200" "CLASS_50" "CLASS_100"})))

(s/def
  :cognitect.aws.mediaconvert/TimecodeSource
  (s/spec string? :gen #(s/gen #{"ZEROBASED" "EMBEDDED" "SPECIFIEDSTART"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3SurroundExMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "NOT_INDICATED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/RenewalType
  (s/spec string? :gen #(s/gen #{"EXPIRE" "AUTO_RENEW"})))

(s/def
  :cognitect.aws.mediaconvert/RemoveRubyReserveAttributes
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/M3u8PcrControl
  (s/spec string? :gen #(s/gen #{"CONFIGURED_PCR_PERIOD" "PCR_EVERY_PES_PACKET"})))

(s/def
  :cognitect.aws.mediaconvert/OpusSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.OpusSettings/SampleRate
     :cognitect.aws.mediaconvert.OpusSettings/Bitrate
     :cognitect.aws.mediaconvert.OpusSettings/Channels]))

(s/def
  :cognitect.aws.mediaconvert/ListVersionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListVersionsRequest/NextToken
     :cognitect.aws.mediaconvert.ListVersionsRequest/MaxResults]))

(s/def :cognitect.aws.mediaconvert/PadVideo (s/spec string? :gen #(s/gen #{"DISABLED" "BLACK"})))

(s/def
  :cognitect.aws.mediaconvert/PresetListBy
  (s/spec string? :gen #(s/gen #{"SYSTEM" "CREATION_DATE" "NAME"})))

(s/def
  :cognitect.aws.mediaconvert/InternalServerErrorException
  (s/keys :opt-un [:cognitect.aws.mediaconvert.InternalServerErrorException/Message]))

(s/def
  :cognitect.aws.mediaconvert/BurninSubtitleOutlineColor
  (s/spec string? :gen #(s/gen #{"AUTO" "GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})))

(s/def
  :cognitect.aws.mediaconvert/H265ParControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/DvbSubtitleShadowColor
  (s/spec string? :gen #(s/gen #{"AUTO" "NONE" "WHITE" "BLACK"})))

(s/def :cognitect.aws.mediaconvert/QueueStatus (s/spec string? :gen #(s/gen #{"ACTIVE" "PAUSED"})))

(s/def
  :cognitect.aws.mediaconvert/M2tsAudioBufferModel
  (s/spec string? :gen #(s/gen #{"DVB" "ATSC"})))

(s/def
  :cognitect.aws.mediaconvert/H265QualityTuningLevel
  (s/spec string? :gen #(s/gen #{"MULTI_PASS_HQ" "SINGLE_PASS" "SINGLE_PASS_HQ"})))

(s/def
  :cognitect.aws.mediaconvert/__doubleMinNegative60MaxNegative1
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/__listOf__integerMinNegative60Max6
  (s/coll-of :cognitect.aws.mediaconvert/__integerMinNegative60Max6))

(s/def
  :cognitect.aws.mediaconvert/__listOfForceIncludeRenditionSize
  (s/coll-of :cognitect.aws.mediaconvert/ForceIncludeRenditionSize))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max30000
  (s/spec (s/and int? #(<= 0 % 30000)) :gen #(gen/choose 0 30000)))

(s/def
  :cognitect.aws.mediaconvert/NoiseReducerTemporalFilterSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/PostTemporalSharpening
     :cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/AggressiveMode
     :cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/Speed
     :cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/PostTemporalSharpeningStrength
     :cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/Strength]))

(s/def
  :cognitect.aws.mediaconvert/__mapOf__string
  (s/map-of :cognitect.aws.mediaconvert/__string :cognitect.aws.mediaconvert/__string))

(s/def
  :cognitect.aws.mediaconvert/AdvancedInputFilterAddTexture
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/DolbyVision
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DolbyVision/L6Mode
     :cognitect.aws.mediaconvert.DolbyVision/Profile
     :cognitect.aws.mediaconvert.DolbyVision/Mapping
     :cognitect.aws.mediaconvert.DolbyVision/L6Metadata]))

(s/def
  :cognitect.aws.mediaconvert/CaptionDescriptionPreset
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CaptionDescriptionPreset/CustomLanguageCode
     :cognitect.aws.mediaconvert.CaptionDescriptionPreset/DestinationSettings
     :cognitect.aws.mediaconvert.CaptionDescriptionPreset/LanguageCode
     :cognitect.aws.mediaconvert.CaptionDescriptionPreset/LanguageDescription]))

(s/def :cognitect.aws.mediaconvert/Mpeg2Syntax (s/spec string? :gen #(s/gen #{"D_10" "DEFAULT"})))

(s/def
  :cognitect.aws.mediaconvert/ScalingBehavior
  (s/spec string? :gen #(s/gen #{"FILL" "STRETCH_TO_OUTPUT" "FIT_NO_UPSCALE" "FIT" "DEFAULT"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPattern0940191020191209301
  (s/spec
    #(re-matches (re-pattern "^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])$") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.mediaconvert/Av1RateControlMode (s/spec string? :gen #(s/gen #{"QVBR"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfOutputDetail
  (s/coll-of :cognitect.aws.mediaconvert/OutputDetail))

(s/def
  :cognitect.aws.mediaconvert/OutputGroup
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.OutputGroup/Outputs
     :cognitect.aws.mediaconvert.OutputGroup/AutomatedEncodingSettings
     :cognitect.aws.mediaconvert.OutputGroup/OutputGroupSettings
     :cognitect.aws.mediaconvert.OutputGroup/Name
     :cognitect.aws.mediaconvert.OutputGroup/CustomName]))

(s/def
  :cognitect.aws.mediaconvert/__doubleMinNegative8Max0
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/__listOfCaptionDescriptionPreset
  (s/coll-of :cognitect.aws.mediaconvert/CaptionDescriptionPreset))

(s/def
  :cognitect.aws.mediaconvert/EmbeddedSourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.EmbeddedSourceSettings/Source608ChannelNumber
     :cognitect.aws.mediaconvert.EmbeddedSourceSettings/Convert608To708
     :cognitect.aws.mediaconvert.EmbeddedSourceSettings/TerminateCaptions
     :cognitect.aws.mediaconvert.EmbeddedSourceSettings/Source608TrackNumber]))

(s/def
  :cognitect.aws.mediaconvert/GetJobTemplateRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.GetJobTemplateRequest/Name]))

(s/def
  :cognitect.aws.mediaconvert/Output
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Output/ContainerSettings
     :cognitect.aws.mediaconvert.Output/NameModifier
     :cognitect.aws.mediaconvert.Output/CaptionDescriptions
     :cognitect.aws.mediaconvert.Output/VideoDescription
     :cognitect.aws.mediaconvert.Output/OutputSettings
     :cognitect.aws.mediaconvert.Output/Preset
     :cognitect.aws.mediaconvert.Output/Extension
     :cognitect.aws.mediaconvert.Output/AudioDescriptions]))

(s/def
  :cognitect.aws.mediaconvert/__stringMin9Max19PatternAZ26EastWestCentralNorthSouthEastWest1912
  (s/spec
    #(re-matches
      (re-pattern "^[a-z-]{2,6}-(east|west|central|((north|south)(east|west)?))-[1-9]{1,2}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/Ac3DynamicRangeCompressionLine
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def
  :cognitect.aws.mediaconvert/AdvancedInputFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/DashIsoPlaybackDeviceCompatibility
  (s/spec string? :gen #(s/gen #{"CENC_V1" "UNENCRYPTED_SEI"})))

(s/def
  :cognitect.aws.mediaconvert/VideoPreprocessor
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoPreprocessor/TimecodeBurnin
     :cognitect.aws.mediaconvert.VideoPreprocessor/Hdr10Plus
     :cognitect.aws.mediaconvert.VideoPreprocessor/DolbyVision
     :cognitect.aws.mediaconvert.VideoPreprocessor/ColorCorrector
     :cognitect.aws.mediaconvert.VideoPreprocessor/NoiseReducer
     :cognitect.aws.mediaconvert.VideoPreprocessor/ImageInserter
     :cognitect.aws.mediaconvert.VideoPreprocessor/Deinterlacer
     :cognitect.aws.mediaconvert.VideoPreprocessor/PartnerWatermarking]))

(s/def
  :cognitect.aws.mediaconvert/CaptionSourceConvertPaintOnToPopOn
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfHlsAdMarkers
  (s/coll-of :cognitect.aws.mediaconvert/HlsAdMarkers))

(s/def
  :cognitect.aws.mediaconvert/DashIsoMpdManifestBandwidthType
  (s/spec string? :gen #(s/gen #{"MAX" "AVERAGE"})))

(s/def
  :cognitect.aws.mediaconvert/Mp2Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Mp2Settings/SampleRate
     :cognitect.aws.mediaconvert.Mp2Settings/Bitrate
     :cognitect.aws.mediaconvert.Mp2Settings/Channels]))

(s/def
  :cognitect.aws.mediaconvert/M2tsPreventBufferUnderflow
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/VideoCodec
  (s/spec
    string?
    :gen
    #(s/gen
      #{"XAVC"
        "H_264"
        "AVC_INTRA"
        "VP9"
        "VC3"
        "PASSTHROUGH"
        "UNCOMPRESSED"
        "AV1"
        "VP8"
        "MPEG2"
        "H_265"
        "FRAME_CAPTURE"
        "PRORES"
        "GIF"})))

(s/def
  :cognitect.aws.mediaconvert/ProresFramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def
  :cognitect.aws.mediaconvert/DescribeEndpointsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DescribeEndpointsResponse/Endpoints
     :cognitect.aws.mediaconvert.DescribeEndpointsResponse/NextToken]))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2AdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"LOW" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.mediaconvert/S3DestinationAccessControl
  (s/keys :opt-un [:cognitect.aws.mediaconvert.S3DestinationAccessControl/CannedAcl]))

(s/def
  :cognitect.aws.mediaconvert/H265EndOfStreamMarkers
  (s/spec string? :gen #(s/gen #{"INCLUDE" "SUPPRESS"})))

(s/def
  :cognitect.aws.mediaconvert/KantarWatermarkSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.KantarWatermarkSettings/ContentReference
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/KantarServerUrl
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata4
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata6
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/KantarLicenseId
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata8
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/ChannelName
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/CredentialsSecretName
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata3
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata5
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/LogDestination
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata7
     :cognitect.aws.mediaconvert.KantarWatermarkSettings/FileOffset]))

(s/def
  :cognitect.aws.mediaconvert/HDRToSDRToneMapper
  (s/spec string? :gen #(s/gen #{"VIBRANT" "PRESERVE_DETAILS"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max20
  (s/spec (s/and int? #(<= 1 % 20)) :gen #(gen/choose 1 20)))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternAZaZ23AZaZ09
  (s/spec #(re-matches (re-pattern "^[A-Za-z]{2,3}(-[A-Za-z0-9-]+)?$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max100
  (s/spec (s/and int? #(<= 0 % 100)) :gen #(gen/choose 0 100)))

(s/def
  :cognitect.aws.mediaconvert/CmafVideoCompositionOffsets
  (s/spec string? :gen #(s/gen #{"UNSIGNED" "SIGNED"})))

(s/def :cognitect.aws.mediaconvert/M3u8NielsenId3 (s/spec string? :gen #(s/gen #{"INSERT" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/CmafIntervalCadence
  (s/spec string? :gen #(s/gen #{"FOLLOW_CUSTOM" "FOLLOW_IFRAME"})))

(s/def
  :cognitect.aws.mediaconvert/XavcSlowPal
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def :cognitect.aws.mediaconvert/__listOfJob (s/coll-of :cognitect.aws.mediaconvert/Job))

(s/def
  :cognitect.aws.mediaconvert/DashIsoIntervalCadence
  (s/spec string? :gen #(s/gen #{"FOLLOW_CUSTOM" "FOLLOW_IFRAME"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3DynamicRangeCompressionLine
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def
  :cognitect.aws.mediaconvert/MsSmoothGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MsSmoothGroupSettings/FragmentLength
     :cognitect.aws.mediaconvert.MsSmoothGroupSettings/AdditionalManifests
     :cognitect.aws.mediaconvert.MsSmoothGroupSettings/Destination
     :cognitect.aws.mediaconvert.MsSmoothGroupSettings/ManifestEncoding
     :cognitect.aws.mediaconvert.MsSmoothGroupSettings/DestinationSettings
     :cognitect.aws.mediaconvert.MsSmoothGroupSettings/Encryption
     :cognitect.aws.mediaconvert.MsSmoothGroupSettings/AudioDeduplication
     :cognitect.aws.mediaconvert.MsSmoothGroupSettings/FragmentLengthControl]))

(s/def
  :cognitect.aws.mediaconvert/HlsCaptionSegmentLengthControl
  (s/spec string? :gen #(s/gen #{"MATCH_VIDEO" "LARGE_SEGMENTS"})))

(s/def
  :cognitect.aws.mediaconvert/BurnInSubtitleStylePassthrough
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/FileSourceConvert608To708
  (s/spec string? :gen #(s/gen #{"DISABLED" "UPCONVERT"})))

(s/def
  :cognitect.aws.mediaconvert/InputPsiControl
  (s/spec string? :gen #(s/gen #{"IGNORE_PSI" "USE_PSI"})))

(s/def
  :cognitect.aws.mediaconvert/MovCslgAtom
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/InputRotate
  (s/spec string? :gen #(s/gen #{"DEGREES_180" "DEGREE_0" "DEGREES_90" "AUTO" "DEGREES_270"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3StereoDownmix
  (s/spec string? :gen #(s/gen #{"NOT_INDICATED" "LO_RO" "LT_RT" "DPL2"})))

(s/def
  :cognitect.aws.mediaconvert/HlsDescriptiveVideoServiceFlag
  (s/spec string? :gen #(s/gen #{"DONT_FLAG" "FLAG"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin4Max12
  (s/spec (s/and int? #(<= 4 % 12)) :gen #(gen/choose 4 12)))

(s/def
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092090909
  (s/spec
    #(re-matches
      (re-pattern
        "^([01][0-9]|2[0-4]):[0-5][0-9]:[0-5][0-9][:;][0-9]{2}(@[0-9]+(\\.[0-9]+)?(:[0-9]+)?)?$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/Av1QvbrSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Av1QvbrSettings/QvbrQualityLevelFineTune
     :cognitect.aws.mediaconvert.Av1QvbrSettings/QvbrQualityLevel]))

(s/def
  :cognitect.aws.mediaconvert/CmafCodecSpecification
  (s/spec string? :gen #(s/gen #{"RFC_4281" "RFC_6381"})))

(s/def :cognitect.aws.mediaconvert/AssociateCertificateResponse (s/keys))

(s/def
  :cognitect.aws.mediaconvert/OutputSdt
  (s/spec string? :gen #(s/gen #{"SDT_MANUAL" "SDT_NONE" "SDT_FOLLOW_IF_PRESENT" "SDT_FOLLOW"})))

(s/def
  :cognitect.aws.mediaconvert/CmafMpdProfile
  (s/spec string? :gen #(s/gen #{"MAIN_PROFILE" "ON_DEMAND_PROFILE"})))

(s/def
  :cognitect.aws.mediaconvert/H265Telecine
  (s/spec string? :gen #(s/gen #{"SOFT" "HARD" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max255
  (s/spec (s/and int? #(<= 0 % 255)) :gen #(gen/choose 0 255)))

(s/def
  :cognitect.aws.mediaconvert/HlsIntervalCadence
  (s/spec string? :gen #(s/gen #{"FOLLOW_CUSTOM" "FOLLOW_IFRAME"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12
  (s/spec
    #(re-matches
      (re-pattern "^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/CmafWriteHLSManifest
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/HlsCaptionLanguageMapping
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.HlsCaptionLanguageMapping/CustomLanguageCode
     :cognitect.aws.mediaconvert.HlsCaptionLanguageMapping/LanguageCode
     :cognitect.aws.mediaconvert.HlsCaptionLanguageMapping/CaptionChannel
     :cognitect.aws.mediaconvert.HlsCaptionLanguageMapping/LanguageDescription]))

(s/def
  :cognitect.aws.mediaconvert/Eac3DcFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/DashIsoImageBasedTrickPlay
  (s/spec string? :gen #(s/gen #{"THUMBNAIL" "NONE" "ADVANCED" "THUMBNAIL_AND_FULLFRAME"})))

(s/def
  :cognitect.aws.mediaconvert/CmafMpdManifestBandwidthType
  (s/spec string? :gen #(s/gen #{"MAX" "AVERAGE"})))

(s/def
  :cognitect.aws.mediaconvert/CreateQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.CreateQueueRequest/Name]
    :opt-un
    [:cognitect.aws.mediaconvert.CreateQueueRequest/PricingPlan
     :cognitect.aws.mediaconvert.CreateQueueRequest/Tags
     :cognitect.aws.mediaconvert.CreateQueueRequest/Status
     :cognitect.aws.mediaconvert.CreateQueueRequest/Description
     :cognitect.aws.mediaconvert.CreateQueueRequest/ConcurrentJobs
     :cognitect.aws.mediaconvert.CreateQueueRequest/ReservationPlanSettings]))

(s/def
  :cognitect.aws.mediaconvert/Eac3MetadataControl
  (s/spec string? :gen #(s/gen #{"FOLLOW_INPUT" "USE_CONFIGURED"})))

(s/def :cognitect.aws.mediaconvert/__listOfQueue (s/coll-of :cognitect.aws.mediaconvert/Queue))

(s/def
  :cognitect.aws.mediaconvert/BurninSubtitleTeletextSpacing
  (s/spec string? :gen #(s/gen #{"AUTO" "FIXED_GRID" "PROPORTIONAL"})))

(s/def
  :cognitect.aws.mediaconvert/MotionImagePlayback
  (s/spec string? :gen #(s/gen #{"ONCE" "REPEAT"})))

(s/def
  :cognitect.aws.mediaconvert/M2tsDataPtsControl
  (s/spec string? :gen #(s/gen #{"AUTO" "ALIGN_TO_VIDEO"})))

(s/def
  :cognitect.aws.mediaconvert/DvbTdtSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.DvbTdtSettings/TdtInterval]))

(s/def
  :cognitect.aws.mediaconvert/ListQueuesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListQueuesResponse/NextToken
     :cognitect.aws.mediaconvert.ListQueuesResponse/Queues
     :cognitect.aws.mediaconvert.ListQueuesResponse/TotalConcurrentJobs
     :cognitect.aws.mediaconvert.ListQueuesResponse/UnallocatedConcurrentJobs]))

(s/def
  :cognitect.aws.mediaconvert/ForbiddenException
  (s/keys :opt-un [:cognitect.aws.mediaconvert.ForbiddenException/Message]))

(s/def
  :cognitect.aws.mediaconvert/StaticKeyProvider
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.StaticKeyProvider/StaticKeyValue
     :cognitect.aws.mediaconvert.StaticKeyProvider/KeyFormatVersions
     :cognitect.aws.mediaconvert.StaticKeyProvider/Url
     :cognitect.aws.mediaconvert.StaticKeyProvider/KeyFormat]))

(s/def
  :cognitect.aws.mediaconvert/TimedMetadataInsertion
  (s/keys :opt-un [:cognitect.aws.mediaconvert.TimedMetadataInsertion/Id3Insertions]))

(s/def
  :cognitect.aws.mediaconvert/__listOfEndpoint
  (s/coll-of :cognitect.aws.mediaconvert/Endpoint))

(s/def
  :cognitect.aws.mediaconvert/HlsOfflineEncrypted
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/BadRequestException
  (s/keys :opt-un [:cognitect.aws.mediaconvert.BadRequestException/Message]))

(s/def
  :cognitect.aws.mediaconvert/XavcGopBReference
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__listOf__stringMin1
  (s/coll-of :cognitect.aws.mediaconvert/__stringMin1))

(s/def
  :cognitect.aws.mediaconvert/__stringMin16Max24PatternAZaZ0922AZaZ0916
  (s/spec
    #(re-matches (re-pattern "^[A-Za-z0-9+\\/]{22}==$|^[A-Za-z0-9+\\/]{16}$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/MpdManifestMetadataSignaling
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max1466400000
  (s/spec (s/and int? #(<= 0 % 1466400000)) :gen #(gen/choose 0 1466400000)))

(s/def
  :cognitect.aws.mediaconvert/DvbSubtitlingType
  (s/spec string? :gen #(s/gen #{"STANDARD" "HEARING_IMPAIRED"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin8Max4096
  (s/spec (s/and int? #(<= 8 % 4096)) :gen #(gen/choose 8 4096)))

(s/def
  :cognitect.aws.mediaconvert/PutPolicyRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.PutPolicyRequest/Policy]))

(s/def
  :cognitect.aws.mediaconvert/CmafStreamInfResolution
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin25Max10000
  (s/spec (s/and int? #(<= 25 % 10000)) :gen #(gen/choose 25 10000)))

(s/def
  :cognitect.aws.mediaconvert/TrackSourceSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.TrackSourceSettings/TrackNumber]))

(s/def
  :cognitect.aws.mediaconvert/ColorSpace
  (s/spec
    string?
    :gen
    #(s/gen #{"P3D65_HDR" "HLG_2020" "REC_601" "FOLLOW" "HDR10" "P3D65_SDR" "P3DCI" "REC_709"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1000Max480000000
  (s/spec (s/and int? #(<= 1000 % 480000000)) :gen #(gen/choose 1000 480000000)))

(s/def
  :cognitect.aws.mediaconvert/F4vSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.F4vSettings/MoovPlacement]))

(s/def
  :cognitect.aws.mediaconvert/CreatePresetResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.CreatePresetResponse/Preset]))

(s/def
  :cognitect.aws.mediaconvert/UpdateQueueResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.UpdateQueueResponse/Queue]))

(s/def
  :cognitect.aws.mediaconvert/PricingPlan
  (s/spec string? :gen #(s/gen #{"ON_DEMAND" "RESERVED"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfId3Insertion
  (s/coll-of :cognitect.aws.mediaconvert/Id3Insertion))

(s/def
  :cognitect.aws.mediaconvert/Preset
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.Preset/Settings :cognitect.aws.mediaconvert.Preset/Name]
    :opt-un
    [:cognitect.aws.mediaconvert.Preset/Type
     :cognitect.aws.mediaconvert.Preset/Category
     :cognitect.aws.mediaconvert.Preset/Description
     :cognitect.aws.mediaconvert.Preset/Arn
     :cognitect.aws.mediaconvert.Preset/CreatedAt
     :cognitect.aws.mediaconvert.Preset/LastUpdated]))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2Telecine
  (s/spec string? :gen #(s/gen #{"SOFT" "HARD" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/BurninSubtitleShadowColor
  (s/spec string? :gen #(s/gen #{"AUTO" "NONE" "WHITE" "BLACK"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfAllowedRenditionSize
  (s/coll-of :cognitect.aws.mediaconvert/AllowedRenditionSize))

(s/def
  :cognitect.aws.mediaconvert/DescribeEndpointsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DescribeEndpointsRequest/Mode
     :cognitect.aws.mediaconvert.DescribeEndpointsRequest/NextToken
     :cognitect.aws.mediaconvert.DescribeEndpointsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediaconvert/M2tsScte35Esam
  (s/keys :opt-un [:cognitect.aws.mediaconvert.M2tsScte35Esam/Scte35EsamPid]))

(s/def
  :cognitect.aws.mediaconvert/VideoOverlayPosition
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoOverlayPosition/Unit
     :cognitect.aws.mediaconvert.VideoOverlayPosition/Width
     :cognitect.aws.mediaconvert.VideoOverlayPosition/YPosition
     :cognitect.aws.mediaconvert.VideoOverlayPosition/XPosition
     :cognitect.aws.mediaconvert.VideoOverlayPosition/Height]))

(s/def
  :cognitect.aws.mediaconvert/NoiseReducerFilter
  (s/spec
    string?
    :gen
    #(s/gen #{"LANCZOS" "MEAN" "SPATIAL" "GAUSSIAN" "TEMPORAL" "SHARPEN" "BILATERAL" "CONSERVE"})))

(s/def
  :cognitect.aws.mediaconvert/GetPolicyResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.GetPolicyResponse/Policy]))

(s/def
  :cognitect.aws.mediaconvert/DashIsoVideoCompositionOffsets
  (s/spec string? :gen #(s/gen #{"UNSIGNED" "SIGNED"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosMeteringMode
  (s/spec
    string?
    :gen
    #(s/gen #{"ITU_BS_1770_1" "ITU_BS_1770_2" "ITU_BS_1770_4" "LEQ_A" "ITU_BS_1770_3"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max31
  (s/spec (s/and int? #(<= 1 % 31)) :gen #(gen/choose 1 31)))

(s/def
  :cognitect.aws.mediaconvert/CmafClientCache
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/MinBottomRenditionSize
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MinBottomRenditionSize/Width
     :cognitect.aws.mediaconvert.MinBottomRenditionSize/Height]))

(s/def
  :cognitect.aws.mediaconvert/InputDenoiseFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPattern
  (s/spec #(re-matches (re-pattern "^[ -~]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/DvbSubSourceSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.DvbSubSourceSettings/Pid]))

(s/def
  :cognitect.aws.mediaconvert/DestinationSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.DestinationSettings/S3Settings]))

(s/def
  :cognitect.aws.mediaconvert/__integerMinNegative1Max10
  (s/spec (s/and int? #(<= -1 % 10)) :gen #(gen/choose -1 10)))

(s/def
  :cognitect.aws.mediaconvert/SrtStylePassthrough
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/WatermarkingStrength
  (s/spec string? :gen #(s/gen #{"STRONGER" "LIGHTER" "LIGHTEST" "STRONGEST" "DEFAULT"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin96Max600
  (s/spec (s/and int? #(<= 96 % 600)) :gen #(gen/choose 96 600)))

(s/def
  :cognitect.aws.mediaconvert/SimulateReservedQueue
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/ChannelMapping
  (s/keys :opt-un [:cognitect.aws.mediaconvert.ChannelMapping/OutputChannels]))

(s/def
  :cognitect.aws.mediaconvert/BurninSubtitleApplyFontColor
  (s/spec string? :gen #(s/gen #{"WHITE_TEXT_ONLY" "ALL_TEXT"})))

(s/def
  :cognitect.aws.mediaconvert/ListQueuesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListQueuesRequest/Order
     :cognitect.aws.mediaconvert.ListQueuesRequest/ListBy
     :cognitect.aws.mediaconvert.ListQueuesRequest/NextToken
     :cognitect.aws.mediaconvert.ListQueuesRequest/MaxResults]))

(s/def
  :cognitect.aws.mediaconvert/MovClapAtom
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.UntagResourceRequest/Arn]
    :opt-un
    [:cognitect.aws.mediaconvert.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternSNSignalProcessingNotificationNS
  (s/spec
    #(re-matches (re-pattern "^\\s*<(.|\\n)*SignalProcessingNotification(.|\\n)*>\\s*$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max100
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.mediaconvert/Av1AdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"LOW" "MAX" "HIGHER" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.mediaconvert/H264GopBReference
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/Timing
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Timing/StartTime
     :cognitect.aws.mediaconvert.Timing/SubmitTime
     :cognitect.aws.mediaconvert.Timing/FinishTime]))

(s/def
  :cognitect.aws.mediaconvert/VideoOverlayInputClipping
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoOverlayInputClipping/StartTimecode
     :cognitect.aws.mediaconvert.VideoOverlayInputClipping/EndTimecode]))

(s/def
  :cognitect.aws.mediaconvert/S3EncryptionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.S3EncryptionSettings/KmsEncryptionContext
     :cognitect.aws.mediaconvert.S3EncryptionSettings/KmsKeyArn
     :cognitect.aws.mediaconvert.S3EncryptionSettings/EncryptionType]))

(s/def
  :cognitect.aws.mediaconvert/H265Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.H265Settings/RateControlMode
     :cognitect.aws.mediaconvert.H265Settings/UnregisteredSeiTimecode
     :cognitect.aws.mediaconvert.H265Settings/BandwidthReductionFilter
     :cognitect.aws.mediaconvert.H265Settings/InterlaceMode
     :cognitect.aws.mediaconvert.H265Settings/MinIInterval
     :cognitect.aws.mediaconvert.H265Settings/ParDenominator
     :cognitect.aws.mediaconvert.H265Settings/ScanTypeConversionMode
     :cognitect.aws.mediaconvert.H265Settings/GopBReference
     :cognitect.aws.mediaconvert.H265Settings/NumberReferenceFrames
     :cognitect.aws.mediaconvert.H265Settings/QualityTuningLevel
     :cognitect.aws.mediaconvert.H265Settings/Tiles
     :cognitect.aws.mediaconvert.H265Settings/AdaptiveQuantization
     :cognitect.aws.mediaconvert.H265Settings/FramerateDenominator
     :cognitect.aws.mediaconvert.H265Settings/HrdBufferFinalFillPercentage
     :cognitect.aws.mediaconvert.H265Settings/FramerateControl
     :cognitect.aws.mediaconvert.H265Settings/EndOfStreamMarkers
     :cognitect.aws.mediaconvert.H265Settings/AlternateTransferFunctionSei
     :cognitect.aws.mediaconvert.H265Settings/HrdBufferSize
     :cognitect.aws.mediaconvert.H265Settings/SlowPal
     :cognitect.aws.mediaconvert.H265Settings/DynamicSubGop
     :cognitect.aws.mediaconvert.H265Settings/NumberBFramesBetweenReferenceFrames
     :cognitect.aws.mediaconvert.H265Settings/QvbrSettings
     :cognitect.aws.mediaconvert.H265Settings/GopClosedCadence
     :cognitect.aws.mediaconvert.H265Settings/SpatialAdaptiveQuantization
     :cognitect.aws.mediaconvert.H265Settings/FramerateNumerator
     :cognitect.aws.mediaconvert.H265Settings/GopSizeUnits
     :cognitect.aws.mediaconvert.H265Settings/MaxBitrate
     :cognitect.aws.mediaconvert.H265Settings/CodecProfile
     :cognitect.aws.mediaconvert.H265Settings/TemporalIds
     :cognitect.aws.mediaconvert.H265Settings/FlickerAdaptiveQuantization
     :cognitect.aws.mediaconvert.H265Settings/ParNumerator
     :cognitect.aws.mediaconvert.H265Settings/GopSize
     :cognitect.aws.mediaconvert.H265Settings/SampleAdaptiveOffsetFilterMode
     :cognitect.aws.mediaconvert.H265Settings/ParControl
     :cognitect.aws.mediaconvert.H265Settings/CodecLevel
     :cognitect.aws.mediaconvert.H265Settings/Telecine
     :cognitect.aws.mediaconvert.H265Settings/HrdBufferInitialFillPercentage
     :cognitect.aws.mediaconvert.H265Settings/Slices
     :cognitect.aws.mediaconvert.H265Settings/TemporalAdaptiveQuantization
     :cognitect.aws.mediaconvert.H265Settings/FramerateConversionAlgorithm
     :cognitect.aws.mediaconvert.H265Settings/SceneChangeDetect
     :cognitect.aws.mediaconvert.H265Settings/Deblocking
     :cognitect.aws.mediaconvert.H265Settings/WriteMp4PackagingType
     :cognitect.aws.mediaconvert.H265Settings/Bitrate]))

(s/def
  :cognitect.aws.mediaconvert/GetJobResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.GetJobResponse/Job]))

(s/def
  :cognitect.aws.mediaconvert/NielsenActiveWatermarkProcessType
  (s/spec string? :gen #(s/gen #{"NAES2_AND_NW" "NAES2_AND_NW_AND_CBET" "CBET"})))

(s/def
  :cognitect.aws.mediaconvert/AvcIntraUhdSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.AvcIntraUhdSettings/QualityTuningLevel]))

(s/def
  :cognitect.aws.mediaconvert/InputClipping
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.InputClipping/StartTimecode
     :cognitect.aws.mediaconvert.InputClipping/EndTimecode]))

(s/def
  :cognitect.aws.mediaconvert/MpdSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MpdSettings/Scte35Source
     :cognitect.aws.mediaconvert.MpdSettings/CaptionContainerType
     :cognitect.aws.mediaconvert.MpdSettings/TimedMetadataValue
     :cognitect.aws.mediaconvert.MpdSettings/TimedMetadata
     :cognitect.aws.mediaconvert.MpdSettings/AccessibilityCaptionHints
     :cognitect.aws.mediaconvert.MpdSettings/TimedMetadataSchemeIdUri
     :cognitect.aws.mediaconvert.MpdSettings/KlvMetadata
     :cognitect.aws.mediaconvert.MpdSettings/AudioDuration
     :cognitect.aws.mediaconvert.MpdSettings/Scte35Esam
     :cognitect.aws.mediaconvert.MpdSettings/TimedMetadataBoxVersion
     :cognitect.aws.mediaconvert.MpdSettings/ManifestMetadataSignaling]))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2FramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/HlsAdMarkers
  (s/spec string? :gen #(s/gen #{"ELEMENTAL" "ELEMENTAL_SCTE35"})))

(s/def
  :cognitect.aws.mediaconvert/JobSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.JobSettings/Esam
     :cognitect.aws.mediaconvert.JobSettings/KantarWatermark
     :cognitect.aws.mediaconvert.JobSettings/NielsenNonLinearWatermark
     :cognitect.aws.mediaconvert.JobSettings/ExtendedDataServices
     :cognitect.aws.mediaconvert.JobSettings/Inputs
     :cognitect.aws.mediaconvert.JobSettings/TimedMetadataInsertion
     :cognitect.aws.mediaconvert.JobSettings/MotionImageInserter
     :cognitect.aws.mediaconvert.JobSettings/FollowSource
     :cognitect.aws.mediaconvert.JobSettings/ColorConversion3DLUTSettings
     :cognitect.aws.mediaconvert.JobSettings/TimecodeConfig
     :cognitect.aws.mediaconvert.JobSettings/AdAvailOffset
     :cognitect.aws.mediaconvert.JobSettings/OutputGroups
     :cognitect.aws.mediaconvert.JobSettings/NielsenConfiguration
     :cognitect.aws.mediaconvert.JobSettings/AvailBlanking]))

(s/def
  :cognitect.aws.mediaconvert/HlsImageBasedTrickPlay
  (s/spec string? :gen #(s/gen #{"THUMBNAIL" "NONE" "ADVANCED" "THUMBNAIL_AND_FULLFRAME"})))

(s/def
  :cognitect.aws.mediaconvert/ProresFramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/HlsAudioOnlyHeader
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.mediaconvert/CmafWriteSegmentTimelineInRepresentation
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/CmfcAudioTrackType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT"
        "ALTERNATE_AUDIO_AUTO_SELECT"
        "ALTERNATE_AUDIO_NOT_AUTO_SELECT"
        "AUDIO_ONLY_VARIANT_STREAM"})))

(s/def
  :cognitect.aws.mediaconvert/H264ParControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/UpdateJobTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Name]
    :opt-un
    [:cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Category
     :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Queue
     :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Priority
     :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/AccelerationSettings
     :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Description
     :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/HopDestinations
     :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Settings
     :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/StatusUpdateInterval]))

(s/def
  :cognitect.aws.mediaconvert/MovMpeg2FourCCControl
  (s/spec string? :gen #(s/gen #{"XDCAM" "MPEG"})))

(s/def
  :cognitect.aws.mediaconvert/CaptionDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CaptionDestinationSettings/TtmlDestinationSettings
     :cognitect.aws.mediaconvert.CaptionDestinationSettings/ImscDestinationSettings
     :cognitect.aws.mediaconvert.CaptionDestinationSettings/SccDestinationSettings
     :cognitect.aws.mediaconvert.CaptionDestinationSettings/WebvttDestinationSettings
     :cognitect.aws.mediaconvert.CaptionDestinationSettings/TeletextDestinationSettings
     :cognitect.aws.mediaconvert.CaptionDestinationSettings/DvbSubDestinationSettings
     :cognitect.aws.mediaconvert.CaptionDestinationSettings/SrtDestinationSettings
     :cognitect.aws.mediaconvert.CaptionDestinationSettings/EmbeddedDestinationSettings
     :cognitect.aws.mediaconvert.CaptionDestinationSettings/BurninDestinationSettings
     :cognitect.aws.mediaconvert.CaptionDestinationSettings/DestinationType]))

(s/def
  :cognitect.aws.mediaconvert/Vp8ParControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/AudioCodec
  (s/spec
    string?
    :gen
    #(s/gen
      #{"EAC3"
        "AC3"
        "PASSTHROUGH"
        "OPUS"
        "EAC3_ATMOS"
        "MP2"
        "FLAC"
        "MP3"
        "AAC"
        "AIFF"
        "VORBIS"
        "WAV"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfInputTemplate
  (s/coll-of :cognitect.aws.mediaconvert/InputTemplate))

(s/def
  :cognitect.aws.mediaconvert/VideoOverlayInput
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoOverlayInput/InputClippings
     :cognitect.aws.mediaconvert.VideoOverlayInput/TimecodeSource
     :cognitect.aws.mediaconvert.VideoOverlayInput/TimecodeStart
     :cognitect.aws.mediaconvert.VideoOverlayInput/FileInput]))

(s/def :cognitect.aws.mediaconvert/Eac3LfeControl (s/spec string? :gen #(s/gen #{"NO_LFE" "LFE"})))

(s/def
  :cognitect.aws.mediaconvert/MotionImageInsertionOffset
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MotionImageInsertionOffset/ImageX
     :cognitect.aws.mediaconvert.MotionImageInsertionOffset/ImageY]))

(s/def
  :cognitect.aws.mediaconvert/__listOfServiceOverride
  (s/coll-of :cognitect.aws.mediaconvert/ServiceOverride))

(s/def :cognitect.aws.mediaconvert/Vp8RateControlMode (s/spec string? :gen #(s/gen #{"VBR"})))

(s/def
  :cognitect.aws.mediaconvert/VideoOverlay
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoOverlay/InitialPosition
     :cognitect.aws.mediaconvert.VideoOverlay/StartTimecode
     :cognitect.aws.mediaconvert.VideoOverlay/EndTimecode
     :cognitect.aws.mediaconvert.VideoOverlay/Transitions
     :cognitect.aws.mediaconvert.VideoOverlay/Input
     :cognitect.aws.mediaconvert.VideoOverlay/Playback]))

(s/def
  :cognitect.aws.mediaconvert/AvcIntraSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AvcIntraSettings/InterlaceMode
     :cognitect.aws.mediaconvert.AvcIntraSettings/AvcIntraUhdSettings
     :cognitect.aws.mediaconvert.AvcIntraSettings/ScanTypeConversionMode
     :cognitect.aws.mediaconvert.AvcIntraSettings/FramerateDenominator
     :cognitect.aws.mediaconvert.AvcIntraSettings/FramerateControl
     :cognitect.aws.mediaconvert.AvcIntraSettings/SlowPal
     :cognitect.aws.mediaconvert.AvcIntraSettings/AvcIntraClass
     :cognitect.aws.mediaconvert.AvcIntraSettings/FramerateNumerator
     :cognitect.aws.mediaconvert.AvcIntraSettings/Telecine
     :cognitect.aws.mediaconvert.AvcIntraSettings/FramerateConversionAlgorithm]))

(s/def
  :cognitect.aws.mediaconvert/__listOfVideoOverlayInputClipping
  (s/coll-of :cognitect.aws.mediaconvert/VideoOverlayInputClipping))

(s/def
  :cognitect.aws.mediaconvert/AudioSelectorGroup
  (s/keys :opt-un [:cognitect.aws.mediaconvert.AudioSelectorGroup/AudioSelectorNames]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin25Max2000
  (s/spec (s/and int? #(<= 25 % 2000)) :gen #(gen/choose 25 2000)))

(s/def
  :cognitect.aws.mediaconvert/FontScript
  (s/spec string? :gen #(s/gen #{"HANT" "AUTOMATIC" "HANS"})))

(s/def
  :cognitect.aws.mediaconvert/Vp9Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Vp9Settings/RateControlMode
     :cognitect.aws.mediaconvert.Vp9Settings/ParDenominator
     :cognitect.aws.mediaconvert.Vp9Settings/QualityTuningLevel
     :cognitect.aws.mediaconvert.Vp9Settings/FramerateDenominator
     :cognitect.aws.mediaconvert.Vp9Settings/FramerateControl
     :cognitect.aws.mediaconvert.Vp9Settings/HrdBufferSize
     :cognitect.aws.mediaconvert.Vp9Settings/FramerateNumerator
     :cognitect.aws.mediaconvert.Vp9Settings/MaxBitrate
     :cognitect.aws.mediaconvert.Vp9Settings/ParNumerator
     :cognitect.aws.mediaconvert.Vp9Settings/GopSize
     :cognitect.aws.mediaconvert.Vp9Settings/ParControl
     :cognitect.aws.mediaconvert.Vp9Settings/FramerateConversionAlgorithm
     :cognitect.aws.mediaconvert.Vp9Settings/Bitrate]))

(s/def
  :cognitect.aws.mediaconvert/Vc3InterlaceMode
  (s/spec string? :gen #(s/gen #{"PROGRESSIVE" "INTERLACED"})))

(s/def
  :cognitect.aws.mediaconvert/DescribeEndpointsMode
  (s/spec string? :gen #(s/gen #{"GET_ONLY" "DEFAULT"})))

(s/def :cognitect.aws.mediaconvert/Vc3Telecine (s/spec string? :gen #(s/gen #{"HARD" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/CmafImageBasedTrickPlaySettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/IntervalCadence
     :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/ThumbnailInterval
     :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/ThumbnailWidth
     :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/TileWidth
     :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/TileHeight
     :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/ThumbnailHeight]))

(s/def
  :cognitect.aws.mediaconvert/H264DynamicSubGop
  (s/spec string? :gen #(s/gen #{"ADAPTIVE" "STATIC"})))

(s/def
  :cognitect.aws.mediaconvert/SccDestinationSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.SccDestinationSettings/Framerate]))

(s/def :cognitect.aws.mediaconvert/Type (s/spec string? :gen #(s/gen #{"SYSTEM" "CUSTOM"})))

(s/def
  :cognitect.aws.mediaconvert/EsamSignalProcessingNotification
  (s/keys :opt-un [:cognitect.aws.mediaconvert.EsamSignalProcessingNotification/SccXml]))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Mpeg2Settings/RateControlMode
     :cognitect.aws.mediaconvert.Mpeg2Settings/InterlaceMode
     :cognitect.aws.mediaconvert.Mpeg2Settings/MinIInterval
     :cognitect.aws.mediaconvert.Mpeg2Settings/ParDenominator
     :cognitect.aws.mediaconvert.Mpeg2Settings/ScanTypeConversionMode
     :cognitect.aws.mediaconvert.Mpeg2Settings/QualityTuningLevel
     :cognitect.aws.mediaconvert.Mpeg2Settings/AdaptiveQuantization
     :cognitect.aws.mediaconvert.Mpeg2Settings/FramerateDenominator
     :cognitect.aws.mediaconvert.Mpeg2Settings/HrdBufferFinalFillPercentage
     :cognitect.aws.mediaconvert.Mpeg2Settings/FramerateControl
     :cognitect.aws.mediaconvert.Mpeg2Settings/HrdBufferSize
     :cognitect.aws.mediaconvert.Mpeg2Settings/SlowPal
     :cognitect.aws.mediaconvert.Mpeg2Settings/DynamicSubGop
     :cognitect.aws.mediaconvert.Mpeg2Settings/NumberBFramesBetweenReferenceFrames
     :cognitect.aws.mediaconvert.Mpeg2Settings/IntraDcPrecision
     :cognitect.aws.mediaconvert.Mpeg2Settings/Syntax
     :cognitect.aws.mediaconvert.Mpeg2Settings/GopClosedCadence
     :cognitect.aws.mediaconvert.Mpeg2Settings/SpatialAdaptiveQuantization
     :cognitect.aws.mediaconvert.Mpeg2Settings/FramerateNumerator
     :cognitect.aws.mediaconvert.Mpeg2Settings/Softness
     :cognitect.aws.mediaconvert.Mpeg2Settings/GopSizeUnits
     :cognitect.aws.mediaconvert.Mpeg2Settings/MaxBitrate
     :cognitect.aws.mediaconvert.Mpeg2Settings/CodecProfile
     :cognitect.aws.mediaconvert.Mpeg2Settings/ParNumerator
     :cognitect.aws.mediaconvert.Mpeg2Settings/GopSize
     :cognitect.aws.mediaconvert.Mpeg2Settings/ParControl
     :cognitect.aws.mediaconvert.Mpeg2Settings/CodecLevel
     :cognitect.aws.mediaconvert.Mpeg2Settings/Telecine
     :cognitect.aws.mediaconvert.Mpeg2Settings/HrdBufferInitialFillPercentage
     :cognitect.aws.mediaconvert.Mpeg2Settings/TemporalAdaptiveQuantization
     :cognitect.aws.mediaconvert.Mpeg2Settings/FramerateConversionAlgorithm
     :cognitect.aws.mediaconvert.Mpeg2Settings/SceneChangeDetect
     :cognitect.aws.mediaconvert.Mpeg2Settings/Bitrate]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin2Max2147483647
  (s/spec (s/and int? #(<= 2 % 2147483647)) :gen #(gen/choose 2 2147483647)))

(s/def
  :cognitect.aws.mediaconvert/Ac3BitstreamMode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"COMPLETE_MAIN"
        "DIALOGUE"
        "VISUALLY_IMPAIRED"
        "EMERGENCY"
        "COMMENTARY"
        "MUSIC_AND_EFFECTS"
        "VOICE_OVER"
        "HEARING_IMPAIRED"})))

(s/def
  :cognitect.aws.mediaconvert/UncompressedFramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/Hdr10Metadata
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Hdr10Metadata/MinLuminance
     :cognitect.aws.mediaconvert.Hdr10Metadata/BluePrimaryX
     :cognitect.aws.mediaconvert.Hdr10Metadata/GreenPrimaryX
     :cognitect.aws.mediaconvert.Hdr10Metadata/MaxLuminance
     :cognitect.aws.mediaconvert.Hdr10Metadata/MaxFrameAverageLightLevel
     :cognitect.aws.mediaconvert.Hdr10Metadata/GreenPrimaryY
     :cognitect.aws.mediaconvert.Hdr10Metadata/MaxContentLightLevel
     :cognitect.aws.mediaconvert.Hdr10Metadata/WhitePointX
     :cognitect.aws.mediaconvert.Hdr10Metadata/RedPrimaryX
     :cognitect.aws.mediaconvert.Hdr10Metadata/WhitePointY
     :cognitect.aws.mediaconvert.Hdr10Metadata/BluePrimaryY
     :cognitect.aws.mediaconvert.Hdr10Metadata/RedPrimaryY]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max1
  (s/spec (s/and int? #(<= 0 % 1)) :gen #(gen/choose 0 1)))

(s/def
  :cognitect.aws.mediaconvert/AdvancedInputFilterSharpen
  (s/spec string? :gen #(s/gen #{"LOW" "HIGH" "OFF"})))

(s/def
  :cognitect.aws.mediaconvert/ListJobTemplatesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListJobTemplatesRequest/Order
     :cognitect.aws.mediaconvert.ListJobTemplatesRequest/Category
     :cognitect.aws.mediaconvert.ListJobTemplatesRequest/ListBy
     :cognitect.aws.mediaconvert.ListJobTemplatesRequest/NextToken
     :cognitect.aws.mediaconvert.ListJobTemplatesRequest/MaxResults]))

(s/def
  :cognitect.aws.mediaconvert/CmfcTimedMetadataBoxVersion
  (s/spec string? :gen #(s/gen #{"VERSION_0" "VERSION_1"})))

(s/def
  :cognitect.aws.mediaconvert/VideoOverlayTransition
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VideoOverlayTransition/StartTimecode
     :cognitect.aws.mediaconvert.VideoOverlayTransition/EndPosition
     :cognitect.aws.mediaconvert.VideoOverlayTransition/EndTimecode]))

(s/def
  :cognitect.aws.mediaconvert/__listOfMsSmoothAdditionalManifest
  (s/coll-of :cognitect.aws.mediaconvert/MsSmoothAdditionalManifest))

(s/def
  :cognitect.aws.mediaconvert/UncompressedScanTypeConversionMode
  (s/spec string? :gen #(s/gen #{"INTERLACED_OPTIMIZE" "INTERLACED"})))

(s/def
  :cognitect.aws.mediaconvert/M2tsSegmentationMarkers
  (s/spec
    string?
    :gen
    #(s/gen #{"PSI_SEGSTART" "RAI_SEGSTART" "RAI_ADAPT" "NONE" "EBP_LEGACY" "EBP"})))

(s/def
  :cognitect.aws.mediaconvert/ChromaPositionMode
  (s/spec string? :gen #(s/gen #{"AUTO" "FORCE_TOP_LEFT" "FORCE_CENTER"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max4194303
  (s/spec (s/and int? #(<= 0 % 4194303)) :gen #(gen/choose 0 4194303)))

(s/def
  :cognitect.aws.mediaconvert/ReservationPlan
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ReservationPlan/Commitment
     :cognitect.aws.mediaconvert.ReservationPlan/PurchasedAt
     :cognitect.aws.mediaconvert.ReservationPlan/RenewalType
     :cognitect.aws.mediaconvert.ReservationPlan/Status
     :cognitect.aws.mediaconvert.ReservationPlan/ReservedSlots
     :cognitect.aws.mediaconvert.ReservationPlan/ExpiresAt]))

(s/def
  :cognitect.aws.mediaconvert/H264TemporalAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/DvbSubtitleApplyFontColor
  (s/spec string? :gen #(s/gen #{"WHITE_TEXT_ONLY" "ALL_TEXT"})))

(s/def
  :cognitect.aws.mediaconvert/ContainerType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MOV" "MP4" "Y4M" "F4V" "ISMV" "MXF" "MPD" "OGG" "RAW" "WEBM" "M3U8" "GIF" "CMFC" "M2TS"})))

(s/def
  :cognitect.aws.mediaconvert/__listOfAudioChannelTag
  (s/coll-of :cognitect.aws.mediaconvert/AudioChannelTag))

(s/def
  :cognitect.aws.mediaconvert/SrtDestinationSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.SrtDestinationSettings/StylePassthrough]))

(s/def
  :cognitect.aws.mediaconvert/S3ServerSideEncryptionType
  (s/spec string? :gen #(s/gen #{"SERVER_SIDE_ENCRYPTION_KMS" "SERVER_SIDE_ENCRYPTION_S3"})))

(s/def
  :cognitect.aws.mediaconvert/H264SaliencyAwareEncoding
  (s/spec string? :gen #(s/gen #{"DISABLED" "PREFERRED"})))

(s/def
  :cognitect.aws.mediaconvert/TtmlDestinationSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.TtmlDestinationSettings/StylePassthrough]))

(s/def
  :cognitect.aws.mediaconvert/DashIsoMpdProfile
  (s/spec string? :gen #(s/gen #{"MAIN_PROFILE" "ON_DEMAND_PROFILE"})))

(s/def
  :cognitect.aws.mediaconvert/DvbSubtitleTeletextSpacing
  (s/spec string? :gen #(s/gen #{"AUTO" "FIXED_GRID" "PROPORTIONAL"})))

(s/def
  :cognitect.aws.mediaconvert/HlsOutputSelection
  (s/spec string? :gen #(s/gen #{"MANIFESTS_AND_SEGMENTS" "SEGMENTS_ONLY"})))

(s/def
  :cognitect.aws.mediaconvert/H264SpatialAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/AvcIntraScanTypeConversionMode
  (s/spec string? :gen #(s/gen #{"INTERLACED_OPTIMIZE" "INTERLACED"})))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2QualityTuningLevel
  (s/spec string? :gen #(s/gen #{"SINGLE_PASS" "MULTI_PASS"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max10000
  (s/spec (s/and int? #(<= 0 % 10000)) :gen #(gen/choose 0 10000)))

(s/def :cognitect.aws.mediaconvert/DeletePolicyRequest (s/keys))

(s/def
  :cognitect.aws.mediaconvert/MpdAccessibilityCaptionHints
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def :cognitect.aws.mediaconvert/__timestampIso8601 inst?)

(s/def
  :cognitect.aws.mediaconvert/AncillaryConvert608To708
  (s/spec string? :gen #(s/gen #{"DISABLED" "UPCONVERT"})))

(s/def
  :cognitect.aws.mediaconvert/TimecodeBurnin
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.TimecodeBurnin/Prefix
     :cognitect.aws.mediaconvert.TimecodeBurnin/Position
     :cognitect.aws.mediaconvert.TimecodeBurnin/FontSize]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin8Max12
  (s/spec (s/and int? #(<= 8 % 12)) :gen #(gen/choose 8 12)))

(s/def
  :cognitect.aws.mediaconvert/JobMessages
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.JobMessages/Info :cognitect.aws.mediaconvert.JobMessages/Warning]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max10
  (s/spec (s/and int? #(<= 0 % 10)) :gen #(gen/choose 0 10)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max4000
  (s/spec (s/and int? #(<= 0 % 4000)) :gen #(gen/choose 0 4000)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max15
  (s/spec (s/and int? #(<= 0 % 15)) :gen #(gen/choose 0 15)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max65535
  (s/spec (s/and int? #(<= 0 % 65535)) :gen #(gen/choose 0 65535)))

(s/def
  :cognitect.aws.mediaconvert/GetJobTemplateResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.GetJobTemplateResponse/JobTemplate]))

(s/def
  :cognitect.aws.mediaconvert/H265Deblocking
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/MsSmoothAudioDeduplication
  (s/spec string? :gen #(s/gen #{"NONE" "COMBINE_DUPLICATE_STREAMS"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMax2048
  (s/spec
    (s/and string? #(>= 2048 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.mediaconvert/__listOfCmafAdditionalManifest
  (s/coll-of :cognitect.aws.mediaconvert/CmafAdditionalManifest))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternSNManifestConfirmConditionNotificationNS
  (s/spec
    #(re-matches (re-pattern "^\\s*<(.|\\n)*ManifestConfirmConditionNotification(.|\\n)*>\\s*$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosDialogueIntelligence
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/CmafTargetDurationCompatibilityMode
  (s/spec string? :gen #(s/gen #{"LEGACY" "SPEC_COMPLIANT"})))

(s/def
  :cognitect.aws.mediaconvert/ReservationPlanSettings
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.ReservationPlanSettings/Commitment
     :cognitect.aws.mediaconvert.ReservationPlanSettings/ReservedSlots
     :cognitect.aws.mediaconvert.ReservationPlanSettings/RenewalType]))

(s/def
  :cognitect.aws.mediaconvert/RuleType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MIN_BOTTOM_RENDITION_SIZE"
        "FORCE_INCLUDE_RENDITIONS"
        "ALLOWED_RENDITIONS"
        "MIN_TOP_RENDITION_SIZE"})))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2GopSizeUnits
  (s/spec string? :gen #(s/gen #{"SECONDS" "FRAMES"})))

(s/def
  :cognitect.aws.mediaconvert/Vc3ScanTypeConversionMode
  (s/spec string? :gen #(s/gen #{"INTERLACED_OPTIMIZE" "INTERLACED"})))

(s/def :cognitect.aws.mediaconvert/M2tsRateMode (s/spec string? :gen #(s/gen #{"VBR" "CBR"})))

(s/def
  :cognitect.aws.mediaconvert/JobPhase
  (s/spec string? :gen #(s/gen #{"UPLOADING" "TRANSCODING" "PROBING"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternHttps
  (s/spec #(re-matches (re-pattern "^https:\\/\\/") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/H264SlowPal
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/M2tsForceTsVideoEbpOrder
  (s/spec string? :gen #(s/gen #{"DEFAULT" "FORCE"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3DynamicRangeCompressionRf
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max99
  (s/spec (s/and int? #(<= 0 % 99)) :gen #(gen/choose 0 99)))

(s/def
  :cognitect.aws.mediaconvert/InputPolicy
  (s/spec string? :gen #(s/gen #{"ALLOWED" "DISALLOWED"})))

(s/def
  :cognitect.aws.mediaconvert/AudioNormalizationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AudioNormalizationSettings/TargetLkfs
     :cognitect.aws.mediaconvert.AudioNormalizationSettings/AlgorithmControl
     :cognitect.aws.mediaconvert.AudioNormalizationSettings/PeakCalculation
     :cognitect.aws.mediaconvert.AudioNormalizationSettings/CorrectionGateLevel
     :cognitect.aws.mediaconvert.AudioNormalizationSettings/Algorithm
     :cognitect.aws.mediaconvert.AudioNormalizationSettings/TruePeakLimiterThreshold
     :cognitect.aws.mediaconvert.AudioNormalizationSettings/LoudnessLogging]))

(s/def
  :cognitect.aws.mediaconvert/AvcIntraInterlaceMode
  (s/spec
    string?
    :gen
    #(s/gen #{"BOTTOM_FIELD" "FOLLOW_TOP_FIELD" "PROGRESSIVE" "FOLLOW_BOTTOM_FIELD" "TOP_FIELD"})))

(s/def
  :cognitect.aws.mediaconvert/AlphaBehavior
  (s/spec string? :gen #(s/gen #{"REMAP_TO_LUMA" "DISCARD"})))

(s/def
  :cognitect.aws.mediaconvert/WebvttStylePassthrough
  (s/spec string? :gen #(s/gen #{"DISABLED" "MERGE" "ENABLED" "STRICT"})))

(s/def
  :cognitect.aws.mediaconvert/DashIsoSegmentLengthControl
  (s/spec string? :gen #(s/gen #{"EXACT" "GOP_MULTIPLE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647
  (s/spec (s/and int? #(<= 1 % 2147483647)) :gen #(gen/choose 1 2147483647)))

(s/def
  :cognitect.aws.mediaconvert/H265CodecProfile
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MAIN_422_10BIT_HIGH"
        "MAIN10_MAIN"
        "MAIN_MAIN"
        "MAIN_422_8BIT_HIGH"
        "MAIN_422_8BIT_MAIN"
        "MAIN_422_10BIT_MAIN"
        "MAIN10_HIGH"
        "MAIN_HIGH"})))

(s/def
  :cognitect.aws.mediaconvert/Vc3Class
  (s/spec string? :gen #(s/gen #{"CLASS_220_10BIT" "CLASS_220_8BIT" "CLASS_145_8BIT"})))

(s/def
  :cognitect.aws.mediaconvert/CmafSegmentLengthControl
  (s/spec string? :gen #(s/gen #{"EXACT" "GOP_MULTIPLE"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternS3TtfHttpsTtf
  (s/spec
    #(re-matches
      (re-pattern
        "^((s3://(.*?)\\.(ttf))|(https?://(.*?)\\.(ttf)(\\?([^&=]+=[^&]+&)*[^&=]+=[^&]+)?))$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max128
  (s/spec (s/and int? #(<= 0 % 128)) :gen #(gen/choose 0 128)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1000Max1466400000
  (s/spec (s/and int? #(<= 1000 % 1466400000)) :gen #(gen/choose 1000 1466400000)))

(s/def
  :cognitect.aws.mediaconvert/FileSourceTimeDeltaUnits
  (s/spec string? :gen #(s/gen #{"SECONDS" "MILLISECONDS"})))

(s/def
  :cognitect.aws.mediaconvert/CopyProtectionAction
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "STRIP"})))

(s/def
  :cognitect.aws.mediaconvert/CmafGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CmafGroupSettings/PtsOffsetHandlingForBFrames
     :cognitect.aws.mediaconvert.CmafGroupSettings/SegmentLength
     :cognitect.aws.mediaconvert.CmafGroupSettings/MinBufferTime
     :cognitect.aws.mediaconvert.CmafGroupSettings/WriteSegmentTimelineInRepresentation
     :cognitect.aws.mediaconvert.CmafGroupSettings/FragmentLength
     :cognitect.aws.mediaconvert.CmafGroupSettings/ImageBasedTrickPlay
     :cognitect.aws.mediaconvert.CmafGroupSettings/SegmentControl
     :cognitect.aws.mediaconvert.CmafGroupSettings/AdditionalManifests
     :cognitect.aws.mediaconvert.CmafGroupSettings/WriteHlsManifest
     :cognitect.aws.mediaconvert.CmafGroupSettings/DashManifestStyle
     :cognitect.aws.mediaconvert.CmafGroupSettings/BaseUrl
     :cognitect.aws.mediaconvert.CmafGroupSettings/SegmentLengthControl
     :cognitect.aws.mediaconvert.CmafGroupSettings/Destination
     :cognitect.aws.mediaconvert.CmafGroupSettings/MinFinalSegmentLength
     :cognitect.aws.mediaconvert.CmafGroupSettings/MpdManifestBandwidthType
     :cognitect.aws.mediaconvert.CmafGroupSettings/DestinationSettings
     :cognitect.aws.mediaconvert.CmafGroupSettings/VideoCompositionOffsets
     :cognitect.aws.mediaconvert.CmafGroupSettings/ImageBasedTrickPlaySettings
     :cognitect.aws.mediaconvert.CmafGroupSettings/StreamInfResolution
     :cognitect.aws.mediaconvert.CmafGroupSettings/MpdProfile
     :cognitect.aws.mediaconvert.CmafGroupSettings/ManifestDurationFormat
     :cognitect.aws.mediaconvert.CmafGroupSettings/WriteDashManifest
     :cognitect.aws.mediaconvert.CmafGroupSettings/ManifestCompression
     :cognitect.aws.mediaconvert.CmafGroupSettings/Encryption
     :cognitect.aws.mediaconvert.CmafGroupSettings/TargetDurationCompatibilityMode
     :cognitect.aws.mediaconvert.CmafGroupSettings/CodecSpecification
     :cognitect.aws.mediaconvert.CmafGroupSettings/DashIFrameTrickPlayNameModifier
     :cognitect.aws.mediaconvert.CmafGroupSettings/ClientCache]))

(s/def
  :cognitect.aws.mediaconvert/Mpeg2SlowPal
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1000Max30000
  (s/spec (s/and int? #(<= 1000 % 30000)) :gen #(gen/choose 1000 30000)))

(s/def
  :cognitect.aws.mediaconvert/BillingTagsSource
  (s/spec string? :gen #(s/gen #{"PRESET" "QUEUE" "JOB" "JOB_TEMPLATE"})))

(s/def
  :cognitect.aws.mediaconvert/H265GopSizeUnits
  (s/spec string? :gen #(s/gen #{"SECONDS" "AUTO" "FRAMES"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternAZaZ0932
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9]{32}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/DeleteJobTemplateRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.DeleteJobTemplateRequest/Name]))

(s/def
  :cognitect.aws.mediaconvert/Av1FilmGrainSynthesis
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__listOf__doubleMinNegative60Max6
  (s/coll-of :cognitect.aws.mediaconvert/__doubleMinNegative60Max6))

(s/def
  :cognitect.aws.mediaconvert/__integerMin100Max1000
  (s/spec (s/and int? #(<= 100 % 1000)) :gen #(gen/choose 100 1000)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max2147483640
  (s/spec (s/and int? #(<= 1 % 2147483640)) :gen #(gen/choose 1 2147483640)))

(s/def
  :cognitect.aws.mediaconvert/AutomatedEncodingSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.AutomatedEncodingSettings/AbrSettings]))

(s/def
  :cognitect.aws.mediaconvert/CancelJobRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.CancelJobRequest/Id]))

(s/def
  :cognitect.aws.mediaconvert/ProresCodecProfile
  (s/spec
    string?
    :gen
    #(s/gen
      #{"APPLE_PRORES_4444_XQ"
        "APPLE_PRORES_422_PROXY"
        "APPLE_PRORES_422_LT"
        "APPLE_PRORES_4444"
        "APPLE_PRORES_422_HQ"
        "APPLE_PRORES_422"})))

(s/def
  :cognitect.aws.mediaconvert/WebvttAccessibilitySubs
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/DashIsoGroupAudioChannelConfigSchemeIdUri
  (s/spec string? :gen #(s/gen #{"DOLBY_CHANNEL_CONFIGURATION" "MPEG_CHANNEL_CONFIGURATION"})))

(s/def
  :cognitect.aws.mediaconvert/XavcHdProfileTelecine
  (s/spec string? :gen #(s/gen #{"HARD" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max65534
  (s/spec (s/and int? #(<= 0 % 65534)) :gen #(gen/choose 0 65534)))

(s/def
  :cognitect.aws.mediaconvert/AudioNormalizationPeakCalculation
  (s/spec string? :gen #(s/gen #{"TRUE_PEAK" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/DashIsoImageBasedTrickPlaySettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/IntervalCadence
     :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/ThumbnailInterval
     :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/ThumbnailWidth
     :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/TileWidth
     :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/TileHeight
     :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/ThumbnailHeight]))

(s/def
  :cognitect.aws.mediaconvert/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.ListTagsForResourceResponse/ResourceTags]))

(s/def
  :cognitect.aws.mediaconvert/TtmlStylePassthrough
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/M2tsScte35Source
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def :cognitect.aws.mediaconvert/H265Tiles (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/H265CodecLevel
  (s/spec
    string?
    :gen
    #(s/gen
      #{"LEVEL_2_1"
        "LEVEL_5"
        "LEVEL_1"
        "AUTO"
        "LEVEL_4_1"
        "LEVEL_5_1"
        "LEVEL_5_2"
        "LEVEL_4"
        "LEVEL_2"
        "LEVEL_3"
        "LEVEL_6_2"
        "LEVEL_6"
        "LEVEL_6_1"
        "LEVEL_3_1"})))

(s/def
  :cognitect.aws.mediaconvert/CmfcManifestMetadataSignaling
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def :cognitect.aws.mediaconvert/__listOfPreset (s/coll-of :cognitect.aws.mediaconvert/Preset))

(s/def
  :cognitect.aws.mediaconvert/__doubleMin0
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.mediaconvert/BandwidthReductionFilter
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.BandwidthReductionFilter/Sharpening
     :cognitect.aws.mediaconvert.BandwidthReductionFilter/Strength]))

(s/def
  :cognitect.aws.mediaconvert/AudioLanguageCodeControl
  (s/spec string? :gen #(s/gen #{"FOLLOW_INPUT" "USE_CONFIGURED"})))

(s/def
  :cognitect.aws.mediaconvert/CmfcScte35Source
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/ClipLimits
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ClipLimits/MaximumRGBTolerance
     :cognitect.aws.mediaconvert.ClipLimits/MinimumRGBTolerance
     :cognitect.aws.mediaconvert.ClipLimits/MaximumYUV
     :cognitect.aws.mediaconvert.ClipLimits/MinimumYUV]))

(s/def
  :cognitect.aws.mediaconvert/InputDecryptionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.InputDecryptionSettings/InitializationVector
     :cognitect.aws.mediaconvert.InputDecryptionSettings/EncryptedDecryptionKey
     :cognitect.aws.mediaconvert.InputDecryptionSettings/DecryptionMode
     :cognitect.aws.mediaconvert.InputDecryptionSettings/KmsKeyRegion]))

(s/def
  :cognitect.aws.mediaconvert/H264SceneChangeDetect
  (s/spec string? :gen #(s/gen #{"DISABLED" "TRANSITION_DETECTION" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/Xavc4kProfileBitrateClass
  (s/spec string? :gen #(s/gen #{"BITRATE_CLASS_100" "BITRATE_CLASS_140" "BITRATE_CLASS_200"})))

(s/def
  :cognitect.aws.mediaconvert/ProresInterlaceMode
  (s/spec
    string?
    :gen
    #(s/gen #{"BOTTOM_FIELD" "FOLLOW_TOP_FIELD" "PROGRESSIVE" "FOLLOW_BOTTOM_FIELD" "TOP_FIELD"})))

(s/def
  :cognitect.aws.mediaconvert/ResourceTags
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ResourceTags/Tags :cognitect.aws.mediaconvert.ResourceTags/Arn]))

(s/def
  :cognitect.aws.mediaconvert/Eac3BitstreamMode
  (s/spec
    string?
    :gen
    #(s/gen #{"COMPLETE_MAIN" "VISUALLY_IMPAIRED" "EMERGENCY" "COMMENTARY" "HEARING_IMPAIRED"})))

(s/def
  :cognitect.aws.mediaconvert/HlsRenditionGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.HlsRenditionGroupSettings/RenditionName
     :cognitect.aws.mediaconvert.HlsRenditionGroupSettings/RenditionLanguageCode
     :cognitect.aws.mediaconvert.HlsRenditionGroupSettings/RenditionGroupId]))

(s/def
  :cognitect.aws.mediaconvert/__integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.mediaconvert/ImageInserter
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ImageInserter/InsertableImages
     :cognitect.aws.mediaconvert.ImageInserter/SdrReferenceWhiteLevel]))

(s/def
  :cognitect.aws.mediaconvert/GetPresetRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.GetPresetRequest/Name]))

(s/def
  :cognitect.aws.mediaconvert/H264FieldEncoding
  (s/spec string? :gen #(s/gen #{"MBAFF" "FORCE_FIELD" "PAFF"})))

(s/def
  :cognitect.aws.mediaconvert/HopDestination
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.HopDestination/Queue
     :cognitect.aws.mediaconvert.HopDestination/Priority
     :cognitect.aws.mediaconvert.HopDestination/WaitMinutes]))

(s/def
  :cognitect.aws.mediaconvert/AfdSignaling
  (s/spec string? :gen #(s/gen #{"AUTO" "FIXED" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__listOf__string
  (s/coll-of :cognitect.aws.mediaconvert/__string))

(s/def
  :cognitect.aws.mediaconvert/UpdatePresetRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediaconvert.UpdatePresetRequest/Name]
    :opt-un
    [:cognitect.aws.mediaconvert.UpdatePresetRequest/Category
     :cognitect.aws.mediaconvert.UpdatePresetRequest/Description
     :cognitect.aws.mediaconvert.UpdatePresetRequest/Settings]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin384000Max1024000
  (s/spec (s/and int? #(<= 384000 % 1024000)) :gen #(gen/choose 384000 1024000)))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max6
  (s/spec (s/and int? #(<= 1 % 6)) :gen #(gen/choose 1 6)))

(s/def
  :cognitect.aws.mediaconvert/UpdateJobTemplateResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.UpdateJobTemplateResponse/JobTemplate]))

(s/def
  :cognitect.aws.mediaconvert/WavSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.WavSettings/SampleRate
     :cognitect.aws.mediaconvert.WavSettings/Format
     :cognitect.aws.mediaconvert.WavSettings/BitDepth
     :cognitect.aws.mediaconvert.WavSettings/Channels]))

(s/def
  :cognitect.aws.mediaconvert/Eac3AttenuationControl
  (s/spec string? :gen #(s/gen #{"ATTENUATE_3_DB" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin1Max60000
  (s/spec (s/and int? #(<= 1 % 60000)) :gen #(gen/choose 1 60000)))

(s/def
  :cognitect.aws.mediaconvert/TooManyRequestsException
  (s/keys :opt-un [:cognitect.aws.mediaconvert.TooManyRequestsException/Message]))

(s/def
  :cognitect.aws.mediaconvert/LanguageCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"VIE"
        "ZUL"
        "COR"
        "URD"
        "EPO"
        "MAR"
        "SRB"
        "TAM"
        "TAH"
        "LIM"
        "SMO"
        "POL"
        "JAV"
        "BEL"
        "AAR"
        "KAU"
        "SQI"
        "III"
        "AVA"
        "LUB"
        "SWE"
        "POR"
        "AYM"
        "NBL"
        "FIN"
        "HEB"
        "SNA"
        "PLI"
        "RON"
        "ABK"
        "CYM"
        "LAV"
        "AMH"
        "IDO"
        "FRY"
        "IPK"
        "VOL"
        "HAT"
        "KOM"
        "IBO"
        "MAH"
        "ARG"
        "KIK"
        "BEN"
        "AVE"
        "GER"
        "ORJ"
        "FUL"
        "KUR"
        "KUA"
        "NYA"
        "CHA"
        "NOB"
        "DEU"
        "SUN"
        "MKD"
        "HRV"
        "XHO"
        "HUN"
        "LUG"
        "KAS"
        "IND"
        "KON"
        "ILE"
        "NDE"
        "TGL"
        "LAT"
        "SRP"
        "TWI"
        "EUS"
        "UKR"
        "HMO"
        "BRE"
        "KAL"
        "ELL"
        "LIN"
        "NAU"
        "MLT"
        "SME"
        "KHM"
        "HIN"
        "FRA"
        "MRI"
        "SLK"
        "THA"
        "AFR"
        "AZE"
        "KAT"
        "EWE"
        "TSN"
        "ZHO"
        "OSS"
        "ORM"
        "SSW"
        "GUJ"
        "EST"
        "KIR"
        "QUE"
        "COS"
        "TUK"
        "KOR"
        "FIJ"
        "KAZ"
        "MYA"
        "AKA"
        "TGK"
        "ITA"
        "MON"
        "KAN"
        "RUS"
        "YID"
        "NLD"
        "TAT"
        "MSA"
        "DIV"
        "YOR"
        "MAL"
        "NNO"
        "FAS"
        "SAG"
        "SOM"
        "BAM"
        "TON"
        "CHV"
        "GLE"
        "SLV"
        "TEL"
        "ARA"
        "ISL"
        "SOT"
        "BIH"
        "JPN"
        "TUR"
        "BAK"
        "VEN"
        "FRM"
        "CES"
        "NAV"
        "GLG"
        "IKU"
        "TIR"
        "SAN"
        "SIN"
        "WOL"
        "ORI"
        "ASM"
        "DZO"
        "CRE"
        "BOD"
        "ENG"
        "BUL"
        "BOS"
        "KIN"
        "GRN"
        "QAA"
        "PAN"
        "BIS"
        "PUS"
        "MLG"
        "QPC"
        "HAU"
        "WLN"
        "LIT"
        "HYE"
        "LTZ"
        "CHU"
        "SWA"
        "HER"
        "DAN"
        "TNG"
        "SRD"
        "RUN"
        "UZB"
        "OJI"
        "ZHA"
        "SND"
        "TSO"
        "CHE"
        "OCI"
        "ROH"
        "NEP"
        "GLV"
        "CAT"
        "ENM"
        "FAO"
        "GLA"
        "UIG"
        "NDO"
        "SPA"
        "LAO"
        "NOR"
        "INA"})))

(s/def
  :cognitect.aws.mediaconvert/HlsManifestCompression
  (s/spec string? :gen #(s/gen #{"GZIP" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/XavcFlickerAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__integerMin8000Max192000
  (s/spec (s/and int? #(<= 8000 % 192000)) :gen #(gen/choose 8000 192000)))

(s/def
  :cognitect.aws.mediaconvert/Ac3Settings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Ac3Settings/CodingMode
     :cognitect.aws.mediaconvert.Ac3Settings/SampleRate
     :cognitect.aws.mediaconvert.Ac3Settings/DynamicRangeCompressionLine
     :cognitect.aws.mediaconvert.Ac3Settings/LfeFilter
     :cognitect.aws.mediaconvert.Ac3Settings/DynamicRangeCompressionProfile
     :cognitect.aws.mediaconvert.Ac3Settings/MetadataControl
     :cognitect.aws.mediaconvert.Ac3Settings/BitstreamMode
     :cognitect.aws.mediaconvert.Ac3Settings/Dialnorm
     :cognitect.aws.mediaconvert.Ac3Settings/DynamicRangeCompressionRf
     :cognitect.aws.mediaconvert.Ac3Settings/Bitrate]))

(s/def
  :cognitect.aws.mediaconvert/NoiseReducerSpatialFilterSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.NoiseReducerSpatialFilterSettings/Speed
     :cognitect.aws.mediaconvert.NoiseReducerSpatialFilterSettings/PostFilterSharpenStrength
     :cognitect.aws.mediaconvert.NoiseReducerSpatialFilterSettings/Strength]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin6000Max1024000
  (s/spec (s/and int? #(<= 6000 % 1024000)) :gen #(gen/choose 6000 1024000)))

(s/def
  :cognitect.aws.mediaconvert/HlsAudioTrackType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT"
        "ALTERNATE_AUDIO_AUTO_SELECT"
        "ALTERNATE_AUDIO_NOT_AUTO_SELECT"
        "AUDIO_ONLY_VARIANT_STREAM"})))

(s/def
  :cognitect.aws.mediaconvert/Vp9ParControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/DvbNitSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DvbNitSettings/NetworkId
     :cognitect.aws.mediaconvert.DvbNitSettings/NitInterval
     :cognitect.aws.mediaconvert.DvbNitSettings/NetworkName]))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosDynamicRangeCompressionRf
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def :cognitect.aws.mediaconvert/GetPolicyRequest (s/keys))

(s/def
  :cognitect.aws.mediaconvert/__listOfVideoOverlayTransition
  (s/coll-of :cognitect.aws.mediaconvert/VideoOverlayTransition))

(s/def
  :cognitect.aws.mediaconvert/ListJobTemplatesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.ListJobTemplatesResponse/NextToken
     :cognitect.aws.mediaconvert.ListJobTemplatesResponse/JobTemplates]))

(s/def
  :cognitect.aws.mediaconvert/__stringMin14PatternS3BmpBMPPngPNGHttpsBmpBMPPngPNG
  (s/spec
    #(re-matches
      (re-pattern
        "^((s3://(.*?)\\.(bmp|BMP|png|PNG))|(https?://(.*?)\\.(bmp|BMP|png|PNG)(\\?([^&=]+=[^&]+&)*[^&=]+=[^&]+)?))$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/H264InterlaceMode
  (s/spec
    string?
    :gen
    #(s/gen #{"BOTTOM_FIELD" "FOLLOW_TOP_FIELD" "PROGRESSIVE" "FOLLOW_BOTTOM_FIELD" "TOP_FIELD"})))

(s/def
  :cognitect.aws.mediaconvert/WebvttHlsSourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.WebvttHlsSourceSettings/RenditionName
     :cognitect.aws.mediaconvert.WebvttHlsSourceSettings/RenditionLanguageCode
     :cognitect.aws.mediaconvert.WebvttHlsSourceSettings/RenditionGroupId]))

(s/def
  :cognitect.aws.mediaconvert/InputTimecodeSource
  (s/spec string? :gen #(s/gen #{"ZEROBASED" "EMBEDDED" "SPECIFIEDSTART"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosStereoDownmix
  (s/spec string? :gen #(s/gen #{"STEREO" "NOT_INDICATED" "DPL2" "SURROUND"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin14PatternS3BmpBMPPngPNGTgaTGAHttpsBmpBMPPngPNGTgaTGA
  (s/spec
    #(re-matches
      (re-pattern
        "^((s3://(.*?)\\.(bmp|BMP|png|PNG|tga|TGA))|(https?://(.*?)\\.(bmp|BMP|png|PNG|tga|TGA)(\\?([^&=]+=[^&]+&)*[^&=]+=[^&]+)?))$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/OutputDetail
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.OutputDetail/DurationInMs
     :cognitect.aws.mediaconvert.OutputDetail/VideoDetails]))

(s/def
  :cognitect.aws.mediaconvert/__listOfHlsCaptionLanguageMapping
  (s/coll-of :cognitect.aws.mediaconvert/HlsCaptionLanguageMapping))

(s/def
  :cognitect.aws.mediaconvert/CmfcDescriptiveVideoServiceFlag
  (s/spec string? :gen #(s/gen #{"DONT_FLAG" "FLAG"})))

(s/def
  :cognitect.aws.mediaconvert/TimedMetadata
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/VorbisSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.VorbisSettings/SampleRate
     :cognitect.aws.mediaconvert.VorbisSettings/VbrQuality
     :cognitect.aws.mediaconvert.VorbisSettings/Channels]))

(s/def
  :cognitect.aws.mediaconvert/MpdCaptionContainerType
  (s/spec string? :gen #(s/gen #{"FRAGMENTED_MP4" "RAW"})))

(s/def
  :cognitect.aws.mediaconvert/__stringMin1Max100000
  (s/spec
    (s/and string? #(<= 1 (count %) 100000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.mediaconvert/CreateJobResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.CreateJobResponse/Job]))

(s/def
  :cognitect.aws.mediaconvert/PutPolicyResponse
  (s/keys :opt-un [:cognitect.aws.mediaconvert.PutPolicyResponse/Policy]))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Eac3AtmosSettings/LtRtSurroundMixLevel
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/CodingMode
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/SampleRate
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/DynamicRangeCompressionLine
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/DialogueIntelligence
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/LoRoCenterMixLevel
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/DynamicRangeControl
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/StereoDownmix
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/LtRtCenterMixLevel
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/SurroundExMode
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/DownmixControl
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/LoRoSurroundMixLevel
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/BitstreamMode
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/DynamicRangeCompressionRf
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/SpeechThreshold
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/Bitrate
     :cognitect.aws.mediaconvert.Eac3AtmosSettings/MeteringMode]))

(s/def
  :cognitect.aws.mediaconvert/EmbeddedTerminateCaptions
  (s/spec string? :gen #(s/gen #{"DISABLED" "END_OF_INPUT"})))

(s/def
  :cognitect.aws.mediaconvert/MotionImageInsertionFramerate
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.MotionImageInsertionFramerate/FramerateDenominator
     :cognitect.aws.mediaconvert.MotionImageInsertionFramerate/FramerateNumerator]))

(s/def
  :cognitect.aws.mediaconvert/__stringMin1Max2048PatternArnAZSecretsmanagerWD12SecretAZAZ09
  (s/spec
    #(re-matches
      (re-pattern "^(arn:[a-z-]+:secretsmanager:[\\w-]+:\\d{12}:secret:)?[a-zA-Z0-9_\\/_+=.@-]*$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/__stringMin1Max50PatternAZAZ09
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_\\/_+=.@-]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/AacVbrQuality
  (s/spec string? :gen #(s/gen #{"LOW" "MEDIUM_LOW" "HIGH" "MEDIUM_HIGH"})))

(s/def
  :cognitect.aws.mediaconvert/H264FlickerAdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092
  (s/spec
    #(re-matches (re-pattern "^([01][0-9]|2[0-4]):[0-5][0-9]:[0-5][0-9][:;][0-9]{2}$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/CmafKeyProviderType
  (s/spec string? :gen #(s/gen #{"SPEKE" "STATIC_KEY"})))

(s/def
  :cognitect.aws.mediaconvert/ProresScanTypeConversionMode
  (s/spec string? :gen #(s/gen #{"INTERLACED_OPTIMIZE" "INTERLACED"})))

(s/def
  :cognitect.aws.mediaconvert/CmafSegmentControl
  (s/spec string? :gen #(s/gen #{"SINGLE_FILE" "SEGMENTED_FILES"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternIdentityAZaZ26AZaZ09163
  (s/spec
    #(re-matches (re-pattern "^(identity|[A-Za-z]{2,6}(\\.[A-Za-z0-9-]{1,63})+)$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/H264QvbrSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.H264QvbrSettings/QvbrQualityLevelFineTune
     :cognitect.aws.mediaconvert.H264QvbrSettings/QvbrQualityLevel
     :cognitect.aws.mediaconvert.H264QvbrSettings/MaxAverageBitrate]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max8
  (s/spec (s/and int? #(<= 0 % 8)) :gen #(gen/choose 0 8)))

(s/def
  :cognitect.aws.mediaconvert/GetQueueRequest
  (s/keys :req-un [:cognitect.aws.mediaconvert.GetQueueRequest/Name]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max9
  (s/spec (s/and int? #(<= 0 % 9)) :gen #(gen/choose 0 9)))

(s/def
  :cognitect.aws.mediaconvert/H264CodecProfile
  (s/spec
    string?
    :gen
    #(s/gen #{"HIGH_422" "BASELINE" "MAIN" "HIGH_10BIT" "HIGH" "HIGH_422_10BIT"})))

(s/def
  :cognitect.aws.mediaconvert/TimecodeConfig
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.TimecodeConfig/Source
     :cognitect.aws.mediaconvert.TimecodeConfig/Start
     :cognitect.aws.mediaconvert.TimecodeConfig/Anchor
     :cognitect.aws.mediaconvert.TimecodeConfig/TimestampOffset]))

(s/def
  :cognitect.aws.mediaconvert/Policy
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Policy/S3Inputs
     :cognitect.aws.mediaconvert.Policy/HttpsInputs
     :cognitect.aws.mediaconvert.Policy/HttpInputs]))

(s/def
  :cognitect.aws.mediaconvert/Vp8FramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def
  :cognitect.aws.mediaconvert/OutputSettings
  (s/keys :opt-un [:cognitect.aws.mediaconvert.OutputSettings/HlsSettings]))

(s/def
  :cognitect.aws.mediaconvert/BurninDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.BurninDestinationSettings/FontFileBold
     :cognitect.aws.mediaconvert.BurninDestinationSettings/TeletextSpacing
     :cognitect.aws.mediaconvert.BurninDestinationSettings/OutlineColor
     :cognitect.aws.mediaconvert.BurninDestinationSettings/FontScript
     :cognitect.aws.mediaconvert.BurninDestinationSettings/OutlineSize
     :cognitect.aws.mediaconvert.BurninDestinationSettings/RemoveRubyReserveAttributes
     :cognitect.aws.mediaconvert.BurninDestinationSettings/HexFontColor
     :cognitect.aws.mediaconvert.BurninDestinationSettings/ShadowColor
     :cognitect.aws.mediaconvert.BurninDestinationSettings/ShadowOpacity
     :cognitect.aws.mediaconvert.BurninDestinationSettings/ShadowYOffset
     :cognitect.aws.mediaconvert.BurninDestinationSettings/FallbackFont
     :cognitect.aws.mediaconvert.BurninDestinationSettings/BackgroundColor
     :cognitect.aws.mediaconvert.BurninDestinationSettings/FontFileBoldItalic
     :cognitect.aws.mediaconvert.BurninDestinationSettings/ApplyFontColor
     :cognitect.aws.mediaconvert.BurninDestinationSettings/YPosition
     :cognitect.aws.mediaconvert.BurninDestinationSettings/FontColor
     :cognitect.aws.mediaconvert.BurninDestinationSettings/XPosition
     :cognitect.aws.mediaconvert.BurninDestinationSettings/FontFileRegular
     :cognitect.aws.mediaconvert.BurninDestinationSettings/FontResolution
     :cognitect.aws.mediaconvert.BurninDestinationSettings/FontSize
     :cognitect.aws.mediaconvert.BurninDestinationSettings/BackgroundOpacity
     :cognitect.aws.mediaconvert.BurninDestinationSettings/FontOpacity
     :cognitect.aws.mediaconvert.BurninDestinationSettings/StylePassthrough
     :cognitect.aws.mediaconvert.BurninDestinationSettings/ShadowXOffset
     :cognitect.aws.mediaconvert.BurninDestinationSettings/Alignment
     :cognitect.aws.mediaconvert.BurninDestinationSettings/FontFileItalic]))

(s/def
  :cognitect.aws.mediaconvert/EsamManifestConfirmConditionNotification
  (s/keys :opt-un [:cognitect.aws.mediaconvert.EsamManifestConfirmConditionNotification/MccXml]))

(s/def
  :cognitect.aws.mediaconvert/UncompressedSlowPal
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.mediaconvert/Deinterlacer
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.Deinterlacer/Control
     :cognitect.aws.mediaconvert.Deinterlacer/Mode
     :cognitect.aws.mediaconvert.Deinterlacer/Algorithm]))

(s/def
  :cognitect.aws.mediaconvert/EmbeddedConvert608To708
  (s/spec string? :gen #(s/gen #{"DISABLED" "UPCONVERT"})))

(s/def
  :cognitect.aws.mediaconvert/ConflictException
  (s/keys :opt-un [:cognitect.aws.mediaconvert.ConflictException/Message]))

(s/def
  :cognitect.aws.mediaconvert/__integerMin0Max1000
  (s/spec (s/and int? #(<= 0 % 1000)) :gen #(gen/choose 0 1000)))

(s/def
  :cognitect.aws.mediaconvert/DolbyVisionLevel6Metadata
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.DolbyVisionLevel6Metadata/MaxFall
     :cognitect.aws.mediaconvert.DolbyVisionLevel6Metadata/MaxCll]))

(s/def
  :cognitect.aws.mediaconvert/AudioCodecSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AudioCodecSettings/Codec
     :cognitect.aws.mediaconvert.AudioCodecSettings/Eac3Settings
     :cognitect.aws.mediaconvert.AudioCodecSettings/AiffSettings
     :cognitect.aws.mediaconvert.AudioCodecSettings/OpusSettings
     :cognitect.aws.mediaconvert.AudioCodecSettings/FlacSettings
     :cognitect.aws.mediaconvert.AudioCodecSettings/Mp2Settings
     :cognitect.aws.mediaconvert.AudioCodecSettings/Mp3Settings
     :cognitect.aws.mediaconvert.AudioCodecSettings/Eac3AtmosSettings
     :cognitect.aws.mediaconvert.AudioCodecSettings/Ac3Settings
     :cognitect.aws.mediaconvert.AudioCodecSettings/AacSettings
     :cognitect.aws.mediaconvert.AudioCodecSettings/VorbisSettings
     :cognitect.aws.mediaconvert.AudioCodecSettings/WavSettings]))

(s/def
  :cognitect.aws.mediaconvert/DashIsoHbbtvCompliance
  (s/spec string? :gen #(s/gen #{"HBBTV_1_5" "NONE"})))

(s/def
  :cognitect.aws.mediaconvert/AncillarySourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.AncillarySourceSettings/SourceAncillaryChannelNumber
     :cognitect.aws.mediaconvert.AncillarySourceSettings/Convert608To708
     :cognitect.aws.mediaconvert.AncillarySourceSettings/TerminateCaptions]))

(s/def
  :cognitect.aws.mediaconvert/HlsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.HlsSettings/SegmentModifier
     :cognitect.aws.mediaconvert.HlsSettings/AudioTrackType
     :cognitect.aws.mediaconvert.HlsSettings/AudioOnlyContainer
     :cognitect.aws.mediaconvert.HlsSettings/IFrameOnlyManifest
     :cognitect.aws.mediaconvert.HlsSettings/DescriptiveVideoServiceFlag
     :cognitect.aws.mediaconvert.HlsSettings/AudioGroupId
     :cognitect.aws.mediaconvert.HlsSettings/AudioRenditionSets]))

(s/def
  :cognitect.aws.mediaconvert/OutputGroupType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MS_SMOOTH_GROUP_SETTINGS"
        "FILE_GROUP_SETTINGS"
        "DASH_ISO_GROUP_SETTINGS"
        "HLS_GROUP_SETTINGS"
        "CMAF_GROUP_SETTINGS"})))

(s/def
  :cognitect.aws.mediaconvert/H264FramerateConversionAlgorithm
  (s/spec
    string?
    :gen
    #(s/gen #{"DUPLICATE_DROP" "MAINTAIN_FRAME_COUNT" "INTERPOLATE" "FRAMEFORMER"})))

(s/def :cognitect.aws.mediaconvert/InputScanType (s/spec string? :gen #(s/gen #{"AUTO" "PSF"})))

(s/def
  :cognitect.aws.mediaconvert/Eac3AtmosSurroundExMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "NOT_INDICATED" "ENABLED"})))

(s/def :cognitect.aws.mediaconvert/Order (s/spec string? :gen #(s/gen #{"ASCENDING" "DESCENDING"})))

(s/def
  :cognitect.aws.mediaconvert/__stringPatternS3Https
  (s/spec
    #(re-matches (re-pattern "^s3://([^\\/]+\\/+)+((([^\\/]*)))|^https?://[^\\/].*[^&]$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.mediaconvert/AvcIntraFramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.mediaconvert/CmafAdditionalManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediaconvert.CmafAdditionalManifest/ManifestNameModifier
     :cognitect.aws.mediaconvert.CmafAdditionalManifest/SelectedOutputs]))

(s/def :cognitect.aws.mediaconvert.DvbSdtSettings/OutputSdt :cognitect.aws.mediaconvert/OutputSdt)

(s/def
  :cognitect.aws.mediaconvert.DvbSdtSettings/SdtInterval
  :cognitect.aws.mediaconvert/__integerMin25Max2000)

(s/def
  :cognitect.aws.mediaconvert.DvbSdtSettings/ServiceName
  :cognitect.aws.mediaconvert/__stringMin1Max256)

(s/def
  :cognitect.aws.mediaconvert.DvbSdtSettings/ServiceProviderName
  :cognitect.aws.mediaconvert/__stringMin1Max256)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/CustomLanguageCode
  :cognitect.aws.mediaconvert/__stringPatternAZaZ23AZaZ09)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/AudioTypeControl
  :cognitect.aws.mediaconvert/AudioTypeControl)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/LanguageCodeControl
  :cognitect.aws.mediaconvert/AudioLanguageCodeControl)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/AudioType
  :cognitect.aws.mediaconvert/__integerMin0Max255)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/StreamName
  :cognitect.aws.mediaconvert/__stringPatternWS)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/AudioChannelTaggingSettings
  :cognitect.aws.mediaconvert/AudioChannelTaggingSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/RemixSettings
  :cognitect.aws.mediaconvert/RemixSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/CodecSettings
  :cognitect.aws.mediaconvert/AudioCodecSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/AudioSourceName
  :cognitect.aws.mediaconvert/__stringMax2048)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/AudioNormalizationSettings
  :cognitect.aws.mediaconvert/AudioNormalizationSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioDescription/LanguageCode
  :cognitect.aws.mediaconvert/LanguageCode)

(s/def
  :cognitect.aws.mediaconvert.OutputChannelMapping/InputChannels
  :cognitect.aws.mediaconvert/__listOf__integerMinNegative60Max6)

(s/def
  :cognitect.aws.mediaconvert.OutputChannelMapping/InputChannelsFineTune
  :cognitect.aws.mediaconvert/__listOf__doubleMinNegative60Max6)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kIntraVbrProfileSettings/XavcClass
  :cognitect.aws.mediaconvert/Xavc4kIntraVbrProfileClass)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/Tracks
  :cognitect.aws.mediaconvert/__listOf__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/ProgramSelection
  :cognitect.aws.mediaconvert/__integerMin0Max8)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/CustomLanguageCode
  :cognitect.aws.mediaconvert/__stringMin3Max3PatternAZaZ3)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/AudioDurationCorrection
  :cognitect.aws.mediaconvert/AudioDurationCorrection)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/DefaultSelection
  :cognitect.aws.mediaconvert/AudioDefaultSelection)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/Offset
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/SelectorType
  :cognitect.aws.mediaconvert/AudioSelectorType)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/RemixSettings
  :cognitect.aws.mediaconvert/RemixSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/Pids
  :cognitect.aws.mediaconvert/__listOf__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/ExternalAudioFileInput
  :cognitect.aws.mediaconvert/__stringPatternS3Https)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/HlsRenditionGroupSettings
  :cognitect.aws.mediaconvert/HlsRenditionGroupSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioSelector/LanguageCode
  :cognitect.aws.mediaconvert/LanguageCode)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceFramerate/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max1001)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceFramerate/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max60000)

(s/def
  :cognitect.aws.mediaconvert.AvailBlanking/AvailBlankingImage
  :cognitect.aws.mediaconvert/__stringMin14PatternS3BmpBMPPngPNGHttpsBmpBMPPngPNG)

(s/def :cognitect.aws.mediaconvert.ExceptionBody/Message :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.TagResourceRequest/Arn :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.TagResourceRequest/Tags
  :cognitect.aws.mediaconvert/__mapOf__string)

(s/def :cognitect.aws.mediaconvert.MovSettings/ClapAtom :cognitect.aws.mediaconvert/MovClapAtom)

(s/def :cognitect.aws.mediaconvert.MovSettings/CslgAtom :cognitect.aws.mediaconvert/MovCslgAtom)

(s/def
  :cognitect.aws.mediaconvert.MovSettings/Mpeg2FourCCControl
  :cognitect.aws.mediaconvert/MovMpeg2FourCCControl)

(s/def
  :cognitect.aws.mediaconvert.MovSettings/PaddingControl
  :cognitect.aws.mediaconvert/MovPaddingControl)

(s/def :cognitect.aws.mediaconvert.MovSettings/Reference :cognitect.aws.mediaconvert/MovReference)

(s/def
  :cognitect.aws.mediaconvert.OutputGroupSettings/CmafGroupSettings
  :cognitect.aws.mediaconvert/CmafGroupSettings)

(s/def
  :cognitect.aws.mediaconvert.OutputGroupSettings/DashIsoGroupSettings
  :cognitect.aws.mediaconvert/DashIsoGroupSettings)

(s/def
  :cognitect.aws.mediaconvert.OutputGroupSettings/FileGroupSettings
  :cognitect.aws.mediaconvert/FileGroupSettings)

(s/def
  :cognitect.aws.mediaconvert.OutputGroupSettings/HlsGroupSettings
  :cognitect.aws.mediaconvert/HlsGroupSettings)

(s/def
  :cognitect.aws.mediaconvert.OutputGroupSettings/MsSmoothGroupSettings
  :cognitect.aws.mediaconvert/MsSmoothGroupSettings)

(s/def
  :cognitect.aws.mediaconvert.OutputGroupSettings/Type
  :cognitect.aws.mediaconvert/OutputGroupType)

(s/def
  :cognitect.aws.mediaconvert.JobTemplate/CreatedAt
  :cognitect.aws.mediaconvert/__timestampUnix)

(s/def
  :cognitect.aws.mediaconvert.JobTemplate/LastUpdated
  :cognitect.aws.mediaconvert/__timestampUnix)

(s/def
  :cognitect.aws.mediaconvert.JobTemplate/StatusUpdateInterval
  :cognitect.aws.mediaconvert/StatusUpdateInterval)

(s/def
  :cognitect.aws.mediaconvert.JobTemplate/AccelerationSettings
  :cognitect.aws.mediaconvert/AccelerationSettings)

(s/def :cognitect.aws.mediaconvert.JobTemplate/Queue :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.JobTemplate/Priority
  :cognitect.aws.mediaconvert/__integerMinNegative50Max50)

(s/def :cognitect.aws.mediaconvert.JobTemplate/Category :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.JobTemplate/Settings
  :cognitect.aws.mediaconvert/JobTemplateSettings)

(s/def :cognitect.aws.mediaconvert.JobTemplate/Arn :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.JobTemplate/Name :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.JobTemplate/Description :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.JobTemplate/Type :cognitect.aws.mediaconvert/Type)

(s/def
  :cognitect.aws.mediaconvert.JobTemplate/HopDestinations
  :cognitect.aws.mediaconvert/__listOfHopDestination)

(s/def
  :cognitect.aws.mediaconvert.PresetSettings/AudioDescriptions
  :cognitect.aws.mediaconvert/__listOfAudioDescription)

(s/def
  :cognitect.aws.mediaconvert.PresetSettings/CaptionDescriptions
  :cognitect.aws.mediaconvert/__listOfCaptionDescriptionPreset)

(s/def
  :cognitect.aws.mediaconvert.PresetSettings/ContainerSettings
  :cognitect.aws.mediaconvert/ContainerSettings)

(s/def
  :cognitect.aws.mediaconvert.PresetSettings/VideoDescription
  :cognitect.aws.mediaconvert/VideoDescription)

(s/def
  :cognitect.aws.mediaconvert.Mp3Settings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin16000Max320000)

(s/def
  :cognitect.aws.mediaconvert.Mp3Settings/Channels
  :cognitect.aws.mediaconvert/__integerMin1Max2)

(s/def
  :cognitect.aws.mediaconvert.Mp3Settings/RateControlMode
  :cognitect.aws.mediaconvert/Mp3RateControlMode)

(s/def
  :cognitect.aws.mediaconvert.Mp3Settings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin22050Max48000)

(s/def
  :cognitect.aws.mediaconvert.Mp3Settings/VbrQuality
  :cognitect.aws.mediaconvert/__integerMin0Max9)

(s/def :cognitect.aws.mediaconvert.WarningGroup/Code :cognitect.aws.mediaconvert/__integer)

(s/def :cognitect.aws.mediaconvert.WarningGroup/Count :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/VideoOverlays
  :cognitect.aws.mediaconvert/__listOfVideoOverlay)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/FilterStrength
  :cognitect.aws.mediaconvert/__integerMin0Max5)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/DenoiseFilter
  :cognitect.aws.mediaconvert/InputDenoiseFilter)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/FilterEnable
  :cognitect.aws.mediaconvert/InputFilterEnable)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/VideoSelector
  :cognitect.aws.mediaconvert/VideoSelector)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/CaptionSelectors
  :cognitect.aws.mediaconvert/__mapOfCaptionSelector)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/AdvancedInputFilterSettings
  :cognitect.aws.mediaconvert/AdvancedInputFilterSettings)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/AudioSelectorGroups
  :cognitect.aws.mediaconvert/__mapOfAudioSelectorGroup)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/PsiControl
  :cognitect.aws.mediaconvert/InputPsiControl)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/AudioSelectors
  :cognitect.aws.mediaconvert/__mapOfAudioSelector)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/TimecodeStart
  :cognitect.aws.mediaconvert/__stringMin11Max11Pattern01D20305D205D)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/InputClippings
  :cognitect.aws.mediaconvert/__listOfInputClipping)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/DynamicAudioSelectors
  :cognitect.aws.mediaconvert/__mapOfDynamicAudioSelector)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/TimecodeSource
  :cognitect.aws.mediaconvert/InputTimecodeSource)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/DeblockFilter
  :cognitect.aws.mediaconvert/InputDeblockFilter)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/AdvancedInputFilter
  :cognitect.aws.mediaconvert/AdvancedInputFilter)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/ProgramNumber
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/DolbyVisionMetadataXml
  :cognitect.aws.mediaconvert/__stringMin14PatternS3XmlXMLHttpsXmlXML)

(s/def :cognitect.aws.mediaconvert.InputTemplate/Position :cognitect.aws.mediaconvert/Rectangle)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/ImageInserter
  :cognitect.aws.mediaconvert/ImageInserter)

(s/def :cognitect.aws.mediaconvert.InputTemplate/Crop :cognitect.aws.mediaconvert/Rectangle)

(s/def
  :cognitect.aws.mediaconvert.InputTemplate/InputScanType
  :cognitect.aws.mediaconvert/InputScanType)

(s/def
  :cognitect.aws.mediaconvert.HlsAdditionalManifest/ManifestNameModifier
  :cognitect.aws.mediaconvert/__stringMin1)

(s/def
  :cognitect.aws.mediaconvert.HlsAdditionalManifest/SelectedOutputs
  :cognitect.aws.mediaconvert/__listOf__stringMin1)

(s/def
  :cognitect.aws.mediaconvert.InputVideoGenerator/Channels
  :cognitect.aws.mediaconvert/__integerMin1Max32)

(s/def
  :cognitect.aws.mediaconvert.InputVideoGenerator/Duration
  :cognitect.aws.mediaconvert/__integerMin50Max86400000)

(s/def
  :cognitect.aws.mediaconvert.InputVideoGenerator/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max1001)

(s/def
  :cognitect.aws.mediaconvert.InputVideoGenerator/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max60000)

(s/def
  :cognitect.aws.mediaconvert.InputVideoGenerator/SampleRate
  :cognitect.aws.mediaconvert/__integerMin32000Max48000)

(s/def :cognitect.aws.mediaconvert.GetQueueResponse/Queue :cognitect.aws.mediaconvert/Queue)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/VideoPreprocessors
  :cognitect.aws.mediaconvert/VideoPreprocessor)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/Sharpness
  :cognitect.aws.mediaconvert/__integerMin0Max100)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/DropFrameTimecode
  :cognitect.aws.mediaconvert/DropFrameTimecode)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/TimecodeTrack
  :cognitect.aws.mediaconvert/TimecodeTrack)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/FixedAfd
  :cognitect.aws.mediaconvert/__integerMin0Max15)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/RespondToAfd
  :cognitect.aws.mediaconvert/RespondToAfd)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/ColorMetadata
  :cognitect.aws.mediaconvert/ColorMetadata)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/TimecodeInsertion
  :cognitect.aws.mediaconvert/VideoTimecodeInsertion)

(s/def :cognitect.aws.mediaconvert.VideoDescription/AntiAlias :cognitect.aws.mediaconvert/AntiAlias)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/ScalingBehavior
  :cognitect.aws.mediaconvert/ScalingBehavior)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/CodecSettings
  :cognitect.aws.mediaconvert/VideoCodecSettings)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/Width
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/ChromaPositionMode
  :cognitect.aws.mediaconvert/ChromaPositionMode)

(s/def :cognitect.aws.mediaconvert.VideoDescription/Position :cognitect.aws.mediaconvert/Rectangle)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/AfdSignaling
  :cognitect.aws.mediaconvert/AfdSignaling)

(s/def
  :cognitect.aws.mediaconvert.VideoDescription/Height
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def :cognitect.aws.mediaconvert.VideoDescription/Crop :cognitect.aws.mediaconvert/Rectangle)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateResponse/JobTemplate
  :cognitect.aws.mediaconvert/JobTemplate)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInserter/Framerate
  :cognitect.aws.mediaconvert/MotionImageInsertionFramerate)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInserter/Input
  :cognitect.aws.mediaconvert/__stringMin14PatternS3Mov09PngHttpsMov09Png)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInserter/InsertionMode
  :cognitect.aws.mediaconvert/MotionImageInsertionMode)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInserter/Offset
  :cognitect.aws.mediaconvert/MotionImageInsertionOffset)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInserter/Playback
  :cognitect.aws.mediaconvert/MotionImagePlayback)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInserter/StartTime
  :cognitect.aws.mediaconvert/__stringMin11Max11Pattern01D20305D205D)

(s/def
  :cognitect.aws.mediaconvert.FileSourceSettings/ByteRateLimit
  :cognitect.aws.mediaconvert/CaptionSourceByteRateLimit)

(s/def
  :cognitect.aws.mediaconvert.FileSourceSettings/Convert608To708
  :cognitect.aws.mediaconvert/FileSourceConvert608To708)

(s/def
  :cognitect.aws.mediaconvert.FileSourceSettings/ConvertPaintToPop
  :cognitect.aws.mediaconvert/CaptionSourceConvertPaintOnToPopOn)

(s/def
  :cognitect.aws.mediaconvert.FileSourceSettings/Framerate
  :cognitect.aws.mediaconvert/CaptionSourceFramerate)

(s/def
  :cognitect.aws.mediaconvert.FileSourceSettings/SourceFile
  :cognitect.aws.mediaconvert/__stringMin14PatternS3SccSCCTtmlTTMLDfxpDFXPStlSTLSrtSRTXmlXMLSmiSMIVttVTTWebvttWEBVTTHttpsSccSCCTtmlTTMLDfxpDFXPStlSTLSrtSRTXmlXMLSmiSMIVttVTTWebvttWEBVTT)

(s/def
  :cognitect.aws.mediaconvert.FileSourceSettings/TimeDelta
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.FileSourceSettings/TimeDeltaUnits
  :cognitect.aws.mediaconvert/FileSourceTimeDeltaUnits)

(s/def :cognitect.aws.mediaconvert.Vp8Settings/GopSize :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/QualityTuningLevel
  :cognitect.aws.mediaconvert/Vp8QualityTuningLevel)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/ParNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/HrdBufferSize
  :cognitect.aws.mediaconvert/__integerMin0Max47185920)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/ParDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/RateControlMode
  :cognitect.aws.mediaconvert/Vp8RateControlMode)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max1152000000)

(s/def :cognitect.aws.mediaconvert.Vp8Settings/ParControl :cognitect.aws.mediaconvert/Vp8ParControl)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/MaxBitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max1152000000)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/Vp8FramerateConversionAlgorithm)

(s/def
  :cognitect.aws.mediaconvert.Vp8Settings/FramerateControl
  :cognitect.aws.mediaconvert/Vp8FramerateControl)

(s/def
  :cognitect.aws.mediaconvert.ForceIncludeRenditionSize/Height
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def
  :cognitect.aws.mediaconvert.ForceIncludeRenditionSize/Width
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def :cognitect.aws.mediaconvert.Av1Settings/GopSize :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/FilmGrainSynthesis
  :cognitect.aws.mediaconvert/Av1FilmGrainSynthesis)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/AdaptiveQuantization
  :cognitect.aws.mediaconvert/Av1AdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/NumberBFramesBetweenReferenceFrames
  :cognitect.aws.mediaconvert/__integerMin0Max15)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/QvbrSettings
  :cognitect.aws.mediaconvert/Av1QvbrSettings)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/RateControlMode
  :cognitect.aws.mediaconvert/Av1RateControlMode)

(s/def :cognitect.aws.mediaconvert.Av1Settings/BitDepth :cognitect.aws.mediaconvert/Av1BitDepth)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/SpatialAdaptiveQuantization
  :cognitect.aws.mediaconvert/Av1SpatialAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/MaxBitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max1152000000)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/Slices
  :cognitect.aws.mediaconvert/__integerMin1Max32)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/Av1FramerateConversionAlgorithm)

(s/def
  :cognitect.aws.mediaconvert.Av1Settings/FramerateControl
  :cognitect.aws.mediaconvert/Av1FramerateControl)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/Telecine
  :cognitect.aws.mediaconvert/ProresTelecine)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/InterlaceMode
  :cognitect.aws.mediaconvert/ProresInterlaceMode)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/ParNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/ParDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/CodecProfile
  :cognitect.aws.mediaconvert/ProresCodecProfile)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/ParControl
  :cognitect.aws.mediaconvert/ProresParControl)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/ChromaSampling
  :cognitect.aws.mediaconvert/ProresChromaSampling)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/ProresFramerateConversionAlgorithm)

(s/def :cognitect.aws.mediaconvert.ProresSettings/SlowPal :cognitect.aws.mediaconvert/ProresSlowPal)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/ScanTypeConversionMode
  :cognitect.aws.mediaconvert/ProresScanTypeConversionMode)

(s/def
  :cognitect.aws.mediaconvert.ProresSettings/FramerateControl
  :cognitect.aws.mediaconvert/ProresFramerateControl)

(s/def
  :cognitect.aws.mediaconvert.MxfXavcProfileSettings/DurationMode
  :cognitect.aws.mediaconvert/MxfXavcDurationMode)

(s/def
  :cognitect.aws.mediaconvert.MxfXavcProfileSettings/MaxAncDataSize
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def :cognitect.aws.mediaconvert.ListJobsResponse/Jobs :cognitect.aws.mediaconvert/__listOfJob)

(s/def :cognitect.aws.mediaconvert.ListJobsResponse/NextToken :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.NexGuardFileMarkerSettings/License
  :cognitect.aws.mediaconvert/__stringMin1Max100000)

(s/def
  :cognitect.aws.mediaconvert.NexGuardFileMarkerSettings/Payload
  :cognitect.aws.mediaconvert/__integerMin0Max4194303)

(s/def
  :cognitect.aws.mediaconvert.NexGuardFileMarkerSettings/Preset
  :cognitect.aws.mediaconvert/__stringMin1Max256)

(s/def
  :cognitect.aws.mediaconvert.NexGuardFileMarkerSettings/Strength
  :cognitect.aws.mediaconvert/WatermarkingStrength)

(s/def
  :cognitect.aws.mediaconvert.EmbeddedDestinationSettings/Destination608ChannelNumber
  :cognitect.aws.mediaconvert/__integerMin1Max4)

(s/def
  :cognitect.aws.mediaconvert.EmbeddedDestinationSettings/Destination708ServiceNumber
  :cognitect.aws.mediaconvert/__integerMin1Max6)

(s/def :cognitect.aws.mediaconvert.UpdatePresetResponse/Preset :cognitect.aws.mediaconvert/Preset)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/ManifestDurationFormat
  :cognitect.aws.mediaconvert/HlsManifestDurationFormat)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/CodecSpecification
  :cognitect.aws.mediaconvert/HlsCodecSpecification)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/Encryption
  :cognitect.aws.mediaconvert/HlsEncryptionSettings)

(s/def :cognitect.aws.mediaconvert.HlsGroupSettings/BaseUrl :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/ImageBasedTrickPlaySettings
  :cognitect.aws.mediaconvert/HlsImageBasedTrickPlaySettings)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/ProgramDateTime
  :cognitect.aws.mediaconvert/HlsProgramDateTime)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/AdMarkers
  :cognitect.aws.mediaconvert/__listOfHlsAdMarkers)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/StreamInfResolution
  :cognitect.aws.mediaconvert/HlsStreamInfResolution)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/Destination
  :cognitect.aws.mediaconvert/__stringPatternS3)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/MinFinalSegmentLength
  :cognitect.aws.mediaconvert/__doubleMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/SegmentLength
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/TimedMetadataId3Period
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/AdditionalManifests
  :cognitect.aws.mediaconvert/__listOfHlsAdditionalManifest)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/TargetDurationCompatibilityMode
  :cognitect.aws.mediaconvert/HlsTargetDurationCompatibilityMode)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/TimedMetadataId3Frame
  :cognitect.aws.mediaconvert/HlsTimedMetadataId3Frame)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/ProgramDateTimePeriod
  :cognitect.aws.mediaconvert/__integerMin0Max3600)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/AudioOnlyHeader
  :cognitect.aws.mediaconvert/HlsAudioOnlyHeader)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/SegmentControl
  :cognitect.aws.mediaconvert/HlsSegmentControl)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/CaptionLanguageSetting
  :cognitect.aws.mediaconvert/HlsCaptionLanguageSetting)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/ClientCache
  :cognitect.aws.mediaconvert/HlsClientCache)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/DestinationSettings
  :cognitect.aws.mediaconvert/DestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/MinSegmentLength
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/CaptionLanguageMappings
  :cognitect.aws.mediaconvert/__listOfHlsCaptionLanguageMapping)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/SegmentsPerSubdirectory
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/CaptionSegmentLengthControl
  :cognitect.aws.mediaconvert/HlsCaptionSegmentLengthControl)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/ManifestCompression
  :cognitect.aws.mediaconvert/HlsManifestCompression)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/SegmentLengthControl
  :cognitect.aws.mediaconvert/HlsSegmentLengthControl)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/ImageBasedTrickPlay
  :cognitect.aws.mediaconvert/HlsImageBasedTrickPlay)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/TimestampDeltaMilliseconds
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/ProgressiveWriteHlsManifest
  :cognitect.aws.mediaconvert/HlsProgressiveWriteHlsManifest)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/DirectoryStructure
  :cognitect.aws.mediaconvert/HlsDirectoryStructure)

(s/def
  :cognitect.aws.mediaconvert.HlsGroupSettings/OutputSelection
  :cognitect.aws.mediaconvert/HlsOutputSelection)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducer/Filter
  :cognitect.aws.mediaconvert/NoiseReducerFilter)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducer/FilterSettings
  :cognitect.aws.mediaconvert/NoiseReducerFilterSettings)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducer/SpatialFilterSettings
  :cognitect.aws.mediaconvert/NoiseReducerSpatialFilterSettings)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducer/TemporalFilterSettings
  :cognitect.aws.mediaconvert/NoiseReducerTemporalFilterSettings)

(s/def :cognitect.aws.mediaconvert.Endpoint/Url :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/DdsXCoordinate
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontFileItalic
  :cognitect.aws.mediaconvert/__stringPatternS3TtfHttpsTtf)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/TeletextSpacing
  :cognitect.aws.mediaconvert/DvbSubtitleTeletextSpacing)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontFileRegular
  :cognitect.aws.mediaconvert/__stringPatternS3TtfHttpsTtf)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ShadowYOffset
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/BackgroundOpacity
  :cognitect.aws.mediaconvert/__integerMin0Max255)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ApplyFontColor
  :cognitect.aws.mediaconvert/DvbSubtitleApplyFontColor)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/HexFontColor
  :cognitect.aws.mediaconvert/__stringMin6Max8Pattern09aFAF609aFAF2)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/OutlineColor
  :cognitect.aws.mediaconvert/DvbSubtitleOutlineColor)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ShadowXOffset
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontSize
  :cognitect.aws.mediaconvert/__integerMin0Max96)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/SubtitlingType
  :cognitect.aws.mediaconvert/DvbSubtitlingType)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontOpacity
  :cognitect.aws.mediaconvert/__integerMin0Max255)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/Alignment
  :cognitect.aws.mediaconvert/DvbSubtitleAlignment)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/DdsHandling
  :cognitect.aws.mediaconvert/DvbddsHandling)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontFileBoldItalic
  :cognitect.aws.mediaconvert/__stringPatternS3TtfHttpsTtf)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontColor
  :cognitect.aws.mediaconvert/DvbSubtitleFontColor)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/YPosition
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ShadowColor
  :cognitect.aws.mediaconvert/DvbSubtitleShadowColor)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/Width
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontScript
  :cognitect.aws.mediaconvert/FontScript)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontResolution
  :cognitect.aws.mediaconvert/__integerMin96Max600)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/BackgroundColor
  :cognitect.aws.mediaconvert/DvbSubtitleBackgroundColor)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/DdsYCoordinate
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FontFileBold
  :cognitect.aws.mediaconvert/__stringPatternS3TtfHttpsTtf)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/ShadowOpacity
  :cognitect.aws.mediaconvert/__integerMin0Max255)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/XPosition
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/StylePassthrough
  :cognitect.aws.mediaconvert/DvbSubtitleStylePassthrough)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/FallbackFont
  :cognitect.aws.mediaconvert/DvbSubSubtitleFallbackFont)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/OutlineSize
  :cognitect.aws.mediaconvert/__integerMin0Max10)

(s/def
  :cognitect.aws.mediaconvert.DvbSubDestinationSettings/Height
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.QueueTransition/DestinationQueue
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.QueueTransition/SourceQueue :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.QueueTransition/Timestamp
  :cognitect.aws.mediaconvert/__timestampUnix)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/JobTemplate
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/StatusUpdateInterval
  :cognitect.aws.mediaconvert/StatusUpdateInterval)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/AccelerationSettings
  :cognitect.aws.mediaconvert/AccelerationSettings)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/Tags
  :cognitect.aws.mediaconvert/__mapOf__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/UserMetadata
  :cognitect.aws.mediaconvert/__mapOf__string)

(s/def :cognitect.aws.mediaconvert.CreateJobRequest/Queue :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/Priority
  :cognitect.aws.mediaconvert/__integerMinNegative50Max50)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/ClientRequestToken
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/JobEngineVersion
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/Settings
  :cognitect.aws.mediaconvert/JobSettings)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/SimulateReservedQueue
  :cognitect.aws.mediaconvert/SimulateReservedQueue)

(s/def :cognitect.aws.mediaconvert.CreateJobRequest/Role :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/BillingTagsSource
  :cognitect.aws.mediaconvert/BillingTagsSource)

(s/def
  :cognitect.aws.mediaconvert.CreateJobRequest/HopDestinations
  :cognitect.aws.mediaconvert/__listOfHopDestination)

(s/def
  :cognitect.aws.mediaconvert.VideoSelector/MaxLuminance
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.VideoSelector/SampleRange
  :cognitect.aws.mediaconvert/InputSampleRange)

(s/def
  :cognitect.aws.mediaconvert.VideoSelector/ColorSpaceUsage
  :cognitect.aws.mediaconvert/ColorSpaceUsage)

(s/def
  :cognitect.aws.mediaconvert.VideoSelector/Pid
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.VideoSelector/EmbeddedTimecodeOverride
  :cognitect.aws.mediaconvert/EmbeddedTimecodeOverride)

(s/def :cognitect.aws.mediaconvert.VideoSelector/PadVideo :cognitect.aws.mediaconvert/PadVideo)

(s/def
  :cognitect.aws.mediaconvert.VideoSelector/ProgramNumber
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def :cognitect.aws.mediaconvert.VideoSelector/ColorSpace :cognitect.aws.mediaconvert/ColorSpace)

(s/def
  :cognitect.aws.mediaconvert.VideoSelector/Hdr10Metadata
  :cognitect.aws.mediaconvert/Hdr10Metadata)

(s/def
  :cognitect.aws.mediaconvert.VideoSelector/AlphaBehavior
  :cognitect.aws.mediaconvert/AlphaBehavior)

(s/def :cognitect.aws.mediaconvert.VideoSelector/Rotate :cognitect.aws.mediaconvert/InputRotate)

(s/def
  :cognitect.aws.mediaconvert.XavcHdIntraCbgProfileSettings/XavcClass
  :cognitect.aws.mediaconvert/XavcHdIntraCbgProfileClass)

(s/def
  :cognitect.aws.mediaconvert.ListPresetsResponse/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.ListPresetsResponse/Presets
  :cognitect.aws.mediaconvert/__listOfPreset)

(s/def
  :cognitect.aws.mediaconvert.Id3Insertion/Id3
  :cognitect.aws.mediaconvert/__stringPatternAZaZ0902)

(s/def
  :cognitect.aws.mediaconvert.Id3Insertion/Timecode
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092)

(s/def
  :cognitect.aws.mediaconvert.Mp4Settings/AudioDuration
  :cognitect.aws.mediaconvert/CmfcAudioDuration)

(s/def :cognitect.aws.mediaconvert.Mp4Settings/CslgAtom :cognitect.aws.mediaconvert/Mp4CslgAtom)

(s/def
  :cognitect.aws.mediaconvert.Mp4Settings/CttsVersion
  :cognitect.aws.mediaconvert/__integerMin0Max1)

(s/def
  :cognitect.aws.mediaconvert.Mp4Settings/FreeSpaceBox
  :cognitect.aws.mediaconvert/Mp4FreeSpaceBox)

(s/def
  :cognitect.aws.mediaconvert.Mp4Settings/MoovPlacement
  :cognitect.aws.mediaconvert/Mp4MoovPlacement)

(s/def :cognitect.aws.mediaconvert.Mp4Settings/Mp4MajorBrand :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CmafEncryptionSettings/ConstantInitializationVector
  :cognitect.aws.mediaconvert/__stringMin32Max32Pattern09aFAF32)

(s/def
  :cognitect.aws.mediaconvert.CmafEncryptionSettings/EncryptionMethod
  :cognitect.aws.mediaconvert/CmafEncryptionType)

(s/def
  :cognitect.aws.mediaconvert.CmafEncryptionSettings/InitializationVectorInManifest
  :cognitect.aws.mediaconvert/CmafInitializationVectorInManifest)

(s/def
  :cognitect.aws.mediaconvert.CmafEncryptionSettings/SpekeKeyProvider
  :cognitect.aws.mediaconvert/SpekeKeyProviderCmaf)

(s/def
  :cognitect.aws.mediaconvert.CmafEncryptionSettings/StaticKeyProvider
  :cognitect.aws.mediaconvert/StaticKeyProvider)

(s/def
  :cognitect.aws.mediaconvert.CmafEncryptionSettings/Type
  :cognitect.aws.mediaconvert/CmafKeyProviderType)

(s/def
  :cognitect.aws.mediaconvert.HlsEncryptionSettings/ConstantInitializationVector
  :cognitect.aws.mediaconvert/__stringMin32Max32Pattern09aFAF32)

(s/def
  :cognitect.aws.mediaconvert.HlsEncryptionSettings/EncryptionMethod
  :cognitect.aws.mediaconvert/HlsEncryptionType)

(s/def
  :cognitect.aws.mediaconvert.HlsEncryptionSettings/InitializationVectorInManifest
  :cognitect.aws.mediaconvert/HlsInitializationVectorInManifest)

(s/def
  :cognitect.aws.mediaconvert.HlsEncryptionSettings/OfflineEncrypted
  :cognitect.aws.mediaconvert/HlsOfflineEncrypted)

(s/def
  :cognitect.aws.mediaconvert.HlsEncryptionSettings/SpekeKeyProvider
  :cognitect.aws.mediaconvert/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediaconvert.HlsEncryptionSettings/StaticKeyProvider
  :cognitect.aws.mediaconvert/StaticKeyProvider)

(s/def
  :cognitect.aws.mediaconvert.HlsEncryptionSettings/Type
  :cognitect.aws.mediaconvert/HlsKeyProviderType)

(s/def
  :cognitect.aws.mediaconvert.AdvancedInputFilterSettings/AddTexture
  :cognitect.aws.mediaconvert/AdvancedInputFilterAddTexture)

(s/def
  :cognitect.aws.mediaconvert.AdvancedInputFilterSettings/Sharpening
  :cognitect.aws.mediaconvert/AdvancedInputFilterSharpen)

(s/def
  :cognitect.aws.mediaconvert.AssociateCertificateRequest/Arn
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.ListVersionsResponse/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.ListVersionsResponse/Versions
  :cognitect.aws.mediaconvert/__listOfJobEngineVersion)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothAdditionalManifest/ManifestNameModifier
  :cognitect.aws.mediaconvert/__stringMin1)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothAdditionalManifest/SelectedOutputs
  :cognitect.aws.mediaconvert/__listOf__stringMin1)

(s/def
  :cognitect.aws.mediaconvert.ContainerSettings/MovSettings
  :cognitect.aws.mediaconvert/MovSettings)

(s/def
  :cognitect.aws.mediaconvert.ContainerSettings/Container
  :cognitect.aws.mediaconvert/ContainerType)

(s/def
  :cognitect.aws.mediaconvert.ContainerSettings/Mp4Settings
  :cognitect.aws.mediaconvert/Mp4Settings)

(s/def
  :cognitect.aws.mediaconvert.ContainerSettings/MxfSettings
  :cognitect.aws.mediaconvert/MxfSettings)

(s/def
  :cognitect.aws.mediaconvert.ContainerSettings/M3u8Settings
  :cognitect.aws.mediaconvert/M3u8Settings)

(s/def
  :cognitect.aws.mediaconvert.ContainerSettings/CmfcSettings
  :cognitect.aws.mediaconvert/CmfcSettings)

(s/def
  :cognitect.aws.mediaconvert.ContainerSettings/M2tsSettings
  :cognitect.aws.mediaconvert/M2tsSettings)

(s/def
  :cognitect.aws.mediaconvert.ContainerSettings/F4vSettings
  :cognitect.aws.mediaconvert/F4vSettings)

(s/def
  :cognitect.aws.mediaconvert.ContainerSettings/MpdSettings
  :cognitect.aws.mediaconvert/MpdSettings)

(s/def
  :cognitect.aws.mediaconvert.Input/VideoOverlays
  :cognitect.aws.mediaconvert/__listOfVideoOverlay)

(s/def
  :cognitect.aws.mediaconvert.Input/FilterStrength
  :cognitect.aws.mediaconvert/__integerMin0Max5)

(s/def
  :cognitect.aws.mediaconvert.Input/DecryptionSettings
  :cognitect.aws.mediaconvert/InputDecryptionSettings)

(s/def
  :cognitect.aws.mediaconvert.Input/VideoGenerator
  :cognitect.aws.mediaconvert/InputVideoGenerator)

(s/def
  :cognitect.aws.mediaconvert.Input/DenoiseFilter
  :cognitect.aws.mediaconvert/InputDenoiseFilter)

(s/def :cognitect.aws.mediaconvert.Input/FilterEnable :cognitect.aws.mediaconvert/InputFilterEnable)

(s/def :cognitect.aws.mediaconvert.Input/VideoSelector :cognitect.aws.mediaconvert/VideoSelector)

(s/def
  :cognitect.aws.mediaconvert.Input/CaptionSelectors
  :cognitect.aws.mediaconvert/__mapOfCaptionSelector)

(s/def
  :cognitect.aws.mediaconvert.Input/AdvancedInputFilterSettings
  :cognitect.aws.mediaconvert/AdvancedInputFilterSettings)

(s/def
  :cognitect.aws.mediaconvert.Input/AudioSelectorGroups
  :cognitect.aws.mediaconvert/__mapOfAudioSelectorGroup)

(s/def
  :cognitect.aws.mediaconvert.Input/SupplementalImps
  :cognitect.aws.mediaconvert/__listOf__stringPatternS3ASSETMAPXml)

(s/def :cognitect.aws.mediaconvert.Input/PsiControl :cognitect.aws.mediaconvert/InputPsiControl)

(s/def
  :cognitect.aws.mediaconvert.Input/AudioSelectors
  :cognitect.aws.mediaconvert/__mapOfAudioSelector)

(s/def
  :cognitect.aws.mediaconvert.Input/TimecodeStart
  :cognitect.aws.mediaconvert/__stringMin11Max11Pattern01D20305D205D)

(s/def
  :cognitect.aws.mediaconvert.Input/InputClippings
  :cognitect.aws.mediaconvert/__listOfInputClipping)

(s/def
  :cognitect.aws.mediaconvert.Input/DynamicAudioSelectors
  :cognitect.aws.mediaconvert/__mapOfDynamicAudioSelector)

(s/def
  :cognitect.aws.mediaconvert.Input/TimecodeSource
  :cognitect.aws.mediaconvert/InputTimecodeSource)

(s/def
  :cognitect.aws.mediaconvert.Input/DeblockFilter
  :cognitect.aws.mediaconvert/InputDeblockFilter)

(s/def
  :cognitect.aws.mediaconvert.Input/AdvancedInputFilter
  :cognitect.aws.mediaconvert/AdvancedInputFilter)

(s/def
  :cognitect.aws.mediaconvert.Input/FileInput
  :cognitect.aws.mediaconvert/__stringMax2048PatternS3Https)

(s/def
  :cognitect.aws.mediaconvert.Input/ProgramNumber
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Input/DolbyVisionMetadataXml
  :cognitect.aws.mediaconvert/__stringMin14PatternS3XmlXMLHttpsXmlXML)

(s/def :cognitect.aws.mediaconvert.Input/Position :cognitect.aws.mediaconvert/Rectangle)

(s/def :cognitect.aws.mediaconvert.Input/ImageInserter :cognitect.aws.mediaconvert/ImageInserter)

(s/def :cognitect.aws.mediaconvert.Input/Crop :cognitect.aws.mediaconvert/Rectangle)

(s/def :cognitect.aws.mediaconvert.Input/InputScanType :cognitect.aws.mediaconvert/InputScanType)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kIntraCbgProfileSettings/XavcClass
  :cognitect.aws.mediaconvert/Xavc4kIntraCbgProfileClass)

(s/def
  :cognitect.aws.mediaconvert.MinTopRenditionSize/Height
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def
  :cognitect.aws.mediaconvert.MinTopRenditionSize/Width
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProvider/CertificateArn
  :cognitect.aws.mediaconvert/__stringPatternArnAwsUsGovAcm)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProvider/EncryptionContractConfiguration
  :cognitect.aws.mediaconvert/EncryptionContractConfiguration)

(s/def :cognitect.aws.mediaconvert.SpekeKeyProvider/ResourceId :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProvider/SystemIds
  :cognitect.aws.mediaconvert/__listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProvider/Url
  :cognitect.aws.mediaconvert/__stringPatternHttpsD)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/AssetId
  :cognitect.aws.mediaconvert/__stringMin1Max20)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/AdiFilename
  :cognitect.aws.mediaconvert/__stringPatternS3)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/EpisodeId
  :cognitect.aws.mediaconvert/__stringMin1Max20)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/CbetSourceId
  :cognitect.aws.mediaconvert/__stringPattern0xAFaF0908190908)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/SourceWatermarkStatus
  :cognitect.aws.mediaconvert/NielsenSourceWatermarkStatusType)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/ActiveWatermarkProcess
  :cognitect.aws.mediaconvert/NielsenActiveWatermarkProcessType)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/SourceId
  :cognitect.aws.mediaconvert/__integerMin0Max65534)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/TicServerUrl
  :cognitect.aws.mediaconvert/__stringPatternHttps)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/MetadataDestination
  :cognitect.aws.mediaconvert/__stringPatternS3)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/AssetName
  :cognitect.aws.mediaconvert/__stringMin1Max50)

(s/def
  :cognitect.aws.mediaconvert.NielsenNonLinearWatermarkSettings/UniqueTicPerAudioTrack
  :cognitect.aws.mediaconvert/NielsenUniqueTicPerAudioTrackType)

(s/def
  :cognitect.aws.mediaconvert.NielsenConfiguration/BreakoutCode
  :cognitect.aws.mediaconvert/__integerMin0Max0)

(s/def
  :cognitect.aws.mediaconvert.NielsenConfiguration/DistributorId
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.AccelerationSettings/Mode
  :cognitect.aws.mediaconvert/AccelerationMode)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/DashManifestStyle
  :cognitect.aws.mediaconvert/DashManifestStyle)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/Encryption
  :cognitect.aws.mediaconvert/DashIsoEncryptionSettings)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/BaseUrl
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/ImageBasedTrickPlaySettings
  :cognitect.aws.mediaconvert/DashIsoImageBasedTrickPlaySettings)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/PtsOffsetHandlingForBFrames
  :cognitect.aws.mediaconvert/DashIsoPtsOffsetHandlingForBFrames)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/WriteSegmentTimelineInRepresentation
  :cognitect.aws.mediaconvert/DashIsoWriteSegmentTimelineInRepresentation)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/Destination
  :cognitect.aws.mediaconvert/__stringPatternS3)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/FragmentLength
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/MinFinalSegmentLength
  :cognitect.aws.mediaconvert/__doubleMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/MpdProfile
  :cognitect.aws.mediaconvert/DashIsoMpdProfile)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/SegmentLength
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/AdditionalManifests
  :cognitect.aws.mediaconvert/__listOfDashAdditionalManifest)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/HbbtvCompliance
  :cognitect.aws.mediaconvert/DashIsoHbbtvCompliance)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/MinBufferTime
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/MpdManifestBandwidthType
  :cognitect.aws.mediaconvert/DashIsoMpdManifestBandwidthType)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/SegmentControl
  :cognitect.aws.mediaconvert/DashIsoSegmentControl)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/VideoCompositionOffsets
  :cognitect.aws.mediaconvert/DashIsoVideoCompositionOffsets)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/DashIFrameTrickPlayNameModifier
  :cognitect.aws.mediaconvert/__stringMin1Max256)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/DestinationSettings
  :cognitect.aws.mediaconvert/DestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/AudioChannelConfigSchemeIdUri
  :cognitect.aws.mediaconvert/DashIsoGroupAudioChannelConfigSchemeIdUri)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/SegmentLengthControl
  :cognitect.aws.mediaconvert/DashIsoSegmentLengthControl)

(s/def
  :cognitect.aws.mediaconvert.DashIsoGroupSettings/ImageBasedTrickPlay
  :cognitect.aws.mediaconvert/DashIsoImageBasedTrickPlay)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceSettings/AncillarySourceSettings
  :cognitect.aws.mediaconvert/AncillarySourceSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceSettings/DvbSubSourceSettings
  :cognitect.aws.mediaconvert/DvbSubSourceSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceSettings/EmbeddedSourceSettings
  :cognitect.aws.mediaconvert/EmbeddedSourceSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceSettings/FileSourceSettings
  :cognitect.aws.mediaconvert/FileSourceSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceSettings/SourceType
  :cognitect.aws.mediaconvert/CaptionSourceType)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceSettings/TeletextSourceSettings
  :cognitect.aws.mediaconvert/TeletextSourceSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceSettings/TrackSourceSettings
  :cognitect.aws.mediaconvert/TrackSourceSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionSourceSettings/WebvttHlsSourceSettings
  :cognitect.aws.mediaconvert/WebvttHlsSourceSettings)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/FadeIn
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/ImageInserterInput
  :cognitect.aws.mediaconvert/__stringMin14PatternS3BmpBMPPngPNGTgaTGAHttpsBmpBMPPngPNGTgaTGA)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/Opacity
  :cognitect.aws.mediaconvert/__integerMin0Max100)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/ImageX
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/StartTime
  :cognitect.aws.mediaconvert/__stringPattern01D20305D205D)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/Duration
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/Width
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/FadeOut
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/ImageY
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/Layer
  :cognitect.aws.mediaconvert/__integerMin0Max99)

(s/def
  :cognitect.aws.mediaconvert.InsertableImage/Height
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def :cognitect.aws.mediaconvert.ServiceOverride/Message :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.ServiceOverride/Name :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.ServiceOverride/OverrideValue
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.ServiceOverride/Value :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.AacSettings/Specification
  :cognitect.aws.mediaconvert/AacSpecification)

(s/def :cognitect.aws.mediaconvert.AacSettings/CodingMode :cognitect.aws.mediaconvert/AacCodingMode)

(s/def :cognitect.aws.mediaconvert.AacSettings/RawFormat :cognitect.aws.mediaconvert/AacRawFormat)

(s/def
  :cognitect.aws.mediaconvert.AacSettings/AudioDescriptionBroadcasterMix
  :cognitect.aws.mediaconvert/AacAudioDescriptionBroadcasterMix)

(s/def
  :cognitect.aws.mediaconvert.AacSettings/CodecProfile
  :cognitect.aws.mediaconvert/AacCodecProfile)

(s/def
  :cognitect.aws.mediaconvert.AacSettings/RateControlMode
  :cognitect.aws.mediaconvert/AacRateControlMode)

(s/def
  :cognitect.aws.mediaconvert.AacSettings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin6000Max1024000)

(s/def :cognitect.aws.mediaconvert.AacSettings/VbrQuality :cognitect.aws.mediaconvert/AacVbrQuality)

(s/def
  :cognitect.aws.mediaconvert.AacSettings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin8000Max96000)

(s/def
  :cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/FileInput
  :cognitect.aws.mediaconvert/__stringMin14PatternS3CubeCUBEHttpsCubeCUBE)

(s/def
  :cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/InputColorSpace
  :cognitect.aws.mediaconvert/ColorSpace)

(s/def
  :cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/InputMasteringLuminance
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/OutputColorSpace
  :cognitect.aws.mediaconvert/ColorSpace)

(s/def
  :cognitect.aws.mediaconvert.ColorConversion3DLUTSetting/OutputMasteringLuminance
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/Xavc4kIntraVbrProfileSettings
  :cognitect.aws.mediaconvert/Xavc4kIntraVbrProfileSettings)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/EntropyEncoding
  :cognitect.aws.mediaconvert/XavcEntropyEncoding)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/AdaptiveQuantization
  :cognitect.aws.mediaconvert/XavcAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/XavcHdIntraCbgProfileSettings
  :cognitect.aws.mediaconvert/XavcHdIntraCbgProfileSettings)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/Softness
  :cognitect.aws.mediaconvert/__integerMin0Max128)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/TemporalAdaptiveQuantization
  :cognitect.aws.mediaconvert/XavcTemporalAdaptiveQuantization)

(s/def :cognitect.aws.mediaconvert.XavcSettings/Profile :cognitect.aws.mediaconvert/XavcProfile)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/Xavc4kIntraCbgProfileSettings
  :cognitect.aws.mediaconvert/Xavc4kIntraCbgProfileSettings)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin24Max60000)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/XavcHdProfileSettings
  :cognitect.aws.mediaconvert/XavcHdProfileSettings)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/Xavc4kProfileSettings
  :cognitect.aws.mediaconvert/Xavc4kProfileSettings)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/SpatialAdaptiveQuantization
  :cognitect.aws.mediaconvert/XavcSpatialAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max1001)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/XavcFramerateConversionAlgorithm)

(s/def :cognitect.aws.mediaconvert.XavcSettings/SlowPal :cognitect.aws.mediaconvert/XavcSlowPal)

(s/def
  :cognitect.aws.mediaconvert.XavcSettings/FramerateControl
  :cognitect.aws.mediaconvert/XavcFramerateControl)

(s/def
  :cognitect.aws.mediaconvert.FileGroupSettings/Destination
  :cognitect.aws.mediaconvert/__stringPatternS3)

(s/def
  :cognitect.aws.mediaconvert.FileGroupSettings/DestinationSettings
  :cognitect.aws.mediaconvert/DestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/StatusUpdateInterval
  :cognitect.aws.mediaconvert/StatusUpdateInterval)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/AccelerationSettings
  :cognitect.aws.mediaconvert/AccelerationSettings)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Tags
  :cognitect.aws.mediaconvert/__mapOf__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Queue
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Priority
  :cognitect.aws.mediaconvert/__integerMinNegative50Max50)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Category
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Settings
  :cognitect.aws.mediaconvert/JobTemplateSettings)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Name
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/Description
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateJobTemplateRequest/HopDestinations
  :cognitect.aws.mediaconvert/__listOfHopDestination)

(s/def
  :cognitect.aws.mediaconvert.AutomatedAbrRule/AllowedRenditions
  :cognitect.aws.mediaconvert/__listOfAllowedRenditionSize)

(s/def
  :cognitect.aws.mediaconvert.AutomatedAbrRule/ForceIncludeRenditions
  :cognitect.aws.mediaconvert/__listOfForceIncludeRenditionSize)

(s/def
  :cognitect.aws.mediaconvert.AutomatedAbrRule/MinBottomRenditionSize
  :cognitect.aws.mediaconvert/MinBottomRenditionSize)

(s/def
  :cognitect.aws.mediaconvert.AutomatedAbrRule/MinTopRenditionSize
  :cognitect.aws.mediaconvert/MinTopRenditionSize)

(s/def :cognitect.aws.mediaconvert.AutomatedAbrRule/Type :cognitect.aws.mediaconvert/RuleType)

(s/def
  :cognitect.aws.mediaconvert.PartnerWatermarking/NexguardFileMarkerSettings
  :cognitect.aws.mediaconvert/NexGuardFileMarkerSettings)

(s/def
  :cognitect.aws.mediaconvert.Rectangle/Height
  :cognitect.aws.mediaconvert/__integerMin2Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Rectangle/Width
  :cognitect.aws.mediaconvert/__integerMin2Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Rectangle/X
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Rectangle/Y
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.ListJobsRequest/MaxResults
  :cognitect.aws.mediaconvert/__integerMin1Max20)

(s/def :cognitect.aws.mediaconvert.ListJobsRequest/NextToken :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.ListJobsRequest/Order :cognitect.aws.mediaconvert/Order)

(s/def :cognitect.aws.mediaconvert.ListJobsRequest/Queue :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.ListJobsRequest/Status :cognitect.aws.mediaconvert/JobStatus)

(s/def
  :cognitect.aws.mediaconvert.TeletextDestinationSettings/PageNumber
  :cognitect.aws.mediaconvert/__stringMin3Max3Pattern1809aFAF09aEAE)

(s/def
  :cognitect.aws.mediaconvert.TeletextDestinationSettings/PageTypes
  :cognitect.aws.mediaconvert/__listOfTeletextPageType)

(s/def
  :cognitect.aws.mediaconvert.EncryptionContractConfiguration/SpekeAudioPreset
  :cognitect.aws.mediaconvert/PresetSpeke20Audio)

(s/def
  :cognitect.aws.mediaconvert.EncryptionContractConfiguration/SpekeVideoPreset
  :cognitect.aws.mediaconvert/PresetSpeke20Video)

(s/def
  :cognitect.aws.mediaconvert.DashAdditionalManifest/ManifestNameModifier
  :cognitect.aws.mediaconvert/__stringMin1)

(s/def
  :cognitect.aws.mediaconvert.DashAdditionalManifest/SelectedOutputs
  :cognitect.aws.mediaconvert/__listOf__stringMin1)

(s/def
  :cognitect.aws.mediaconvert.MxfSettings/AfdSignaling
  :cognitect.aws.mediaconvert/MxfAfdSignaling)

(s/def :cognitect.aws.mediaconvert.MxfSettings/Profile :cognitect.aws.mediaconvert/MxfProfile)

(s/def
  :cognitect.aws.mediaconvert.MxfSettings/XavcProfileSettings
  :cognitect.aws.mediaconvert/MxfXavcProfileSettings)

(s/def :cognitect.aws.mediaconvert.SearchJobsRequest/InputFile :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.SearchJobsRequest/MaxResults
  :cognitect.aws.mediaconvert/__integerMin1Max20)

(s/def :cognitect.aws.mediaconvert.SearchJobsRequest/NextToken :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.SearchJobsRequest/Order :cognitect.aws.mediaconvert/Order)

(s/def :cognitect.aws.mediaconvert.SearchJobsRequest/Queue :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.SearchJobsRequest/Status :cognitect.aws.mediaconvert/JobStatus)

(s/def
  :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/IntervalCadence
  :cognitect.aws.mediaconvert/HlsIntervalCadence)

(s/def
  :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/ThumbnailHeight
  :cognitect.aws.mediaconvert/__integerMin2Max4096)

(s/def
  :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/ThumbnailInterval
  :cognitect.aws.mediaconvert/__doubleMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/ThumbnailWidth
  :cognitect.aws.mediaconvert/__integerMin8Max4096)

(s/def
  :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/TileHeight
  :cognitect.aws.mediaconvert/__integerMin1Max2048)

(s/def
  :cognitect.aws.mediaconvert.HlsImageBasedTrickPlaySettings/TileWidth
  :cognitect.aws.mediaconvert/__integerMin1Max512)

(s/def :cognitect.aws.mediaconvert.VideoDetail/HeightInPx :cognitect.aws.mediaconvert/__integer)

(s/def :cognitect.aws.mediaconvert.VideoDetail/WidthInPx :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Plus/MasteringMonitorNits
  :cognitect.aws.mediaconvert/__integerMin0Max4000)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Plus/TargetMonitorNits
  :cognitect.aws.mediaconvert/__integerMin0Max4000)

(s/def :cognitect.aws.mediaconvert.NotFoundException/Message :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.H264Settings/Telecine :cognitect.aws.mediaconvert/H264Telecine)

(s/def :cognitect.aws.mediaconvert.H264Settings/GopSize :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/EntropyEncoding
  :cognitect.aws.mediaconvert/H264EntropyEncoding)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/InterlaceMode
  :cognitect.aws.mediaconvert/H264InterlaceMode)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/AdaptiveQuantization
  :cognitect.aws.mediaconvert/H264AdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/QualityTuningLevel
  :cognitect.aws.mediaconvert/H264QualityTuningLevel)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/ParNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/EndOfStreamMarkers
  :cognitect.aws.mediaconvert/H264EndOfStreamMarkers)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/HrdBufferSize
  :cognitect.aws.mediaconvert/__integerMin0Max1152000000)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/Softness
  :cognitect.aws.mediaconvert/__integerMin0Max128)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/TemporalAdaptiveQuantization
  :cognitect.aws.mediaconvert/H264TemporalAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/NumberBFramesBetweenReferenceFrames
  :cognitect.aws.mediaconvert/__integerMin0Max7)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/UnregisteredSeiTimecode
  :cognitect.aws.mediaconvert/H264UnregisteredSeiTimecode)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/ParDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/SaliencyAwareEncoding
  :cognitect.aws.mediaconvert/H264SaliencyAwareEncoding)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/DynamicSubGop
  :cognitect.aws.mediaconvert/H264DynamicSubGop)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/SceneChangeDetect
  :cognitect.aws.mediaconvert/H264SceneChangeDetect)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/CodecProfile
  :cognitect.aws.mediaconvert/H264CodecProfile)

(s/def :cognitect.aws.mediaconvert.H264Settings/RepeatPps :cognitect.aws.mediaconvert/H264RepeatPps)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/HrdBufferFinalFillPercentage
  :cognitect.aws.mediaconvert/__integerMin0Max100)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/WriteMp4PackagingType
  :cognitect.aws.mediaconvert/H264WriteMp4PackagingType)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/MinIInterval
  :cognitect.aws.mediaconvert/__integerMin0Max30)

(s/def :cognitect.aws.mediaconvert.H264Settings/Syntax :cognitect.aws.mediaconvert/H264Syntax)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/QvbrSettings
  :cognitect.aws.mediaconvert/H264QvbrSettings)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/RateControlMode
  :cognitect.aws.mediaconvert/H264RateControlMode)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max1152000000)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/SpatialAdaptiveQuantization
  :cognitect.aws.mediaconvert/H264SpatialAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/ParControl
  :cognitect.aws.mediaconvert/H264ParControl)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/NumberReferenceFrames
  :cognitect.aws.mediaconvert/__integerMin1Max6)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/GopSizeUnits
  :cognitect.aws.mediaconvert/H264GopSizeUnits)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/MaxBitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max1152000000)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/FieldEncoding
  :cognitect.aws.mediaconvert/H264FieldEncoding)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/Slices
  :cognitect.aws.mediaconvert/__integerMin1Max32)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/CodecLevel
  :cognitect.aws.mediaconvert/H264CodecLevel)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/H264FramerateConversionAlgorithm)

(s/def :cognitect.aws.mediaconvert.H264Settings/SlowPal :cognitect.aws.mediaconvert/H264SlowPal)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/GopClosedCadence
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/GopBReference
  :cognitect.aws.mediaconvert/H264GopBReference)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/BandwidthReductionFilter
  :cognitect.aws.mediaconvert/BandwidthReductionFilter)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/HrdBufferInitialFillPercentage
  :cognitect.aws.mediaconvert/__integerMin0Max100)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/FlickerAdaptiveQuantization
  :cognitect.aws.mediaconvert/H264FlickerAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/ScanTypeConversionMode
  :cognitect.aws.mediaconvert/H264ScanTypeConversionMode)

(s/def
  :cognitect.aws.mediaconvert.H264Settings/FramerateControl
  :cognitect.aws.mediaconvert/H264FramerateControl)

(s/def :cognitect.aws.mediaconvert.VideoCodecSettings/Codec :cognitect.aws.mediaconvert/VideoCodec)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/Vp8Settings
  :cognitect.aws.mediaconvert/Vp8Settings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/Av1Settings
  :cognitect.aws.mediaconvert/Av1Settings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/ProresSettings
  :cognitect.aws.mediaconvert/ProresSettings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/XavcSettings
  :cognitect.aws.mediaconvert/XavcSettings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/H264Settings
  :cognitect.aws.mediaconvert/H264Settings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/GifSettings
  :cognitect.aws.mediaconvert/GifSettings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/Vc3Settings
  :cognitect.aws.mediaconvert/Vc3Settings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/UncompressedSettings
  :cognitect.aws.mediaconvert/UncompressedSettings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/FrameCaptureSettings
  :cognitect.aws.mediaconvert/FrameCaptureSettings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/H265Settings
  :cognitect.aws.mediaconvert/H265Settings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/AvcIntraSettings
  :cognitect.aws.mediaconvert/AvcIntraSettings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/Vp9Settings
  :cognitect.aws.mediaconvert/Vp9Settings)

(s/def
  :cognitect.aws.mediaconvert.VideoCodecSettings/Mpeg2Settings
  :cognitect.aws.mediaconvert/Mpeg2Settings)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/PassthroughControl
  :cognitect.aws.mediaconvert/Eac3PassthroughControl)

(s/def :cognitect.aws.mediaconvert.Eac3Settings/LfeFilter :cognitect.aws.mediaconvert/Eac3LfeFilter)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/StereoDownmix
  :cognitect.aws.mediaconvert/Eac3StereoDownmix)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/BitstreamMode
  :cognitect.aws.mediaconvert/Eac3BitstreamMode)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/SurroundMode
  :cognitect.aws.mediaconvert/Eac3SurroundMode)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/SurroundExMode
  :cognitect.aws.mediaconvert/Eac3SurroundExMode)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/CodingMode
  :cognitect.aws.mediaconvert/Eac3CodingMode)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/AttenuationControl
  :cognitect.aws.mediaconvert/Eac3AttenuationControl)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/PhaseControl
  :cognitect.aws.mediaconvert/Eac3PhaseControl)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/LtRtSurroundMixLevel
  :cognitect.aws.mediaconvert/__doubleMinNegative60MaxNegative1)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin32000Max3024000)

(s/def :cognitect.aws.mediaconvert.Eac3Settings/DcFilter :cognitect.aws.mediaconvert/Eac3DcFilter)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/LtRtCenterMixLevel
  :cognitect.aws.mediaconvert/__doubleMinNegative60Max3)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/MetadataControl
  :cognitect.aws.mediaconvert/Eac3MetadataControl)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/DynamicRangeCompressionRf
  :cognitect.aws.mediaconvert/Eac3DynamicRangeCompressionRf)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin48000Max48000)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/DynamicRangeCompressionLine
  :cognitect.aws.mediaconvert/Eac3DynamicRangeCompressionLine)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/LoRoSurroundMixLevel
  :cognitect.aws.mediaconvert/__doubleMinNegative60MaxNegative1)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/Dialnorm
  :cognitect.aws.mediaconvert/__integerMin1Max31)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/LoRoCenterMixLevel
  :cognitect.aws.mediaconvert/__doubleMinNegative60Max3)

(s/def
  :cognitect.aws.mediaconvert.Eac3Settings/LfeControl
  :cognitect.aws.mediaconvert/Eac3LfeControl)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/CertificateArn
  :cognitect.aws.mediaconvert/__stringPatternArnAwsUsGovAcm)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/DashSignaledSystemIds
  :cognitect.aws.mediaconvert/__listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/EncryptionContractConfiguration
  :cognitect.aws.mediaconvert/EncryptionContractConfiguration)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/HlsSignaledSystemIds
  :cognitect.aws.mediaconvert/__listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/ResourceId
  :cognitect.aws.mediaconvert/__stringPatternW)

(s/def
  :cognitect.aws.mediaconvert.SpekeKeyProviderCmaf/Url
  :cognitect.aws.mediaconvert/__stringPatternHttpsD)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/MaxPcrInterval
  :cognitect.aws.mediaconvert/__integerMin0Max500)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/Scte35Pid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/PtsOffset
  :cognitect.aws.mediaconvert/__integerMin0Max3600)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/NielsenId3
  :cognitect.aws.mediaconvert/M3u8NielsenId3)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/VideoPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/PcrControl
  :cognitect.aws.mediaconvert/M3u8PcrControl)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/PatInterval
  :cognitect.aws.mediaconvert/__integerMin0Max1000)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/PrivateMetadataPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/AudioPids
  :cognitect.aws.mediaconvert/__listOf__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/PcrPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/AudioDuration
  :cognitect.aws.mediaconvert/M3u8AudioDuration)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/ProgramNumber
  :cognitect.aws.mediaconvert/__integerMin0Max65535)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/Scte35Source
  :cognitect.aws.mediaconvert/M3u8Scte35Source)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/TransportStreamId
  :cognitect.aws.mediaconvert/__integerMin0Max65535)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/PmtPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/PmtInterval
  :cognitect.aws.mediaconvert/__integerMin0Max1000)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/DataPTSControl
  :cognitect.aws.mediaconvert/M3u8DataPtsControl)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/PtsOffsetMode
  :cognitect.aws.mediaconvert/TsPtsOffset)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/TimedMetadata
  :cognitect.aws.mediaconvert/TimedMetadata)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/AudioFramesPerPes
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.M3u8Settings/TimedMetadataPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.GifSettings/FramerateControl
  :cognitect.aws.mediaconvert/GifFramerateControl)

(s/def
  :cognitect.aws.mediaconvert.GifSettings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/GifFramerateConversionAlgorithm)

(s/def
  :cognitect.aws.mediaconvert.GifSettings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.GifSettings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.WebvttDestinationSettings/Accessibility
  :cognitect.aws.mediaconvert/WebvttAccessibilitySubs)

(s/def
  :cognitect.aws.mediaconvert.WebvttDestinationSettings/StylePassthrough
  :cognitect.aws.mediaconvert/WebvttStylePassthrough)

(s/def
  :cognitect.aws.mediaconvert.XavcHdProfileSettings/Telecine
  :cognitect.aws.mediaconvert/XavcHdProfileTelecine)

(s/def
  :cognitect.aws.mediaconvert.XavcHdProfileSettings/InterlaceMode
  :cognitect.aws.mediaconvert/XavcInterlaceMode)

(s/def
  :cognitect.aws.mediaconvert.XavcHdProfileSettings/QualityTuningLevel
  :cognitect.aws.mediaconvert/XavcHdProfileQualityTuningLevel)

(s/def
  :cognitect.aws.mediaconvert.XavcHdProfileSettings/HrdBufferSize
  :cognitect.aws.mediaconvert/__integerMin0Max1152000000)

(s/def
  :cognitect.aws.mediaconvert.XavcHdProfileSettings/BitrateClass
  :cognitect.aws.mediaconvert/XavcHdProfileBitrateClass)

(s/def
  :cognitect.aws.mediaconvert.XavcHdProfileSettings/Slices
  :cognitect.aws.mediaconvert/__integerMin4Max12)

(s/def
  :cognitect.aws.mediaconvert.XavcHdProfileSettings/GopClosedCadence
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.XavcHdProfileSettings/GopBReference
  :cognitect.aws.mediaconvert/XavcGopBReference)

(s/def
  :cognitect.aws.mediaconvert.XavcHdProfileSettings/FlickerAdaptiveQuantization
  :cognitect.aws.mediaconvert/XavcFlickerAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.ExtendedDataServices/CopyProtectionAction
  :cognitect.aws.mediaconvert/CopyProtectionAction)

(s/def
  :cognitect.aws.mediaconvert.ExtendedDataServices/VchipAction
  :cognitect.aws.mediaconvert/VchipAction)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/MaxLuminance
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/ColorSpaceConversion
  :cognitect.aws.mediaconvert/ColorSpaceConversion)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/Saturation
  :cognitect.aws.mediaconvert/__integerMin1Max100)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/Contrast
  :cognitect.aws.mediaconvert/__integerMin1Max100)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/SampleRangeConversion
  :cognitect.aws.mediaconvert/SampleRangeConversion)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/HdrToSdrToneMapper
  :cognitect.aws.mediaconvert/HDRToSDRToneMapper)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/Brightness
  :cognitect.aws.mediaconvert/__integerMin1Max100)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/Hue
  :cognitect.aws.mediaconvert/__integerMinNegative180Max180)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/Hdr10Metadata
  :cognitect.aws.mediaconvert/Hdr10Metadata)

(s/def :cognitect.aws.mediaconvert.ColorCorrector/ClipLimits :cognitect.aws.mediaconvert/ClipLimits)

(s/def
  :cognitect.aws.mediaconvert.ColorCorrector/SdrReferenceWhiteLevel
  :cognitect.aws.mediaconvert/__integerMin100Max1000)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/AvailBlanking
  :cognitect.aws.mediaconvert/AvailBlanking)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/Inputs
  :cognitect.aws.mediaconvert/__listOfInputTemplate)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/MotionImageInserter
  :cognitect.aws.mediaconvert/MotionImageInserter)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/ColorConversion3DLUTSettings
  :cognitect.aws.mediaconvert/__listOfColorConversion3DLUTSetting)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/NielsenNonLinearWatermark
  :cognitect.aws.mediaconvert/NielsenNonLinearWatermarkSettings)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/Esam
  :cognitect.aws.mediaconvert/EsamSettings)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/NielsenConfiguration
  :cognitect.aws.mediaconvert/NielsenConfiguration)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/FollowSource
  :cognitect.aws.mediaconvert/__integerMin1Max150)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/KantarWatermark
  :cognitect.aws.mediaconvert/KantarWatermarkSettings)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/ExtendedDataServices
  :cognitect.aws.mediaconvert/ExtendedDataServices)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/OutputGroups
  :cognitect.aws.mediaconvert/__listOfOutputGroup)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/TimedMetadataInsertion
  :cognitect.aws.mediaconvert/TimedMetadataInsertion)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/AdAvailOffset
  :cognitect.aws.mediaconvert/__integerMinNegative1000Max1000)

(s/def
  :cognitect.aws.mediaconvert.JobTemplateSettings/TimecodeConfig
  :cognitect.aws.mediaconvert/TimecodeConfig)

(s/def :cognitect.aws.mediaconvert.SearchJobsResponse/Jobs :cognitect.aws.mediaconvert/__listOfJob)

(s/def
  :cognitect.aws.mediaconvert.SearchJobsResponse/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.DynamicAudioSelector/AudioDurationCorrection
  :cognitect.aws.mediaconvert/AudioDurationCorrection)

(s/def
  :cognitect.aws.mediaconvert.DynamicAudioSelector/ExternalAudioFileInput
  :cognitect.aws.mediaconvert/__stringPatternS3Https)

(s/def
  :cognitect.aws.mediaconvert.DynamicAudioSelector/LanguageCode
  :cognitect.aws.mediaconvert/LanguageCode)

(s/def
  :cognitect.aws.mediaconvert.DynamicAudioSelector/Offset
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DynamicAudioSelector/SelectorType
  :cognitect.aws.mediaconvert/DynamicAudioSelectorType)

(s/def :cognitect.aws.mediaconvert.CreateQueueResponse/Queue :cognitect.aws.mediaconvert/Queue)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothEncryptionSettings/SpekeKeyProvider
  :cognitect.aws.mediaconvert/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediaconvert.AllowedRenditionSize/Height
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def
  :cognitect.aws.mediaconvert.AllowedRenditionSize/Required
  :cognitect.aws.mediaconvert/RequiredFlag)

(s/def
  :cognitect.aws.mediaconvert.AllowedRenditionSize/Width
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def
  :cognitect.aws.mediaconvert.AutomatedAbrSettings/MaxAbrBitrate
  :cognitect.aws.mediaconvert/__integerMin100000Max100000000)

(s/def
  :cognitect.aws.mediaconvert.AutomatedAbrSettings/MaxRenditions
  :cognitect.aws.mediaconvert/__integerMin3Max15)

(s/def
  :cognitect.aws.mediaconvert.AutomatedAbrSettings/MinAbrBitrate
  :cognitect.aws.mediaconvert/__integerMin100000Max100000000)

(s/def
  :cognitect.aws.mediaconvert.AutomatedAbrSettings/Rules
  :cognitect.aws.mediaconvert/__listOfAutomatedAbrRule)

(s/def :cognitect.aws.mediaconvert.Vc3Settings/Telecine :cognitect.aws.mediaconvert/Vc3Telecine)

(s/def
  :cognitect.aws.mediaconvert.Vc3Settings/InterlaceMode
  :cognitect.aws.mediaconvert/Vc3InterlaceMode)

(s/def
  :cognitect.aws.mediaconvert.Vc3Settings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin24Max60000)

(s/def
  :cognitect.aws.mediaconvert.Vc3Settings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max1001)

(s/def
  :cognitect.aws.mediaconvert.Vc3Settings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/Vc3FramerateConversionAlgorithm)

(s/def :cognitect.aws.mediaconvert.Vc3Settings/Vc3Class :cognitect.aws.mediaconvert/Vc3Class)

(s/def :cognitect.aws.mediaconvert.Vc3Settings/SlowPal :cognitect.aws.mediaconvert/Vc3SlowPal)

(s/def
  :cognitect.aws.mediaconvert.Vc3Settings/ScanTypeConversionMode
  :cognitect.aws.mediaconvert/Vc3ScanTypeConversionMode)

(s/def
  :cognitect.aws.mediaconvert.Vc3Settings/FramerateControl
  :cognitect.aws.mediaconvert/Vc3FramerateControl)

(s/def
  :cognitect.aws.mediaconvert.UncompressedSettings/Telecine
  :cognitect.aws.mediaconvert/UncompressedTelecine)

(s/def
  :cognitect.aws.mediaconvert.UncompressedSettings/InterlaceMode
  :cognitect.aws.mediaconvert/UncompressedInterlaceMode)

(s/def
  :cognitect.aws.mediaconvert.UncompressedSettings/Fourcc
  :cognitect.aws.mediaconvert/UncompressedFourcc)

(s/def
  :cognitect.aws.mediaconvert.UncompressedSettings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.UncompressedSettings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.UncompressedSettings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/UncompressedFramerateConversionAlgorithm)

(s/def
  :cognitect.aws.mediaconvert.UncompressedSettings/SlowPal
  :cognitect.aws.mediaconvert/UncompressedSlowPal)

(s/def
  :cognitect.aws.mediaconvert.UncompressedSettings/ScanTypeConversionMode
  :cognitect.aws.mediaconvert/UncompressedScanTypeConversionMode)

(s/def
  :cognitect.aws.mediaconvert.UncompressedSettings/FramerateControl
  :cognitect.aws.mediaconvert/UncompressedFramerateControl)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/ManifestMetadataSignaling
  :cognitect.aws.mediaconvert/CmfcManifestMetadataSignaling)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/AudioRenditionSets
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/KlvMetadata
  :cognitect.aws.mediaconvert/CmfcKlvMetadata)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/AudioTrackType
  :cognitect.aws.mediaconvert/CmfcAudioTrackType)

(s/def :cognitect.aws.mediaconvert.CmfcSettings/AudioGroupId :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/DescriptiveVideoServiceFlag
  :cognitect.aws.mediaconvert/CmfcDescriptiveVideoServiceFlag)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/AudioDuration
  :cognitect.aws.mediaconvert/CmfcAudioDuration)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/TimedMetadataValue
  :cognitect.aws.mediaconvert/__stringMax1000)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/Scte35Esam
  :cognitect.aws.mediaconvert/CmfcScte35Esam)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/Scte35Source
  :cognitect.aws.mediaconvert/CmfcScte35Source)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/TimedMetadataBoxVersion
  :cognitect.aws.mediaconvert/CmfcTimedMetadataBoxVersion)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/IFrameOnlyManifest
  :cognitect.aws.mediaconvert/CmfcIFrameOnlyManifest)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/TimedMetadataSchemeIdUri
  :cognitect.aws.mediaconvert/__stringMax1000)

(s/def
  :cognitect.aws.mediaconvert.CmfcSettings/TimedMetadata
  :cognitect.aws.mediaconvert/CmfcTimedMetadata)

(s/def
  :cognitect.aws.mediaconvert.CaptionDescription/CaptionSelectorName
  :cognitect.aws.mediaconvert/__stringMin1)

(s/def
  :cognitect.aws.mediaconvert.CaptionDescription/CustomLanguageCode
  :cognitect.aws.mediaconvert/__stringPatternAZaZ23AZaZ)

(s/def
  :cognitect.aws.mediaconvert.CaptionDescription/DestinationSettings
  :cognitect.aws.mediaconvert/CaptionDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDescription/LanguageCode
  :cognitect.aws.mediaconvert/LanguageCode)

(s/def
  :cognitect.aws.mediaconvert.CaptionDescription/LanguageDescription
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.ImscDestinationSettings/Accessibility
  :cognitect.aws.mediaconvert/ImscAccessibilitySubs)

(s/def
  :cognitect.aws.mediaconvert.ImscDestinationSettings/StylePassthrough
  :cognitect.aws.mediaconvert/ImscStylePassthrough)

(s/def :cognitect.aws.mediaconvert.Queue/CreatedAt :cognitect.aws.mediaconvert/__timestampUnix)

(s/def :cognitect.aws.mediaconvert.Queue/LastUpdated :cognitect.aws.mediaconvert/__timestampUnix)

(s/def :cognitect.aws.mediaconvert.Queue/SubmittedJobsCount :cognitect.aws.mediaconvert/__integer)

(s/def :cognitect.aws.mediaconvert.Queue/ProgressingJobsCount :cognitect.aws.mediaconvert/__integer)

(s/def :cognitect.aws.mediaconvert.Queue/Arn :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Queue/PricingPlan :cognitect.aws.mediaconvert/PricingPlan)

(s/def :cognitect.aws.mediaconvert.Queue/Name :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Queue/Description :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Queue/Type :cognitect.aws.mediaconvert/Type)

(s/def
  :cognitect.aws.mediaconvert.Queue/ReservationPlan
  :cognitect.aws.mediaconvert/ReservationPlan)

(s/def
  :cognitect.aws.mediaconvert.Queue/ServiceOverrides
  :cognitect.aws.mediaconvert/__listOfServiceOverride)

(s/def :cognitect.aws.mediaconvert.Queue/ConcurrentJobs :cognitect.aws.mediaconvert/__integer)

(s/def :cognitect.aws.mediaconvert.Queue/Status :cognitect.aws.mediaconvert/QueueStatus)

(s/def
  :cognitect.aws.mediaconvert.UpdateQueueRequest/ConcurrentJobs
  :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.UpdateQueueRequest/Description
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.UpdateQueueRequest/Name :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.UpdateQueueRequest/ReservationPlanSettings
  :cognitect.aws.mediaconvert/ReservationPlanSettings)

(s/def
  :cognitect.aws.mediaconvert.UpdateQueueRequest/Status
  :cognitect.aws.mediaconvert/QueueStatus)

(s/def
  :cognitect.aws.mediaconvert.DashIsoEncryptionSettings/PlaybackDeviceCompatibility
  :cognitect.aws.mediaconvert/DashIsoPlaybackDeviceCompatibility)

(s/def
  :cognitect.aws.mediaconvert.DashIsoEncryptionSettings/SpekeKeyProvider
  :cognitect.aws.mediaconvert/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediaconvert.CaptionSelector/CustomLanguageCode
  :cognitect.aws.mediaconvert/__stringMin3Max3PatternAZaZ3)

(s/def
  :cognitect.aws.mediaconvert.CaptionSelector/LanguageCode
  :cognitect.aws.mediaconvert/LanguageCode)

(s/def
  :cognitect.aws.mediaconvert.CaptionSelector/SourceSettings
  :cognitect.aws.mediaconvert/CaptionSourceSettings)

(s/def
  :cognitect.aws.mediaconvert.S3DestinationSettings/AccessControl
  :cognitect.aws.mediaconvert/S3DestinationAccessControl)

(s/def
  :cognitect.aws.mediaconvert.S3DestinationSettings/Encryption
  :cognitect.aws.mediaconvert/S3EncryptionSettings)

(s/def
  :cognitect.aws.mediaconvert.S3DestinationSettings/StorageClass
  :cognitect.aws.mediaconvert/S3StorageClass)

(s/def
  :cognitect.aws.mediaconvert.TeletextSourceSettings/PageNumber
  :cognitect.aws.mediaconvert/__stringMin3Max3Pattern1809aFAF09aEAE)

(s/def
  :cognitect.aws.mediaconvert.AudioChannelTaggingSettings/ChannelTag
  :cognitect.aws.mediaconvert/AudioChannelTag)

(s/def
  :cognitect.aws.mediaconvert.AudioChannelTaggingSettings/ChannelTags
  :cognitect.aws.mediaconvert/__listOfAudioChannelTag)

(s/def
  :cognitect.aws.mediaconvert.RemixSettings/AudioDescriptionAudioChannel
  :cognitect.aws.mediaconvert/__integerMin1Max64)

(s/def
  :cognitect.aws.mediaconvert.RemixSettings/AudioDescriptionDataChannel
  :cognitect.aws.mediaconvert/__integerMin1Max64)

(s/def
  :cognitect.aws.mediaconvert.RemixSettings/ChannelMapping
  :cognitect.aws.mediaconvert/ChannelMapping)

(s/def
  :cognitect.aws.mediaconvert.RemixSettings/ChannelsIn
  :cognitect.aws.mediaconvert/__integerMin1Max64)

(s/def
  :cognitect.aws.mediaconvert.RemixSettings/ChannelsOut
  :cognitect.aws.mediaconvert/__integerMin1Max64)

(s/def
  :cognitect.aws.mediaconvert.EsamSettings/ManifestConfirmConditionNotification
  :cognitect.aws.mediaconvert/EsamManifestConfirmConditionNotification)

(s/def
  :cognitect.aws.mediaconvert.EsamSettings/ResponseSignalPreroll
  :cognitect.aws.mediaconvert/__integerMin0Max30000)

(s/def
  :cognitect.aws.mediaconvert.EsamSettings/SignalProcessingNotification
  :cognitect.aws.mediaconvert/EsamSignalProcessingNotification)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kProfileSettings/BitrateClass
  :cognitect.aws.mediaconvert/Xavc4kProfileBitrateClass)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kProfileSettings/CodecProfile
  :cognitect.aws.mediaconvert/Xavc4kProfileCodecProfile)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kProfileSettings/FlickerAdaptiveQuantization
  :cognitect.aws.mediaconvert/XavcFlickerAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kProfileSettings/GopBReference
  :cognitect.aws.mediaconvert/XavcGopBReference)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kProfileSettings/GopClosedCadence
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kProfileSettings/HrdBufferSize
  :cognitect.aws.mediaconvert/__integerMin0Max1152000000)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kProfileSettings/QualityTuningLevel
  :cognitect.aws.mediaconvert/Xavc4kProfileQualityTuningLevel)

(s/def
  :cognitect.aws.mediaconvert.Xavc4kProfileSettings/Slices
  :cognitect.aws.mediaconvert/__integerMin8Max12)

(s/def
  :cognitect.aws.mediaconvert.FrameCaptureSettings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.FrameCaptureSettings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.FrameCaptureSettings/MaxCaptures
  :cognitect.aws.mediaconvert/__integerMin1Max10000000)

(s/def
  :cognitect.aws.mediaconvert.FrameCaptureSettings/Quality
  :cognitect.aws.mediaconvert/__integerMin1Max100)

(s/def
  :cognitect.aws.mediaconvert.OutputGroupDetail/OutputDetails
  :cognitect.aws.mediaconvert/__listOfOutputDetail)

(s/def
  :cognitect.aws.mediaconvert.ListTagsForResourceRequest/Arn
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.DisassociateCertificateRequest/Arn
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.ListPresetsRequest/Category :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.ListPresetsRequest/ListBy
  :cognitect.aws.mediaconvert/PresetListBy)

(s/def
  :cognitect.aws.mediaconvert.ListPresetsRequest/MaxResults
  :cognitect.aws.mediaconvert/__integerMin1Max20)

(s/def
  :cognitect.aws.mediaconvert.ListPresetsRequest/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.ListPresetsRequest/Order :cognitect.aws.mediaconvert/Order)

(s/def :cognitect.aws.mediaconvert.DeleteQueueRequest/Name :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Job/ErrorCode :cognitect.aws.mediaconvert/__integer)

(s/def :cognitect.aws.mediaconvert.Job/JobTemplate :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Job/CreatedAt :cognitect.aws.mediaconvert/__timestampUnix)

(s/def :cognitect.aws.mediaconvert.Job/CurrentPhase :cognitect.aws.mediaconvert/JobPhase)

(s/def :cognitect.aws.mediaconvert.Job/JobEngineVersionUsed :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.Job/AccelerationStatus
  :cognitect.aws.mediaconvert/AccelerationStatus)

(s/def :cognitect.aws.mediaconvert.Job/JobPercentComplete :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.Job/StatusUpdateInterval
  :cognitect.aws.mediaconvert/StatusUpdateInterval)

(s/def :cognitect.aws.mediaconvert.Job/ErrorMessage :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Job/Id :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Job/Messages :cognitect.aws.mediaconvert/JobMessages)

(s/def
  :cognitect.aws.mediaconvert.Job/AccelerationSettings
  :cognitect.aws.mediaconvert/AccelerationSettings)

(s/def
  :cognitect.aws.mediaconvert.Job/JobEngineVersionRequested
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Job/UserMetadata :cognitect.aws.mediaconvert/__mapOf__string)

(s/def :cognitect.aws.mediaconvert.Job/Queue :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.Job/Priority
  :cognitect.aws.mediaconvert/__integerMinNegative50Max50)

(s/def :cognitect.aws.mediaconvert.Job/ClientRequestToken :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.Job/OutputGroupDetails
  :cognitect.aws.mediaconvert/__listOfOutputGroupDetail)

(s/def :cognitect.aws.mediaconvert.Job/Settings :cognitect.aws.mediaconvert/JobSettings)

(s/def :cognitect.aws.mediaconvert.Job/Arn :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Job/Warnings :cognitect.aws.mediaconvert/__listOfWarningGroup)

(s/def
  :cognitect.aws.mediaconvert.Job/SimulateReservedQueue
  :cognitect.aws.mediaconvert/SimulateReservedQueue)

(s/def
  :cognitect.aws.mediaconvert.Job/QueueTransitions
  :cognitect.aws.mediaconvert/__listOfQueueTransition)

(s/def :cognitect.aws.mediaconvert.Job/Timing :cognitect.aws.mediaconvert/Timing)

(s/def :cognitect.aws.mediaconvert.Job/RetryCount :cognitect.aws.mediaconvert/__integer)

(s/def :cognitect.aws.mediaconvert.Job/Role :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.Job/BillingTagsSource
  :cognitect.aws.mediaconvert/BillingTagsSource)

(s/def
  :cognitect.aws.mediaconvert.Job/HopDestinations
  :cognitect.aws.mediaconvert/__listOfHopDestination)

(s/def :cognitect.aws.mediaconvert.Job/Status :cognitect.aws.mediaconvert/JobStatus)

(s/def :cognitect.aws.mediaconvert.GetPresetResponse/Preset :cognitect.aws.mediaconvert/Preset)

(s/def
  :cognitect.aws.mediaconvert.FlacSettings/BitDepth
  :cognitect.aws.mediaconvert/__integerMin16Max24)

(s/def
  :cognitect.aws.mediaconvert.FlacSettings/Channels
  :cognitect.aws.mediaconvert/__integerMin1Max8)

(s/def
  :cognitect.aws.mediaconvert.FlacSettings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin22050Max48000)

(s/def
  :cognitect.aws.mediaconvert.CreatePresetRequest/Category
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreatePresetRequest/Description
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.CreatePresetRequest/Name :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreatePresetRequest/Settings
  :cognitect.aws.mediaconvert/PresetSettings)

(s/def
  :cognitect.aws.mediaconvert.CreatePresetRequest/Tags
  :cognitect.aws.mediaconvert/__mapOf__string)

(s/def :cognitect.aws.mediaconvert.GetJobRequest/Id :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.AiffSettings/BitDepth
  :cognitect.aws.mediaconvert/__integerMin16Max24)

(s/def
  :cognitect.aws.mediaconvert.AiffSettings/Channels
  :cognitect.aws.mediaconvert/__integerMin1Max64)

(s/def
  :cognitect.aws.mediaconvert.AiffSettings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin8000Max192000)

(s/def
  :cognitect.aws.mediaconvert.JobEngineVersion/ExpirationDate
  :cognitect.aws.mediaconvert/__timestampUnix)

(s/def :cognitect.aws.mediaconvert.JobEngineVersion/Version :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/DvbSdtSettings
  :cognitect.aws.mediaconvert/DvbSdtSettings)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/MaxPcrInterval
  :cognitect.aws.mediaconvert/__integerMin0Max500)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/ForceTsVideoEbpOrder
  :cognitect.aws.mediaconvert/M2tsForceTsVideoEbpOrder)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/Scte35Pid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/EsRateInPes
  :cognitect.aws.mediaconvert/M2tsEsRateInPes)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/SegmentationTime
  :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/PtsOffset
  :cognitect.aws.mediaconvert/__integerMin0Max3600)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/NielsenId3
  :cognitect.aws.mediaconvert/M2tsNielsenId3)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/SegmentationStyle
  :cognitect.aws.mediaconvert/M2tsSegmentationStyle)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/VideoPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/PcrControl
  :cognitect.aws.mediaconvert/M2tsPcrControl)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/DvbSubPids
  :cognitect.aws.mediaconvert/__listOf__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/KlvMetadata
  :cognitect.aws.mediaconvert/M2tsKlvMetadata)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/BufferModel
  :cognitect.aws.mediaconvert/M2tsBufferModel)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/PatInterval
  :cognitect.aws.mediaconvert/__integerMin0Max1000)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/DvbTeletextPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/AudioBufferModel
  :cognitect.aws.mediaconvert/M2tsAudioBufferModel)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/SegmentationMarkers
  :cognitect.aws.mediaconvert/M2tsSegmentationMarkers)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/EbpPlacement
  :cognitect.aws.mediaconvert/M2tsEbpPlacement)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/PrivateMetadataPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/AudioPids
  :cognitect.aws.mediaconvert/__listOf__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/NullPacketBitrate
  :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/EbpAudioInterval
  :cognitect.aws.mediaconvert/M2tsEbpAudioInterval)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/PcrPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/AudioDuration
  :cognitect.aws.mediaconvert/M2tsAudioDuration)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/DvbTdtSettings
  :cognitect.aws.mediaconvert/DvbTdtSettings)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/Scte35Esam
  :cognitect.aws.mediaconvert/M2tsScte35Esam)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/ProgramNumber
  :cognitect.aws.mediaconvert/__integerMin0Max65535)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/Scte35Source
  :cognitect.aws.mediaconvert/M2tsScte35Source)

(s/def :cognitect.aws.mediaconvert.M2tsSettings/RateMode :cognitect.aws.mediaconvert/M2tsRateMode)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/TransportStreamId
  :cognitect.aws.mediaconvert/__integerMin0Max65535)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/PmtPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/PreventBufferUnderflow
  :cognitect.aws.mediaconvert/M2tsPreventBufferUnderflow)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/PmtInterval
  :cognitect.aws.mediaconvert/__integerMin0Max1000)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/MinEbpInterval
  :cognitect.aws.mediaconvert/__integerMin0Max10000)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/DataPTSControl
  :cognitect.aws.mediaconvert/M2tsDataPtsControl)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/FragmentTime
  :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/DvbNitSettings
  :cognitect.aws.mediaconvert/DvbNitSettings)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/PtsOffsetMode
  :cognitect.aws.mediaconvert/TsPtsOffset)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/AudioFramesPerPes
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.M2tsSettings/TimedMetadataPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def :cognitect.aws.mediaconvert.DeletePresetRequest/Name :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.H265QvbrSettings/MaxAverageBitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max1466400000)

(s/def
  :cognitect.aws.mediaconvert.H265QvbrSettings/QvbrQualityLevel
  :cognitect.aws.mediaconvert/__integerMin1Max10)

(s/def
  :cognitect.aws.mediaconvert.H265QvbrSettings/QvbrQualityLevelFineTune
  :cognitect.aws.mediaconvert/__doubleMin0Max1)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducerFilterSettings/Strength
  :cognitect.aws.mediaconvert/__integerMin0Max3)

(s/def
  :cognitect.aws.mediaconvert.OpusSettings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin32000Max192000)

(s/def
  :cognitect.aws.mediaconvert.OpusSettings/Channels
  :cognitect.aws.mediaconvert/__integerMin1Max2)

(s/def
  :cognitect.aws.mediaconvert.OpusSettings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin16000Max48000)

(s/def
  :cognitect.aws.mediaconvert.ListVersionsRequest/MaxResults
  :cognitect.aws.mediaconvert/__integerMin1Max20)

(s/def
  :cognitect.aws.mediaconvert.ListVersionsRequest/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.InternalServerErrorException/Message
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/AggressiveMode
  :cognitect.aws.mediaconvert/__integerMin0Max4)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/PostTemporalSharpening
  :cognitect.aws.mediaconvert/NoiseFilterPostTemporalSharpening)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/PostTemporalSharpeningStrength
  :cognitect.aws.mediaconvert/NoiseFilterPostTemporalSharpeningStrength)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/Speed
  :cognitect.aws.mediaconvert/__integerMinNegative1Max3)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducerTemporalFilterSettings/Strength
  :cognitect.aws.mediaconvert/__integerMin0Max16)

(s/def
  :cognitect.aws.mediaconvert.DolbyVision/L6Metadata
  :cognitect.aws.mediaconvert/DolbyVisionLevel6Metadata)

(s/def
  :cognitect.aws.mediaconvert.DolbyVision/L6Mode
  :cognitect.aws.mediaconvert/DolbyVisionLevel6Mode)

(s/def
  :cognitect.aws.mediaconvert.DolbyVision/Mapping
  :cognitect.aws.mediaconvert/DolbyVisionMapping)

(s/def
  :cognitect.aws.mediaconvert.DolbyVision/Profile
  :cognitect.aws.mediaconvert/DolbyVisionProfile)

(s/def
  :cognitect.aws.mediaconvert.CaptionDescriptionPreset/CustomLanguageCode
  :cognitect.aws.mediaconvert/__stringPatternAZaZ23AZaZ)

(s/def
  :cognitect.aws.mediaconvert.CaptionDescriptionPreset/DestinationSettings
  :cognitect.aws.mediaconvert/CaptionDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDescriptionPreset/LanguageCode
  :cognitect.aws.mediaconvert/LanguageCode)

(s/def
  :cognitect.aws.mediaconvert.CaptionDescriptionPreset/LanguageDescription
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.OutputGroup/AutomatedEncodingSettings
  :cognitect.aws.mediaconvert/AutomatedEncodingSettings)

(s/def :cognitect.aws.mediaconvert.OutputGroup/CustomName :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.OutputGroup/Name :cognitect.aws.mediaconvert/__stringMax2048)

(s/def
  :cognitect.aws.mediaconvert.OutputGroup/OutputGroupSettings
  :cognitect.aws.mediaconvert/OutputGroupSettings)

(s/def :cognitect.aws.mediaconvert.OutputGroup/Outputs :cognitect.aws.mediaconvert/__listOfOutput)

(s/def
  :cognitect.aws.mediaconvert.EmbeddedSourceSettings/Convert608To708
  :cognitect.aws.mediaconvert/EmbeddedConvert608To708)

(s/def
  :cognitect.aws.mediaconvert.EmbeddedSourceSettings/Source608ChannelNumber
  :cognitect.aws.mediaconvert/__integerMin1Max4)

(s/def
  :cognitect.aws.mediaconvert.EmbeddedSourceSettings/Source608TrackNumber
  :cognitect.aws.mediaconvert/__integerMin1Max1)

(s/def
  :cognitect.aws.mediaconvert.EmbeddedSourceSettings/TerminateCaptions
  :cognitect.aws.mediaconvert/EmbeddedTerminateCaptions)

(s/def :cognitect.aws.mediaconvert.GetJobTemplateRequest/Name :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.Output/AudioDescriptions
  :cognitect.aws.mediaconvert/__listOfAudioDescription)

(s/def
  :cognitect.aws.mediaconvert.Output/CaptionDescriptions
  :cognitect.aws.mediaconvert/__listOfCaptionDescription)

(s/def
  :cognitect.aws.mediaconvert.Output/ContainerSettings
  :cognitect.aws.mediaconvert/ContainerSettings)

(s/def :cognitect.aws.mediaconvert.Output/Extension :cognitect.aws.mediaconvert/__stringMax256)

(s/def
  :cognitect.aws.mediaconvert.Output/NameModifier
  :cognitect.aws.mediaconvert/__stringMin1Max256)

(s/def :cognitect.aws.mediaconvert.Output/OutputSettings :cognitect.aws.mediaconvert/OutputSettings)

(s/def :cognitect.aws.mediaconvert.Output/Preset :cognitect.aws.mediaconvert/__stringMin0)

(s/def
  :cognitect.aws.mediaconvert.Output/VideoDescription
  :cognitect.aws.mediaconvert/VideoDescription)

(s/def
  :cognitect.aws.mediaconvert.VideoPreprocessor/ColorCorrector
  :cognitect.aws.mediaconvert/ColorCorrector)

(s/def
  :cognitect.aws.mediaconvert.VideoPreprocessor/Deinterlacer
  :cognitect.aws.mediaconvert/Deinterlacer)

(s/def
  :cognitect.aws.mediaconvert.VideoPreprocessor/DolbyVision
  :cognitect.aws.mediaconvert/DolbyVision)

(s/def
  :cognitect.aws.mediaconvert.VideoPreprocessor/Hdr10Plus
  :cognitect.aws.mediaconvert/Hdr10Plus)

(s/def
  :cognitect.aws.mediaconvert.VideoPreprocessor/ImageInserter
  :cognitect.aws.mediaconvert/ImageInserter)

(s/def
  :cognitect.aws.mediaconvert.VideoPreprocessor/NoiseReducer
  :cognitect.aws.mediaconvert/NoiseReducer)

(s/def
  :cognitect.aws.mediaconvert.VideoPreprocessor/PartnerWatermarking
  :cognitect.aws.mediaconvert/PartnerWatermarking)

(s/def
  :cognitect.aws.mediaconvert.VideoPreprocessor/TimecodeBurnin
  :cognitect.aws.mediaconvert/TimecodeBurnin)

(s/def
  :cognitect.aws.mediaconvert.Mp2Settings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin32000Max384000)

(s/def
  :cognitect.aws.mediaconvert.Mp2Settings/Channels
  :cognitect.aws.mediaconvert/__integerMin1Max2)

(s/def
  :cognitect.aws.mediaconvert.Mp2Settings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin32000Max48000)

(s/def
  :cognitect.aws.mediaconvert.DescribeEndpointsResponse/Endpoints
  :cognitect.aws.mediaconvert/__listOfEndpoint)

(s/def
  :cognitect.aws.mediaconvert.DescribeEndpointsResponse/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.S3DestinationAccessControl/CannedAcl
  :cognitect.aws.mediaconvert/S3ObjectCannedAcl)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata8
  :cognitect.aws.mediaconvert/__stringMin1Max50)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/LogDestination
  :cognitect.aws.mediaconvert/__stringPatternS3)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/FileOffset
  :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/CredentialsSecretName
  :cognitect.aws.mediaconvert/__stringMin1Max2048PatternArnAZSecretsmanagerWD12SecretAZAZ09)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/KantarServerUrl
  :cognitect.aws.mediaconvert/__stringPatternHttpsKantarmedia)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata7
  :cognitect.aws.mediaconvert/__stringMin1Max50)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/ChannelName
  :cognitect.aws.mediaconvert/__stringMin1Max20)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/ContentReference
  :cognitect.aws.mediaconvert/__stringMin1Max50PatternAZAZ09)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata3
  :cognitect.aws.mediaconvert/__stringMin1Max50)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata5
  :cognitect.aws.mediaconvert/__stringMin1Max50)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata6
  :cognitect.aws.mediaconvert/__stringMin1Max50)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/Metadata4
  :cognitect.aws.mediaconvert/__stringMin1Max50)

(s/def
  :cognitect.aws.mediaconvert.KantarWatermarkSettings/KantarLicenseId
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothGroupSettings/AdditionalManifests
  :cognitect.aws.mediaconvert/__listOfMsSmoothAdditionalManifest)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothGroupSettings/AudioDeduplication
  :cognitect.aws.mediaconvert/MsSmoothAudioDeduplication)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothGroupSettings/Destination
  :cognitect.aws.mediaconvert/__stringPatternS3)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothGroupSettings/DestinationSettings
  :cognitect.aws.mediaconvert/DestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothGroupSettings/Encryption
  :cognitect.aws.mediaconvert/MsSmoothEncryptionSettings)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothGroupSettings/FragmentLength
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothGroupSettings/FragmentLengthControl
  :cognitect.aws.mediaconvert/MsSmoothFragmentLengthControl)

(s/def
  :cognitect.aws.mediaconvert.MsSmoothGroupSettings/ManifestEncoding
  :cognitect.aws.mediaconvert/MsSmoothManifestEncoding)

(s/def
  :cognitect.aws.mediaconvert.Av1QvbrSettings/QvbrQualityLevel
  :cognitect.aws.mediaconvert/__integerMin1Max10)

(s/def
  :cognitect.aws.mediaconvert.Av1QvbrSettings/QvbrQualityLevelFineTune
  :cognitect.aws.mediaconvert/__doubleMin0Max1)

(s/def
  :cognitect.aws.mediaconvert.HlsCaptionLanguageMapping/CaptionChannel
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.HlsCaptionLanguageMapping/CustomLanguageCode
  :cognitect.aws.mediaconvert/__stringMin3Max3PatternAZaZ3)

(s/def
  :cognitect.aws.mediaconvert.HlsCaptionLanguageMapping/LanguageCode
  :cognitect.aws.mediaconvert/LanguageCode)

(s/def
  :cognitect.aws.mediaconvert.HlsCaptionLanguageMapping/LanguageDescription
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateQueueRequest/ConcurrentJobs
  :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.CreateQueueRequest/Description
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.CreateQueueRequest/Name :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CreateQueueRequest/PricingPlan
  :cognitect.aws.mediaconvert/PricingPlan)

(s/def
  :cognitect.aws.mediaconvert.CreateQueueRequest/ReservationPlanSettings
  :cognitect.aws.mediaconvert/ReservationPlanSettings)

(s/def
  :cognitect.aws.mediaconvert.CreateQueueRequest/Status
  :cognitect.aws.mediaconvert/QueueStatus)

(s/def
  :cognitect.aws.mediaconvert.CreateQueueRequest/Tags
  :cognitect.aws.mediaconvert/__mapOf__string)

(s/def
  :cognitect.aws.mediaconvert.DvbTdtSettings/TdtInterval
  :cognitect.aws.mediaconvert/__integerMin1000Max30000)

(s/def
  :cognitect.aws.mediaconvert.ListQueuesResponse/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.ListQueuesResponse/Queues
  :cognitect.aws.mediaconvert/__listOfQueue)

(s/def
  :cognitect.aws.mediaconvert.ListQueuesResponse/TotalConcurrentJobs
  :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.ListQueuesResponse/UnallocatedConcurrentJobs
  :cognitect.aws.mediaconvert/__integer)

(s/def :cognitect.aws.mediaconvert.ForbiddenException/Message :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.StaticKeyProvider/KeyFormat
  :cognitect.aws.mediaconvert/__stringPatternIdentityAZaZ26AZaZ09163)

(s/def
  :cognitect.aws.mediaconvert.StaticKeyProvider/KeyFormatVersions
  :cognitect.aws.mediaconvert/__stringPatternDD)

(s/def
  :cognitect.aws.mediaconvert.StaticKeyProvider/StaticKeyValue
  :cognitect.aws.mediaconvert/__stringPatternAZaZ0932)

(s/def :cognitect.aws.mediaconvert.StaticKeyProvider/Url :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.TimedMetadataInsertion/Id3Insertions
  :cognitect.aws.mediaconvert/__listOfId3Insertion)

(s/def :cognitect.aws.mediaconvert.BadRequestException/Message :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.PutPolicyRequest/Policy :cognitect.aws.mediaconvert/Policy)

(s/def
  :cognitect.aws.mediaconvert.TrackSourceSettings/TrackNumber
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.F4vSettings/MoovPlacement
  :cognitect.aws.mediaconvert/F4vMoovPlacement)

(s/def :cognitect.aws.mediaconvert.CreatePresetResponse/Preset :cognitect.aws.mediaconvert/Preset)

(s/def :cognitect.aws.mediaconvert.UpdateQueueResponse/Queue :cognitect.aws.mediaconvert/Queue)

(s/def :cognitect.aws.mediaconvert.Preset/Arn :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Preset/Category :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Preset/CreatedAt :cognitect.aws.mediaconvert/__timestampUnix)

(s/def :cognitect.aws.mediaconvert.Preset/Description :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Preset/LastUpdated :cognitect.aws.mediaconvert/__timestampUnix)

(s/def :cognitect.aws.mediaconvert.Preset/Name :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Preset/Settings :cognitect.aws.mediaconvert/PresetSettings)

(s/def :cognitect.aws.mediaconvert.Preset/Type :cognitect.aws.mediaconvert/Type)

(s/def
  :cognitect.aws.mediaconvert.DescribeEndpointsRequest/MaxResults
  :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.DescribeEndpointsRequest/Mode
  :cognitect.aws.mediaconvert/DescribeEndpointsMode)

(s/def
  :cognitect.aws.mediaconvert.DescribeEndpointsRequest/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.M2tsScte35Esam/Scte35EsamPid
  :cognitect.aws.mediaconvert/__integerMin32Max8182)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayPosition/Height
  :cognitect.aws.mediaconvert/__integerMinNegative1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayPosition/Unit
  :cognitect.aws.mediaconvert/VideoOverlayUnit)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayPosition/Width
  :cognitect.aws.mediaconvert/__integerMinNegative1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayPosition/XPosition
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayPosition/YPosition
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def :cognitect.aws.mediaconvert.GetPolicyResponse/Policy :cognitect.aws.mediaconvert/Policy)

(s/def
  :cognitect.aws.mediaconvert.MinBottomRenditionSize/Height
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def
  :cognitect.aws.mediaconvert.MinBottomRenditionSize/Width
  :cognitect.aws.mediaconvert/__integerMin32Max8192)

(s/def
  :cognitect.aws.mediaconvert.DvbSubSourceSettings/Pid
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DestinationSettings/S3Settings
  :cognitect.aws.mediaconvert/S3DestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.ChannelMapping/OutputChannels
  :cognitect.aws.mediaconvert/__listOfOutputChannelMapping)

(s/def :cognitect.aws.mediaconvert.ListQueuesRequest/ListBy :cognitect.aws.mediaconvert/QueueListBy)

(s/def
  :cognitect.aws.mediaconvert.ListQueuesRequest/MaxResults
  :cognitect.aws.mediaconvert/__integerMin1Max20)

(s/def :cognitect.aws.mediaconvert.ListQueuesRequest/NextToken :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.ListQueuesRequest/Order :cognitect.aws.mediaconvert/Order)

(s/def :cognitect.aws.mediaconvert.UntagResourceRequest/Arn :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.UntagResourceRequest/TagKeys
  :cognitect.aws.mediaconvert/__listOf__string)

(s/def :cognitect.aws.mediaconvert.Timing/FinishTime :cognitect.aws.mediaconvert/__timestampUnix)

(s/def :cognitect.aws.mediaconvert.Timing/StartTime :cognitect.aws.mediaconvert/__timestampUnix)

(s/def :cognitect.aws.mediaconvert.Timing/SubmitTime :cognitect.aws.mediaconvert/__timestampUnix)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayInputClipping/EndTimecode
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092090909)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayInputClipping/StartTimecode
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092090909)

(s/def
  :cognitect.aws.mediaconvert.S3EncryptionSettings/EncryptionType
  :cognitect.aws.mediaconvert/S3ServerSideEncryptionType)

(s/def
  :cognitect.aws.mediaconvert.S3EncryptionSettings/KmsEncryptionContext
  :cognitect.aws.mediaconvert/__stringPatternAZaZ0902)

(s/def
  :cognitect.aws.mediaconvert.S3EncryptionSettings/KmsKeyArn
  :cognitect.aws.mediaconvert/__stringPatternArnAwsUsGovCnKmsAZ26EastWestCentralNorthSouthEastWest1912D12KeyAFAF098AFAF094AFAF094AFAF094AFAF0912MrkAFAF0932)

(s/def :cognitect.aws.mediaconvert.H265Settings/Telecine :cognitect.aws.mediaconvert/H265Telecine)

(s/def :cognitect.aws.mediaconvert.H265Settings/GopSize :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/InterlaceMode
  :cognitect.aws.mediaconvert/H265InterlaceMode)

(s/def :cognitect.aws.mediaconvert.H265Settings/Tiles :cognitect.aws.mediaconvert/H265Tiles)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/AdaptiveQuantization
  :cognitect.aws.mediaconvert/H265AdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/TemporalIds
  :cognitect.aws.mediaconvert/H265TemporalIds)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/QualityTuningLevel
  :cognitect.aws.mediaconvert/H265QualityTuningLevel)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/ParNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/EndOfStreamMarkers
  :cognitect.aws.mediaconvert/H265EndOfStreamMarkers)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/AlternateTransferFunctionSei
  :cognitect.aws.mediaconvert/H265AlternateTransferFunctionSei)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/HrdBufferSize
  :cognitect.aws.mediaconvert/__integerMin0Max1466400000)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/TemporalAdaptiveQuantization
  :cognitect.aws.mediaconvert/H265TemporalAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/NumberBFramesBetweenReferenceFrames
  :cognitect.aws.mediaconvert/__integerMin0Max7)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/UnregisteredSeiTimecode
  :cognitect.aws.mediaconvert/H265UnregisteredSeiTimecode)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/ParDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/DynamicSubGop
  :cognitect.aws.mediaconvert/H265DynamicSubGop)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/SceneChangeDetect
  :cognitect.aws.mediaconvert/H265SceneChangeDetect)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/CodecProfile
  :cognitect.aws.mediaconvert/H265CodecProfile)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/HrdBufferFinalFillPercentage
  :cognitect.aws.mediaconvert/__integerMin0Max100)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/WriteMp4PackagingType
  :cognitect.aws.mediaconvert/H265WriteMp4PackagingType)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/MinIInterval
  :cognitect.aws.mediaconvert/__integerMin0Max30)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/QvbrSettings
  :cognitect.aws.mediaconvert/H265QvbrSettings)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/RateControlMode
  :cognitect.aws.mediaconvert/H265RateControlMode)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max1466400000)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/SpatialAdaptiveQuantization
  :cognitect.aws.mediaconvert/H265SpatialAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/ParControl
  :cognitect.aws.mediaconvert/H265ParControl)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/NumberReferenceFrames
  :cognitect.aws.mediaconvert/__integerMin1Max6)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/SampleAdaptiveOffsetFilterMode
  :cognitect.aws.mediaconvert/H265SampleAdaptiveOffsetFilterMode)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/GopSizeUnits
  :cognitect.aws.mediaconvert/H265GopSizeUnits)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/MaxBitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max1466400000)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/Slices
  :cognitect.aws.mediaconvert/__integerMin1Max32)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/CodecLevel
  :cognitect.aws.mediaconvert/H265CodecLevel)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/H265FramerateConversionAlgorithm)

(s/def :cognitect.aws.mediaconvert.H265Settings/SlowPal :cognitect.aws.mediaconvert/H265SlowPal)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/GopClosedCadence
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/GopBReference
  :cognitect.aws.mediaconvert/H265GopBReference)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/BandwidthReductionFilter
  :cognitect.aws.mediaconvert/BandwidthReductionFilter)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/HrdBufferInitialFillPercentage
  :cognitect.aws.mediaconvert/__integerMin0Max100)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/FlickerAdaptiveQuantization
  :cognitect.aws.mediaconvert/H265FlickerAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/ScanTypeConversionMode
  :cognitect.aws.mediaconvert/H265ScanTypeConversionMode)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/Deblocking
  :cognitect.aws.mediaconvert/H265Deblocking)

(s/def
  :cognitect.aws.mediaconvert.H265Settings/FramerateControl
  :cognitect.aws.mediaconvert/H265FramerateControl)

(s/def :cognitect.aws.mediaconvert.GetJobResponse/Job :cognitect.aws.mediaconvert/Job)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraUhdSettings/QualityTuningLevel
  :cognitect.aws.mediaconvert/AvcIntraUhdQualityTuningLevel)

(s/def
  :cognitect.aws.mediaconvert.InputClipping/EndTimecode
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092090909)

(s/def
  :cognitect.aws.mediaconvert.InputClipping/StartTimecode
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092090909)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/ManifestMetadataSignaling
  :cognitect.aws.mediaconvert/MpdManifestMetadataSignaling)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/KlvMetadata
  :cognitect.aws.mediaconvert/MpdKlvMetadata)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/AccessibilityCaptionHints
  :cognitect.aws.mediaconvert/MpdAccessibilityCaptionHints)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/CaptionContainerType
  :cognitect.aws.mediaconvert/MpdCaptionContainerType)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/AudioDuration
  :cognitect.aws.mediaconvert/MpdAudioDuration)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/TimedMetadataValue
  :cognitect.aws.mediaconvert/__stringMax1000)

(s/def :cognitect.aws.mediaconvert.MpdSettings/Scte35Esam :cognitect.aws.mediaconvert/MpdScte35Esam)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/Scte35Source
  :cognitect.aws.mediaconvert/MpdScte35Source)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/TimedMetadataBoxVersion
  :cognitect.aws.mediaconvert/MpdTimedMetadataBoxVersion)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/TimedMetadataSchemeIdUri
  :cognitect.aws.mediaconvert/__stringMax1000)

(s/def
  :cognitect.aws.mediaconvert.MpdSettings/TimedMetadata
  :cognitect.aws.mediaconvert/MpdTimedMetadata)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/AvailBlanking
  :cognitect.aws.mediaconvert/AvailBlanking)

(s/def :cognitect.aws.mediaconvert.JobSettings/Inputs :cognitect.aws.mediaconvert/__listOfInput)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/MotionImageInserter
  :cognitect.aws.mediaconvert/MotionImageInserter)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/ColorConversion3DLUTSettings
  :cognitect.aws.mediaconvert/__listOfColorConversion3DLUTSetting)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/NielsenNonLinearWatermark
  :cognitect.aws.mediaconvert/NielsenNonLinearWatermarkSettings)

(s/def :cognitect.aws.mediaconvert.JobSettings/Esam :cognitect.aws.mediaconvert/EsamSettings)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/NielsenConfiguration
  :cognitect.aws.mediaconvert/NielsenConfiguration)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/FollowSource
  :cognitect.aws.mediaconvert/__integerMin1Max150)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/KantarWatermark
  :cognitect.aws.mediaconvert/KantarWatermarkSettings)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/ExtendedDataServices
  :cognitect.aws.mediaconvert/ExtendedDataServices)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/OutputGroups
  :cognitect.aws.mediaconvert/__listOfOutputGroup)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/TimedMetadataInsertion
  :cognitect.aws.mediaconvert/TimedMetadataInsertion)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/AdAvailOffset
  :cognitect.aws.mediaconvert/__integerMinNegative1000Max1000)

(s/def
  :cognitect.aws.mediaconvert.JobSettings/TimecodeConfig
  :cognitect.aws.mediaconvert/TimecodeConfig)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/StatusUpdateInterval
  :cognitect.aws.mediaconvert/StatusUpdateInterval)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/AccelerationSettings
  :cognitect.aws.mediaconvert/AccelerationSettings)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Queue
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Priority
  :cognitect.aws.mediaconvert/__integerMinNegative50Max50)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Category
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Settings
  :cognitect.aws.mediaconvert/JobTemplateSettings)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Name
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/Description
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateRequest/HopDestinations
  :cognitect.aws.mediaconvert/__listOfHopDestination)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/EmbeddedDestinationSettings
  :cognitect.aws.mediaconvert/EmbeddedDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/DvbSubDestinationSettings
  :cognitect.aws.mediaconvert/DvbSubDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/DestinationType
  :cognitect.aws.mediaconvert/CaptionDestinationType)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/TeletextDestinationSettings
  :cognitect.aws.mediaconvert/TeletextDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/WebvttDestinationSettings
  :cognitect.aws.mediaconvert/WebvttDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/ImscDestinationSettings
  :cognitect.aws.mediaconvert/ImscDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/SccDestinationSettings
  :cognitect.aws.mediaconvert/SccDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/SrtDestinationSettings
  :cognitect.aws.mediaconvert/SrtDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/TtmlDestinationSettings
  :cognitect.aws.mediaconvert/TtmlDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CaptionDestinationSettings/BurninDestinationSettings
  :cognitect.aws.mediaconvert/BurninDestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayInput/FileInput
  :cognitect.aws.mediaconvert/__stringPatternS3Https)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayInput/InputClippings
  :cognitect.aws.mediaconvert/__listOfVideoOverlayInputClipping)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayInput/TimecodeSource
  :cognitect.aws.mediaconvert/InputTimecodeSource)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayInput/TimecodeStart
  :cognitect.aws.mediaconvert/__stringMin11Max11Pattern01D20305D205D)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInsertionOffset/ImageX
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInsertionOffset/ImageY
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlay/EndTimecode
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlay/InitialPosition
  :cognitect.aws.mediaconvert/VideoOverlayPosition)

(s/def :cognitect.aws.mediaconvert.VideoOverlay/Input :cognitect.aws.mediaconvert/VideoOverlayInput)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlay/Playback
  :cognitect.aws.mediaconvert/VideoOverlayPlayBackMode)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlay/StartTimecode
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlay/Transitions
  :cognitect.aws.mediaconvert/__listOfVideoOverlayTransition)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/AvcIntraClass
  :cognitect.aws.mediaconvert/AvcIntraClass)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/Telecine
  :cognitect.aws.mediaconvert/AvcIntraTelecine)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/InterlaceMode
  :cognitect.aws.mediaconvert/AvcIntraInterlaceMode)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin24Max60000)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max1001)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/AvcIntraUhdSettings
  :cognitect.aws.mediaconvert/AvcIntraUhdSettings)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/AvcIntraFramerateConversionAlgorithm)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/SlowPal
  :cognitect.aws.mediaconvert/AvcIntraSlowPal)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/ScanTypeConversionMode
  :cognitect.aws.mediaconvert/AvcIntraScanTypeConversionMode)

(s/def
  :cognitect.aws.mediaconvert.AvcIntraSettings/FramerateControl
  :cognitect.aws.mediaconvert/AvcIntraFramerateControl)

(s/def
  :cognitect.aws.mediaconvert.AudioSelectorGroup/AudioSelectorNames
  :cognitect.aws.mediaconvert/__listOf__stringMin1)

(s/def :cognitect.aws.mediaconvert.Vp9Settings/GopSize :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/QualityTuningLevel
  :cognitect.aws.mediaconvert/Vp9QualityTuningLevel)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/ParNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/HrdBufferSize
  :cognitect.aws.mediaconvert/__integerMin0Max47185920)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/ParDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/RateControlMode
  :cognitect.aws.mediaconvert/Vp9RateControlMode)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max480000000)

(s/def :cognitect.aws.mediaconvert.Vp9Settings/ParControl :cognitect.aws.mediaconvert/Vp9ParControl)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/MaxBitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max480000000)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/Vp9FramerateConversionAlgorithm)

(s/def
  :cognitect.aws.mediaconvert.Vp9Settings/FramerateControl
  :cognitect.aws.mediaconvert/Vp9FramerateControl)

(s/def
  :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/IntervalCadence
  :cognitect.aws.mediaconvert/CmafIntervalCadence)

(s/def
  :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/ThumbnailHeight
  :cognitect.aws.mediaconvert/__integerMin2Max4096)

(s/def
  :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/ThumbnailInterval
  :cognitect.aws.mediaconvert/__doubleMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/ThumbnailWidth
  :cognitect.aws.mediaconvert/__integerMin8Max4096)

(s/def
  :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/TileHeight
  :cognitect.aws.mediaconvert/__integerMin1Max2048)

(s/def
  :cognitect.aws.mediaconvert.CmafImageBasedTrickPlaySettings/TileWidth
  :cognitect.aws.mediaconvert/__integerMin1Max512)

(s/def
  :cognitect.aws.mediaconvert.SccDestinationSettings/Framerate
  :cognitect.aws.mediaconvert/SccDestinationFramerate)

(s/def
  :cognitect.aws.mediaconvert.EsamSignalProcessingNotification/SccXml
  :cognitect.aws.mediaconvert/__stringPatternSNSignalProcessingNotificationNS)

(s/def :cognitect.aws.mediaconvert.Mpeg2Settings/Telecine :cognitect.aws.mediaconvert/Mpeg2Telecine)

(s/def :cognitect.aws.mediaconvert.Mpeg2Settings/GopSize :cognitect.aws.mediaconvert/__doubleMin0)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/InterlaceMode
  :cognitect.aws.mediaconvert/Mpeg2InterlaceMode)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/AdaptiveQuantization
  :cognitect.aws.mediaconvert/Mpeg2AdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/QualityTuningLevel
  :cognitect.aws.mediaconvert/Mpeg2QualityTuningLevel)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/ParNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/IntraDcPrecision
  :cognitect.aws.mediaconvert/Mpeg2IntraDcPrecision)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/HrdBufferSize
  :cognitect.aws.mediaconvert/__integerMin0Max47185920)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/Softness
  :cognitect.aws.mediaconvert/__integerMin0Max128)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/TemporalAdaptiveQuantization
  :cognitect.aws.mediaconvert/Mpeg2TemporalAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/NumberBFramesBetweenReferenceFrames
  :cognitect.aws.mediaconvert/__integerMin0Max7)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/ParDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/DynamicSubGop
  :cognitect.aws.mediaconvert/Mpeg2DynamicSubGop)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/SceneChangeDetect
  :cognitect.aws.mediaconvert/Mpeg2SceneChangeDetect)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/CodecProfile
  :cognitect.aws.mediaconvert/Mpeg2CodecProfile)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/HrdBufferFinalFillPercentage
  :cognitect.aws.mediaconvert/__integerMin0Max100)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/MinIInterval
  :cognitect.aws.mediaconvert/__integerMin0Max30)

(s/def :cognitect.aws.mediaconvert.Mpeg2Settings/Syntax :cognitect.aws.mediaconvert/Mpeg2Syntax)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin24Max60000)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/RateControlMode
  :cognitect.aws.mediaconvert/Mpeg2RateControlMode)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max288000000)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/SpatialAdaptiveQuantization
  :cognitect.aws.mediaconvert/Mpeg2SpatialAdaptiveQuantization)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/ParControl
  :cognitect.aws.mediaconvert/Mpeg2ParControl)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/GopSizeUnits
  :cognitect.aws.mediaconvert/Mpeg2GopSizeUnits)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/MaxBitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max300000000)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max1001)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/CodecLevel
  :cognitect.aws.mediaconvert/Mpeg2CodecLevel)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/FramerateConversionAlgorithm
  :cognitect.aws.mediaconvert/Mpeg2FramerateConversionAlgorithm)

(s/def :cognitect.aws.mediaconvert.Mpeg2Settings/SlowPal :cognitect.aws.mediaconvert/Mpeg2SlowPal)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/GopClosedCadence
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/HrdBufferInitialFillPercentage
  :cognitect.aws.mediaconvert/__integerMin0Max100)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/ScanTypeConversionMode
  :cognitect.aws.mediaconvert/Mpeg2ScanTypeConversionMode)

(s/def
  :cognitect.aws.mediaconvert.Mpeg2Settings/FramerateControl
  :cognitect.aws.mediaconvert/Mpeg2FramerateControl)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/MaxLuminance
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/MaxContentLightLevel
  :cognitect.aws.mediaconvert/__integerMin0Max65535)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/BluePrimaryX
  :cognitect.aws.mediaconvert/__integerMin0Max50000)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/MinLuminance
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/GreenPrimaryX
  :cognitect.aws.mediaconvert/__integerMin0Max50000)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/RedPrimaryX
  :cognitect.aws.mediaconvert/__integerMin0Max50000)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/GreenPrimaryY
  :cognitect.aws.mediaconvert/__integerMin0Max50000)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/RedPrimaryY
  :cognitect.aws.mediaconvert/__integerMin0Max50000)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/BluePrimaryY
  :cognitect.aws.mediaconvert/__integerMin0Max50000)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/WhitePointX
  :cognitect.aws.mediaconvert/__integerMin0Max50000)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/WhitePointY
  :cognitect.aws.mediaconvert/__integerMin0Max50000)

(s/def
  :cognitect.aws.mediaconvert.Hdr10Metadata/MaxFrameAverageLightLevel
  :cognitect.aws.mediaconvert/__integerMin0Max65535)

(s/def
  :cognitect.aws.mediaconvert.ListJobTemplatesRequest/Category
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.ListJobTemplatesRequest/ListBy
  :cognitect.aws.mediaconvert/JobTemplateListBy)

(s/def
  :cognitect.aws.mediaconvert.ListJobTemplatesRequest/MaxResults
  :cognitect.aws.mediaconvert/__integerMin1Max20)

(s/def
  :cognitect.aws.mediaconvert.ListJobTemplatesRequest/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.ListJobTemplatesRequest/Order :cognitect.aws.mediaconvert/Order)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayTransition/EndPosition
  :cognitect.aws.mediaconvert/VideoOverlayPosition)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayTransition/EndTimecode
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092)

(s/def
  :cognitect.aws.mediaconvert.VideoOverlayTransition/StartTimecode
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092)

(s/def
  :cognitect.aws.mediaconvert.ReservationPlan/Commitment
  :cognitect.aws.mediaconvert/Commitment)

(s/def
  :cognitect.aws.mediaconvert.ReservationPlan/ExpiresAt
  :cognitect.aws.mediaconvert/__timestampUnix)

(s/def
  :cognitect.aws.mediaconvert.ReservationPlan/PurchasedAt
  :cognitect.aws.mediaconvert/__timestampUnix)

(s/def
  :cognitect.aws.mediaconvert.ReservationPlan/RenewalType
  :cognitect.aws.mediaconvert/RenewalType)

(s/def
  :cognitect.aws.mediaconvert.ReservationPlan/ReservedSlots
  :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.ReservationPlan/Status
  :cognitect.aws.mediaconvert/ReservationPlanStatus)

(s/def
  :cognitect.aws.mediaconvert.SrtDestinationSettings/StylePassthrough
  :cognitect.aws.mediaconvert/SrtStylePassthrough)

(s/def
  :cognitect.aws.mediaconvert.TtmlDestinationSettings/StylePassthrough
  :cognitect.aws.mediaconvert/TtmlStylePassthrough)

(s/def
  :cognitect.aws.mediaconvert.TimecodeBurnin/FontSize
  :cognitect.aws.mediaconvert/__integerMin10Max48)

(s/def
  :cognitect.aws.mediaconvert.TimecodeBurnin/Position
  :cognitect.aws.mediaconvert/TimecodeBurninPosition)

(s/def
  :cognitect.aws.mediaconvert.TimecodeBurnin/Prefix
  :cognitect.aws.mediaconvert/__stringPattern)

(s/def :cognitect.aws.mediaconvert.JobMessages/Info :cognitect.aws.mediaconvert/__listOf__string)

(s/def :cognitect.aws.mediaconvert.JobMessages/Warning :cognitect.aws.mediaconvert/__listOf__string)

(s/def
  :cognitect.aws.mediaconvert.GetJobTemplateResponse/JobTemplate
  :cognitect.aws.mediaconvert/JobTemplate)

(s/def
  :cognitect.aws.mediaconvert.ReservationPlanSettings/Commitment
  :cognitect.aws.mediaconvert/Commitment)

(s/def
  :cognitect.aws.mediaconvert.ReservationPlanSettings/RenewalType
  :cognitect.aws.mediaconvert/RenewalType)

(s/def
  :cognitect.aws.mediaconvert.ReservationPlanSettings/ReservedSlots
  :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.AudioNormalizationSettings/Algorithm
  :cognitect.aws.mediaconvert/AudioNormalizationAlgorithm)

(s/def
  :cognitect.aws.mediaconvert.AudioNormalizationSettings/AlgorithmControl
  :cognitect.aws.mediaconvert/AudioNormalizationAlgorithmControl)

(s/def
  :cognitect.aws.mediaconvert.AudioNormalizationSettings/CorrectionGateLevel
  :cognitect.aws.mediaconvert/__integerMinNegative70Max0)

(s/def
  :cognitect.aws.mediaconvert.AudioNormalizationSettings/LoudnessLogging
  :cognitect.aws.mediaconvert/AudioNormalizationLoudnessLogging)

(s/def
  :cognitect.aws.mediaconvert.AudioNormalizationSettings/PeakCalculation
  :cognitect.aws.mediaconvert/AudioNormalizationPeakCalculation)

(s/def
  :cognitect.aws.mediaconvert.AudioNormalizationSettings/TargetLkfs
  :cognitect.aws.mediaconvert/__doubleMinNegative59Max0)

(s/def
  :cognitect.aws.mediaconvert.AudioNormalizationSettings/TruePeakLimiterThreshold
  :cognitect.aws.mediaconvert/__doubleMinNegative8Max0)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/DashManifestStyle
  :cognitect.aws.mediaconvert/DashManifestStyle)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/ManifestDurationFormat
  :cognitect.aws.mediaconvert/CmafManifestDurationFormat)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/CodecSpecification
  :cognitect.aws.mediaconvert/CmafCodecSpecification)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/Encryption
  :cognitect.aws.mediaconvert/CmafEncryptionSettings)

(s/def :cognitect.aws.mediaconvert.CmafGroupSettings/BaseUrl :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/ImageBasedTrickPlaySettings
  :cognitect.aws.mediaconvert/CmafImageBasedTrickPlaySettings)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/PtsOffsetHandlingForBFrames
  :cognitect.aws.mediaconvert/CmafPtsOffsetHandlingForBFrames)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/WriteSegmentTimelineInRepresentation
  :cognitect.aws.mediaconvert/CmafWriteSegmentTimelineInRepresentation)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/StreamInfResolution
  :cognitect.aws.mediaconvert/CmafStreamInfResolution)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/Destination
  :cognitect.aws.mediaconvert/__stringPatternS3)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/FragmentLength
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/MinFinalSegmentLength
  :cognitect.aws.mediaconvert/__doubleMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/MpdProfile
  :cognitect.aws.mediaconvert/CmafMpdProfile)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/SegmentLength
  :cognitect.aws.mediaconvert/__integerMin1Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/AdditionalManifests
  :cognitect.aws.mediaconvert/__listOfCmafAdditionalManifest)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/TargetDurationCompatibilityMode
  :cognitect.aws.mediaconvert/CmafTargetDurationCompatibilityMode)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/WriteDashManifest
  :cognitect.aws.mediaconvert/CmafWriteDASHManifest)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/MinBufferTime
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/MpdManifestBandwidthType
  :cognitect.aws.mediaconvert/CmafMpdManifestBandwidthType)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/SegmentControl
  :cognitect.aws.mediaconvert/CmafSegmentControl)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/VideoCompositionOffsets
  :cognitect.aws.mediaconvert/CmafVideoCompositionOffsets)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/ClientCache
  :cognitect.aws.mediaconvert/CmafClientCache)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/DashIFrameTrickPlayNameModifier
  :cognitect.aws.mediaconvert/__stringMin1Max256)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/DestinationSettings
  :cognitect.aws.mediaconvert/DestinationSettings)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/WriteHlsManifest
  :cognitect.aws.mediaconvert/CmafWriteHLSManifest)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/ManifestCompression
  :cognitect.aws.mediaconvert/CmafManifestCompression)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/SegmentLengthControl
  :cognitect.aws.mediaconvert/CmafSegmentLengthControl)

(s/def
  :cognitect.aws.mediaconvert.CmafGroupSettings/ImageBasedTrickPlay
  :cognitect.aws.mediaconvert/CmafImageBasedTrickPlay)

(s/def
  :cognitect.aws.mediaconvert.DeleteJobTemplateRequest/Name
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.AutomatedEncodingSettings/AbrSettings
  :cognitect.aws.mediaconvert/AutomatedAbrSettings)

(s/def :cognitect.aws.mediaconvert.CancelJobRequest/Id :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/IntervalCadence
  :cognitect.aws.mediaconvert/DashIsoIntervalCadence)

(s/def
  :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/ThumbnailHeight
  :cognitect.aws.mediaconvert/__integerMin1Max4096)

(s/def
  :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/ThumbnailInterval
  :cognitect.aws.mediaconvert/__doubleMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/ThumbnailWidth
  :cognitect.aws.mediaconvert/__integerMin8Max4096)

(s/def
  :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/TileHeight
  :cognitect.aws.mediaconvert/__integerMin1Max2048)

(s/def
  :cognitect.aws.mediaconvert.DashIsoImageBasedTrickPlaySettings/TileWidth
  :cognitect.aws.mediaconvert/__integerMin1Max512)

(s/def
  :cognitect.aws.mediaconvert.ListTagsForResourceResponse/ResourceTags
  :cognitect.aws.mediaconvert/ResourceTags)

(s/def
  :cognitect.aws.mediaconvert.BandwidthReductionFilter/Sharpening
  :cognitect.aws.mediaconvert/BandwidthReductionFilterSharpening)

(s/def
  :cognitect.aws.mediaconvert.BandwidthReductionFilter/Strength
  :cognitect.aws.mediaconvert/BandwidthReductionFilterStrength)

(s/def
  :cognitect.aws.mediaconvert.ClipLimits/MaximumRGBTolerance
  :cognitect.aws.mediaconvert/__integerMin90Max105)

(s/def
  :cognitect.aws.mediaconvert.ClipLimits/MaximumYUV
  :cognitect.aws.mediaconvert/__integerMin920Max1023)

(s/def
  :cognitect.aws.mediaconvert.ClipLimits/MinimumRGBTolerance
  :cognitect.aws.mediaconvert/__integerMinNegative5Max10)

(s/def
  :cognitect.aws.mediaconvert.ClipLimits/MinimumYUV
  :cognitect.aws.mediaconvert/__integerMin0Max128)

(s/def
  :cognitect.aws.mediaconvert.InputDecryptionSettings/DecryptionMode
  :cognitect.aws.mediaconvert/DecryptionMode)

(s/def
  :cognitect.aws.mediaconvert.InputDecryptionSettings/EncryptedDecryptionKey
  :cognitect.aws.mediaconvert/__stringMin24Max512PatternAZaZ0902)

(s/def
  :cognitect.aws.mediaconvert.InputDecryptionSettings/InitializationVector
  :cognitect.aws.mediaconvert/__stringMin16Max24PatternAZaZ0922AZaZ0916)

(s/def
  :cognitect.aws.mediaconvert.InputDecryptionSettings/KmsKeyRegion
  :cognitect.aws.mediaconvert/__stringMin9Max19PatternAZ26EastWestCentralNorthSouthEastWest1912)

(s/def :cognitect.aws.mediaconvert.ResourceTags/Arn :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.ResourceTags/Tags :cognitect.aws.mediaconvert/__mapOf__string)

(s/def
  :cognitect.aws.mediaconvert.HlsRenditionGroupSettings/RenditionGroupId
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.HlsRenditionGroupSettings/RenditionLanguageCode
  :cognitect.aws.mediaconvert/LanguageCode)

(s/def
  :cognitect.aws.mediaconvert.HlsRenditionGroupSettings/RenditionName
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.ImageInserter/InsertableImages
  :cognitect.aws.mediaconvert/__listOfInsertableImage)

(s/def
  :cognitect.aws.mediaconvert.ImageInserter/SdrReferenceWhiteLevel
  :cognitect.aws.mediaconvert/__integerMin100Max1000)

(s/def :cognitect.aws.mediaconvert.GetPresetRequest/Name :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.HopDestination/Priority
  :cognitect.aws.mediaconvert/__integerMinNegative50Max50)

(s/def :cognitect.aws.mediaconvert.HopDestination/Queue :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.HopDestination/WaitMinutes :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.UpdatePresetRequest/Category
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.UpdatePresetRequest/Description
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.UpdatePresetRequest/Name :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.UpdatePresetRequest/Settings
  :cognitect.aws.mediaconvert/PresetSettings)

(s/def
  :cognitect.aws.mediaconvert.UpdateJobTemplateResponse/JobTemplate
  :cognitect.aws.mediaconvert/JobTemplate)

(s/def
  :cognitect.aws.mediaconvert.WavSettings/BitDepth
  :cognitect.aws.mediaconvert/__integerMin16Max24)

(s/def
  :cognitect.aws.mediaconvert.WavSettings/Channels
  :cognitect.aws.mediaconvert/__integerMin1Max64)

(s/def :cognitect.aws.mediaconvert.WavSettings/Format :cognitect.aws.mediaconvert/WavFormat)

(s/def
  :cognitect.aws.mediaconvert.WavSettings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin8000Max192000)

(s/def
  :cognitect.aws.mediaconvert.TooManyRequestsException/Message
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.Ac3Settings/LfeFilter :cognitect.aws.mediaconvert/Ac3LfeFilter)

(s/def
  :cognitect.aws.mediaconvert.Ac3Settings/BitstreamMode
  :cognitect.aws.mediaconvert/Ac3BitstreamMode)

(s/def :cognitect.aws.mediaconvert.Ac3Settings/CodingMode :cognitect.aws.mediaconvert/Ac3CodingMode)

(s/def
  :cognitect.aws.mediaconvert.Ac3Settings/DynamicRangeCompressionProfile
  :cognitect.aws.mediaconvert/Ac3DynamicRangeCompressionProfile)

(s/def
  :cognitect.aws.mediaconvert.Ac3Settings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin64000Max640000)

(s/def
  :cognitect.aws.mediaconvert.Ac3Settings/MetadataControl
  :cognitect.aws.mediaconvert/Ac3MetadataControl)

(s/def
  :cognitect.aws.mediaconvert.Ac3Settings/DynamicRangeCompressionRf
  :cognitect.aws.mediaconvert/Ac3DynamicRangeCompressionRf)

(s/def
  :cognitect.aws.mediaconvert.Ac3Settings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin48000Max48000)

(s/def
  :cognitect.aws.mediaconvert.Ac3Settings/DynamicRangeCompressionLine
  :cognitect.aws.mediaconvert/Ac3DynamicRangeCompressionLine)

(s/def
  :cognitect.aws.mediaconvert.Ac3Settings/Dialnorm
  :cognitect.aws.mediaconvert/__integerMin1Max31)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducerSpatialFilterSettings/PostFilterSharpenStrength
  :cognitect.aws.mediaconvert/__integerMin0Max3)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducerSpatialFilterSettings/Speed
  :cognitect.aws.mediaconvert/__integerMinNegative2Max3)

(s/def
  :cognitect.aws.mediaconvert.NoiseReducerSpatialFilterSettings/Strength
  :cognitect.aws.mediaconvert/__integerMin0Max16)

(s/def
  :cognitect.aws.mediaconvert.DvbNitSettings/NetworkId
  :cognitect.aws.mediaconvert/__integerMin0Max65535)

(s/def
  :cognitect.aws.mediaconvert.DvbNitSettings/NetworkName
  :cognitect.aws.mediaconvert/__stringMin1Max256)

(s/def
  :cognitect.aws.mediaconvert.DvbNitSettings/NitInterval
  :cognitect.aws.mediaconvert/__integerMin25Max10000)

(s/def
  :cognitect.aws.mediaconvert.ListJobTemplatesResponse/JobTemplates
  :cognitect.aws.mediaconvert/__listOfJobTemplate)

(s/def
  :cognitect.aws.mediaconvert.ListJobTemplatesResponse/NextToken
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.WebvttHlsSourceSettings/RenditionGroupId
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.WebvttHlsSourceSettings/RenditionLanguageCode
  :cognitect.aws.mediaconvert/LanguageCode)

(s/def
  :cognitect.aws.mediaconvert.WebvttHlsSourceSettings/RenditionName
  :cognitect.aws.mediaconvert/__string)

(s/def :cognitect.aws.mediaconvert.OutputDetail/DurationInMs :cognitect.aws.mediaconvert/__integer)

(s/def
  :cognitect.aws.mediaconvert.OutputDetail/VideoDetails
  :cognitect.aws.mediaconvert/VideoDetail)

(s/def
  :cognitect.aws.mediaconvert.VorbisSettings/Channels
  :cognitect.aws.mediaconvert/__integerMin1Max2)

(s/def
  :cognitect.aws.mediaconvert.VorbisSettings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin22050Max48000)

(s/def
  :cognitect.aws.mediaconvert.VorbisSettings/VbrQuality
  :cognitect.aws.mediaconvert/__integerMinNegative1Max10)

(s/def :cognitect.aws.mediaconvert.CreateJobResponse/Job :cognitect.aws.mediaconvert/Job)

(s/def :cognitect.aws.mediaconvert.PutPolicyResponse/Policy :cognitect.aws.mediaconvert/Policy)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/StereoDownmix
  :cognitect.aws.mediaconvert/Eac3AtmosStereoDownmix)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/BitstreamMode
  :cognitect.aws.mediaconvert/Eac3AtmosBitstreamMode)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/SurroundExMode
  :cognitect.aws.mediaconvert/Eac3AtmosSurroundExMode)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/SpeechThreshold
  :cognitect.aws.mediaconvert/__integerMin0Max100)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/CodingMode
  :cognitect.aws.mediaconvert/Eac3AtmosCodingMode)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/DownmixControl
  :cognitect.aws.mediaconvert/Eac3AtmosDownmixControl)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/LtRtSurroundMixLevel
  :cognitect.aws.mediaconvert/__doubleMinNegative60MaxNegative1)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/Bitrate
  :cognitect.aws.mediaconvert/__integerMin384000Max1024000)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/LtRtCenterMixLevel
  :cognitect.aws.mediaconvert/__doubleMinNegative6Max3)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/DynamicRangeControl
  :cognitect.aws.mediaconvert/Eac3AtmosDynamicRangeControl)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/MeteringMode
  :cognitect.aws.mediaconvert/Eac3AtmosMeteringMode)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/DynamicRangeCompressionRf
  :cognitect.aws.mediaconvert/Eac3AtmosDynamicRangeCompressionRf)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/SampleRate
  :cognitect.aws.mediaconvert/__integerMin48000Max48000)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/DynamicRangeCompressionLine
  :cognitect.aws.mediaconvert/Eac3AtmosDynamicRangeCompressionLine)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/LoRoSurroundMixLevel
  :cognitect.aws.mediaconvert/__doubleMinNegative60MaxNegative1)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/DialogueIntelligence
  :cognitect.aws.mediaconvert/Eac3AtmosDialogueIntelligence)

(s/def
  :cognitect.aws.mediaconvert.Eac3AtmosSettings/LoRoCenterMixLevel
  :cognitect.aws.mediaconvert/__doubleMinNegative6Max3)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInsertionFramerate/FramerateDenominator
  :cognitect.aws.mediaconvert/__integerMin1Max17895697)

(s/def
  :cognitect.aws.mediaconvert.MotionImageInsertionFramerate/FramerateNumerator
  :cognitect.aws.mediaconvert/__integerMin1Max2147483640)

(s/def
  :cognitect.aws.mediaconvert.H264QvbrSettings/MaxAverageBitrate
  :cognitect.aws.mediaconvert/__integerMin1000Max1152000000)

(s/def
  :cognitect.aws.mediaconvert.H264QvbrSettings/QvbrQualityLevel
  :cognitect.aws.mediaconvert/__integerMin1Max10)

(s/def
  :cognitect.aws.mediaconvert.H264QvbrSettings/QvbrQualityLevelFineTune
  :cognitect.aws.mediaconvert/__doubleMin0Max1)

(s/def :cognitect.aws.mediaconvert.GetQueueRequest/Name :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.TimecodeConfig/Anchor
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092)

(s/def :cognitect.aws.mediaconvert.TimecodeConfig/Source :cognitect.aws.mediaconvert/TimecodeSource)

(s/def
  :cognitect.aws.mediaconvert.TimecodeConfig/Start
  :cognitect.aws.mediaconvert/__stringPattern010920405090509092)

(s/def
  :cognitect.aws.mediaconvert.TimecodeConfig/TimestampOffset
  :cognitect.aws.mediaconvert/__stringPattern0940191020191209301)

(s/def :cognitect.aws.mediaconvert.Policy/HttpInputs :cognitect.aws.mediaconvert/InputPolicy)

(s/def :cognitect.aws.mediaconvert.Policy/HttpsInputs :cognitect.aws.mediaconvert/InputPolicy)

(s/def :cognitect.aws.mediaconvert.Policy/S3Inputs :cognitect.aws.mediaconvert/InputPolicy)

(s/def
  :cognitect.aws.mediaconvert.OutputSettings/HlsSettings
  :cognitect.aws.mediaconvert/HlsSettings)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FontFileItalic
  :cognitect.aws.mediaconvert/__stringPatternS3TtfHttpsTtf)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/TeletextSpacing
  :cognitect.aws.mediaconvert/BurninSubtitleTeletextSpacing)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FontFileRegular
  :cognitect.aws.mediaconvert/__stringPatternS3TtfHttpsTtf)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/ShadowYOffset
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/BackgroundOpacity
  :cognitect.aws.mediaconvert/__integerMin0Max255)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/ApplyFontColor
  :cognitect.aws.mediaconvert/BurninSubtitleApplyFontColor)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/HexFontColor
  :cognitect.aws.mediaconvert/__stringMin6Max8Pattern09aFAF609aFAF2)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/OutlineColor
  :cognitect.aws.mediaconvert/BurninSubtitleOutlineColor)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/ShadowXOffset
  :cognitect.aws.mediaconvert/__integerMinNegative2147483648Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FontSize
  :cognitect.aws.mediaconvert/__integerMin0Max96)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FontOpacity
  :cognitect.aws.mediaconvert/__integerMin0Max255)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/Alignment
  :cognitect.aws.mediaconvert/BurninSubtitleAlignment)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/RemoveRubyReserveAttributes
  :cognitect.aws.mediaconvert/RemoveRubyReserveAttributes)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FontFileBoldItalic
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FontColor
  :cognitect.aws.mediaconvert/BurninSubtitleFontColor)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/YPosition
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/ShadowColor
  :cognitect.aws.mediaconvert/BurninSubtitleShadowColor)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FontScript
  :cognitect.aws.mediaconvert/FontScript)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FontResolution
  :cognitect.aws.mediaconvert/__integerMin96Max600)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/BackgroundColor
  :cognitect.aws.mediaconvert/BurninSubtitleBackgroundColor)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FontFileBold
  :cognitect.aws.mediaconvert/__stringPatternS3TtfHttpsTtf)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/ShadowOpacity
  :cognitect.aws.mediaconvert/__integerMin0Max255)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/XPosition
  :cognitect.aws.mediaconvert/__integerMin0Max2147483647)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/StylePassthrough
  :cognitect.aws.mediaconvert/BurnInSubtitleStylePassthrough)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/FallbackFont
  :cognitect.aws.mediaconvert/BurninSubtitleFallbackFont)

(s/def
  :cognitect.aws.mediaconvert.BurninDestinationSettings/OutlineSize
  :cognitect.aws.mediaconvert/__integerMin0Max10)

(s/def
  :cognitect.aws.mediaconvert.EsamManifestConfirmConditionNotification/MccXml
  :cognitect.aws.mediaconvert/__stringPatternSNManifestConfirmConditionNotificationNS)

(s/def
  :cognitect.aws.mediaconvert.Deinterlacer/Algorithm
  :cognitect.aws.mediaconvert/DeinterlaceAlgorithm)

(s/def
  :cognitect.aws.mediaconvert.Deinterlacer/Control
  :cognitect.aws.mediaconvert/DeinterlacerControl)

(s/def :cognitect.aws.mediaconvert.Deinterlacer/Mode :cognitect.aws.mediaconvert/DeinterlacerMode)

(s/def :cognitect.aws.mediaconvert.ConflictException/Message :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.DolbyVisionLevel6Metadata/MaxCll
  :cognitect.aws.mediaconvert/__integerMin0Max65535)

(s/def
  :cognitect.aws.mediaconvert.DolbyVisionLevel6Metadata/MaxFall
  :cognitect.aws.mediaconvert/__integerMin0Max65535)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/Mp3Settings
  :cognitect.aws.mediaconvert/Mp3Settings)

(s/def :cognitect.aws.mediaconvert.AudioCodecSettings/Codec :cognitect.aws.mediaconvert/AudioCodec)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/AacSettings
  :cognitect.aws.mediaconvert/AacSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/Eac3Settings
  :cognitect.aws.mediaconvert/Eac3Settings)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/FlacSettings
  :cognitect.aws.mediaconvert/FlacSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/AiffSettings
  :cognitect.aws.mediaconvert/AiffSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/OpusSettings
  :cognitect.aws.mediaconvert/OpusSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/Mp2Settings
  :cognitect.aws.mediaconvert/Mp2Settings)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/WavSettings
  :cognitect.aws.mediaconvert/WavSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/Ac3Settings
  :cognitect.aws.mediaconvert/Ac3Settings)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/VorbisSettings
  :cognitect.aws.mediaconvert/VorbisSettings)

(s/def
  :cognitect.aws.mediaconvert.AudioCodecSettings/Eac3AtmosSettings
  :cognitect.aws.mediaconvert/Eac3AtmosSettings)

(s/def
  :cognitect.aws.mediaconvert.AncillarySourceSettings/Convert608To708
  :cognitect.aws.mediaconvert/AncillaryConvert608To708)

(s/def
  :cognitect.aws.mediaconvert.AncillarySourceSettings/SourceAncillaryChannelNumber
  :cognitect.aws.mediaconvert/__integerMin1Max4)

(s/def
  :cognitect.aws.mediaconvert.AncillarySourceSettings/TerminateCaptions
  :cognitect.aws.mediaconvert/AncillaryTerminateCaptions)

(s/def :cognitect.aws.mediaconvert.HlsSettings/AudioGroupId :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.HlsSettings/AudioOnlyContainer
  :cognitect.aws.mediaconvert/HlsAudioOnlyContainer)

(s/def
  :cognitect.aws.mediaconvert.HlsSettings/AudioRenditionSets
  :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.HlsSettings/AudioTrackType
  :cognitect.aws.mediaconvert/HlsAudioTrackType)

(s/def
  :cognitect.aws.mediaconvert.HlsSettings/DescriptiveVideoServiceFlag
  :cognitect.aws.mediaconvert/HlsDescriptiveVideoServiceFlag)

(s/def
  :cognitect.aws.mediaconvert.HlsSettings/IFrameOnlyManifest
  :cognitect.aws.mediaconvert/HlsIFrameOnlyManifest)

(s/def :cognitect.aws.mediaconvert.HlsSettings/SegmentModifier :cognitect.aws.mediaconvert/__string)

(s/def
  :cognitect.aws.mediaconvert.CmafAdditionalManifest/ManifestNameModifier
  :cognitect.aws.mediaconvert/__stringMin1)

(s/def
  :cognitect.aws.mediaconvert.CmafAdditionalManifest/SelectedOutputs
  :cognitect.aws.mediaconvert/__listOf__stringMin1)

