;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.medialive.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.medialive/DvbSdtSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DvbSdtSettings/OutputSdt
     :cognitect.aws.medialive.DvbSdtSettings/ServiceName
     :cognitect.aws.medialive.DvbSdtSettings/RepInterval
     :cognitect.aws.medialive.DvbSdtSettings/ServiceProviderName]))

(s/def
  :cognitect.aws.medialive/AudioDescription
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioDescription/AudioSelectorName
     :cognitect.aws.medialive.AudioDescription/Name]
    :opt-un
    [:cognitect.aws.medialive.AudioDescription/StreamName
     :cognitect.aws.medialive.AudioDescription/RemixSettings
     :cognitect.aws.medialive.AudioDescription/AudioType
     :cognitect.aws.medialive.AudioDescription/CodecSettings
     :cognitect.aws.medialive.AudioDescription/LanguageCodeControl
     :cognitect.aws.medialive.AudioDescription/AudioTypeControl
     :cognitect.aws.medialive.AudioDescription/LanguageCode
     :cognitect.aws.medialive.AudioDescription/AudioNormalizationSettings]))

(s/def
  :cognitect.aws.medialive/AudioOnlyHlsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AudioOnlyHlsSettings/AudioOnlyImage
     :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioTrackType
     :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioGroupId]))

(s/def
  :cognitect.aws.medialive/AudioSelector
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioSelector/Name]
    :opt-un
    [:cognitect.aws.medialive.AudioSelector/SelectorSettings]))

(s/def :cognitect.aws.medialive/AvailBlankingState #{"DISABLED" "ENABLED"})

(s/def :cognitect.aws.medialive/M2tsPcrControl #{"CONFIGURED_PCR_PERIOD" "PCR_EVERY_PES_PACKET"})

(s/def
  :cognitect.aws.medialive/DescribeInputSecurityGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Inputs
     :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/WhitelistRules
     :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Arn
     :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/State
     :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Id]))

(s/def :cognitect.aws.medialive/HlsCaptionLanguageSetting #{"INSERT" "NONE" "OMIT"})

(s/def :cognitect.aws.medialive/VideoSelectorColorSpaceUsage #{"FORCE" "FALLBACK"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max30
  (s/with-gen (s/and int? #(<= 0 % 30)) #(gen/choose (or 0 Long/MIN_VALUE) (or 30 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/Scte35SpliceInsert
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Scte35SpliceInsert/NoRegionalBlackoutFlag
     :cognitect.aws.medialive.Scte35SpliceInsert/WebDeliveryAllowedFlag
     :cognitect.aws.medialive.Scte35SpliceInsert/AdAvailOffset]))

(s/def
  :cognitect.aws.medialive/__listOfOutputDestinationSettings
  (s/coll-of :cognitect.aws.medialive/OutputDestinationSettings))

(s/def :cognitect.aws.medialive/AacRawFormat #{"LATM_LOAS" "NONE"})

(s/def :cognitect.aws.medialive/GlobalConfigurationLowFramerateInputs #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/AvailBlanking
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AvailBlanking/State
     :cognitect.aws.medialive.AvailBlanking/AvailBlankingImage]))

(s/def
  :cognitect.aws.medialive/ListReservationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListReservationsResponse/NextToken
     :cognitect.aws.medialive.ListReservationsResponse/Reservations]))

(s/def :cognitect.aws.medialive/InputResolution #{"UHD" "SD" "HD"})

(s/def
  :cognitect.aws.medialive/InputChannelLevel
  (s/keys
    :req-un
    [:cognitect.aws.medialive.InputChannelLevel/InputChannel
     :cognitect.aws.medialive.InputChannelLevel/Gain]))

(s/def :cognitect.aws.medialive/HlsEncryptionType #{"SAMPLE_AES" "AES128"})

(s/def
  :cognitect.aws.medialive/GlobalConfigurationOutputTimingSource
  #{"INPUT_CLOCK" "SYSTEM_CLOCK"})

(s/def
  :cognitect.aws.medialive/OutputGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.OutputGroupSettings/UdpGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/ArchiveGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/MsSmoothGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/RtmpGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/HlsGroupSettings]))

(s/def
  :cognitect.aws.medialive/ListInputSecurityGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputSecurityGroupsRequest/NextToken
     :cognitect.aws.medialive.ListInputSecurityGroupsRequest/MaxResults]))

(s/def :cognitect.aws.medialive/DvbSubDestinationAlignment #{"LEFT" "CENTERED" "SMART"})

(s/def
  :cognitect.aws.medialive/InputSecurityGroup
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSecurityGroup/Inputs
     :cognitect.aws.medialive.InputSecurityGroup/WhitelistRules
     :cognitect.aws.medialive.InputSecurityGroup/Arn
     :cognitect.aws.medialive.InputSecurityGroup/State
     :cognitect.aws.medialive.InputSecurityGroup/Id]))

(s/def
  :cognitect.aws.medialive/SmoothGroupTimestampOffsetMode
  #{"USE_EVENT_START_DATE" "USE_CONFIGURED_OFFSET"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max3600
  (s/with-gen
    (s/and int? #(<= 0 % 3600))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 3600 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/HlsInputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsInputSettings/Bandwidth
     :cognitect.aws.medialive.HlsInputSettings/Retries
     :cognitect.aws.medialive.HlsInputSettings/RetryInterval
     :cognitect.aws.medialive.HlsInputSettings/BufferSegments]))

(s/def
  :cognitect.aws.medialive/__stringMin6Max6
  (s/with-gen
    (s/and string? #(<= 6 (count %) 6))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 6 0) (or 6 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/Scte35TimeSignalApos
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Scte35TimeSignalApos/NoRegionalBlackoutFlag
     :cognitect.aws.medialive.Scte35TimeSignalApos/WebDeliveryAllowedFlag
     :cognitect.aws.medialive.Scte35TimeSignalApos/AdAvailOffset]))

(s/def
  :cognitect.aws.medialive/VideoDescription
  (s/keys
    :req-un
    [:cognitect.aws.medialive.VideoDescription/Name]
    :opt-un
    [:cognitect.aws.medialive.VideoDescription/Sharpness
     :cognitect.aws.medialive.VideoDescription/CodecSettings
     :cognitect.aws.medialive.VideoDescription/Width
     :cognitect.aws.medialive.VideoDescription/ScalingBehavior
     :cognitect.aws.medialive.VideoDescription/Height
     :cognitect.aws.medialive.VideoDescription/RespondToAfd]))

(s/def :cognitect.aws.medialive/M2tsScte35Control #{"PASSTHROUGH" "NONE"})

(s/def :cognitect.aws.medialive/Scte35SpliceInsertWebDeliveryAllowedBehavior #{"FOLLOW" "IGNORE"})

(s/def :cognitect.aws.medialive/AribDestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/__doubleMin1
  (s/with-gen double? #(gen/double* {:infinite? false, :NaN? false})))

(s/def :cognitect.aws.medialive/BurnInOutlineColor #{"GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})

(s/def :cognitect.aws.medialive/ReservationSpecialFeature #{"AUDIO_NORMALIZATION" "ADVANCED_AUDIO"})

(s/def
  :cognitect.aws.medialive/ChannelSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ChannelSummary/InputAttachments
     :cognitect.aws.medialive.ChannelSummary/PipelinesRunningCount
     :cognitect.aws.medialive.ChannelSummary/LogLevel
     :cognitect.aws.medialive.ChannelSummary/RoleArn
     :cognitect.aws.medialive.ChannelSummary/EgressEndpoints
     :cognitect.aws.medialive.ChannelSummary/Arn
     :cognitect.aws.medialive.ChannelSummary/InputSpecification
     :cognitect.aws.medialive.ChannelSummary/State
     :cognitect.aws.medialive.ChannelSummary/Destinations
     :cognitect.aws.medialive.ChannelSummary/Name
     :cognitect.aws.medialive.ChannelSummary/Id]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max32
  (s/with-gen (s/and int? #(<= 1 % 32)) #(gen/choose (or 1 Long/MIN_VALUE) (or 32 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/M2tsAudioStreamType #{"DVB" "ATSC"})

(s/def
  :cognitect.aws.medialive/ListInputSecurityGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputSecurityGroupsResponse/InputSecurityGroups
     :cognitect.aws.medialive.ListInputSecurityGroupsResponse/NextToken]))

(s/def
  :cognitect.aws.medialive/Scte35SegmentationDescriptor
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationEventId
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationCancelIndicator]
    :opt-un
    [:cognitect.aws.medialive.Scte35SegmentationDescriptor/SubSegmentNum
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationDuration
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationTypeId
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationUpid
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationUpidType
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentsExpected
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SubSegmentsExpected
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentNum
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/DeliveryRestrictions]))

(s/def :cognitect.aws.medialive/H264ScanType #{"PROGRESSIVE" "INTERLACED"})

(s/def
  :cognitect.aws.medialive/DvbSubDestinationOutlineColor
  #{"GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})

(s/def
  :cognitect.aws.medialive/DeleteChannelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteChannelResponse/InputAttachments
     :cognitect.aws.medialive.DeleteChannelResponse/PipelinesRunningCount
     :cognitect.aws.medialive.DeleteChannelResponse/LogLevel
     :cognitect.aws.medialive.DeleteChannelResponse/RoleArn
     :cognitect.aws.medialive.DeleteChannelResponse/EgressEndpoints
     :cognitect.aws.medialive.DeleteChannelResponse/EncoderSettings
     :cognitect.aws.medialive.DeleteChannelResponse/Arn
     :cognitect.aws.medialive.DeleteChannelResponse/InputSpecification
     :cognitect.aws.medialive.DeleteChannelResponse/State
     :cognitect.aws.medialive.DeleteChannelResponse/Destinations
     :cognitect.aws.medialive.DeleteChannelResponse/Name
     :cognitect.aws.medialive.DeleteChannelResponse/Id]))

(s/def
  :cognitect.aws.medialive/__listOfInputWhitelistRuleCidr
  (s/coll-of :cognitect.aws.medialive/InputWhitelistRuleCidr))

(s/def
  :cognitect.aws.medialive/CreateChannelResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreateChannelResponse/Channel]))

(s/def
  :cognitect.aws.medialive/__integerMin4Max20
  (s/with-gen (s/and int? #(<= 4 % 20)) #(gen/choose (or 4 Long/MIN_VALUE) (or 20 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/ReservationResourceSpecification
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ReservationResourceSpecification/Codec
     :cognitect.aws.medialive.ReservationResourceSpecification/Resolution
     :cognitect.aws.medialive.ReservationResourceSpecification/MaximumBitrate
     :cognitect.aws.medialive.ReservationResourceSpecification/ResourceType
     :cognitect.aws.medialive.ReservationResourceSpecification/VideoQuality
     :cognitect.aws.medialive.ReservationResourceSpecification/SpecialFeature
     :cognitect.aws.medialive.ReservationResourceSpecification/MaximumFramerate]))

(s/def :cognitect.aws.medialive/__listOfInput (s/coll-of :cognitect.aws.medialive/Input))

(s/def :cognitect.aws.medialive/H264LookAheadRateControl #{"LOW" "HIGH" "MEDIUM"})

(s/def :cognitect.aws.medialive/M2tsSegmentationStyle #{"MAINTAIN_CADENCE" "RESET_CADENCE"})

(s/def
  :cognitect.aws.medialive/CaptionLanguageMapping
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CaptionLanguageMapping/LanguageCode
     :cognitect.aws.medialive.CaptionLanguageMapping/LanguageDescription
     :cognitect.aws.medialive.CaptionLanguageMapping/CaptionChannel]))

(s/def
  :cognitect.aws.medialive/OutputDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.OutputDestinationSettings/Username
     :cognitect.aws.medialive.OutputDestinationSettings/StreamName
     :cognitect.aws.medialive.OutputDestinationSettings/Url
     :cognitect.aws.medialive.OutputDestinationSettings/PasswordParam]))

(s/def :cognitect.aws.medialive/HlsAkamaiHttpTransferMode #{"NON_CHUNKED" "CHUNKED"})

(s/def
  :cognitect.aws.medialive/Scte35TimeSignalScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35TimeSignalScheduleActionSettings/Scte35Descriptors]))

(s/def
  :cognitect.aws.medialive/OutputDestination
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.OutputDestination/Settings
     :cognitect.aws.medialive.OutputDestination/Id]))

(s/def
  :cognitect.aws.medialive/BlackoutSlate
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BlackoutSlate/NetworkEndBlackoutImage
     :cognitect.aws.medialive.BlackoutSlate/NetworkId
     :cognitect.aws.medialive.BlackoutSlate/NetworkEndBlackout
     :cognitect.aws.medialive.BlackoutSlate/BlackoutSlateImage
     :cognitect.aws.medialive.BlackoutSlate/State]))

(s/def :cognitect.aws.medialive/BurnInFontColor #{"GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})

(s/def :cognitect.aws.medialive/SmoothGroupSparseTrackType #{"NONE" "SCTE_35"})

(s/def
  :cognitect.aws.medialive/__integerMin1Max10
  (s/with-gen (s/and int? #(<= 1 % 10)) #(gen/choose (or 1 Long/MIN_VALUE) (or 10 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/ArchiveContainerSettings
  (s/keys :opt-un [:cognitect.aws.medialive.ArchiveContainerSettings/M2tsSettings]))

(s/def
  :cognitect.aws.medialive/Eac3DrcLine
  #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})

(s/def :cognitect.aws.medialive/LogLevel #{"DISABLED" "WARNING" "ERROR" "DEBUG" "INFO"})

(s/def :cognitect.aws.medialive/M2tsAudioInterval #{"VIDEO_AND_FIXED_INTERVALS" "VIDEO_INTERVAL"})

(s/def :cognitect.aws.medialive/ReservationState #{"CANCELED" "EXPIRED" "ACTIVE" "DELETED"})

(s/def
  :cognitect.aws.medialive/Eac3CodingMode
  #{"CODING_MODE_1_0" "CODING_MODE_2_0" "CODING_MODE_3_2"})

(s/def :cognitect.aws.medialive/M2tsAribCaptionsPidControl #{"USE_CONFIGURED" "AUTO"})

(s/def
  :cognitect.aws.medialive/Scte35SpliceInsertScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35SpliceInsertScheduleActionSettings/SpliceEventId]
    :opt-un
    [:cognitect.aws.medialive.Scte35SpliceInsertScheduleActionSettings/Duration]))

(s/def :cognitect.aws.medialive/EmbeddedDestinationSettings (s/keys))

(s/def :cognitect.aws.medialive/Ac3LfeFilter #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/HlsGroupSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.HlsGroupSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.HlsGroupSettings/SegmentLength
     :cognitect.aws.medialive.HlsGroupSettings/TsFileMode
     :cognitect.aws.medialive.HlsGroupSettings/TimestampDeltaMilliseconds
     :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTimePeriod
     :cognitect.aws.medialive.HlsGroupSettings/ConstantIv
     :cognitect.aws.medialive.HlsGroupSettings/KeyFormatVersions
     :cognitect.aws.medialive.HlsGroupSettings/InputLossAction
     :cognitect.aws.medialive.HlsGroupSettings/AdMarkers
     :cognitect.aws.medialive.HlsGroupSettings/CaptionLanguageMappings
     :cognitect.aws.medialive.HlsGroupSettings/TimedMetadataId3Frame
     :cognitect.aws.medialive.HlsGroupSettings/Mode
     :cognitect.aws.medialive.HlsGroupSettings/DirectoryStructure
     :cognitect.aws.medialive.HlsGroupSettings/EncryptionType
     :cognitect.aws.medialive.HlsGroupSettings/IndexNSegments
     :cognitect.aws.medialive.HlsGroupSettings/KeepSegments
     :cognitect.aws.medialive.HlsGroupSettings/MinSegmentLength
     :cognitect.aws.medialive.HlsGroupSettings/IvInManifest
     :cognitect.aws.medialive.HlsGroupSettings/StreamInfResolution
     :cognitect.aws.medialive.HlsGroupSettings/HlsCdnSettings
     :cognitect.aws.medialive.HlsGroupSettings/RedundantManifest
     :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTime
     :cognitect.aws.medialive.HlsGroupSettings/OutputSelection
     :cognitect.aws.medialive.HlsGroupSettings/BaseUrlContent
     :cognitect.aws.medialive.HlsGroupSettings/CaptionLanguageSetting
     :cognitect.aws.medialive.HlsGroupSettings/ManifestDurationFormat
     :cognitect.aws.medialive.HlsGroupSettings/SegmentationMode
     :cognitect.aws.medialive.HlsGroupSettings/TimedMetadataId3Period
     :cognitect.aws.medialive.HlsGroupSettings/ManifestCompression
     :cognitect.aws.medialive.HlsGroupSettings/SegmentsPerSubdirectory
     :cognitect.aws.medialive.HlsGroupSettings/KeyFormat
     :cognitect.aws.medialive.HlsGroupSettings/IvSource
     :cognitect.aws.medialive.HlsGroupSettings/CodecSpecification
     :cognitect.aws.medialive.HlsGroupSettings/KeyProviderSettings
     :cognitect.aws.medialive.HlsGroupSettings/BaseUrlManifest
     :cognitect.aws.medialive.HlsGroupSettings/ClientCache]))

(s/def
  :cognitect.aws.medialive/__listOfInputDestinationRequest
  (s/coll-of :cognitect.aws.medialive/InputDestinationRequest))

(s/def :cognitect.aws.medialive/HlsTimedMetadataId3Frame #{"TDRL" "NONE" "PRIV"})

(s/def :cognitect.aws.medialive/H264FramerateControl #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})

(s/def :cognitect.aws.medialive/AudioDescriptionAudioTypeControl #{"FOLLOW_INPUT" "USE_CONFIGURED"})

(s/def :cognitect.aws.medialive/VideoSelectorColorSpace #{"REC_601" "FOLLOW" "REC_709"})

(s/def :cognitect.aws.medialive/FecOutputIncludeFec #{"COLUMN_AND_ROW" "COLUMN"})

(s/def
  :cognitect.aws.medialive/__listOfAudioDescription
  (s/coll-of :cognitect.aws.medialive/AudioDescription))

(s/def
  :cognitect.aws.medialive/InputLossBehavior
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputLossBehavior/InputLossImageSlate
     :cognitect.aws.medialive.InputLossBehavior/InputLossImageType
     :cognitect.aws.medialive.InputLossBehavior/InputLossImageColor
     :cognitect.aws.medialive.InputLossBehavior/BlackFrameMsec
     :cognitect.aws.medialive.InputLossBehavior/RepeatFrameMsec]))

(s/def
  :cognitect.aws.medialive/Scte35DeliveryRestrictions
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35DeliveryRestrictions/DeviceRestrictions
     :cognitect.aws.medialive.Scte35DeliveryRestrictions/ArchiveAllowedFlag
     :cognitect.aws.medialive.Scte35DeliveryRestrictions/WebDeliveryAllowedFlag
     :cognitect.aws.medialive.Scte35DeliveryRestrictions/NoRegionalBlackoutFlag]))

(s/def :cognitect.aws.medialive/Eac3PassthroughControl #{"WHEN_POSSIBLE" "NO_PASSTHROUGH"})

(s/def
  :cognitect.aws.medialive/PurchaseOfferingRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.PurchaseOfferingRequest/OfferingId
     :cognitect.aws.medialive.PurchaseOfferingRequest/Count]
    :opt-un
    [:cognitect.aws.medialive.PurchaseOfferingRequest/RequestId
     :cognitect.aws.medialive.PurchaseOfferingRequest/Start
     :cognitect.aws.medialive.PurchaseOfferingRequest/Name]))

(s/def
  :cognitect.aws.medialive/DvbSubDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DvbSubDestinationSettings/OutlineColor
     :cognitect.aws.medialive.DvbSubDestinationSettings/OutlineSize
     :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowColor
     :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowOpacity
     :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowYOffset
     :cognitect.aws.medialive.DvbSubDestinationSettings/BackgroundColor
     :cognitect.aws.medialive.DvbSubDestinationSettings/TeletextGridControl
     :cognitect.aws.medialive.DvbSubDestinationSettings/YPosition
     :cognitect.aws.medialive.DvbSubDestinationSettings/FontColor
     :cognitect.aws.medialive.DvbSubDestinationSettings/XPosition
     :cognitect.aws.medialive.DvbSubDestinationSettings/Font
     :cognitect.aws.medialive.DvbSubDestinationSettings/FontResolution
     :cognitect.aws.medialive.DvbSubDestinationSettings/FontSize
     :cognitect.aws.medialive.DvbSubDestinationSettings/BackgroundOpacity
     :cognitect.aws.medialive.DvbSubDestinationSettings/FontOpacity
     :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowXOffset
     :cognitect.aws.medialive.DvbSubDestinationSettings/Alignment]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max500
  (s/with-gen
    (s/and int? #(<= 0 % 500))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 500 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/HlsClientCache #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/DescribeOfferingResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeOfferingResponse/DurationUnits
     :cognitect.aws.medialive.DescribeOfferingResponse/CurrencyCode
     :cognitect.aws.medialive.DescribeOfferingResponse/OfferingDescription
     :cognitect.aws.medialive.DescribeOfferingResponse/ResourceSpecification
     :cognitect.aws.medialive.DescribeOfferingResponse/FixedPrice
     :cognitect.aws.medialive.DescribeOfferingResponse/OfferingId
     :cognitect.aws.medialive.DescribeOfferingResponse/Duration
     :cognitect.aws.medialive.DescribeOfferingResponse/UsagePrice
     :cognitect.aws.medialive.DescribeOfferingResponse/Arn
     :cognitect.aws.medialive.DescribeOfferingResponse/OfferingType
     :cognitect.aws.medialive.DescribeOfferingResponse/Region]))

(s/def
  :cognitect.aws.medialive/BurnInDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BurnInDestinationSettings/OutlineColor
     :cognitect.aws.medialive.BurnInDestinationSettings/OutlineSize
     :cognitect.aws.medialive.BurnInDestinationSettings/ShadowColor
     :cognitect.aws.medialive.BurnInDestinationSettings/ShadowOpacity
     :cognitect.aws.medialive.BurnInDestinationSettings/ShadowYOffset
     :cognitect.aws.medialive.BurnInDestinationSettings/BackgroundColor
     :cognitect.aws.medialive.BurnInDestinationSettings/TeletextGridControl
     :cognitect.aws.medialive.BurnInDestinationSettings/YPosition
     :cognitect.aws.medialive.BurnInDestinationSettings/FontColor
     :cognitect.aws.medialive.BurnInDestinationSettings/XPosition
     :cognitect.aws.medialive.BurnInDestinationSettings/Font
     :cognitect.aws.medialive.BurnInDestinationSettings/FontResolution
     :cognitect.aws.medialive.BurnInDestinationSettings/FontSize
     :cognitect.aws.medialive.BurnInDestinationSettings/BackgroundOpacity
     :cognitect.aws.medialive.BurnInDestinationSettings/FontOpacity
     :cognitect.aws.medialive.BurnInDestinationSettings/ShadowXOffset
     :cognitect.aws.medialive.BurnInDestinationSettings/Alignment]))

(s/def
  :cognitect.aws.medialive/MsSmoothOutputSettings
  (s/keys :opt-un [:cognitect.aws.medialive.MsSmoothOutputSettings/NameModifier]))

(s/def
  :cognitect.aws.medialive/Eac3DrcRf
  #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})

(s/def
  :cognitect.aws.medialive/NetworkInputServerValidation
  #{"CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME" "CHECK_CRYPTOGRAPHY_ONLY"})

(s/def
  :cognitect.aws.medialive/UpdateInputResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateInputResponse/Input]))

(s/def
  :cognitect.aws.medialive/VideoSelector
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.VideoSelector/SelectorSettings
     :cognitect.aws.medialive.VideoSelector/ColorSpace
     :cognitect.aws.medialive.VideoSelector/ColorSpaceUsage]))

(s/def
  :cognitect.aws.medialive/__listOfCaptionSelector
  (s/coll-of :cognitect.aws.medialive/CaptionSelector))

(s/def
  :cognitect.aws.medialive/__listOfVideoDescription
  (s/coll-of :cognitect.aws.medialive/VideoDescription))

(s/def
  :cognitect.aws.medialive/__integerMin1Max4
  (s/with-gen (s/and int? #(<= 1 % 4)) #(gen/choose (or 1 Long/MIN_VALUE) (or 4 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/Eac3SurroundMode #{"DISABLED" "NOT_INDICATED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/EncoderSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.EncoderSettings/VideoDescriptions
     :cognitect.aws.medialive.EncoderSettings/AudioDescriptions
     :cognitect.aws.medialive.EncoderSettings/OutputGroups
     :cognitect.aws.medialive.EncoderSettings/TimecodeConfig]
    :opt-un
    [:cognitect.aws.medialive.EncoderSettings/GlobalConfiguration
     :cognitect.aws.medialive.EncoderSettings/CaptionDescriptions
     :cognitect.aws.medialive.EncoderSettings/AvailConfiguration
     :cognitect.aws.medialive.EncoderSettings/BlackoutSlate
     :cognitect.aws.medialive.EncoderSettings/AvailBlanking]))

(s/def :cognitect.aws.medialive/ReservationMaximumFramerate #{"MAX_30_FPS" "MAX_60_FPS"})

(s/def
  :cognitect.aws.medialive/__listOfReservation
  (s/coll-of :cognitect.aws.medialive/Reservation))

(s/def
  :cognitect.aws.medialive/__integerMinNegative60Max6
  (s/with-gen
    (s/and int? #(<= -60 % 6))
    #(gen/choose (or -60 Long/MIN_VALUE) (or 6 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/TimecodeConfigSource #{"ZEROBASED" "EMBEDDED" "SYSTEMCLOCK"})

(s/def
  :cognitect.aws.medialive/PurchaseOfferingResponse
  (s/keys :opt-un [:cognitect.aws.medialive.PurchaseOfferingResponse/Reservation]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max65536
  (s/with-gen
    (s/and int? #(<= 0 % 65536))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 65536 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/AacCodingMode
  #{"AD_RECEIVER_MIX" "CODING_MODE_1_0" "CODING_MODE_1_1" "CODING_MODE_2_0" "CODING_MODE_5_1"})

(s/def
  :cognitect.aws.medialive/InputSource
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSource/Username
     :cognitect.aws.medialive.InputSource/Url
     :cognitect.aws.medialive.InputSource/PasswordParam]))

(s/def :cognitect.aws.medialive/M2tsTimedMetadataBehavior #{"PASSTHROUGH" "NO_PASSTHROUGH"})

(s/def
  :cognitect.aws.medialive/__double
  (s/with-gen double? #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/__stringMin32Max32
  (s/with-gen
    (s/and string? #(<= 32 (count %) 32))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 32 0) (or 32 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive/H264EntropyEncoding #{"CABAC" "CAVLC"})

(s/def :cognitect.aws.medialive/AribSourceSettings (s/keys))

(s/def
  :cognitect.aws.medialive/HlsDirectoryStructure
  #{"SINGLE_DIRECTORY" "SUBDIRECTORY_PER_STREAM"})

(s/def :cognitect.aws.medialive/HlsStreamInfResolution #{"INCLUDE" "EXCLUDE"})

(s/def
  :cognitect.aws.medialive/Scte35DeviceRestrictions
  #{"RESTRICT_GROUP1" "RESTRICT_GROUP0" "RESTRICT_GROUP2" "NONE"})

(s/def
  :cognitect.aws.medialive/__listOfInputAttachment
  (s/coll-of :cognitect.aws.medialive/InputAttachment))

(s/def
  :cognitect.aws.medialive/Scte35Descriptor
  (s/keys :req-un [:cognitect.aws.medialive.Scte35Descriptor/Scte35DescriptorSettings]))

(s/def
  :cognitect.aws.medialive/ArchiveGroupSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ArchiveGroupSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.ArchiveGroupSettings/RolloverInterval]))

(s/def
  :cognitect.aws.medialive/__listOfCaptionLanguageMapping
  (s/coll-of :cognitect.aws.medialive/CaptionLanguageMapping))

(s/def
  :cognitect.aws.medialive/Input
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Input/Type
     :cognitect.aws.medialive.Input/SecurityGroups
     :cognitect.aws.medialive.Input/Arn
     :cognitect.aws.medialive.Input/State
     :cognitect.aws.medialive.Input/Destinations
     :cognitect.aws.medialive.Input/Name
     :cognitect.aws.medialive.Input/Sources
     :cognitect.aws.medialive.Input/AttachedChannels
     :cognitect.aws.medialive.Input/Id]))

(s/def :cognitect.aws.medialive/InputDeblockFilter #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/DeleteReservationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteReservationResponse/DurationUnits
     :cognitect.aws.medialive.DeleteReservationResponse/CurrencyCode
     :cognitect.aws.medialive.DeleteReservationResponse/OfferingDescription
     :cognitect.aws.medialive.DeleteReservationResponse/ResourceSpecification
     :cognitect.aws.medialive.DeleteReservationResponse/Start
     :cognitect.aws.medialive.DeleteReservationResponse/FixedPrice
     :cognitect.aws.medialive.DeleteReservationResponse/End
     :cognitect.aws.medialive.DeleteReservationResponse/Count
     :cognitect.aws.medialive.DeleteReservationResponse/OfferingId
     :cognitect.aws.medialive.DeleteReservationResponse/Duration
     :cognitect.aws.medialive.DeleteReservationResponse/UsagePrice
     :cognitect.aws.medialive.DeleteReservationResponse/Arn
     :cognitect.aws.medialive.DeleteReservationResponse/State
     :cognitect.aws.medialive.DeleteReservationResponse/OfferingType
     :cognitect.aws.medialive.DeleteReservationResponse/Name
     :cognitect.aws.medialive.DeleteReservationResponse/ReservationId
     :cognitect.aws.medialive.DeleteReservationResponse/Region]))

(s/def :cognitect.aws.medialive/HlsTsFileMode #{"SINGLE_FILE" "SEGMENTED_FILES"})

(s/def
  :cognitect.aws.medialive/__stringMin34Max34
  (s/with-gen
    (s/and string? #(<= 34 (count %) 34))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 34 0) (or 34 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive/Scte20Convert608To708 #{"DISABLED" "UPCONVERT"})

(s/def :cognitect.aws.medialive/ReservationVideoQuality #{"ENHANCED" "STANDARD" "PREMIUM"})

(s/def
  :cognitect.aws.medialive/AudioType
  #{"VISUAL_IMPAIRED_COMMENTARY" "UNDEFINED" "HEARING_IMPAIRED" "CLEAN_EFFECTS"})

(s/def
  :cognitect.aws.medialive/__integerMin1Max8
  (s/with-gen (s/and int? #(<= 1 % 8)) #(gen/choose (or 1 Long/MIN_VALUE) (or 8 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/AacSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AacSettings/RateControlMode
     :cognitect.aws.medialive.AacSettings/CodingMode
     :cognitect.aws.medialive.AacSettings/InputType
     :cognitect.aws.medialive.AacSettings/SampleRate
     :cognitect.aws.medialive.AacSettings/Spec
     :cognitect.aws.medialive.AacSettings/VbrQuality
     :cognitect.aws.medialive.AacSettings/Profile
     :cognitect.aws.medialive.AacSettings/RawFormat
     :cognitect.aws.medialive.AacSettings/Bitrate]))

(s/def :cognitect.aws.medialive/HlsIvInManifest #{"INCLUDE" "EXCLUDE"})

(s/def
  :cognitect.aws.medialive/StartChannelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StartChannelResponse/InputAttachments
     :cognitect.aws.medialive.StartChannelResponse/PipelinesRunningCount
     :cognitect.aws.medialive.StartChannelResponse/LogLevel
     :cognitect.aws.medialive.StartChannelResponse/RoleArn
     :cognitect.aws.medialive.StartChannelResponse/EgressEndpoints
     :cognitect.aws.medialive.StartChannelResponse/EncoderSettings
     :cognitect.aws.medialive.StartChannelResponse/Arn
     :cognitect.aws.medialive.StartChannelResponse/InputSpecification
     :cognitect.aws.medialive.StartChannelResponse/State
     :cognitect.aws.medialive.StartChannelResponse/Destinations
     :cognitect.aws.medialive.StartChannelResponse/Name
     :cognitect.aws.medialive.StartChannelResponse/Id]))

(s/def
  :cognitect.aws.medialive/__stringMin1Max256
  (s/with-gen
    (s/and string? #(<= 1 (count %) 256))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 256 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive/EmbeddedScte20Detection #{"AUTO" "OFF"})

(s/def :cognitect.aws.medialive/HlsMediaStoreStorageClass #{"TEMPORAL"})

(s/def :cognitect.aws.medialive/H264Syntax #{"RP2027" "DEFAULT"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max4294967295
  (s/with-gen
    (s/and int? #(<= 0 % 4294967295))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 4294967295 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/TeletextDestinationSettings (s/keys))

(s/def :cognitect.aws.medialive/AacInputType #{"NORMAL" "BROADCASTER_MIXED_AD"})

(s/def :cognitect.aws.medialive/BurnInShadowColor #{"NONE" "WHITE" "BLACK"})

(s/def
  :cognitect.aws.medialive/FixedAfd
  #{"AFD_0010" "AFD_1101" "AFD_1000" "AFD_1111" "AFD_0000" "AFD_1011" "AFD_0011" "AFD_1001"
    "AFD_0100" "AFD_1010" "AFD_1110"})

(s/def
  :cognitect.aws.medialive/UdpContainerSettings
  (s/keys :opt-un [:cognitect.aws.medialive.UdpContainerSettings/M2tsSettings]))

(s/def
  :cognitect.aws.medialive/InputSpecification
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSpecification/Codec
     :cognitect.aws.medialive.InputSpecification/Resolution
     :cognitect.aws.medialive.InputSpecification/MaximumBitrate]))

(s/def :cognitect.aws.medialive/HlsIvSource #{"EXPLICIT" "FOLLOWS_SEGMENT_NUMBER"})

(s/def
  :cognitect.aws.medialive/DvbSubDestinationFontColor
  #{"GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})

(s/def :cognitect.aws.medialive/Ac3MetadataControl #{"FOLLOW_INPUT" "USE_CONFIGURED"})

(s/def :cognitect.aws.medialive/AacRateControlMode #{"VBR" "CBR"})

(s/def
  :cognitect.aws.medialive/Scte35NoRegionalBlackoutFlag
  #{"REGIONAL_BLACKOUT" "NO_REGIONAL_BLACKOUT"})

(s/def :cognitect.aws.medialive/BlackoutSlateNetworkEndBlackout #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/BatchScheduleActionDeleteRequest
  (s/keys :req-un [:cognitect.aws.medialive.BatchScheduleActionDeleteRequest/ActionNames]))

(s/def :cognitect.aws.medialive/HlsProgramDateTime #{"INCLUDE" "EXCLUDE"})

(s/def
  :cognitect.aws.medialive/CreateInputRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateInputRequest/RequestId
     :cognitect.aws.medialive.CreateInputRequest/Type
     :cognitect.aws.medialive.CreateInputRequest/InputSecurityGroups
     :cognitect.aws.medialive.CreateInputRequest/Destinations
     :cognitect.aws.medialive.CreateInputRequest/Name
     :cognitect.aws.medialive.CreateInputRequest/Sources]))

(s/def
  :cognitect.aws.medialive/Channel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Channel/InputAttachments
     :cognitect.aws.medialive.Channel/PipelinesRunningCount
     :cognitect.aws.medialive.Channel/LogLevel
     :cognitect.aws.medialive.Channel/RoleArn
     :cognitect.aws.medialive.Channel/EgressEndpoints
     :cognitect.aws.medialive.Channel/EncoderSettings
     :cognitect.aws.medialive.Channel/Arn
     :cognitect.aws.medialive.Channel/InputSpecification
     :cognitect.aws.medialive.Channel/State
     :cognitect.aws.medialive.Channel/Destinations
     :cognitect.aws.medialive.Channel/Name
     :cognitect.aws.medialive.Channel/Id]))

(s/def
  :cognitect.aws.medialive/H264Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.H264Settings/Level
     :cognitect.aws.medialive.H264Settings/RateControlMode
     :cognitect.aws.medialive.H264Settings/MinIInterval
     :cognitect.aws.medialive.H264Settings/TemporalAq
     :cognitect.aws.medialive.H264Settings/ParDenominator
     :cognitect.aws.medialive.H264Settings/QvbrQualityLevel
     :cognitect.aws.medialive.H264Settings/NumRefFrames
     :cognitect.aws.medialive.H264Settings/GopBReference
     :cognitect.aws.medialive.H264Settings/TimecodeInsertion
     :cognitect.aws.medialive.H264Settings/ScanType
     :cognitect.aws.medialive.H264Settings/AdaptiveQuantization
     :cognitect.aws.medialive.H264Settings/AfdSignaling
     :cognitect.aws.medialive.H264Settings/BufFillPct
     :cognitect.aws.medialive.H264Settings/FramerateDenominator
     :cognitect.aws.medialive.H264Settings/SpatialAq
     :cognitect.aws.medialive.H264Settings/FramerateControl
     :cognitect.aws.medialive.H264Settings/GopNumBFrames
     :cognitect.aws.medialive.H264Settings/BufSize
     :cognitect.aws.medialive.H264Settings/Profile
     :cognitect.aws.medialive.H264Settings/ColorMetadata
     :cognitect.aws.medialive.H264Settings/LookAheadRateControl
     :cognitect.aws.medialive.H264Settings/Syntax
     :cognitect.aws.medialive.H264Settings/GopClosedCadence
     :cognitect.aws.medialive.H264Settings/FlickerAq
     :cognitect.aws.medialive.H264Settings/FramerateNumerator
     :cognitect.aws.medialive.H264Settings/Softness
     :cognitect.aws.medialive.H264Settings/GopSizeUnits
     :cognitect.aws.medialive.H264Settings/MaxBitrate
     :cognitect.aws.medialive.H264Settings/ParNumerator
     :cognitect.aws.medialive.H264Settings/GopSize
     :cognitect.aws.medialive.H264Settings/ParControl
     :cognitect.aws.medialive.H264Settings/Slices
     :cognitect.aws.medialive.H264Settings/FixedAfd
     :cognitect.aws.medialive.H264Settings/EntropyEncoding
     :cognitect.aws.medialive.H264Settings/SceneChangeDetect
     :cognitect.aws.medialive.H264Settings/Bitrate]))

(s/def
  :cognitect.aws.medialive/__doubleMinNegative59Max0
  (s/with-gen double? #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/__stringMin1
  (s/with-gen
    (s/and string? #(<= 1 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or nil 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/__integerMin3
  (s/with-gen (s/and int? #(<= 3 %)) #(gen/choose (or 3 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/__integerMinNegative1000Max1000
  (s/with-gen
    (s/and int? #(<= -1000 % 1000))
    #(gen/choose (or -1000 Long/MIN_VALUE) (or 1000 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/VideoCodecSettings
  (s/keys :opt-un [:cognitect.aws.medialive.VideoCodecSettings/H264Settings]))

(s/def :cognitect.aws.medialive/M2tsBufferModel #{"NONE" "MULTIPLEX"})

(s/def
  :cognitect.aws.medialive/Eac3Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Eac3Settings/LtRtSurroundMixLevel
     :cognitect.aws.medialive.Eac3Settings/CodingMode
     :cognitect.aws.medialive.Eac3Settings/PhaseControl
     :cognitect.aws.medialive.Eac3Settings/PassthroughControl
     :cognitect.aws.medialive.Eac3Settings/SurroundMode
     :cognitect.aws.medialive.Eac3Settings/AttenuationControl
     :cognitect.aws.medialive.Eac3Settings/DrcLine
     :cognitect.aws.medialive.Eac3Settings/DcFilter
     :cognitect.aws.medialive.Eac3Settings/LfeFilter
     :cognitect.aws.medialive.Eac3Settings/LfeControl
     :cognitect.aws.medialive.Eac3Settings/LoRoCenterMixLevel
     :cognitect.aws.medialive.Eac3Settings/StereoDownmix
     :cognitect.aws.medialive.Eac3Settings/LtRtCenterMixLevel
     :cognitect.aws.medialive.Eac3Settings/SurroundExMode
     :cognitect.aws.medialive.Eac3Settings/MetadataControl
     :cognitect.aws.medialive.Eac3Settings/LoRoSurroundMixLevel
     :cognitect.aws.medialive.Eac3Settings/DrcRf
     :cognitect.aws.medialive.Eac3Settings/BitstreamMode
     :cognitect.aws.medialive.Eac3Settings/Dialnorm
     :cognitect.aws.medialive.Eac3Settings/Bitrate]))

(s/def
  :cognitect.aws.medialive/InputLocation
  (s/keys
    :req-un
    [:cognitect.aws.medialive.InputLocation/Uri]
    :opt-un
    [:cognitect.aws.medialive.InputLocation/Username
     :cognitect.aws.medialive.InputLocation/PasswordParam]))

(s/def
  :cognitect.aws.medialive/Ac3CodingMode
  #{"CODING_MODE_1_0" "CODING_MODE_3_2_LFE" "CODING_MODE_1_1" "CODING_MODE_2_0"})

(s/def :cognitect.aws.medialive/Ac3DrcProfile #{"FILM_STANDARD" "NONE"})

(s/def :cognitect.aws.medialive/HlsManifestDurationFormat #{"FLOATING_POINT" "INTEGER"})

(s/def
  :cognitect.aws.medialive/M3u8Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.M3u8Settings/PatInterval
     :cognitect.aws.medialive.M3u8Settings/AudioFramesPerPes
     :cognitect.aws.medialive.M3u8Settings/TransportStreamId
     :cognitect.aws.medialive.M3u8Settings/Scte35Behavior
     :cognitect.aws.medialive.M3u8Settings/TimedMetadataBehavior
     :cognitect.aws.medialive.M3u8Settings/PcrControl
     :cognitect.aws.medialive.M3u8Settings/Scte35Pid
     :cognitect.aws.medialive.M3u8Settings/PcrPid
     :cognitect.aws.medialive.M3u8Settings/PmtPid
     :cognitect.aws.medialive.M3u8Settings/VideoPid
     :cognitect.aws.medialive.M3u8Settings/AudioPids
     :cognitect.aws.medialive.M3u8Settings/PcrPeriod
     :cognitect.aws.medialive.M3u8Settings/PmtInterval
     :cognitect.aws.medialive.M3u8Settings/ProgramNum
     :cognitect.aws.medialive.M3u8Settings/TimedMetadataPid
     :cognitect.aws.medialive.M3u8Settings/EcmPid]))

(s/def
  :cognitect.aws.medialive/AudioSelectorSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AudioSelectorSettings/AudioPidSelection
     :cognitect.aws.medialive.AudioSelectorSettings/AudioLanguageSelection]))

(s/def :cognitect.aws.medialive/H264RateControlMode #{"VBR" "CBR" "QVBR"})

(s/def :cognitect.aws.medialive/SmpteTtDestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/__integerMin1Max5
  (s/with-gen (s/and int? #(<= 1 % 5)) #(gen/choose (or 1 Long/MIN_VALUE) (or 5 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/__listOfOutput (s/coll-of :cognitect.aws.medialive/Output))

(s/def
  :cognitect.aws.medialive/InputType
  #{"MP4_FILE" "RTMP_PULL" "UDP_PUSH" "URL_PULL" "RTP_PUSH" "RTMP_PUSH"})

(s/def
  :cognitect.aws.medialive/__integerMin1000
  (s/with-gen
    (s/and int? #(<= 1000 %))
    #(gen/choose (or 1000 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/StaticImageDeactivateScheduleActionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StaticImageDeactivateScheduleActionSettings/Layer
     :cognitect.aws.medialive.StaticImageDeactivateScheduleActionSettings/FadeOut]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max1000000
  (s/with-gen
    (s/and int? #(<= 1 % 1000000))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 1000000 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/H264GopSizeUnits #{"SECONDS" "FRAMES"})

(s/def
  :cognitect.aws.medialive/Scte35WebDeliveryAllowedFlag
  #{"WEB_DELIVERY_ALLOWED" "WEB_DELIVERY_NOT_ALLOWED"})

(s/def
  :cognitect.aws.medialive/ListChannelsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListChannelsResponse/NextToken
     :cognitect.aws.medialive.ListChannelsResponse/Channels]))

(s/def
  :cognitect.aws.medialive/__listOfScheduleAction
  (s/coll-of :cognitect.aws.medialive/ScheduleAction))

(s/def
  :cognitect.aws.medialive/DescribeReservationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeReservationResponse/DurationUnits
     :cognitect.aws.medialive.DescribeReservationResponse/CurrencyCode
     :cognitect.aws.medialive.DescribeReservationResponse/OfferingDescription
     :cognitect.aws.medialive.DescribeReservationResponse/ResourceSpecification
     :cognitect.aws.medialive.DescribeReservationResponse/Start
     :cognitect.aws.medialive.DescribeReservationResponse/FixedPrice
     :cognitect.aws.medialive.DescribeReservationResponse/End
     :cognitect.aws.medialive.DescribeReservationResponse/Count
     :cognitect.aws.medialive.DescribeReservationResponse/OfferingId
     :cognitect.aws.medialive.DescribeReservationResponse/Duration
     :cognitect.aws.medialive.DescribeReservationResponse/UsagePrice
     :cognitect.aws.medialive.DescribeReservationResponse/Arn
     :cognitect.aws.medialive.DescribeReservationResponse/State
     :cognitect.aws.medialive.DescribeReservationResponse/OfferingType
     :cognitect.aws.medialive.DescribeReservationResponse/Name
     :cognitect.aws.medialive.DescribeReservationResponse/ReservationId
     :cognitect.aws.medialive.DescribeReservationResponse/Region]))

(s/def :cognitect.aws.medialive/FollowPoint #{"END" "START"})

(s/def :cognitect.aws.medialive/Scte35SpliceInsertNoRegionalBlackoutBehavior #{"FOLLOW" "IGNORE"})

(s/def
  :cognitect.aws.medialive/__stringMax32
  (s/with-gen
    (s/and string? #(>= 32 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or nil 0) (or 32 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive/M2tsEsRateInPes #{"INCLUDE" "EXCLUDE"})

(s/def :cognitect.aws.medialive/WebvttDestinationSettings (s/keys))

(s/def :cognitect.aws.medialive/InputCodec #{"HEVC" "MPEG2" "AVC"})

(s/def
  :cognitect.aws.medialive/__listOfCaptionDescription
  (s/coll-of :cognitect.aws.medialive/CaptionDescription))

(s/def
  :cognitect.aws.medialive/__integerMin1
  (s/with-gen (s/and int? #(<= 1 %)) #(gen/choose (or 1 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/ReservationResourceType #{"OUTPUT" "CHANNEL" "INPUT"})

(s/def :cognitect.aws.medialive/Eac3PhaseControl #{"SHIFT_90_DEGREES" "NO_SHIFT"})

(s/def
  :cognitect.aws.medialive/ReservationMaximumBitrate
  #{"MAX_10_MBPS" "MAX_50_MBPS" "MAX_20_MBPS"})

(s/def
  :cognitect.aws.medialive/DescribeInputResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeInputResponse/Type
     :cognitect.aws.medialive.DescribeInputResponse/SecurityGroups
     :cognitect.aws.medialive.DescribeInputResponse/Arn
     :cognitect.aws.medialive.DescribeInputResponse/State
     :cognitect.aws.medialive.DescribeInputResponse/Destinations
     :cognitect.aws.medialive.DescribeInputResponse/Name
     :cognitect.aws.medialive.DescribeInputResponse/Sources
     :cognitect.aws.medialive.DescribeInputResponse/AttachedChannels
     :cognitect.aws.medialive.DescribeInputResponse/Id]))

(s/def
  :cognitect.aws.medialive/__listOfInputChannelLevel
  (s/coll-of :cognitect.aws.medialive/InputChannelLevel))

(s/def
  :cognitect.aws.medialive/__listOfOutputGroup
  (s/coll-of :cognitect.aws.medialive/OutputGroup))

(s/def :cognitect.aws.medialive/Scte35ArchiveAllowedFlag #{"ARCHIVE_ALLOWED" "ARCHIVE_NOT_ALLOWED"})

(s/def :cognitect.aws.medialive/InputLossActionForUdpOut #{"DROP_TS" "EMIT_PROGRAM" "DROP_PROGRAM"})

(s/def
  :cognitect.aws.medialive/H264Profile
  #{"HIGH_422" "BASELINE" "MAIN" "HIGH_10BIT" "HIGH" "HIGH_422_10BIT"})

(s/def
  :cognitect.aws.medialive/__listOfInputSource
  (s/coll-of :cognitect.aws.medialive/InputSource))

(s/def :cognitect.aws.medialive/OfferingDurationUnits #{"MONTHS"})

(s/def
  :cognitect.aws.medialive/Scte20SourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Scte20SourceSettings/Source608ChannelNumber
     :cognitect.aws.medialive.Scte20SourceSettings/Convert608To708]))

(s/def
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint
  (s/coll-of :cognitect.aws.medialive/ChannelEgressEndpoint))

(s/def
  :cognitect.aws.medialive/CreateInputSecurityGroupRequest
  (s/keys :opt-un [:cognitect.aws.medialive.CreateInputSecurityGroupRequest/WhitelistRules]))

(s/def
  :cognitect.aws.medialive/CaptionDescription
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CaptionDescription/CaptionSelectorName
     :cognitect.aws.medialive.CaptionDescription/Name]
    :opt-un
    [:cognitect.aws.medialive.CaptionDescription/DestinationSettings
     :cognitect.aws.medialive.CaptionDescription/LanguageCode
     :cognitect.aws.medialive.CaptionDescription/LanguageDescription]))

(s/def
  :cognitect.aws.medialive/StandardHlsSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StandardHlsSettings/M3u8Settings]
    :opt-un
    [:cognitect.aws.medialive.StandardHlsSettings/AudioRenditionSets]))

(s/def
  :cognitect.aws.medialive/Scte27SourceSettings
  (s/keys :opt-un [:cognitect.aws.medialive.Scte27SourceSettings/Pid]))

(s/def
  :cognitect.aws.medialive/VideoSelectorProgramId
  (s/keys :opt-un [:cognitect.aws.medialive.VideoSelectorProgramId/ProgramId]))

(s/def :cognitect.aws.medialive/Eac3LfeFilter #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max7
  (s/with-gen (s/and int? #(<= 0 % 7)) #(gen/choose (or 0 Long/MIN_VALUE) (or 7 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/CaptionSelector
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CaptionSelector/Name]
    :opt-un
    [:cognitect.aws.medialive.CaptionSelector/SelectorSettings
     :cognitect.aws.medialive.CaptionSelector/LanguageCode]))

(s/def
  :cognitect.aws.medialive/HlsWebdavSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsWebdavSettings/HttpTransferMode
     :cognitect.aws.medialive.HlsWebdavSettings/NumRetries
     :cognitect.aws.medialive.HlsWebdavSettings/FilecacheDuration
     :cognitect.aws.medialive.HlsWebdavSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.HlsWebdavSettings/RestartDelay]))

(s/def
  :cognitect.aws.medialive/StopChannelRequest
  (s/keys :req-un [:cognitect.aws.medialive.StopChannelRequest/ChannelId]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max1099511627775
  (s/with-gen
    (s/and int? #(<= 0 % 1099511627775))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 1099511627775 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/AudioOnlyHlsTrackType
  #{"ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT" "ALTERNATE_AUDIO_AUTO_SELECT"
    "ALTERNATE_AUDIO_NOT_AUTO_SELECT" "AUDIO_ONLY_VARIANT_STREAM"})

(s/def
  :cognitect.aws.medialive/TeletextSourceSettings
  (s/keys :opt-un [:cognitect.aws.medialive.TeletextSourceSettings/PageNumber]))

(s/def :cognitect.aws.medialive/AudioNormalizationAlgorithm #{"ITU_1770_1" "ITU_1770_2"})

(s/def :cognitect.aws.medialive/M2tsKlv #{"PASSTHROUGH" "NONE"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max8191
  (s/with-gen
    (s/and int? #(<= 0 % 8191))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 8191 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/InputLossActionForMsSmoothOut #{"PAUSE_OUTPUT" "EMIT_OUTPUT"})

(s/def
  :cognitect.aws.medialive/Scte35SegmentationCancelIndicator
  #{"SEGMENTATION_EVENT_NOT_CANCELED" "SEGMENTATION_EVENT_CANCELED"})

(s/def
  :cognitect.aws.medialive/RemixSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.RemixSettings/ChannelMappings]
    :opt-un
    [:cognitect.aws.medialive.RemixSettings/ChannelsOut
     :cognitect.aws.medialive.RemixSettings/ChannelsIn]))

(s/def :cognitect.aws.medialive/Scte35AposNoRegionalBlackoutBehavior #{"FOLLOW" "IGNORE"})

(s/def
  :cognitect.aws.medialive/StaticImageActivateScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Image]
    :opt-un
    [:cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Opacity
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/ImageX
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Width
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Layer
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Duration
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/FadeIn
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Height
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/ImageY
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/FadeOut]))

(s/def :cognitect.aws.medialive/__string string?)

(s/def
  :cognitect.aws.medialive/FollowModeScheduleActionStartSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.FollowModeScheduleActionStartSettings/ReferenceActionName
     :cognitect.aws.medialive.FollowModeScheduleActionStartSettings/FollowPoint]))

(s/def :cognitect.aws.medialive/InputState #{"ATTACHED" "DELETING" "CREATING" "DETACHED" "DELETED"})

(s/def
  :cognitect.aws.medialive/H264AdaptiveQuantization
  #{"LOW" "MAX" "HIGHER" "HIGH" "OFF" "MEDIUM"})

(s/def :cognitect.aws.medialive/HlsCodecSpecification #{"RFC_4281" "RFC_6381"})

(s/def
  :cognitect.aws.medialive/ListOfferingsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListOfferingsResponse/Offerings
     :cognitect.aws.medialive.ListOfferingsResponse/NextToken]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max1000000
  (s/with-gen
    (s/and int? #(<= 0 % 1000000))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 1000000 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/AudioNormalizationAlgorithmControl #{"CORRECT_AUDIO"})

(s/def :cognitect.aws.medialive/M2tsEbpPlacement #{"VIDEO_AND_AUDIO_PIDS" "VIDEO_PID"})

(s/def
  :cognitect.aws.medialive/AudioPidSelection
  (s/keys :req-un [:cognitect.aws.medialive.AudioPidSelection/Pid]))

(s/def
  :cognitect.aws.medialive/HlsCdnSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsCdnSettings/HlsBasicPutSettings
     :cognitect.aws.medialive.HlsCdnSettings/HlsWebdavSettings
     :cognitect.aws.medialive.HlsCdnSettings/HlsMediaStoreSettings
     :cognitect.aws.medialive.HlsCdnSettings/HlsAkamaiSettings]))

(s/def
  :cognitect.aws.medialive/InputAttachment
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputAttachment/InputId
     :cognitect.aws.medialive.InputAttachment/InputSettings
     :cognitect.aws.medialive.InputAttachment/InputAttachmentName]))

(s/def
  :cognitect.aws.medialive/Reservation
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Reservation/DurationUnits
     :cognitect.aws.medialive.Reservation/CurrencyCode
     :cognitect.aws.medialive.Reservation/OfferingDescription
     :cognitect.aws.medialive.Reservation/ResourceSpecification
     :cognitect.aws.medialive.Reservation/Start
     :cognitect.aws.medialive.Reservation/FixedPrice
     :cognitect.aws.medialive.Reservation/End
     :cognitect.aws.medialive.Reservation/Count
     :cognitect.aws.medialive.Reservation/OfferingId
     :cognitect.aws.medialive.Reservation/Duration
     :cognitect.aws.medialive.Reservation/UsagePrice
     :cognitect.aws.medialive.Reservation/Arn
     :cognitect.aws.medialive.Reservation/State
     :cognitect.aws.medialive.Reservation/OfferingType
     :cognitect.aws.medialive.Reservation/Name
     :cognitect.aws.medialive.Reservation/ReservationId
     :cognitect.aws.medialive.Reservation/Region]))

(s/def
  :cognitect.aws.medialive/VideoSelectorPid
  (s/keys :opt-un [:cognitect.aws.medialive.VideoSelectorPid/Pid]))

(s/def
  :cognitect.aws.medialive/SmoothGroupEventIdMode
  #{"USE_CONFIGURED" "NO_EVENT_ID" "USE_TIMESTAMP"})

(s/def
  :cognitect.aws.medialive/FixedModeScheduleActionStartSettings
  (s/keys :req-un [:cognitect.aws.medialive.FixedModeScheduleActionStartSettings/Time]))

(s/def
  :cognitect.aws.medialive/HlsBasicPutSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsBasicPutSettings/NumRetries
     :cognitect.aws.medialive.HlsBasicPutSettings/FilecacheDuration
     :cognitect.aws.medialive.HlsBasicPutSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.HlsBasicPutSettings/RestartDelay]))

(s/def
  :cognitect.aws.medialive/BatchScheduleActionCreateRequest
  (s/keys :req-un [:cognitect.aws.medialive.BatchScheduleActionCreateRequest/ScheduleActions]))

(s/def
  :cognitect.aws.medialive/M2tsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.M2tsSettings/PatInterval
     :cognitect.aws.medialive.M2tsSettings/BufferModel
     :cognitect.aws.medialive.M2tsSettings/DvbTdtSettings
     :cognitect.aws.medialive.M2tsSettings/AudioFramesPerPes
     :cognitect.aws.medialive.M2tsSettings/FragmentTime
     :cognitect.aws.medialive.M2tsSettings/TransportStreamId
     :cognitect.aws.medialive.M2tsSettings/TimedMetadataBehavior
     :cognitect.aws.medialive.M2tsSettings/DvbSdtSettings
     :cognitect.aws.medialive.M2tsSettings/AbsentInputAudioBehavior
     :cognitect.aws.medialive.M2tsSettings/PcrControl
     :cognitect.aws.medialive.M2tsSettings/Scte35Pid
     :cognitect.aws.medialive.M2tsSettings/PcrPid
     :cognitect.aws.medialive.M2tsSettings/PmtPid
     :cognitect.aws.medialive.M2tsSettings/VideoPid
     :cognitect.aws.medialive.M2tsSettings/RateMode
     :cognitect.aws.medialive.M2tsSettings/AudioPids
     :cognitect.aws.medialive.M2tsSettings/EtvPlatformPid
     :cognitect.aws.medialive.M2tsSettings/EbpLookaheadMs
     :cognitect.aws.medialive.M2tsSettings/Arib
     :cognitect.aws.medialive.M2tsSettings/Ebif
     :cognitect.aws.medialive.M2tsSettings/PcrPeriod
     :cognitect.aws.medialive.M2tsSettings/CcDescriptor
     :cognitect.aws.medialive.M2tsSettings/EtvSignalPid
     :cognitect.aws.medialive.M2tsSettings/PmtInterval
     :cognitect.aws.medialive.M2tsSettings/SegmentationStyle
     :cognitect.aws.medialive.M2tsSettings/NullPacketBitrate
     :cognitect.aws.medialive.M2tsSettings/SegmentationMarkers
     :cognitect.aws.medialive.M2tsSettings/EbpPlacement
     :cognitect.aws.medialive.M2tsSettings/Scte35Control
     :cognitect.aws.medialive.M2tsSettings/AudioBufferModel
     :cognitect.aws.medialive.M2tsSettings/EsRateInPes
     :cognitect.aws.medialive.M2tsSettings/Klv
     :cognitect.aws.medialive.M2tsSettings/ProgramNum
     :cognitect.aws.medialive.M2tsSettings/TimedMetadataPid
     :cognitect.aws.medialive.M2tsSettings/AudioStreamType
     :cognitect.aws.medialive.M2tsSettings/Scte27Pids
     :cognitect.aws.medialive.M2tsSettings/AribCaptionsPidControl
     :cognitect.aws.medialive.M2tsSettings/KlvDataPids
     :cognitect.aws.medialive.M2tsSettings/DvbSubPids
     :cognitect.aws.medialive.M2tsSettings/EbpAudioInterval
     :cognitect.aws.medialive.M2tsSettings/EcmPid
     :cognitect.aws.medialive.M2tsSettings/DvbNitSettings
     :cognitect.aws.medialive.M2tsSettings/DvbTeletextPid
     :cognitect.aws.medialive.M2tsSettings/AribCaptionsPid
     :cognitect.aws.medialive.M2tsSettings/Bitrate
     :cognitect.aws.medialive.M2tsSettings/SegmentationTime]))

(s/def :cognitect.aws.medialive/H264TemporalAq #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/__listOfInputSourceRequest
  (s/coll-of :cognitect.aws.medialive/InputSourceRequest))

(s/def :cognitect.aws.medialive/DvbSubDestinationBackgroundColor #{"NONE" "WHITE" "BLACK"})

(s/def
  :cognitect.aws.medialive/__stringMin3Max3
  (s/with-gen
    (s/and string? #(<= 3 (count %) 3))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 3 0) (or 3 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive/InputMaximumBitrate #{"MAX_10_MBPS" "MAX_50_MBPS" "MAX_20_MBPS"})

(s/def
  :cognitect.aws.medialive/ChannelState
  #{"IDLE" "CREATE_FAILED" "STARTING" "DELETING" "CREATING" "DELETED" "RECOVERING" "STOPPING"
    "RUNNING"})

(s/def :cognitect.aws.medialive/BlackoutSlateState #{"DISABLED" "ENABLED"})

(s/def :cognitect.aws.medialive/Eac3SurroundExMode #{"DISABLED" "NOT_INDICATED" "ENABLED"})

(s/def :cognitect.aws.medialive/M3u8PcrControl #{"CONFIGURED_PCR_PERIOD" "PCR_EVERY_PES_PACKET"})

(s/def
  :cognitect.aws.medialive/BatchScheduleActionDeleteResult
  (s/keys :req-un [:cognitect.aws.medialive.BatchScheduleActionDeleteResult/ScheduleActions]))

(s/def
  :cognitect.aws.medialive/__listOfInputWhitelistRule
  (s/coll-of :cognitect.aws.medialive/InputWhitelistRule))

(s/def
  :cognitect.aws.medialive/StartChannelRequest
  (s/keys :req-un [:cognitect.aws.medialive.StartChannelRequest/ChannelId]))

(s/def
  :cognitect.aws.medialive/UpdateInputSecurityGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateInputSecurityGroupRequest/InputSecurityGroupId]
    :opt-un
    [:cognitect.aws.medialive.UpdateInputSecurityGroupRequest/WhitelistRules]))

(s/def :cognitect.aws.medialive/M2tsAudioBufferModel #{"DVB" "ATSC"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max600
  (s/with-gen
    (s/and int? #(<= 0 % 600))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 600 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/__integerMin0
  (s/with-gen (s/and int? #(<= 0 %)) #(gen/choose (or 0 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/__listOfInputDestination
  (s/coll-of :cognitect.aws.medialive/InputDestination))

(s/def :cognitect.aws.medialive/H264SpatialAq #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/ScheduleActionStartSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ScheduleActionStartSettings/FixedModeScheduleActionStartSettings
     :cognitect.aws.medialive.ScheduleActionStartSettings/FollowModeScheduleActionStartSettings]))

(s/def
  :cognitect.aws.medialive/OutputGroup
  (s/keys
    :req-un
    [:cognitect.aws.medialive.OutputGroup/Outputs
     :cognitect.aws.medialive.OutputGroup/OutputGroupSettings]
    :opt-un
    [:cognitect.aws.medialive.OutputGroup/Name]))

(s/def :cognitect.aws.medialive/AacProfile #{"LC" "HEV2" "HEV1"})

(s/def
  :cognitect.aws.medialive/ScheduleActionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ScheduleActionSettings/Scte35SpliceInsertSettings
     :cognitect.aws.medialive.ScheduleActionSettings/Scte35TimeSignalSettings
     :cognitect.aws.medialive.ScheduleActionSettings/InputSwitchSettings
     :cognitect.aws.medialive.ScheduleActionSettings/Scte35ReturnToNetworkSettings
     :cognitect.aws.medialive.ScheduleActionSettings/StaticImageActivateSettings
     :cognitect.aws.medialive.ScheduleActionSettings/StaticImageDeactivateSettings]))

(s/def
  :cognitect.aws.medialive/EmbeddedSourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.EmbeddedSourceSettings/Source608ChannelNumber
     :cognitect.aws.medialive.EmbeddedSourceSettings/Convert608To708
     :cognitect.aws.medialive.EmbeddedSourceSettings/Scte20Detection
     :cognitect.aws.medialive.EmbeddedSourceSettings/Source608TrackNumber]))

(s/def
  :cognitect.aws.medialive/InputSourceRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSourceRequest/Username
     :cognitect.aws.medialive.InputSourceRequest/Url
     :cognitect.aws.medialive.InputSourceRequest/PasswordParam]))

(s/def
  :cognitect.aws.medialive/Output
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Output/OutputSettings]
    :opt-un
    [:cognitect.aws.medialive.Output/VideoDescriptionName
     :cognitect.aws.medialive.Output/AudioDescriptionNames
     :cognitect.aws.medialive.Output/CaptionDescriptionNames
     :cognitect.aws.medialive.Output/OutputName]))

(s/def
  :cognitect.aws.medialive/KeyProviderSettings
  (s/keys :opt-un [:cognitect.aws.medialive.KeyProviderSettings/StaticKeySettings]))

(s/def
  :cognitect.aws.medialive/__stringMin1Max255
  (s/with-gen
    (s/and string? #(<= 1 (count %) 255))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 255 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/__listOfHlsAdMarkers
  (s/coll-of :cognitect.aws.medialive/HlsAdMarkers))

(s/def
  :cognitect.aws.medialive/Mp2Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Mp2Settings/CodingMode
     :cognitect.aws.medialive.Mp2Settings/SampleRate
     :cognitect.aws.medialive.Mp2Settings/Bitrate]))

(s/def :cognitect.aws.medialive/PassThroughSettings (s/keys))

(s/def
  :cognitect.aws.medialive/DescribeInputSecurityGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DescribeInputSecurityGroupRequest/InputSecurityGroupId]))

(s/def
  :cognitect.aws.medialive/ChannelEgressEndpoint
  (s/keys :opt-un [:cognitect.aws.medialive.ChannelEgressEndpoint/SourceIp]))

(s/def
  :cognitect.aws.medialive/ListReservationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListReservationsRequest/Codec
     :cognitect.aws.medialive.ListReservationsRequest/Resolution
     :cognitect.aws.medialive.ListReservationsRequest/NextToken
     :cognitect.aws.medialive.ListReservationsRequest/MaximumBitrate
     :cognitect.aws.medialive.ListReservationsRequest/ResourceType
     :cognitect.aws.medialive.ListReservationsRequest/MaxResults
     :cognitect.aws.medialive.ListReservationsRequest/VideoQuality
     :cognitect.aws.medialive.ListReservationsRequest/SpecialFeature
     :cognitect.aws.medialive.ListReservationsRequest/MaximumFramerate]))

(s/def :cognitect.aws.medialive/AuthenticationScheme #{"AKAMAI" "COMMON"})

(s/def :cognitect.aws.medialive/RtmpCaptionData #{"FIELD1_608" "FIELD1_AND_FIELD2_608" "ALL"})

(s/def :cognitect.aws.medialive/DeleteInputSecurityGroupResponse (s/keys))

(s/def :cognitect.aws.medialive/AacSpec #{"MPEG4" "MPEG2"})

(s/def
  :cognitect.aws.medialive/InputDestination
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDestination/Url
     :cognitect.aws.medialive.InputDestination/Port
     :cognitect.aws.medialive.InputDestination/Ip]))

(s/def
  :cognitect.aws.medialive/BatchScheduleActionCreateResult
  (s/keys :req-un [:cognitect.aws.medialive.BatchScheduleActionCreateResult/ScheduleActions]))

(s/def
  :cognitect.aws.medialive/UpdateInputRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateInputRequest/InputId]
    :opt-un
    [:cognitect.aws.medialive.UpdateInputRequest/InputSecurityGroups
     :cognitect.aws.medialive.UpdateInputRequest/Destinations
     :cognitect.aws.medialive.UpdateInputRequest/Name
     :cognitect.aws.medialive.UpdateInputRequest/Sources]))

(s/def
  :cognitect.aws.medialive/UpdateChannelResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateChannelResponse/Channel]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max20
  (s/with-gen (s/and int? #(<= 1 % 20)) #(gen/choose (or 1 Long/MIN_VALUE) (or 20 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/__integerMin0Max100
  (s/with-gen
    (s/and int? #(<= 0 % 100))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 100 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/BatchUpdateScheduleRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.BatchUpdateScheduleRequest/ChannelId]
    :opt-un
    [:cognitect.aws.medialive.BatchUpdateScheduleRequest/Creates
     :cognitect.aws.medialive.BatchUpdateScheduleRequest/Deletes]))

(s/def
  :cognitect.aws.medialive/DeleteChannelRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteChannelRequest/ChannelId]))

(s/def
  :cognitect.aws.medialive/ArchiveOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ArchiveOutputSettings/ContainerSettings]
    :opt-un
    [:cognitect.aws.medialive.ArchiveOutputSettings/NameModifier
     :cognitect.aws.medialive.ArchiveOutputSettings/Extension]))

(s/def
  :cognitect.aws.medialive/MsSmoothGroupSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MsSmoothGroupSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.MsSmoothGroupSettings/FragmentLength
     :cognitect.aws.medialive.MsSmoothGroupSettings/InputLossAction
     :cognitect.aws.medialive.MsSmoothGroupSettings/EventStopBehavior
     :cognitect.aws.medialive.MsSmoothGroupSettings/AcquisitionPointId
     :cognitect.aws.medialive.MsSmoothGroupSettings/StreamManifestBehavior
     :cognitect.aws.medialive.MsSmoothGroupSettings/NumRetries
     :cognitect.aws.medialive.MsSmoothGroupSettings/FilecacheDuration
     :cognitect.aws.medialive.MsSmoothGroupSettings/SparseTrackType
     :cognitect.aws.medialive.MsSmoothGroupSettings/CertificateMode
     :cognitect.aws.medialive.MsSmoothGroupSettings/SendDelayMs
     :cognitect.aws.medialive.MsSmoothGroupSettings/EventIdMode
     :cognitect.aws.medialive.MsSmoothGroupSettings/SegmentationMode
     :cognitect.aws.medialive.MsSmoothGroupSettings/AudioOnlyTimecodeControl
     :cognitect.aws.medialive.MsSmoothGroupSettings/TimestampOffset
     :cognitect.aws.medialive.MsSmoothGroupSettings/EventId
     :cognitect.aws.medialive.MsSmoothGroupSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.MsSmoothGroupSettings/TimestampOffsetMode
     :cognitect.aws.medialive.MsSmoothGroupSettings/RestartDelay]))

(s/def :cognitect.aws.medialive/SmoothGroupStreamManifestBehavior #{"SEND" "DO_NOT_SEND"})

(s/def :cognitect.aws.medialive/UdpTimedMetadataId3Frame #{"TDRL" "NONE" "PRIV"})

(s/def
  :cognitect.aws.medialive/UpdateInputSecurityGroupResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateInputSecurityGroupResponse/SecurityGroup]))

(s/def
  :cognitect.aws.medialive/SmoothGroupAudioOnlyTimecodeControl
  #{"PASSTHROUGH" "USE_CONFIGURED_CLOCK"})

(s/def :cognitect.aws.medialive/InputLossActionForRtmpOut #{"PAUSE_OUTPUT" "EMIT_OUTPUT"})

(s/def :cognitect.aws.medialive/Eac3StereoDownmix #{"NOT_INDICATED" "LO_RO" "LT_RT" "DPL2"})

(s/def :cognitect.aws.medialive/DvbSubDestinationTeletextGridControl #{"FIXED" "SCALED"})

(s/def :cognitect.aws.medialive/AudioLanguageSelectionPolicy #{"LOOSE" "STRICT"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max255
  (s/with-gen
    (s/and int? #(<= 0 % 255))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 255 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/AvailSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AvailSettings/Scte35TimeSignalApos
     :cognitect.aws.medialive.AvailSettings/Scte35SpliceInsert]))

(s/def :cognitect.aws.medialive/Scte20PlusEmbeddedDestinationSettings (s/keys))

(s/def :cognitect.aws.medialive/DvbSubDestinationShadowColor #{"NONE" "WHITE" "BLACK"})

(s/def :cognitect.aws.medialive/Mp2CodingMode #{"CODING_MODE_1_0" "CODING_MODE_2_0"})

(s/def :cognitect.aws.medialive/Eac3DcFilter #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/StaticKeySettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StaticKeySettings/StaticKeyValue]
    :opt-un
    [:cognitect.aws.medialive.StaticKeySettings/KeyProviderServer]))

(s/def :cognitect.aws.medialive/DeleteInputResponse (s/keys))

(s/def :cognitect.aws.medialive/Eac3MetadataControl #{"FOLLOW_INPUT" "USE_CONFIGURED"})

(s/def :cognitect.aws.medialive/M2tsEbifControl #{"PASSTHROUGH" "NONE"})

(s/def
  :cognitect.aws.medialive/SmoothGroupSegmentationMode
  #{"USE_INPUT_SEGMENTATION" "USE_SEGMENT_DURATION"})

(s/def :cognitect.aws.medialive/H264FlickerAq #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/DvbTdtSettings
  (s/keys :opt-un [:cognitect.aws.medialive.DvbTdtSettings/RepInterval]))

(s/def
  :cognitect.aws.medialive/__integerMin30
  (s/with-gen (s/and int? #(<= 30 %)) #(gen/choose (or 30 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/__listOfAudioChannelMapping
  (s/coll-of :cognitect.aws.medialive/AudioChannelMapping))

(s/def
  :cognitect.aws.medialive/ListChannelsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListChannelsRequest/NextToken
     :cognitect.aws.medialive.ListChannelsRequest/MaxResults]))

(s/def :cognitect.aws.medialive/M3u8Scte35Behavior #{"PASSTHROUGH" "NO_PASSTHROUGH"})

(s/def
  :cognitect.aws.medialive/DeleteInputRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteInputRequest/InputId]))

(s/def
  :cognitect.aws.medialive/ListOfferingsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListOfferingsRequest/Codec
     :cognitect.aws.medialive.ListOfferingsRequest/Resolution
     :cognitect.aws.medialive.ListOfferingsRequest/NextToken
     :cognitect.aws.medialive.ListOfferingsRequest/MaximumBitrate
     :cognitect.aws.medialive.ListOfferingsRequest/ResourceType
     :cognitect.aws.medialive.ListOfferingsRequest/MaxResults
     :cognitect.aws.medialive.ListOfferingsRequest/VideoQuality
     :cognitect.aws.medialive.ListOfferingsRequest/ChannelConfiguration
     :cognitect.aws.medialive.ListOfferingsRequest/SpecialFeature
     :cognitect.aws.medialive.ListOfferingsRequest/MaximumFramerate]))

(s/def
  :cognitect.aws.medialive/ScheduleAction
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ScheduleAction/ActionName
     :cognitect.aws.medialive.ScheduleAction/ScheduleActionStartSettings
     :cognitect.aws.medialive.ScheduleAction/ScheduleActionSettings]))

(s/def
  :cognitect.aws.medialive/__integerMin25Max10000
  (s/with-gen
    (s/and int? #(<= 25 % 10000))
    #(gen/choose (or 25 Long/MIN_VALUE) (or 10000 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/__listOfOffering (s/coll-of :cognitect.aws.medialive/Offering))

(s/def
  :cognitect.aws.medialive/InputDestinationRequest
  (s/keys :opt-un [:cognitect.aws.medialive.InputDestinationRequest/StreamName]))

(s/def
  :cognitect.aws.medialive/HlsOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.HlsOutputSettings/HlsSettings]
    :opt-un
    [:cognitect.aws.medialive.HlsOutputSettings/SegmentModifier
     :cognitect.aws.medialive.HlsOutputSettings/NameModifier]))

(s/def
  :cognitect.aws.medialive/GlobalConfigurationInputEndAction
  #{"SWITCH_AND_LOOP_INPUTS" "NONE"})

(s/def :cognitect.aws.medialive/ReservationResolution #{"UHD" "SD" "HD"})

(s/def :cognitect.aws.medialive/M2tsArib #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/ListInputsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputsResponse/NextToken
     :cognitect.aws.medialive.ListInputsResponse/Inputs]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max31
  (s/with-gen (s/and int? #(<= 1 % 31)) #(gen/choose (or 1 Long/MIN_VALUE) (or 31 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/M3u8TimedMetadataBehavior #{"PASSTHROUGH" "NO_PASSTHROUGH"})

(s/def
  :cognitect.aws.medialive/__listOfScte35Descriptor
  (s/coll-of :cognitect.aws.medialive/Scte35Descriptor))

(s/def :cognitect.aws.medialive/InputDenoiseFilter #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/DvbSubSourceSettings
  (s/keys :opt-un [:cognitect.aws.medialive.DvbSubSourceSettings/Pid]))

(s/def
  :cognitect.aws.medialive/__integerMin96Max600
  (s/with-gen
    (s/and int? #(<= 96 % 600))
    #(gen/choose (or 96 Long/MIN_VALUE) (or 600 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/TtmlDestinationStyleControl #{"USE_CONFIGURED" "PASSTHROUGH"})

(s/def
  :cognitect.aws.medialive/MaxResults
  (s/with-gen
    (s/and int? #(<= 1 % 1000))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 1000 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/H264GopBReference #{"DISABLED" "ENABLED"})

(s/def :cognitect.aws.medialive/VideoDescriptionScalingBehavior #{"STRETCH_TO_OUTPUT" "DEFAULT"})

(s/def :cognitect.aws.medialive/InputLossImageType #{"SLATE" "COLOR"})

(s/def
  :cognitect.aws.medialive/CreateInputSecurityGroupResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreateInputSecurityGroupResponse/SecurityGroup]))

(s/def
  :cognitect.aws.medialive/__listOfChannelSummary
  (s/coll-of :cognitect.aws.medialive/ChannelSummary))

(s/def
  :cognitect.aws.medialive/DescribeScheduleRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DescribeScheduleRequest/ChannelId]
    :opt-un
    [:cognitect.aws.medialive.DescribeScheduleRequest/NextToken
     :cognitect.aws.medialive.DescribeScheduleRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/DeleteReservationRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteReservationRequest/ReservationId]))

(s/def :cognitect.aws.medialive/InputSourceEndBehavior #{"CONTINUE" "LOOP"})

(s/def :cognitect.aws.medialive/HlsAdMarkers #{"ELEMENTAL" "ADOBE" "ELEMENTAL_SCTE35"})

(s/def
  :cognitect.aws.medialive/UdpOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UdpOutputSettings/Destination
     :cognitect.aws.medialive.UdpOutputSettings/ContainerSettings]
    :opt-un
    [:cognitect.aws.medialive.UdpOutputSettings/FecOutputSettings
     :cognitect.aws.medialive.UdpOutputSettings/BufferMsec]))

(s/def :cognitect.aws.medialive/H264ParControl #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})

(s/def
  :cognitect.aws.medialive/CaptionDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CaptionDestinationSettings/TtmlDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/BurnInDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/Scte27DestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/AribDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/RtmpCaptionInfoDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/WebvttDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/TeletextDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/SmpteTtDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/DvbSubDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/EmbeddedDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/EmbeddedPlusScte20DestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/Scte20PlusEmbeddedDestinationSettings]))

(s/def
  :cognitect.aws.medialive/UdpGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UdpGroupSettings/InputLossAction
     :cognitect.aws.medialive.UdpGroupSettings/TimedMetadataId3Frame
     :cognitect.aws.medialive.UdpGroupSettings/TimedMetadataId3Period]))

(s/def :cognitect.aws.medialive/Eac3LfeControl #{"NO_LFE" "LFE"})

(s/def
  :cognitect.aws.medialive/CreateChannelRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateChannelRequest/Reserved
     :cognitect.aws.medialive.CreateChannelRequest/InputAttachments
     :cognitect.aws.medialive.CreateChannelRequest/RequestId
     :cognitect.aws.medialive.CreateChannelRequest/LogLevel
     :cognitect.aws.medialive.CreateChannelRequest/RoleArn
     :cognitect.aws.medialive.CreateChannelRequest/EncoderSettings
     :cognitect.aws.medialive.CreateChannelRequest/InputSpecification
     :cognitect.aws.medialive.CreateChannelRequest/Destinations
     :cognitect.aws.medialive.CreateChannelRequest/Name]))

(s/def :cognitect.aws.medialive/Scte35AposWebDeliveryAllowedBehavior #{"FOLLOW" "IGNORE"})

(s/def :cognitect.aws.medialive/HlsRedundantManifest #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/__integerMin25Max2000
  (s/with-gen
    (s/and int? #(<= 25 % 2000))
    #(gen/choose (or 25 Long/MIN_VALUE) (or 2000 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/HlsWebdavHttpTransferMode #{"NON_CHUNKED" "CHUNKED"})

(s/def
  :cognitect.aws.medialive/Ac3BitstreamMode
  #{"COMPLETE_MAIN" "DIALOGUE" "VISUALLY_IMPAIRED" "EMERGENCY" "COMMENTARY" "MUSIC_AND_EFFECTS"
    "VOICE_OVER" "HEARING_IMPAIRED"})

(s/def
  :cognitect.aws.medialive/InputWhitelistRuleCidr
  (s/keys :opt-un [:cognitect.aws.medialive.InputWhitelistRuleCidr/Cidr]))

(s/def :cognitect.aws.medialive/InputFilter #{"DISABLED" "AUTO" "FORCED"})

(s/def
  :cognitect.aws.medialive/CaptionSelectorSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CaptionSelectorSettings/Scte20SourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/DvbSubSourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/TeletextSourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/Scte27SourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/EmbeddedSourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/AribSourceSettings]))

(s/def
  :cognitect.aws.medialive/DescribeScheduleResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeScheduleResponse/NextToken
     :cognitect.aws.medialive.DescribeScheduleResponse/ScheduleActions]))

(s/def
  :cognitect.aws.medialive/M2tsSegmentationMarkers
  #{"PSI_SEGSTART" "RAI_SEGSTART" "RAI_ADAPT" "NONE" "EBP_LEGACY" "EBP"})

(s/def
  :cognitect.aws.medialive/DescribeReservationRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeReservationRequest/ReservationId]))

(s/def
  :cognitect.aws.medialive/__integerMinNegative60Max60
  (s/with-gen
    (s/and int? #(<= -60 % 60))
    #(gen/choose (or -60 Long/MIN_VALUE) (or 60 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/SmoothGroupCertificateMode #{"VERIFY_AUTHENTICITY" "SELF_SIGNED"})

(s/def
  :cognitect.aws.medialive/OutputLocationRef
  (s/keys :opt-un [:cognitect.aws.medialive.OutputLocationRef/DestinationRefId]))

(s/def :cognitect.aws.medialive/M2tsCcDescriptor #{"DISABLED" "ENABLED"})

(s/def :cognitect.aws.medialive/SmoothGroupEventStopBehavior #{"SEND_EOS" "NONE"})

(s/def
  :cognitect.aws.medialive/TtmlDestinationSettings
  (s/keys :opt-un [:cognitect.aws.medialive.TtmlDestinationSettings/StyleControl]))

(s/def
  :cognitect.aws.medialive/Scte35DescriptorSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35DescriptorSettings/SegmentationDescriptorScte35DescriptorSettings]))

(s/def :cognitect.aws.medialive/HlsMode #{"VOD" "LIVE"})

(s/def
  :cognitect.aws.medialive/H264Level
  #{"H264_LEVEL_4_2" "H264_LEVEL_2_2" "H264_LEVEL_2" "H264_LEVEL_1_1" "H264_LEVEL_5"
    "H264_LEVEL_1_3" "H264_LEVEL_3" "H264_LEVEL_2_1" "H264_LEVEL_1_2" "H264_LEVEL_1"
    "H264_LEVEL_3_2" "H264_LEVEL_4" "H264_LEVEL_5_1" "H264_LEVEL_3_1" "H264_LEVEL_AUTO"
    "H264_LEVEL_5_2" "H264_LEVEL_4_1"})

(s/def :cognitect.aws.medialive/HlsOutputSelection #{"MANIFESTS_AND_SEGMENTS" "SEGMENTS_ONLY"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max10000
  (s/with-gen
    (s/and int? #(<= 0 % 10000))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 10000 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/InputSwitchScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.InputSwitchScheduleActionSettings/InputAttachmentNameReference]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max10
  (s/with-gen (s/and int? #(<= 0 % 10)) #(gen/choose (or 0 Long/MIN_VALUE) (or 10 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/__integerMin0Max15
  (s/with-gen (s/and int? #(<= 0 % 15)) #(gen/choose (or 0 Long/MIN_VALUE) (or 15 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/EmbeddedPlusScte20DestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/Offering
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Offering/DurationUnits
     :cognitect.aws.medialive.Offering/CurrencyCode
     :cognitect.aws.medialive.Offering/OfferingDescription
     :cognitect.aws.medialive.Offering/ResourceSpecification
     :cognitect.aws.medialive.Offering/FixedPrice
     :cognitect.aws.medialive.Offering/OfferingId
     :cognitect.aws.medialive.Offering/Duration
     :cognitect.aws.medialive.Offering/UsagePrice
     :cognitect.aws.medialive.Offering/Arn
     :cognitect.aws.medialive.Offering/OfferingType
     :cognitect.aws.medialive.Offering/Region]))

(s/def :cognitect.aws.medialive/Scte27DestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/__integerMin0Max65535
  (s/with-gen
    (s/and int? #(<= 0 % 65535))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 65535 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/VideoSelectorSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.VideoSelectorSettings/VideoSelectorProgramId
     :cognitect.aws.medialive.VideoSelectorSettings/VideoSelectorPid]))

(s/def
  :cognitect.aws.medialive/DescribeInputRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeInputRequest/InputId]))

(s/def :cognitect.aws.medialive/InputLossActionForHlsOut #{"PAUSE_OUTPUT" "EMIT_OUTPUT"})

(s/def :cognitect.aws.medialive/M2tsRateMode #{"VBR" "CBR"})

(s/def
  :cognitect.aws.medialive/HlsSegmentationMode
  #{"USE_INPUT_SEGMENTATION" "USE_SEGMENT_DURATION"})

(s/def :cognitect.aws.medialive/BurnInBackgroundColor #{"NONE" "WHITE" "BLACK"})

(s/def
  :cognitect.aws.medialive/AudioNormalizationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AudioNormalizationSettings/TargetLkfs
     :cognitect.aws.medialive.AudioNormalizationSettings/AlgorithmControl
     :cognitect.aws.medialive.AudioNormalizationSettings/Algorithm]))

(s/def :cognitect.aws.medialive/VideoDescriptionRespondToAfd #{"PASSTHROUGH" "NONE" "RESPOND"})

(s/def :cognitect.aws.medialive/ReservationCodec #{"HEVC" "MPEG2" "AUDIO" "AVC"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max128
  (s/with-gen
    (s/and int? #(<= 0 % 128))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 128 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/RtmpGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.RtmpGroupSettings/InputLossAction
     :cognitect.aws.medialive.RtmpGroupSettings/CacheLength
     :cognitect.aws.medialive.RtmpGroupSettings/AuthenticationScheme
     :cognitect.aws.medialive.RtmpGroupSettings/CacheFullBehavior
     :cognitect.aws.medialive.RtmpGroupSettings/CaptionData
     :cognitect.aws.medialive.RtmpGroupSettings/RestartDelay]))

(s/def
  :cognitect.aws.medialive/RtmpOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.RtmpOutputSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.RtmpOutputSettings/NumRetries
     :cognitect.aws.medialive.RtmpOutputSettings/CertificateMode
     :cognitect.aws.medialive.RtmpOutputSettings/ConnectionRetryInterval]))

(s/def
  :cognitect.aws.medialive/UpdateChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateChannelRequest/ChannelId]
    :opt-un
    [:cognitect.aws.medialive.UpdateChannelRequest/InputAttachments
     :cognitect.aws.medialive.UpdateChannelRequest/LogLevel
     :cognitect.aws.medialive.UpdateChannelRequest/RoleArn
     :cognitect.aws.medialive.UpdateChannelRequest/EncoderSettings
     :cognitect.aws.medialive.UpdateChannelRequest/InputSpecification
     :cognitect.aws.medialive.UpdateChannelRequest/Destinations
     :cognitect.aws.medialive.UpdateChannelRequest/Name]))

(s/def :cognitect.aws.medialive/RtmpOutputCertificateMode #{"VERIFY_AUTHENTICITY" "SELF_SIGNED"})

(s/def
  :cognitect.aws.medialive/__integerMin1000Max30000
  (s/with-gen
    (s/and int? #(<= 1000 % 30000))
    #(gen/choose (or 1000 Long/MIN_VALUE) (or 30000 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/DescribeOfferingRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeOfferingRequest/OfferingId]))

(s/def
  :cognitect.aws.medialive/AvailConfiguration
  (s/keys :opt-un [:cognitect.aws.medialive.AvailConfiguration/AvailSettings]))

(s/def
  :cognitect.aws.medialive/AudioDescriptionLanguageCodeControl
  #{"FOLLOW_INPUT" "USE_CONFIGURED"})

(s/def
  :cognitect.aws.medialive/ListInputsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputsRequest/NextToken
     :cognitect.aws.medialive.ListInputsRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/Scte35ReturnToNetworkScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35ReturnToNetworkScheduleActionSettings/SpliceEventId]))

(s/def
  :cognitect.aws.medialive/BatchUpdateScheduleResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchUpdateScheduleResponse/Creates
     :cognitect.aws.medialive.BatchUpdateScheduleResponse/Deletes]))

(s/def
  :cognitect.aws.medialive/__listOfInputSecurityGroup
  (s/coll-of :cognitect.aws.medialive/InputSecurityGroup))

(s/def :cognitect.aws.medialive/H264TimecodeInsertionBehavior #{"DISABLED" "PIC_TIMING_SEI"})

(s/def :cognitect.aws.medialive/RtmpCacheFullBehavior #{"WAIT_FOR_SERVER" "DISCONNECT_IMMEDIATELY"})

(s/def
  :cognitect.aws.medialive/NetworkInputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.NetworkInputSettings/HlsInputSettings
     :cognitect.aws.medialive.NetworkInputSettings/ServerValidation]))

(s/def
  :cognitect.aws.medialive/AudioChannelMapping
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioChannelMapping/OutputChannel
     :cognitect.aws.medialive.AudioChannelMapping/InputChannelLevels]))

(s/def
  :cognitect.aws.medialive/__doubleMin0
  (s/with-gen double? #(gen/double* {:infinite? false, :NaN? false})))

(s/def :cognitect.aws.medialive/OfferingType #{"NO_UPFRONT"})

(s/def
  :cognitect.aws.medialive/DescribeChannelRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeChannelRequest/ChannelId]))

(s/def :cognitect.aws.medialive/H264SceneChangeDetect #{"DISABLED" "ENABLED"})

(s/def
  :cognitect.aws.medialive/Eac3BitstreamMode
  #{"COMPLETE_MAIN" "VISUALLY_IMPAIRED" "EMERGENCY" "COMMENTARY" "HEARING_IMPAIRED"})

(s/def
  :cognitect.aws.medialive/__integer
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/AfdSignaling #{"AUTO" "FIXED" "NONE"})

(s/def :cognitect.aws.medialive/__listOf__string (s/coll-of :cognitect.aws.medialive/__string))

(s/def :cognitect.aws.medialive/BurnInAlignment #{"LEFT" "CENTERED" "SMART"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max8589934591
  (s/with-gen
    (s/and int? #(<= 0 % 8589934591))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 8589934591 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/__integerMin1Max6
  (s/with-gen (s/and int? #(<= 1 % 6)) #(gen/choose (or 1 Long/MIN_VALUE) (or 6 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive/Eac3AttenuationControl #{"ATTENUATE_3_DB" "NONE"})

(s/def
  :cognitect.aws.medialive/InputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSettings/InputFilter
     :cognitect.aws.medialive.InputSettings/DenoiseFilter
     :cognitect.aws.medialive.InputSettings/SourceEndBehavior
     :cognitect.aws.medialive.InputSettings/FilterStrength
     :cognitect.aws.medialive.InputSettings/CaptionSelectors
     :cognitect.aws.medialive.InputSettings/VideoSelector
     :cognitect.aws.medialive.InputSettings/NetworkInputSettings
     :cognitect.aws.medialive.InputSettings/AudioSelectors
     :cognitect.aws.medialive.InputSettings/DeblockFilter]))

(s/def :cognitect.aws.medialive/InputSecurityGroupState #{"IDLE" "IN_USE" "UPDATING" "DELETED"})

(s/def
  :cognitect.aws.medialive/HlsMediaStoreSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsMediaStoreSettings/NumRetries
     :cognitect.aws.medialive.HlsMediaStoreSettings/FilecacheDuration
     :cognitect.aws.medialive.HlsMediaStoreSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.HlsMediaStoreSettings/MediaStoreStorageClass
     :cognitect.aws.medialive.HlsMediaStoreSettings/RestartDelay]))

(s/def :cognitect.aws.medialive/HlsManifestCompression #{"GZIP" "NONE"})

(s/def
  :cognitect.aws.medialive/Ac3Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Ac3Settings/CodingMode
     :cognitect.aws.medialive.Ac3Settings/LfeFilter
     :cognitect.aws.medialive.Ac3Settings/DrcProfile
     :cognitect.aws.medialive.Ac3Settings/MetadataControl
     :cognitect.aws.medialive.Ac3Settings/BitstreamMode
     :cognitect.aws.medialive.Ac3Settings/Dialnorm
     :cognitect.aws.medialive.Ac3Settings/Bitrate]))

(s/def
  :cognitect.aws.medialive/InputWhitelistRule
  (s/keys :opt-un [:cognitect.aws.medialive.InputWhitelistRule/Cidr]))

(s/def
  :cognitect.aws.medialive/FecOutputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.FecOutputSettings/IncludeFec
     :cognitect.aws.medialive.FecOutputSettings/ColumnDepth
     :cognitect.aws.medialive.FecOutputSettings/RowLength]))

(s/def
  :cognitect.aws.medialive/__listOfAudioSelector
  (s/coll-of :cognitect.aws.medialive/AudioSelector))

(s/def
  :cognitect.aws.medialive/DvbNitSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DvbNitSettings/NetworkName
     :cognitect.aws.medialive.DvbNitSettings/NetworkId]
    :opt-un
    [:cognitect.aws.medialive.DvbNitSettings/RepInterval]))

(s/def :cognitect.aws.medialive/H264ColorMetadata #{"INSERT" "IGNORE"})

(s/def
  :cognitect.aws.medialive/StopChannelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StopChannelResponse/InputAttachments
     :cognitect.aws.medialive.StopChannelResponse/PipelinesRunningCount
     :cognitect.aws.medialive.StopChannelResponse/LogLevel
     :cognitect.aws.medialive.StopChannelResponse/RoleArn
     :cognitect.aws.medialive.StopChannelResponse/EgressEndpoints
     :cognitect.aws.medialive.StopChannelResponse/EncoderSettings
     :cognitect.aws.medialive.StopChannelResponse/Arn
     :cognitect.aws.medialive.StopChannelResponse/InputSpecification
     :cognitect.aws.medialive.StopChannelResponse/State
     :cognitect.aws.medialive.StopChannelResponse/Destinations
     :cognitect.aws.medialive.StopChannelResponse/Name
     :cognitect.aws.medialive.StopChannelResponse/Id]))

(s/def
  :cognitect.aws.medialive/DeleteInputSecurityGroupRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteInputSecurityGroupRequest/InputSecurityGroupId]))

(s/def
  :cognitect.aws.medialive/AudioLanguageSelection
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioLanguageSelection/LanguageCode]
    :opt-un
    [:cognitect.aws.medialive.AudioLanguageSelection/LanguageSelectionPolicy]))

(s/def :cognitect.aws.medialive/BurnInTeletextGridControl #{"FIXED" "SCALED"})

(s/def
  :cognitect.aws.medialive/CreateInputResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreateInputResponse/Input]))

(s/def :cognitect.aws.medialive/AacVbrQuality #{"LOW" "MEDIUM_LOW" "HIGH" "MEDIUM_HIGH"})

(s/def
  :cognitect.aws.medialive/__listOfOutputDestination
  (s/coll-of :cognitect.aws.medialive/OutputDestination))

(s/def
  :cognitect.aws.medialive/DvbSdtOutputSdt
  #{"SDT_MANUAL" "SDT_NONE" "SDT_FOLLOW_IF_PRESENT" "SDT_FOLLOW"})

(s/def
  :cognitect.aws.medialive/TimecodeConfig
  (s/keys
    :req-un
    [:cognitect.aws.medialive.TimecodeConfig/Source]
    :opt-un
    [:cognitect.aws.medialive.TimecodeConfig/SyncThreshold]))

(s/def
  :cognitect.aws.medialive/HlsAkamaiSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsAkamaiSettings/HttpTransferMode
     :cognitect.aws.medialive.HlsAkamaiSettings/NumRetries
     :cognitect.aws.medialive.HlsAkamaiSettings/FilecacheDuration
     :cognitect.aws.medialive.HlsAkamaiSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.HlsAkamaiSettings/Token
     :cognitect.aws.medialive.HlsAkamaiSettings/RestartDelay
     :cognitect.aws.medialive.HlsAkamaiSettings/Salt]))

(s/def
  :cognitect.aws.medialive/OutputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.OutputSettings/ArchiveOutputSettings
     :cognitect.aws.medialive.OutputSettings/UdpOutputSettings
     :cognitect.aws.medialive.OutputSettings/RtmpOutputSettings
     :cognitect.aws.medialive.OutputSettings/MsSmoothOutputSettings
     :cognitect.aws.medialive.OutputSettings/HlsOutputSettings]))

(s/def
  :cognitect.aws.medialive/GlobalConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.GlobalConfiguration/InitialAudioGain
     :cognitect.aws.medialive.GlobalConfiguration/InputLossBehavior
     :cognitect.aws.medialive.GlobalConfiguration/InputEndAction
     :cognitect.aws.medialive.GlobalConfiguration/SupportLowFramerateInputs
     :cognitect.aws.medialive.GlobalConfiguration/OutputTimingSource]))

(s/def :cognitect.aws.medialive/EmbeddedConvert608To708 #{"DISABLED" "UPCONVERT"})

(s/def
  :cognitect.aws.medialive/__integerMin0Max1000
  (s/with-gen
    (s/and int? #(<= 0 % 1000))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 1000 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.medialive/AudioCodecSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AudioCodecSettings/Eac3Settings
     :cognitect.aws.medialive.AudioCodecSettings/Mp2Settings
     :cognitect.aws.medialive.AudioCodecSettings/PassThroughSettings
     :cognitect.aws.medialive.AudioCodecSettings/Ac3Settings
     :cognitect.aws.medialive.AudioCodecSettings/AacSettings]))

(s/def
  :cognitect.aws.medialive/HlsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsSettings/AudioOnlyHlsSettings
     :cognitect.aws.medialive.HlsSettings/StandardHlsSettings]))

(s/def :cognitect.aws.medialive/M2tsAbsentInputAudioBehavior #{"ENCODE_SILENCE" "DROP"})

(s/def :cognitect.aws.medialive/RtmpCaptionInfoDestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/DescribeChannelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeChannelResponse/InputAttachments
     :cognitect.aws.medialive.DescribeChannelResponse/PipelinesRunningCount
     :cognitect.aws.medialive.DescribeChannelResponse/LogLevel
     :cognitect.aws.medialive.DescribeChannelResponse/RoleArn
     :cognitect.aws.medialive.DescribeChannelResponse/EgressEndpoints
     :cognitect.aws.medialive.DescribeChannelResponse/EncoderSettings
     :cognitect.aws.medialive.DescribeChannelResponse/Arn
     :cognitect.aws.medialive.DescribeChannelResponse/InputSpecification
     :cognitect.aws.medialive.DescribeChannelResponse/State
     :cognitect.aws.medialive.DescribeChannelResponse/Destinations
     :cognitect.aws.medialive.DescribeChannelResponse/Name
     :cognitect.aws.medialive.DescribeChannelResponse/Id]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max16
  (s/with-gen (s/and int? #(<= 1 % 16)) #(gen/choose (or 1 Long/MIN_VALUE) (or 16 Long/MAX_VALUE))))

(s/def :cognitect.aws.medialive.DvbSdtSettings/OutputSdt :cognitect.aws.medialive/DvbSdtOutputSdt)

(s/def
  :cognitect.aws.medialive.DvbSdtSettings/RepInterval
  :cognitect.aws.medialive/__integerMin25Max2000)

(s/def
  :cognitect.aws.medialive.DvbSdtSettings/ServiceName
  :cognitect.aws.medialive/__stringMin1Max256)

(s/def
  :cognitect.aws.medialive.DvbSdtSettings/ServiceProviderName
  :cognitect.aws.medialive/__stringMin1Max256)

(s/def
  :cognitect.aws.medialive.AudioDescription/AudioTypeControl
  :cognitect.aws.medialive/AudioDescriptionAudioTypeControl)

(s/def
  :cognitect.aws.medialive.AudioDescription/LanguageCodeControl
  :cognitect.aws.medialive/AudioDescriptionLanguageCodeControl)

(s/def :cognitect.aws.medialive.AudioDescription/AudioType :cognitect.aws.medialive/AudioType)

(s/def :cognitect.aws.medialive.AudioDescription/StreamName :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioDescription/RemixSettings
  :cognitect.aws.medialive/RemixSettings)

(s/def
  :cognitect.aws.medialive.AudioDescription/CodecSettings
  :cognitect.aws.medialive/AudioCodecSettings)

(s/def :cognitect.aws.medialive.AudioDescription/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioDescription/AudioSelectorName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioDescription/AudioNormalizationSettings
  :cognitect.aws.medialive/AudioNormalizationSettings)

(s/def
  :cognitect.aws.medialive.AudioDescription/LanguageCode
  :cognitect.aws.medialive/__stringMin3Max3)

(s/def :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioGroupId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioOnlyImage
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioTrackType
  :cognitect.aws.medialive/AudioOnlyHlsTrackType)

(s/def :cognitect.aws.medialive.AudioSelector/Name :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.AudioSelector/SelectorSettings
  :cognitect.aws.medialive/AudioSelectorSettings)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Arn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Id
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Inputs
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/State
  :cognitect.aws.medialive/InputSecurityGroupState)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/WhitelistRules
  :cognitect.aws.medialive/__listOfInputWhitelistRule)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsert/AdAvailOffset
  :cognitect.aws.medialive/__integerMinNegative1000Max1000)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsert/NoRegionalBlackoutFlag
  :cognitect.aws.medialive/Scte35SpliceInsertNoRegionalBlackoutBehavior)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsert/WebDeliveryAllowedFlag
  :cognitect.aws.medialive/Scte35SpliceInsertWebDeliveryAllowedBehavior)

(s/def
  :cognitect.aws.medialive.AvailBlanking/AvailBlankingImage
  :cognitect.aws.medialive/InputLocation)

(s/def :cognitect.aws.medialive.AvailBlanking/State :cognitect.aws.medialive/AvailBlankingState)

(s/def
  :cognitect.aws.medialive.ListReservationsResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsResponse/Reservations
  :cognitect.aws.medialive/__listOfReservation)

(s/def
  :cognitect.aws.medialive.InputChannelLevel/Gain
  :cognitect.aws.medialive/__integerMinNegative60Max6)

(s/def
  :cognitect.aws.medialive.InputChannelLevel/InputChannel
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/ArchiveGroupSettings
  :cognitect.aws.medialive/ArchiveGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/HlsGroupSettings
  :cognitect.aws.medialive/HlsGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/MsSmoothGroupSettings
  :cognitect.aws.medialive/MsSmoothGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/RtmpGroupSettings
  :cognitect.aws.medialive/RtmpGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/UdpGroupSettings
  :cognitect.aws.medialive/UdpGroupSettings)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsRequest/NextToken
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSecurityGroup/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSecurityGroup/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSecurityGroup/Inputs :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.InputSecurityGroup/State
  :cognitect.aws.medialive/InputSecurityGroupState)

(s/def
  :cognitect.aws.medialive.InputSecurityGroup/WhitelistRules
  :cognitect.aws.medialive/__listOfInputWhitelistRule)

(s/def :cognitect.aws.medialive.HlsInputSettings/Bandwidth :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsInputSettings/BufferSegments
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.HlsInputSettings/Retries :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsInputSettings/RetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.Scte35TimeSignalApos/AdAvailOffset
  :cognitect.aws.medialive/__integerMinNegative1000Max1000)

(s/def
  :cognitect.aws.medialive.Scte35TimeSignalApos/NoRegionalBlackoutFlag
  :cognitect.aws.medialive/Scte35AposNoRegionalBlackoutBehavior)

(s/def
  :cognitect.aws.medialive.Scte35TimeSignalApos/WebDeliveryAllowedFlag
  :cognitect.aws.medialive/Scte35AposWebDeliveryAllowedBehavior)

(s/def
  :cognitect.aws.medialive.VideoDescription/CodecSettings
  :cognitect.aws.medialive/VideoCodecSettings)

(s/def :cognitect.aws.medialive.VideoDescription/Height :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.VideoDescription/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.VideoDescription/RespondToAfd
  :cognitect.aws.medialive/VideoDescriptionRespondToAfd)

(s/def
  :cognitect.aws.medialive.VideoDescription/ScalingBehavior
  :cognitect.aws.medialive/VideoDescriptionScalingBehavior)

(s/def
  :cognitect.aws.medialive.VideoDescription/Sharpness
  :cognitect.aws.medialive/__integerMin0Max100)

(s/def :cognitect.aws.medialive.VideoDescription/Width :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.ChannelSummary/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def :cognitect.aws.medialive.ChannelSummary/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ChannelSummary/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.ChannelSummary/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.ChannelSummary/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.ChannelSummary/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ChannelSummary/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.ChannelSummary/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ChannelSummary/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ChannelSummary/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.ChannelSummary/State :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsResponse/InputSecurityGroups
  :cognitect.aws.medialive/__listOfInputSecurityGroup)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/DeliveryRestrictions
  :cognitect.aws.medialive/Scte35DeliveryRestrictions)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SubSegmentNum
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationCancelIndicator
  :cognitect.aws.medialive/Scte35SegmentationCancelIndicator)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SubSegmentsExpected
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationEventId
  :cognitect.aws.medialive/__integerMin0Max4294967295)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationUpidType
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationUpid
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationDuration
  :cognitect.aws.medialive/__integerMin0Max1099511627775)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentsExpected
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentNum
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationTypeId
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/State :cognitect.aws.medialive/ChannelState)

(s/def :cognitect.aws.medialive.CreateChannelResponse/Channel :cognitect.aws.medialive/Channel)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/Codec
  :cognitect.aws.medialive/ReservationCodec)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/MaximumBitrate
  :cognitect.aws.medialive/ReservationMaximumBitrate)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/MaximumFramerate
  :cognitect.aws.medialive/ReservationMaximumFramerate)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/Resolution
  :cognitect.aws.medialive/ReservationResolution)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/ResourceType
  :cognitect.aws.medialive/ReservationResourceType)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/SpecialFeature
  :cognitect.aws.medialive/ReservationSpecialFeature)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/VideoQuality
  :cognitect.aws.medialive/ReservationVideoQuality)

(s/def
  :cognitect.aws.medialive.CaptionLanguageMapping/CaptionChannel
  :cognitect.aws.medialive/__integerMin1Max4)

(s/def
  :cognitect.aws.medialive.CaptionLanguageMapping/LanguageCode
  :cognitect.aws.medialive/__stringMin3Max3)

(s/def
  :cognitect.aws.medialive.CaptionLanguageMapping/LanguageDescription
  :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.OutputDestinationSettings/PasswordParam
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputDestinationSettings/StreamName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.OutputDestinationSettings/Url :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputDestinationSettings/Username
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35TimeSignalScheduleActionSettings/Scte35Descriptors
  :cognitect.aws.medialive/__listOfScte35Descriptor)

(s/def :cognitect.aws.medialive.OutputDestination/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputDestination/Settings
  :cognitect.aws.medialive/__listOfOutputDestinationSettings)

(s/def
  :cognitect.aws.medialive.BlackoutSlate/BlackoutSlateImage
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.BlackoutSlate/NetworkEndBlackout
  :cognitect.aws.medialive/BlackoutSlateNetworkEndBlackout)

(s/def
  :cognitect.aws.medialive.BlackoutSlate/NetworkEndBlackoutImage
  :cognitect.aws.medialive/InputLocation)

(s/def :cognitect.aws.medialive.BlackoutSlate/NetworkId :cognitect.aws.medialive/__stringMin34Max34)

(s/def :cognitect.aws.medialive.BlackoutSlate/State :cognitect.aws.medialive/BlackoutSlateState)

(s/def
  :cognitect.aws.medialive.ArchiveContainerSettings/M2tsSettings
  :cognitect.aws.medialive/M2tsSettings)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsertScheduleActionSettings/Duration
  :cognitect.aws.medialive/__integerMin0Max8589934591)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsertScheduleActionSettings/SpliceEventId
  :cognitect.aws.medialive/__integerMin0Max4294967295)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/IndexNSegments
  :cognitect.aws.medialive/__integerMin3)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ManifestDurationFormat
  :cognitect.aws.medialive/HlsManifestDurationFormat)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/CodecSpecification
  :cognitect.aws.medialive/HlsCodecSpecification)

(s/def :cognitect.aws.medialive.HlsGroupSettings/BaseUrlContent :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTime
  :cognitect.aws.medialive/HlsProgramDateTime)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/AdMarkers
  :cognitect.aws.medialive/__listOfHlsAdMarkers)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/StreamInfResolution
  :cognitect.aws.medialive/HlsStreamInfResolution)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def :cognitect.aws.medialive.HlsGroupSettings/Mode :cognitect.aws.medialive/HlsMode)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/IvInManifest
  :cognitect.aws.medialive/HlsIvInManifest)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ConstantIv
  :cognitect.aws.medialive/__stringMin32Max32)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/SegmentLength
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/TimedMetadataId3Period
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/EncryptionType
  :cognitect.aws.medialive/HlsEncryptionType)

(s/def :cognitect.aws.medialive.HlsGroupSettings/BaseUrlManifest :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.HlsGroupSettings/IvSource :cognitect.aws.medialive/HlsIvSource)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/RedundantManifest
  :cognitect.aws.medialive/HlsRedundantManifest)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/HlsCdnSettings
  :cognitect.aws.medialive/HlsCdnSettings)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/TimedMetadataId3Frame
  :cognitect.aws.medialive/HlsTimedMetadataId3Frame)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTimePeriod
  :cognitect.aws.medialive/__integerMin0Max3600)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/KeyProviderSettings
  :cognitect.aws.medialive/KeyProviderSettings)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/KeepSegments
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/CaptionLanguageSetting
  :cognitect.aws.medialive/HlsCaptionLanguageSetting)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ClientCache
  :cognitect.aws.medialive/HlsClientCache)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/MinSegmentLength
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/SegmentationMode
  :cognitect.aws.medialive/HlsSegmentationMode)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/KeyFormatVersions
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/CaptionLanguageMappings
  :cognitect.aws.medialive/__listOfCaptionLanguageMapping)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/SegmentsPerSubdirectory
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ManifestCompression
  :cognitect.aws.medialive/HlsManifestCompression)

(s/def :cognitect.aws.medialive.HlsGroupSettings/TsFileMode :cognitect.aws.medialive/HlsTsFileMode)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/TimestampDeltaMilliseconds
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.HlsGroupSettings/KeyFormat :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/DirectoryStructure
  :cognitect.aws.medialive/HlsDirectoryStructure)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/OutputSelection
  :cognitect.aws.medialive/HlsOutputSelection)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/InputLossAction
  :cognitect.aws.medialive/InputLossActionForHlsOut)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/BlackFrameMsec
  :cognitect.aws.medialive/__integerMin0Max1000000)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/InputLossImageColor
  :cognitect.aws.medialive/__stringMin6Max6)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/InputLossImageSlate
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/InputLossImageType
  :cognitect.aws.medialive/InputLossImageType)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/RepeatFrameMsec
  :cognitect.aws.medialive/__integerMin0Max1000000)

(s/def
  :cognitect.aws.medialive.Scte35DeliveryRestrictions/ArchiveAllowedFlag
  :cognitect.aws.medialive/Scte35ArchiveAllowedFlag)

(s/def
  :cognitect.aws.medialive.Scte35DeliveryRestrictions/DeviceRestrictions
  :cognitect.aws.medialive/Scte35DeviceRestrictions)

(s/def
  :cognitect.aws.medialive.Scte35DeliveryRestrictions/NoRegionalBlackoutFlag
  :cognitect.aws.medialive/Scte35NoRegionalBlackoutFlag)

(s/def
  :cognitect.aws.medialive.Scte35DeliveryRestrictions/WebDeliveryAllowedFlag
  :cognitect.aws.medialive/Scte35WebDeliveryAllowedFlag)

(s/def
  :cognitect.aws.medialive.PurchaseOfferingRequest/Count
  :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.PurchaseOfferingRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.PurchaseOfferingRequest/OfferingId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.PurchaseOfferingRequest/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.PurchaseOfferingRequest/Start :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowYOffset
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/BackgroundOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/Font
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/OutlineColor
  :cognitect.aws.medialive/DvbSubDestinationOutlineColor)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowXOffset
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/FontSize
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/FontOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/Alignment
  :cognitect.aws.medialive/DvbSubDestinationAlignment)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/FontColor
  :cognitect.aws.medialive/DvbSubDestinationFontColor)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/YPosition
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowColor
  :cognitect.aws.medialive/DvbSubDestinationShadowColor)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/FontResolution
  :cognitect.aws.medialive/__integerMin96Max600)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/BackgroundColor
  :cognitect.aws.medialive/DvbSubDestinationBackgroundColor)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/TeletextGridControl
  :cognitect.aws.medialive/DvbSubDestinationTeletextGridControl)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/XPosition
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/OutlineSize
  :cognitect.aws.medialive/__integerMin0Max10)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/CurrencyCode
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/FixedPrice
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def :cognitect.aws.medialive.DescribeOfferingResponse/Region :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/OfferingDescription
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeOfferingResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/Duration
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/UsagePrice
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/OfferingId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/OfferingType
  :cognitect.aws.medialive/OfferingType)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/ShadowYOffset
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/BackgroundOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/Font
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/OutlineColor
  :cognitect.aws.medialive/BurnInOutlineColor)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/ShadowXOffset
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/FontSize
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/FontOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/Alignment
  :cognitect.aws.medialive/BurnInAlignment)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/FontColor
  :cognitect.aws.medialive/BurnInFontColor)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/YPosition
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/ShadowColor
  :cognitect.aws.medialive/BurnInShadowColor)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/FontResolution
  :cognitect.aws.medialive/__integerMin96Max600)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/BackgroundColor
  :cognitect.aws.medialive/BurnInBackgroundColor)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/TeletextGridControl
  :cognitect.aws.medialive/BurnInTeletextGridControl)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/ShadowOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/XPosition
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/OutlineSize
  :cognitect.aws.medialive/__integerMin0Max10)

(s/def
  :cognitect.aws.medialive.MsSmoothOutputSettings/NameModifier
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateInputResponse/Input :cognitect.aws.medialive/Input)

(s/def
  :cognitect.aws.medialive.VideoSelector/ColorSpace
  :cognitect.aws.medialive/VideoSelectorColorSpace)

(s/def
  :cognitect.aws.medialive.VideoSelector/ColorSpaceUsage
  :cognitect.aws.medialive/VideoSelectorColorSpaceUsage)

(s/def
  :cognitect.aws.medialive.VideoSelector/SelectorSettings
  :cognitect.aws.medialive/VideoSelectorSettings)

(s/def
  :cognitect.aws.medialive.EncoderSettings/AvailBlanking
  :cognitect.aws.medialive/AvailBlanking)

(s/def
  :cognitect.aws.medialive.EncoderSettings/VideoDescriptions
  :cognitect.aws.medialive/__listOfVideoDescription)

(s/def
  :cognitect.aws.medialive.EncoderSettings/BlackoutSlate
  :cognitect.aws.medialive/BlackoutSlate)

(s/def
  :cognitect.aws.medialive.EncoderSettings/CaptionDescriptions
  :cognitect.aws.medialive/__listOfCaptionDescription)

(s/def
  :cognitect.aws.medialive.EncoderSettings/OutputGroups
  :cognitect.aws.medialive/__listOfOutputGroup)

(s/def
  :cognitect.aws.medialive.EncoderSettings/AudioDescriptions
  :cognitect.aws.medialive/__listOfAudioDescription)

(s/def
  :cognitect.aws.medialive.EncoderSettings/AvailConfiguration
  :cognitect.aws.medialive/AvailConfiguration)

(s/def
  :cognitect.aws.medialive.EncoderSettings/TimecodeConfig
  :cognitect.aws.medialive/TimecodeConfig)

(s/def
  :cognitect.aws.medialive.EncoderSettings/GlobalConfiguration
  :cognitect.aws.medialive/GlobalConfiguration)

(s/def
  :cognitect.aws.medialive.PurchaseOfferingResponse/Reservation
  :cognitect.aws.medialive/Reservation)

(s/def :cognitect.aws.medialive.InputSource/PasswordParam :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSource/Url :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSource/Username :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35Descriptor/Scte35DescriptorSettings
  :cognitect.aws.medialive/Scte35DescriptorSettings)

(s/def
  :cognitect.aws.medialive.ArchiveGroupSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.ArchiveGroupSettings/RolloverInterval
  :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.Input/Sources :cognitect.aws.medialive/__listOfInputSource)

(s/def :cognitect.aws.medialive.Input/AttachedChannels :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.Input/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Input/Destinations
  :cognitect.aws.medialive/__listOfInputDestination)

(s/def :cognitect.aws.medialive.Input/SecurityGroups :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.Input/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Input/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Input/Type :cognitect.aws.medialive/InputType)

(s/def :cognitect.aws.medialive.Input/State :cognitect.aws.medialive/InputState)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/CurrencyCode
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/FixedPrice
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/ReservationId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Region :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/OfferingDescription
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/Duration
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/UsagePrice
  :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/End :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/State
  :cognitect.aws.medialive/ReservationState)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Count :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/OfferingId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Start :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/OfferingType
  :cognitect.aws.medialive/OfferingType)

(s/def :cognitect.aws.medialive.AacSettings/Spec :cognitect.aws.medialive/AacSpec)

(s/def :cognitect.aws.medialive.AacSettings/CodingMode :cognitect.aws.medialive/AacCodingMode)

(s/def :cognitect.aws.medialive.AacSettings/Profile :cognitect.aws.medialive/AacProfile)

(s/def :cognitect.aws.medialive.AacSettings/RawFormat :cognitect.aws.medialive/AacRawFormat)

(s/def :cognitect.aws.medialive.AacSettings/InputType :cognitect.aws.medialive/AacInputType)

(s/def
  :cognitect.aws.medialive.AacSettings/RateControlMode
  :cognitect.aws.medialive/AacRateControlMode)

(s/def :cognitect.aws.medialive.AacSettings/Bitrate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.AacSettings/VbrQuality :cognitect.aws.medialive/AacVbrQuality)

(s/def :cognitect.aws.medialive.AacSettings/SampleRate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.StartChannelResponse/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.StartChannelResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.StartChannelResponse/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.StartChannelResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StartChannelResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.StartChannelResponse/State :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.UdpContainerSettings/M2tsSettings
  :cognitect.aws.medialive/M2tsSettings)

(s/def :cognitect.aws.medialive.InputSpecification/Codec :cognitect.aws.medialive/InputCodec)

(s/def
  :cognitect.aws.medialive.InputSpecification/MaximumBitrate
  :cognitect.aws.medialive/InputMaximumBitrate)

(s/def
  :cognitect.aws.medialive.InputSpecification/Resolution
  :cognitect.aws.medialive/InputResolution)

(s/def
  :cognitect.aws.medialive.BatchScheduleActionDeleteRequest/ActionNames
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/Destinations
  :cognitect.aws.medialive/__listOfInputDestinationRequest)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/InputSecurityGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.CreateInputRequest/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateInputRequest/RequestId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/Sources
  :cognitect.aws.medialive/__listOfInputSourceRequest)

(s/def :cognitect.aws.medialive.CreateInputRequest/Type :cognitect.aws.medialive/InputType)

(s/def :cognitect.aws.medialive.Channel/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def :cognitect.aws.medialive.Channel/EncoderSettings :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.Channel/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Channel/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.Channel/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.Channel/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.Channel/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Channel/PipelinesRunningCount :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.Channel/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Channel/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Channel/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.Channel/State :cognitect.aws.medialive/ChannelState)

(s/def :cognitect.aws.medialive.H264Settings/GopSize :cognitect.aws.medialive/__doubleMin1)

(s/def
  :cognitect.aws.medialive.H264Settings/EntropyEncoding
  :cognitect.aws.medialive/H264EntropyEncoding)

(s/def
  :cognitect.aws.medialive.H264Settings/NumRefFrames
  :cognitect.aws.medialive/__integerMin1Max6)

(s/def
  :cognitect.aws.medialive.H264Settings/GopNumBFrames
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def
  :cognitect.aws.medialive.H264Settings/AdaptiveQuantization
  :cognitect.aws.medialive/H264AdaptiveQuantization)

(s/def :cognitect.aws.medialive.H264Settings/ParNumerator :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.H264Settings/Softness :cognitect.aws.medialive/__integerMin0Max128)

(s/def :cognitect.aws.medialive.H264Settings/Profile :cognitect.aws.medialive/H264Profile)

(s/def :cognitect.aws.medialive.H264Settings/ParDenominator :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.H264Settings/SceneChangeDetect
  :cognitect.aws.medialive/H264SceneChangeDetect)

(s/def :cognitect.aws.medialive.H264Settings/SpatialAq :cognitect.aws.medialive/H264SpatialAq)

(s/def :cognitect.aws.medialive.H264Settings/FlickerAq :cognitect.aws.medialive/H264FlickerAq)

(s/def :cognitect.aws.medialive.H264Settings/FixedAfd :cognitect.aws.medialive/FixedAfd)

(s/def
  :cognitect.aws.medialive.H264Settings/MinIInterval
  :cognitect.aws.medialive/__integerMin0Max30)

(s/def
  :cognitect.aws.medialive.H264Settings/QvbrQualityLevel
  :cognitect.aws.medialive/__integerMin1Max10)

(s/def :cognitect.aws.medialive.H264Settings/Syntax :cognitect.aws.medialive/H264Syntax)

(s/def
  :cognitect.aws.medialive.H264Settings/ColorMetadata
  :cognitect.aws.medialive/H264ColorMetadata)

(s/def :cognitect.aws.medialive.H264Settings/TemporalAq :cognitect.aws.medialive/H264TemporalAq)

(s/def :cognitect.aws.medialive.H264Settings/FramerateNumerator :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.H264Settings/RateControlMode
  :cognitect.aws.medialive/H264RateControlMode)

(s/def :cognitect.aws.medialive.H264Settings/ScanType :cognitect.aws.medialive/H264ScanType)

(s/def :cognitect.aws.medialive.H264Settings/Bitrate :cognitect.aws.medialive/__integerMin1000)

(s/def
  :cognitect.aws.medialive.H264Settings/TimecodeInsertion
  :cognitect.aws.medialive/H264TimecodeInsertionBehavior)

(s/def :cognitect.aws.medialive.H264Settings/ParControl :cognitect.aws.medialive/H264ParControl)

(s/def :cognitect.aws.medialive.H264Settings/Level :cognitect.aws.medialive/H264Level)

(s/def :cognitect.aws.medialive.H264Settings/GopSizeUnits :cognitect.aws.medialive/H264GopSizeUnits)

(s/def :cognitect.aws.medialive.H264Settings/MaxBitrate :cognitect.aws.medialive/__integerMin1000)

(s/def
  :cognitect.aws.medialive.H264Settings/FramerateDenominator
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.H264Settings/Slices :cognitect.aws.medialive/__integerMin1Max32)

(s/def
  :cognitect.aws.medialive.H264Settings/BufFillPct
  :cognitect.aws.medialive/__integerMin0Max100)

(s/def
  :cognitect.aws.medialive.H264Settings/LookAheadRateControl
  :cognitect.aws.medialive/H264LookAheadRateControl)

(s/def
  :cognitect.aws.medialive.H264Settings/GopClosedCadence
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.H264Settings/GopBReference
  :cognitect.aws.medialive/H264GopBReference)

(s/def :cognitect.aws.medialive.H264Settings/AfdSignaling :cognitect.aws.medialive/AfdSignaling)

(s/def :cognitect.aws.medialive.H264Settings/BufSize :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.H264Settings/FramerateControl
  :cognitect.aws.medialive/H264FramerateControl)

(s/def
  :cognitect.aws.medialive.VideoCodecSettings/H264Settings
  :cognitect.aws.medialive/H264Settings)

(s/def
  :cognitect.aws.medialive.Eac3Settings/PassthroughControl
  :cognitect.aws.medialive/Eac3PassthroughControl)

(s/def :cognitect.aws.medialive.Eac3Settings/LfeFilter :cognitect.aws.medialive/Eac3LfeFilter)

(s/def
  :cognitect.aws.medialive.Eac3Settings/StereoDownmix
  :cognitect.aws.medialive/Eac3StereoDownmix)

(s/def
  :cognitect.aws.medialive.Eac3Settings/BitstreamMode
  :cognitect.aws.medialive/Eac3BitstreamMode)

(s/def :cognitect.aws.medialive.Eac3Settings/SurroundMode :cognitect.aws.medialive/Eac3SurroundMode)

(s/def
  :cognitect.aws.medialive.Eac3Settings/SurroundExMode
  :cognitect.aws.medialive/Eac3SurroundExMode)

(s/def :cognitect.aws.medialive.Eac3Settings/CodingMode :cognitect.aws.medialive/Eac3CodingMode)

(s/def :cognitect.aws.medialive.Eac3Settings/DrcRf :cognitect.aws.medialive/Eac3DrcRf)

(s/def
  :cognitect.aws.medialive.Eac3Settings/AttenuationControl
  :cognitect.aws.medialive/Eac3AttenuationControl)

(s/def :cognitect.aws.medialive.Eac3Settings/PhaseControl :cognitect.aws.medialive/Eac3PhaseControl)

(s/def :cognitect.aws.medialive.Eac3Settings/LtRtSurroundMixLevel :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/Bitrate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/DcFilter :cognitect.aws.medialive/Eac3DcFilter)

(s/def :cognitect.aws.medialive.Eac3Settings/LtRtCenterMixLevel :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/DrcLine :cognitect.aws.medialive/Eac3DrcLine)

(s/def
  :cognitect.aws.medialive.Eac3Settings/MetadataControl
  :cognitect.aws.medialive/Eac3MetadataControl)

(s/def :cognitect.aws.medialive.Eac3Settings/LoRoSurroundMixLevel :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/Dialnorm :cognitect.aws.medialive/__integerMin1Max31)

(s/def :cognitect.aws.medialive.Eac3Settings/LoRoCenterMixLevel :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/LfeControl :cognitect.aws.medialive/Eac3LfeControl)

(s/def :cognitect.aws.medialive.InputLocation/PasswordParam :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputLocation/Uri :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputLocation/Username :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/Scte35Pid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/EcmPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/VideoPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/PcrControl :cognitect.aws.medialive/M3u8PcrControl)

(s/def
  :cognitect.aws.medialive.M3u8Settings/PatInterval
  :cognitect.aws.medialive/__integerMin0Max1000)

(s/def :cognitect.aws.medialive.M3u8Settings/AudioPids :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/PcrPeriod :cognitect.aws.medialive/__integerMin0Max500)

(s/def
  :cognitect.aws.medialive.M3u8Settings/Scte35Behavior
  :cognitect.aws.medialive/M3u8Scte35Behavior)

(s/def :cognitect.aws.medialive.M3u8Settings/PcrPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M3u8Settings/TimedMetadataBehavior
  :cognitect.aws.medialive/M3u8TimedMetadataBehavior)

(s/def
  :cognitect.aws.medialive.M3u8Settings/ProgramNum
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def
  :cognitect.aws.medialive.M3u8Settings/TransportStreamId
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def :cognitect.aws.medialive.M3u8Settings/PmtPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M3u8Settings/PmtInterval
  :cognitect.aws.medialive/__integerMin0Max1000)

(s/def
  :cognitect.aws.medialive.M3u8Settings/AudioFramesPerPes
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.M3u8Settings/TimedMetadataPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioSelectorSettings/AudioLanguageSelection
  :cognitect.aws.medialive/AudioLanguageSelection)

(s/def
  :cognitect.aws.medialive.AudioSelectorSettings/AudioPidSelection
  :cognitect.aws.medialive/AudioPidSelection)

(s/def
  :cognitect.aws.medialive.StaticImageDeactivateScheduleActionSettings/FadeOut
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageDeactivateScheduleActionSettings/Layer
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def
  :cognitect.aws.medialive.ListChannelsResponse/Channels
  :cognitect.aws.medialive/__listOfChannelSummary)

(s/def :cognitect.aws.medialive.ListChannelsResponse/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/CurrencyCode
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/FixedPrice
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/ReservationId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/Region
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/OfferingDescription
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeReservationResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeReservationResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/Duration
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/UsagePrice
  :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.DescribeReservationResponse/End :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/State
  :cognitect.aws.medialive/ReservationState)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/Count
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/OfferingId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeReservationResponse/Start :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/OfferingType
  :cognitect.aws.medialive/OfferingType)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/Sources
  :cognitect.aws.medialive/__listOfInputSource)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/AttachedChannels
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.DescribeInputResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/Destinations
  :cognitect.aws.medialive/__listOfInputDestination)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/SecurityGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.DescribeInputResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeInputResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeInputResponse/Type :cognitect.aws.medialive/InputType)

(s/def :cognitect.aws.medialive.DescribeInputResponse/State :cognitect.aws.medialive/InputState)

(s/def
  :cognitect.aws.medialive.Scte20SourceSettings/Convert608To708
  :cognitect.aws.medialive/Scte20Convert608To708)

(s/def
  :cognitect.aws.medialive.Scte20SourceSettings/Source608ChannelNumber
  :cognitect.aws.medialive/__integerMin1Max4)

(s/def
  :cognitect.aws.medialive.CreateInputSecurityGroupRequest/WhitelistRules
  :cognitect.aws.medialive/__listOfInputWhitelistRuleCidr)

(s/def
  :cognitect.aws.medialive.CaptionDescription/CaptionSelectorName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CaptionDescription/DestinationSettings
  :cognitect.aws.medialive/CaptionDestinationSettings)

(s/def :cognitect.aws.medialive.CaptionDescription/LanguageCode :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CaptionDescription/LanguageDescription
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CaptionDescription/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StandardHlsSettings/AudioRenditionSets
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StandardHlsSettings/M3u8Settings
  :cognitect.aws.medialive/M3u8Settings)

(s/def :cognitect.aws.medialive.Scte27SourceSettings/Pid :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.VideoSelectorProgramId/ProgramId
  :cognitect.aws.medialive/__integerMin0Max65536)

(s/def :cognitect.aws.medialive.CaptionSelector/LanguageCode :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CaptionSelector/Name :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.CaptionSelector/SelectorSettings
  :cognitect.aws.medialive/CaptionSelectorSettings)

(s/def
  :cognitect.aws.medialive.HlsWebdavSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsWebdavSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0Max600)

(s/def
  :cognitect.aws.medialive.HlsWebdavSettings/HttpTransferMode
  :cognitect.aws.medialive/HlsWebdavHttpTransferMode)

(s/def :cognitect.aws.medialive.HlsWebdavSettings/NumRetries :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsWebdavSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def :cognitect.aws.medialive.StopChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.TeletextSourceSettings/PageNumber :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.RemixSettings/ChannelMappings
  :cognitect.aws.medialive/__listOfAudioChannelMapping)

(s/def
  :cognitect.aws.medialive.RemixSettings/ChannelsIn
  :cognitect.aws.medialive/__integerMin1Max16)

(s/def
  :cognitect.aws.medialive.RemixSettings/ChannelsOut
  :cognitect.aws.medialive/__integerMin1Max8)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/FadeIn
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Image
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Opacity
  :cognitect.aws.medialive/__integerMin0Max100)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/ImageX
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Duration
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Width
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/FadeOut
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/ImageY
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Layer
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Height
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.FollowModeScheduleActionStartSettings/FollowPoint
  :cognitect.aws.medialive/FollowPoint)

(s/def
  :cognitect.aws.medialive.FollowModeScheduleActionStartSettings/ReferenceActionName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsResponse/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsResponse/Offerings
  :cognitect.aws.medialive/__listOfOffering)

(s/def :cognitect.aws.medialive.AudioPidSelection/Pid :cognitect.aws.medialive/__integerMin0Max8191)

(s/def
  :cognitect.aws.medialive.HlsCdnSettings/HlsAkamaiSettings
  :cognitect.aws.medialive/HlsAkamaiSettings)

(s/def
  :cognitect.aws.medialive.HlsCdnSettings/HlsBasicPutSettings
  :cognitect.aws.medialive/HlsBasicPutSettings)

(s/def
  :cognitect.aws.medialive.HlsCdnSettings/HlsMediaStoreSettings
  :cognitect.aws.medialive/HlsMediaStoreSettings)

(s/def
  :cognitect.aws.medialive.HlsCdnSettings/HlsWebdavSettings
  :cognitect.aws.medialive/HlsWebdavSettings)

(s/def
  :cognitect.aws.medialive.InputAttachment/InputAttachmentName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputAttachment/InputId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputAttachment/InputSettings
  :cognitect.aws.medialive/InputSettings)

(s/def
  :cognitect.aws.medialive.Reservation/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def :cognitect.aws.medialive.Reservation/CurrencyCode :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/FixedPrice :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.Reservation/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def :cognitect.aws.medialive.Reservation/ReservationId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/Region :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/OfferingDescription :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/Duration :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.Reservation/UsagePrice :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Reservation/End :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/State :cognitect.aws.medialive/ReservationState)

(s/def :cognitect.aws.medialive.Reservation/Count :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.Reservation/OfferingId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/Start :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/OfferingType :cognitect.aws.medialive/OfferingType)

(s/def :cognitect.aws.medialive.VideoSelectorPid/Pid :cognitect.aws.medialive/__integerMin0Max8191)

(s/def
  :cognitect.aws.medialive.FixedModeScheduleActionStartSettings/Time
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsBasicPutSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsBasicPutSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0Max600)

(s/def
  :cognitect.aws.medialive.HlsBasicPutSettings/NumRetries
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsBasicPutSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def
  :cognitect.aws.medialive.BatchScheduleActionCreateRequest/ScheduleActions
  :cognitect.aws.medialive/__listOfScheduleAction)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbSdtSettings :cognitect.aws.medialive/DvbSdtSettings)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AbsentInputAudioBehavior
  :cognitect.aws.medialive/M2tsAbsentInputAudioBehavior)

(s/def :cognitect.aws.medialive.M2tsSettings/Scte35Pid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/EsRateInPes :cognitect.aws.medialive/M2tsEsRateInPes)

(s/def :cognitect.aws.medialive.M2tsSettings/CcDescriptor :cognitect.aws.medialive/M2tsCcDescriptor)

(s/def :cognitect.aws.medialive.M2tsSettings/SegmentationTime :cognitect.aws.medialive/__doubleMin1)

(s/def :cognitect.aws.medialive.M2tsSettings/EcmPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/SegmentationStyle
  :cognitect.aws.medialive/M2tsSegmentationStyle)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AribCaptionsPidControl
  :cognitect.aws.medialive/M2tsAribCaptionsPidControl)

(s/def :cognitect.aws.medialive.M2tsSettings/VideoPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/EtvSignalPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/PcrControl :cognitect.aws.medialive/M2tsPcrControl)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbSubPids :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/EbpLookaheadMs
  :cognitect.aws.medialive/__integerMin0Max10000)

(s/def :cognitect.aws.medialive.M2tsSettings/BufferModel :cognitect.aws.medialive/M2tsBufferModel)

(s/def
  :cognitect.aws.medialive.M2tsSettings/PatInterval
  :cognitect.aws.medialive/__integerMin0Max1000)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbTeletextPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AudioBufferModel
  :cognitect.aws.medialive/M2tsAudioBufferModel)

(s/def
  :cognitect.aws.medialive.M2tsSettings/SegmentationMarkers
  :cognitect.aws.medialive/M2tsSegmentationMarkers)

(s/def :cognitect.aws.medialive.M2tsSettings/EbpPlacement :cognitect.aws.medialive/M2tsEbpPlacement)

(s/def :cognitect.aws.medialive.M2tsSettings/Bitrate :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.M2tsSettings/AudioPids :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/PcrPeriod :cognitect.aws.medialive/__integerMin0Max500)

(s/def
  :cognitect.aws.medialive.M2tsSettings/NullPacketBitrate
  :cognitect.aws.medialive/__doubleMin0)

(s/def :cognitect.aws.medialive.M2tsSettings/AribCaptionsPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/KlvDataPids :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/EbpAudioInterval
  :cognitect.aws.medialive/M2tsAudioInterval)

(s/def :cognitect.aws.medialive.M2tsSettings/PcrPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/Ebif :cognitect.aws.medialive/M2tsEbifControl)

(s/def
  :cognitect.aws.medialive.M2tsSettings/TimedMetadataBehavior
  :cognitect.aws.medialive/M2tsTimedMetadataBehavior)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AudioStreamType
  :cognitect.aws.medialive/M2tsAudioStreamType)

(s/def :cognitect.aws.medialive.M2tsSettings/Klv :cognitect.aws.medialive/M2tsKlv)

(s/def :cognitect.aws.medialive.M2tsSettings/EtvPlatformPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbTdtSettings :cognitect.aws.medialive/DvbTdtSettings)

(s/def :cognitect.aws.medialive.M2tsSettings/Arib :cognitect.aws.medialive/M2tsArib)

(s/def :cognitect.aws.medialive.M2tsSettings/Scte27Pids :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/ProgramNum
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def
  :cognitect.aws.medialive.M2tsSettings/Scte35Control
  :cognitect.aws.medialive/M2tsScte35Control)

(s/def :cognitect.aws.medialive.M2tsSettings/RateMode :cognitect.aws.medialive/M2tsRateMode)

(s/def
  :cognitect.aws.medialive.M2tsSettings/TransportStreamId
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def :cognitect.aws.medialive.M2tsSettings/PmtPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/PmtInterval
  :cognitect.aws.medialive/__integerMin0Max1000)

(s/def :cognitect.aws.medialive.M2tsSettings/FragmentTime :cognitect.aws.medialive/__doubleMin0)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbNitSettings :cognitect.aws.medialive/DvbNitSettings)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AudioFramesPerPes
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.M2tsSettings/TimedMetadataPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BatchScheduleActionDeleteResult/ScheduleActions
  :cognitect.aws.medialive/__listOfScheduleAction)

(s/def :cognitect.aws.medialive.StartChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputSecurityGroupRequest/InputSecurityGroupId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputSecurityGroupRequest/WhitelistRules
  :cognitect.aws.medialive/__listOfInputWhitelistRuleCidr)

(s/def
  :cognitect.aws.medialive.ScheduleActionStartSettings/FixedModeScheduleActionStartSettings
  :cognitect.aws.medialive/FixedModeScheduleActionStartSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionStartSettings/FollowModeScheduleActionStartSettings
  :cognitect.aws.medialive/FollowModeScheduleActionStartSettings)

(s/def :cognitect.aws.medialive.OutputGroup/Name :cognitect.aws.medialive/__stringMax32)

(s/def
  :cognitect.aws.medialive.OutputGroup/OutputGroupSettings
  :cognitect.aws.medialive/OutputGroupSettings)

(s/def :cognitect.aws.medialive.OutputGroup/Outputs :cognitect.aws.medialive/__listOfOutput)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/InputSwitchSettings
  :cognitect.aws.medialive/InputSwitchScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/Scte35ReturnToNetworkSettings
  :cognitect.aws.medialive/Scte35ReturnToNetworkScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/Scte35SpliceInsertSettings
  :cognitect.aws.medialive/Scte35SpliceInsertScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/Scte35TimeSignalSettings
  :cognitect.aws.medialive/Scte35TimeSignalScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/StaticImageActivateSettings
  :cognitect.aws.medialive/StaticImageActivateScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/StaticImageDeactivateSettings
  :cognitect.aws.medialive/StaticImageDeactivateScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.EmbeddedSourceSettings/Convert608To708
  :cognitect.aws.medialive/EmbeddedConvert608To708)

(s/def
  :cognitect.aws.medialive.EmbeddedSourceSettings/Scte20Detection
  :cognitect.aws.medialive/EmbeddedScte20Detection)

(s/def
  :cognitect.aws.medialive.EmbeddedSourceSettings/Source608ChannelNumber
  :cognitect.aws.medialive/__integerMin1Max4)

(s/def
  :cognitect.aws.medialive.EmbeddedSourceSettings/Source608TrackNumber
  :cognitect.aws.medialive/__integerMin1Max5)

(s/def :cognitect.aws.medialive.InputSourceRequest/PasswordParam :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSourceRequest/Url :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSourceRequest/Username :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Output/AudioDescriptionNames
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.Output/CaptionDescriptionNames
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.Output/OutputName :cognitect.aws.medialive/__stringMin1Max255)

(s/def :cognitect.aws.medialive.Output/OutputSettings :cognitect.aws.medialive/OutputSettings)

(s/def :cognitect.aws.medialive.Output/VideoDescriptionName :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.KeyProviderSettings/StaticKeySettings
  :cognitect.aws.medialive/StaticKeySettings)

(s/def :cognitect.aws.medialive.Mp2Settings/Bitrate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Mp2Settings/CodingMode :cognitect.aws.medialive/Mp2CodingMode)

(s/def :cognitect.aws.medialive.Mp2Settings/SampleRate :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupRequest/InputSecurityGroupId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ChannelEgressEndpoint/SourceIp :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/MaximumFramerate
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/ResourceType
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListReservationsRequest/Codec :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/SpecialFeature
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListReservationsRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/VideoQuality
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/MaximumBitrate
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/Resolution
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDestination/Ip :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDestination/Port :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDestination/Url :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BatchScheduleActionCreateResult/ScheduleActions
  :cognitect.aws.medialive/__listOfScheduleAction)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/Destinations
  :cognitect.aws.medialive/__listOfInputDestinationRequest)

(s/def :cognitect.aws.medialive.UpdateInputRequest/InputId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/InputSecurityGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.UpdateInputRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/Sources
  :cognitect.aws.medialive/__listOfInputSourceRequest)

(s/def :cognitect.aws.medialive.UpdateChannelResponse/Channel :cognitect.aws.medialive/Channel)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleRequest/ChannelId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleRequest/Creates
  :cognitect.aws.medialive/BatchScheduleActionCreateRequest)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleRequest/Deletes
  :cognitect.aws.medialive/BatchScheduleActionDeleteRequest)

(s/def :cognitect.aws.medialive.DeleteChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ArchiveOutputSettings/ContainerSettings
  :cognitect.aws.medialive/ArchiveContainerSettings)

(s/def :cognitect.aws.medialive.ArchiveOutputSettings/Extension :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ArchiveOutputSettings/NameModifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/AcquisitionPointId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/AudioOnlyTimecodeControl
  :cognitect.aws.medialive/SmoothGroupAudioOnlyTimecodeControl)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/TimestampOffset
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/CertificateMode
  :cognitect.aws.medialive/SmoothGroupCertificateMode)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/EventIdMode
  :cognitect.aws.medialive/SmoothGroupEventIdMode)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/NumRetries
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/FragmentLength
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/TimestampOffsetMode
  :cognitect.aws.medialive/SmoothGroupTimestampOffsetMode)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/EventStopBehavior
  :cognitect.aws.medialive/SmoothGroupEventStopBehavior)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/SendDelayMs
  :cognitect.aws.medialive/__integerMin0Max10000)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/StreamManifestBehavior
  :cognitect.aws.medialive/SmoothGroupStreamManifestBehavior)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/SparseTrackType
  :cognitect.aws.medialive/SmoothGroupSparseTrackType)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/SegmentationMode
  :cognitect.aws.medialive/SmoothGroupSegmentationMode)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.MsSmoothGroupSettings/EventId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/InputLossAction
  :cognitect.aws.medialive/InputLossActionForMsSmoothOut)

(s/def
  :cognitect.aws.medialive.UpdateInputSecurityGroupResponse/SecurityGroup
  :cognitect.aws.medialive/InputSecurityGroup)

(s/def
  :cognitect.aws.medialive.AvailSettings/Scte35SpliceInsert
  :cognitect.aws.medialive/Scte35SpliceInsert)

(s/def
  :cognitect.aws.medialive.AvailSettings/Scte35TimeSignalApos
  :cognitect.aws.medialive/Scte35TimeSignalApos)

(s/def
  :cognitect.aws.medialive.StaticKeySettings/KeyProviderServer
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.StaticKeySettings/StaticKeyValue
  :cognitect.aws.medialive/__stringMin32Max32)

(s/def
  :cognitect.aws.medialive.DvbTdtSettings/RepInterval
  :cognitect.aws.medialive/__integerMin1000Max30000)

(s/def :cognitect.aws.medialive.ListChannelsRequest/MaxResults :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListChannelsRequest/NextToken :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteInputRequest/InputId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsRequest/MaximumFramerate
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/ResourceType :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/Codec :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsRequest/SpecialFeature
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/NextToken :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/VideoQuality :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsRequest/MaximumBitrate
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/MaxResults :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/Resolution :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsRequest/ChannelConfiguration
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ScheduleAction/ActionName :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ScheduleAction/ScheduleActionSettings
  :cognitect.aws.medialive/ScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleAction/ScheduleActionStartSettings
  :cognitect.aws.medialive/ScheduleActionStartSettings)

(s/def
  :cognitect.aws.medialive.InputDestinationRequest/StreamName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.HlsOutputSettings/HlsSettings :cognitect.aws.medialive/HlsSettings)

(s/def
  :cognitect.aws.medialive.HlsOutputSettings/NameModifier
  :cognitect.aws.medialive/__stringMin1)

(s/def :cognitect.aws.medialive.HlsOutputSettings/SegmentModifier :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListInputsResponse/Inputs :cognitect.aws.medialive/__listOfInput)

(s/def :cognitect.aws.medialive.ListInputsResponse/NextToken :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DvbSubSourceSettings/Pid :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CreateInputSecurityGroupResponse/SecurityGroup
  :cognitect.aws.medialive/InputSecurityGroup)

(s/def :cognitect.aws.medialive.DescribeScheduleRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeScheduleRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.DescribeScheduleRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationRequest/ReservationId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UdpOutputSettings/BufferMsec
  :cognitect.aws.medialive/__integerMin0Max10000)

(s/def
  :cognitect.aws.medialive.UdpOutputSettings/ContainerSettings
  :cognitect.aws.medialive/UdpContainerSettings)

(s/def
  :cognitect.aws.medialive.UdpOutputSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.UdpOutputSettings/FecOutputSettings
  :cognitect.aws.medialive/FecOutputSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/AribDestinationSettings
  :cognitect.aws.medialive/AribDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/EmbeddedDestinationSettings
  :cognitect.aws.medialive/EmbeddedDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/DvbSubDestinationSettings
  :cognitect.aws.medialive/DvbSubDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/BurnInDestinationSettings
  :cognitect.aws.medialive/BurnInDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/TeletextDestinationSettings
  :cognitect.aws.medialive/TeletextDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/SmpteTtDestinationSettings
  :cognitect.aws.medialive/SmpteTtDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/WebvttDestinationSettings
  :cognitect.aws.medialive/WebvttDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/Scte20PlusEmbeddedDestinationSettings
  :cognitect.aws.medialive/Scte20PlusEmbeddedDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/TtmlDestinationSettings
  :cognitect.aws.medialive/TtmlDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/EmbeddedPlusScte20DestinationSettings
  :cognitect.aws.medialive/EmbeddedPlusScte20DestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/Scte27DestinationSettings
  :cognitect.aws.medialive/Scte27DestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/RtmpCaptionInfoDestinationSettings
  :cognitect.aws.medialive/RtmpCaptionInfoDestinationSettings)

(s/def
  :cognitect.aws.medialive.UdpGroupSettings/InputLossAction
  :cognitect.aws.medialive/InputLossActionForUdpOut)

(s/def
  :cognitect.aws.medialive.UdpGroupSettings/TimedMetadataId3Frame
  :cognitect.aws.medialive/UdpTimedMetadataId3Frame)

(s/def
  :cognitect.aws.medialive.UdpGroupSettings/TimedMetadataId3Period
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.CreateChannelRequest/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.CreateChannelRequest/Reserved :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.CreateChannelRequest/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateChannelRequest/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateChannelRequest/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputWhitelistRuleCidr/Cidr :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/AribSourceSettings
  :cognitect.aws.medialive/AribSourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/DvbSubSourceSettings
  :cognitect.aws.medialive/DvbSubSourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/EmbeddedSourceSettings
  :cognitect.aws.medialive/EmbeddedSourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/Scte20SourceSettings
  :cognitect.aws.medialive/Scte20SourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/Scte27SourceSettings
  :cognitect.aws.medialive/Scte27SourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/TeletextSourceSettings
  :cognitect.aws.medialive/TeletextSourceSettings)

(s/def
  :cognitect.aws.medialive.DescribeScheduleResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeScheduleResponse/ScheduleActions
  :cognitect.aws.medialive/__listOfScheduleAction)

(s/def
  :cognitect.aws.medialive.DescribeReservationRequest/ReservationId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputLocationRef/DestinationRefId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.TtmlDestinationSettings/StyleControl
  :cognitect.aws.medialive/TtmlDestinationStyleControl)

(s/def
  :cognitect.aws.medialive.Scte35DescriptorSettings/SegmentationDescriptorScte35DescriptorSettings
  :cognitect.aws.medialive/Scte35SegmentationDescriptor)

(s/def
  :cognitect.aws.medialive.InputSwitchScheduleActionSettings/InputAttachmentNameReference
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Offering/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def :cognitect.aws.medialive.Offering/CurrencyCode :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/FixedPrice :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.Offering/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def :cognitect.aws.medialive.Offering/Region :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/OfferingDescription :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/Duration :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.Offering/UsagePrice :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Offering/OfferingId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/OfferingType :cognitect.aws.medialive/OfferingType)

(s/def
  :cognitect.aws.medialive.VideoSelectorSettings/VideoSelectorPid
  :cognitect.aws.medialive/VideoSelectorPid)

(s/def
  :cognitect.aws.medialive.VideoSelectorSettings/VideoSelectorProgramId
  :cognitect.aws.medialive/VideoSelectorProgramId)

(s/def :cognitect.aws.medialive.DescribeInputRequest/InputId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioNormalizationSettings/Algorithm
  :cognitect.aws.medialive/AudioNormalizationAlgorithm)

(s/def
  :cognitect.aws.medialive.AudioNormalizationSettings/AlgorithmControl
  :cognitect.aws.medialive/AudioNormalizationAlgorithmControl)

(s/def
  :cognitect.aws.medialive.AudioNormalizationSettings/TargetLkfs
  :cognitect.aws.medialive/__doubleMinNegative59Max0)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/AuthenticationScheme
  :cognitect.aws.medialive/AuthenticationScheme)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/CacheFullBehavior
  :cognitect.aws.medialive/RtmpCacheFullBehavior)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/CacheLength
  :cognitect.aws.medialive/__integerMin30)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/CaptionData
  :cognitect.aws.medialive/RtmpCaptionData)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/InputLossAction
  :cognitect.aws.medialive/InputLossActionForRtmpOut)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.RtmpOutputSettings/CertificateMode
  :cognitect.aws.medialive/RtmpOutputCertificateMode)

(s/def
  :cognitect.aws.medialive.RtmpOutputSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.RtmpOutputSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.RtmpOutputSettings/NumRetries
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.UpdateChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def :cognitect.aws.medialive.UpdateChannelRequest/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def :cognitect.aws.medialive.UpdateChannelRequest/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateChannelRequest/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeOfferingRequest/OfferingId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AvailConfiguration/AvailSettings
  :cognitect.aws.medialive/AvailSettings)

(s/def :cognitect.aws.medialive.ListInputsRequest/MaxResults :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListInputsRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35ReturnToNetworkScheduleActionSettings/SpliceEventId
  :cognitect.aws.medialive/__integerMin0Max4294967295)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleResponse/Creates
  :cognitect.aws.medialive/BatchScheduleActionCreateResult)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleResponse/Deletes
  :cognitect.aws.medialive/BatchScheduleActionDeleteResult)

(s/def
  :cognitect.aws.medialive.NetworkInputSettings/HlsInputSettings
  :cognitect.aws.medialive/HlsInputSettings)

(s/def
  :cognitect.aws.medialive.NetworkInputSettings/ServerValidation
  :cognitect.aws.medialive/NetworkInputServerValidation)

(s/def
  :cognitect.aws.medialive.AudioChannelMapping/InputChannelLevels
  :cognitect.aws.medialive/__listOfInputChannelLevel)

(s/def
  :cognitect.aws.medialive.AudioChannelMapping/OutputChannel
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def :cognitect.aws.medialive.DescribeChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputSettings/FilterStrength
  :cognitect.aws.medialive/__integerMin1Max5)

(s/def
  :cognitect.aws.medialive.InputSettings/DenoiseFilter
  :cognitect.aws.medialive/InputDenoiseFilter)

(s/def :cognitect.aws.medialive.InputSettings/VideoSelector :cognitect.aws.medialive/VideoSelector)

(s/def
  :cognitect.aws.medialive.InputSettings/CaptionSelectors
  :cognitect.aws.medialive/__listOfCaptionSelector)

(s/def
  :cognitect.aws.medialive.InputSettings/AudioSelectors
  :cognitect.aws.medialive/__listOfAudioSelector)

(s/def
  :cognitect.aws.medialive.InputSettings/DeblockFilter
  :cognitect.aws.medialive/InputDeblockFilter)

(s/def :cognitect.aws.medialive.InputSettings/InputFilter :cognitect.aws.medialive/InputFilter)

(s/def
  :cognitect.aws.medialive.InputSettings/SourceEndBehavior
  :cognitect.aws.medialive/InputSourceEndBehavior)

(s/def
  :cognitect.aws.medialive.InputSettings/NetworkInputSettings
  :cognitect.aws.medialive/NetworkInputSettings)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0Max600)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/MediaStoreStorageClass
  :cognitect.aws.medialive/HlsMediaStoreStorageClass)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/NumRetries
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def :cognitect.aws.medialive.Ac3Settings/Bitrate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Ac3Settings/BitstreamMode :cognitect.aws.medialive/Ac3BitstreamMode)

(s/def :cognitect.aws.medialive.Ac3Settings/CodingMode :cognitect.aws.medialive/Ac3CodingMode)

(s/def :cognitect.aws.medialive.Ac3Settings/Dialnorm :cognitect.aws.medialive/__integerMin1Max31)

(s/def :cognitect.aws.medialive.Ac3Settings/DrcProfile :cognitect.aws.medialive/Ac3DrcProfile)

(s/def :cognitect.aws.medialive.Ac3Settings/LfeFilter :cognitect.aws.medialive/Ac3LfeFilter)

(s/def
  :cognitect.aws.medialive.Ac3Settings/MetadataControl
  :cognitect.aws.medialive/Ac3MetadataControl)

(s/def :cognitect.aws.medialive.InputWhitelistRule/Cidr :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.FecOutputSettings/ColumnDepth
  :cognitect.aws.medialive/__integerMin4Max20)

(s/def
  :cognitect.aws.medialive.FecOutputSettings/IncludeFec
  :cognitect.aws.medialive/FecOutputIncludeFec)

(s/def
  :cognitect.aws.medialive.FecOutputSettings/RowLength
  :cognitect.aws.medialive/__integerMin1Max20)

(s/def
  :cognitect.aws.medialive.DvbNitSettings/NetworkId
  :cognitect.aws.medialive/__integerMin0Max65536)

(s/def
  :cognitect.aws.medialive.DvbNitSettings/NetworkName
  :cognitect.aws.medialive/__stringMin1Max256)

(s/def
  :cognitect.aws.medialive.DvbNitSettings/RepInterval
  :cognitect.aws.medialive/__integerMin25Max10000)

(s/def :cognitect.aws.medialive.StopChannelResponse/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.StopChannelResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.StopChannelResponse/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.StopChannelResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StopChannelResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.StopChannelResponse/State :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.DeleteInputSecurityGroupRequest/InputSecurityGroupId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioLanguageSelection/LanguageCode
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioLanguageSelection/LanguageSelectionPolicy
  :cognitect.aws.medialive/AudioLanguageSelectionPolicy)

(s/def :cognitect.aws.medialive.CreateInputResponse/Input :cognitect.aws.medialive/Input)

(s/def :cognitect.aws.medialive.TimecodeConfig/Source :cognitect.aws.medialive/TimecodeConfigSource)

(s/def
  :cognitect.aws.medialive.TimecodeConfig/SyncThreshold
  :cognitect.aws.medialive/__integerMin1Max1000000)

(s/def
  :cognitect.aws.medialive.HlsAkamaiSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsAkamaiSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0Max600)

(s/def
  :cognitect.aws.medialive.HlsAkamaiSettings/HttpTransferMode
  :cognitect.aws.medialive/HlsAkamaiHttpTransferMode)

(s/def :cognitect.aws.medialive.HlsAkamaiSettings/NumRetries :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsAkamaiSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def :cognitect.aws.medialive.HlsAkamaiSettings/Salt :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.HlsAkamaiSettings/Token :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputSettings/ArchiveOutputSettings
  :cognitect.aws.medialive/ArchiveOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/HlsOutputSettings
  :cognitect.aws.medialive/HlsOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/MsSmoothOutputSettings
  :cognitect.aws.medialive/MsSmoothOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/RtmpOutputSettings
  :cognitect.aws.medialive/RtmpOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/UdpOutputSettings
  :cognitect.aws.medialive/UdpOutputSettings)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/InitialAudioGain
  :cognitect.aws.medialive/__integerMinNegative60Max60)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/InputEndAction
  :cognitect.aws.medialive/GlobalConfigurationInputEndAction)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/InputLossBehavior
  :cognitect.aws.medialive/InputLossBehavior)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/OutputTimingSource
  :cognitect.aws.medialive/GlobalConfigurationOutputTimingSource)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/SupportLowFramerateInputs
  :cognitect.aws.medialive/GlobalConfigurationLowFramerateInputs)

(s/def :cognitect.aws.medialive.AudioCodecSettings/AacSettings :cognitect.aws.medialive/AacSettings)

(s/def :cognitect.aws.medialive.AudioCodecSettings/Ac3Settings :cognitect.aws.medialive/Ac3Settings)

(s/def
  :cognitect.aws.medialive.AudioCodecSettings/Eac3Settings
  :cognitect.aws.medialive/Eac3Settings)

(s/def :cognitect.aws.medialive.AudioCodecSettings/Mp2Settings :cognitect.aws.medialive/Mp2Settings)

(s/def
  :cognitect.aws.medialive.AudioCodecSettings/PassThroughSettings
  :cognitect.aws.medialive/PassThroughSettings)

(s/def
  :cognitect.aws.medialive.HlsSettings/AudioOnlyHlsSettings
  :cognitect.aws.medialive/AudioOnlyHlsSettings)

(s/def
  :cognitect.aws.medialive.HlsSettings/StandardHlsSettings
  :cognitect.aws.medialive/StandardHlsSettings)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/State :cognitect.aws.medialive/ChannelState)

