;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.medialive.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.medialive/DvbSdtSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DvbSdtSettings/OutputSdt
     :cognitect.aws.medialive.DvbSdtSettings/ServiceName
     :cognitect.aws.medialive.DvbSdtSettings/RepInterval
     :cognitect.aws.medialive.DvbSdtSettings/ServiceProviderName]))

(s/def
  :cognitect.aws.medialive/DescribeNetworkResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeNetworkResult/Routes
     :cognitect.aws.medialive.DescribeNetworkResult/IpPools
     :cognitect.aws.medialive.DescribeNetworkResult/AssociatedClusterIds
     :cognitect.aws.medialive.DescribeNetworkResult/Arn
     :cognitect.aws.medialive.DescribeNetworkResult/State
     :cognitect.aws.medialive.DescribeNetworkResult/Name
     :cognitect.aws.medialive.DescribeNetworkResult/Id]))

(s/def
  :cognitect.aws.medialive/AudioDescription
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioDescription/AudioSelectorName
     :cognitect.aws.medialive.AudioDescription/Name]
    :opt-un
    [:cognitect.aws.medialive.AudioDescription/StreamName
     :cognitect.aws.medialive.AudioDescription/RemixSettings
     :cognitect.aws.medialive.AudioDescription/AudioType
     :cognitect.aws.medialive.AudioDescription/CodecSettings
     :cognitect.aws.medialive.AudioDescription/DvbDashAccessibility
     :cognitect.aws.medialive.AudioDescription/AudioDashRoles
     :cognitect.aws.medialive.AudioDescription/AudioWatermarkingSettings
     :cognitect.aws.medialive.AudioDescription/LanguageCodeControl
     :cognitect.aws.medialive.AudioDescription/AudioTypeControl
     :cognitect.aws.medialive.AudioDescription/LanguageCode
     :cognitect.aws.medialive.AudioDescription/AudioNormalizationSettings]))

(s/def
  :cognitect.aws.medialive/AudioOnlyHlsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AudioOnlyHlsSettings/SegmentType
     :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioOnlyImage
     :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioTrackType
     :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioGroupId]))

(s/def
  :cognitect.aws.medialive/AudioSelector
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioSelector/Name]
    :opt-un
    [:cognitect.aws.medialive.AudioSelector/SelectorSettings]))

(s/def
  :cognitect.aws.medialive/DeleteSignalMapRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteSignalMapRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/AvailBlankingState
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/M2tsPcrControl
  (s/spec string? :gen #(s/gen #{"CONFIGURED_PCR_PERIOD" "PCR_EVERY_PES_PACKET"})))

(s/def
  :cognitect.aws.medialive/__integerMin40Max16000
  (s/spec (s/and int? #(<= 40 % 16000)) :gen #(gen/choose 40 16000)))

(s/def
  :cognitect.aws.medialive/UpdateReservationResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateReservationResponse/Reservation]))

(s/def
  :cognitect.aws.medialive/InterfaceMappingCreateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InterfaceMappingCreateRequest/NetworkId
     :cognitect.aws.medialive.InterfaceMappingCreateRequest/LogicalInterfaceName]))

(s/def
  :cognitect.aws.medialive/DescribeInputSecurityGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Tags
     :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Inputs
     :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/WhitelistRules
     :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Arn
     :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/State
     :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Id]))

(s/def
  :cognitect.aws.medialive/HlsCaptionLanguageSetting
  (s/spec string? :gen #(s/gen #{"INSERT" "NONE" "OMIT"})))

(s/def
  :cognitect.aws.medialive/NodeInterfaceMappingCreateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.NodeInterfaceMappingCreateRequest/PhysicalInterfaceName
     :cognitect.aws.medialive.NodeInterfaceMappingCreateRequest/LogicalInterfaceName
     :cognitect.aws.medialive.NodeInterfaceMappingCreateRequest/NetworkInterfaceMode]))

(s/def
  :cognitect.aws.medialive/__integerMax5
  (s/spec (s/and int? #(>= 5 %)) :gen #(gen/choose Long/MIN_VALUE 5)))

(s/def
  :cognitect.aws.medialive/__listOfMediaResourceNeighbor
  (s/coll-of :cognitect.aws.medialive/MediaResourceNeighbor))

(s/def
  :cognitect.aws.medialive/VideoSelectorColorSpaceUsage
  (s/spec string? :gen #(s/gen #{"FORCE" "FALLBACK"})))

(s/def
  :cognitect.aws.medialive/ThumbnailData
  (s/keys :opt-un [:cognitect.aws.medialive.ThumbnailData/Body]))

(s/def
  :cognitect.aws.medialive/CreateMultiplexProgram
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateMultiplexProgram/RequestId
     :cognitect.aws.medialive.CreateMultiplexProgram/MultiplexProgramSettings
     :cognitect.aws.medialive.CreateMultiplexProgram/ProgramName]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max30
  (s/spec (s/and int? #(<= 0 % 30)) :gen #(gen/choose 0 30)))

(s/def
  :cognitect.aws.medialive/Scte35SpliceInsert
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Scte35SpliceInsert/NoRegionalBlackoutFlag
     :cognitect.aws.medialive.Scte35SpliceInsert/WebDeliveryAllowedFlag
     :cognitect.aws.medialive.Scte35SpliceInsert/AdAvailOffset]))

(s/def
  :cognitect.aws.medialive/Av1GopSizeUnits
  (s/spec string? :gen #(s/gen #{"SECONDS" "FRAMES"})))

(s/def
  :cognitect.aws.medialive/InputSdpLocation
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSdpLocation/SdpUrl
     :cognitect.aws.medialive.InputSdpLocation/MediaIndex]))

(s/def
  :cognitect.aws.medialive/__listOfOutputDestinationSettings
  (s/coll-of :cognitect.aws.medialive/OutputDestinationSettings))

(s/def
  :cognitect.aws.medialive/CreateNetworkRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateNetworkRequest/RequestId
     :cognitect.aws.medialive.CreateNetworkRequest/Tags
     :cognitect.aws.medialive.CreateNetworkRequest/Routes
     :cognitect.aws.medialive.CreateNetworkRequest/IpPools
     :cognitect.aws.medialive.CreateNetworkRequest/Name]))

(s/def :cognitect.aws.medialive/AacRawFormat (s/spec string? :gen #(s/gen #{"LATM_LOAS" "NONE"})))

(s/def
  :cognitect.aws.medialive/GlobalConfigurationLowFramerateInputs
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/DescribeAnywhereSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeAnywhereSettings/ClusterId
     :cognitect.aws.medialive.DescribeAnywhereSettings/ChannelPlacementGroupId]))

(s/def :cognitect.aws.medialive/RawSettings (s/keys))

(s/def
  :cognitect.aws.medialive/ListNodesResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListNodesResult/Nodes
     :cognitect.aws.medialive.ListNodesResult/NextToken]))

(s/def
  :cognitect.aws.medialive/Id3SegmentTaggingScheduleActionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Id3SegmentTaggingScheduleActionSettings/Tag
     :cognitect.aws.medialive.Id3SegmentTaggingScheduleActionSettings/Id3]))

(s/def
  :cognitect.aws.medialive/GetCloudWatchAlarmTemplateGroupRequest
  (s/keys :req-un [:cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/InternalServiceError
  (s/keys :opt-un [:cognitect.aws.medialive.InternalServiceError/Message]))

(s/def
  :cognitect.aws.medialive/AvailBlanking
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AvailBlanking/State
     :cognitect.aws.medialive.AvailBlanking/AvailBlankingImage]))

(s/def
  :cognitect.aws.medialive/ListReservationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListReservationsResponse/NextToken
     :cognitect.aws.medialive.ListReservationsResponse/Reservations]))

(s/def
  :cognitect.aws.medialive/SuccessfulMonitorDeployment
  (s/keys
    :req-un
    [:cognitect.aws.medialive.SuccessfulMonitorDeployment/DetailsUri
     :cognitect.aws.medialive.SuccessfulMonitorDeployment/Status]))

(s/def
  :cognitect.aws.medialive/Smpte2038DataPreference
  (s/spec string? :gen #(s/gen #{"PREFER" "IGNORE"})))

(s/def :cognitect.aws.medialive/InputResolution (s/spec string? :gen #(s/gen #{"UHD" "SD" "HD"})))

(s/def
  :cognitect.aws.medialive/HlsIncompleteSegmentBehavior
  (s/spec string? :gen #(s/gen #{"AUTO" "SUPPRESS"})))

(s/def
  :cognitect.aws.medialive/BatchDelete
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchDelete/InputSecurityGroupIds
     :cognitect.aws.medialive.BatchDelete/MultiplexIds
     :cognitect.aws.medialive.BatchDelete/ChannelIds
     :cognitect.aws.medialive.BatchDelete/InputIds]))

(s/def
  :cognitect.aws.medialive/InputChannelLevel
  (s/keys
    :req-un
    [:cognitect.aws.medialive.InputChannelLevel/InputChannel
     :cognitect.aws.medialive.InputChannelLevel/Gain]))

(s/def
  :cognitect.aws.medialive/HlsEncryptionType
  (s/spec string? :gen #(s/gen #{"SAMPLE_AES" "AES128"})))

(s/def
  :cognitect.aws.medialive/GlobalConfigurationOutputTimingSource
  (s/spec string? :gen #(s/gen #{"INPUT_CLOCK" "SYSTEM_CLOCK"})))

(s/def
  :cognitect.aws.medialive/OutputGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.OutputGroupSettings/UdpGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/ArchiveGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/MediaPackageGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/SrtGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/CmafIngestGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/MultiplexGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/FrameCaptureGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/MsSmoothGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/RtmpGroupSettings
     :cognitect.aws.medialive.OutputGroupSettings/HlsGroupSettings]))

(s/def
  :cognitect.aws.medialive/Smpte2110ReceiverGroupSdpSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Smpte2110ReceiverGroupSdpSettings/AncillarySdps
     :cognitect.aws.medialive.Smpte2110ReceiverGroupSdpSettings/AudioSdps
     :cognitect.aws.medialive.Smpte2110ReceiverGroupSdpSettings/VideoSdp]))

(s/def
  :cognitect.aws.medialive/ListInputSecurityGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputSecurityGroupsRequest/NextToken
     :cognitect.aws.medialive.ListInputSecurityGroupsRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/ClusterNetworkSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ClusterNetworkSettings/InterfaceMappings
     :cognitect.aws.medialive.ClusterNetworkSettings/DefaultRoute]))

(s/def
  :cognitect.aws.medialive/InputDeviceUhdAudioChannelPairProfile
  (s/spec
    string?
    :gen
    #(s/gen
      #{"VBR-AAC_LC-128000"
        "DISABLED"
        "CBR-AAC_HQ-192000"
        "CBR-AAC_HQ-256000"
        "VBR-AAC_HHE-16000"
        "CBR-AAC_HQ-512000"
        "CBR-AAC_HQ-384000"
        "VBR-AAC_HE-64000"})))

(s/def
  :cognitect.aws.medialive/H265AlternativeTransferFunction
  (s/spec string? :gen #(s/gen #{"INSERT" "OMIT"})))

(s/def
  :cognitect.aws.medialive/FailedMediaResourceMap
  (s/map-of :cognitect.aws.medialive/__string :cognitect.aws.medialive/MediaResource))

(s/def
  :cognitect.aws.medialive/DvbSubDestinationAlignment
  (s/spec string? :gen #(s/gen #{"LEFT" "CENTERED" "SMART"})))

(s/def
  :cognitect.aws.medialive/InputSecurityGroup
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSecurityGroup/Tags
     :cognitect.aws.medialive.InputSecurityGroup/Inputs
     :cognitect.aws.medialive.InputSecurityGroup/WhitelistRules
     :cognitect.aws.medialive.InputSecurityGroup/Arn
     :cognitect.aws.medialive.InputSecurityGroup/State
     :cognitect.aws.medialive.InputSecurityGroup/Id]))

(s/def
  :cognitect.aws.medialive/DeleteSdiSourceRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteSdiSourceRequest/SdiSourceId]))

(s/def
  :cognitect.aws.medialive/SmoothGroupTimestampOffsetMode
  (s/spec string? :gen #(s/gen #{"USE_EVENT_START_DATE" "USE_CONFIGURED_OFFSET"})))

(s/def
  :cognitect.aws.medialive/RtmpAdMarkers
  (s/spec string? :gen #(s/gen #{"ON_CUE_POINT_SCTE35"})))

(s/def
  :cognitect.aws.medialive/CreateCloudWatchAlarmTemplateRequestContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/TargetResourceType
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/MetricName
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/TreatMissingData
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/ComparisonOperator
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Statistic
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Period
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/EvaluationPeriods
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Threshold
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Name
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/GroupIdentifier]
    :opt-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/RequestId
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Tags
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/DatapointsToAlarm
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Description]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max3600
  (s/spec (s/and int? #(<= 0 % 3600)) :gen #(gen/choose 0 3600)))

(s/def
  :cognitect.aws.medialive/UpdateSdiSourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateSdiSourceRequest/SdiSourceId]
    :opt-un
    [:cognitect.aws.medialive.UpdateSdiSourceRequest/Type
     :cognitect.aws.medialive.UpdateSdiSourceRequest/Mode
     :cognitect.aws.medialive.UpdateSdiSourceRequest/Name]))

(s/def
  :cognitect.aws.medialive/__listOfInputSdpLocation
  (s/coll-of :cognitect.aws.medialive/InputSdpLocation))

(s/def
  :cognitect.aws.medialive/EventBridgeRuleTemplateTarget
  (s/keys :req-un [:cognitect.aws.medialive.EventBridgeRuleTemplateTarget/Arn]))

(s/def
  :cognitect.aws.medialive/__listOfColorCorrection
  (s/coll-of :cognitect.aws.medialive/ColorCorrection))

(s/def
  :cognitect.aws.medialive/HlsInputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsInputSettings/Scte35Source
     :cognitect.aws.medialive.HlsInputSettings/Bandwidth
     :cognitect.aws.medialive.HlsInputSettings/Retries
     :cognitect.aws.medialive.HlsInputSettings/RetryInterval
     :cognitect.aws.medialive.HlsInputSettings/BufferSegments]))

(s/def
  :cognitect.aws.medialive/__stringMin6Max6
  (s/spec
    (s/and string? #(<= 6 (count %) 6))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 6 6) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/Scte35TimeSignalApos
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Scte35TimeSignalApos/NoRegionalBlackoutFlag
     :cognitect.aws.medialive.Scte35TimeSignalApos/WebDeliveryAllowedFlag
     :cognitect.aws.medialive.Scte35TimeSignalApos/AdAvailOffset]))

(s/def
  :cognitect.aws.medialive/VideoDescription
  (s/keys
    :req-un
    [:cognitect.aws.medialive.VideoDescription/Name]
    :opt-un
    [:cognitect.aws.medialive.VideoDescription/Sharpness
     :cognitect.aws.medialive.VideoDescription/CodecSettings
     :cognitect.aws.medialive.VideoDescription/Width
     :cognitect.aws.medialive.VideoDescription/ScalingBehavior
     :cognitect.aws.medialive.VideoDescription/Height
     :cognitect.aws.medialive.VideoDescription/RespondToAfd]))

(s/def
  :cognitect.aws.medialive/ListNetworksResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListNetworksResponse/NextToken
     :cognitect.aws.medialive.ListNetworksResponse/Networks]))

(s/def
  :cognitect.aws.medialive/M2tsScte35Control
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.medialive/CmafIngestSegmentLengthUnits
  (s/spec string? :gen #(s/gen #{"SECONDS" "MILLISECONDS"})))

(s/def
  :cognitect.aws.medialive/CreateSignalMapResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateSignalMapResponseContent/Status
     :cognitect.aws.medialive.CreateSignalMapResponseContent/CreatedAt
     :cognitect.aws.medialive.CreateSignalMapResponseContent/Name
     :cognitect.aws.medialive.CreateSignalMapResponseContent/Id
     :cognitect.aws.medialive.CreateSignalMapResponseContent/Arn
     :cognitect.aws.medialive.CreateSignalMapResponseContent/DiscoveryEntryPointArn
     :cognitect.aws.medialive.CreateSignalMapResponseContent/MonitorChangesPendingDeployment]
    :opt-un
    [:cognitect.aws.medialive.CreateSignalMapResponseContent/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.CreateSignalMapResponseContent/Tags
     :cognitect.aws.medialive.CreateSignalMapResponseContent/ErrorMessage
     :cognitect.aws.medialive.CreateSignalMapResponseContent/MonitorDeployment
     :cognitect.aws.medialive.CreateSignalMapResponseContent/Description
     :cognitect.aws.medialive.CreateSignalMapResponseContent/ModifiedAt
     :cognitect.aws.medialive.CreateSignalMapResponseContent/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.CreateSignalMapResponseContent/FailedMediaResourceMap
     :cognitect.aws.medialive.CreateSignalMapResponseContent/MediaResourceMap
     :cognitect.aws.medialive.CreateSignalMapResponseContent/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.CreateSignalMapResponseContent/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/BatchDeleteResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchDeleteResultModel/Failed
     :cognitect.aws.medialive.BatchDeleteResultModel/Successful]))

(s/def
  :cognitect.aws.medialive/Scte35SpliceInsertWebDeliveryAllowedBehavior
  (s/spec string? :gen #(s/gen #{"FOLLOW" "IGNORE"})))

(s/def
  :cognitect.aws.medialive/InterfaceMappingUpdateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InterfaceMappingUpdateRequest/NetworkId
     :cognitect.aws.medialive.InterfaceMappingUpdateRequest/LogicalInterfaceName]))

(s/def
  :cognitect.aws.medialive/InputDeviceTransferType
  (s/spec string? :gen #(s/gen #{"OUTGOING" "INCOMING"})))

(s/def :cognitect.aws.medialive/AribDestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/MultiplexSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MultiplexSettings/TransportStreamBitrate
     :cognitect.aws.medialive.MultiplexSettings/TransportStreamId]
    :opt-un
    [:cognitect.aws.medialive.MultiplexSettings/MaximumVideoBufferDelayMilliseconds
     :cognitect.aws.medialive.MultiplexSettings/TransportStreamReservedBitrate]))

(s/def
  :cognitect.aws.medialive/__doubleMin1
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/__listOfInputDeviceSummary
  (s/coll-of :cognitect.aws.medialive/InputDeviceSummary))

(s/def
  :cognitect.aws.medialive/BurnInOutlineColor
  (s/spec string? :gen #(s/gen #{"GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})))

(s/def
  :cognitect.aws.medialive/ReservationSpecialFeature
  (s/spec string? :gen #(s/gen #{"MGHD" "MGUHD" "AUDIO_NORMALIZATION" "ADVANCED_AUDIO"})))

(s/def
  :cognitect.aws.medialive/ChannelSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ChannelSummary/ChannelClass
     :cognitect.aws.medialive.ChannelSummary/InputAttachments
     :cognitect.aws.medialive.ChannelSummary/PipelinesRunningCount
     :cognitect.aws.medialive.ChannelSummary/UsedChannelEngineVersions
     :cognitect.aws.medialive.ChannelSummary/LogLevel
     :cognitect.aws.medialive.ChannelSummary/RoleArn
     :cognitect.aws.medialive.ChannelSummary/Tags
     :cognitect.aws.medialive.ChannelSummary/AnywhereSettings
     :cognitect.aws.medialive.ChannelSummary/EgressEndpoints
     :cognitect.aws.medialive.ChannelSummary/CdiInputSpecification
     :cognitect.aws.medialive.ChannelSummary/Vpc
     :cognitect.aws.medialive.ChannelSummary/Arn
     :cognitect.aws.medialive.ChannelSummary/InputSpecification
     :cognitect.aws.medialive.ChannelSummary/ChannelEngineVersion
     :cognitect.aws.medialive.ChannelSummary/State
     :cognitect.aws.medialive.ChannelSummary/Destinations
     :cognitect.aws.medialive.ChannelSummary/Name
     :cognitect.aws.medialive.ChannelSummary/Maintenance
     :cognitect.aws.medialive.ChannelSummary/Id]))

(s/def
  :cognitect.aws.medialive/InputDeviceConfigurableAudioChannelPairProfile
  (s/spec
    string?
    :gen
    #(s/gen
      #{"VBR-AAC_LC-128000"
        "DISABLED"
        "CBR-AAC_HQ-192000"
        "CBR-AAC_HQ-256000"
        "VBR-AAC_HHE-16000"
        "CBR-AAC_HQ-512000"
        "CBR-AAC_HQ-384000"
        "VBR-AAC_HE-64000"})))

(s/def
  :cognitect.aws.medialive/__integerMin1Max32
  (s/spec (s/and int? #(<= 1 % 32)) :gen #(gen/choose 1 32)))

(s/def
  :cognitect.aws.medialive/CreateMultiplexProgramRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateMultiplexProgramRequest/MultiplexId
     :cognitect.aws.medialive.CreateMultiplexProgramRequest/RequestId
     :cognitect.aws.medialive.CreateMultiplexProgramRequest/MultiplexProgramSettings
     :cognitect.aws.medialive.CreateMultiplexProgramRequest/ProgramName]))

(s/def
  :cognitect.aws.medialive/DescribeNetworkResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeNetworkResponse/Routes
     :cognitect.aws.medialive.DescribeNetworkResponse/IpPools
     :cognitect.aws.medialive.DescribeNetworkResponse/AssociatedClusterIds
     :cognitect.aws.medialive.DescribeNetworkResponse/Arn
     :cognitect.aws.medialive.DescribeNetworkResponse/State
     :cognitect.aws.medialive.DescribeNetworkResponse/Name
     :cognitect.aws.medialive.DescribeNetworkResponse/Id]))

(s/def
  :cognitect.aws.medialive/GetEventBridgeRuleTemplateRequest
  (s/keys :req-un [:cognitect.aws.medialive.GetEventBridgeRuleTemplateRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/InputDeviceConnectionState
  (s/spec string? :gen #(s/gen #{"CONNECTED" "DISCONNECTED"})))

(s/def :cognitect.aws.medialive/M2tsAudioStreamType (s/spec string? :gen #(s/gen #{"DVB" "ATSC"})))

(s/def
  :cognitect.aws.medialive/ListInputSecurityGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputSecurityGroupsResponse/InputSecurityGroups
     :cognitect.aws.medialive.ListInputSecurityGroupsResponse/NextToken]))

(s/def
  :cognitect.aws.medialive/__stringMin1Max7
  (s/spec
    (s/and string? #(<= 1 (count %) 7))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 1 7) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/Scte35SegmentationDescriptor
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationEventId
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationCancelIndicator]
    :opt-un
    [:cognitect.aws.medialive.Scte35SegmentationDescriptor/SubSegmentNum
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationDuration
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationTypeId
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationUpid
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationUpidType
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentsExpected
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SubSegmentsExpected
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentNum
     :cognitect.aws.medialive.Scte35SegmentationDescriptor/DeliveryRestrictions]))

(s/def
  :cognitect.aws.medialive/H264ScanType
  (s/spec string? :gen #(s/gen #{"PROGRESSIVE" "INTERLACED"})))

(s/def
  :cognitect.aws.medialive/DvbSubDestinationOutlineColor
  (s/spec string? :gen #(s/gen #{"GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})))

(s/def
  :cognitect.aws.medialive/DeleteChannelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteChannelResponse/ChannelClass
     :cognitect.aws.medialive.DeleteChannelResponse/InputAttachments
     :cognitect.aws.medialive.DeleteChannelResponse/PipelinesRunningCount
     :cognitect.aws.medialive.DeleteChannelResponse/LogLevel
     :cognitect.aws.medialive.DeleteChannelResponse/RoleArn
     :cognitect.aws.medialive.DeleteChannelResponse/Tags
     :cognitect.aws.medialive.DeleteChannelResponse/PipelineDetails
     :cognitect.aws.medialive.DeleteChannelResponse/AnywhereSettings
     :cognitect.aws.medialive.DeleteChannelResponse/EgressEndpoints
     :cognitect.aws.medialive.DeleteChannelResponse/CdiInputSpecification
     :cognitect.aws.medialive.DeleteChannelResponse/EncoderSettings
     :cognitect.aws.medialive.DeleteChannelResponse/Vpc
     :cognitect.aws.medialive.DeleteChannelResponse/Arn
     :cognitect.aws.medialive.DeleteChannelResponse/InputSpecification
     :cognitect.aws.medialive.DeleteChannelResponse/ChannelEngineVersion
     :cognitect.aws.medialive.DeleteChannelResponse/State
     :cognitect.aws.medialive.DeleteChannelResponse/Destinations
     :cognitect.aws.medialive.DeleteChannelResponse/Name
     :cognitect.aws.medialive.DeleteChannelResponse/Maintenance
     :cognitect.aws.medialive.DeleteChannelResponse/Id]))

(s/def
  :cognitect.aws.medialive/__listOfInputWhitelistRuleCidr
  (s/coll-of :cognitect.aws.medialive/InputWhitelistRuleCidr))

(s/def
  :cognitect.aws.medialive/UpdateNetworkRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateNetworkRequest/NetworkId]
    :opt-un
    [:cognitect.aws.medialive.UpdateNetworkRequest/Routes
     :cognitect.aws.medialive.UpdateNetworkRequest/IpPools
     :cognitect.aws.medialive.UpdateNetworkRequest/Name]))

(s/def
  :cognitect.aws.medialive/UpdateCloudWatchAlarmTemplateGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Tags
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Description
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/ModifiedAt
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Arn
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/CreatedAt
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Name
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Id]))

(s/def
  :cognitect.aws.medialive/CreateChannelResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreateChannelResponse/Channel]))

(s/def
  :cognitect.aws.medialive/MultiplexState
  (s/spec
    string?
    :gen
    #(s/gen
      #{"IDLE"
        "CREATE_FAILED"
        "STARTING"
        "DELETING"
        "CREATING"
        "DELETED"
        "RECOVERING"
        "STOPPING"
        "RUNNING"})))

(s/def
  :cognitect.aws.medialive/__integerMin4Max20
  (s/spec (s/and int? #(<= 4 % 20)) :gen #(gen/choose 4 20)))

(s/def
  :cognitect.aws.medialive/__listOfIpPoolCreateRequest
  (s/coll-of :cognitect.aws.medialive/IpPoolCreateRequest))

(s/def
  :cognitect.aws.medialive/ReservationResourceSpecification
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ReservationResourceSpecification/ChannelClass
     :cognitect.aws.medialive.ReservationResourceSpecification/Codec
     :cognitect.aws.medialive.ReservationResourceSpecification/Resolution
     :cognitect.aws.medialive.ReservationResourceSpecification/MaximumBitrate
     :cognitect.aws.medialive.ReservationResourceSpecification/ResourceType
     :cognitect.aws.medialive.ReservationResourceSpecification/VideoQuality
     :cognitect.aws.medialive.ReservationResourceSpecification/SpecialFeature
     :cognitect.aws.medialive.ReservationResourceSpecification/MaximumFramerate]))

(s/def :cognitect.aws.medialive/__listOfInput (s/coll-of :cognitect.aws.medialive/Input))

(s/def
  :cognitect.aws.medialive/ListSignalMapsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListSignalMapsResponse/NextToken
     :cognitect.aws.medialive.ListSignalMapsResponse/SignalMaps]))

(s/def
  :cognitect.aws.medialive/DescribeNetworkRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeNetworkRequest/NetworkId]))

(s/def
  :cognitect.aws.medialive/DeleteClusterResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteClusterResponse/NetworkSettings
     :cognitect.aws.medialive.DeleteClusterResponse/ClusterType
     :cognitect.aws.medialive.DeleteClusterResponse/Arn
     :cognitect.aws.medialive.DeleteClusterResponse/InstanceRoleArn
     :cognitect.aws.medialive.DeleteClusterResponse/State
     :cognitect.aws.medialive.DeleteClusterResponse/Name
     :cognitect.aws.medialive.DeleteClusterResponse/ChannelIds
     :cognitect.aws.medialive.DeleteClusterResponse/Id]))

(s/def
  :cognitect.aws.medialive/DeleteTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DeleteTagsRequest/TagKeys
     :cognitect.aws.medialive.DeleteTagsRequest/ResourceArn]))

(s/def
  :cognitect.aws.medialive/__listOf__stringPatternS
  (s/coll-of :cognitect.aws.medialive/__stringPatternS))

(s/def
  :cognitect.aws.medialive/MultiplexSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexSummary/ProgramCount
     :cognitect.aws.medialive.MultiplexSummary/PipelinesRunningCount
     :cognitect.aws.medialive.MultiplexSummary/Tags
     :cognitect.aws.medialive.MultiplexSummary/Arn
     :cognitect.aws.medialive.MultiplexSummary/MultiplexSettings
     :cognitect.aws.medialive.MultiplexSummary/State
     :cognitect.aws.medialive.MultiplexSummary/Name
     :cognitect.aws.medialive.MultiplexSummary/AvailabilityZones
     :cognitect.aws.medialive.MultiplexSummary/Id]))

(s/def
  :cognitect.aws.medialive/SrtSettings
  (s/keys :opt-un [:cognitect.aws.medialive.SrtSettings/SrtCallerSources]))

(s/def
  :cognitect.aws.medialive/H264LookAheadRateControl
  (s/spec string? :gen #(s/gen #{"LOW" "HIGH" "MEDIUM"})))

(s/def
  :cognitect.aws.medialive/M2tsSegmentationStyle
  (s/spec string? :gen #(s/gen #{"MAINTAIN_CADENCE" "RESET_CADENCE"})))

(s/def
  :cognitect.aws.medialive/__integerMin50000Max24000000
  (s/spec (s/and int? #(<= 50000 % 24000000)) :gen #(gen/choose 50000 24000000)))

(s/def
  :cognitect.aws.medialive/NotFoundExceptionResponseContent
  (s/keys :opt-un [:cognitect.aws.medialive.NotFoundExceptionResponseContent/Message]))

(s/def
  :cognitect.aws.medialive/CaptionLanguageMapping
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CaptionLanguageMapping/LanguageCode
     :cognitect.aws.medialive.CaptionLanguageMapping/LanguageDescription
     :cognitect.aws.medialive.CaptionLanguageMapping/CaptionChannel]))

(s/def
  :cognitect.aws.medialive/__listOfNodeInterfaceMapping
  (s/coll-of :cognitect.aws.medialive/NodeInterfaceMapping))

(s/def
  :cognitect.aws.medialive/DeleteScheduleRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteScheduleRequest/ChannelId]))

(s/def
  :cognitect.aws.medialive/OutputDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.OutputDestinationSettings/Username
     :cognitect.aws.medialive.OutputDestinationSettings/StreamName
     :cognitect.aws.medialive.OutputDestinationSettings/Url
     :cognitect.aws.medialive.OutputDestinationSettings/PasswordParam]))

(s/def
  :cognitect.aws.medialive/EventBridgeRuleTemplateSummary
  (s/keys
    :req-un
    [:cognitect.aws.medialive.EventBridgeRuleTemplateSummary/EventType
     :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/CreatedAt
     :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/EventTargetCount
     :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Id
     :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Arn
     :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Name
     :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/GroupId]
    :opt-un
    [:cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Tags
     :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Description
     :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/HlsAkamaiHttpTransferMode
  (s/spec string? :gen #(s/gen #{"NON_CHUNKED" "CHUNKED"})))

(s/def
  :cognitect.aws.medialive/Scte35TimeSignalScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35TimeSignalScheduleActionSettings/Scte35Descriptors]))

(s/def
  :cognitect.aws.medialive/SdiSourceMode
  (s/spec string? :gen #(s/gen #{"QUADRANT" "INTERLEAVE"})))

(s/def
  :cognitect.aws.medialive/Mpeg2FilterSettings
  (s/keys :opt-un [:cognitect.aws.medialive.Mpeg2FilterSettings/TemporalFilterSettings]))

(s/def
  :cognitect.aws.medialive/CreateSignalMapResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateSignalMapResponse/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.CreateSignalMapResponse/Tags
     :cognitect.aws.medialive.CreateSignalMapResponse/Status
     :cognitect.aws.medialive.CreateSignalMapResponse/ErrorMessage
     :cognitect.aws.medialive.CreateSignalMapResponse/MonitorDeployment
     :cognitect.aws.medialive.CreateSignalMapResponse/DiscoveryEntryPointArn
     :cognitect.aws.medialive.CreateSignalMapResponse/Description
     :cognitect.aws.medialive.CreateSignalMapResponse/ModifiedAt
     :cognitect.aws.medialive.CreateSignalMapResponse/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.CreateSignalMapResponse/Arn
     :cognitect.aws.medialive.CreateSignalMapResponse/CreatedAt
     :cognitect.aws.medialive.CreateSignalMapResponse/FailedMediaResourceMap
     :cognitect.aws.medialive.CreateSignalMapResponse/Name
     :cognitect.aws.medialive.CreateSignalMapResponse/MediaResourceMap
     :cognitect.aws.medialive.CreateSignalMapResponse/MonitorChangesPendingDeployment
     :cognitect.aws.medialive.CreateSignalMapResponse/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.CreateSignalMapResponse/Id
     :cognitect.aws.medialive.CreateSignalMapResponse/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/OutputDestination
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.OutputDestination/LogicalInterfaceNames
     :cognitect.aws.medialive.OutputDestination/SrtSettings
     :cognitect.aws.medialive.OutputDestination/MediaPackageSettings
     :cognitect.aws.medialive.OutputDestination/Settings
     :cognitect.aws.medialive.OutputDestination/MultiplexSettings
     :cognitect.aws.medialive.OutputDestination/Id]))

(s/def
  :cognitect.aws.medialive/NodeConnectionState
  (s/spec string? :gen #(s/gen #{"CONNECTED" "DISCONNECTED"})))

(s/def
  :cognitect.aws.medialive/Av1Settings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Av1Settings/FramerateNumerator
     :cognitect.aws.medialive.Av1Settings/FramerateDenominator]
    :opt-un
    [:cognitect.aws.medialive.Av1Settings/Level
     :cognitect.aws.medialive.Av1Settings/RateControlMode
     :cognitect.aws.medialive.Av1Settings/MinIInterval
     :cognitect.aws.medialive.Av1Settings/ParDenominator
     :cognitect.aws.medialive.Av1Settings/QvbrQualityLevel
     :cognitect.aws.medialive.Av1Settings/AfdSignaling
     :cognitect.aws.medialive.Av1Settings/BufSize
     :cognitect.aws.medialive.Av1Settings/LookAheadRateControl
     :cognitect.aws.medialive.Av1Settings/GopSizeUnits
     :cognitect.aws.medialive.Av1Settings/MaxBitrate
     :cognitect.aws.medialive.Av1Settings/ParNumerator
     :cognitect.aws.medialive.Av1Settings/GopSize
     :cognitect.aws.medialive.Av1Settings/FixedAfd
     :cognitect.aws.medialive.Av1Settings/TimecodeBurninSettings
     :cognitect.aws.medialive.Av1Settings/SceneChangeDetect
     :cognitect.aws.medialive.Av1Settings/ColorSpaceSettings
     :cognitect.aws.medialive.Av1Settings/Bitrate]))

(s/def
  :cognitect.aws.medialive/BlackoutSlate
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BlackoutSlate/NetworkEndBlackoutImage
     :cognitect.aws.medialive.BlackoutSlate/NetworkId
     :cognitect.aws.medialive.BlackoutSlate/NetworkEndBlackout
     :cognitect.aws.medialive.BlackoutSlate/BlackoutSlateImage
     :cognitect.aws.medialive.BlackoutSlate/State]))

(s/def
  :cognitect.aws.medialive/ListClustersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListClustersResponse/NextToken
     :cognitect.aws.medialive.ListClustersResponse/Clusters]))

(s/def
  :cognitect.aws.medialive/MediaResourceMap
  (s/map-of :cognitect.aws.medialive/__string :cognitect.aws.medialive/MediaResource))

(s/def
  :cognitect.aws.medialive/DescribeClusterRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeClusterRequest/ClusterId]))

(s/def
  :cognitect.aws.medialive/BurnInFontColor
  (s/spec string? :gen #(s/gen #{"GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})))

(s/def
  :cognitect.aws.medialive/CreateChannelPlacementGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Nodes
     :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/ClusterId
     :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Arn
     :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/State
     :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Name
     :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Id
     :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Channels]))

(s/def
  :cognitect.aws.medialive/InputDeviceSettings
  (s/keys :opt-un [:cognitect.aws.medialive.InputDeviceSettings/Id]))

(s/def
  :cognitect.aws.medialive/MotionGraphicsInsertion
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/BatchSuccessfulResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchSuccessfulResultModel/Arn
     :cognitect.aws.medialive.BatchSuccessfulResultModel/State
     :cognitect.aws.medialive.BatchSuccessfulResultModel/Id]))

(s/def
  :cognitect.aws.medialive/CreateCloudWatchAlarmTemplateGroupRequestContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequestContent/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequestContent/RequestId
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequestContent/Tags
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequestContent/Description]))

(s/def :cognitect.aws.medialive/__timestampUnix inst?)

(s/def
  :cognitect.aws.medialive/SmoothGroupSparseTrackType
  (s/spec string? :gen #(s/gen #{"SCTE_35_WITHOUT_SEGMENTATION" "NONE" "SCTE_35"})))

(s/def
  :cognitect.aws.medialive/Mpeg2SubGopLength
  (s/spec string? :gen #(s/gen #{"FIXED" "DYNAMIC"})))

(s/def
  :cognitect.aws.medialive/TagMap
  (s/map-of :cognitect.aws.medialive/__string :cognitect.aws.medialive/__string))

(s/def
  :cognitect.aws.medialive/DescribeSdiSourceResponse
  (s/keys :opt-un [:cognitect.aws.medialive.DescribeSdiSourceResponse/SdiSource]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max10
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.medialive/RejectInputDeviceTransferRequest
  (s/keys :req-un [:cognitect.aws.medialive.RejectInputDeviceTransferRequest/InputDeviceId]))

(s/def
  :cognitect.aws.medialive/ArchiveContainerSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ArchiveContainerSettings/M2tsSettings
     :cognitect.aws.medialive.ArchiveContainerSettings/RawSettings]))

(s/def
  :cognitect.aws.medialive/BandwidthReductionFilterStrength
  (s/spec string? :gen #(s/gen #{"STRENGTH_2" "AUTO" "STRENGTH_3" "STRENGTH_4" "STRENGTH_1"})))

(s/def
  :cognitect.aws.medialive/ListInputDevicesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputDevicesResponse/NextToken
     :cognitect.aws.medialive.ListInputDevicesResponse/InputDevices]))

(s/def
  :cognitect.aws.medialive/Eac3DrcLine
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def
  :cognitect.aws.medialive/Eac3AtmosCodingMode
  (s/spec string? :gen #(s/gen #{"CODING_MODE_7_1_4" "CODING_MODE_5_1_4" "CODING_MODE_9_1_6"})))

(s/def
  :cognitect.aws.medialive/LogLevel
  (s/spec string? :gen #(s/gen #{"DISABLED" "WARNING" "ERROR" "DEBUG" "INFO"})))

(s/def
  :cognitect.aws.medialive/MulticastSettingsCreateRequest
  (s/keys :opt-un [:cognitect.aws.medialive.MulticastSettingsCreateRequest/Sources]))

(s/def
  :cognitect.aws.medialive/M2tsAudioInterval
  (s/spec string? :gen #(s/gen #{"VIDEO_AND_FIXED_INTERVALS" "VIDEO_INTERVAL"})))

(s/def
  :cognitect.aws.medialive/__stringMax64
  (s/spec
    (s/and string? #(>= 64 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 64) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive/ThumbnailState (s/spec string? :gen #(s/gen #{"DISABLED" "AUTO"})))

(s/def
  :cognitect.aws.medialive/ReservationState
  (s/spec string? :gen #(s/gen #{"CANCELED" "EXPIRED" "ACTIVE" "DELETED"})))

(s/def
  :cognitect.aws.medialive/TemporalFilterPostFilterSharpening
  (s/spec string? :gen #(s/gen #{"DISABLED" "AUTO" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/Eac3CodingMode
  (s/spec string? :gen #(s/gen #{"CODING_MODE_1_0" "CODING_MODE_2_0" "CODING_MODE_3_2"})))

(s/def
  :cognitect.aws.medialive/TimecodeBurninSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.TimecodeBurninSettings/Position
     :cognitect.aws.medialive.TimecodeBurninSettings/FontSize]
    :opt-un
    [:cognitect.aws.medialive.TimecodeBurninSettings/Prefix]))

(s/def
  :cognitect.aws.medialive/M2tsAribCaptionsPidControl
  (s/spec string? :gen #(s/gen #{"USE_CONFIGURED" "AUTO"})))

(s/def
  :cognitect.aws.medialive/MulticastSettingsUpdateRequest
  (s/keys :opt-un [:cognitect.aws.medialive.MulticastSettingsUpdateRequest/Sources]))

(s/def
  :cognitect.aws.medialive/Scte35SpliceInsertScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35SpliceInsertScheduleActionSettings/SpliceEventId]
    :opt-un
    [:cognitect.aws.medialive.Scte35SpliceInsertScheduleActionSettings/Duration]))

(s/def
  :cognitect.aws.medialive/InputSourceType
  (s/spec string? :gen #(s/gen #{"STATIC" "DYNAMIC"})))

(s/def :cognitect.aws.medialive/EmbeddedDestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/GetEventBridgeRuleTemplateGroupRequest
  (s/keys :req-un [:cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupRequest/Identifier]))

(s/def :cognitect.aws.medialive/ImmediateModeScheduleActionStartSettings (s/keys))

(s/def :cognitect.aws.medialive/Ac3LfeFilter (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/ArchiveS3Settings
  (s/keys :opt-un [:cognitect.aws.medialive.ArchiveS3Settings/CannedAcl]))

(s/def
  :cognitect.aws.medialive/MultiplexMediaConnectOutputDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexMediaConnectOutputDestinationSettings/EntitlementArn]))

(s/def
  :cognitect.aws.medialive/CreatePartnerInput
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreatePartnerInput/RequestId
     :cognitect.aws.medialive.CreatePartnerInput/Tags]))

(s/def
  :cognitect.aws.medialive/RestartChannelPipelinesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.RestartChannelPipelinesResponse/ChannelClass
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/InputAttachments
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/PipelinesRunningCount
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/LogLevel
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/RoleArn
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/Tags
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/PipelineDetails
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/AnywhereSettings
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/EgressEndpoints
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/CdiInputSpecification
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/EncoderSettings
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/Vpc
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/Arn
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/InputSpecification
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/ChannelEngineVersion
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/State
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/Destinations
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/Name
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/Maintenance
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/Id
     :cognitect.aws.medialive.RestartChannelPipelinesResponse/MaintenanceStatus]))

(s/def
  :cognitect.aws.medialive/ListSdiSourcesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListSdiSourcesRequest/NextToken
     :cognitect.aws.medialive.ListSdiSourcesRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max2000
  (s/spec (s/and int? #(<= 0 % 2000)) :gen #(gen/choose 0 2000)))

(s/def
  :cognitect.aws.medialive/Hdr10Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Hdr10Settings/MaxFall :cognitect.aws.medialive.Hdr10Settings/MaxCll]))

(s/def
  :cognitect.aws.medialive/InputNetworkLocation
  (s/spec string? :gen #(s/gen #{"ON_PREMISES" "AWS"})))

(s/def
  :cognitect.aws.medialive/UpdateCloudWatchAlarmTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Identifier]
    :opt-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/TreatMissingData
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Period
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Threshold
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/ComparisonOperator
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/TargetResourceType
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/GroupIdentifier
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/DatapointsToAlarm
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Description
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/MetricName
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Name
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/EvaluationPeriods
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Statistic]))

(s/def
  :cognitect.aws.medialive/HlsGroupSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.HlsGroupSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.HlsGroupSettings/SegmentLength
     :cognitect.aws.medialive.HlsGroupSettings/TsFileMode
     :cognitect.aws.medialive.HlsGroupSettings/DiscontinuityTags
     :cognitect.aws.medialive.HlsGroupSettings/TimestampDeltaMilliseconds
     :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTimePeriod
     :cognitect.aws.medialive.HlsGroupSettings/ConstantIv
     :cognitect.aws.medialive.HlsGroupSettings/KeyFormatVersions
     :cognitect.aws.medialive.HlsGroupSettings/InputLossAction
     :cognitect.aws.medialive.HlsGroupSettings/AdMarkers
     :cognitect.aws.medialive.HlsGroupSettings/IncompleteSegmentBehavior
     :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTimeClock
     :cognitect.aws.medialive.HlsGroupSettings/CaptionLanguageMappings
     :cognitect.aws.medialive.HlsGroupSettings/TimedMetadataId3Frame
     :cognitect.aws.medialive.HlsGroupSettings/Mode
     :cognitect.aws.medialive.HlsGroupSettings/DirectoryStructure
     :cognitect.aws.medialive.HlsGroupSettings/EncryptionType
     :cognitect.aws.medialive.HlsGroupSettings/IndexNSegments
     :cognitect.aws.medialive.HlsGroupSettings/KeepSegments
     :cognitect.aws.medialive.HlsGroupSettings/MinSegmentLength
     :cognitect.aws.medialive.HlsGroupSettings/IvInManifest
     :cognitect.aws.medialive.HlsGroupSettings/StreamInfResolution
     :cognitect.aws.medialive.HlsGroupSettings/HlsCdnSettings
     :cognitect.aws.medialive.HlsGroupSettings/BaseUrlManifest1
     :cognitect.aws.medialive.HlsGroupSettings/RedundantManifest
     :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTime
     :cognitect.aws.medialive.HlsGroupSettings/IFrameOnlyPlaylists
     :cognitect.aws.medialive.HlsGroupSettings/OutputSelection
     :cognitect.aws.medialive.HlsGroupSettings/BaseUrlContent
     :cognitect.aws.medialive.HlsGroupSettings/HlsId3SegmentTagging
     :cognitect.aws.medialive.HlsGroupSettings/CaptionLanguageSetting
     :cognitect.aws.medialive.HlsGroupSettings/ManifestDurationFormat
     :cognitect.aws.medialive.HlsGroupSettings/SegmentationMode
     :cognitect.aws.medialive.HlsGroupSettings/TimedMetadataId3Period
     :cognitect.aws.medialive.HlsGroupSettings/ManifestCompression
     :cognitect.aws.medialive.HlsGroupSettings/SegmentsPerSubdirectory
     :cognitect.aws.medialive.HlsGroupSettings/KeyFormat
     :cognitect.aws.medialive.HlsGroupSettings/IvSource
     :cognitect.aws.medialive.HlsGroupSettings/BaseUrlContent1
     :cognitect.aws.medialive.HlsGroupSettings/CodecSpecification
     :cognitect.aws.medialive.HlsGroupSettings/KeyProviderSettings
     :cognitect.aws.medialive.HlsGroupSettings/BaseUrlManifest
     :cognitect.aws.medialive.HlsGroupSettings/ClientCache]))

(s/def
  :cognitect.aws.medialive/ListInputDeviceTransfersResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputDeviceTransfersResultModel/NextToken
     :cognitect.aws.medialive.ListInputDeviceTransfersResultModel/InputDeviceTransfers]))

(s/def
  :cognitect.aws.medialive/LastFrameClippingBehavior
  (s/spec string? :gen #(s/gen #{"INCLUDE_LAST_FRAME" "EXCLUDE_LAST_FRAME"})))

(s/def
  :cognitect.aws.medialive/__listOfDashRoleCaption
  (s/coll-of :cognitect.aws.medialive/DashRoleCaption))

(s/def
  :cognitect.aws.medialive/__listOfInputDestinationRequest
  (s/coll-of :cognitect.aws.medialive/InputDestinationRequest))

(s/def
  :cognitect.aws.medialive/DescribeInputDeviceThumbnailRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DescribeInputDeviceThumbnailRequest/InputDeviceId
     :cognitect.aws.medialive.DescribeInputDeviceThumbnailRequest/Accept]))

(s/def :cognitect.aws.medialive/MultiplexGroupSettings (s/keys))

(s/def
  :cognitect.aws.medialive/HlsTimedMetadataId3Frame
  (s/spec string? :gen #(s/gen #{"TDRL" "NONE" "PRIV"})))

(s/def
  :cognitect.aws.medialive/H264FramerateControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.medialive/AudioDescriptionAudioTypeControl
  (s/spec string? :gen #(s/gen #{"FOLLOW_INPUT" "USE_CONFIGURED"})))

(s/def
  :cognitect.aws.medialive/__integerMin1Max3003
  (s/spec (s/and int? #(<= 1 % 3003)) :gen #(gen/choose 1 3003)))

(s/def
  :cognitect.aws.medialive/VideoSelectorColorSpace
  (s/spec string? :gen #(s/gen #{"HLG_2020" "REC_601" "FOLLOW" "HDR10" "REC_709"})))

(s/def
  :cognitect.aws.medialive/FecOutputIncludeFec
  (s/spec string? :gen #(s/gen #{"COLUMN_AND_ROW" "COLUMN"})))

(s/def :cognitect.aws.medialive/__boolean boolean?)

(s/def
  :cognitect.aws.medialive/InputDeviceSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceSummary/NetworkSettings
     :cognitect.aws.medialive.InputDeviceSummary/HdDeviceSettings
     :cognitect.aws.medialive.InputDeviceSummary/Type
     :cognitect.aws.medialive.InputDeviceSummary/ConnectionState
     :cognitect.aws.medialive.InputDeviceSummary/DeviceUpdateStatus
     :cognitect.aws.medialive.InputDeviceSummary/MacAddress
     :cognitect.aws.medialive.InputDeviceSummary/Tags
     :cognitect.aws.medialive.InputDeviceSummary/AvailabilityZone
     :cognitect.aws.medialive.InputDeviceSummary/MedialiveInputArns
     :cognitect.aws.medialive.InputDeviceSummary/OutputType
     :cognitect.aws.medialive.InputDeviceSummary/UhdDeviceSettings
     :cognitect.aws.medialive.InputDeviceSummary/DeviceSettingsSyncState
     :cognitect.aws.medialive.InputDeviceSummary/Arn
     :cognitect.aws.medialive.InputDeviceSummary/SerialNumber
     :cognitect.aws.medialive.InputDeviceSummary/Name
     :cognitect.aws.medialive.InputDeviceSummary/Id]))

(s/def
  :cognitect.aws.medialive/StartMonitorDeploymentRequestContent
  (s/keys :opt-un [:cognitect.aws.medialive.StartMonitorDeploymentRequestContent/DryRun]))

(s/def
  :cognitect.aws.medialive/StartUpdateSignalMapResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Status
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/CreatedAt
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Name
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Id
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Arn
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/DiscoveryEntryPointArn
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/MonitorChangesPendingDeployment]
    :opt-un
    [:cognitect.aws.medialive.StartUpdateSignalMapResponseContent/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Tags
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/ErrorMessage
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/MonitorDeployment
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Description
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/ModifiedAt
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/FailedMediaResourceMap
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/MediaResourceMap
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/StartDeleteMonitorDeploymentResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Status
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/CreatedAt
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Name
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Id
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Arn
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/DiscoveryEntryPointArn
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/MonitorChangesPendingDeployment]
    :opt-un
    [:cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Tags
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/ErrorMessage
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/MonitorDeployment
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Description
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/ModifiedAt
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/FailedMediaResourceMap
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/MediaResourceMap
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/__listOfRouteCreateRequest
  (s/coll-of :cognitect.aws.medialive/RouteCreateRequest))

(s/def :cognitect.aws.medialive/DolbyVision81Settings (s/keys))

(s/def
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097
  (s/coll-of :cognitect.aws.medialive/__stringMin7Max11PatternAws097))

(s/def
  :cognitect.aws.medialive/__listOfAudioDescription
  (s/coll-of :cognitect.aws.medialive/AudioDescription))

(s/def
  :cognitect.aws.medialive/PurchaseOffering
  (s/keys
    :req-un
    [:cognitect.aws.medialive.PurchaseOffering/Count]
    :opt-un
    [:cognitect.aws.medialive.PurchaseOffering/RequestId
     :cognitect.aws.medialive.PurchaseOffering/RenewalSettings
     :cognitect.aws.medialive.PurchaseOffering/Start
     :cognitect.aws.medialive.PurchaseOffering/Tags
     :cognitect.aws.medialive.PurchaseOffering/Name]))

(s/def
  :cognitect.aws.medialive/InputLossBehavior
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputLossBehavior/InputLossImageSlate
     :cognitect.aws.medialive.InputLossBehavior/InputLossImageType
     :cognitect.aws.medialive.InputLossBehavior/InputLossImageColor
     :cognitect.aws.medialive.InputLossBehavior/BlackFrameMsec
     :cognitect.aws.medialive.InputLossBehavior/RepeatFrameMsec]))

(s/def
  :cognitect.aws.medialive/__listOfMultiplexProgramSummary
  (s/coll-of :cognitect.aws.medialive/MultiplexProgramSummary))

(s/def
  :cognitect.aws.medialive/Scte35DeliveryRestrictions
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35DeliveryRestrictions/DeviceRestrictions
     :cognitect.aws.medialive.Scte35DeliveryRestrictions/ArchiveAllowedFlag
     :cognitect.aws.medialive.Scte35DeliveryRestrictions/WebDeliveryAllowedFlag
     :cognitect.aws.medialive.Scte35DeliveryRestrictions/NoRegionalBlackoutFlag]))

(s/def
  :cognitect.aws.medialive/__listOfCloudWatchAlarmTemplateGroupSummary
  (s/coll-of :cognitect.aws.medialive/CloudWatchAlarmTemplateGroupSummary))

(s/def
  :cognitect.aws.medialive/Eac3PassthroughControl
  (s/spec string? :gen #(s/gen #{"WHEN_POSSIBLE" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/PurchaseOfferingRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.PurchaseOfferingRequest/OfferingId
     :cognitect.aws.medialive.PurchaseOfferingRequest/Count]
    :opt-un
    [:cognitect.aws.medialive.PurchaseOfferingRequest/RequestId
     :cognitect.aws.medialive.PurchaseOfferingRequest/RenewalSettings
     :cognitect.aws.medialive.PurchaseOfferingRequest/Start
     :cognitect.aws.medialive.PurchaseOfferingRequest/Tags
     :cognitect.aws.medialive.PurchaseOfferingRequest/Name]))

(s/def
  :cognitect.aws.medialive/CreateEventBridgeRuleTemplateRequestContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/EventType
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/Name
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/GroupIdentifier]
    :opt-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/RequestId
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/Tags
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/Description
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/EventTargets]))

(s/def
  :cognitect.aws.medialive/__doubleMin0Max1
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap
  (s/spec #(re-matches (re-pattern "^arn:.+:medialive:.+:signal-map:.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.medialive/UpdateChannelResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateChannelResultModel/Channel]))

(s/def
  :cognitect.aws.medialive/ListSdiSourcesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListSdiSourcesResponse/SdiSources
     :cognitect.aws.medialive.ListSdiSourcesResponse/NextToken]))

(s/def
  :cognitect.aws.medialive/GetEventBridgeRuleTemplateGroupResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/CreatedAt
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Id
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Arn
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Name]
    :opt-un
    [:cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Tags
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Description
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/DashRoleCaption
  (s/spec
    string?
    :gen
    #(s/gen
      #{"METADATA"
        "KARAOKE"
        "DESCRIPTION"
        "ALTERNATE"
        "MAIN"
        "EMERGENCY"
        "SUBTITLE"
        "DUB"
        "EASYREADER"
        "CAPTION"
        "SUPPLEMENTARY"
        "COMMENTARY"
        "FORCED-SUBTITLE"})))

(s/def :cognitect.aws.medialive/RejectInputDeviceTransferResponse (s/keys))

(s/def
  :cognitect.aws.medialive/DvbSubDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DvbSubDestinationSettings/OutlineColor
     :cognitect.aws.medialive.DvbSubDestinationSettings/OutlineSize
     :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowColor
     :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowOpacity
     :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowYOffset
     :cognitect.aws.medialive.DvbSubDestinationSettings/BackgroundColor
     :cognitect.aws.medialive.DvbSubDestinationSettings/TeletextGridControl
     :cognitect.aws.medialive.DvbSubDestinationSettings/YPosition
     :cognitect.aws.medialive.DvbSubDestinationSettings/FontColor
     :cognitect.aws.medialive.DvbSubDestinationSettings/XPosition
     :cognitect.aws.medialive.DvbSubDestinationSettings/Font
     :cognitect.aws.medialive.DvbSubDestinationSettings/FontResolution
     :cognitect.aws.medialive.DvbSubDestinationSettings/FontSize
     :cognitect.aws.medialive.DvbSubDestinationSettings/BackgroundOpacity
     :cognitect.aws.medialive.DvbSubDestinationSettings/FontOpacity
     :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowXOffset
     :cognitect.aws.medialive.DvbSubDestinationSettings/Alignment]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max500
  (s/spec (s/and int? #(<= 0 % 500)) :gen #(gen/choose 0 500)))

(s/def
  :cognitect.aws.medialive/FeatureActivations
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.FeatureActivations/InputPrepareScheduleActions
     :cognitect.aws.medialive.FeatureActivations/OutputStaticImageOverlayScheduleActions]))

(s/def
  :cognitect.aws.medialive/GetCloudWatchAlarmTemplateResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/TargetResourceType
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/TreatMissingData
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/ComparisonOperator
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/CreatedAt
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Period
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/EvaluationPeriods
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Name
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/GroupId
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/MetricName
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Statistic
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Id
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Arn
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Threshold]
    :opt-un
    [:cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Tags
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/DatapointsToAlarm
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Description
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/CmafIngestOutputSettings
  (s/keys :opt-un [:cognitect.aws.medialive.CmafIngestOutputSettings/NameModifier]))

(s/def
  :cognitect.aws.medialive/DeleteNodeResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteNodeResponse/ConnectionState
     :cognitect.aws.medialive.DeleteNodeResponse/ClusterId
     :cognitect.aws.medialive.DeleteNodeResponse/Role
     :cognitect.aws.medialive.DeleteNodeResponse/NodeInterfaceMappings
     :cognitect.aws.medialive.DeleteNodeResponse/SdiSourceMappings
     :cognitect.aws.medialive.DeleteNodeResponse/Arn
     :cognitect.aws.medialive.DeleteNodeResponse/State
     :cognitect.aws.medialive.DeleteNodeResponse/Name
     :cognitect.aws.medialive.DeleteNodeResponse/Id
     :cognitect.aws.medialive.DeleteNodeResponse/ChannelPlacementGroups
     :cognitect.aws.medialive.DeleteNodeResponse/InstanceArn]))

(s/def
  :cognitect.aws.medialive/UpdateChannelClassRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateChannelClassRequest/ChannelId
     :cognitect.aws.medialive.UpdateChannelClassRequest/ChannelClass]
    :opt-un
    [:cognitect.aws.medialive.UpdateChannelClassRequest/Destinations]))

(s/def
  :cognitect.aws.medialive/UpdateMultiplexRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateMultiplexRequest/MultiplexId]
    :opt-un
    [:cognitect.aws.medialive.UpdateMultiplexRequest/PacketIdentifiersMapping
     :cognitect.aws.medialive.UpdateMultiplexRequest/MultiplexSettings
     :cognitect.aws.medialive.UpdateMultiplexRequest/Name]))

(s/def
  :cognitect.aws.medialive/HlsClientCache
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/UpdateChannelClassResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateChannelClassResponse/Channel]))

(s/def
  :cognitect.aws.medialive/DescribeOfferingResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeOfferingResponse/DurationUnits
     :cognitect.aws.medialive.DescribeOfferingResponse/CurrencyCode
     :cognitect.aws.medialive.DescribeOfferingResponse/OfferingDescription
     :cognitect.aws.medialive.DescribeOfferingResponse/ResourceSpecification
     :cognitect.aws.medialive.DescribeOfferingResponse/FixedPrice
     :cognitect.aws.medialive.DescribeOfferingResponse/OfferingId
     :cognitect.aws.medialive.DescribeOfferingResponse/Duration
     :cognitect.aws.medialive.DescribeOfferingResponse/UsagePrice
     :cognitect.aws.medialive.DescribeOfferingResponse/Arn
     :cognitect.aws.medialive.DescribeOfferingResponse/OfferingType
     :cognitect.aws.medialive.DescribeOfferingResponse/Region]))

(s/def
  :cognitect.aws.medialive/CreateInput
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateInput/MediaConnectFlows
     :cognitect.aws.medialive.CreateInput/RequestId
     :cognitect.aws.medialive.CreateInput/Type
     :cognitect.aws.medialive.CreateInput/InputSecurityGroups
     :cognitect.aws.medialive.CreateInput/SdiSources
     :cognitect.aws.medialive.CreateInput/RoleArn
     :cognitect.aws.medialive.CreateInput/InputNetworkLocation
     :cognitect.aws.medialive.CreateInput/Tags
     :cognitect.aws.medialive.CreateInput/Smpte2110ReceiverGroupSettings
     :cognitect.aws.medialive.CreateInput/SrtSettings
     :cognitect.aws.medialive.CreateInput/MulticastSettings
     :cognitect.aws.medialive.CreateInput/InputDevices
     :cognitect.aws.medialive.CreateInput/Vpc
     :cognitect.aws.medialive.CreateInput/Destinations
     :cognitect.aws.medialive.CreateInput/Name
     :cognitect.aws.medialive.CreateInput/Sources]))

(s/def
  :cognitect.aws.medialive/DeleteClusterRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteClusterRequest/ClusterId]))

(s/def
  :cognitect.aws.medialive/BurnInDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BurnInDestinationSettings/OutlineColor
     :cognitect.aws.medialive.BurnInDestinationSettings/OutlineSize
     :cognitect.aws.medialive.BurnInDestinationSettings/ShadowColor
     :cognitect.aws.medialive.BurnInDestinationSettings/ShadowOpacity
     :cognitect.aws.medialive.BurnInDestinationSettings/ShadowYOffset
     :cognitect.aws.medialive.BurnInDestinationSettings/BackgroundColor
     :cognitect.aws.medialive.BurnInDestinationSettings/TeletextGridControl
     :cognitect.aws.medialive.BurnInDestinationSettings/YPosition
     :cognitect.aws.medialive.BurnInDestinationSettings/FontColor
     :cognitect.aws.medialive.BurnInDestinationSettings/XPosition
     :cognitect.aws.medialive.BurnInDestinationSettings/Font
     :cognitect.aws.medialive.BurnInDestinationSettings/FontResolution
     :cognitect.aws.medialive.BurnInDestinationSettings/FontSize
     :cognitect.aws.medialive.BurnInDestinationSettings/BackgroundOpacity
     :cognitect.aws.medialive.BurnInDestinationSettings/FontOpacity
     :cognitect.aws.medialive.BurnInDestinationSettings/ShadowXOffset
     :cognitect.aws.medialive.BurnInDestinationSettings/Alignment]))

(s/def
  :cognitect.aws.medialive/__listOfPipelineDetail
  (s/coll-of :cognitect.aws.medialive/PipelineDetail))

(s/def
  :cognitect.aws.medialive/MsSmoothOutputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MsSmoothOutputSettings/NameModifier
     :cognitect.aws.medialive.MsSmoothOutputSettings/H265PackagingType]))

(s/def
  :cognitect.aws.medialive/H264FilterSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.H264FilterSettings/TemporalFilterSettings
     :cognitect.aws.medialive.H264FilterSettings/BandwidthReductionFilterSettings]))

(s/def
  :cognitect.aws.medialive/InputDeviceState
  (s/spec string? :gen #(s/gen #{"STREAMING" "IDLE"})))

(s/def
  :cognitect.aws.medialive/RouteUpdateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.RouteUpdateRequest/Cidr
     :cognitect.aws.medialive.RouteUpdateRequest/Gateway]))

(s/def
  :cognitect.aws.medialive/EbuTtDDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.EbuTtDDestinationSettings/DefaultLineHeight
     :cognitect.aws.medialive.EbuTtDDestinationSettings/StyleControl
     :cognitect.aws.medialive.EbuTtDDestinationSettings/DefaultFontSize
     :cognitect.aws.medialive.EbuTtDDestinationSettings/FillLineGap
     :cognitect.aws.medialive.EbuTtDDestinationSettings/FontFamily
     :cognitect.aws.medialive.EbuTtDDestinationSettings/CopyrightHolder]))

(s/def
  :cognitect.aws.medialive/Eac3DrcRf
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def
  :cognitect.aws.medialive/NetworkInputServerValidation
  (s/spec
    string?
    :gen
    #(s/gen #{"CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME" "CHECK_CRYPTOGRAPHY_ONLY"})))

(s/def
  :cognitect.aws.medialive/__listOfValidationError
  (s/coll-of :cognitect.aws.medialive/ValidationError))

(s/def
  :cognitect.aws.medialive/__long
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.medialive/UpdateInputResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateInputResponse/Input]))

(s/def
  :cognitect.aws.medialive/VideoSelector
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.VideoSelector/SelectorSettings
     :cognitect.aws.medialive.VideoSelector/ColorSpace
     :cognitect.aws.medialive.VideoSelector/ColorSpaceUsage
     :cognitect.aws.medialive.VideoSelector/ColorSpaceSettings]))

(s/def
  :cognitect.aws.medialive/__listOfCaptionSelector
  (s/coll-of :cognitect.aws.medialive/CaptionSelector))

(s/def
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplateGroup
  (s/spec
    #(re-matches (re-pattern "^arn:.+:medialive:.+:eventbridge-rule-template-group:.+$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.medialive/__listOfVideoDescription
  (s/coll-of :cognitect.aws.medialive/VideoDescription))

(s/def
  :cognitect.aws.medialive/DeleteEventBridgeRuleTemplateGroupRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteEventBridgeRuleTemplateGroupRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/ValidationError
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ValidationError/ErrorMessage
     :cognitect.aws.medialive.ValidationError/ElementPath]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max4
  (s/spec (s/and int? #(<= 1 % 4)) :gen #(gen/choose 1 4)))

(s/def
  :cognitect.aws.medialive/Eac3SurroundMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "NOT_INDICATED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/__listOfInputDeviceConfigurableAudioChannelPairConfig
  (s/coll-of :cognitect.aws.medialive/InputDeviceConfigurableAudioChannelPairConfig))

(s/def
  :cognitect.aws.medialive/__listOfMediaPackageOutputDestinationSettings
  (s/coll-of :cognitect.aws.medialive/MediaPackageOutputDestinationSettings))

(s/def
  :cognitect.aws.medialive/__listOfSdiSourceSummary
  (s/coll-of :cognitect.aws.medialive/SdiSourceSummary))

(s/def
  :cognitect.aws.medialive/AudioWatermarkSettings
  (s/keys :opt-un [:cognitect.aws.medialive.AudioWatermarkSettings/NielsenWatermarksSettings]))

(s/def
  :cognitect.aws.medialive/CloudWatchAlarmTemplateSummary
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/TargetResourceType
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/TreatMissingData
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/ComparisonOperator
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/CreatedAt
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Period
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/EvaluationPeriods
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Name
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/GroupId
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/MetricName
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Statistic
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Id
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Arn
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Threshold]
    :opt-un
    [:cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Tags
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/DatapointsToAlarm
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Description
     :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/EncoderSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.EncoderSettings/VideoDescriptions
     :cognitect.aws.medialive.EncoderSettings/AudioDescriptions
     :cognitect.aws.medialive.EncoderSettings/OutputGroups
     :cognitect.aws.medialive.EncoderSettings/TimecodeConfig]
    :opt-un
    [:cognitect.aws.medialive.EncoderSettings/ColorCorrectionSettings
     :cognitect.aws.medialive.EncoderSettings/GlobalConfiguration
     :cognitect.aws.medialive.EncoderSettings/CaptionDescriptions
     :cognitect.aws.medialive.EncoderSettings/ThumbnailConfiguration
     :cognitect.aws.medialive.EncoderSettings/AvailConfiguration
     :cognitect.aws.medialive.EncoderSettings/BlackoutSlate
     :cognitect.aws.medialive.EncoderSettings/MotionGraphicsConfiguration
     :cognitect.aws.medialive.EncoderSettings/NielsenConfiguration
     :cognitect.aws.medialive.EncoderSettings/FeatureActivations
     :cognitect.aws.medialive.EncoderSettings/AvailBlanking]))

(s/def
  :cognitect.aws.medialive/ReservationMaximumFramerate
  (s/spec string? :gen #(s/gen #{"MAX_30_FPS" "MAX_60_FPS"})))

(s/def :cognitect.aws.medialive/__listOfRoute (s/coll-of :cognitect.aws.medialive/Route))

(s/def
  :cognitect.aws.medialive/RestartChannelPipelinesRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.RestartChannelPipelinesRequest/ChannelId]
    :opt-un
    [:cognitect.aws.medialive.RestartChannelPipelinesRequest/PipelineIds]))

(s/def
  :cognitect.aws.medialive/InputDeviceThumbnail
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.medialive/UpdateChannelClass
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateChannelClass/ChannelClass]
    :opt-un
    [:cognitect.aws.medialive.UpdateChannelClass/Destinations]))

(s/def
  :cognitect.aws.medialive/__listOfReservation
  (s/coll-of :cognitect.aws.medialive/Reservation))

(s/def
  :cognitect.aws.medialive/__integerMinNegative60Max6
  (s/spec (s/and int? #(<= -60 % 6)) :gen #(gen/choose -60 6)))

(s/def
  :cognitect.aws.medialive/__listOfInterfaceMappingUpdateRequest
  (s/coll-of :cognitect.aws.medialive/InterfaceMappingUpdateRequest))

(s/def
  :cognitect.aws.medialive/MaintenanceUpdateSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MaintenanceUpdateSettings/MaintenanceStartTime
     :cognitect.aws.medialive.MaintenanceUpdateSettings/MaintenanceScheduledDate
     :cognitect.aws.medialive.MaintenanceUpdateSettings/MaintenanceDay]))

(s/def :cognitect.aws.medialive/__listOfThumbnail (s/coll-of :cognitect.aws.medialive/Thumbnail))

(s/def
  :cognitect.aws.medialive/MultiplexPacketIdentifiersMapping
  (s/map-of
    :cognitect.aws.medialive/__string
    :cognitect.aws.medialive/MultiplexProgramPacketIdentifiersMap))

(s/def
  :cognitect.aws.medialive/DeleteMultiplexProgramRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DeleteMultiplexProgramRequest/MultiplexId
     :cognitect.aws.medialive.DeleteMultiplexProgramRequest/ProgramName]))

(s/def
  :cognitect.aws.medialive/M2tsNielsenId3Behavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/ListClustersResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListClustersResult/NextToken
     :cognitect.aws.medialive.ListClustersResult/Clusters]))

(s/def
  :cognitect.aws.medialive/TimecodeConfigSource
  (s/spec string? :gen #(s/gen #{"ZEROBASED" "EMBEDDED" "SYSTEMCLOCK"})))

(s/def
  :cognitect.aws.medialive/StartUpdateSignalMapRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StartUpdateSignalMapRequest/Identifier]
    :opt-un
    [:cognitect.aws.medialive.StartUpdateSignalMapRequest/ForceRediscovery
     :cognitect.aws.medialive.StartUpdateSignalMapRequest/EventBridgeRuleTemplateGroupIdentifiers
     :cognitect.aws.medialive.StartUpdateSignalMapRequest/CloudWatchAlarmTemplateGroupIdentifiers
     :cognitect.aws.medialive.StartUpdateSignalMapRequest/DiscoveryEntryPointArn
     :cognitect.aws.medialive.StartUpdateSignalMapRequest/Description
     :cognitect.aws.medialive.StartUpdateSignalMapRequest/Name]))

(s/def
  :cognitect.aws.medialive/Smpte2110ReceiverGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Smpte2110ReceiverGroupSettings/Smpte2110ReceiverGroups]))

(s/def
  :cognitect.aws.medialive/WavCodingMode
  (s/spec
    string?
    :gen
    #(s/gen #{"CODING_MODE_1_0" "CODING_MODE_4_0" "CODING_MODE_8_0" "CODING_MODE_2_0"})))

(s/def
  :cognitect.aws.medialive/__longMin0Max86400000
  (s/spec (s/and int? #(<= 0 % 86400000)) :gen #(gen/choose 0 86400000)))

(s/def
  :cognitect.aws.medialive/PurchaseOfferingResponse
  (s/keys :opt-un [:cognitect.aws.medialive.PurchaseOfferingResponse/Reservation]))

(s/def
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MEDIAPACKAGE_CHANNEL"
        "MEDIAPACKAGE_ORIGIN_ENDPOINT"
        "MEDIALIVE_CHANNEL"
        "MEDIALIVE_MULTIPLEX"
        "MEDIALIVE_INPUT_DEVICE"
        "MEDIACONNECT_FLOW"
        "CLOUDFRONT_DISTRIBUTION"
        "S3_BUCKET"
        "MEDIATAILOR_PLAYBACK_CONFIGURATION"})))

(s/def
  :cognitect.aws.medialive/InputDeviceUhdSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceUhdSettings/Codec
     :cognitect.aws.medialive.InputDeviceUhdSettings/Framerate
     :cognitect.aws.medialive.InputDeviceUhdSettings/ScanType
     :cognitect.aws.medialive.InputDeviceUhdSettings/AudioChannelPairs
     :cognitect.aws.medialive.InputDeviceUhdSettings/ConfiguredInput
     :cognitect.aws.medialive.InputDeviceUhdSettings/Width
     :cognitect.aws.medialive.InputDeviceUhdSettings/LatencyMs
     :cognitect.aws.medialive.InputDeviceUhdSettings/Height
     :cognitect.aws.medialive.InputDeviceUhdSettings/MaxBitrate
     :cognitect.aws.medialive.InputDeviceUhdSettings/DeviceState
     :cognitect.aws.medialive.InputDeviceUhdSettings/MediaconnectSettings
     :cognitect.aws.medialive.InputDeviceUhdSettings/ActiveInput
     :cognitect.aws.medialive.InputDeviceUhdSettings/InputResolution]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max65536
  (s/spec (s/and int? #(<= 0 % 65536)) :gen #(gen/choose 0 65536)))

(s/def
  :cognitect.aws.medialive/ListNodesRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ListNodesRequest/ClusterId]
    :opt-un
    [:cognitect.aws.medialive.ListNodesRequest/NextToken
     :cognitect.aws.medialive.ListNodesRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/__integerMin100000Max100000000
  (s/spec (s/and int? #(<= 100000 % 100000000)) :gen #(gen/choose 100000 100000000)))

(s/def
  :cognitect.aws.medialive/AacCodingMode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AD_RECEIVER_MIX"
        "CODING_MODE_1_0"
        "CODING_MODE_1_1"
        "CODING_MODE_2_0"
        "CODING_MODE_5_1"})))

(s/def
  :cognitect.aws.medialive/CreateCloudWatchAlarmTemplateGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequest/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequest/RequestId
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequest/Tags
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequest/Description]))

(s/def
  :cognitect.aws.medialive/InputLossFailoverSettings
  (s/keys :opt-un [:cognitect.aws.medialive.InputLossFailoverSettings/InputLossThresholdMsec]))

(s/def :cognitect.aws.medialive/ColorSpacePassthroughSettings (s/keys))

(s/def
  :cognitect.aws.medialive/InputSource
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSource/Username
     :cognitect.aws.medialive.InputSource/Url
     :cognitect.aws.medialive.InputSource/PasswordParam]))

(s/def
  :cognitect.aws.medialive/GetEventBridgeRuleTemplateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Tags
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/GroupId
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/EventType
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Description
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/EventTargets
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/ModifiedAt
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Arn
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/CreatedAt
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Name
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Id]))

(s/def
  :cognitect.aws.medialive/__listOfIpPoolUpdateRequest
  (s/coll-of :cognitect.aws.medialive/IpPoolUpdateRequest))

(s/def
  :cognitect.aws.medialive/GetEventBridgeRuleTemplateGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Tags
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Description
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/ModifiedAt
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Arn
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/CreatedAt
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Name
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Id]))

(s/def
  :cognitect.aws.medialive/UpdateMultiplexProgramResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateMultiplexProgramResponse/MultiplexProgram]))

(s/def
  :cognitect.aws.medialive/__integerMinNegative5Max5
  (s/spec (s/and int? #(<= -5 % 5)) :gen #(gen/choose -5 5)))

(s/def
  :cognitect.aws.medialive/Scte27OcrLanguage
  (s/spec string? :gen #(s/gen #{"POR" "DEU" "FRA" "NLD" "ENG" "SPA"})))

(s/def
  :cognitect.aws.medialive/M2tsTimedMetadataBehavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/ListCloudWatchAlarmTemplatesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/NextToken
     :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/GroupIdentifier
     :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/MaxResults
     :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/SignalMapIdentifier
     :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/Scope]))

(s/def
  :cognitect.aws.medialive/CreateCloudWatchAlarmTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/TargetResourceType
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/MetricName
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/TreatMissingData
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/ComparisonOperator
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Statistic
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Period
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/EvaluationPeriods
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Threshold
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Name
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/GroupIdentifier]
    :opt-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/RequestId
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Tags
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/DatapointsToAlarm
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Description]))

(s/def
  :cognitect.aws.medialive/ListMultiplexProgramsResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListMultiplexProgramsResultModel/NextToken
     :cognitect.aws.medialive.ListMultiplexProgramsResultModel/MultiplexPrograms]))

(s/def
  :cognitect.aws.medialive/__double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/StartMultiplexRequest
  (s/keys :req-un [:cognitect.aws.medialive.StartMultiplexRequest/MultiplexId]))

(s/def
  :cognitect.aws.medialive/AudioTrackSelection
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioTrackSelection/Tracks]
    :opt-un
    [:cognitect.aws.medialive.AudioTrackSelection/DolbyEDecode]))

(s/def
  :cognitect.aws.medialive/__stringMin32Max32
  (s/spec
    (s/and string? #(<= 32 (count %) 32))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 32 32) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/H264EntropyEncoding
  (s/spec string? :gen #(s/gen #{"CABAC" "CAVLC"})))

(s/def
  :cognitect.aws.medialive/H265RateControlMode
  (s/spec string? :gen #(s/gen #{"CBR" "QVBR" "MULTIPLEX"})))

(s/def :cognitect.aws.medialive/AribSourceSettings (s/keys))

(s/def
  :cognitect.aws.medialive/H265FilterSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.H265FilterSettings/TemporalFilterSettings
     :cognitect.aws.medialive.H265FilterSettings/BandwidthReductionFilterSettings]))

(s/def
  :cognitect.aws.medialive/__integerMin80Max800
  (s/spec (s/and int? #(<= 80 % 800)) :gen #(gen/choose 80 800)))

(s/def
  :cognitect.aws.medialive/InputRequestDestinationRoute
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputRequestDestinationRoute/Cidr
     :cognitect.aws.medialive.InputRequestDestinationRoute/Gateway]))

(s/def
  :cognitect.aws.medialive/ListChannelPlacementGroupsRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ListChannelPlacementGroupsRequest/ClusterId]
    :opt-un
    [:cognitect.aws.medialive.ListChannelPlacementGroupsRequest/NextToken
     :cognitect.aws.medialive.ListChannelPlacementGroupsRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/ChannelEngineVersionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ChannelEngineVersionResponse/ExpirationDate
     :cognitect.aws.medialive.ChannelEngineVersionResponse/Version]))

(s/def
  :cognitect.aws.medialive/HlsDirectoryStructure
  (s/spec string? :gen #(s/gen #{"SINGLE_DIRECTORY" "SUBDIRECTORY_PER_STREAM"})))

(s/def
  :cognitect.aws.medialive/CreateClusterResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateClusterResponse/NetworkSettings
     :cognitect.aws.medialive.CreateClusterResponse/ClusterType
     :cognitect.aws.medialive.CreateClusterResponse/Arn
     :cognitect.aws.medialive.CreateClusterResponse/InstanceRoleArn
     :cognitect.aws.medialive.CreateClusterResponse/State
     :cognitect.aws.medialive.CreateClusterResponse/Name
     :cognitect.aws.medialive.CreateClusterResponse/ChannelIds
     :cognitect.aws.medialive.CreateClusterResponse/Id]))

(s/def
  :cognitect.aws.medialive/__doubleMin250Max5000
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/H265AdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"AUTO" "LOW" "MAX" "HIGHER" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.medialive/HlsStreamInfResolution
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.medialive/Scte35DeviceRestrictions
  (s/spec string? :gen #(s/gen #{"RESTRICT_GROUP1" "RESTRICT_GROUP0" "RESTRICT_GROUP2" "NONE"})))

(s/def
  :cognitect.aws.medialive/ListSignalMapsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListSignalMapsRequest/EventBridgeRuleTemplateGroupIdentifier
     :cognitect.aws.medialive.ListSignalMapsRequest/NextToken
     :cognitect.aws.medialive.ListSignalMapsRequest/CloudWatchAlarmTemplateGroupIdentifier
     :cognitect.aws.medialive.ListSignalMapsRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/Mpeg2TimecodeInsertionBehavior
  (s/spec string? :gen #(s/gen #{"DISABLED" "GOP_TIMECODE"})))

(s/def
  :cognitect.aws.medialive/__listOfInputAttachment
  (s/coll-of :cognitect.aws.medialive/InputAttachment))

(s/def
  :cognitect.aws.medialive/BatchStartRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchStartRequest/MultiplexIds
     :cognitect.aws.medialive.BatchStartRequest/ChannelIds]))

(s/def
  :cognitect.aws.medialive/Scte35Descriptor
  (s/keys :req-un [:cognitect.aws.medialive.Scte35Descriptor/Scte35DescriptorSettings]))

(s/def
  :cognitect.aws.medialive/StartMonitorDeploymentRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StartMonitorDeploymentRequest/Identifier]
    :opt-un
    [:cognitect.aws.medialive.StartMonitorDeploymentRequest/DryRun]))

(s/def
  :cognitect.aws.medialive/ListVersionsResponse
  (s/keys :opt-un [:cognitect.aws.medialive.ListVersionsResponse/Versions]))

(s/def
  :cognitect.aws.medialive/EbuTtDDestinationStyleControl
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.medialive/ArchiveGroupSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ArchiveGroupSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.ArchiveGroupSettings/ArchiveCdnSettings
     :cognitect.aws.medialive.ArchiveGroupSettings/RolloverInterval]))

(s/def
  :cognitect.aws.medialive/AudioHlsRenditionSelection
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioHlsRenditionSelection/Name
     :cognitect.aws.medialive.AudioHlsRenditionSelection/GroupId]))

(s/def
  :cognitect.aws.medialive/InputClippingSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.InputClippingSettings/InputTimecodeSource]
    :opt-un
    [:cognitect.aws.medialive.InputClippingSettings/StopTimecode
     :cognitect.aws.medialive.InputClippingSettings/StartTimecode]))

(s/def
  :cognitect.aws.medialive/ThumbnailType
  (s/spec string? :gen #(s/gen #{"CURRENT_ACTIVE" "UNSPECIFIED"})))

(s/def
  :cognitect.aws.medialive/CreatePartnerInputResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreatePartnerInputResponse/Input]))

(s/def
  :cognitect.aws.medialive/__listOfCaptionLanguageMapping
  (s/coll-of :cognitect.aws.medialive/CaptionLanguageMapping))

(s/def
  :cognitect.aws.medialive/CreateClusterRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateClusterRequest/NetworkSettings
     :cognitect.aws.medialive.CreateClusterRequest/RequestId
     :cognitect.aws.medialive.CreateClusterRequest/Tags
     :cognitect.aws.medialive.CreateClusterRequest/ClusterType
     :cognitect.aws.medialive.CreateClusterRequest/InstanceRoleArn
     :cognitect.aws.medialive.CreateClusterRequest/Name]))

(s/def
  :cognitect.aws.medialive/Input
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Input/MediaConnectFlows
     :cognitect.aws.medialive.Input/InputClass
     :cognitect.aws.medialive.Input/Type
     :cognitect.aws.medialive.Input/SecurityGroups
     :cognitect.aws.medialive.Input/SdiSources
     :cognitect.aws.medialive.Input/RoleArn
     :cognitect.aws.medialive.Input/InputNetworkLocation
     :cognitect.aws.medialive.Input/Tags
     :cognitect.aws.medialive.Input/Smpte2110ReceiverGroupSettings
     :cognitect.aws.medialive.Input/SrtSettings
     :cognitect.aws.medialive.Input/MulticastSettings
     :cognitect.aws.medialive.Input/InputPartnerIds
     :cognitect.aws.medialive.Input/InputDevices
     :cognitect.aws.medialive.Input/Arn
     :cognitect.aws.medialive.Input/InputSourceType
     :cognitect.aws.medialive.Input/State
     :cognitect.aws.medialive.Input/Destinations
     :cognitect.aws.medialive.Input/Name
     :cognitect.aws.medialive.Input/Sources
     :cognitect.aws.medialive.Input/AttachedChannels
     :cognitect.aws.medialive.Input/Id]))

(s/def
  :cognitect.aws.medialive/Esam
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Esam/AcquisitionPointId :cognitect.aws.medialive.Esam/PoisEndpoint]
    :opt-un
    [:cognitect.aws.medialive.Esam/Username
     :cognitect.aws.medialive.Esam/PasswordParam
     :cognitect.aws.medialive.Esam/AdAvailOffset
     :cognitect.aws.medialive.Esam/ZoneIdentity]))

(s/def
  :cognitect.aws.medialive/DeleteMultiplexProgramResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteMultiplexProgramResponse/ProgramName
     :cognitect.aws.medialive.DeleteMultiplexProgramResponse/ChannelId
     :cognitect.aws.medialive.DeleteMultiplexProgramResponse/PipelineDetails
     :cognitect.aws.medialive.DeleteMultiplexProgramResponse/PacketIdentifiersMap
     :cognitect.aws.medialive.DeleteMultiplexProgramResponse/MultiplexProgramSettings]))

(s/def
  :cognitect.aws.medialive/__listOfInputRequestDestinationRoute
  (s/coll-of :cognitect.aws.medialive/InputRequestDestinationRoute))

(s/def
  :cognitect.aws.medialive/InternalServerErrorExceptionResponseContent
  (s/keys :opt-un [:cognitect.aws.medialive.InternalServerErrorExceptionResponseContent/Message]))

(s/def
  :cognitect.aws.medialive/UpdateInputSecurityGroupResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateInputSecurityGroupResultModel/SecurityGroup]))

(s/def
  :cognitect.aws.medialive/H265ColorMetadata
  (s/spec string? :gen #(s/gen #{"INSERT" "IGNORE"})))

(s/def
  :cognitect.aws.medialive/DescribeNetworkSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeNetworkSummary/Routes
     :cognitect.aws.medialive.DescribeNetworkSummary/IpPools
     :cognitect.aws.medialive.DescribeNetworkSummary/AssociatedClusterIds
     :cognitect.aws.medialive.DescribeNetworkSummary/Arn
     :cognitect.aws.medialive.DescribeNetworkSummary/State
     :cognitect.aws.medialive.DescribeNetworkSummary/Name
     :cognitect.aws.medialive.DescribeNetworkSummary/Id]))

(s/def
  :cognitect.aws.medialive/InputDeblockFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/DeleteReservationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteReservationResponse/DurationUnits
     :cognitect.aws.medialive.DeleteReservationResponse/CurrencyCode
     :cognitect.aws.medialive.DeleteReservationResponse/OfferingDescription
     :cognitect.aws.medialive.DeleteReservationResponse/RenewalSettings
     :cognitect.aws.medialive.DeleteReservationResponse/ResourceSpecification
     :cognitect.aws.medialive.DeleteReservationResponse/Start
     :cognitect.aws.medialive.DeleteReservationResponse/FixedPrice
     :cognitect.aws.medialive.DeleteReservationResponse/End
     :cognitect.aws.medialive.DeleteReservationResponse/Count
     :cognitect.aws.medialive.DeleteReservationResponse/Tags
     :cognitect.aws.medialive.DeleteReservationResponse/OfferingId
     :cognitect.aws.medialive.DeleteReservationResponse/Duration
     :cognitect.aws.medialive.DeleteReservationResponse/UsagePrice
     :cognitect.aws.medialive.DeleteReservationResponse/Arn
     :cognitect.aws.medialive.DeleteReservationResponse/State
     :cognitect.aws.medialive.DeleteReservationResponse/OfferingType
     :cognitect.aws.medialive.DeleteReservationResponse/Name
     :cognitect.aws.medialive.DeleteReservationResponse/ReservationId
     :cognitect.aws.medialive.DeleteReservationResponse/Region]))

(s/def
  :cognitect.aws.medialive/NielsenConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.NielsenConfiguration/NielsenPcmToId3Tagging
     :cognitect.aws.medialive.NielsenConfiguration/DistributorId]))

(s/def :cognitect.aws.medialive/RebootInputDeviceResponse (s/keys))

(s/def
  :cognitect.aws.medialive/Route
  (s/keys :opt-un [:cognitect.aws.medialive.Route/Cidr :cognitect.aws.medialive.Route/Gateway]))

(s/def
  :cognitect.aws.medialive/HlsProgramDateTimeClock
  (s/spec string? :gen #(s/gen #{"SYSTEM_CLOCK" "INITIALIZE_FROM_OUTPUT_TIMECODE"})))

(s/def
  :cognitect.aws.medialive/GetCloudWatchAlarmTemplateGroupResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/CreatedAt
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Id
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Arn
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Name]
    :opt-un
    [:cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Tags
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Description
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/LimitExceeded
  (s/keys :opt-un [:cognitect.aws.medialive.LimitExceeded/Message]))

(s/def
  :cognitect.aws.medialive/HlsTsFileMode
  (s/spec string? :gen #(s/gen #{"SINGLE_FILE" "SEGMENTED_FILES"})))

(s/def
  :cognitect.aws.medialive/CmafTimedMetadataId3Frame
  (s/spec string? :gen #(s/gen #{"TDRL" "NONE" "PRIV"})))

(s/def
  :cognitect.aws.medialive/__stringMin34Max34
  (s/spec
    (s/and string? #(<= 34 (count %) 34))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 34 34) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/Scte20Convert608To708
  (s/spec string? :gen #(s/gen #{"DISABLED" "UPCONVERT"})))

(s/def :cognitect.aws.medialive/HtmlMotionGraphicsSettings (s/keys))

(s/def
  :cognitect.aws.medialive/__integerMin1Max800
  (s/spec (s/and int? #(<= 1 % 800)) :gen #(gen/choose 1 800)))

(s/def
  :cognitect.aws.medialive/BatchStopResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchStopResponse/Failed
     :cognitect.aws.medialive.BatchStopResponse/Successful]))

(s/def
  :cognitect.aws.medialive/TimedMetadataScheduleActionSettings
  (s/keys :req-un [:cognitect.aws.medialive.TimedMetadataScheduleActionSettings/Id3]))

(s/def
  :cognitect.aws.medialive/__listOfSrtCallerSourceRequest
  (s/coll-of :cognitect.aws.medialive/SrtCallerSourceRequest))

(s/def
  :cognitect.aws.medialive/UpdateClusterResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateClusterResult/NetworkSettings
     :cognitect.aws.medialive.UpdateClusterResult/ClusterType
     :cognitect.aws.medialive.UpdateClusterResult/Arn
     :cognitect.aws.medialive.UpdateClusterResult/State
     :cognitect.aws.medialive.UpdateClusterResult/Name
     :cognitect.aws.medialive.UpdateClusterResult/ChannelIds
     :cognitect.aws.medialive.UpdateClusterResult/Id]))

(s/def
  :cognitect.aws.medialive/ReservationVideoQuality
  (s/spec string? :gen #(s/gen #{"ENHANCED" "STANDARD" "PREMIUM"})))

(s/def :cognitect.aws.medialive/RebootInputDeviceForce (s/spec string? :gen #(s/gen #{"NO" "YES"})))

(s/def
  :cognitect.aws.medialive/AudioType
  (s/spec
    string?
    :gen
    #(s/gen #{"VISUAL_IMPAIRED_COMMENTARY" "UNDEFINED" "HEARING_IMPAIRED" "CLEAN_EFFECTS"})))

(s/def
  :cognitect.aws.medialive/NetworkInterfaceMode
  (s/spec string? :gen #(s/gen #{"BRIDGE" "NAT"})))

(s/def
  :cognitect.aws.medialive/__integerMin32Max8191
  (s/spec (s/and int? #(<= 32 % 8191)) :gen #(gen/choose 32 8191)))

(s/def
  :cognitect.aws.medialive/__integerMin1Max8
  (s/spec (s/and int? #(<= 1 % 8)) :gen #(gen/choose 1 8)))

(s/def
  :cognitect.aws.medialive/CmafTimedMetadataPassthrough
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/DvbSubOcrLanguage
  (s/spec string? :gen #(s/gen #{"POR" "DEU" "FRA" "NLD" "ENG" "SPA"})))

(s/def
  :cognitect.aws.medialive/Tags
  (s/map-of :cognitect.aws.medialive/__string :cognitect.aws.medialive/__string))

(s/def
  :cognitect.aws.medialive/H265MvTemporalPredictor
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/CreateCloudWatchAlarmTemplateGroupResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/CreatedAt
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Id
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Arn
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Tags
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Description
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/DescribeNodeSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeNodeSummary/ConnectionState
     :cognitect.aws.medialive.DescribeNodeSummary/ClusterId
     :cognitect.aws.medialive.DescribeNodeSummary/Role
     :cognitect.aws.medialive.DescribeNodeSummary/NodeInterfaceMappings
     :cognitect.aws.medialive.DescribeNodeSummary/ManagedInstanceId
     :cognitect.aws.medialive.DescribeNodeSummary/SdiSourceMappings
     :cognitect.aws.medialive.DescribeNodeSummary/Arn
     :cognitect.aws.medialive.DescribeNodeSummary/State
     :cognitect.aws.medialive.DescribeNodeSummary/Name
     :cognitect.aws.medialive.DescribeNodeSummary/Id
     :cognitect.aws.medialive.DescribeNodeSummary/ChannelPlacementGroups
     :cognitect.aws.medialive.DescribeNodeSummary/InstanceArn]))

(s/def :cognitect.aws.medialive/SdiSourceType (s/spec string? :gen #(s/gen #{"SINGLE" "QUAD"})))

(s/def
  :cognitect.aws.medialive/AacSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AacSettings/RateControlMode
     :cognitect.aws.medialive.AacSettings/CodingMode
     :cognitect.aws.medialive.AacSettings/InputType
     :cognitect.aws.medialive.AacSettings/SampleRate
     :cognitect.aws.medialive.AacSettings/Spec
     :cognitect.aws.medialive.AacSettings/VbrQuality
     :cognitect.aws.medialive.AacSettings/Profile
     :cognitect.aws.medialive.AacSettings/RawFormat
     :cognitect.aws.medialive.AacSettings/Bitrate]))

(s/def
  :cognitect.aws.medialive/FrameCaptureS3LogUploads
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def :cognitect.aws.medialive/Rec709Settings (s/keys))

(s/def
  :cognitect.aws.medialive/__listOfTransferringInputDeviceSummary
  (s/coll-of :cognitect.aws.medialive/TransferringInputDeviceSummary))

(s/def
  :cognitect.aws.medialive/DescribeClusterResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeClusterResult/NetworkSettings
     :cognitect.aws.medialive.DescribeClusterResult/ClusterType
     :cognitect.aws.medialive.DescribeClusterResult/Arn
     :cognitect.aws.medialive.DescribeClusterResult/InstanceRoleArn
     :cognitect.aws.medialive.DescribeClusterResult/State
     :cognitect.aws.medialive.DescribeClusterResult/Name
     :cognitect.aws.medialive.DescribeClusterResult/ChannelIds
     :cognitect.aws.medialive.DescribeClusterResult/Id]))

(s/def
  :cognitect.aws.medialive/InputDeviceMediaConnectSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceMediaConnectSettings/RoleArn
     :cognitect.aws.medialive.InputDeviceMediaConnectSettings/SecretArn
     :cognitect.aws.medialive.InputDeviceMediaConnectSettings/SourceName
     :cognitect.aws.medialive.InputDeviceMediaConnectSettings/FlowArn]))

(s/def
  :cognitect.aws.medialive/StartMonitorDeploymentResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StartMonitorDeploymentResponse/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/Tags
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/Status
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/ErrorMessage
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/MonitorDeployment
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/DiscoveryEntryPointArn
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/Description
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/ModifiedAt
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/Arn
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/CreatedAt
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/FailedMediaResourceMap
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/Name
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/MediaResourceMap
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/MonitorChangesPendingDeployment
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/Id
     :cognitect.aws.medialive.StartMonitorDeploymentResponse/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/__listOfCloudWatchAlarmTemplateSummary
  (s/coll-of :cognitect.aws.medialive/CloudWatchAlarmTemplateSummary))

(s/def
  :cognitect.aws.medialive/__integerMin50000Max12000000
  (s/spec (s/and int? #(<= 50000 % 12000000)) :gen #(gen/choose 50000 12000000)))

(s/def
  :cognitect.aws.medialive/__listOfRtmpAdMarkers
  (s/coll-of :cognitect.aws.medialive/RtmpAdMarkers))

(s/def
  :cognitect.aws.medialive/ReservationAutomaticRenewal
  (s/spec string? :gen #(s/gen #{"DISABLED" "UNAVAILABLE" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/__stringMax1000
  (s/spec
    (s/and string? #(>= 1000 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/HlsIvInManifest
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.medialive/AcceptInputDeviceTransferRequest
  (s/keys :req-un [:cognitect.aws.medialive.AcceptInputDeviceTransferRequest/InputDeviceId]))

(s/def
  :cognitect.aws.medialive/StartChannelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StartChannelResponse/ChannelClass
     :cognitect.aws.medialive.StartChannelResponse/InputAttachments
     :cognitect.aws.medialive.StartChannelResponse/PipelinesRunningCount
     :cognitect.aws.medialive.StartChannelResponse/LogLevel
     :cognitect.aws.medialive.StartChannelResponse/RoleArn
     :cognitect.aws.medialive.StartChannelResponse/Tags
     :cognitect.aws.medialive.StartChannelResponse/PipelineDetails
     :cognitect.aws.medialive.StartChannelResponse/AnywhereSettings
     :cognitect.aws.medialive.StartChannelResponse/EgressEndpoints
     :cognitect.aws.medialive.StartChannelResponse/CdiInputSpecification
     :cognitect.aws.medialive.StartChannelResponse/EncoderSettings
     :cognitect.aws.medialive.StartChannelResponse/Vpc
     :cognitect.aws.medialive.StartChannelResponse/Arn
     :cognitect.aws.medialive.StartChannelResponse/InputSpecification
     :cognitect.aws.medialive.StartChannelResponse/ChannelEngineVersion
     :cognitect.aws.medialive.StartChannelResponse/State
     :cognitect.aws.medialive.StartChannelResponse/Destinations
     :cognitect.aws.medialive.StartChannelResponse/Name
     :cognitect.aws.medialive.StartChannelResponse/Maintenance
     :cognitect.aws.medialive.StartChannelResponse/Id]))

(s/def
  :cognitect.aws.medialive/__listOfMulticastSource
  (s/coll-of :cognitect.aws.medialive/MulticastSource))

(s/def
  :cognitect.aws.medialive/__integerMin100
  (s/spec (s/and int? #(<= 100 %)) :gen #(gen/choose 100 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.medialive/MonitorDeployment
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MonitorDeployment/Status]
    :opt-un
    [:cognitect.aws.medialive.MonitorDeployment/ErrorMessage
     :cognitect.aws.medialive.MonitorDeployment/DetailsUri]))

(s/def
  :cognitect.aws.medialive/__stringMin1Max256
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/__listOfAdditionalDestinations
  (s/coll-of :cognitect.aws.medialive/AdditionalDestinations))

(s/def
  :cognitect.aws.medialive/EmbeddedScte20Detection
  (s/spec string? :gen #(s/gen #{"AUTO" "OFF"})))

(s/def
  :cognitect.aws.medialive/DescribeMultiplexProgramRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DescribeMultiplexProgramRequest/MultiplexId
     :cognitect.aws.medialive.DescribeMultiplexProgramRequest/ProgramName]))

(s/def
  :cognitect.aws.medialive/__listOfMulticastSourceCreateRequest
  (s/coll-of :cognitect.aws.medialive/MulticastSourceCreateRequest))

(s/def
  :cognitect.aws.medialive/HlsMediaStoreStorageClass
  (s/spec string? :gen #(s/gen #{"TEMPORAL"})))

(s/def :cognitect.aws.medialive/H264Syntax (s/spec string? :gen #(s/gen #{"RP2027" "DEFAULT"})))

(s/def
  :cognitect.aws.medialive/DeleteCloudWatchAlarmTemplateRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteCloudWatchAlarmTemplateRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/AudioTrack
  (s/keys :req-un [:cognitect.aws.medialive.AudioTrack/Track]))

(s/def
  :cognitect.aws.medialive/ColorCorrectionSettings
  (s/keys :req-un [:cognitect.aws.medialive.ColorCorrectionSettings/GlobalColorCorrections]))

(s/def
  :cognitect.aws.medialive/__listOfMediaConnectFlowRequest
  (s/coll-of :cognitect.aws.medialive/MediaConnectFlowRequest))

(s/def :cognitect.aws.medialive/TeletextDestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/AacInputType
  (s/spec string? :gen #(s/gen #{"NORMAL" "BROADCASTER_MIXED_AD"})))

(s/def
  :cognitect.aws.medialive/FrameCaptureCdnSettings
  (s/keys :opt-un [:cognitect.aws.medialive.FrameCaptureCdnSettings/FrameCaptureS3Settings]))

(s/def
  :cognitect.aws.medialive/BurnInShadowColor
  (s/spec string? :gen #(s/gen #{"NONE" "WHITE" "BLACK"})))

(s/def
  :cognitect.aws.medialive/BatchStop
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchStop/MultiplexIds
     :cognitect.aws.medialive.BatchStop/ChannelIds]))

(s/def
  :cognitect.aws.medialive/FixedAfd
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AFD_0010"
        "AFD_1101"
        "AFD_1000"
        "AFD_1111"
        "AFD_0000"
        "AFD_1011"
        "AFD_0011"
        "AFD_1001"
        "AFD_0100"
        "AFD_1010"
        "AFD_1110"})))

(s/def
  :cognitect.aws.medialive/UdpContainerSettings
  (s/keys :opt-un [:cognitect.aws.medialive.UdpContainerSettings/M2tsSettings]))

(s/def
  :cognitect.aws.medialive/InputSpecification
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSpecification/Codec
     :cognitect.aws.medialive.InputSpecification/Resolution
     :cognitect.aws.medialive.InputSpecification/MaximumBitrate]))

(s/def
  :cognitect.aws.medialive/UpdateChannel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateChannel/DryRun
     :cognitect.aws.medialive.UpdateChannel/InputAttachments
     :cognitect.aws.medialive.UpdateChannel/LogLevel
     :cognitect.aws.medialive.UpdateChannel/RoleArn
     :cognitect.aws.medialive.UpdateChannel/AnywhereSettings
     :cognitect.aws.medialive.UpdateChannel/CdiInputSpecification
     :cognitect.aws.medialive.UpdateChannel/EncoderSettings
     :cognitect.aws.medialive.UpdateChannel/InputSpecification
     :cognitect.aws.medialive.UpdateChannel/ChannelEngineVersion
     :cognitect.aws.medialive.UpdateChannel/Destinations
     :cognitect.aws.medialive.UpdateChannel/Name
     :cognitect.aws.medialive.UpdateChannel/Maintenance]))

(s/def
  :cognitect.aws.medialive/HlsIvSource
  (s/spec string? :gen #(s/gen #{"EXPLICIT" "FOLLOWS_SEGMENT_NUMBER"})))

(s/def
  :cognitect.aws.medialive/DvbSubDestinationFontColor
  (s/spec string? :gen #(s/gen #{"GREEN" "BLUE" "WHITE" "YELLOW" "BLACK" "RED"})))

(s/def
  :cognitect.aws.medialive/H265Level
  (s/spec
    string?
    :gen
    #(s/gen
      #{"H265_LEVEL_3_1"
        "H265_LEVEL_1"
        "H265_LEVEL_AUTO"
        "H265_LEVEL_6"
        "H265_LEVEL_4_1"
        "H265_LEVEL_5_1"
        "H265_LEVEL_6_2"
        "H265_LEVEL_6_1"
        "H265_LEVEL_5"
        "H265_LEVEL_4"
        "H265_LEVEL_2"
        "H265_LEVEL_3"
        "H265_LEVEL_2_1"
        "H265_LEVEL_5_2"})))

(s/def
  :cognitect.aws.medialive/H265FlickerAq
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/CreateCloudWatchAlarmTemplateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/TreatMissingData
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Period
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Threshold
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Tags
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/ComparisonOperator
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/GroupId
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/TargetResourceType
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/DatapointsToAlarm
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Description
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/ModifiedAt
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Arn
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/CreatedAt
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/MetricName
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Name
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/EvaluationPeriods
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Id
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Statistic]))

(s/def
  :cognitect.aws.medialive/UpdateReservationResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateReservationResultModel/Reservation]))

(s/def
  :cognitect.aws.medialive/UnprocessableEntityException
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UnprocessableEntityException/Message
     :cognitect.aws.medialive.UnprocessableEntityException/ValidationErrors]))

(s/def
  :cognitect.aws.medialive/H264QualityLevel
  (s/spec string? :gen #(s/gen #{"ENHANCED_QUALITY" "STANDARD_QUALITY"})))

(s/def
  :cognitect.aws.medialive/TimecodeBurninPosition
  (s/spec
    string?
    :gen
    #(s/gen
      #{"TOP_CENTER"
        "MIDDLE_LEFT"
        "MIDDLE_CENTER"
        "MIDDLE_RIGHT"
        "BOTTOM_LEFT"
        "TOP_LEFT"
        "BOTTOM_CENTER"
        "TOP_RIGHT"
        "BOTTOM_RIGHT"})))

(s/def
  :cognitect.aws.medialive/Ac3MetadataControl
  (s/spec string? :gen #(s/gen #{"FOLLOW_INPUT" "USE_CONFIGURED"})))

(s/def
  :cognitect.aws.medialive/NielsenWatermarkTimezones
  (s/spec
    string?
    :gen
    #(s/gen
      #{"US_PACIFIC"
        "US_HAWAII"
        "AMERICA_PUERTO_RICO"
        "US_EASTERN"
        "US_CENTRAL"
        "US_SAMOA"
        "US_ALASKA"
        "UTC"
        "US_ARIZONA"
        "US_MOUNTAIN"})))

(s/def
  :cognitect.aws.medialive/CreateEventBridgeRuleTemplateGroupResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/CreatedAt
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Id
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Arn
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Tags
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Description
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/Smpte2110ReceiverGroup
  (s/keys :opt-un [:cognitect.aws.medialive.Smpte2110ReceiverGroup/SdpSettings]))

(s/def :cognitect.aws.medialive/AacRateControlMode (s/spec string? :gen #(s/gen #{"VBR" "CBR"})))

(s/def
  :cognitect.aws.medialive/Ac3AttenuationControl
  (s/spec string? :gen #(s/gen #{"ATTENUATE_3_DB" "NONE"})))

(s/def
  :cognitect.aws.medialive/Scte35NoRegionalBlackoutFlag
  (s/spec string? :gen #(s/gen #{"REGIONAL_BLACKOUT" "NO_REGIONAL_BLACKOUT"})))

(s/def
  :cognitect.aws.medialive/__stringMin0Max1024
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/UpdateCloudWatchAlarmTemplateRequestContent
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/TreatMissingData
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Period
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Threshold
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/ComparisonOperator
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/TargetResourceType
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/GroupIdentifier
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/DatapointsToAlarm
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Description
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/MetricName
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Name
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/EvaluationPeriods
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Statistic]))

(s/def
  :cognitect.aws.medialive/BlackoutSlateNetworkEndBlackout
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/InputDevice
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDevice/NetworkSettings
     :cognitect.aws.medialive.InputDevice/HdDeviceSettings
     :cognitect.aws.medialive.InputDevice/Type
     :cognitect.aws.medialive.InputDevice/ConnectionState
     :cognitect.aws.medialive.InputDevice/DeviceUpdateStatus
     :cognitect.aws.medialive.InputDevice/MacAddress
     :cognitect.aws.medialive.InputDevice/Tags
     :cognitect.aws.medialive.InputDevice/AvailabilityZone
     :cognitect.aws.medialive.InputDevice/MedialiveInputArns
     :cognitect.aws.medialive.InputDevice/OutputType
     :cognitect.aws.medialive.InputDevice/UhdDeviceSettings
     :cognitect.aws.medialive.InputDevice/DeviceSettingsSyncState
     :cognitect.aws.medialive.InputDevice/Arn
     :cognitect.aws.medialive.InputDevice/SerialNumber
     :cognitect.aws.medialive.InputDevice/Name
     :cognitect.aws.medialive.InputDevice/Id]))

(s/def
  :cognitect.aws.medialive/BatchScheduleActionDeleteRequest
  (s/keys :req-un [:cognitect.aws.medialive.BatchScheduleActionDeleteRequest/ActionNames]))

(s/def
  :cognitect.aws.medialive/UpdateClusterRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateClusterRequest/ClusterId]
    :opt-un
    [:cognitect.aws.medialive.UpdateClusterRequest/NetworkSettings
     :cognitect.aws.medialive.UpdateClusterRequest/Name]))

(s/def
  :cognitect.aws.medialive/ListCloudWatchAlarmTemplatesResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ListCloudWatchAlarmTemplatesResponseContent/CloudWatchAlarmTemplates]
    :opt-un
    [:cognitect.aws.medialive.ListCloudWatchAlarmTemplatesResponseContent/NextToken]))

(s/def
  :cognitect.aws.medialive/DeleteMultiplexResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteMultiplexResponse/ProgramCount
     :cognitect.aws.medialive.DeleteMultiplexResponse/PipelinesRunningCount
     :cognitect.aws.medialive.DeleteMultiplexResponse/Tags
     :cognitect.aws.medialive.DeleteMultiplexResponse/Arn
     :cognitect.aws.medialive.DeleteMultiplexResponse/MultiplexSettings
     :cognitect.aws.medialive.DeleteMultiplexResponse/State
     :cognitect.aws.medialive.DeleteMultiplexResponse/Destinations
     :cognitect.aws.medialive.DeleteMultiplexResponse/Name
     :cognitect.aws.medialive.DeleteMultiplexResponse/AvailabilityZones
     :cognitect.aws.medialive.DeleteMultiplexResponse/Id]))

(s/def
  :cognitect.aws.medialive/HlsProgramDateTime
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.medialive/SrtCallerSource
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.SrtCallerSource/StreamId
     :cognitect.aws.medialive.SrtCallerSource/SrtListenerPort
     :cognitect.aws.medialive.SrtCallerSource/Decryption
     :cognitect.aws.medialive.SrtCallerSource/MinimumLatency
     :cognitect.aws.medialive.SrtCallerSource/SrtListenerAddress]))

(s/def
  :cognitect.aws.medialive/InterfaceMapping
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InterfaceMapping/NetworkId
     :cognitect.aws.medialive.InterfaceMapping/LogicalInterfaceName]))

(s/def
  :cognitect.aws.medialive/ClusterState
  (s/spec
    string?
    :gen
    #(s/gen #{"CREATE_FAILED" "DELETING" "CREATING" "ACTIVE" "DELETED" "DELETE_FAILED"})))

(s/def
  :cognitect.aws.medialive/__doubleMinNegative1Max5
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/MultiplexVideoSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexVideoSettings/StatmuxSettings
     :cognitect.aws.medialive.MultiplexVideoSettings/ConstantBitrate]))

(s/def
  :cognitect.aws.medialive/ListChannelsResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListChannelsResultModel/NextToken
     :cognitect.aws.medialive.ListChannelsResultModel/Channels]))

(s/def
  :cognitect.aws.medialive/BatchStartResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchStartResponse/Failed
     :cognitect.aws.medialive.BatchStartResponse/Successful]))

(s/def
  :cognitect.aws.medialive/InputSecurityGroupWhitelistRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSecurityGroupWhitelistRequest/Tags
     :cognitect.aws.medialive.InputSecurityGroupWhitelistRequest/WhitelistRules]))

(s/def
  :cognitect.aws.medialive/NotFoundException
  (s/keys :opt-un [:cognitect.aws.medialive.NotFoundException/Message]))

(s/def
  :cognitect.aws.medialive/__listOfSmpte2110ReceiverGroup
  (s/coll-of :cognitect.aws.medialive/Smpte2110ReceiverGroup))

(s/def
  :cognitect.aws.medialive/__listOfBatchSuccessfulResultModel
  (s/coll-of :cognitect.aws.medialive/BatchSuccessfulResultModel))

(s/def
  :cognitect.aws.medialive/UpdateNodeResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateNodeResponse/ConnectionState
     :cognitect.aws.medialive.UpdateNodeResponse/ClusterId
     :cognitect.aws.medialive.UpdateNodeResponse/Role
     :cognitect.aws.medialive.UpdateNodeResponse/NodeInterfaceMappings
     :cognitect.aws.medialive.UpdateNodeResponse/SdiSourceMappings
     :cognitect.aws.medialive.UpdateNodeResponse/Arn
     :cognitect.aws.medialive.UpdateNodeResponse/State
     :cognitect.aws.medialive.UpdateNodeResponse/Name
     :cognitect.aws.medialive.UpdateNodeResponse/Id
     :cognitect.aws.medialive.UpdateNodeResponse/ChannelPlacementGroups
     :cognitect.aws.medialive.UpdateNodeResponse/InstanceArn]))

(s/def
  :cognitect.aws.medialive/CreateInputRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateInputRequest/MediaConnectFlows
     :cognitect.aws.medialive.CreateInputRequest/RequestId
     :cognitect.aws.medialive.CreateInputRequest/Type
     :cognitect.aws.medialive.CreateInputRequest/InputSecurityGroups
     :cognitect.aws.medialive.CreateInputRequest/SdiSources
     :cognitect.aws.medialive.CreateInputRequest/RoleArn
     :cognitect.aws.medialive.CreateInputRequest/InputNetworkLocation
     :cognitect.aws.medialive.CreateInputRequest/Tags
     :cognitect.aws.medialive.CreateInputRequest/Smpte2110ReceiverGroupSettings
     :cognitect.aws.medialive.CreateInputRequest/SrtSettings
     :cognitect.aws.medialive.CreateInputRequest/MulticastSettings
     :cognitect.aws.medialive.CreateInputRequest/InputDevices
     :cognitect.aws.medialive.CreateInputRequest/Vpc
     :cognitect.aws.medialive.CreateInputRequest/Destinations
     :cognitect.aws.medialive.CreateInputRequest/Name
     :cognitect.aws.medialive.CreateInputRequest/Sources]))

(s/def
  :cognitect.aws.medialive/Channel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Channel/ChannelClass
     :cognitect.aws.medialive.Channel/InputAttachments
     :cognitect.aws.medialive.Channel/PipelinesRunningCount
     :cognitect.aws.medialive.Channel/LogLevel
     :cognitect.aws.medialive.Channel/RoleArn
     :cognitect.aws.medialive.Channel/Tags
     :cognitect.aws.medialive.Channel/PipelineDetails
     :cognitect.aws.medialive.Channel/AnywhereSettings
     :cognitect.aws.medialive.Channel/EgressEndpoints
     :cognitect.aws.medialive.Channel/CdiInputSpecification
     :cognitect.aws.medialive.Channel/EncoderSettings
     :cognitect.aws.medialive.Channel/Vpc
     :cognitect.aws.medialive.Channel/Arn
     :cognitect.aws.medialive.Channel/InputSpecification
     :cognitect.aws.medialive.Channel/ChannelEngineVersion
     :cognitect.aws.medialive.Channel/State
     :cognitect.aws.medialive.Channel/Destinations
     :cognitect.aws.medialive.Channel/Name
     :cognitect.aws.medialive.Channel/Maintenance
     :cognitect.aws.medialive.Channel/Id]))

(s/def
  :cognitect.aws.medialive/H264Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.H264Settings/Level
     :cognitect.aws.medialive.H264Settings/RateControlMode
     :cognitect.aws.medialive.H264Settings/SubgopLength
     :cognitect.aws.medialive.H264Settings/MinIInterval
     :cognitect.aws.medialive.H264Settings/TemporalAq
     :cognitect.aws.medialive.H264Settings/ParDenominator
     :cognitect.aws.medialive.H264Settings/QvbrQualityLevel
     :cognitect.aws.medialive.H264Settings/NumRefFrames
     :cognitect.aws.medialive.H264Settings/GopBReference
     :cognitect.aws.medialive.H264Settings/TimecodeInsertion
     :cognitect.aws.medialive.H264Settings/ScanType
     :cognitect.aws.medialive.H264Settings/AdaptiveQuantization
     :cognitect.aws.medialive.H264Settings/AfdSignaling
     :cognitect.aws.medialive.H264Settings/BufFillPct
     :cognitect.aws.medialive.H264Settings/FramerateDenominator
     :cognitect.aws.medialive.H264Settings/ForceFieldPictures
     :cognitect.aws.medialive.H264Settings/SpatialAq
     :cognitect.aws.medialive.H264Settings/MinQp
     :cognitect.aws.medialive.H264Settings/FramerateControl
     :cognitect.aws.medialive.H264Settings/FilterSettings
     :cognitect.aws.medialive.H264Settings/GopNumBFrames
     :cognitect.aws.medialive.H264Settings/BufSize
     :cognitect.aws.medialive.H264Settings/Profile
     :cognitect.aws.medialive.H264Settings/ColorMetadata
     :cognitect.aws.medialive.H264Settings/LookAheadRateControl
     :cognitect.aws.medialive.H264Settings/Syntax
     :cognitect.aws.medialive.H264Settings/GopClosedCadence
     :cognitect.aws.medialive.H264Settings/FlickerAq
     :cognitect.aws.medialive.H264Settings/FramerateNumerator
     :cognitect.aws.medialive.H264Settings/Softness
     :cognitect.aws.medialive.H264Settings/GopSizeUnits
     :cognitect.aws.medialive.H264Settings/MaxBitrate
     :cognitect.aws.medialive.H264Settings/QualityLevel
     :cognitect.aws.medialive.H264Settings/ParNumerator
     :cognitect.aws.medialive.H264Settings/GopSize
     :cognitect.aws.medialive.H264Settings/ParControl
     :cognitect.aws.medialive.H264Settings/Slices
     :cognitect.aws.medialive.H264Settings/FixedAfd
     :cognitect.aws.medialive.H264Settings/TimecodeBurninSettings
     :cognitect.aws.medialive.H264Settings/EntropyEncoding
     :cognitect.aws.medialive.H264Settings/SceneChangeDetect
     :cognitect.aws.medialive.H264Settings/ColorSpaceSettings
     :cognitect.aws.medialive.H264Settings/Bitrate]))

(s/def
  :cognitect.aws.medialive/__doubleMinNegative59Max0
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/__stringMin1
  (s/spec
    (s/and string? #(<= 1 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive/TransferInputDeviceResponse (s/keys))

(s/def
  :cognitect.aws.medialive/UpdateCloudWatchAlarmTemplateGroupRequestContent
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupRequestContent/Description]))

(s/def
  :cognitect.aws.medialive/__integerMin3
  (s/spec (s/and int? #(<= 3 %)) :gen #(gen/choose 3 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.medialive/__integerMinNegative1000Max1000
  (s/spec (s/and int? #(<= -1000 % 1000)) :gen #(gen/choose -1000 1000)))

(s/def
  :cognitect.aws.medialive/SdiSourceMappingsUpdateRequest
  (s/coll-of :cognitect.aws.medialive/SdiSourceMappingUpdateRequest))

(s/def
  :cognitect.aws.medialive/VideoCodecSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.VideoCodecSettings/Av1Settings
     :cognitect.aws.medialive.VideoCodecSettings/H265Settings
     :cognitect.aws.medialive.VideoCodecSettings/FrameCaptureSettings
     :cognitect.aws.medialive.VideoCodecSettings/Mpeg2Settings
     :cognitect.aws.medialive.VideoCodecSettings/H264Settings]))

(s/def
  :cognitect.aws.medialive/MaintenanceCreateSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MaintenanceCreateSettings/MaintenanceStartTime
     :cognitect.aws.medialive.MaintenanceCreateSettings/MaintenanceDay]))

(s/def
  :cognitect.aws.medialive/FrameCaptureGroupSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.FrameCaptureGroupSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.FrameCaptureGroupSettings/FrameCaptureCdnSettings]))

(s/def
  :cognitect.aws.medialive/Mpeg2ColorSpace
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "AUTO"})))

(s/def
  :cognitect.aws.medialive/MultiplexProgramSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MultiplexProgramSettings/ProgramNumber]
    :opt-un
    [:cognitect.aws.medialive.MultiplexProgramSettings/PreferredChannelPipeline
     :cognitect.aws.medialive.MultiplexProgramSettings/ServiceDescriptor
     :cognitect.aws.medialive.MultiplexProgramSettings/VideoSettings]))

(s/def
  :cognitect.aws.medialive/M2tsBufferModel
  (s/spec string? :gen #(s/gen #{"NONE" "MULTIPLEX"})))

(s/def
  :cognitect.aws.medialive/__doubleMin0Max100
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/CreateChannelResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.CreateChannelResultModel/Channel]))

(s/def
  :cognitect.aws.medialive/H265MvOverPictureBoundaries
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def :cognitect.aws.medialive/__timestamp inst?)

(s/def
  :cognitect.aws.medialive/CreateCloudWatchAlarmTemplateResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/TargetResourceType
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/TreatMissingData
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/ComparisonOperator
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/CreatedAt
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Period
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/EvaluationPeriods
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Name
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/GroupId
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/MetricName
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Statistic
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Id
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Arn
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Threshold]
    :opt-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Tags
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/DatapointsToAlarm
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Description
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/Eac3Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Eac3Settings/LtRtSurroundMixLevel
     :cognitect.aws.medialive.Eac3Settings/CodingMode
     :cognitect.aws.medialive.Eac3Settings/PhaseControl
     :cognitect.aws.medialive.Eac3Settings/PassthroughControl
     :cognitect.aws.medialive.Eac3Settings/SurroundMode
     :cognitect.aws.medialive.Eac3Settings/AttenuationControl
     :cognitect.aws.medialive.Eac3Settings/DrcLine
     :cognitect.aws.medialive.Eac3Settings/DcFilter
     :cognitect.aws.medialive.Eac3Settings/LfeFilter
     :cognitect.aws.medialive.Eac3Settings/LfeControl
     :cognitect.aws.medialive.Eac3Settings/LoRoCenterMixLevel
     :cognitect.aws.medialive.Eac3Settings/StereoDownmix
     :cognitect.aws.medialive.Eac3Settings/LtRtCenterMixLevel
     :cognitect.aws.medialive.Eac3Settings/SurroundExMode
     :cognitect.aws.medialive.Eac3Settings/MetadataControl
     :cognitect.aws.medialive.Eac3Settings/LoRoSurroundMixLevel
     :cognitect.aws.medialive.Eac3Settings/DrcRf
     :cognitect.aws.medialive.Eac3Settings/BitstreamMode
     :cognitect.aws.medialive.Eac3Settings/Dialnorm
     :cognitect.aws.medialive.Eac3Settings/Bitrate]))

(s/def
  :cognitect.aws.medialive/UpdateAccountConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateAccountConfigurationResponse/AccountConfiguration]))

(s/def
  :cognitect.aws.medialive/InputLocation
  (s/keys
    :req-un
    [:cognitect.aws.medialive.InputLocation/Uri]
    :opt-un
    [:cognitect.aws.medialive.InputLocation/Username
     :cognitect.aws.medialive.InputLocation/PasswordParam]))

(s/def
  :cognitect.aws.medialive/DescribeSdiSourceRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeSdiSourceRequest/SdiSourceId]))

(s/def
  :cognitect.aws.medialive/Ac3CodingMode
  (s/spec
    string?
    :gen
    #(s/gen #{"CODING_MODE_1_0" "CODING_MODE_3_2_LFE" "CODING_MODE_1_1" "CODING_MODE_2_0"})))

(s/def
  :cognitect.aws.medialive/Ac3DrcProfile
  (s/spec string? :gen #(s/gen #{"FILM_STANDARD" "NONE"})))

(s/def
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MEDIAPACKAGE_HARVEST_JOB_NOTIFICATION"
        "MEDIALIVE_MULTIPLEX_ALERT"
        "MEDIACONNECT_ALERT"
        "SIGNAL_MAP_ACTIVE_ALARM"
        "MEDIALIVE_CHANNEL_STATE_CHANGE"
        "MEDIALIVE_CHANNEL_INPUT_CHANGE"
        "MEDIACONNECT_SOURCE_HEALTH"
        "MEDIAPACKAGE_KEY_PROVIDER_NOTIFICATION"
        "MEDIALIVE_CHANNEL_ALERT"
        "MEDIACONNECT_FLOW_STATUS_CHANGE"
        "MEDIALIVE_MULTIPLEX_STATE_CHANGE"
        "MEDIAPACKAGE_INPUT_NOTIFICATION"
        "MEDIACONNECT_OUTPUT_HEALTH"})))

(s/def
  :cognitect.aws.medialive/MediaConnectFlow
  (s/keys :opt-un [:cognitect.aws.medialive.MediaConnectFlow/FlowArn]))

(s/def
  :cognitect.aws.medialive/HlsManifestDurationFormat
  (s/spec string? :gen #(s/gen #{"FLOATING_POINT" "INTEGER"})))

(s/def
  :cognitect.aws.medialive/ListChannelPlacementGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListChannelPlacementGroupsResponse/NextToken
     :cognitect.aws.medialive.ListChannelPlacementGroupsResponse/ChannelPlacementGroups]))

(s/def
  :cognitect.aws.medialive/M3u8Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.M3u8Settings/PatInterval
     :cognitect.aws.medialive.M3u8Settings/NielsenId3Behavior
     :cognitect.aws.medialive.M3u8Settings/AudioFramesPerPes
     :cognitect.aws.medialive.M3u8Settings/TransportStreamId
     :cognitect.aws.medialive.M3u8Settings/Scte35Behavior
     :cognitect.aws.medialive.M3u8Settings/TimedMetadataBehavior
     :cognitect.aws.medialive.M3u8Settings/PcrControl
     :cognitect.aws.medialive.M3u8Settings/Scte35Pid
     :cognitect.aws.medialive.M3u8Settings/PcrPid
     :cognitect.aws.medialive.M3u8Settings/PmtPid
     :cognitect.aws.medialive.M3u8Settings/VideoPid
     :cognitect.aws.medialive.M3u8Settings/AudioPids
     :cognitect.aws.medialive.M3u8Settings/PcrPeriod
     :cognitect.aws.medialive.M3u8Settings/KlvBehavior
     :cognitect.aws.medialive.M3u8Settings/PmtInterval
     :cognitect.aws.medialive.M3u8Settings/ProgramNum
     :cognitect.aws.medialive.M3u8Settings/TimedMetadataPid
     :cognitect.aws.medialive.M3u8Settings/KlvDataPids
     :cognitect.aws.medialive.M3u8Settings/EcmPid]))

(s/def
  :cognitect.aws.medialive/AudioSelectorSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AudioSelectorSettings/AudioHlsRenditionSelection
     :cognitect.aws.medialive.AudioSelectorSettings/AudioPidSelection
     :cognitect.aws.medialive.AudioSelectorSettings/AudioLanguageSelection
     :cognitect.aws.medialive.AudioSelectorSettings/AudioTrackSelection]))

(s/def
  :cognitect.aws.medialive/ListNodesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListNodesResponse/Nodes
     :cognitect.aws.medialive.ListNodesResponse/NextToken]))

(s/def
  :cognitect.aws.medialive/H264RateControlMode
  (s/spec string? :gen #(s/gen #{"VBR" "CBR" "QVBR" "MULTIPLEX"})))

(s/def
  :cognitect.aws.medialive/MultiplexOutputDestination
  (s/keys :opt-un [:cognitect.aws.medialive.MultiplexOutputDestination/MediaConnectSettings]))

(s/def
  :cognitect.aws.medialive/H264ForceFieldPictures
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def :cognitect.aws.medialive/SmpteTtDestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/__listOfDashRoleAudio
  (s/coll-of :cognitect.aws.medialive/DashRoleAudio))

(s/def
  :cognitect.aws.medialive/CreateInputResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.CreateInputResultModel/Input]))

(s/def :cognitect.aws.medialive/H265Profile (s/spec string? :gen #(s/gen #{"MAIN" "MAIN_10BIT"})))

(s/def
  :cognitect.aws.medialive/ClaimDeviceRequest
  (s/keys :opt-un [:cognitect.aws.medialive.ClaimDeviceRequest/Id]))

(s/def :cognitect.aws.medialive/StartInputDeviceResponse (s/keys))

(s/def
  :cognitect.aws.medialive/__integerMin1Max5
  (s/spec (s/and int? #(<= 1 % 5)) :gen #(gen/choose 1 5)))

(s/def :cognitect.aws.medialive/__listOfOutput (s/coll-of :cognitect.aws.medialive/Output))

(s/def
  :cognitect.aws.medialive/MultiplexContainerSettings
  (s/keys :opt-un [:cognitect.aws.medialive.MultiplexContainerSettings/MultiplexM2tsSettings]))

(s/def :cognitect.aws.medialive/__listOfIpPool (s/coll-of :cognitect.aws.medialive/IpPool))

(s/def
  :cognitect.aws.medialive/InputType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"SRT_CALLER"
        "MP4_FILE"
        "MULTICAST"
        "SMPTE_2110_RECEIVER_GROUP"
        "SDI"
        "RTMP_PULL"
        "UDP_PUSH"
        "URL_PULL"
        "AWS_CDI"
        "INPUT_DEVICE"
        "RTP_PUSH"
        "MEDIACONNECT"
        "TS_FILE"
        "RTMP_PUSH"})))

(s/def
  :cognitect.aws.medialive/__integerMin1000
  (s/spec (s/and int? #(<= 1000 %)) :gen #(gen/choose 1000 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.medialive/ResourceConflict
  (s/keys :opt-un [:cognitect.aws.medialive.ResourceConflict/Message]))

(s/def
  :cognitect.aws.medialive/StaticImageDeactivateScheduleActionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StaticImageDeactivateScheduleActionSettings/Layer
     :cognitect.aws.medialive.StaticImageDeactivateScheduleActionSettings/FadeOut]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max1000000
  (s/spec (s/and int? #(<= 1 % 1000000)) :gen #(gen/choose 1 1000000)))

(s/def
  :cognitect.aws.medialive/H264GopSizeUnits
  (s/spec string? :gen #(s/gen #{"SECONDS" "FRAMES"})))

(s/def
  :cognitect.aws.medialive/MsSmoothH265PackagingType
  (s/spec string? :gen #(s/gen #{"HVC1" "HEV1"})))

(s/def :cognitect.aws.medialive/CancelInputDeviceTransferResponse (s/keys))

(s/def
  :cognitect.aws.medialive/Scte35WebDeliveryAllowedFlag
  (s/spec string? :gen #(s/gen #{"WEB_DELIVERY_ALLOWED" "WEB_DELIVERY_NOT_ALLOWED"})))

(s/def
  :cognitect.aws.medialive/__stringMax256
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive/PipelineLockingSettings (s/keys))

(s/def
  :cognitect.aws.medialive/DescribeAccountConfigurationResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeAccountConfigurationResultModel/AccountConfiguration]))

(s/def
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateSummary
  (s/coll-of :cognitect.aws.medialive/EventBridgeRuleTemplateSummary))

(s/def
  :cognitect.aws.medialive/AutomaticInputFailoverSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AutomaticInputFailoverSettings/SecondaryInputId]
    :opt-un
    [:cognitect.aws.medialive.AutomaticInputFailoverSettings/ErrorClearTimeMsec
     :cognitect.aws.medialive.AutomaticInputFailoverSettings/InputPreference
     :cognitect.aws.medialive.AutomaticInputFailoverSettings/FailoverConditions]))

(s/def
  :cognitect.aws.medialive/ListChannelsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListChannelsResponse/NextToken
     :cognitect.aws.medialive.ListChannelsResponse/Channels]))

(s/def
  :cognitect.aws.medialive/__listOfScheduleAction
  (s/coll-of :cognitect.aws.medialive/ScheduleAction))

(s/def
  :cognitect.aws.medialive/BadRequestExceptionResponseContent
  (s/keys :opt-un [:cognitect.aws.medialive.BadRequestExceptionResponseContent/Message]))

(s/def
  :cognitect.aws.medialive/StartInputDeviceRequest
  (s/keys :req-un [:cognitect.aws.medialive.StartInputDeviceRequest/InputDeviceId]))

(s/def
  :cognitect.aws.medialive/HlsDiscontinuityTags
  (s/spec string? :gen #(s/gen #{"NEVER_INSERT" "INSERT"})))

(s/def
  :cognitect.aws.medialive/ArchiveS3LogUploads
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/Mpeg2ColorMetadata
  (s/spec string? :gen #(s/gen #{"INSERT" "IGNORE"})))

(s/def
  :cognitect.aws.medialive/AudioOnlyHlsSegmentType
  (s/spec string? :gen #(s/gen #{"AAC" "FMP4"})))

(s/def
  :cognitect.aws.medialive/DescribeReservationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeReservationResponse/DurationUnits
     :cognitect.aws.medialive.DescribeReservationResponse/CurrencyCode
     :cognitect.aws.medialive.DescribeReservationResponse/OfferingDescription
     :cognitect.aws.medialive.DescribeReservationResponse/RenewalSettings
     :cognitect.aws.medialive.DescribeReservationResponse/ResourceSpecification
     :cognitect.aws.medialive.DescribeReservationResponse/Start
     :cognitect.aws.medialive.DescribeReservationResponse/FixedPrice
     :cognitect.aws.medialive.DescribeReservationResponse/End
     :cognitect.aws.medialive.DescribeReservationResponse/Count
     :cognitect.aws.medialive.DescribeReservationResponse/Tags
     :cognitect.aws.medialive.DescribeReservationResponse/OfferingId
     :cognitect.aws.medialive.DescribeReservationResponse/Duration
     :cognitect.aws.medialive.DescribeReservationResponse/UsagePrice
     :cognitect.aws.medialive.DescribeReservationResponse/Arn
     :cognitect.aws.medialive.DescribeReservationResponse/State
     :cognitect.aws.medialive.DescribeReservationResponse/OfferingType
     :cognitect.aws.medialive.DescribeReservationResponse/Name
     :cognitect.aws.medialive.DescribeReservationResponse/ReservationId
     :cognitect.aws.medialive.DescribeReservationResponse/Region]))

(s/def :cognitect.aws.medialive/FollowPoint (s/spec string? :gen #(s/gen #{"END" "START"})))

(s/def
  :cognitect.aws.medialive/Scte35SpliceInsertNoRegionalBlackoutBehavior
  (s/spec string? :gen #(s/gen #{"FOLLOW" "IGNORE"})))

(s/def
  :cognitect.aws.medialive/DeleteCloudWatchAlarmTemplateGroupRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteCloudWatchAlarmTemplateGroupRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/__listOfChannelEngineVersionResponse
  (s/coll-of :cognitect.aws.medialive/ChannelEngineVersionResponse))

(s/def
  :cognitect.aws.medialive/UpdateAccountConfigurationResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateAccountConfigurationResultModel/AccountConfiguration]))

(s/def
  :cognitect.aws.medialive/SdiSourceMappings
  (s/coll-of :cognitect.aws.medialive/SdiSourceMapping))

(s/def
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097
  (s/spec #(re-matches (re-pattern "^(aws-)?[0-9]{7}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.medialive/UpdateEventBridgeRuleTemplateGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Tags
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Description
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/ModifiedAt
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Arn
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/CreatedAt
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Name
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Id]))

(s/def
  :cognitect.aws.medialive/__stringMax32
  (s/spec
    (s/and string? #(>= 32 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 32) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/CreateCloudWatchAlarmTemplateGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Tags
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Description
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/ModifiedAt
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Arn
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/CreatedAt
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Name
     :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Id]))

(s/def
  :cognitect.aws.medialive/GetSignalMapResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.GetSignalMapResponse/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.GetSignalMapResponse/Tags
     :cognitect.aws.medialive.GetSignalMapResponse/Status
     :cognitect.aws.medialive.GetSignalMapResponse/ErrorMessage
     :cognitect.aws.medialive.GetSignalMapResponse/MonitorDeployment
     :cognitect.aws.medialive.GetSignalMapResponse/DiscoveryEntryPointArn
     :cognitect.aws.medialive.GetSignalMapResponse/Description
     :cognitect.aws.medialive.GetSignalMapResponse/ModifiedAt
     :cognitect.aws.medialive.GetSignalMapResponse/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.GetSignalMapResponse/Arn
     :cognitect.aws.medialive.GetSignalMapResponse/CreatedAt
     :cognitect.aws.medialive.GetSignalMapResponse/FailedMediaResourceMap
     :cognitect.aws.medialive.GetSignalMapResponse/Name
     :cognitect.aws.medialive.GetSignalMapResponse/MediaResourceMap
     :cognitect.aws.medialive.GetSignalMapResponse/MonitorChangesPendingDeployment
     :cognitect.aws.medialive.GetSignalMapResponse/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.GetSignalMapResponse/Id
     :cognitect.aws.medialive.GetSignalMapResponse/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/__stringMin1Max35
  (s/spec
    (s/and string? #(<= 1 (count %) 35))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 35) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/VideoSelectorColorSpaceSettings
  (s/keys :opt-un [:cognitect.aws.medialive.VideoSelectorColorSpaceSettings/Hdr10Settings]))

(s/def
  :cognitect.aws.medialive/TagsModel
  (s/keys :opt-un [:cognitect.aws.medialive.TagsModel/Tags]))

(s/def
  :cognitect.aws.medialive/M2tsEsRateInPes
  (s/spec string? :gen #(s/gen #{"INCLUDE" "EXCLUDE"})))

(s/def
  :cognitect.aws.medialive/__listOfInterfaceMapping
  (s/coll-of :cognitect.aws.medialive/InterfaceMapping))

(s/def
  :cognitect.aws.medialive/FeatureActivationsInputPrepareScheduleActions
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/WebvttDestinationSettings
  (s/keys :opt-un [:cognitect.aws.medialive.WebvttDestinationSettings/StyleControl]))

(s/def
  :cognitect.aws.medialive/MultiplexStatmuxVideoSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexStatmuxVideoSettings/MinimumBitrate
     :cognitect.aws.medialive.MultiplexStatmuxVideoSettings/Priority
     :cognitect.aws.medialive.MultiplexStatmuxVideoSettings/MaximumBitrate]))

(s/def
  :cognitect.aws.medialive/BatchStopResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchStopResultModel/Failed
     :cognitect.aws.medialive.BatchStopResultModel/Successful]))

(s/def :cognitect.aws.medialive/InputCodec (s/spec string? :gen #(s/gen #{"HEVC" "MPEG2" "AVC"})))

(s/def
  :cognitect.aws.medialive/ArchiveCdnSettings
  (s/keys :opt-un [:cognitect.aws.medialive.ArchiveCdnSettings/ArchiveS3Settings]))

(s/def
  :cognitect.aws.medialive/EbuTtDFillLineGapControl
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/BatchUpdateScheduleResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchUpdateScheduleResult/Creates
     :cognitect.aws.medialive.BatchUpdateScheduleResult/Deletes]))

(s/def
  :cognitect.aws.medialive/__listOfCaptionDescription
  (s/coll-of :cognitect.aws.medialive/CaptionDescription))

(s/def
  :cognitect.aws.medialive/MediaConnectFlowRequest
  (s/keys :opt-un [:cognitect.aws.medialive.MediaConnectFlowRequest/FlowArn]))

(s/def
  :cognitect.aws.medialive/__integerMin1
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.medialive/DescribeClusterResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeClusterResponse/NetworkSettings
     :cognitect.aws.medialive.DescribeClusterResponse/ClusterType
     :cognitect.aws.medialive.DescribeClusterResponse/Arn
     :cognitect.aws.medialive.DescribeClusterResponse/InstanceRoleArn
     :cognitect.aws.medialive.DescribeClusterResponse/State
     :cognitect.aws.medialive.DescribeClusterResponse/Name
     :cognitect.aws.medialive.DescribeClusterResponse/ChannelIds
     :cognitect.aws.medialive.DescribeClusterResponse/Id]))

(s/def
  :cognitect.aws.medialive/ReservationResourceType
  (s/spec string? :gen #(s/gen #{"OUTPUT" "CHANNEL" "INPUT" "MULTIPLEX"})))

(s/def
  :cognitect.aws.medialive/Eac3PhaseControl
  (s/spec string? :gen #(s/gen #{"SHIFT_90_DEGREES" "NO_SHIFT"})))

(s/def
  :cognitect.aws.medialive/DescribeChannelPlacementGroupResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Nodes
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/ClusterId
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Arn
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/State
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Name
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Id
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Channels]))

(s/def
  :cognitect.aws.medialive/ReservationMaximumBitrate
  (s/spec string? :gen #(s/gen #{"MAX_10_MBPS" "MAX_50_MBPS" "MAX_20_MBPS"})))

(s/def
  :cognitect.aws.medialive/__longMin0Max4294967295
  (s/spec (s/and int? #(<= 0 % 4294967295)) :gen #(gen/choose 0 4294967295)))

(s/def
  :cognitect.aws.medialive/DescribeInputResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeInputResponse/MediaConnectFlows
     :cognitect.aws.medialive.DescribeInputResponse/InputClass
     :cognitect.aws.medialive.DescribeInputResponse/Type
     :cognitect.aws.medialive.DescribeInputResponse/SecurityGroups
     :cognitect.aws.medialive.DescribeInputResponse/SdiSources
     :cognitect.aws.medialive.DescribeInputResponse/RoleArn
     :cognitect.aws.medialive.DescribeInputResponse/InputNetworkLocation
     :cognitect.aws.medialive.DescribeInputResponse/Tags
     :cognitect.aws.medialive.DescribeInputResponse/Smpte2110ReceiverGroupSettings
     :cognitect.aws.medialive.DescribeInputResponse/SrtSettings
     :cognitect.aws.medialive.DescribeInputResponse/MulticastSettings
     :cognitect.aws.medialive.DescribeInputResponse/InputPartnerIds
     :cognitect.aws.medialive.DescribeInputResponse/InputDevices
     :cognitect.aws.medialive.DescribeInputResponse/Arn
     :cognitect.aws.medialive.DescribeInputResponse/InputSourceType
     :cognitect.aws.medialive.DescribeInputResponse/State
     :cognitect.aws.medialive.DescribeInputResponse/Destinations
     :cognitect.aws.medialive.DescribeInputResponse/Name
     :cognitect.aws.medialive.DescribeInputResponse/Sources
     :cognitect.aws.medialive.DescribeInputResponse/AttachedChannels
     :cognitect.aws.medialive.DescribeInputResponse/Id]))

(s/def
  :cognitect.aws.medialive/__listOfInputChannelLevel
  (s/coll-of :cognitect.aws.medialive/InputChannelLevel))

(s/def
  :cognitect.aws.medialive/__listOfOutputGroup
  (s/coll-of :cognitect.aws.medialive/OutputGroup))

(s/def
  :cognitect.aws.medialive/NodeConfigurationValidationError
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.NodeConfigurationValidationError/Message
     :cognitect.aws.medialive.NodeConfigurationValidationError/ValidationErrors]))

(s/def
  :cognitect.aws.medialive/ListInputDevicesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputDevicesRequest/NextToken
     :cognitect.aws.medialive.ListInputDevicesRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/MulticastSourceUpdateRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MulticastSourceUpdateRequest/Url]
    :opt-un
    [:cognitect.aws.medialive.MulticastSourceUpdateRequest/SourceIp]))

(s/def
  :cognitect.aws.medialive/DescribeAccountConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeAccountConfigurationResponse/AccountConfiguration]))

(s/def
  :cognitect.aws.medialive/UpdateMultiplexResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateMultiplexResultModel/Multiplex]))

(s/def
  :cognitect.aws.medialive/__longMin0Max1099511627775
  (s/spec (s/and int? #(<= 0 % 1099511627775)) :gen #(gen/choose 0 1099511627775)))

(s/def
  :cognitect.aws.medialive/__listOfPipelinePauseStateSettings
  (s/coll-of :cognitect.aws.medialive/PipelinePauseStateSettings))

(s/def
  :cognitect.aws.medialive/Scte35ArchiveAllowedFlag
  (s/spec string? :gen #(s/gen #{"ARCHIVE_ALLOWED" "ARCHIVE_NOT_ALLOWED"})))

(s/def
  :cognitect.aws.medialive/InputDeviceActiveInput
  (s/spec string? :gen #(s/gen #{"HDMI" "SDI"})))

(s/def
  :cognitect.aws.medialive/Multiplex
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Multiplex/ProgramCount
     :cognitect.aws.medialive.Multiplex/PipelinesRunningCount
     :cognitect.aws.medialive.Multiplex/Tags
     :cognitect.aws.medialive.Multiplex/Arn
     :cognitect.aws.medialive.Multiplex/MultiplexSettings
     :cognitect.aws.medialive.Multiplex/State
     :cognitect.aws.medialive.Multiplex/Destinations
     :cognitect.aws.medialive.Multiplex/Name
     :cognitect.aws.medialive.Multiplex/AvailabilityZones
     :cognitect.aws.medialive.Multiplex/Id]))

(s/def
  :cognitect.aws.medialive/InputLossActionForUdpOut
  (s/spec string? :gen #(s/gen #{"DROP_TS" "EMIT_PROGRAM" "DROP_PROGRAM"})))

(s/def
  :cognitect.aws.medialive/UpdateEventBridgeRuleTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/Identifier]
    :opt-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/EventType
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/GroupIdentifier
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/Description
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/EventTargets
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/Name]))

(s/def
  :cognitect.aws.medialive/H264Profile
  (s/spec
    string?
    :gen
    #(s/gen #{"HIGH_422" "BASELINE" "MAIN" "HIGH_10BIT" "HIGH" "HIGH_422_10BIT"})))

(s/def
  :cognitect.aws.medialive/ListCloudWatchAlarmTemplatesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListCloudWatchAlarmTemplatesResponse/CloudWatchAlarmTemplates
     :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesResponse/NextToken]))

(s/def
  :cognitect.aws.medialive/DescribeInputDeviceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeInputDeviceResponse/NetworkSettings
     :cognitect.aws.medialive.DescribeInputDeviceResponse/HdDeviceSettings
     :cognitect.aws.medialive.DescribeInputDeviceResponse/Type
     :cognitect.aws.medialive.DescribeInputDeviceResponse/ConnectionState
     :cognitect.aws.medialive.DescribeInputDeviceResponse/DeviceUpdateStatus
     :cognitect.aws.medialive.DescribeInputDeviceResponse/MacAddress
     :cognitect.aws.medialive.DescribeInputDeviceResponse/Tags
     :cognitect.aws.medialive.DescribeInputDeviceResponse/AvailabilityZone
     :cognitect.aws.medialive.DescribeInputDeviceResponse/MedialiveInputArns
     :cognitect.aws.medialive.DescribeInputDeviceResponse/OutputType
     :cognitect.aws.medialive.DescribeInputDeviceResponse/UhdDeviceSettings
     :cognitect.aws.medialive.DescribeInputDeviceResponse/DeviceSettingsSyncState
     :cognitect.aws.medialive.DescribeInputDeviceResponse/Arn
     :cognitect.aws.medialive.DescribeInputDeviceResponse/SerialNumber
     :cognitect.aws.medialive.DescribeInputDeviceResponse/Name
     :cognitect.aws.medialive.DescribeInputDeviceResponse/Id]))

(s/def
  :cognitect.aws.medialive/__listOfInputSource
  (s/coll-of :cognitect.aws.medialive/InputSource))

(s/def
  :cognitect.aws.medialive/SrtGroupSettings
  (s/keys :opt-un [:cognitect.aws.medialive.SrtGroupSettings/InputLossAction]))

(s/def :cognitect.aws.medialive/OfferingDurationUnits (s/spec string? :gen #(s/gen #{"MONTHS"})))

(s/def
  :cognitect.aws.medialive/UpdateInputDeviceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateInputDeviceResponse/NetworkSettings
     :cognitect.aws.medialive.UpdateInputDeviceResponse/HdDeviceSettings
     :cognitect.aws.medialive.UpdateInputDeviceResponse/Type
     :cognitect.aws.medialive.UpdateInputDeviceResponse/ConnectionState
     :cognitect.aws.medialive.UpdateInputDeviceResponse/DeviceUpdateStatus
     :cognitect.aws.medialive.UpdateInputDeviceResponse/MacAddress
     :cognitect.aws.medialive.UpdateInputDeviceResponse/Tags
     :cognitect.aws.medialive.UpdateInputDeviceResponse/AvailabilityZone
     :cognitect.aws.medialive.UpdateInputDeviceResponse/MedialiveInputArns
     :cognitect.aws.medialive.UpdateInputDeviceResponse/OutputType
     :cognitect.aws.medialive.UpdateInputDeviceResponse/UhdDeviceSettings
     :cognitect.aws.medialive.UpdateInputDeviceResponse/DeviceSettingsSyncState
     :cognitect.aws.medialive.UpdateInputDeviceResponse/Arn
     :cognitect.aws.medialive.UpdateInputDeviceResponse/SerialNumber
     :cognitect.aws.medialive.UpdateInputDeviceResponse/Name
     :cognitect.aws.medialive.UpdateInputDeviceResponse/Id]))

(s/def
  :cognitect.aws.medialive/Scte20SourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Scte20SourceSettings/Source608ChannelNumber
     :cognitect.aws.medialive.Scte20SourceSettings/Convert608To708]))

(s/def
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint
  (s/coll-of :cognitect.aws.medialive/ChannelEgressEndpoint))

(s/def
  :cognitect.aws.medialive/H265LookAheadRateControl
  (s/spec string? :gen #(s/gen #{"LOW" "HIGH" "MEDIUM"})))

(s/def
  :cognitect.aws.medialive/CreateInputSecurityGroupRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateInputSecurityGroupRequest/Tags
     :cognitect.aws.medialive.CreateInputSecurityGroupRequest/WhitelistRules]))

(s/def
  :cognitect.aws.medialive/ListNetworksResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListNetworksResult/NextToken
     :cognitect.aws.medialive.ListNetworksResult/Networks]))

(s/def
  :cognitect.aws.medialive/__integerMin256Max3840
  (s/spec (s/and int? #(<= 256 % 3840)) :gen #(gen/choose 256 3840)))

(s/def :cognitect.aws.medialive/Rec601Settings (s/keys))

(s/def
  :cognitect.aws.medialive/DescribeThumbnailsResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.DescribeThumbnailsResultModel/ThumbnailDetails]))

(s/def
  :cognitect.aws.medialive/MediaPackageOutputDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MediaPackageOutputDestinationSettings/ChannelId
     :cognitect.aws.medialive.MediaPackageOutputDestinationSettings/ChannelName
     :cognitect.aws.medialive.MediaPackageOutputDestinationSettings/ChannelGroup]))

(s/def
  :cognitect.aws.medialive/CaptionDescription
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CaptionDescription/CaptionSelectorName
     :cognitect.aws.medialive.CaptionDescription/Name]
    :opt-un
    [:cognitect.aws.medialive.CaptionDescription/DvbDashAccessibility
     :cognitect.aws.medialive.CaptionDescription/CaptionDashRoles
     :cognitect.aws.medialive.CaptionDescription/DestinationSettings
     :cognitect.aws.medialive.CaptionDescription/LanguageCode
     :cognitect.aws.medialive.CaptionDescription/Accessibility
     :cognitect.aws.medialive.CaptionDescription/LanguageDescription]))

(s/def
  :cognitect.aws.medialive/StandardHlsSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StandardHlsSettings/M3u8Settings]
    :opt-un
    [:cognitect.aws.medialive.StandardHlsSettings/AudioRenditionSets]))

(s/def
  :cognitect.aws.medialive/H264SubGopLength
  (s/spec string? :gen #(s/gen #{"FIXED" "DYNAMIC"})))

(s/def
  :cognitect.aws.medialive/MultiplexProgramPacketIdentifiersMap
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/DvbTeletextPids
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/Scte35Pid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/PcrPid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/PmtPid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/VideoPid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/AudioPids
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/EtvPlatformPid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/Smpte2038Pid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/EtvSignalPid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/TimedMetadataPid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/Scte27Pids
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/KlvDataPids
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/DvbSubPids
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/EcmPid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/PrivateMetadataPid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/DvbTeletextPid
     :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/AribCaptionsPid]))

(s/def
  :cognitect.aws.medialive/__listOfSrtCallerSource
  (s/coll-of :cognitect.aws.medialive/SrtCallerSource))

(s/def
  :cognitect.aws.medialive/__doubleMin32Max46
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/Scte27SourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Scte27SourceSettings/Pid
     :cognitect.aws.medialive.Scte27SourceSettings/OcrLanguage]))

(s/def
  :cognitect.aws.medialive/StopInputDeviceRequest
  (s/keys :req-un [:cognitect.aws.medialive.StopInputDeviceRequest/InputDeviceId]))

(s/def
  :cognitect.aws.medialive/SdiSourceMappingUpdateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.SdiSourceMappingUpdateRequest/CardNumber
     :cognitect.aws.medialive.SdiSourceMappingUpdateRequest/ChannelNumber
     :cognitect.aws.medialive.SdiSourceMappingUpdateRequest/SdiSource]))

(s/def :cognitect.aws.medialive/InputSdiSources (s/coll-of :cognitect.aws.medialive/__string))

(s/def :cognitect.aws.medialive/Empty (s/keys))

(s/def
  :cognitect.aws.medialive/__listOfNodeInterfaceMappingCreateRequest
  (s/coll-of :cognitect.aws.medialive/NodeInterfaceMappingCreateRequest))

(s/def
  :cognitect.aws.medialive/__longMin0Max8589934591
  (s/spec (s/and int? #(<= 0 % 8589934591)) :gen #(gen/choose 0 8589934591)))

(s/def
  :cognitect.aws.medialive/Thumbnail
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Thumbnail/Body
     :cognitect.aws.medialive.Thumbnail/ContentType
     :cognitect.aws.medialive.Thumbnail/ThumbnailType
     :cognitect.aws.medialive.Thumbnail/TimeStamp]))

(s/def
  :cognitect.aws.medialive/VideoSelectorProgramId
  (s/keys :opt-un [:cognitect.aws.medialive.VideoSelectorProgramId/ProgramId]))

(s/def
  :cognitect.aws.medialive/Mpeg2DisplayRatio
  (s/spec string? :gen #(s/gen #{"DISPLAYRATIO16X9" "DISPLAYRATIO4X3"})))

(s/def
  :cognitect.aws.medialive/ListCloudWatchAlarmTemplateGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsRequest/NextToken
     :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsRequest/MaxResults
     :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsRequest/SignalMapIdentifier
     :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsRequest/Scope]))

(s/def
  :cognitect.aws.medialive/Eac3LfeFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/DeleteNodeRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DeleteNodeRequest/NodeId
     :cognitect.aws.medialive.DeleteNodeRequest/ClusterId]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max7
  (s/spec (s/and int? #(<= 0 % 7)) :gen #(gen/choose 0 7)))

(s/def
  :cognitect.aws.medialive/CaptionSelector
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CaptionSelector/Name]
    :opt-un
    [:cognitect.aws.medialive.CaptionSelector/SelectorSettings
     :cognitect.aws.medialive.CaptionSelector/LanguageCode]))

(s/def
  :cognitect.aws.medialive/FrameCaptureS3Settings
  (s/keys :opt-un [:cognitect.aws.medialive.FrameCaptureS3Settings/CannedAcl]))

(s/def
  :cognitect.aws.medialive/HlsWebdavSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsWebdavSettings/HttpTransferMode
     :cognitect.aws.medialive.HlsWebdavSettings/NumRetries
     :cognitect.aws.medialive.HlsWebdavSettings/FilecacheDuration
     :cognitect.aws.medialive.HlsWebdavSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.HlsWebdavSettings/RestartDelay]))

(s/def
  :cognitect.aws.medialive/StopChannelRequest
  (s/keys :req-un [:cognitect.aws.medialive.StopChannelRequest/ChannelId]))

(s/def :cognitect.aws.medialive/FrameCaptureHlsSettings (s/keys))

(s/def
  :cognitect.aws.medialive/RebootInputDevice
  (s/keys :opt-un [:cognitect.aws.medialive.RebootInputDevice/Force]))

(s/def
  :cognitect.aws.medialive/AudioOnlyHlsTrackType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT"
        "ALTERNATE_AUDIO_AUTO_SELECT"
        "ALTERNATE_AUDIO_NOT_AUTO_SELECT"
        "AUDIO_ONLY_VARIANT_STREAM"})))

(s/def
  :cognitect.aws.medialive/CloudWatchAlarmTemplateGroupSummary
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/TemplateCount
     :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/CreatedAt
     :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Id
     :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Arn
     :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Name]
    :opt-un
    [:cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Tags
     :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Description
     :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/TeletextSourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.TeletextSourceSettings/PageNumber
     :cognitect.aws.medialive.TeletextSourceSettings/OutputRectangle]))

(s/def
  :cognitect.aws.medialive/AudioNormalizationAlgorithm
  (s/spec string? :gen #(s/gen #{"ITU_1770_1" "ITU_1770_2"})))

(s/def :cognitect.aws.medialive/M2tsKlv (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.medialive/__integerMin0Max8191
  (s/spec (s/and int? #(<= 0 % 8191)) :gen #(gen/choose 0 8191)))

(s/def
  :cognitect.aws.medialive/InputLossActionForMsSmoothOut
  (s/spec string? :gen #(s/gen #{"PAUSE_OUTPUT" "EMIT_OUTPUT"})))

(s/def
  :cognitect.aws.medialive/PreferredChannelPipeline
  (s/spec string? :gen #(s/gen #{"PIPELINE_0" "CURRENTLY_ACTIVE" "PIPELINE_1"})))

(s/def
  :cognitect.aws.medialive/DescribeChannelPlacementGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Nodes
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/ClusterId
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Arn
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/State
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Name
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Id
     :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Channels]))

(s/def
  :cognitect.aws.medialive/Scte35SegmentationCancelIndicator
  (s/spec string? :gen #(s/gen #{"SEGMENTATION_EVENT_NOT_CANCELED" "SEGMENTATION_EVENT_CANCELED"})))

(s/def
  :cognitect.aws.medialive/SdiSourceState
  (s/spec string? :gen #(s/gen #{"IDLE" "IN_USE" "DELETED"})))

(s/def
  :cognitect.aws.medialive/SrtSettingsRequest
  (s/keys :opt-un [:cognitect.aws.medialive.SrtSettingsRequest/SrtCallerSources]))

(s/def
  :cognitect.aws.medialive/UpdateNodeStateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateNodeStateResponse/ConnectionState
     :cognitect.aws.medialive.UpdateNodeStateResponse/ClusterId
     :cognitect.aws.medialive.UpdateNodeStateResponse/Role
     :cognitect.aws.medialive.UpdateNodeStateResponse/NodeInterfaceMappings
     :cognitect.aws.medialive.UpdateNodeStateResponse/SdiSourceMappings
     :cognitect.aws.medialive.UpdateNodeStateResponse/Arn
     :cognitect.aws.medialive.UpdateNodeStateResponse/State
     :cognitect.aws.medialive.UpdateNodeStateResponse/Name
     :cognitect.aws.medialive.UpdateNodeStateResponse/Id
     :cognitect.aws.medialive.UpdateNodeStateResponse/ChannelPlacementGroups
     :cognitect.aws.medialive.UpdateNodeStateResponse/InstanceArn]))

(s/def
  :cognitect.aws.medialive/RemixSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.RemixSettings/ChannelMappings]
    :opt-un
    [:cognitect.aws.medialive.RemixSettings/ChannelsOut
     :cognitect.aws.medialive.RemixSettings/ChannelsIn]))

(s/def :cognitect.aws.medialive/H265Tier (s/spec string? :gen #(s/gen #{"MAIN" "HIGH"})))

(s/def
  :cognitect.aws.medialive/Scte35AposNoRegionalBlackoutBehavior
  (s/spec string? :gen #(s/gen #{"FOLLOW" "IGNORE"})))

(s/def
  :cognitect.aws.medialive/InputDeviceRequest
  (s/keys :opt-un [:cognitect.aws.medialive.InputDeviceRequest/Id]))

(s/def
  :cognitect.aws.medialive/StaticImageActivateScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Image]
    :opt-un
    [:cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Opacity
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/ImageX
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Width
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Layer
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Duration
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/FadeIn
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Height
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/ImageY
     :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/FadeOut]))

(s/def :cognitect.aws.medialive/__string string?)

(s/def
  :cognitect.aws.medialive/FrameCaptureSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.FrameCaptureSettings/CaptureInterval
     :cognitect.aws.medialive.FrameCaptureSettings/CaptureIntervalUnits
     :cognitect.aws.medialive.FrameCaptureSettings/TimecodeBurninSettings]))

(s/def
  :cognitect.aws.medialive/SdiSource
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.SdiSource/Type
     :cognitect.aws.medialive.SdiSource/Mode
     :cognitect.aws.medialive.SdiSource/Inputs
     :cognitect.aws.medialive.SdiSource/Arn
     :cognitect.aws.medialive.SdiSource/State
     :cognitect.aws.medialive.SdiSource/Name
     :cognitect.aws.medialive.SdiSource/Id]))

(s/def
  :cognitect.aws.medialive/FollowModeScheduleActionStartSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.FollowModeScheduleActionStartSettings/ReferenceActionName
     :cognitect.aws.medialive.FollowModeScheduleActionStartSettings/FollowPoint]))

(s/def
  :cognitect.aws.medialive/SrtCallerDecryption
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.SrtCallerDecryption/Algorithm
     :cognitect.aws.medialive.SrtCallerDecryption/PassphraseSecretArn]))

(s/def
  :cognitect.aws.medialive/__listOfThumbnailDetail
  (s/coll-of :cognitect.aws.medialive/ThumbnailDetail))

(s/def
  :cognitect.aws.medialive/InputState
  (s/spec string? :gen #(s/gen #{"ATTACHED" "DELETING" "CREATING" "DETACHED" "DELETED"})))

(s/def
  :cognitect.aws.medialive/__integerMin800Max3000
  (s/spec (s/and int? #(<= 800 % 3000)) :gen #(gen/choose 800 3000)))

(s/def
  :cognitect.aws.medialive/ChannelClass
  (s/spec string? :gen #(s/gen #{"SINGLE_PIPELINE" "STANDARD"})))

(s/def
  :cognitect.aws.medialive/UpdateNodeRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateNodeRequest/NodeId
     :cognitect.aws.medialive.UpdateNodeRequest/ClusterId]
    :opt-un
    [:cognitect.aws.medialive.UpdateNodeRequest/Role
     :cognitect.aws.medialive.UpdateNodeRequest/SdiSourceMappings
     :cognitect.aws.medialive.UpdateNodeRequest/Name]))

(s/def
  :cognitect.aws.medialive/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.medialive.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.medialive/InputDestinationVpc
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDestinationVpc/NetworkInterfaceId
     :cognitect.aws.medialive.InputDestinationVpc/AvailabilityZone]))

(s/def
  :cognitect.aws.medialive/H265SceneChangeDetect
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/RebootInputDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.RebootInputDeviceRequest/InputDeviceId]
    :opt-un
    [:cognitect.aws.medialive.RebootInputDeviceRequest/Force]))

(s/def
  :cognitect.aws.medialive/H264AdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"AUTO" "LOW" "MAX" "HIGHER" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.medialive/PurchaseOfferingResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.PurchaseOfferingResultModel/Reservation]))

(s/def
  :cognitect.aws.medialive/MaintenanceStatus
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MaintenanceStatus/MaintenanceStartTime
     :cognitect.aws.medialive.MaintenanceStatus/MaintenanceScheduledDate
     :cognitect.aws.medialive.MaintenanceStatus/MaintenanceDeadline
     :cognitect.aws.medialive.MaintenanceStatus/MaintenanceDay]))

(s/def
  :cognitect.aws.medialive/InputDeviceMediaConnectConfigurableSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceMediaConnectConfigurableSettings/RoleArn
     :cognitect.aws.medialive.InputDeviceMediaConnectConfigurableSettings/SecretArn
     :cognitect.aws.medialive.InputDeviceMediaConnectConfigurableSettings/SourceName
     :cognitect.aws.medialive.InputDeviceMediaConnectConfigurableSettings/FlowArn]))

(s/def
  :cognitect.aws.medialive/GetCloudWatchAlarmTemplateGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Tags
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Description
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/ModifiedAt
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Arn
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/CreatedAt
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Name
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Id]))

(s/def
  :cognitect.aws.medialive/HlsCodecSpecification
  (s/spec string? :gen #(s/gen #{"RFC_4281" "RFC_6381"})))

(s/def
  :cognitect.aws.medialive/ListEventBridgeRuleTemplateGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsResponse/NextToken
     :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsResponse/EventBridgeRuleTemplateGroups]))

(s/def
  :cognitect.aws.medialive/ListInputSecurityGroupsResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputSecurityGroupsResultModel/InputSecurityGroups
     :cognitect.aws.medialive.ListInputSecurityGroupsResultModel/NextToken]))

(s/def
  :cognitect.aws.medialive/ListOfferingsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListOfferingsResponse/Offerings
     :cognitect.aws.medialive.ListOfferingsResponse/NextToken]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max1000000
  (s/spec (s/and int? #(<= 0 % 1000000)) :gen #(gen/choose 0 1000000)))

(s/def
  :cognitect.aws.medialive/AudioNormalizationAlgorithmControl
  (s/spec string? :gen #(s/gen #{"CORRECT_AUDIO"})))

(s/def
  :cognitect.aws.medialive/ListEventBridgeRuleTemplateGroupsResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsResponseContent/EventBridgeRuleTemplateGroups]
    :opt-un
    [:cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsResponseContent/NextToken]))

(s/def
  :cognitect.aws.medialive/M2tsEbpPlacement
  (s/spec string? :gen #(s/gen #{"VIDEO_AND_AUDIO_PIDS" "VIDEO_PID"})))

(s/def
  :cognitect.aws.medialive/OutputLockingSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.OutputLockingSettings/EpochLockingSettings
     :cognitect.aws.medialive.OutputLockingSettings/PipelineLockingSettings]))

(s/def
  :cognitect.aws.medialive/AudioPidSelection
  (s/keys :req-un [:cognitect.aws.medialive.AudioPidSelection/Pid]))

(s/def
  :cognitect.aws.medialive/InputDeviceUhdAudioChannelPairConfig
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceUhdAudioChannelPairConfig/Profile
     :cognitect.aws.medialive.InputDeviceUhdAudioChannelPairConfig/Id]))

(s/def
  :cognitect.aws.medialive/AccountConfiguration
  (s/keys :opt-un [:cognitect.aws.medialive.AccountConfiguration/KmsKeyId]))

(s/def
  :cognitect.aws.medialive/HlsCdnSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsCdnSettings/HlsBasicPutSettings
     :cognitect.aws.medialive.HlsCdnSettings/HlsWebdavSettings
     :cognitect.aws.medialive.HlsCdnSettings/HlsS3Settings
     :cognitect.aws.medialive.HlsCdnSettings/HlsMediaStoreSettings
     :cognitect.aws.medialive.HlsCdnSettings/HlsAkamaiSettings]))

(s/def
  :cognitect.aws.medialive/__listOfMediaConnectFlow
  (s/coll-of :cognitect.aws.medialive/MediaConnectFlow))

(s/def
  :cognitect.aws.medialive/StopMultiplexRequest
  (s/keys :req-un [:cognitect.aws.medialive.StopMultiplexRequest/MultiplexId]))

(s/def
  :cognitect.aws.medialive/InputDeviceConfigurationValidationError
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceConfigurationValidationError/Message
     :cognitect.aws.medialive.InputDeviceConfigurationValidationError/ValidationErrors]))

(s/def
  :cognitect.aws.medialive/FrameCaptureIntervalUnit
  (s/spec string? :gen #(s/gen #{"SECONDS" "MILLISECONDS"})))

(s/def
  :cognitect.aws.medialive/DescribeChannelPlacementGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DescribeChannelPlacementGroupRequest/ClusterId
     :cognitect.aws.medialive.DescribeChannelPlacementGroupRequest/ChannelPlacementGroupId]))

(s/def
  :cognitect.aws.medialive/InputAttachment
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputAttachment/InputId
     :cognitect.aws.medialive.InputAttachment/LogicalInterfaceNames
     :cognitect.aws.medialive.InputAttachment/InputSettings
     :cognitect.aws.medialive.InputAttachment/InputAttachmentName
     :cognitect.aws.medialive.InputAttachment/AutomaticInputFailoverSettings]))

(s/def
  :cognitect.aws.medialive/IFrameOnlyPlaylistType
  (s/spec string? :gen #(s/gen #{"DISABLED" "STANDARD"})))

(s/def
  :cognitect.aws.medialive/MotionGraphicsConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MotionGraphicsConfiguration/MotionGraphicsSettings]
    :opt-un
    [:cognitect.aws.medialive.MotionGraphicsConfiguration/MotionGraphicsInsertion]))

(s/def
  :cognitect.aws.medialive/BatchDeleteRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchDeleteRequest/InputSecurityGroupIds
     :cognitect.aws.medialive.BatchDeleteRequest/MultiplexIds
     :cognitect.aws.medialive.BatchDeleteRequest/ChannelIds
     :cognitect.aws.medialive.BatchDeleteRequest/InputIds]))

(s/def
  :cognitect.aws.medialive/__stringMax255
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/__listOfInterfaceMappingCreateRequest
  (s/coll-of :cognitect.aws.medialive/InterfaceMappingCreateRequest))

(s/def
  :cognitect.aws.medialive/Reservation
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Reservation/DurationUnits
     :cognitect.aws.medialive.Reservation/CurrencyCode
     :cognitect.aws.medialive.Reservation/OfferingDescription
     :cognitect.aws.medialive.Reservation/RenewalSettings
     :cognitect.aws.medialive.Reservation/ResourceSpecification
     :cognitect.aws.medialive.Reservation/Start
     :cognitect.aws.medialive.Reservation/FixedPrice
     :cognitect.aws.medialive.Reservation/End
     :cognitect.aws.medialive.Reservation/Count
     :cognitect.aws.medialive.Reservation/Tags
     :cognitect.aws.medialive.Reservation/OfferingId
     :cognitect.aws.medialive.Reservation/Duration
     :cognitect.aws.medialive.Reservation/UsagePrice
     :cognitect.aws.medialive.Reservation/Arn
     :cognitect.aws.medialive.Reservation/State
     :cognitect.aws.medialive.Reservation/OfferingType
     :cognitect.aws.medialive.Reservation/Name
     :cognitect.aws.medialive.Reservation/ReservationId
     :cognitect.aws.medialive.Reservation/Region]))

(s/def
  :cognitect.aws.medialive/StartDeleteMonitorDeploymentResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Tags
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Status
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/ErrorMessage
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/MonitorDeployment
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/DiscoveryEntryPointArn
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Description
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/ModifiedAt
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Arn
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/CreatedAt
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/FailedMediaResourceMap
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Name
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/MediaResourceMap
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/MonitorChangesPendingDeployment
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Id
     :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/VideoSelectorPid
  (s/keys :opt-un [:cognitect.aws.medialive.VideoSelectorPid/Pid]))

(s/def
  :cognitect.aws.medialive/Av1ColorSpaceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Av1ColorSpaceSettings/Hdr10Settings
     :cognitect.aws.medialive.Av1ColorSpaceSettings/Rec601Settings
     :cognitect.aws.medialive.Av1ColorSpaceSettings/Rec709Settings
     :cognitect.aws.medialive.Av1ColorSpaceSettings/ColorSpacePassthroughSettings]))

(s/def
  :cognitect.aws.medialive/SmoothGroupEventIdMode
  (s/spec string? :gen #(s/gen #{"USE_CONFIGURED" "NO_EVENT_ID" "USE_TIMESTAMP"})))

(s/def
  :cognitect.aws.medialive/FixedModeScheduleActionStartSettings
  (s/keys :req-un [:cognitect.aws.medialive.FixedModeScheduleActionStartSettings/Time]))

(s/def
  :cognitect.aws.medialive/HlsBasicPutSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsBasicPutSettings/NumRetries
     :cognitect.aws.medialive.HlsBasicPutSettings/FilecacheDuration
     :cognitect.aws.medialive.HlsBasicPutSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.HlsBasicPutSettings/RestartDelay]))

(s/def
  :cognitect.aws.medialive/BatchScheduleActionCreateRequest
  (s/keys :req-un [:cognitect.aws.medialive.BatchScheduleActionCreateRequest/ScheduleActions]))

(s/def
  :cognitect.aws.medialive/M2tsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.M2tsSettings/PatInterval
     :cognitect.aws.medialive.M2tsSettings/BufferModel
     :cognitect.aws.medialive.M2tsSettings/DvbTdtSettings
     :cognitect.aws.medialive.M2tsSettings/NielsenId3Behavior
     :cognitect.aws.medialive.M2tsSettings/AudioFramesPerPes
     :cognitect.aws.medialive.M2tsSettings/FragmentTime
     :cognitect.aws.medialive.M2tsSettings/TransportStreamId
     :cognitect.aws.medialive.M2tsSettings/TimedMetadataBehavior
     :cognitect.aws.medialive.M2tsSettings/DvbSdtSettings
     :cognitect.aws.medialive.M2tsSettings/AbsentInputAudioBehavior
     :cognitect.aws.medialive.M2tsSettings/PcrControl
     :cognitect.aws.medialive.M2tsSettings/Scte35Pid
     :cognitect.aws.medialive.M2tsSettings/PcrPid
     :cognitect.aws.medialive.M2tsSettings/PmtPid
     :cognitect.aws.medialive.M2tsSettings/VideoPid
     :cognitect.aws.medialive.M2tsSettings/RateMode
     :cognitect.aws.medialive.M2tsSettings/AudioPids
     :cognitect.aws.medialive.M2tsSettings/EtvPlatformPid
     :cognitect.aws.medialive.M2tsSettings/EbpLookaheadMs
     :cognitect.aws.medialive.M2tsSettings/Arib
     :cognitect.aws.medialive.M2tsSettings/Ebif
     :cognitect.aws.medialive.M2tsSettings/PcrPeriod
     :cognitect.aws.medialive.M2tsSettings/CcDescriptor
     :cognitect.aws.medialive.M2tsSettings/EtvSignalPid
     :cognitect.aws.medialive.M2tsSettings/PmtInterval
     :cognitect.aws.medialive.M2tsSettings/SegmentationStyle
     :cognitect.aws.medialive.M2tsSettings/NullPacketBitrate
     :cognitect.aws.medialive.M2tsSettings/SegmentationMarkers
     :cognitect.aws.medialive.M2tsSettings/EbpPlacement
     :cognitect.aws.medialive.M2tsSettings/Scte35Control
     :cognitect.aws.medialive.M2tsSettings/AudioBufferModel
     :cognitect.aws.medialive.M2tsSettings/EsRateInPes
     :cognitect.aws.medialive.M2tsSettings/Klv
     :cognitect.aws.medialive.M2tsSettings/ProgramNum
     :cognitect.aws.medialive.M2tsSettings/TimedMetadataPid
     :cognitect.aws.medialive.M2tsSettings/AudioStreamType
     :cognitect.aws.medialive.M2tsSettings/Scte27Pids
     :cognitect.aws.medialive.M2tsSettings/AribCaptionsPidControl
     :cognitect.aws.medialive.M2tsSettings/KlvDataPids
     :cognitect.aws.medialive.M2tsSettings/DvbSubPids
     :cognitect.aws.medialive.M2tsSettings/EbpAudioInterval
     :cognitect.aws.medialive.M2tsSettings/EcmPid
     :cognitect.aws.medialive.M2tsSettings/DvbNitSettings
     :cognitect.aws.medialive.M2tsSettings/DvbTeletextPid
     :cognitect.aws.medialive.M2tsSettings/AribCaptionsPid
     :cognitect.aws.medialive.M2tsSettings/Bitrate
     :cognitect.aws.medialive.M2tsSettings/SegmentationTime
     :cognitect.aws.medialive.M2tsSettings/Scte35PrerollPullupMilliseconds]))

(s/def
  :cognitect.aws.medialive/H264TemporalAq
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/__listOfSignalMapSummary
  (s/coll-of :cognitect.aws.medialive/SignalMapSummary))

(s/def
  :cognitect.aws.medialive/ListInputsResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputsResultModel/NextToken
     :cognitect.aws.medialive.ListInputsResultModel/Inputs]))

(s/def
  :cognitect.aws.medialive/BadGatewayException
  (s/keys :opt-un [:cognitect.aws.medialive.BadGatewayException/Message]))

(s/def
  :cognitect.aws.medialive/CreateMultiplexRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateMultiplexRequest/RequestId
     :cognitect.aws.medialive.CreateMultiplexRequest/MultiplexSettings
     :cognitect.aws.medialive.CreateMultiplexRequest/AvailabilityZones
     :cognitect.aws.medialive.CreateMultiplexRequest/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateMultiplexRequest/Tags]))

(s/def
  :cognitect.aws.medialive/__listOfInputSourceRequest
  (s/coll-of :cognitect.aws.medialive/InputSourceRequest))

(s/def
  :cognitect.aws.medialive/InputVpcRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.InputVpcRequest/SubnetIds]
    :opt-un
    [:cognitect.aws.medialive.InputVpcRequest/SecurityGroupIds]))

(s/def :cognitect.aws.medialive/__listOfAudioTrack (s/coll-of :cognitect.aws.medialive/AudioTrack))

(s/def
  :cognitect.aws.medialive/TooManyRequestsExceptionResponseContent
  (s/keys :opt-un [:cognitect.aws.medialive.TooManyRequestsExceptionResponseContent/Message]))

(s/def
  :cognitect.aws.medialive/DvbSubDestinationBackgroundColor
  (s/spec string? :gen #(s/gen #{"NONE" "WHITE" "BLACK"})))

(s/def
  :cognitect.aws.medialive/__stringMin3Max3
  (s/spec
    (s/and string? #(<= 3 (count %) 3))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 3 3) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/InputMaximumBitrate
  (s/spec string? :gen #(s/gen #{"MAX_10_MBPS" "MAX_50_MBPS" "MAX_20_MBPS"})))

(s/def
  :cognitect.aws.medialive/ChannelState
  (s/spec
    string?
    :gen
    #(s/gen
      #{"IDLE"
        "CREATE_FAILED"
        "UPDATING"
        "STARTING"
        "DELETING"
        "CREATING"
        "DELETED"
        "RECOVERING"
        "STOPPING"
        "RUNNING"
        "UPDATE_FAILED"})))

(s/def
  :cognitect.aws.medialive/__doubleMin1Max65535
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/Av1LookAheadRateControl
  (s/spec string? :gen #(s/gen #{"LOW" "HIGH" "MEDIUM"})))

(s/def
  :cognitect.aws.medialive/MultiplexProgramServiceDescriptor
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MultiplexProgramServiceDescriptor/ProviderName
     :cognitect.aws.medialive.MultiplexProgramServiceDescriptor/ServiceName]))

(s/def
  :cognitect.aws.medialive/ClusterNetworkSettingsCreateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ClusterNetworkSettingsCreateRequest/InterfaceMappings
     :cognitect.aws.medialive.ClusterNetworkSettingsCreateRequest/DefaultRoute]))

(s/def
  :cognitect.aws.medialive/BlackoutSlateState
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/PipelineId
  (s/spec string? :gen #(s/gen #{"PIPELINE_0" "PIPELINE_1"})))

(s/def
  :cognitect.aws.medialive/ClusterNetworkSettingsUpdateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ClusterNetworkSettingsUpdateRequest/InterfaceMappings
     :cognitect.aws.medialive.ClusterNetworkSettingsUpdateRequest/DefaultRoute]))

(s/def
  :cognitect.aws.medialive/Eac3SurroundExMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "NOT_INDICATED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/CreateSignalMapRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateSignalMapRequest/DiscoveryEntryPointArn
     :cognitect.aws.medialive.CreateSignalMapRequest/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateSignalMapRequest/RequestId
     :cognitect.aws.medialive.CreateSignalMapRequest/Tags
     :cognitect.aws.medialive.CreateSignalMapRequest/EventBridgeRuleTemplateGroupIdentifiers
     :cognitect.aws.medialive.CreateSignalMapRequest/CloudWatchAlarmTemplateGroupIdentifiers
     :cognitect.aws.medialive.CreateSignalMapRequest/Description]))

(s/def
  :cognitect.aws.medialive/Eac3AtmosDrcLine
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def
  :cognitect.aws.medialive/CancelInputDeviceTransferRequest
  (s/keys :req-un [:cognitect.aws.medialive.CancelInputDeviceTransferRequest/InputDeviceId]))

(s/def
  :cognitect.aws.medialive/M3u8PcrControl
  (s/spec string? :gen #(s/gen #{"CONFIGURED_PCR_PERIOD" "PCR_EVERY_PES_PACKET"})))

(s/def
  :cognitect.aws.medialive/BatchScheduleActionDeleteResult
  (s/keys :req-un [:cognitect.aws.medialive.BatchScheduleActionDeleteResult/ScheduleActions]))

(s/def
  :cognitect.aws.medialive/__listOfInputWhitelistRule
  (s/coll-of :cognitect.aws.medialive/InputWhitelistRule))

(s/def
  :cognitect.aws.medialive/GetSignalMapRequest
  (s/keys :req-un [:cognitect.aws.medialive.GetSignalMapRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/MulticastSourceCreateRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MulticastSourceCreateRequest/Url]
    :opt-un
    [:cognitect.aws.medialive.MulticastSourceCreateRequest/SourceIp]))

(s/def :cognitect.aws.medialive/ListVersionsRequest (s/keys))

(s/def
  :cognitect.aws.medialive/CreateEventBridgeRuleTemplateGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequest/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequest/RequestId
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequest/Tags
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequest/Description]))

(s/def
  :cognitect.aws.medialive/IpPoolCreateRequest
  (s/keys :opt-un [:cognitect.aws.medialive.IpPoolCreateRequest/Cidr]))

(s/def :cognitect.aws.medialive/ThumbnailNoData (s/keys))

(s/def
  :cognitect.aws.medialive/__listOfBatchFailedResultModel
  (s/coll-of :cognitect.aws.medialive/BatchFailedResultModel))

(s/def
  :cognitect.aws.medialive/InternalServerErrorException
  (s/keys :opt-un [:cognitect.aws.medialive.InternalServerErrorException/Message]))

(s/def
  :cognitect.aws.medialive/StartChannelRequest
  (s/keys :req-un [:cognitect.aws.medialive.StartChannelRequest/ChannelId]))

(s/def
  :cognitect.aws.medialive/InputDeviceIpScheme
  (s/spec string? :gen #(s/gen #{"DHCP" "STATIC"})))

(s/def
  :cognitect.aws.medialive/StartTimecode
  (s/keys :opt-un [:cognitect.aws.medialive.StartTimecode/Timecode]))

(s/def
  :cognitect.aws.medialive/__listOfMulticastSourceUpdateRequest
  (s/coll-of :cognitect.aws.medialive/MulticastSourceUpdateRequest))

(s/def
  :cognitect.aws.medialive/UpdateCloudWatchAlarmTemplateResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/TargetResourceType
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/TreatMissingData
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/ComparisonOperator
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/CreatedAt
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Period
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/EvaluationPeriods
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Name
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/GroupId
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/MetricName
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Statistic
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Id
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Arn
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Threshold]
    :opt-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Tags
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/DatapointsToAlarm
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Description
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/UpdateInputSecurityGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateInputSecurityGroupRequest/InputSecurityGroupId]
    :opt-un
    [:cognitect.aws.medialive.UpdateInputSecurityGroupRequest/Tags
     :cognitect.aws.medialive.UpdateInputSecurityGroupRequest/WhitelistRules]))

(s/def :cognitect.aws.medialive/M2tsAudioBufferModel (s/spec string? :gen #(s/gen #{"DVB" "ATSC"})))

(s/def
  :cognitect.aws.medialive/__integerMin0Max600
  (s/spec (s/and int? #(<= 0 % 600)) :gen #(gen/choose 0 600)))

(s/def
  :cognitect.aws.medialive/CdiInputResolution
  (s/spec string? :gen #(s/gen #{"UHD" "SD" "FHD" "HD"})))

(s/def
  :cognitect.aws.medialive/UpdateEventBridgeRuleTemplateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Tags
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/GroupId
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/EventType
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Description
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/EventTargets
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/ModifiedAt
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Arn
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/CreatedAt
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Name
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Id]))

(s/def
  :cognitect.aws.medialive/__integerMin1000000Max100000000
  (s/spec (s/and int? #(<= 1000000 % 100000000)) :gen #(gen/choose 1000000 100000000)))

(s/def
  :cognitect.aws.medialive/__listOfDescribeClusterSummary
  (s/coll-of :cognitect.aws.medialive/DescribeClusterSummary))

(s/def
  :cognitect.aws.medialive/__integerMin0
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.medialive/__stringMin1Max255PatternS
  (s/spec #(re-matches (re-pattern "^[^\\s]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.medialive/__listOfInputDestination
  (s/coll-of :cognitect.aws.medialive/InputDestination))

(s/def
  :cognitect.aws.medialive/UpdateAccountConfigurationRequestModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateAccountConfigurationRequestModel/AccountConfiguration]))

(s/def
  :cognitect.aws.medialive/InputPrepareScheduleActionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputPrepareScheduleActionSettings/InputAttachmentNameReference
     :cognitect.aws.medialive.InputPrepareScheduleActionSettings/InputClippingSettings
     :cognitect.aws.medialive.InputPrepareScheduleActionSettings/UrlPath]))

(s/def
  :cognitect.aws.medialive/TransferInputDevice
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.TransferInputDevice/TargetRegion
     :cognitect.aws.medialive.TransferInputDevice/TransferMessage
     :cognitect.aws.medialive.TransferInputDevice/TargetCustomerId]))

(s/def
  :cognitect.aws.medialive/DescribeNodeRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DescribeNodeRequest/NodeId
     :cognitect.aws.medialive.DescribeNodeRequest/ClusterId]))

(s/def
  :cognitect.aws.medialive/H264SpatialAq
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/ListNetworksRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListNetworksRequest/NextToken
     :cognitect.aws.medialive.ListNetworksRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/UpdateMultiplexProgramResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateMultiplexProgramResultModel/MultiplexProgram]))

(s/def
  :cognitect.aws.medialive/InputDeviceConfiguredInput
  (s/spec string? :gen #(s/gen #{"HDMI" "AUTO" "SDI"})))

(s/def
  :cognitect.aws.medialive/ScheduleActionStartSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ScheduleActionStartSettings/FixedModeScheduleActionStartSettings
     :cognitect.aws.medialive.ScheduleActionStartSettings/FollowModeScheduleActionStartSettings
     :cognitect.aws.medialive.ScheduleActionStartSettings/ImmediateModeScheduleActionStartSettings]))

(s/def
  :cognitect.aws.medialive/StartDeleteMonitorDeploymentRequest
  (s/keys :req-un [:cognitect.aws.medialive.StartDeleteMonitorDeploymentRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max100000000
  (s/spec (s/and int? #(<= 0 % 100000000)) :gen #(gen/choose 0 100000000)))

(s/def :cognitect.aws.medialive/StopInputDeviceResponse (s/keys))

(s/def :cognitect.aws.medialive/Av1RateControlMode (s/spec string? :gen #(s/gen #{"CBR" "QVBR"})))

(s/def
  :cognitect.aws.medialive/OutputGroup
  (s/keys
    :req-un
    [:cognitect.aws.medialive.OutputGroup/Outputs
     :cognitect.aws.medialive.OutputGroup/OutputGroupSettings]
    :opt-un
    [:cognitect.aws.medialive.OutputGroup/Name]))

(s/def :cognitect.aws.medialive/AacProfile (s/spec string? :gen #(s/gen #{"LC" "HEV2" "HEV1"})))

(s/def
  :cognitect.aws.medialive/ScheduleActionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ScheduleActionSettings/Scte35InputSettings
     :cognitect.aws.medialive.ScheduleActionSettings/TimedMetadataSettings
     :cognitect.aws.medialive.ScheduleActionSettings/MotionGraphicsImageActivateSettings
     :cognitect.aws.medialive.ScheduleActionSettings/Scte35SpliceInsertSettings
     :cognitect.aws.medialive.ScheduleActionSettings/StaticImageOutputActivateSettings
     :cognitect.aws.medialive.ScheduleActionSettings/MotionGraphicsImageDeactivateSettings
     :cognitect.aws.medialive.ScheduleActionSettings/Scte35TimeSignalSettings
     :cognitect.aws.medialive.ScheduleActionSettings/Id3SegmentTaggingSettings
     :cognitect.aws.medialive.ScheduleActionSettings/InputPrepareSettings
     :cognitect.aws.medialive.ScheduleActionSettings/PauseStateSettings
     :cognitect.aws.medialive.ScheduleActionSettings/InputSwitchSettings
     :cognitect.aws.medialive.ScheduleActionSettings/Scte35ReturnToNetworkSettings
     :cognitect.aws.medialive.ScheduleActionSettings/StaticImageActivateSettings
     :cognitect.aws.medialive.ScheduleActionSettings/HlsId3SegmentTaggingSettings
     :cognitect.aws.medialive.ScheduleActionSettings/StaticImageDeactivateSettings
     :cognitect.aws.medialive.ScheduleActionSettings/HlsTimedMetadataSettings
     :cognitect.aws.medialive.ScheduleActionSettings/StaticImageOutputDeactivateSettings]))

(s/def
  :cognitect.aws.medialive/WebvttDestinationStyleControl
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_STYLE_DATA"})))

(s/def
  :cognitect.aws.medialive/EmbeddedSourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.EmbeddedSourceSettings/Source608ChannelNumber
     :cognitect.aws.medialive.EmbeddedSourceSettings/Convert608To708
     :cognitect.aws.medialive.EmbeddedSourceSettings/Scte20Detection
     :cognitect.aws.medialive.EmbeddedSourceSettings/Source608TrackNumber]))

(s/def
  :cognitect.aws.medialive/BatchStopRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchStopRequest/MultiplexIds
     :cognitect.aws.medialive.BatchStopRequest/ChannelIds]))

(s/def
  :cognitect.aws.medialive/InputSourceRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSourceRequest/Username
     :cognitect.aws.medialive.InputSourceRequest/Url
     :cognitect.aws.medialive.InputSourceRequest/PasswordParam]))

(s/def
  :cognitect.aws.medialive/CreateMultiplexResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreateMultiplexResponse/Multiplex]))

(s/def
  :cognitect.aws.medialive/Output
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Output/OutputSettings]
    :opt-un
    [:cognitect.aws.medialive.Output/VideoDescriptionName
     :cognitect.aws.medialive.Output/AudioDescriptionNames
     :cognitect.aws.medialive.Output/CaptionDescriptionNames
     :cognitect.aws.medialive.Output/OutputName]))

(s/def
  :cognitect.aws.medialive/UpdateSdiSourceResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateSdiSourceResponse/SdiSource]))

(s/def
  :cognitect.aws.medialive/DolbyEProgramSelection
  (s/spec
    string?
    :gen
    #(s/gen
      #{"PROGRAM_2"
        "PROGRAM_1"
        "ALL_CHANNELS"
        "PROGRAM_4"
        "PROGRAM_7"
        "PROGRAM_6"
        "PROGRAM_5"
        "PROGRAM_8"
        "PROGRAM_3"})))

(s/def
  :cognitect.aws.medialive/Scte35SegmentationScope
  (s/spec string? :gen #(s/gen #{"ALL_OUTPUT_GROUPS" "SCTE35_ENABLED_OUTPUT_GROUPS"})))

(s/def
  :cognitect.aws.medialive/ChannelPipelineIdToRestart
  (s/spec string? :gen #(s/gen #{"PIPELINE_0" "PIPELINE_1"})))

(s/def
  :cognitect.aws.medialive/KeyProviderSettings
  (s/keys :opt-un [:cognitect.aws.medialive.KeyProviderSettings/StaticKeySettings]))

(s/def
  :cognitect.aws.medialive/__stringMin1Max255
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/__listOfHlsAdMarkers
  (s/coll-of :cognitect.aws.medialive/HlsAdMarkers))

(s/def
  :cognitect.aws.medialive/StopMultiplexResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StopMultiplexResponse/ProgramCount
     :cognitect.aws.medialive.StopMultiplexResponse/PipelinesRunningCount
     :cognitect.aws.medialive.StopMultiplexResponse/Tags
     :cognitect.aws.medialive.StopMultiplexResponse/Arn
     :cognitect.aws.medialive.StopMultiplexResponse/MultiplexSettings
     :cognitect.aws.medialive.StopMultiplexResponse/State
     :cognitect.aws.medialive.StopMultiplexResponse/Destinations
     :cognitect.aws.medialive.StopMultiplexResponse/Name
     :cognitect.aws.medialive.StopMultiplexResponse/AvailabilityZones
     :cognitect.aws.medialive.StopMultiplexResponse/Id]))

(s/def
  :cognitect.aws.medialive/__listOfMultiplexProgramPipelineDetail
  (s/coll-of :cognitect.aws.medialive/MultiplexProgramPipelineDetail))

(s/def
  :cognitect.aws.medialive/Mp2Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Mp2Settings/CodingMode
     :cognitect.aws.medialive.Mp2Settings/SampleRate
     :cognitect.aws.medialive.Mp2Settings/Bitrate]))

(s/def :cognitect.aws.medialive/PassThroughSettings (s/keys))

(s/def
  :cognitect.aws.medialive/SrtCallerSourceRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.SrtCallerSourceRequest/StreamId
     :cognitect.aws.medialive.SrtCallerSourceRequest/SrtListenerPort
     :cognitect.aws.medialive.SrtCallerSourceRequest/Decryption
     :cognitect.aws.medialive.SrtCallerSourceRequest/MinimumLatency
     :cognitect.aws.medialive.SrtCallerSourceRequest/SrtListenerAddress]))

(s/def
  :cognitect.aws.medialive/StartInputDeviceMaintenanceWindowRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StartInputDeviceMaintenanceWindowRequest/InputDeviceId]))

(s/def
  :cognitect.aws.medialive/DescribeInputSecurityGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DescribeInputSecurityGroupRequest/InputSecurityGroupId]))

(s/def
  :cognitect.aws.medialive/SignalMapSummary
  (s/keys
    :req-un
    [:cognitect.aws.medialive.SignalMapSummary/Status
     :cognitect.aws.medialive.SignalMapSummary/MonitorDeploymentStatus
     :cognitect.aws.medialive.SignalMapSummary/CreatedAt
     :cognitect.aws.medialive.SignalMapSummary/Id
     :cognitect.aws.medialive.SignalMapSummary/Arn
     :cognitect.aws.medialive.SignalMapSummary/Name]
    :opt-un
    [:cognitect.aws.medialive.SignalMapSummary/Tags
     :cognitect.aws.medialive.SignalMapSummary/Description
     :cognitect.aws.medialive.SignalMapSummary/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/DeleteEventBridgeRuleTemplateRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteEventBridgeRuleTemplateRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/ChannelEgressEndpoint
  (s/keys :opt-un [:cognitect.aws.medialive.ChannelEgressEndpoint/SourceIp]))

(s/def
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplate
  (s/spec
    #(re-matches (re-pattern "^arn:.+:medialive:.+:eventbridge-rule-template:.+$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.medialive/ListReservationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListReservationsRequest/ChannelClass
     :cognitect.aws.medialive.ListReservationsRequest/Codec
     :cognitect.aws.medialive.ListReservationsRequest/Resolution
     :cognitect.aws.medialive.ListReservationsRequest/NextToken
     :cognitect.aws.medialive.ListReservationsRequest/MaximumBitrate
     :cognitect.aws.medialive.ListReservationsRequest/ResourceType
     :cognitect.aws.medialive.ListReservationsRequest/MaxResults
     :cognitect.aws.medialive.ListReservationsRequest/VideoQuality
     :cognitect.aws.medialive.ListReservationsRequest/SpecialFeature
     :cognitect.aws.medialive.ListReservationsRequest/MaximumFramerate]))

(s/def
  :cognitect.aws.medialive/AuthenticationScheme
  (s/spec string? :gen #(s/gen #{"AKAMAI" "COMMON"})))

(s/def
  :cognitect.aws.medialive/DescribeInputDeviceRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeInputDeviceRequest/InputDeviceId]))

(s/def
  :cognitect.aws.medialive/EpochLockingSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.EpochLockingSettings/CustomEpoch
     :cognitect.aws.medialive.EpochLockingSettings/JamSyncTime]))

(s/def
  :cognitect.aws.medialive/MultiplexSettingsSummary
  (s/keys :opt-un [:cognitect.aws.medialive.MultiplexSettingsSummary/TransportStreamBitrate]))

(s/def
  :cognitect.aws.medialive/RtmpCaptionData
  (s/spec string? :gen #(s/gen #{"FIELD1_608" "FIELD1_AND_FIELD2_608" "ALL"})))

(s/def :cognitect.aws.medialive/DeleteInputSecurityGroupResponse (s/keys))

(s/def :cognitect.aws.medialive/AacSpec (s/spec string? :gen #(s/gen #{"MPEG4" "MPEG2"})))

(s/def
  :cognitect.aws.medialive/CreateSdiSourceResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreateSdiSourceResponse/SdiSource]))

(s/def
  :cognitect.aws.medialive/Mpeg2AdaptiveQuantization
  (s/spec string? :gen #(s/gen #{"AUTO" "LOW" "HIGH" "OFF" "MEDIUM"})))

(s/def
  :cognitect.aws.medialive/CreateMultiplex
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateMultiplex/RequestId
     :cognitect.aws.medialive.CreateMultiplex/MultiplexSettings
     :cognitect.aws.medialive.CreateMultiplex/AvailabilityZones
     :cognitect.aws.medialive.CreateMultiplex/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateMultiplex/Tags]))

(s/def
  :cognitect.aws.medialive/InputDestination
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDestination/Url
     :cognitect.aws.medialive.InputDestination/Port
     :cognitect.aws.medialive.InputDestination/Network
     :cognitect.aws.medialive.InputDestination/Vpc
     :cognitect.aws.medialive.InputDestination/Ip
     :cognitect.aws.medialive.InputDestination/NetworkRoutes]))

(s/def
  :cognitect.aws.medialive/UpdateCloudWatchAlarmTemplateGroupResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/CreatedAt
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Id
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Arn
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Name]
    :opt-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Tags
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Description
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/CreateEventBridgeRuleTemplateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Tags
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/GroupId
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/EventType
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Description
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/EventTargets
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/ModifiedAt
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Arn
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/CreatedAt
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Name
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Id]))

(s/def
  :cognitect.aws.medialive/BatchScheduleActionCreateResult
  (s/keys :req-un [:cognitect.aws.medialive.BatchScheduleActionCreateResult/ScheduleActions]))

(s/def
  :cognitect.aws.medialive/UpdateInputRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateInputRequest/InputId]
    :opt-un
    [:cognitect.aws.medialive.UpdateInputRequest/MediaConnectFlows
     :cognitect.aws.medialive.UpdateInputRequest/InputSecurityGroups
     :cognitect.aws.medialive.UpdateInputRequest/SdiSources
     :cognitect.aws.medialive.UpdateInputRequest/RoleArn
     :cognitect.aws.medialive.UpdateInputRequest/Smpte2110ReceiverGroupSettings
     :cognitect.aws.medialive.UpdateInputRequest/SrtSettings
     :cognitect.aws.medialive.UpdateInputRequest/MulticastSettings
     :cognitect.aws.medialive.UpdateInputRequest/InputDevices
     :cognitect.aws.medialive.UpdateInputRequest/Destinations
     :cognitect.aws.medialive.UpdateInputRequest/Name
     :cognitect.aws.medialive.UpdateInputRequest/Sources]))

(s/def
  :cognitect.aws.medialive/CreateNodeRegistrationScriptRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/ClusterId]
    :opt-un
    [:cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/RequestId
     :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/Role
     :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/NodeInterfaceMappings
     :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/Name
     :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/Id]))

(s/def
  :cognitect.aws.medialive/DescribeChannelPlacementGroupSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Nodes
     :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/ClusterId
     :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Arn
     :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/State
     :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Name
     :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Id
     :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Channels]))

(s/def
  :cognitect.aws.medialive/Eac3AtmosDrcRf
  (s/spec
    string?
    :gen
    #(s/gen #{"MUSIC_LIGHT" "FILM_STANDARD" "NONE" "FILM_LIGHT" "SPEECH" "MUSIC_STANDARD"})))

(s/def
  :cognitect.aws.medialive/UpdateChannelResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateChannelResponse/Channel]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max20
  (s/spec (s/and int? #(<= 1 % 20)) :gen #(gen/choose 1 20)))

(s/def
  :cognitect.aws.medialive/__integerMin0Max100
  (s/spec (s/and int? #(<= 0 % 100)) :gen #(gen/choose 0 100)))

(s/def
  :cognitect.aws.medialive/BatchUpdateScheduleRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.BatchUpdateScheduleRequest/ChannelId]
    :opt-un
    [:cognitect.aws.medialive.BatchUpdateScheduleRequest/Creates
     :cognitect.aws.medialive.BatchUpdateScheduleRequest/Deletes]))

(s/def
  :cognitect.aws.medialive/DescribeThumbnailsRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DescribeThumbnailsRequest/ThumbnailType
     :cognitect.aws.medialive.DescribeThumbnailsRequest/PipelineId
     :cognitect.aws.medialive.DescribeThumbnailsRequest/ChannelId]))

(s/def
  :cognitect.aws.medialive/CmafIngestGroupSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CmafIngestGroupSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.CmafIngestGroupSettings/SegmentLength
     :cognitect.aws.medialive.CmafIngestGroupSettings/NielsenId3Behavior
     :cognitect.aws.medialive.CmafIngestGroupSettings/Id3Behavior
     :cognitect.aws.medialive.CmafIngestGroupSettings/CaptionLanguageMappings
     :cognitect.aws.medialive.CmafIngestGroupSettings/TimedMetadataId3Frame
     :cognitect.aws.medialive.CmafIngestGroupSettings/Scte35Type
     :cognitect.aws.medialive.CmafIngestGroupSettings/KlvBehavior
     :cognitect.aws.medialive.CmafIngestGroupSettings/KlvNameModifier
     :cognitect.aws.medialive.CmafIngestGroupSettings/SendDelayMs
     :cognitect.aws.medialive.CmafIngestGroupSettings/Scte35NameModifier
     :cognitect.aws.medialive.CmafIngestGroupSettings/NielsenId3NameModifier
     :cognitect.aws.medialive.CmafIngestGroupSettings/TimedMetadataId3Period
     :cognitect.aws.medialive.CmafIngestGroupSettings/AdditionalDestinations
     :cognitect.aws.medialive.CmafIngestGroupSettings/TimedMetadataPassthrough
     :cognitect.aws.medialive.CmafIngestGroupSettings/SegmentLengthUnits
     :cognitect.aws.medialive.CmafIngestGroupSettings/Id3NameModifier]))

(s/def
  :cognitect.aws.medialive/DeleteChannelRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteChannelRequest/ChannelId]))

(s/def
  :cognitect.aws.medialive/UpdateEventBridgeRuleTemplateGroupRequestContent
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupRequestContent/Description]))

(s/def
  :cognitect.aws.medialive/ArchiveOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ArchiveOutputSettings/ContainerSettings]
    :opt-un
    [:cognitect.aws.medialive.ArchiveOutputSettings/NameModifier
     :cognitect.aws.medialive.ArchiveOutputSettings/Extension]))

(s/def
  :cognitect.aws.medialive/MsSmoothGroupSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MsSmoothGroupSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.MsSmoothGroupSettings/FragmentLength
     :cognitect.aws.medialive.MsSmoothGroupSettings/InputLossAction
     :cognitect.aws.medialive.MsSmoothGroupSettings/EventStopBehavior
     :cognitect.aws.medialive.MsSmoothGroupSettings/AcquisitionPointId
     :cognitect.aws.medialive.MsSmoothGroupSettings/StreamManifestBehavior
     :cognitect.aws.medialive.MsSmoothGroupSettings/NumRetries
     :cognitect.aws.medialive.MsSmoothGroupSettings/FilecacheDuration
     :cognitect.aws.medialive.MsSmoothGroupSettings/SparseTrackType
     :cognitect.aws.medialive.MsSmoothGroupSettings/CertificateMode
     :cognitect.aws.medialive.MsSmoothGroupSettings/SendDelayMs
     :cognitect.aws.medialive.MsSmoothGroupSettings/EventIdMode
     :cognitect.aws.medialive.MsSmoothGroupSettings/SegmentationMode
     :cognitect.aws.medialive.MsSmoothGroupSettings/AudioOnlyTimecodeControl
     :cognitect.aws.medialive.MsSmoothGroupSettings/TimestampOffset
     :cognitect.aws.medialive.MsSmoothGroupSettings/EventId
     :cognitect.aws.medialive.MsSmoothGroupSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.MsSmoothGroupSettings/TimestampOffsetMode
     :cognitect.aws.medialive.MsSmoothGroupSettings/RestartDelay]))

(s/def
  :cognitect.aws.medialive/SmoothGroupStreamManifestBehavior
  (s/spec string? :gen #(s/gen #{"SEND" "DO_NOT_SEND"})))

(s/def
  :cognitect.aws.medialive/__integerMin100000Max40000000
  (s/spec (s/and int? #(<= 100000 % 40000000)) :gen #(gen/choose 100000 40000000)))

(s/def
  :cognitect.aws.medialive/BatchStart
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchStart/MultiplexIds
     :cognitect.aws.medialive.BatchStart/ChannelIds]))

(s/def
  :cognitect.aws.medialive/CreateMultiplexProgramResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.CreateMultiplexProgramResultModel/MultiplexProgram]))

(s/def
  :cognitect.aws.medialive/UdpTimedMetadataId3Frame
  (s/spec string? :gen #(s/gen #{"TDRL" "NONE" "PRIV"})))

(s/def
  :cognitect.aws.medialive/FrameCaptureOutputSettings
  (s/keys :opt-un [:cognitect.aws.medialive.FrameCaptureOutputSettings/NameModifier]))

(s/def
  :cognitect.aws.medialive/UpdateInputSecurityGroupResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateInputSecurityGroupResponse/SecurityGroup]))

(s/def
  :cognitect.aws.medialive/__listOfDescribeChannelPlacementGroupSummary
  (s/coll-of :cognitect.aws.medialive/DescribeChannelPlacementGroupSummary))

(s/def
  :cognitect.aws.medialive/InputPreference
  (s/spec string? :gen #(s/gen #{"EQUAL_INPUT_PREFERENCE" "PRIMARY_INPUT_PREFERRED"})))

(s/def
  :cognitect.aws.medialive/SmoothGroupAudioOnlyTimecodeControl
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "USE_CONFIGURED_CLOCK"})))

(s/def
  :cognitect.aws.medialive/InputLossActionForRtmpOut
  (s/spec string? :gen #(s/gen #{"PAUSE_OUTPUT" "EMIT_OUTPUT"})))

(s/def
  :cognitect.aws.medialive/InputDeviceConfigurableSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceConfigurableSettings/Codec
     :cognitect.aws.medialive.InputDeviceConfigurableSettings/AudioChannelPairs
     :cognitect.aws.medialive.InputDeviceConfigurableSettings/ConfiguredInput
     :cognitect.aws.medialive.InputDeviceConfigurableSettings/LatencyMs
     :cognitect.aws.medialive.InputDeviceConfigurableSettings/MaxBitrate
     :cognitect.aws.medialive.InputDeviceConfigurableSettings/MediaconnectSettings
     :cognitect.aws.medialive.InputDeviceConfigurableSettings/InputResolution]))

(s/def
  :cognitect.aws.medialive/Eac3StereoDownmix
  (s/spec string? :gen #(s/gen #{"NOT_INDICATED" "LO_RO" "LT_RT" "DPL2"})))

(s/def
  :cognitect.aws.medialive/StartMultiplexResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StartMultiplexResponse/ProgramCount
     :cognitect.aws.medialive.StartMultiplexResponse/PipelinesRunningCount
     :cognitect.aws.medialive.StartMultiplexResponse/Tags
     :cognitect.aws.medialive.StartMultiplexResponse/Arn
     :cognitect.aws.medialive.StartMultiplexResponse/MultiplexSettings
     :cognitect.aws.medialive.StartMultiplexResponse/State
     :cognitect.aws.medialive.StartMultiplexResponse/Destinations
     :cognitect.aws.medialive.StartMultiplexResponse/Name
     :cognitect.aws.medialive.StartMultiplexResponse/AvailabilityZones
     :cognitect.aws.medialive.StartMultiplexResponse/Id]))

(s/def
  :cognitect.aws.medialive/PipelinePauseStateSettings
  (s/keys :req-un [:cognitect.aws.medialive.PipelinePauseStateSettings/PipelineId]))

(s/def
  :cognitect.aws.medialive/HlsId3SegmentTaggingScheduleActionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsId3SegmentTaggingScheduleActionSettings/Tag
     :cognitect.aws.medialive.HlsId3SegmentTaggingScheduleActionSettings/Id3]))

(s/def
  :cognitect.aws.medialive/UpdateEventBridgeRuleTemplateGroupResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/CreatedAt
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Id
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Arn
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Name]
    :opt-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Tags
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Description
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/DescribeClusterSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeClusterSummary/NetworkSettings
     :cognitect.aws.medialive.DescribeClusterSummary/ClusterType
     :cognitect.aws.medialive.DescribeClusterSummary/Arn
     :cognitect.aws.medialive.DescribeClusterSummary/InstanceRoleArn
     :cognitect.aws.medialive.DescribeClusterSummary/State
     :cognitect.aws.medialive.DescribeClusterSummary/Name
     :cognitect.aws.medialive.DescribeClusterSummary/ChannelIds
     :cognitect.aws.medialive.DescribeClusterSummary/Id]))

(s/def
  :cognitect.aws.medialive/UpdateChannelPlacementGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Nodes
     :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/ClusterId
     :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Arn
     :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/State
     :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Name
     :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Id
     :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Channels]))

(s/def
  :cognitect.aws.medialive/DvbSubDestinationTeletextGridControl
  (s/spec string? :gen #(s/gen #{"FIXED" "SCALED"})))

(s/def
  :cognitect.aws.medialive/CmafId3Behavior
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/AudioLanguageSelectionPolicy
  (s/spec string? :gen #(s/gen #{"LOOSE" "STRICT"})))

(s/def
  :cognitect.aws.medialive/DeleteNetworkResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteNetworkResponse/Routes
     :cognitect.aws.medialive.DeleteNetworkResponse/IpPools
     :cognitect.aws.medialive.DeleteNetworkResponse/AssociatedClusterIds
     :cognitect.aws.medialive.DeleteNetworkResponse/Arn
     :cognitect.aws.medialive.DeleteNetworkResponse/State
     :cognitect.aws.medialive.DeleteNetworkResponse/Name
     :cognitect.aws.medialive.DeleteNetworkResponse/Id]))

(s/def :cognitect.aws.medialive/DescribeAccountConfigurationRequest (s/keys))

(s/def
  :cognitect.aws.medialive/RenewalSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.RenewalSettings/AutomaticRenewal
     :cognitect.aws.medialive.RenewalSettings/RenewalCount]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max255
  (s/spec (s/and int? #(<= 0 % 255)) :gen #(gen/choose 0 255)))

(s/def
  :cognitect.aws.medialive/AvailSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AvailSettings/Esam
     :cognitect.aws.medialive.AvailSettings/Scte35TimeSignalApos
     :cognitect.aws.medialive.AvailSettings/Scte35SpliceInsert]))

(s/def :cognitect.aws.medialive/Scte20PlusEmbeddedDestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/DvbSubDestinationShadowColor
  (s/spec string? :gen #(s/gen #{"NONE" "WHITE" "BLACK"})))

(s/def
  :cognitect.aws.medialive/Mp2CodingMode
  (s/spec string? :gen #(s/gen #{"CODING_MODE_1_0" "CODING_MODE_2_0"})))

(s/def :cognitect.aws.medialive/Eac3DcFilter (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/__listOfSrtOutputDestinationSettings
  (s/coll-of :cognitect.aws.medialive/SrtOutputDestinationSettings))

(s/def
  :cognitect.aws.medialive/StaticKeySettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StaticKeySettings/StaticKeyValue]
    :opt-un
    [:cognitect.aws.medialive.StaticKeySettings/KeyProviderServer]))

(s/def :cognitect.aws.medialive/DeleteInputResponse (s/keys))

(s/def
  :cognitect.aws.medialive/CreateNodeRegistrationScriptResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateNodeRegistrationScriptResult/NodeRegistrationScript]))

(s/def
  :cognitect.aws.medialive/SrtCallerDecryptionRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.SrtCallerDecryptionRequest/Algorithm
     :cognitect.aws.medialive.SrtCallerDecryptionRequest/PassphraseSecretArn]))

(s/def
  :cognitect.aws.medialive/Eac3MetadataControl
  (s/spec string? :gen #(s/gen #{"FOLLOW_INPUT" "USE_CONFIGURED"})))

(s/def
  :cognitect.aws.medialive/M2tsEbifControl
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE"})))

(s/def
  :cognitect.aws.medialive/CreateChannel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateChannel/DryRun
     :cognitect.aws.medialive.CreateChannel/ChannelClass
     :cognitect.aws.medialive.CreateChannel/Reserved
     :cognitect.aws.medialive.CreateChannel/InputAttachments
     :cognitect.aws.medialive.CreateChannel/RequestId
     :cognitect.aws.medialive.CreateChannel/LogLevel
     :cognitect.aws.medialive.CreateChannel/RoleArn
     :cognitect.aws.medialive.CreateChannel/Tags
     :cognitect.aws.medialive.CreateChannel/AnywhereSettings
     :cognitect.aws.medialive.CreateChannel/CdiInputSpecification
     :cognitect.aws.medialive.CreateChannel/EncoderSettings
     :cognitect.aws.medialive.CreateChannel/Vpc
     :cognitect.aws.medialive.CreateChannel/InputSpecification
     :cognitect.aws.medialive.CreateChannel/ChannelEngineVersion
     :cognitect.aws.medialive.CreateChannel/Destinations
     :cognitect.aws.medialive.CreateChannel/Name
     :cognitect.aws.medialive.CreateChannel/Maintenance]))

(s/def
  :cognitect.aws.medialive/ListInputDeviceTransfersRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ListInputDeviceTransfersRequest/TransferType]
    :opt-un
    [:cognitect.aws.medialive.ListInputDeviceTransfersRequest/NextToken
     :cognitect.aws.medialive.ListInputDeviceTransfersRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/FeatureActivationsOutputStaticImageOverlayScheduleActions
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/SmoothGroupSegmentationMode
  (s/spec string? :gen #(s/gen #{"USE_INPUT_SEGMENTATION" "USE_SEGMENT_DURATION"})))

(s/def
  :cognitect.aws.medialive/UpdateInputResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateInputResultModel/Input]))

(s/def
  :cognitect.aws.medialive/H264FlickerAq
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/CreateChannelPlacementGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateChannelPlacementGroupRequest/ClusterId]
    :opt-un
    [:cognitect.aws.medialive.CreateChannelPlacementGroupRequest/Nodes
     :cognitect.aws.medialive.CreateChannelPlacementGroupRequest/RequestId
     :cognitect.aws.medialive.CreateChannelPlacementGroupRequest/Tags
     :cognitect.aws.medialive.CreateChannelPlacementGroupRequest/Name]))

(s/def
  :cognitect.aws.medialive/NielsenPcmToId3TaggingState
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/UpdateEventBridgeRuleTemplateResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/EventType
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/CreatedAt
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Id
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Arn
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Name
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/GroupId]
    :opt-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Tags
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Description
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/EventTargets
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/VideoBlackFailoverSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.VideoBlackFailoverSettings/VideoBlackThresholdMsec
     :cognitect.aws.medialive.VideoBlackFailoverSettings/BlackDetectThreshold]))

(s/def
  :cognitect.aws.medialive/DvbTdtSettings
  (s/keys :opt-un [:cognitect.aws.medialive.DvbTdtSettings/RepInterval]))

(s/def
  :cognitect.aws.medialive/ForbiddenException
  (s/keys :opt-un [:cognitect.aws.medialive.ForbiddenException/Message]))

(s/def
  :cognitect.aws.medialive/CmafNielsenId3Behavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/__listOfDescribeNetworkSummary
  (s/coll-of :cognitect.aws.medialive/DescribeNetworkSummary))

(s/def
  :cognitect.aws.medialive/CreateNodeResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateNodeResponse/ConnectionState
     :cognitect.aws.medialive.CreateNodeResponse/ClusterId
     :cognitect.aws.medialive.CreateNodeResponse/Role
     :cognitect.aws.medialive.CreateNodeResponse/NodeInterfaceMappings
     :cognitect.aws.medialive.CreateNodeResponse/SdiSourceMappings
     :cognitect.aws.medialive.CreateNodeResponse/Arn
     :cognitect.aws.medialive.CreateNodeResponse/State
     :cognitect.aws.medialive.CreateNodeResponse/Name
     :cognitect.aws.medialive.CreateNodeResponse/Id
     :cognitect.aws.medialive.CreateNodeResponse/ChannelPlacementGroups
     :cognitect.aws.medialive.CreateNodeResponse/InstanceArn]))

(s/def
  :cognitect.aws.medialive/CreateTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateTagsRequest/ResourceArn]
    :opt-un
    [:cognitect.aws.medialive.CreateTagsRequest/Tags]))

(s/def
  :cognitect.aws.medialive/BadRequestException
  (s/keys :opt-un [:cognitect.aws.medialive.BadRequestException/Message]))

(s/def
  :cognitect.aws.medialive/HlsTimedMetadataScheduleActionSettings
  (s/keys :req-un [:cognitect.aws.medialive.HlsTimedMetadataScheduleActionSettings/Id3]))

(s/def
  :cognitect.aws.medialive/__integerMin30
  (s/spec (s/and int? #(<= 30 %)) :gen #(gen/choose 30 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.medialive/__stringPatternS
  (s/spec #(re-matches (re-pattern "^[^\\s]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.medialive/StaticImageOutputActivateScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/OutputNames
     :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Image]
    :opt-un
    [:cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Opacity
     :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/ImageX
     :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Width
     :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Layer
     :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Duration
     :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/FadeIn
     :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Height
     :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/ImageY
     :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/FadeOut]))

(s/def
  :cognitect.aws.medialive/__listOfAudioChannelMapping
  (s/coll-of :cognitect.aws.medialive/AudioChannelMapping))

(s/def
  :cognitect.aws.medialive/UpdateNetworkResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateNetworkResult/Routes
     :cognitect.aws.medialive.UpdateNetworkResult/IpPools
     :cognitect.aws.medialive.UpdateNetworkResult/AssociatedClusterIds
     :cognitect.aws.medialive.UpdateNetworkResult/Arn
     :cognitect.aws.medialive.UpdateNetworkResult/State
     :cognitect.aws.medialive.UpdateNetworkResult/Name
     :cognitect.aws.medialive.UpdateNetworkResult/Id]))

(s/def
  :cognitect.aws.medialive/ListChannelsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListChannelsRequest/NextToken
     :cognitect.aws.medialive.ListChannelsRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/ListMultiplexProgramsRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ListMultiplexProgramsRequest/MultiplexId]
    :opt-un
    [:cognitect.aws.medialive.ListMultiplexProgramsRequest/NextToken
     :cognitect.aws.medialive.ListMultiplexProgramsRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/M3u8Scte35Behavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/GatewayTimeoutException
  (s/keys :opt-un [:cognitect.aws.medialive.GatewayTimeoutException/Message]))

(s/def
  :cognitect.aws.medialive/ListCloudWatchAlarmTemplateGroupsResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsResponseContent/CloudWatchAlarmTemplateGroups]
    :opt-un
    [:cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsResponseContent/NextToken]))

(s/def
  :cognitect.aws.medialive/DeleteInputRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteInputRequest/InputId]))

(s/def
  :cognitect.aws.medialive/IncludeFillerNalUnits
  (s/spec string? :gen #(s/gen #{"AUTO" "INCLUDE" "DROP"})))

(s/def
  :cognitect.aws.medialive/ScheduleDescribeResultModel
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ScheduleDescribeResultModel/ScheduleActions]
    :opt-un
    [:cognitect.aws.medialive.ScheduleDescribeResultModel/NextToken]))

(s/def :cognitect.aws.medialive/ScheduleDeleteResultModel (s/keys))

(s/def
  :cognitect.aws.medialive/AccessibilityType
  (s/spec
    string?
    :gen
    #(s/gen #{"DOES_NOT_IMPLEMENT_ACCESSIBILITY_FEATURES" "IMPLEMENTS_ACCESSIBILITY_FEATURES"})))

(s/def :cognitect.aws.medialive/InputDeviceCodec (s/spec string? :gen #(s/gen #{"HEVC" "AVC"})))

(s/def
  :cognitect.aws.medialive/ListOfferingsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListOfferingsRequest/ChannelClass
     :cognitect.aws.medialive.ListOfferingsRequest/Codec
     :cognitect.aws.medialive.ListOfferingsRequest/Resolution
     :cognitect.aws.medialive.ListOfferingsRequest/NextToken
     :cognitect.aws.medialive.ListOfferingsRequest/MaximumBitrate
     :cognitect.aws.medialive.ListOfferingsRequest/Duration
     :cognitect.aws.medialive.ListOfferingsRequest/ResourceType
     :cognitect.aws.medialive.ListOfferingsRequest/MaxResults
     :cognitect.aws.medialive.ListOfferingsRequest/VideoQuality
     :cognitect.aws.medialive.ListOfferingsRequest/ChannelConfiguration
     :cognitect.aws.medialive.ListOfferingsRequest/SpecialFeature
     :cognitect.aws.medialive.ListOfferingsRequest/MaximumFramerate]))

(s/def
  :cognitect.aws.medialive/ChannelEngineVersionRequest
  (s/keys :opt-un [:cognitect.aws.medialive.ChannelEngineVersionRequest/Version]))

(s/def
  :cognitect.aws.medialive/ScheduleAction
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ScheduleAction/ActionName
     :cognitect.aws.medialive.ScheduleAction/ScheduleActionStartSettings
     :cognitect.aws.medialive.ScheduleAction/ScheduleActionSettings]))

(s/def
  :cognitect.aws.medialive/__integerMin25Max10000
  (s/spec (s/and int? #(<= 25 % 10000)) :gen #(gen/choose 25 10000)))

(s/def
  :cognitect.aws.medialive/ColorSpace
  (s/spec string? :gen #(s/gen #{"HLG_2020" "REC_601" "HDR10" "REC_709"})))

(s/def
  :cognitect.aws.medialive/ListOfferingsResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListOfferingsResultModel/Offerings
     :cognitect.aws.medialive.ListOfferingsResultModel/NextToken]))

(s/def
  :cognitect.aws.medialive/UpdateReservation
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateReservation/RenewalSettings
     :cognitect.aws.medialive.UpdateReservation/Name]))

(s/def :cognitect.aws.medialive/__listOfOffering (s/coll-of :cognitect.aws.medialive/Offering))

(s/def
  :cognitect.aws.medialive/InputDestinationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDestinationRequest/StreamName
     :cognitect.aws.medialive.InputDestinationRequest/StaticIpAddress
     :cognitect.aws.medialive.InputDestinationRequest/Network
     :cognitect.aws.medialive.InputDestinationRequest/NetworkRoutes]))

(s/def
  :cognitect.aws.medialive/DeviceSettingsSyncState
  (s/spec string? :gen #(s/gen #{"SYNCING" "SYNCED"})))

(s/def
  :cognitect.aws.medialive/CreateMultiplexResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.CreateMultiplexResultModel/Multiplex]))

(s/def
  :cognitect.aws.medialive/NodeState
  (s/spec
    string?
    :gen
    #(s/gen
      #{"IN_USE"
        "READY_TO_ACTIVATE"
        "REGISTERING"
        "DEREGISTERING"
        "READY"
        "DEREGISTRATION_FAILED"
        "DRAINING"
        "ACTIVE"
        "REGISTRATION_FAILED"
        "ACTIVATION_FAILED"
        "DEREGISTERED"
        "CREATED"})))

(s/def
  :cognitect.aws.medialive/HlsOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.HlsOutputSettings/HlsSettings]
    :opt-un
    [:cognitect.aws.medialive.HlsOutputSettings/SegmentModifier
     :cognitect.aws.medialive.HlsOutputSettings/NameModifier
     :cognitect.aws.medialive.HlsOutputSettings/H265PackagingType]))

(s/def
  :cognitect.aws.medialive/GlobalConfigurationInputEndAction
  (s/spec string? :gen #(s/gen #{"SWITCH_AND_LOOP_INPUTS" "NONE"})))

(s/def
  :cognitect.aws.medialive/ListChannelPlacementGroupsResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListChannelPlacementGroupsResult/NextToken
     :cognitect.aws.medialive.ListChannelPlacementGroupsResult/ChannelPlacementGroups]))

(s/def
  :cognitect.aws.medialive/__listOfInputDeviceSettings
  (s/coll-of :cognitect.aws.medialive/InputDeviceSettings))

(s/def
  :cognitect.aws.medialive/ChannelConfigurationValidationError
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ChannelConfigurationValidationError/Message
     :cognitect.aws.medialive.ChannelConfigurationValidationError/ValidationErrors]))

(s/def
  :cognitect.aws.medialive/ResourceNotFound
  (s/keys :opt-un [:cognitect.aws.medialive.ResourceNotFound/Message]))

(s/def
  :cognitect.aws.medialive/CreateEventBridgeRuleTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/EventType
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/Name
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/GroupIdentifier]
    :opt-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/RequestId
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/Tags
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/Description
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/EventTargets]))

(s/def
  :cognitect.aws.medialive/MediaResource
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MediaResource/Destinations
     :cognitect.aws.medialive.MediaResource/Name
     :cognitect.aws.medialive.MediaResource/Sources]))

(s/def
  :cognitect.aws.medialive/Algorithm
  (s/spec string? :gen #(s/gen #{"AES192" "AES128" "AES256"})))

(s/def
  :cognitect.aws.medialive/ReservationResolution
  (s/spec string? :gen #(s/gen #{"UHD" "SD" "FHD" "HD"})))

(s/def :cognitect.aws.medialive/M2tsArib (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/StartUpdateSignalMapRequestContent
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StartUpdateSignalMapRequestContent/ForceRediscovery
     :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/EventBridgeRuleTemplateGroupIdentifiers
     :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/CloudWatchAlarmTemplateGroupIdentifiers
     :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/DiscoveryEntryPointArn
     :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/Description
     :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/Name]))

(s/def
  :cognitect.aws.medialive/MulticastSettings
  (s/keys :opt-un [:cognitect.aws.medialive.MulticastSettings/Sources]))

(s/def
  :cognitect.aws.medialive/ListInputsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputsResponse/NextToken
     :cognitect.aws.medialive.ListInputsResponse/Inputs]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max31
  (s/spec (s/and int? #(<= 1 % 31)) :gen #(gen/choose 1 31)))

(s/def
  :cognitect.aws.medialive/M3u8TimedMetadataBehavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/__listOfScte35Descriptor
  (s/coll-of :cognitect.aws.medialive/Scte35Descriptor))

(s/def :cognitect.aws.medialive/DeleteScheduleResponse (s/keys))

(s/def
  :cognitect.aws.medialive/__listOfInputDeviceRequest
  (s/coll-of :cognitect.aws.medialive/InputDeviceRequest))

(s/def
  :cognitect.aws.medialive/__stringMin1Max256PatternS
  (s/spec #(re-matches (re-pattern "^[\\S]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.medialive/InputDenoiseFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/ListEventBridgeRuleTemplateGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsRequest/NextToken
     :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsRequest/MaxResults
     :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsRequest/SignalMapIdentifier]))

(s/def
  :cognitect.aws.medialive/DvbSubSourceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DvbSubSourceSettings/Pid
     :cognitect.aws.medialive.DvbSubSourceSettings/OcrLanguage]))

(s/def
  :cognitect.aws.medialive/DescribeMultiplexRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeMultiplexRequest/MultiplexId]))

(s/def
  :cognitect.aws.medialive/__integerMin96Max600
  (s/spec (s/and int? #(<= 96 % 600)) :gen #(gen/choose 96 600)))

(s/def
  :cognitect.aws.medialive/CreateInputSecurityGroupResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.CreateInputSecurityGroupResultModel/SecurityGroup]))

(s/def
  :cognitect.aws.medialive/MulticastInputSettings
  (s/keys :opt-un [:cognitect.aws.medialive.MulticastInputSettings/SourceIpAddress]))

(s/def
  :cognitect.aws.medialive/ListMultiplexesResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListMultiplexesResultModel/Multiplexes
     :cognitect.aws.medialive.ListMultiplexesResultModel/NextToken]))

(s/def
  :cognitect.aws.medialive/ColorCorrection
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ColorCorrection/OutputColorSpace
     :cognitect.aws.medialive.ColorCorrection/InputColorSpace
     :cognitect.aws.medialive.ColorCorrection/Uri]))

(s/def
  :cognitect.aws.medialive/CreateSdiSourceRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateSdiSourceRequest/RequestId
     :cognitect.aws.medialive.CreateSdiSourceRequest/Type
     :cognitect.aws.medialive.CreateSdiSourceRequest/Tags
     :cognitect.aws.medialive.CreateSdiSourceRequest/Mode
     :cognitect.aws.medialive.CreateSdiSourceRequest/Name]))

(s/def
  :cognitect.aws.medialive/CmafIngestCaptionLanguageMapping
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CmafIngestCaptionLanguageMapping/LanguageCode
     :cognitect.aws.medialive.CmafIngestCaptionLanguageMapping/CaptionChannel]))

(s/def
  :cognitect.aws.medialive/BatchStartResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchStartResultModel/Failed
     :cognitect.aws.medialive.BatchStartResultModel/Successful]))

(s/def :cognitect.aws.medialive/AcceptHeader (s/spec string? :gen #(s/gen #{"image/jpeg"})))

(s/def
  :cognitect.aws.medialive/TtmlDestinationStyleControl
  (s/spec string? :gen #(s/gen #{"USE_CONFIGURED" "PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/UpdateNetworkResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateNetworkResponse/Routes
     :cognitect.aws.medialive.UpdateNetworkResponse/IpPools
     :cognitect.aws.medialive.UpdateNetworkResponse/AssociatedClusterIds
     :cognitect.aws.medialive.UpdateNetworkResponse/Arn
     :cognitect.aws.medialive.UpdateNetworkResponse/State
     :cognitect.aws.medialive.UpdateNetworkResponse/Name
     :cognitect.aws.medialive.UpdateNetworkResponse/Id]))

(s/def
  :cognitect.aws.medialive/MaxResults
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.medialive/Mpeg2ScanType
  (s/spec string? :gen #(s/gen #{"PROGRESSIVE" "INTERLACED"})))

(s/def
  :cognitect.aws.medialive/H264GopBReference
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/VideoDescriptionScalingBehavior
  (s/spec string? :gen #(s/gen #{"STRETCH_TO_OUTPUT" "DEFAULT"})))

(s/def
  :cognitect.aws.medialive/Av1SceneChangeDetect
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/DeleteMultiplexRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteMultiplexRequest/MultiplexId]))

(s/def
  :cognitect.aws.medialive/InputLossImageType
  (s/spec string? :gen #(s/gen #{"SLATE" "COLOR"})))

(s/def
  :cognitect.aws.medialive/H265Settings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.H265Settings/FramerateNumerator
     :cognitect.aws.medialive.H265Settings/FramerateDenominator]
    :opt-un
    [:cognitect.aws.medialive.H265Settings/Level
     :cognitect.aws.medialive.H265Settings/RateControlMode
     :cognitect.aws.medialive.H265Settings/Tier
     :cognitect.aws.medialive.H265Settings/MinIInterval
     :cognitect.aws.medialive.H265Settings/AlternativeTransferFunction
     :cognitect.aws.medialive.H265Settings/ParDenominator
     :cognitect.aws.medialive.H265Settings/MvTemporalPredictor
     :cognitect.aws.medialive.H265Settings/QvbrQualityLevel
     :cognitect.aws.medialive.H265Settings/TimecodeInsertion
     :cognitect.aws.medialive.H265Settings/ScanType
     :cognitect.aws.medialive.H265Settings/MvOverPictureBoundaries
     :cognitect.aws.medialive.H265Settings/AdaptiveQuantization
     :cognitect.aws.medialive.H265Settings/AfdSignaling
     :cognitect.aws.medialive.H265Settings/TilePadding
     :cognitect.aws.medialive.H265Settings/MinQp
     :cognitect.aws.medialive.H265Settings/FilterSettings
     :cognitect.aws.medialive.H265Settings/BufSize
     :cognitect.aws.medialive.H265Settings/Profile
     :cognitect.aws.medialive.H265Settings/ColorMetadata
     :cognitect.aws.medialive.H265Settings/LookAheadRateControl
     :cognitect.aws.medialive.H265Settings/GopClosedCadence
     :cognitect.aws.medialive.H265Settings/FlickerAq
     :cognitect.aws.medialive.H265Settings/TileWidth
     :cognitect.aws.medialive.H265Settings/GopSizeUnits
     :cognitect.aws.medialive.H265Settings/MaxBitrate
     :cognitect.aws.medialive.H265Settings/ParNumerator
     :cognitect.aws.medialive.H265Settings/GopSize
     :cognitect.aws.medialive.H265Settings/TileHeight
     :cognitect.aws.medialive.H265Settings/Slices
     :cognitect.aws.medialive.H265Settings/FixedAfd
     :cognitect.aws.medialive.H265Settings/TimecodeBurninSettings
     :cognitect.aws.medialive.H265Settings/SceneChangeDetect
     :cognitect.aws.medialive.H265Settings/Deblocking
     :cognitect.aws.medialive.H265Settings/ColorSpaceSettings
     :cognitect.aws.medialive.H265Settings/Bitrate
     :cognitect.aws.medialive.H265Settings/TreeblockSize]))

(s/def
  :cognitect.aws.medialive/CreateInputSecurityGroupResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreateInputSecurityGroupResponse/SecurityGroup]))

(s/def
  :cognitect.aws.medialive/ListMultiplexesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListMultiplexesRequest/NextToken
     :cognitect.aws.medialive.ListMultiplexesRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/__listOfFailoverCondition
  (s/coll-of :cognitect.aws.medialive/FailoverCondition))

(s/def
  :cognitect.aws.medialive/__listOfChannelSummary
  (s/coll-of :cognitect.aws.medialive/ChannelSummary))

(s/def
  :cognitect.aws.medialive/CreateEventBridgeRuleTemplateGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Tags
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Description
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/ModifiedAt
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Arn
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/CreatedAt
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Name
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Id]))

(s/def
  :cognitect.aws.medialive/DescribeScheduleRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DescribeScheduleRequest/ChannelId]
    :opt-un
    [:cognitect.aws.medialive.DescribeScheduleRequest/NextToken
     :cognitect.aws.medialive.DescribeScheduleRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/__listOfInputDeviceUhdAudioChannelPairConfig
  (s/coll-of :cognitect.aws.medialive/InputDeviceUhdAudioChannelPairConfig))

(s/def
  :cognitect.aws.medialive/UpdateReservationRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateReservationRequest/ReservationId]
    :opt-un
    [:cognitect.aws.medialive.UpdateReservationRequest/RenewalSettings
     :cognitect.aws.medialive.UpdateReservationRequest/Name]))

(s/def
  :cognitect.aws.medialive/DeleteReservationRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteReservationRequest/ReservationId]))

(s/def
  :cognitect.aws.medialive/DeleteChannelPlacementGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Nodes
     :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/ClusterId
     :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Arn
     :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/State
     :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Name
     :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Id
     :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Channels]))

(s/def
  :cognitect.aws.medialive/InputSourceEndBehavior
  (s/spec string? :gen #(s/gen #{"CONTINUE" "LOOP"})))

(s/def
  :cognitect.aws.medialive/HlsAdMarkers
  (s/spec string? :gen #(s/gen #{"ELEMENTAL" "ADOBE" "ELEMENTAL_SCTE35"})))

(s/def
  :cognitect.aws.medialive/__integerMin10Max86400
  (s/spec (s/and int? #(<= 10 % 86400)) :gen #(gen/choose 10 86400)))

(s/def
  :cognitect.aws.medialive/UdpOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UdpOutputSettings/Destination
     :cognitect.aws.medialive.UdpOutputSettings/ContainerSettings]
    :opt-un
    [:cognitect.aws.medialive.UdpOutputSettings/FecOutputSettings
     :cognitect.aws.medialive.UdpOutputSettings/BufferMsec]))

(s/def
  :cognitect.aws.medialive/AudioDolbyEDecode
  (s/keys :req-un [:cognitect.aws.medialive.AudioDolbyEDecode/ProgramSelection]))

(s/def :cognitect.aws.medialive/ClusterType (s/spec string? :gen #(s/gen #{"ON_PREMISES"})))

(s/def
  :cognitect.aws.medialive/H265ColorSpaceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.H265ColorSpaceSettings/Hdr10Settings
     :cognitect.aws.medialive.H265ColorSpaceSettings/Rec601Settings
     :cognitect.aws.medialive.H265ColorSpaceSettings/DolbyVision81Settings
     :cognitect.aws.medialive.H265ColorSpaceSettings/Rec709Settings
     :cognitect.aws.medialive.H265ColorSpaceSettings/ColorSpacePassthroughSettings]))

(s/def :cognitect.aws.medialive/IpPool (s/keys :opt-un [:cognitect.aws.medialive.IpPool/Cidr]))

(s/def
  :cognitect.aws.medialive/InputDeviceOutputType
  (s/spec string? :gen #(s/gen #{"MEDIALIVE_INPUT" "NONE" "MEDIACONNECT_FLOW"})))

(s/def
  :cognitect.aws.medialive/__doubleMin0Max5000
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/H264ParControl
  (s/spec string? :gen #(s/gen #{"SPECIFIED" "INITIALIZE_FROM_SOURCE"})))

(s/def
  :cognitect.aws.medialive/CaptionDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CaptionDestinationSettings/TtmlDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/BurnInDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/Scte27DestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/EbuTtDDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/AribDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/RtmpCaptionInfoDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/WebvttDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/TeletextDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/SmpteTtDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/DvbSubDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/EmbeddedDestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/EmbeddedPlusScte20DestinationSettings
     :cognitect.aws.medialive.CaptionDestinationSettings/Scte20PlusEmbeddedDestinationSettings]))

(s/def
  :cognitect.aws.medialive/InvalidRequest
  (s/keys :opt-un [:cognitect.aws.medialive.InvalidRequest/Message]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max51
  (s/spec (s/and int? #(<= 1 % 51)) :gen #(gen/choose 1 51)))

(s/def
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic
  (s/spec string? :gen #(s/gen #{"Sum" "Average" "SampleCount" "Minimum" "Maximum"})))

(s/def
  :cognitect.aws.medialive/StopTimecode
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StopTimecode/Timecode
     :cognitect.aws.medialive.StopTimecode/LastFrameClippingBehavior]))

(s/def
  :cognitect.aws.medialive/AccessDenied
  (s/keys :opt-un [:cognitect.aws.medialive.AccessDenied/Message]))

(s/def
  :cognitect.aws.medialive/MultiplexProgramSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexProgramSummary/ProgramName
     :cognitect.aws.medialive.MultiplexProgramSummary/ChannelId]))

(s/def
  :cognitect.aws.medialive/UdpGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UdpGroupSettings/InputLossAction
     :cognitect.aws.medialive.UdpGroupSettings/TimedMetadataId3Frame
     :cognitect.aws.medialive.UdpGroupSettings/TimedMetadataId3Period]))

(s/def
  :cognitect.aws.medialive/SrtEncryptionType
  (s/spec string? :gen #(s/gen #{"AES192" "AES128" "AES256"})))

(s/def :cognitect.aws.medialive/Eac3LfeControl (s/spec string? :gen #(s/gen #{"NO_LFE" "LFE"})))

(s/def
  :cognitect.aws.medialive/CreateChannelRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateChannelRequest/DryRun
     :cognitect.aws.medialive.CreateChannelRequest/ChannelClass
     :cognitect.aws.medialive.CreateChannelRequest/Reserved
     :cognitect.aws.medialive.CreateChannelRequest/InputAttachments
     :cognitect.aws.medialive.CreateChannelRequest/RequestId
     :cognitect.aws.medialive.CreateChannelRequest/LogLevel
     :cognitect.aws.medialive.CreateChannelRequest/RoleArn
     :cognitect.aws.medialive.CreateChannelRequest/Tags
     :cognitect.aws.medialive.CreateChannelRequest/AnywhereSettings
     :cognitect.aws.medialive.CreateChannelRequest/CdiInputSpecification
     :cognitect.aws.medialive.CreateChannelRequest/EncoderSettings
     :cognitect.aws.medialive.CreateChannelRequest/Vpc
     :cognitect.aws.medialive.CreateChannelRequest/InputSpecification
     :cognitect.aws.medialive.CreateChannelRequest/ChannelEngineVersion
     :cognitect.aws.medialive.CreateChannelRequest/Destinations
     :cognitect.aws.medialive.CreateChannelRequest/Name
     :cognitect.aws.medialive.CreateChannelRequest/Maintenance]))

(s/def
  :cognitect.aws.medialive/Scte35AposWebDeliveryAllowedBehavior
  (s/spec string? :gen #(s/gen #{"FOLLOW" "IGNORE"})))

(s/def
  :cognitect.aws.medialive/MediaResourceNeighbor
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MediaResourceNeighbor/Arn]
    :opt-un
    [:cognitect.aws.medialive.MediaResourceNeighbor/Name]))

(s/def
  :cognitect.aws.medialive/IpPoolUpdateRequest
  (s/keys :opt-un [:cognitect.aws.medialive.IpPoolUpdateRequest/Cidr]))

(s/def
  :cognitect.aws.medialive/HlsRedundantManifest
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/UpdateInputDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateInputDeviceRequest/InputDeviceId]
    :opt-un
    [:cognitect.aws.medialive.UpdateInputDeviceRequest/HdDeviceSettings
     :cognitect.aws.medialive.UpdateInputDeviceRequest/AvailabilityZone
     :cognitect.aws.medialive.UpdateInputDeviceRequest/UhdDeviceSettings
     :cognitect.aws.medialive.UpdateInputDeviceRequest/Name]))

(s/def
  :cognitect.aws.medialive/UpdateEventBridgeRuleTemplateRequestContent
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/EventType
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/GroupIdentifier
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/Description
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/EventTargets
     :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/Name]))

(s/def
  :cognitect.aws.medialive/RouteCreateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.RouteCreateRequest/Cidr
     :cognitect.aws.medialive.RouteCreateRequest/Gateway]))

(s/def
  :cognitect.aws.medialive/__integerMin25Max2000
  (s/spec (s/and int? #(<= 25 % 2000)) :gen #(gen/choose 25 2000)))

(s/def
  :cognitect.aws.medialive/CreateEventBridgeRuleTemplateGroupRequestContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequestContent/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequestContent/RequestId
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequestContent/Tags
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequestContent/Description]))

(s/def
  :cognitect.aws.medialive/NielsenWatermarksDistributionTypes
  (s/spec string? :gen #(s/gen #{"PROGRAM_CONTENT" "FINAL_DISTRIBUTOR"})))

(s/def
  :cognitect.aws.medialive/MediaPackageGroupSettings
  (s/keys :req-un [:cognitect.aws.medialive.MediaPackageGroupSettings/Destination]))

(s/def
  :cognitect.aws.medialive/M3u8KlvBehavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/HlsWebdavHttpTransferMode
  (s/spec string? :gen #(s/gen #{"NON_CHUNKED" "CHUNKED"})))

(s/def
  :cognitect.aws.medialive/Mpeg2Settings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Mpeg2Settings/FramerateNumerator
     :cognitect.aws.medialive.Mpeg2Settings/FramerateDenominator]
    :opt-un
    [:cognitect.aws.medialive.Mpeg2Settings/SubgopLength
     :cognitect.aws.medialive.Mpeg2Settings/TimecodeInsertion
     :cognitect.aws.medialive.Mpeg2Settings/ScanType
     :cognitect.aws.medialive.Mpeg2Settings/AdaptiveQuantization
     :cognitect.aws.medialive.Mpeg2Settings/AfdSignaling
     :cognitect.aws.medialive.Mpeg2Settings/FilterSettings
     :cognitect.aws.medialive.Mpeg2Settings/GopNumBFrames
     :cognitect.aws.medialive.Mpeg2Settings/ColorSpace
     :cognitect.aws.medialive.Mpeg2Settings/ColorMetadata
     :cognitect.aws.medialive.Mpeg2Settings/GopClosedCadence
     :cognitect.aws.medialive.Mpeg2Settings/GopSizeUnits
     :cognitect.aws.medialive.Mpeg2Settings/GopSize
     :cognitect.aws.medialive.Mpeg2Settings/FixedAfd
     :cognitect.aws.medialive.Mpeg2Settings/DisplayAspectRatio
     :cognitect.aws.medialive.Mpeg2Settings/TimecodeBurninSettings]))

(s/def
  :cognitect.aws.medialive/Ac3BitstreamMode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"COMPLETE_MAIN"
        "DIALOGUE"
        "VISUALLY_IMPAIRED"
        "EMERGENCY"
        "COMMENTARY"
        "MUSIC_AND_EFFECTS"
        "VOICE_OVER"
        "HEARING_IMPAIRED"})))

(s/def
  :cognitect.aws.medialive/InputWhitelistRuleCidr
  (s/keys :opt-un [:cognitect.aws.medialive.InputWhitelistRuleCidr/Cidr]))

(s/def
  :cognitect.aws.medialive/AdditionalDestinations
  (s/keys :req-un [:cognitect.aws.medialive.AdditionalDestinations/Destination]))

(s/def
  :cognitect.aws.medialive/MulticastSource
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MulticastSource/Url]
    :opt-un
    [:cognitect.aws.medialive.MulticastSource/SourceIp]))

(s/def
  :cognitect.aws.medialive/InputFilter
  (s/spec string? :gen #(s/gen #{"DISABLED" "AUTO" "FORCED"})))

(s/def
  :cognitect.aws.medialive/CaptionSelectorSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CaptionSelectorSettings/Scte20SourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/DvbSubSourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/TeletextSourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/AncillarySourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/Scte27SourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/EmbeddedSourceSettings
     :cognitect.aws.medialive.CaptionSelectorSettings/AribSourceSettings]))

(s/def
  :cognitect.aws.medialive/TimecodeBurninFontSize
  (s/spec string? :gen #(s/gen #{"EXTRA_SMALL_10" "MEDIUM_32" "SMALL_16" "LARGE_48"})))

(s/def
  :cognitect.aws.medialive/UpdateCloudWatchAlarmTemplateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/TreatMissingData
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Period
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Threshold
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Tags
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/ComparisonOperator
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/GroupId
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/TargetResourceType
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/DatapointsToAlarm
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Description
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/ModifiedAt
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Arn
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/CreatedAt
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/MetricName
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Name
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/EvaluationPeriods
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Id
     :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Statistic]))

(s/def
  :cognitect.aws.medialive/DescribeScheduleResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeScheduleResponse/NextToken
     :cognitect.aws.medialive.DescribeScheduleResponse/ScheduleActions]))

(s/def
  :cognitect.aws.medialive/M2tsSegmentationMarkers
  (s/spec
    string?
    :gen
    #(s/gen #{"PSI_SEGSTART" "RAI_SEGSTART" "RAI_ADAPT" "NONE" "EBP_LEGACY" "EBP"})))

(s/def :cognitect.aws.medialive/StartInputDeviceMaintenanceWindowResponse (s/keys))

(s/def
  :cognitect.aws.medialive/FailoverCondition
  (s/keys :opt-un [:cognitect.aws.medialive.FailoverCondition/FailoverConditionSettings]))

(s/def
  :cognitect.aws.medialive/ThumbnailDetail
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ThumbnailDetail/Thumbnails
     :cognitect.aws.medialive.ThumbnailDetail/PipelineId]))

(s/def
  :cognitect.aws.medialive/DescribeReservationRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeReservationRequest/ReservationId]))

(s/def
  :cognitect.aws.medialive/__integerMinNegative60Max60
  (s/spec (s/and int? #(<= -60 % 60)) :gen #(gen/choose -60 60)))

(s/def
  :cognitect.aws.medialive/MultiplexConfigurationValidationError
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexConfigurationValidationError/Message
     :cognitect.aws.medialive.MultiplexConfigurationValidationError/ValidationErrors]))

(s/def
  :cognitect.aws.medialive/__listOfMultiplexSummary
  (s/coll-of :cognitect.aws.medialive/MultiplexSummary))

(s/def
  :cognitect.aws.medialive/UpdateClusterResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateClusterResponse/NetworkSettings
     :cognitect.aws.medialive.UpdateClusterResponse/ClusterType
     :cognitect.aws.medialive.UpdateClusterResponse/Arn
     :cognitect.aws.medialive.UpdateClusterResponse/State
     :cognitect.aws.medialive.UpdateClusterResponse/Name
     :cognitect.aws.medialive.UpdateClusterResponse/ChannelIds
     :cognitect.aws.medialive.UpdateClusterResponse/Id]))

(s/def
  :cognitect.aws.medialive/__listOfDescribeNodeSummary
  (s/coll-of :cognitect.aws.medialive/DescribeNodeSummary))

(s/def
  :cognitect.aws.medialive/H264ColorSpaceSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.H264ColorSpaceSettings/Rec601Settings
     :cognitect.aws.medialive.H264ColorSpaceSettings/Rec709Settings
     :cognitect.aws.medialive.H264ColorSpaceSettings/ColorSpacePassthroughSettings]))

(s/def
  :cognitect.aws.medialive/SmoothGroupCertificateMode
  (s/spec string? :gen #(s/gen #{"VERIFY_AUTHENTICITY" "SELF_SIGNED"})))

(s/def :cognitect.aws.medialive/NodeRole (s/spec string? :gen #(s/gen #{"BACKUP" "ACTIVE"})))

(s/def
  :cognitect.aws.medialive/OutputLocationRef
  (s/keys :opt-un [:cognitect.aws.medialive.OutputLocationRef/DestinationRefId]))

(s/def
  :cognitect.aws.medialive/M2tsCcDescriptor
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/SmoothGroupEventStopBehavior
  (s/spec string? :gen #(s/gen #{"SEND_EOS" "NONE"})))

(s/def
  :cognitect.aws.medialive/ForbiddenExceptionResponseContent
  (s/keys :opt-un [:cognitect.aws.medialive.ForbiddenExceptionResponseContent/Message]))

(s/def
  :cognitect.aws.medialive/TtmlDestinationSettings
  (s/keys :opt-un [:cognitect.aws.medialive.TtmlDestinationSettings/StyleControl]))

(s/def
  :cognitect.aws.medialive/Scte35DescriptorSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35DescriptorSettings/SegmentationDescriptorScte35DescriptorSettings]))

(s/def :cognitect.aws.medialive/HlsMode (s/spec string? :gen #(s/gen #{"VOD" "LIVE"})))

(s/def
  :cognitect.aws.medialive/Av1Level
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AV1_LEVEL_4_1"
        "AV1_LEVEL_5_3"
        "AV1_LEVEL_4"
        "AV1_LEVEL_5"
        "AV1_LEVEL_5_2"
        "AV1_LEVEL_3_1"
        "AV1_LEVEL_AUTO"
        "AV1_LEVEL_6_3"
        "AV1_LEVEL_2_1"
        "AV1_LEVEL_2"
        "AV1_LEVEL_6_1"
        "AV1_LEVEL_6"
        "AV1_LEVEL_5_1"
        "AV1_LEVEL_3"
        "AV1_LEVEL_6_2"})))

(s/def
  :cognitect.aws.medialive/AudioSilenceFailoverSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioSilenceFailoverSettings/AudioSelectorName]
    :opt-un
    [:cognitect.aws.medialive.AudioSilenceFailoverSettings/AudioSilenceThresholdMsec]))

(s/def
  :cognitect.aws.medialive/NielsenWatermarksSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.NielsenWatermarksSettings/NielsenNaesIiNwSettings
     :cognitect.aws.medialive.NielsenWatermarksSettings/NielsenCbetSettings
     :cognitect.aws.medialive.NielsenWatermarksSettings/NielsenDistributionType]))

(s/def
  :cognitect.aws.medialive/H264Level
  (s/spec
    string?
    :gen
    #(s/gen
      #{"H264_LEVEL_4_2"
        "H264_LEVEL_2_2"
        "H264_LEVEL_2"
        "H264_LEVEL_1_1"
        "H264_LEVEL_5"
        "H264_LEVEL_1_3"
        "H264_LEVEL_3"
        "H264_LEVEL_2_1"
        "H264_LEVEL_1_2"
        "H264_LEVEL_1"
        "H264_LEVEL_3_2"
        "H264_LEVEL_4"
        "H264_LEVEL_5_1"
        "H264_LEVEL_3_1"
        "H264_LEVEL_AUTO"
        "H264_LEVEL_5_2"
        "H264_LEVEL_4_1"})))

(s/def
  :cognitect.aws.medialive/__listOfCmafIngestCaptionLanguageMapping
  (s/coll-of :cognitect.aws.medialive/CmafIngestCaptionLanguageMapping))

(s/def
  :cognitect.aws.medialive/VpcOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.VpcOutputSettings/SubnetIds]
    :opt-un
    [:cognitect.aws.medialive.VpcOutputSettings/PublicAddressAllocationIds
     :cognitect.aws.medialive.VpcOutputSettings/SecurityGroupIds]))

(s/def
  :cognitect.aws.medialive/HlsOutputSelection
  (s/spec
    string?
    :gen
    #(s/gen #{"MANIFESTS_AND_SEGMENTS" "SEGMENTS_ONLY" "VARIANT_MANIFESTS_AND_SEGMENTS"})))

(s/def
  :cognitect.aws.medialive/AnywhereSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AnywhereSettings/ClusterId
     :cognitect.aws.medialive.AnywhereSettings/ChannelPlacementGroupId]))

(s/def
  :cognitect.aws.medialive/H265ScanType
  (s/spec string? :gen #(s/gen #{"PROGRESSIVE" "INTERLACED"})))

(s/def
  :cognitect.aws.medialive/CreateNetworkResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateNetworkResponse/Routes
     :cognitect.aws.medialive.CreateNetworkResponse/IpPools
     :cognitect.aws.medialive.CreateNetworkResponse/AssociatedClusterIds
     :cognitect.aws.medialive.CreateNetworkResponse/Arn
     :cognitect.aws.medialive.CreateNetworkResponse/State
     :cognitect.aws.medialive.CreateNetworkResponse/Name
     :cognitect.aws.medialive.CreateNetworkResponse/Id]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max10000
  (s/spec (s/and int? #(<= 0 % 10000)) :gen #(gen/choose 0 10000)))

(s/def :cognitect.aws.medialive/ContentType (s/spec string? :gen #(s/gen #{"image/jpeg"})))

(s/def
  :cognitect.aws.medialive/ConflictExceptionResponseContent
  (s/keys :opt-un [:cognitect.aws.medialive.ConflictExceptionResponseContent/Message]))

(s/def
  :cognitect.aws.medialive/NodeInterfaceMapping
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.NodeInterfaceMapping/PhysicalInterfaceName
     :cognitect.aws.medialive.NodeInterfaceMapping/LogicalInterfaceName
     :cognitect.aws.medialive.NodeInterfaceMapping/NetworkInterfaceMode]))

(s/def
  :cognitect.aws.medialive/UpdateInput
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateInput/MediaConnectFlows
     :cognitect.aws.medialive.UpdateInput/InputSecurityGroups
     :cognitect.aws.medialive.UpdateInput/SdiSources
     :cognitect.aws.medialive.UpdateInput/RoleArn
     :cognitect.aws.medialive.UpdateInput/Smpte2110ReceiverGroupSettings
     :cognitect.aws.medialive.UpdateInput/SrtSettings
     :cognitect.aws.medialive.UpdateInput/MulticastSettings
     :cognitect.aws.medialive.UpdateInput/InputDevices
     :cognitect.aws.medialive.UpdateInput/Destinations
     :cognitect.aws.medialive.UpdateInput/Name
     :cognitect.aws.medialive.UpdateInput/Sources]))

(s/def
  :cognitect.aws.medialive/SignalMapStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"UPDATE_IN_PROGRESS"
        "CREATE_FAILED"
        "READY"
        "CREATE_IN_PROGRESS"
        "UPDATE_REVERTED"
        "NOT_READY"
        "CREATE_COMPLETE"
        "UPDATE_COMPLETE"
        "UPDATE_FAILED"})))

(s/def :cognitect.aws.medialive/__timestampIso8601 inst?)

(s/def
  :cognitect.aws.medialive/InputSwitchScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.InputSwitchScheduleActionSettings/InputAttachmentNameReference]
    :opt-un
    [:cognitect.aws.medialive.InputSwitchScheduleActionSettings/InputClippingSettings
     :cognitect.aws.medialive.InputSwitchScheduleActionSettings/UrlPath]))

(s/def :cognitect.aws.medialive/__listOf__integer (s/coll-of :cognitect.aws.medialive/__integer))

(s/def
  :cognitect.aws.medialive/ListInputDevicesResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputDevicesResultModel/NextToken
     :cognitect.aws.medialive.ListInputDevicesResultModel/InputDevices]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max10
  (s/spec (s/and int? #(<= 0 % 10)) :gen #(gen/choose 0 10)))

(s/def
  :cognitect.aws.medialive/DescribeNodeResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeNodeResponse/ConnectionState
     :cognitect.aws.medialive.DescribeNodeResponse/ClusterId
     :cognitect.aws.medialive.DescribeNodeResponse/Role
     :cognitect.aws.medialive.DescribeNodeResponse/NodeInterfaceMappings
     :cognitect.aws.medialive.DescribeNodeResponse/SdiSourceMappings
     :cognitect.aws.medialive.DescribeNodeResponse/Arn
     :cognitect.aws.medialive.DescribeNodeResponse/State
     :cognitect.aws.medialive.DescribeNodeResponse/Name
     :cognitect.aws.medialive.DescribeNodeResponse/Id
     :cognitect.aws.medialive.DescribeNodeResponse/ChannelPlacementGroups
     :cognitect.aws.medialive.DescribeNodeResponse/InstanceArn]))

(s/def
  :cognitect.aws.medialive/InputDeviceConfigurableAudioChannelPairConfig
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceConfigurableAudioChannelPairConfig/Profile
     :cognitect.aws.medialive.InputDeviceConfigurableAudioChannelPairConfig/Id]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max15
  (s/spec (s/and int? #(<= 0 % 15)) :gen #(gen/choose 0 15)))

(s/def :cognitect.aws.medialive/EmbeddedPlusScte20DestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/Offering
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Offering/DurationUnits
     :cognitect.aws.medialive.Offering/CurrencyCode
     :cognitect.aws.medialive.Offering/OfferingDescription
     :cognitect.aws.medialive.Offering/ResourceSpecification
     :cognitect.aws.medialive.Offering/FixedPrice
     :cognitect.aws.medialive.Offering/OfferingId
     :cognitect.aws.medialive.Offering/Duration
     :cognitect.aws.medialive.Offering/UsagePrice
     :cognitect.aws.medialive.Offering/Arn
     :cognitect.aws.medialive.Offering/OfferingType
     :cognitect.aws.medialive.Offering/Region]))

(s/def
  :cognitect.aws.medialive/S3CannedAcl
  (s/spec
    string?
    :gen
    #(s/gen #{"PUBLIC_READ" "BUCKET_OWNER_READ" "BUCKET_OWNER_FULL_CONTROL" "AUTHENTICATED_READ"})))

(s/def :cognitect.aws.medialive/Scte27DestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/__integerMin0Max65535
  (s/spec (s/and int? #(<= 0 % 65535)) :gen #(gen/choose 0 65535)))

(s/def
  :cognitect.aws.medialive/__integerMin64Max2160
  (s/spec (s/and int? #(<= 64 % 2160)) :gen #(gen/choose 64 2160)))

(s/def
  :cognitect.aws.medialive/MotionGraphicsActivateScheduleActionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MotionGraphicsActivateScheduleActionSettings/Username
     :cognitect.aws.medialive.MotionGraphicsActivateScheduleActionSettings/Url
     :cognitect.aws.medialive.MotionGraphicsActivateScheduleActionSettings/Duration
     :cognitect.aws.medialive.MotionGraphicsActivateScheduleActionSettings/PasswordParam]))

(s/def
  :cognitect.aws.medialive/H265Deblocking
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/__stringMin2Max2
  (s/spec
    (s/and string? #(<= 2 (count %) 2))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 2 2) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive/ClaimDeviceResponse (s/keys))

(s/def
  :cognitect.aws.medialive/__stringMax2048
  (s/spec
    (s/and string? #(>= 2048 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/ListSignalMapsResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ListSignalMapsResponseContent/SignalMaps]
    :opt-un
    [:cognitect.aws.medialive.ListSignalMapsResponseContent/NextToken]))

(s/def
  :cognitect.aws.medialive/VideoSelectorSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.VideoSelectorSettings/VideoSelectorProgramId
     :cognitect.aws.medialive.VideoSelectorSettings/VideoSelectorPid]))

(s/def
  :cognitect.aws.medialive/DescribeInputRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeInputRequest/InputId]))

(s/def
  :cognitect.aws.medialive/SrtOutputDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.SrtOutputDestinationSettings/StreamId
     :cognitect.aws.medialive.SrtOutputDestinationSettings/EncryptionPassphraseSecretArn
     :cognitect.aws.medialive.SrtOutputDestinationSettings/Url]))

(s/def
  :cognitect.aws.medialive/Mpeg2GopSizeUnits
  (s/spec string? :gen #(s/gen #{"SECONDS" "FRAMES"})))

(s/def
  :cognitect.aws.medialive/DeleteSdiSourceResponse
  (s/keys :opt-un [:cognitect.aws.medialive.DeleteSdiSourceResponse/SdiSource]))

(s/def
  :cognitect.aws.medialive/MultiplexProgram
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexProgram/ProgramName
     :cognitect.aws.medialive.MultiplexProgram/ChannelId
     :cognitect.aws.medialive.MultiplexProgram/PipelineDetails
     :cognitect.aws.medialive.MultiplexProgram/PacketIdentifiersMap
     :cognitect.aws.medialive.MultiplexProgram/MultiplexProgramSettings]))

(s/def
  :cognitect.aws.medialive/InputLossActionForHlsOut
  (s/spec string? :gen #(s/gen #{"PAUSE_OUTPUT" "EMIT_OUTPUT"})))

(s/def :cognitect.aws.medialive/M2tsRateMode (s/spec string? :gen #(s/gen #{"VBR" "CBR"})))

(s/def
  :cognitect.aws.medialive/Scte35InputMode
  (s/spec string? :gen #(s/gen #{"FIXED" "FOLLOW_ACTIVE"})))

(s/def
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator
  (s/spec
    string?
    :gen
    #(s/gen
      #{"LessThanThreshold"
        "GreaterThanThreshold"
        "LessThanOrEqualToThreshold"
        "GreaterThanOrEqualToThreshold"})))

(s/def
  :cognitect.aws.medialive/GetSignalMapResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.GetSignalMapResponseContent/Status
     :cognitect.aws.medialive.GetSignalMapResponseContent/CreatedAt
     :cognitect.aws.medialive.GetSignalMapResponseContent/Name
     :cognitect.aws.medialive.GetSignalMapResponseContent/Id
     :cognitect.aws.medialive.GetSignalMapResponseContent/Arn
     :cognitect.aws.medialive.GetSignalMapResponseContent/DiscoveryEntryPointArn
     :cognitect.aws.medialive.GetSignalMapResponseContent/MonitorChangesPendingDeployment]
    :opt-un
    [:cognitect.aws.medialive.GetSignalMapResponseContent/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.GetSignalMapResponseContent/Tags
     :cognitect.aws.medialive.GetSignalMapResponseContent/ErrorMessage
     :cognitect.aws.medialive.GetSignalMapResponseContent/MonitorDeployment
     :cognitect.aws.medialive.GetSignalMapResponseContent/Description
     :cognitect.aws.medialive.GetSignalMapResponseContent/ModifiedAt
     :cognitect.aws.medialive.GetSignalMapResponseContent/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.GetSignalMapResponseContent/FailedMediaResourceMap
     :cognitect.aws.medialive.GetSignalMapResponseContent/MediaResourceMap
     :cognitect.aws.medialive.GetSignalMapResponseContent/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.GetSignalMapResponseContent/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/HlsSegmentationMode
  (s/spec string? :gen #(s/gen #{"USE_INPUT_SEGMENTATION" "USE_SEGMENT_DURATION"})))

(s/def
  :cognitect.aws.medialive/BurnInBackgroundColor
  (s/spec string? :gen #(s/gen #{"NONE" "WHITE" "BLACK"})))

(s/def
  :cognitect.aws.medialive/DescribeMultiplexResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeMultiplexResponse/ProgramCount
     :cognitect.aws.medialive.DescribeMultiplexResponse/PipelinesRunningCount
     :cognitect.aws.medialive.DescribeMultiplexResponse/Tags
     :cognitect.aws.medialive.DescribeMultiplexResponse/Arn
     :cognitect.aws.medialive.DescribeMultiplexResponse/MultiplexSettings
     :cognitect.aws.medialive.DescribeMultiplexResponse/State
     :cognitect.aws.medialive.DescribeMultiplexResponse/Destinations
     :cognitect.aws.medialive.DescribeMultiplexResponse/Name
     :cognitect.aws.medialive.DescribeMultiplexResponse/AvailabilityZones
     :cognitect.aws.medialive.DescribeMultiplexResponse/Id]))

(s/def
  :cognitect.aws.medialive/StartMonitorDeploymentResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Status
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/CreatedAt
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Name
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Id
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Arn
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/DiscoveryEntryPointArn
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/MonitorChangesPendingDeployment]
    :opt-un
    [:cognitect.aws.medialive.StartMonitorDeploymentResponseContent/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Tags
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/ErrorMessage
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/MonitorDeployment
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Description
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/ModifiedAt
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/FailedMediaResourceMap
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/MediaResourceMap
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/SdiSourceSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.SdiSourceSummary/Type
     :cognitect.aws.medialive.SdiSourceSummary/Mode
     :cognitect.aws.medialive.SdiSourceSummary/Inputs
     :cognitect.aws.medialive.SdiSourceSummary/Arn
     :cognitect.aws.medialive.SdiSourceSummary/State
     :cognitect.aws.medialive.SdiSourceSummary/Name
     :cognitect.aws.medialive.SdiSourceSummary/Id]))

(s/def
  :cognitect.aws.medialive/UpdateChannelPlacementGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateChannelPlacementGroupRequest/ClusterId
     :cognitect.aws.medialive.UpdateChannelPlacementGroupRequest/ChannelPlacementGroupId]
    :opt-un
    [:cognitect.aws.medialive.UpdateChannelPlacementGroupRequest/Nodes
     :cognitect.aws.medialive.UpdateChannelPlacementGroupRequest/Name]))

(s/def
  :cognitect.aws.medialive/AudioNormalizationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AudioNormalizationSettings/TargetLkfs
     :cognitect.aws.medialive.AudioNormalizationSettings/AlgorithmControl
     :cognitect.aws.medialive.AudioNormalizationSettings/Algorithm]))

(s/def
  :cognitect.aws.medialive/MultiplexOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.MultiplexOutputSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.MultiplexOutputSettings/ContainerSettings]))

(s/def
  :cognitect.aws.medialive/VideoDescriptionRespondToAfd
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE" "RESPOND"})))

(s/def
  :cognitect.aws.medialive/EventBridgeRuleTemplateGroupSummary
  (s/keys
    :req-un
    [:cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/TemplateCount
     :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/CreatedAt
     :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Id
     :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Arn
     :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Name]
    :opt-un
    [:cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Tags
     :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Description
     :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/ThumbnailConfiguration
  (s/keys :req-un [:cognitect.aws.medialive.ThumbnailConfiguration/State]))

(s/def
  :cognitect.aws.medialive/NielsenCBET
  (s/keys
    :req-un
    [:cognitect.aws.medialive.NielsenCBET/CbetCheckDigitString
     :cognitect.aws.medialive.NielsenCBET/CbetStepaside
     :cognitect.aws.medialive.NielsenCBET/Csid]))

(s/def
  :cognitect.aws.medialive/ChannelPlacementGroupState
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ASSIGNING" "UNASSIGNED" "DELETING" "DELETED" "ASSIGNED" "DELETE_FAILED" "UNASSIGNING"})))

(s/def
  :cognitect.aws.medialive/ReservationCodec
  (s/spec string? :gen #(s/gen #{"HEVC" "AV1" "MPEG2" "LINK" "AUDIO" "AVC"})))

(s/def :cognitect.aws.medialive/MediaPackageOutputSettings (s/keys))

(s/def
  :cognitect.aws.medialive/__integerMin0Max32768
  (s/spec (s/and int? #(<= 0 % 32768)) :gen #(gen/choose 0 32768)))

(s/def
  :cognitect.aws.medialive/__listOfChannelPipelineIdToRestart
  (s/coll-of :cognitect.aws.medialive/ChannelPipelineIdToRestart))

(s/def
  :cognitect.aws.medialive/Scte35InputScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35InputScheduleActionSettings/Mode]
    :opt-un
    [:cognitect.aws.medialive.Scte35InputScheduleActionSettings/InputAttachmentNameReference]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max128
  (s/spec (s/and int? #(<= 0 % 128)) :gen #(gen/choose 0 128)))

(s/def
  :cognitect.aws.medialive/CmafKLVBehavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/GetCloudWatchAlarmTemplateRequest
  (s/keys :req-un [:cognitect.aws.medialive.GetCloudWatchAlarmTemplateRequest/Identifier]))

(s/def
  :cognitect.aws.medialive/RtmpGroupSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.RtmpGroupSettings/InputLossAction
     :cognitect.aws.medialive.RtmpGroupSettings/AdMarkers
     :cognitect.aws.medialive.RtmpGroupSettings/CacheLength
     :cognitect.aws.medialive.RtmpGroupSettings/AuthenticationScheme
     :cognitect.aws.medialive.RtmpGroupSettings/IncludeFillerNalUnits
     :cognitect.aws.medialive.RtmpGroupSettings/CacheFullBehavior
     :cognitect.aws.medialive.RtmpGroupSettings/CaptionData
     :cognitect.aws.medialive.RtmpGroupSettings/RestartDelay]))

(s/def
  :cognitect.aws.medialive/NetworkState
  (s/spec
    string?
    :gen
    #(s/gen
      #{"IDLE"
        "IN_USE"
        "CREATE_FAILED"
        "UPDATING"
        "DELETING"
        "CREATING"
        "ACTIVE"
        "DELETED"
        "DELETE_FAILED"})))

(s/def
  :cognitect.aws.medialive/RtmpOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.RtmpOutputSettings/Destination]
    :opt-un
    [:cognitect.aws.medialive.RtmpOutputSettings/NumRetries
     :cognitect.aws.medialive.RtmpOutputSettings/CertificateMode
     :cognitect.aws.medialive.RtmpOutputSettings/ConnectionRetryInterval]))

(s/def
  :cognitect.aws.medialive/StaticImageOutputDeactivateScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.StaticImageOutputDeactivateScheduleActionSettings/OutputNames]
    :opt-un
    [:cognitect.aws.medialive.StaticImageOutputDeactivateScheduleActionSettings/Layer
     :cognitect.aws.medialive.StaticImageOutputDeactivateScheduleActionSettings/FadeOut]))

(s/def
  :cognitect.aws.medialive/TemporalFilterSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.TemporalFilterSettings/PostFilterSharpening
     :cognitect.aws.medialive.TemporalFilterSettings/Strength]))

(s/def
  :cognitect.aws.medialive/DescribeThumbnailsResponse
  (s/keys :opt-un [:cognitect.aws.medialive.DescribeThumbnailsResponse/ThumbnailDetails]))

(s/def
  :cognitect.aws.medialive/UpdateChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateChannelRequest/ChannelId]
    :opt-un
    [:cognitect.aws.medialive.UpdateChannelRequest/DryRun
     :cognitect.aws.medialive.UpdateChannelRequest/InputAttachments
     :cognitect.aws.medialive.UpdateChannelRequest/LogLevel
     :cognitect.aws.medialive.UpdateChannelRequest/RoleArn
     :cognitect.aws.medialive.UpdateChannelRequest/AnywhereSettings
     :cognitect.aws.medialive.UpdateChannelRequest/CdiInputSpecification
     :cognitect.aws.medialive.UpdateChannelRequest/EncoderSettings
     :cognitect.aws.medialive.UpdateChannelRequest/InputSpecification
     :cognitect.aws.medialive.UpdateChannelRequest/ChannelEngineVersion
     :cognitect.aws.medialive.UpdateChannelRequest/Destinations
     :cognitect.aws.medialive.UpdateChannelRequest/Name
     :cognitect.aws.medialive.UpdateChannelRequest/Maintenance]))

(s/def
  :cognitect.aws.medialive/RtmpOutputCertificateMode
  (s/spec string? :gen #(s/gen #{"VERIFY_AUTHENTICITY" "SELF_SIGNED"})))

(s/def
  :cognitect.aws.medialive/__integerMin100000Max80000000
  (s/spec (s/and int? #(<= 100000 % 80000000)) :gen #(gen/choose 100000 80000000)))

(s/def
  :cognitect.aws.medialive/UpdateMultiplexProgram
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateMultiplexProgram/MultiplexProgramSettings]))

(s/def
  :cognitect.aws.medialive/DeleteChannelPlacementGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DeleteChannelPlacementGroupRequest/ClusterId
     :cognitect.aws.medialive.DeleteChannelPlacementGroupRequest/ChannelPlacementGroupId]))

(s/def
  :cognitect.aws.medialive/__integerMin1000Max30000
  (s/spec (s/and int? #(<= 1000 % 30000)) :gen #(gen/choose 1000 30000)))

(s/def
  :cognitect.aws.medialive/BandwidthReductionFilterSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BandwidthReductionFilterSettings/PostFilterSharpening
     :cognitect.aws.medialive.BandwidthReductionFilterSettings/Strength]))

(s/def
  :cognitect.aws.medialive/ListEventBridgeRuleTemplatesResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.ListEventBridgeRuleTemplatesResponseContent/EventBridgeRuleTemplates]
    :opt-un
    [:cognitect.aws.medialive.ListEventBridgeRuleTemplatesResponseContent/NextToken]))

(s/def
  :cognitect.aws.medialive/NielsenWatermarksCbetStepaside
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/H265GopSizeUnits
  (s/spec string? :gen #(s/gen #{"SECONDS" "FRAMES"})))

(s/def
  :cognitect.aws.medialive/DescribeOfferingRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeOfferingRequest/OfferingId]))

(s/def
  :cognitect.aws.medialive/AvailConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AvailConfiguration/AvailSettings
     :cognitect.aws.medialive.AvailConfiguration/Scte35SegmentationScope]))

(s/def
  :cognitect.aws.medialive/AudioDescriptionLanguageCodeControl
  (s/spec string? :gen #(s/gen #{"FOLLOW_INPUT" "USE_CONFIGURED"})))

(s/def
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget
  (s/coll-of :cognitect.aws.medialive/EventBridgeRuleTemplateTarget))

(s/def
  :cognitect.aws.medialive/__integerMin1Max3600000
  (s/spec (s/and int? #(<= 1 % 3600000)) :gen #(gen/choose 1 3600000)))

(s/def
  :cognitect.aws.medialive/TemporalFilterStrength
  (s/spec
    string?
    :gen
    #(s/gen
      #{"STRENGTH_7"
        "STRENGTH_8"
        "STRENGTH_2"
        "STRENGTH_15"
        "STRENGTH_5"
        "AUTO"
        "STRENGTH_3"
        "STRENGTH_14"
        "STRENGTH_9"
        "STRENGTH_4"
        "STRENGTH_1"
        "STRENGTH_10"
        "STRENGTH_12"
        "STRENGTH_16"
        "STRENGTH_13"
        "STRENGTH_6"
        "STRENGTH_11"})))

(s/def
  :cognitect.aws.medialive/ListCloudWatchAlarmTemplateGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsResponse/CloudWatchAlarmTemplateGroups
     :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsResponse/NextToken]))

(s/def
  :cognitect.aws.medialive/ListClustersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListClustersRequest/NextToken
     :cognitect.aws.medialive.ListClustersRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/ListInputsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputsRequest/NextToken
     :cognitect.aws.medialive.ListInputsRequest/MaxResults]))

(s/def
  :cognitect.aws.medialive/ListMultiplexProgramsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListMultiplexProgramsResponse/NextToken
     :cognitect.aws.medialive.ListMultiplexProgramsResponse/MultiplexPrograms]))

(s/def
  :cognitect.aws.medialive/CreatePartnerInputResultModel
  (s/keys :opt-un [:cognitect.aws.medialive.CreatePartnerInputResultModel/Input]))

(s/def
  :cognitect.aws.medialive/BatchFailedResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchFailedResultModel/Message
     :cognitect.aws.medialive.BatchFailedResultModel/Arn
     :cognitect.aws.medialive.BatchFailedResultModel/Code
     :cognitect.aws.medialive.BatchFailedResultModel/Id]))

(s/def
  :cognitect.aws.medialive/Scte35ReturnToNetworkScheduleActionSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.Scte35ReturnToNetworkScheduleActionSettings/SpliceEventId]))

(s/def
  :cognitect.aws.medialive/HlsH265PackagingType
  (s/spec string? :gen #(s/gen #{"HVC1" "HEV1"})))

(s/def
  :cognitect.aws.medialive/BatchUpdateScheduleResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchUpdateScheduleResponse/Creates
     :cognitect.aws.medialive.BatchUpdateScheduleResponse/Deletes]))

(s/def
  :cognitect.aws.medialive/Scte35Type
  (s/spec string? :gen #(s/gen #{"SCTE_35_WITHOUT_SEGMENTATION" "NONE"})))

(s/def
  :cognitect.aws.medialive/HlsS3Settings
  (s/keys :opt-un [:cognitect.aws.medialive.HlsS3Settings/CannedAcl]))

(s/def
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplateGroup
  (s/spec
    #(re-matches (re-pattern "^arn:.+:medialive:.+:cloudwatch-alarm-template-group:.+$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.medialive/NielsenNaesIiNw
  (s/keys
    :req-un
    [:cognitect.aws.medialive.NielsenNaesIiNw/CheckDigitString
     :cognitect.aws.medialive.NielsenNaesIiNw/Sid]
    :opt-un
    [:cognitect.aws.medialive.NielsenNaesIiNw/Timezone]))

(s/def
  :cognitect.aws.medialive/UpdateMultiplexProgramRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateMultiplexProgramRequest/MultiplexId
     :cognitect.aws.medialive.UpdateMultiplexProgramRequest/ProgramName]
    :opt-un
    [:cognitect.aws.medialive.UpdateMultiplexProgramRequest/MultiplexProgramSettings]))

(s/def
  :cognitect.aws.medialive/ListEventBridgeRuleTemplatesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListEventBridgeRuleTemplatesResponse/EventBridgeRuleTemplates
     :cognitect.aws.medialive.ListEventBridgeRuleTemplatesResponse/NextToken]))

(s/def
  :cognitect.aws.medialive/__listOfInputSecurityGroup
  (s/coll-of :cognitect.aws.medialive/InputSecurityGroup))

(s/def
  :cognitect.aws.medialive/CdiInputSpecification
  (s/keys :opt-un [:cognitect.aws.medialive.CdiInputSpecification/Resolution]))

(s/def
  :cognitect.aws.medialive/CaptionRectangle
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CaptionRectangle/TopOffset
     :cognitect.aws.medialive.CaptionRectangle/Height
     :cognitect.aws.medialive.CaptionRectangle/Width
     :cognitect.aws.medialive.CaptionRectangle/LeftOffset]))

(s/def
  :cognitect.aws.medialive/H264TimecodeInsertionBehavior
  (s/spec string? :gen #(s/gen #{"DISABLED" "PIC_TIMING_SEI"})))

(s/def
  :cognitect.aws.medialive/FailoverConditionSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.FailoverConditionSettings/InputLossSettings
     :cognitect.aws.medialive.FailoverConditionSettings/VideoBlackSettings
     :cognitect.aws.medialive.FailoverConditionSettings/AudioSilenceSettings]))

(s/def
  :cognitect.aws.medialive/CreateMultiplexProgramResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreateMultiplexProgramResponse/MultiplexProgram]))

(s/def
  :cognitect.aws.medialive/PipelineDetail
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.PipelineDetail/ActiveMotionGraphicsActionName
     :cognitect.aws.medialive.PipelineDetail/ActiveInputAttachmentName
     :cognitect.aws.medialive.PipelineDetail/PipelineId
     :cognitect.aws.medialive.PipelineDetail/ActiveMotionGraphicsUri
     :cognitect.aws.medialive.PipelineDetail/ChannelEngineVersion
     :cognitect.aws.medialive.PipelineDetail/ActiveInputSwitchActionName]))

(s/def
  :cognitect.aws.medialive/RtmpCacheFullBehavior
  (s/spec string? :gen #(s/gen #{"WAIT_FOR_SERVER" "DISCONNECT_IMMEDIATELY"})))

(s/def
  :cognitect.aws.medialive/__listOfRouteUpdateRequest
  (s/coll-of :cognitect.aws.medialive/RouteUpdateRequest))

(s/def
  :cognitect.aws.medialive/NetworkInputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.NetworkInputSettings/HlsInputSettings
     :cognitect.aws.medialive.NetworkInputSettings/MulticastInputSettings
     :cognitect.aws.medialive.NetworkInputSettings/ServerValidation]))

(s/def
  :cognitect.aws.medialive/M3u8NielsenId3Behavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/InputDeviceNetworkSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceNetworkSettings/SubnetMask
     :cognitect.aws.medialive.InputDeviceNetworkSettings/IpScheme
     :cognitect.aws.medialive.InputDeviceNetworkSettings/DnsAddresses
     :cognitect.aws.medialive.InputDeviceNetworkSettings/IpAddress
     :cognitect.aws.medialive.InputDeviceNetworkSettings/Gateway]))

(s/def
  :cognitect.aws.medialive/AudioChannelMapping
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioChannelMapping/OutputChannel
     :cognitect.aws.medialive.AudioChannelMapping/InputChannelLevels]))

(s/def
  :cognitect.aws.medialive/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.medialive.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.medialive/Fmp4NielsenId3Behavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/__doubleMin0
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.medialive/ListInputDeviceTransfersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListInputDeviceTransfersResponse/NextToken
     :cognitect.aws.medialive.ListInputDeviceTransfersResponse/InputDeviceTransfers]))

(s/def
  :cognitect.aws.medialive/ListEventBridgeRuleTemplatesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListEventBridgeRuleTemplatesRequest/NextToken
     :cognitect.aws.medialive.ListEventBridgeRuleTemplatesRequest/GroupIdentifier
     :cognitect.aws.medialive.ListEventBridgeRuleTemplatesRequest/MaxResults
     :cognitect.aws.medialive.ListEventBridgeRuleTemplatesRequest/SignalMapIdentifier]))

(s/def
  :cognitect.aws.medialive/MotionGraphicsSettings
  (s/keys :opt-un [:cognitect.aws.medialive.MotionGraphicsSettings/HtmlMotionGraphicsSettings]))

(s/def :cognitect.aws.medialive/OfferingType (s/spec string? :gen #(s/gen #{"NO_UPFRONT"})))

(s/def
  :cognitect.aws.medialive/DescribeChannelRequest
  (s/keys :req-un [:cognitect.aws.medialive.DescribeChannelRequest/ChannelId]))

(s/def
  :cognitect.aws.medialive/InputClass
  (s/spec string? :gen #(s/gen #{"SINGLE_PIPELINE" "STANDARD"})))

(s/def
  :cognitect.aws.medialive/H264SceneChangeDetect
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/__listOfMultiplexOutputDestination
  (s/coll-of :cognitect.aws.medialive/MultiplexOutputDestination))

(s/def
  :cognitect.aws.medialive/MultiplexProgramPipelineDetail
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexProgramPipelineDetail/PipelineId
     :cognitect.aws.medialive.MultiplexProgramPipelineDetail/ActiveChannelPipeline]))

(s/def
  :cognitect.aws.medialive/VpcOutputSettingsDescription
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.VpcOutputSettingsDescription/SubnetIds
     :cognitect.aws.medialive.VpcOutputSettingsDescription/SecurityGroupIds
     :cognitect.aws.medialive.VpcOutputSettingsDescription/NetworkInterfaceIds
     :cognitect.aws.medialive.VpcOutputSettingsDescription/AvailabilityZones]))

(s/def
  :cognitect.aws.medialive/Eac3BitstreamMode
  (s/spec
    string?
    :gen
    #(s/gen #{"COMPLETE_MAIN" "VISUALLY_IMPAIRED" "EMERGENCY" "COMMENTARY" "HEARING_IMPAIRED"})))

(s/def
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData
  (s/spec string? :gen #(s/gen #{"ignore" "breaching" "notBreaching" "missing"})))

(s/def
  :cognitect.aws.medialive/__integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.medialive/SrtOutputSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.SrtOutputSettings/Destination
     :cognitect.aws.medialive.SrtOutputSettings/ContainerSettings]
    :opt-un
    [:cognitect.aws.medialive.SrtOutputSettings/EncryptionType
     :cognitect.aws.medialive.SrtOutputSettings/Latency
     :cognitect.aws.medialive.SrtOutputSettings/BufferMsec]))

(s/def
  :cognitect.aws.medialive/DeviceUpdateStatus
  (s/spec string? :gen #(s/gen #{"UPDATING" "UP_TO_DATE" "NOT_UP_TO_DATE"})))

(s/def
  :cognitect.aws.medialive/TransferringInputDeviceSummary
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.TransferringInputDeviceSummary/Message
     :cognitect.aws.medialive.TransferringInputDeviceSummary/TransferType
     :cognitect.aws.medialive.TransferringInputDeviceSummary/TargetCustomerId
     :cognitect.aws.medialive.TransferringInputDeviceSummary/Id]))

(s/def
  :cognitect.aws.medialive/AfdSignaling
  (s/spec string? :gen #(s/gen #{"AUTO" "FIXED" "NONE"})))

(s/def :cognitect.aws.medialive/__listOf__string (s/coll-of :cognitect.aws.medialive/__string))

(s/def
  :cognitect.aws.medialive/PauseStateScheduleActionSettings
  (s/keys :opt-un [:cognitect.aws.medialive.PauseStateScheduleActionSettings/Pipelines]))

(s/def
  :cognitect.aws.medialive/InputDeviceHdSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDeviceHdSettings/Framerate
     :cognitect.aws.medialive.InputDeviceHdSettings/ScanType
     :cognitect.aws.medialive.InputDeviceHdSettings/ConfiguredInput
     :cognitect.aws.medialive.InputDeviceHdSettings/Width
     :cognitect.aws.medialive.InputDeviceHdSettings/LatencyMs
     :cognitect.aws.medialive.InputDeviceHdSettings/Height
     :cognitect.aws.medialive.InputDeviceHdSettings/MaxBitrate
     :cognitect.aws.medialive.InputDeviceHdSettings/DeviceState
     :cognitect.aws.medialive.InputDeviceHdSettings/ActiveInput]))

(s/def
  :cognitect.aws.medialive/__stringMax100
  (s/spec
    (s/and string? #(>= 100 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.medialive/BatchDeleteResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.BatchDeleteResponse/Failed
     :cognitect.aws.medialive.BatchDeleteResponse/Successful]))

(s/def
  :cognitect.aws.medialive/BurnInAlignment
  (s/spec string? :gen #(s/gen #{"LEFT" "CENTERED" "SMART"})))

(s/def
  :cognitect.aws.medialive/__integerMin1Max6
  (s/spec (s/and int? #(<= 1 % 6)) :gen #(gen/choose 1 6)))

(s/def :cognitect.aws.medialive/AcceptInputDeviceTransferResponse (s/keys))

(s/def
  :cognitect.aws.medialive/WavSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.WavSettings/CodingMode
     :cognitect.aws.medialive.WavSettings/SampleRate
     :cognitect.aws.medialive.WavSettings/BitDepth]))

(s/def
  :cognitect.aws.medialive/Eac3AttenuationControl
  (s/spec string? :gen #(s/gen #{"ATTENUATE_3_DB" "NONE"})))

(s/def
  :cognitect.aws.medialive/DescribeNodeResult
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeNodeResult/ConnectionState
     :cognitect.aws.medialive.DescribeNodeResult/ClusterId
     :cognitect.aws.medialive.DescribeNodeResult/Role
     :cognitect.aws.medialive.DescribeNodeResult/NodeInterfaceMappings
     :cognitect.aws.medialive.DescribeNodeResult/SdiSourceMappings
     :cognitect.aws.medialive.DescribeNodeResult/Arn
     :cognitect.aws.medialive.DescribeNodeResult/State
     :cognitect.aws.medialive.DescribeNodeResult/Name
     :cognitect.aws.medialive.DescribeNodeResult/Id
     :cognitect.aws.medialive.DescribeNodeResult/ChannelPlacementGroups
     :cognitect.aws.medialive.DescribeNodeResult/InstanceArn]))

(s/def
  :cognitect.aws.medialive/ListMultiplexesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListMultiplexesResponse/Multiplexes
     :cognitect.aws.medialive.ListMultiplexesResponse/NextToken]))

(s/def :cognitect.aws.medialive/H265TilePadding (s/spec string? :gen #(s/gen #{"NONE" "PADDED"})))

(s/def
  :cognitect.aws.medialive/ListReservationsResultModel
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.ListReservationsResultModel/NextToken
     :cognitect.aws.medialive.ListReservationsResultModel/Reservations]))

(s/def
  :cognitect.aws.medialive/InputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputSettings/InputFilter
     :cognitect.aws.medialive.InputSettings/DenoiseFilter
     :cognitect.aws.medialive.InputSettings/SourceEndBehavior
     :cognitect.aws.medialive.InputSettings/FilterStrength
     :cognitect.aws.medialive.InputSettings/Scte35Pid
     :cognitect.aws.medialive.InputSettings/Smpte2038DataPreference
     :cognitect.aws.medialive.InputSettings/CaptionSelectors
     :cognitect.aws.medialive.InputSettings/VideoSelector
     :cognitect.aws.medialive.InputSettings/NetworkInputSettings
     :cognitect.aws.medialive.InputSettings/AudioSelectors
     :cognitect.aws.medialive.InputSettings/DeblockFilter]))

(s/def
  :cognitect.aws.medialive/TooManyRequestsException
  (s/keys :opt-un [:cognitect.aws.medialive.TooManyRequestsException/Message]))

(s/def
  :cognitect.aws.medialive/InputSecurityGroupState
  (s/spec string? :gen #(s/gen #{"IDLE" "IN_USE" "UPDATING" "DELETED"})))

(s/def
  :cognitect.aws.medialive/HlsScte35SourceType
  (s/spec string? :gen #(s/gen #{"MANIFEST" "SEGMENTS"})))

(s/def
  :cognitect.aws.medialive/HlsMediaStoreSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsMediaStoreSettings/NumRetries
     :cognitect.aws.medialive.HlsMediaStoreSettings/FilecacheDuration
     :cognitect.aws.medialive.HlsMediaStoreSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.HlsMediaStoreSettings/MediaStoreStorageClass
     :cognitect.aws.medialive.HlsMediaStoreSettings/RestartDelay]))

(s/def
  :cognitect.aws.medialive/HlsManifestCompression
  (s/spec string? :gen #(s/gen #{"GZIP" "NONE"})))

(s/def :cognitect.aws.medialive/MotionGraphicsDeactivateScheduleActionSettings (s/keys))

(s/def
  :cognitect.aws.medialive/GetEventBridgeRuleTemplateResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/EventType
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/CreatedAt
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Id
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Arn
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Name
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/GroupId]
    :opt-un
    [:cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Tags
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Description
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/EventTargets
     :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/CreateNodeRegistrationScriptResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.CreateNodeRegistrationScriptResponse/NodeRegistrationScript]))

(s/def
  :cognitect.aws.medialive/MultiplexM2tsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexM2tsSettings/NielsenId3Behavior
     :cognitect.aws.medialive.MultiplexM2tsSettings/AudioFramesPerPes
     :cognitect.aws.medialive.MultiplexM2tsSettings/AbsentInputAudioBehavior
     :cognitect.aws.medialive.MultiplexM2tsSettings/PcrControl
     :cognitect.aws.medialive.MultiplexM2tsSettings/Arib
     :cognitect.aws.medialive.MultiplexM2tsSettings/Ebif
     :cognitect.aws.medialive.MultiplexM2tsSettings/PcrPeriod
     :cognitect.aws.medialive.MultiplexM2tsSettings/CcDescriptor
     :cognitect.aws.medialive.MultiplexM2tsSettings/Scte35Control
     :cognitect.aws.medialive.MultiplexM2tsSettings/AudioBufferModel
     :cognitect.aws.medialive.MultiplexM2tsSettings/EsRateInPes
     :cognitect.aws.medialive.MultiplexM2tsSettings/Klv
     :cognitect.aws.medialive.MultiplexM2tsSettings/AudioStreamType
     :cognitect.aws.medialive.MultiplexM2tsSettings/Scte35PrerollPullupMilliseconds]))

(s/def
  :cognitect.aws.medialive/GlobalConfigurationOutputLockingMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "PIPELINE_LOCKING" "EPOCH_LOCKING"})))

(s/def
  :cognitect.aws.medialive/Ac3Settings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Ac3Settings/CodingMode
     :cognitect.aws.medialive.Ac3Settings/AttenuationControl
     :cognitect.aws.medialive.Ac3Settings/LfeFilter
     :cognitect.aws.medialive.Ac3Settings/DrcProfile
     :cognitect.aws.medialive.Ac3Settings/MetadataControl
     :cognitect.aws.medialive.Ac3Settings/BitstreamMode
     :cognitect.aws.medialive.Ac3Settings/Dialnorm
     :cognitect.aws.medialive.Ac3Settings/Bitrate]))

(s/def
  :cognitect.aws.medialive/StartUpdateSignalMapResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StartUpdateSignalMapResponse/LastSuccessfulMonitorDeployment
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/Tags
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/Status
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/ErrorMessage
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/MonitorDeployment
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/DiscoveryEntryPointArn
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/Description
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/ModifiedAt
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/CloudWatchAlarmTemplateGroupIds
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/Arn
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/CreatedAt
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/FailedMediaResourceMap
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/Name
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/MediaResourceMap
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/MonitorChangesPendingDeployment
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/EventBridgeRuleTemplateGroupIds
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/Id
     :cognitect.aws.medialive.StartUpdateSignalMapResponse/LastDiscoveredAt]))

(s/def
  :cognitect.aws.medialive/InputWhitelistRule
  (s/keys :opt-un [:cognitect.aws.medialive.InputWhitelistRule/Cidr]))

(s/def
  :cognitect.aws.medialive/CreateSignalMapRequestContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateSignalMapRequestContent/DiscoveryEntryPointArn
     :cognitect.aws.medialive.CreateSignalMapRequestContent/Name]
    :opt-un
    [:cognitect.aws.medialive.CreateSignalMapRequestContent/RequestId
     :cognitect.aws.medialive.CreateSignalMapRequestContent/Tags
     :cognitect.aws.medialive.CreateSignalMapRequestContent/EventBridgeRuleTemplateGroupIdentifiers
     :cognitect.aws.medialive.CreateSignalMapRequestContent/CloudWatchAlarmTemplateGroupIdentifiers
     :cognitect.aws.medialive.CreateSignalMapRequestContent/Description]))

(s/def
  :cognitect.aws.medialive/FecOutputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.FecOutputSettings/IncludeFec
     :cognitect.aws.medialive.FecOutputSettings/ColumnDepth
     :cognitect.aws.medialive.FecOutputSettings/RowLength]))

(s/def
  :cognitect.aws.medialive/__listOfAudioSelector
  (s/coll-of :cognitect.aws.medialive/AudioSelector))

(s/def
  :cognitect.aws.medialive/DvbNitSettings
  (s/keys
    :req-un
    [:cognitect.aws.medialive.DvbNitSettings/NetworkName
     :cognitect.aws.medialive.DvbNitSettings/NetworkId]
    :opt-un
    [:cognitect.aws.medialive.DvbNitSettings/RepInterval]))

(s/def
  :cognitect.aws.medialive/UpdateNodeState
  (s/spec string? :gen #(s/gen #{"DRAINING" "ACTIVE"})))

(s/def
  :cognitect.aws.medialive/H264ColorMetadata
  (s/spec string? :gen #(s/gen #{"INSERT" "IGNORE"})))

(s/def
  :cognitect.aws.medialive/__stringMin1Max2048PatternArn
  (s/spec #(re-matches (re-pattern "^arn.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.medialive/InputDeviceScanType
  (s/spec string? :gen #(s/gen #{"PROGRESSIVE" "INTERLACED"})))

(s/def
  :cognitect.aws.medialive/CreatePartnerInputRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreatePartnerInputRequest/InputId]
    :opt-un
    [:cognitect.aws.medialive.CreatePartnerInputRequest/RequestId
     :cognitect.aws.medialive.CreatePartnerInputRequest/Tags]))

(s/def
  :cognitect.aws.medialive/__stringPattern010920300
  (s/spec #(re-matches (re-pattern "^([0,1]?[0-9]|2[0-3]):00$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.medialive/UpdateMultiplexResponse
  (s/keys :opt-un [:cognitect.aws.medialive.UpdateMultiplexResponse/Multiplex]))

(s/def
  :cognitect.aws.medialive/InputTimecodeSource
  (s/spec string? :gen #(s/gen #{"ZEROBASED" "EMBEDDED"})))

(s/def
  :cognitect.aws.medialive/StopChannelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.StopChannelResponse/ChannelClass
     :cognitect.aws.medialive.StopChannelResponse/InputAttachments
     :cognitect.aws.medialive.StopChannelResponse/PipelinesRunningCount
     :cognitect.aws.medialive.StopChannelResponse/LogLevel
     :cognitect.aws.medialive.StopChannelResponse/RoleArn
     :cognitect.aws.medialive.StopChannelResponse/Tags
     :cognitect.aws.medialive.StopChannelResponse/PipelineDetails
     :cognitect.aws.medialive.StopChannelResponse/AnywhereSettings
     :cognitect.aws.medialive.StopChannelResponse/EgressEndpoints
     :cognitect.aws.medialive.StopChannelResponse/CdiInputSpecification
     :cognitect.aws.medialive.StopChannelResponse/EncoderSettings
     :cognitect.aws.medialive.StopChannelResponse/Vpc
     :cognitect.aws.medialive.StopChannelResponse/Arn
     :cognitect.aws.medialive.StopChannelResponse/InputSpecification
     :cognitect.aws.medialive.StopChannelResponse/ChannelEngineVersion
     :cognitect.aws.medialive.StopChannelResponse/State
     :cognitect.aws.medialive.StopChannelResponse/Destinations
     :cognitect.aws.medialive.StopChannelResponse/Name
     :cognitect.aws.medialive.StopChannelResponse/Maintenance
     :cognitect.aws.medialive.StopChannelResponse/Id]))

(s/def
  :cognitect.aws.medialive/DescribeInputDeviceThumbnailResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/Body
     :cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/ETag
     :cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/ContentType
     :cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/ContentLength
     :cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/LastModified]))

(s/def
  :cognitect.aws.medialive/H265TreeblockSize
  (s/spec string? :gen #(s/gen #{"AUTO" "TREE_SIZE_32X32"})))

(s/def
  :cognitect.aws.medialive/CreateEventBridgeRuleTemplateResponseContent
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/EventType
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/CreatedAt
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Id
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Arn
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Name
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/GroupId]
    :opt-un
    [:cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Tags
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Description
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/EventTargets
     :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/ModifiedAt]))

(s/def
  :cognitect.aws.medialive/DeleteInputSecurityGroupRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteInputSecurityGroupRequest/InputSecurityGroupId]))

(s/def
  :cognitect.aws.medialive/AudioLanguageSelection
  (s/keys
    :req-un
    [:cognitect.aws.medialive.AudioLanguageSelection/LanguageCode]
    :opt-un
    [:cognitect.aws.medialive.AudioLanguageSelection/LanguageSelectionPolicy]))

(s/def
  :cognitect.aws.medialive/BurnInTeletextGridControl
  (s/spec string? :gen #(s/gen #{"FIXED" "SCALED"})))

(s/def
  :cognitect.aws.medialive/GetCloudWatchAlarmTemplateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/TreatMissingData
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Period
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Threshold
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Tags
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/ComparisonOperator
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/GroupId
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/TargetResourceType
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/DatapointsToAlarm
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Description
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/ModifiedAt
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Arn
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/CreatedAt
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/MetricName
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Name
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/EvaluationPeriods
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Id
     :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Statistic]))

(s/def
  :cognitect.aws.medialive/CreateInputResponse
  (s/keys :opt-un [:cognitect.aws.medialive.CreateInputResponse/Input]))

(s/def
  :cognitect.aws.medialive/__listOfInputDestinationRoute
  (s/coll-of :cognitect.aws.medialive/InputDestinationRoute))

(s/def
  :cognitect.aws.medialive/BandwidthReductionPostFilterSharpening
  (s/spec string? :gen #(s/gen #{"DISABLED" "SHARPENING_1" "SHARPENING_2" "SHARPENING_3"})))

(s/def
  :cognitect.aws.medialive/Eac3AtmosSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Eac3AtmosSettings/SurroundTrim
     :cognitect.aws.medialive.Eac3AtmosSettings/CodingMode
     :cognitect.aws.medialive.Eac3AtmosSettings/DrcLine
     :cognitect.aws.medialive.Eac3AtmosSettings/HeightTrim
     :cognitect.aws.medialive.Eac3AtmosSettings/DrcRf
     :cognitect.aws.medialive.Eac3AtmosSettings/Dialnorm
     :cognitect.aws.medialive.Eac3AtmosSettings/Bitrate]))

(s/def
  :cognitect.aws.medialive/InputDestinationRoute
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.InputDestinationRoute/Cidr
     :cognitect.aws.medialive.InputDestinationRoute/Gateway]))

(s/def
  :cognitect.aws.medialive/MaintenanceDay
  (s/spec
    string?
    :gen
    #(s/gen #{"WEDNESDAY" "SUNDAY" "THURSDAY" "TUESDAY" "FRIDAY" "SATURDAY" "MONDAY"})))

(s/def
  :cognitect.aws.medialive/H265TimecodeInsertionBehavior
  (s/spec string? :gen #(s/gen #{"DISABLED" "PIC_TIMING_SEI"})))

(s/def
  :cognitect.aws.medialive/AacVbrQuality
  (s/spec string? :gen #(s/gen #{"LOW" "MEDIUM_LOW" "HIGH" "MEDIUM_HIGH"})))

(s/def
  :cognitect.aws.medialive/UpdateMultiplex
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateMultiplex/PacketIdentifiersMapping
     :cognitect.aws.medialive.UpdateMultiplex/MultiplexSettings
     :cognitect.aws.medialive.UpdateMultiplex/Name]))

(s/def
  :cognitect.aws.medialive/__listOfOutputDestination
  (s/coll-of :cognitect.aws.medialive/OutputDestination))

(s/def
  :cognitect.aws.medialive/UpdateEventBridgeRuleTemplateGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupRequest/Identifier]
    :opt-un
    [:cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupRequest/Description]))

(s/def
  :cognitect.aws.medialive/HlsS3LogUploads
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/DvbSdtOutputSdt
  (s/spec string? :gen #(s/gen #{"SDT_MANUAL" "SDT_NONE" "SDT_FOLLOW_IF_PRESENT" "SDT_FOLLOW"})))

(s/def
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateGroupSummary
  (s/coll-of :cognitect.aws.medialive/EventBridgeRuleTemplateGroupSummary))

(s/def
  :cognitect.aws.medialive/SignalMapMonitorDeploymentStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DRY_RUN_DEPLOYMENT_IN_PROGRESS"
        "DEPLOYMENT_IN_PROGRESS"
        "DELETE_IN_PROGRESS"
        "NOT_DEPLOYED"
        "DELETE_COMPLETE"
        "DEPLOYMENT_FAILED"
        "DRY_RUN_DEPLOYMENT_FAILED"
        "DRY_RUN_DEPLOYMENT_COMPLETE"
        "DEPLOYMENT_COMPLETE"
        "DELETE_FAILED"})))

(s/def
  :cognitect.aws.medialive/HlsId3SegmentTaggingState
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.medialive/DashRoleAudio
  (s/spec
    string?
    :gen
    #(s/gen
      #{"KARAOKE"
        "DESCRIPTION"
        "ENHANCED-AUDIO-INTELLIGIBILITY"
        "ALTERNATE"
        "MAIN"
        "EMERGENCY"
        "DUB"
        "SUPPLEMENTARY"
        "COMMENTARY"})))

(s/def
  :cognitect.aws.medialive/TimecodeConfig
  (s/keys
    :req-un
    [:cognitect.aws.medialive.TimecodeConfig/Source]
    :opt-un
    [:cognitect.aws.medialive.TimecodeConfig/SyncThreshold]))

(s/def
  :cognitect.aws.medialive/HlsAkamaiSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsAkamaiSettings/HttpTransferMode
     :cognitect.aws.medialive.HlsAkamaiSettings/NumRetries
     :cognitect.aws.medialive.HlsAkamaiSettings/FilecacheDuration
     :cognitect.aws.medialive.HlsAkamaiSettings/ConnectionRetryInterval
     :cognitect.aws.medialive.HlsAkamaiSettings/Token
     :cognitect.aws.medialive.HlsAkamaiSettings/RestartDelay
     :cognitect.aws.medialive.HlsAkamaiSettings/Salt]))

(s/def
  :cognitect.aws.medialive/UpdateInputDevice
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateInputDevice/HdDeviceSettings
     :cognitect.aws.medialive.UpdateInputDevice/AvailabilityZone
     :cognitect.aws.medialive.UpdateInputDevice/UhdDeviceSettings
     :cognitect.aws.medialive.UpdateInputDevice/Name]))

(s/def
  :cognitect.aws.medialive/UpdateCloudWatchAlarmTemplateGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupRequest/Identifier]
    :opt-un
    [:cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupRequest/Description]))

(s/def
  :cognitect.aws.medialive/OutputSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.OutputSettings/ArchiveOutputSettings
     :cognitect.aws.medialive.OutputSettings/FrameCaptureOutputSettings
     :cognitect.aws.medialive.OutputSettings/MediaPackageOutputSettings
     :cognitect.aws.medialive.OutputSettings/UdpOutputSettings
     :cognitect.aws.medialive.OutputSettings/CmafIngestOutputSettings
     :cognitect.aws.medialive.OutputSettings/RtmpOutputSettings
     :cognitect.aws.medialive.OutputSettings/MsSmoothOutputSettings
     :cognitect.aws.medialive.OutputSettings/MultiplexOutputSettings
     :cognitect.aws.medialive.OutputSettings/SrtOutputSettings
     :cognitect.aws.medialive.OutputSettings/HlsOutputSettings]))

(s/def
  :cognitect.aws.medialive/Fmp4TimedMetadataBehavior
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NO_PASSTHROUGH"})))

(s/def
  :cognitect.aws.medialive/SdiSourceMapping
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.SdiSourceMapping/CardNumber
     :cognitect.aws.medialive.SdiSourceMapping/ChannelNumber
     :cognitect.aws.medialive.SdiSourceMapping/SdiSource]))

(s/def
  :cognitect.aws.medialive/GlobalConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.GlobalConfiguration/InitialAudioGain
     :cognitect.aws.medialive.GlobalConfiguration/OutputLockingMode
     :cognitect.aws.medialive.GlobalConfiguration/InputLossBehavior
     :cognitect.aws.medialive.GlobalConfiguration/InputEndAction
     :cognitect.aws.medialive.GlobalConfiguration/SupportLowFramerateInputs
     :cognitect.aws.medialive.GlobalConfiguration/OutputLockingSettings
     :cognitect.aws.medialive.GlobalConfiguration/OutputTimingSource]))

(s/def
  :cognitect.aws.medialive/CreateNodeRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.CreateNodeRequest/ClusterId]
    :opt-un
    [:cognitect.aws.medialive.CreateNodeRequest/RequestId
     :cognitect.aws.medialive.CreateNodeRequest/Tags
     :cognitect.aws.medialive.CreateNodeRequest/Role
     :cognitect.aws.medialive.CreateNodeRequest/NodeInterfaceMappings
     :cognitect.aws.medialive.CreateNodeRequest/Name]))

(s/def :cognitect.aws.medialive/InputDeviceType (s/spec string? :gen #(s/gen #{"UHD" "HD"})))

(s/def
  :cognitect.aws.medialive/UpdateNodeStateRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.UpdateNodeStateRequest/NodeId
     :cognitect.aws.medialive.UpdateNodeStateRequest/ClusterId]
    :opt-un
    [:cognitect.aws.medialive.UpdateNodeStateRequest/State]))

(s/def
  :cognitect.aws.medialive/DeleteNetworkRequest
  (s/keys :req-un [:cognitect.aws.medialive.DeleteNetworkRequest/NetworkId]))

(s/def
  :cognitect.aws.medialive/EmbeddedConvert608To708
  (s/spec string? :gen #(s/gen #{"DISABLED" "UPCONVERT"})))

(s/def
  :cognitect.aws.medialive/ConflictException
  (s/keys :opt-un [:cognitect.aws.medialive.ConflictException/Message]))

(s/def
  :cognitect.aws.medialive/__integerMin0Max1000
  (s/spec (s/and int? #(<= 0 % 1000)) :gen #(gen/choose 0 1000)))

(s/def
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplate
  (s/spec
    #(re-matches (re-pattern "^arn:.+:medialive:.+:cloudwatch-alarm-template:.+$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.medialive/AudioCodecSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.AudioCodecSettings/Eac3Settings
     :cognitect.aws.medialive.AudioCodecSettings/Mp2Settings
     :cognitect.aws.medialive.AudioCodecSettings/Eac3AtmosSettings
     :cognitect.aws.medialive.AudioCodecSettings/PassThroughSettings
     :cognitect.aws.medialive.AudioCodecSettings/Ac3Settings
     :cognitect.aws.medialive.AudioCodecSettings/AacSettings
     :cognitect.aws.medialive.AudioCodecSettings/WavSettings]))

(s/def
  :cognitect.aws.medialive/MultiplexProgramChannelDestinationSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.MultiplexProgramChannelDestinationSettings/ProgramName
     :cognitect.aws.medialive.MultiplexProgramChannelDestinationSettings/MultiplexId]))

(s/def
  :cognitect.aws.medialive/UpdateAccountConfigurationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.UpdateAccountConfigurationRequest/AccountConfiguration]))

(s/def
  :cognitect.aws.medialive/AncillarySourceSettings
  (s/keys :opt-un [:cognitect.aws.medialive.AncillarySourceSettings/SourceAncillaryChannelNumber]))

(s/def
  :cognitect.aws.medialive/HlsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.HlsSettings/AudioOnlyHlsSettings
     :cognitect.aws.medialive.HlsSettings/FrameCaptureHlsSettings
     :cognitect.aws.medialive.HlsSettings/Fmp4HlsSettings
     :cognitect.aws.medialive.HlsSettings/StandardHlsSettings]))

(s/def
  :cognitect.aws.medialive/M2tsAbsentInputAudioBehavior
  (s/spec string? :gen #(s/gen #{"ENCODE_SILENCE" "DROP"})))

(s/def
  :cognitect.aws.medialive/Fmp4HlsSettings
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.Fmp4HlsSettings/NielsenId3Behavior
     :cognitect.aws.medialive.Fmp4HlsSettings/TimedMetadataBehavior
     :cognitect.aws.medialive.Fmp4HlsSettings/AudioRenditionSets]))

(s/def :cognitect.aws.medialive/RtmpCaptionInfoDestinationSettings (s/keys))

(s/def
  :cognitect.aws.medialive/DescribeChannelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeChannelResponse/ChannelClass
     :cognitect.aws.medialive.DescribeChannelResponse/InputAttachments
     :cognitect.aws.medialive.DescribeChannelResponse/PipelinesRunningCount
     :cognitect.aws.medialive.DescribeChannelResponse/LogLevel
     :cognitect.aws.medialive.DescribeChannelResponse/RoleArn
     :cognitect.aws.medialive.DescribeChannelResponse/Tags
     :cognitect.aws.medialive.DescribeChannelResponse/PipelineDetails
     :cognitect.aws.medialive.DescribeChannelResponse/AnywhereSettings
     :cognitect.aws.medialive.DescribeChannelResponse/EgressEndpoints
     :cognitect.aws.medialive.DescribeChannelResponse/CdiInputSpecification
     :cognitect.aws.medialive.DescribeChannelResponse/EncoderSettings
     :cognitect.aws.medialive.DescribeChannelResponse/Vpc
     :cognitect.aws.medialive.DescribeChannelResponse/Arn
     :cognitect.aws.medialive.DescribeChannelResponse/InputSpecification
     :cognitect.aws.medialive.DescribeChannelResponse/ChannelEngineVersion
     :cognitect.aws.medialive.DescribeChannelResponse/State
     :cognitect.aws.medialive.DescribeChannelResponse/Destinations
     :cognitect.aws.medialive.DescribeChannelResponse/Name
     :cognitect.aws.medialive.DescribeChannelResponse/Maintenance
     :cognitect.aws.medialive.DescribeChannelResponse/Id]))

(s/def
  :cognitect.aws.medialive/TransferInputDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.medialive.TransferInputDeviceRequest/InputDeviceId]
    :opt-un
    [:cognitect.aws.medialive.TransferInputDeviceRequest/TargetRegion
     :cognitect.aws.medialive.TransferInputDeviceRequest/TransferMessage
     :cognitect.aws.medialive.TransferInputDeviceRequest/TargetCustomerId]))

(s/def
  :cognitect.aws.medialive/__integerMin1Max16
  (s/spec (s/and int? #(<= 1 % 16)) :gen #(gen/choose 1 16)))

(s/def
  :cognitect.aws.medialive/DvbDashAccessibility
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DVBDASH_4_DIRECTORS_COMMENTARY"
        "DVBDASH_1_VISUALLY_IMPAIRED"
        "DVBDASH_7_CLEAN_FEED"
        "DVBDASH_5_EDUCATIONAL_NOTES"
        "DVBDASH_3_SUPPLEMENTAL_COMMENTARY"
        "DVBDASH_6_MAIN_PROGRAM"
        "DVBDASH_2_HARD_OF_HEARING"})))

(s/def
  :cognitect.aws.medialive/DescribeMultiplexProgramResponse
  (s/keys
    :opt-un
    [:cognitect.aws.medialive.DescribeMultiplexProgramResponse/ProgramName
     :cognitect.aws.medialive.DescribeMultiplexProgramResponse/ChannelId
     :cognitect.aws.medialive.DescribeMultiplexProgramResponse/PipelineDetails
     :cognitect.aws.medialive.DescribeMultiplexProgramResponse/PacketIdentifiersMap
     :cognitect.aws.medialive.DescribeMultiplexProgramResponse/MultiplexProgramSettings]))

(s/def
  :cognitect.aws.medialive/__stringMin1Max2048
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.medialive.DvbSdtSettings/OutputSdt :cognitect.aws.medialive/DvbSdtOutputSdt)

(s/def
  :cognitect.aws.medialive.DvbSdtSettings/RepInterval
  :cognitect.aws.medialive/__integerMin25Max2000)

(s/def
  :cognitect.aws.medialive.DvbSdtSettings/ServiceName
  :cognitect.aws.medialive/__stringMin1Max256)

(s/def
  :cognitect.aws.medialive.DvbSdtSettings/ServiceProviderName
  :cognitect.aws.medialive/__stringMin1Max256)

(s/def :cognitect.aws.medialive.DescribeNetworkResult/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNetworkResult/AssociatedClusterIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.DescribeNetworkResult/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNetworkResult/IpPools
  :cognitect.aws.medialive/__listOfIpPool)

(s/def :cognitect.aws.medialive.DescribeNetworkResult/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNetworkResult/Routes :cognitect.aws.medialive/__listOfRoute)

(s/def :cognitect.aws.medialive.DescribeNetworkResult/State :cognitect.aws.medialive/NetworkState)

(s/def
  :cognitect.aws.medialive.AudioDescription/AudioTypeControl
  :cognitect.aws.medialive/AudioDescriptionAudioTypeControl)

(s/def
  :cognitect.aws.medialive.AudioDescription/LanguageCodeControl
  :cognitect.aws.medialive/AudioDescriptionLanguageCodeControl)

(s/def :cognitect.aws.medialive.AudioDescription/AudioType :cognitect.aws.medialive/AudioType)

(s/def
  :cognitect.aws.medialive.AudioDescription/AudioWatermarkingSettings
  :cognitect.aws.medialive/AudioWatermarkSettings)

(s/def :cognitect.aws.medialive.AudioDescription/StreamName :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioDescription/RemixSettings
  :cognitect.aws.medialive/RemixSettings)

(s/def
  :cognitect.aws.medialive.AudioDescription/CodecSettings
  :cognitect.aws.medialive/AudioCodecSettings)

(s/def :cognitect.aws.medialive.AudioDescription/Name :cognitect.aws.medialive/__stringMax255)

(s/def
  :cognitect.aws.medialive.AudioDescription/AudioDashRoles
  :cognitect.aws.medialive/__listOfDashRoleAudio)

(s/def
  :cognitect.aws.medialive.AudioDescription/AudioSelectorName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioDescription/AudioNormalizationSettings
  :cognitect.aws.medialive/AudioNormalizationSettings)

(s/def
  :cognitect.aws.medialive.AudioDescription/LanguageCode
  :cognitect.aws.medialive/__stringMin1Max35)

(s/def
  :cognitect.aws.medialive.AudioDescription/DvbDashAccessibility
  :cognitect.aws.medialive/DvbDashAccessibility)

(s/def :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioGroupId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioOnlyImage
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.AudioOnlyHlsSettings/AudioTrackType
  :cognitect.aws.medialive/AudioOnlyHlsTrackType)

(s/def
  :cognitect.aws.medialive.AudioOnlyHlsSettings/SegmentType
  :cognitect.aws.medialive/AudioOnlyHlsSegmentType)

(s/def :cognitect.aws.medialive.AudioSelector/Name :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.AudioSelector/SelectorSettings
  :cognitect.aws.medialive/AudioSelectorSettings)

(s/def :cognitect.aws.medialive.DeleteSignalMapRequest/Identifier :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateReservationResponse/Reservation
  :cognitect.aws.medialive/Reservation)

(s/def
  :cognitect.aws.medialive.InterfaceMappingCreateRequest/LogicalInterfaceName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InterfaceMappingCreateRequest/NetworkId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Arn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Id
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Inputs
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/State
  :cognitect.aws.medialive/InputSecurityGroupState)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/Tags
  :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupResponse/WhitelistRules
  :cognitect.aws.medialive/__listOfInputWhitelistRule)

(s/def
  :cognitect.aws.medialive.NodeInterfaceMappingCreateRequest/LogicalInterfaceName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.NodeInterfaceMappingCreateRequest/NetworkInterfaceMode
  :cognitect.aws.medialive/NetworkInterfaceMode)

(s/def
  :cognitect.aws.medialive.NodeInterfaceMappingCreateRequest/PhysicalInterfaceName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ThumbnailData/Body :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateMultiplexProgram/MultiplexProgramSettings
  :cognitect.aws.medialive/MultiplexProgramSettings)

(s/def
  :cognitect.aws.medialive.CreateMultiplexProgram/ProgramName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateMultiplexProgram/RequestId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsert/AdAvailOffset
  :cognitect.aws.medialive/__integerMinNegative1000Max1000)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsert/NoRegionalBlackoutFlag
  :cognitect.aws.medialive/Scte35SpliceInsertNoRegionalBlackoutBehavior)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsert/WebDeliveryAllowedFlag
  :cognitect.aws.medialive/Scte35SpliceInsertWebDeliveryAllowedBehavior)

(s/def :cognitect.aws.medialive.InputSdpLocation/MediaIndex :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.InputSdpLocation/SdpUrl :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNetworkRequest/IpPools
  :cognitect.aws.medialive/__listOfIpPoolCreateRequest)

(s/def :cognitect.aws.medialive.CreateNetworkRequest/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateNetworkRequest/RequestId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNetworkRequest/Routes
  :cognitect.aws.medialive/__listOfRouteCreateRequest)

(s/def :cognitect.aws.medialive.CreateNetworkRequest/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DescribeAnywhereSettings/ChannelPlacementGroupId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeAnywhereSettings/ClusterId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListNodesResult/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListNodesResult/Nodes
  :cognitect.aws.medialive/__listOfDescribeNodeSummary)

(s/def
  :cognitect.aws.medialive.Id3SegmentTaggingScheduleActionSettings/Id3
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Id3SegmentTaggingScheduleActionSettings/Tag
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InternalServiceError/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AvailBlanking/AvailBlankingImage
  :cognitect.aws.medialive/InputLocation)

(s/def :cognitect.aws.medialive.AvailBlanking/State :cognitect.aws.medialive/AvailBlankingState)

(s/def
  :cognitect.aws.medialive.ListReservationsResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsResponse/Reservations
  :cognitect.aws.medialive/__listOfReservation)

(s/def
  :cognitect.aws.medialive.SuccessfulMonitorDeployment/DetailsUri
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.SuccessfulMonitorDeployment/Status
  :cognitect.aws.medialive/SignalMapMonitorDeploymentStatus)

(s/def :cognitect.aws.medialive.BatchDelete/ChannelIds :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.BatchDelete/InputIds :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.BatchDelete/InputSecurityGroupIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.BatchDelete/MultiplexIds :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.InputChannelLevel/Gain
  :cognitect.aws.medialive/__integerMinNegative60Max6)

(s/def
  :cognitect.aws.medialive.InputChannelLevel/InputChannel
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/HlsGroupSettings
  :cognitect.aws.medialive/HlsGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/MultiplexGroupSettings
  :cognitect.aws.medialive/MultiplexGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/ArchiveGroupSettings
  :cognitect.aws.medialive/ArchiveGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/FrameCaptureGroupSettings
  :cognitect.aws.medialive/FrameCaptureGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/SrtGroupSettings
  :cognitect.aws.medialive/SrtGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/CmafIngestGroupSettings
  :cognitect.aws.medialive/CmafIngestGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/MsSmoothGroupSettings
  :cognitect.aws.medialive/MsSmoothGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/UdpGroupSettings
  :cognitect.aws.medialive/UdpGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/MediaPackageGroupSettings
  :cognitect.aws.medialive/MediaPackageGroupSettings)

(s/def
  :cognitect.aws.medialive.OutputGroupSettings/RtmpGroupSettings
  :cognitect.aws.medialive/RtmpGroupSettings)

(s/def
  :cognitect.aws.medialive.Smpte2110ReceiverGroupSdpSettings/AncillarySdps
  :cognitect.aws.medialive/__listOfInputSdpLocation)

(s/def
  :cognitect.aws.medialive.Smpte2110ReceiverGroupSdpSettings/AudioSdps
  :cognitect.aws.medialive/__listOfInputSdpLocation)

(s/def
  :cognitect.aws.medialive.Smpte2110ReceiverGroupSdpSettings/VideoSdp
  :cognitect.aws.medialive/InputSdpLocation)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsRequest/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ClusterNetworkSettings/DefaultRoute
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ClusterNetworkSettings/InterfaceMappings
  :cognitect.aws.medialive/__listOfInterfaceMapping)

(s/def :cognitect.aws.medialive.InputSecurityGroup/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSecurityGroup/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSecurityGroup/Inputs :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.InputSecurityGroup/State
  :cognitect.aws.medialive/InputSecurityGroupState)

(s/def :cognitect.aws.medialive.InputSecurityGroup/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.InputSecurityGroup/WhitelistRules
  :cognitect.aws.medialive/__listOfInputWhitelistRule)

(s/def
  :cognitect.aws.medialive.DeleteSdiSourceRequest/SdiSourceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/GroupIdentifier
  :cognitect.aws.medialive/__stringPatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequestContent/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def :cognitect.aws.medialive.UpdateSdiSourceRequest/Mode :cognitect.aws.medialive/SdiSourceMode)

(s/def :cognitect.aws.medialive.UpdateSdiSourceRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateSdiSourceRequest/SdiSourceId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateSdiSourceRequest/Type :cognitect.aws.medialive/SdiSourceType)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateTarget/Arn
  :cognitect.aws.medialive/__stringMin1Max2048PatternArn)

(s/def :cognitect.aws.medialive.HlsInputSettings/Bandwidth :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsInputSettings/BufferSegments
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.HlsInputSettings/Retries :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsInputSettings/RetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsInputSettings/Scte35Source
  :cognitect.aws.medialive/HlsScte35SourceType)

(s/def
  :cognitect.aws.medialive.Scte35TimeSignalApos/AdAvailOffset
  :cognitect.aws.medialive/__integerMinNegative1000Max1000)

(s/def
  :cognitect.aws.medialive.Scte35TimeSignalApos/NoRegionalBlackoutFlag
  :cognitect.aws.medialive/Scte35AposNoRegionalBlackoutBehavior)

(s/def
  :cognitect.aws.medialive.Scte35TimeSignalApos/WebDeliveryAllowedFlag
  :cognitect.aws.medialive/Scte35AposWebDeliveryAllowedBehavior)

(s/def
  :cognitect.aws.medialive.VideoDescription/CodecSettings
  :cognitect.aws.medialive/VideoCodecSettings)

(s/def :cognitect.aws.medialive.VideoDescription/Height :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.VideoDescription/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.VideoDescription/RespondToAfd
  :cognitect.aws.medialive/VideoDescriptionRespondToAfd)

(s/def
  :cognitect.aws.medialive.VideoDescription/ScalingBehavior
  :cognitect.aws.medialive/VideoDescriptionScalingBehavior)

(s/def
  :cognitect.aws.medialive.VideoDescription/Sharpness
  :cognitect.aws.medialive/__integerMin0Max100)

(s/def :cognitect.aws.medialive.VideoDescription/Width :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.ListNetworksResponse/Networks
  :cognitect.aws.medialive/__listOfDescribeNetworkSummary)

(s/def :cognitect.aws.medialive.ListNetworksResponse/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def :cognitect.aws.medialive.CreateSignalMapResponseContent/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponseContent/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def
  :cognitect.aws.medialive.BatchDeleteResultModel/Failed
  :cognitect.aws.medialive/__listOfBatchFailedResultModel)

(s/def
  :cognitect.aws.medialive.BatchDeleteResultModel/Successful
  :cognitect.aws.medialive/__listOfBatchSuccessfulResultModel)

(s/def
  :cognitect.aws.medialive.InterfaceMappingUpdateRequest/LogicalInterfaceName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InterfaceMappingUpdateRequest/NetworkId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexSettings/MaximumVideoBufferDelayMilliseconds
  :cognitect.aws.medialive/__integerMin800Max3000)

(s/def
  :cognitect.aws.medialive.MultiplexSettings/TransportStreamBitrate
  :cognitect.aws.medialive/__integerMin1000000Max100000000)

(s/def
  :cognitect.aws.medialive.MultiplexSettings/TransportStreamId
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def
  :cognitect.aws.medialive.MultiplexSettings/TransportStreamReservedBitrate
  :cognitect.aws.medialive/__integerMin0Max100000000)

(s/def :cognitect.aws.medialive.ChannelSummary/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def :cognitect.aws.medialive.ChannelSummary/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ChannelSummary/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.ChannelSummary/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.ChannelSummary/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.ChannelSummary/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.ChannelSummary/ChannelClass :cognitect.aws.medialive/ChannelClass)

(s/def
  :cognitect.aws.medialive.ChannelSummary/Vpc
  :cognitect.aws.medialive/VpcOutputSettingsDescription)

(s/def :cognitect.aws.medialive.ChannelSummary/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ChannelSummary/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.ChannelSummary/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ChannelSummary/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ChannelSummary/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.ChannelSummary/State :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.ChannelSummary/AnywhereSettings
  :cognitect.aws.medialive/DescribeAnywhereSettings)

(s/def
  :cognitect.aws.medialive.ChannelSummary/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.ChannelSummary/Maintenance
  :cognitect.aws.medialive/MaintenanceStatus)

(s/def
  :cognitect.aws.medialive.ChannelSummary/UsedChannelEngineVersions
  :cognitect.aws.medialive/__listOfChannelEngineVersionResponse)

(s/def
  :cognitect.aws.medialive.ChannelSummary/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionResponse)

(s/def
  :cognitect.aws.medialive.CreateMultiplexProgramRequest/MultiplexId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateMultiplexProgramRequest/MultiplexProgramSettings
  :cognitect.aws.medialive/MultiplexProgramSettings)

(s/def
  :cognitect.aws.medialive.CreateMultiplexProgramRequest/ProgramName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateMultiplexProgramRequest/RequestId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNetworkResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNetworkResponse/AssociatedClusterIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.DescribeNetworkResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNetworkResponse/IpPools
  :cognitect.aws.medialive/__listOfIpPool)

(s/def :cognitect.aws.medialive.DescribeNetworkResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNetworkResponse/Routes
  :cognitect.aws.medialive/__listOfRoute)

(s/def :cognitect.aws.medialive.DescribeNetworkResponse/State :cognitect.aws.medialive/NetworkState)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsResponse/InputSecurityGroups
  :cognitect.aws.medialive/__listOfInputSecurityGroup)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/DeliveryRestrictions
  :cognitect.aws.medialive/Scte35DeliveryRestrictions)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SubSegmentNum
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationCancelIndicator
  :cognitect.aws.medialive/Scte35SegmentationCancelIndicator)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SubSegmentsExpected
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationEventId
  :cognitect.aws.medialive/__longMin0Max4294967295)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationUpidType
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationUpid
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationDuration
  :cognitect.aws.medialive/__longMin0Max1099511627775)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentsExpected
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentNum
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.Scte35SegmentationDescriptor/SegmentationTypeId
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/ChannelClass
  :cognitect.aws.medialive/ChannelClass)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/Vpc
  :cognitect.aws.medialive/VpcOutputSettingsDescription)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/PipelineDetails
  :cognitect.aws.medialive/__listOfPipelineDetail)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.DeleteChannelResponse/State :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/AnywhereSettings
  :cognitect.aws.medialive/DescribeAnywhereSettings)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/Maintenance
  :cognitect.aws.medialive/MaintenanceStatus)

(s/def
  :cognitect.aws.medialive.DeleteChannelResponse/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionResponse)

(s/def
  :cognitect.aws.medialive.UpdateNetworkRequest/IpPools
  :cognitect.aws.medialive/__listOfIpPoolUpdateRequest)

(s/def :cognitect.aws.medialive.UpdateNetworkRequest/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNetworkRequest/NetworkId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateNetworkRequest/Routes
  :cognitect.aws.medialive/__listOfRouteUpdateRequest)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplateGroup)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def :cognitect.aws.medialive.CreateChannelResponse/Channel :cognitect.aws.medialive/Channel)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/ChannelClass
  :cognitect.aws.medialive/ChannelClass)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/Codec
  :cognitect.aws.medialive/ReservationCodec)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/MaximumBitrate
  :cognitect.aws.medialive/ReservationMaximumBitrate)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/MaximumFramerate
  :cognitect.aws.medialive/ReservationMaximumFramerate)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/Resolution
  :cognitect.aws.medialive/ReservationResolution)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/ResourceType
  :cognitect.aws.medialive/ReservationResourceType)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/SpecialFeature
  :cognitect.aws.medialive/ReservationSpecialFeature)

(s/def
  :cognitect.aws.medialive.ReservationResourceSpecification/VideoQuality
  :cognitect.aws.medialive/ReservationVideoQuality)

(s/def
  :cognitect.aws.medialive.ListSignalMapsResponse/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.ListSignalMapsResponse/SignalMaps
  :cognitect.aws.medialive/__listOfSignalMapSummary)

(s/def :cognitect.aws.medialive.DescribeNetworkRequest/NetworkId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteClusterResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteClusterResponse/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DeleteClusterResponse/ClusterType
  :cognitect.aws.medialive/ClusterType)

(s/def :cognitect.aws.medialive.DeleteClusterResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteClusterResponse/InstanceRoleArn
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteClusterResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteClusterResponse/NetworkSettings
  :cognitect.aws.medialive/ClusterNetworkSettings)

(s/def :cognitect.aws.medialive.DeleteClusterResponse/State :cognitect.aws.medialive/ClusterState)

(s/def :cognitect.aws.medialive.DeleteTagsRequest/ResourceArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteTagsRequest/TagKeys :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.MultiplexSummary/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettingsSummary)

(s/def :cognitect.aws.medialive.MultiplexSummary/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.MultiplexSummary/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.MultiplexSummary/AvailabilityZones
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.MultiplexSummary/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.MultiplexSummary/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.MultiplexSummary/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.MultiplexSummary/State :cognitect.aws.medialive/MultiplexState)

(s/def :cognitect.aws.medialive.MultiplexSummary/ProgramCount :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.SrtSettings/SrtCallerSources
  :cognitect.aws.medialive/__listOfSrtCallerSource)

(s/def
  :cognitect.aws.medialive.NotFoundExceptionResponseContent/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CaptionLanguageMapping/CaptionChannel
  :cognitect.aws.medialive/__integerMin1Max4)

(s/def
  :cognitect.aws.medialive.CaptionLanguageMapping/LanguageCode
  :cognitect.aws.medialive/__stringMin3Max3)

(s/def
  :cognitect.aws.medialive.CaptionLanguageMapping/LanguageDescription
  :cognitect.aws.medialive/__stringMin1)

(s/def :cognitect.aws.medialive.DeleteScheduleRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputDestinationSettings/PasswordParam
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputDestinationSettings/StreamName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.OutputDestinationSettings/Url :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputDestinationSettings/Username
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/EventTargetCount
  :cognitect.aws.medialive/__integerMax5)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplate)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateSummary/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.Scte35TimeSignalScheduleActionSettings/Scte35Descriptors
  :cognitect.aws.medialive/__listOfScte35Descriptor)

(s/def
  :cognitect.aws.medialive.Mpeg2FilterSettings/TemporalFilterSettings
  :cognitect.aws.medialive/TemporalFilterSettings)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def :cognitect.aws.medialive.CreateSignalMapResponse/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateSignalMapResponse/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def :cognitect.aws.medialive.OutputDestination/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputDestination/MediaPackageSettings
  :cognitect.aws.medialive/__listOfMediaPackageOutputDestinationSettings)

(s/def
  :cognitect.aws.medialive.OutputDestination/MultiplexSettings
  :cognitect.aws.medialive/MultiplexProgramChannelDestinationSettings)

(s/def
  :cognitect.aws.medialive.OutputDestination/Settings
  :cognitect.aws.medialive/__listOfOutputDestinationSettings)

(s/def
  :cognitect.aws.medialive.OutputDestination/SrtSettings
  :cognitect.aws.medialive/__listOfSrtOutputDestinationSettings)

(s/def
  :cognitect.aws.medialive.OutputDestination/LogicalInterfaceNames
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.Av1Settings/GopSize :cognitect.aws.medialive/__doubleMin0)

(s/def
  :cognitect.aws.medialive.Av1Settings/TimecodeBurninSettings
  :cognitect.aws.medialive/TimecodeBurninSettings)

(s/def :cognitect.aws.medialive.Av1Settings/ParNumerator :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.Av1Settings/ParDenominator :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.Av1Settings/SceneChangeDetect
  :cognitect.aws.medialive/Av1SceneChangeDetect)

(s/def :cognitect.aws.medialive.Av1Settings/FixedAfd :cognitect.aws.medialive/FixedAfd)

(s/def
  :cognitect.aws.medialive.Av1Settings/MinIInterval
  :cognitect.aws.medialive/__integerMin0Max30)

(s/def
  :cognitect.aws.medialive.Av1Settings/QvbrQualityLevel
  :cognitect.aws.medialive/__integerMin1Max10)

(s/def
  :cognitect.aws.medialive.Av1Settings/FramerateNumerator
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.Av1Settings/RateControlMode
  :cognitect.aws.medialive/Av1RateControlMode)

(s/def
  :cognitect.aws.medialive.Av1Settings/Bitrate
  :cognitect.aws.medialive/__integerMin50000Max12000000)

(s/def
  :cognitect.aws.medialive.Av1Settings/ColorSpaceSettings
  :cognitect.aws.medialive/Av1ColorSpaceSettings)

(s/def :cognitect.aws.medialive.Av1Settings/Level :cognitect.aws.medialive/Av1Level)

(s/def :cognitect.aws.medialive.Av1Settings/GopSizeUnits :cognitect.aws.medialive/Av1GopSizeUnits)

(s/def
  :cognitect.aws.medialive.Av1Settings/MaxBitrate
  :cognitect.aws.medialive/__integerMin50000Max12000000)

(s/def
  :cognitect.aws.medialive.Av1Settings/FramerateDenominator
  :cognitect.aws.medialive/__integerMin1Max3003)

(s/def
  :cognitect.aws.medialive.Av1Settings/LookAheadRateControl
  :cognitect.aws.medialive/Av1LookAheadRateControl)

(s/def :cognitect.aws.medialive.Av1Settings/AfdSignaling :cognitect.aws.medialive/AfdSignaling)

(s/def
  :cognitect.aws.medialive.Av1Settings/BufSize
  :cognitect.aws.medialive/__integerMin50000Max24000000)

(s/def
  :cognitect.aws.medialive.BlackoutSlate/BlackoutSlateImage
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.BlackoutSlate/NetworkEndBlackout
  :cognitect.aws.medialive/BlackoutSlateNetworkEndBlackout)

(s/def
  :cognitect.aws.medialive.BlackoutSlate/NetworkEndBlackoutImage
  :cognitect.aws.medialive/InputLocation)

(s/def :cognitect.aws.medialive.BlackoutSlate/NetworkId :cognitect.aws.medialive/__stringMin34Max34)

(s/def :cognitect.aws.medialive.BlackoutSlate/State :cognitect.aws.medialive/BlackoutSlateState)

(s/def
  :cognitect.aws.medialive.ListClustersResponse/Clusters
  :cognitect.aws.medialive/__listOfDescribeClusterSummary)

(s/def :cognitect.aws.medialive.ListClustersResponse/NextToken :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeClusterRequest/ClusterId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Arn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Channels
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Id
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/Nodes
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupResponse/State
  :cognitect.aws.medialive/ChannelPlacementGroupState)

(s/def :cognitect.aws.medialive.InputDeviceSettings/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.BatchSuccessfulResultModel/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.BatchSuccessfulResultModel/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.BatchSuccessfulResultModel/State :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequestContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequestContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequestContent/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def
  :cognitect.aws.medialive.DescribeSdiSourceResponse/SdiSource
  :cognitect.aws.medialive/SdiSource)

(s/def
  :cognitect.aws.medialive.RejectInputDeviceTransferRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ArchiveContainerSettings/M2tsSettings
  :cognitect.aws.medialive/M2tsSettings)

(s/def
  :cognitect.aws.medialive.ArchiveContainerSettings/RawSettings
  :cognitect.aws.medialive/RawSettings)

(s/def
  :cognitect.aws.medialive.ListInputDevicesResponse/InputDevices
  :cognitect.aws.medialive/__listOfInputDeviceSummary)

(s/def
  :cognitect.aws.medialive.ListInputDevicesResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MulticastSettingsCreateRequest/Sources
  :cognitect.aws.medialive/__listOfMulticastSourceCreateRequest)

(s/def
  :cognitect.aws.medialive.TimecodeBurninSettings/FontSize
  :cognitect.aws.medialive/TimecodeBurninFontSize)

(s/def
  :cognitect.aws.medialive.TimecodeBurninSettings/Position
  :cognitect.aws.medialive/TimecodeBurninPosition)

(s/def
  :cognitect.aws.medialive.TimecodeBurninSettings/Prefix
  :cognitect.aws.medialive/__stringMax255)

(s/def
  :cognitect.aws.medialive.MulticastSettingsUpdateRequest/Sources
  :cognitect.aws.medialive/__listOfMulticastSourceUpdateRequest)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsertScheduleActionSettings/Duration
  :cognitect.aws.medialive/__longMin0Max8589934591)

(s/def
  :cognitect.aws.medialive.Scte35SpliceInsertScheduleActionSettings/SpliceEventId
  :cognitect.aws.medialive/__longMin0Max4294967295)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ArchiveS3Settings/CannedAcl :cognitect.aws.medialive/S3CannedAcl)

(s/def
  :cognitect.aws.medialive.MultiplexMediaConnectOutputDestinationSettings/EntitlementArn
  :cognitect.aws.medialive/__stringMin1)

(s/def :cognitect.aws.medialive.CreatePartnerInput/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreatePartnerInput/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/LogLevel
  :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/Id
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.RestartChannelPipelinesResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/ChannelClass
  :cognitect.aws.medialive/ChannelClass)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/Vpc
  :cognitect.aws.medialive/VpcOutputSettingsDescription)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/MaintenanceStatus
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/RoleArn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/PipelineDetails
  :cognitect.aws.medialive/__listOfPipelineDetail)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/Arn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/State
  :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/AnywhereSettings
  :cognitect.aws.medialive/DescribeAnywhereSettings)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/Maintenance
  :cognitect.aws.medialive/MaintenanceStatus)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesResponse/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionResponse)

(s/def
  :cognitect.aws.medialive.ListSdiSourcesRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListSdiSourcesRequest/NextToken :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Hdr10Settings/MaxCll :cognitect.aws.medialive/__integerMin0Max32768)

(s/def
  :cognitect.aws.medialive.Hdr10Settings/MaxFall
  :cognitect.aws.medialive/__integerMin0Max32768)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/GroupIdentifier
  :cognitect.aws.medialive/__stringPatternS)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequest/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/IndexNSegments
  :cognitect.aws.medialive/__integerMin3)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ManifestDurationFormat
  :cognitect.aws.medialive/HlsManifestDurationFormat)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/CodecSpecification
  :cognitect.aws.medialive/HlsCodecSpecification)

(s/def :cognitect.aws.medialive.HlsGroupSettings/BaseUrlContent :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTime
  :cognitect.aws.medialive/HlsProgramDateTime)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/AdMarkers
  :cognitect.aws.medialive/__listOfHlsAdMarkers)

(s/def :cognitect.aws.medialive.HlsGroupSettings/BaseUrlManifest1 :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/StreamInfResolution
  :cognitect.aws.medialive/HlsStreamInfResolution)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def :cognitect.aws.medialive.HlsGroupSettings/Mode :cognitect.aws.medialive/HlsMode)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/IvInManifest
  :cognitect.aws.medialive/HlsIvInManifest)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ConstantIv
  :cognitect.aws.medialive/__stringMin32Max32)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/IncompleteSegmentBehavior
  :cognitect.aws.medialive/HlsIncompleteSegmentBehavior)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/SegmentLength
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/TimedMetadataId3Period
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/HlsId3SegmentTagging
  :cognitect.aws.medialive/HlsId3SegmentTaggingState)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/EncryptionType
  :cognitect.aws.medialive/HlsEncryptionType)

(s/def :cognitect.aws.medialive.HlsGroupSettings/BaseUrlManifest :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.HlsGroupSettings/IvSource :cognitect.aws.medialive/HlsIvSource)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/RedundantManifest
  :cognitect.aws.medialive/HlsRedundantManifest)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/HlsCdnSettings
  :cognitect.aws.medialive/HlsCdnSettings)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/TimedMetadataId3Frame
  :cognitect.aws.medialive/HlsTimedMetadataId3Frame)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTimePeriod
  :cognitect.aws.medialive/__integerMin0Max3600)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/KeyProviderSettings
  :cognitect.aws.medialive/KeyProviderSettings)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/KeepSegments
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/DiscontinuityTags
  :cognitect.aws.medialive/HlsDiscontinuityTags)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/CaptionLanguageSetting
  :cognitect.aws.medialive/HlsCaptionLanguageSetting)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ClientCache
  :cognitect.aws.medialive/HlsClientCache)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/IFrameOnlyPlaylists
  :cognitect.aws.medialive/IFrameOnlyPlaylistType)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/MinSegmentLength
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/SegmentationMode
  :cognitect.aws.medialive/HlsSegmentationMode)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/KeyFormatVersions
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ProgramDateTimeClock
  :cognitect.aws.medialive/HlsProgramDateTimeClock)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/CaptionLanguageMappings
  :cognitect.aws.medialive/__listOfCaptionLanguageMapping)

(s/def :cognitect.aws.medialive.HlsGroupSettings/BaseUrlContent1 :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/SegmentsPerSubdirectory
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/ManifestCompression
  :cognitect.aws.medialive/HlsManifestCompression)

(s/def :cognitect.aws.medialive.HlsGroupSettings/TsFileMode :cognitect.aws.medialive/HlsTsFileMode)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/TimestampDeltaMilliseconds
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.HlsGroupSettings/KeyFormat :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/DirectoryStructure
  :cognitect.aws.medialive/HlsDirectoryStructure)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/OutputSelection
  :cognitect.aws.medialive/HlsOutputSelection)

(s/def
  :cognitect.aws.medialive.HlsGroupSettings/InputLossAction
  :cognitect.aws.medialive/InputLossActionForHlsOut)

(s/def
  :cognitect.aws.medialive.ListInputDeviceTransfersResultModel/InputDeviceTransfers
  :cognitect.aws.medialive/__listOfTransferringInputDeviceSummary)

(s/def
  :cognitect.aws.medialive.ListInputDeviceTransfersResultModel/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceThumbnailRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceThumbnailRequest/Accept
  :cognitect.aws.medialive/AcceptHeader)

(s/def
  :cognitect.aws.medialive.InputDeviceSummary/AvailabilityZone
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceSummary/UhdDeviceSettings
  :cognitect.aws.medialive/InputDeviceUhdSettings)

(s/def :cognitect.aws.medialive.InputDeviceSummary/SerialNumber :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDeviceSummary/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceSummary/MedialiveInputArns
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.InputDeviceSummary/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.InputDeviceSummary/OutputType
  :cognitect.aws.medialive/InputDeviceOutputType)

(s/def
  :cognitect.aws.medialive.InputDeviceSummary/ConnectionState
  :cognitect.aws.medialive/InputDeviceConnectionState)

(s/def :cognitect.aws.medialive.InputDeviceSummary/MacAddress :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDeviceSummary/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceSummary/DeviceSettingsSyncState
  :cognitect.aws.medialive/DeviceSettingsSyncState)

(s/def :cognitect.aws.medialive.InputDeviceSummary/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDeviceSummary/Type :cognitect.aws.medialive/InputDeviceType)

(s/def
  :cognitect.aws.medialive.InputDeviceSummary/NetworkSettings
  :cognitect.aws.medialive/InputDeviceNetworkSettings)

(s/def
  :cognitect.aws.medialive.InputDeviceSummary/DeviceUpdateStatus
  :cognitect.aws.medialive/DeviceUpdateStatus)

(s/def
  :cognitect.aws.medialive.InputDeviceSummary/HdDeviceSettings
  :cognitect.aws.medialive/InputDeviceHdSettings)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentRequestContent/DryRun
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponseContent/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponseContent/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def :cognitect.aws.medialive.PurchaseOffering/Count :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.PurchaseOffering/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.PurchaseOffering/RenewalSettings
  :cognitect.aws.medialive/RenewalSettings)

(s/def :cognitect.aws.medialive.PurchaseOffering/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.PurchaseOffering/Start :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.PurchaseOffering/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/BlackFrameMsec
  :cognitect.aws.medialive/__integerMin0Max1000000)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/InputLossImageColor
  :cognitect.aws.medialive/__stringMin6Max6)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/InputLossImageSlate
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/InputLossImageType
  :cognitect.aws.medialive/InputLossImageType)

(s/def
  :cognitect.aws.medialive.InputLossBehavior/RepeatFrameMsec
  :cognitect.aws.medialive/__integerMin0Max1000000)

(s/def
  :cognitect.aws.medialive.Scte35DeliveryRestrictions/ArchiveAllowedFlag
  :cognitect.aws.medialive/Scte35ArchiveAllowedFlag)

(s/def
  :cognitect.aws.medialive.Scte35DeliveryRestrictions/DeviceRestrictions
  :cognitect.aws.medialive/Scte35DeviceRestrictions)

(s/def
  :cognitect.aws.medialive.Scte35DeliveryRestrictions/NoRegionalBlackoutFlag
  :cognitect.aws.medialive/Scte35NoRegionalBlackoutFlag)

(s/def
  :cognitect.aws.medialive.Scte35DeliveryRestrictions/WebDeliveryAllowedFlag
  :cognitect.aws.medialive/Scte35WebDeliveryAllowedFlag)

(s/def
  :cognitect.aws.medialive.PurchaseOfferingRequest/Count
  :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.PurchaseOfferingRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.PurchaseOfferingRequest/OfferingId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.PurchaseOfferingRequest/RenewalSettings
  :cognitect.aws.medialive/RenewalSettings)

(s/def :cognitect.aws.medialive.PurchaseOfferingRequest/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.PurchaseOfferingRequest/Start :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.PurchaseOfferingRequest/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/GroupIdentifier
  :cognitect.aws.medialive/__stringPatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequestContent/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def :cognitect.aws.medialive.UpdateChannelResultModel/Channel :cognitect.aws.medialive/Channel)

(s/def :cognitect.aws.medialive.ListSdiSourcesResponse/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListSdiSourcesResponse/SdiSources
  :cognitect.aws.medialive/__listOfSdiSourceSummary)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplateGroup)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowYOffset
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/BackgroundOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/Font
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/OutlineColor
  :cognitect.aws.medialive/DvbSubDestinationOutlineColor)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowXOffset
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/FontSize
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/FontOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/Alignment
  :cognitect.aws.medialive/DvbSubDestinationAlignment)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/FontColor
  :cognitect.aws.medialive/DvbSubDestinationFontColor)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/YPosition
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowColor
  :cognitect.aws.medialive/DvbSubDestinationShadowColor)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/FontResolution
  :cognitect.aws.medialive/__integerMin96Max600)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/BackgroundColor
  :cognitect.aws.medialive/DvbSubDestinationBackgroundColor)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/TeletextGridControl
  :cognitect.aws.medialive/DvbSubDestinationTeletextGridControl)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/ShadowOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/XPosition
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.DvbSubDestinationSettings/OutlineSize
  :cognitect.aws.medialive/__integerMin0Max10)

(s/def
  :cognitect.aws.medialive.FeatureActivations/InputPrepareScheduleActions
  :cognitect.aws.medialive/FeatureActivationsInputPrepareScheduleActions)

(s/def
  :cognitect.aws.medialive.FeatureActivations/OutputStaticImageOverlayScheduleActions
  :cognitect.aws.medialive/FeatureActivationsOutputStaticImageOverlayScheduleActions)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplate)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponseContent/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def
  :cognitect.aws.medialive.CmafIngestOutputSettings/NameModifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteNodeResponse/NodeInterfaceMappings
  :cognitect.aws.medialive/__listOfNodeInterfaceMapping)

(s/def :cognitect.aws.medialive.DeleteNodeResponse/InstanceArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteNodeResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteNodeResponse/ChannelPlacementGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DeleteNodeResponse/SdiSourceMappings
  :cognitect.aws.medialive/SdiSourceMappings)

(s/def
  :cognitect.aws.medialive.DeleteNodeResponse/ConnectionState
  :cognitect.aws.medialive/NodeConnectionState)

(s/def :cognitect.aws.medialive.DeleteNodeResponse/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteNodeResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteNodeResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteNodeResponse/State :cognitect.aws.medialive/NodeState)

(s/def :cognitect.aws.medialive.DeleteNodeResponse/Role :cognitect.aws.medialive/NodeRole)

(s/def
  :cognitect.aws.medialive.UpdateChannelClassRequest/ChannelClass
  :cognitect.aws.medialive/ChannelClass)

(s/def
  :cognitect.aws.medialive.UpdateChannelClassRequest/ChannelId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelClassRequest/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexRequest/MultiplexId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexRequest/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettings)

(s/def :cognitect.aws.medialive.UpdateMultiplexRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexRequest/PacketIdentifiersMapping
  :cognitect.aws.medialive/MultiplexPacketIdentifiersMapping)

(s/def :cognitect.aws.medialive.UpdateChannelClassResponse/Channel :cognitect.aws.medialive/Channel)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/CurrencyCode
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/FixedPrice
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def :cognitect.aws.medialive.DescribeOfferingResponse/Region :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/OfferingDescription
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeOfferingResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/Duration
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/UsagePrice
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/OfferingId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeOfferingResponse/OfferingType
  :cognitect.aws.medialive/OfferingType)

(s/def
  :cognitect.aws.medialive.CreateInput/Sources
  :cognitect.aws.medialive/__listOfInputSourceRequest)

(s/def :cognitect.aws.medialive.CreateInput/SdiSources :cognitect.aws.medialive/InputSdiSources)

(s/def :cognitect.aws.medialive.CreateInput/SrtSettings :cognitect.aws.medialive/SrtSettingsRequest)

(s/def
  :cognitect.aws.medialive.CreateInput/MediaConnectFlows
  :cognitect.aws.medialive/__listOfMediaConnectFlowRequest)

(s/def
  :cognitect.aws.medialive.CreateInput/InputNetworkLocation
  :cognitect.aws.medialive/InputNetworkLocation)

(s/def
  :cognitect.aws.medialive.CreateInput/Smpte2110ReceiverGroupSettings
  :cognitect.aws.medialive/Smpte2110ReceiverGroupSettings)

(s/def
  :cognitect.aws.medialive.CreateInput/InputSecurityGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.CreateInput/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.CreateInput/Destinations
  :cognitect.aws.medialive/__listOfInputDestinationRequest)

(s/def :cognitect.aws.medialive.CreateInput/Vpc :cognitect.aws.medialive/InputVpcRequest)

(s/def :cognitect.aws.medialive.CreateInput/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateInput/RequestId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateInput/MulticastSettings
  :cognitect.aws.medialive/MulticastSettingsCreateRequest)

(s/def :cognitect.aws.medialive.CreateInput/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateInput/Type :cognitect.aws.medialive/InputType)

(s/def
  :cognitect.aws.medialive.CreateInput/InputDevices
  :cognitect.aws.medialive/__listOfInputDeviceSettings)

(s/def :cognitect.aws.medialive.DeleteClusterRequest/ClusterId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/ShadowYOffset
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/BackgroundOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/Font
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/OutlineColor
  :cognitect.aws.medialive/BurnInOutlineColor)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/ShadowXOffset
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/FontSize
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/FontOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/Alignment
  :cognitect.aws.medialive/BurnInAlignment)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/FontColor
  :cognitect.aws.medialive/BurnInFontColor)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/YPosition
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/ShadowColor
  :cognitect.aws.medialive/BurnInShadowColor)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/FontResolution
  :cognitect.aws.medialive/__integerMin96Max600)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/BackgroundColor
  :cognitect.aws.medialive/BurnInBackgroundColor)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/TeletextGridControl
  :cognitect.aws.medialive/BurnInTeletextGridControl)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/ShadowOpacity
  :cognitect.aws.medialive/__integerMin0Max255)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/XPosition
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.BurnInDestinationSettings/OutlineSize
  :cognitect.aws.medialive/__integerMin0Max10)

(s/def
  :cognitect.aws.medialive.MsSmoothOutputSettings/H265PackagingType
  :cognitect.aws.medialive/MsSmoothH265PackagingType)

(s/def
  :cognitect.aws.medialive.MsSmoothOutputSettings/NameModifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.H264FilterSettings/TemporalFilterSettings
  :cognitect.aws.medialive/TemporalFilterSettings)

(s/def
  :cognitect.aws.medialive.H264FilterSettings/BandwidthReductionFilterSettings
  :cognitect.aws.medialive/BandwidthReductionFilterSettings)

(s/def :cognitect.aws.medialive.RouteUpdateRequest/Cidr :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.RouteUpdateRequest/Gateway :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.EbuTtDDestinationSettings/CopyrightHolder
  :cognitect.aws.medialive/__stringMax1000)

(s/def
  :cognitect.aws.medialive.EbuTtDDestinationSettings/FillLineGap
  :cognitect.aws.medialive/EbuTtDFillLineGapControl)

(s/def
  :cognitect.aws.medialive.EbuTtDDestinationSettings/FontFamily
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.EbuTtDDestinationSettings/StyleControl
  :cognitect.aws.medialive/EbuTtDDestinationStyleControl)

(s/def
  :cognitect.aws.medialive.EbuTtDDestinationSettings/DefaultFontSize
  :cognitect.aws.medialive/__integerMin1Max800)

(s/def
  :cognitect.aws.medialive.EbuTtDDestinationSettings/DefaultLineHeight
  :cognitect.aws.medialive/__integerMin80Max800)

(s/def :cognitect.aws.medialive.UpdateInputResponse/Input :cognitect.aws.medialive/Input)

(s/def
  :cognitect.aws.medialive.VideoSelector/ColorSpace
  :cognitect.aws.medialive/VideoSelectorColorSpace)

(s/def
  :cognitect.aws.medialive.VideoSelector/ColorSpaceSettings
  :cognitect.aws.medialive/VideoSelectorColorSpaceSettings)

(s/def
  :cognitect.aws.medialive.VideoSelector/ColorSpaceUsage
  :cognitect.aws.medialive/VideoSelectorColorSpaceUsage)

(s/def
  :cognitect.aws.medialive.VideoSelector/SelectorSettings
  :cognitect.aws.medialive/VideoSelectorSettings)

(s/def
  :cognitect.aws.medialive.DeleteEventBridgeRuleTemplateGroupRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ValidationError/ElementPath :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ValidationError/ErrorMessage :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioWatermarkSettings/NielsenWatermarksSettings
  :cognitect.aws.medialive/NielsenWatermarksSettings)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplate)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateSummary/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def
  :cognitect.aws.medialive.EncoderSettings/AvailBlanking
  :cognitect.aws.medialive/AvailBlanking)

(s/def
  :cognitect.aws.medialive.EncoderSettings/VideoDescriptions
  :cognitect.aws.medialive/__listOfVideoDescription)

(s/def
  :cognitect.aws.medialive.EncoderSettings/BlackoutSlate
  :cognitect.aws.medialive/BlackoutSlate)

(s/def
  :cognitect.aws.medialive.EncoderSettings/FeatureActivations
  :cognitect.aws.medialive/FeatureActivations)

(s/def
  :cognitect.aws.medialive.EncoderSettings/NielsenConfiguration
  :cognitect.aws.medialive/NielsenConfiguration)

(s/def
  :cognitect.aws.medialive.EncoderSettings/CaptionDescriptions
  :cognitect.aws.medialive/__listOfCaptionDescription)

(s/def
  :cognitect.aws.medialive.EncoderSettings/ColorCorrectionSettings
  :cognitect.aws.medialive/ColorCorrectionSettings)

(s/def
  :cognitect.aws.medialive.EncoderSettings/OutputGroups
  :cognitect.aws.medialive/__listOfOutputGroup)

(s/def
  :cognitect.aws.medialive.EncoderSettings/MotionGraphicsConfiguration
  :cognitect.aws.medialive/MotionGraphicsConfiguration)

(s/def
  :cognitect.aws.medialive.EncoderSettings/AudioDescriptions
  :cognitect.aws.medialive/__listOfAudioDescription)

(s/def
  :cognitect.aws.medialive.EncoderSettings/ThumbnailConfiguration
  :cognitect.aws.medialive/ThumbnailConfiguration)

(s/def
  :cognitect.aws.medialive.EncoderSettings/AvailConfiguration
  :cognitect.aws.medialive/AvailConfiguration)

(s/def
  :cognitect.aws.medialive.EncoderSettings/TimecodeConfig
  :cognitect.aws.medialive/TimecodeConfig)

(s/def
  :cognitect.aws.medialive.EncoderSettings/GlobalConfiguration
  :cognitect.aws.medialive/GlobalConfiguration)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesRequest/ChannelId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.RestartChannelPipelinesRequest/PipelineIds
  :cognitect.aws.medialive/__listOfChannelPipelineIdToRestart)

(s/def
  :cognitect.aws.medialive.UpdateChannelClass/ChannelClass
  :cognitect.aws.medialive/ChannelClass)

(s/def
  :cognitect.aws.medialive.UpdateChannelClass/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.MaintenanceUpdateSettings/MaintenanceDay
  :cognitect.aws.medialive/MaintenanceDay)

(s/def
  :cognitect.aws.medialive.MaintenanceUpdateSettings/MaintenanceScheduledDate
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MaintenanceUpdateSettings/MaintenanceStartTime
  :cognitect.aws.medialive/__stringPattern010920300)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexProgramRequest/MultiplexId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexProgramRequest/ProgramName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListClustersResult/Clusters
  :cognitect.aws.medialive/__listOfDescribeClusterSummary)

(s/def :cognitect.aws.medialive.ListClustersResult/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequest/CloudWatchAlarmTemplateGroupIdentifiers
  :cognitect.aws.medialive/__listOf__stringPatternS)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequest/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequest/EventBridgeRuleTemplateGroupIdentifiers
  :cognitect.aws.medialive/__listOf__stringPatternS)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequest/ForceRediscovery
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequest/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.Smpte2110ReceiverGroupSettings/Smpte2110ReceiverGroups
  :cognitect.aws.medialive/__listOfSmpte2110ReceiverGroup)

(s/def
  :cognitect.aws.medialive.PurchaseOfferingResponse/Reservation
  :cognitect.aws.medialive/Reservation)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdSettings/InputResolution
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdSettings/ConfiguredInput
  :cognitect.aws.medialive/InputDeviceConfiguredInput)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdSettings/AudioChannelPairs
  :cognitect.aws.medialive/__listOfInputDeviceUhdAudioChannelPairConfig)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdSettings/Codec
  :cognitect.aws.medialive/InputDeviceCodec)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdSettings/DeviceState
  :cognitect.aws.medialive/InputDeviceState)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdSettings/ScanType
  :cognitect.aws.medialive/InputDeviceScanType)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdSettings/ActiveInput
  :cognitect.aws.medialive/InputDeviceActiveInput)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdSettings/MaxBitrate
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.InputDeviceUhdSettings/LatencyMs :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.InputDeviceUhdSettings/Width :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.InputDeviceUhdSettings/Framerate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.InputDeviceUhdSettings/Height :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdSettings/MediaconnectSettings
  :cognitect.aws.medialive/InputDeviceMediaConnectSettings)

(s/def :cognitect.aws.medialive.ListNodesRequest/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListNodesRequest/MaxResults :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListNodesRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequest/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequest/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupRequest/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def
  :cognitect.aws.medialive.InputLossFailoverSettings/InputLossThresholdMsec
  :cognitect.aws.medialive/__integerMin100)

(s/def :cognitect.aws.medialive.InputSource/PasswordParam :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSource/Url :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSource/Username :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplate)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplateGroup)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateGroupResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexProgramResponse/MultiplexProgram
  :cognitect.aws.medialive/MultiplexProgram)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/GroupIdentifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/Scope
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesRequest/SignalMapIdentifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/GroupIdentifier
  :cognitect.aws.medialive/__stringPatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateRequest/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def
  :cognitect.aws.medialive.ListMultiplexProgramsResultModel/MultiplexPrograms
  :cognitect.aws.medialive/__listOfMultiplexProgramSummary)

(s/def
  :cognitect.aws.medialive.ListMultiplexProgramsResultModel/NextToken
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StartMultiplexRequest/MultiplexId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioTrackSelection/Tracks
  :cognitect.aws.medialive/__listOfAudioTrack)

(s/def
  :cognitect.aws.medialive.AudioTrackSelection/DolbyEDecode
  :cognitect.aws.medialive/AudioDolbyEDecode)

(s/def
  :cognitect.aws.medialive.H265FilterSettings/TemporalFilterSettings
  :cognitect.aws.medialive/TemporalFilterSettings)

(s/def
  :cognitect.aws.medialive.H265FilterSettings/BandwidthReductionFilterSettings
  :cognitect.aws.medialive/BandwidthReductionFilterSettings)

(s/def :cognitect.aws.medialive.InputRequestDestinationRoute/Cidr :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputRequestDestinationRoute/Gateway
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListChannelPlacementGroupsRequest/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListChannelPlacementGroupsRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListChannelPlacementGroupsRequest/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ChannelEngineVersionResponse/ExpirationDate
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.ChannelEngineVersionResponse/Version
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateClusterResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateClusterResponse/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.CreateClusterResponse/ClusterType
  :cognitect.aws.medialive/ClusterType)

(s/def :cognitect.aws.medialive.CreateClusterResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateClusterResponse/InstanceRoleArn
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateClusterResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateClusterResponse/NetworkSettings
  :cognitect.aws.medialive/ClusterNetworkSettings)

(s/def :cognitect.aws.medialive.CreateClusterResponse/State :cognitect.aws.medialive/ClusterState)

(s/def
  :cognitect.aws.medialive.ListSignalMapsRequest/CloudWatchAlarmTemplateGroupIdentifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListSignalMapsRequest/EventBridgeRuleTemplateGroupIdentifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListSignalMapsRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListSignalMapsRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BatchStartRequest/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.BatchStartRequest/MultiplexIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.Scte35Descriptor/Scte35DescriptorSettings
  :cognitect.aws.medialive/Scte35DescriptorSettings)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentRequest/DryRun
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListVersionsResponse/Versions
  :cognitect.aws.medialive/__listOfChannelEngineVersionResponse)

(s/def
  :cognitect.aws.medialive.ArchiveGroupSettings/ArchiveCdnSettings
  :cognitect.aws.medialive/ArchiveCdnSettings)

(s/def
  :cognitect.aws.medialive.ArchiveGroupSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.ArchiveGroupSettings/RolloverInterval
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.AudioHlsRenditionSelection/GroupId
  :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.AudioHlsRenditionSelection/Name
  :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.InputClippingSettings/InputTimecodeSource
  :cognitect.aws.medialive/InputTimecodeSource)

(s/def
  :cognitect.aws.medialive.InputClippingSettings/StartTimecode
  :cognitect.aws.medialive/StartTimecode)

(s/def
  :cognitect.aws.medialive.InputClippingSettings/StopTimecode
  :cognitect.aws.medialive/StopTimecode)

(s/def :cognitect.aws.medialive.CreatePartnerInputResponse/Input :cognitect.aws.medialive/Input)

(s/def
  :cognitect.aws.medialive.CreateClusterRequest/ClusterType
  :cognitect.aws.medialive/ClusterType)

(s/def
  :cognitect.aws.medialive.CreateClusterRequest/InstanceRoleArn
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateClusterRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateClusterRequest/NetworkSettings
  :cognitect.aws.medialive/ClusterNetworkSettingsCreateRequest)

(s/def :cognitect.aws.medialive.CreateClusterRequest/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateClusterRequest/Tags :cognitect.aws.medialive/Tags)

(s/def :cognitect.aws.medialive.Input/Sources :cognitect.aws.medialive/__listOfInputSource)

(s/def :cognitect.aws.medialive.Input/SdiSources :cognitect.aws.medialive/InputSdiSources)

(s/def :cognitect.aws.medialive.Input/SrtSettings :cognitect.aws.medialive/SrtSettings)

(s/def
  :cognitect.aws.medialive.Input/MediaConnectFlows
  :cognitect.aws.medialive/__listOfMediaConnectFlow)

(s/def :cognitect.aws.medialive.Input/InputSourceType :cognitect.aws.medialive/InputSourceType)

(s/def
  :cognitect.aws.medialive.Input/InputNetworkLocation
  :cognitect.aws.medialive/InputNetworkLocation)

(s/def :cognitect.aws.medialive.Input/InputPartnerIds :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.Input/Smpte2110ReceiverGroupSettings
  :cognitect.aws.medialive/Smpte2110ReceiverGroupSettings)

(s/def :cognitect.aws.medialive.Input/AttachedChannels :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.Input/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Input/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.Input/Destinations
  :cognitect.aws.medialive/__listOfInputDestination)

(s/def :cognitect.aws.medialive.Input/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Input/SecurityGroups :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.Input/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Input/MulticastSettings :cognitect.aws.medialive/MulticastSettings)

(s/def :cognitect.aws.medialive.Input/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Input/Type :cognitect.aws.medialive/InputType)

(s/def :cognitect.aws.medialive.Input/State :cognitect.aws.medialive/InputState)

(s/def
  :cognitect.aws.medialive.Input/InputDevices
  :cognitect.aws.medialive/__listOfInputDeviceSettings)

(s/def :cognitect.aws.medialive.Input/InputClass :cognitect.aws.medialive/InputClass)

(s/def :cognitect.aws.medialive.Esam/AcquisitionPointId :cognitect.aws.medialive/__stringMax256)

(s/def
  :cognitect.aws.medialive.Esam/AdAvailOffset
  :cognitect.aws.medialive/__integerMinNegative1000Max1000)

(s/def :cognitect.aws.medialive.Esam/PasswordParam :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Esam/PoisEndpoint :cognitect.aws.medialive/__stringMax2048)

(s/def :cognitect.aws.medialive.Esam/Username :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Esam/ZoneIdentity :cognitect.aws.medialive/__stringMax256)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexProgramResponse/ChannelId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexProgramResponse/MultiplexProgramSettings
  :cognitect.aws.medialive/MultiplexProgramSettings)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexProgramResponse/PacketIdentifiersMap
  :cognitect.aws.medialive/MultiplexProgramPacketIdentifiersMap)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexProgramResponse/PipelineDetails
  :cognitect.aws.medialive/__listOfMultiplexProgramPipelineDetail)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexProgramResponse/ProgramName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InternalServerErrorExceptionResponseContent/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputSecurityGroupResultModel/SecurityGroup
  :cognitect.aws.medialive/InputSecurityGroup)

(s/def :cognitect.aws.medialive.DescribeNetworkSummary/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNetworkSummary/AssociatedClusterIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.DescribeNetworkSummary/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNetworkSummary/IpPools
  :cognitect.aws.medialive/__listOfIpPool)

(s/def :cognitect.aws.medialive.DescribeNetworkSummary/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNetworkSummary/Routes
  :cognitect.aws.medialive/__listOfRoute)

(s/def :cognitect.aws.medialive.DescribeNetworkSummary/State :cognitect.aws.medialive/NetworkState)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/CurrencyCode
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/FixedPrice
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/ReservationId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Region :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/OfferingDescription
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/RenewalSettings
  :cognitect.aws.medialive/RenewalSettings)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/Duration
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/UsagePrice
  :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/End :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/State
  :cognitect.aws.medialive/ReservationState)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Count :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/OfferingId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteReservationResponse/Start :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationResponse/OfferingType
  :cognitect.aws.medialive/OfferingType)

(s/def
  :cognitect.aws.medialive.NielsenConfiguration/DistributorId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.NielsenConfiguration/NielsenPcmToId3Tagging
  :cognitect.aws.medialive/NielsenPcmToId3TaggingState)

(s/def :cognitect.aws.medialive.Route/Cidr :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Route/Gateway :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplateGroup)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def :cognitect.aws.medialive.LimitExceeded/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BatchStopResponse/Failed
  :cognitect.aws.medialive/__listOfBatchFailedResultModel)

(s/def
  :cognitect.aws.medialive.BatchStopResponse/Successful
  :cognitect.aws.medialive/__listOfBatchSuccessfulResultModel)

(s/def
  :cognitect.aws.medialive.TimedMetadataScheduleActionSettings/Id3
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateClusterResult/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateClusterResult/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.UpdateClusterResult/ClusterType
  :cognitect.aws.medialive/ClusterType)

(s/def :cognitect.aws.medialive.UpdateClusterResult/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateClusterResult/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateClusterResult/NetworkSettings
  :cognitect.aws.medialive/ClusterNetworkSettings)

(s/def :cognitect.aws.medialive.UpdateClusterResult/State :cognitect.aws.medialive/ClusterState)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplateGroup)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.DescribeNodeSummary/NodeInterfaceMappings
  :cognitect.aws.medialive/__listOfNodeInterfaceMapping)

(s/def :cognitect.aws.medialive.DescribeNodeSummary/InstanceArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeSummary/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNodeSummary/ManagedInstanceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNodeSummary/ChannelPlacementGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeNodeSummary/SdiSourceMappings
  :cognitect.aws.medialive/SdiSourceMappings)

(s/def
  :cognitect.aws.medialive.DescribeNodeSummary/ConnectionState
  :cognitect.aws.medialive/NodeConnectionState)

(s/def :cognitect.aws.medialive.DescribeNodeSummary/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeSummary/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeSummary/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeSummary/State :cognitect.aws.medialive/NodeState)

(s/def :cognitect.aws.medialive.DescribeNodeSummary/Role :cognitect.aws.medialive/NodeRole)

(s/def :cognitect.aws.medialive.AacSettings/Spec :cognitect.aws.medialive/AacSpec)

(s/def :cognitect.aws.medialive.AacSettings/CodingMode :cognitect.aws.medialive/AacCodingMode)

(s/def :cognitect.aws.medialive.AacSettings/Profile :cognitect.aws.medialive/AacProfile)

(s/def :cognitect.aws.medialive.AacSettings/RawFormat :cognitect.aws.medialive/AacRawFormat)

(s/def :cognitect.aws.medialive.AacSettings/InputType :cognitect.aws.medialive/AacInputType)

(s/def
  :cognitect.aws.medialive.AacSettings/RateControlMode
  :cognitect.aws.medialive/AacRateControlMode)

(s/def :cognitect.aws.medialive.AacSettings/Bitrate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.AacSettings/VbrQuality :cognitect.aws.medialive/AacVbrQuality)

(s/def :cognitect.aws.medialive.AacSettings/SampleRate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.DescribeClusterResult/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterResult/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterResult/ClusterType
  :cognitect.aws.medialive/ClusterType)

(s/def :cognitect.aws.medialive.DescribeClusterResult/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterResult/InstanceRoleArn
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeClusterResult/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterResult/NetworkSettings
  :cognitect.aws.medialive/ClusterNetworkSettings)

(s/def :cognitect.aws.medialive.DescribeClusterResult/State :cognitect.aws.medialive/ClusterState)

(s/def
  :cognitect.aws.medialive.InputDeviceMediaConnectSettings/FlowArn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceMediaConnectSettings/RoleArn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceMediaConnectSettings/SecretArn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceMediaConnectSettings/SourceName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def :cognitect.aws.medialive.StartMonitorDeploymentResponse/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponse/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def
  :cognitect.aws.medialive.AcceptInputDeviceTransferRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StartChannelResponse/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.StartChannelResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StartChannelResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/ChannelClass
  :cognitect.aws.medialive/ChannelClass)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/Vpc
  :cognitect.aws.medialive/VpcOutputSettingsDescription)

(s/def :cognitect.aws.medialive.StartChannelResponse/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/PipelineDetails
  :cognitect.aws.medialive/__listOfPipelineDetail)

(s/def :cognitect.aws.medialive.StartChannelResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StartChannelResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.StartChannelResponse/State :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/AnywhereSettings
  :cognitect.aws.medialive/DescribeAnywhereSettings)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/Maintenance
  :cognitect.aws.medialive/MaintenanceStatus)

(s/def
  :cognitect.aws.medialive.StartChannelResponse/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionResponse)

(s/def
  :cognitect.aws.medialive.MonitorDeployment/DetailsUri
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.MonitorDeployment/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.MonitorDeployment/Status
  :cognitect.aws.medialive/SignalMapMonitorDeploymentStatus)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexProgramRequest/MultiplexId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexProgramRequest/ProgramName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteCloudWatchAlarmTemplateRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.AudioTrack/Track :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.ColorCorrectionSettings/GlobalColorCorrections
  :cognitect.aws.medialive/__listOfColorCorrection)

(s/def
  :cognitect.aws.medialive.FrameCaptureCdnSettings/FrameCaptureS3Settings
  :cognitect.aws.medialive/FrameCaptureS3Settings)

(s/def :cognitect.aws.medialive.BatchStop/ChannelIds :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.BatchStop/MultiplexIds :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.UdpContainerSettings/M2tsSettings
  :cognitect.aws.medialive/M2tsSettings)

(s/def :cognitect.aws.medialive.InputSpecification/Codec :cognitect.aws.medialive/InputCodec)

(s/def
  :cognitect.aws.medialive.InputSpecification/MaximumBitrate
  :cognitect.aws.medialive/InputMaximumBitrate)

(s/def
  :cognitect.aws.medialive.InputSpecification/Resolution
  :cognitect.aws.medialive/InputResolution)

(s/def :cognitect.aws.medialive.UpdateChannel/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.UpdateChannel/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def
  :cognitect.aws.medialive.UpdateChannel/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def :cognitect.aws.medialive.UpdateChannel/DryRun :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.UpdateChannel/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.UpdateChannel/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.UpdateChannel/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateChannel/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannel/AnywhereSettings
  :cognitect.aws.medialive/AnywhereSettings)

(s/def
  :cognitect.aws.medialive.UpdateChannel/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.UpdateChannel/Maintenance
  :cognitect.aws.medialive/MaintenanceUpdateSettings)

(s/def
  :cognitect.aws.medialive.UpdateChannel/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionRequest)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplate)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponse/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def
  :cognitect.aws.medialive.UpdateReservationResultModel/Reservation
  :cognitect.aws.medialive/Reservation)

(s/def
  :cognitect.aws.medialive.UnprocessableEntityException/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UnprocessableEntityException/ValidationErrors
  :cognitect.aws.medialive/__listOfValidationError)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplateGroup)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.Smpte2110ReceiverGroup/SdpSettings
  :cognitect.aws.medialive/Smpte2110ReceiverGroupSdpSettings)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/GroupIdentifier
  :cognitect.aws.medialive/__stringPatternS)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateRequestContent/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def :cognitect.aws.medialive.InputDevice/AvailabilityZone :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDevice/UhdDeviceSettings
  :cognitect.aws.medialive/InputDeviceUhdSettings)

(s/def :cognitect.aws.medialive.InputDevice/SerialNumber :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDevice/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDevice/MedialiveInputArns
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.InputDevice/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.InputDevice/OutputType
  :cognitect.aws.medialive/InputDeviceOutputType)

(s/def
  :cognitect.aws.medialive.InputDevice/ConnectionState
  :cognitect.aws.medialive/InputDeviceConnectionState)

(s/def :cognitect.aws.medialive.InputDevice/MacAddress :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDevice/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDevice/DeviceSettingsSyncState
  :cognitect.aws.medialive/DeviceSettingsSyncState)

(s/def :cognitect.aws.medialive.InputDevice/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDevice/Type :cognitect.aws.medialive/InputDeviceType)

(s/def
  :cognitect.aws.medialive.InputDevice/NetworkSettings
  :cognitect.aws.medialive/InputDeviceNetworkSettings)

(s/def
  :cognitect.aws.medialive.InputDevice/DeviceUpdateStatus
  :cognitect.aws.medialive/DeviceUpdateStatus)

(s/def
  :cognitect.aws.medialive.InputDevice/HdDeviceSettings
  :cognitect.aws.medialive/InputDeviceHdSettings)

(s/def
  :cognitect.aws.medialive.BatchScheduleActionDeleteRequest/ActionNames
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.UpdateClusterRequest/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateClusterRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateClusterRequest/NetworkSettings
  :cognitect.aws.medialive/ClusterNetworkSettingsUpdateRequest)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesResponseContent/CloudWatchAlarmTemplates
  :cognitect.aws.medialive/__listOfCloudWatchAlarmTemplateSummary)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesResponseContent/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexResponse/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettings)

(s/def :cognitect.aws.medialive.DeleteMultiplexResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteMultiplexResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexResponse/Destinations
  :cognitect.aws.medialive/__listOfMultiplexOutputDestination)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexResponse/AvailabilityZones
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.DeleteMultiplexResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteMultiplexResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexResponse/State
  :cognitect.aws.medialive/MultiplexState)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexResponse/ProgramCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.SrtCallerSource/Decryption
  :cognitect.aws.medialive/SrtCallerDecryption)

(s/def :cognitect.aws.medialive.SrtCallerSource/MinimumLatency :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.SrtCallerSource/SrtListenerAddress
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SrtCallerSource/SrtListenerPort :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SrtCallerSource/StreamId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InterfaceMapping/LogicalInterfaceName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InterfaceMapping/NetworkId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexVideoSettings/ConstantBitrate
  :cognitect.aws.medialive/__integerMin100000Max100000000)

(s/def
  :cognitect.aws.medialive.MultiplexVideoSettings/StatmuxSettings
  :cognitect.aws.medialive/MultiplexStatmuxVideoSettings)

(s/def
  :cognitect.aws.medialive.ListChannelsResultModel/Channels
  :cognitect.aws.medialive/__listOfChannelSummary)

(s/def :cognitect.aws.medialive.ListChannelsResultModel/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BatchStartResponse/Failed
  :cognitect.aws.medialive/__listOfBatchFailedResultModel)

(s/def
  :cognitect.aws.medialive.BatchStartResponse/Successful
  :cognitect.aws.medialive/__listOfBatchSuccessfulResultModel)

(s/def
  :cognitect.aws.medialive.InputSecurityGroupWhitelistRequest/Tags
  :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.InputSecurityGroupWhitelistRequest/WhitelistRules
  :cognitect.aws.medialive/__listOfInputWhitelistRuleCidr)

(s/def :cognitect.aws.medialive.NotFoundException/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateNodeResponse/NodeInterfaceMappings
  :cognitect.aws.medialive/__listOfNodeInterfaceMapping)

(s/def :cognitect.aws.medialive.UpdateNodeResponse/InstanceArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateNodeResponse/ChannelPlacementGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.UpdateNodeResponse/SdiSourceMappings
  :cognitect.aws.medialive/SdiSourceMappings)

(s/def
  :cognitect.aws.medialive.UpdateNodeResponse/ConnectionState
  :cognitect.aws.medialive/NodeConnectionState)

(s/def :cognitect.aws.medialive.UpdateNodeResponse/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeResponse/State :cognitect.aws.medialive/NodeState)

(s/def :cognitect.aws.medialive.UpdateNodeResponse/Role :cognitect.aws.medialive/NodeRole)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/Sources
  :cognitect.aws.medialive/__listOfInputSourceRequest)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/SdiSources
  :cognitect.aws.medialive/InputSdiSources)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/SrtSettings
  :cognitect.aws.medialive/SrtSettingsRequest)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/MediaConnectFlows
  :cognitect.aws.medialive/__listOfMediaConnectFlowRequest)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/InputNetworkLocation
  :cognitect.aws.medialive/InputNetworkLocation)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/Smpte2110ReceiverGroupSettings
  :cognitect.aws.medialive/Smpte2110ReceiverGroupSettings)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/InputSecurityGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.CreateInputRequest/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/Destinations
  :cognitect.aws.medialive/__listOfInputDestinationRequest)

(s/def :cognitect.aws.medialive.CreateInputRequest/Vpc :cognitect.aws.medialive/InputVpcRequest)

(s/def :cognitect.aws.medialive.CreateInputRequest/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateInputRequest/RequestId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/MulticastSettings
  :cognitect.aws.medialive/MulticastSettingsCreateRequest)

(s/def :cognitect.aws.medialive.CreateInputRequest/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateInputRequest/Type :cognitect.aws.medialive/InputType)

(s/def
  :cognitect.aws.medialive.CreateInputRequest/InputDevices
  :cognitect.aws.medialive/__listOfInputDeviceSettings)

(s/def :cognitect.aws.medialive.Channel/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def :cognitect.aws.medialive.Channel/EncoderSettings :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.Channel/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Channel/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.Channel/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.Channel/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.Channel/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.Channel/ChannelClass :cognitect.aws.medialive/ChannelClass)

(s/def :cognitect.aws.medialive.Channel/Vpc :cognitect.aws.medialive/VpcOutputSettingsDescription)

(s/def :cognitect.aws.medialive.Channel/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Channel/PipelinesRunningCount :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.Channel/PipelineDetails
  :cognitect.aws.medialive/__listOfPipelineDetail)

(s/def :cognitect.aws.medialive.Channel/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Channel/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Channel/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.Channel/State :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.Channel/AnywhereSettings
  :cognitect.aws.medialive/DescribeAnywhereSettings)

(s/def
  :cognitect.aws.medialive.Channel/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def :cognitect.aws.medialive.Channel/Maintenance :cognitect.aws.medialive/MaintenanceStatus)

(s/def
  :cognitect.aws.medialive.Channel/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionResponse)

(s/def :cognitect.aws.medialive.H264Settings/GopSize :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.H264Settings/EntropyEncoding
  :cognitect.aws.medialive/H264EntropyEncoding)

(s/def
  :cognitect.aws.medialive.H264Settings/NumRefFrames
  :cognitect.aws.medialive/__integerMin1Max6)

(s/def
  :cognitect.aws.medialive.H264Settings/GopNumBFrames
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def
  :cognitect.aws.medialive.H264Settings/TimecodeBurninSettings
  :cognitect.aws.medialive/TimecodeBurninSettings)

(s/def
  :cognitect.aws.medialive.H264Settings/AdaptiveQuantization
  :cognitect.aws.medialive/H264AdaptiveQuantization)

(s/def :cognitect.aws.medialive.H264Settings/ParNumerator :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.H264Settings/Softness :cognitect.aws.medialive/__integerMin0Max128)

(s/def :cognitect.aws.medialive.H264Settings/Profile :cognitect.aws.medialive/H264Profile)

(s/def :cognitect.aws.medialive.H264Settings/ParDenominator :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.H264Settings/QualityLevel :cognitect.aws.medialive/H264QualityLevel)

(s/def
  :cognitect.aws.medialive.H264Settings/SceneChangeDetect
  :cognitect.aws.medialive/H264SceneChangeDetect)

(s/def :cognitect.aws.medialive.H264Settings/MinQp :cognitect.aws.medialive/__integerMin1Max51)

(s/def :cognitect.aws.medialive.H264Settings/SpatialAq :cognitect.aws.medialive/H264SpatialAq)

(s/def :cognitect.aws.medialive.H264Settings/FlickerAq :cognitect.aws.medialive/H264FlickerAq)

(s/def :cognitect.aws.medialive.H264Settings/FixedAfd :cognitect.aws.medialive/FixedAfd)

(s/def
  :cognitect.aws.medialive.H264Settings/ForceFieldPictures
  :cognitect.aws.medialive/H264ForceFieldPictures)

(s/def
  :cognitect.aws.medialive.H264Settings/MinIInterval
  :cognitect.aws.medialive/__integerMin0Max30)

(s/def
  :cognitect.aws.medialive.H264Settings/QvbrQualityLevel
  :cognitect.aws.medialive/__integerMin1Max10)

(s/def :cognitect.aws.medialive.H264Settings/Syntax :cognitect.aws.medialive/H264Syntax)

(s/def
  :cognitect.aws.medialive.H264Settings/ColorMetadata
  :cognitect.aws.medialive/H264ColorMetadata)

(s/def :cognitect.aws.medialive.H264Settings/TemporalAq :cognitect.aws.medialive/H264TemporalAq)

(s/def
  :cognitect.aws.medialive.H264Settings/FramerateNumerator
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.H264Settings/RateControlMode
  :cognitect.aws.medialive/H264RateControlMode)

(s/def :cognitect.aws.medialive.H264Settings/SubgopLength :cognitect.aws.medialive/H264SubGopLength)

(s/def :cognitect.aws.medialive.H264Settings/ScanType :cognitect.aws.medialive/H264ScanType)

(s/def :cognitect.aws.medialive.H264Settings/Bitrate :cognitect.aws.medialive/__integerMin1000)

(s/def
  :cognitect.aws.medialive.H264Settings/ColorSpaceSettings
  :cognitect.aws.medialive/H264ColorSpaceSettings)

(s/def
  :cognitect.aws.medialive.H264Settings/TimecodeInsertion
  :cognitect.aws.medialive/H264TimecodeInsertionBehavior)

(s/def :cognitect.aws.medialive.H264Settings/ParControl :cognitect.aws.medialive/H264ParControl)

(s/def :cognitect.aws.medialive.H264Settings/Level :cognitect.aws.medialive/H264Level)

(s/def :cognitect.aws.medialive.H264Settings/GopSizeUnits :cognitect.aws.medialive/H264GopSizeUnits)

(s/def :cognitect.aws.medialive.H264Settings/MaxBitrate :cognitect.aws.medialive/__integerMin1000)

(s/def
  :cognitect.aws.medialive.H264Settings/FramerateDenominator
  :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.H264Settings/Slices :cognitect.aws.medialive/__integerMin1Max32)

(s/def
  :cognitect.aws.medialive.H264Settings/BufFillPct
  :cognitect.aws.medialive/__integerMin0Max100)

(s/def
  :cognitect.aws.medialive.H264Settings/LookAheadRateControl
  :cognitect.aws.medialive/H264LookAheadRateControl)

(s/def
  :cognitect.aws.medialive.H264Settings/FilterSettings
  :cognitect.aws.medialive/H264FilterSettings)

(s/def
  :cognitect.aws.medialive.H264Settings/GopClosedCadence
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.H264Settings/GopBReference
  :cognitect.aws.medialive/H264GopBReference)

(s/def :cognitect.aws.medialive.H264Settings/AfdSignaling :cognitect.aws.medialive/AfdSignaling)

(s/def :cognitect.aws.medialive.H264Settings/BufSize :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.H264Settings/FramerateControl
  :cognitect.aws.medialive/H264FramerateControl)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.VideoCodecSettings/FrameCaptureSettings
  :cognitect.aws.medialive/FrameCaptureSettings)

(s/def
  :cognitect.aws.medialive.VideoCodecSettings/H264Settings
  :cognitect.aws.medialive/H264Settings)

(s/def
  :cognitect.aws.medialive.VideoCodecSettings/H265Settings
  :cognitect.aws.medialive/H265Settings)

(s/def
  :cognitect.aws.medialive.VideoCodecSettings/Mpeg2Settings
  :cognitect.aws.medialive/Mpeg2Settings)

(s/def :cognitect.aws.medialive.VideoCodecSettings/Av1Settings :cognitect.aws.medialive/Av1Settings)

(s/def
  :cognitect.aws.medialive.MaintenanceCreateSettings/MaintenanceDay
  :cognitect.aws.medialive/MaintenanceDay)

(s/def
  :cognitect.aws.medialive.MaintenanceCreateSettings/MaintenanceStartTime
  :cognitect.aws.medialive/__stringPattern010920300)

(s/def
  :cognitect.aws.medialive.FrameCaptureGroupSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.FrameCaptureGroupSettings/FrameCaptureCdnSettings
  :cognitect.aws.medialive/FrameCaptureCdnSettings)

(s/def
  :cognitect.aws.medialive.MultiplexProgramSettings/PreferredChannelPipeline
  :cognitect.aws.medialive/PreferredChannelPipeline)

(s/def
  :cognitect.aws.medialive.MultiplexProgramSettings/ProgramNumber
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def
  :cognitect.aws.medialive.MultiplexProgramSettings/ServiceDescriptor
  :cognitect.aws.medialive/MultiplexProgramServiceDescriptor)

(s/def
  :cognitect.aws.medialive.MultiplexProgramSettings/VideoSettings
  :cognitect.aws.medialive/MultiplexVideoSettings)

(s/def :cognitect.aws.medialive.CreateChannelResultModel/Channel :cognitect.aws.medialive/Channel)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplate)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateResponseContent/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def
  :cognitect.aws.medialive.Eac3Settings/PassthroughControl
  :cognitect.aws.medialive/Eac3PassthroughControl)

(s/def :cognitect.aws.medialive.Eac3Settings/LfeFilter :cognitect.aws.medialive/Eac3LfeFilter)

(s/def
  :cognitect.aws.medialive.Eac3Settings/StereoDownmix
  :cognitect.aws.medialive/Eac3StereoDownmix)

(s/def
  :cognitect.aws.medialive.Eac3Settings/BitstreamMode
  :cognitect.aws.medialive/Eac3BitstreamMode)

(s/def :cognitect.aws.medialive.Eac3Settings/SurroundMode :cognitect.aws.medialive/Eac3SurroundMode)

(s/def
  :cognitect.aws.medialive.Eac3Settings/SurroundExMode
  :cognitect.aws.medialive/Eac3SurroundExMode)

(s/def :cognitect.aws.medialive.Eac3Settings/CodingMode :cognitect.aws.medialive/Eac3CodingMode)

(s/def :cognitect.aws.medialive.Eac3Settings/DrcRf :cognitect.aws.medialive/Eac3DrcRf)

(s/def
  :cognitect.aws.medialive.Eac3Settings/AttenuationControl
  :cognitect.aws.medialive/Eac3AttenuationControl)

(s/def :cognitect.aws.medialive.Eac3Settings/PhaseControl :cognitect.aws.medialive/Eac3PhaseControl)

(s/def :cognitect.aws.medialive.Eac3Settings/LtRtSurroundMixLevel :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/Bitrate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/DcFilter :cognitect.aws.medialive/Eac3DcFilter)

(s/def :cognitect.aws.medialive.Eac3Settings/LtRtCenterMixLevel :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/DrcLine :cognitect.aws.medialive/Eac3DrcLine)

(s/def
  :cognitect.aws.medialive.Eac3Settings/MetadataControl
  :cognitect.aws.medialive/Eac3MetadataControl)

(s/def :cognitect.aws.medialive.Eac3Settings/LoRoSurroundMixLevel :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/Dialnorm :cognitect.aws.medialive/__integerMin1Max31)

(s/def :cognitect.aws.medialive.Eac3Settings/LoRoCenterMixLevel :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3Settings/LfeControl :cognitect.aws.medialive/Eac3LfeControl)

(s/def
  :cognitect.aws.medialive.UpdateAccountConfigurationResponse/AccountConfiguration
  :cognitect.aws.medialive/AccountConfiguration)

(s/def :cognitect.aws.medialive.InputLocation/PasswordParam :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputLocation/Uri :cognitect.aws.medialive/__stringMax2048)

(s/def :cognitect.aws.medialive.InputLocation/Username :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeSdiSourceRequest/SdiSourceId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.MediaConnectFlow/FlowArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListChannelPlacementGroupsResponse/ChannelPlacementGroups
  :cognitect.aws.medialive/__listOfDescribeChannelPlacementGroupSummary)

(s/def
  :cognitect.aws.medialive.ListChannelPlacementGroupsResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/Scte35Pid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M3u8Settings/NielsenId3Behavior
  :cognitect.aws.medialive/M3u8NielsenId3Behavior)

(s/def :cognitect.aws.medialive.M3u8Settings/EcmPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/KlvBehavior :cognitect.aws.medialive/M3u8KlvBehavior)

(s/def :cognitect.aws.medialive.M3u8Settings/VideoPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/PcrControl :cognitect.aws.medialive/M3u8PcrControl)

(s/def
  :cognitect.aws.medialive.M3u8Settings/PatInterval
  :cognitect.aws.medialive/__integerMin0Max1000)

(s/def :cognitect.aws.medialive.M3u8Settings/AudioPids :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/PcrPeriod :cognitect.aws.medialive/__integerMin0Max500)

(s/def
  :cognitect.aws.medialive.M3u8Settings/Scte35Behavior
  :cognitect.aws.medialive/M3u8Scte35Behavior)

(s/def :cognitect.aws.medialive.M3u8Settings/KlvDataPids :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M3u8Settings/PcrPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M3u8Settings/TimedMetadataBehavior
  :cognitect.aws.medialive/M3u8TimedMetadataBehavior)

(s/def
  :cognitect.aws.medialive.M3u8Settings/ProgramNum
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def
  :cognitect.aws.medialive.M3u8Settings/TransportStreamId
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def :cognitect.aws.medialive.M3u8Settings/PmtPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M3u8Settings/PmtInterval
  :cognitect.aws.medialive/__integerMin0Max1000)

(s/def
  :cognitect.aws.medialive.M3u8Settings/AudioFramesPerPes
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.M3u8Settings/TimedMetadataPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioSelectorSettings/AudioHlsRenditionSelection
  :cognitect.aws.medialive/AudioHlsRenditionSelection)

(s/def
  :cognitect.aws.medialive.AudioSelectorSettings/AudioLanguageSelection
  :cognitect.aws.medialive/AudioLanguageSelection)

(s/def
  :cognitect.aws.medialive.AudioSelectorSettings/AudioPidSelection
  :cognitect.aws.medialive/AudioPidSelection)

(s/def
  :cognitect.aws.medialive.AudioSelectorSettings/AudioTrackSelection
  :cognitect.aws.medialive/AudioTrackSelection)

(s/def :cognitect.aws.medialive.ListNodesResponse/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListNodesResponse/Nodes
  :cognitect.aws.medialive/__listOfDescribeNodeSummary)

(s/def
  :cognitect.aws.medialive.MultiplexOutputDestination/MediaConnectSettings
  :cognitect.aws.medialive/MultiplexMediaConnectOutputDestinationSettings)

(s/def :cognitect.aws.medialive.CreateInputResultModel/Input :cognitect.aws.medialive/Input)

(s/def :cognitect.aws.medialive.ClaimDeviceRequest/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexContainerSettings/MultiplexM2tsSettings
  :cognitect.aws.medialive/MultiplexM2tsSettings)

(s/def :cognitect.aws.medialive.ResourceConflict/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StaticImageDeactivateScheduleActionSettings/FadeOut
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageDeactivateScheduleActionSettings/Layer
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def
  :cognitect.aws.medialive.DescribeAccountConfigurationResultModel/AccountConfiguration
  :cognitect.aws.medialive/AccountConfiguration)

(s/def
  :cognitect.aws.medialive.AutomaticInputFailoverSettings/ErrorClearTimeMsec
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.AutomaticInputFailoverSettings/FailoverConditions
  :cognitect.aws.medialive/__listOfFailoverCondition)

(s/def
  :cognitect.aws.medialive.AutomaticInputFailoverSettings/InputPreference
  :cognitect.aws.medialive/InputPreference)

(s/def
  :cognitect.aws.medialive.AutomaticInputFailoverSettings/SecondaryInputId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListChannelsResponse/Channels
  :cognitect.aws.medialive/__listOfChannelSummary)

(s/def :cognitect.aws.medialive.ListChannelsResponse/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BadRequestExceptionResponseContent/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartInputDeviceRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def :cognitect.aws.medialive.DescribeReservationResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/CurrencyCode
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/FixedPrice
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/ReservationId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/Region
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/OfferingDescription
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/RenewalSettings
  :cognitect.aws.medialive/RenewalSettings)

(s/def :cognitect.aws.medialive.DescribeReservationResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeReservationResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/Duration
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/UsagePrice
  :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.DescribeReservationResponse/End :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/State
  :cognitect.aws.medialive/ReservationState)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/Count
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/OfferingId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeReservationResponse/Start :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeReservationResponse/OfferingType
  :cognitect.aws.medialive/OfferingType)

(s/def
  :cognitect.aws.medialive.DeleteCloudWatchAlarmTemplateGroupRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateAccountConfigurationResultModel/AccountConfiguration
  :cognitect.aws.medialive/AccountConfiguration)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplateGroup)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplateGroup)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateCloudWatchAlarmTemplateGroupResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def :cognitect.aws.medialive.GetSignalMapResponse/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponse/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def
  :cognitect.aws.medialive.VideoSelectorColorSpaceSettings/Hdr10Settings
  :cognitect.aws.medialive/Hdr10Settings)

(s/def :cognitect.aws.medialive.TagsModel/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.WebvttDestinationSettings/StyleControl
  :cognitect.aws.medialive/WebvttDestinationStyleControl)

(s/def
  :cognitect.aws.medialive.MultiplexStatmuxVideoSettings/MaximumBitrate
  :cognitect.aws.medialive/__integerMin100000Max100000000)

(s/def
  :cognitect.aws.medialive.MultiplexStatmuxVideoSettings/MinimumBitrate
  :cognitect.aws.medialive/__integerMin100000Max100000000)

(s/def
  :cognitect.aws.medialive.MultiplexStatmuxVideoSettings/Priority
  :cognitect.aws.medialive/__integerMinNegative5Max5)

(s/def
  :cognitect.aws.medialive.BatchStopResultModel/Failed
  :cognitect.aws.medialive/__listOfBatchFailedResultModel)

(s/def
  :cognitect.aws.medialive.BatchStopResultModel/Successful
  :cognitect.aws.medialive/__listOfBatchSuccessfulResultModel)

(s/def
  :cognitect.aws.medialive.ArchiveCdnSettings/ArchiveS3Settings
  :cognitect.aws.medialive/ArchiveS3Settings)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleResult/Creates
  :cognitect.aws.medialive/BatchScheduleActionCreateResult)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleResult/Deletes
  :cognitect.aws.medialive/BatchScheduleActionDeleteResult)

(s/def :cognitect.aws.medialive.MediaConnectFlowRequest/FlowArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeClusterResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterResponse/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterResponse/ClusterType
  :cognitect.aws.medialive/ClusterType)

(s/def :cognitect.aws.medialive.DescribeClusterResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterResponse/InstanceRoleArn
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeClusterResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterResponse/NetworkSettings
  :cognitect.aws.medialive/ClusterNetworkSettings)

(s/def :cognitect.aws.medialive.DescribeClusterResponse/State :cognitect.aws.medialive/ClusterState)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Arn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Channels
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Id
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/Nodes
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResult/State
  :cognitect.aws.medialive/ChannelPlacementGroupState)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/Sources
  :cognitect.aws.medialive/__listOfInputSource)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/SdiSources
  :cognitect.aws.medialive/InputSdiSources)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/SrtSettings
  :cognitect.aws.medialive/SrtSettings)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/MediaConnectFlows
  :cognitect.aws.medialive/__listOfMediaConnectFlow)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/InputSourceType
  :cognitect.aws.medialive/InputSourceType)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/InputNetworkLocation
  :cognitect.aws.medialive/InputNetworkLocation)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/InputPartnerIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/Smpte2110ReceiverGroupSettings
  :cognitect.aws.medialive/Smpte2110ReceiverGroupSettings)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/AttachedChannels
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.DescribeInputResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeInputResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/Destinations
  :cognitect.aws.medialive/__listOfInputDestination)

(s/def :cognitect.aws.medialive.DescribeInputResponse/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/SecurityGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.DescribeInputResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/MulticastSettings
  :cognitect.aws.medialive/MulticastSettings)

(s/def :cognitect.aws.medialive.DescribeInputResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeInputResponse/Type :cognitect.aws.medialive/InputType)

(s/def :cognitect.aws.medialive.DescribeInputResponse/State :cognitect.aws.medialive/InputState)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/InputDevices
  :cognitect.aws.medialive/__listOfInputDeviceSettings)

(s/def
  :cognitect.aws.medialive.DescribeInputResponse/InputClass
  :cognitect.aws.medialive/InputClass)

(s/def
  :cognitect.aws.medialive.NodeConfigurationValidationError/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.NodeConfigurationValidationError/ValidationErrors
  :cognitect.aws.medialive/__listOfValidationError)

(s/def
  :cognitect.aws.medialive.ListInputDevicesRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListInputDevicesRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MulticastSourceUpdateRequest/SourceIp
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.MulticastSourceUpdateRequest/Url :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeAccountConfigurationResponse/AccountConfiguration
  :cognitect.aws.medialive/AccountConfiguration)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexResultModel/Multiplex
  :cognitect.aws.medialive/Multiplex)

(s/def
  :cognitect.aws.medialive.Multiplex/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettings)

(s/def :cognitect.aws.medialive.Multiplex/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Multiplex/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.Multiplex/Destinations
  :cognitect.aws.medialive/__listOfMultiplexOutputDestination)

(s/def
  :cognitect.aws.medialive.Multiplex/AvailabilityZones
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.Multiplex/PipelinesRunningCount :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.Multiplex/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Multiplex/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Multiplex/State :cognitect.aws.medialive/MultiplexState)

(s/def :cognitect.aws.medialive.Multiplex/ProgramCount :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/GroupIdentifier
  :cognitect.aws.medialive/__stringPatternS)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequest/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesResponse/CloudWatchAlarmTemplates
  :cognitect.aws.medialive/__listOfCloudWatchAlarmTemplateSummary)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplatesResponse/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/AvailabilityZone
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/UhdDeviceSettings
  :cognitect.aws.medialive/InputDeviceUhdSettings)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/SerialNumber
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeInputDeviceResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/MedialiveInputArns
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.DescribeInputDeviceResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/OutputType
  :cognitect.aws.medialive/InputDeviceOutputType)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/ConnectionState
  :cognitect.aws.medialive/InputDeviceConnectionState)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/MacAddress
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeInputDeviceResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/DeviceSettingsSyncState
  :cognitect.aws.medialive/DeviceSettingsSyncState)

(s/def :cognitect.aws.medialive.DescribeInputDeviceResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/Type
  :cognitect.aws.medialive/InputDeviceType)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/NetworkSettings
  :cognitect.aws.medialive/InputDeviceNetworkSettings)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/DeviceUpdateStatus
  :cognitect.aws.medialive/DeviceUpdateStatus)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceResponse/HdDeviceSettings
  :cognitect.aws.medialive/InputDeviceHdSettings)

(s/def
  :cognitect.aws.medialive.SrtGroupSettings/InputLossAction
  :cognitect.aws.medialive/InputLossActionForUdpOut)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/AvailabilityZone
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/UhdDeviceSettings
  :cognitect.aws.medialive/InputDeviceUhdSettings)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/SerialNumber
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateInputDeviceResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/MedialiveInputArns
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.UpdateInputDeviceResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/OutputType
  :cognitect.aws.medialive/InputDeviceOutputType)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/ConnectionState
  :cognitect.aws.medialive/InputDeviceConnectionState)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/MacAddress
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateInputDeviceResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/DeviceSettingsSyncState
  :cognitect.aws.medialive/DeviceSettingsSyncState)

(s/def :cognitect.aws.medialive.UpdateInputDeviceResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/Type
  :cognitect.aws.medialive/InputDeviceType)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/NetworkSettings
  :cognitect.aws.medialive/InputDeviceNetworkSettings)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/DeviceUpdateStatus
  :cognitect.aws.medialive/DeviceUpdateStatus)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceResponse/HdDeviceSettings
  :cognitect.aws.medialive/InputDeviceHdSettings)

(s/def
  :cognitect.aws.medialive.Scte20SourceSettings/Convert608To708
  :cognitect.aws.medialive/Scte20Convert608To708)

(s/def
  :cognitect.aws.medialive.Scte20SourceSettings/Source608ChannelNumber
  :cognitect.aws.medialive/__integerMin1Max4)

(s/def :cognitect.aws.medialive.CreateInputSecurityGroupRequest/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.CreateInputSecurityGroupRequest/WhitelistRules
  :cognitect.aws.medialive/__listOfInputWhitelistRuleCidr)

(s/def
  :cognitect.aws.medialive.ListNetworksResult/Networks
  :cognitect.aws.medialive/__listOfDescribeNetworkSummary)

(s/def :cognitect.aws.medialive.ListNetworksResult/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeThumbnailsResultModel/ThumbnailDetails
  :cognitect.aws.medialive/__listOfThumbnailDetail)

(s/def
  :cognitect.aws.medialive.MediaPackageOutputDestinationSettings/ChannelId
  :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.MediaPackageOutputDestinationSettings/ChannelGroup
  :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.MediaPackageOutputDestinationSettings/ChannelName
  :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.CaptionDescription/Accessibility
  :cognitect.aws.medialive/AccessibilityType)

(s/def
  :cognitect.aws.medialive.CaptionDescription/CaptionSelectorName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CaptionDescription/DestinationSettings
  :cognitect.aws.medialive/CaptionDestinationSettings)

(s/def :cognitect.aws.medialive.CaptionDescription/LanguageCode :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CaptionDescription/LanguageDescription
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CaptionDescription/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CaptionDescription/CaptionDashRoles
  :cognitect.aws.medialive/__listOfDashRoleCaption)

(s/def
  :cognitect.aws.medialive.CaptionDescription/DvbDashAccessibility
  :cognitect.aws.medialive/DvbDashAccessibility)

(s/def
  :cognitect.aws.medialive.StandardHlsSettings/AudioRenditionSets
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StandardHlsSettings/M3u8Settings
  :cognitect.aws.medialive/M3u8Settings)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/Scte35Pid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/Smpte2038Pid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/EcmPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/VideoPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/EtvSignalPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/DvbSubPids
  :cognitect.aws.medialive/__listOf__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/DvbTeletextPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/PrivateMetadataPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/AudioPids
  :cognitect.aws.medialive/__listOf__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/DvbTeletextPids
  :cognitect.aws.medialive/__listOf__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/AribCaptionsPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/KlvDataPids
  :cognitect.aws.medialive/__listOf__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/PcrPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/EtvPlatformPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/Scte27Pids
  :cognitect.aws.medialive/__listOf__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/PmtPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPacketIdentifiersMap/TimedMetadataPid
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.Scte27SourceSettings/OcrLanguage
  :cognitect.aws.medialive/Scte27OcrLanguage)

(s/def :cognitect.aws.medialive.Scte27SourceSettings/Pid :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.StopInputDeviceRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.SdiSourceMappingUpdateRequest/CardNumber
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.SdiSourceMappingUpdateRequest/ChannelNumber
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.SdiSourceMappingUpdateRequest/SdiSource
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Thumbnail/Body :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Thumbnail/ContentType :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Thumbnail/ThumbnailType :cognitect.aws.medialive/ThumbnailType)

(s/def :cognitect.aws.medialive.Thumbnail/TimeStamp :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.VideoSelectorProgramId/ProgramId
  :cognitect.aws.medialive/__integerMin0Max65536)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsRequest/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsRequest/Scope
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsRequest/SignalMapIdentifier
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteNodeRequest/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteNodeRequest/NodeId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CaptionSelector/LanguageCode :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CaptionSelector/Name :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.CaptionSelector/SelectorSettings
  :cognitect.aws.medialive/CaptionSelectorSettings)

(s/def
  :cognitect.aws.medialive.FrameCaptureS3Settings/CannedAcl
  :cognitect.aws.medialive/S3CannedAcl)

(s/def
  :cognitect.aws.medialive.HlsWebdavSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsWebdavSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0Max600)

(s/def
  :cognitect.aws.medialive.HlsWebdavSettings/HttpTransferMode
  :cognitect.aws.medialive/HlsWebdavHttpTransferMode)

(s/def :cognitect.aws.medialive.HlsWebdavSettings/NumRetries :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsWebdavSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def :cognitect.aws.medialive.StopChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.RebootInputDevice/Force
  :cognitect.aws.medialive/RebootInputDeviceForce)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplateGroup)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CloudWatchAlarmTemplateGroupSummary/TemplateCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.TeletextSourceSettings/OutputRectangle
  :cognitect.aws.medialive/CaptionRectangle)

(s/def :cognitect.aws.medialive.TeletextSourceSettings/PageNumber :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Arn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Channels
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Id
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/Nodes
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupResponse/State
  :cognitect.aws.medialive/ChannelPlacementGroupState)

(s/def
  :cognitect.aws.medialive.SrtSettingsRequest/SrtCallerSources
  :cognitect.aws.medialive/__listOfSrtCallerSourceRequest)

(s/def
  :cognitect.aws.medialive.UpdateNodeStateResponse/NodeInterfaceMappings
  :cognitect.aws.medialive/__listOfNodeInterfaceMapping)

(s/def
  :cognitect.aws.medialive.UpdateNodeStateResponse/InstanceArn
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeStateResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateNodeStateResponse/ChannelPlacementGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.UpdateNodeStateResponse/SdiSourceMappings
  :cognitect.aws.medialive/SdiSourceMappings)

(s/def
  :cognitect.aws.medialive.UpdateNodeStateResponse/ConnectionState
  :cognitect.aws.medialive/NodeConnectionState)

(s/def :cognitect.aws.medialive.UpdateNodeStateResponse/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeStateResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeStateResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeStateResponse/State :cognitect.aws.medialive/NodeState)

(s/def :cognitect.aws.medialive.UpdateNodeStateResponse/Role :cognitect.aws.medialive/NodeRole)

(s/def
  :cognitect.aws.medialive.RemixSettings/ChannelMappings
  :cognitect.aws.medialive/__listOfAudioChannelMapping)

(s/def
  :cognitect.aws.medialive.RemixSettings/ChannelsIn
  :cognitect.aws.medialive/__integerMin1Max16)

(s/def
  :cognitect.aws.medialive.RemixSettings/ChannelsOut
  :cognitect.aws.medialive/__integerMin1Max8)

(s/def :cognitect.aws.medialive.InputDeviceRequest/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/FadeIn
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Image
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Opacity
  :cognitect.aws.medialive/__integerMin0Max100)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/ImageX
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Duration
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Width
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/FadeOut
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/ImageY
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Layer
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def
  :cognitect.aws.medialive.StaticImageActivateScheduleActionSettings/Height
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.FrameCaptureSettings/CaptureInterval
  :cognitect.aws.medialive/__integerMin1Max3600000)

(s/def
  :cognitect.aws.medialive.FrameCaptureSettings/CaptureIntervalUnits
  :cognitect.aws.medialive/FrameCaptureIntervalUnit)

(s/def
  :cognitect.aws.medialive.FrameCaptureSettings/TimecodeBurninSettings
  :cognitect.aws.medialive/TimecodeBurninSettings)

(s/def :cognitect.aws.medialive.SdiSource/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SdiSource/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SdiSource/Inputs :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.SdiSource/Mode :cognitect.aws.medialive/SdiSourceMode)

(s/def :cognitect.aws.medialive.SdiSource/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SdiSource/State :cognitect.aws.medialive/SdiSourceState)

(s/def :cognitect.aws.medialive.SdiSource/Type :cognitect.aws.medialive/SdiSourceType)

(s/def
  :cognitect.aws.medialive.FollowModeScheduleActionStartSettings/FollowPoint
  :cognitect.aws.medialive/FollowPoint)

(s/def
  :cognitect.aws.medialive.FollowModeScheduleActionStartSettings/ReferenceActionName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SrtCallerDecryption/Algorithm :cognitect.aws.medialive/Algorithm)

(s/def
  :cognitect.aws.medialive.SrtCallerDecryption/PassphraseSecretArn
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeRequest/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeRequest/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeRequest/NodeId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeRequest/Role :cognitect.aws.medialive/NodeRole)

(s/def
  :cognitect.aws.medialive.UpdateNodeRequest/SdiSourceMappings
  :cognitect.aws.medialive/SdiSourceMappingsUpdateRequest)

(s/def
  :cognitect.aws.medialive.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDestinationVpc/AvailabilityZone
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDestinationVpc/NetworkInterfaceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.RebootInputDeviceRequest/Force
  :cognitect.aws.medialive/RebootInputDeviceForce)

(s/def
  :cognitect.aws.medialive.RebootInputDeviceRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.PurchaseOfferingResultModel/Reservation
  :cognitect.aws.medialive/Reservation)

(s/def
  :cognitect.aws.medialive.MaintenanceStatus/MaintenanceDay
  :cognitect.aws.medialive/MaintenanceDay)

(s/def
  :cognitect.aws.medialive.MaintenanceStatus/MaintenanceDeadline
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MaintenanceStatus/MaintenanceScheduledDate
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MaintenanceStatus/MaintenanceStartTime
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceMediaConnectConfigurableSettings/FlowArn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceMediaConnectConfigurableSettings/RoleArn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceMediaConnectConfigurableSettings/SecretArn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceMediaConnectConfigurableSettings/SourceName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplateGroup)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateGroupResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsResponse/EventBridgeRuleTemplateGroups
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateGroupSummary)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsResponse/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsResultModel/InputSecurityGroups
  :cognitect.aws.medialive/__listOfInputSecurityGroup)

(s/def
  :cognitect.aws.medialive.ListInputSecurityGroupsResultModel/NextToken
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsResponse/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsResponse/Offerings
  :cognitect.aws.medialive/__listOfOffering)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsResponseContent/EventBridgeRuleTemplateGroups
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateGroupSummary)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsResponseContent/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.OutputLockingSettings/EpochLockingSettings
  :cognitect.aws.medialive/EpochLockingSettings)

(s/def
  :cognitect.aws.medialive.OutputLockingSettings/PipelineLockingSettings
  :cognitect.aws.medialive/PipelineLockingSettings)

(s/def :cognitect.aws.medialive.AudioPidSelection/Pid :cognitect.aws.medialive/__integerMin0Max8191)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdAudioChannelPairConfig/Id
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.InputDeviceUhdAudioChannelPairConfig/Profile
  :cognitect.aws.medialive/InputDeviceUhdAudioChannelPairProfile)

(s/def :cognitect.aws.medialive.AccountConfiguration/KmsKeyId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsCdnSettings/HlsAkamaiSettings
  :cognitect.aws.medialive/HlsAkamaiSettings)

(s/def
  :cognitect.aws.medialive.HlsCdnSettings/HlsBasicPutSettings
  :cognitect.aws.medialive/HlsBasicPutSettings)

(s/def
  :cognitect.aws.medialive.HlsCdnSettings/HlsMediaStoreSettings
  :cognitect.aws.medialive/HlsMediaStoreSettings)

(s/def :cognitect.aws.medialive.HlsCdnSettings/HlsS3Settings :cognitect.aws.medialive/HlsS3Settings)

(s/def
  :cognitect.aws.medialive.HlsCdnSettings/HlsWebdavSettings
  :cognitect.aws.medialive/HlsWebdavSettings)

(s/def :cognitect.aws.medialive.StopMultiplexRequest/MultiplexId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurationValidationError/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurationValidationError/ValidationErrors
  :cognitect.aws.medialive/__listOfValidationError)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupRequest/ChannelPlacementGroupId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupRequest/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputAttachment/AutomaticInputFailoverSettings
  :cognitect.aws.medialive/AutomaticInputFailoverSettings)

(s/def
  :cognitect.aws.medialive.InputAttachment/InputAttachmentName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputAttachment/InputId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputAttachment/InputSettings
  :cognitect.aws.medialive/InputSettings)

(s/def
  :cognitect.aws.medialive.InputAttachment/LogicalInterfaceNames
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.MotionGraphicsConfiguration/MotionGraphicsInsertion
  :cognitect.aws.medialive/MotionGraphicsInsertion)

(s/def
  :cognitect.aws.medialive.MotionGraphicsConfiguration/MotionGraphicsSettings
  :cognitect.aws.medialive/MotionGraphicsSettings)

(s/def
  :cognitect.aws.medialive.BatchDeleteRequest/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.BatchDeleteRequest/InputIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.BatchDeleteRequest/InputSecurityGroupIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.BatchDeleteRequest/MultiplexIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.Reservation/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def :cognitect.aws.medialive.Reservation/Tags :cognitect.aws.medialive/Tags)

(s/def :cognitect.aws.medialive.Reservation/CurrencyCode :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/FixedPrice :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.Reservation/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def :cognitect.aws.medialive.Reservation/ReservationId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/Region :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/OfferingDescription :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Reservation/RenewalSettings
  :cognitect.aws.medialive/RenewalSettings)

(s/def :cognitect.aws.medialive.Reservation/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/Duration :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.Reservation/UsagePrice :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Reservation/End :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/State :cognitect.aws.medialive/ReservationState)

(s/def :cognitect.aws.medialive.Reservation/Count :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.Reservation/OfferingId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/Start :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Reservation/OfferingType :cognitect.aws.medialive/OfferingType)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentResponse/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def :cognitect.aws.medialive.VideoSelectorPid/Pid :cognitect.aws.medialive/__integerMin0Max8191)

(s/def
  :cognitect.aws.medialive.Av1ColorSpaceSettings/ColorSpacePassthroughSettings
  :cognitect.aws.medialive/ColorSpacePassthroughSettings)

(s/def
  :cognitect.aws.medialive.Av1ColorSpaceSettings/Hdr10Settings
  :cognitect.aws.medialive/Hdr10Settings)

(s/def
  :cognitect.aws.medialive.Av1ColorSpaceSettings/Rec601Settings
  :cognitect.aws.medialive/Rec601Settings)

(s/def
  :cognitect.aws.medialive.Av1ColorSpaceSettings/Rec709Settings
  :cognitect.aws.medialive/Rec709Settings)

(s/def
  :cognitect.aws.medialive.FixedModeScheduleActionStartSettings/Time
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsBasicPutSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsBasicPutSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0Max600)

(s/def
  :cognitect.aws.medialive.HlsBasicPutSettings/NumRetries
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsBasicPutSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def
  :cognitect.aws.medialive.BatchScheduleActionCreateRequest/ScheduleActions
  :cognitect.aws.medialive/__listOfScheduleAction)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbSdtSettings :cognitect.aws.medialive/DvbSdtSettings)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AbsentInputAudioBehavior
  :cognitect.aws.medialive/M2tsAbsentInputAudioBehavior)

(s/def :cognitect.aws.medialive.M2tsSettings/Scte35Pid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/NielsenId3Behavior
  :cognitect.aws.medialive/M2tsNielsenId3Behavior)

(s/def :cognitect.aws.medialive.M2tsSettings/EsRateInPes :cognitect.aws.medialive/M2tsEsRateInPes)

(s/def :cognitect.aws.medialive.M2tsSettings/CcDescriptor :cognitect.aws.medialive/M2tsCcDescriptor)

(s/def :cognitect.aws.medialive.M2tsSettings/SegmentationTime :cognitect.aws.medialive/__doubleMin1)

(s/def :cognitect.aws.medialive.M2tsSettings/EcmPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/SegmentationStyle
  :cognitect.aws.medialive/M2tsSegmentationStyle)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AribCaptionsPidControl
  :cognitect.aws.medialive/M2tsAribCaptionsPidControl)

(s/def :cognitect.aws.medialive.M2tsSettings/VideoPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/EtvSignalPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/PcrControl :cognitect.aws.medialive/M2tsPcrControl)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbSubPids :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/EbpLookaheadMs
  :cognitect.aws.medialive/__integerMin0Max10000)

(s/def :cognitect.aws.medialive.M2tsSettings/BufferModel :cognitect.aws.medialive/M2tsBufferModel)

(s/def
  :cognitect.aws.medialive.M2tsSettings/PatInterval
  :cognitect.aws.medialive/__integerMin0Max1000)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbTeletextPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AudioBufferModel
  :cognitect.aws.medialive/M2tsAudioBufferModel)

(s/def
  :cognitect.aws.medialive.M2tsSettings/SegmentationMarkers
  :cognitect.aws.medialive/M2tsSegmentationMarkers)

(s/def :cognitect.aws.medialive.M2tsSettings/EbpPlacement :cognitect.aws.medialive/M2tsEbpPlacement)

(s/def :cognitect.aws.medialive.M2tsSettings/Bitrate :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.M2tsSettings/AudioPids :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/PcrPeriod :cognitect.aws.medialive/__integerMin0Max500)

(s/def
  :cognitect.aws.medialive.M2tsSettings/NullPacketBitrate
  :cognitect.aws.medialive/__doubleMin0)

(s/def :cognitect.aws.medialive.M2tsSettings/AribCaptionsPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/KlvDataPids :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/EbpAudioInterval
  :cognitect.aws.medialive/M2tsAudioInterval)

(s/def :cognitect.aws.medialive.M2tsSettings/PcrPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/Ebif :cognitect.aws.medialive/M2tsEbifControl)

(s/def
  :cognitect.aws.medialive.M2tsSettings/TimedMetadataBehavior
  :cognitect.aws.medialive/M2tsTimedMetadataBehavior)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AudioStreamType
  :cognitect.aws.medialive/M2tsAudioStreamType)

(s/def :cognitect.aws.medialive.M2tsSettings/Klv :cognitect.aws.medialive/M2tsKlv)

(s/def :cognitect.aws.medialive.M2tsSettings/EtvPlatformPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbTdtSettings :cognitect.aws.medialive/DvbTdtSettings)

(s/def :cognitect.aws.medialive.M2tsSettings/Arib :cognitect.aws.medialive/M2tsArib)

(s/def :cognitect.aws.medialive.M2tsSettings/Scte27Pids :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/ProgramNum
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def
  :cognitect.aws.medialive.M2tsSettings/Scte35Control
  :cognitect.aws.medialive/M2tsScte35Control)

(s/def :cognitect.aws.medialive.M2tsSettings/RateMode :cognitect.aws.medialive/M2tsRateMode)

(s/def
  :cognitect.aws.medialive.M2tsSettings/TransportStreamId
  :cognitect.aws.medialive/__integerMin0Max65535)

(s/def :cognitect.aws.medialive.M2tsSettings/PmtPid :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.M2tsSettings/PmtInterval
  :cognitect.aws.medialive/__integerMin0Max1000)

(s/def :cognitect.aws.medialive.M2tsSettings/FragmentTime :cognitect.aws.medialive/__doubleMin0)

(s/def :cognitect.aws.medialive.M2tsSettings/DvbNitSettings :cognitect.aws.medialive/DvbNitSettings)

(s/def
  :cognitect.aws.medialive.M2tsSettings/Scte35PrerollPullupMilliseconds
  :cognitect.aws.medialive/__doubleMin0Max5000)

(s/def
  :cognitect.aws.medialive.M2tsSettings/AudioFramesPerPes
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.M2tsSettings/TimedMetadataPid :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListInputsResultModel/Inputs :cognitect.aws.medialive/__listOfInput)

(s/def :cognitect.aws.medialive.ListInputsResultModel/NextToken :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.BadGatewayException/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateMultiplexRequest/AvailabilityZones
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.CreateMultiplexRequest/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettings)

(s/def :cognitect.aws.medialive.CreateMultiplexRequest/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateMultiplexRequest/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateMultiplexRequest/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.InputVpcRequest/SecurityGroupIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.InputVpcRequest/SubnetIds :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.TooManyRequestsExceptionResponseContent/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexProgramServiceDescriptor/ProviderName
  :cognitect.aws.medialive/__stringMax256)

(s/def
  :cognitect.aws.medialive.MultiplexProgramServiceDescriptor/ServiceName
  :cognitect.aws.medialive/__stringMax256)

(s/def
  :cognitect.aws.medialive.ClusterNetworkSettingsCreateRequest/DefaultRoute
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ClusterNetworkSettingsCreateRequest/InterfaceMappings
  :cognitect.aws.medialive/__listOfInterfaceMappingCreateRequest)

(s/def
  :cognitect.aws.medialive.ClusterNetworkSettingsUpdateRequest/DefaultRoute
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ClusterNetworkSettingsUpdateRequest/InterfaceMappings
  :cognitect.aws.medialive/__listOfInterfaceMappingUpdateRequest)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequest/CloudWatchAlarmTemplateGroupIdentifiers
  :cognitect.aws.medialive/__listOf__stringPatternS)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequest/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequest/EventBridgeRuleTemplateGroupIdentifiers
  :cognitect.aws.medialive/__listOf__stringPatternS)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequest/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def :cognitect.aws.medialive.CreateSignalMapRequest/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequest/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def
  :cognitect.aws.medialive.CancelInputDeviceTransferRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BatchScheduleActionDeleteResult/ScheduleActions
  :cognitect.aws.medialive/__listOfScheduleAction)

(s/def :cognitect.aws.medialive.GetSignalMapRequest/Identifier :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MulticastSourceCreateRequest/SourceIp
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.MulticastSourceCreateRequest/Url :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequest/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequest/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequest/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def :cognitect.aws.medialive.IpPoolCreateRequest/Cidr :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InternalServerErrorException/Message
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StartChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StartTimecode/Timecode :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplate)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponseContent/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def
  :cognitect.aws.medialive.UpdateInputSecurityGroupRequest/InputSecurityGroupId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateInputSecurityGroupRequest/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.UpdateInputSecurityGroupRequest/WhitelistRules
  :cognitect.aws.medialive/__listOfInputWhitelistRuleCidr)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplate)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateAccountConfigurationRequestModel/AccountConfiguration
  :cognitect.aws.medialive/AccountConfiguration)

(s/def
  :cognitect.aws.medialive.InputPrepareScheduleActionSettings/InputAttachmentNameReference
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputPrepareScheduleActionSettings/InputClippingSettings
  :cognitect.aws.medialive/InputClippingSettings)

(s/def
  :cognitect.aws.medialive.InputPrepareScheduleActionSettings/UrlPath
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.TransferInputDevice/TargetCustomerId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.TransferInputDevice/TargetRegion :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.TransferInputDevice/TransferMessage
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeRequest/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeRequest/NodeId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListNetworksRequest/MaxResults :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListNetworksRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexProgramResultModel/MultiplexProgram
  :cognitect.aws.medialive/MultiplexProgram)

(s/def
  :cognitect.aws.medialive.ScheduleActionStartSettings/FixedModeScheduleActionStartSettings
  :cognitect.aws.medialive/FixedModeScheduleActionStartSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionStartSettings/FollowModeScheduleActionStartSettings
  :cognitect.aws.medialive/FollowModeScheduleActionStartSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionStartSettings/ImmediateModeScheduleActionStartSettings
  :cognitect.aws.medialive/ImmediateModeScheduleActionStartSettings)

(s/def
  :cognitect.aws.medialive.StartDeleteMonitorDeploymentRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.OutputGroup/Name :cognitect.aws.medialive/__stringMax32)

(s/def
  :cognitect.aws.medialive.OutputGroup/OutputGroupSettings
  :cognitect.aws.medialive/OutputGroupSettings)

(s/def :cognitect.aws.medialive.OutputGroup/Outputs :cognitect.aws.medialive/__listOfOutput)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/PauseStateSettings
  :cognitect.aws.medialive/PauseStateScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/MotionGraphicsImageDeactivateSettings
  :cognitect.aws.medialive/MotionGraphicsDeactivateScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/StaticImageOutputDeactivateSettings
  :cognitect.aws.medialive/StaticImageOutputDeactivateScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/Scte35TimeSignalSettings
  :cognitect.aws.medialive/Scte35TimeSignalScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/MotionGraphicsImageActivateSettings
  :cognitect.aws.medialive/MotionGraphicsActivateScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/InputSwitchSettings
  :cognitect.aws.medialive/InputSwitchScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/StaticImageOutputActivateSettings
  :cognitect.aws.medialive/StaticImageOutputActivateScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/Id3SegmentTaggingSettings
  :cognitect.aws.medialive/Id3SegmentTaggingScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/HlsId3SegmentTaggingSettings
  :cognitect.aws.medialive/HlsId3SegmentTaggingScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/HlsTimedMetadataSettings
  :cognitect.aws.medialive/HlsTimedMetadataScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/Scte35InputSettings
  :cognitect.aws.medialive/Scte35InputScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/Scte35ReturnToNetworkSettings
  :cognitect.aws.medialive/Scte35ReturnToNetworkScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/TimedMetadataSettings
  :cognitect.aws.medialive/TimedMetadataScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/StaticImageDeactivateSettings
  :cognitect.aws.medialive/StaticImageDeactivateScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/StaticImageActivateSettings
  :cognitect.aws.medialive/StaticImageActivateScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/InputPrepareSettings
  :cognitect.aws.medialive/InputPrepareScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleActionSettings/Scte35SpliceInsertSettings
  :cognitect.aws.medialive/Scte35SpliceInsertScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.EmbeddedSourceSettings/Convert608To708
  :cognitect.aws.medialive/EmbeddedConvert608To708)

(s/def
  :cognitect.aws.medialive.EmbeddedSourceSettings/Scte20Detection
  :cognitect.aws.medialive/EmbeddedScte20Detection)

(s/def
  :cognitect.aws.medialive.EmbeddedSourceSettings/Source608ChannelNumber
  :cognitect.aws.medialive/__integerMin1Max4)

(s/def
  :cognitect.aws.medialive.EmbeddedSourceSettings/Source608TrackNumber
  :cognitect.aws.medialive/__integerMin1Max5)

(s/def
  :cognitect.aws.medialive.BatchStopRequest/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.BatchStopRequest/MultiplexIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.InputSourceRequest/PasswordParam :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSourceRequest/Url :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputSourceRequest/Username :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateMultiplexResponse/Multiplex
  :cognitect.aws.medialive/Multiplex)

(s/def
  :cognitect.aws.medialive.Output/AudioDescriptionNames
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.Output/CaptionDescriptionNames
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.Output/OutputName :cognitect.aws.medialive/__stringMin1Max255)

(s/def :cognitect.aws.medialive.Output/OutputSettings :cognitect.aws.medialive/OutputSettings)

(s/def :cognitect.aws.medialive.Output/VideoDescriptionName :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateSdiSourceResponse/SdiSource
  :cognitect.aws.medialive/SdiSource)

(s/def
  :cognitect.aws.medialive.KeyProviderSettings/StaticKeySettings
  :cognitect.aws.medialive/StaticKeySettings)

(s/def
  :cognitect.aws.medialive.StopMultiplexResponse/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettings)

(s/def :cognitect.aws.medialive.StopMultiplexResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StopMultiplexResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.StopMultiplexResponse/Destinations
  :cognitect.aws.medialive/__listOfMultiplexOutputDestination)

(s/def
  :cognitect.aws.medialive.StopMultiplexResponse/AvailabilityZones
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.StopMultiplexResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.StopMultiplexResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StopMultiplexResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StopMultiplexResponse/State :cognitect.aws.medialive/MultiplexState)

(s/def
  :cognitect.aws.medialive.StopMultiplexResponse/ProgramCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.Mp2Settings/Bitrate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Mp2Settings/CodingMode :cognitect.aws.medialive/Mp2CodingMode)

(s/def :cognitect.aws.medialive.Mp2Settings/SampleRate :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.SrtCallerSourceRequest/Decryption
  :cognitect.aws.medialive/SrtCallerDecryptionRequest)

(s/def
  :cognitect.aws.medialive.SrtCallerSourceRequest/MinimumLatency
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.SrtCallerSourceRequest/SrtListenerAddress
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.SrtCallerSourceRequest/SrtListenerPort
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SrtCallerSourceRequest/StreamId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartInputDeviceMaintenanceWindowRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputSecurityGroupRequest/InputSecurityGroupId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.SignalMapSummary/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.SignalMapSummary/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def :cognitect.aws.medialive.SignalMapSummary/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.SignalMapSummary/MonitorDeploymentStatus
  :cognitect.aws.medialive/SignalMapMonitorDeploymentStatus)

(s/def
  :cognitect.aws.medialive.SignalMapSummary/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.SignalMapSummary/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.SignalMapSummary/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.SignalMapSummary/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def :cognitect.aws.medialive.SignalMapSummary/Status :cognitect.aws.medialive/SignalMapStatus)

(s/def
  :cognitect.aws.medialive.DeleteEventBridgeRuleTemplateRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ChannelEgressEndpoint/SourceIp :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/MaximumFramerate
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/ResourceType
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListReservationsRequest/Codec :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/SpecialFeature
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListReservationsRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/ChannelClass
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/VideoQuality
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/MaximumBitrate
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListReservationsRequest/Resolution
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.EpochLockingSettings/CustomEpoch :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.EpochLockingSettings/JamSyncTime :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexSettingsSummary/TransportStreamBitrate
  :cognitect.aws.medialive/__integerMin1000000Max100000000)

(s/def
  :cognitect.aws.medialive.CreateSdiSourceResponse/SdiSource
  :cognitect.aws.medialive/SdiSource)

(s/def
  :cognitect.aws.medialive.CreateMultiplex/AvailabilityZones
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.CreateMultiplex/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettings)

(s/def :cognitect.aws.medialive.CreateMultiplex/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateMultiplex/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateMultiplex/Tags :cognitect.aws.medialive/Tags)

(s/def :cognitect.aws.medialive.InputDestination/Ip :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDestination/Port :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDestination/Url :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDestination/Vpc :cognitect.aws.medialive/InputDestinationVpc)

(s/def :cognitect.aws.medialive.InputDestination/Network :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDestination/NetworkRoutes
  :cognitect.aws.medialive/__listOfInputDestinationRoute)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplateGroup)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplate)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.BatchScheduleActionCreateResult/ScheduleActions
  :cognitect.aws.medialive/__listOfScheduleAction)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/Sources
  :cognitect.aws.medialive/__listOfInputSourceRequest)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/SdiSources
  :cognitect.aws.medialive/InputSdiSources)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/SrtSettings
  :cognitect.aws.medialive/SrtSettingsRequest)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/MediaConnectFlows
  :cognitect.aws.medialive/__listOfMediaConnectFlowRequest)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/Smpte2110ReceiverGroupSettings
  :cognitect.aws.medialive/Smpte2110ReceiverGroupSettings)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/InputSecurityGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/Destinations
  :cognitect.aws.medialive/__listOfInputDestinationRequest)

(s/def :cognitect.aws.medialive.UpdateInputRequest/InputId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateInputRequest/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/MulticastSettings
  :cognitect.aws.medialive/MulticastSettingsUpdateRequest)

(s/def :cognitect.aws.medialive.UpdateInputRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputRequest/InputDevices
  :cognitect.aws.medialive/__listOfInputDeviceRequest)

(s/def
  :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/Id
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/NodeInterfaceMappings
  :cognitect.aws.medialive/__listOfNodeInterfaceMapping)

(s/def
  :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/RequestId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNodeRegistrationScriptRequest/Role
  :cognitect.aws.medialive/NodeRole)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Arn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Channels
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Id
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/Nodes
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelPlacementGroupSummary/State
  :cognitect.aws.medialive/ChannelPlacementGroupState)

(s/def :cognitect.aws.medialive.UpdateChannelResponse/Channel :cognitect.aws.medialive/Channel)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleRequest/ChannelId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleRequest/Creates
  :cognitect.aws.medialive/BatchScheduleActionCreateRequest)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleRequest/Deletes
  :cognitect.aws.medialive/BatchScheduleActionDeleteRequest)

(s/def
  :cognitect.aws.medialive.DescribeThumbnailsRequest/ChannelId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeThumbnailsRequest/PipelineId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeThumbnailsRequest/ThumbnailType
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/NielsenId3Behavior
  :cognitect.aws.medialive/CmafNielsenId3Behavior)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/NielsenId3NameModifier
  :cognitect.aws.medialive/__stringMax100)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/KlvBehavior
  :cognitect.aws.medialive/CmafKLVBehavior)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/SegmentLength
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/TimedMetadataId3Period
  :cognitect.aws.medialive/__integerMin0Max10000)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/TimedMetadataId3Frame
  :cognitect.aws.medialive/CmafTimedMetadataId3Frame)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/SendDelayMs
  :cognitect.aws.medialive/__integerMin0Max2000)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/SegmentLengthUnits
  :cognitect.aws.medialive/CmafIngestSegmentLengthUnits)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/Id3Behavior
  :cognitect.aws.medialive/CmafId3Behavior)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/Scte35NameModifier
  :cognitect.aws.medialive/__stringMax100)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/Id3NameModifier
  :cognitect.aws.medialive/__stringMax100)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/KlvNameModifier
  :cognitect.aws.medialive/__stringMax100)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/AdditionalDestinations
  :cognitect.aws.medialive/__listOfAdditionalDestinations)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/CaptionLanguageMappings
  :cognitect.aws.medialive/__listOfCmafIngestCaptionLanguageMapping)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/TimedMetadataPassthrough
  :cognitect.aws.medialive/CmafTimedMetadataPassthrough)

(s/def
  :cognitect.aws.medialive.CmafIngestGroupSettings/Scte35Type
  :cognitect.aws.medialive/Scte35Type)

(s/def :cognitect.aws.medialive.DeleteChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.ArchiveOutputSettings/ContainerSettings
  :cognitect.aws.medialive/ArchiveContainerSettings)

(s/def :cognitect.aws.medialive.ArchiveOutputSettings/Extension :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ArchiveOutputSettings/NameModifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/AcquisitionPointId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/AudioOnlyTimecodeControl
  :cognitect.aws.medialive/SmoothGroupAudioOnlyTimecodeControl)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/TimestampOffset
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/CertificateMode
  :cognitect.aws.medialive/SmoothGroupCertificateMode)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/EventIdMode
  :cognitect.aws.medialive/SmoothGroupEventIdMode)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/NumRetries
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/FragmentLength
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/TimestampOffsetMode
  :cognitect.aws.medialive/SmoothGroupTimestampOffsetMode)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/EventStopBehavior
  :cognitect.aws.medialive/SmoothGroupEventStopBehavior)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/SendDelayMs
  :cognitect.aws.medialive/__integerMin0Max10000)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/StreamManifestBehavior
  :cognitect.aws.medialive/SmoothGroupStreamManifestBehavior)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/SparseTrackType
  :cognitect.aws.medialive/SmoothGroupSparseTrackType)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/SegmentationMode
  :cognitect.aws.medialive/SmoothGroupSegmentationMode)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.MsSmoothGroupSettings/EventId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MsSmoothGroupSettings/InputLossAction
  :cognitect.aws.medialive/InputLossActionForMsSmoothOut)

(s/def :cognitect.aws.medialive.BatchStart/ChannelIds :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.BatchStart/MultiplexIds :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.CreateMultiplexProgramResultModel/MultiplexProgram
  :cognitect.aws.medialive/MultiplexProgram)

(s/def
  :cognitect.aws.medialive.FrameCaptureOutputSettings/NameModifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputSecurityGroupResponse/SecurityGroup
  :cognitect.aws.medialive/InputSecurityGroup)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurableSettings/ConfiguredInput
  :cognitect.aws.medialive/InputDeviceConfiguredInput)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurableSettings/MaxBitrate
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurableSettings/LatencyMs
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurableSettings/Codec
  :cognitect.aws.medialive/InputDeviceCodec)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurableSettings/MediaconnectSettings
  :cognitect.aws.medialive/InputDeviceMediaConnectConfigurableSettings)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurableSettings/AudioChannelPairs
  :cognitect.aws.medialive/__listOfInputDeviceConfigurableAudioChannelPairConfig)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurableSettings/InputResolution
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartMultiplexResponse/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettings)

(s/def :cognitect.aws.medialive.StartMultiplexResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StartMultiplexResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.StartMultiplexResponse/Destinations
  :cognitect.aws.medialive/__listOfMultiplexOutputDestination)

(s/def
  :cognitect.aws.medialive.StartMultiplexResponse/AvailabilityZones
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.StartMultiplexResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.StartMultiplexResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StartMultiplexResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StartMultiplexResponse/State
  :cognitect.aws.medialive/MultiplexState)

(s/def
  :cognitect.aws.medialive.StartMultiplexResponse/ProgramCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.PipelinePauseStateSettings/PipelineId
  :cognitect.aws.medialive/PipelineId)

(s/def
  :cognitect.aws.medialive.HlsId3SegmentTaggingScheduleActionSettings/Tag
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsId3SegmentTaggingScheduleActionSettings/Id3
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplateGroup)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def :cognitect.aws.medialive.DescribeClusterSummary/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterSummary/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterSummary/ClusterType
  :cognitect.aws.medialive/ClusterType)

(s/def :cognitect.aws.medialive.DescribeClusterSummary/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterSummary/InstanceRoleArn
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeClusterSummary/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeClusterSummary/NetworkSettings
  :cognitect.aws.medialive/ClusterNetworkSettings)

(s/def :cognitect.aws.medialive.DescribeClusterSummary/State :cognitect.aws.medialive/ClusterState)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Arn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Channels
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Id
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/Nodes
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupResponse/State
  :cognitect.aws.medialive/ChannelPlacementGroupState)

(s/def :cognitect.aws.medialive.DeleteNetworkResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteNetworkResponse/AssociatedClusterIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.DeleteNetworkResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteNetworkResponse/IpPools
  :cognitect.aws.medialive/__listOfIpPool)

(s/def :cognitect.aws.medialive.DeleteNetworkResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DeleteNetworkResponse/Routes :cognitect.aws.medialive/__listOfRoute)

(s/def :cognitect.aws.medialive.DeleteNetworkResponse/State :cognitect.aws.medialive/NetworkState)

(s/def
  :cognitect.aws.medialive.RenewalSettings/AutomaticRenewal
  :cognitect.aws.medialive/ReservationAutomaticRenewal)

(s/def :cognitect.aws.medialive.RenewalSettings/RenewalCount :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.AvailSettings/Esam :cognitect.aws.medialive/Esam)

(s/def
  :cognitect.aws.medialive.AvailSettings/Scte35SpliceInsert
  :cognitect.aws.medialive/Scte35SpliceInsert)

(s/def
  :cognitect.aws.medialive.AvailSettings/Scte35TimeSignalApos
  :cognitect.aws.medialive/Scte35TimeSignalApos)

(s/def
  :cognitect.aws.medialive.StaticKeySettings/KeyProviderServer
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.StaticKeySettings/StaticKeyValue
  :cognitect.aws.medialive/__stringMin32Max32)

(s/def
  :cognitect.aws.medialive.CreateNodeRegistrationScriptResult/NodeRegistrationScript
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.SrtCallerDecryptionRequest/Algorithm
  :cognitect.aws.medialive/Algorithm)

(s/def
  :cognitect.aws.medialive.SrtCallerDecryptionRequest/PassphraseSecretArn
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateChannel/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.CreateChannel/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.CreateChannel/Reserved :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateChannel/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.CreateChannel/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def :cognitect.aws.medialive.CreateChannel/DryRun :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.CreateChannel/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.CreateChannel/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.CreateChannel/ChannelClass :cognitect.aws.medialive/ChannelClass)

(s/def :cognitect.aws.medialive.CreateChannel/Vpc :cognitect.aws.medialive/VpcOutputSettings)

(s/def :cognitect.aws.medialive.CreateChannel/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateChannel/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateChannel/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannel/AnywhereSettings
  :cognitect.aws.medialive/AnywhereSettings)

(s/def
  :cognitect.aws.medialive.CreateChannel/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.CreateChannel/Maintenance
  :cognitect.aws.medialive/MaintenanceCreateSettings)

(s/def
  :cognitect.aws.medialive.CreateChannel/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionRequest)

(s/def
  :cognitect.aws.medialive.ListInputDeviceTransfersRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListInputDeviceTransfersRequest/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListInputDeviceTransfersRequest/TransferType
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateInputResultModel/Input :cognitect.aws.medialive/Input)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupRequest/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupRequest/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupRequest/Nodes
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupRequest/RequestId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelPlacementGroupRequest/Tags
  :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplate)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.VideoBlackFailoverSettings/BlackDetectThreshold
  :cognitect.aws.medialive/__doubleMin0Max1)

(s/def
  :cognitect.aws.medialive.VideoBlackFailoverSettings/VideoBlackThresholdMsec
  :cognitect.aws.medialive/__integerMin1000)

(s/def
  :cognitect.aws.medialive.DvbTdtSettings/RepInterval
  :cognitect.aws.medialive/__integerMin1000Max30000)

(s/def :cognitect.aws.medialive.ForbiddenException/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNodeResponse/NodeInterfaceMappings
  :cognitect.aws.medialive/__listOfNodeInterfaceMapping)

(s/def :cognitect.aws.medialive.CreateNodeResponse/InstanceArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateNodeResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNodeResponse/ChannelPlacementGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.CreateNodeResponse/SdiSourceMappings
  :cognitect.aws.medialive/SdiSourceMappings)

(s/def
  :cognitect.aws.medialive.CreateNodeResponse/ConnectionState
  :cognitect.aws.medialive/NodeConnectionState)

(s/def :cognitect.aws.medialive.CreateNodeResponse/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateNodeResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateNodeResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateNodeResponse/State :cognitect.aws.medialive/NodeState)

(s/def :cognitect.aws.medialive.CreateNodeResponse/Role :cognitect.aws.medialive/NodeRole)

(s/def :cognitect.aws.medialive.CreateTagsRequest/ResourceArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateTagsRequest/Tags :cognitect.aws.medialive/Tags)

(s/def :cognitect.aws.medialive.BadRequestException/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsTimedMetadataScheduleActionSettings/Id3
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/FadeIn
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/OutputNames
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Image
  :cognitect.aws.medialive/InputLocation)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Opacity
  :cognitect.aws.medialive/__integerMin0Max100)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/ImageX
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Duration
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Width
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/FadeOut
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/ImageY
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Layer
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def
  :cognitect.aws.medialive.StaticImageOutputActivateScheduleActionSettings/Height
  :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.UpdateNetworkResult/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateNetworkResult/AssociatedClusterIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.UpdateNetworkResult/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNetworkResult/IpPools :cognitect.aws.medialive/__listOfIpPool)

(s/def :cognitect.aws.medialive.UpdateNetworkResult/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNetworkResult/Routes :cognitect.aws.medialive/__listOfRoute)

(s/def :cognitect.aws.medialive.UpdateNetworkResult/State :cognitect.aws.medialive/NetworkState)

(s/def :cognitect.aws.medialive.ListChannelsRequest/MaxResults :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListChannelsRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListMultiplexProgramsRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListMultiplexProgramsRequest/MultiplexId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListMultiplexProgramsRequest/NextToken
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.GatewayTimeoutException/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsResponseContent/CloudWatchAlarmTemplateGroups
  :cognitect.aws.medialive/__listOfCloudWatchAlarmTemplateGroupSummary)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsResponseContent/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def :cognitect.aws.medialive.DeleteInputRequest/InputId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ScheduleDescribeResultModel/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ScheduleDescribeResultModel/ScheduleActions
  :cognitect.aws.medialive/__listOfScheduleAction)

(s/def
  :cognitect.aws.medialive.ListOfferingsRequest/MaximumFramerate
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/ResourceType :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/Codec :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsRequest/SpecialFeature
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/NextToken :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/ChannelClass :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/VideoQuality :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsRequest/MaximumBitrate
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/MaxResults :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/Duration :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListOfferingsRequest/Resolution :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsRequest/ChannelConfiguration
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ChannelEngineVersionRequest/Version
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ScheduleAction/ActionName :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ScheduleAction/ScheduleActionSettings
  :cognitect.aws.medialive/ScheduleActionSettings)

(s/def
  :cognitect.aws.medialive.ScheduleAction/ScheduleActionStartSettings
  :cognitect.aws.medialive/ScheduleActionStartSettings)

(s/def
  :cognitect.aws.medialive.ListOfferingsResultModel/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListOfferingsResultModel/Offerings
  :cognitect.aws.medialive/__listOfOffering)

(s/def :cognitect.aws.medialive.UpdateReservation/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateReservation/RenewalSettings
  :cognitect.aws.medialive/RenewalSettings)

(s/def
  :cognitect.aws.medialive.InputDestinationRequest/StreamName
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDestinationRequest/Network :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDestinationRequest/NetworkRoutes
  :cognitect.aws.medialive/__listOfInputRequestDestinationRoute)

(s/def
  :cognitect.aws.medialive.InputDestinationRequest/StaticIpAddress
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateMultiplexResultModel/Multiplex
  :cognitect.aws.medialive/Multiplex)

(s/def
  :cognitect.aws.medialive.HlsOutputSettings/H265PackagingType
  :cognitect.aws.medialive/HlsH265PackagingType)

(s/def :cognitect.aws.medialive.HlsOutputSettings/HlsSettings :cognitect.aws.medialive/HlsSettings)

(s/def
  :cognitect.aws.medialive.HlsOutputSettings/NameModifier
  :cognitect.aws.medialive/__stringMin1)

(s/def :cognitect.aws.medialive.HlsOutputSettings/SegmentModifier :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListChannelPlacementGroupsResult/ChannelPlacementGroups
  :cognitect.aws.medialive/__listOfDescribeChannelPlacementGroupSummary)

(s/def
  :cognitect.aws.medialive.ListChannelPlacementGroupsResult/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ChannelConfigurationValidationError/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ChannelConfigurationValidationError/ValidationErrors
  :cognitect.aws.medialive/__listOfValidationError)

(s/def :cognitect.aws.medialive.ResourceNotFound/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/GroupIdentifier
  :cognitect.aws.medialive/__stringPatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateRequest/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def
  :cognitect.aws.medialive.MediaResource/Destinations
  :cognitect.aws.medialive/__listOfMediaResourceNeighbor)

(s/def :cognitect.aws.medialive.MediaResource/Name :cognitect.aws.medialive/__stringMin1Max256)

(s/def
  :cognitect.aws.medialive.MediaResource/Sources
  :cognitect.aws.medialive/__listOfMediaResourceNeighbor)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/CloudWatchAlarmTemplateGroupIdentifiers
  :cognitect.aws.medialive/__listOf__stringPatternS)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/EventBridgeRuleTemplateGroupIdentifiers
  :cognitect.aws.medialive/__listOf__stringPatternS)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/ForceRediscovery
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapRequestContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.MulticastSettings/Sources
  :cognitect.aws.medialive/__listOfMulticastSource)

(s/def :cognitect.aws.medialive.ListInputsResponse/Inputs :cognitect.aws.medialive/__listOfInput)

(s/def :cognitect.aws.medialive.ListInputsResponse/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsRequest/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplateGroupsRequest/SignalMapIdentifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DvbSubSourceSettings/OcrLanguage
  :cognitect.aws.medialive/DvbSubOcrLanguage)

(s/def :cognitect.aws.medialive.DvbSubSourceSettings/Pid :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexRequest/MultiplexId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateInputSecurityGroupResultModel/SecurityGroup
  :cognitect.aws.medialive/InputSecurityGroup)

(s/def
  :cognitect.aws.medialive.MulticastInputSettings/SourceIpAddress
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListMultiplexesResultModel/Multiplexes
  :cognitect.aws.medialive/__listOfMultiplexSummary)

(s/def
  :cognitect.aws.medialive.ListMultiplexesResultModel/NextToken
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ColorCorrection/InputColorSpace :cognitect.aws.medialive/ColorSpace)

(s/def
  :cognitect.aws.medialive.ColorCorrection/OutputColorSpace
  :cognitect.aws.medialive/ColorSpace)

(s/def :cognitect.aws.medialive.ColorCorrection/Uri :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateSdiSourceRequest/Mode :cognitect.aws.medialive/SdiSourceMode)

(s/def :cognitect.aws.medialive.CreateSdiSourceRequest/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateSdiSourceRequest/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateSdiSourceRequest/Tags :cognitect.aws.medialive/Tags)

(s/def :cognitect.aws.medialive.CreateSdiSourceRequest/Type :cognitect.aws.medialive/SdiSourceType)

(s/def
  :cognitect.aws.medialive.CmafIngestCaptionLanguageMapping/CaptionChannel
  :cognitect.aws.medialive/__integerMin1Max4)

(s/def
  :cognitect.aws.medialive.CmafIngestCaptionLanguageMapping/LanguageCode
  :cognitect.aws.medialive/__stringMin3Max3)

(s/def
  :cognitect.aws.medialive.BatchStartResultModel/Failed
  :cognitect.aws.medialive/__listOfBatchFailedResultModel)

(s/def
  :cognitect.aws.medialive.BatchStartResultModel/Successful
  :cognitect.aws.medialive/__listOfBatchSuccessfulResultModel)

(s/def :cognitect.aws.medialive.UpdateNetworkResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateNetworkResponse/AssociatedClusterIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.UpdateNetworkResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateNetworkResponse/IpPools
  :cognitect.aws.medialive/__listOfIpPool)

(s/def :cognitect.aws.medialive.UpdateNetworkResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNetworkResponse/Routes :cognitect.aws.medialive/__listOfRoute)

(s/def :cognitect.aws.medialive.UpdateNetworkResponse/State :cognitect.aws.medialive/NetworkState)

(s/def
  :cognitect.aws.medialive.DeleteMultiplexRequest/MultiplexId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.H265Settings/GopSize :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.H265Settings/TimecodeBurninSettings
  :cognitect.aws.medialive/TimecodeBurninSettings)

(s/def
  :cognitect.aws.medialive.H265Settings/AdaptiveQuantization
  :cognitect.aws.medialive/H265AdaptiveQuantization)

(s/def :cognitect.aws.medialive.H265Settings/ParNumerator :cognitect.aws.medialive/__integerMin1)

(s/def :cognitect.aws.medialive.H265Settings/Profile :cognitect.aws.medialive/H265Profile)

(s/def :cognitect.aws.medialive.H265Settings/ParDenominator :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.H265Settings/SceneChangeDetect
  :cognitect.aws.medialive/H265SceneChangeDetect)

(s/def :cognitect.aws.medialive.H265Settings/MinQp :cognitect.aws.medialive/__integerMin1Max51)

(s/def :cognitect.aws.medialive.H265Settings/FlickerAq :cognitect.aws.medialive/H265FlickerAq)

(s/def :cognitect.aws.medialive.H265Settings/FixedAfd :cognitect.aws.medialive/FixedAfd)

(s/def
  :cognitect.aws.medialive.H265Settings/MvTemporalPredictor
  :cognitect.aws.medialive/H265MvTemporalPredictor)

(s/def
  :cognitect.aws.medialive.H265Settings/MinIInterval
  :cognitect.aws.medialive/__integerMin0Max30)

(s/def
  :cognitect.aws.medialive.H265Settings/QvbrQualityLevel
  :cognitect.aws.medialive/__integerMin1Max10)

(s/def :cognitect.aws.medialive.H265Settings/Tier :cognitect.aws.medialive/H265Tier)

(s/def
  :cognitect.aws.medialive.H265Settings/ColorMetadata
  :cognitect.aws.medialive/H265ColorMetadata)

(s/def
  :cognitect.aws.medialive.H265Settings/FramerateNumerator
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.H265Settings/RateControlMode
  :cognitect.aws.medialive/H265RateControlMode)

(s/def :cognitect.aws.medialive.H265Settings/ScanType :cognitect.aws.medialive/H265ScanType)

(s/def
  :cognitect.aws.medialive.H265Settings/Bitrate
  :cognitect.aws.medialive/__integerMin100000Max40000000)

(s/def
  :cognitect.aws.medialive.H265Settings/AlternativeTransferFunction
  :cognitect.aws.medialive/H265AlternativeTransferFunction)

(s/def
  :cognitect.aws.medialive.H265Settings/ColorSpaceSettings
  :cognitect.aws.medialive/H265ColorSpaceSettings)

(s/def
  :cognitect.aws.medialive.H265Settings/TimecodeInsertion
  :cognitect.aws.medialive/H265TimecodeInsertionBehavior)

(s/def :cognitect.aws.medialive.H265Settings/TilePadding :cognitect.aws.medialive/H265TilePadding)

(s/def
  :cognitect.aws.medialive.H265Settings/TreeblockSize
  :cognitect.aws.medialive/H265TreeblockSize)

(s/def :cognitect.aws.medialive.H265Settings/Level :cognitect.aws.medialive/H265Level)

(s/def
  :cognitect.aws.medialive.H265Settings/TileHeight
  :cognitect.aws.medialive/__integerMin64Max2160)

(s/def
  :cognitect.aws.medialive.H265Settings/TileWidth
  :cognitect.aws.medialive/__integerMin256Max3840)

(s/def :cognitect.aws.medialive.H265Settings/GopSizeUnits :cognitect.aws.medialive/H265GopSizeUnits)

(s/def
  :cognitect.aws.medialive.H265Settings/MaxBitrate
  :cognitect.aws.medialive/__integerMin100000Max40000000)

(s/def
  :cognitect.aws.medialive.H265Settings/FramerateDenominator
  :cognitect.aws.medialive/__integerMin1Max3003)

(s/def :cognitect.aws.medialive.H265Settings/Slices :cognitect.aws.medialive/__integerMin1Max16)

(s/def
  :cognitect.aws.medialive.H265Settings/LookAheadRateControl
  :cognitect.aws.medialive/H265LookAheadRateControl)

(s/def
  :cognitect.aws.medialive.H265Settings/FilterSettings
  :cognitect.aws.medialive/H265FilterSettings)

(s/def
  :cognitect.aws.medialive.H265Settings/GopClosedCadence
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.H265Settings/AfdSignaling :cognitect.aws.medialive/AfdSignaling)

(s/def :cognitect.aws.medialive.H265Settings/Deblocking :cognitect.aws.medialive/H265Deblocking)

(s/def
  :cognitect.aws.medialive.H265Settings/BufSize
  :cognitect.aws.medialive/__integerMin100000Max80000000)

(s/def
  :cognitect.aws.medialive.H265Settings/MvOverPictureBoundaries
  :cognitect.aws.medialive/H265MvOverPictureBoundaries)

(s/def
  :cognitect.aws.medialive.CreateInputSecurityGroupResponse/SecurityGroup
  :cognitect.aws.medialive/InputSecurityGroup)

(s/def
  :cognitect.aws.medialive.ListMultiplexesRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListMultiplexesRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplateGroup)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def :cognitect.aws.medialive.DescribeScheduleRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeScheduleRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.DescribeScheduleRequest/NextToken :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateReservationRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateReservationRequest/RenewalSettings
  :cognitect.aws.medialive/RenewalSettings)

(s/def
  :cognitect.aws.medialive.UpdateReservationRequest/ReservationId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteReservationRequest/ReservationId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Arn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Channels
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Id
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/Nodes
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelPlacementGroupResponse/State
  :cognitect.aws.medialive/ChannelPlacementGroupState)

(s/def
  :cognitect.aws.medialive.UdpOutputSettings/BufferMsec
  :cognitect.aws.medialive/__integerMin0Max10000)

(s/def
  :cognitect.aws.medialive.UdpOutputSettings/ContainerSettings
  :cognitect.aws.medialive/UdpContainerSettings)

(s/def
  :cognitect.aws.medialive.UdpOutputSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.UdpOutputSettings/FecOutputSettings
  :cognitect.aws.medialive/FecOutputSettings)

(s/def
  :cognitect.aws.medialive.AudioDolbyEDecode/ProgramSelection
  :cognitect.aws.medialive/DolbyEProgramSelection)

(s/def
  :cognitect.aws.medialive.H265ColorSpaceSettings/ColorSpacePassthroughSettings
  :cognitect.aws.medialive/ColorSpacePassthroughSettings)

(s/def
  :cognitect.aws.medialive.H265ColorSpaceSettings/DolbyVision81Settings
  :cognitect.aws.medialive/DolbyVision81Settings)

(s/def
  :cognitect.aws.medialive.H265ColorSpaceSettings/Hdr10Settings
  :cognitect.aws.medialive/Hdr10Settings)

(s/def
  :cognitect.aws.medialive.H265ColorSpaceSettings/Rec601Settings
  :cognitect.aws.medialive/Rec601Settings)

(s/def
  :cognitect.aws.medialive.H265ColorSpaceSettings/Rec709Settings
  :cognitect.aws.medialive/Rec709Settings)

(s/def :cognitect.aws.medialive.IpPool/Cidr :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/AribDestinationSettings
  :cognitect.aws.medialive/AribDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/EmbeddedDestinationSettings
  :cognitect.aws.medialive/EmbeddedDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/DvbSubDestinationSettings
  :cognitect.aws.medialive/DvbSubDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/BurnInDestinationSettings
  :cognitect.aws.medialive/BurnInDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/EbuTtDDestinationSettings
  :cognitect.aws.medialive/EbuTtDDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/TeletextDestinationSettings
  :cognitect.aws.medialive/TeletextDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/SmpteTtDestinationSettings
  :cognitect.aws.medialive/SmpteTtDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/WebvttDestinationSettings
  :cognitect.aws.medialive/WebvttDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/Scte20PlusEmbeddedDestinationSettings
  :cognitect.aws.medialive/Scte20PlusEmbeddedDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/TtmlDestinationSettings
  :cognitect.aws.medialive/TtmlDestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/EmbeddedPlusScte20DestinationSettings
  :cognitect.aws.medialive/EmbeddedPlusScte20DestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/Scte27DestinationSettings
  :cognitect.aws.medialive/Scte27DestinationSettings)

(s/def
  :cognitect.aws.medialive.CaptionDestinationSettings/RtmpCaptionInfoDestinationSettings
  :cognitect.aws.medialive/RtmpCaptionInfoDestinationSettings)

(s/def :cognitect.aws.medialive.InvalidRequest/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StopTimecode/LastFrameClippingBehavior
  :cognitect.aws.medialive/LastFrameClippingBehavior)

(s/def :cognitect.aws.medialive.StopTimecode/Timecode :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.AccessDenied/Message :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.MultiplexProgramSummary/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexProgramSummary/ProgramName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UdpGroupSettings/InputLossAction
  :cognitect.aws.medialive/InputLossActionForUdpOut)

(s/def
  :cognitect.aws.medialive.UdpGroupSettings/TimedMetadataId3Frame
  :cognitect.aws.medialive/UdpTimedMetadataId3Frame)

(s/def
  :cognitect.aws.medialive.UdpGroupSettings/TimedMetadataId3Period
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.CreateChannelRequest/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.CreateChannelRequest/Reserved :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateChannelRequest/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def :cognitect.aws.medialive.CreateChannelRequest/DryRun :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/ChannelClass
  :cognitect.aws.medialive/ChannelClass)

(s/def :cognitect.aws.medialive.CreateChannelRequest/Vpc :cognitect.aws.medialive/VpcOutputSettings)

(s/def :cognitect.aws.medialive.CreateChannelRequest/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateChannelRequest/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateChannelRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/AnywhereSettings
  :cognitect.aws.medialive/AnywhereSettings)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/Maintenance
  :cognitect.aws.medialive/MaintenanceCreateSettings)

(s/def
  :cognitect.aws.medialive.CreateChannelRequest/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionRequest)

(s/def
  :cognitect.aws.medialive.MediaResourceNeighbor/Arn
  :cognitect.aws.medialive/__stringMin1Max2048PatternArn)

(s/def
  :cognitect.aws.medialive.MediaResourceNeighbor/Name
  :cognitect.aws.medialive/__stringMin1Max256)

(s/def :cognitect.aws.medialive.IpPoolUpdateRequest/Cidr :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceRequest/HdDeviceSettings
  :cognitect.aws.medialive/InputDeviceConfigurableSettings)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateInputDeviceRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceRequest/UhdDeviceSettings
  :cognitect.aws.medialive/InputDeviceConfigurableSettings)

(s/def
  :cognitect.aws.medialive.UpdateInputDeviceRequest/AvailabilityZone
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/GroupIdentifier
  :cognitect.aws.medialive/__stringPatternS)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateRequestContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def :cognitect.aws.medialive.RouteCreateRequest/Cidr :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.RouteCreateRequest/Gateway :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequestContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequestContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateGroupRequestContent/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def
  :cognitect.aws.medialive.MediaPackageGroupSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def :cognitect.aws.medialive.Mpeg2Settings/GopSize :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/DisplayAspectRatio
  :cognitect.aws.medialive/Mpeg2DisplayRatio)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/GopNumBFrames
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/TimecodeBurninSettings
  :cognitect.aws.medialive/TimecodeBurninSettings)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/AdaptiveQuantization
  :cognitect.aws.medialive/Mpeg2AdaptiveQuantization)

(s/def :cognitect.aws.medialive.Mpeg2Settings/FixedAfd :cognitect.aws.medialive/FixedAfd)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/ColorMetadata
  :cognitect.aws.medialive/Mpeg2ColorMetadata)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/FramerateNumerator
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/SubgopLength
  :cognitect.aws.medialive/Mpeg2SubGopLength)

(s/def :cognitect.aws.medialive.Mpeg2Settings/ScanType :cognitect.aws.medialive/Mpeg2ScanType)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/TimecodeInsertion
  :cognitect.aws.medialive/Mpeg2TimecodeInsertionBehavior)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/GopSizeUnits
  :cognitect.aws.medialive/Mpeg2GopSizeUnits)

(s/def :cognitect.aws.medialive.Mpeg2Settings/ColorSpace :cognitect.aws.medialive/Mpeg2ColorSpace)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/FramerateDenominator
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/FilterSettings
  :cognitect.aws.medialive/Mpeg2FilterSettings)

(s/def
  :cognitect.aws.medialive.Mpeg2Settings/GopClosedCadence
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.Mpeg2Settings/AfdSignaling :cognitect.aws.medialive/AfdSignaling)

(s/def :cognitect.aws.medialive.InputWhitelistRuleCidr/Cidr :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AdditionalDestinations/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def :cognitect.aws.medialive.MulticastSource/SourceIp :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.MulticastSource/Url :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/AncillarySourceSettings
  :cognitect.aws.medialive/AncillarySourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/AribSourceSettings
  :cognitect.aws.medialive/AribSourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/DvbSubSourceSettings
  :cognitect.aws.medialive/DvbSubSourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/EmbeddedSourceSettings
  :cognitect.aws.medialive/EmbeddedSourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/Scte20SourceSettings
  :cognitect.aws.medialive/Scte20SourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/Scte27SourceSettings
  :cognitect.aws.medialive/Scte27SourceSettings)

(s/def
  :cognitect.aws.medialive.CaptionSelectorSettings/TeletextSourceSettings
  :cognitect.aws.medialive/TeletextSourceSettings)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplate)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateResponse/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def
  :cognitect.aws.medialive.DescribeScheduleResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeScheduleResponse/ScheduleActions
  :cognitect.aws.medialive/__listOfScheduleAction)

(s/def
  :cognitect.aws.medialive.FailoverCondition/FailoverConditionSettings
  :cognitect.aws.medialive/FailoverConditionSettings)

(s/def :cognitect.aws.medialive.ThumbnailDetail/PipelineId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ThumbnailDetail/Thumbnails
  :cognitect.aws.medialive/__listOfThumbnail)

(s/def
  :cognitect.aws.medialive.DescribeReservationRequest/ReservationId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexConfigurationValidationError/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexConfigurationValidationError/ValidationErrors
  :cognitect.aws.medialive/__listOfValidationError)

(s/def :cognitect.aws.medialive.UpdateClusterResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateClusterResponse/ChannelIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.UpdateClusterResponse/ClusterType
  :cognitect.aws.medialive/ClusterType)

(s/def :cognitect.aws.medialive.UpdateClusterResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateClusterResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateClusterResponse/NetworkSettings
  :cognitect.aws.medialive/ClusterNetworkSettings)

(s/def :cognitect.aws.medialive.UpdateClusterResponse/State :cognitect.aws.medialive/ClusterState)

(s/def
  :cognitect.aws.medialive.H264ColorSpaceSettings/ColorSpacePassthroughSettings
  :cognitect.aws.medialive/ColorSpacePassthroughSettings)

(s/def
  :cognitect.aws.medialive.H264ColorSpaceSettings/Rec601Settings
  :cognitect.aws.medialive/Rec601Settings)

(s/def
  :cognitect.aws.medialive.H264ColorSpaceSettings/Rec709Settings
  :cognitect.aws.medialive/Rec709Settings)

(s/def
  :cognitect.aws.medialive.OutputLocationRef/DestinationRefId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ForbiddenExceptionResponseContent/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.TtmlDestinationSettings/StyleControl
  :cognitect.aws.medialive/TtmlDestinationStyleControl)

(s/def
  :cognitect.aws.medialive.Scte35DescriptorSettings/SegmentationDescriptorScte35DescriptorSettings
  :cognitect.aws.medialive/Scte35SegmentationDescriptor)

(s/def
  :cognitect.aws.medialive.AudioSilenceFailoverSettings/AudioSelectorName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioSilenceFailoverSettings/AudioSilenceThresholdMsec
  :cognitect.aws.medialive/__integerMin1000)

(s/def
  :cognitect.aws.medialive.NielsenWatermarksSettings/NielsenCbetSettings
  :cognitect.aws.medialive/NielsenCBET)

(s/def
  :cognitect.aws.medialive.NielsenWatermarksSettings/NielsenDistributionType
  :cognitect.aws.medialive/NielsenWatermarksDistributionTypes)

(s/def
  :cognitect.aws.medialive.NielsenWatermarksSettings/NielsenNaesIiNwSettings
  :cognitect.aws.medialive/NielsenNaesIiNw)

(s/def
  :cognitect.aws.medialive.VpcOutputSettings/PublicAddressAllocationIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.VpcOutputSettings/SecurityGroupIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.VpcOutputSettings/SubnetIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.AnywhereSettings/ChannelPlacementGroupId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.AnywhereSettings/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateNetworkResponse/Arn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNetworkResponse/AssociatedClusterIds
  :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.CreateNetworkResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNetworkResponse/IpPools
  :cognitect.aws.medialive/__listOfIpPool)

(s/def :cognitect.aws.medialive.CreateNetworkResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateNetworkResponse/Routes :cognitect.aws.medialive/__listOfRoute)

(s/def :cognitect.aws.medialive.CreateNetworkResponse/State :cognitect.aws.medialive/NetworkState)

(s/def
  :cognitect.aws.medialive.ConflictExceptionResponseContent/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.NodeInterfaceMapping/LogicalInterfaceName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.NodeInterfaceMapping/NetworkInterfaceMode
  :cognitect.aws.medialive/NetworkInterfaceMode)

(s/def
  :cognitect.aws.medialive.NodeInterfaceMapping/PhysicalInterfaceName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInput/Sources
  :cognitect.aws.medialive/__listOfInputSourceRequest)

(s/def :cognitect.aws.medialive.UpdateInput/SdiSources :cognitect.aws.medialive/InputSdiSources)

(s/def :cognitect.aws.medialive.UpdateInput/SrtSettings :cognitect.aws.medialive/SrtSettingsRequest)

(s/def
  :cognitect.aws.medialive.UpdateInput/MediaConnectFlows
  :cognitect.aws.medialive/__listOfMediaConnectFlowRequest)

(s/def
  :cognitect.aws.medialive.UpdateInput/Smpte2110ReceiverGroupSettings
  :cognitect.aws.medialive/Smpte2110ReceiverGroupSettings)

(s/def
  :cognitect.aws.medialive.UpdateInput/InputSecurityGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.UpdateInput/Destinations
  :cognitect.aws.medialive/__listOfInputDestinationRequest)

(s/def :cognitect.aws.medialive.UpdateInput/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInput/MulticastSettings
  :cognitect.aws.medialive/MulticastSettingsUpdateRequest)

(s/def :cognitect.aws.medialive.UpdateInput/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInput/InputDevices
  :cognitect.aws.medialive/__listOfInputDeviceRequest)

(s/def
  :cognitect.aws.medialive.InputSwitchScheduleActionSettings/InputAttachmentNameReference
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputSwitchScheduleActionSettings/InputClippingSettings
  :cognitect.aws.medialive/InputClippingSettings)

(s/def
  :cognitect.aws.medialive.InputSwitchScheduleActionSettings/UrlPath
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.ListInputDevicesResultModel/InputDevices
  :cognitect.aws.medialive/__listOfInputDeviceSummary)

(s/def
  :cognitect.aws.medialive.ListInputDevicesResultModel/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNodeResponse/NodeInterfaceMappings
  :cognitect.aws.medialive/__listOfNodeInterfaceMapping)

(s/def :cognitect.aws.medialive.DescribeNodeResponse/InstanceArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeResponse/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNodeResponse/ChannelPlacementGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeNodeResponse/SdiSourceMappings
  :cognitect.aws.medialive/SdiSourceMappings)

(s/def
  :cognitect.aws.medialive.DescribeNodeResponse/ConnectionState
  :cognitect.aws.medialive/NodeConnectionState)

(s/def :cognitect.aws.medialive.DescribeNodeResponse/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeResponse/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeResponse/State :cognitect.aws.medialive/NodeState)

(s/def :cognitect.aws.medialive.DescribeNodeResponse/Role :cognitect.aws.medialive/NodeRole)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurableAudioChannelPairConfig/Id
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.InputDeviceConfigurableAudioChannelPairConfig/Profile
  :cognitect.aws.medialive/InputDeviceConfigurableAudioChannelPairProfile)

(s/def
  :cognitect.aws.medialive.Offering/DurationUnits
  :cognitect.aws.medialive/OfferingDurationUnits)

(s/def :cognitect.aws.medialive.Offering/CurrencyCode :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/FixedPrice :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.Offering/ResourceSpecification
  :cognitect.aws.medialive/ReservationResourceSpecification)

(s/def :cognitect.aws.medialive.Offering/Region :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/OfferingDescription :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/Duration :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.Offering/UsagePrice :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Offering/OfferingId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.Offering/OfferingType :cognitect.aws.medialive/OfferingType)

(s/def
  :cognitect.aws.medialive.MotionGraphicsActivateScheduleActionSettings/Duration
  :cognitect.aws.medialive/__longMin0Max86400000)

(s/def
  :cognitect.aws.medialive.MotionGraphicsActivateScheduleActionSettings/PasswordParam
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MotionGraphicsActivateScheduleActionSettings/Url
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MotionGraphicsActivateScheduleActionSettings/Username
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListSignalMapsResponseContent/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.ListSignalMapsResponseContent/SignalMaps
  :cognitect.aws.medialive/__listOfSignalMapSummary)

(s/def
  :cognitect.aws.medialive.VideoSelectorSettings/VideoSelectorPid
  :cognitect.aws.medialive/VideoSelectorPid)

(s/def
  :cognitect.aws.medialive.VideoSelectorSettings/VideoSelectorProgramId
  :cognitect.aws.medialive/VideoSelectorProgramId)

(s/def :cognitect.aws.medialive.DescribeInputRequest/InputId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.SrtOutputDestinationSettings/EncryptionPassphraseSecretArn
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.SrtOutputDestinationSettings/StreamId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SrtOutputDestinationSettings/Url :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteSdiSourceResponse/SdiSource
  :cognitect.aws.medialive/SdiSource)

(s/def :cognitect.aws.medialive.MultiplexProgram/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexProgram/MultiplexProgramSettings
  :cognitect.aws.medialive/MultiplexProgramSettings)

(s/def
  :cognitect.aws.medialive.MultiplexProgram/PacketIdentifiersMap
  :cognitect.aws.medialive/MultiplexProgramPacketIdentifiersMap)

(s/def
  :cognitect.aws.medialive.MultiplexProgram/PipelineDetails
  :cognitect.aws.medialive/__listOfMultiplexProgramPipelineDetail)

(s/def :cognitect.aws.medialive.MultiplexProgram/ProgramName :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def :cognitect.aws.medialive.GetSignalMapResponseContent/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.GetSignalMapResponseContent/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexResponse/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettings)

(s/def :cognitect.aws.medialive.DescribeMultiplexResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeMultiplexResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexResponse/Destinations
  :cognitect.aws.medialive/__listOfMultiplexOutputDestination)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexResponse/AvailabilityZones
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.DescribeMultiplexResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeMultiplexResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexResponse/State
  :cognitect.aws.medialive/MultiplexState)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexResponse/ProgramCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.StartMonitorDeploymentResponseContent/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def :cognitect.aws.medialive.SdiSourceSummary/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SdiSourceSummary/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SdiSourceSummary/Inputs :cognitect.aws.medialive/__listOf__string)

(s/def :cognitect.aws.medialive.SdiSourceSummary/Mode :cognitect.aws.medialive/SdiSourceMode)

(s/def :cognitect.aws.medialive.SdiSourceSummary/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.SdiSourceSummary/State :cognitect.aws.medialive/SdiSourceState)

(s/def :cognitect.aws.medialive.SdiSourceSummary/Type :cognitect.aws.medialive/SdiSourceType)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupRequest/ChannelPlacementGroupId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupRequest/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupRequest/Name
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelPlacementGroupRequest/Nodes
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.AudioNormalizationSettings/Algorithm
  :cognitect.aws.medialive/AudioNormalizationAlgorithm)

(s/def
  :cognitect.aws.medialive.AudioNormalizationSettings/AlgorithmControl
  :cognitect.aws.medialive/AudioNormalizationAlgorithmControl)

(s/def
  :cognitect.aws.medialive.AudioNormalizationSettings/TargetLkfs
  :cognitect.aws.medialive/__doubleMinNegative59Max0)

(s/def
  :cognitect.aws.medialive.MultiplexOutputSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.MultiplexOutputSettings/ContainerSettings
  :cognitect.aws.medialive/MultiplexContainerSettings)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplateGroup)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.EventBridgeRuleTemplateGroupSummary/TemplateCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.ThumbnailConfiguration/State
  :cognitect.aws.medialive/ThumbnailState)

(s/def
  :cognitect.aws.medialive.NielsenCBET/CbetCheckDigitString
  :cognitect.aws.medialive/__stringMin2Max2)

(s/def
  :cognitect.aws.medialive.NielsenCBET/CbetStepaside
  :cognitect.aws.medialive/NielsenWatermarksCbetStepaside)

(s/def :cognitect.aws.medialive.NielsenCBET/Csid :cognitect.aws.medialive/__stringMin1Max7)

(s/def
  :cognitect.aws.medialive.Scte35InputScheduleActionSettings/InputAttachmentNameReference
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35InputScheduleActionSettings/Mode
  :cognitect.aws.medialive/Scte35InputMode)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/AdMarkers
  :cognitect.aws.medialive/__listOfRtmpAdMarkers)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/AuthenticationScheme
  :cognitect.aws.medialive/AuthenticationScheme)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/CacheFullBehavior
  :cognitect.aws.medialive/RtmpCacheFullBehavior)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/CacheLength
  :cognitect.aws.medialive/__integerMin30)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/CaptionData
  :cognitect.aws.medialive/RtmpCaptionData)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/InputLossAction
  :cognitect.aws.medialive/InputLossActionForRtmpOut)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.RtmpGroupSettings/IncludeFillerNalUnits
  :cognitect.aws.medialive/IncludeFillerNalUnits)

(s/def
  :cognitect.aws.medialive.RtmpOutputSettings/CertificateMode
  :cognitect.aws.medialive/RtmpOutputCertificateMode)

(s/def
  :cognitect.aws.medialive.RtmpOutputSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.RtmpOutputSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.RtmpOutputSettings/NumRetries
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageOutputDeactivateScheduleActionSettings/FadeOut
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.StaticImageOutputDeactivateScheduleActionSettings/Layer
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def
  :cognitect.aws.medialive.StaticImageOutputDeactivateScheduleActionSettings/OutputNames
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.TemporalFilterSettings/PostFilterSharpening
  :cognitect.aws.medialive/TemporalFilterPostFilterSharpening)

(s/def
  :cognitect.aws.medialive.TemporalFilterSettings/Strength
  :cognitect.aws.medialive/TemporalFilterStrength)

(s/def
  :cognitect.aws.medialive.DescribeThumbnailsResponse/ThumbnailDetails
  :cognitect.aws.medialive/__listOfThumbnailDetail)

(s/def :cognitect.aws.medialive.UpdateChannelRequest/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def :cognitect.aws.medialive.UpdateChannelRequest/DryRun :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def :cognitect.aws.medialive.UpdateChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def :cognitect.aws.medialive.UpdateChannelRequest/RoleArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateChannelRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/AnywhereSettings
  :cognitect.aws.medialive/AnywhereSettings)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/Maintenance
  :cognitect.aws.medialive/MaintenanceUpdateSettings)

(s/def
  :cognitect.aws.medialive.UpdateChannelRequest/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionRequest)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexProgram/MultiplexProgramSettings
  :cognitect.aws.medialive/MultiplexProgramSettings)

(s/def
  :cognitect.aws.medialive.DeleteChannelPlacementGroupRequest/ChannelPlacementGroupId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DeleteChannelPlacementGroupRequest/ClusterId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.BandwidthReductionFilterSettings/PostFilterSharpening
  :cognitect.aws.medialive/BandwidthReductionPostFilterSharpening)

(s/def
  :cognitect.aws.medialive.BandwidthReductionFilterSettings/Strength
  :cognitect.aws.medialive/BandwidthReductionFilterStrength)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplatesResponseContent/EventBridgeRuleTemplates
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateSummary)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplatesResponseContent/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.DescribeOfferingRequest/OfferingId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AvailConfiguration/AvailSettings
  :cognitect.aws.medialive/AvailSettings)

(s/def
  :cognitect.aws.medialive.AvailConfiguration/Scte35SegmentationScope
  :cognitect.aws.medialive/Scte35SegmentationScope)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsResponse/CloudWatchAlarmTemplateGroups
  :cognitect.aws.medialive/__listOfCloudWatchAlarmTemplateGroupSummary)

(s/def
  :cognitect.aws.medialive.ListCloudWatchAlarmTemplateGroupsResponse/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def :cognitect.aws.medialive.ListClustersRequest/MaxResults :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListClustersRequest/NextToken :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ListInputsRequest/MaxResults :cognitect.aws.medialive/MaxResults)

(s/def :cognitect.aws.medialive.ListInputsRequest/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListMultiplexProgramsResponse/MultiplexPrograms
  :cognitect.aws.medialive/__listOfMultiplexProgramSummary)

(s/def
  :cognitect.aws.medialive.ListMultiplexProgramsResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreatePartnerInputResultModel/Input :cognitect.aws.medialive/Input)

(s/def :cognitect.aws.medialive.BatchFailedResultModel/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.BatchFailedResultModel/Code :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.BatchFailedResultModel/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.BatchFailedResultModel/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Scte35ReturnToNetworkScheduleActionSettings/SpliceEventId
  :cognitect.aws.medialive/__longMin0Max4294967295)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleResponse/Creates
  :cognitect.aws.medialive/BatchScheduleActionCreateResult)

(s/def
  :cognitect.aws.medialive.BatchUpdateScheduleResponse/Deletes
  :cognitect.aws.medialive/BatchScheduleActionDeleteResult)

(s/def :cognitect.aws.medialive.HlsS3Settings/CannedAcl :cognitect.aws.medialive/S3CannedAcl)

(s/def
  :cognitect.aws.medialive.NielsenNaesIiNw/CheckDigitString
  :cognitect.aws.medialive/__stringMin2Max2)

(s/def :cognitect.aws.medialive.NielsenNaesIiNw/Sid :cognitect.aws.medialive/__doubleMin1Max65535)

(s/def
  :cognitect.aws.medialive.NielsenNaesIiNw/Timezone
  :cognitect.aws.medialive/NielsenWatermarkTimezones)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexProgramRequest/MultiplexId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexProgramRequest/MultiplexProgramSettings
  :cognitect.aws.medialive/MultiplexProgramSettings)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexProgramRequest/ProgramName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplatesResponse/EventBridgeRuleTemplates
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateSummary)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplatesResponse/NextToken
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.CdiInputSpecification/Resolution
  :cognitect.aws.medialive/CdiInputResolution)

(s/def :cognitect.aws.medialive.CaptionRectangle/Height :cognitect.aws.medialive/__doubleMin0Max100)

(s/def
  :cognitect.aws.medialive.CaptionRectangle/LeftOffset
  :cognitect.aws.medialive/__doubleMin0Max100)

(s/def
  :cognitect.aws.medialive.CaptionRectangle/TopOffset
  :cognitect.aws.medialive/__doubleMin0Max100)

(s/def :cognitect.aws.medialive.CaptionRectangle/Width :cognitect.aws.medialive/__doubleMin0Max100)

(s/def
  :cognitect.aws.medialive.FailoverConditionSettings/AudioSilenceSettings
  :cognitect.aws.medialive/AudioSilenceFailoverSettings)

(s/def
  :cognitect.aws.medialive.FailoverConditionSettings/InputLossSettings
  :cognitect.aws.medialive/InputLossFailoverSettings)

(s/def
  :cognitect.aws.medialive.FailoverConditionSettings/VideoBlackSettings
  :cognitect.aws.medialive/VideoBlackFailoverSettings)

(s/def
  :cognitect.aws.medialive.CreateMultiplexProgramResponse/MultiplexProgram
  :cognitect.aws.medialive/MultiplexProgram)

(s/def
  :cognitect.aws.medialive.PipelineDetail/ActiveInputAttachmentName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.PipelineDetail/ActiveInputSwitchActionName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.PipelineDetail/ActiveMotionGraphicsActionName
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.PipelineDetail/ActiveMotionGraphicsUri
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.PipelineDetail/PipelineId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.PipelineDetail/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionResponse)

(s/def
  :cognitect.aws.medialive.NetworkInputSettings/HlsInputSettings
  :cognitect.aws.medialive/HlsInputSettings)

(s/def
  :cognitect.aws.medialive.NetworkInputSettings/ServerValidation
  :cognitect.aws.medialive/NetworkInputServerValidation)

(s/def
  :cognitect.aws.medialive.NetworkInputSettings/MulticastInputSettings
  :cognitect.aws.medialive/MulticastInputSettings)

(s/def
  :cognitect.aws.medialive.InputDeviceNetworkSettings/DnsAddresses
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.InputDeviceNetworkSettings/Gateway
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceNetworkSettings/IpAddress
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.InputDeviceNetworkSettings/IpScheme
  :cognitect.aws.medialive/InputDeviceIpScheme)

(s/def
  :cognitect.aws.medialive.InputDeviceNetworkSettings/SubnetMask
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioChannelMapping/InputChannelLevels
  :cognitect.aws.medialive/__listOfInputChannelLevel)

(s/def
  :cognitect.aws.medialive.AudioChannelMapping/OutputChannel
  :cognitect.aws.medialive/__integerMin0Max7)

(s/def :cognitect.aws.medialive.ListTagsForResourceResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.ListInputDeviceTransfersResponse/InputDeviceTransfers
  :cognitect.aws.medialive/__listOfTransferringInputDeviceSummary)

(s/def
  :cognitect.aws.medialive.ListInputDeviceTransfersResponse/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplatesRequest/GroupIdentifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplatesRequest/MaxResults
  :cognitect.aws.medialive/MaxResults)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplatesRequest/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListEventBridgeRuleTemplatesRequest/SignalMapIdentifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MotionGraphicsSettings/HtmlMotionGraphicsSettings
  :cognitect.aws.medialive/HtmlMotionGraphicsSettings)

(s/def :cognitect.aws.medialive.DescribeChannelRequest/ChannelId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPipelineDetail/ActiveChannelPipeline
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexProgramPipelineDetail/PipelineId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.VpcOutputSettingsDescription/AvailabilityZones
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.VpcOutputSettingsDescription/NetworkInterfaceIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.VpcOutputSettingsDescription/SecurityGroupIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.VpcOutputSettingsDescription/SubnetIds
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.SrtOutputSettings/BufferMsec
  :cognitect.aws.medialive/__integerMin0Max10000)

(s/def
  :cognitect.aws.medialive.SrtOutputSettings/ContainerSettings
  :cognitect.aws.medialive/UdpContainerSettings)

(s/def
  :cognitect.aws.medialive.SrtOutputSettings/Destination
  :cognitect.aws.medialive/OutputLocationRef)

(s/def
  :cognitect.aws.medialive.SrtOutputSettings/EncryptionType
  :cognitect.aws.medialive/SrtEncryptionType)

(s/def
  :cognitect.aws.medialive.SrtOutputSettings/Latency
  :cognitect.aws.medialive/__integerMin40Max16000)

(s/def :cognitect.aws.medialive.TransferringInputDeviceSummary/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.TransferringInputDeviceSummary/Message
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.TransferringInputDeviceSummary/TargetCustomerId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.TransferringInputDeviceSummary/TransferType
  :cognitect.aws.medialive/InputDeviceTransferType)

(s/def
  :cognitect.aws.medialive.PauseStateScheduleActionSettings/Pipelines
  :cognitect.aws.medialive/__listOfPipelinePauseStateSettings)

(s/def
  :cognitect.aws.medialive.InputDeviceHdSettings/ConfiguredInput
  :cognitect.aws.medialive/InputDeviceConfiguredInput)

(s/def
  :cognitect.aws.medialive.InputDeviceHdSettings/DeviceState
  :cognitect.aws.medialive/InputDeviceState)

(s/def
  :cognitect.aws.medialive.InputDeviceHdSettings/ScanType
  :cognitect.aws.medialive/InputDeviceScanType)

(s/def
  :cognitect.aws.medialive.InputDeviceHdSettings/ActiveInput
  :cognitect.aws.medialive/InputDeviceActiveInput)

(s/def :cognitect.aws.medialive.InputDeviceHdSettings/MaxBitrate :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.InputDeviceHdSettings/LatencyMs :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.InputDeviceHdSettings/Width :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.InputDeviceHdSettings/Framerate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.InputDeviceHdSettings/Height :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.BatchDeleteResponse/Failed
  :cognitect.aws.medialive/__listOfBatchFailedResultModel)

(s/def
  :cognitect.aws.medialive.BatchDeleteResponse/Successful
  :cognitect.aws.medialive/__listOfBatchSuccessfulResultModel)

(s/def :cognitect.aws.medialive.WavSettings/BitDepth :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.WavSettings/CodingMode :cognitect.aws.medialive/WavCodingMode)

(s/def :cognitect.aws.medialive.WavSettings/SampleRate :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.DescribeNodeResult/NodeInterfaceMappings
  :cognitect.aws.medialive/__listOfNodeInterfaceMapping)

(s/def :cognitect.aws.medialive.DescribeNodeResult/InstanceArn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeResult/Id :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeNodeResult/ChannelPlacementGroups
  :cognitect.aws.medialive/__listOf__string)

(s/def
  :cognitect.aws.medialive.DescribeNodeResult/SdiSourceMappings
  :cognitect.aws.medialive/SdiSourceMappings)

(s/def
  :cognitect.aws.medialive.DescribeNodeResult/ConnectionState
  :cognitect.aws.medialive/NodeConnectionState)

(s/def :cognitect.aws.medialive.DescribeNodeResult/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeResult/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeResult/Name :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeNodeResult/State :cognitect.aws.medialive/NodeState)

(s/def :cognitect.aws.medialive.DescribeNodeResult/Role :cognitect.aws.medialive/NodeRole)

(s/def
  :cognitect.aws.medialive.ListMultiplexesResponse/Multiplexes
  :cognitect.aws.medialive/__listOfMultiplexSummary)

(s/def :cognitect.aws.medialive.ListMultiplexesResponse/NextToken :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsResultModel/NextToken
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.ListReservationsResultModel/Reservations
  :cognitect.aws.medialive/__listOfReservation)

(s/def
  :cognitect.aws.medialive.InputSettings/FilterStrength
  :cognitect.aws.medialive/__integerMin1Max5)

(s/def
  :cognitect.aws.medialive.InputSettings/Smpte2038DataPreference
  :cognitect.aws.medialive/Smpte2038DataPreference)

(s/def
  :cognitect.aws.medialive.InputSettings/Scte35Pid
  :cognitect.aws.medialive/__integerMin32Max8191)

(s/def
  :cognitect.aws.medialive.InputSettings/DenoiseFilter
  :cognitect.aws.medialive/InputDenoiseFilter)

(s/def :cognitect.aws.medialive.InputSettings/VideoSelector :cognitect.aws.medialive/VideoSelector)

(s/def
  :cognitect.aws.medialive.InputSettings/CaptionSelectors
  :cognitect.aws.medialive/__listOfCaptionSelector)

(s/def
  :cognitect.aws.medialive.InputSettings/AudioSelectors
  :cognitect.aws.medialive/__listOfAudioSelector)

(s/def
  :cognitect.aws.medialive.InputSettings/DeblockFilter
  :cognitect.aws.medialive/InputDeblockFilter)

(s/def :cognitect.aws.medialive.InputSettings/InputFilter :cognitect.aws.medialive/InputFilter)

(s/def
  :cognitect.aws.medialive.InputSettings/SourceEndBehavior
  :cognitect.aws.medialive/InputSourceEndBehavior)

(s/def
  :cognitect.aws.medialive.InputSettings/NetworkInputSettings
  :cognitect.aws.medialive/NetworkInputSettings)

(s/def :cognitect.aws.medialive.TooManyRequestsException/Message :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0Max600)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/MediaStoreStorageClass
  :cognitect.aws.medialive/HlsMediaStoreStorageClass)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/NumRetries
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsMediaStoreSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplate)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetEventBridgeRuleTemplateResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateNodeRegistrationScriptResponse/NodeRegistrationScript
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/AbsentInputAudioBehavior
  :cognitect.aws.medialive/M2tsAbsentInputAudioBehavior)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/NielsenId3Behavior
  :cognitect.aws.medialive/M2tsNielsenId3Behavior)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/EsRateInPes
  :cognitect.aws.medialive/M2tsEsRateInPes)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/CcDescriptor
  :cognitect.aws.medialive/M2tsCcDescriptor)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/PcrControl
  :cognitect.aws.medialive/M2tsPcrControl)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/AudioBufferModel
  :cognitect.aws.medialive/M2tsAudioBufferModel)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/PcrPeriod
  :cognitect.aws.medialive/__integerMin0Max500)

(s/def :cognitect.aws.medialive.MultiplexM2tsSettings/Ebif :cognitect.aws.medialive/M2tsEbifControl)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/AudioStreamType
  :cognitect.aws.medialive/M2tsAudioStreamType)

(s/def :cognitect.aws.medialive.MultiplexM2tsSettings/Klv :cognitect.aws.medialive/M2tsKlv)

(s/def :cognitect.aws.medialive.MultiplexM2tsSettings/Arib :cognitect.aws.medialive/M2tsArib)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/Scte35Control
  :cognitect.aws.medialive/M2tsScte35Control)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/Scte35PrerollPullupMilliseconds
  :cognitect.aws.medialive/__doubleMin0Max5000)

(s/def
  :cognitect.aws.medialive.MultiplexM2tsSettings/AudioFramesPerPes
  :cognitect.aws.medialive/__integerMin0)

(s/def :cognitect.aws.medialive.Ac3Settings/Bitrate :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Ac3Settings/BitstreamMode :cognitect.aws.medialive/Ac3BitstreamMode)

(s/def :cognitect.aws.medialive.Ac3Settings/CodingMode :cognitect.aws.medialive/Ac3CodingMode)

(s/def :cognitect.aws.medialive.Ac3Settings/Dialnorm :cognitect.aws.medialive/__integerMin1Max31)

(s/def :cognitect.aws.medialive.Ac3Settings/DrcProfile :cognitect.aws.medialive/Ac3DrcProfile)

(s/def :cognitect.aws.medialive.Ac3Settings/LfeFilter :cognitect.aws.medialive/Ac3LfeFilter)

(s/def
  :cognitect.aws.medialive.Ac3Settings/MetadataControl
  :cognitect.aws.medialive/Ac3MetadataControl)

(s/def
  :cognitect.aws.medialive.Ac3Settings/AttenuationControl
  :cognitect.aws.medialive/Ac3AttenuationControl)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/FailedMediaResourceMap
  :cognitect.aws.medialive/FailedMediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/MediaResourceMap
  :cognitect.aws.medialive/MediaResourceMap)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/LastSuccessfulMonitorDeployment
  :cognitect.aws.medialive/SuccessfulMonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/MonitorChangesPendingDeployment
  :cognitect.aws.medialive/__boolean)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/ErrorMessage
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def :cognitect.aws.medialive.StartUpdateSignalMapResponse/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/MonitorDeployment
  :cognitect.aws.medialive/MonitorDeployment)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/CloudWatchAlarmTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/EventBridgeRuleTemplateGroupIds
  :cognitect.aws.medialive/__listOf__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/LastDiscoveredAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveSignalMap)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.StartUpdateSignalMapResponse/Status
  :cognitect.aws.medialive/SignalMapStatus)

(s/def :cognitect.aws.medialive.InputWhitelistRule/Cidr :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequestContent/CloudWatchAlarmTemplateGroupIdentifiers
  :cognitect.aws.medialive/__listOf__stringPatternS)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequestContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequestContent/DiscoveryEntryPointArn
  :cognitect.aws.medialive/__stringMin1Max2048)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequestContent/EventBridgeRuleTemplateGroupIdentifiers
  :cognitect.aws.medialive/__listOf__stringPatternS)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequestContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def :cognitect.aws.medialive.CreateSignalMapRequestContent/Tags :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateSignalMapRequestContent/RequestId
  :cognitect.aws.medialive/__stringMin1Max256PatternS)

(s/def
  :cognitect.aws.medialive.FecOutputSettings/ColumnDepth
  :cognitect.aws.medialive/__integerMin4Max20)

(s/def
  :cognitect.aws.medialive.FecOutputSettings/IncludeFec
  :cognitect.aws.medialive/FecOutputIncludeFec)

(s/def
  :cognitect.aws.medialive.FecOutputSettings/RowLength
  :cognitect.aws.medialive/__integerMin1Max20)

(s/def
  :cognitect.aws.medialive.DvbNitSettings/NetworkId
  :cognitect.aws.medialive/__integerMin0Max65536)

(s/def
  :cognitect.aws.medialive.DvbNitSettings/NetworkName
  :cognitect.aws.medialive/__stringMin1Max256)

(s/def
  :cognitect.aws.medialive.DvbNitSettings/RepInterval
  :cognitect.aws.medialive/__integerMin25Max10000)

(s/def :cognitect.aws.medialive.CreatePartnerInputRequest/InputId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreatePartnerInputRequest/RequestId
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreatePartnerInputRequest/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.UpdateMultiplexResponse/Multiplex
  :cognitect.aws.medialive/Multiplex)

(s/def :cognitect.aws.medialive.StopChannelResponse/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.StopChannelResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StopChannelResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/ChannelClass
  :cognitect.aws.medialive/ChannelClass)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/Vpc
  :cognitect.aws.medialive/VpcOutputSettingsDescription)

(s/def :cognitect.aws.medialive.StopChannelResponse/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/PipelineDetails
  :cognitect.aws.medialive/__listOfPipelineDetail)

(s/def :cognitect.aws.medialive.StopChannelResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.StopChannelResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.StopChannelResponse/State :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/AnywhereSettings
  :cognitect.aws.medialive/DescribeAnywhereSettings)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/Maintenance
  :cognitect.aws.medialive/MaintenanceStatus)

(s/def
  :cognitect.aws.medialive.StopChannelResponse/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionResponse)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/Body
  :cognitect.aws.medialive/InputDeviceThumbnail)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/ContentType
  :cognitect.aws.medialive/ContentType)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/ContentLength
  :cognitect.aws.medialive/__long)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/ETag
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeInputDeviceThumbnailResponse/LastModified
  :cognitect.aws.medialive/__timestamp)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/EventType
  :cognitect.aws.medialive/EventBridgeRuleTemplateEventType)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/EventTargets
  :cognitect.aws.medialive/__listOfEventBridgeRuleTemplateTarget)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveEventbridgeRuleTemplate)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.CreateEventBridgeRuleTemplateResponseContent/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.DeleteInputSecurityGroupRequest/InputSecurityGroupId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioLanguageSelection/LanguageCode
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.AudioLanguageSelection/LanguageSelectionPolicy
  :cognitect.aws.medialive/AudioLanguageSelectionPolicy)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/CreatedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/EvaluationPeriods
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Statistic
  :cognitect.aws.medialive/CloudWatchAlarmTemplateStatistic)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/DatapointsToAlarm
  :cognitect.aws.medialive/__integerMin1)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Id
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Tags
  :cognitect.aws.medialive/TagMap)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/TreatMissingData
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTreatMissingData)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/ComparisonOperator
  :cognitect.aws.medialive/CloudWatchAlarmTemplateComparisonOperator)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Threshold
  :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/ModifiedAt
  :cognitect.aws.medialive/__timestampIso8601)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Period
  :cognitect.aws.medialive/__integerMin10Max86400)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/GroupId
  :cognitect.aws.medialive/__stringMin7Max11PatternAws097)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Arn
  :cognitect.aws.medialive/__stringPatternArnMedialiveCloudwatchAlarmTemplate)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Name
  :cognitect.aws.medialive/__stringMin1Max255PatternS)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/TargetResourceType
  :cognitect.aws.medialive/CloudWatchAlarmTemplateTargetResourceType)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.GetCloudWatchAlarmTemplateResponse/MetricName
  :cognitect.aws.medialive/__stringMax64)

(s/def :cognitect.aws.medialive.CreateInputResponse/Input :cognitect.aws.medialive/Input)

(s/def :cognitect.aws.medialive.Eac3AtmosSettings/Bitrate :cognitect.aws.medialive/__double)

(s/def
  :cognitect.aws.medialive.Eac3AtmosSettings/CodingMode
  :cognitect.aws.medialive/Eac3AtmosCodingMode)

(s/def
  :cognitect.aws.medialive.Eac3AtmosSettings/Dialnorm
  :cognitect.aws.medialive/__integerMin1Max31)

(s/def :cognitect.aws.medialive.Eac3AtmosSettings/DrcLine :cognitect.aws.medialive/Eac3AtmosDrcLine)

(s/def :cognitect.aws.medialive.Eac3AtmosSettings/DrcRf :cognitect.aws.medialive/Eac3AtmosDrcRf)

(s/def :cognitect.aws.medialive.Eac3AtmosSettings/HeightTrim :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.Eac3AtmosSettings/SurroundTrim :cognitect.aws.medialive/__double)

(s/def :cognitect.aws.medialive.InputDestinationRoute/Cidr :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.InputDestinationRoute/Gateway :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateMultiplex/MultiplexSettings
  :cognitect.aws.medialive/MultiplexSettings)

(s/def :cognitect.aws.medialive.UpdateMultiplex/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateMultiplex/PacketIdentifiersMapping
  :cognitect.aws.medialive/MultiplexPacketIdentifiersMapping)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateEventBridgeRuleTemplateGroupRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.TimecodeConfig/Source :cognitect.aws.medialive/TimecodeConfigSource)

(s/def
  :cognitect.aws.medialive.TimecodeConfig/SyncThreshold
  :cognitect.aws.medialive/__integerMin1Max1000000)

(s/def
  :cognitect.aws.medialive.HlsAkamaiSettings/ConnectionRetryInterval
  :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsAkamaiSettings/FilecacheDuration
  :cognitect.aws.medialive/__integerMin0Max600)

(s/def
  :cognitect.aws.medialive.HlsAkamaiSettings/HttpTransferMode
  :cognitect.aws.medialive/HlsAkamaiHttpTransferMode)

(s/def :cognitect.aws.medialive.HlsAkamaiSettings/NumRetries :cognitect.aws.medialive/__integerMin0)

(s/def
  :cognitect.aws.medialive.HlsAkamaiSettings/RestartDelay
  :cognitect.aws.medialive/__integerMin0Max15)

(s/def :cognitect.aws.medialive.HlsAkamaiSettings/Salt :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.HlsAkamaiSettings/Token :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputDevice/HdDeviceSettings
  :cognitect.aws.medialive/InputDeviceConfigurableSettings)

(s/def :cognitect.aws.medialive.UpdateInputDevice/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateInputDevice/UhdDeviceSettings
  :cognitect.aws.medialive/InputDeviceConfigurableSettings)

(s/def
  :cognitect.aws.medialive.UpdateInputDevice/AvailabilityZone
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupRequest/Description
  :cognitect.aws.medialive/__stringMin0Max1024)

(s/def
  :cognitect.aws.medialive.UpdateCloudWatchAlarmTemplateGroupRequest/Identifier
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.OutputSettings/CmafIngestOutputSettings
  :cognitect.aws.medialive/CmafIngestOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/MsSmoothOutputSettings
  :cognitect.aws.medialive/MsSmoothOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/ArchiveOutputSettings
  :cognitect.aws.medialive/ArchiveOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/FrameCaptureOutputSettings
  :cognitect.aws.medialive/FrameCaptureOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/HlsOutputSettings
  :cognitect.aws.medialive/HlsOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/UdpOutputSettings
  :cognitect.aws.medialive/UdpOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/MultiplexOutputSettings
  :cognitect.aws.medialive/MultiplexOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/MediaPackageOutputSettings
  :cognitect.aws.medialive/MediaPackageOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/RtmpOutputSettings
  :cognitect.aws.medialive/RtmpOutputSettings)

(s/def
  :cognitect.aws.medialive.OutputSettings/SrtOutputSettings
  :cognitect.aws.medialive/SrtOutputSettings)

(s/def :cognitect.aws.medialive.SdiSourceMapping/CardNumber :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.SdiSourceMapping/ChannelNumber :cognitect.aws.medialive/__integer)

(s/def :cognitect.aws.medialive.SdiSourceMapping/SdiSource :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/InitialAudioGain
  :cognitect.aws.medialive/__integerMinNegative60Max60)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/InputEndAction
  :cognitect.aws.medialive/GlobalConfigurationInputEndAction)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/InputLossBehavior
  :cognitect.aws.medialive/InputLossBehavior)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/OutputLockingMode
  :cognitect.aws.medialive/GlobalConfigurationOutputLockingMode)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/OutputTimingSource
  :cognitect.aws.medialive/GlobalConfigurationOutputTimingSource)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/SupportLowFramerateInputs
  :cognitect.aws.medialive/GlobalConfigurationLowFramerateInputs)

(s/def
  :cognitect.aws.medialive.GlobalConfiguration/OutputLockingSettings
  :cognitect.aws.medialive/OutputLockingSettings)

(s/def :cognitect.aws.medialive.CreateNodeRequest/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateNodeRequest/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.CreateNodeRequest/NodeInterfaceMappings
  :cognitect.aws.medialive/__listOfNodeInterfaceMappingCreateRequest)

(s/def :cognitect.aws.medialive.CreateNodeRequest/RequestId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.CreateNodeRequest/Role :cognitect.aws.medialive/NodeRole)

(s/def :cognitect.aws.medialive.CreateNodeRequest/Tags :cognitect.aws.medialive/Tags)

(s/def :cognitect.aws.medialive.UpdateNodeStateRequest/ClusterId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.UpdateNodeStateRequest/NodeId :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.UpdateNodeStateRequest/State
  :cognitect.aws.medialive/UpdateNodeState)

(s/def :cognitect.aws.medialive.DeleteNetworkRequest/NetworkId :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.ConflictException/Message :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.AudioCodecSettings/AacSettings :cognitect.aws.medialive/AacSettings)

(s/def :cognitect.aws.medialive.AudioCodecSettings/Ac3Settings :cognitect.aws.medialive/Ac3Settings)

(s/def
  :cognitect.aws.medialive.AudioCodecSettings/Eac3AtmosSettings
  :cognitect.aws.medialive/Eac3AtmosSettings)

(s/def
  :cognitect.aws.medialive.AudioCodecSettings/Eac3Settings
  :cognitect.aws.medialive/Eac3Settings)

(s/def :cognitect.aws.medialive.AudioCodecSettings/Mp2Settings :cognitect.aws.medialive/Mp2Settings)

(s/def
  :cognitect.aws.medialive.AudioCodecSettings/PassThroughSettings
  :cognitect.aws.medialive/PassThroughSettings)

(s/def :cognitect.aws.medialive.AudioCodecSettings/WavSettings :cognitect.aws.medialive/WavSettings)

(s/def
  :cognitect.aws.medialive.MultiplexProgramChannelDestinationSettings/MultiplexId
  :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.MultiplexProgramChannelDestinationSettings/ProgramName
  :cognitect.aws.medialive/__stringMin1)

(s/def
  :cognitect.aws.medialive.UpdateAccountConfigurationRequest/AccountConfiguration
  :cognitect.aws.medialive/AccountConfiguration)

(s/def
  :cognitect.aws.medialive.AncillarySourceSettings/SourceAncillaryChannelNumber
  :cognitect.aws.medialive/__integerMin1Max4)

(s/def
  :cognitect.aws.medialive.HlsSettings/AudioOnlyHlsSettings
  :cognitect.aws.medialive/AudioOnlyHlsSettings)

(s/def
  :cognitect.aws.medialive.HlsSettings/Fmp4HlsSettings
  :cognitect.aws.medialive/Fmp4HlsSettings)

(s/def
  :cognitect.aws.medialive.HlsSettings/FrameCaptureHlsSettings
  :cognitect.aws.medialive/FrameCaptureHlsSettings)

(s/def
  :cognitect.aws.medialive.HlsSettings/StandardHlsSettings
  :cognitect.aws.medialive/StandardHlsSettings)

(s/def
  :cognitect.aws.medialive.Fmp4HlsSettings/AudioRenditionSets
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.Fmp4HlsSettings/NielsenId3Behavior
  :cognitect.aws.medialive/Fmp4NielsenId3Behavior)

(s/def
  :cognitect.aws.medialive.Fmp4HlsSettings/TimedMetadataBehavior
  :cognitect.aws.medialive/Fmp4TimedMetadataBehavior)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/LogLevel :cognitect.aws.medialive/LogLevel)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/EncoderSettings
  :cognitect.aws.medialive/EncoderSettings)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/Id :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/Tags :cognitect.aws.medialive/Tags)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/InputSpecification
  :cognitect.aws.medialive/InputSpecification)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/Destinations
  :cognitect.aws.medialive/__listOfOutputDestination)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/InputAttachments
  :cognitect.aws.medialive/__listOfInputAttachment)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/ChannelClass
  :cognitect.aws.medialive/ChannelClass)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/Vpc
  :cognitect.aws.medialive/VpcOutputSettingsDescription)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/RoleArn :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/PipelinesRunningCount
  :cognitect.aws.medialive/__integer)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/PipelineDetails
  :cognitect.aws.medialive/__listOfPipelineDetail)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/Arn :cognitect.aws.medialive/__string)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/Name :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/EgressEndpoints
  :cognitect.aws.medialive/__listOfChannelEgressEndpoint)

(s/def :cognitect.aws.medialive.DescribeChannelResponse/State :cognitect.aws.medialive/ChannelState)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/AnywhereSettings
  :cognitect.aws.medialive/DescribeAnywhereSettings)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/CdiInputSpecification
  :cognitect.aws.medialive/CdiInputSpecification)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/Maintenance
  :cognitect.aws.medialive/MaintenanceStatus)

(s/def
  :cognitect.aws.medialive.DescribeChannelResponse/ChannelEngineVersion
  :cognitect.aws.medialive/ChannelEngineVersionResponse)

(s/def
  :cognitect.aws.medialive.TransferInputDeviceRequest/InputDeviceId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.TransferInputDeviceRequest/TargetCustomerId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.TransferInputDeviceRequest/TargetRegion
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.TransferInputDeviceRequest/TransferMessage
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexProgramResponse/ChannelId
  :cognitect.aws.medialive/__string)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexProgramResponse/MultiplexProgramSettings
  :cognitect.aws.medialive/MultiplexProgramSettings)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexProgramResponse/PacketIdentifiersMap
  :cognitect.aws.medialive/MultiplexProgramPacketIdentifiersMap)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexProgramResponse/PipelineDetails
  :cognitect.aws.medialive/__listOfMultiplexProgramPipelineDetail)

(s/def
  :cognitect.aws.medialive.DescribeMultiplexProgramResponse/ProgramName
  :cognitect.aws.medialive/__string)

