;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.mediapackage-vod.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.mediapackage-vod/ListPackagingConfigurationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListPackagingConfigurationsResponse/PackagingConfigurations
     :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsResponse/NextToken]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribeAssetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.DescribeAssetResponse/SourceRoleArn
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/PackagingGroupId
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/ResourceId
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/EgressEndpoints
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/SourceArn
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Arn
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Id]))

(s/def :cognitect.aws.mediapackage-vod/DeletePackagingConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.mediapackage-vod/ListPackagingGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListPackagingGroupsResponse/NextToken
     :cognitect.aws.mediapackage-vod.ListPackagingGroupsResponse/PackagingGroups]))

(s/def
  :cognitect.aws.mediapackage-vod/CreatePackagingConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/PackagingGroupId
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/HlsPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/MssPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/CmafPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Arn
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/DashPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/AssetShallow
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.AssetShallow/SourceRoleArn
     :cognitect.aws.mediapackage-vod.AssetShallow/PackagingGroupId
     :cognitect.aws.mediapackage-vod.AssetShallow/ResourceId
     :cognitect.aws.mediapackage-vod.AssetShallow/SourceArn
     :cognitect.aws.mediapackage-vod.AssetShallow/Arn
     :cognitect.aws.mediapackage-vod.AssetShallow/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfEgressEndpoint
  (s/coll-of :cognitect.aws.mediapackage-vod/EgressEndpoint))

(s/def
  :cognitect.aws.mediapackage-vod/DeleteAssetRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DeleteAssetRequest/Id]))

(s/def :cognitect.aws.mediapackage-vod/__boolean boolean?)

(s/def
  :cognitect.aws.mediapackage-vod/EgressEndpoint
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.EgressEndpoint/PackagingConfigurationId
     :cognitect.aws.mediapackage-vod.EgressEndpoint/Url]))

(s/def
  :cognitect.aws.mediapackage-vod/MssPackage
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.MssPackage/MssManifests]
    :opt-un
    [:cognitect.aws.mediapackage-vod.MssPackage/Encryption
     :cognitect.aws.mediapackage-vod.MssPackage/SegmentDurationSeconds]))

(s/def
  :cognitect.aws.mediapackage-vod/CmafEncryption
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.CmafEncryption/SpekeKeyProvider]))

(s/def :cognitect.aws.mediapackage-vod/AdMarkers string?)

(s/def
  :cognitect.aws.mediapackage-vod/DescribeAssetRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DescribeAssetRequest/Id]))

(s/def :cognitect.aws.mediapackage-vod/Profile string?)

(s/def
  :cognitect.aws.mediapackage-vod/DashEncryption
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DashEncryption/SpekeKeyProvider]))

(s/def
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.SpekeKeyProvider/SystemIds
     :cognitect.aws.mediapackage-vod.SpekeKeyProvider/Url
     :cognitect.aws.mediapackage-vod.SpekeKeyProvider/RoleArn]))

(s/def
  :cognitect.aws.mediapackage-vod/DashPackage
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.DashPackage/DashManifests]
    :opt-un
    [:cognitect.aws.mediapackage-vod.DashPackage/Encryption
     :cognitect.aws.mediapackage-vod.DashPackage/SegmentDurationSeconds]))

(s/def
  :cognitect.aws.mediapackage-vod/HlsPackage
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.HlsPackage/HlsManifests]
    :opt-un
    [:cognitect.aws.mediapackage-vod.HlsPackage/UseAudioRenditionGroup
     :cognitect.aws.mediapackage-vod.HlsPackage/Encryption
     :cognitect.aws.mediapackage-vod.HlsPackage/SegmentDurationSeconds]))

(s/def :cognitect.aws.mediapackage-vod/DeletePackagingGroupResponse (s/keys))

(s/def
  :cognitect.aws.mediapackage-vod/PackagingConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.PackagingConfiguration/PackagingGroupId
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/HlsPackage
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/MssPackage
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/CmafPackage
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/Arn
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/DashPackage
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribePackagingGroupRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DescribePackagingGroupRequest/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfDashManifest
  (s/coll-of :cognitect.aws.mediapackage-vod/DashManifest))

(s/def
  :cognitect.aws.mediapackage-vod/MssManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.MssManifest/StreamSelection
     :cognitect.aws.mediapackage-vod.MssManifest/ManifestName]))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfHlsManifest
  (s/coll-of :cognitect.aws.mediapackage-vod/HlsManifest))

(s/def :cognitect.aws.mediapackage-vod/EncryptionMethod string?)

(s/def
  :cognitect.aws.mediapackage-vod/ListPackagingConfigurationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/PackagingGroupId
     :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/NextToken
     :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediapackage-vod/ListPackagingGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListPackagingGroupsRequest/NextToken
     :cognitect.aws.mediapackage-vod.ListPackagingGroupsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribePackagingConfigurationRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DescribePackagingConfigurationRequest/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribePackagingGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Arn
     :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/CreatePackagingGroupRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/ListAssetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListAssetsResponse/NextToken
     :cognitect.aws.mediapackage-vod.ListAssetsResponse/Assets]))

(s/def :cognitect.aws.mediapackage-vod/__string string?)

(s/def
  :cognitect.aws.mediapackage-vod/MssEncryption
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.MssEncryption/SpekeKeyProvider]))

(s/def
  :cognitect.aws.mediapackage-vod/ListAssetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListAssetsRequest/PackagingGroupId
     :cognitect.aws.mediapackage-vod.ListAssetsRequest/NextToken
     :cognitect.aws.mediapackage-vod.ListAssetsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediapackage-vod/PackagingGroup
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.PackagingGroup/Arn
     :cognitect.aws.mediapackage-vod.PackagingGroup/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/CmafPackage
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.CmafPackage/HlsManifests]
    :opt-un
    [:cognitect.aws.mediapackage-vod.CmafPackage/Encryption
     :cognitect.aws.mediapackage-vod.CmafPackage/SegmentDurationSeconds]))

(s/def
  :cognitect.aws.mediapackage-vod/CreateAssetRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.CreateAssetRequest/SourceArn
     :cognitect.aws.mediapackage-vod.CreateAssetRequest/Id
     :cognitect.aws.mediapackage-vod.CreateAssetRequest/PackagingGroupId
     :cognitect.aws.mediapackage-vod.CreateAssetRequest/SourceRoleArn]
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreateAssetRequest/ResourceId]))

(s/def
  :cognitect.aws.mediapackage-vod/CreateAssetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreateAssetResponse/SourceRoleArn
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/PackagingGroupId
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/ResourceId
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/EgressEndpoints
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/SourceArn
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/Arn
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfPackagingConfiguration
  (s/coll-of :cognitect.aws.mediapackage-vod/PackagingConfiguration))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfAssetShallow
  (s/coll-of :cognitect.aws.mediapackage-vod/AssetShallow))

(s/def
  :cognitect.aws.mediapackage-vod/DeletePackagingGroupRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DeletePackagingGroupRequest/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/MaxResults
  (s/with-gen
    (s/and int? #(<= 1 % 1000))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 1000 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfMssManifest
  (s/coll-of :cognitect.aws.mediapackage-vod/MssManifest))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfPackagingGroup
  (s/coll-of :cognitect.aws.mediapackage-vod/PackagingGroup))

(s/def
  :cognitect.aws.mediapackage-vod/CreatePackagingConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/Id
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/PackagingGroupId]
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/HlsPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/MssPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/CmafPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/DashPackage]))

(s/def
  :cognitect.aws.mediapackage-vod/StreamSelection
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.StreamSelection/MaxVideoBitsPerSecond
     :cognitect.aws.mediapackage-vod.StreamSelection/StreamOrder
     :cognitect.aws.mediapackage-vod.StreamSelection/MinVideoBitsPerSecond]))

(s/def
  :cognitect.aws.mediapackage-vod/CreatePackagingGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Arn
     :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/DeletePackagingConfigurationRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DeletePackagingConfigurationRequest/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/HlsEncryption
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.HlsEncryption/SpekeKeyProvider]
    :opt-un
    [:cognitect.aws.mediapackage-vod.HlsEncryption/ConstantInitializationVector
     :cognitect.aws.mediapackage-vod.HlsEncryption/EncryptionMethod]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribePackagingConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/PackagingGroupId
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/HlsPackage
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/MssPackage
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/CmafPackage
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Arn
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/DashPackage
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/__integer
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.mediapackage-vod/__listOf__string
  (s/coll-of :cognitect.aws.mediapackage-vod/__string))

(s/def
  :cognitect.aws.mediapackage-vod/DashManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.DashManifest/StreamSelection
     :cognitect.aws.mediapackage-vod.DashManifest/Profile
     :cognitect.aws.mediapackage-vod.DashManifest/MinBufferTimeSeconds
     :cognitect.aws.mediapackage-vod.DashManifest/ManifestName]))

(s/def :cognitect.aws.mediapackage-vod/DeleteAssetResponse (s/keys))

(s/def
  :cognitect.aws.mediapackage-vod/HlsManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.HlsManifest/AdMarkers
     :cognitect.aws.mediapackage-vod.HlsManifest/StreamSelection
     :cognitect.aws.mediapackage-vod.HlsManifest/RepeatExtXKey
     :cognitect.aws.mediapackage-vod.HlsManifest/IncludeIframeOnlyStream
     :cognitect.aws.mediapackage-vod.HlsManifest/ProgramDateTimeIntervalSeconds
     :cognitect.aws.mediapackage-vod.HlsManifest/ManifestName]))

(s/def :cognitect.aws.mediapackage-vod/StreamOrder string?)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsResponse/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsResponse/PackagingConfigurations
  :cognitect.aws.mediapackage-vod/__listOfPackagingConfiguration)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/EgressEndpoints
  :cognitect.aws.mediapackage-vod/__listOfEgressEndpoint)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/ResourceId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/SourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/SourceRoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingGroupsResponse/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingGroupsResponse/PackagingGroups
  :cognitect.aws.mediapackage-vod/__listOfPackagingGroup)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/CmafPackage
  :cognitect.aws.mediapackage-vod/CmafPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/DashPackage
  :cognitect.aws.mediapackage-vod/DashPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/HlsPackage
  :cognitect.aws.mediapackage-vod/HlsPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/MssPackage
  :cognitect.aws.mediapackage-vod/MssPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.AssetShallow/Arn :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.AssetShallow/Id :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.AssetShallow/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.AssetShallow/ResourceId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.AssetShallow/SourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.AssetShallow/SourceRoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DeleteAssetRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.EgressEndpoint/PackagingConfigurationId
  :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.EgressEndpoint/Url :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.MssPackage/Encryption
  :cognitect.aws.mediapackage-vod/MssEncryption)

(s/def
  :cognitect.aws.mediapackage-vod.MssPackage/MssManifests
  :cognitect.aws.mediapackage-vod/__listOfMssManifest)

(s/def
  :cognitect.aws.mediapackage-vod.MssPackage/SegmentDurationSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.CmafEncryption/SpekeKeyProvider
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DashEncryption/SpekeKeyProvider
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediapackage-vod.SpekeKeyProvider/RoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.SpekeKeyProvider/SystemIds
  :cognitect.aws.mediapackage-vod/__listOf__string)

(s/def
  :cognitect.aws.mediapackage-vod.SpekeKeyProvider/Url
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/DashManifests
  :cognitect.aws.mediapackage-vod/__listOfDashManifest)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/Encryption
  :cognitect.aws.mediapackage-vod/DashEncryption)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/SegmentDurationSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.HlsPackage/Encryption
  :cognitect.aws.mediapackage-vod/HlsEncryption)

(s/def
  :cognitect.aws.mediapackage-vod.HlsPackage/HlsManifests
  :cognitect.aws.mediapackage-vod/__listOfHlsManifest)

(s/def
  :cognitect.aws.mediapackage-vod.HlsPackage/SegmentDurationSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.HlsPackage/UseAudioRenditionGroup
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/CmafPackage
  :cognitect.aws.mediapackage-vod/CmafPackage)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/DashPackage
  :cognitect.aws.mediapackage-vod/DashPackage)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/HlsPackage
  :cognitect.aws.mediapackage-vod/HlsPackage)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/MssPackage
  :cognitect.aws.mediapackage-vod/MssPackage)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.MssManifest/ManifestName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.MssManifest/StreamSelection
  :cognitect.aws.mediapackage-vod/StreamSelection)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/MaxResults
  :cognitect.aws.mediapackage-vod/MaxResults)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingGroupsRequest/MaxResults
  :cognitect.aws.mediapackage-vod/MaxResults)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingGroupsRequest/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsResponse/Assets
  :cognitect.aws.mediapackage-vod/__listOfAssetShallow)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsResponse/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.MssEncryption/SpekeKeyProvider
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsRequest/MaxResults
  :cognitect.aws.mediapackage-vod/MaxResults)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsRequest/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsRequest/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.PackagingGroup/Arn :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.PackagingGroup/Id :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CmafPackage/Encryption
  :cognitect.aws.mediapackage-vod/CmafEncryption)

(s/def
  :cognitect.aws.mediapackage-vod.CmafPackage/HlsManifests
  :cognitect.aws.mediapackage-vod/__listOfHlsManifest)

(s/def
  :cognitect.aws.mediapackage-vod.CmafPackage/SegmentDurationSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/ResourceId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/SourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/SourceRoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/EgressEndpoints
  :cognitect.aws.mediapackage-vod/__listOfEgressEndpoint)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/ResourceId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/SourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/SourceRoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DeletePackagingGroupRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/CmafPackage
  :cognitect.aws.mediapackage-vod/CmafPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/DashPackage
  :cognitect.aws.mediapackage-vod/DashPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/HlsPackage
  :cognitect.aws.mediapackage-vod/HlsPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/MssPackage
  :cognitect.aws.mediapackage-vod/MssPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.StreamSelection/MaxVideoBitsPerSecond
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.StreamSelection/MinVideoBitsPerSecond
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.StreamSelection/StreamOrder
  :cognitect.aws.mediapackage-vod/StreamOrder)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DeletePackagingConfigurationRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.HlsEncryption/ConstantInitializationVector
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.HlsEncryption/EncryptionMethod
  :cognitect.aws.mediapackage-vod/EncryptionMethod)

(s/def
  :cognitect.aws.mediapackage-vod.HlsEncryption/SpekeKeyProvider
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/CmafPackage
  :cognitect.aws.mediapackage-vod/CmafPackage)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/DashPackage
  :cognitect.aws.mediapackage-vod/DashPackage)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/HlsPackage
  :cognitect.aws.mediapackage-vod/HlsPackage)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/MssPackage
  :cognitect.aws.mediapackage-vod/MssPackage)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DashManifest/ManifestName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DashManifest/MinBufferTimeSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def :cognitect.aws.mediapackage-vod.DashManifest/Profile :cognitect.aws.mediapackage-vod/Profile)

(s/def
  :cognitect.aws.mediapackage-vod.DashManifest/StreamSelection
  :cognitect.aws.mediapackage-vod/StreamSelection)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/AdMarkers
  :cognitect.aws.mediapackage-vod/AdMarkers)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/IncludeIframeOnlyStream
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/ManifestName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/ProgramDateTimeIntervalSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/RepeatExtXKey
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/StreamSelection
  :cognitect.aws.mediapackage-vod/StreamSelection)

