;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.mediapackage-vod.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.mediapackage-vod/ListPackagingConfigurationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListPackagingConfigurationsResponse/PackagingConfigurations
     :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsResponse/NextToken]))

(s/def
  :cognitect.aws.mediapackage-vod/PresetSpeke20Audio
  (s/spec
    string?
    :gen
    #(s/gen #{"PRESET-AUDIO-3" "UNENCRYPTED" "PRESET-AUDIO-1" "PRESET-AUDIO-2" "SHARED"})))

(s/def
  :cognitect.aws.mediapackage-vod/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.TagResourceRequest/ResourceArn
     :cognitect.aws.mediapackage-vod.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.mediapackage-vod/ConfigureLogsRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.ConfigureLogsRequest/Id]
    :opt-un
    [:cognitect.aws.mediapackage-vod.ConfigureLogsRequest/EgressAccessLogs]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribeAssetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.DescribeAssetResponse/SourceRoleArn
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/PackagingGroupId
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Tags
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/ResourceId
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/EgressEndpoints
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/SourceArn
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Arn
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/CreatedAt
     :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/SegmentTemplateFormat
  (s/spec
    string?
    :gen
    #(s/gen #{"NUMBER_WITH_TIMELINE" "NUMBER_WITH_DURATION" "TIME_WITH_TIMELINE"})))

(s/def :cognitect.aws.mediapackage-vod/DeletePackagingConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.mediapackage-vod/ListPackagingGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListPackagingGroupsResponse/NextToken
     :cognitect.aws.mediapackage-vod.ListPackagingGroupsResponse/PackagingGroups]))

(s/def
  :cognitect.aws.mediapackage-vod/CreatePackagingConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/PackagingGroupId
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/HlsPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Tags
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/MssPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/CmafPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Arn
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/DashPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/AssetShallow
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.AssetShallow/SourceRoleArn
     :cognitect.aws.mediapackage-vod.AssetShallow/PackagingGroupId
     :cognitect.aws.mediapackage-vod.AssetShallow/Tags
     :cognitect.aws.mediapackage-vod.AssetShallow/ResourceId
     :cognitect.aws.mediapackage-vod.AssetShallow/SourceArn
     :cognitect.aws.mediapackage-vod.AssetShallow/Arn
     :cognitect.aws.mediapackage-vod.AssetShallow/CreatedAt
     :cognitect.aws.mediapackage-vod.AssetShallow/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/EgressAccessLogs
  (s/keys :opt-un [:cognitect.aws.mediapackage-vod.EgressAccessLogs/LogGroupName]))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfEgressEndpoint
  (s/coll-of :cognitect.aws.mediapackage-vod/EgressEndpoint))

(s/def
  :cognitect.aws.mediapackage-vod/DeleteAssetRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DeleteAssetRequest/Id]))

(s/def :cognitect.aws.mediapackage-vod/__boolean boolean?)

(s/def
  :cognitect.aws.mediapackage-vod/EgressEndpoint
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.EgressEndpoint/PackagingConfigurationId
     :cognitect.aws.mediapackage-vod.EgressEndpoint/Status
     :cognitect.aws.mediapackage-vod.EgressEndpoint/Url]))

(s/def
  :cognitect.aws.mediapackage-vod/MssPackage
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.MssPackage/MssManifests]
    :opt-un
    [:cognitect.aws.mediapackage-vod.MssPackage/Encryption
     :cognitect.aws.mediapackage-vod.MssPackage/SegmentDurationSeconds]))

(s/def
  :cognitect.aws.mediapackage-vod/CmafEncryption
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.CmafEncryption/SpekeKeyProvider]
    :opt-un
    [:cognitect.aws.mediapackage-vod.CmafEncryption/ConstantInitializationVector]))

(s/def
  :cognitect.aws.mediapackage-vod/UpdatePackagingGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.UpdatePackagingGroupRequest/Id]
    :opt-un
    [:cognitect.aws.mediapackage-vod.UpdatePackagingGroupRequest/Authorization]))

(s/def
  :cognitect.aws.mediapackage-vod/AdMarkers
  (s/spec string? :gen #(s/gen #{"PASSTHROUGH" "NONE" "SCTE35_ENHANCED"})))

(s/def
  :cognitect.aws.mediapackage-vod/DescribeAssetRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DescribeAssetRequest/Id]))

(s/def :cognitect.aws.mediapackage-vod/Profile (s/spec string? :gen #(s/gen #{"HBBTV_1_5" "NONE"})))

(s/def
  :cognitect.aws.mediapackage-vod/DashEncryption
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DashEncryption/SpekeKeyProvider]))

(s/def
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.SpekeKeyProvider/SystemIds
     :cognitect.aws.mediapackage-vod.SpekeKeyProvider/Url
     :cognitect.aws.mediapackage-vod.SpekeKeyProvider/RoleArn]
    :opt-un
    [:cognitect.aws.mediapackage-vod.SpekeKeyProvider/EncryptionContractConfiguration]))

(s/def
  :cognitect.aws.mediapackage-vod/Tags
  (s/map-of :cognitect.aws.mediapackage-vod/__string :cognitect.aws.mediapackage-vod/__string))

(s/def
  :cognitect.aws.mediapackage-vod/DashPackage
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.DashPackage/DashManifests]
    :opt-un
    [:cognitect.aws.mediapackage-vod.DashPackage/SegmentTemplateFormat
     :cognitect.aws.mediapackage-vod.DashPackage/IncludeIframeOnlyStream
     :cognitect.aws.mediapackage-vod.DashPackage/PeriodTriggers
     :cognitect.aws.mediapackage-vod.DashPackage/IncludeEncoderConfigurationInSegments
     :cognitect.aws.mediapackage-vod.DashPackage/Encryption
     :cognitect.aws.mediapackage-vod.DashPackage/SegmentDurationSeconds]))

(s/def
  :cognitect.aws.mediapackage-vod/HlsPackage
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.HlsPackage/HlsManifests]
    :opt-un
    [:cognitect.aws.mediapackage-vod.HlsPackage/IncludeDvbSubtitles
     :cognitect.aws.mediapackage-vod.HlsPackage/UseAudioRenditionGroup
     :cognitect.aws.mediapackage-vod.HlsPackage/Encryption
     :cognitect.aws.mediapackage-vod.HlsPackage/SegmentDurationSeconds]))

(s/def :cognitect.aws.mediapackage-vod/DeletePackagingGroupResponse (s/keys))

(s/def
  :cognitect.aws.mediapackage-vod/PackagingConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.PackagingConfiguration/PackagingGroupId
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/HlsPackage
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/Tags
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/MssPackage
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/CmafPackage
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/Arn
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/DashPackage
     :cognitect.aws.mediapackage-vod.PackagingConfiguration/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribePackagingGroupRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DescribePackagingGroupRequest/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/EncryptionContractConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.EncryptionContractConfiguration/PresetSpeke20Audio
     :cognitect.aws.mediapackage-vod.EncryptionContractConfiguration/PresetSpeke20Video]))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfDashManifest
  (s/coll-of :cognitect.aws.mediapackage-vod/DashManifest))

(s/def
  :cognitect.aws.mediapackage-vod/MssManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.MssManifest/StreamSelection
     :cognitect.aws.mediapackage-vod.MssManifest/ManifestName]))

(s/def
  :cognitect.aws.mediapackage-vod/ScteMarkersSource
  (s/spec string? :gen #(s/gen #{"MANIFEST" "SEGMENTS"})))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfHlsManifest
  (s/coll-of :cognitect.aws.mediapackage-vod/HlsManifest))

(s/def
  :cognitect.aws.mediapackage-vod/EncryptionMethod
  (s/spec string? :gen #(s/gen #{"SAMPLE_AES" "AES_128"})))

(s/def
  :cognitect.aws.mediapackage-vod/ListPackagingConfigurationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/PackagingGroupId
     :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/NextToken
     :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediapackage-vod/ListPackagingGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListPackagingGroupsRequest/NextToken
     :cognitect.aws.mediapackage-vod.ListPackagingGroupsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribePackagingConfigurationRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DescribePackagingConfigurationRequest/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribePackagingGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Authorization
     :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/EgressAccessLogs
     :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Tags
     :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Arn
     :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/DomainName
     :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/ConfigureLogsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ConfigureLogsResponse/Authorization
     :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/EgressAccessLogs
     :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/Tags
     :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/Arn
     :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/DomainName
     :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/CreatePackagingGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/Id]
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/Authorization
     :cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/EgressAccessLogs
     :cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/Tags]))

(s/def
  :cognitect.aws.mediapackage-vod/ListAssetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListAssetsResponse/NextToken
     :cognitect.aws.mediapackage-vod.ListAssetsResponse/Assets]))

(s/def :cognitect.aws.mediapackage-vod/__string string?)

(s/def
  :cognitect.aws.mediapackage-vod/PresetSpeke20Video
  (s/spec
    string?
    :gen
    #(s/gen
      #{"PRESET-VIDEO-2" "PRESET-VIDEO-8" "PRESET-VIDEO-6" "PRESET-VIDEO-1" "PRESET-VIDEO-7"
        "PRESET-VIDEO-5" "UNENCRYPTED" "PRESET-VIDEO-3" "PRESET-VIDEO-4" "SHARED"})))

(s/def
  :cognitect.aws.mediapackage-vod/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.mediapackage-vod/MssEncryption
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.MssEncryption/SpekeKeyProvider]))

(s/def
  :cognitect.aws.mediapackage-vod/ListAssetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.ListAssetsRequest/PackagingGroupId
     :cognitect.aws.mediapackage-vod.ListAssetsRequest/NextToken
     :cognitect.aws.mediapackage-vod.ListAssetsRequest/MaxResults]))

(s/def
  :cognitect.aws.mediapackage-vod/PackagingGroup
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.PackagingGroup/Authorization
     :cognitect.aws.mediapackage-vod.PackagingGroup/EgressAccessLogs
     :cognitect.aws.mediapackage-vod.PackagingGroup/Tags
     :cognitect.aws.mediapackage-vod.PackagingGroup/Arn
     :cognitect.aws.mediapackage-vod.PackagingGroup/DomainName
     :cognitect.aws.mediapackage-vod.PackagingGroup/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/__mapOf__string
  (s/map-of :cognitect.aws.mediapackage-vod/__string :cognitect.aws.mediapackage-vod/__string))

(s/def
  :cognitect.aws.mediapackage-vod/CmafPackage
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.CmafPackage/HlsManifests]
    :opt-un
    [:cognitect.aws.mediapackage-vod.CmafPackage/IncludeEncoderConfigurationInSegments
     :cognitect.aws.mediapackage-vod.CmafPackage/Encryption
     :cognitect.aws.mediapackage-vod.CmafPackage/SegmentDurationSeconds]))

(s/def
  :cognitect.aws.mediapackage-vod/CreateAssetRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.CreateAssetRequest/SourceArn
     :cognitect.aws.mediapackage-vod.CreateAssetRequest/Id
     :cognitect.aws.mediapackage-vod.CreateAssetRequest/PackagingGroupId
     :cognitect.aws.mediapackage-vod.CreateAssetRequest/SourceRoleArn]
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreateAssetRequest/Tags
     :cognitect.aws.mediapackage-vod.CreateAssetRequest/ResourceId]))

(s/def
  :cognitect.aws.mediapackage-vod/CreateAssetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreateAssetResponse/SourceRoleArn
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/PackagingGroupId
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/Tags
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/ResourceId
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/EgressEndpoints
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/SourceArn
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/Arn
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/CreatedAt
     :cognitect.aws.mediapackage-vod.CreateAssetResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/__PeriodTriggersElement
  (s/spec string? :gen #(s/gen #{"ADS"})))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfPackagingConfiguration
  (s/coll-of :cognitect.aws.mediapackage-vod/PackagingConfiguration))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfAssetShallow
  (s/coll-of :cognitect.aws.mediapackage-vod/AssetShallow))

(s/def
  :cognitect.aws.mediapackage-vod/DeletePackagingGroupRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DeletePackagingGroupRequest/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/MaxResults
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.mediapackage-vod/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.UntagResourceRequest/TagKeys
     :cognitect.aws.mediapackage-vod.UntagResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfMssManifest
  (s/coll-of :cognitect.aws.mediapackage-vod/MssManifest))

(s/def
  :cognitect.aws.mediapackage-vod/__listOfPackagingGroup
  (s/coll-of :cognitect.aws.mediapackage-vod/PackagingGroup))

(s/def
  :cognitect.aws.mediapackage-vod/CreatePackagingConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/Id
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/PackagingGroupId]
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/HlsPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/Tags
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/MssPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/CmafPackage
     :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/DashPackage]))

(s/def
  :cognitect.aws.mediapackage-vod/StreamSelection
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.StreamSelection/MaxVideoBitsPerSecond
     :cognitect.aws.mediapackage-vod.StreamSelection/StreamOrder
     :cognitect.aws.mediapackage-vod.StreamSelection/MinVideoBitsPerSecond]))

(s/def
  :cognitect.aws.mediapackage-vod/CreatePackagingGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Authorization
     :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/EgressAccessLogs
     :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Tags
     :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Arn
     :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/DomainName
     :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/Authorization
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.Authorization/SecretsRoleArn
     :cognitect.aws.mediapackage-vod.Authorization/CdnIdentifierSecret]))

(s/def
  :cognitect.aws.mediapackage-vod/ManifestLayout
  (s/spec string? :gen #(s/gen #{"COMPACT" "FULL"})))

(s/def
  :cognitect.aws.mediapackage-vod/DeletePackagingConfigurationRequest
  (s/keys :req-un [:cognitect.aws.mediapackage-vod.DeletePackagingConfigurationRequest/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/HlsEncryption
  (s/keys
    :req-un
    [:cognitect.aws.mediapackage-vod.HlsEncryption/SpekeKeyProvider]
    :opt-un
    [:cognitect.aws.mediapackage-vod.HlsEncryption/ConstantInitializationVector
     :cognitect.aws.mediapackage-vod.HlsEncryption/EncryptionMethod]))

(s/def
  :cognitect.aws.mediapackage-vod/DescribePackagingConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/PackagingGroupId
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/HlsPackage
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Tags
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/MssPackage
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/CmafPackage
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Arn
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/DashPackage
     :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/__listOf__PeriodTriggersElement
  (s/coll-of :cognitect.aws.mediapackage-vod/__PeriodTriggersElement))

(s/def
  :cognitect.aws.mediapackage-vod/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.mediapackage-vod.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.mediapackage-vod/__integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.mediapackage-vod/__listOf__string
  (s/coll-of :cognitect.aws.mediapackage-vod/__string))

(s/def
  :cognitect.aws.mediapackage-vod/UpdatePackagingGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/Authorization
     :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/EgressAccessLogs
     :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/Tags
     :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/Arn
     :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/DomainName
     :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/Id]))

(s/def
  :cognitect.aws.mediapackage-vod/DashManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.DashManifest/StreamSelection
     :cognitect.aws.mediapackage-vod.DashManifest/Profile
     :cognitect.aws.mediapackage-vod.DashManifest/ManifestLayout
     :cognitect.aws.mediapackage-vod.DashManifest/MinBufferTimeSeconds
     :cognitect.aws.mediapackage-vod.DashManifest/ScteMarkersSource
     :cognitect.aws.mediapackage-vod.DashManifest/ManifestName]))

(s/def :cognitect.aws.mediapackage-vod/DeleteAssetResponse (s/keys))

(s/def
  :cognitect.aws.mediapackage-vod/HlsManifest
  (s/keys
    :opt-un
    [:cognitect.aws.mediapackage-vod.HlsManifest/AdMarkers
     :cognitect.aws.mediapackage-vod.HlsManifest/StreamSelection
     :cognitect.aws.mediapackage-vod.HlsManifest/RepeatExtXKey
     :cognitect.aws.mediapackage-vod.HlsManifest/IncludeIframeOnlyStream
     :cognitect.aws.mediapackage-vod.HlsManifest/ProgramDateTimeIntervalSeconds
     :cognitect.aws.mediapackage-vod.HlsManifest/ManifestName]))

(s/def
  :cognitect.aws.mediapackage-vod/StreamOrder
  (s/spec string? :gen #(s/gen #{"VIDEO_BITRATE_DESCENDING" "ORIGINAL" "VIDEO_BITRATE_ASCENDING"})))

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsResponse/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsResponse/PackagingConfigurations
  :cognitect.aws.mediapackage-vod/__listOfPackagingConfiguration)

(s/def
  :cognitect.aws.mediapackage-vod.TagResourceRequest/ResourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.TagResourceRequest/Tags
  :cognitect.aws.mediapackage-vod/__mapOf__string)

(s/def
  :cognitect.aws.mediapackage-vod.ConfigureLogsRequest/EgressAccessLogs
  :cognitect.aws.mediapackage-vod/EgressAccessLogs)

(s/def
  :cognitect.aws.mediapackage-vod.ConfigureLogsRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/CreatedAt
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/ResourceId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/SourceRoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/EgressEndpoints
  :cognitect.aws.mediapackage-vod/__listOfEgressEndpoint)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetResponse/SourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingGroupsResponse/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingGroupsResponse/PackagingGroups
  :cognitect.aws.mediapackage-vod/__listOfPackagingGroup)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/CmafPackage
  :cognitect.aws.mediapackage-vod/CmafPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/DashPackage
  :cognitect.aws.mediapackage-vod/DashPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/HlsPackage
  :cognitect.aws.mediapackage-vod/HlsPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/MssPackage
  :cognitect.aws.mediapackage-vod/MssPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationResponse/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def :cognitect.aws.mediapackage-vod.AssetShallow/Arn :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.AssetShallow/CreatedAt
  :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.AssetShallow/Id :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.AssetShallow/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.AssetShallow/ResourceId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.AssetShallow/SourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.AssetShallow/SourceRoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.AssetShallow/Tags :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.EgressAccessLogs/LogGroupName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DeleteAssetRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.EgressEndpoint/PackagingConfigurationId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.EgressEndpoint/Status
  :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.EgressEndpoint/Url :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.MssPackage/Encryption
  :cognitect.aws.mediapackage-vod/MssEncryption)

(s/def
  :cognitect.aws.mediapackage-vod.MssPackage/MssManifests
  :cognitect.aws.mediapackage-vod/__listOfMssManifest)

(s/def
  :cognitect.aws.mediapackage-vod.MssPackage/SegmentDurationSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.CmafEncryption/ConstantInitializationVector
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CmafEncryption/SpekeKeyProvider
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediapackage-vod.UpdatePackagingGroupRequest/Authorization
  :cognitect.aws.mediapackage-vod/Authorization)

(s/def
  :cognitect.aws.mediapackage-vod.UpdatePackagingGroupRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribeAssetRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DashEncryption/SpekeKeyProvider
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediapackage-vod.SpekeKeyProvider/EncryptionContractConfiguration
  :cognitect.aws.mediapackage-vod/EncryptionContractConfiguration)

(s/def
  :cognitect.aws.mediapackage-vod.SpekeKeyProvider/RoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.SpekeKeyProvider/SystemIds
  :cognitect.aws.mediapackage-vod/__listOf__string)

(s/def
  :cognitect.aws.mediapackage-vod.SpekeKeyProvider/Url
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/DashManifests
  :cognitect.aws.mediapackage-vod/__listOfDashManifest)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/Encryption
  :cognitect.aws.mediapackage-vod/DashEncryption)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/IncludeEncoderConfigurationInSegments
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/IncludeIframeOnlyStream
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/PeriodTriggers
  :cognitect.aws.mediapackage-vod/__listOf__PeriodTriggersElement)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/SegmentDurationSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.DashPackage/SegmentTemplateFormat
  :cognitect.aws.mediapackage-vod/SegmentTemplateFormat)

(s/def
  :cognitect.aws.mediapackage-vod.HlsPackage/Encryption
  :cognitect.aws.mediapackage-vod/HlsEncryption)

(s/def
  :cognitect.aws.mediapackage-vod.HlsPackage/HlsManifests
  :cognitect.aws.mediapackage-vod/__listOfHlsManifest)

(s/def
  :cognitect.aws.mediapackage-vod.HlsPackage/IncludeDvbSubtitles
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.HlsPackage/SegmentDurationSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.HlsPackage/UseAudioRenditionGroup
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/CmafPackage
  :cognitect.aws.mediapackage-vod/CmafPackage)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/DashPackage
  :cognitect.aws.mediapackage-vod/DashPackage)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/HlsPackage
  :cognitect.aws.mediapackage-vod/HlsPackage)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/MssPackage
  :cognitect.aws.mediapackage-vod/MssPackage)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingConfiguration/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.EncryptionContractConfiguration/PresetSpeke20Audio
  :cognitect.aws.mediapackage-vod/PresetSpeke20Audio)

(s/def
  :cognitect.aws.mediapackage-vod.EncryptionContractConfiguration/PresetSpeke20Video
  :cognitect.aws.mediapackage-vod/PresetSpeke20Video)

(s/def
  :cognitect.aws.mediapackage-vod.MssManifest/ManifestName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.MssManifest/StreamSelection
  :cognitect.aws.mediapackage-vod/StreamSelection)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/MaxResults
  :cognitect.aws.mediapackage-vod/MaxResults)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingConfigurationsRequest/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingGroupsRequest/MaxResults
  :cognitect.aws.mediapackage-vod/MaxResults)

(s/def
  :cognitect.aws.mediapackage-vod.ListPackagingGroupsRequest/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Authorization
  :cognitect.aws.mediapackage-vod/Authorization)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/DomainName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/EgressAccessLogs
  :cognitect.aws.mediapackage-vod/EgressAccessLogs)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingGroupResponse/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/Authorization
  :cognitect.aws.mediapackage-vod/Authorization)

(s/def
  :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/DomainName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/EgressAccessLogs
  :cognitect.aws.mediapackage-vod/EgressAccessLogs)

(s/def
  :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ConfigureLogsResponse/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/Authorization
  :cognitect.aws.mediapackage-vod/Authorization)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/EgressAccessLogs
  :cognitect.aws.mediapackage-vod/EgressAccessLogs)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupRequest/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsResponse/Assets
  :cognitect.aws.mediapackage-vod/__listOfAssetShallow)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsResponse/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.MssEncryption/SpekeKeyProvider
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsRequest/MaxResults
  :cognitect.aws.mediapackage-vod/MaxResults)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsRequest/NextToken
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.ListAssetsRequest/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.PackagingGroup/Arn :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingGroup/Authorization
  :cognitect.aws.mediapackage-vod/Authorization)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingGroup/DomainName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.PackagingGroup/EgressAccessLogs
  :cognitect.aws.mediapackage-vod/EgressAccessLogs)

(s/def :cognitect.aws.mediapackage-vod.PackagingGroup/Id :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.PackagingGroup/Tags :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.CmafPackage/Encryption
  :cognitect.aws.mediapackage-vod/CmafEncryption)

(s/def
  :cognitect.aws.mediapackage-vod.CmafPackage/HlsManifests
  :cognitect.aws.mediapackage-vod/__listOfHlsManifest)

(s/def
  :cognitect.aws.mediapackage-vod.CmafPackage/IncludeEncoderConfigurationInSegments
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.CmafPackage/SegmentDurationSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/ResourceId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/SourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetRequest/SourceRoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def :cognitect.aws.mediapackage-vod.CreateAssetRequest/Tags :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/CreatedAt
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/ResourceId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/SourceRoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/EgressEndpoints
  :cognitect.aws.mediapackage-vod/__listOfEgressEndpoint)

(s/def
  :cognitect.aws.mediapackage-vod.CreateAssetResponse/SourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DeletePackagingGroupRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.UntagResourceRequest/ResourceArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.UntagResourceRequest/TagKeys
  :cognitect.aws.mediapackage-vod/__listOf__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/CmafPackage
  :cognitect.aws.mediapackage-vod/CmafPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/DashPackage
  :cognitect.aws.mediapackage-vod/DashPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/HlsPackage
  :cognitect.aws.mediapackage-vod/HlsPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/MssPackage
  :cognitect.aws.mediapackage-vod/MssPackage)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingConfigurationRequest/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.StreamSelection/MaxVideoBitsPerSecond
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.StreamSelection/MinVideoBitsPerSecond
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.StreamSelection/StreamOrder
  :cognitect.aws.mediapackage-vod/StreamOrder)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Authorization
  :cognitect.aws.mediapackage-vod/Authorization)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/DomainName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/EgressAccessLogs
  :cognitect.aws.mediapackage-vod/EgressAccessLogs)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.CreatePackagingGroupResponse/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.Authorization/CdnIdentifierSecret
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.Authorization/SecretsRoleArn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DeletePackagingConfigurationRequest/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.HlsEncryption/ConstantInitializationVector
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.HlsEncryption/EncryptionMethod
  :cognitect.aws.mediapackage-vod/EncryptionMethod)

(s/def
  :cognitect.aws.mediapackage-vod.HlsEncryption/SpekeKeyProvider
  :cognitect.aws.mediapackage-vod/SpekeKeyProvider)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/CmafPackage
  :cognitect.aws.mediapackage-vod/CmafPackage)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/DashPackage
  :cognitect.aws.mediapackage-vod/DashPackage)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/HlsPackage
  :cognitect.aws.mediapackage-vod/HlsPackage)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/MssPackage
  :cognitect.aws.mediapackage-vod/MssPackage)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/PackagingGroupId
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DescribePackagingConfigurationResponse/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.ListTagsForResourceResponse/Tags
  :cognitect.aws.mediapackage-vod/__mapOf__string)

(s/def
  :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/Arn
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/Authorization
  :cognitect.aws.mediapackage-vod/Authorization)

(s/def
  :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/DomainName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/EgressAccessLogs
  :cognitect.aws.mediapackage-vod/EgressAccessLogs)

(s/def
  :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/Id
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.UpdatePackagingGroupResponse/Tags
  :cognitect.aws.mediapackage-vod/Tags)

(s/def
  :cognitect.aws.mediapackage-vod.DashManifest/ManifestLayout
  :cognitect.aws.mediapackage-vod/ManifestLayout)

(s/def
  :cognitect.aws.mediapackage-vod.DashManifest/ManifestName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.DashManifest/MinBufferTimeSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def :cognitect.aws.mediapackage-vod.DashManifest/Profile :cognitect.aws.mediapackage-vod/Profile)

(s/def
  :cognitect.aws.mediapackage-vod.DashManifest/ScteMarkersSource
  :cognitect.aws.mediapackage-vod/ScteMarkersSource)

(s/def
  :cognitect.aws.mediapackage-vod.DashManifest/StreamSelection
  :cognitect.aws.mediapackage-vod/StreamSelection)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/AdMarkers
  :cognitect.aws.mediapackage-vod/AdMarkers)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/IncludeIframeOnlyStream
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/ManifestName
  :cognitect.aws.mediapackage-vod/__string)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/ProgramDateTimeIntervalSeconds
  :cognitect.aws.mediapackage-vod/__integer)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/RepeatExtXKey
  :cognitect.aws.mediapackage-vod/__boolean)

(s/def
  :cognitect.aws.mediapackage-vod.HlsManifest/StreamSelection
  :cognitect.aws.mediapackage-vod/StreamSelection)

