;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.organizations.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.organizations/CreateGovCloudAccountRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.CreateGovCloudAccountRequest/Email
     :cognitect.aws.organizations.CreateGovCloudAccountRequest/AccountName]
    :opt-un
    [:cognitect.aws.organizations.CreateGovCloudAccountRequest/RoleName
     :cognitect.aws.organizations.CreateGovCloudAccountRequest/IamUserAccessToBilling
     :cognitect.aws.organizations.CreateGovCloudAccountRequest/Tags]))

(s/def
  :cognitect.aws.organizations/RemoveAccountFromOrganizationRequest
  (s/keys :req-un [:cognitect.aws.organizations.RemoveAccountFromOrganizationRequest/AccountId]))

(s/def
  :cognitect.aws.organizations/CreateAccountStatus
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.CreateAccountStatus/GovCloudAccountId
     :cognitect.aws.organizations.CreateAccountStatus/CompletedTimestamp
     :cognitect.aws.organizations.CreateAccountStatus/RequestedTimestamp
     :cognitect.aws.organizations.CreateAccountStatus/FailureReason
     :cognitect.aws.organizations.CreateAccountStatus/AccountId
     :cognitect.aws.organizations.CreateAccountStatus/AccountName
     :cognitect.aws.organizations.CreateAccountStatus/State
     :cognitect.aws.organizations.CreateAccountStatus/Id]))

(s/def
  :cognitect.aws.organizations/InviteAccountToOrganizationResponse
  (s/keys :opt-un [:cognitect.aws.organizations.InviteAccountToOrganizationResponse/Handshake]))

(s/def
  :cognitect.aws.organizations/UpdatePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.UpdatePolicyRequest/PolicyId]
    :opt-un
    [:cognitect.aws.organizations.UpdatePolicyRequest/Description
     :cognitect.aws.organizations.UpdatePolicyRequest/Content
     :cognitect.aws.organizations.UpdatePolicyRequest/Name]))

(s/def :cognitect.aws.organizations/HandshakeResourceValue string?)

(s/def
  :cognitect.aws.organizations/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.TagResourceRequest/ResourceId
     :cognitect.aws.organizations.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.organizations/CreateAccountState
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "SUCCEEDED" "FAILED"})))

(s/def
  :cognitect.aws.organizations/ListAWSServiceAccessForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListAWSServiceAccessForOrganizationResponse/EnabledServicePrincipals
     :cognitect.aws.organizations.ListAWSServiceAccessForOrganizationResponse/NextToken]))

(s/def
  :cognitect.aws.organizations/ListHandshakesForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListHandshakesForOrganizationResponse/NextToken
     :cognitect.aws.organizations.ListHandshakesForOrganizationResponse/Handshakes]))

(s/def
  :cognitect.aws.organizations/HandshakeId
  (s/spec #(re-matches (re-pattern "^h-[0-9a-z]{8,32}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/ListTargetsForPolicyResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListTargetsForPolicyResponse/NextToken
     :cognitect.aws.organizations.ListTargetsForPolicyResponse/Targets]))

(s/def
  :cognitect.aws.organizations/OrganizationalUnitName
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/OrganizationArn
  (s/spec
    #(re-matches (re-pattern "^arn:aws:organizations::\\d{12}:organization\\/o-[a-z0-9]{10,32}") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.organizations/PolicyTargetSummary
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.PolicyTargetSummary/Type
     :cognitect.aws.organizations.PolicyTargetSummary/TargetId
     :cognitect.aws.organizations.PolicyTargetSummary/Arn
     :cognitect.aws.organizations.PolicyTargetSummary/Name]))

(s/def
  :cognitect.aws.organizations/AccountName
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/Tag
  (s/keys :req-un [:cognitect.aws.organizations.Tag/Key :cognitect.aws.organizations.Tag/Value]))

(s/def
  :cognitect.aws.organizations/CreateAccountFailureReason
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MISSING_BUSINESS_VALIDATION" "INTERNAL_FAILURE" "INVALID_PAYMENT_INSTRUMENT"
        "PENDING_BUSINESS_VALIDATION" "CONCURRENT_ACCOUNT_MODIFICATION"
        "FAILED_BUSINESS_VALIDATION" "INVALID_IDENTITY_FOR_BUSINESS_VALIDATION" "INVALID_ADDRESS"
        "GOVCLOUD_ACCOUNT_ALREADY_EXISTS" "ACCOUNT_LIMIT_EXCEEDED" "INVALID_EMAIL"
        "EMAIL_ALREADY_EXISTS" "MISSING_PAYMENT_INSTRUMENT" "UNKNOWN_BUSINESS_VALIDATION"})))

(s/def
  :cognitect.aws.organizations/ListDelegatedServicesForAccountRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.ListDelegatedServicesForAccountRequest/AccountId]
    :opt-un
    [:cognitect.aws.organizations.ListDelegatedServicesForAccountRequest/NextToken
     :cognitect.aws.organizations.ListDelegatedServicesForAccountRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/DeclineHandshakeRequest
  (s/keys :req-un [:cognitect.aws.organizations.DeclineHandshakeRequest/HandshakeId]))

(s/def
  :cognitect.aws.organizations/ListRootsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListRootsRequest/NextToken
     :cognitect.aws.organizations.ListRootsRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/HandshakePartyId
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/DelegatedAdministrator
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.DelegatedAdministrator/Email
     :cognitect.aws.organizations.DelegatedAdministrator/JoinedTimestamp
     :cognitect.aws.organizations.DelegatedAdministrator/DelegationEnabledDate
     :cognitect.aws.organizations.DelegatedAdministrator/Status
     :cognitect.aws.organizations.DelegatedAdministrator/Arn
     :cognitect.aws.organizations.DelegatedAdministrator/JoinedMethod
     :cognitect.aws.organizations.DelegatedAdministrator/Name
     :cognitect.aws.organizations.DelegatedAdministrator/Id]))

(s/def
  :cognitect.aws.organizations/DelegatedAdministrators
  (s/coll-of :cognitect.aws.organizations/DelegatedAdministrator))

(s/def
  :cognitect.aws.organizations/ListAccountsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListAccountsRequest/NextToken
     :cognitect.aws.organizations.ListAccountsRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/ListHandshakesForAccountRequest
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListHandshakesForAccountRequest/Filter
     :cognitect.aws.organizations.ListHandshakesForAccountRequest/NextToken
     :cognitect.aws.organizations.ListHandshakesForAccountRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/CreateAccountResponse
  (s/keys :opt-un [:cognitect.aws.organizations.CreateAccountResponse/CreateAccountStatus]))

(s/def
  :cognitect.aws.organizations/CreateAccountRequestId
  (s/spec #(re-matches (re-pattern "^car-[a-z0-9]{8,32}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/ListParentsRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.ListParentsRequest/ChildId]
    :opt-un
    [:cognitect.aws.organizations.ListParentsRequest/NextToken
     :cognitect.aws.organizations.ListParentsRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/DeclineHandshakeResponse
  (s/keys :opt-un [:cognitect.aws.organizations.DeclineHandshakeResponse/Handshake]))

(s/def
  :cognitect.aws.organizations/ListChildrenResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListChildrenResponse/Children
     :cognitect.aws.organizations.ListChildrenResponse/NextToken]))

(s/def
  :cognitect.aws.organizations/EnableAWSServiceAccessRequest
  (s/keys :req-un [:cognitect.aws.organizations.EnableAWSServiceAccessRequest/ServicePrincipal]))

(s/def
  :cognitect.aws.organizations/IAMUserAccessToBilling
  (s/spec string? :gen #(s/gen #{"DENY" "ALLOW"})))

(s/def :cognitect.aws.organizations/AwsManagedPolicy boolean?)

(s/def
  :cognitect.aws.organizations/ListCreateAccountStatusRequest
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListCreateAccountStatusRequest/NextToken
     :cognitect.aws.organizations.ListCreateAccountStatusRequest/MaxResults
     :cognitect.aws.organizations.ListCreateAccountStatusRequest/States]))

(s/def
  :cognitect.aws.organizations/PolicySummary
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.PolicySummary/Type
     :cognitect.aws.organizations.PolicySummary/AwsManaged
     :cognitect.aws.organizations.PolicySummary/Description
     :cognitect.aws.organizations.PolicySummary/Arn
     :cognitect.aws.organizations.PolicySummary/Name
     :cognitect.aws.organizations.PolicySummary/Id]))

(s/def
  :cognitect.aws.organizations/ListRootsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListRootsResponse/NextToken
     :cognitect.aws.organizations.ListRootsResponse/Roots]))

(s/def
  :cognitect.aws.organizations/AccountId
  (s/spec #(re-matches (re-pattern "^\\d{12}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/CreatePolicyResponse
  (s/keys :opt-un [:cognitect.aws.organizations.CreatePolicyResponse/Policy]))

(s/def
  :cognitect.aws.organizations/DisableAWSServiceAccessRequest
  (s/keys :req-un [:cognitect.aws.organizations.DisableAWSServiceAccessRequest/ServicePrincipal]))

(s/def
  :cognitect.aws.organizations/HandshakeNotes
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def :cognitect.aws.organizations/Policies (s/coll-of :cognitect.aws.organizations/PolicySummary))

(s/def
  :cognitect.aws.organizations/PolicyArn
  (s/spec
    #(re-matches
      (re-pattern
        "^(arn:aws:organizations::\\d{12}:policy\\/o-[a-z0-9]{10,32}\\/[0-9a-z_]+\\/p-[0-9a-z]{10,32})|(arn:aws:organizations::aws:policy\\/[0-9a-z_]+\\/p-[0-9a-zA-Z_]{10,128})")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.organizations/PolicyContent
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/AccountJoinedMethod
  (s/spec string? :gen #(s/gen #{"INVITED" "CREATED"})))

(s/def
  :cognitect.aws.organizations/CreateOrganizationalUnitRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.CreateOrganizationalUnitRequest/ParentId
     :cognitect.aws.organizations.CreateOrganizationalUnitRequest/Name]
    :opt-un
    [:cognitect.aws.organizations.CreateOrganizationalUnitRequest/Tags]))

(s/def :cognitect.aws.organizations/Tags (s/coll-of :cognitect.aws.organizations/Tag))

(s/def :cognitect.aws.organizations/Roots (s/coll-of :cognitect.aws.organizations/Root))

(s/def
  :cognitect.aws.organizations/OrganizationFeatureSet
  (s/spec string? :gen #(s/gen #{"CONSOLIDATED_BILLING" "ALL"})))

(s/def
  :cognitect.aws.organizations/AcceptHandshakeResponse
  (s/keys :opt-un [:cognitect.aws.organizations.AcceptHandshakeResponse/Handshake]))

(s/def
  :cognitect.aws.organizations/HandshakeResourceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ORGANIZATION" "MASTER_EMAIL" "NOTES" "PARENT_HANDSHAKE" "ACCOUNT"
        "ORGANIZATION_FEATURE_SET" "EMAIL" "MASTER_NAME"})))

(s/def
  :cognitect.aws.organizations/AcceptHandshakeRequest
  (s/keys :req-un [:cognitect.aws.organizations.AcceptHandshakeRequest/HandshakeId]))

(s/def
  :cognitect.aws.organizations/OrganizationalUnits
  (s/coll-of :cognitect.aws.organizations/OrganizationalUnit))

(s/def
  :cognitect.aws.organizations/CreateOrganizationResponse
  (s/keys :opt-un [:cognitect.aws.organizations.CreateOrganizationResponse/Organization]))

(s/def
  :cognitect.aws.organizations/DescribeOrganizationResponse
  (s/keys :opt-un [:cognitect.aws.organizations.DescribeOrganizationResponse/Organization]))

(s/def
  :cognitect.aws.organizations/HandshakeArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws:organizations::\\d{12}:handshake\\/o-[a-z0-9]{10,32}\\/[a-z_]{1,32}\\/h-[0-9a-z]{8,32}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.organizations/ActionType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE" "ENABLE_ALL_FEATURES" "INVITE"
        "APPROVE_ALL_FEATURES"})))

(s/def
  :cognitect.aws.organizations/Email
  (s/spec #(re-matches (re-pattern "[^\\s@]+@[^\\s@]+\\.[^\\s@]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/ParentType
  (s/spec string? :gen #(s/gen #{"ROOT" "ORGANIZATIONAL_UNIT"})))

(s/def
  :cognitect.aws.organizations/AccountStatus
  (s/spec string? :gen #(s/gen #{"PENDING_CLOSURE" "ACTIVE" "SUSPENDED"})))

(s/def
  :cognitect.aws.organizations/ListOrganizationalUnitsForParentResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListOrganizationalUnitsForParentResponse/OrganizationalUnits
     :cognitect.aws.organizations.ListOrganizationalUnitsForParentResponse/NextToken]))

(s/def
  :cognitect.aws.organizations/ListDelegatedServicesForAccountResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListDelegatedServicesForAccountResponse/DelegatedServices
     :cognitect.aws.organizations.ListDelegatedServicesForAccountResponse/NextToken]))

(s/def
  :cognitect.aws.organizations/ListAccountsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListAccountsResponse/NextToken
     :cognitect.aws.organizations.ListAccountsResponse/Accounts]))

(s/def
  :cognitect.aws.organizations/PolicyDescription
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/RootName
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.organizations/DescribeEffectivePolicyResponse
  (s/keys :opt-un [:cognitect.aws.organizations.DescribeEffectivePolicyResponse/EffectivePolicy]))

(s/def
  :cognitect.aws.organizations/EnableAllFeaturesResponse
  (s/keys :opt-un [:cognitect.aws.organizations.EnableAllFeaturesResponse/Handshake]))

(s/def
  :cognitect.aws.organizations/UpdatePolicyResponse
  (s/keys :opt-un [:cognitect.aws.organizations.UpdatePolicyResponse/Policy]))

(s/def
  :cognitect.aws.organizations/DescribePolicyResponse
  (s/keys :opt-un [:cognitect.aws.organizations.DescribePolicyResponse/Policy]))

(s/def
  :cognitect.aws.organizations/EnablePolicyTypeResponse
  (s/keys :opt-un [:cognitect.aws.organizations.EnablePolicyTypeResponse/Root]))

(s/def
  :cognitect.aws.organizations/RootArn
  (s/spec
    #(re-matches
      (re-pattern "^arn:aws:organizations::\\d{12}:root\\/o-[a-z0-9]{10,32}\\/r-[0-9a-z]{4,32}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.organizations/ParentId
  (s/spec
    #(re-matches (re-pattern "^(r-[0-9a-z]{4,32})|(ou-[0-9a-z]{4,32}-[a-z0-9]{8,32})$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.organizations/AccountArn
  (s/spec
    #(re-matches
      (re-pattern "^arn:aws:organizations::\\d{12}:account\\/o-[a-z0-9]{10,32}\\/\\d{12}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.organizations/TargetType
  (s/spec string? :gen #(s/gen #{"ROOT" "ACCOUNT" "ORGANIZATIONAL_UNIT"})))

(s/def
  :cognitect.aws.organizations/DescribeAccountResponse
  (s/keys :opt-un [:cognitect.aws.organizations.DescribeAccountResponse/Account]))

(s/def
  :cognitect.aws.organizations/ListAWSServiceAccessForOrganizationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListAWSServiceAccessForOrganizationRequest/NextToken
     :cognitect.aws.organizations.ListAWSServiceAccessForOrganizationRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/ChildId
  (s/spec
    #(re-matches (re-pattern "^(\\d{12})|(ou-[0-9a-z]{4,32}-[a-z0-9]{8,32})$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.organizations/DelegatedServices
  (s/coll-of :cognitect.aws.organizations/DelegatedService))

(s/def
  :cognitect.aws.organizations/RoleName
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]{1,64}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/EnabledServicePrincipals
  (s/coll-of :cognitect.aws.organizations/EnabledServicePrincipal))

(s/def
  :cognitect.aws.organizations/ListDelegatedAdministratorsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListDelegatedAdministratorsRequest/ServicePrincipal
     :cognitect.aws.organizations.ListDelegatedAdministratorsRequest/NextToken
     :cognitect.aws.organizations.ListDelegatedAdministratorsRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/ListAccountsForParentRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.ListAccountsForParentRequest/ParentId]
    :opt-un
    [:cognitect.aws.organizations.ListAccountsForParentRequest/NextToken
     :cognitect.aws.organizations.ListAccountsForParentRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/PolicyTargets
  (s/coll-of :cognitect.aws.organizations/PolicyTargetSummary))

(s/def
  :cognitect.aws.organizations/Handshake
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.Handshake/RequestedTimestamp
     :cognitect.aws.organizations.Handshake/Parties
     :cognitect.aws.organizations.Handshake/Resources
     :cognitect.aws.organizations.Handshake/ExpirationTimestamp
     :cognitect.aws.organizations.Handshake/Arn
     :cognitect.aws.organizations.Handshake/State
     :cognitect.aws.organizations.Handshake/Action
     :cognitect.aws.organizations.Handshake/Id]))

(s/def
  :cognitect.aws.organizations/DescribeOrganizationalUnitResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.DescribeOrganizationalUnitResponse/OrganizationalUnit]))

(s/def :cognitect.aws.organizations/Accounts (s/coll-of :cognitect.aws.organizations/Account))

(s/def
  :cognitect.aws.organizations/EnablePolicyTypeRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.EnablePolicyTypeRequest/RootId
     :cognitect.aws.organizations.EnablePolicyTypeRequest/PolicyType]))

(s/def
  :cognitect.aws.organizations/CreateAccountStates
  (s/coll-of :cognitect.aws.organizations/CreateAccountState))

(s/def
  :cognitect.aws.organizations/NextToken
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def :cognitect.aws.organizations/Children (s/coll-of :cognitect.aws.organizations/Child))

(s/def
  :cognitect.aws.organizations/HandshakeState
  (s/spec string? :gen #(s/gen #{"CANCELED" "ACCEPTED" "OPEN" "EXPIRED" "DECLINED" "REQUESTED"})))

(s/def
  :cognitect.aws.organizations/PolicyName
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/UpdateOrganizationalUnitRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.UpdateOrganizationalUnitRequest/OrganizationalUnitId]
    :opt-un
    [:cognitect.aws.organizations.UpdateOrganizationalUnitRequest/Name]))

(s/def
  :cognitect.aws.organizations/DescribeCreateAccountStatusResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.DescribeCreateAccountStatusResponse/CreateAccountStatus]))

(s/def
  :cognitect.aws.organizations/CancelHandshakeResponse
  (s/keys :opt-un [:cognitect.aws.organizations.CancelHandshakeResponse/Handshake]))

(s/def
  :cognitect.aws.organizations/DescribeHandshakeRequest
  (s/keys :req-un [:cognitect.aws.organizations.DescribeHandshakeRequest/HandshakeId]))

(s/def
  :cognitect.aws.organizations/HandshakeFilter
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.HandshakeFilter/ParentHandshakeId
     :cognitect.aws.organizations.HandshakeFilter/ActionType]))

(s/def
  :cognitect.aws.organizations/TagValue
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/DescribeCreateAccountStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.DescribeCreateAccountStatusRequest/CreateAccountRequestId]))

(s/def
  :cognitect.aws.organizations/ListPoliciesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListPoliciesResponse/NextToken
     :cognitect.aws.organizations.ListPoliciesResponse/Policies]))

(s/def
  :cognitect.aws.organizations/ListTagsForResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.ListTagsForResourceRequest/ResourceId]
    :opt-un
    [:cognitect.aws.organizations.ListTagsForResourceRequest/NextToken]))

(s/def
  :cognitect.aws.organizations/ListCreateAccountStatusResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListCreateAccountStatusResponse/CreateAccountStatuses
     :cognitect.aws.organizations.ListCreateAccountStatusResponse/NextToken]))

(s/def
  :cognitect.aws.organizations/DescribeEffectivePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.DescribeEffectivePolicyRequest/PolicyType]
    :opt-un
    [:cognitect.aws.organizations.DescribeEffectivePolicyRequest/TargetId]))

(s/def
  :cognitect.aws.organizations/HandshakeParties
  (s/coll-of :cognitect.aws.organizations/HandshakeParty))

(s/def
  :cognitect.aws.organizations/DescribeHandshakeResponse
  (s/keys :opt-un [:cognitect.aws.organizations.DescribeHandshakeResponse/Handshake]))

(s/def
  :cognitect.aws.organizations/AttachPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.AttachPolicyRequest/PolicyId
     :cognitect.aws.organizations.AttachPolicyRequest/TargetId]))

(s/def
  :cognitect.aws.organizations/RegisterDelegatedAdministratorRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.RegisterDelegatedAdministratorRequest/AccountId
     :cognitect.aws.organizations.RegisterDelegatedAdministratorRequest/ServicePrincipal]))

(s/def
  :cognitect.aws.organizations/PolicyTargetId
  (s/spec
    #(re-matches
      (re-pattern "^(r-[0-9a-z]{4,32})|(\\d{12})|(ou-[0-9a-z]{4,32}-[a-z0-9]{8,32})$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.organizations/Account
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.Account/Email
     :cognitect.aws.organizations.Account/JoinedTimestamp
     :cognitect.aws.organizations.Account/Status
     :cognitect.aws.organizations.Account/Arn
     :cognitect.aws.organizations.Account/JoinedMethod
     :cognitect.aws.organizations.Account/Name
     :cognitect.aws.organizations.Account/Id]))

(s/def
  :cognitect.aws.organizations/MoveAccountRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.MoveAccountRequest/AccountId
     :cognitect.aws.organizations.MoveAccountRequest/SourceParentId
     :cognitect.aws.organizations.MoveAccountRequest/DestinationParentId]))

(s/def
  :cognitect.aws.organizations/ListOrganizationalUnitsForParentRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.ListOrganizationalUnitsForParentRequest/ParentId]
    :opt-un
    [:cognitect.aws.organizations.ListOrganizationalUnitsForParentRequest/NextToken
     :cognitect.aws.organizations.ListOrganizationalUnitsForParentRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/DelegatedService
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.DelegatedService/DelegationEnabledDate
     :cognitect.aws.organizations.DelegatedService/ServicePrincipal]))

(s/def
  :cognitect.aws.organizations/PolicyTypes
  (s/coll-of :cognitect.aws.organizations/PolicyTypeSummary))

(s/def
  :cognitect.aws.organizations/ListPoliciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.ListPoliciesRequest/Filter]
    :opt-un
    [:cognitect.aws.organizations.ListPoliciesRequest/NextToken
     :cognitect.aws.organizations.ListPoliciesRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/CloseAccountRequest
  (s/keys :req-un [:cognitect.aws.organizations.CloseAccountRequest/AccountId]))

(s/def
  :cognitect.aws.organizations/DeleteOrganizationalUnitRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.DeleteOrganizationalUnitRequest/OrganizationalUnitId]))

(s/def
  :cognitect.aws.organizations/ListPoliciesForTargetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListPoliciesForTargetResponse/NextToken
     :cognitect.aws.organizations.ListPoliciesForTargetResponse/Policies]))

(s/def
  :cognitect.aws.organizations/CreateAccountStatuses
  (s/coll-of :cognitect.aws.organizations/CreateAccountStatus))

(s/def
  :cognitect.aws.organizations/Child
  (s/keys :opt-un [:cognitect.aws.organizations.Child/Type :cognitect.aws.organizations.Child/Id]))

(s/def
  :cognitect.aws.organizations/PolicyType
  (s/spec
    string?
    :gen
    #(s/gen #{"SERVICE_CONTROL_POLICY" "TAG_POLICY" "AISERVICES_OPT_OUT_POLICY" "BACKUP_POLICY"})))

(s/def
  :cognitect.aws.organizations/ListTargetsForPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.ListTargetsForPolicyRequest/PolicyId]
    :opt-un
    [:cognitect.aws.organizations.ListTargetsForPolicyRequest/NextToken
     :cognitect.aws.organizations.ListTargetsForPolicyRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/DescribeOrganizationalUnitRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.DescribeOrganizationalUnitRequest/OrganizationalUnitId]))

(s/def :cognitect.aws.organizations/Parents (s/coll-of :cognitect.aws.organizations/Parent))

(s/def
  :cognitect.aws.organizations/UpdateOrganizationalUnitResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.UpdateOrganizationalUnitResponse/OrganizationalUnit]))

(s/def
  :cognitect.aws.organizations/CreateAccountName
  (s/spec #(re-matches (re-pattern "[\\u0020-\\u007E]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/ListHandshakesForAccountResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListHandshakesForAccountResponse/NextToken
     :cognitect.aws.organizations.ListHandshakesForAccountResponse/Handshakes]))

(s/def
  :cognitect.aws.organizations/CreatePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.CreatePolicyRequest/Content
     :cognitect.aws.organizations.CreatePolicyRequest/Description
     :cognitect.aws.organizations.CreatePolicyRequest/Name
     :cognitect.aws.organizations.CreatePolicyRequest/Type]
    :opt-un
    [:cognitect.aws.organizations.CreatePolicyRequest/Tags]))

(s/def
  :cognitect.aws.organizations/HandshakeParty
  (s/keys
    :req-un
    [:cognitect.aws.organizations.HandshakeParty/Id
     :cognitect.aws.organizations.HandshakeParty/Type]))

(s/def
  :cognitect.aws.organizations/Parent
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.Parent/Type :cognitect.aws.organizations.Parent/Id]))

(s/def
  :cognitect.aws.organizations/DisablePolicyTypeResponse
  (s/keys :opt-un [:cognitect.aws.organizations.DisablePolicyTypeResponse/Root]))

(s/def
  :cognitect.aws.organizations/MaxResults
  (s/spec (s/and int? #(<= 1 % 20)) :gen #(gen/choose 1 20)))

(s/def
  :cognitect.aws.organizations/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.UntagResourceRequest/ResourceId
     :cognitect.aws.organizations.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.organizations/ServicePrincipal
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/TagKey
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/HandshakeResource
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.HandshakeResource/Type
     :cognitect.aws.organizations.HandshakeResource/Value
     :cognitect.aws.organizations.HandshakeResource/Resources]))

(s/def
  :cognitect.aws.organizations/TargetName
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.organizations/PolicyTypeStatus
  (s/spec string? :gen #(s/gen #{"PENDING_DISABLE" "PENDING_ENABLE" "ENABLED"})))

(s/def
  :cognitect.aws.organizations/OrganizationalUnit
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.OrganizationalUnit/Arn
     :cognitect.aws.organizations.OrganizationalUnit/Name
     :cognitect.aws.organizations.OrganizationalUnit/Id]))

(s/def
  :cognitect.aws.organizations/TaggableResourceId
  (s/spec
    #(re-matches
      (re-pattern
        "^(r-[0-9a-z]{4,32})|(\\d{12})|(ou-[0-9a-z]{4,32}-[a-z0-9]{8,32})|(^p-[0-9a-zA-Z_]{8,128})$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.organizations/EffectivePolicyType
  (s/spec string? :gen #(s/gen #{"TAG_POLICY" "AISERVICES_OPT_OUT_POLICY" "BACKUP_POLICY"})))

(s/def
  :cognitect.aws.organizations/HandshakePartyType
  (s/spec string? :gen #(s/gen #{"ORGANIZATION" "ACCOUNT" "EMAIL"})))

(s/def
  :cognitect.aws.organizations/PolicyId
  (s/spec #(re-matches (re-pattern "^p-[0-9a-zA-Z_]{8,128}$") %) :gen #(gen/string)))

(s/def :cognitect.aws.organizations/Timestamp inst?)

(s/def
  :cognitect.aws.organizations/ListHandshakesForOrganizationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListHandshakesForOrganizationRequest/Filter
     :cognitect.aws.organizations.ListHandshakesForOrganizationRequest/NextToken
     :cognitect.aws.organizations.ListHandshakesForOrganizationRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/HandshakeResources
  (s/coll-of :cognitect.aws.organizations/HandshakeResource))

(s/def
  :cognitect.aws.organizations/CreateGovCloudAccountResponse
  (s/keys :opt-un [:cognitect.aws.organizations.CreateGovCloudAccountResponse/CreateAccountStatus]))

(s/def
  :cognitect.aws.organizations/DescribeAccountRequest
  (s/keys :req-un [:cognitect.aws.organizations.DescribeAccountRequest/AccountId]))

(s/def
  :cognitect.aws.organizations/Root
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.Root/PolicyTypes
     :cognitect.aws.organizations.Root/Arn
     :cognitect.aws.organizations.Root/Name
     :cognitect.aws.organizations.Root/Id]))

(s/def
  :cognitect.aws.organizations/EffectivePolicy
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.EffectivePolicy/LastUpdatedTimestamp
     :cognitect.aws.organizations.EffectivePolicy/PolicyContent
     :cognitect.aws.organizations.EffectivePolicy/TargetId
     :cognitect.aws.organizations.EffectivePolicy/PolicyType]))

(s/def
  :cognitect.aws.organizations/DeletePolicyRequest
  (s/keys :req-un [:cognitect.aws.organizations.DeletePolicyRequest/PolicyId]))

(s/def
  :cognitect.aws.organizations/OrganizationalUnitId
  (s/spec #(re-matches (re-pattern "^ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/CreateAccountRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.CreateAccountRequest/Email
     :cognitect.aws.organizations.CreateAccountRequest/AccountName]
    :opt-un
    [:cognitect.aws.organizations.CreateAccountRequest/RoleName
     :cognitect.aws.organizations.CreateAccountRequest/IamUserAccessToBilling
     :cognitect.aws.organizations.CreateAccountRequest/Tags]))

(s/def
  :cognitect.aws.organizations/DisablePolicyTypeRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.DisablePolicyTypeRequest/RootId
     :cognitect.aws.organizations.DisablePolicyTypeRequest/PolicyType]))

(s/def
  :cognitect.aws.organizations/OrganizationId
  (s/spec #(re-matches (re-pattern "^o-[a-z0-9]{10,32}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/InviteAccountToOrganizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.InviteAccountToOrganizationRequest/Target]
    :opt-un
    [:cognitect.aws.organizations.InviteAccountToOrganizationRequest/Tags
     :cognitect.aws.organizations.InviteAccountToOrganizationRequest/Notes]))

(s/def
  :cognitect.aws.organizations/ChildType
  (s/spec string? :gen #(s/gen #{"ACCOUNT" "ORGANIZATIONAL_UNIT"})))

(s/def
  :cognitect.aws.organizations/ListChildrenRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.ListChildrenRequest/ParentId
     :cognitect.aws.organizations.ListChildrenRequest/ChildType]
    :opt-un
    [:cognitect.aws.organizations.ListChildrenRequest/NextToken
     :cognitect.aws.organizations.ListChildrenRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/OrganizationalUnitArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws:organizations::\\d{12}:ou\\/o-[a-z0-9]{10,32}\\/ou-[0-9a-z]{4,32}-[0-9a-z]{8,32}")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.organizations/Handshakes (s/coll-of :cognitect.aws.organizations/Handshake))

(s/def :cognitect.aws.organizations/TagKeys (s/coll-of :cognitect.aws.organizations/TagKey))

(s/def
  :cognitect.aws.organizations/ListPoliciesForTargetRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.ListPoliciesForTargetRequest/TargetId
     :cognitect.aws.organizations.ListPoliciesForTargetRequest/Filter]
    :opt-un
    [:cognitect.aws.organizations.ListPoliciesForTargetRequest/NextToken
     :cognitect.aws.organizations.ListPoliciesForTargetRequest/MaxResults]))

(s/def
  :cognitect.aws.organizations/PolicyTypeSummary
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.PolicyTypeSummary/Type
     :cognitect.aws.organizations.PolicyTypeSummary/Status]))

(s/def
  :cognitect.aws.organizations/Organization
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.Organization/MasterAccountEmail
     :cognitect.aws.organizations.Organization/FeatureSet
     :cognitect.aws.organizations.Organization/MasterAccountArn
     :cognitect.aws.organizations.Organization/AvailablePolicyTypes
     :cognitect.aws.organizations.Organization/MasterAccountId
     :cognitect.aws.organizations.Organization/Arn
     :cognitect.aws.organizations.Organization/Id]))

(s/def
  :cognitect.aws.organizations/ListDelegatedAdministratorsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListDelegatedAdministratorsResponse/NextToken
     :cognitect.aws.organizations.ListDelegatedAdministratorsResponse/DelegatedAdministrators]))

(s/def
  :cognitect.aws.organizations/DescribePolicyRequest
  (s/keys :req-un [:cognitect.aws.organizations.DescribePolicyRequest/PolicyId]))

(s/def
  :cognitect.aws.organizations/ListTagsForResourceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListTagsForResourceResponse/Tags
     :cognitect.aws.organizations.ListTagsForResourceResponse/NextToken]))

(s/def
  :cognitect.aws.organizations/DetachPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.DetachPolicyRequest/PolicyId
     :cognitect.aws.organizations.DetachPolicyRequest/TargetId]))

(s/def
  :cognitect.aws.organizations/CreateOrganizationRequest
  (s/keys :opt-un [:cognitect.aws.organizations.CreateOrganizationRequest/FeatureSet]))

(s/def
  :cognitect.aws.organizations/DeregisterDelegatedAdministratorRequest
  (s/keys
    :req-un
    [:cognitect.aws.organizations.DeregisterDelegatedAdministratorRequest/AccountId
     :cognitect.aws.organizations.DeregisterDelegatedAdministratorRequest/ServicePrincipal]))

(s/def
  :cognitect.aws.organizations/GenericArn
  (s/spec #(re-matches (re-pattern "^arn:aws:organizations::.+:.+") %) :gen #(gen/string)))

(s/def :cognitect.aws.organizations/EnableAllFeaturesRequest (s/keys))

(s/def
  :cognitect.aws.organizations/CreateOrganizationalUnitResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.CreateOrganizationalUnitResponse/OrganizationalUnit]))

(s/def
  :cognitect.aws.organizations/CancelHandshakeRequest
  (s/keys :req-un [:cognitect.aws.organizations.CancelHandshakeRequest/HandshakeId]))

(s/def
  :cognitect.aws.organizations/RootId
  (s/spec #(re-matches (re-pattern "^r-[0-9a-z]{4,32}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.organizations/ListAccountsForParentResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListAccountsForParentResponse/NextToken
     :cognitect.aws.organizations.ListAccountsForParentResponse/Accounts]))

(s/def
  :cognitect.aws.organizations/Policy
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.Policy/PolicySummary
     :cognitect.aws.organizations.Policy/Content]))

(s/def
  :cognitect.aws.organizations/ListParentsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.ListParentsResponse/NextToken
     :cognitect.aws.organizations.ListParentsResponse/Parents]))

(s/def
  :cognitect.aws.organizations/EnabledServicePrincipal
  (s/keys
    :opt-un
    [:cognitect.aws.organizations.EnabledServicePrincipal/ServicePrincipal
     :cognitect.aws.organizations.EnabledServicePrincipal/DateEnabled]))

(s/def
  :cognitect.aws.organizations.CreateGovCloudAccountRequest/Email
  :cognitect.aws.organizations/Email)

(s/def
  :cognitect.aws.organizations.CreateGovCloudAccountRequest/AccountName
  :cognitect.aws.organizations/CreateAccountName)

(s/def
  :cognitect.aws.organizations.CreateGovCloudAccountRequest/RoleName
  :cognitect.aws.organizations/RoleName)

(s/def
  :cognitect.aws.organizations.CreateGovCloudAccountRequest/IamUserAccessToBilling
  :cognitect.aws.organizations/IAMUserAccessToBilling)

(s/def
  :cognitect.aws.organizations.CreateGovCloudAccountRequest/Tags
  :cognitect.aws.organizations/Tags)

(s/def
  :cognitect.aws.organizations.RemoveAccountFromOrganizationRequest/AccountId
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.CreateAccountStatus/Id
  :cognitect.aws.organizations/CreateAccountRequestId)

(s/def
  :cognitect.aws.organizations.CreateAccountStatus/AccountName
  :cognitect.aws.organizations/CreateAccountName)

(s/def
  :cognitect.aws.organizations.CreateAccountStatus/State
  :cognitect.aws.organizations/CreateAccountState)

(s/def
  :cognitect.aws.organizations.CreateAccountStatus/RequestedTimestamp
  :cognitect.aws.organizations/Timestamp)

(s/def
  :cognitect.aws.organizations.CreateAccountStatus/CompletedTimestamp
  :cognitect.aws.organizations/Timestamp)

(s/def
  :cognitect.aws.organizations.CreateAccountStatus/AccountId
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.CreateAccountStatus/GovCloudAccountId
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.CreateAccountStatus/FailureReason
  :cognitect.aws.organizations/CreateAccountFailureReason)

(s/def
  :cognitect.aws.organizations.InviteAccountToOrganizationResponse/Handshake
  :cognitect.aws.organizations/Handshake)

(s/def
  :cognitect.aws.organizations.UpdatePolicyRequest/PolicyId
  :cognitect.aws.organizations/PolicyId)

(s/def
  :cognitect.aws.organizations.UpdatePolicyRequest/Name
  :cognitect.aws.organizations/PolicyName)

(s/def
  :cognitect.aws.organizations.UpdatePolicyRequest/Description
  :cognitect.aws.organizations/PolicyDescription)

(s/def
  :cognitect.aws.organizations.UpdatePolicyRequest/Content
  :cognitect.aws.organizations/PolicyContent)

(s/def
  :cognitect.aws.organizations.TagResourceRequest/ResourceId
  :cognitect.aws.organizations/TaggableResourceId)

(s/def :cognitect.aws.organizations.TagResourceRequest/Tags :cognitect.aws.organizations/Tags)

(s/def
  :cognitect.aws.organizations.ListAWSServiceAccessForOrganizationResponse/EnabledServicePrincipals
  :cognitect.aws.organizations/EnabledServicePrincipals)

(s/def
  :cognitect.aws.organizations.ListAWSServiceAccessForOrganizationResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListHandshakesForOrganizationResponse/Handshakes
  :cognitect.aws.organizations/Handshakes)

(s/def
  :cognitect.aws.organizations.ListHandshakesForOrganizationResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListTargetsForPolicyResponse/Targets
  :cognitect.aws.organizations/PolicyTargets)

(s/def
  :cognitect.aws.organizations.ListTargetsForPolicyResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.PolicyTargetSummary/TargetId
  :cognitect.aws.organizations/PolicyTargetId)

(s/def :cognitect.aws.organizations.PolicyTargetSummary/Arn :cognitect.aws.organizations/GenericArn)

(s/def
  :cognitect.aws.organizations.PolicyTargetSummary/Name
  :cognitect.aws.organizations/TargetName)

(s/def
  :cognitect.aws.organizations.PolicyTargetSummary/Type
  :cognitect.aws.organizations/TargetType)

(s/def :cognitect.aws.organizations.Tag/Key :cognitect.aws.organizations/TagKey)

(s/def :cognitect.aws.organizations.Tag/Value :cognitect.aws.organizations/TagValue)

(s/def
  :cognitect.aws.organizations.ListDelegatedServicesForAccountRequest/AccountId
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.ListDelegatedServicesForAccountRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListDelegatedServicesForAccountRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.DeclineHandshakeRequest/HandshakeId
  :cognitect.aws.organizations/HandshakeId)

(s/def
  :cognitect.aws.organizations.ListRootsRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListRootsRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.DelegatedAdministrator/Id
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.DelegatedAdministrator/Arn
  :cognitect.aws.organizations/AccountArn)

(s/def :cognitect.aws.organizations.DelegatedAdministrator/Email :cognitect.aws.organizations/Email)

(s/def
  :cognitect.aws.organizations.DelegatedAdministrator/Name
  :cognitect.aws.organizations/AccountName)

(s/def
  :cognitect.aws.organizations.DelegatedAdministrator/Status
  :cognitect.aws.organizations/AccountStatus)

(s/def
  :cognitect.aws.organizations.DelegatedAdministrator/JoinedMethod
  :cognitect.aws.organizations/AccountJoinedMethod)

(s/def
  :cognitect.aws.organizations.DelegatedAdministrator/JoinedTimestamp
  :cognitect.aws.organizations/Timestamp)

(s/def
  :cognitect.aws.organizations.DelegatedAdministrator/DelegationEnabledDate
  :cognitect.aws.organizations/Timestamp)

(s/def
  :cognitect.aws.organizations.ListAccountsRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListAccountsRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.ListHandshakesForAccountRequest/Filter
  :cognitect.aws.organizations/HandshakeFilter)

(s/def
  :cognitect.aws.organizations.ListHandshakesForAccountRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListHandshakesForAccountRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.CreateAccountResponse/CreateAccountStatus
  :cognitect.aws.organizations/CreateAccountStatus)

(s/def :cognitect.aws.organizations.ListParentsRequest/ChildId :cognitect.aws.organizations/ChildId)

(s/def
  :cognitect.aws.organizations.ListParentsRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListParentsRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.DeclineHandshakeResponse/Handshake
  :cognitect.aws.organizations/Handshake)

(s/def
  :cognitect.aws.organizations.ListChildrenResponse/Children
  :cognitect.aws.organizations/Children)

(s/def
  :cognitect.aws.organizations.ListChildrenResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.EnableAWSServiceAccessRequest/ServicePrincipal
  :cognitect.aws.organizations/ServicePrincipal)

(s/def
  :cognitect.aws.organizations.ListCreateAccountStatusRequest/States
  :cognitect.aws.organizations/CreateAccountStates)

(s/def
  :cognitect.aws.organizations.ListCreateAccountStatusRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListCreateAccountStatusRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def :cognitect.aws.organizations.PolicySummary/Id :cognitect.aws.organizations/PolicyId)

(s/def :cognitect.aws.organizations.PolicySummary/Arn :cognitect.aws.organizations/PolicyArn)

(s/def :cognitect.aws.organizations.PolicySummary/Name :cognitect.aws.organizations/PolicyName)

(s/def
  :cognitect.aws.organizations.PolicySummary/Description
  :cognitect.aws.organizations/PolicyDescription)

(s/def :cognitect.aws.organizations.PolicySummary/Type :cognitect.aws.organizations/PolicyType)

(s/def
  :cognitect.aws.organizations.PolicySummary/AwsManaged
  :cognitect.aws.organizations/AwsManagedPolicy)

(s/def :cognitect.aws.organizations.ListRootsResponse/Roots :cognitect.aws.organizations/Roots)

(s/def
  :cognitect.aws.organizations.ListRootsResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def :cognitect.aws.organizations.CreatePolicyResponse/Policy :cognitect.aws.organizations/Policy)

(s/def
  :cognitect.aws.organizations.DisableAWSServiceAccessRequest/ServicePrincipal
  :cognitect.aws.organizations/ServicePrincipal)

(s/def
  :cognitect.aws.organizations.CreateOrganizationalUnitRequest/ParentId
  :cognitect.aws.organizations/ParentId)

(s/def
  :cognitect.aws.organizations.CreateOrganizationalUnitRequest/Name
  :cognitect.aws.organizations/OrganizationalUnitName)

(s/def
  :cognitect.aws.organizations.CreateOrganizationalUnitRequest/Tags
  :cognitect.aws.organizations/Tags)

(s/def
  :cognitect.aws.organizations.AcceptHandshakeResponse/Handshake
  :cognitect.aws.organizations/Handshake)

(s/def
  :cognitect.aws.organizations.AcceptHandshakeRequest/HandshakeId
  :cognitect.aws.organizations/HandshakeId)

(s/def
  :cognitect.aws.organizations.CreateOrganizationResponse/Organization
  :cognitect.aws.organizations/Organization)

(s/def
  :cognitect.aws.organizations.DescribeOrganizationResponse/Organization
  :cognitect.aws.organizations/Organization)

(s/def
  :cognitect.aws.organizations.ListOrganizationalUnitsForParentResponse/OrganizationalUnits
  :cognitect.aws.organizations/OrganizationalUnits)

(s/def
  :cognitect.aws.organizations.ListOrganizationalUnitsForParentResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListDelegatedServicesForAccountResponse/DelegatedServices
  :cognitect.aws.organizations/DelegatedServices)

(s/def
  :cognitect.aws.organizations.ListDelegatedServicesForAccountResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListAccountsResponse/Accounts
  :cognitect.aws.organizations/Accounts)

(s/def
  :cognitect.aws.organizations.ListAccountsResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.DescribeEffectivePolicyResponse/EffectivePolicy
  :cognitect.aws.organizations/EffectivePolicy)

(s/def
  :cognitect.aws.organizations.EnableAllFeaturesResponse/Handshake
  :cognitect.aws.organizations/Handshake)

(s/def :cognitect.aws.organizations.UpdatePolicyResponse/Policy :cognitect.aws.organizations/Policy)

(s/def
  :cognitect.aws.organizations.DescribePolicyResponse/Policy
  :cognitect.aws.organizations/Policy)

(s/def :cognitect.aws.organizations.EnablePolicyTypeResponse/Root :cognitect.aws.organizations/Root)

(s/def
  :cognitect.aws.organizations.DescribeAccountResponse/Account
  :cognitect.aws.organizations/Account)

(s/def
  :cognitect.aws.organizations.ListAWSServiceAccessForOrganizationRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListAWSServiceAccessForOrganizationRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.ListDelegatedAdministratorsRequest/ServicePrincipal
  :cognitect.aws.organizations/ServicePrincipal)

(s/def
  :cognitect.aws.organizations.ListDelegatedAdministratorsRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListDelegatedAdministratorsRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.ListAccountsForParentRequest/ParentId
  :cognitect.aws.organizations/ParentId)

(s/def
  :cognitect.aws.organizations.ListAccountsForParentRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListAccountsForParentRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def :cognitect.aws.organizations.Handshake/Id :cognitect.aws.organizations/HandshakeId)

(s/def :cognitect.aws.organizations.Handshake/Arn :cognitect.aws.organizations/HandshakeArn)

(s/def :cognitect.aws.organizations.Handshake/Parties :cognitect.aws.organizations/HandshakeParties)

(s/def :cognitect.aws.organizations.Handshake/State :cognitect.aws.organizations/HandshakeState)

(s/def
  :cognitect.aws.organizations.Handshake/RequestedTimestamp
  :cognitect.aws.organizations/Timestamp)

(s/def
  :cognitect.aws.organizations.Handshake/ExpirationTimestamp
  :cognitect.aws.organizations/Timestamp)

(s/def :cognitect.aws.organizations.Handshake/Action :cognitect.aws.organizations/ActionType)

(s/def
  :cognitect.aws.organizations.Handshake/Resources
  :cognitect.aws.organizations/HandshakeResources)

(s/def
  :cognitect.aws.organizations.DescribeOrganizationalUnitResponse/OrganizationalUnit
  :cognitect.aws.organizations/OrganizationalUnit)

(s/def
  :cognitect.aws.organizations.EnablePolicyTypeRequest/RootId
  :cognitect.aws.organizations/RootId)

(s/def
  :cognitect.aws.organizations.EnablePolicyTypeRequest/PolicyType
  :cognitect.aws.organizations/PolicyType)

(s/def
  :cognitect.aws.organizations.UpdateOrganizationalUnitRequest/OrganizationalUnitId
  :cognitect.aws.organizations/OrganizationalUnitId)

(s/def
  :cognitect.aws.organizations.UpdateOrganizationalUnitRequest/Name
  :cognitect.aws.organizations/OrganizationalUnitName)

(s/def
  :cognitect.aws.organizations.DescribeCreateAccountStatusResponse/CreateAccountStatus
  :cognitect.aws.organizations/CreateAccountStatus)

(s/def
  :cognitect.aws.organizations.CancelHandshakeResponse/Handshake
  :cognitect.aws.organizations/Handshake)

(s/def
  :cognitect.aws.organizations.DescribeHandshakeRequest/HandshakeId
  :cognitect.aws.organizations/HandshakeId)

(s/def
  :cognitect.aws.organizations.HandshakeFilter/ActionType
  :cognitect.aws.organizations/ActionType)

(s/def
  :cognitect.aws.organizations.HandshakeFilter/ParentHandshakeId
  :cognitect.aws.organizations/HandshakeId)

(s/def
  :cognitect.aws.organizations.DescribeCreateAccountStatusRequest/CreateAccountRequestId
  :cognitect.aws.organizations/CreateAccountRequestId)

(s/def
  :cognitect.aws.organizations.ListPoliciesResponse/Policies
  :cognitect.aws.organizations/Policies)

(s/def
  :cognitect.aws.organizations.ListPoliciesResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListTagsForResourceRequest/ResourceId
  :cognitect.aws.organizations/TaggableResourceId)

(s/def
  :cognitect.aws.organizations.ListTagsForResourceRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListCreateAccountStatusResponse/CreateAccountStatuses
  :cognitect.aws.organizations/CreateAccountStatuses)

(s/def
  :cognitect.aws.organizations.ListCreateAccountStatusResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.DescribeEffectivePolicyRequest/PolicyType
  :cognitect.aws.organizations/EffectivePolicyType)

(s/def
  :cognitect.aws.organizations.DescribeEffectivePolicyRequest/TargetId
  :cognitect.aws.organizations/PolicyTargetId)

(s/def
  :cognitect.aws.organizations.DescribeHandshakeResponse/Handshake
  :cognitect.aws.organizations/Handshake)

(s/def
  :cognitect.aws.organizations.AttachPolicyRequest/PolicyId
  :cognitect.aws.organizations/PolicyId)

(s/def
  :cognitect.aws.organizations.AttachPolicyRequest/TargetId
  :cognitect.aws.organizations/PolicyTargetId)

(s/def
  :cognitect.aws.organizations.RegisterDelegatedAdministratorRequest/AccountId
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.RegisterDelegatedAdministratorRequest/ServicePrincipal
  :cognitect.aws.organizations/ServicePrincipal)

(s/def :cognitect.aws.organizations.Account/Id :cognitect.aws.organizations/AccountId)

(s/def :cognitect.aws.organizations.Account/Arn :cognitect.aws.organizations/AccountArn)

(s/def :cognitect.aws.organizations.Account/Email :cognitect.aws.organizations/Email)

(s/def :cognitect.aws.organizations.Account/Name :cognitect.aws.organizations/AccountName)

(s/def :cognitect.aws.organizations.Account/Status :cognitect.aws.organizations/AccountStatus)

(s/def
  :cognitect.aws.organizations.Account/JoinedMethod
  :cognitect.aws.organizations/AccountJoinedMethod)

(s/def :cognitect.aws.organizations.Account/JoinedTimestamp :cognitect.aws.organizations/Timestamp)

(s/def
  :cognitect.aws.organizations.MoveAccountRequest/AccountId
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.MoveAccountRequest/SourceParentId
  :cognitect.aws.organizations/ParentId)

(s/def
  :cognitect.aws.organizations.MoveAccountRequest/DestinationParentId
  :cognitect.aws.organizations/ParentId)

(s/def
  :cognitect.aws.organizations.ListOrganizationalUnitsForParentRequest/ParentId
  :cognitect.aws.organizations/ParentId)

(s/def
  :cognitect.aws.organizations.ListOrganizationalUnitsForParentRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListOrganizationalUnitsForParentRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.DelegatedService/ServicePrincipal
  :cognitect.aws.organizations/ServicePrincipal)

(s/def
  :cognitect.aws.organizations.DelegatedService/DelegationEnabledDate
  :cognitect.aws.organizations/Timestamp)

(s/def
  :cognitect.aws.organizations.ListPoliciesRequest/Filter
  :cognitect.aws.organizations/PolicyType)

(s/def
  :cognitect.aws.organizations.ListPoliciesRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListPoliciesRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.CloseAccountRequest/AccountId
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.DeleteOrganizationalUnitRequest/OrganizationalUnitId
  :cognitect.aws.organizations/OrganizationalUnitId)

(s/def
  :cognitect.aws.organizations.ListPoliciesForTargetResponse/Policies
  :cognitect.aws.organizations/Policies)

(s/def
  :cognitect.aws.organizations.ListPoliciesForTargetResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def :cognitect.aws.organizations.Child/Id :cognitect.aws.organizations/ChildId)

(s/def :cognitect.aws.organizations.Child/Type :cognitect.aws.organizations/ChildType)

(s/def
  :cognitect.aws.organizations.ListTargetsForPolicyRequest/PolicyId
  :cognitect.aws.organizations/PolicyId)

(s/def
  :cognitect.aws.organizations.ListTargetsForPolicyRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListTargetsForPolicyRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.DescribeOrganizationalUnitRequest/OrganizationalUnitId
  :cognitect.aws.organizations/OrganizationalUnitId)

(s/def
  :cognitect.aws.organizations.UpdateOrganizationalUnitResponse/OrganizationalUnit
  :cognitect.aws.organizations/OrganizationalUnit)

(s/def
  :cognitect.aws.organizations.ListHandshakesForAccountResponse/Handshakes
  :cognitect.aws.organizations/Handshakes)

(s/def
  :cognitect.aws.organizations.ListHandshakesForAccountResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.CreatePolicyRequest/Content
  :cognitect.aws.organizations/PolicyContent)

(s/def
  :cognitect.aws.organizations.CreatePolicyRequest/Description
  :cognitect.aws.organizations/PolicyDescription)

(s/def
  :cognitect.aws.organizations.CreatePolicyRequest/Name
  :cognitect.aws.organizations/PolicyName)

(s/def
  :cognitect.aws.organizations.CreatePolicyRequest/Type
  :cognitect.aws.organizations/PolicyType)

(s/def :cognitect.aws.organizations.CreatePolicyRequest/Tags :cognitect.aws.organizations/Tags)

(s/def :cognitect.aws.organizations.HandshakeParty/Id :cognitect.aws.organizations/HandshakePartyId)

(s/def
  :cognitect.aws.organizations.HandshakeParty/Type
  :cognitect.aws.organizations/HandshakePartyType)

(s/def :cognitect.aws.organizations.Parent/Id :cognitect.aws.organizations/ParentId)

(s/def :cognitect.aws.organizations.Parent/Type :cognitect.aws.organizations/ParentType)

(s/def
  :cognitect.aws.organizations.DisablePolicyTypeResponse/Root
  :cognitect.aws.organizations/Root)

(s/def
  :cognitect.aws.organizations.UntagResourceRequest/ResourceId
  :cognitect.aws.organizations/TaggableResourceId)

(s/def
  :cognitect.aws.organizations.UntagResourceRequest/TagKeys
  :cognitect.aws.organizations/TagKeys)

(s/def
  :cognitect.aws.organizations.HandshakeResource/Value
  :cognitect.aws.organizations/HandshakeResourceValue)

(s/def
  :cognitect.aws.organizations.HandshakeResource/Type
  :cognitect.aws.organizations/HandshakeResourceType)

(s/def
  :cognitect.aws.organizations.HandshakeResource/Resources
  :cognitect.aws.organizations/HandshakeResources)

(s/def
  :cognitect.aws.organizations.OrganizationalUnit/Id
  :cognitect.aws.organizations/OrganizationalUnitId)

(s/def
  :cognitect.aws.organizations.OrganizationalUnit/Arn
  :cognitect.aws.organizations/OrganizationalUnitArn)

(s/def
  :cognitect.aws.organizations.OrganizationalUnit/Name
  :cognitect.aws.organizations/OrganizationalUnitName)

(s/def
  :cognitect.aws.organizations.ListHandshakesForOrganizationRequest/Filter
  :cognitect.aws.organizations/HandshakeFilter)

(s/def
  :cognitect.aws.organizations.ListHandshakesForOrganizationRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListHandshakesForOrganizationRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.CreateGovCloudAccountResponse/CreateAccountStatus
  :cognitect.aws.organizations/CreateAccountStatus)

(s/def
  :cognitect.aws.organizations.DescribeAccountRequest/AccountId
  :cognitect.aws.organizations/AccountId)

(s/def :cognitect.aws.organizations.Root/Id :cognitect.aws.organizations/RootId)

(s/def :cognitect.aws.organizations.Root/Arn :cognitect.aws.organizations/RootArn)

(s/def :cognitect.aws.organizations.Root/Name :cognitect.aws.organizations/RootName)

(s/def :cognitect.aws.organizations.Root/PolicyTypes :cognitect.aws.organizations/PolicyTypes)

(s/def
  :cognitect.aws.organizations.EffectivePolicy/PolicyContent
  :cognitect.aws.organizations/PolicyContent)

(s/def
  :cognitect.aws.organizations.EffectivePolicy/LastUpdatedTimestamp
  :cognitect.aws.organizations/Timestamp)

(s/def
  :cognitect.aws.organizations.EffectivePolicy/TargetId
  :cognitect.aws.organizations/PolicyTargetId)

(s/def
  :cognitect.aws.organizations.EffectivePolicy/PolicyType
  :cognitect.aws.organizations/EffectivePolicyType)

(s/def
  :cognitect.aws.organizations.DeletePolicyRequest/PolicyId
  :cognitect.aws.organizations/PolicyId)

(s/def :cognitect.aws.organizations.CreateAccountRequest/Email :cognitect.aws.organizations/Email)

(s/def
  :cognitect.aws.organizations.CreateAccountRequest/AccountName
  :cognitect.aws.organizations/CreateAccountName)

(s/def
  :cognitect.aws.organizations.CreateAccountRequest/RoleName
  :cognitect.aws.organizations/RoleName)

(s/def
  :cognitect.aws.organizations.CreateAccountRequest/IamUserAccessToBilling
  :cognitect.aws.organizations/IAMUserAccessToBilling)

(s/def :cognitect.aws.organizations.CreateAccountRequest/Tags :cognitect.aws.organizations/Tags)

(s/def
  :cognitect.aws.organizations.DisablePolicyTypeRequest/RootId
  :cognitect.aws.organizations/RootId)

(s/def
  :cognitect.aws.organizations.DisablePolicyTypeRequest/PolicyType
  :cognitect.aws.organizations/PolicyType)

(s/def
  :cognitect.aws.organizations.InviteAccountToOrganizationRequest/Target
  :cognitect.aws.organizations/HandshakeParty)

(s/def
  :cognitect.aws.organizations.InviteAccountToOrganizationRequest/Notes
  :cognitect.aws.organizations/HandshakeNotes)

(s/def
  :cognitect.aws.organizations.InviteAccountToOrganizationRequest/Tags
  :cognitect.aws.organizations/Tags)

(s/def
  :cognitect.aws.organizations.ListChildrenRequest/ParentId
  :cognitect.aws.organizations/ParentId)

(s/def
  :cognitect.aws.organizations.ListChildrenRequest/ChildType
  :cognitect.aws.organizations/ChildType)

(s/def
  :cognitect.aws.organizations.ListChildrenRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListChildrenRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def
  :cognitect.aws.organizations.ListPoliciesForTargetRequest/TargetId
  :cognitect.aws.organizations/PolicyTargetId)

(s/def
  :cognitect.aws.organizations.ListPoliciesForTargetRequest/Filter
  :cognitect.aws.organizations/PolicyType)

(s/def
  :cognitect.aws.organizations.ListPoliciesForTargetRequest/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.ListPoliciesForTargetRequest/MaxResults
  :cognitect.aws.organizations/MaxResults)

(s/def :cognitect.aws.organizations.PolicyTypeSummary/Type :cognitect.aws.organizations/PolicyType)

(s/def
  :cognitect.aws.organizations.PolicyTypeSummary/Status
  :cognitect.aws.organizations/PolicyTypeStatus)

(s/def :cognitect.aws.organizations.Organization/Id :cognitect.aws.organizations/OrganizationId)

(s/def :cognitect.aws.organizations.Organization/Arn :cognitect.aws.organizations/OrganizationArn)

(s/def
  :cognitect.aws.organizations.Organization/FeatureSet
  :cognitect.aws.organizations/OrganizationFeatureSet)

(s/def
  :cognitect.aws.organizations.Organization/MasterAccountArn
  :cognitect.aws.organizations/AccountArn)

(s/def
  :cognitect.aws.organizations.Organization/MasterAccountId
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.Organization/MasterAccountEmail
  :cognitect.aws.organizations/Email)

(s/def
  :cognitect.aws.organizations.Organization/AvailablePolicyTypes
  :cognitect.aws.organizations/PolicyTypes)

(s/def
  :cognitect.aws.organizations.ListDelegatedAdministratorsResponse/DelegatedAdministrators
  :cognitect.aws.organizations/DelegatedAdministrators)

(s/def
  :cognitect.aws.organizations.ListDelegatedAdministratorsResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.DescribePolicyRequest/PolicyId
  :cognitect.aws.organizations/PolicyId)

(s/def
  :cognitect.aws.organizations.ListTagsForResourceResponse/Tags
  :cognitect.aws.organizations/Tags)

(s/def
  :cognitect.aws.organizations.ListTagsForResourceResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.DetachPolicyRequest/PolicyId
  :cognitect.aws.organizations/PolicyId)

(s/def
  :cognitect.aws.organizations.DetachPolicyRequest/TargetId
  :cognitect.aws.organizations/PolicyTargetId)

(s/def
  :cognitect.aws.organizations.CreateOrganizationRequest/FeatureSet
  :cognitect.aws.organizations/OrganizationFeatureSet)

(s/def
  :cognitect.aws.organizations.DeregisterDelegatedAdministratorRequest/AccountId
  :cognitect.aws.organizations/AccountId)

(s/def
  :cognitect.aws.organizations.DeregisterDelegatedAdministratorRequest/ServicePrincipal
  :cognitect.aws.organizations/ServicePrincipal)

(s/def
  :cognitect.aws.organizations.CreateOrganizationalUnitResponse/OrganizationalUnit
  :cognitect.aws.organizations/OrganizationalUnit)

(s/def
  :cognitect.aws.organizations.CancelHandshakeRequest/HandshakeId
  :cognitect.aws.organizations/HandshakeId)

(s/def
  :cognitect.aws.organizations.ListAccountsForParentResponse/Accounts
  :cognitect.aws.organizations/Accounts)

(s/def
  :cognitect.aws.organizations.ListAccountsForParentResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def :cognitect.aws.organizations.Policy/PolicySummary :cognitect.aws.organizations/PolicySummary)

(s/def :cognitect.aws.organizations.Policy/Content :cognitect.aws.organizations/PolicyContent)

(s/def
  :cognitect.aws.organizations.ListParentsResponse/Parents
  :cognitect.aws.organizations/Parents)

(s/def
  :cognitect.aws.organizations.ListParentsResponse/NextToken
  :cognitect.aws.organizations/NextToken)

(s/def
  :cognitect.aws.organizations.EnabledServicePrincipal/ServicePrincipal
  :cognitect.aws.organizations/ServicePrincipal)

(s/def
  :cognitect.aws.organizations.EnabledServicePrincipal/DateEnabled
  :cognitect.aws.organizations/Timestamp)

