;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.panorama.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def :cognitect.aws.panorama/OutputPortList (s/coll-of :cognitect.aws.panorama/NodeOutputPort))

(s/def
  :cognitect.aws.panorama/DeviceJobConfig
  (s/keys :opt-un [:cognitect.aws.panorama.DeviceJobConfig/OTAJobConfig]))

(s/def
  :cognitect.aws.panorama/NodeName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/IpAddressOrServerName
  (s/spec
    #(re-matches
      (re-pattern
        "(^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z]{2,}$)|(^((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d))(:(6553[0-5]|655[0-2]\\d|65[0-4]\\d{2}|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}))?$)")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.panorama/ManifestOverridesPayloadData
  (s/spec #(re-matches (re-pattern "^.*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/DescribeNodeFromTemplateJobResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/CreatedTime
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/JobId
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/LastUpdatedTime
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/NodeName
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/OutputPackageName
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/OutputPackageVersion
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/Status
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/StatusMessage
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/TemplateParameters
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/TemplateType]
    :opt-un
    [:cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/JobTags
     :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/NodeDescription]))

(s/def
  :cognitect.aws.panorama/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.TagResourceRequest/ResourceArn
     :cognitect.aws.panorama.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.panorama/ApplicationInstanceArn
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/NodeAssetName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/DeviceJob
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.DeviceJob/CreatedTime
     :cognitect.aws.panorama.DeviceJob/DeviceId
     :cognitect.aws.panorama.DeviceJob/DeviceName
     :cognitect.aws.panorama.DeviceJob/JobId]))

(s/def
  :cognitect.aws.panorama/StorageLocation
  (s/keys
    :req-un
    [:cognitect.aws.panorama.StorageLocation/BinaryPrefixLocation
     :cognitect.aws.panorama.StorageLocation/Bucket
     :cognitect.aws.panorama.StorageLocation/GeneratedPrefixLocation
     :cognitect.aws.panorama.StorageLocation/ManifestPrefixLocation
     :cognitect.aws.panorama.StorageLocation/RepoPrefixLocation]))

(s/def
  :cognitect.aws.panorama/DeviceId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/NodePackageArn
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/DefaultRuntimeContextDevice
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.panorama/TimeStamp inst?)

(s/def :cognitect.aws.panorama/NodesList (s/coll-of :cognitect.aws.panorama/Node))

(s/def
  :cognitect.aws.panorama/ListPackageImportJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListPackageImportJobsRequest/NextToken
     :cognitect.aws.panorama.ListPackageImportJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.panorama/StaticIpConnectionInfo
  (s/keys
    :req-un
    [:cognitect.aws.panorama.StaticIpConnectionInfo/DefaultGateway
     :cognitect.aws.panorama.StaticIpConnectionInfo/Dns
     :cognitect.aws.panorama.StaticIpConnectionInfo/IpAddress
     :cognitect.aws.panorama.StaticIpConnectionInfo/Mask]))

(s/def
  :cognitect.aws.panorama/ManifestOverridesPayload
  (s/keys :opt-un [:cognitect.aws.panorama.ManifestOverridesPayload/PayloadData]))

(s/def
  :cognitect.aws.panorama/UpdateDeviceMetadataResponse
  (s/keys :opt-un [:cognitect.aws.panorama.UpdateDeviceMetadataResponse/DeviceId]))

(s/def
  :cognitect.aws.panorama/TagMap
  (s/map-of
    :cognitect.aws.panorama/TagKey
    :cognitect.aws.panorama/TagValue
    :min-count
    0
    :max-count
    50))

(s/def
  :cognitect.aws.panorama/ApplicationInstanceStatusDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/LatestSoftware
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/ListDevicesJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListDevicesJobsRequest/NextToken
     :cognitect.aws.panorama.ListDevicesJobsRequest/DeviceId
     :cognitect.aws.panorama.ListDevicesJobsRequest/MaxResults]))

(s/def :cognitect.aws.panorama/JobTagsList (s/coll-of :cognitect.aws.panorama/JobResourceTags))

(s/def :cognitect.aws.panorama/DeregisterPackageVersionResponse (s/keys))

(s/def :cognitect.aws.panorama/NodeInstances (s/coll-of :cognitect.aws.panorama/NodeInstance))

(s/def
  :cognitect.aws.panorama/CreatePackageImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.CreatePackageImportJobRequest/ClientToken
     :cognitect.aws.panorama.CreatePackageImportJobRequest/InputConfig
     :cognitect.aws.panorama.CreatePackageImportJobRequest/JobType
     :cognitect.aws.panorama.CreatePackageImportJobRequest/OutputConfig]
    :opt-un
    [:cognitect.aws.panorama.CreatePackageImportJobRequest/JobTags]))

(s/def :cognitect.aws.panorama/TagResourceResponse (s/keys))

(s/def :cognitect.aws.panorama/MarkLatestPatch boolean?)

(s/def
  :cognitect.aws.panorama/ListDevicesJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListDevicesJobsResponse/DeviceJobs
     :cognitect.aws.panorama.ListDevicesJobsResponse/NextToken]))

(s/def :cognitect.aws.panorama/RemoveApplicationInstanceResponse (s/keys))

(s/def
  :cognitect.aws.panorama/IpAddress
  (s/spec
    #(re-matches
      (re-pattern
        "^((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d))(:(6553[0-5]|655[0-2]\\d|65[0-4]\\d{2}|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}))?$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.panorama/PackageImportJobOutput
  (s/keys
    :req-un
    [:cognitect.aws.panorama.PackageImportJobOutput/OutputS3Location
     :cognitect.aws.panorama.PackageImportJobOutput/PackageId
     :cognitect.aws.panorama.PackageImportJobOutput/PackageVersion
     :cognitect.aws.panorama.PackageImportJobOutput/PatchVersion]))

(s/def
  :cognitect.aws.panorama/DeviceType
  (s/spec string? :gen #(s/gen #{"PANORAMA_APPLIANCE" "PANORAMA_APPLIANCE_DEVELOPER_KIT"})))

(s/def
  :cognitect.aws.panorama/JobId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.panorama/MaxSize25 (s/spec (s/and int? #(<= 0 % 25)) :gen #(gen/choose 0 25)))

(s/def
  :cognitect.aws.panorama/DescribeApplicationInstanceRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DescribeApplicationInstanceRequest/ApplicationInstanceId]))

(s/def
  :cognitect.aws.panorama/ApplicationInstanceHealthStatus
  (s/spec string? :gen #(s/gen #{"ERROR" "NOT_AVAILABLE" "RUNNING"})))

(s/def :cognitect.aws.panorama/UpdateCreatedTime inst?)

(s/def
  :cognitect.aws.panorama/ListApplicationInstanceNodeInstancesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListApplicationInstanceNodeInstancesResponse/NextToken
     :cognitect.aws.panorama.ListApplicationInstanceNodeInstancesResponse/NodeInstances]))

(s/def
  :cognitect.aws.panorama/PackageImportJobInputConfig
  (s/keys :opt-un [:cognitect.aws.panorama.PackageImportJobInputConfig/PackageVersionInputConfig]))

(s/def
  :cognitect.aws.panorama/ListNodeFromTemplateJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListNodeFromTemplateJobsRequest/NextToken
     :cognitect.aws.panorama.ListNodeFromTemplateJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.panorama/DescribePackageVersionResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DescribePackageVersionResponse/IsLatestPatch
     :cognitect.aws.panorama.DescribePackageVersionResponse/PackageId
     :cognitect.aws.panorama.DescribePackageVersionResponse/PackageName
     :cognitect.aws.panorama.DescribePackageVersionResponse/PackageVersion
     :cognitect.aws.panorama.DescribePackageVersionResponse/PatchVersion
     :cognitect.aws.panorama.DescribePackageVersionResponse/Status]
    :opt-un
    [:cognitect.aws.panorama.DescribePackageVersionResponse/PackageArn
     :cognitect.aws.panorama.DescribePackageVersionResponse/OwnerAccount
     :cognitect.aws.panorama.DescribePackageVersionResponse/RegisteredTime
     :cognitect.aws.panorama.DescribePackageVersionResponse/StatusDescription]))

(s/def
  :cognitect.aws.panorama/Token
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/DeviceBrand
  (s/spec string? :gen #(s/gen #{"AWS_PANORAMA" "LENOVO"})))

(s/def
  :cognitect.aws.panorama/EthernetStatus
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.EthernetStatus/HwAddress
     :cognitect.aws.panorama.EthernetStatus/ConnectionStatus
     :cognitect.aws.panorama.EthernetStatus/IpAddress]))

(s/def :cognitect.aws.panorama/Bucket string?)

(s/def
  :cognitect.aws.panorama/JobResourceTags
  (s/keys
    :req-un
    [:cognitect.aws.panorama.JobResourceTags/ResourceType
     :cognitect.aws.panorama.JobResourceTags/Tags]))

(s/def
  :cognitect.aws.panorama/ListNodesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListNodesRequest/Category
     :cognitect.aws.panorama.ListNodesRequest/PackageVersion
     :cognitect.aws.panorama.ListNodesRequest/OwnerAccount
     :cognitect.aws.panorama.ListNodesRequest/NextToken
     :cognitect.aws.panorama.ListNodesRequest/PackageName
     :cognitect.aws.panorama.ListNodesRequest/PatchVersion
     :cognitect.aws.panorama.ListNodesRequest/MaxResults]))

(s/def
  :cognitect.aws.panorama/DeviceConnectionStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"ERROR" "AWAITING_CREDENTIALS" "NOT_AVAILABLE" "OFFLINE" "ONLINE"})))

(s/def
  :cognitect.aws.panorama/DeviceName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/DescribePackageVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DescribePackageVersionRequest/PackageId
     :cognitect.aws.panorama.DescribePackageVersionRequest/PackageVersion]
    :opt-un
    [:cognitect.aws.panorama.DescribePackageVersionRequest/OwnerAccount
     :cognitect.aws.panorama.DescribePackageVersionRequest/PatchVersion]))

(s/def
  :cognitect.aws.panorama/ListNodeFromTemplateJobsResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.ListNodeFromTemplateJobsResponse/NodeFromTemplateJobs]
    :opt-un
    [:cognitect.aws.panorama.ListNodeFromTemplateJobsResponse/NextToken]))

(s/def
  :cognitect.aws.panorama/CreateJobForDevicesRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.CreateJobForDevicesRequest/DeviceIds
     :cognitect.aws.panorama.CreateJobForDevicesRequest/DeviceJobConfig
     :cognitect.aws.panorama.CreateJobForDevicesRequest/JobType]))

(s/def
  :cognitect.aws.panorama/NodeCategory
  (s/spec string? :gen #(s/gen #{"ML_MODEL" "MEDIA_SOURCE" "BUSINESS_LOGIC" "MEDIA_SINK"})))

(s/def :cognitect.aws.panorama/LastUpdatedTime inst?)

(s/def :cognitect.aws.panorama/LeaseExpirationTime inst?)

(s/def :cognitect.aws.panorama/DeletePackageResponse (s/keys))

(s/def :cognitect.aws.panorama/NodeFromTemplateJobStatusMessage string?)

(s/def
  :cognitect.aws.panorama/AlternateSoftwareMetadata
  (s/keys :opt-un [:cognitect.aws.panorama.AlternateSoftwareMetadata/Version]))

(s/def
  :cognitect.aws.panorama/DescribePackageRequest
  (s/keys :req-un [:cognitect.aws.panorama.DescribePackageRequest/PackageId]))

(s/def
  :cognitect.aws.panorama/PortName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/ObjectKey
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/CreateNodeFromTemplateJobResponse
  (s/keys :req-un [:cognitect.aws.panorama.CreateNodeFromTemplateJobResponse/JobId]))

(s/def
  :cognitect.aws.panorama/ApplicationInstanceStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DEPLOYMENT_ERROR" "DEPLOYMENT_IN_PROGRESS" "REMOVAL_SUCCEEDED" "DEPLOYMENT_PENDING"
        "REMOVAL_FAILED" "REMOVAL_IN_PROGRESS" "DEPLOYMENT_FAILED" "REMOVAL_PENDING"
        "REMOVAL_REQUESTED" "DEPLOYMENT_SUCCEEDED" "DEPLOYMENT_REQUESTED"})))

(s/def
  :cognitect.aws.panorama/ManifestPayload
  (s/keys :opt-un [:cognitect.aws.panorama.ManifestPayload/PayloadData]))

(s/def :cognitect.aws.panorama/PackageObjects (s/coll-of :cognitect.aws.panorama/PackageObject))

(s/def
  :cognitect.aws.panorama/DeviceArn
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.panorama/InputPortList (s/coll-of :cognitect.aws.panorama/NodeInputPort))

(s/def :cognitect.aws.panorama/JobResourceType (s/spec string? :gen #(s/gen #{"PACKAGE"})))

(s/def
  :cognitect.aws.panorama/ListPackagesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListPackagesRequest/NextToken
     :cognitect.aws.panorama.ListPackagesRequest/MaxResults]))

(s/def
  :cognitect.aws.panorama/NtpServerName
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/DescribePackageImportJobRequest
  (s/keys :req-un [:cognitect.aws.panorama.DescribePackageImportJobRequest/JobId]))

(s/def :cognitect.aws.panorama/PrincipalArnsList (s/coll-of :cognitect.aws.panorama/PrincipalArn))

(s/def
  :cognitect.aws.panorama/DescribePackageImportJobResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DescribePackageImportJobResponse/CreatedTime
     :cognitect.aws.panorama.DescribePackageImportJobResponse/InputConfig
     :cognitect.aws.panorama.DescribePackageImportJobResponse/JobId
     :cognitect.aws.panorama.DescribePackageImportJobResponse/JobType
     :cognitect.aws.panorama.DescribePackageImportJobResponse/LastUpdatedTime
     :cognitect.aws.panorama.DescribePackageImportJobResponse/Output
     :cognitect.aws.panorama.DescribePackageImportJobResponse/OutputConfig
     :cognitect.aws.panorama.DescribePackageImportJobResponse/Status
     :cognitect.aws.panorama.DescribePackageImportJobResponse/StatusMessage]
    :opt-un
    [:cognitect.aws.panorama.DescribePackageImportJobResponse/JobTags
     :cognitect.aws.panorama.DescribePackageImportJobResponse/ClientToken]))

(s/def
  :cognitect.aws.panorama/PackageImportJobOutputConfig
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.PackageImportJobOutputConfig/PackageVersionOutputConfig]))

(s/def
  :cognitect.aws.panorama/DefaultGateway
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.panorama/Boolean boolean?)

(s/def
  :cognitect.aws.panorama/NodeFromTemplateJobList
  (s/coll-of :cognitect.aws.panorama/NodeFromTemplateJob))

(s/def
  :cognitect.aws.panorama/CreateJobForDevicesResponse
  (s/keys :req-un [:cognitect.aws.panorama.CreateJobForDevicesResponse/Jobs]))

(s/def
  :cognitect.aws.panorama/ListNodesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListNodesResponse/Nodes
     :cognitect.aws.panorama.ListNodesResponse/NextToken]))

(s/def
  :cognitect.aws.panorama/PackageObject
  (s/keys
    :req-un
    [:cognitect.aws.panorama.PackageObject/Name
     :cognitect.aws.panorama.PackageObject/PackageVersion
     :cognitect.aws.panorama.PackageObject/PatchVersion]))

(s/def
  :cognitect.aws.panorama/S3Location
  (s/keys
    :req-un
    [:cognitect.aws.panorama.S3Location/BucketName :cognitect.aws.panorama.S3Location/ObjectKey]
    :opt-un
    [:cognitect.aws.panorama.S3Location/Region]))

(s/def
  :cognitect.aws.panorama/DescribeApplicationInstanceDetailsRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DescribeApplicationInstanceDetailsRequest/ApplicationInstanceId]))

(s/def
  :cognitect.aws.panorama/CreateApplicationInstanceRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.CreateApplicationInstanceRequest/DefaultRuntimeContextDevice
     :cognitect.aws.panorama.CreateApplicationInstanceRequest/ManifestPayload]
    :opt-un
    [:cognitect.aws.panorama.CreateApplicationInstanceRequest/RuntimeRoleArn
     :cognitect.aws.panorama.CreateApplicationInstanceRequest/Tags
     :cognitect.aws.panorama.CreateApplicationInstanceRequest/Description
     :cognitect.aws.panorama.CreateApplicationInstanceRequest/ManifestOverridesPayload
     :cognitect.aws.panorama.CreateApplicationInstanceRequest/Name
     :cognitect.aws.panorama.CreateApplicationInstanceRequest/ApplicationInstanceIdToReplace]))

(s/def :cognitect.aws.panorama/PackageImportJobStatusMessage string?)

(s/def
  :cognitect.aws.panorama/ApplicationInstanceName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.panorama/DnsList (s/coll-of :cognitect.aws.panorama/Dns))

(s/def
  :cognitect.aws.panorama/DeviceIdList
  (s/coll-of :cognitect.aws.panorama/DeviceId :min-count 1 :max-count 1))

(s/def
  :cognitect.aws.panorama/NodeFromTemplateJob
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.NodeFromTemplateJob/StatusMessage
     :cognitect.aws.panorama.NodeFromTemplateJob/Status
     :cognitect.aws.panorama.NodeFromTemplateJob/CreatedTime
     :cognitect.aws.panorama.NodeFromTemplateJob/NodeName
     :cognitect.aws.panorama.NodeFromTemplateJob/TemplateType
     :cognitect.aws.panorama.NodeFromTemplateJob/JobId]))

(s/def
  :cognitect.aws.panorama/NodeFromTemplateJobStatus
  (s/spec string? :gen #(s/gen #{"PENDING" "SUCCEEDED" "FAILED"})))

(s/def
  :cognitect.aws.panorama/RemoveApplicationInstanceRequest
  (s/keys :req-un [:cognitect.aws.panorama.RemoveApplicationInstanceRequest/ApplicationInstanceId]))

(s/def
  :cognitect.aws.panorama/PackageVersionInputConfig
  (s/keys :req-un [:cognitect.aws.panorama.PackageVersionInputConfig/S3Location]))

(s/def
  :cognitect.aws.panorama/ListPackagesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListPackagesResponse/NextToken
     :cognitect.aws.panorama.ListPackagesResponse/Packages]))

(s/def
  :cognitect.aws.panorama/NodeInterface
  (s/keys
    :req-un
    [:cognitect.aws.panorama.NodeInterface/Inputs :cognitect.aws.panorama.NodeInterface/Outputs]))

(s/def
  :cognitect.aws.panorama/AlternateSoftwares
  (s/coll-of :cognitect.aws.panorama/AlternateSoftwareMetadata))

(s/def
  :cognitect.aws.panorama/NextToken
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/IotThingName
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/Certificates
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.panorama/OTAJobConfig
  (s/keys :req-un [:cognitect.aws.panorama.OTAJobConfig/ImageVersion]))

(s/def
  :cognitect.aws.panorama/HwAddress
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/PackageListItem
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.PackageListItem/Tags
     :cognitect.aws.panorama.PackageListItem/CreatedTime
     :cognitect.aws.panorama.PackageListItem/PackageName
     :cognitect.aws.panorama.PackageListItem/Arn
     :cognitect.aws.panorama.PackageListItem/PackageId]))

(s/def
  :cognitect.aws.panorama/ListApplicationInstancesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListApplicationInstancesResponse/NextToken
     :cognitect.aws.panorama.ListApplicationInstancesResponse/ApplicationInstances]))

(s/def
  :cognitect.aws.panorama/TagValue
  (s/spec #(re-matches (re-pattern "^.*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/DeviceSerialNumber
  (s/spec #(re-matches (re-pattern "^[0-9]{1,20}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/NodePackagePatchVersion
  (s/spec #(re-matches (re-pattern "^[a-z0-9]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.panorama.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.panorama/NetworkStatus
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.NetworkStatus/Ethernet1Status
     :cognitect.aws.panorama.NetworkStatus/NtpStatus
     :cognitect.aws.panorama.NetworkStatus/LastUpdatedTime
     :cognitect.aws.panorama.NetworkStatus/Ethernet0Status]))

(s/def
  :cognitect.aws.panorama/DescribeNodeFromTemplateJobRequest
  (s/keys :req-un [:cognitect.aws.panorama.DescribeNodeFromTemplateJobRequest/JobId]))

(s/def
  :cognitect.aws.panorama/Job
  (s/keys :opt-un [:cognitect.aws.panorama.Job/DeviceId :cognitect.aws.panorama.Job/JobId]))

(s/def
  :cognitect.aws.panorama/NetworkConnectionStatus
  (s/spec string? :gen #(s/gen #{"NOT_CONNECTED" "CONNECTED" "CONNECTING"})))

(s/def :cognitect.aws.panorama/ConnectionType (s/spec string? :gen #(s/gen #{"STATIC_IP" "DHCP"})))

(s/def :cognitect.aws.panorama/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.panorama/CreatePackageRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.CreatePackageRequest/PackageName]
    :opt-un
    [:cognitect.aws.panorama.CreatePackageRequest/Tags]))

(s/def
  :cognitect.aws.panorama/PackageOwnerAccount
  (s/spec #(re-matches (re-pattern "^[0-9a-z\\_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/NtpStatus
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.NtpStatus/ConnectionStatus
     :cognitect.aws.panorama.NtpStatus/IpAddress
     :cognitect.aws.panorama.NtpStatus/NtpServerName]))

(s/def
  :cognitect.aws.panorama/ProvisionDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.ProvisionDeviceRequest/Name]
    :opt-un
    [:cognitect.aws.panorama.ProvisionDeviceRequest/Tags
     :cognitect.aws.panorama.ProvisionDeviceRequest/Description
     :cognitect.aws.panorama.ProvisionDeviceRequest/NetworkingConfiguration]))

(s/def
  :cognitect.aws.panorama/ManifestPayloadData
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/NodeOutputPort
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.NodeOutputPort/Type
     :cognitect.aws.panorama.NodeOutputPort/Description
     :cognitect.aws.panorama.NodeOutputPort/Name]))

(s/def
  :cognitect.aws.panorama/RuntimeRoleArn
  (s/spec
    #(re-matches (re-pattern "^arn:[a-z0-9][-.a-z0-9]{0,62}:iam::[0-9]{12}:role/.+$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.panorama/DescribePackageResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DescribePackageResponse/Arn
     :cognitect.aws.panorama.DescribePackageResponse/CreatedTime
     :cognitect.aws.panorama.DescribePackageResponse/PackageId
     :cognitect.aws.panorama.DescribePackageResponse/PackageName
     :cognitect.aws.panorama.DescribePackageResponse/StorageLocation
     :cognitect.aws.panorama.DescribePackageResponse/Tags]
    :opt-un
    [:cognitect.aws.panorama.DescribePackageResponse/WriteAccessPrincipalArns
     :cognitect.aws.panorama.DescribePackageResponse/ReadAccessPrincipalArns]))

(s/def
  :cognitect.aws.panorama/Region
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/ApplicationInstance
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ApplicationInstance/DefaultRuntimeContextDevice
     :cognitect.aws.panorama.ApplicationInstance/DefaultRuntimeContextDeviceName
     :cognitect.aws.panorama.ApplicationInstance/Tags
     :cognitect.aws.panorama.ApplicationInstance/HealthStatus
     :cognitect.aws.panorama.ApplicationInstance/Status
     :cognitect.aws.panorama.ApplicationInstance/CreatedTime
     :cognitect.aws.panorama.ApplicationInstance/ApplicationInstanceId
     :cognitect.aws.panorama.ApplicationInstance/StatusDescription
     :cognitect.aws.panorama.ApplicationInstance/Description
     :cognitect.aws.panorama.ApplicationInstance/Arn
     :cognitect.aws.panorama.ApplicationInstance/Name]))

(s/def
  :cognitect.aws.panorama/CreateNodeFromTemplateJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/NodeName
     :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/OutputPackageName
     :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/OutputPackageVersion
     :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/TemplateParameters
     :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/TemplateType]
    :opt-un
    [:cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/JobTags
     :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/NodeDescription]))

(s/def
  :cognitect.aws.panorama/DescribeNodeRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DescribeNodeRequest/NodeId]
    :opt-un
    [:cognitect.aws.panorama.DescribeNodeRequest/OwnerAccount]))

(s/def :cognitect.aws.panorama/Dns (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/ListApplicationInstanceDependenciesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListApplicationInstanceDependenciesResponse/PackageObjects
     :cognitect.aws.panorama.ListApplicationInstanceDependenciesResponse/NextToken]))

(s/def
  :cognitect.aws.panorama/TemplateValue
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.panorama/DeviceJobList (s/coll-of :cognitect.aws.panorama/DeviceJob))

(s/def
  :cognitect.aws.panorama/PackageImportJob
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.PackageImportJob/JobType
     :cognitect.aws.panorama.PackageImportJob/StatusMessage
     :cognitect.aws.panorama.PackageImportJob/Status
     :cognitect.aws.panorama.PackageImportJob/CreatedTime
     :cognitect.aws.panorama.PackageImportJob/LastUpdatedTime
     :cognitect.aws.panorama.PackageImportJob/JobId]))

(s/def
  :cognitect.aws.panorama/NtpPayload
  (s/keys :req-un [:cognitect.aws.panorama.NtpPayload/NtpServers]))

(s/def
  :cognitect.aws.panorama/PortType
  (s/spec string? :gen #(s/gen #{"STRING" "INT32" "FLOAT32" "MEDIA" "BOOLEAN"})))

(s/def
  :cognitect.aws.panorama/NodeInstance
  (s/keys
    :req-un
    [:cognitect.aws.panorama.NodeInstance/CurrentStatus
     :cognitect.aws.panorama.NodeInstance/NodeInstanceId]
    :opt-un
    [:cognitect.aws.panorama.NodeInstance/NodeId
     :cognitect.aws.panorama.NodeInstance/PackageVersion
     :cognitect.aws.panorama.NodeInstance/NodeName
     :cognitect.aws.panorama.NodeInstance/PackageName
     :cognitect.aws.panorama.NodeInstance/PackagePatchVersion]))

(s/def
  :cognitect.aws.panorama/StatusFilter
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DEPLOYMENT_ERROR" "PROCESSING_DEPLOYMENT" "REMOVAL_SUCCEEDED" "PROCESSING_REMOVAL"
        "REMOVAL_FAILED" "DEPLOYMENT_FAILED" "DEPLOYMENT_SUCCEEDED"})))

(s/def
  :cognitect.aws.panorama/NodeInstanceStatus
  (s/spec string? :gen #(s/gen #{"ERROR" "NOT_AVAILABLE" "RUNNING"})))

(s/def
  :cognitect.aws.panorama/ListApplicationInstancesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListApplicationInstancesRequest/StatusFilter
     :cognitect.aws.panorama.ListApplicationInstancesRequest/NextToken
     :cognitect.aws.panorama.ListApplicationInstancesRequest/DeviceId
     :cognitect.aws.panorama.ListApplicationInstancesRequest/MaxResults]))

(s/def
  :cognitect.aws.panorama/CreateApplicationInstanceResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.CreateApplicationInstanceResponse/ApplicationInstanceId]))

(s/def
  :cognitect.aws.panorama/ListDevicesResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.ListDevicesResponse/Devices]
    :opt-un
    [:cognitect.aws.panorama.ListDevicesResponse/NextToken]))

(s/def
  :cognitect.aws.panorama/DeleteDeviceResponse
  (s/keys :opt-un [:cognitect.aws.panorama.DeleteDeviceResponse/DeviceId]))

(s/def
  :cognitect.aws.panorama/DescribeDeviceRequest
  (s/keys :req-un [:cognitect.aws.panorama.DescribeDeviceRequest/DeviceId]))

(s/def :cognitect.aws.panorama/Mask (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/DeregisterPackageVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DeregisterPackageVersionRequest/PackageId
     :cognitect.aws.panorama.DeregisterPackageVersionRequest/PackageVersion
     :cognitect.aws.panorama.DeregisterPackageVersionRequest/PatchVersion]
    :opt-un
    [:cognitect.aws.panorama.DeregisterPackageVersionRequest/OwnerAccount
     :cognitect.aws.panorama.DeregisterPackageVersionRequest/UpdatedLatestPatchVersion]))

(s/def
  :cognitect.aws.panorama/CurrentSoftware
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/ApplicationInstances
  (s/coll-of :cognitect.aws.panorama/ApplicationInstance))

(s/def
  :cognitect.aws.panorama/DescribeDeviceJobRequest
  (s/keys :req-un [:cognitect.aws.panorama.DescribeDeviceJobRequest/JobId]))

(s/def
  :cognitect.aws.panorama/CreatePackageResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.CreatePackageResponse/StorageLocation]
    :opt-un
    [:cognitect.aws.panorama.CreatePackageResponse/Arn
     :cognitect.aws.panorama.CreatePackageResponse/PackageId]))

(s/def
  :cognitect.aws.panorama/ApplicationInstanceId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/BucketName
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/TemplateParametersMap
  (s/map-of :cognitect.aws.panorama/TemplateKey :cognitect.aws.panorama/TemplateValue))

(s/def
  :cognitect.aws.panorama/UpdateDeviceMetadataRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.UpdateDeviceMetadataRequest/DeviceId]
    :opt-un
    [:cognitect.aws.panorama.UpdateDeviceMetadataRequest/Description]))

(s/def
  :cognitect.aws.panorama/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.UntagResourceRequest/ResourceArn
     :cognitect.aws.panorama.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.panorama/TagKey
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/PackageVersionOutputConfig
  (s/keys
    :req-un
    [:cognitect.aws.panorama.PackageVersionOutputConfig/PackageName
     :cognitect.aws.panorama.PackageVersionOutputConfig/PackageVersion]
    :opt-un
    [:cognitect.aws.panorama.PackageVersionOutputConfig/MarkLatest]))

(s/def
  :cognitect.aws.panorama/PackageImportJobStatus
  (s/spec string? :gen #(s/gen #{"PENDING" "SUCCEEDED" "FAILED"})))

(s/def
  :cognitect.aws.panorama/NodePackageVersion
  (s/spec #(re-matches (re-pattern "^([0-9]+)\\.([0-9]+)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/Node
  (s/keys
    :req-un
    [:cognitect.aws.panorama.Node/Category
     :cognitect.aws.panorama.Node/CreatedTime
     :cognitect.aws.panorama.Node/Name
     :cognitect.aws.panorama.Node/NodeId
     :cognitect.aws.panorama.Node/PackageId
     :cognitect.aws.panorama.Node/PackageName
     :cognitect.aws.panorama.Node/PackageVersion
     :cognitect.aws.panorama.Node/PatchVersion]
    :opt-un
    [:cognitect.aws.panorama.Node/PackageArn
     :cognitect.aws.panorama.Node/OwnerAccount
     :cognitect.aws.panorama.Node/Description]))

(s/def
  :cognitect.aws.panorama/ListDevicesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.ListDevicesRequest/NextToken
     :cognitect.aws.panorama.ListDevicesRequest/MaxResults]))

(s/def
  :cognitect.aws.panorama/Description
  (s/spec #(re-matches (re-pattern "^.*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/ListApplicationInstanceDependenciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.ListApplicationInstanceDependenciesRequest/ApplicationInstanceId]
    :opt-un
    [:cognitect.aws.panorama.ListApplicationInstanceDependenciesRequest/NextToken
     :cognitect.aws.panorama.ListApplicationInstanceDependenciesRequest/MaxResults]))

(s/def
  :cognitect.aws.panorama/DeleteDeviceRequest
  (s/keys :req-un [:cognitect.aws.panorama.DeleteDeviceRequest/DeviceId]))

(s/def :cognitect.aws.panorama/TemplateType (s/spec string? :gen #(s/gen #{"RTSP_CAMERA_STREAM"})))

(s/def :cognitect.aws.panorama/RegisterPackageVersionResponse (s/keys))

(s/def
  :cognitect.aws.panorama/ClientToken
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.panorama/JobList (s/coll-of :cognitect.aws.panorama/Job))

(s/def
  :cognitect.aws.panorama/NodePackageId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_\\/]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/NtpServerList
  (s/coll-of :cognitect.aws.panorama/IpAddressOrServerName :min-count 0 :max-count 5))

(s/def :cognitect.aws.panorama/CreatedTime inst?)

(s/def
  :cognitect.aws.panorama/TemplateKey
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/NodePackageName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.panorama/DeviceList (s/coll-of :cognitect.aws.panorama/Device))

(s/def
  :cognitect.aws.panorama/ResourceArn
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/DescribeNodeResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DescribeNodeResponse/Category
     :cognitect.aws.panorama.DescribeNodeResponse/CreatedTime
     :cognitect.aws.panorama.DescribeNodeResponse/Description
     :cognitect.aws.panorama.DescribeNodeResponse/LastUpdatedTime
     :cognitect.aws.panorama.DescribeNodeResponse/Name
     :cognitect.aws.panorama.DescribeNodeResponse/NodeId
     :cognitect.aws.panorama.DescribeNodeResponse/NodeInterface
     :cognitect.aws.panorama.DescribeNodeResponse/OwnerAccount
     :cognitect.aws.panorama.DescribeNodeResponse/PackageId
     :cognitect.aws.panorama.DescribeNodeResponse/PackageName
     :cognitect.aws.panorama.DescribeNodeResponse/PackageVersion
     :cognitect.aws.panorama.DescribeNodeResponse/PatchVersion]
    :opt-un
    [:cognitect.aws.panorama.DescribeNodeResponse/PackageArn
     :cognitect.aws.panorama.DescribeNodeResponse/AssetName]))

(s/def
  :cognitect.aws.panorama/PackageVersionStatusDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/EthernetPayload
  (s/keys
    :req-un
    [:cognitect.aws.panorama.EthernetPayload/ConnectionType]
    :opt-un
    [:cognitect.aws.panorama.EthernetPayload/StaticIpConnectionInfo]))

(s/def
  :cognitect.aws.panorama/NodeInstanceId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/PackageImportJobList
  (s/coll-of :cognitect.aws.panorama/PackageImportJob))

(s/def :cognitect.aws.panorama/JobType (s/spec string? :gen #(s/gen #{"OTA"})))

(s/def :cognitect.aws.panorama/Object string?)

(s/def
  :cognitect.aws.panorama/LatestAlternateSoftware
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/ListApplicationInstanceNodeInstancesRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.ListApplicationInstanceNodeInstancesRequest/ApplicationInstanceId]
    :opt-un
    [:cognitect.aws.panorama.ListApplicationInstanceNodeInstancesRequest/NextToken
     :cognitect.aws.panorama.ListApplicationInstanceNodeInstancesRequest/MaxResults]))

(s/def
  :cognitect.aws.panorama/DeviceStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"AWAITING_PROVISIONING" "PENDING" "ERROR" "SUCCEEDED" "DELETING" "FAILED"})))

(s/def
  :cognitect.aws.panorama/ImageVersion
  (s/spec #(re-matches (re-pattern "^.+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/PrincipalArn
  (s/spec
    #(re-matches
      (re-pattern "^arn:[a-z0-9][-.a-z0-9]{0,62}:iam::[0-9]{12}:[a-zA-Z0-9+=,.@\\-_/]+$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.panorama/Device
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.Device/CreatedTime
     :cognitect.aws.panorama.Device/ProvisioningStatus
     :cognitect.aws.panorama.Device/LastUpdatedTime
     :cognitect.aws.panorama.Device/DeviceId
     :cognitect.aws.panorama.Device/LeaseExpirationTime
     :cognitect.aws.panorama.Device/Name
     :cognitect.aws.panorama.Device/Brand]))

(s/def
  :cognitect.aws.panorama/MaxConnections
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.panorama/RegisterPackageVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.RegisterPackageVersionRequest/PackageId
     :cognitect.aws.panorama.RegisterPackageVersionRequest/PackageVersion
     :cognitect.aws.panorama.RegisterPackageVersionRequest/PatchVersion]
    :opt-un
    [:cognitect.aws.panorama.RegisterPackageVersionRequest/MarkLatest
     :cognitect.aws.panorama.RegisterPackageVersionRequest/OwnerAccount]))

(s/def :cognitect.aws.panorama/PackageList (s/coll-of :cognitect.aws.panorama/PackageListItem))

(s/def
  :cognitect.aws.panorama/PackageImportJobType
  (s/spec string? :gen #(s/gen #{"MARKETPLACE_NODE_PACKAGE_VERSION" "NODE_PACKAGE_VERSION"})))

(s/def
  :cognitect.aws.panorama/Version
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/NodeInputPort
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.NodeInputPort/Type
     :cognitect.aws.panorama.NodeInputPort/MaxConnections
     :cognitect.aws.panorama.NodeInputPort/Description
     :cognitect.aws.panorama.NodeInputPort/DefaultValue
     :cognitect.aws.panorama.NodeInputPort/Name]))

(s/def
  :cognitect.aws.panorama/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.panorama.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.panorama/CreatePackageImportJobResponse
  (s/keys :req-un [:cognitect.aws.panorama.CreatePackageImportJobResponse/JobId]))

(s/def
  :cognitect.aws.panorama/ListPackageImportJobsResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.ListPackageImportJobsResponse/PackageImportJobs]
    :opt-un
    [:cognitect.aws.panorama.ListPackageImportJobsResponse/NextToken]))

(s/def
  :cognitect.aws.panorama/PackageVersionStatus
  (s/spec string? :gen #(s/gen #{"REGISTER_COMPLETED" "REGISTER_PENDING" "DELETING" "FAILED"})))

(s/def
  :cognitect.aws.panorama/DescribeDeviceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.DescribeDeviceResponse/Type
     :cognitect.aws.panorama.DescribeDeviceResponse/AlternateSoftwares
     :cognitect.aws.panorama.DescribeDeviceResponse/DeviceConnectionStatus
     :cognitect.aws.panorama.DescribeDeviceResponse/Tags
     :cognitect.aws.panorama.DescribeDeviceResponse/CurrentNetworkingStatus
     :cognitect.aws.panorama.DescribeDeviceResponse/CurrentSoftware
     :cognitect.aws.panorama.DescribeDeviceResponse/LatestSoftware
     :cognitect.aws.panorama.DescribeDeviceResponse/LatestAlternateSoftware
     :cognitect.aws.panorama.DescribeDeviceResponse/CreatedTime
     :cognitect.aws.panorama.DescribeDeviceResponse/Description
     :cognitect.aws.panorama.DescribeDeviceResponse/ProvisioningStatus
     :cognitect.aws.panorama.DescribeDeviceResponse/DeviceId
     :cognitect.aws.panorama.DescribeDeviceResponse/LeaseExpirationTime
     :cognitect.aws.panorama.DescribeDeviceResponse/Arn
     :cognitect.aws.panorama.DescribeDeviceResponse/NetworkingConfiguration
     :cognitect.aws.panorama.DescribeDeviceResponse/SerialNumber
     :cognitect.aws.panorama.DescribeDeviceResponse/Name
     :cognitect.aws.panorama.DescribeDeviceResponse/Brand]))

(s/def
  :cognitect.aws.panorama/DescribeDeviceJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.DescribeDeviceJobResponse/DeviceArn
     :cognitect.aws.panorama.DescribeDeviceJobResponse/Status
     :cognitect.aws.panorama.DescribeDeviceJobResponse/CreatedTime
     :cognitect.aws.panorama.DescribeDeviceJobResponse/DeviceType
     :cognitect.aws.panorama.DescribeDeviceJobResponse/DeviceId
     :cognitect.aws.panorama.DescribeDeviceJobResponse/ImageVersion
     :cognitect.aws.panorama.DescribeDeviceJobResponse/DeviceName
     :cognitect.aws.panorama.DescribeDeviceJobResponse/JobId]))

(s/def
  :cognitect.aws.panorama/PortDefaultValue
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.panorama/OutPutS3Location
  (s/keys
    :req-un
    [:cognitect.aws.panorama.OutPutS3Location/BucketName
     :cognitect.aws.panorama.OutPutS3Location/ObjectKey]))

(s/def
  :cognitect.aws.panorama/NodeId
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9\\-\\_\\.]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.panorama/DescribeApplicationInstanceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.DescribeApplicationInstanceResponse/DefaultRuntimeContextDevice
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/RuntimeRoleArn
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/DefaultRuntimeContextDeviceName
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Tags
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/HealthStatus
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Status
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/CreatedTime
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/ApplicationInstanceId
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/StatusDescription
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Description
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/LastUpdatedTime
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Arn
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Name
     :cognitect.aws.panorama.DescribeApplicationInstanceResponse/ApplicationInstanceIdToReplace]))

(s/def
  :cognitect.aws.panorama/UpdateProgress
  (s/spec
    string?
    :gen
    #(s/gen #{"COMPLETED" "IN_PROGRESS" "REBOOTING" "PENDING" "DOWNLOADING" "FAILED" "VERIFYING"})))

(s/def
  :cognitect.aws.panorama/DescribeApplicationInstanceDetailsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/DefaultRuntimeContextDevice
     :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/CreatedTime
     :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/ManifestPayload
     :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/ApplicationInstanceId
     :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/Description
     :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/ManifestOverridesPayload
     :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/Name
     :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/ApplicationInstanceIdToReplace]))

(s/def
  :cognitect.aws.panorama/NetworkPayload
  (s/keys
    :opt-un
    [:cognitect.aws.panorama.NetworkPayload/Ntp
     :cognitect.aws.panorama.NetworkPayload/Ethernet1
     :cognitect.aws.panorama.NetworkPayload/Ethernet0]))

(s/def
  :cognitect.aws.panorama/DeletePackageRequest
  (s/keys
    :req-un
    [:cognitect.aws.panorama.DeletePackageRequest/PackageId]
    :opt-un
    [:cognitect.aws.panorama.DeletePackageRequest/ForceDelete]))

(s/def
  :cognitect.aws.panorama/TagKeyList
  (s/coll-of :cognitect.aws.panorama/TagKey :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.panorama/ProvisionDeviceResponse
  (s/keys
    :req-un
    [:cognitect.aws.panorama.ProvisionDeviceResponse/Arn
     :cognitect.aws.panorama.ProvisionDeviceResponse/Status]
    :opt-un
    [:cognitect.aws.panorama.ProvisionDeviceResponse/Certificates
     :cognitect.aws.panorama.ProvisionDeviceResponse/DeviceId
     :cognitect.aws.panorama.ProvisionDeviceResponse/IotThingName]))

(s/def :cognitect.aws.panorama.DeviceJobConfig/OTAJobConfig :cognitect.aws.panorama/OTAJobConfig)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/NodeName
  :cognitect.aws.panorama/NodeName)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/JobId
  :cognitect.aws.panorama/JobId)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/LastUpdatedTime
  :cognitect.aws.panorama/LastUpdatedTime)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/TemplateParameters
  :cognitect.aws.panorama/TemplateParametersMap)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/NodeDescription
  :cognitect.aws.panorama/Description)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/JobTags
  :cognitect.aws.panorama/JobTagsList)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/StatusMessage
  :cognitect.aws.panorama/NodeFromTemplateJobStatusMessage)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/TemplateType
  :cognitect.aws.panorama/TemplateType)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/OutputPackageName
  :cognitect.aws.panorama/NodePackageName)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/CreatedTime
  :cognitect.aws.panorama/CreatedTime)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/OutputPackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobResponse/Status
  :cognitect.aws.panorama/NodeFromTemplateJobStatus)

(s/def :cognitect.aws.panorama.TagResourceRequest/ResourceArn :cognitect.aws.panorama/ResourceArn)

(s/def :cognitect.aws.panorama.TagResourceRequest/Tags :cognitect.aws.panorama/TagMap)

(s/def :cognitect.aws.panorama.DeviceJob/CreatedTime :cognitect.aws.panorama/CreatedTime)

(s/def :cognitect.aws.panorama.DeviceJob/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def :cognitect.aws.panorama.DeviceJob/DeviceName :cognitect.aws.panorama/DeviceName)

(s/def :cognitect.aws.panorama.DeviceJob/JobId :cognitect.aws.panorama/JobId)

(s/def :cognitect.aws.panorama.StorageLocation/BinaryPrefixLocation :cognitect.aws.panorama/Object)

(s/def :cognitect.aws.panorama.StorageLocation/Bucket :cognitect.aws.panorama/Bucket)

(s/def
  :cognitect.aws.panorama.StorageLocation/GeneratedPrefixLocation
  :cognitect.aws.panorama/Object)

(s/def
  :cognitect.aws.panorama.StorageLocation/ManifestPrefixLocation
  :cognitect.aws.panorama/Object)

(s/def :cognitect.aws.panorama.StorageLocation/RepoPrefixLocation :cognitect.aws.panorama/Object)

(s/def
  :cognitect.aws.panorama.ListPackageImportJobsRequest/MaxResults
  :cognitect.aws.panorama/MaxSize25)

(s/def
  :cognitect.aws.panorama.ListPackageImportJobsRequest/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.StaticIpConnectionInfo/DefaultGateway
  :cognitect.aws.panorama/DefaultGateway)

(s/def :cognitect.aws.panorama.StaticIpConnectionInfo/Dns :cognitect.aws.panorama/DnsList)

(s/def :cognitect.aws.panorama.StaticIpConnectionInfo/IpAddress :cognitect.aws.panorama/IpAddress)

(s/def :cognitect.aws.panorama.StaticIpConnectionInfo/Mask :cognitect.aws.panorama/Mask)

(s/def
  :cognitect.aws.panorama.ManifestOverridesPayload/PayloadData
  :cognitect.aws.panorama/ManifestOverridesPayloadData)

(s/def
  :cognitect.aws.panorama.UpdateDeviceMetadataResponse/DeviceId
  :cognitect.aws.panorama/DeviceId)

(s/def :cognitect.aws.panorama.ListDevicesJobsRequest/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def :cognitect.aws.panorama.ListDevicesJobsRequest/MaxResults :cognitect.aws.panorama/MaxSize25)

(s/def :cognitect.aws.panorama.ListDevicesJobsRequest/NextToken :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.CreatePackageImportJobRequest/ClientToken
  :cognitect.aws.panorama/ClientToken)

(s/def
  :cognitect.aws.panorama.CreatePackageImportJobRequest/InputConfig
  :cognitect.aws.panorama/PackageImportJobInputConfig)

(s/def
  :cognitect.aws.panorama.CreatePackageImportJobRequest/JobTags
  :cognitect.aws.panorama/JobTagsList)

(s/def
  :cognitect.aws.panorama.CreatePackageImportJobRequest/JobType
  :cognitect.aws.panorama/PackageImportJobType)

(s/def
  :cognitect.aws.panorama.CreatePackageImportJobRequest/OutputConfig
  :cognitect.aws.panorama/PackageImportJobOutputConfig)

(s/def
  :cognitect.aws.panorama.ListDevicesJobsResponse/DeviceJobs
  :cognitect.aws.panorama/DeviceJobList)

(s/def :cognitect.aws.panorama.ListDevicesJobsResponse/NextToken :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.PackageImportJobOutput/OutputS3Location
  :cognitect.aws.panorama/OutPutS3Location)

(s/def
  :cognitect.aws.panorama.PackageImportJobOutput/PackageId
  :cognitect.aws.panorama/NodePackageId)

(s/def
  :cognitect.aws.panorama.PackageImportJobOutput/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.PackageImportJobOutput/PatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceRequest/ApplicationInstanceId
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceNodeInstancesResponse/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceNodeInstancesResponse/NodeInstances
  :cognitect.aws.panorama/NodeInstances)

(s/def
  :cognitect.aws.panorama.PackageImportJobInputConfig/PackageVersionInputConfig
  :cognitect.aws.panorama/PackageVersionInputConfig)

(s/def
  :cognitect.aws.panorama.ListNodeFromTemplateJobsRequest/MaxResults
  :cognitect.aws.panorama/MaxSize25)

(s/def
  :cognitect.aws.panorama.ListNodeFromTemplateJobsRequest/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/PackageId
  :cognitect.aws.panorama/NodePackageId)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/PatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/StatusDescription
  :cognitect.aws.panorama/PackageVersionStatusDescription)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/PackageName
  :cognitect.aws.panorama/NodePackageName)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/IsLatestPatch
  :cognitect.aws.panorama/Boolean)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/RegisteredTime
  :cognitect.aws.panorama/TimeStamp)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/OwnerAccount
  :cognitect.aws.panorama/PackageOwnerAccount)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/PackageArn
  :cognitect.aws.panorama/NodePackageArn)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionResponse/Status
  :cognitect.aws.panorama/PackageVersionStatus)

(s/def
  :cognitect.aws.panorama.EthernetStatus/ConnectionStatus
  :cognitect.aws.panorama/NetworkConnectionStatus)

(s/def :cognitect.aws.panorama.EthernetStatus/HwAddress :cognitect.aws.panorama/HwAddress)

(s/def :cognitect.aws.panorama.EthernetStatus/IpAddress :cognitect.aws.panorama/IpAddress)

(s/def :cognitect.aws.panorama.JobResourceTags/ResourceType :cognitect.aws.panorama/JobResourceType)

(s/def :cognitect.aws.panorama.JobResourceTags/Tags :cognitect.aws.panorama/TagMap)

(s/def :cognitect.aws.panorama.ListNodesRequest/Category :cognitect.aws.panorama/NodeCategory)

(s/def :cognitect.aws.panorama.ListNodesRequest/MaxResults :cognitect.aws.panorama/MaxSize25)

(s/def :cognitect.aws.panorama.ListNodesRequest/NextToken :cognitect.aws.panorama/Token)

(s/def
  :cognitect.aws.panorama.ListNodesRequest/OwnerAccount
  :cognitect.aws.panorama/PackageOwnerAccount)

(s/def :cognitect.aws.panorama.ListNodesRequest/PackageName :cognitect.aws.panorama/NodePackageName)

(s/def
  :cognitect.aws.panorama.ListNodesRequest/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.ListNodesRequest/PatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionRequest/OwnerAccount
  :cognitect.aws.panorama/PackageOwnerAccount)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionRequest/PackageId
  :cognitect.aws.panorama/NodePackageId)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionRequest/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.DescribePackageVersionRequest/PatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def
  :cognitect.aws.panorama.ListNodeFromTemplateJobsResponse/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.ListNodeFromTemplateJobsResponse/NodeFromTemplateJobs
  :cognitect.aws.panorama/NodeFromTemplateJobList)

(s/def
  :cognitect.aws.panorama.CreateJobForDevicesRequest/DeviceIds
  :cognitect.aws.panorama/DeviceIdList)

(s/def
  :cognitect.aws.panorama.CreateJobForDevicesRequest/DeviceJobConfig
  :cognitect.aws.panorama/DeviceJobConfig)

(s/def :cognitect.aws.panorama.CreateJobForDevicesRequest/JobType :cognitect.aws.panorama/JobType)

(s/def :cognitect.aws.panorama.AlternateSoftwareMetadata/Version :cognitect.aws.panorama/Version)

(s/def
  :cognitect.aws.panorama.DescribePackageRequest/PackageId
  :cognitect.aws.panorama/NodePackageId)

(s/def
  :cognitect.aws.panorama.CreateNodeFromTemplateJobResponse/JobId
  :cognitect.aws.panorama/JobId)

(s/def
  :cognitect.aws.panorama.ManifestPayload/PayloadData
  :cognitect.aws.panorama/ManifestPayloadData)

(s/def :cognitect.aws.panorama.ListPackagesRequest/MaxResults :cognitect.aws.panorama/MaxSize25)

(s/def :cognitect.aws.panorama.ListPackagesRequest/NextToken :cognitect.aws.panorama/Token)

(s/def :cognitect.aws.panorama.DescribePackageImportJobRequest/JobId :cognitect.aws.panorama/JobId)

(s/def :cognitect.aws.panorama.DescribePackageImportJobResponse/JobId :cognitect.aws.panorama/JobId)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/LastUpdatedTime
  :cognitect.aws.panorama/LastUpdatedTime)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/OutputConfig
  :cognitect.aws.panorama/PackageImportJobOutputConfig)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/Output
  :cognitect.aws.panorama/PackageImportJobOutput)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/JobTags
  :cognitect.aws.panorama/JobTagsList)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/StatusMessage
  :cognitect.aws.panorama/PackageImportJobStatusMessage)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/ClientToken
  :cognitect.aws.panorama/ClientToken)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/CreatedTime
  :cognitect.aws.panorama/CreatedTime)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/JobType
  :cognitect.aws.panorama/PackageImportJobType)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/InputConfig
  :cognitect.aws.panorama/PackageImportJobInputConfig)

(s/def
  :cognitect.aws.panorama.DescribePackageImportJobResponse/Status
  :cognitect.aws.panorama/PackageImportJobStatus)

(s/def
  :cognitect.aws.panorama.PackageImportJobOutputConfig/PackageVersionOutputConfig
  :cognitect.aws.panorama/PackageVersionOutputConfig)

(s/def :cognitect.aws.panorama.CreateJobForDevicesResponse/Jobs :cognitect.aws.panorama/JobList)

(s/def :cognitect.aws.panorama.ListNodesResponse/NextToken :cognitect.aws.panorama/Token)

(s/def :cognitect.aws.panorama.ListNodesResponse/Nodes :cognitect.aws.panorama/NodesList)

(s/def :cognitect.aws.panorama.PackageObject/Name :cognitect.aws.panorama/NodePackageName)

(s/def
  :cognitect.aws.panorama.PackageObject/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.PackageObject/PatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def :cognitect.aws.panorama.S3Location/BucketName :cognitect.aws.panorama/BucketName)

(s/def :cognitect.aws.panorama.S3Location/ObjectKey :cognitect.aws.panorama/ObjectKey)

(s/def :cognitect.aws.panorama.S3Location/Region :cognitect.aws.panorama/Region)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceDetailsRequest/ApplicationInstanceId
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.CreateApplicationInstanceRequest/ApplicationInstanceIdToReplace
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.CreateApplicationInstanceRequest/DefaultRuntimeContextDevice
  :cognitect.aws.panorama/DefaultRuntimeContextDevice)

(s/def
  :cognitect.aws.panorama.CreateApplicationInstanceRequest/Description
  :cognitect.aws.panorama/Description)

(s/def
  :cognitect.aws.panorama.CreateApplicationInstanceRequest/ManifestOverridesPayload
  :cognitect.aws.panorama/ManifestOverridesPayload)

(s/def
  :cognitect.aws.panorama.CreateApplicationInstanceRequest/ManifestPayload
  :cognitect.aws.panorama/ManifestPayload)

(s/def
  :cognitect.aws.panorama.CreateApplicationInstanceRequest/Name
  :cognitect.aws.panorama/ApplicationInstanceName)

(s/def
  :cognitect.aws.panorama.CreateApplicationInstanceRequest/RuntimeRoleArn
  :cognitect.aws.panorama/RuntimeRoleArn)

(s/def :cognitect.aws.panorama.CreateApplicationInstanceRequest/Tags :cognitect.aws.panorama/TagMap)

(s/def :cognitect.aws.panorama.NodeFromTemplateJob/CreatedTime :cognitect.aws.panorama/CreatedTime)

(s/def :cognitect.aws.panorama.NodeFromTemplateJob/JobId :cognitect.aws.panorama/JobId)

(s/def :cognitect.aws.panorama.NodeFromTemplateJob/NodeName :cognitect.aws.panorama/NodeName)

(s/def
  :cognitect.aws.panorama.NodeFromTemplateJob/Status
  :cognitect.aws.panorama/NodeFromTemplateJobStatus)

(s/def
  :cognitect.aws.panorama.NodeFromTemplateJob/StatusMessage
  :cognitect.aws.panorama/NodeFromTemplateJobStatusMessage)

(s/def
  :cognitect.aws.panorama.NodeFromTemplateJob/TemplateType
  :cognitect.aws.panorama/TemplateType)

(s/def
  :cognitect.aws.panorama.RemoveApplicationInstanceRequest/ApplicationInstanceId
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.PackageVersionInputConfig/S3Location
  :cognitect.aws.panorama/S3Location)

(s/def :cognitect.aws.panorama.ListPackagesResponse/NextToken :cognitect.aws.panorama/NextToken)

(s/def :cognitect.aws.panorama.ListPackagesResponse/Packages :cognitect.aws.panorama/PackageList)

(s/def :cognitect.aws.panorama.NodeInterface/Inputs :cognitect.aws.panorama/InputPortList)

(s/def :cognitect.aws.panorama.NodeInterface/Outputs :cognitect.aws.panorama/OutputPortList)

(s/def :cognitect.aws.panorama.OTAJobConfig/ImageVersion :cognitect.aws.panorama/ImageVersion)

(s/def :cognitect.aws.panorama.PackageListItem/Arn :cognitect.aws.panorama/NodePackageArn)

(s/def :cognitect.aws.panorama.PackageListItem/CreatedTime :cognitect.aws.panorama/TimeStamp)

(s/def :cognitect.aws.panorama.PackageListItem/PackageId :cognitect.aws.panorama/NodePackageId)

(s/def :cognitect.aws.panorama.PackageListItem/PackageName :cognitect.aws.panorama/NodePackageName)

(s/def :cognitect.aws.panorama.PackageListItem/Tags :cognitect.aws.panorama/TagMap)

(s/def
  :cognitect.aws.panorama.ListApplicationInstancesResponse/ApplicationInstances
  :cognitect.aws.panorama/ApplicationInstances)

(s/def
  :cognitect.aws.panorama.ListApplicationInstancesResponse/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.panorama/ResourceArn)

(s/def :cognitect.aws.panorama.NetworkStatus/Ethernet0Status :cognitect.aws.panorama/EthernetStatus)

(s/def :cognitect.aws.panorama.NetworkStatus/Ethernet1Status :cognitect.aws.panorama/EthernetStatus)

(s/def
  :cognitect.aws.panorama.NetworkStatus/LastUpdatedTime
  :cognitect.aws.panorama/LastUpdatedTime)

(s/def :cognitect.aws.panorama.NetworkStatus/NtpStatus :cognitect.aws.panorama/NtpStatus)

(s/def
  :cognitect.aws.panorama.DescribeNodeFromTemplateJobRequest/JobId
  :cognitect.aws.panorama/JobId)

(s/def :cognitect.aws.panorama.Job/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def :cognitect.aws.panorama.Job/JobId :cognitect.aws.panorama/JobId)

(s/def
  :cognitect.aws.panorama.CreatePackageRequest/PackageName
  :cognitect.aws.panorama/NodePackageName)

(s/def :cognitect.aws.panorama.CreatePackageRequest/Tags :cognitect.aws.panorama/TagMap)

(s/def
  :cognitect.aws.panorama.NtpStatus/ConnectionStatus
  :cognitect.aws.panorama/NetworkConnectionStatus)

(s/def :cognitect.aws.panorama.NtpStatus/IpAddress :cognitect.aws.panorama/IpAddress)

(s/def :cognitect.aws.panorama.NtpStatus/NtpServerName :cognitect.aws.panorama/NtpServerName)

(s/def
  :cognitect.aws.panorama.ProvisionDeviceRequest/Description
  :cognitect.aws.panorama/Description)

(s/def :cognitect.aws.panorama.ProvisionDeviceRequest/Name :cognitect.aws.panorama/DeviceName)

(s/def
  :cognitect.aws.panorama.ProvisionDeviceRequest/NetworkingConfiguration
  :cognitect.aws.panorama/NetworkPayload)

(s/def :cognitect.aws.panorama.ProvisionDeviceRequest/Tags :cognitect.aws.panorama/TagMap)

(s/def :cognitect.aws.panorama.NodeOutputPort/Description :cognitect.aws.panorama/Description)

(s/def :cognitect.aws.panorama.NodeOutputPort/Name :cognitect.aws.panorama/PortName)

(s/def :cognitect.aws.panorama.NodeOutputPort/Type :cognitect.aws.panorama/PortType)

(s/def :cognitect.aws.panorama.DescribePackageResponse/Arn :cognitect.aws.panorama/NodePackageArn)

(s/def
  :cognitect.aws.panorama.DescribePackageResponse/CreatedTime
  :cognitect.aws.panorama/TimeStamp)

(s/def
  :cognitect.aws.panorama.DescribePackageResponse/PackageId
  :cognitect.aws.panorama/NodePackageId)

(s/def
  :cognitect.aws.panorama.DescribePackageResponse/PackageName
  :cognitect.aws.panorama/NodePackageName)

(s/def
  :cognitect.aws.panorama.DescribePackageResponse/ReadAccessPrincipalArns
  :cognitect.aws.panorama/PrincipalArnsList)

(s/def
  :cognitect.aws.panorama.DescribePackageResponse/StorageLocation
  :cognitect.aws.panorama/StorageLocation)

(s/def :cognitect.aws.panorama.DescribePackageResponse/Tags :cognitect.aws.panorama/TagMap)

(s/def
  :cognitect.aws.panorama.DescribePackageResponse/WriteAccessPrincipalArns
  :cognitect.aws.panorama/PrincipalArnsList)

(s/def
  :cognitect.aws.panorama.ApplicationInstance/DefaultRuntimeContextDeviceName
  :cognitect.aws.panorama/DeviceName)

(s/def
  :cognitect.aws.panorama.ApplicationInstance/DefaultRuntimeContextDevice
  :cognitect.aws.panorama/DefaultRuntimeContextDevice)

(s/def :cognitect.aws.panorama.ApplicationInstance/Tags :cognitect.aws.panorama/TagMap)

(s/def
  :cognitect.aws.panorama.ApplicationInstance/StatusDescription
  :cognitect.aws.panorama/ApplicationInstanceStatusDescription)

(s/def
  :cognitect.aws.panorama.ApplicationInstance/Arn
  :cognitect.aws.panorama/ApplicationInstanceArn)

(s/def
  :cognitect.aws.panorama.ApplicationInstance/ApplicationInstanceId
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.ApplicationInstance/Name
  :cognitect.aws.panorama/ApplicationInstanceName)

(s/def :cognitect.aws.panorama.ApplicationInstance/Description :cognitect.aws.panorama/Description)

(s/def
  :cognitect.aws.panorama.ApplicationInstance/HealthStatus
  :cognitect.aws.panorama/ApplicationInstanceHealthStatus)

(s/def :cognitect.aws.panorama.ApplicationInstance/CreatedTime :cognitect.aws.panorama/TimeStamp)

(s/def
  :cognitect.aws.panorama.ApplicationInstance/Status
  :cognitect.aws.panorama/ApplicationInstanceStatus)

(s/def
  :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/JobTags
  :cognitect.aws.panorama/JobTagsList)

(s/def
  :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/NodeDescription
  :cognitect.aws.panorama/Description)

(s/def
  :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/NodeName
  :cognitect.aws.panorama/NodeName)

(s/def
  :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/OutputPackageName
  :cognitect.aws.panorama/NodePackageName)

(s/def
  :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/OutputPackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/TemplateParameters
  :cognitect.aws.panorama/TemplateParametersMap)

(s/def
  :cognitect.aws.panorama.CreateNodeFromTemplateJobRequest/TemplateType
  :cognitect.aws.panorama/TemplateType)

(s/def :cognitect.aws.panorama.DescribeNodeRequest/NodeId :cognitect.aws.panorama/NodeId)

(s/def
  :cognitect.aws.panorama.DescribeNodeRequest/OwnerAccount
  :cognitect.aws.panorama/PackageOwnerAccount)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceDependenciesResponse/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceDependenciesResponse/PackageObjects
  :cognitect.aws.panorama/PackageObjects)

(s/def :cognitect.aws.panorama.PackageImportJob/CreatedTime :cognitect.aws.panorama/CreatedTime)

(s/def :cognitect.aws.panorama.PackageImportJob/JobId :cognitect.aws.panorama/JobId)

(s/def
  :cognitect.aws.panorama.PackageImportJob/JobType
  :cognitect.aws.panorama/PackageImportJobType)

(s/def
  :cognitect.aws.panorama.PackageImportJob/LastUpdatedTime
  :cognitect.aws.panorama/LastUpdatedTime)

(s/def
  :cognitect.aws.panorama.PackageImportJob/Status
  :cognitect.aws.panorama/PackageImportJobStatus)

(s/def
  :cognitect.aws.panorama.PackageImportJob/StatusMessage
  :cognitect.aws.panorama/PackageImportJobStatusMessage)

(s/def :cognitect.aws.panorama.NtpPayload/NtpServers :cognitect.aws.panorama/NtpServerList)

(s/def
  :cognitect.aws.panorama.NodeInstance/CurrentStatus
  :cognitect.aws.panorama/NodeInstanceStatus)

(s/def :cognitect.aws.panorama.NodeInstance/NodeId :cognitect.aws.panorama/NodeId)

(s/def :cognitect.aws.panorama.NodeInstance/NodeInstanceId :cognitect.aws.panorama/NodeInstanceId)

(s/def :cognitect.aws.panorama.NodeInstance/NodeName :cognitect.aws.panorama/NodeName)

(s/def :cognitect.aws.panorama.NodeInstance/PackageName :cognitect.aws.panorama/NodePackageName)

(s/def
  :cognitect.aws.panorama.NodeInstance/PackagePatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def
  :cognitect.aws.panorama.NodeInstance/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.ListApplicationInstancesRequest/DeviceId
  :cognitect.aws.panorama/DeviceId)

(s/def
  :cognitect.aws.panorama.ListApplicationInstancesRequest/MaxResults
  :cognitect.aws.panorama/MaxSize25)

(s/def
  :cognitect.aws.panorama.ListApplicationInstancesRequest/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.ListApplicationInstancesRequest/StatusFilter
  :cognitect.aws.panorama/StatusFilter)

(s/def
  :cognitect.aws.panorama.CreateApplicationInstanceResponse/ApplicationInstanceId
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def :cognitect.aws.panorama.ListDevicesResponse/Devices :cognitect.aws.panorama/DeviceList)

(s/def :cognitect.aws.panorama.ListDevicesResponse/NextToken :cognitect.aws.panorama/NextToken)

(s/def :cognitect.aws.panorama.DeleteDeviceResponse/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def :cognitect.aws.panorama.DescribeDeviceRequest/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def
  :cognitect.aws.panorama.DeregisterPackageVersionRequest/OwnerAccount
  :cognitect.aws.panorama/PackageOwnerAccount)

(s/def
  :cognitect.aws.panorama.DeregisterPackageVersionRequest/PackageId
  :cognitect.aws.panorama/NodePackageId)

(s/def
  :cognitect.aws.panorama.DeregisterPackageVersionRequest/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.DeregisterPackageVersionRequest/PatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def
  :cognitect.aws.panorama.DeregisterPackageVersionRequest/UpdatedLatestPatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def :cognitect.aws.panorama.DescribeDeviceJobRequest/JobId :cognitect.aws.panorama/JobId)

(s/def :cognitect.aws.panorama.CreatePackageResponse/Arn :cognitect.aws.panorama/NodePackageArn)

(s/def
  :cognitect.aws.panorama.CreatePackageResponse/PackageId
  :cognitect.aws.panorama/NodePackageId)

(s/def
  :cognitect.aws.panorama.CreatePackageResponse/StorageLocation
  :cognitect.aws.panorama/StorageLocation)

(s/def
  :cognitect.aws.panorama.UpdateDeviceMetadataRequest/Description
  :cognitect.aws.panorama/Description)

(s/def
  :cognitect.aws.panorama.UpdateDeviceMetadataRequest/DeviceId
  :cognitect.aws.panorama/DeviceId)

(s/def :cognitect.aws.panorama.UntagResourceRequest/ResourceArn :cognitect.aws.panorama/ResourceArn)

(s/def :cognitect.aws.panorama.UntagResourceRequest/TagKeys :cognitect.aws.panorama/TagKeyList)

(s/def
  :cognitect.aws.panorama.PackageVersionOutputConfig/MarkLatest
  :cognitect.aws.panorama/MarkLatestPatch)

(s/def
  :cognitect.aws.panorama.PackageVersionOutputConfig/PackageName
  :cognitect.aws.panorama/NodePackageName)

(s/def
  :cognitect.aws.panorama.PackageVersionOutputConfig/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def :cognitect.aws.panorama.Node/PackageId :cognitect.aws.panorama/NodePackageId)

(s/def :cognitect.aws.panorama.Node/PatchVersion :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def :cognitect.aws.panorama.Node/PackageVersion :cognitect.aws.panorama/NodePackageVersion)

(s/def :cognitect.aws.panorama.Node/Category :cognitect.aws.panorama/NodeCategory)

(s/def :cognitect.aws.panorama.Node/PackageName :cognitect.aws.panorama/NodePackageName)

(s/def :cognitect.aws.panorama.Node/Name :cognitect.aws.panorama/NodeName)

(s/def :cognitect.aws.panorama.Node/Description :cognitect.aws.panorama/Description)

(s/def :cognitect.aws.panorama.Node/CreatedTime :cognitect.aws.panorama/TimeStamp)

(s/def :cognitect.aws.panorama.Node/OwnerAccount :cognitect.aws.panorama/PackageOwnerAccount)

(s/def :cognitect.aws.panorama.Node/PackageArn :cognitect.aws.panorama/NodePackageArn)

(s/def :cognitect.aws.panorama.Node/NodeId :cognitect.aws.panorama/NodeId)

(s/def :cognitect.aws.panorama.ListDevicesRequest/MaxResults :cognitect.aws.panorama/MaxSize25)

(s/def :cognitect.aws.panorama.ListDevicesRequest/NextToken :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceDependenciesRequest/ApplicationInstanceId
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceDependenciesRequest/MaxResults
  :cognitect.aws.panorama/MaxSize25)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceDependenciesRequest/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def :cognitect.aws.panorama.DeleteDeviceRequest/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def :cognitect.aws.panorama.DescribeNodeResponse/PackageId :cognitect.aws.panorama/NodePackageId)

(s/def
  :cognitect.aws.panorama.DescribeNodeResponse/PatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def
  :cognitect.aws.panorama.DescribeNodeResponse/LastUpdatedTime
  :cognitect.aws.panorama/TimeStamp)

(s/def
  :cognitect.aws.panorama.DescribeNodeResponse/NodeInterface
  :cognitect.aws.panorama/NodeInterface)

(s/def
  :cognitect.aws.panorama.DescribeNodeResponse/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def :cognitect.aws.panorama.DescribeNodeResponse/Category :cognitect.aws.panorama/NodeCategory)

(s/def
  :cognitect.aws.panorama.DescribeNodeResponse/PackageName
  :cognitect.aws.panorama/NodePackageName)

(s/def :cognitect.aws.panorama.DescribeNodeResponse/Name :cognitect.aws.panorama/NodeName)

(s/def :cognitect.aws.panorama.DescribeNodeResponse/Description :cognitect.aws.panorama/Description)

(s/def :cognitect.aws.panorama.DescribeNodeResponse/AssetName :cognitect.aws.panorama/NodeAssetName)

(s/def :cognitect.aws.panorama.DescribeNodeResponse/CreatedTime :cognitect.aws.panorama/TimeStamp)

(s/def
  :cognitect.aws.panorama.DescribeNodeResponse/OwnerAccount
  :cognitect.aws.panorama/PackageOwnerAccount)

(s/def
  :cognitect.aws.panorama.DescribeNodeResponse/PackageArn
  :cognitect.aws.panorama/NodePackageArn)

(s/def :cognitect.aws.panorama.DescribeNodeResponse/NodeId :cognitect.aws.panorama/NodeId)

(s/def
  :cognitect.aws.panorama.EthernetPayload/ConnectionType
  :cognitect.aws.panorama/ConnectionType)

(s/def
  :cognitect.aws.panorama.EthernetPayload/StaticIpConnectionInfo
  :cognitect.aws.panorama/StaticIpConnectionInfo)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceNodeInstancesRequest/ApplicationInstanceId
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceNodeInstancesRequest/MaxResults
  :cognitect.aws.panorama/MaxSize25)

(s/def
  :cognitect.aws.panorama.ListApplicationInstanceNodeInstancesRequest/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def :cognitect.aws.panorama.Device/Brand :cognitect.aws.panorama/DeviceBrand)

(s/def :cognitect.aws.panorama.Device/CreatedTime :cognitect.aws.panorama/CreatedTime)

(s/def :cognitect.aws.panorama.Device/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def :cognitect.aws.panorama.Device/LastUpdatedTime :cognitect.aws.panorama/LastUpdatedTime)

(s/def
  :cognitect.aws.panorama.Device/LeaseExpirationTime
  :cognitect.aws.panorama/LeaseExpirationTime)

(s/def :cognitect.aws.panorama.Device/Name :cognitect.aws.panorama/DeviceName)

(s/def :cognitect.aws.panorama.Device/ProvisioningStatus :cognitect.aws.panorama/DeviceStatus)

(s/def
  :cognitect.aws.panorama.RegisterPackageVersionRequest/MarkLatest
  :cognitect.aws.panorama/MarkLatestPatch)

(s/def
  :cognitect.aws.panorama.RegisterPackageVersionRequest/OwnerAccount
  :cognitect.aws.panorama/PackageOwnerAccount)

(s/def
  :cognitect.aws.panorama.RegisterPackageVersionRequest/PackageId
  :cognitect.aws.panorama/NodePackageId)

(s/def
  :cognitect.aws.panorama.RegisterPackageVersionRequest/PackageVersion
  :cognitect.aws.panorama/NodePackageVersion)

(s/def
  :cognitect.aws.panorama.RegisterPackageVersionRequest/PatchVersion
  :cognitect.aws.panorama/NodePackagePatchVersion)

(s/def :cognitect.aws.panorama.NodeInputPort/DefaultValue :cognitect.aws.panorama/PortDefaultValue)

(s/def :cognitect.aws.panorama.NodeInputPort/Description :cognitect.aws.panorama/Description)

(s/def :cognitect.aws.panorama.NodeInputPort/MaxConnections :cognitect.aws.panorama/MaxConnections)

(s/def :cognitect.aws.panorama.NodeInputPort/Name :cognitect.aws.panorama/PortName)

(s/def :cognitect.aws.panorama.NodeInputPort/Type :cognitect.aws.panorama/PortType)

(s/def :cognitect.aws.panorama.ListTagsForResourceResponse/Tags :cognitect.aws.panorama/TagMap)

(s/def :cognitect.aws.panorama.CreatePackageImportJobResponse/JobId :cognitect.aws.panorama/JobId)

(s/def
  :cognitect.aws.panorama.ListPackageImportJobsResponse/NextToken
  :cognitect.aws.panorama/NextToken)

(s/def
  :cognitect.aws.panorama.ListPackageImportJobsResponse/PackageImportJobs
  :cognitect.aws.panorama/PackageImportJobList)

(s/def :cognitect.aws.panorama.DescribeDeviceResponse/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/ProvisioningStatus
  :cognitect.aws.panorama/DeviceStatus)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/LatestSoftware
  :cognitect.aws.panorama/LatestSoftware)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/SerialNumber
  :cognitect.aws.panorama/DeviceSerialNumber)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/DeviceConnectionStatus
  :cognitect.aws.panorama/DeviceConnectionStatus)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/LeaseExpirationTime
  :cognitect.aws.panorama/LeaseExpirationTime)

(s/def :cognitect.aws.panorama.DescribeDeviceResponse/Tags :cognitect.aws.panorama/TagMap)

(s/def :cognitect.aws.panorama.DescribeDeviceResponse/Brand :cognitect.aws.panorama/DeviceBrand)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/AlternateSoftwares
  :cognitect.aws.panorama/AlternateSoftwares)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/NetworkingConfiguration
  :cognitect.aws.panorama/NetworkPayload)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/CurrentNetworkingStatus
  :cognitect.aws.panorama/NetworkStatus)

(s/def :cognitect.aws.panorama.DescribeDeviceResponse/Arn :cognitect.aws.panorama/DeviceArn)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/CurrentSoftware
  :cognitect.aws.panorama/CurrentSoftware)

(s/def :cognitect.aws.panorama.DescribeDeviceResponse/Name :cognitect.aws.panorama/DeviceName)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/Description
  :cognitect.aws.panorama/Description)

(s/def :cognitect.aws.panorama.DescribeDeviceResponse/Type :cognitect.aws.panorama/DeviceType)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/CreatedTime
  :cognitect.aws.panorama/CreatedTime)

(s/def
  :cognitect.aws.panorama.DescribeDeviceResponse/LatestAlternateSoftware
  :cognitect.aws.panorama/LatestAlternateSoftware)

(s/def
  :cognitect.aws.panorama.DescribeDeviceJobResponse/CreatedTime
  :cognitect.aws.panorama/UpdateCreatedTime)

(s/def
  :cognitect.aws.panorama.DescribeDeviceJobResponse/DeviceArn
  :cognitect.aws.panorama/DeviceArn)

(s/def :cognitect.aws.panorama.DescribeDeviceJobResponse/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def
  :cognitect.aws.panorama.DescribeDeviceJobResponse/DeviceName
  :cognitect.aws.panorama/DeviceName)

(s/def
  :cognitect.aws.panorama.DescribeDeviceJobResponse/DeviceType
  :cognitect.aws.panorama/DeviceType)

(s/def
  :cognitect.aws.panorama.DescribeDeviceJobResponse/ImageVersion
  :cognitect.aws.panorama/ImageVersion)

(s/def :cognitect.aws.panorama.DescribeDeviceJobResponse/JobId :cognitect.aws.panorama/JobId)

(s/def
  :cognitect.aws.panorama.DescribeDeviceJobResponse/Status
  :cognitect.aws.panorama/UpdateProgress)

(s/def :cognitect.aws.panorama.OutPutS3Location/BucketName :cognitect.aws.panorama/BucketName)

(s/def :cognitect.aws.panorama.OutPutS3Location/ObjectKey :cognitect.aws.panorama/ObjectKey)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/DefaultRuntimeContextDeviceName
  :cognitect.aws.panorama/DeviceName)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/DefaultRuntimeContextDevice
  :cognitect.aws.panorama/DefaultRuntimeContextDevice)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/ApplicationInstanceIdToReplace
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/LastUpdatedTime
  :cognitect.aws.panorama/TimeStamp)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Tags
  :cognitect.aws.panorama/TagMap)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/StatusDescription
  :cognitect.aws.panorama/ApplicationInstanceStatusDescription)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/RuntimeRoleArn
  :cognitect.aws.panorama/RuntimeRoleArn)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Arn
  :cognitect.aws.panorama/ApplicationInstanceArn)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/ApplicationInstanceId
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Name
  :cognitect.aws.panorama/ApplicationInstanceName)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Description
  :cognitect.aws.panorama/Description)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/HealthStatus
  :cognitect.aws.panorama/ApplicationInstanceHealthStatus)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/CreatedTime
  :cognitect.aws.panorama/TimeStamp)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceResponse/Status
  :cognitect.aws.panorama/ApplicationInstanceStatus)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/ApplicationInstanceId
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/ApplicationInstanceIdToReplace
  :cognitect.aws.panorama/ApplicationInstanceId)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/CreatedTime
  :cognitect.aws.panorama/TimeStamp)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/DefaultRuntimeContextDevice
  :cognitect.aws.panorama/DefaultRuntimeContextDevice)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/Description
  :cognitect.aws.panorama/Description)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/ManifestOverridesPayload
  :cognitect.aws.panorama/ManifestOverridesPayload)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/ManifestPayload
  :cognitect.aws.panorama/ManifestPayload)

(s/def
  :cognitect.aws.panorama.DescribeApplicationInstanceDetailsResponse/Name
  :cognitect.aws.panorama/ApplicationInstanceName)

(s/def :cognitect.aws.panorama.NetworkPayload/Ethernet0 :cognitect.aws.panorama/EthernetPayload)

(s/def :cognitect.aws.panorama.NetworkPayload/Ethernet1 :cognitect.aws.panorama/EthernetPayload)

(s/def :cognitect.aws.panorama.NetworkPayload/Ntp :cognitect.aws.panorama/NtpPayload)

(s/def :cognitect.aws.panorama.DeletePackageRequest/ForceDelete :cognitect.aws.panorama/Boolean)

(s/def :cognitect.aws.panorama.DeletePackageRequest/PackageId :cognitect.aws.panorama/NodePackageId)

(s/def :cognitect.aws.panorama.ProvisionDeviceResponse/Arn :cognitect.aws.panorama/DeviceArn)

(s/def
  :cognitect.aws.panorama.ProvisionDeviceResponse/Certificates
  :cognitect.aws.panorama/Certificates)

(s/def :cognitect.aws.panorama.ProvisionDeviceResponse/DeviceId :cognitect.aws.panorama/DeviceId)

(s/def
  :cognitect.aws.panorama.ProvisionDeviceResponse/IotThingName
  :cognitect.aws.panorama/IotThingName)

(s/def :cognitect.aws.panorama.ProvisionDeviceResponse/Status :cognitect.aws.panorama/DeviceStatus)

