;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.partnercentral-selling.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.partnercentral-selling/AwsTeamMemberLastNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ThrottlingException
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.ThrottlingException/Message]))

(s/def
  :cognitect.aws.partnercentral-selling/ListResourceSnapshotsRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/Catalog
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/EngagementIdentifier]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/CreatedBy
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/ResourceSnapshotTemplateIdentifier
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/ResourceType
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/ResourceIdentifier
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/MaxResults]))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectViewOtherSolutionDescriptionString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunitySort
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.OpportunitySort/SortBy
     :cognitect.aws.partnercentral-selling.OpportunitySort/SortOrder]))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectOtherCompetitorNamesString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/SoftwareRevenue
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.SoftwareRevenue/DeliveryModel
     :cognitect.aws.partnercentral-selling.SoftwareRevenue/ExpirationDate
     :cognitect.aws.partnercentral-selling.SoftwareRevenue/Value
     :cognitect.aws.partnercentral-selling.SoftwareRevenue/EffectiveDate]))

(s/def
  :cognitect.aws.partnercentral-selling/LastModifiedDate
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.LastModifiedDate/AfterLastModifiedDate
     :cognitect.aws.partnercentral-selling.LastModifiedDate/BeforeLastModifiedDate]))

(s/def
  :cognitect.aws.partnercentral-selling/ListResourceSnapshotJobsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementResourceAssociationsResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsResponse/EngagementResourceAssociationSummaries]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsResponse/NextToken]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementResourceAssociationSummary
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/CreatedBy
     :cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/ResourceId
     :cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/ResourceType
     :cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/EngagementId]))

(s/def
  :cognitect.aws.partnercentral-selling/AddressCityString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.TagResourceRequest/ResourceArn
     :cognitect.aws.partnercentral-selling.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.partnercentral-selling/AssociateOpportunityRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.AssociateOpportunityRequest/Catalog
     :cognitect.aws.partnercentral-selling.AssociateOpportunityRequest/OpportunityIdentifier
     :cognitect.aws.partnercentral-selling.AssociateOpportunityRequest/RelatedEntityIdentifier
     :cognitect.aws.partnercentral-selling.AssociateOpportunityRequest/RelatedEntityType]))

(s/def
  :cognitect.aws.partnercentral-selling/AwsAccount
  (s/spec #(re-matches (re-pattern "^([0-9]{12}|\\w{1,12})$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/WebsiteUrl
  (s/spec
    (s/and string? #(<= 4 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 4 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/CreateEngagementRequestClientTokenString
  (s/spec #(re-matches (re-pattern "^[!-~]{1,64}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ServiceQuotaExceededException
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.ServiceQuotaExceededException/Message]))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunityType
  (s/spec string? :gen #(s/gen #{"Flat Renewal" "Net New Business" "Expansion"})))

(s/def
  :cognitect.aws.partnercentral-selling/InternalServerException
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.InternalServerException/Message]))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceType
  (s/spec string? :gen #(s/gen #{"Opportunity"})))

(s/def
  :cognitect.aws.partnercentral-selling/CreateResourceSnapshotJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/Catalog
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/ClientToken
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/EngagementIdentifier
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/ResourceIdentifier
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/ResourceSnapshotTemplateIdentifier
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/ResourceType]
    :opt-un
    [:cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/Tags]))

(s/def
  :cognitect.aws.partnercentral-selling/AccountSummary
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.AccountSummary/CompanyName]
    :opt-un
    [:cognitect.aws.partnercentral-selling.AccountSummary/Address
     :cognitect.aws.partnercentral-selling.AccountSummary/Industry
     :cognitect.aws.partnercentral-selling.AccountSummary/OtherIndustry
     :cognitect.aws.partnercentral-selling.AccountSummary/WebsiteUrl]))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectCustomerBusinessProblemString
  (s/spec
    (s/and string? #(<= 20 (count %) 2000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 20 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier
  (s/spec #(re-matches (re-pattern "^O[0-9]{1,19}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/CompanyWebsiteUrl
  (s/spec
    #(re-matches
      (re-pattern
        "^((http|https)://)??(www[.])??([a-zA-Z0-9]|-)+?([.][a-zA-Z0-9(-|/|=|?)??]+?)+?$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/InvitationMessage
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/GetResourceSnapshotJobResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/Status
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/ResourceId
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/LastFailure
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/ResourceType
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/LastSuccessfulExecutionDate
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/Arn
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/EngagementId
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/CreatedAt
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/ResourceSnapshotTemplateName
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/ResourceArn
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/Id]))

(s/def
  :cognitect.aws.partnercentral-selling/PutSellingSystemSettingsResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.PutSellingSystemSettingsResponse/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.PutSellingSystemSettingsResponse/ResourceSnapshotJobRoleArn]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementMemberSummary
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.EngagementMemberSummary/CompanyName
     :cognitect.aws.partnercentral-selling.EngagementMemberSummary/WebsiteUrl]))

(s/def
  :cognitect.aws.partnercentral-selling/AwsMemberBusinessTitle
  (s/spec string? :gen #(s/gen #{"AWSSalesRep" "ISVSM" "AWSAccountOwner" "PSM" "WWPSPDM" "PDM"})))

(s/def
  :cognitect.aws.partnercentral-selling/Stage
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Business Validation"
        "Closed Lost"
        "Launched"
        "Qualified"
        "Prospect"
        "Committed"
        "Technical Validation"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementInvitationIdentifier
  (s/spec #(re-matches (re-pattern "^engi-[0-9,a-z]{13}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/SolutionBase
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.SolutionBase/Catalog
     :cognitect.aws.partnercentral-selling.SolutionBase/Category
     :cognitect.aws.partnercentral-selling.SolutionBase/CreatedDate
     :cognitect.aws.partnercentral-selling.SolutionBase/Id
     :cognitect.aws.partnercentral-selling.SolutionBase/Name
     :cognitect.aws.partnercentral-selling.SolutionBase/Status]
    :opt-un
    [:cognitect.aws.partnercentral-selling.SolutionBase/Arn]))

(s/def
  :cognitect.aws.partnercentral-selling/SolutionStatus
  (s/spec string? :gen #(s/gen #{"Draft" "Active" "Inactive"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementContexts
  (s/coll-of
    :cognitect.aws.partnercentral-selling/EngagementContextDetails
    :min-count
    0
    :max-count
    5))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementPageSize
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.partnercentral-selling/Tag
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.Tag/Key
     :cognitect.aws.partnercentral-selling.Tag/Value]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementCustomerProjectTitle
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/AwsOpportunityRelatedEntities
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.AwsOpportunityRelatedEntities/Solutions
     :cognitect.aws.partnercentral-selling.AwsOpportunityRelatedEntities/AwsProducts]))

(s/def
  :cognitect.aws.partnercentral-selling/CreateOpportunityRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Catalog
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/ClientToken]
    :opt-un
    [:cognitect.aws.partnercentral-selling.CreateOpportunityRequest/OpportunityType
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/NationalSecurity
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Customer
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Origin
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/PartnerOpportunityIdentifier
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/OpportunityTeam
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/LifeCycle
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Project
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/SoftwareRevenue
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Marketing
     :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/PrimaryNeedsFromAws]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementCustomer
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.EngagementCustomer/CompanyName
     :cognitect.aws.partnercentral-selling.EngagementCustomer/CountryCode
     :cognitect.aws.partnercentral-selling.EngagementCustomer/Industry
     :cognitect.aws.partnercentral-selling.EngagementCustomer/WebsiteUrl]))

(s/def
  :cognitect.aws.partnercentral-selling/LifeCycleForViewNextStepsString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/CustomerContactsList
  (s/coll-of :cognitect.aws.partnercentral-selling/Contact))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementInvitationSummarySenderCompanyNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 120))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 120) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListOpportunitiesRequestLifeCycleStageList
  (s/coll-of :cognitect.aws.partnercentral-selling/Stage :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.partnercentral-selling/Receiver
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.Receiver/Account]))

(s/def
  :cognitect.aws.partnercentral-selling/DisassociateOpportunityRequestRelatedEntityIdentifierString
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListOpportunitiesResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListOpportunitiesResponse/OpportunitySummaries]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListOpportunitiesResponse/NextToken]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementArn
  (s/spec #(re-matches (re-pattern "^arn:.*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ListResourceSnapshotsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.partnercentral-selling/RevenueModel
  (s/spec string? :gen #(s/gen #{"Contract" "Pay-as-you-go" "Subscription"})))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunitySummaries
  (s/coll-of :cognitect.aws.partnercentral-selling/OpportunitySummary))

(s/def :cognitect.aws.partnercentral-selling/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.partnercentral-selling/CreateOpportunityRequestPartnerOpportunityIdentifierString
  (s/spec
    (s/and string? #(<= 0 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ReceiverResponsibility
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Software Partner"
        "Facilitator"
        "Training Partner"
        "Managed Service Provider"
        "Co-Sell Facilitator"
        "Distributor"
        "Hardware Partner"
        "Services Partner"
        "Reseller"})))

(s/def
  :cognitect.aws.partnercentral-selling/GetResourceSnapshotJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetResourceSnapshotJobRequest/Catalog
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobRequest/ResourceSnapshotJobIdentifier]))

(s/def
  :cognitect.aws.partnercentral-selling/DeleteResourceSnapshotJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.DeleteResourceSnapshotJobRequest/Catalog
     :cognitect.aws.partnercentral-selling.DeleteResourceSnapshotJobRequest/ResourceSnapshotJobIdentifier]))

(s/def
  :cognitect.aws.partnercentral-selling/PaymentFrequency
  (s/spec string? :gen #(s/gen #{"Monthly"})))

(s/def
  :cognitect.aws.partnercentral-selling/TaskStatuses
  (s/coll-of :cognitect.aws.partnercentral-selling/TaskStatus :min-count 1 :max-count 3))

(s/def
  :cognitect.aws.partnercentral-selling/StartResourceSnapshotJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.StartResourceSnapshotJobRequest/Catalog
     :cognitect.aws.partnercentral-selling.StartResourceSnapshotJobRequest/ResourceSnapshotJobIdentifier]))

(s/def
  :cognitect.aws.partnercentral-selling/AccountReceiver
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.AccountReceiver/AwsAccountId]
    :opt-un
    [:cognitect.aws.partnercentral-selling.AccountReceiver/Alias]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementIdentifier
  (s/spec #(re-matches (re-pattern "^eng-[0-9a-z]{14}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/AccountOtherIndustryString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListTasksSortBase
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListTasksSortBase/SortBy
     :cognitect.aws.partnercentral-selling.ListTasksSortBase/SortOrder]))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectOtherSolutionDescriptionString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTasksRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/Sort
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/EngagementInvitationIdentifier
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/OpportunityIdentifier
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/MaxResults
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/TaskStatus
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/TaskIdentifier]))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobRoleIdentifier
  (s/spec
    #(re-matches
      (re-pattern "^(arn:aws:iam::\\d{12}:role/([-+=,.@_a-zA-Z0-9]+/)*)?[-+=,.@_a-zA-Z0-9]{1,64}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTasksRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/Sort
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/EngagementIdentifier
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/OpportunityIdentifier
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/MaxResults
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/TaskStatus
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/TaskIdentifier]))

(s/def
  :cognitect.aws.partnercentral-selling/GetOpportunityRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetOpportunityRequest/Catalog
     :cognitect.aws.partnercentral-selling.GetOpportunityRequest/Identifier]))

(s/def
  :cognitect.aws.partnercentral-selling/AwsMarketplaceOfferIdentifiers
  (s/coll-of :cognitect.aws.partnercentral-selling/AwsMarketplaceOfferIdentifier))

(s/def
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendList
  (s/coll-of
    :cognitect.aws.partnercentral-selling/ExpectedCustomerSpend
    :min-count
    0
    :max-count
    10))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotArn
  (s/spec #(re-matches (re-pattern "^arn:.*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementMembersRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListEngagementMembersRequest/Catalog
     :cognitect.aws.partnercentral-selling.ListEngagementMembersRequest/Identifier]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementMembersRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListEngagementMembersRequest/MaxResults]))

(s/def
  :cognitect.aws.partnercentral-selling/ListResourceSnapshotJobsResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsResponse/ResourceSnapshotJobSummaries]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsResponse/NextToken]))

(s/def
  :cognitect.aws.partnercentral-selling/CustomerSummary
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.CustomerSummary/Account]))

(s/def
  :cognitect.aws.partnercentral-selling/SortObject
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.SortObject/SortBy
     :cognitect.aws.partnercentral-selling.SortObject/SortOrder]))

(s/def
  :cognitect.aws.partnercentral-selling/AwsClosedLostReason
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Insufficient Amazon Value"
        "Competitive Offering"
        "People/Relationship/Governance"
        "Lost to Competitor - VMWare"
        "Legal / Tax / Regulatory"
        "No Customer Reference"
        "Product Not on AWS"
        "Lost to Competitor - Rackspace"
        "Failed Vetting"
        "Security / Compliance"
        "Lost to Competitor - Microsoft"
        "No Opportunity"
        "No Response"
        "Lost to Competitor - Other"
        "No Integration Resources"
        "Lost to Competitor"
        "Price"
        "Other (Details in Description)"
        "Customer Experience"
        "Financial/Commercial"
        "Executive Blocker"
        "Duplicate Opportunity"
        "International Constraints"
        "Legal Terms and Conditions"
        "Administrative"
        "Partner Gap"
        "Preference for Competitor"
        "Customer Data Requirement"
        "Technical Limitations"
        "Term Sheet Impasse"
        "Feature Limitation"
        "On Premises Deployment"
        "Past Due"
        "Delay / Cancellation of Project"
        "Lost to Competitor - Google"
        "Insufficient AWS Value"
        "Business Associate Agreement"
        "Platform Technology Limitation"
        "Duplicate"
        "Company Acquired/Dissolved"
        "No Perceived Value of MP"
        "Customer Deficiency"
        "Not Committed to AWS"
        "Self-Service"
        "Lost to Competitor - SoftLayer"
        "Product/Technology"
        "Other"
        "No Update"})))

(s/def
  :cognitect.aws.partnercentral-selling/AssigneeContactLastNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTaskSummaries
  (s/coll-of :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTaskSummary))

(s/def
  :cognitect.aws.partnercentral-selling/ValidationException
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ValidationException/Message
     :cognitect.aws.partnercentral-selling.ValidationException/Reason]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ValidationException/ErrorList]))

(s/def
  :cognitect.aws.partnercentral-selling/Invitation
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.Invitation/Message
     :cognitect.aws.partnercentral-selling.Invitation/Payload
     :cognitect.aws.partnercentral-selling.Invitation/Receiver]))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunityIdentifiers
  (s/coll-of
    :cognitect.aws.partnercentral-selling/OpportunityIdentifier
    :min-count
    1
    :max-count
    10))

(s/def
  :cognitect.aws.partnercentral-selling/AccessDeniedException
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.AccessDeniedException/Message]))

(s/def
  :cognitect.aws.partnercentral-selling/PutSellingSystemSettingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.PutSellingSystemSettingsRequest/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.PutSellingSystemSettingsRequest/ResourceSnapshotJobRoleIdentifier]))

(s/def
  :cognitect.aws.partnercentral-selling/PrimaryNeedFromAws
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Co-Sell - Architectural Validation"
        "Co-Sell - Technical Consultation"
        "Co-Sell - Deal Support"
        "Co-Sell - Pricing Assistance"
        "Co-Sell - Total Cost of Ownership Evaluation"
        "Co-Sell - Support for Public Tender / RFx"
        "Co-Sell - Competitive Information"
        "Co-Sell - Business Presentation"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementInvitationArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws:partnercentral::[0-9]{12}:[a-zA-Z]+/engagement-invitation/engi-[0-9,a-z]{13}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/SalesInvolvementType
  (s/spec string? :gen #(s/gen #{"Co-Sell" "For Visibility Only"})))

(s/def
  :cognitect.aws.partnercentral-selling/TagList
  (s/coll-of :cognitect.aws.partnercentral-selling/Tag :min-count 1 :max-count 200))

(s/def
  :cognitect.aws.partnercentral-selling/Visibility
  (s/spec string? :gen #(s/gen #{"Limited" "Full"})))

(s/def
  :cognitect.aws.partnercentral-selling/ValidationExceptionReason
  (s/spec string? :gen #(s/gen #{"BUSINESS_VALIDATION_FAILED" "REQUEST_VALIDATION_FAILED"})))

(s/def
  :cognitect.aws.partnercentral-selling/ReceiverResponsibilityList
  (s/coll-of :cognitect.aws.partnercentral-selling/ReceiverResponsibility))

(s/def
  :cognitect.aws.partnercentral-selling/AddressStreetAddressString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListOpportunitiesRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/Sort
     :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/LastModifiedDate
     :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/LifeCycleStage
     :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/CustomerCompanyName
     :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/MaxResults
     :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/LifeCycleReviewStatus
     :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/Identifier]))

(s/def
  :cognitect.aws.partnercentral-selling/GetResourceSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/Catalog
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/EngagementIdentifier
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/ResourceIdentifier
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/ResourceSnapshotTemplateIdentifier
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/ResourceType]
    :opt-un
    [:cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/Revision]))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotSummaryList
  (s/coll-of :cognitect.aws.partnercentral-selling/ResourceSnapshotSummary))

(s/def
  :cognitect.aws.partnercentral-selling/GetEngagementInvitationResponseSenderCompanyNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 120))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 120) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementSummaryList
  (s/coll-of :cognitect.aws.partnercentral-selling/EngagementSummary))

(s/def
  :cognitect.aws.partnercentral-selling/AwsTeamMemberFirstNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/CountryCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CR"
        "TG"
        "TJ"
        "ZA"
        "IM"
        "PE"
        "LC"
        "CH"
        "RU"
        "MP"
        "CK"
        "SI"
        "AU"
        "KR"
        "IT"
        "FI"
        "GF"
        "SC"
        "SX"
        "TT"
        "TK"
        "MY"
        "SY"
        "MN"
        "TF"
        "AM"
        "DZ"
        "UY"
        "TD"
        "DJ"
        "BI"
        "MK"
        "MU"
        "LI"
        "NU"
        "GR"
        "GY"
        "CG"
        "NF"
        "ML"
        "AX"
        "GM"
        "SA"
        "CX"
        "BH"
        "NE"
        "BN"
        "MF"
        "CD"
        "DK"
        "BJ"
        "ME"
        "SJ"
        "BO"
        "JO"
        "CV"
        "VE"
        "CI"
        "UZ"
        "TN"
        "IS"
        "EH"
        "TM"
        "GA"
        "LS"
        "TZ"
        "AT"
        "LT"
        "NP"
        "BG"
        "IL"
        "GU"
        "PK"
        "PT"
        "HR"
        "VU"
        "PF"
        "BM"
        "MR"
        "GE"
        "HU"
        "TW"
        "MM"
        "VG"
        "YE"
        "SR"
        "PN"
        "VA"
        "AN"
        "PR"
        "KW"
        "SE"
        "GB"
        "UM"
        "VN"
        "CF"
        "PA"
        "VC"
        "JP"
        "IR"
        "AF"
        "LY"
        "MZ"
        "RO"
        "QA"
        "CM"
        "GG"
        "BY"
        "SD"
        "BQ"
        "MO"
        "KY"
        "AR"
        "BR"
        "ZW"
        "NR"
        "NZ"
        "AW"
        "FJ"
        "ID"
        "SV"
        "CN"
        "FM"
        "HT"
        "CC"
        "RW"
        "BA"
        "TL"
        "JM"
        "KM"
        "KE"
        "WS"
        "TO"
        "PY"
        "SH"
        "CY"
        "GH"
        "MA"
        "SG"
        "LK"
        "PH"
        "SM"
        "WF"
        "TR"
        "PS"
        "BZ"
        "CU"
        "TV"
        "AD"
        "SB"
        "DM"
        "LR"
        "OM"
        "SO"
        "DO"
        "AL"
        "BL"
        "FR"
        "GW"
        "MS"
        "BB"
        "CA"
        "MG"
        "KH"
        "LA"
        "GP"
        "BV"
        "HN"
        "TH"
        "DE"
        "LB"
        "KZ"
        "AS"
        "EC"
        "NO"
        "AO"
        "FK"
        "ET"
        "GS"
        "MD"
        "AG"
        "BE"
        "MV"
        "SZ"
        "CZ"
        "CL"
        "BT"
        "NL"
        "EG"
        "MQ"
        "SN"
        "FO"
        "EE"
        "AQ"
        "ST"
        "KN"
        "BW"
        "MH"
        "NI"
        "PG"
        "VI"
        "IQ"
        "KG"
        "US"
        "ZM"
        "MC"
        "GI"
        "NC"
        "GT"
        "BF"
        "YT"
        "LU"
        "UA"
        "IE"
        "LV"
        "GD"
        "MW"
        "BS"
        "AZ"
        "SK"
        "GQ"
        "TC"
        "RE"
        "IN"
        "ES"
        "GL"
        "KI"
        "HK"
        "CO"
        "SS"
        "RS"
        "IO"
        "NG"
        "UG"
        "CW"
        "SL"
        "ER"
        "JE"
        "AE"
        "HM"
        "PM"
        "BD"
        "MT"
        "AI"
        "GN"
        "PW"
        "NA"
        "MX"
        "PL"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementInvitationArnOrIdentifier
  (s/spec #(re-matches (re-pattern "^(arn:.*|engi-[0-9a-z]{13})$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/UpdateOpportunityRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Catalog
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Identifier
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/LastModifiedDate]
    :opt-un
    [:cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/OpportunityType
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/NationalSecurity
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Customer
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/PartnerOpportunityIdentifier
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/LifeCycle
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Project
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/SoftwareRevenue
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Marketing
     :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/PrimaryNeedsFromAws]))

(s/def
  :cognitect.aws.partnercentral-selling/AwsOpportunityLifeCycleNextStepsHistoryList
  (s/coll-of
    :cognitect.aws.partnercentral-selling/ProfileNextStepsHistory
    :min-count
    0
    :max-count
    50))

(s/def
  :cognitect.aws.partnercentral-selling/SenderContactEmail
  (s/spec
    #(re-matches
      (re-pattern "^[a-zA-Z0-9.!#$%&'*+/=?^_{|}~-]+@[a-zA-Z0-9-]+(?:.[a-zA-Z0-9-]+)*$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectSummary
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ProjectSummary/DeliveryModels
     :cognitect.aws.partnercentral-selling.ProjectSummary/ExpectedCustomerSpend]))

(s/def
  :cognitect.aws.partnercentral-selling/LifeCycle
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.LifeCycle/ClosedLostReason
     :cognitect.aws.partnercentral-selling.LifeCycle/NextSteps
     :cognitect.aws.partnercentral-selling.LifeCycle/ReviewStatusReason
     :cognitect.aws.partnercentral-selling.LifeCycle/ReviewComments
     :cognitect.aws.partnercentral-selling.LifeCycle/TargetCloseDate
     :cognitect.aws.partnercentral-selling.LifeCycle/NextStepsHistory
     :cognitect.aws.partnercentral-selling.LifeCycle/ReviewStatus
     :cognitect.aws.partnercentral-selling.LifeCycle/Stage]))

(s/def
  :cognitect.aws.partnercentral-selling/PartnerOpportunityTeamMembersList
  (s/coll-of :cognitect.aws.partnercentral-selling/Contact :min-count 0 :max-count 1))

(s/def
  :cognitect.aws.partnercentral-selling/CurrencyCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"NZD"
        "SGD"
        "ANG"
        "MNT"
        "BIF"
        "BBD"
        "HUF"
        "ERN"
        "AZN"
        "BYN"
        "AOA"
        "PYG"
        "MYR"
        "GYD"
        "VUV"
        "SLL"
        "FKP"
        "DJF"
        "GNF"
        "MMK"
        "RSD"
        "CLF"
        "XDR"
        "ZAR"
        "TND"
        "PHP"
        "KGS"
        "RON"
        "RUB"
        "KMF"
        "CHW"
        "SCR"
        "GIP"
        "MXV"
        "TRY"
        "UYU"
        "XCD"
        "FJD"
        "GHS"
        "MVR"
        "AWG"
        "UGX"
        "TOP"
        "CVE"
        "MKD"
        "COP"
        "CUC"
        "GTQ"
        "KZT"
        "MXN"
        "MGA"
        "AUD"
        "BDT"
        "ISK"
        "KRW"
        "DZD"
        "OMR"
        "ZMW"
        "MOP"
        "CUP"
        "JPY"
        "SHP"
        "LSL"
        "ETB"
        "BWP"
        "MAD"
        "AED"
        "NGN"
        "BRL"
        "GEL"
        "IDR"
        "EUR"
        "GBP"
        "WST"
        "UYI"
        "XAF"
        "SZL"
        "XOF"
        "SEK"
        "UZS"
        "KES"
        "KYD"
        "ILS"
        "KWD"
        "NPR"
        "MRU"
        "BZD"
        "QAR"
        "UAH"
        "XSU"
        "BTN"
        "HTG"
        "DKK"
        "USN"
        "VND"
        "SBD"
        "SSP"
        "STN"
        "JMD"
        "IQD"
        "LBP"
        "HRK"
        "HKD"
        "JOD"
        "PAB"
        "CDF"
        "VEF"
        "BAM"
        "CNY"
        "SOS"
        "XPF"
        "GMD"
        "DOP"
        "KPW"
        "BOB"
        "BHD"
        "LRD"
        "BGN"
        "AMD"
        "CZK"
        "CAD"
        "LAK"
        "PLN"
        "LKR"
        "XUA"
        "MWK"
        "PGK"
        "YER"
        "PEN"
        "KHR"
        "RWF"
        "BSD"
        "AFN"
        "ZWL"
        "LYD"
        "TMT"
        "HNL"
        "TWD"
        "IRR"
        "MUR"
        "BOV"
        "THB"
        "ALL"
        "TJS"
        "SDG"
        "BMD"
        "CRC"
        "USD"
        "NOK"
        "SRD"
        "MZN"
        "CLP"
        "SYP"
        "TZS"
        "EGP"
        "COU"
        "ARS"
        "MDL"
        "INR"
        "CHE"
        "SAR"
        "PKR"
        "TTD"
        "NIO"
        "BND"
        "NAD"
        "SVC"
        "CHF"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementMemberSummaries
  (s/coll-of :cognitect.aws.partnercentral-selling/EngagementMemberSummary))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementInvitationsPayloadType
  (s/coll-of :cognitect.aws.partnercentral-selling/EngagementInvitationPayloadType))

(s/def
  :cognitect.aws.partnercentral-selling/NationalSecurity
  (s/spec string? :gen #(s/gen #{"Yes" "No"})))

(s/def
  :cognitect.aws.partnercentral-selling/ClosedLostReason
  (s/spec
    string?
    :gen
    #(s/gen
      #{"People/Relationship/Governance"
        "Lost to Competitor - VMWare"
        "Legal / Tax / Regulatory"
        "Security / Compliance"
        "Lost to Competitor - Microsoft"
        "No Opportunity"
        "Lost to Competitor - Other"
        "Price"
        "Customer Experience"
        "Financial/Commercial"
        "Partner Gap"
        "Technical Limitations"
        "On Premises Deployment"
        "Delay / Cancellation of Project"
        "Lost to Competitor - Google"
        "Customer Deficiency"
        "Lost to Competitor - SoftLayer"
        "Product/Technology"
        "Other"})))

(s/def
  :cognitect.aws.partnercentral-selling/TaskArn
  (s/spec #(re-matches (re-pattern "^arn:.*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/MemberPageSize
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.partnercentral-selling/GetAwsOpportunitySummaryRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryRequest/Catalog
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryRequest/RelatedOpportunityIdentifier]))

(s/def
  :cognitect.aws.partnercentral-selling/Email
  (s/spec
    #(re-matches
      (re-pattern
        "^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/AwsSubmission
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.AwsSubmission/InvolvementType]
    :opt-un
    [:cognitect.aws.partnercentral-selling.AwsSubmission/Visibility]))

(s/def
  :cognitect.aws.partnercentral-selling/UseCases
  (s/coll-of :cognitect.aws.partnercentral-selling/String))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementInvitationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementInvitationsResponse/NextToken
     :cognitect.aws.partnercentral-selling.ListEngagementInvitationsResponse/EngagementInvitationSummaries]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementResourceAssociationSummaryList
  (s/coll-of :cognitect.aws.partnercentral-selling/EngagementResourceAssociationSummary))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementInvitationSummaries
  (s/coll-of :cognitect.aws.partnercentral-selling/EngagementInvitationSummary))

(s/def
  :cognitect.aws.partnercentral-selling/GetSellingSystemSettingsRequest
  (s/keys :req-un [:cognitect.aws.partnercentral-selling.GetSellingSystemSettingsRequest/Catalog]))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementResourceAssociationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/CreatedBy
     :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/EngagementIdentifier
     :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/ResourceType
     :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/ResourceIdentifier
     :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/MaxResults]))

(s/def
  :cognitect.aws.partnercentral-selling/AccountCompanyNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 120))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 120) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/AssociateOpportunityRequestRelatedEntityIdentifierString
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/RelatedEntityIdentifiers
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.RelatedEntityIdentifiers/AwsMarketplaceOffers
     :cognitect.aws.partnercentral-selling.RelatedEntityIdentifiers/Solutions
     :cognitect.aws.partnercentral-selling.RelatedEntityIdentifiers/AwsProducts]))

(s/def
  :cognitect.aws.partnercentral-selling/Channel
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Display"
        "Telemarketing"
        "Social"
        "AWS Marketing Central"
        "Email"
        "Video"
        "Print"
        "Content Syndication"
        "TV"
        "Out Of Home (OOH)"
        "Live Event"
        "Virtual Event"
        "Search"})))

(s/def
  :cognitect.aws.partnercentral-selling/ListResourceSnapshotJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/Sort
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/Status
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/EngagementIdentifier
     :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/MaxResults]))

(s/def
  :cognitect.aws.partnercentral-selling/AwsFundingUsed
  (s/spec string? :gen #(s/gen #{"Yes" "No"})))

(s/def
  :cognitect.aws.partnercentral-selling/StartEngagementFromOpportunityTaskRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/AwsSubmission
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/Catalog
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/ClientToken
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/Identifier]
    :opt-un
    [:cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/Tags]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementSort
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.EngagementSort/SortBy
     :cognitect.aws.partnercentral-selling.EngagementSort/SortOrder]))

(s/def
  :cognitect.aws.partnercentral-selling/TaskStatus
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "COMPLETE" "FAILED"})))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectDetailsTitleString
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/AcceptEngagementInvitationRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.AcceptEngagementInvitationRequest/Catalog
     :cognitect.aws.partnercentral-selling.AcceptEngagementInvitationRequest/Identifier]))

(s/def
  :cognitect.aws.partnercentral-selling/ListSolutionsRequestCategoryList
  (s/coll-of :cognitect.aws.partnercentral-selling/String :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.partnercentral-selling/DunsNumber
  (s/spec #(re-matches (re-pattern "^[0-9]{9}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/CustomerProjectsContext
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.CustomerProjectsContext/Customer
     :cognitect.aws.partnercentral-selling.CustomerProjectsContext/Project]))

(s/def
  :cognitect.aws.partnercentral-selling/GetOpportunityResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetOpportunityResponse/Catalog
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/CreatedDate
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Id
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/LastModifiedDate
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/RelatedEntityIdentifiers]
    :opt-un
    [:cognitect.aws.partnercentral-selling.GetOpportunityResponse/OpportunityType
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/NationalSecurity
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Customer
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/PartnerOpportunityIdentifier
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/OpportunityTeam
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/LifeCycle
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Project
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/SoftwareRevenue
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Marketing
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Arn
     :cognitect.aws.partnercentral-selling.GetOpportunityResponse/PrimaryNeedsFromAws]))

(s/def
  :cognitect.aws.partnercentral-selling/ContactFirstNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/CompetitorName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Akamai"
        "On-Prem"
        "IBM Softlayer"
        "Google Cloud Platform"
        "AliCloud"
        "Oracle Cloud"
        "Microsoft Azure"
        "*Other"
        "Other- Cost Optimization"
        "Co-location"
        "No Competition"})))

(s/def
  :cognitect.aws.partnercentral-selling/SolutionArn
  (s/spec #(re-matches (re-pattern "^S-[0-9]{1,19}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/AwsOpportunityStage
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Business Validation"
        "Closed Lost"
        "Launched"
        "Qualify"
        "Seller Engaged"
        "In Progress"
        "Deferred to Partner"
        "Contract Negotiation"
        "Identified"
        "Closed Incomplete"
        "Not Started"
        "Qualified"
        "Building Integration"
        "Term Sheet Negotiation"
        "Evaluating"
        "Prospect"
        "Completed"
        "Engaged"
        "On-hold"
        "Research"
        "Committed"
        "Onboarding"
        "Seller Registered"
        "Technical Validation"})))

(s/def
  :cognitect.aws.partnercentral-selling/InvolvementTypeChangeReason
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Change in Deal Information"
        "Technical Complexity"
        "Expansion Opportunity"
        "Customer Requested"
        "Risk Mitigation"})))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotPayload
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ResourceSnapshotPayload/OpportunitySummary]))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTasksRequestNextTokenString
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/Marketing
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.Marketing/CampaignName
     :cognitect.aws.partnercentral-selling.Marketing/Source
     :cognitect.aws.partnercentral-selling.Marketing/UseCases
     :cognitect.aws.partnercentral-selling.Marketing/AwsFundingUsed
     :cognitect.aws.partnercentral-selling.Marketing/Channels]))

(s/def
  :cognitect.aws.partnercentral-selling/GetOpportunityResponsePartnerOpportunityIdentifierString
  (s/spec
    (s/and string? #(<= 0 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/AssigneeContact
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.AssigneeContact/BusinessTitle
     :cognitect.aws.partnercentral-selling.AssigneeContact/Email
     :cognitect.aws.partnercentral-selling.AssigneeContact/FirstName
     :cognitect.aws.partnercentral-selling.AssigneeContact/LastName]))

(s/def
  :cognitect.aws.partnercentral-selling/SalesActivities
  (s/coll-of :cognitect.aws.partnercentral-selling/SalesActivity))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectDetails
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ProjectDetails/BusinessProblem
     :cognitect.aws.partnercentral-selling.ProjectDetails/ExpectedCustomerSpend
     :cognitect.aws.partnercentral-selling.ProjectDetails/TargetCompletionDate
     :cognitect.aws.partnercentral-selling.ProjectDetails/Title]))

(s/def
  :cognitect.aws.partnercentral-selling/CreateResourceSnapshotResponse
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.CreateResourceSnapshotResponse/Revision
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotResponse/Arn]))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunityEngagementInvitationSortName
  (s/spec string? :gen #(s/gen #{"InvitationDate"})))

(s/def
  :cognitect.aws.partnercentral-selling/Payload
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.Payload/OpportunityInvitation]))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunitySummary
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.OpportunitySummary/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.OpportunitySummary/OpportunityType
     :cognitect.aws.partnercentral-selling.OpportunitySummary/LastModifiedDate
     :cognitect.aws.partnercentral-selling.OpportunitySummary/Customer
     :cognitect.aws.partnercentral-selling.OpportunitySummary/PartnerOpportunityIdentifier
     :cognitect.aws.partnercentral-selling.OpportunitySummary/LifeCycle
     :cognitect.aws.partnercentral-selling.OpportunitySummary/CreatedDate
     :cognitect.aws.partnercentral-selling.OpportunitySummary/Project
     :cognitect.aws.partnercentral-selling.OpportunitySummary/Arn
     :cognitect.aws.partnercentral-selling.OpportunitySummary/Id]))

(s/def
  :cognitect.aws.partnercentral-selling/MonetaryValue
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.MonetaryValue/Amount
     :cognitect.aws.partnercentral-selling.MonetaryValue/CurrencyCode]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementIdentifiers
  (s/coll-of
    :cognitect.aws.partnercentral-selling/EngagementArnOrIdentifier
    :min-count
    1
    :max-count
    10))

(s/def
  :cognitect.aws.partnercentral-selling/Address
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.Address/StateOrRegion
     :cognitect.aws.partnercentral-selling.Address/PostalCode
     :cognitect.aws.partnercentral-selling.Address/CountryCode
     :cognitect.aws.partnercentral-selling.Address/StreetAddress
     :cognitect.aws.partnercentral-selling.Address/City]))

(s/def
  :cognitect.aws.partnercentral-selling/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.partnercentral-selling/GetSellingSystemSettingsResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetSellingSystemSettingsResponse/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.GetSellingSystemSettingsResponse/ResourceSnapshotJobRoleArn]))

(s/def
  :cognitect.aws.partnercentral-selling/StartEngagementFromOpportunityTaskResponse
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/StartTime
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/TaskId
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/ResourceSnapshotJobId
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/OpportunityId
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/TaskArn
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/Message
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/EngagementId
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/ReasonCode
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/EngagementInvitationId
     :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/TaskStatus]))

(s/def
  :cognitect.aws.partnercentral-selling/AwsAccountList
  (s/coll-of :cognitect.aws.partnercentral-selling/AwsAccount :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementContextDetails
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.EngagementContextDetails/Type]
    :opt-un
    [:cognitect.aws.partnercentral-selling.EngagementContextDetails/Payload]))

(s/def
  :cognitect.aws.partnercentral-selling/GetResourceSnapshotResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/Payload
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/CreatedBy
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/ResourceId
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/Revision
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/ResourceType
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/Arn
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/EngagementId
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/CreatedAt
     :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/ResourceSnapshotTemplateName]))

(s/def
  :cognitect.aws.partnercentral-selling/ListSolutionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListSolutionsRequest/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListSolutionsRequest/Sort
     :cognitect.aws.partnercentral-selling.ListSolutionsRequest/Category
     :cognitect.aws.partnercentral-selling.ListSolutionsRequest/Status
     :cognitect.aws.partnercentral-selling.ListSolutionsRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListSolutionsRequest/MaxResults
     :cognitect.aws.partnercentral-selling.ListSolutionsRequest/Identifier]))

(s/def
  :cognitect.aws.partnercentral-selling/CreateResourceSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/Catalog
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/ClientToken
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/EngagementIdentifier
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/ResourceIdentifier
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/ResourceSnapshotTemplateIdentifier
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/ResourceType]))

(s/def :cognitect.aws.partnercentral-selling/AddressPart string?)

(s/def
  :cognitect.aws.partnercentral-selling/EngagementTitle
  (s/spec
    (s/and string? #(<= 1 (count %) 40))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 40) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListOpportunitiesRequestCustomerCompanyNameList
  (s/coll-of :cognitect.aws.partnercentral-selling/String :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.partnercentral-selling/TagValue
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/RejectionReasonString
  (s/spec
    #(re-matches (re-pattern "^[\\u0020-\\u007E\\u00A0-\\uD7FF\\uE000-\\uFFFD]{1,80}$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/DeliveryModels
  (s/coll-of :cognitect.aws.partnercentral-selling/DeliveryModel))

(s/def
  :cognitect.aws.partnercentral-selling/CreateOpportunityResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.CreateOpportunityResponse/Id]
    :opt-un
    [:cognitect.aws.partnercentral-selling.CreateOpportunityResponse/LastModifiedDate
     :cognitect.aws.partnercentral-selling.CreateOpportunityResponse/PartnerOpportunityIdentifier]))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTasksRequestNextTokenString
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/RejectEngagementInvitationRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.RejectEngagementInvitationRequest/Catalog
     :cognitect.aws.partnercentral-selling.RejectEngagementInvitationRequest/Identifier]
    :opt-un
    [:cognitect.aws.partnercentral-selling.RejectEngagementInvitationRequest/RejectionReason]))

(s/def
  :cognitect.aws.partnercentral-selling/SalesActivity
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Finalized Deployment Need"
        "Completed Action Plan"
        "Customer has shown interest in solution"
        "Conducted POC / Demo"
        "Initialized discussions with customer"
        "Agreed on solution to Business Problem"
        "SOW Signed"
        "In evaluation / planning stage"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementInvitationSummary
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Catalog
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Id]
    :opt-un
    [:cognitect.aws.partnercentral-selling.EngagementInvitationSummary/InvitationDate
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/SenderCompanyName
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Status
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/ExpirationDate
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/ParticipantType
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Arn
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/EngagementId
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/PayloadType
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Receiver
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/SenderAwsAccountId
     :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/EngagementTitle]))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunityEngagementInvitationSort
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.OpportunityEngagementInvitationSort/SortBy
     :cognitect.aws.partnercentral-selling.OpportunityEngagementInvitationSort/SortOrder]))

(s/def
  :cognitect.aws.partnercentral-selling/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.partnercentral-selling.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTaskSummaries
  (s/coll-of :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTaskSummary))

(s/def
  :cognitect.aws.partnercentral-selling/CompanyName
  (s/spec
    (s/and string? #(<= 1 (count %) 120))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 120) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/CreateEngagementInvitationRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.CreateEngagementInvitationRequest/Catalog
     :cognitect.aws.partnercentral-selling.CreateEngagementInvitationRequest/ClientToken
     :cognitect.aws.partnercentral-selling.CreateEngagementInvitationRequest/EngagementIdentifier
     :cognitect.aws.partnercentral-selling.CreateEngagementInvitationRequest/Invitation]))

(s/def
  :cognitect.aws.partnercentral-selling/JobTitle
  (s/spec
    (s/and string? #(<= 0 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/LifeCycleSummary
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.LifeCycleSummary/ClosedLostReason
     :cognitect.aws.partnercentral-selling.LifeCycleSummary/NextSteps
     :cognitect.aws.partnercentral-selling.LifeCycleSummary/ReviewStatusReason
     :cognitect.aws.partnercentral-selling.LifeCycleSummary/ReviewComments
     :cognitect.aws.partnercentral-selling.LifeCycleSummary/TargetCloseDate
     :cognitect.aws.partnercentral-selling.LifeCycleSummary/ReviewStatus
     :cognitect.aws.partnercentral-selling.LifeCycleSummary/Stage]))

(s/def
  :cognitect.aws.partnercentral-selling/CreateResourceSnapshotRequestClientTokenString
  (s/spec #(re-matches (re-pattern "^[!-~]{1,64}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobSummaryList
  (s/coll-of :cognitect.aws.partnercentral-selling/ResourceSnapshotJobSummary))

(s/def
  :cognitect.aws.partnercentral-selling/PhoneNumber
  (s/spec #(re-matches (re-pattern "^\\+[1-9]\\d{1,14}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/AwsOpportunityLifeCycle
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/ClosedLostReason
     :cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/NextSteps
     :cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/TargetCloseDate
     :cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/NextStepsHistory
     :cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/Stage]))

(s/def :cognitect.aws.partnercentral-selling/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTasksResponse
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksResponse/TaskSummaries
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksResponse/NextToken]))

(s/def
  :cognitect.aws.partnercentral-selling/ReasonCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ResourceSnapshotJobAccessDenied"
        "ResourceSnapshotJobConflict"
        "InternalError"
        "OpportunitySubmissionFailed"
        "EngagementAccessDenied"
        "RequestThrottled"
        "EngagementConflict"
        "OpportunityValidationFailed"
        "OpportunityConflict"
        "ResourceSnapshotConflict"
        "InvitationValidationFailed"
        "EngagementInvitationConflict"
        "ResourceSnapshotJobValidationFailed"
        "ResourceSnapshotValidationFailed"
        "InvitationAccessDenied"
        "ServiceQuotaExceeded"
        "OpportunityAccessDenied"
        "EngagementValidationFailed"
        "ResourceSnapshotAccessDenied"})))

(s/def
  :cognitect.aws.partnercentral-selling/ListSolutionsRequestIdentifierList
  (s/coll-of :cognitect.aws.partnercentral-selling/SolutionIdentifier :min-count 0 :max-count 20))

(s/def
  :cognitect.aws.partnercentral-selling/AddressSummaryCityString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementSummary
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.EngagementSummary/MemberCount
     :cognitect.aws.partnercentral-selling.EngagementSummary/Title
     :cognitect.aws.partnercentral-selling.EngagementSummary/CreatedBy
     :cognitect.aws.partnercentral-selling.EngagementSummary/Arn
     :cognitect.aws.partnercentral-selling.EngagementSummary/CreatedAt
     :cognitect.aws.partnercentral-selling.EngagementSummary/Id]))

(s/def
  :cognitect.aws.partnercentral-selling/MarketingSource
  (s/spec string? :gen #(s/gen #{"Marketing Activity" "None"})))

(s/def
  :cognitect.aws.partnercentral-selling/AwsOpportunityProject
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.AwsOpportunityProject/ExpectedCustomerSpend]))

(s/def
  :cognitect.aws.partnercentral-selling/MemberCompanyName
  (s/spec
    (s/and string? #(<= 1 (count %) 120))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 120) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementsResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListEngagementsResponse/EngagementSummaryList]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementsResponse/NextToken]))

(s/def
  :cognitect.aws.partnercentral-selling/TaggableResourceArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:[\\w+=/,.@-]+:partnercentral:[\\w+=/,.@-]*:[0-9]{12}:catalog/([a-zA-Z]+)/[\\w+=,.@-]+(/[\\w+=,.@-]+)*$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/LifeCycleNextStepsString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/TaskIdentifier
  (s/spec #(re-matches (re-pattern "task-[0-9a-z]{13}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/Customer
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.Customer/Contacts
     :cognitect.aws.partnercentral-selling.Customer/Account]))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTaskSummary
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/StartTime
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/TaskId
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/ResourceSnapshotJobId
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/OpportunityId
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/TaskArn
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/Message
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/EngagementId
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/ReasonCode
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/EngagementInvitationId
     :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/TaskStatus]))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTasksResponse
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksResponse/TaskSummaries
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksResponse/NextToken]))

(s/def
  :cognitect.aws.partnercentral-selling/ListSolutionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListSolutionsResponse/SolutionSummaries]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListSolutionsResponse/NextToken]))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobRoleArn
  (s/spec
    #(re-matches
      (re-pattern "^arn:aws:iam::\\d{12}:role/([-+=,.@_a-zA-Z0-9]+/)*[-+=,.@_a-zA-Z0-9]{1,64}$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/AccountSummaryCompanyNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 120))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 120) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectAdditionalCommentsString
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListSolutionsRequestStatusList
  (s/coll-of :cognitect.aws.partnercentral-selling/SolutionStatus :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.partnercentral-selling/Industry
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Automotive"
        "Aerospace"
        "Software and Internet"
        "Retail"
        "Mining"
        "Manufacturing"
        "Energy - Oil and Gas"
        "Travel"
        "Education"
        "Wholesale and Distribution"
        "Government"
        "Healthcare"
        "Consumer Goods"
        "Real Estate and Construction"
        "Telecommunications"
        "Energy - Power and Utilities"
        "Hospitality"
        "Gaming"
        "Transportation and Logistics"
        "Marketing and Advertising"
        "Computers and Electronics"
        "Financial Services"
        "Agriculture"
        "Non-Profit Organization"
        "Life Sciences"
        "Media and Entertainment"
        "Other"
        "Professional Services"})))

(s/def
  :cognitect.aws.partnercentral-selling/ListTasksSortName
  (s/spec string? :gen #(s/gen #{"StartTime"})))

(s/def
  :cognitect.aws.partnercentral-selling/AwsTeamMember
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.AwsTeamMember/Email
     :cognitect.aws.partnercentral-selling.AwsTeamMember/LastName
     :cognitect.aws.partnercentral-selling.AwsTeamMember/BusinessTitle
     :cognitect.aws.partnercentral-selling.AwsTeamMember/FirstName]))

(s/def
  :cognitect.aws.partnercentral-selling/AssignOpportunityRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.AssignOpportunityRequest/Assignee
     :cognitect.aws.partnercentral-selling.AssignOpportunityRequest/Catalog
     :cognitect.aws.partnercentral-selling.AssignOpportunityRequest/Identifier]))

(s/def
  :cognitect.aws.partnercentral-selling/UpdateOpportunityRequestPartnerOpportunityIdentifierString
  (s/spec
    (s/and string? #(<= 0 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/CreateResourceSnapshotJobRequestClientTokenString
  (s/spec #(re-matches (re-pattern "^[!-~]{1,64}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/AddressSummaryPostalCodeString
  (s/spec
    (s/and string? #(<= 0 (count %) 20))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 20) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.partnercentral-selling/SortBy (s/spec string? :gen #(s/gen #{"CreatedDate"})))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobSummary
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ResourceSnapshotJobSummary/Status
     :cognitect.aws.partnercentral-selling.ResourceSnapshotJobSummary/Arn
     :cognitect.aws.partnercentral-selling.ResourceSnapshotJobSummary/EngagementId
     :cognitect.aws.partnercentral-selling.ResourceSnapshotJobSummary/Id]))

(s/def
  :cognitect.aws.partnercentral-selling/LifeCycleNextStepsHistoryList
  (s/coll-of :cognitect.aws.partnercentral-selling/NextStepsHistory :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTaskSummary
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/StartTime
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/TaskId
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/ResourceSnapshotJobId
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/OpportunityId
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/TaskArn
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/Message
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/ReasonCode
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/EngagementInvitationId
     :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/TaskStatus]))

(s/def
  :cognitect.aws.partnercentral-selling/GetEngagementInvitationResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Catalog
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Id]
    :opt-un
    [:cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/InvitationDate
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/InvitationMessage
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/SenderCompanyName
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Status
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Payload
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/EngagementDescription
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/ExpirationDate
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Arn
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/EngagementId
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/PayloadType
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/ExistingMembers
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/RejectionReason
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Receiver
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/SenderAwsAccountId
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/EngagementTitle]))

(s/def
  :cognitect.aws.partnercentral-selling/DeliveryModel
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Resell" "Managed Services" "SaaS or PaaS" "BYOL or AMI" "Other" "Professional Services"})))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunitySortName
  (s/spec string? :gen #(s/gen #{"LastModifiedDate" "CustomerCompanyName" "Identifier"})))

(s/def
  :cognitect.aws.partnercentral-selling/RelatedEntityType
  (s/spec string? :gen #(s/gen #{"AwsMarketplaceOffers" "Solutions" "AwsProducts"})))

(s/def
  :cognitect.aws.partnercentral-selling/Account
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.Account/CompanyName]
    :opt-un
    [:cognitect.aws.partnercentral-selling.Account/Address
     :cognitect.aws.partnercentral-selling.Account/Industry
     :cognitect.aws.partnercentral-selling.Account/Duns
     :cognitect.aws.partnercentral-selling.Account/OtherIndustry
     :cognitect.aws.partnercentral-selling.Account/AwsAccountId
     :cognitect.aws.partnercentral-selling.Account/WebsiteUrl]))

(s/def
  :cognitect.aws.partnercentral-selling/ValidationExceptionErrorCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"INVALID_STRING_FORMAT"
        "TOO_MANY_VALUES"
        "ACTION_NOT_PERMITTED"
        "DUPLICATE_KEY_VALUE"
        "INVALID_RESOURCE_STATE"
        "INVALID_VALUE"
        "REQUIRED_FIELD_MISSING"
        "INVALID_ENUM_VALUE"
        "VALUE_OUT_OF_RANGE"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementArnOrIdentifier
  (s/spec #(re-matches (re-pattern "^(arn:.*|eng-[0-9a-z]{14})$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ListOpportunitiesRequestIdentifierList
  (s/coll-of
    :cognitect.aws.partnercentral-selling/OpportunityIdentifier
    :min-count
    0
    :max-count
    20))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceTemplateName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9]{3,80}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/UpdateOpportunityResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.UpdateOpportunityResponse/Id
     :cognitect.aws.partnercentral-selling.UpdateOpportunityResponse/LastModifiedDate]))

(s/def
  :cognitect.aws.partnercentral-selling/ListOpportunitiesRequestLifeCycleReviewStatusList
  (s/coll-of :cognitect.aws.partnercentral-selling/ReviewStatus :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementInvitationIdentifiers
  (s/coll-of
    :cognitect.aws.partnercentral-selling/EngagementInvitationArnOrIdentifier
    :min-count
    1
    :max-count
    10))

(s/def
  :cognitect.aws.partnercentral-selling/CreateResourceSnapshotJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobResponse/Arn
     :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobResponse/Id]))

(s/def
  :cognitect.aws.partnercentral-selling/AddressSummary
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.AddressSummary/StateOrRegion
     :cognitect.aws.partnercentral-selling.AddressSummary/PostalCode
     :cognitect.aws.partnercentral-selling.AddressSummary/CountryCode
     :cognitect.aws.partnercentral-selling.AddressSummary/City]))

(s/def
  :cognitect.aws.partnercentral-selling/SortOrder
  (s/spec string? :gen #(s/gen #{"ASCENDING" "DESCENDING"})))

(s/def
  :cognitect.aws.partnercentral-selling/Date
  (s/spec
    #(re-matches (re-pattern "^[1-9][0-9]{3}-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/TaskIdentifiers
  (s/coll-of :cognitect.aws.partnercentral-selling/TaskArnOrIdentifier :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementContextPayload
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.EngagementContextPayload/CustomerProject]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementDescription
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendCurrencyCodeEnum
  (s/spec
    string?
    :gen
    #(s/gen
      #{"NZD"
        "SGD"
        "ANG"
        "MNT"
        "BIF"
        "BBD"
        "HUF"
        "ERN"
        "AZN"
        "BYN"
        "AOA"
        "PYG"
        "MYR"
        "GYD"
        "VUV"
        "SLL"
        "FKP"
        "DJF"
        "GNF"
        "MMK"
        "RSD"
        "CLF"
        "XDR"
        "ZAR"
        "TND"
        "PHP"
        "KGS"
        "RON"
        "RUB"
        "KMF"
        "CHW"
        "SCR"
        "GIP"
        "MXV"
        "TRY"
        "UYU"
        "XCD"
        "FJD"
        "GHS"
        "MVR"
        "AWG"
        "UGX"
        "TOP"
        "CVE"
        "MKD"
        "COP"
        "CUC"
        "GTQ"
        "KZT"
        "MXN"
        "MGA"
        "AUD"
        "BDT"
        "ISK"
        "KRW"
        "DZD"
        "OMR"
        "ZMW"
        "MOP"
        "CUP"
        "JPY"
        "SHP"
        "LSL"
        "ETB"
        "BWP"
        "MAD"
        "AED"
        "NGN"
        "BRL"
        "GEL"
        "IDR"
        "EUR"
        "GBP"
        "WST"
        "UYI"
        "XAF"
        "SZL"
        "XOF"
        "SEK"
        "UZS"
        "KES"
        "KYD"
        "ILS"
        "KWD"
        "NPR"
        "MRU"
        "BZD"
        "QAR"
        "UAH"
        "XSU"
        "BTN"
        "HTG"
        "DKK"
        "USN"
        "VND"
        "SBD"
        "SSP"
        "STN"
        "JMD"
        "IQD"
        "LBP"
        "HRK"
        "HKD"
        "JOD"
        "PAB"
        "CDF"
        "VEF"
        "BAM"
        "CNY"
        "SOS"
        "XPF"
        "GMD"
        "DOP"
        "KPW"
        "BOB"
        "BHD"
        "LRD"
        "BGN"
        "AMD"
        "CZK"
        "CAD"
        "LAK"
        "PLN"
        "LKR"
        "XUA"
        "MWK"
        "PGK"
        "YER"
        "PEN"
        "KHR"
        "RWF"
        "BSD"
        "AFN"
        "ZWL"
        "LYD"
        "TMT"
        "HNL"
        "TWD"
        "IRR"
        "MUR"
        "BOV"
        "THB"
        "ALL"
        "TJS"
        "SDG"
        "BMD"
        "CRC"
        "USD"
        "NOK"
        "SRD"
        "MZN"
        "CLP"
        "SYP"
        "TZS"
        "EGP"
        "COU"
        "ARS"
        "MDL"
        "INR"
        "CHE"
        "SAR"
        "PKR"
        "TTD"
        "NIO"
        "BND"
        "NAD"
        "SVC"
        "CHF"})))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTasksRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.partnercentral-selling/SubmitOpportunityRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.SubmitOpportunityRequest/Catalog
     :cognitect.aws.partnercentral-selling.SubmitOpportunityRequest/Identifier
     :cognitect.aws.partnercentral-selling.SubmitOpportunityRequest/InvolvementType]
    :opt-un
    [:cognitect.aws.partnercentral-selling.SubmitOpportunityRequest/Visibility]))

(s/def
  :cognitect.aws.partnercentral-selling/StartEngagementByAcceptingInvitationTaskResponse
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/StartTime
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/TaskId
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/ResourceSnapshotJobId
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/OpportunityId
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/TaskArn
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/Message
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/ReasonCode
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/EngagementInvitationId
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/TaskStatus]))

(s/def
  :cognitect.aws.partnercentral-selling/AwsProductIdentifiers
  (s/coll-of :cognitect.aws.partnercentral-selling/AwsProductIdentifier))

(s/def
  :cognitect.aws.partnercentral-selling/SenderContactList
  (s/coll-of :cognitect.aws.partnercentral-selling/SenderContact :min-count 1 :max-count 3))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotRevision
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.partnercentral-selling/AssigneeContactFirstNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectTitleString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ValidationExceptionError
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ValidationExceptionError/Code
     :cognitect.aws.partnercentral-selling.ValidationExceptionError/Message]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ValidationExceptionError/FieldName]))

(s/def
  :cognitect.aws.partnercentral-selling/ApnPrograms
  (s/coll-of :cognitect.aws.partnercentral-selling/String))

(s/def
  :cognitect.aws.partnercentral-selling/AwsOpportunityInsights
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.AwsOpportunityInsights/NextBestActions
     :cognitect.aws.partnercentral-selling.AwsOpportunityInsights/EngagementScore]))

(s/def
  :cognitect.aws.partnercentral-selling/AwsOpportunityTeamMembersList
  (s/coll-of :cognitect.aws.partnercentral-selling/AwsTeamMember))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementCustomerProjectDetails
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.EngagementCustomerProjectDetails/BusinessProblem
     :cognitect.aws.partnercentral-selling.EngagementCustomerProjectDetails/TargetCompletionDate
     :cognitect.aws.partnercentral-selling.EngagementCustomerProjectDetails/Title]))

(s/def
  :cognitect.aws.partnercentral-selling/GetAwsOpportunitySummaryResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Visibility
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Customer
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Origin
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/RelatedOpportunityId
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/OpportunityTeam
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/InvolvementType
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/LifeCycle
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/InvolvementTypeChangeReason
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Project
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Insights
     :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/RelatedEntityIds]))

(s/def
  :cognitect.aws.partnercentral-selling/AddressPostalCodeString
  (s/spec
    (s/and string? #(<= 0 (count %) 20))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 20) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/Name
  (s/spec
    (s/and string? #(<= 0 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/PageSize
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementContextType
  (s/spec string? :gen #(s/gen #{"CustomerProject"})))

(s/def
  :cognitect.aws.partnercentral-selling/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.UntagResourceRequest/ResourceArn
     :cognitect.aws.partnercentral-selling.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.partnercentral-selling/InvitationStatus
  (s/spec string? :gen #(s/gen #{"ACCEPTED" "EXPIRED" "PENDING" "REJECTED"})))

(s/def
  :cognitect.aws.partnercentral-selling/TagKey
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunityOrigin
  (s/spec string? :gen #(s/gen #{"Partner Referral" "AWS Referral"})))

(s/def
  :cognitect.aws.partnercentral-selling/TaskArnOrIdentifier
  (s/spec #(re-matches (re-pattern "^(arn:.*|task-[0-9a-z]{13})$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ValidationExceptionErrorList
  (s/coll-of :cognitect.aws.partnercentral-selling/ValidationExceptionError))

(s/def
  :cognitect.aws.partnercentral-selling/MonetaryValueAmountString
  (s/spec
    #(re-matches (re-pattern "^(0|([1-9][0-9]{0,30}))(\\.[0-9]{0,2})?$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ProjectView
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ProjectView/DeliveryModels
     :cognitect.aws.partnercentral-selling.ProjectView/CustomerUseCase
     :cognitect.aws.partnercentral-selling.ProjectView/ExpectedCustomerSpend
     :cognitect.aws.partnercentral-selling.ProjectView/OtherSolutionDescription
     :cognitect.aws.partnercentral-selling.ProjectView/SalesActivities]))

(s/def
  :cognitect.aws.partnercentral-selling/ReviewStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"In review" "Pending Submission" "Rejected" "Approved" "Action Required" "Submitted"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementScore
  (s/spec string? :gen #(s/gen #{"Medium" "High" "Low"})))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementInvitationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/Catalog
     :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/ParticipantType]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/Sort
     :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/Status
     :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/EngagementIdentifier
     :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/PayloadType
     :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/MaxResults
     :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/SenderAwsAccountId]))

(s/def
  :cognitect.aws.partnercentral-selling/ListResourceSnapshotsResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListResourceSnapshotsResponse/ResourceSnapshotSummaries]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListResourceSnapshotsResponse/NextToken]))

(s/def
  :cognitect.aws.partnercentral-selling/CreateEngagementRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.CreateEngagementRequest/Catalog
     :cognitect.aws.partnercentral-selling.CreateEngagementRequest/ClientToken
     :cognitect.aws.partnercentral-selling.CreateEngagementRequest/Description
     :cognitect.aws.partnercentral-selling.CreateEngagementRequest/Title]
    :opt-un
    [:cognitect.aws.partnercentral-selling.CreateEngagementRequest/Contexts]))

(s/def
  :cognitect.aws.partnercentral-selling/ClientToken
  (s/spec #(re-matches (re-pattern "^[!-~]{1,64}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/CatalogIdentifier
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementMembersResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListEngagementMembersResponse/EngagementMemberList]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementMembersResponse/NextToken]))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementsRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ListEngagementsRequest/Catalog]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ListEngagementsRequest/Sort
     :cognitect.aws.partnercentral-selling.ListEngagementsRequest/ExcludeCreatedBy
     :cognitect.aws.partnercentral-selling.ListEngagementsRequest/NextToken
     :cognitect.aws.partnercentral-selling.ListEngagementsRequest/CreatedBy
     :cognitect.aws.partnercentral-selling.ListEngagementsRequest/EngagementIdentifier
     :cognitect.aws.partnercentral-selling.ListEngagementsRequest/MaxResults]))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunityArn
  (s/spec #(re-matches (re-pattern "^arn:.*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/AwsOpportunityCustomer
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.AwsOpportunityCustomer/Contacts]))

(s/def
  :cognitect.aws.partnercentral-selling/SolutionIdentifier
  (s/spec #(re-matches (re-pattern "^S-[0-9]{1,19}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ContactLastNameString
  (s/spec
    (s/and string? #(<= 0 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/SolutionList
  (s/coll-of :cognitect.aws.partnercentral-selling/SolutionBase))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementResourceAssociationsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpend
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/Amount
     :cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/CurrencyCode
     :cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/Frequency
     :cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/TargetCompany]
    :opt-un
    [:cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/EstimationUrl]))

(s/def
  :cognitect.aws.partnercentral-selling/SolutionSortName
  (s/spec string? :gen #(s/gen #{"Category" "Status" "CreatedDate" "Name" "Identifier"})))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceArn
  (s/spec #(re-matches (re-pattern "^arn:.*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/GetEngagementRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetEngagementRequest/Catalog
     :cognitect.aws.partnercentral-selling.GetEngagementRequest/Identifier]))

(s/def
  :cognitect.aws.partnercentral-selling/StartEngagementByAcceptingInvitationTaskRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskRequest/Catalog
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskRequest/ClientToken
     :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskRequest/Identifier]
    :opt-un
    [:cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskRequest/Tags]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementSortName
  (s/spec string? :gen #(s/gen #{"CreatedDate"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementMember
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.EngagementMember/CompanyName
     :cognitect.aws.partnercentral-selling.EngagementMember/AccountId
     :cognitect.aws.partnercentral-selling.EngagementMember/WebsiteUrl]))

(s/def
  :cognitect.aws.partnercentral-selling/ParticipantType
  (s/spec string? :gen #(s/gen #{"RECEIVER" "SENDER"})))

(s/def
  :cognitect.aws.partnercentral-selling/SenderContact
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.SenderContact/Email]
    :opt-un
    [:cognitect.aws.partnercentral-selling.SenderContact/Phone
     :cognitect.aws.partnercentral-selling.SenderContact/LastName
     :cognitect.aws.partnercentral-selling.SenderContact/BusinessTitle
     :cognitect.aws.partnercentral-selling.SenderContact/FirstName]))

(s/def
  :cognitect.aws.partnercentral-selling/Alias
  (s/spec
    (s/and string? #(<= 0 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTasksRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier
  (s/spec #(re-matches (re-pattern "^job-[0-9a-z]{13}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementInvitationPayloadType
  (s/spec string? :gen #(s/gen #{"OpportunityInvitation"})))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementMembers
  (s/coll-of :cognitect.aws.partnercentral-selling/EngagementMember :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.partnercentral-selling/AwsOpportunityLifeCycleNextStepsString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.partnercentral-selling/AwsProductIdentifier string?)

(s/def
  :cognitect.aws.partnercentral-selling/AccountSummaryOtherIndustryString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/AwsMarketplaceOfferIdentifier
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws:aws-marketplace:[a-z]{1,2}-[a-z]*-\\d+:\\d{12}:AWSMarketplace/Offer/.*$")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.partnercentral-selling/DateTime inst?)

(s/def
  :cognitect.aws.partnercentral-selling/StartEngagementFromOpportunityTaskRequestClientTokenString
  (s/spec #(re-matches (re-pattern "^[!-~]{1,64}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/SolutionSort
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.SolutionSort/SortBy
     :cognitect.aws.partnercentral-selling.SolutionSort/SortOrder]))

(s/def
  :cognitect.aws.partnercentral-selling/ProfileNextStepsHistory
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.ProfileNextStepsHistory/Time
     :cognitect.aws.partnercentral-selling.ProfileNextStepsHistory/Value]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementCustomerProjectDetailsTargetCompletionDateString
  (s/spec
    #(re-matches (re-pattern "^[1-9][0-9]{3}-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobArn
  (s/spec #(re-matches (re-pattern "^arn:.*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/Channels
  (s/coll-of :cognitect.aws.partnercentral-selling/Channel))

(s/def
  :cognitect.aws.partnercentral-selling/AwsAccountIdOrAliasList
  (s/coll-of :cognitect.aws.partnercentral-selling/AwsAccount :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.partnercentral-selling/PrimaryNeedsFromAws
  (s/coll-of :cognitect.aws.partnercentral-selling/PrimaryNeedFromAws))

(s/def
  :cognitect.aws.partnercentral-selling/ListTagsForResourceResponse
  (s/keys :req-un [:cognitect.aws.partnercentral-selling.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunitySummaryView
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.OpportunitySummaryView/OpportunityType
     :cognitect.aws.partnercentral-selling.OpportunitySummaryView/Customer
     :cognitect.aws.partnercentral-selling.OpportunitySummaryView/OpportunityTeam
     :cognitect.aws.partnercentral-selling.OpportunitySummaryView/RelatedEntityIdentifiers
     :cognitect.aws.partnercentral-selling.OpportunitySummaryView/Project
     :cognitect.aws.partnercentral-selling.OpportunitySummaryView/Lifecycle
     :cognitect.aws.partnercentral-selling.OpportunitySummaryView/PrimaryNeedsFromAws]))

(s/def
  :cognitect.aws.partnercentral-selling/SolutionIdentifiers
  (s/coll-of :cognitect.aws.partnercentral-selling/SolutionIdentifier))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobStatus
  (s/spec string? :gen #(s/gen #{"Running" "Stopped"})))

(s/def
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendTargetCompanyString
  (s/spec
    (s/and string? #(<= 1 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/OpportunityInvitationPayload
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.OpportunityInvitationPayload/Customer
     :cognitect.aws.partnercentral-selling.OpportunityInvitationPayload/Project
     :cognitect.aws.partnercentral-selling.OpportunityInvitationPayload/ReceiverResponsibilities]
    :opt-un
    [:cognitect.aws.partnercentral-selling.OpportunityInvitationPayload/SenderContacts]))

(s/def
  :cognitect.aws.partnercentral-selling/CreateEngagementInvitationResponse
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.CreateEngagementInvitationResponse/Arn
     :cognitect.aws.partnercentral-selling.CreateEngagementInvitationResponse/Id]))

(s/def
  :cognitect.aws.partnercentral-selling/StartEngagementByAcceptingInvitationTaskRequestClientTokenString
  (s/spec #(re-matches (re-pattern "^[!-~]{1,64}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/LifeCycleSummaryNextStepsString
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceIdentifier
  (s/spec #(re-matches (re-pattern "^O[0-9]{1,19}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.partnercentral-selling/GetEngagementInvitationRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.GetEngagementInvitationRequest/Catalog
     :cognitect.aws.partnercentral-selling.GetEngagementInvitationRequest/Identifier]))

(s/def
  :cognitect.aws.partnercentral-selling/LifeCycleForView
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.LifeCycleForView/NextSteps
     :cognitect.aws.partnercentral-selling.LifeCycleForView/TargetCloseDate
     :cognitect.aws.partnercentral-selling.LifeCycleForView/ReviewStatus
     :cognitect.aws.partnercentral-selling.LifeCycleForView/Stage]))

(s/def
  :cognitect.aws.partnercentral-selling/InvitationStatusList
  (s/coll-of :cognitect.aws.partnercentral-selling/InvitationStatus :min-count 1 :max-count 10))

(s/def :cognitect.aws.partnercentral-selling/String string?)

(s/def
  :cognitect.aws.partnercentral-selling/Contact
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.Contact/Email
     :cognitect.aws.partnercentral-selling.Contact/Phone
     :cognitect.aws.partnercentral-selling.Contact/LastName
     :cognitect.aws.partnercentral-selling.Contact/BusinessTitle
     :cognitect.aws.partnercentral-selling.Contact/FirstName]))

(s/def
  :cognitect.aws.partnercentral-selling/DisassociateOpportunityRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.DisassociateOpportunityRequest/Catalog
     :cognitect.aws.partnercentral-selling.DisassociateOpportunityRequest/OpportunityIdentifier
     :cognitect.aws.partnercentral-selling.DisassociateOpportunityRequest/RelatedEntityIdentifier
     :cognitect.aws.partnercentral-selling.DisassociateOpportunityRequest/RelatedEntityType]))

(s/def
  :cognitect.aws.partnercentral-selling/GetEngagementResponse
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.GetEngagementResponse/Contexts
     :cognitect.aws.partnercentral-selling.GetEngagementResponse/MemberCount
     :cognitect.aws.partnercentral-selling.GetEngagementResponse/Title
     :cognitect.aws.partnercentral-selling.GetEngagementResponse/CreatedBy
     :cognitect.aws.partnercentral-selling.GetEngagementResponse/Description
     :cognitect.aws.partnercentral-selling.GetEngagementResponse/Arn
     :cognitect.aws.partnercentral-selling.GetEngagementResponse/CreatedAt
     :cognitect.aws.partnercentral-selling.GetEngagementResponse/Id]))

(s/def
  :cognitect.aws.partnercentral-selling/CreateOpportunityRequestClientTokenString
  (s/spec
    (s/and string? #(<= 1 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceNotFoundException
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.ResourceNotFoundException/Message]))

(s/def
  :cognitect.aws.partnercentral-selling/ConflictException
  (s/keys :opt-un [:cognitect.aws.partnercentral-selling.ConflictException/Message]))

(s/def
  :cognitect.aws.partnercentral-selling/ResourceSnapshotSummary
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/CreatedBy
     :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/ResourceId
     :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/Revision
     :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/ResourceType
     :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/Arn
     :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/ResourceSnapshotTemplateName]))

(s/def
  :cognitect.aws.partnercentral-selling/StopResourceSnapshotJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.StopResourceSnapshotJobRequest/Catalog
     :cognitect.aws.partnercentral-selling.StopResourceSnapshotJobRequest/ResourceSnapshotJobIdentifier]))

(s/def
  :cognitect.aws.partnercentral-selling/TagKeyList
  (s/coll-of :cognitect.aws.partnercentral-selling/TagKey :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.partnercentral-selling/Project
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.Project/DeliveryModels
     :cognitect.aws.partnercentral-selling.Project/CustomerUseCase
     :cognitect.aws.partnercentral-selling.Project/Title
     :cognitect.aws.partnercentral-selling.Project/ExpectedCustomerSpend
     :cognitect.aws.partnercentral-selling.Project/OtherSolutionDescription
     :cognitect.aws.partnercentral-selling.Project/RelatedOpportunityIdentifier
     :cognitect.aws.partnercentral-selling.Project/CustomerBusinessProblem
     :cognitect.aws.partnercentral-selling.Project/ApnPrograms
     :cognitect.aws.partnercentral-selling.Project/AdditionalComments
     :cognitect.aws.partnercentral-selling.Project/OtherCompetitorNames
     :cognitect.aws.partnercentral-selling.Project/CompetitorName
     :cognitect.aws.partnercentral-selling.Project/SalesActivities]))

(s/def
  :cognitect.aws.partnercentral-selling/EngagementCustomerBusinessProblem
  (s/spec
    (s/and string? #(<= 20 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 20 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.partnercentral-selling/CreateEngagementResponse
  (s/keys
    :opt-un
    [:cognitect.aws.partnercentral-selling.CreateEngagementResponse/Arn
     :cognitect.aws.partnercentral-selling.CreateEngagementResponse/Id]))

(s/def
  :cognitect.aws.partnercentral-selling/NextStepsHistory
  (s/keys
    :req-un
    [:cognitect.aws.partnercentral-selling.NextStepsHistory/Time
     :cognitect.aws.partnercentral-selling.NextStepsHistory/Value]))

(s/def
  :cognitect.aws.partnercentral-selling.ThrottlingException/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/CreatedBy
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/MaxResults
  :cognitect.aws.partnercentral-selling/ListResourceSnapshotsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/ResourceIdentifier
  :cognitect.aws.partnercentral-selling/ResourceIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/ResourceSnapshotTemplateIdentifier
  :cognitect.aws.partnercentral-selling/ResourceTemplateName)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsRequest/ResourceType
  :cognitect.aws.partnercentral-selling/ResourceType)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySort/SortBy
  :cognitect.aws.partnercentral-selling/OpportunitySortName)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySort/SortOrder
  :cognitect.aws.partnercentral-selling/SortOrder)

(s/def
  :cognitect.aws.partnercentral-selling.SoftwareRevenue/DeliveryModel
  :cognitect.aws.partnercentral-selling/RevenueModel)

(s/def
  :cognitect.aws.partnercentral-selling.SoftwareRevenue/EffectiveDate
  :cognitect.aws.partnercentral-selling/Date)

(s/def
  :cognitect.aws.partnercentral-selling.SoftwareRevenue/ExpirationDate
  :cognitect.aws.partnercentral-selling/Date)

(s/def
  :cognitect.aws.partnercentral-selling.SoftwareRevenue/Value
  :cognitect.aws.partnercentral-selling/MonetaryValue)

(s/def
  :cognitect.aws.partnercentral-selling.LastModifiedDate/AfterLastModifiedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.LastModifiedDate/BeforeLastModifiedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsResponse/EngagementResourceAssociationSummaries
  :cognitect.aws.partnercentral-selling/EngagementResourceAssociationSummaryList)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/CreatedBy
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/EngagementId
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/ResourceId
  :cognitect.aws.partnercentral-selling/ResourceIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementResourceAssociationSummary/ResourceType
  :cognitect.aws.partnercentral-selling/ResourceType)

(s/def
  :cognitect.aws.partnercentral-selling.TagResourceRequest/ResourceArn
  :cognitect.aws.partnercentral-selling/TaggableResourceArn)

(s/def
  :cognitect.aws.partnercentral-selling.TagResourceRequest/Tags
  :cognitect.aws.partnercentral-selling/TagList)

(s/def
  :cognitect.aws.partnercentral-selling.AssociateOpportunityRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.AssociateOpportunityRequest/OpportunityIdentifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.AssociateOpportunityRequest/RelatedEntityIdentifier
  :cognitect.aws.partnercentral-selling/AssociateOpportunityRequestRelatedEntityIdentifierString)

(s/def
  :cognitect.aws.partnercentral-selling.AssociateOpportunityRequest/RelatedEntityType
  :cognitect.aws.partnercentral-selling/RelatedEntityType)

(s/def
  :cognitect.aws.partnercentral-selling.ServiceQuotaExceededException/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.InternalServerException/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/ClientToken
  :cognitect.aws.partnercentral-selling/CreateResourceSnapshotJobRequestClientTokenString)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/ResourceIdentifier
  :cognitect.aws.partnercentral-selling/ResourceIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/ResourceSnapshotTemplateIdentifier
  :cognitect.aws.partnercentral-selling/ResourceTemplateName)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/ResourceType
  :cognitect.aws.partnercentral-selling/ResourceType)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobRequest/Tags
  :cognitect.aws.partnercentral-selling/TagList)

(s/def
  :cognitect.aws.partnercentral-selling.AccountSummary/Address
  :cognitect.aws.partnercentral-selling/AddressSummary)

(s/def
  :cognitect.aws.partnercentral-selling.AccountSummary/CompanyName
  :cognitect.aws.partnercentral-selling/AccountSummaryCompanyNameString)

(s/def
  :cognitect.aws.partnercentral-selling.AccountSummary/Industry
  :cognitect.aws.partnercentral-selling/Industry)

(s/def
  :cognitect.aws.partnercentral-selling.AccountSummary/OtherIndustry
  :cognitect.aws.partnercentral-selling/AccountSummaryOtherIndustryString)

(s/def
  :cognitect.aws.partnercentral-selling.AccountSummary/WebsiteUrl
  :cognitect.aws.partnercentral-selling/WebsiteUrl)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/ResourceType
  :cognitect.aws.partnercentral-selling/ResourceType)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/CreatedAt
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/EngagementId
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/ResourceSnapshotTemplateName
  :cognitect.aws.partnercentral-selling/ResourceTemplateName)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/Id
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/ResourceId
  :cognitect.aws.partnercentral-selling/ResourceIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/Arn
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobArn)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/LastSuccessfulExecutionDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/LastFailure
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/ResourceArn
  :cognitect.aws.partnercentral-selling/ResourceArn)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobResponse/Status
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobStatus)

(s/def
  :cognitect.aws.partnercentral-selling.PutSellingSystemSettingsResponse/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.PutSellingSystemSettingsResponse/ResourceSnapshotJobRoleArn
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobRoleArn)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementMemberSummary/CompanyName
  :cognitect.aws.partnercentral-selling/MemberCompanyName)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementMemberSummary/WebsiteUrl
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.SolutionBase/Arn
  :cognitect.aws.partnercentral-selling/SolutionArn)

(s/def
  :cognitect.aws.partnercentral-selling.SolutionBase/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.SolutionBase/Category
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.SolutionBase/CreatedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.SolutionBase/Id
  :cognitect.aws.partnercentral-selling/SolutionIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.SolutionBase/Name
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.SolutionBase/Status
  :cognitect.aws.partnercentral-selling/SolutionStatus)

(s/def :cognitect.aws.partnercentral-selling.Tag/Key :cognitect.aws.partnercentral-selling/TagKey)

(s/def
  :cognitect.aws.partnercentral-selling.Tag/Value
  :cognitect.aws.partnercentral-selling/TagValue)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityRelatedEntities/AwsProducts
  :cognitect.aws.partnercentral-selling/AwsProductIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityRelatedEntities/Solutions
  :cognitect.aws.partnercentral-selling/SolutionIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/SoftwareRevenue
  :cognitect.aws.partnercentral-selling/SoftwareRevenue)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/OpportunityTeam
  :cognitect.aws.partnercentral-selling/PartnerOpportunityTeamMembersList)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/OpportunityType
  :cognitect.aws.partnercentral-selling/OpportunityType)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/LifeCycle
  :cognitect.aws.partnercentral-selling/LifeCycle)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/NationalSecurity
  :cognitect.aws.partnercentral-selling/NationalSecurity)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Origin
  :cognitect.aws.partnercentral-selling/OpportunityOrigin)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Marketing
  :cognitect.aws.partnercentral-selling/Marketing)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/PartnerOpportunityIdentifier
  :cognitect.aws.partnercentral-selling/CreateOpportunityRequestPartnerOpportunityIdentifierString)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Customer
  :cognitect.aws.partnercentral-selling/Customer)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/ClientToken
  :cognitect.aws.partnercentral-selling/CreateOpportunityRequestClientTokenString)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/PrimaryNeedsFromAws
  :cognitect.aws.partnercentral-selling/PrimaryNeedsFromAws)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityRequest/Project
  :cognitect.aws.partnercentral-selling/Project)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementCustomer/CompanyName
  :cognitect.aws.partnercentral-selling/CompanyName)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementCustomer/CountryCode
  :cognitect.aws.partnercentral-selling/CountryCode)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementCustomer/Industry
  :cognitect.aws.partnercentral-selling/Industry)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementCustomer/WebsiteUrl
  :cognitect.aws.partnercentral-selling/CompanyWebsiteUrl)

(s/def
  :cognitect.aws.partnercentral-selling.Receiver/Account
  :cognitect.aws.partnercentral-selling/AccountReceiver)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesResponse/OpportunitySummaries
  :cognitect.aws.partnercentral-selling/OpportunitySummaries)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotJobRequest/ResourceSnapshotJobIdentifier
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.DeleteResourceSnapshotJobRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.DeleteResourceSnapshotJobRequest/ResourceSnapshotJobIdentifier
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartResourceSnapshotJobRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartResourceSnapshotJobRequest/ResourceSnapshotJobIdentifier
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.AccountReceiver/Alias
  :cognitect.aws.partnercentral-selling/Alias)

(s/def
  :cognitect.aws.partnercentral-selling.AccountReceiver/AwsAccountId
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.ListTasksSortBase/SortBy
  :cognitect.aws.partnercentral-selling/ListTasksSortName)

(s/def
  :cognitect.aws.partnercentral-selling.ListTasksSortBase/SortOrder
  :cognitect.aws.partnercentral-selling/SortOrder)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/EngagementInvitationIdentifier
  :cognitect.aws.partnercentral-selling/EngagementInvitationIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/MaxResults
  :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTasksRequestMaxResultsInteger)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/NextToken
  :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTasksRequestNextTokenString)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/OpportunityIdentifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/Sort
  :cognitect.aws.partnercentral-selling/ListTasksSortBase)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/TaskIdentifier
  :cognitect.aws.partnercentral-selling/TaskIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksRequest/TaskStatus
  :cognitect.aws.partnercentral-selling/TaskStatuses)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/MaxResults
  :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTasksRequestMaxResultsInteger)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/NextToken
  :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTasksRequestNextTokenString)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/OpportunityIdentifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/Sort
  :cognitect.aws.partnercentral-selling/ListTasksSortBase)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/TaskIdentifier
  :cognitect.aws.partnercentral-selling/TaskIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksRequest/TaskStatus
  :cognitect.aws.partnercentral-selling/TaskStatuses)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityRequest/Identifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementMembersRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementMembersRequest/Identifier
  :cognitect.aws.partnercentral-selling/EngagementArnOrIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementMembersRequest/MaxResults
  :cognitect.aws.partnercentral-selling/MemberPageSize)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementMembersRequest/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsResponse/ResourceSnapshotJobSummaries
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobSummaryList)

(s/def
  :cognitect.aws.partnercentral-selling.CustomerSummary/Account
  :cognitect.aws.partnercentral-selling/AccountSummary)

(s/def
  :cognitect.aws.partnercentral-selling.SortObject/SortBy
  :cognitect.aws.partnercentral-selling/SortBy)

(s/def
  :cognitect.aws.partnercentral-selling.SortObject/SortOrder
  :cognitect.aws.partnercentral-selling/SortOrder)

(s/def
  :cognitect.aws.partnercentral-selling.ValidationException/ErrorList
  :cognitect.aws.partnercentral-selling/ValidationExceptionErrorList)

(s/def
  :cognitect.aws.partnercentral-selling.ValidationException/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ValidationException/Reason
  :cognitect.aws.partnercentral-selling/ValidationExceptionReason)

(s/def
  :cognitect.aws.partnercentral-selling.Invitation/Message
  :cognitect.aws.partnercentral-selling/InvitationMessage)

(s/def
  :cognitect.aws.partnercentral-selling.Invitation/Payload
  :cognitect.aws.partnercentral-selling/Payload)

(s/def
  :cognitect.aws.partnercentral-selling.Invitation/Receiver
  :cognitect.aws.partnercentral-selling/Receiver)

(s/def
  :cognitect.aws.partnercentral-selling.AccessDeniedException/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.PutSellingSystemSettingsRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.PutSellingSystemSettingsRequest/ResourceSnapshotJobRoleIdentifier
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobRoleIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/LastModifiedDate
  :cognitect.aws.partnercentral-selling/LastModifiedDate)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/Sort
  :cognitect.aws.partnercentral-selling/OpportunitySort)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/CustomerCompanyName
  :cognitect.aws.partnercentral-selling/ListOpportunitiesRequestCustomerCompanyNameList)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/Identifier
  :cognitect.aws.partnercentral-selling/ListOpportunitiesRequestIdentifierList)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/LifeCycleReviewStatus
  :cognitect.aws.partnercentral-selling/ListOpportunitiesRequestLifeCycleReviewStatusList)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/MaxResults
  :cognitect.aws.partnercentral-selling/PageSize)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListOpportunitiesRequest/LifeCycleStage
  :cognitect.aws.partnercentral-selling/ListOpportunitiesRequestLifeCycleStageList)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/ResourceIdentifier
  :cognitect.aws.partnercentral-selling/ResourceIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/ResourceSnapshotTemplateIdentifier
  :cognitect.aws.partnercentral-selling/ResourceTemplateName)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/ResourceType
  :cognitect.aws.partnercentral-selling/ResourceType)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotRequest/Revision
  :cognitect.aws.partnercentral-selling/ResourceSnapshotRevision)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/SoftwareRevenue
  :cognitect.aws.partnercentral-selling/SoftwareRevenue)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/LastModifiedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/OpportunityType
  :cognitect.aws.partnercentral-selling/OpportunityType)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/LifeCycle
  :cognitect.aws.partnercentral-selling/LifeCycle)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/NationalSecurity
  :cognitect.aws.partnercentral-selling/NationalSecurity)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Marketing
  :cognitect.aws.partnercentral-selling/Marketing)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Identifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/PartnerOpportunityIdentifier
  :cognitect.aws.partnercentral-selling/UpdateOpportunityRequestPartnerOpportunityIdentifierString)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Customer
  :cognitect.aws.partnercentral-selling/Customer)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/PrimaryNeedsFromAws
  :cognitect.aws.partnercentral-selling/PrimaryNeedsFromAws)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityRequest/Project
  :cognitect.aws.partnercentral-selling/Project)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectSummary/DeliveryModels
  :cognitect.aws.partnercentral-selling/DeliveryModels)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectSummary/ExpectedCustomerSpend
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendList)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycle/ClosedLostReason
  :cognitect.aws.partnercentral-selling/ClosedLostReason)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycle/NextSteps
  :cognitect.aws.partnercentral-selling/LifeCycleNextStepsString)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycle/NextStepsHistory
  :cognitect.aws.partnercentral-selling/LifeCycleNextStepsHistoryList)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycle/ReviewComments
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycle/ReviewStatus
  :cognitect.aws.partnercentral-selling/ReviewStatus)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycle/ReviewStatusReason
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycle/Stage
  :cognitect.aws.partnercentral-selling/Stage)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycle/TargetCloseDate
  :cognitect.aws.partnercentral-selling/Date)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryRequest/RelatedOpportunityIdentifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.AwsSubmission/InvolvementType
  :cognitect.aws.partnercentral-selling/SalesInvolvementType)

(s/def
  :cognitect.aws.partnercentral-selling.AwsSubmission/Visibility
  :cognitect.aws.partnercentral-selling/Visibility)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsResponse/EngagementInvitationSummaries
  :cognitect.aws.partnercentral-selling/EngagementInvitationSummaries)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.GetSellingSystemSettingsRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/CreatedBy
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/MaxResults
  :cognitect.aws.partnercentral-selling/ListEngagementResourceAssociationsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/ResourceIdentifier
  :cognitect.aws.partnercentral-selling/ResourceIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementResourceAssociationsRequest/ResourceType
  :cognitect.aws.partnercentral-selling/ResourceType)

(s/def
  :cognitect.aws.partnercentral-selling.RelatedEntityIdentifiers/AwsMarketplaceOffers
  :cognitect.aws.partnercentral-selling/AwsMarketplaceOfferIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.RelatedEntityIdentifiers/AwsProducts
  :cognitect.aws.partnercentral-selling/AwsProductIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.RelatedEntityIdentifiers/Solutions
  :cognitect.aws.partnercentral-selling/SolutionIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/MaxResults
  :cognitect.aws.partnercentral-selling/ListResourceSnapshotJobsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/Sort
  :cognitect.aws.partnercentral-selling/SortObject)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotJobsRequest/Status
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobStatus)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/AwsSubmission
  :cognitect.aws.partnercentral-selling/AwsSubmission)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/ClientToken
  :cognitect.aws.partnercentral-selling/StartEngagementFromOpportunityTaskRequestClientTokenString)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/Identifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskRequest/Tags
  :cognitect.aws.partnercentral-selling/TagList)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementSort/SortBy
  :cognitect.aws.partnercentral-selling/EngagementSortName)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementSort/SortOrder
  :cognitect.aws.partnercentral-selling/SortOrder)

(s/def
  :cognitect.aws.partnercentral-selling.AcceptEngagementInvitationRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.AcceptEngagementInvitationRequest/Identifier
  :cognitect.aws.partnercentral-selling/EngagementInvitationArnOrIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CustomerProjectsContext/Customer
  :cognitect.aws.partnercentral-selling/EngagementCustomer)

(s/def
  :cognitect.aws.partnercentral-selling.CustomerProjectsContext/Project
  :cognitect.aws.partnercentral-selling/EngagementCustomerProjectDetails)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/SoftwareRevenue
  :cognitect.aws.partnercentral-selling/SoftwareRevenue)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/LastModifiedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/OpportunityTeam
  :cognitect.aws.partnercentral-selling/PartnerOpportunityTeamMembersList)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/OpportunityType
  :cognitect.aws.partnercentral-selling/OpportunityType)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Id
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/LifeCycle
  :cognitect.aws.partnercentral-selling/LifeCycle)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/NationalSecurity
  :cognitect.aws.partnercentral-selling/NationalSecurity)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/CreatedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/RelatedEntityIdentifiers
  :cognitect.aws.partnercentral-selling/RelatedEntityIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Marketing
  :cognitect.aws.partnercentral-selling/Marketing)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/PartnerOpportunityIdentifier
  :cognitect.aws.partnercentral-selling/GetOpportunityResponsePartnerOpportunityIdentifierString)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Customer
  :cognitect.aws.partnercentral-selling/Customer)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Arn
  :cognitect.aws.partnercentral-selling/OpportunityArn)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/PrimaryNeedsFromAws
  :cognitect.aws.partnercentral-selling/PrimaryNeedsFromAws)

(s/def
  :cognitect.aws.partnercentral-selling.GetOpportunityResponse/Project
  :cognitect.aws.partnercentral-selling/Project)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotPayload/OpportunitySummary
  :cognitect.aws.partnercentral-selling/OpportunitySummaryView)

(s/def
  :cognitect.aws.partnercentral-selling.Marketing/AwsFundingUsed
  :cognitect.aws.partnercentral-selling/AwsFundingUsed)

(s/def
  :cognitect.aws.partnercentral-selling.Marketing/CampaignName
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.Marketing/Channels
  :cognitect.aws.partnercentral-selling/Channels)

(s/def
  :cognitect.aws.partnercentral-selling.Marketing/Source
  :cognitect.aws.partnercentral-selling/MarketingSource)

(s/def
  :cognitect.aws.partnercentral-selling.Marketing/UseCases
  :cognitect.aws.partnercentral-selling/UseCases)

(s/def
  :cognitect.aws.partnercentral-selling.AssigneeContact/BusinessTitle
  :cognitect.aws.partnercentral-selling/JobTitle)

(s/def
  :cognitect.aws.partnercentral-selling.AssigneeContact/Email
  :cognitect.aws.partnercentral-selling/Email)

(s/def
  :cognitect.aws.partnercentral-selling.AssigneeContact/FirstName
  :cognitect.aws.partnercentral-selling/AssigneeContactFirstNameString)

(s/def
  :cognitect.aws.partnercentral-selling.AssigneeContact/LastName
  :cognitect.aws.partnercentral-selling/AssigneeContactLastNameString)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectDetails/BusinessProblem
  :cognitect.aws.partnercentral-selling/EngagementCustomerBusinessProblem)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectDetails/ExpectedCustomerSpend
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendList)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectDetails/TargetCompletionDate
  :cognitect.aws.partnercentral-selling/Date)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectDetails/Title
  :cognitect.aws.partnercentral-selling/ProjectDetailsTitleString)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotResponse/Arn
  :cognitect.aws.partnercentral-selling/ResourceArn)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotResponse/Revision
  :cognitect.aws.partnercentral-selling/ResourceSnapshotRevision)

(s/def
  :cognitect.aws.partnercentral-selling.Payload/OpportunityInvitation
  :cognitect.aws.partnercentral-selling/OpportunityInvitationPayload)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/LastModifiedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/OpportunityType
  :cognitect.aws.partnercentral-selling/OpportunityType)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/Id
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/LifeCycle
  :cognitect.aws.partnercentral-selling/LifeCycleSummary)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/CreatedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/PartnerOpportunityIdentifier
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/Customer
  :cognitect.aws.partnercentral-selling/CustomerSummary)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/Arn
  :cognitect.aws.partnercentral-selling/OpportunityArn)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummary/Project
  :cognitect.aws.partnercentral-selling/ProjectSummary)

(s/def
  :cognitect.aws.partnercentral-selling.MonetaryValue/Amount
  :cognitect.aws.partnercentral-selling/MonetaryValueAmountString)

(s/def
  :cognitect.aws.partnercentral-selling.MonetaryValue/CurrencyCode
  :cognitect.aws.partnercentral-selling/CurrencyCode)

(s/def
  :cognitect.aws.partnercentral-selling.Address/City
  :cognitect.aws.partnercentral-selling/AddressCityString)

(s/def
  :cognitect.aws.partnercentral-selling.Address/CountryCode
  :cognitect.aws.partnercentral-selling/CountryCode)

(s/def
  :cognitect.aws.partnercentral-selling.Address/PostalCode
  :cognitect.aws.partnercentral-selling/AddressPostalCodeString)

(s/def
  :cognitect.aws.partnercentral-selling.Address/StateOrRegion
  :cognitect.aws.partnercentral-selling/AddressPart)

(s/def
  :cognitect.aws.partnercentral-selling.Address/StreetAddress
  :cognitect.aws.partnercentral-selling/AddressStreetAddressString)

(s/def
  :cognitect.aws.partnercentral-selling.GetSellingSystemSettingsResponse/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetSellingSystemSettingsResponse/ResourceSnapshotJobRoleArn
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobRoleArn)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/TaskId
  :cognitect.aws.partnercentral-selling/TaskIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/EngagementId
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/OpportunityId
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/TaskArn
  :cognitect.aws.partnercentral-selling/TaskArn)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/TaskStatus
  :cognitect.aws.partnercentral-selling/TaskStatus)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/ResourceSnapshotJobId
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/ReasonCode
  :cognitect.aws.partnercentral-selling/ReasonCode)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/StartTime
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementFromOpportunityTaskResponse/EngagementInvitationId
  :cognitect.aws.partnercentral-selling/EngagementInvitationIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementContextDetails/Payload
  :cognitect.aws.partnercentral-selling/EngagementContextPayload)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementContextDetails/Type
  :cognitect.aws.partnercentral-selling/EngagementContextType)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/ResourceType
  :cognitect.aws.partnercentral-selling/ResourceType)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/CreatedAt
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/EngagementId
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/Revision
  :cognitect.aws.partnercentral-selling/ResourceSnapshotRevision)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/ResourceSnapshotTemplateName
  :cognitect.aws.partnercentral-selling/ResourceTemplateName)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/ResourceId
  :cognitect.aws.partnercentral-selling/ResourceIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/Payload
  :cognitect.aws.partnercentral-selling/ResourceSnapshotPayload)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/CreatedBy
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/Arn
  :cognitect.aws.partnercentral-selling/ResourceArn)

(s/def
  :cognitect.aws.partnercentral-selling.GetResourceSnapshotResponse/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListSolutionsRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListSolutionsRequest/Category
  :cognitect.aws.partnercentral-selling/ListSolutionsRequestCategoryList)

(s/def
  :cognitect.aws.partnercentral-selling.ListSolutionsRequest/Identifier
  :cognitect.aws.partnercentral-selling/ListSolutionsRequestIdentifierList)

(s/def
  :cognitect.aws.partnercentral-selling.ListSolutionsRequest/MaxResults
  :cognitect.aws.partnercentral-selling/PageSize)

(s/def
  :cognitect.aws.partnercentral-selling.ListSolutionsRequest/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListSolutionsRequest/Sort
  :cognitect.aws.partnercentral-selling/SolutionSort)

(s/def
  :cognitect.aws.partnercentral-selling.ListSolutionsRequest/Status
  :cognitect.aws.partnercentral-selling/ListSolutionsRequestStatusList)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/ClientToken
  :cognitect.aws.partnercentral-selling/CreateResourceSnapshotRequestClientTokenString)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/ResourceIdentifier
  :cognitect.aws.partnercentral-selling/ResourceIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/ResourceSnapshotTemplateIdentifier
  :cognitect.aws.partnercentral-selling/ResourceTemplateName)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotRequest/ResourceType
  :cognitect.aws.partnercentral-selling/ResourceType)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityResponse/Id
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityResponse/LastModifiedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.CreateOpportunityResponse/PartnerOpportunityIdentifier
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.RejectEngagementInvitationRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.RejectEngagementInvitationRequest/Identifier
  :cognitect.aws.partnercentral-selling/EngagementInvitationArnOrIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.RejectEngagementInvitationRequest/RejectionReason
  :cognitect.aws.partnercentral-selling/RejectionReasonString)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/EngagementId
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/SenderCompanyName
  :cognitect.aws.partnercentral-selling/EngagementInvitationSummarySenderCompanyNameString)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Receiver
  :cognitect.aws.partnercentral-selling/Receiver)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Id
  :cognitect.aws.partnercentral-selling/EngagementInvitationArnOrIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/ExpirationDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/PayloadType
  :cognitect.aws.partnercentral-selling/EngagementInvitationPayloadType)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/EngagementTitle
  :cognitect.aws.partnercentral-selling/EngagementTitle)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Arn
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/ParticipantType
  :cognitect.aws.partnercentral-selling/ParticipantType)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/SenderAwsAccountId
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/Status
  :cognitect.aws.partnercentral-selling/InvitationStatus)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementInvitationSummary/InvitationDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunityEngagementInvitationSort/SortBy
  :cognitect.aws.partnercentral-selling/OpportunityEngagementInvitationSortName)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunityEngagementInvitationSort/SortOrder
  :cognitect.aws.partnercentral-selling/SortOrder)

(s/def
  :cognitect.aws.partnercentral-selling.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.partnercentral-selling/TaggableResourceArn)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementInvitationRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementInvitationRequest/ClientToken
  :cognitect.aws.partnercentral-selling/ClientToken)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementInvitationRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementInvitationRequest/Invitation
  :cognitect.aws.partnercentral-selling/Invitation)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleSummary/ClosedLostReason
  :cognitect.aws.partnercentral-selling/ClosedLostReason)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleSummary/NextSteps
  :cognitect.aws.partnercentral-selling/LifeCycleSummaryNextStepsString)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleSummary/ReviewComments
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleSummary/ReviewStatus
  :cognitect.aws.partnercentral-selling/ReviewStatus)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleSummary/ReviewStatusReason
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleSummary/Stage
  :cognitect.aws.partnercentral-selling/Stage)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleSummary/TargetCloseDate
  :cognitect.aws.partnercentral-selling/Date)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/ClosedLostReason
  :cognitect.aws.partnercentral-selling/AwsClosedLostReason)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/NextSteps
  :cognitect.aws.partnercentral-selling/AwsOpportunityLifeCycleNextStepsString)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/NextStepsHistory
  :cognitect.aws.partnercentral-selling/AwsOpportunityLifeCycleNextStepsHistoryList)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/Stage
  :cognitect.aws.partnercentral-selling/AwsOpportunityStage)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityLifeCycle/TargetCloseDate
  :cognitect.aws.partnercentral-selling/Date)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTasksResponse/TaskSummaries
  :cognitect.aws.partnercentral-selling/ListEngagementFromOpportunityTaskSummaries)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementSummary/Arn
  :cognitect.aws.partnercentral-selling/EngagementArn)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementSummary/CreatedAt
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementSummary/CreatedBy
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementSummary/Id
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementSummary/MemberCount
  :cognitect.aws.partnercentral-selling/Integer)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementSummary/Title
  :cognitect.aws.partnercentral-selling/EngagementTitle)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityProject/ExpectedCustomerSpend
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendList)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementsResponse/EngagementSummaryList
  :cognitect.aws.partnercentral-selling/EngagementSummaryList)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementsResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.Customer/Account
  :cognitect.aws.partnercentral-selling/Account)

(s/def
  :cognitect.aws.partnercentral-selling.Customer/Contacts
  :cognitect.aws.partnercentral-selling/CustomerContactsList)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/TaskId
  :cognitect.aws.partnercentral-selling/TaskIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/EngagementId
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/OpportunityId
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/TaskArn
  :cognitect.aws.partnercentral-selling/TaskArn)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/TaskStatus
  :cognitect.aws.partnercentral-selling/TaskStatus)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/ResourceSnapshotJobId
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/ReasonCode
  :cognitect.aws.partnercentral-selling/ReasonCode)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/StartTime
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementFromOpportunityTaskSummary/EngagementInvitationId
  :cognitect.aws.partnercentral-selling/EngagementInvitationIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTasksResponse/TaskSummaries
  :cognitect.aws.partnercentral-selling/ListEngagementByAcceptingInvitationTaskSummaries)

(s/def
  :cognitect.aws.partnercentral-selling.ListSolutionsResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListSolutionsResponse/SolutionSummaries
  :cognitect.aws.partnercentral-selling/SolutionList)

(s/def
  :cognitect.aws.partnercentral-selling.AwsTeamMember/BusinessTitle
  :cognitect.aws.partnercentral-selling/AwsMemberBusinessTitle)

(s/def
  :cognitect.aws.partnercentral-selling.AwsTeamMember/Email
  :cognitect.aws.partnercentral-selling/Email)

(s/def
  :cognitect.aws.partnercentral-selling.AwsTeamMember/FirstName
  :cognitect.aws.partnercentral-selling/AwsTeamMemberFirstNameString)

(s/def
  :cognitect.aws.partnercentral-selling.AwsTeamMember/LastName
  :cognitect.aws.partnercentral-selling/AwsTeamMemberLastNameString)

(s/def
  :cognitect.aws.partnercentral-selling.AssignOpportunityRequest/Assignee
  :cognitect.aws.partnercentral-selling/AssigneeContact)

(s/def
  :cognitect.aws.partnercentral-selling.AssignOpportunityRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.AssignOpportunityRequest/Identifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotJobSummary/Arn
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobArn)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotJobSummary/EngagementId
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotJobSummary/Id
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotJobSummary/Status
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobStatus)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/TaskId
  :cognitect.aws.partnercentral-selling/TaskIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/OpportunityId
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/TaskArn
  :cognitect.aws.partnercentral-selling/TaskArn)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/TaskStatus
  :cognitect.aws.partnercentral-selling/TaskStatus)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/ResourceSnapshotJobId
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/ReasonCode
  :cognitect.aws.partnercentral-selling/ReasonCode)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/StartTime
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementByAcceptingInvitationTaskSummary/EngagementInvitationId
  :cognitect.aws.partnercentral-selling/EngagementInvitationIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/InvitationMessage
  :cognitect.aws.partnercentral-selling/InvitationMessage)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/EngagementId
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/SenderCompanyName
  :cognitect.aws.partnercentral-selling/GetEngagementInvitationResponseSenderCompanyNameString)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Receiver
  :cognitect.aws.partnercentral-selling/Receiver)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Id
  :cognitect.aws.partnercentral-selling/EngagementInvitationArnOrIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/ExpirationDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/PayloadType
  :cognitect.aws.partnercentral-selling/EngagementInvitationPayloadType)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Payload
  :cognitect.aws.partnercentral-selling/Payload)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/EngagementTitle
  :cognitect.aws.partnercentral-selling/EngagementTitle)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/EngagementDescription
  :cognitect.aws.partnercentral-selling/EngagementDescription)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Arn
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/RejectionReason
  :cognitect.aws.partnercentral-selling/RejectionReasonString)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/ExistingMembers
  :cognitect.aws.partnercentral-selling/EngagementMemberSummaries)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/SenderAwsAccountId
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/Status
  :cognitect.aws.partnercentral-selling/InvitationStatus)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationResponse/InvitationDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.Account/Address
  :cognitect.aws.partnercentral-selling/Address)

(s/def
  :cognitect.aws.partnercentral-selling.Account/AwsAccountId
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.Account/CompanyName
  :cognitect.aws.partnercentral-selling/AccountCompanyNameString)

(s/def
  :cognitect.aws.partnercentral-selling.Account/Duns
  :cognitect.aws.partnercentral-selling/DunsNumber)

(s/def
  :cognitect.aws.partnercentral-selling.Account/Industry
  :cognitect.aws.partnercentral-selling/Industry)

(s/def
  :cognitect.aws.partnercentral-selling.Account/OtherIndustry
  :cognitect.aws.partnercentral-selling/AccountOtherIndustryString)

(s/def
  :cognitect.aws.partnercentral-selling.Account/WebsiteUrl
  :cognitect.aws.partnercentral-selling/WebsiteUrl)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityResponse/Id
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.UpdateOpportunityResponse/LastModifiedDate
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobResponse/Arn
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobArn)

(s/def
  :cognitect.aws.partnercentral-selling.CreateResourceSnapshotJobResponse/Id
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.AddressSummary/City
  :cognitect.aws.partnercentral-selling/AddressSummaryCityString)

(s/def
  :cognitect.aws.partnercentral-selling.AddressSummary/CountryCode
  :cognitect.aws.partnercentral-selling/CountryCode)

(s/def
  :cognitect.aws.partnercentral-selling.AddressSummary/PostalCode
  :cognitect.aws.partnercentral-selling/AddressSummaryPostalCodeString)

(s/def
  :cognitect.aws.partnercentral-selling.AddressSummary/StateOrRegion
  :cognitect.aws.partnercentral-selling/AddressPart)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementContextPayload/CustomerProject
  :cognitect.aws.partnercentral-selling/CustomerProjectsContext)

(s/def
  :cognitect.aws.partnercentral-selling.SubmitOpportunityRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.SubmitOpportunityRequest/Identifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.SubmitOpportunityRequest/InvolvementType
  :cognitect.aws.partnercentral-selling/SalesInvolvementType)

(s/def
  :cognitect.aws.partnercentral-selling.SubmitOpportunityRequest/Visibility
  :cognitect.aws.partnercentral-selling/Visibility)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/TaskId
  :cognitect.aws.partnercentral-selling/TaskIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/OpportunityId
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/TaskArn
  :cognitect.aws.partnercentral-selling/TaskArn)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/TaskStatus
  :cognitect.aws.partnercentral-selling/TaskStatus)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/ResourceSnapshotJobId
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/ReasonCode
  :cognitect.aws.partnercentral-selling/ReasonCode)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/StartTime
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskResponse/EngagementInvitationId
  :cognitect.aws.partnercentral-selling/EngagementInvitationIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ValidationExceptionError/Code
  :cognitect.aws.partnercentral-selling/ValidationExceptionErrorCode)

(s/def
  :cognitect.aws.partnercentral-selling.ValidationExceptionError/FieldName
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ValidationExceptionError/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityInsights/EngagementScore
  :cognitect.aws.partnercentral-selling/EngagementScore)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityInsights/NextBestActions
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementCustomerProjectDetails/BusinessProblem
  :cognitect.aws.partnercentral-selling/EngagementCustomerBusinessProblem)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementCustomerProjectDetails/TargetCompletionDate
  :cognitect.aws.partnercentral-selling/EngagementCustomerProjectDetailsTargetCompletionDateString)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementCustomerProjectDetails/Title
  :cognitect.aws.partnercentral-selling/EngagementCustomerProjectTitle)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/OpportunityTeam
  :cognitect.aws.partnercentral-selling/AwsOpportunityTeamMembersList)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Insights
  :cognitect.aws.partnercentral-selling/AwsOpportunityInsights)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Visibility
  :cognitect.aws.partnercentral-selling/Visibility)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/LifeCycle
  :cognitect.aws.partnercentral-selling/AwsOpportunityLifeCycle)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/RelatedEntityIds
  :cognitect.aws.partnercentral-selling/AwsOpportunityRelatedEntities)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Origin
  :cognitect.aws.partnercentral-selling/OpportunityOrigin)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/InvolvementTypeChangeReason
  :cognitect.aws.partnercentral-selling/InvolvementTypeChangeReason)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Customer
  :cognitect.aws.partnercentral-selling/AwsOpportunityCustomer)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/InvolvementType
  :cognitect.aws.partnercentral-selling/SalesInvolvementType)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/RelatedOpportunityId
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetAwsOpportunitySummaryResponse/Project
  :cognitect.aws.partnercentral-selling/AwsOpportunityProject)

(s/def
  :cognitect.aws.partnercentral-selling.UntagResourceRequest/ResourceArn
  :cognitect.aws.partnercentral-selling/TaggableResourceArn)

(s/def
  :cognitect.aws.partnercentral-selling.UntagResourceRequest/TagKeys
  :cognitect.aws.partnercentral-selling/TagKeyList)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectView/CustomerUseCase
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectView/DeliveryModels
  :cognitect.aws.partnercentral-selling/DeliveryModels)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectView/ExpectedCustomerSpend
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendList)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectView/OtherSolutionDescription
  :cognitect.aws.partnercentral-selling/ProjectViewOtherSolutionDescriptionString)

(s/def
  :cognitect.aws.partnercentral-selling.ProjectView/SalesActivities
  :cognitect.aws.partnercentral-selling/SalesActivities)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/Sort
  :cognitect.aws.partnercentral-selling/OpportunityEngagementInvitationSort)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/PayloadType
  :cognitect.aws.partnercentral-selling/EngagementInvitationsPayloadType)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/MaxResults
  :cognitect.aws.partnercentral-selling/PageSize)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/ParticipantType
  :cognitect.aws.partnercentral-selling/ParticipantType)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/SenderAwsAccountId
  :cognitect.aws.partnercentral-selling/AwsAccountIdOrAliasList)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementInvitationsRequest/Status
  :cognitect.aws.partnercentral-selling/InvitationStatusList)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListResourceSnapshotsResponse/ResourceSnapshotSummaries
  :cognitect.aws.partnercentral-selling/ResourceSnapshotSummaryList)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementRequest/ClientToken
  :cognitect.aws.partnercentral-selling/CreateEngagementRequestClientTokenString)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementRequest/Contexts
  :cognitect.aws.partnercentral-selling/EngagementContexts)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementRequest/Description
  :cognitect.aws.partnercentral-selling/EngagementDescription)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementRequest/Title
  :cognitect.aws.partnercentral-selling/EngagementTitle)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementMembersResponse/EngagementMemberList
  :cognitect.aws.partnercentral-selling/EngagementMembers)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementMembersResponse/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementsRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementsRequest/CreatedBy
  :cognitect.aws.partnercentral-selling/AwsAccountList)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementsRequest/EngagementIdentifier
  :cognitect.aws.partnercentral-selling/EngagementIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementsRequest/ExcludeCreatedBy
  :cognitect.aws.partnercentral-selling/AwsAccountList)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementsRequest/MaxResults
  :cognitect.aws.partnercentral-selling/EngagementPageSize)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementsRequest/NextToken
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListEngagementsRequest/Sort
  :cognitect.aws.partnercentral-selling/EngagementSort)

(s/def
  :cognitect.aws.partnercentral-selling.AwsOpportunityCustomer/Contacts
  :cognitect.aws.partnercentral-selling/CustomerContactsList)

(s/def
  :cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/Amount
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/CurrencyCode
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendCurrencyCodeEnum)

(s/def
  :cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/EstimationUrl
  :cognitect.aws.partnercentral-selling/WebsiteUrl)

(s/def
  :cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/Frequency
  :cognitect.aws.partnercentral-selling/PaymentFrequency)

(s/def
  :cognitect.aws.partnercentral-selling.ExpectedCustomerSpend/TargetCompany
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendTargetCompanyString)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementRequest/Identifier
  :cognitect.aws.partnercentral-selling/EngagementArnOrIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskRequest/ClientToken
  :cognitect.aws.partnercentral-selling/StartEngagementByAcceptingInvitationTaskRequestClientTokenString)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskRequest/Identifier
  :cognitect.aws.partnercentral-selling/EngagementInvitationArnOrIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StartEngagementByAcceptingInvitationTaskRequest/Tags
  :cognitect.aws.partnercentral-selling/TagList)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementMember/AccountId
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementMember/CompanyName
  :cognitect.aws.partnercentral-selling/MemberCompanyName)

(s/def
  :cognitect.aws.partnercentral-selling.EngagementMember/WebsiteUrl
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.SenderContact/BusinessTitle
  :cognitect.aws.partnercentral-selling/JobTitle)

(s/def
  :cognitect.aws.partnercentral-selling.SenderContact/Email
  :cognitect.aws.partnercentral-selling/SenderContactEmail)

(s/def
  :cognitect.aws.partnercentral-selling.SenderContact/FirstName
  :cognitect.aws.partnercentral-selling/Name)

(s/def
  :cognitect.aws.partnercentral-selling.SenderContact/LastName
  :cognitect.aws.partnercentral-selling/Name)

(s/def
  :cognitect.aws.partnercentral-selling.SenderContact/Phone
  :cognitect.aws.partnercentral-selling/PhoneNumber)

(s/def
  :cognitect.aws.partnercentral-selling.SolutionSort/SortBy
  :cognitect.aws.partnercentral-selling/SolutionSortName)

(s/def
  :cognitect.aws.partnercentral-selling.SolutionSort/SortOrder
  :cognitect.aws.partnercentral-selling/SortOrder)

(s/def
  :cognitect.aws.partnercentral-selling.ProfileNextStepsHistory/Time
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.ProfileNextStepsHistory/Value
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ListTagsForResourceResponse/Tags
  :cognitect.aws.partnercentral-selling/TagList)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummaryView/Customer
  :cognitect.aws.partnercentral-selling/Customer)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummaryView/Lifecycle
  :cognitect.aws.partnercentral-selling/LifeCycleForView)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummaryView/OpportunityTeam
  :cognitect.aws.partnercentral-selling/PartnerOpportunityTeamMembersList)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummaryView/OpportunityType
  :cognitect.aws.partnercentral-selling/OpportunityType)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummaryView/PrimaryNeedsFromAws
  :cognitect.aws.partnercentral-selling/PrimaryNeedsFromAws)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummaryView/Project
  :cognitect.aws.partnercentral-selling/ProjectView)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunitySummaryView/RelatedEntityIdentifiers
  :cognitect.aws.partnercentral-selling/RelatedEntityIdentifiers)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunityInvitationPayload/Customer
  :cognitect.aws.partnercentral-selling/EngagementCustomer)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunityInvitationPayload/Project
  :cognitect.aws.partnercentral-selling/ProjectDetails)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunityInvitationPayload/ReceiverResponsibilities
  :cognitect.aws.partnercentral-selling/ReceiverResponsibilityList)

(s/def
  :cognitect.aws.partnercentral-selling.OpportunityInvitationPayload/SenderContacts
  :cognitect.aws.partnercentral-selling/SenderContactList)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementInvitationResponse/Arn
  :cognitect.aws.partnercentral-selling/EngagementInvitationArn)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementInvitationResponse/Id
  :cognitect.aws.partnercentral-selling/EngagementInvitationIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementInvitationRequest/Identifier
  :cognitect.aws.partnercentral-selling/EngagementInvitationArnOrIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleForView/NextSteps
  :cognitect.aws.partnercentral-selling/LifeCycleForViewNextStepsString)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleForView/ReviewStatus
  :cognitect.aws.partnercentral-selling/ReviewStatus)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleForView/Stage
  :cognitect.aws.partnercentral-selling/Stage)

(s/def
  :cognitect.aws.partnercentral-selling.LifeCycleForView/TargetCloseDate
  :cognitect.aws.partnercentral-selling/Date)

(s/def
  :cognitect.aws.partnercentral-selling.Contact/BusinessTitle
  :cognitect.aws.partnercentral-selling/JobTitle)

(s/def
  :cognitect.aws.partnercentral-selling.Contact/Email
  :cognitect.aws.partnercentral-selling/Email)

(s/def
  :cognitect.aws.partnercentral-selling.Contact/FirstName
  :cognitect.aws.partnercentral-selling/ContactFirstNameString)

(s/def
  :cognitect.aws.partnercentral-selling.Contact/LastName
  :cognitect.aws.partnercentral-selling/ContactLastNameString)

(s/def
  :cognitect.aws.partnercentral-selling.Contact/Phone
  :cognitect.aws.partnercentral-selling/PhoneNumber)

(s/def
  :cognitect.aws.partnercentral-selling.DisassociateOpportunityRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.DisassociateOpportunityRequest/OpportunityIdentifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.DisassociateOpportunityRequest/RelatedEntityIdentifier
  :cognitect.aws.partnercentral-selling/DisassociateOpportunityRequestRelatedEntityIdentifierString)

(s/def
  :cognitect.aws.partnercentral-selling.DisassociateOpportunityRequest/RelatedEntityType
  :cognitect.aws.partnercentral-selling/RelatedEntityType)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementResponse/Arn
  :cognitect.aws.partnercentral-selling/EngagementArn)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementResponse/Contexts
  :cognitect.aws.partnercentral-selling/EngagementContexts)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementResponse/CreatedAt
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementResponse/CreatedBy
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementResponse/Description
  :cognitect.aws.partnercentral-selling/EngagementDescription)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementResponse/Id
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementResponse/MemberCount
  :cognitect.aws.partnercentral-selling/Integer)

(s/def
  :cognitect.aws.partnercentral-selling.GetEngagementResponse/Title
  :cognitect.aws.partnercentral-selling/EngagementTitle)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceNotFoundException/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ConflictException/Message
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/Arn
  :cognitect.aws.partnercentral-selling/ResourceSnapshotArn)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/CreatedBy
  :cognitect.aws.partnercentral-selling/AwsAccount)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/ResourceId
  :cognitect.aws.partnercentral-selling/ResourceIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/ResourceSnapshotTemplateName
  :cognitect.aws.partnercentral-selling/ResourceTemplateName)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/ResourceType
  :cognitect.aws.partnercentral-selling/ResourceType)

(s/def
  :cognitect.aws.partnercentral-selling.ResourceSnapshotSummary/Revision
  :cognitect.aws.partnercentral-selling/ResourceSnapshotRevision)

(s/def
  :cognitect.aws.partnercentral-selling.StopResourceSnapshotJobRequest/Catalog
  :cognitect.aws.partnercentral-selling/CatalogIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.StopResourceSnapshotJobRequest/ResourceSnapshotJobIdentifier
  :cognitect.aws.partnercentral-selling/ResourceSnapshotJobIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.Project/OtherSolutionDescription
  :cognitect.aws.partnercentral-selling/ProjectOtherSolutionDescriptionString)

(s/def
  :cognitect.aws.partnercentral-selling.Project/RelatedOpportunityIdentifier
  :cognitect.aws.partnercentral-selling/OpportunityIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.Project/CustomerUseCase
  :cognitect.aws.partnercentral-selling/String)

(s/def
  :cognitect.aws.partnercentral-selling.Project/Title
  :cognitect.aws.partnercentral-selling/ProjectTitleString)

(s/def
  :cognitect.aws.partnercentral-selling.Project/OtherCompetitorNames
  :cognitect.aws.partnercentral-selling/ProjectOtherCompetitorNamesString)

(s/def
  :cognitect.aws.partnercentral-selling.Project/CompetitorName
  :cognitect.aws.partnercentral-selling/CompetitorName)

(s/def
  :cognitect.aws.partnercentral-selling.Project/SalesActivities
  :cognitect.aws.partnercentral-selling/SalesActivities)

(s/def
  :cognitect.aws.partnercentral-selling.Project/DeliveryModels
  :cognitect.aws.partnercentral-selling/DeliveryModels)

(s/def
  :cognitect.aws.partnercentral-selling.Project/AdditionalComments
  :cognitect.aws.partnercentral-selling/ProjectAdditionalCommentsString)

(s/def
  :cognitect.aws.partnercentral-selling.Project/ApnPrograms
  :cognitect.aws.partnercentral-selling/ApnPrograms)

(s/def
  :cognitect.aws.partnercentral-selling.Project/ExpectedCustomerSpend
  :cognitect.aws.partnercentral-selling/ExpectedCustomerSpendList)

(s/def
  :cognitect.aws.partnercentral-selling.Project/CustomerBusinessProblem
  :cognitect.aws.partnercentral-selling/ProjectCustomerBusinessProblemString)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementResponse/Arn
  :cognitect.aws.partnercentral-selling/EngagementArn)

(s/def
  :cognitect.aws.partnercentral-selling.CreateEngagementResponse/Id
  :cognitect.aws.partnercentral-selling/EngagementIdentifier)

(s/def
  :cognitect.aws.partnercentral-selling.NextStepsHistory/Time
  :cognitect.aws.partnercentral-selling/DateTime)

(s/def
  :cognitect.aws.partnercentral-selling.NextStepsHistory/Value
  :cognitect.aws.partnercentral-selling/String)

