;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.pcs.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.pcs/ThrottlingException
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ThrottlingException/message]
    :opt-un
    [:cognitect.aws.pcs.ThrottlingException/retryAfterSeconds]))

(s/def
  :cognitect.aws.pcs/ValidationExceptionFieldList
  (s/coll-of :cognitect.aws.pcs/ValidationExceptionField))

(s/def
  :cognitect.aws.pcs/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.TagResourceRequest/resourceArn :cognitect.aws.pcs.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.pcs/UpdateComputeNodeGroupSlurmConfigurationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pcs.UpdateComputeNodeGroupSlurmConfigurationRequest/slurmCustomSettings]))

(s/def
  :cognitect.aws.pcs/ServiceQuotaExceededException
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ServiceQuotaExceededException/message
     :cognitect.aws.pcs.ServiceQuotaExceededException/serviceCode]
    :opt-un
    [:cognitect.aws.pcs.ServiceQuotaExceededException/quotaCode
     :cognitect.aws.pcs.ServiceQuotaExceededException/resourceId
     :cognitect.aws.pcs.ServiceQuotaExceededException/resourceType]))

(s/def
  :cognitect.aws.pcs/InternalServerException
  (s/keys :req-un [:cognitect.aws.pcs.InternalServerException/message]))

(s/def
  :cognitect.aws.pcs/GetQueueResponse
  (s/keys :opt-un [:cognitect.aws.pcs.GetQueueResponse/queue]))

(s/def
  :cognitect.aws.pcs/SlurmAuthKey
  (s/keys
    :req-un
    [:cognitect.aws.pcs.SlurmAuthKey/secretArn :cognitect.aws.pcs.SlurmAuthKey/secretVersion]))

(s/def
  :cognitect.aws.pcs/ValidationExceptionField
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ValidationExceptionField/name
     :cognitect.aws.pcs.ValidationExceptionField/message]))

(s/def :cognitect.aws.pcs/DeleteClusterResponse (s/keys))

(s/def :cognitect.aws.pcs/AccountingMode (s/spec string? :gen #(s/gen #{"NONE" "STANDARD"})))

(s/def :cognitect.aws.pcs/SecurityGroupIdList (s/coll-of :cognitect.aws.pcs/SecurityGroupId))

(s/def
  :cognitect.aws.pcs/ComputeNodeGroupIdentifier
  (s/spec
    #(re-matches (re-pattern "(pcs_[a-zA-Z0-9]+|[A-Za-z][A-Za-z0-9-]{2,25})") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.pcs/NetworkType (s/spec string? :gen #(s/gen #{"IPV4" "IPV6"})))

(s/def
  :cognitect.aws.pcs/ListClustersResponse
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ListClustersResponse/clusters]
    :opt-un
    [:cognitect.aws.pcs.ListClustersResponse/nextToken]))

(s/def
  :cognitect.aws.pcs/ScalingConfigurationMinInstanceCountInteger
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def :cognitect.aws.pcs/DeleteQueueResponse (s/keys))

(s/def
  :cognitect.aws.pcs/ComputeNodeGroupSummary
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ComputeNodeGroupSummary/name
     :cognitect.aws.pcs.ComputeNodeGroupSummary/id
     :cognitect.aws.pcs.ComputeNodeGroupSummary/arn
     :cognitect.aws.pcs.ComputeNodeGroupSummary/clusterId
     :cognitect.aws.pcs.ComputeNodeGroupSummary/createdAt
     :cognitect.aws.pcs.ComputeNodeGroupSummary/modifiedAt
     :cognitect.aws.pcs.ComputeNodeGroupSummary/status]))

(s/def
  :cognitect.aws.pcs/ComputeNodeGroupConfigurationList
  (s/coll-of :cognitect.aws.pcs/ComputeNodeGroupConfiguration))

(s/def
  :cognitect.aws.pcs/AmiId
  (s/spec #(re-matches (re-pattern "ami-[a-z0-9]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pcs/ComputeNodeGroupName
  (s/spec #(re-matches (re-pattern "(?!pcs_)^[A-Za-z][A-Za-z0-9-]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.pcs/SlurmCustomSettings (s/coll-of :cognitect.aws.pcs/SlurmCustomSetting))

(s/def
  :cognitect.aws.pcs/Endpoint
  (s/keys
    :req-un
    [:cognitect.aws.pcs.Endpoint/type
     :cognitect.aws.pcs.Endpoint/privateIpAddress
     :cognitect.aws.pcs.Endpoint/port]
    :opt-un
    [:cognitect.aws.pcs.Endpoint/ipv6Address :cognitect.aws.pcs.Endpoint/publicIpAddress]))

(s/def
  :cognitect.aws.pcs/DeleteClusterRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.DeleteClusterRequest/clusterIdentifier]
    :opt-un
    [:cognitect.aws.pcs.DeleteClusterRequest/clientToken]))

(s/def :cognitect.aws.pcs/Size (s/spec string? :gen #(s/gen #{"LARGE" "SMALL" "MEDIUM"})))

(s/def
  :cognitect.aws.pcs/ScalingConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ScalingConfiguration/minInstanceCount
     :cognitect.aws.pcs.ScalingConfiguration/maxInstanceCount]))

(s/def
  :cognitect.aws.pcs/ValidationException
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ValidationException/message :cognitect.aws.pcs.ValidationException/reason]
    :opt-un
    [:cognitect.aws.pcs.ValidationException/fieldList]))

(s/def
  :cognitect.aws.pcs/AccessDeniedException
  (s/keys :req-un [:cognitect.aws.pcs.AccessDeniedException/message]))

(s/def
  :cognitect.aws.pcs/UpdateComputeNodeGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.UpdateComputeNodeGroupRequest/clusterIdentifier
     :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/computeNodeGroupIdentifier]
    :opt-un
    [:cognitect.aws.pcs.UpdateComputeNodeGroupRequest/spotOptions
     :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/subnetIds
     :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/amiId
     :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/clientToken
     :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/scalingConfiguration
     :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/customLaunchTemplate
     :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/purchaseOption
     :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/iamInstanceProfileArn
     :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/slurmConfiguration]))

(s/def
  :cognitect.aws.pcs/ValidationExceptionReason
  (s/spec
    string?
    :gen
    #(s/gen #{"unknownOperation" "cannotParse" "fieldValidationFailed" "other"})))

(s/def
  :cognitect.aws.pcs/CreateClusterResponse
  (s/keys :opt-un [:cognitect.aws.pcs.CreateClusterResponse/cluster]))

(s/def
  :cognitect.aws.pcs/ClusterName
  (s/spec #(re-matches (re-pattern "(?!pcs_)^[A-Za-z][A-Za-z0-9-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pcs/CreateComputeNodeGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.CreateComputeNodeGroupRequest/clusterIdentifier
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/computeNodeGroupName
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/subnetIds
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/customLaunchTemplate
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/iamInstanceProfileArn
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/scalingConfiguration
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/instanceConfigs]
    :opt-un
    [:cognitect.aws.pcs.CreateComputeNodeGroupRequest/spotOptions
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/amiId
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/clientToken
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/tags
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/purchaseOption
     :cognitect.aws.pcs.CreateComputeNodeGroupRequest/slurmConfiguration]))

(s/def
  :cognitect.aws.pcs/Accounting
  (s/keys
    :req-un
    [:cognitect.aws.pcs.Accounting/mode]
    :opt-un
    [:cognitect.aws.pcs.Accounting/defaultPurgeTimeInDays]))

(s/def
  :cognitect.aws.pcs/CreateClusterRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.CreateClusterRequest/clusterName
     :cognitect.aws.pcs.CreateClusterRequest/scheduler
     :cognitect.aws.pcs.CreateClusterRequest/size
     :cognitect.aws.pcs.CreateClusterRequest/networking]
    :opt-un
    [:cognitect.aws.pcs.CreateClusterRequest/clientToken
     :cognitect.aws.pcs.CreateClusterRequest/tags
     :cognitect.aws.pcs.CreateClusterRequest/slurmConfiguration]))

(s/def
  :cognitect.aws.pcs/ComputeNodeGroupSlurmConfigurationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pcs.ComputeNodeGroupSlurmConfigurationRequest/slurmCustomSettings]))

(s/def
  :cognitect.aws.pcs/ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def :cognitect.aws.pcs/SchedulerType (s/spec string? :gen #(s/gen #{"SLURM"})))

(s/def
  :cognitect.aws.pcs/SlurmCustomSetting
  (s/keys
    :req-un
    [:cognitect.aws.pcs.SlurmCustomSetting/parameterName
     :cognitect.aws.pcs.SlurmCustomSetting/parameterValue]))

(s/def
  :cognitect.aws.pcs/GetComputeNodeGroupResponse
  (s/keys :opt-un [:cognitect.aws.pcs.GetComputeNodeGroupResponse/computeNodeGroup]))

(s/def
  :cognitect.aws.pcs/AccountingRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.AccountingRequest/mode]
    :opt-un
    [:cognitect.aws.pcs.AccountingRequest/defaultPurgeTimeInDays]))

(s/def
  :cognitect.aws.pcs/ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pcs/GetClusterRequest
  (s/keys :req-un [:cognitect.aws.pcs.GetClusterRequest/clusterIdentifier]))

(s/def :cognitect.aws.pcs/ClusterList (s/coll-of :cognitect.aws.pcs/ClusterSummary))

(s/def
  :cognitect.aws.pcs/UpdateComputeNodeGroupResponse
  (s/keys :opt-un [:cognitect.aws.pcs.UpdateComputeNodeGroupResponse/computeNodeGroup]))

(s/def
  :cognitect.aws.pcs/ScalingConfigurationRequestMaxInstanceCountInteger
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pcs/ClusterSlurmConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.pcs.ClusterSlurmConfiguration/scaleDownIdleTimeInSeconds
     :cognitect.aws.pcs.ClusterSlurmConfiguration/slurmCustomSettings
     :cognitect.aws.pcs.ClusterSlurmConfiguration/accounting
     :cognitect.aws.pcs.ClusterSlurmConfiguration/authKey]))

(s/def :cognitect.aws.pcs/ErrorInfoList (s/coll-of :cognitect.aws.pcs/ErrorInfo))

(s/def :cognitect.aws.pcs/SyntheticTimestamp_date_time inst?)

(s/def :cognitect.aws.pcs/QueueList (s/coll-of :cognitect.aws.pcs/QueueSummary))

(s/def :cognitect.aws.pcs/InstanceList (s/coll-of :cognitect.aws.pcs/InstanceConfig))

(s/def
  :cognitect.aws.pcs/CustomLaunchTemplate
  (s/keys
    :req-un
    [:cognitect.aws.pcs.CustomLaunchTemplate/id :cognitect.aws.pcs.CustomLaunchTemplate/version]))

(s/def
  :cognitect.aws.pcs/ListComputeNodeGroupsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ListComputeNodeGroupsResponse/computeNodeGroups]
    :opt-un
    [:cognitect.aws.pcs.ListComputeNodeGroupsResponse/nextToken]))

(s/def
  :cognitect.aws.pcs/SpotOptions
  (s/keys :opt-un [:cognitect.aws.pcs.SpotOptions/allocationStrategy]))

(s/def
  :cognitect.aws.pcs/CreateQueueResponse
  (s/keys :opt-un [:cognitect.aws.pcs.CreateQueueResponse/queue]))

(s/def
  :cognitect.aws.pcs/BootstrapId
  (s/spec #(re-matches (re-pattern "[\\S]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.pcs/PurchaseOption (s/spec string? :gen #(s/gen #{"ONDEMAND" "SPOT"})))

(s/def :cognitect.aws.pcs/Integer (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pcs/Queue
  (s/keys
    :req-un
    [:cognitect.aws.pcs.Queue/name
     :cognitect.aws.pcs.Queue/id
     :cognitect.aws.pcs.Queue/arn
     :cognitect.aws.pcs.Queue/clusterId
     :cognitect.aws.pcs.Queue/createdAt
     :cognitect.aws.pcs.Queue/modifiedAt
     :cognitect.aws.pcs.Queue/status
     :cognitect.aws.pcs.Queue/computeNodeGroupConfigurations]
    :opt-un
    [:cognitect.aws.pcs.Queue/errorInfo]))

(s/def
  :cognitect.aws.pcs/UpdateQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.UpdateQueueRequest/clusterIdentifier
     :cognitect.aws.pcs.UpdateQueueRequest/queueIdentifier]
    :opt-un
    [:cognitect.aws.pcs.UpdateQueueRequest/clientToken
     :cognitect.aws.pcs.UpdateQueueRequest/computeNodeGroupConfigurations]))

(s/def
  :cognitect.aws.pcs/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.pcs/GetComputeNodeGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.GetComputeNodeGroupRequest/clusterIdentifier
     :cognitect.aws.pcs.GetComputeNodeGroupRequest/computeNodeGroupIdentifier]))

(s/def
  :cognitect.aws.pcs/Scheduler
  (s/keys :req-un [:cognitect.aws.pcs.Scheduler/type :cognitect.aws.pcs.Scheduler/version]))

(s/def
  :cognitect.aws.pcs/ClusterIdentifier
  (s/spec
    #(re-matches (re-pattern "(pcs_[a-zA-Z0-9]+|[A-Za-z][A-Za-z0-9-]{2,40})") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.pcs/SharedSecret string?)

(s/def
  :cognitect.aws.pcs/ComputeNodeGroupList
  (s/coll-of :cognitect.aws.pcs/ComputeNodeGroupSummary))

(s/def
  :cognitect.aws.pcs/CreateComputeNodeGroupResponse
  (s/keys :opt-un [:cognitect.aws.pcs.CreateComputeNodeGroupResponse/computeNodeGroup]))

(s/def
  :cognitect.aws.pcs/ScalingConfigurationRequestMinInstanceCountInteger
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pcs/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.pcs.ListTagsForResourceRequest/resourceArn]))

(s/def :cognitect.aws.pcs/EndpointType (s/spec string? :gen #(s/gen #{"SLURMDBD" "SLURMCTLD"})))

(s/def
  :cognitect.aws.pcs/DeleteQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.DeleteQueueRequest/clusterIdentifier
     :cognitect.aws.pcs.DeleteQueueRequest/queueIdentifier]
    :opt-un
    [:cognitect.aws.pcs.DeleteQueueRequest/clientToken]))

(s/def
  :cognitect.aws.pcs/SecurityGroupId
  (s/spec #(re-matches (re-pattern "sg-\\w{8,17}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pcs/ScalingConfigurationMaxInstanceCountInteger
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pcs/SpotAllocationStrategy
  (s/spec string? :gen #(s/gen #{"price-capacity-optimized" "lowest-price" "capacity-optimized"})))

(s/def
  :cognitect.aws.pcs/QueueStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CREATE_FAILED"
        "UPDATING"
        "SUSPENDING"
        "DELETING"
        "CREATING"
        "ACTIVE"
        "SUSPENDED"
        "DELETE_FAILED"
        "UPDATE_FAILED"})))

(s/def
  :cognitect.aws.pcs/InstanceConfig
  (s/keys :opt-un [:cognitect.aws.pcs.InstanceConfig/instanceType]))

(s/def
  :cognitect.aws.pcs/SubnetId
  (s/spec #(re-matches (re-pattern "subnet-\\w{8,17}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pcs/ClusterSlurmConfigurationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pcs.ClusterSlurmConfigurationRequest/scaleDownIdleTimeInSeconds
     :cognitect.aws.pcs.ClusterSlurmConfigurationRequest/slurmCustomSettings
     :cognitect.aws.pcs.ClusterSlurmConfigurationRequest/accounting]))

(s/def
  :cognitect.aws.pcs/ComputeNodeGroupConfiguration
  (s/keys :opt-un [:cognitect.aws.pcs.ComputeNodeGroupConfiguration/computeNodeGroupId]))

(s/def
  :cognitect.aws.pcs/QueueSummary
  (s/keys
    :req-un
    [:cognitect.aws.pcs.QueueSummary/name
     :cognitect.aws.pcs.QueueSummary/id
     :cognitect.aws.pcs.QueueSummary/arn
     :cognitect.aws.pcs.QueueSummary/clusterId
     :cognitect.aws.pcs.QueueSummary/createdAt
     :cognitect.aws.pcs.QueueSummary/modifiedAt
     :cognitect.aws.pcs.QueueSummary/status]))

(s/def
  :cognitect.aws.pcs/ComputeNodeGroupSlurmConfiguration
  (s/keys :opt-un [:cognitect.aws.pcs.ComputeNodeGroupSlurmConfiguration/slurmCustomSettings]))

(s/def
  :cognitect.aws.pcs/CreateQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.CreateQueueRequest/clusterIdentifier
     :cognitect.aws.pcs.CreateQueueRequest/queueName]
    :opt-un
    [:cognitect.aws.pcs.CreateQueueRequest/clientToken
     :cognitect.aws.pcs.CreateQueueRequest/tags
     :cognitect.aws.pcs.CreateQueueRequest/computeNodeGroupConfigurations]))

(s/def
  :cognitect.aws.pcs/ClusterStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CREATE_FAILED"
        "UPDATING"
        "SUSPENDING"
        "DELETING"
        "CREATING"
        "ACTIVE"
        "SUSPENDED"
        "DELETE_FAILED"
        "UPDATE_FAILED"})))

(s/def
  :cognitect.aws.pcs/Arn
  (s/spec
    #(re-matches (re-pattern "arn:aws.*:pcs:.*:[0-9]{12}:.*/[a-z0-9_\\-]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.pcs/ListQueuesResponse
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ListQueuesResponse/queues]
    :opt-un
    [:cognitect.aws.pcs.ListQueuesResponse/nextToken]))

(s/def
  :cognitect.aws.pcs/Cluster
  (s/keys
    :req-un
    [:cognitect.aws.pcs.Cluster/name
     :cognitect.aws.pcs.Cluster/id
     :cognitect.aws.pcs.Cluster/arn
     :cognitect.aws.pcs.Cluster/status
     :cognitect.aws.pcs.Cluster/createdAt
     :cognitect.aws.pcs.Cluster/modifiedAt
     :cognitect.aws.pcs.Cluster/scheduler
     :cognitect.aws.pcs.Cluster/size
     :cognitect.aws.pcs.Cluster/networking]
    :opt-un
    [:cognitect.aws.pcs.Cluster/endpoints
     :cognitect.aws.pcs.Cluster/errorInfo
     :cognitect.aws.pcs.Cluster/slurmConfiguration]))

(s/def :cognitect.aws.pcs/SubnetIdList (s/coll-of :cognitect.aws.pcs/SubnetId :min-count 1))

(s/def
  :cognitect.aws.pcs/AccountingDefaultPurgeTimeInDaysInteger
  (s/spec (s/and int? #(<= -1 % 10000)) :gen #(gen/choose -1 10000)))

(s/def
  :cognitect.aws.pcs/UpdateQueueResponse
  (s/keys :opt-un [:cognitect.aws.pcs.UpdateQueueResponse/queue]))

(s/def
  :cognitect.aws.pcs/ClusterSummary
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ClusterSummary/name
     :cognitect.aws.pcs.ClusterSummary/id
     :cognitect.aws.pcs.ClusterSummary/arn
     :cognitect.aws.pcs.ClusterSummary/createdAt
     :cognitect.aws.pcs.ClusterSummary/modifiedAt
     :cognitect.aws.pcs.ClusterSummary/status]))

(s/def
  :cognitect.aws.pcs/ScalingConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ScalingConfigurationRequest/minInstanceCount
     :cognitect.aws.pcs.ScalingConfigurationRequest/maxInstanceCount]))

(s/def
  :cognitect.aws.pcs/NetworkingRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pcs.NetworkingRequest/subnetIds
     :cognitect.aws.pcs.NetworkingRequest/networkType
     :cognitect.aws.pcs.NetworkingRequest/securityGroupIds]))

(s/def
  :cognitect.aws.pcs/ListQueuesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ListQueuesRequest/clusterIdentifier]
    :opt-un
    [:cognitect.aws.pcs.ListQueuesRequest/maxResults
     :cognitect.aws.pcs.ListQueuesRequest/nextToken]))

(s/def :cognitect.aws.pcs/MaxResults (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.pcs/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.UntagResourceRequest/resourceArn
     :cognitect.aws.pcs.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.pcs/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.pcs/Endpoints (s/coll-of :cognitect.aws.pcs/Endpoint))

(s/def
  :cognitect.aws.pcs/SBClientToken
  (s/spec
    (s/and string? #(<= 8 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 8 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.pcs/ComputeNodeGroup
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ComputeNodeGroup/name
     :cognitect.aws.pcs.ComputeNodeGroup/id
     :cognitect.aws.pcs.ComputeNodeGroup/arn
     :cognitect.aws.pcs.ComputeNodeGroup/clusterId
     :cognitect.aws.pcs.ComputeNodeGroup/createdAt
     :cognitect.aws.pcs.ComputeNodeGroup/modifiedAt
     :cognitect.aws.pcs.ComputeNodeGroup/status
     :cognitect.aws.pcs.ComputeNodeGroup/subnetIds
     :cognitect.aws.pcs.ComputeNodeGroup/customLaunchTemplate
     :cognitect.aws.pcs.ComputeNodeGroup/iamInstanceProfileArn
     :cognitect.aws.pcs.ComputeNodeGroup/scalingConfiguration
     :cognitect.aws.pcs.ComputeNodeGroup/instanceConfigs]
    :opt-un
    [:cognitect.aws.pcs.ComputeNodeGroup/spotOptions
     :cognitect.aws.pcs.ComputeNodeGroup/amiId
     :cognitect.aws.pcs.ComputeNodeGroup/errorInfo
     :cognitect.aws.pcs.ComputeNodeGroup/purchaseOption
     :cognitect.aws.pcs.ComputeNodeGroup/slurmConfiguration]))

(s/def
  :cognitect.aws.pcs/ErrorInfo
  (s/keys :opt-un [:cognitect.aws.pcs.ErrorInfo/message :cognitect.aws.pcs.ErrorInfo/code]))

(s/def :cognitect.aws.pcs/StringList (s/coll-of :cognitect.aws.pcs/String))

(s/def
  :cognitect.aws.pcs/AccountingRequestDefaultPurgeTimeInDaysInteger
  (s/spec (s/and int? #(<= -1 % 10000)) :gen #(gen/choose -1 10000)))

(s/def
  :cognitect.aws.pcs/QueueName
  (s/spec #(re-matches (re-pattern "(?!pcs_)^[A-Za-z][A-Za-z0-9-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pcs/InstanceProfileArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:aws([a-zA-Z-]{0,10})?:iam::[0-9]{12}:instance-profile/([!-~]{1,510}/)?([\\w+=,.@-]{1,128})")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.pcs/RegisterComputeNodeGroupInstanceRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.RegisterComputeNodeGroupInstanceRequest/clusterIdentifier
     :cognitect.aws.pcs.RegisterComputeNodeGroupInstanceRequest/bootstrapId]))

(s/def
  :cognitect.aws.pcs/ResponseTagMap
  (s/map-of :cognitect.aws.pcs/TagKey :cognitect.aws.pcs/TagValue))

(s/def
  :cognitect.aws.pcs/RegisterComputeNodeGroupInstanceResponse
  (s/keys
    :req-un
    [:cognitect.aws.pcs.RegisterComputeNodeGroupInstanceResponse/nodeID
     :cognitect.aws.pcs.RegisterComputeNodeGroupInstanceResponse/sharedSecret
     :cognitect.aws.pcs.RegisterComputeNodeGroupInstanceResponse/endpoints]))

(s/def :cognitect.aws.pcs/TagKeys (s/coll-of :cognitect.aws.pcs/TagKey :min-count 1 :max-count 200))

(s/def
  :cognitect.aws.pcs/ListClustersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pcs.ListClustersRequest/maxResults
     :cognitect.aws.pcs.ListClustersRequest/nextToken]))

(s/def
  :cognitect.aws.pcs/SchedulerRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.SchedulerRequest/type :cognitect.aws.pcs.SchedulerRequest/version]))

(s/def :cognitect.aws.pcs/DeleteComputeNodeGroupResponse (s/keys))

(s/def
  :cognitect.aws.pcs/ComputeNodeGroupStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CREATE_FAILED"
        "UPDATING"
        "SUSPENDING"
        "DELETING"
        "CREATING"
        "ACTIVE"
        "DELETED"
        "SUSPENDED"
        "DELETE_FAILED"
        "UPDATE_FAILED"})))

(s/def
  :cognitect.aws.pcs/DeleteComputeNodeGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.DeleteComputeNodeGroupRequest/clusterIdentifier
     :cognitect.aws.pcs.DeleteComputeNodeGroupRequest/computeNodeGroupIdentifier]
    :opt-un
    [:cognitect.aws.pcs.DeleteComputeNodeGroupRequest/clientToken]))

(s/def
  :cognitect.aws.pcs/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.pcs.ListTagsForResourceResponse/tags]))

(s/def
  :cognitect.aws.pcs/QueueIdentifier
  (s/spec
    #(re-matches (re-pattern "(pcs_[a-zA-Z0-9]+|[A-Za-z][A-Za-z0-9-]{2,25})") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.pcs/Networking
  (s/keys
    :opt-un
    [:cognitect.aws.pcs.Networking/subnetIds
     :cognitect.aws.pcs.Networking/networkType
     :cognitect.aws.pcs.Networking/securityGroupIds]))

(s/def
  :cognitect.aws.pcs/ListComputeNodeGroupsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ListComputeNodeGroupsRequest/clusterIdentifier]
    :opt-un
    [:cognitect.aws.pcs.ListComputeNodeGroupsRequest/maxResults
     :cognitect.aws.pcs.ListComputeNodeGroupsRequest/nextToken]))

(s/def :cognitect.aws.pcs/String string?)

(s/def
  :cognitect.aws.pcs/GetQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.pcs.GetQueueRequest/clusterIdentifier
     :cognitect.aws.pcs.GetQueueRequest/queueIdentifier]))

(s/def
  :cognitect.aws.pcs/RequestTagMap
  (s/map-of :cognitect.aws.pcs/TagKey :cognitect.aws.pcs/TagValue :min-count 1 :max-count 200))

(s/def
  :cognitect.aws.pcs/ResourceNotFoundException
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ResourceNotFoundException/message
     :cognitect.aws.pcs.ResourceNotFoundException/resourceId
     :cognitect.aws.pcs.ResourceNotFoundException/resourceType]))

(s/def
  :cognitect.aws.pcs/ConflictException
  (s/keys
    :req-un
    [:cognitect.aws.pcs.ConflictException/message
     :cognitect.aws.pcs.ConflictException/resourceId
     :cognitect.aws.pcs.ConflictException/resourceType]))

(s/def
  :cognitect.aws.pcs/GetClusterResponse
  (s/keys :opt-un [:cognitect.aws.pcs.GetClusterResponse/cluster]))

(s/def :cognitect.aws.pcs.ThrottlingException/message :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ThrottlingException/retryAfterSeconds :cognitect.aws.pcs/Integer)

(s/def :cognitect.aws.pcs.TagResourceRequest/resourceArn :cognitect.aws.pcs/Arn)

(s/def :cognitect.aws.pcs.TagResourceRequest/tags :cognitect.aws.pcs/RequestTagMap)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupSlurmConfigurationRequest/slurmCustomSettings
  :cognitect.aws.pcs/SlurmCustomSettings)

(s/def :cognitect.aws.pcs.ServiceQuotaExceededException/message :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ServiceQuotaExceededException/serviceCode :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ServiceQuotaExceededException/resourceId :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ServiceQuotaExceededException/resourceType :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ServiceQuotaExceededException/quotaCode :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.InternalServerException/message :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.GetQueueResponse/queue :cognitect.aws.pcs/Queue)

(s/def :cognitect.aws.pcs.SlurmAuthKey/secretArn :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.SlurmAuthKey/secretVersion :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ValidationExceptionField/name :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ValidationExceptionField/message :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ListClustersResponse/clusters :cognitect.aws.pcs/ClusterList)

(s/def :cognitect.aws.pcs.ListClustersResponse/nextToken :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ComputeNodeGroupSummary/name :cognitect.aws.pcs/ComputeNodeGroupName)

(s/def :cognitect.aws.pcs.ComputeNodeGroupSummary/id :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ComputeNodeGroupSummary/arn :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ComputeNodeGroupSummary/clusterId :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroupSummary/createdAt
  :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroupSummary/modifiedAt
  :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.ComputeNodeGroupSummary/status :cognitect.aws.pcs/ComputeNodeGroupStatus)

(s/def :cognitect.aws.pcs.Endpoint/type :cognitect.aws.pcs/EndpointType)

(s/def :cognitect.aws.pcs.Endpoint/privateIpAddress :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.Endpoint/publicIpAddress :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.Endpoint/ipv6Address :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.Endpoint/port :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.DeleteClusterRequest/clusterIdentifier
  :cognitect.aws.pcs/ClusterIdentifier)

(s/def :cognitect.aws.pcs.DeleteClusterRequest/clientToken :cognitect.aws.pcs/SBClientToken)

(s/def
  :cognitect.aws.pcs.ScalingConfiguration/minInstanceCount
  :cognitect.aws.pcs/ScalingConfigurationMinInstanceCountInteger)

(s/def
  :cognitect.aws.pcs.ScalingConfiguration/maxInstanceCount
  :cognitect.aws.pcs/ScalingConfigurationMaxInstanceCountInteger)

(s/def :cognitect.aws.pcs.ValidationException/message :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ValidationException/reason :cognitect.aws.pcs/ValidationExceptionReason)

(s/def
  :cognitect.aws.pcs.ValidationException/fieldList
  :cognitect.aws.pcs/ValidationExceptionFieldList)

(s/def :cognitect.aws.pcs.AccessDeniedException/message :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/subnetIds :cognitect.aws.pcs/StringList)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/scalingConfiguration
  :cognitect.aws.pcs/ScalingConfigurationRequest)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/purchaseOption
  :cognitect.aws.pcs/PurchaseOption)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/customLaunchTemplate
  :cognitect.aws.pcs/CustomLaunchTemplate)

(s/def :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/amiId :cognitect.aws.pcs/AmiId)

(s/def :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/spotOptions :cognitect.aws.pcs/SpotOptions)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/slurmConfiguration
  :cognitect.aws.pcs/UpdateComputeNodeGroupSlurmConfigurationRequest)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/iamInstanceProfileArn
  :cognitect.aws.pcs/InstanceProfileArn)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/clusterIdentifier
  :cognitect.aws.pcs/ClusterIdentifier)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/computeNodeGroupIdentifier
  :cognitect.aws.pcs/ComputeNodeGroupIdentifier)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupRequest/clientToken
  :cognitect.aws.pcs/SBClientToken)

(s/def :cognitect.aws.pcs.CreateClusterResponse/cluster :cognitect.aws.pcs/Cluster)

(s/def :cognitect.aws.pcs.CreateComputeNodeGroupRequest/tags :cognitect.aws.pcs/RequestTagMap)

(s/def :cognitect.aws.pcs.CreateComputeNodeGroupRequest/subnetIds :cognitect.aws.pcs/StringList)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupRequest/scalingConfiguration
  :cognitect.aws.pcs/ScalingConfigurationRequest)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupRequest/instanceConfigs
  :cognitect.aws.pcs/InstanceList)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupRequest/purchaseOption
  :cognitect.aws.pcs/PurchaseOption)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupRequest/customLaunchTemplate
  :cognitect.aws.pcs/CustomLaunchTemplate)

(s/def :cognitect.aws.pcs.CreateComputeNodeGroupRequest/amiId :cognitect.aws.pcs/AmiId)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupRequest/computeNodeGroupName
  :cognitect.aws.pcs/ComputeNodeGroupName)

(s/def :cognitect.aws.pcs.CreateComputeNodeGroupRequest/spotOptions :cognitect.aws.pcs/SpotOptions)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupRequest/slurmConfiguration
  :cognitect.aws.pcs/ComputeNodeGroupSlurmConfigurationRequest)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupRequest/iamInstanceProfileArn
  :cognitect.aws.pcs/InstanceProfileArn)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupRequest/clusterIdentifier
  :cognitect.aws.pcs/ClusterIdentifier)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupRequest/clientToken
  :cognitect.aws.pcs/SBClientToken)

(s/def :cognitect.aws.pcs.Accounting/mode :cognitect.aws.pcs/AccountingMode)

(s/def
  :cognitect.aws.pcs.Accounting/defaultPurgeTimeInDays
  :cognitect.aws.pcs/AccountingDefaultPurgeTimeInDaysInteger)

(s/def :cognitect.aws.pcs.CreateClusterRequest/clusterName :cognitect.aws.pcs/ClusterName)

(s/def :cognitect.aws.pcs.CreateClusterRequest/scheduler :cognitect.aws.pcs/SchedulerRequest)

(s/def :cognitect.aws.pcs.CreateClusterRequest/size :cognitect.aws.pcs/Size)

(s/def :cognitect.aws.pcs.CreateClusterRequest/networking :cognitect.aws.pcs/NetworkingRequest)

(s/def
  :cognitect.aws.pcs.CreateClusterRequest/slurmConfiguration
  :cognitect.aws.pcs/ClusterSlurmConfigurationRequest)

(s/def :cognitect.aws.pcs.CreateClusterRequest/clientToken :cognitect.aws.pcs/SBClientToken)

(s/def :cognitect.aws.pcs.CreateClusterRequest/tags :cognitect.aws.pcs/RequestTagMap)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroupSlurmConfigurationRequest/slurmCustomSettings
  :cognitect.aws.pcs/SlurmCustomSettings)

(s/def :cognitect.aws.pcs.SlurmCustomSetting/parameterName :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.SlurmCustomSetting/parameterValue :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.GetComputeNodeGroupResponse/computeNodeGroup
  :cognitect.aws.pcs/ComputeNodeGroup)

(s/def :cognitect.aws.pcs.AccountingRequest/mode :cognitect.aws.pcs/AccountingMode)

(s/def
  :cognitect.aws.pcs.AccountingRequest/defaultPurgeTimeInDays
  :cognitect.aws.pcs/AccountingRequestDefaultPurgeTimeInDaysInteger)

(s/def :cognitect.aws.pcs.GetClusterRequest/clusterIdentifier :cognitect.aws.pcs/ClusterIdentifier)

(s/def
  :cognitect.aws.pcs.UpdateComputeNodeGroupResponse/computeNodeGroup
  :cognitect.aws.pcs/ComputeNodeGroup)

(s/def
  :cognitect.aws.pcs.ClusterSlurmConfiguration/scaleDownIdleTimeInSeconds
  :cognitect.aws.pcs/ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger)

(s/def
  :cognitect.aws.pcs.ClusterSlurmConfiguration/slurmCustomSettings
  :cognitect.aws.pcs/SlurmCustomSettings)

(s/def :cognitect.aws.pcs.ClusterSlurmConfiguration/authKey :cognitect.aws.pcs/SlurmAuthKey)

(s/def :cognitect.aws.pcs.ClusterSlurmConfiguration/accounting :cognitect.aws.pcs/Accounting)

(s/def :cognitect.aws.pcs.CustomLaunchTemplate/id :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.CustomLaunchTemplate/version :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.ListComputeNodeGroupsResponse/computeNodeGroups
  :cognitect.aws.pcs/ComputeNodeGroupList)

(s/def :cognitect.aws.pcs.ListComputeNodeGroupsResponse/nextToken :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.SpotOptions/allocationStrategy :cognitect.aws.pcs/SpotAllocationStrategy)

(s/def :cognitect.aws.pcs.CreateQueueResponse/queue :cognitect.aws.pcs/Queue)

(s/def :cognitect.aws.pcs.Queue/name :cognitect.aws.pcs/QueueName)

(s/def :cognitect.aws.pcs.Queue/clusterId :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.Queue/createdAt :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.Queue/status :cognitect.aws.pcs/QueueStatus)

(s/def :cognitect.aws.pcs.Queue/id :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.Queue/computeNodeGroupConfigurations
  :cognitect.aws.pcs/ComputeNodeGroupConfigurationList)

(s/def :cognitect.aws.pcs.Queue/modifiedAt :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.Queue/errorInfo :cognitect.aws.pcs/ErrorInfoList)

(s/def :cognitect.aws.pcs.Queue/arn :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.UpdateQueueRequest/clusterIdentifier :cognitect.aws.pcs/ClusterIdentifier)

(s/def :cognitect.aws.pcs.UpdateQueueRequest/queueIdentifier :cognitect.aws.pcs/QueueIdentifier)

(s/def
  :cognitect.aws.pcs.UpdateQueueRequest/computeNodeGroupConfigurations
  :cognitect.aws.pcs/ComputeNodeGroupConfigurationList)

(s/def :cognitect.aws.pcs.UpdateQueueRequest/clientToken :cognitect.aws.pcs/SBClientToken)

(s/def
  :cognitect.aws.pcs.GetComputeNodeGroupRequest/clusterIdentifier
  :cognitect.aws.pcs/ClusterIdentifier)

(s/def
  :cognitect.aws.pcs.GetComputeNodeGroupRequest/computeNodeGroupIdentifier
  :cognitect.aws.pcs/ComputeNodeGroupIdentifier)

(s/def :cognitect.aws.pcs.Scheduler/type :cognitect.aws.pcs/SchedulerType)

(s/def :cognitect.aws.pcs.Scheduler/version :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.CreateComputeNodeGroupResponse/computeNodeGroup
  :cognitect.aws.pcs/ComputeNodeGroup)

(s/def :cognitect.aws.pcs.ListTagsForResourceRequest/resourceArn :cognitect.aws.pcs/Arn)

(s/def :cognitect.aws.pcs.DeleteQueueRequest/clusterIdentifier :cognitect.aws.pcs/ClusterIdentifier)

(s/def :cognitect.aws.pcs.DeleteQueueRequest/queueIdentifier :cognitect.aws.pcs/QueueIdentifier)

(s/def :cognitect.aws.pcs.DeleteQueueRequest/clientToken :cognitect.aws.pcs/SBClientToken)

(s/def :cognitect.aws.pcs.InstanceConfig/instanceType :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.ClusterSlurmConfigurationRequest/scaleDownIdleTimeInSeconds
  :cognitect.aws.pcs/ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger)

(s/def
  :cognitect.aws.pcs.ClusterSlurmConfigurationRequest/slurmCustomSettings
  :cognitect.aws.pcs/SlurmCustomSettings)

(s/def
  :cognitect.aws.pcs.ClusterSlurmConfigurationRequest/accounting
  :cognitect.aws.pcs/AccountingRequest)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroupConfiguration/computeNodeGroupId
  :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.QueueSummary/name :cognitect.aws.pcs/QueueName)

(s/def :cognitect.aws.pcs.QueueSummary/id :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.QueueSummary/arn :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.QueueSummary/clusterId :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.QueueSummary/createdAt :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.QueueSummary/modifiedAt :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.QueueSummary/status :cognitect.aws.pcs/QueueStatus)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroupSlurmConfiguration/slurmCustomSettings
  :cognitect.aws.pcs/SlurmCustomSettings)

(s/def :cognitect.aws.pcs.CreateQueueRequest/clusterIdentifier :cognitect.aws.pcs/ClusterIdentifier)

(s/def :cognitect.aws.pcs.CreateQueueRequest/queueName :cognitect.aws.pcs/QueueName)

(s/def
  :cognitect.aws.pcs.CreateQueueRequest/computeNodeGroupConfigurations
  :cognitect.aws.pcs/ComputeNodeGroupConfigurationList)

(s/def :cognitect.aws.pcs.CreateQueueRequest/clientToken :cognitect.aws.pcs/SBClientToken)

(s/def :cognitect.aws.pcs.CreateQueueRequest/tags :cognitect.aws.pcs/RequestTagMap)

(s/def :cognitect.aws.pcs.ListQueuesResponse/queues :cognitect.aws.pcs/QueueList)

(s/def :cognitect.aws.pcs.ListQueuesResponse/nextToken :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.Cluster/scheduler :cognitect.aws.pcs/Scheduler)

(s/def :cognitect.aws.pcs.Cluster/networking :cognitect.aws.pcs/Networking)

(s/def :cognitect.aws.pcs.Cluster/name :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.Cluster/createdAt :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.Cluster/size :cognitect.aws.pcs/Size)

(s/def :cognitect.aws.pcs.Cluster/endpoints :cognitect.aws.pcs/Endpoints)

(s/def :cognitect.aws.pcs.Cluster/slurmConfiguration :cognitect.aws.pcs/ClusterSlurmConfiguration)

(s/def :cognitect.aws.pcs.Cluster/status :cognitect.aws.pcs/ClusterStatus)

(s/def :cognitect.aws.pcs.Cluster/id :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.Cluster/modifiedAt :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.Cluster/errorInfo :cognitect.aws.pcs/ErrorInfoList)

(s/def :cognitect.aws.pcs.Cluster/arn :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.UpdateQueueResponse/queue :cognitect.aws.pcs/Queue)

(s/def :cognitect.aws.pcs.ClusterSummary/name :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ClusterSummary/id :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ClusterSummary/arn :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ClusterSummary/createdAt :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.ClusterSummary/modifiedAt :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.ClusterSummary/status :cognitect.aws.pcs/ClusterStatus)

(s/def
  :cognitect.aws.pcs.ScalingConfigurationRequest/minInstanceCount
  :cognitect.aws.pcs/ScalingConfigurationRequestMinInstanceCountInteger)

(s/def
  :cognitect.aws.pcs.ScalingConfigurationRequest/maxInstanceCount
  :cognitect.aws.pcs/ScalingConfigurationRequestMaxInstanceCountInteger)

(s/def :cognitect.aws.pcs.NetworkingRequest/subnetIds :cognitect.aws.pcs/SubnetIdList)

(s/def :cognitect.aws.pcs.NetworkingRequest/securityGroupIds :cognitect.aws.pcs/SecurityGroupIdList)

(s/def :cognitect.aws.pcs.NetworkingRequest/networkType :cognitect.aws.pcs/NetworkType)

(s/def :cognitect.aws.pcs.ListQueuesRequest/clusterIdentifier :cognitect.aws.pcs/ClusterIdentifier)

(s/def :cognitect.aws.pcs.ListQueuesRequest/nextToken :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ListQueuesRequest/maxResults :cognitect.aws.pcs/MaxResults)

(s/def :cognitect.aws.pcs.UntagResourceRequest/resourceArn :cognitect.aws.pcs/Arn)

(s/def :cognitect.aws.pcs.UntagResourceRequest/tagKeys :cognitect.aws.pcs/TagKeys)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/subnetIds :cognitect.aws.pcs/SubnetIdList)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroup/scalingConfiguration
  :cognitect.aws.pcs/ScalingConfiguration)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/name :cognitect.aws.pcs/ComputeNodeGroupName)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/instanceConfigs :cognitect.aws.pcs/InstanceList)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/clusterId :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/purchaseOption :cognitect.aws.pcs/PurchaseOption)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroup/customLaunchTemplate
  :cognitect.aws.pcs/CustomLaunchTemplate)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroup/createdAt
  :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/amiId :cognitect.aws.pcs/AmiId)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/spotOptions :cognitect.aws.pcs/SpotOptions)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroup/slurmConfiguration
  :cognitect.aws.pcs/ComputeNodeGroupSlurmConfiguration)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/status :cognitect.aws.pcs/ComputeNodeGroupStatus)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/id :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroup/iamInstanceProfileArn
  :cognitect.aws.pcs/InstanceProfileArn)

(s/def
  :cognitect.aws.pcs.ComputeNodeGroup/modifiedAt
  :cognitect.aws.pcs/SyntheticTimestamp_date_time)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/errorInfo :cognitect.aws.pcs/ErrorInfoList)

(s/def :cognitect.aws.pcs.ComputeNodeGroup/arn :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ErrorInfo/code :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ErrorInfo/message :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.RegisterComputeNodeGroupInstanceRequest/clusterIdentifier
  :cognitect.aws.pcs/ClusterIdentifier)

(s/def
  :cognitect.aws.pcs.RegisterComputeNodeGroupInstanceRequest/bootstrapId
  :cognitect.aws.pcs/BootstrapId)

(s/def :cognitect.aws.pcs.RegisterComputeNodeGroupInstanceResponse/nodeID :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.RegisterComputeNodeGroupInstanceResponse/sharedSecret
  :cognitect.aws.pcs/SharedSecret)

(s/def
  :cognitect.aws.pcs.RegisterComputeNodeGroupInstanceResponse/endpoints
  :cognitect.aws.pcs/Endpoints)

(s/def :cognitect.aws.pcs.ListClustersRequest/nextToken :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ListClustersRequest/maxResults :cognitect.aws.pcs/MaxResults)

(s/def :cognitect.aws.pcs.SchedulerRequest/type :cognitect.aws.pcs/SchedulerType)

(s/def :cognitect.aws.pcs.SchedulerRequest/version :cognitect.aws.pcs/String)

(s/def
  :cognitect.aws.pcs.DeleteComputeNodeGroupRequest/clusterIdentifier
  :cognitect.aws.pcs/ClusterIdentifier)

(s/def
  :cognitect.aws.pcs.DeleteComputeNodeGroupRequest/computeNodeGroupIdentifier
  :cognitect.aws.pcs/ComputeNodeGroupIdentifier)

(s/def
  :cognitect.aws.pcs.DeleteComputeNodeGroupRequest/clientToken
  :cognitect.aws.pcs/SBClientToken)

(s/def :cognitect.aws.pcs.ListTagsForResourceResponse/tags :cognitect.aws.pcs/ResponseTagMap)

(s/def :cognitect.aws.pcs.Networking/subnetIds :cognitect.aws.pcs/SubnetIdList)

(s/def :cognitect.aws.pcs.Networking/securityGroupIds :cognitect.aws.pcs/SecurityGroupIdList)

(s/def :cognitect.aws.pcs.Networking/networkType :cognitect.aws.pcs/NetworkType)

(s/def
  :cognitect.aws.pcs.ListComputeNodeGroupsRequest/clusterIdentifier
  :cognitect.aws.pcs/ClusterIdentifier)

(s/def :cognitect.aws.pcs.ListComputeNodeGroupsRequest/nextToken :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ListComputeNodeGroupsRequest/maxResults :cognitect.aws.pcs/MaxResults)

(s/def :cognitect.aws.pcs.GetQueueRequest/clusterIdentifier :cognitect.aws.pcs/ClusterIdentifier)

(s/def :cognitect.aws.pcs.GetQueueRequest/queueIdentifier :cognitect.aws.pcs/QueueIdentifier)

(s/def :cognitect.aws.pcs.ResourceNotFoundException/message :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ResourceNotFoundException/resourceId :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ResourceNotFoundException/resourceType :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ConflictException/message :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ConflictException/resourceId :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.ConflictException/resourceType :cognitect.aws.pcs/String)

(s/def :cognitect.aws.pcs.GetClusterResponse/cluster :cognitect.aws.pcs/Cluster)

