;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.pinpoint-email.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.pinpoint-email/EventType
  (s/spec
    string?
    :gen
    #(s/gen #{"OPEN" "SEND" "COMPLAINT" "CLICK" "RENDERING_FAILURE" "REJECT" "BOUNCE" "DELIVERY"})))

(s/def
  :cognitect.aws.pinpoint-email/DeleteEmailIdentityRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-email.DeleteEmailIdentityRequest/EmailIdentity]))

(s/def
  :cognitect.aws.pinpoint-email/PutAccountDedicatedIpWarmupAttributesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.PutAccountDedicatedIpWarmupAttributesRequest/AutoWarmupEnabled]))

(s/def :cognitect.aws.pinpoint-email/ConfigurationSetName string?)

(s/def :cognitect.aws.pinpoint-email/Domain string?)

(s/def :cognitect.aws.pinpoint-email/CreateDedicatedIpPoolResponse (s/keys))

(s/def :cognitect.aws.pinpoint-email/BlacklistItemName string?)

(s/def
  :cognitect.aws.pinpoint-email/DailyVolume
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.DailyVolume/VolumeStatistics
     :cognitect.aws.pinpoint-email.DailyVolume/DomainIspPlacements
     :cognitect.aws.pinpoint-email.DailyVolume/StartDate]))

(s/def
  :cognitect.aws.pinpoint-email/DeleteDedicatedIpPoolRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-email.DeleteDedicatedIpPoolRequest/PoolName]))

(s/def
  :cognitect.aws.pinpoint-email/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.TagResourceRequest/ResourceArn
     :cognitect.aws.pinpoint-email.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.pinpoint-email/MaxItems
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pinpoint-email/GetEmailIdentityResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.GetEmailIdentityResponse/Tags
     :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/DkimAttributes
     :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/VerifiedForSendingStatus
     :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/IdentityType
     :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/MailFromAttributes
     :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/FeedbackForwardingStatus]))

(s/def
  :cognitect.aws.pinpoint-email/ListConfigurationSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.ListConfigurationSetsResponse/ConfigurationSets
     :cognitect.aws.pinpoint-email.ListConfigurationSetsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint-email/ListDedicatedIpPoolsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.ListDedicatedIpPoolsRequest/PageSize
     :cognitect.aws.pinpoint-email.ListDedicatedIpPoolsRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint-email/CreateDedicatedIpPoolRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.CreateDedicatedIpPoolRequest/PoolName]
    :opt-un
    [:cognitect.aws.pinpoint-email.CreateDedicatedIpPoolRequest/Tags]))

(s/def
  :cognitect.aws.pinpoint-email/CreateDeliverabilityTestReportResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportResponse/ReportId
     :cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportResponse/DeliverabilityTestStatus]))

(s/def
  :cognitect.aws.pinpoint-email/DedicatedIp
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.DedicatedIp/Ip
     :cognitect.aws.pinpoint-email.DedicatedIp/WarmupStatus
     :cognitect.aws.pinpoint-email.DedicatedIp/WarmupPercentage]
    :opt-un
    [:cognitect.aws.pinpoint-email.DedicatedIp/PoolName]))

(s/def
  :cognitect.aws.pinpoint-email/ListDeliverabilityTestReportsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.ListDeliverabilityTestReportsResponse/DeliverabilityTestReports]
    :opt-un
    [:cognitect.aws.pinpoint-email.ListDeliverabilityTestReportsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint-email/GetConfigurationSetRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-email.GetConfigurationSetRequest/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-email/DkimStatus
  (s/spec string? :gen #(s/gen #{"SUCCESS" "PENDING" "TEMPORARY_FAILURE" "NOT_STARTED" "FAILED"})))

(s/def
  :cognitect.aws.pinpoint-email/Tag
  (s/keys :req-un [:cognitect.aws.pinpoint-email.Tag/Key :cognitect.aws.pinpoint-email.Tag/Value]))

(s/def
  :cognitect.aws.pinpoint-email/CreateEmailIdentityRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.CreateEmailIdentityRequest/EmailIdentity]
    :opt-un
    [:cognitect.aws.pinpoint-email.CreateEmailIdentityRequest/Tags]))

(s/def
  :cognitect.aws.pinpoint-email/CreateConfigurationSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/ConfigurationSetName]
    :opt-un
    [:cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/TrackingOptions
     :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/DeliveryOptions
     :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/Tags
     :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/ReputationOptions
     :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/SendingOptions]))

(s/def :cognitect.aws.pinpoint-email/TemplateArn string?)

(s/def
  :cognitect.aws.pinpoint-email/PutConfigurationSetSendingOptionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutConfigurationSetSendingOptionsRequest/ConfigurationSetName]
    :opt-un
    [:cognitect.aws.pinpoint-email.PutConfigurationSetSendingOptionsRequest/SendingEnabled]))

(s/def
  :cognitect.aws.pinpoint-email/DomainIspPlacement
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.DomainIspPlacement/SpamRawCount
     :cognitect.aws.pinpoint-email.DomainIspPlacement/InboxPercentage
     :cognitect.aws.pinpoint-email.DomainIspPlacement/SpamPercentage
     :cognitect.aws.pinpoint-email.DomainIspPlacement/InboxRawCount
     :cognitect.aws.pinpoint-email.DomainIspPlacement/IspName]))

(s/def
  :cognitect.aws.pinpoint-email/SentLast24Hours
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.pinpoint-email/DnsTokenList
  (s/coll-of :cognitect.aws.pinpoint-email/DnsToken))

(s/def
  :cognitect.aws.pinpoint-email/PutConfigurationSetTrackingOptionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutConfigurationSetTrackingOptionsRequest/ConfigurationSetName]
    :opt-un
    [:cognitect.aws.pinpoint-email.PutConfigurationSetTrackingOptionsRequest/CustomRedirectDomain]))

(s/def :cognitect.aws.pinpoint-email/DeliverabilityTestSubject string?)

(s/def :cognitect.aws.pinpoint-email/TagResourceResponse (s/keys))

(s/def :cognitect.aws.pinpoint-email/Identity string?)

(s/def :cognitect.aws.pinpoint-email/IspNameList (s/coll-of :cognitect.aws.pinpoint-email/IspName))

(s/def
  :cognitect.aws.pinpoint-email/ListDomainDeliverabilityCampaignsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/StartDate
     :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/EndDate
     :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/SubscribedDomain]
    :opt-un
    [:cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/PageSize
     :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint-email/ListConfigurationSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.ListConfigurationSetsRequest/PageSize
     :cognitect.aws.pinpoint-email.ListConfigurationSetsRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint-email/PutEmailIdentityMailFromAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutEmailIdentityMailFromAttributesRequest/EmailIdentity]
    :opt-un
    [:cognitect.aws.pinpoint-email.PutEmailIdentityMailFromAttributesRequest/MailFromDomain
     :cognitect.aws.pinpoint-email.PutEmailIdentityMailFromAttributesRequest/BehaviorOnMxFailure]))

(s/def
  :cognitect.aws.pinpoint-email/MaxSendRate
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.pinpoint-email/ConfigurationSetNameList
  (s/coll-of :cognitect.aws.pinpoint-email/ConfigurationSetName))

(s/def
  :cognitect.aws.pinpoint-email/CreateEmailIdentityResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.CreateEmailIdentityResponse/DkimAttributes
     :cognitect.aws.pinpoint-email.CreateEmailIdentityResponse/VerifiedForSendingStatus
     :cognitect.aws.pinpoint-email.CreateEmailIdentityResponse/IdentityType]))

(s/def :cognitect.aws.pinpoint-email/Esp string?)

(s/def
  :cognitect.aws.pinpoint-email/SnsDestination
  (s/keys :req-un [:cognitect.aws.pinpoint-email.SnsDestination/TopicArn]))

(s/def
  :cognitect.aws.pinpoint-email/Message
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.Message/Subject :cognitect.aws.pinpoint-email.Message/Body]))

(s/def :cognitect.aws.pinpoint-email/PoolName string?)

(s/def
  :cognitect.aws.pinpoint-email/IdentityInfo
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.IdentityInfo/IdentityName
     :cognitect.aws.pinpoint-email.IdentityInfo/IdentityType
     :cognitect.aws.pinpoint-email.IdentityInfo/SendingEnabled]))

(s/def :cognitect.aws.pinpoint-email/ImageUrl string?)

(s/def
  :cognitect.aws.pinpoint-email/EmailAddressList
  (s/coll-of :cognitect.aws.pinpoint-email/EmailAddress))

(s/def :cognitect.aws.pinpoint-email/PutDeliverabilityDashboardOptionResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/BlacklistItemNames
  (s/coll-of :cognitect.aws.pinpoint-email/BlacklistItemName))

(s/def
  :cognitect.aws.pinpoint-email/GetDedicatedIpResponse
  (s/keys :opt-un [:cognitect.aws.pinpoint-email.GetDedicatedIpResponse/DedicatedIp]))

(s/def :cognitect.aws.pinpoint-email/TagList (s/coll-of :cognitect.aws.pinpoint-email/Tag))

(s/def
  :cognitect.aws.pinpoint-email/Template
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.Template/TemplateArn
     :cognitect.aws.pinpoint-email.Template/TemplateData]))

(s/def
  :cognitect.aws.pinpoint-email/PutAccountSendingAttributesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.PutAccountSendingAttributesRequest/SendingEnabled]))

(s/def
  :cognitect.aws.pinpoint-email/GetConfigurationSetEventDestinationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.GetConfigurationSetEventDestinationsResponse/EventDestinations]))

(s/def :cognitect.aws.pinpoint-email/PutEmailIdentityFeedbackAttributesResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/PutDedicatedIpInPoolRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutDedicatedIpInPoolRequest/Ip
     :cognitect.aws.pinpoint-email.PutDedicatedIpInPoolRequest/DestinationPoolName]))

(s/def
  :cognitect.aws.pinpoint-email/GetDeliverabilityTestReportRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-email.GetDeliverabilityTestReportRequest/ReportId]))

(s/def :cognitect.aws.pinpoint-email/EventTypes (s/coll-of :cognitect.aws.pinpoint-email/EventType))

(s/def :cognitect.aws.pinpoint-email/RblName string?)

(s/def
  :cognitect.aws.pinpoint-email/GetConfigurationSetEventDestinationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.GetConfigurationSetEventDestinationsRequest/ConfigurationSetName]))

(s/def :cognitect.aws.pinpoint-email/MessageTagName string?)

(s/def :cognitect.aws.pinpoint-email/PutEmailIdentityMailFromAttributesResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/CreateConfigurationSetEventDestinationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.CreateConfigurationSetEventDestinationRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-email.CreateConfigurationSetEventDestinationRequest/EventDestinationName
     :cognitect.aws.pinpoint-email.CreateConfigurationSetEventDestinationRequest/EventDestination]))

(s/def
  :cognitect.aws.pinpoint-email/Destination
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.Destination/BccAddresses
     :cognitect.aws.pinpoint-email.Destination/ToAddresses
     :cognitect.aws.pinpoint-email.Destination/CcAddresses]))

(s/def
  :cognitect.aws.pinpoint-email/DomainIspPlacements
  (s/coll-of :cognitect.aws.pinpoint-email/DomainIspPlacement))

(s/def
  :cognitect.aws.pinpoint-email/EventDestinations
  (s/coll-of :cognitect.aws.pinpoint-email/EventDestination))

(s/def :cognitect.aws.pinpoint-email/BlacklistingDescription string?)

(s/def :cognitect.aws.pinpoint-email/EmailAddress string?)

(s/def
  :cognitect.aws.pinpoint-email/CloudWatchDimensionConfigurations
  (s/coll-of :cognitect.aws.pinpoint-email/CloudWatchDimensionConfiguration))

(s/def :cognitect.aws.pinpoint-email/CreateConfigurationSetResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/GetDedicatedIpsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.GetDedicatedIpsRequest/PoolName
     :cognitect.aws.pinpoint-email.GetDedicatedIpsRequest/PageSize
     :cognitect.aws.pinpoint-email.GetDedicatedIpsRequest/NextToken]))

(s/def :cognitect.aws.pinpoint-email/PutDedicatedIpWarmupAttributesResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/SendEmailRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.SendEmailRequest/Destination
     :cognitect.aws.pinpoint-email.SendEmailRequest/Content]
    :opt-un
    [:cognitect.aws.pinpoint-email.SendEmailRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-email.SendEmailRequest/FromEmailAddress
     :cognitect.aws.pinpoint-email.SendEmailRequest/FeedbackForwardingEmailAddress
     :cognitect.aws.pinpoint-email.SendEmailRequest/EmailTags
     :cognitect.aws.pinpoint-email.SendEmailRequest/ReplyToAddresses]))

(s/def
  :cognitect.aws.pinpoint-email/IdentityInfoList
  (s/coll-of :cognitect.aws.pinpoint-email/IdentityInfo))

(s/def
  :cognitect.aws.pinpoint-email/RawMessage
  (s/keys :req-un [:cognitect.aws.pinpoint-email.RawMessage/Data]))

(s/def
  :cognitect.aws.pinpoint-email/DeleteConfigurationSetEventDestinationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.DeleteConfigurationSetEventDestinationRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-email.DeleteConfigurationSetEventDestinationRequest/EventDestinationName]))

(s/def
  :cognitect.aws.pinpoint-email/BlacklistEntry
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.BlacklistEntry/RblName
     :cognitect.aws.pinpoint-email.BlacklistEntry/Description
     :cognitect.aws.pinpoint-email.BlacklistEntry/ListingTime]))

(s/def
  :cognitect.aws.pinpoint-email/IspPlacement
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.IspPlacement/PlacementStatistics
     :cognitect.aws.pinpoint-email.IspPlacement/IspName]))

(s/def
  :cognitect.aws.pinpoint-email/PutConfigurationSetDeliveryOptionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutConfigurationSetDeliveryOptionsRequest/ConfigurationSetName]
    :opt-un
    [:cognitect.aws.pinpoint-email.PutConfigurationSetDeliveryOptionsRequest/SendingPoolName
     :cognitect.aws.pinpoint-email.PutConfigurationSetDeliveryOptionsRequest/TlsPolicy]))

(s/def
  :cognitect.aws.pinpoint-email/ListOfDedicatedIpPools
  (s/coll-of :cognitect.aws.pinpoint-email/PoolName))

(s/def
  :cognitect.aws.pinpoint-email/GetEmailIdentityRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-email.GetEmailIdentityRequest/EmailIdentity]))

(s/def
  :cognitect.aws.pinpoint-email/GetDeliverabilityTestReportResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/DeliverabilityTestReport
     :cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/OverallPlacement
     :cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/IspPlacements]
    :opt-un
    [:cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/Tags
     :cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/Message]))

(s/def
  :cognitect.aws.pinpoint-email/DomainDeliverabilityCampaignList
  (s/coll-of :cognitect.aws.pinpoint-email/DomainDeliverabilityCampaign))

(s/def
  :cognitect.aws.pinpoint-email/TemplateData
  (s/spec
    (s/and string? #(>= 262144 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 262144) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.pinpoint-email/DeliverabilityTestReports
  (s/coll-of :cognitect.aws.pinpoint-email/DeliverabilityTestReport))

(s/def
  :cognitect.aws.pinpoint-email/DomainDeliverabilityCampaign
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/SendingIps
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/LastSeenDateTime
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/SpamCount
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/ImageUrl
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/FirstSeenDateTime
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/InboxCount
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/ReadDeleteRate
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/Subject
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/ProjectedVolume
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/ReadRate
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/Esps
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/FromAddress
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/DeleteRate
     :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/CampaignId]))

(s/def
  :cognitect.aws.pinpoint-email/DkimAttributes
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.DkimAttributes/SigningEnabled
     :cognitect.aws.pinpoint-email.DkimAttributes/Tokens
     :cognitect.aws.pinpoint-email.DkimAttributes/Status]))

(s/def
  :cognitect.aws.pinpoint-email/GetDomainStatisticsReportResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.GetDomainStatisticsReportResponse/OverallVolume
     :cognitect.aws.pinpoint-email.GetDomainStatisticsReportResponse/DailyVolumes]))

(s/def :cognitect.aws.pinpoint-email/AmazonResourceName string?)

(s/def
  :cognitect.aws.pinpoint-email/IspPlacements
  (s/coll-of :cognitect.aws.pinpoint-email/IspPlacement))

(s/def :cognitect.aws.pinpoint-email/Subject string?)

(s/def
  :cognitect.aws.pinpoint-email/BlacklistEntries
  (s/coll-of :cognitect.aws.pinpoint-email/BlacklistEntry))

(s/def :cognitect.aws.pinpoint-email/UpdateConfigurationSetEventDestinationResponse (s/keys))

(s/def :cognitect.aws.pinpoint-email/DimensionName string?)

(s/def :cognitect.aws.pinpoint-email/NextToken string?)

(s/def
  :cognitect.aws.pinpoint-email/CloudWatchDestination
  (s/keys :req-un [:cognitect.aws.pinpoint-email.CloudWatchDestination/DimensionConfigurations]))

(s/def
  :cognitect.aws.pinpoint-email/UpdateConfigurationSetEventDestinationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.UpdateConfigurationSetEventDestinationRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-email.UpdateConfigurationSetEventDestinationRequest/EventDestinationName
     :cognitect.aws.pinpoint-email.UpdateConfigurationSetEventDestinationRequest/EventDestination]))

(s/def
  :cognitect.aws.pinpoint-email/IdentityType
  (s/spec string? :gen #(s/gen #{"EMAIL_ADDRESS" "MANAGED_DOMAIN" "DOMAIN"})))

(s/def :cognitect.aws.pinpoint-email/MessageContent string?)

(s/def
  :cognitect.aws.pinpoint-email/ListEmailIdentitiesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.ListEmailIdentitiesRequest/PageSize
     :cognitect.aws.pinpoint-email.ListEmailIdentitiesRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint-email/TrackingOptions
  (s/keys :req-un [:cognitect.aws.pinpoint-email.TrackingOptions/CustomRedirectDomain]))

(s/def
  :cognitect.aws.pinpoint-email/PutEmailIdentityFeedbackAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutEmailIdentityFeedbackAttributesRequest/EmailIdentity]
    :opt-un
    [:cognitect.aws.pinpoint-email.PutEmailIdentityFeedbackAttributesRequest/EmailForwardingEnabled]))

(s/def
  :cognitect.aws.pinpoint-email/Body
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.Body/Html :cognitect.aws.pinpoint-email.Body/Text]))

(s/def :cognitect.aws.pinpoint-email/GetDeliverabilityDashboardOptionsRequest (s/keys))

(s/def :cognitect.aws.pinpoint-email/TagValue string?)

(s/def :cognitect.aws.pinpoint-email/PutConfigurationSetTrackingOptionsResponse (s/keys))

(s/def :cognitect.aws.pinpoint-email/LastFreshStart inst?)

(s/def
  :cognitect.aws.pinpoint-email/WarmupStatus
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "DONE"})))

(s/def
  :cognitect.aws.pinpoint-email/ListEmailIdentitiesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.ListEmailIdentitiesResponse/NextToken
     :cognitect.aws.pinpoint-email.ListEmailIdentitiesResponse/EmailIdentities]))

(s/def
  :cognitect.aws.pinpoint-email/Volume
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.pinpoint-email/PutAccountDedicatedIpWarmupAttributesResponse (s/keys))

(s/def :cognitect.aws.pinpoint-email/SendingPoolName string?)

(s/def
  :cognitect.aws.pinpoint-email/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-email.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.pinpoint-email/DomainDeliverabilityTrackingOption
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.DomainDeliverabilityTrackingOption/InboxPlacementTrackingOption
     :cognitect.aws.pinpoint-email.DomainDeliverabilityTrackingOption/Domain
     :cognitect.aws.pinpoint-email.DomainDeliverabilityTrackingOption/SubscriptionStartDate]))

(s/def
  :cognitect.aws.pinpoint-email/GetAccountResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.GetAccountResponse/ProductionAccessEnabled
     :cognitect.aws.pinpoint-email.GetAccountResponse/SendQuota
     :cognitect.aws.pinpoint-email.GetAccountResponse/EnforcementStatus
     :cognitect.aws.pinpoint-email.GetAccountResponse/SendingEnabled
     :cognitect.aws.pinpoint-email.GetAccountResponse/DedicatedIpAutoWarmupEnabled]))

(s/def
  :cognitect.aws.pinpoint-email/GetDomainDeliverabilityCampaignRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.GetDomainDeliverabilityCampaignRequest/CampaignId]))

(s/def
  :cognitect.aws.pinpoint-email/GetConfigurationSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.GetConfigurationSetResponse/TrackingOptions
     :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/DeliveryOptions
     :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/Tags
     :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/ConfigurationSetName
     :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/ReputationOptions
     :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/SendingOptions]))

(s/def :cognitect.aws.pinpoint-email/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/MessageTagList
  (s/coll-of :cognitect.aws.pinpoint-email/MessageTag))

(s/def
  :cognitect.aws.pinpoint-email/DeliverabilityTestStatus
  (s/spec string? :gen #(s/gen #{"COMPLETED" "IN_PROGRESS"})))

(s/def :cognitect.aws.pinpoint-email/PutEmailIdentityDkimAttributesResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/OverallVolume
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.OverallVolume/VolumeStatistics
     :cognitect.aws.pinpoint-email.OverallVolume/ReadRatePercent
     :cognitect.aws.pinpoint-email.OverallVolume/DomainIspPlacements]))

(s/def
  :cognitect.aws.pinpoint-email/Percentage
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.pinpoint-email/SendQuota
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.SendQuota/SentLast24Hours
     :cognitect.aws.pinpoint-email.SendQuota/MaxSendRate
     :cognitect.aws.pinpoint-email.SendQuota/Max24HourSend]))

(s/def :cognitect.aws.pinpoint-email/Ip string?)

(s/def
  :cognitect.aws.pinpoint-email/DeliverabilityTestReport
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.DeliverabilityTestReport/CreateDate
     :cognitect.aws.pinpoint-email.DeliverabilityTestReport/FromEmailAddress
     :cognitect.aws.pinpoint-email.DeliverabilityTestReport/Subject
     :cognitect.aws.pinpoint-email.DeliverabilityTestReport/DeliverabilityTestStatus
     :cognitect.aws.pinpoint-email.DeliverabilityTestReport/ReportName
     :cognitect.aws.pinpoint-email.DeliverabilityTestReport/ReportId]))

(s/def
  :cognitect.aws.pinpoint-email/Percentage100Wrapper
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pinpoint-email/GetDedicatedIpRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-email.GetDedicatedIpRequest/Ip]))

(s/def
  :cognitect.aws.pinpoint-email/PutConfigurationSetReputationOptionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutConfigurationSetReputationOptionsRequest/ConfigurationSetName]
    :opt-un
    [:cognitect.aws.pinpoint-email.PutConfigurationSetReputationOptionsRequest/ReputationMetricsEnabled]))

(s/def
  :cognitect.aws.pinpoint-email/KinesisFirehoseDestination
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.KinesisFirehoseDestination/IamRoleArn
     :cognitect.aws.pinpoint-email.KinesisFirehoseDestination/DeliveryStreamArn]))

(s/def
  :cognitect.aws.pinpoint-email/DimensionValueSource
  (s/spec string? :gen #(s/gen #{"LINK_TAG" "EMAIL_HEADER" "MESSAGE_TAG"})))

(s/def :cognitect.aws.pinpoint-email/MailFromDomainName string?)

(s/def :cognitect.aws.pinpoint-email/Esps (s/coll-of :cognitect.aws.pinpoint-email/Esp))

(s/def
  :cognitect.aws.pinpoint-email/SendingOptions
  (s/keys :opt-un [:cognitect.aws.pinpoint-email.SendingOptions/SendingEnabled]))

(s/def
  :cognitect.aws.pinpoint-email/EventDestination
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.EventDestination/Name
     :cognitect.aws.pinpoint-email.EventDestination/MatchingEventTypes]
    :opt-un
    [:cognitect.aws.pinpoint-email.EventDestination/SnsDestination
     :cognitect.aws.pinpoint-email.EventDestination/CloudWatchDestination
     :cognitect.aws.pinpoint-email.EventDestination/Enabled
     :cognitect.aws.pinpoint-email.EventDestination/PinpointDestination
     :cognitect.aws.pinpoint-email.EventDestination/KinesisFirehoseDestination]))

(s/def :cognitect.aws.pinpoint-email/DnsToken string?)

(s/def :cognitect.aws.pinpoint-email/PutConfigurationSetReputationOptionsResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/PlacementStatistics
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.PlacementStatistics/SpfPercentage
     :cognitect.aws.pinpoint-email.PlacementStatistics/InboxPercentage
     :cognitect.aws.pinpoint-email.PlacementStatistics/DkimPercentage
     :cognitect.aws.pinpoint-email.PlacementStatistics/SpamPercentage
     :cognitect.aws.pinpoint-email.PlacementStatistics/MissingPercentage]))

(s/def :cognitect.aws.pinpoint-email/MessageTagValue string?)

(s/def
  :cognitect.aws.pinpoint-email/GetBlacklistReportsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint-email.GetBlacklistReportsResponse/BlacklistReport]))

(s/def :cognitect.aws.pinpoint-email/ReportId string?)

(s/def
  :cognitect.aws.pinpoint-email/TlsPolicy
  (s/spec string? :gen #(s/gen #{"OPTIONAL" "REQUIRE"})))

(s/def
  :cognitect.aws.pinpoint-email/CreateDeliverabilityTestReportRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportRequest/FromEmailAddress
     :cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportRequest/Content]
    :opt-un
    [:cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportRequest/Tags
     :cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportRequest/ReportName]))

(s/def
  :cognitect.aws.pinpoint-email/InboxPlacementTrackingOption
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.InboxPlacementTrackingOption/TrackedIsps
     :cognitect.aws.pinpoint-email.InboxPlacementTrackingOption/Global]))

(s/def :cognitect.aws.pinpoint-email/DeleteDedicatedIpPoolResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/ReputationOptions
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.ReputationOptions/ReputationMetricsEnabled
     :cognitect.aws.pinpoint-email.ReputationOptions/LastFreshStart]))

(s/def
  :cognitect.aws.pinpoint-email/PutDeliverabilityDashboardOptionRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutDeliverabilityDashboardOptionRequest/DashboardEnabled]
    :opt-un
    [:cognitect.aws.pinpoint-email.PutDeliverabilityDashboardOptionRequest/SubscribedDomains]))

(s/def :cognitect.aws.pinpoint-email/DefaultDimensionValue string?)

(s/def
  :cognitect.aws.pinpoint-email/PinpointDestination
  (s/keys :opt-un [:cognitect.aws.pinpoint-email.PinpointDestination/ApplicationArn]))

(s/def
  :cognitect.aws.pinpoint-email/DailyVolumes
  (s/coll-of :cognitect.aws.pinpoint-email/DailyVolume))

(s/def :cognitect.aws.pinpoint-email/CustomRedirectDomain string?)

(s/def
  :cognitect.aws.pinpoint-email/RawMessageData
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def :cognitect.aws.pinpoint-email/IspName string?)

(s/def
  :cognitect.aws.pinpoint-email/MailFromDomainStatus
  (s/spec string? :gen #(s/gen #{"SUCCESS" "PENDING" "TEMPORARY_FAILURE" "FAILED"})))

(s/def
  :cognitect.aws.pinpoint-email/GetDomainDeliverabilityCampaignResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.GetDomainDeliverabilityCampaignResponse/DomainDeliverabilityCampaign]))

(s/def :cognitect.aws.pinpoint-email/IpList (s/coll-of :cognitect.aws.pinpoint-email/Ip))

(s/def :cognitect.aws.pinpoint-email/GetAccountRequest (s/keys))

(s/def :cognitect.aws.pinpoint-email/OutboundMessageId string?)

(s/def
  :cognitect.aws.pinpoint-email/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.UntagResourceRequest/ResourceArn
     :cognitect.aws.pinpoint-email.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.pinpoint-email/GetBlacklistReportsRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-email.GetBlacklistReportsRequest/BlacklistItemNames]))

(s/def :cognitect.aws.pinpoint-email/TagKey string?)

(s/def
  :cognitect.aws.pinpoint-email/ListDedicatedIpPoolsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.ListDedicatedIpPoolsResponse/DedicatedIpPools
     :cognitect.aws.pinpoint-email.ListDedicatedIpPoolsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint-email/SendEmailResponse
  (s/keys :opt-un [:cognitect.aws.pinpoint-email.SendEmailResponse/MessageId]))

(s/def :cognitect.aws.pinpoint-email/Enabled boolean?)

(s/def :cognitect.aws.pinpoint-email/DeleteEmailIdentityResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/MessageTag
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.MessageTag/Name :cognitect.aws.pinpoint-email.MessageTag/Value]))

(s/def :cognitect.aws.pinpoint-email/PutConfigurationSetSendingOptionsResponse (s/keys))

(s/def :cognitect.aws.pinpoint-email/Timestamp inst?)

(s/def
  :cognitect.aws.pinpoint-email/ListDeliverabilityTestReportsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.ListDeliverabilityTestReportsRequest/PageSize
     :cognitect.aws.pinpoint-email.ListDeliverabilityTestReportsRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint-email/BlacklistReport
  (s/map-of
    :cognitect.aws.pinpoint-email/BlacklistItemName
    :cognitect.aws.pinpoint-email/BlacklistEntries))

(s/def
  :cognitect.aws.pinpoint-email/DedicatedIpList
  (s/coll-of :cognitect.aws.pinpoint-email/DedicatedIp))

(s/def
  :cognitect.aws.pinpoint-email/BehaviorOnMxFailure
  (s/spec string? :gen #(s/gen #{"REJECT_MESSAGE" "USE_DEFAULT_VALUE"})))

(s/def
  :cognitect.aws.pinpoint-email/ListDomainDeliverabilityCampaignsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsResponse/DomainDeliverabilityCampaigns]
    :opt-un
    [:cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsResponse/NextToken]))

(s/def :cognitect.aws.pinpoint-email/Charset string?)

(s/def :cognitect.aws.pinpoint-email/CreateConfigurationSetEventDestinationResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/DomainDeliverabilityTrackingOptions
  (s/coll-of :cognitect.aws.pinpoint-email/DomainDeliverabilityTrackingOption))

(s/def
  :cognitect.aws.pinpoint-email/MailFromAttributes
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.MailFromAttributes/MailFromDomain
     :cognitect.aws.pinpoint-email.MailFromAttributes/MailFromDomainStatus
     :cognitect.aws.pinpoint-email.MailFromAttributes/BehaviorOnMxFailure]))

(s/def
  :cognitect.aws.pinpoint-email/DeliveryOptions
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.DeliveryOptions/SendingPoolName
     :cognitect.aws.pinpoint-email.DeliveryOptions/TlsPolicy]))

(s/def :cognitect.aws.pinpoint-email/PutDedicatedIpInPoolResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/DeliverabilityDashboardAccountStatus
  (s/spec string? :gen #(s/gen #{"DISABLED" "PENDING_EXPIRATION" "ACTIVE"})))

(s/def
  :cognitect.aws.pinpoint-email/VolumeStatistics
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.VolumeStatistics/SpamRawCount
     :cognitect.aws.pinpoint-email.VolumeStatistics/ProjectedSpam
     :cognitect.aws.pinpoint-email.VolumeStatistics/ProjectedInbox
     :cognitect.aws.pinpoint-email.VolumeStatistics/InboxRawCount]))

(s/def
  :cognitect.aws.pinpoint-email/EventDestinationDefinition
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.EventDestinationDefinition/SnsDestination
     :cognitect.aws.pinpoint-email.EventDestinationDefinition/CloudWatchDestination
     :cognitect.aws.pinpoint-email.EventDestinationDefinition/Enabled
     :cognitect.aws.pinpoint-email.EventDestinationDefinition/MatchingEventTypes
     :cognitect.aws.pinpoint-email.EventDestinationDefinition/PinpointDestination
     :cognitect.aws.pinpoint-email.EventDestinationDefinition/KinesisFirehoseDestination]))

(s/def
  :cognitect.aws.pinpoint-email/DeleteConfigurationSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.DeleteConfigurationSetRequest/ConfigurationSetName]))

(s/def :cognitect.aws.pinpoint-email/DeleteConfigurationSetEventDestinationResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/PutDedicatedIpWarmupAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutDedicatedIpWarmupAttributesRequest/Ip
     :cognitect.aws.pinpoint-email.PutDedicatedIpWarmupAttributesRequest/WarmupPercentage]))

(s/def :cognitect.aws.pinpoint-email/ReportName string?)

(s/def
  :cognitect.aws.pinpoint-email/ListTagsForResourceResponse
  (s/keys :req-un [:cognitect.aws.pinpoint-email.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.pinpoint-email/Max24HourSend
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.pinpoint-email/PutEmailIdentityDkimAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.PutEmailIdentityDkimAttributesRequest/EmailIdentity]
    :opt-un
    [:cognitect.aws.pinpoint-email.PutEmailIdentityDkimAttributesRequest/SigningEnabled]))

(s/def
  :cognitect.aws.pinpoint-email/Content
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.Content/Data]
    :opt-un
    [:cognitect.aws.pinpoint-email.Content/Charset]))

(s/def :cognitect.aws.pinpoint-email/DeleteConfigurationSetResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/CloudWatchDimensionConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.CloudWatchDimensionConfiguration/DimensionName
     :cognitect.aws.pinpoint-email.CloudWatchDimensionConfiguration/DimensionValueSource
     :cognitect.aws.pinpoint-email.CloudWatchDimensionConfiguration/DefaultDimensionValue]))

(s/def :cognitect.aws.pinpoint-email/GeneralEnforcementStatus string?)

(s/def
  :cognitect.aws.pinpoint-email/GetDomainStatisticsReportRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.GetDomainStatisticsReportRequest/Domain
     :cognitect.aws.pinpoint-email.GetDomainStatisticsReportRequest/StartDate
     :cognitect.aws.pinpoint-email.GetDomainStatisticsReportRequest/EndDate]))

(s/def :cognitect.aws.pinpoint-email/EventDestinationName string?)

(s/def :cognitect.aws.pinpoint-email/CampaignId string?)

(s/def :cognitect.aws.pinpoint-email/PutAccountSendingAttributesResponse (s/keys))

(s/def :cognitect.aws.pinpoint-email/PutConfigurationSetDeliveryOptionsResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-email/GetDedicatedIpsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.GetDedicatedIpsResponse/NextToken
     :cognitect.aws.pinpoint-email.GetDedicatedIpsResponse/DedicatedIps]))

(s/def
  :cognitect.aws.pinpoint-email/GetDeliverabilityDashboardOptionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/DashboardEnabled]
    :opt-un
    [:cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/PendingExpirationSubscribedDomains
     :cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/ActiveSubscribedDomains
     :cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/AccountStatus
     :cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/SubscriptionExpiryDate]))

(s/def
  :cognitect.aws.pinpoint-email/EmailContent
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-email.EmailContent/Template
     :cognitect.aws.pinpoint-email.EmailContent/Raw
     :cognitect.aws.pinpoint-email.EmailContent/Simple]))

(s/def :cognitect.aws.pinpoint-email/TagKeyList (s/coll-of :cognitect.aws.pinpoint-email/TagKey))

(s/def :cognitect.aws.pinpoint-email/MessageData string?)

(s/def
  :cognitect.aws.pinpoint-email.DeleteEmailIdentityRequest/EmailIdentity
  :cognitect.aws.pinpoint-email/Identity)

(s/def
  :cognitect.aws.pinpoint-email.PutAccountDedicatedIpWarmupAttributesRequest/AutoWarmupEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def :cognitect.aws.pinpoint-email.DailyVolume/StartDate :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.DailyVolume/VolumeStatistics
  :cognitect.aws.pinpoint-email/VolumeStatistics)

(s/def
  :cognitect.aws.pinpoint-email.DailyVolume/DomainIspPlacements
  :cognitect.aws.pinpoint-email/DomainIspPlacements)

(s/def
  :cognitect.aws.pinpoint-email.DeleteDedicatedIpPoolRequest/PoolName
  :cognitect.aws.pinpoint-email/PoolName)

(s/def
  :cognitect.aws.pinpoint-email.TagResourceRequest/ResourceArn
  :cognitect.aws.pinpoint-email/AmazonResourceName)

(s/def :cognitect.aws.pinpoint-email.TagResourceRequest/Tags :cognitect.aws.pinpoint-email/TagList)

(s/def
  :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/IdentityType
  :cognitect.aws.pinpoint-email/IdentityType)

(s/def
  :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/FeedbackForwardingStatus
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/VerifiedForSendingStatus
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/DkimAttributes
  :cognitect.aws.pinpoint-email/DkimAttributes)

(s/def
  :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/MailFromAttributes
  :cognitect.aws.pinpoint-email/MailFromAttributes)

(s/def
  :cognitect.aws.pinpoint-email.GetEmailIdentityResponse/Tags
  :cognitect.aws.pinpoint-email/TagList)

(s/def
  :cognitect.aws.pinpoint-email.ListConfigurationSetsResponse/ConfigurationSets
  :cognitect.aws.pinpoint-email/ConfigurationSetNameList)

(s/def
  :cognitect.aws.pinpoint-email.ListConfigurationSetsResponse/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.ListDedicatedIpPoolsRequest/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.ListDedicatedIpPoolsRequest/PageSize
  :cognitect.aws.pinpoint-email/MaxItems)

(s/def
  :cognitect.aws.pinpoint-email.CreateDedicatedIpPoolRequest/PoolName
  :cognitect.aws.pinpoint-email/PoolName)

(s/def
  :cognitect.aws.pinpoint-email.CreateDedicatedIpPoolRequest/Tags
  :cognitect.aws.pinpoint-email/TagList)

(s/def
  :cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportResponse/ReportId
  :cognitect.aws.pinpoint-email/ReportId)

(s/def
  :cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportResponse/DeliverabilityTestStatus
  :cognitect.aws.pinpoint-email/DeliverabilityTestStatus)

(s/def :cognitect.aws.pinpoint-email.DedicatedIp/Ip :cognitect.aws.pinpoint-email/Ip)

(s/def
  :cognitect.aws.pinpoint-email.DedicatedIp/WarmupStatus
  :cognitect.aws.pinpoint-email/WarmupStatus)

(s/def
  :cognitect.aws.pinpoint-email.DedicatedIp/WarmupPercentage
  :cognitect.aws.pinpoint-email/Percentage100Wrapper)

(s/def :cognitect.aws.pinpoint-email.DedicatedIp/PoolName :cognitect.aws.pinpoint-email/PoolName)

(s/def
  :cognitect.aws.pinpoint-email.ListDeliverabilityTestReportsResponse/DeliverabilityTestReports
  :cognitect.aws.pinpoint-email/DeliverabilityTestReports)

(s/def
  :cognitect.aws.pinpoint-email.ListDeliverabilityTestReportsResponse/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.GetConfigurationSetRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def :cognitect.aws.pinpoint-email.Tag/Key :cognitect.aws.pinpoint-email/TagKey)

(s/def :cognitect.aws.pinpoint-email.Tag/Value :cognitect.aws.pinpoint-email/TagValue)

(s/def
  :cognitect.aws.pinpoint-email.CreateEmailIdentityRequest/EmailIdentity
  :cognitect.aws.pinpoint-email/Identity)

(s/def
  :cognitect.aws.pinpoint-email.CreateEmailIdentityRequest/Tags
  :cognitect.aws.pinpoint-email/TagList)

(s/def
  :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/TrackingOptions
  :cognitect.aws.pinpoint-email/TrackingOptions)

(s/def
  :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/DeliveryOptions
  :cognitect.aws.pinpoint-email/DeliveryOptions)

(s/def
  :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/ReputationOptions
  :cognitect.aws.pinpoint-email/ReputationOptions)

(s/def
  :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/SendingOptions
  :cognitect.aws.pinpoint-email/SendingOptions)

(s/def
  :cognitect.aws.pinpoint-email.CreateConfigurationSetRequest/Tags
  :cognitect.aws.pinpoint-email/TagList)

(s/def
  :cognitect.aws.pinpoint-email.PutConfigurationSetSendingOptionsRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.PutConfigurationSetSendingOptionsRequest/SendingEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.DomainIspPlacement/IspName
  :cognitect.aws.pinpoint-email/IspName)

(s/def
  :cognitect.aws.pinpoint-email.DomainIspPlacement/InboxRawCount
  :cognitect.aws.pinpoint-email/Volume)

(s/def
  :cognitect.aws.pinpoint-email.DomainIspPlacement/SpamRawCount
  :cognitect.aws.pinpoint-email/Volume)

(s/def
  :cognitect.aws.pinpoint-email.DomainIspPlacement/InboxPercentage
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.DomainIspPlacement/SpamPercentage
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.PutConfigurationSetTrackingOptionsRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.PutConfigurationSetTrackingOptionsRequest/CustomRedirectDomain
  :cognitect.aws.pinpoint-email/CustomRedirectDomain)

(s/def
  :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/StartDate
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/EndDate
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/SubscribedDomain
  :cognitect.aws.pinpoint-email/Domain)

(s/def
  :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsRequest/PageSize
  :cognitect.aws.pinpoint-email/MaxItems)

(s/def
  :cognitect.aws.pinpoint-email.ListConfigurationSetsRequest/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.ListConfigurationSetsRequest/PageSize
  :cognitect.aws.pinpoint-email/MaxItems)

(s/def
  :cognitect.aws.pinpoint-email.PutEmailIdentityMailFromAttributesRequest/EmailIdentity
  :cognitect.aws.pinpoint-email/Identity)

(s/def
  :cognitect.aws.pinpoint-email.PutEmailIdentityMailFromAttributesRequest/MailFromDomain
  :cognitect.aws.pinpoint-email/MailFromDomainName)

(s/def
  :cognitect.aws.pinpoint-email.PutEmailIdentityMailFromAttributesRequest/BehaviorOnMxFailure
  :cognitect.aws.pinpoint-email/BehaviorOnMxFailure)

(s/def
  :cognitect.aws.pinpoint-email.CreateEmailIdentityResponse/IdentityType
  :cognitect.aws.pinpoint-email/IdentityType)

(s/def
  :cognitect.aws.pinpoint-email.CreateEmailIdentityResponse/VerifiedForSendingStatus
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.CreateEmailIdentityResponse/DkimAttributes
  :cognitect.aws.pinpoint-email/DkimAttributes)

(s/def
  :cognitect.aws.pinpoint-email.SnsDestination/TopicArn
  :cognitect.aws.pinpoint-email/AmazonResourceName)

(s/def :cognitect.aws.pinpoint-email.Message/Subject :cognitect.aws.pinpoint-email/Content)

(s/def :cognitect.aws.pinpoint-email.Message/Body :cognitect.aws.pinpoint-email/Body)

(s/def
  :cognitect.aws.pinpoint-email.IdentityInfo/IdentityType
  :cognitect.aws.pinpoint-email/IdentityType)

(s/def
  :cognitect.aws.pinpoint-email.IdentityInfo/IdentityName
  :cognitect.aws.pinpoint-email/Identity)

(s/def
  :cognitect.aws.pinpoint-email.IdentityInfo/SendingEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.GetDedicatedIpResponse/DedicatedIp
  :cognitect.aws.pinpoint-email/DedicatedIp)

(s/def :cognitect.aws.pinpoint-email.Template/TemplateArn :cognitect.aws.pinpoint-email/TemplateArn)

(s/def
  :cognitect.aws.pinpoint-email.Template/TemplateData
  :cognitect.aws.pinpoint-email/TemplateData)

(s/def
  :cognitect.aws.pinpoint-email.PutAccountSendingAttributesRequest/SendingEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.GetConfigurationSetEventDestinationsResponse/EventDestinations
  :cognitect.aws.pinpoint-email/EventDestinations)

(s/def
  :cognitect.aws.pinpoint-email.PutDedicatedIpInPoolRequest/Ip
  :cognitect.aws.pinpoint-email/Ip)

(s/def
  :cognitect.aws.pinpoint-email.PutDedicatedIpInPoolRequest/DestinationPoolName
  :cognitect.aws.pinpoint-email/PoolName)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityTestReportRequest/ReportId
  :cognitect.aws.pinpoint-email/ReportId)

(s/def
  :cognitect.aws.pinpoint-email.GetConfigurationSetEventDestinationsRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.CreateConfigurationSetEventDestinationRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.CreateConfigurationSetEventDestinationRequest/EventDestinationName
  :cognitect.aws.pinpoint-email/EventDestinationName)

(s/def
  :cognitect.aws.pinpoint-email.CreateConfigurationSetEventDestinationRequest/EventDestination
  :cognitect.aws.pinpoint-email/EventDestinationDefinition)

(s/def
  :cognitect.aws.pinpoint-email.Destination/ToAddresses
  :cognitect.aws.pinpoint-email/EmailAddressList)

(s/def
  :cognitect.aws.pinpoint-email.Destination/CcAddresses
  :cognitect.aws.pinpoint-email/EmailAddressList)

(s/def
  :cognitect.aws.pinpoint-email.Destination/BccAddresses
  :cognitect.aws.pinpoint-email/EmailAddressList)

(s/def
  :cognitect.aws.pinpoint-email.GetDedicatedIpsRequest/PoolName
  :cognitect.aws.pinpoint-email/PoolName)

(s/def
  :cognitect.aws.pinpoint-email.GetDedicatedIpsRequest/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.GetDedicatedIpsRequest/PageSize
  :cognitect.aws.pinpoint-email/MaxItems)

(s/def
  :cognitect.aws.pinpoint-email.SendEmailRequest/FromEmailAddress
  :cognitect.aws.pinpoint-email/EmailAddress)

(s/def
  :cognitect.aws.pinpoint-email.SendEmailRequest/Destination
  :cognitect.aws.pinpoint-email/Destination)

(s/def
  :cognitect.aws.pinpoint-email.SendEmailRequest/ReplyToAddresses
  :cognitect.aws.pinpoint-email/EmailAddressList)

(s/def
  :cognitect.aws.pinpoint-email.SendEmailRequest/FeedbackForwardingEmailAddress
  :cognitect.aws.pinpoint-email/EmailAddress)

(s/def
  :cognitect.aws.pinpoint-email.SendEmailRequest/Content
  :cognitect.aws.pinpoint-email/EmailContent)

(s/def
  :cognitect.aws.pinpoint-email.SendEmailRequest/EmailTags
  :cognitect.aws.pinpoint-email/MessageTagList)

(s/def
  :cognitect.aws.pinpoint-email.SendEmailRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def :cognitect.aws.pinpoint-email.RawMessage/Data :cognitect.aws.pinpoint-email/RawMessageData)

(s/def
  :cognitect.aws.pinpoint-email.DeleteConfigurationSetEventDestinationRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.DeleteConfigurationSetEventDestinationRequest/EventDestinationName
  :cognitect.aws.pinpoint-email/EventDestinationName)

(s/def :cognitect.aws.pinpoint-email.BlacklistEntry/RblName :cognitect.aws.pinpoint-email/RblName)

(s/def
  :cognitect.aws.pinpoint-email.BlacklistEntry/ListingTime
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.BlacklistEntry/Description
  :cognitect.aws.pinpoint-email/BlacklistingDescription)

(s/def :cognitect.aws.pinpoint-email.IspPlacement/IspName :cognitect.aws.pinpoint-email/IspName)

(s/def
  :cognitect.aws.pinpoint-email.IspPlacement/PlacementStatistics
  :cognitect.aws.pinpoint-email/PlacementStatistics)

(s/def
  :cognitect.aws.pinpoint-email.PutConfigurationSetDeliveryOptionsRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.PutConfigurationSetDeliveryOptionsRequest/TlsPolicy
  :cognitect.aws.pinpoint-email/TlsPolicy)

(s/def
  :cognitect.aws.pinpoint-email.PutConfigurationSetDeliveryOptionsRequest/SendingPoolName
  :cognitect.aws.pinpoint-email/SendingPoolName)

(s/def
  :cognitect.aws.pinpoint-email.GetEmailIdentityRequest/EmailIdentity
  :cognitect.aws.pinpoint-email/Identity)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/DeliverabilityTestReport
  :cognitect.aws.pinpoint-email/DeliverabilityTestReport)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/OverallPlacement
  :cognitect.aws.pinpoint-email/PlacementStatistics)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/IspPlacements
  :cognitect.aws.pinpoint-email/IspPlacements)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/Message
  :cognitect.aws.pinpoint-email/MessageContent)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityTestReportResponse/Tags
  :cognitect.aws.pinpoint-email/TagList)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/ImageUrl
  :cognitect.aws.pinpoint-email/ImageUrl)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/ReadDeleteRate
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/ReadRate
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/Subject
  :cognitect.aws.pinpoint-email/Subject)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/SpamCount
  :cognitect.aws.pinpoint-email/Volume)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/SendingIps
  :cognitect.aws.pinpoint-email/IpList)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/InboxCount
  :cognitect.aws.pinpoint-email/Volume)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/Esps
  :cognitect.aws.pinpoint-email/Esps)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/LastSeenDateTime
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/FirstSeenDateTime
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/FromAddress
  :cognitect.aws.pinpoint-email/Identity)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/ProjectedVolume
  :cognitect.aws.pinpoint-email/Volume)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/DeleteRate
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityCampaign/CampaignId
  :cognitect.aws.pinpoint-email/CampaignId)

(s/def
  :cognitect.aws.pinpoint-email.DkimAttributes/SigningEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def :cognitect.aws.pinpoint-email.DkimAttributes/Status :cognitect.aws.pinpoint-email/DkimStatus)

(s/def
  :cognitect.aws.pinpoint-email.DkimAttributes/Tokens
  :cognitect.aws.pinpoint-email/DnsTokenList)

(s/def
  :cognitect.aws.pinpoint-email.GetDomainStatisticsReportResponse/OverallVolume
  :cognitect.aws.pinpoint-email/OverallVolume)

(s/def
  :cognitect.aws.pinpoint-email.GetDomainStatisticsReportResponse/DailyVolumes
  :cognitect.aws.pinpoint-email/DailyVolumes)

(s/def
  :cognitect.aws.pinpoint-email.CloudWatchDestination/DimensionConfigurations
  :cognitect.aws.pinpoint-email/CloudWatchDimensionConfigurations)

(s/def
  :cognitect.aws.pinpoint-email.UpdateConfigurationSetEventDestinationRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.UpdateConfigurationSetEventDestinationRequest/EventDestinationName
  :cognitect.aws.pinpoint-email/EventDestinationName)

(s/def
  :cognitect.aws.pinpoint-email.UpdateConfigurationSetEventDestinationRequest/EventDestination
  :cognitect.aws.pinpoint-email/EventDestinationDefinition)

(s/def
  :cognitect.aws.pinpoint-email.ListEmailIdentitiesRequest/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.ListEmailIdentitiesRequest/PageSize
  :cognitect.aws.pinpoint-email/MaxItems)

(s/def
  :cognitect.aws.pinpoint-email.TrackingOptions/CustomRedirectDomain
  :cognitect.aws.pinpoint-email/CustomRedirectDomain)

(s/def
  :cognitect.aws.pinpoint-email.PutEmailIdentityFeedbackAttributesRequest/EmailIdentity
  :cognitect.aws.pinpoint-email/Identity)

(s/def
  :cognitect.aws.pinpoint-email.PutEmailIdentityFeedbackAttributesRequest/EmailForwardingEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def :cognitect.aws.pinpoint-email.Body/Text :cognitect.aws.pinpoint-email/Content)

(s/def :cognitect.aws.pinpoint-email.Body/Html :cognitect.aws.pinpoint-email/Content)

(s/def
  :cognitect.aws.pinpoint-email.ListEmailIdentitiesResponse/EmailIdentities
  :cognitect.aws.pinpoint-email/IdentityInfoList)

(s/def
  :cognitect.aws.pinpoint-email.ListEmailIdentitiesResponse/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.pinpoint-email/AmazonResourceName)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityTrackingOption/Domain
  :cognitect.aws.pinpoint-email/Domain)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityTrackingOption/SubscriptionStartDate
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.DomainDeliverabilityTrackingOption/InboxPlacementTrackingOption
  :cognitect.aws.pinpoint-email/InboxPlacementTrackingOption)

(s/def
  :cognitect.aws.pinpoint-email.GetAccountResponse/SendQuota
  :cognitect.aws.pinpoint-email/SendQuota)

(s/def
  :cognitect.aws.pinpoint-email.GetAccountResponse/SendingEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.GetAccountResponse/DedicatedIpAutoWarmupEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.GetAccountResponse/EnforcementStatus
  :cognitect.aws.pinpoint-email/GeneralEnforcementStatus)

(s/def
  :cognitect.aws.pinpoint-email.GetAccountResponse/ProductionAccessEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.GetDomainDeliverabilityCampaignRequest/CampaignId
  :cognitect.aws.pinpoint-email/CampaignId)

(s/def
  :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/TrackingOptions
  :cognitect.aws.pinpoint-email/TrackingOptions)

(s/def
  :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/DeliveryOptions
  :cognitect.aws.pinpoint-email/DeliveryOptions)

(s/def
  :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/ReputationOptions
  :cognitect.aws.pinpoint-email/ReputationOptions)

(s/def
  :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/SendingOptions
  :cognitect.aws.pinpoint-email/SendingOptions)

(s/def
  :cognitect.aws.pinpoint-email.GetConfigurationSetResponse/Tags
  :cognitect.aws.pinpoint-email/TagList)

(s/def
  :cognitect.aws.pinpoint-email.OverallVolume/VolumeStatistics
  :cognitect.aws.pinpoint-email/VolumeStatistics)

(s/def
  :cognitect.aws.pinpoint-email.OverallVolume/ReadRatePercent
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.OverallVolume/DomainIspPlacements
  :cognitect.aws.pinpoint-email/DomainIspPlacements)

(s/def
  :cognitect.aws.pinpoint-email.SendQuota/Max24HourSend
  :cognitect.aws.pinpoint-email/Max24HourSend)

(s/def
  :cognitect.aws.pinpoint-email.SendQuota/MaxSendRate
  :cognitect.aws.pinpoint-email/MaxSendRate)

(s/def
  :cognitect.aws.pinpoint-email.SendQuota/SentLast24Hours
  :cognitect.aws.pinpoint-email/SentLast24Hours)

(s/def
  :cognitect.aws.pinpoint-email.DeliverabilityTestReport/ReportId
  :cognitect.aws.pinpoint-email/ReportId)

(s/def
  :cognitect.aws.pinpoint-email.DeliverabilityTestReport/ReportName
  :cognitect.aws.pinpoint-email/ReportName)

(s/def
  :cognitect.aws.pinpoint-email.DeliverabilityTestReport/Subject
  :cognitect.aws.pinpoint-email/DeliverabilityTestSubject)

(s/def
  :cognitect.aws.pinpoint-email.DeliverabilityTestReport/FromEmailAddress
  :cognitect.aws.pinpoint-email/EmailAddress)

(s/def
  :cognitect.aws.pinpoint-email.DeliverabilityTestReport/CreateDate
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.DeliverabilityTestReport/DeliverabilityTestStatus
  :cognitect.aws.pinpoint-email/DeliverabilityTestStatus)

(s/def :cognitect.aws.pinpoint-email.GetDedicatedIpRequest/Ip :cognitect.aws.pinpoint-email/Ip)

(s/def
  :cognitect.aws.pinpoint-email.PutConfigurationSetReputationOptionsRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.PutConfigurationSetReputationOptionsRequest/ReputationMetricsEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.KinesisFirehoseDestination/IamRoleArn
  :cognitect.aws.pinpoint-email/AmazonResourceName)

(s/def
  :cognitect.aws.pinpoint-email.KinesisFirehoseDestination/DeliveryStreamArn
  :cognitect.aws.pinpoint-email/AmazonResourceName)

(s/def
  :cognitect.aws.pinpoint-email.SendingOptions/SendingEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.EventDestination/Name
  :cognitect.aws.pinpoint-email/EventDestinationName)

(s/def :cognitect.aws.pinpoint-email.EventDestination/Enabled :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.EventDestination/MatchingEventTypes
  :cognitect.aws.pinpoint-email/EventTypes)

(s/def
  :cognitect.aws.pinpoint-email.EventDestination/KinesisFirehoseDestination
  :cognitect.aws.pinpoint-email/KinesisFirehoseDestination)

(s/def
  :cognitect.aws.pinpoint-email.EventDestination/CloudWatchDestination
  :cognitect.aws.pinpoint-email/CloudWatchDestination)

(s/def
  :cognitect.aws.pinpoint-email.EventDestination/SnsDestination
  :cognitect.aws.pinpoint-email/SnsDestination)

(s/def
  :cognitect.aws.pinpoint-email.EventDestination/PinpointDestination
  :cognitect.aws.pinpoint-email/PinpointDestination)

(s/def
  :cognitect.aws.pinpoint-email.PlacementStatistics/InboxPercentage
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.PlacementStatistics/SpamPercentage
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.PlacementStatistics/MissingPercentage
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.PlacementStatistics/SpfPercentage
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.PlacementStatistics/DkimPercentage
  :cognitect.aws.pinpoint-email/Percentage)

(s/def
  :cognitect.aws.pinpoint-email.GetBlacklistReportsResponse/BlacklistReport
  :cognitect.aws.pinpoint-email/BlacklistReport)

(s/def
  :cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportRequest/ReportName
  :cognitect.aws.pinpoint-email/ReportName)

(s/def
  :cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportRequest/FromEmailAddress
  :cognitect.aws.pinpoint-email/EmailAddress)

(s/def
  :cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportRequest/Content
  :cognitect.aws.pinpoint-email/EmailContent)

(s/def
  :cognitect.aws.pinpoint-email.CreateDeliverabilityTestReportRequest/Tags
  :cognitect.aws.pinpoint-email/TagList)

(s/def
  :cognitect.aws.pinpoint-email.InboxPlacementTrackingOption/Global
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.InboxPlacementTrackingOption/TrackedIsps
  :cognitect.aws.pinpoint-email/IspNameList)

(s/def
  :cognitect.aws.pinpoint-email.ReputationOptions/ReputationMetricsEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.ReputationOptions/LastFreshStart
  :cognitect.aws.pinpoint-email/LastFreshStart)

(s/def
  :cognitect.aws.pinpoint-email.PutDeliverabilityDashboardOptionRequest/DashboardEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.PutDeliverabilityDashboardOptionRequest/SubscribedDomains
  :cognitect.aws.pinpoint-email/DomainDeliverabilityTrackingOptions)

(s/def
  :cognitect.aws.pinpoint-email.PinpointDestination/ApplicationArn
  :cognitect.aws.pinpoint-email/AmazonResourceName)

(s/def
  :cognitect.aws.pinpoint-email.GetDomainDeliverabilityCampaignResponse/DomainDeliverabilityCampaign
  :cognitect.aws.pinpoint-email/DomainDeliverabilityCampaign)

(s/def
  :cognitect.aws.pinpoint-email.UntagResourceRequest/ResourceArn
  :cognitect.aws.pinpoint-email/AmazonResourceName)

(s/def
  :cognitect.aws.pinpoint-email.UntagResourceRequest/TagKeys
  :cognitect.aws.pinpoint-email/TagKeyList)

(s/def
  :cognitect.aws.pinpoint-email.GetBlacklistReportsRequest/BlacklistItemNames
  :cognitect.aws.pinpoint-email/BlacklistItemNames)

(s/def
  :cognitect.aws.pinpoint-email.ListDedicatedIpPoolsResponse/DedicatedIpPools
  :cognitect.aws.pinpoint-email/ListOfDedicatedIpPools)

(s/def
  :cognitect.aws.pinpoint-email.ListDedicatedIpPoolsResponse/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.SendEmailResponse/MessageId
  :cognitect.aws.pinpoint-email/OutboundMessageId)

(s/def :cognitect.aws.pinpoint-email.MessageTag/Name :cognitect.aws.pinpoint-email/MessageTagName)

(s/def :cognitect.aws.pinpoint-email.MessageTag/Value :cognitect.aws.pinpoint-email/MessageTagValue)

(s/def
  :cognitect.aws.pinpoint-email.ListDeliverabilityTestReportsRequest/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.ListDeliverabilityTestReportsRequest/PageSize
  :cognitect.aws.pinpoint-email/MaxItems)

(s/def
  :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsResponse/DomainDeliverabilityCampaigns
  :cognitect.aws.pinpoint-email/DomainDeliverabilityCampaignList)

(s/def
  :cognitect.aws.pinpoint-email.ListDomainDeliverabilityCampaignsResponse/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.MailFromAttributes/MailFromDomain
  :cognitect.aws.pinpoint-email/MailFromDomainName)

(s/def
  :cognitect.aws.pinpoint-email.MailFromAttributes/MailFromDomainStatus
  :cognitect.aws.pinpoint-email/MailFromDomainStatus)

(s/def
  :cognitect.aws.pinpoint-email.MailFromAttributes/BehaviorOnMxFailure
  :cognitect.aws.pinpoint-email/BehaviorOnMxFailure)

(s/def
  :cognitect.aws.pinpoint-email.DeliveryOptions/TlsPolicy
  :cognitect.aws.pinpoint-email/TlsPolicy)

(s/def
  :cognitect.aws.pinpoint-email.DeliveryOptions/SendingPoolName
  :cognitect.aws.pinpoint-email/PoolName)

(s/def
  :cognitect.aws.pinpoint-email.VolumeStatistics/InboxRawCount
  :cognitect.aws.pinpoint-email/Volume)

(s/def
  :cognitect.aws.pinpoint-email.VolumeStatistics/SpamRawCount
  :cognitect.aws.pinpoint-email/Volume)

(s/def
  :cognitect.aws.pinpoint-email.VolumeStatistics/ProjectedInbox
  :cognitect.aws.pinpoint-email/Volume)

(s/def
  :cognitect.aws.pinpoint-email.VolumeStatistics/ProjectedSpam
  :cognitect.aws.pinpoint-email/Volume)

(s/def
  :cognitect.aws.pinpoint-email.EventDestinationDefinition/Enabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.EventDestinationDefinition/MatchingEventTypes
  :cognitect.aws.pinpoint-email/EventTypes)

(s/def
  :cognitect.aws.pinpoint-email.EventDestinationDefinition/KinesisFirehoseDestination
  :cognitect.aws.pinpoint-email/KinesisFirehoseDestination)

(s/def
  :cognitect.aws.pinpoint-email.EventDestinationDefinition/CloudWatchDestination
  :cognitect.aws.pinpoint-email/CloudWatchDestination)

(s/def
  :cognitect.aws.pinpoint-email.EventDestinationDefinition/SnsDestination
  :cognitect.aws.pinpoint-email/SnsDestination)

(s/def
  :cognitect.aws.pinpoint-email.EventDestinationDefinition/PinpointDestination
  :cognitect.aws.pinpoint-email/PinpointDestination)

(s/def
  :cognitect.aws.pinpoint-email.DeleteConfigurationSetRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-email/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-email.PutDedicatedIpWarmupAttributesRequest/Ip
  :cognitect.aws.pinpoint-email/Ip)

(s/def
  :cognitect.aws.pinpoint-email.PutDedicatedIpWarmupAttributesRequest/WarmupPercentage
  :cognitect.aws.pinpoint-email/Percentage100Wrapper)

(s/def
  :cognitect.aws.pinpoint-email.ListTagsForResourceResponse/Tags
  :cognitect.aws.pinpoint-email/TagList)

(s/def
  :cognitect.aws.pinpoint-email.PutEmailIdentityDkimAttributesRequest/EmailIdentity
  :cognitect.aws.pinpoint-email/Identity)

(s/def
  :cognitect.aws.pinpoint-email.PutEmailIdentityDkimAttributesRequest/SigningEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def :cognitect.aws.pinpoint-email.Content/Data :cognitect.aws.pinpoint-email/MessageData)

(s/def :cognitect.aws.pinpoint-email.Content/Charset :cognitect.aws.pinpoint-email/Charset)

(s/def
  :cognitect.aws.pinpoint-email.CloudWatchDimensionConfiguration/DimensionName
  :cognitect.aws.pinpoint-email/DimensionName)

(s/def
  :cognitect.aws.pinpoint-email.CloudWatchDimensionConfiguration/DimensionValueSource
  :cognitect.aws.pinpoint-email/DimensionValueSource)

(s/def
  :cognitect.aws.pinpoint-email.CloudWatchDimensionConfiguration/DefaultDimensionValue
  :cognitect.aws.pinpoint-email/DefaultDimensionValue)

(s/def
  :cognitect.aws.pinpoint-email.GetDomainStatisticsReportRequest/Domain
  :cognitect.aws.pinpoint-email/Identity)

(s/def
  :cognitect.aws.pinpoint-email.GetDomainStatisticsReportRequest/StartDate
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.GetDomainStatisticsReportRequest/EndDate
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.GetDedicatedIpsResponse/DedicatedIps
  :cognitect.aws.pinpoint-email/DedicatedIpList)

(s/def
  :cognitect.aws.pinpoint-email.GetDedicatedIpsResponse/NextToken
  :cognitect.aws.pinpoint-email/NextToken)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/DashboardEnabled
  :cognitect.aws.pinpoint-email/Enabled)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/SubscriptionExpiryDate
  :cognitect.aws.pinpoint-email/Timestamp)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/AccountStatus
  :cognitect.aws.pinpoint-email/DeliverabilityDashboardAccountStatus)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/ActiveSubscribedDomains
  :cognitect.aws.pinpoint-email/DomainDeliverabilityTrackingOptions)

(s/def
  :cognitect.aws.pinpoint-email.GetDeliverabilityDashboardOptionsResponse/PendingExpirationSubscribedDomains
  :cognitect.aws.pinpoint-email/DomainDeliverabilityTrackingOptions)

(s/def :cognitect.aws.pinpoint-email.EmailContent/Simple :cognitect.aws.pinpoint-email/Message)

(s/def :cognitect.aws.pinpoint-email.EmailContent/Raw :cognitect.aws.pinpoint-email/RawMessage)

(s/def :cognitect.aws.pinpoint-email.EmailContent/Template :cognitect.aws.pinpoint-email/Template)

