;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.pinpoint-sms-voice-v2.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PutKeywordRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PutKeywordRequest/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordRequest/Keyword
     :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordRequest/KeywordMessage]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PutKeywordRequest/KeywordAction]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/EventType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"VOICE_ALL" "TEXT_ALL" "TEXT_INVALID" "VOICE_COMPLETED" "TEXT_QUEUED" "TEXT_SPAM"
        "VOICE_RINGING" "TEXT_INVALID_MESSAGE" "VOICE_ANSWERED" "TEXT_SUCCESSFUL" "TEXT_DELIVERED"
        "TEXT_UNKNOWN" "TEXT_SENT" "TEXT_CARRIER_BLOCKED" "VOICE_FAILED" "TEXT_TTL_EXPIRED"
        "VOICE_NO_ANSWER" "TEXT_PENDING" "TEXT_CARRIER_UNREACHABLE" "ALL" "VOICE_BUSY"
        "TEXT_UNREACHABLE" "VOICE_TTL_EXPIRED" "TEXT_BLOCKED" "VOICE_INITIATED"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestinationList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/EventDestination))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/CloudWatchLogsDestination
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CloudWatchLogsDestination/IamRoleArn
     :cognitect.aws.pinpoint-sms-voice-v2.CloudWatchLogsDestination/LogGroupArn]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteTextMessageSpendLimitOverrideResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteTextMessageSpendLimitOverrideResult/MonthlyLimit]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/CreatePoolRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/IsoCountryCode
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/MessageType]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/Tags
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/ClientToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ContextValue
  (s/spec #(re-matches (re-pattern "\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.TagResourceRequest/ResourceArn
     :cognitect.aws.pinpoint-sms-voice-v2.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode
  (s/spec #(re-matches (re-pattern "[A-Z]{2}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/NumberType
  (s/spec string? :gen #(s/gen #{"LONG_CODE" "TEN_DLC" "TOLL_FREE" "SHORT_CODE"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetFilterName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"default-message-type" "default-sender-id" "event-destination-name"
        "matching-event-types"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordFilter
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.KeywordFilter/Name
     :cognitect.aws.pinpoint-sms-voice-v2.KeywordFilter/Values]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdFilterList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/SenderIdFilter :min-count 0 :max-count 20))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameOrArn
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_:/-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolInformationList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/PoolInformation))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SnsTopicArn
  (s/spec #(re-matches (re-pattern "arn:\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordInformationList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/KeywordInformation))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/AccountAttributeList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/AccountAttribute))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/Tag
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.Tag/Key :cognitect.aws.pinpoint-sms-voice-v2.Tag/Value]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/CreateConfigurationSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetRequest/ConfigurationSetName]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetRequest/Tags
     :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetRequest/ClientToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/MonthlyLimit
  (s/spec (s/and int? #(<= 0 % 1000000000)) :gen #(gen/choose 0 1000000000)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdAndCountry
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SenderIdAndCountry/SenderId
     :cognitect.aws.pinpoint-sms-voice-v2.SenderIdAndCountry/IsoCountryCode]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeOptedOutNumbersRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/OptOutListName]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/Filters
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/OptedOutNumbers
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/NonEmptyTagList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/Tag :min-count 1 :max-count 200))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolOriginationIdentitiesFilter
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PoolOriginationIdentitiesFilter/Name
     :cognitect.aws.pinpoint-sms-voice-v2.PoolOriginationIdentitiesFilter/Values]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SpendLimitName
  (s/spec
    string?
    :gen
    #(s/gen #{"VOICE_MESSAGE_MONTHLY_SPEND_LIMIT" "TEXT_MESSAGE_MONTHLY_SPEND_LIMIT"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeKeywordsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/OriginationIdentity]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/Filters
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/Keywords
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/CreateConfigurationSetResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetResult/Tags
     :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetResult/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetResult/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteOptedOutNumberRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberRequest/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberRequest/OptedOutNumber]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameList
  (s/coll-of
    :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn
    :min-count
    0
    :max-count
    5))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/UpdatePhoneNumberResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/NumberType
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/PhoneNumberArn
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/TwoWayChannelArn
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/Status
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/NumberCapabilities
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/MonthlyLeasingPrice
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/IsoCountryCode
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/TwoWayEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/PhoneNumberId
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/PhoneNumber]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordFilterName
  (s/spec string? :gen #(s/gen #{"keyword-action"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolStatus
  (s/spec string? :gen #(s/gen #{"DELETING" "CREATING" "ACTIVE"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SnsDestination
  (s/keys :req-un [:cognitect.aws.pinpoint-sms-voice-v2.SnsDestination/TopicArn]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberFilterList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberFilter :min-count 0 :max-count 20))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SenderId
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/LogGroupArn
  (s/spec #(re-matches (re-pattern "arn:\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_:/-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolInformation
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/PoolArn
     :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/Status
     :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/TwoWayEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/SharedRoutesEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/CreatedTimestamp]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/TwoWayChannelArn]))

(s/def :cognitect.aws.pinpoint-sms-voice-v2/DeleteTextMessageSpendLimitOverrideRequest (s/keys))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/RequestPhoneNumberRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/IsoCountryCode
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/NumberCapabilities
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/NumberType]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/Tags
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/RegistrationId
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/ClientToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberInformationList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberInformation))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeSenderIdsResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsResult/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsResult/SenderIds]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeConfigurationSetsResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsResult/ConfigurationSets
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsResult/NextToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteOptOutListResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteOptOutListResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptOutListResult/OptOutListArn
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptOutListResult/OptOutListName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/TagList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/Tag :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SpendLimitList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/SpendLimit))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ReleasePhoneNumberRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberRequest/PhoneNumberId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteKeywordRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordRequest/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordRequest/Keyword]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/FilterValueList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/FilterValue :min-count 1 :max-count 20))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeAccountLimitsResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountLimitsResult/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountLimitsResult/AccountLimits]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/AccountLimitList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/AccountLimit))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeliveryStreamArn
  (s/spec #(re-matches (re-pattern "arn:\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ListTagsForResourceResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.ListTagsForResourceResult/Tags
     :cognitect.aws.pinpoint-sms-voice-v2.ListTagsForResourceResult/ResourceArn]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeConfigurationSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsRequest/ConfigurationSetNames
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsRequest/Filters
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeAccountLimitsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountLimitsRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountLimitsRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordAction
  (s/spec string? :gen #(s/gen #{"OPT_IN" "OPT_OUT" "AUTOMATIC_RESPONSE"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/VoiceMessageOriginationIdentity
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_:/\\+-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/AssociateOriginationIdentityResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/PoolArn
     :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/OriginationIdentityArn
     :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/IsoCountryCode]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SetTextMessageSpendLimitOverrideRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SetTextMessageSpendLimitOverrideRequest/MonthlyLimit]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteDefaultSenderIdResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultSenderIdResult/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultSenderIdResult/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultSenderIdResult/SenderId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/UpdateEventDestinationResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationResult/EventDestination
     :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationResult/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationResult/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberIdOrArn
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_:/-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneOrPoolIdOrArn
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_:/-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/RequestPhoneNumberResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/NumberType
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/PhoneNumberArn
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/Tags
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/TwoWayChannelArn
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/Status
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/NumberCapabilities
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/MonthlyLeasingPrice
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/IsoCountryCode
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/TwoWayEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/PhoneNumberId
     :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/PhoneNumber]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/UpdatePoolRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/PoolId]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/TwoWayChannelArn
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/SharedRoutesEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/TwoWayEnabled]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeSenderIdsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsRequest/SenderIds
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsRequest/Filters
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsRequest/MaxResults]))

(s/def :cognitect.aws.pinpoint-sms-voice-v2/Boolean boolean?)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeOptOutListsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsRequest/OptOutListNames
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberIdList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberIdOrArn :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutNumberList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdFilterName
  (s/spec string? :gen #(s/gen #{"message-type" "iso-country-code" "sender-id"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/AmazonResourceName
  (s/spec #(re-matches (re-pattern "arn:[A-Za-z0-9_:/-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/CreateOptOutListResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListResult/Tags
     :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListResult/OptOutListArn
     :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListResult/OptOutListName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/CreateEventDestinationResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationResult/EventDestination
     :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationResult/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationResult/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SetVoiceMessageSpendLimitOverrideRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SetVoiceMessageSpendLimitOverrideRequest/MonthlyLimit]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ReleasePhoneNumberResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/NumberType
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/PhoneNumberArn
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/TwoWayChannelArn
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/Status
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/NumberCapabilities
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/MonthlyLeasingPrice
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/IsoCountryCode
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/TwoWayEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/PhoneNumberId
     :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/PhoneNumber]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ListPoolOriginationIdentitiesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesRequest/PoolId]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesRequest/Filters
     :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutNumberInformationList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/OptedOutNumberInformation))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/IamRoleArn
  (s/spec #(re-matches (re-pattern "arn:\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveLong
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken
  (s/spec #(re-matches (re-pattern ".+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/NumberCapabilityList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/NumberCapability :min-count 1 :max-count 2))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolIdList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/PoolIdOrArn :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/NumberCapability
  (s/spec string? :gen #(s/gen #{"VOICE" "SMS"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolFilter
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PoolFilter/Name
     :cognitect.aws.pinpoint-sms-voice-v2.PoolFilter/Values]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteEventDestinationResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationResult/EventDestination
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationResult/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationResult/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetFilterList
  (s/coll-of
    :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetFilter
    :min-count
    0
    :max-count
    20))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteDefaultMessageTypeRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultMessageTypeRequest/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/MaxPrice
  (s/spec #(re-matches (re-pattern "[0-9]{0,2}\\.[0-9]{1,5}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DestinationCountryParameterKey
  (s/spec string? :gen #(s/gen #{"IN_ENTITY_ID" "IN_TEMPLATE_ID"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/TagValue
  (s/spec #(re-matches (re-pattern ".*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeAccountAttributesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountAttributesRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountAttributesRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteDefaultMessageTypeResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultMessageTypeResult/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultMessageTypeResult/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultMessageTypeResult/MessageType]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PutKeywordResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/KeywordAction
     :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/OriginationIdentityArn
     :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/Keyword
     :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/KeywordMessage]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SetDefaultMessageTypeResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeResult/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeResult/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeResult/MessageType]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeletePoolResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/PoolArn
     :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/TwoWayChannelArn
     :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/Status
     :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/SharedRoutesEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/TwoWayEnabled]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberFilterName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"self-managed-opt-outs-enabled" "message-type" "number-type" "status" "opt-out-list-name"
        "deletion-protection-enabled" "two-way-enabled" "number-capability" "iso-country-code"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutFilterName
  (s/spec string? :gen #(s/gen #{"end-user-opted-out"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-sms-voice-v2.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/Keyword
  (s/spec #(re-matches (re-pattern "[ \\S]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SetDefaultMessageTypeRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeRequest/MessageType]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteDefaultSenderIdRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultSenderIdRequest/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeKeywordsResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsResult/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsResult/OriginationIdentityArn
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsResult/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsResult/Keywords]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/SenderIdAndCountry :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolOriginationIdentitiesFilterList
  (s/coll-of
    :cognitect.aws.pinpoint-sms-voice-v2/PoolOriginationIdentitiesFilter
    :min-count
    0
    :max-count
    20))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/VoiceMessageBody
  (s/spec #(re-matches (re-pattern "(?!\\s*$)[\\s\\S]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/NumberStatus
  (s/spec string? :gen #(s/gen #{"PENDING" "ACTIVE" "DELETED" "ASSOCIATING" "DISASSOCIATING"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ContextKey
  (s/spec #(re-matches (re-pattern "\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetFilter
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetFilter/Name
     :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetFilter/Values]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber
  (s/spec #(re-matches (re-pattern "\\+?[1-9][0-9]{1,18}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/VoiceId
  (s/spec
    string?
    :gen
    #(s/gen
      #{"GWYNETH" "CONCHITA" "CARMEN" "MAXIM" "LUCIA" "VICKI" "RUBEN" "INES" "PENELOPE" "GERAINT"
        "JOEY" "RAVEENA" "ASTRID" "KARL" "VITORIA" "CAMILA" "CRISTIANO" "TAKUMI" "MIZUKI" "JUSTIN"
        "LUPE" "MIGUEL" "ZHIYU" "LIV" "MADS" "MIA" "CHANTAL" "NAJA" "RUSSELL" "LEA" "AMY" "SEOYEON"
        "ZEINA" "CELINE" "EMMA" "GIORGIO" "KIMBERLY" "TATYANA" "JOANNA" "SALLI" "EWA" "ENRIQUE"
        "RICARDO" "LOTTE" "DORA" "BRIAN" "KENDRA" "FILIZ" "JAN" "BIANCA" "MAJA" "CARLA" "NICOLE"
        "HANS" "JACEK" "MARLENE" "IVY" "MATTHEW" "MATHIEU"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/AssociateOriginationIdentityRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityRequest/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityRequest/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityRequest/IsoCountryCode]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityRequest/ClientToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeOptedOutNumbersResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersResult/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersResult/OptOutListArn
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersResult/OptedOutNumbers
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersResult/OptOutListName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SendVoiceMessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/DestinationPhoneNumber
     :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/OriginationIdentity]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/DryRun
     :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/MessageBodyTextType
     :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/Context
     :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/TimeToLive
     :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/MessageBody
     :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/MaxPricePerMinute
     :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/VoiceId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/RequestableNumberType
  (s/spec string? :gen #(s/gen #{"LONG_CODE" "TEN_DLC" "TOLL_FREE"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/UpdatePoolResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/PoolArn
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/TwoWayChannelArn
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/Status
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/SharedRoutesEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/TwoWayEnabled]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/UpdateEventDestinationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/EventDestinationName]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/SnsDestination
     :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/CloudWatchLogsDestination
     :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/Enabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/MatchingEventTypes
     :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/KinesisFirehoseDestination]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SendTextMessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/DestinationPhoneNumber]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/DryRun
     :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/Context
     :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/TimeToLive
     :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/MessageBody
     :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/Keyword
     :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/DestinationCountryParameters
     :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/MaxPrice]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/KinesisFirehoseDestination
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.KinesisFirehoseDestination/IamRoleArn
     :cognitect.aws.pinpoint-sms-voice-v2.KinesisFirehoseDestination/DeliveryStreamArn]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteOptedOutNumberResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/OptOutListArn
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/OptedOutNumber
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/OptedOutTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/EndUserOptedOut]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutNumberInformation
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.OptedOutNumberInformation/OptedOutNumber
     :cognitect.aws.pinpoint-sms-voice-v2.OptedOutNumberInformation/OptedOutTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.OptedOutNumberInformation/EndUserOptedOut]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestination
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.EventDestination/EventDestinationName
     :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/Enabled
     :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/MatchingEventTypes]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.EventDestination/SnsDestination
     :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/CloudWatchLogsDestination
     :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/KinesisFirehoseDestination]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetInformation
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/EventDestinations
     :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/CreatedTimestamp]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/DefaultSenderId
     :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/DefaultMessageType]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberInformation
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/PhoneNumberArn
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/PhoneNumber
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/Status
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/IsoCountryCode
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/NumberCapabilities
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/NumberType
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/MonthlyLeasingPrice
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/TwoWayEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/CreatedTimestamp]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/TwoWayChannelArn
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/PhoneNumberId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SetTextMessageSpendLimitOverrideResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SetTextMessageSpendLimitOverrideResult/MonthlyLimit]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordMessage
  (s/spec #(re-matches (re-pattern "(?!\\s*$)[\\s\\S]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/UpdatePhoneNumberRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/PhoneNumberId]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/TwoWayChannelArn
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/TwoWayEnabled]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/AccountAttribute
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.AccountAttribute/Name
     :cognitect.aws.pinpoint-sms-voice-v2.AccountAttribute/Value]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/VoiceMessageBodyTextType
  (s/spec string? :gen #(s/gen #{"TEXT" "SSML"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SetDefaultSenderIdResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdResult/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdResult/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdResult/SenderId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/CreateEventDestinationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/EventDestinationName
     :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/MatchingEventTypes]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/SnsDestination
     :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/CloudWatchLogsDestination
     :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/KinesisFirehoseDestination
     :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/ClientToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType
  (s/spec string? :gen #(s/gen #{"TRANSACTIONAL" "PROMOTIONAL"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteKeywordResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/KeywordAction
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/OriginationIdentityArn
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/Keyword
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/KeywordMessage]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeSpendLimitsResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeSpendLimitsResult/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeSpendLimitsResult/SpendLimits]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/Keyword :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeSpendLimitsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeSpendLimitsRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeSpendLimitsRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribePhoneNumbersResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersResult/PhoneNumbers
     :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersResult/NextToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribePoolsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsRequest/Filters
     :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsRequest/PoolIds
     :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetInformationList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetInformation))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdInformation
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/SenderIdArn
     :cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/SenderId
     :cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/IsoCountryCode
     :cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/MessageTypes
     :cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/MonthlyLeasingPrice]))

(s/def :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean boolean?)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListInformation
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.OptOutListInformation/OptOutListArn
     :cognitect.aws.pinpoint-sms-voice-v2.OptOutListInformation/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.OptOutListInformation/CreatedTimestamp]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdInformationList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/SenderIdInformation))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ContextMap
  (s/map-of
    :cognitect.aws.pinpoint-sms-voice-v2/ContextKey
    :cognitect.aws.pinpoint-sms-voice-v2/ContextValue
    :min-count
    0
    :max-count
    5))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OriginationIdentityMetadataList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/OriginationIdentityMetadata))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListInformationList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/OptOutListInformation))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdFilter
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SenderIdFilter/Name
     :cognitect.aws.pinpoint-sms-voice-v2.SenderIdFilter/Values]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/AccountLimitName
  (s/spec string? :gen #(s/gen #{"PHONE_NUMBERS" "OPT_OUT_LISTS" "POOLS" "CONFIGURATION_SETS"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn
  (s/spec #(re-matches (re-pattern "arn:\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DestinationCountryParameterValue
  (s/spec #(re-matches (re-pattern "\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.UntagResourceRequest/ResourceArn
     :cognitect.aws.pinpoint-sms-voice-v2.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/TagKey
  (s/spec #(re-matches (re-pattern ".+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneOrSenderIdOrArn
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_:/-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/TextMessageBody
  (s/spec #(re-matches (re-pattern "(?!\\s*$)[\\s\\S]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.pinpoint-sms-voice-v2/TagResourceResult (s/keys))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolFilterList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/PoolFilter :min-count 0 :max-count 20))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ClientToken
  (s/spec #(re-matches (re-pattern "[!-~]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteConfigurationSetResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/ConfigurationSetArn
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/DefaultSenderId
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/EventDestinations
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/DefaultMessageType]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OriginationIdentityMetadata
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.OriginationIdentityMetadata/OriginationIdentityArn
     :cognitect.aws.pinpoint-sms-voice-v2.OriginationIdentityMetadata/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.OriginationIdentityMetadata/IsoCountryCode
     :cognitect.aws.pinpoint-sms-voice-v2.OriginationIdentityMetadata/NumberCapabilities]))

(s/def :cognitect.aws.pinpoint-sms-voice-v2/Timestamp inst?)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeOptOutListsResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsResult/OptOutLists
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsResult/NextToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DestinationCountryParameters
  (s/map-of
    :cognitect.aws.pinpoint-sms-voice-v2/DestinationCountryParameterKey
    :cognitect.aws.pinpoint-sms-voice-v2/DestinationCountryParameterValue
    :min-count
    0
    :max-count
    10))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/EventTypeList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/EventType :min-count 1 :max-count 25))

(s/def :cognitect.aws.pinpoint-sms-voice-v2/UntagResourceResult (s/keys))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SendVoiceMessageResult
  (s/keys :opt-un [:cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageResult/MessageId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeletePoolRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-sms-voice-v2.DeletePoolRequest/PoolId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/TimeToLive
  (s/spec (s/and int? #(<= 5 % 259200)) :gen #(gen/choose 5 259200)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SendTextMessageResult
  (s/keys :opt-un [:cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageResult/MessageId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordFilterList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/KeywordFilter :min-count 0 :max-count 20))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PutOptedOutNumberRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberRequest/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberRequest/OptedOutNumber]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/RegistrationId
  (s/spec #(re-matches (re-pattern "\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberFilter
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberFilter/Name
     :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberFilter/Values]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_-]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.pinpoint-sms-voice-v2/DeleteVoiceMessageSpendLimitOverrideRequest (s/keys))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteEventDestinationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationRequest/EventDestinationName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordInformation
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.KeywordInformation/Keyword
     :cognitect.aws.pinpoint-sms-voice-v2.KeywordInformation/KeywordMessage
     :cognitect.aws.pinpoint-sms-voice-v2.KeywordInformation/KeywordAction]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/CreatePoolResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/CreatedTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/PoolArn
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/Tags
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/TwoWayChannelArn
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/Status
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/SelfManagedOptOutsEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/MessageType
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/SharedRoutesEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/DeletionProtectionEnabled
     :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/TwoWayEnabled]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/AccountLimit
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.AccountLimit/Name
     :cognitect.aws.pinpoint-sms-voice-v2.AccountLimit/Used
     :cognitect.aws.pinpoint-sms-voice-v2.AccountLimit/Max]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/MessageTypeList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/MessageType))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteConfigurationSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetRequest/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SpendLimit
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SpendLimit/Name
     :cognitect.aws.pinpoint-sms-voice-v2.SpendLimit/EnforcedLimit
     :cognitect.aws.pinpoint-sms-voice-v2.SpendLimit/MaxLimit
     :cognitect.aws.pinpoint-sms-voice-v2.SpendLimit/Overridden]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/TextMessageOriginationIdentity
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_:/\\+-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/CreateOptOutListRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListRequest/OptOutListName]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListRequest/Tags
     :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListRequest/ClientToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/FilterValue
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolOriginationIdentitiesFilterName
  (s/spec string? :gen #(s/gen #{"number-capability" "iso-country-code"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DisassociateOriginationIdentityRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityRequest/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityRequest/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityRequest/IsoCountryCode]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityRequest/ClientToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdOrArn
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_:/-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PutOptedOutNumberResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/OptOutListArn
     :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/OptedOutNumber
     :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/OptedOutTimestamp
     :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/OptOutListName
     :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/EndUserOptedOut]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameOrArn :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DisassociateOriginationIdentityResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/PoolArn
     :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/OriginationIdentity
     :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/OriginationIdentityArn
     :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/PoolId
     :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/IsoCountryCode]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutFilter
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.OptedOutFilter/Name
     :cognitect.aws.pinpoint-sms-voice-v2.OptedOutFilter/Values]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribeAccountAttributesResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountAttributesResult/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountAttributesResult/AccountAttributes]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SetDefaultSenderIdRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdRequest/SenderId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestinationName
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/ListPoolOriginationIdentitiesResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesResult/PoolArn
     :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesResult/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesResult/OriginationIdentities
     :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesResult/PoolId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/AccountAttributeName
  (s/spec string? :gen #(s/gen #{"ACCOUNT_TIER"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribePoolsResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsResult/Pools
     :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsResult/NextToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolIdOrArn
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_:/-]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.pinpoint-sms-voice-v2/String string?)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteOptOutListRequest
  (s/keys :req-un [:cognitect.aws.pinpoint-sms-voice-v2.DeleteOptOutListRequest/OptOutListName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DeleteVoiceMessageSpendLimitOverrideResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DeleteVoiceMessageSpendLimitOverrideResult/MonthlyLimit]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutFilterList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/OptedOutFilter :min-count 0 :max-count 20))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/PoolFilterName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"self-managed-opt-outs-enabled" "message-type" "shared-routes-enabled" "status"
        "opt-out-list-name" "deletion-protection-enabled" "two-way-enabled"})))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/SetVoiceMessageSpendLimitOverrideResult
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.SetVoiceMessageSpendLimitOverrideResult/MonthlyLimit]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/DescribePhoneNumbersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersRequest/PhoneNumberIds
     :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersRequest/NextToken
     :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersRequest/Filters
     :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersRequest/MaxResults]))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2/TagKeyList
  (s/coll-of :cognitect.aws.pinpoint-sms-voice-v2/TagKey :min-count 1 :max-count 200))

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordRequest/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneOrPoolIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordRequest/Keyword
  :cognitect.aws.pinpoint-sms-voice-v2/Keyword)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordRequest/KeywordMessage
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordMessage)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordRequest/KeywordAction
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordAction)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CloudWatchLogsDestination/IamRoleArn
  :cognitect.aws.pinpoint-sms-voice-v2/IamRoleArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CloudWatchLogsDestination/LogGroupArn
  :cognitect.aws.pinpoint-sms-voice-v2/LogGroupArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteTextMessageSpendLimitOverrideResult/MonthlyLimit
  :cognitect.aws.pinpoint-sms-voice-v2/MonthlyLimit)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneOrSenderIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/TagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolRequest/ClientToken
  :cognitect.aws.pinpoint-sms-voice-v2/ClientToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.TagResourceRequest/ResourceArn
  :cognitect.aws.pinpoint-sms-voice-v2/AmazonResourceName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.TagResourceRequest/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/NonEmptyTagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.KeywordFilter/Name
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordFilterName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.KeywordFilter/Values
  :cognitect.aws.pinpoint-sms-voice-v2/FilterValueList)

(s/def :cognitect.aws.pinpoint-sms-voice-v2.Tag/Key :cognitect.aws.pinpoint-sms-voice-v2/TagKey)

(s/def :cognitect.aws.pinpoint-sms-voice-v2.Tag/Value :cognitect.aws.pinpoint-sms-voice-v2/TagValue)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetRequest/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/TagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetRequest/ClientToken
  :cognitect.aws.pinpoint-sms-voice-v2/ClientToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SenderIdAndCountry/SenderId
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SenderIdAndCountry/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/OptedOutNumbers
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutNumberList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/Filters
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutFilterList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolOriginationIdentitiesFilter/Name
  :cognitect.aws.pinpoint-sms-voice-v2/PoolOriginationIdentitiesFilterName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolOriginationIdentitiesFilter/Values
  :cognitect.aws.pinpoint-sms-voice-v2/FilterValueList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneOrPoolIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/Keywords
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/Filters
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordFilterList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetResult/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetResult/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetResult/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/TagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateConfigurationSetResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberRequest/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberRequest/OptedOutNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/NumberType
  :cognitect.aws.pinpoint-sms-voice-v2/NumberType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/PhoneNumberId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/MonthlyLeasingPrice
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/PhoneNumberArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/PhoneNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/NumberCapabilities
  :cognitect.aws.pinpoint-sms-voice-v2/NumberCapabilityList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberResult/Status
  :cognitect.aws.pinpoint-sms-voice-v2/NumberStatus)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SnsDestination/TopicArn
  :cognitect.aws.pinpoint-sms-voice-v2/SnsTopicArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/SharedRoutesEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/PoolArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolInformation/Status
  :cognitect.aws.pinpoint-sms-voice-v2/PoolStatus)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/NumberType
  :cognitect.aws.pinpoint-sms-voice-v2/RequestableNumberType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/TagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/PoolIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/NumberCapabilities
  :cognitect.aws.pinpoint-sms-voice-v2/NumberCapabilityList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/ClientToken
  :cognitect.aws.pinpoint-sms-voice-v2/ClientToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/RegistrationId
  :cognitect.aws.pinpoint-sms-voice-v2/RegistrationId)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberRequest/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsResult/SenderIds
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdInformationList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsResult/ConfigurationSets
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetInformationList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptOutListResult/OptOutListArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptOutListResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptOutListResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberRequest/PhoneNumberId
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordRequest/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneOrPoolIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordRequest/Keyword
  :cognitect.aws.pinpoint-sms-voice-v2/Keyword)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountLimitsResult/AccountLimits
  :cognitect.aws.pinpoint-sms-voice-v2/AccountLimitList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountLimitsResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListTagsForResourceResult/ResourceArn
  :cognitect.aws.pinpoint-sms-voice-v2/AmazonResourceName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListTagsForResourceResult/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/TagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsRequest/ConfigurationSetNames
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsRequest/Filters
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetFilterList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeConfigurationSetsRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountLimitsRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountLimitsRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/PoolArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/OriginationIdentityArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityResult/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetTextMessageSpendLimitOverrideRequest/MonthlyLimit
  :cognitect.aws.pinpoint-sms-voice-v2/MonthlyLimit)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultSenderIdResult/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultSenderIdResult/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultSenderIdResult/SenderId
  :cognitect.aws.pinpoint-sms-voice-v2/SenderId)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationResult/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationResult/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationResult/EventDestination
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/NumberType
  :cognitect.aws.pinpoint-sms-voice-v2/RequestableNumberType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/PhoneNumberId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/MonthlyLeasingPrice
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/PhoneNumberArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/TagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/PhoneNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/NumberCapabilities
  :cognitect.aws.pinpoint-sms-voice-v2/NumberCapabilityList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.RequestPhoneNumberResult/Status
  :cognitect.aws.pinpoint-sms-voice-v2/NumberStatus)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/PoolIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/SharedRoutesEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolRequest/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsRequest/SenderIds
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsRequest/Filters
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdFilterList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSenderIdsRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsRequest/OptOutListNames
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListResult/OptOutListArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListResult/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/TagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationResult/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationResult/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationResult/EventDestination
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetVoiceMessageSpendLimitOverrideRequest/MonthlyLimit
  :cognitect.aws.pinpoint-sms-voice-v2/MonthlyLimit)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/NumberType
  :cognitect.aws.pinpoint-sms-voice-v2/NumberType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/PhoneNumberId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/MonthlyLeasingPrice
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/PhoneNumberArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/PhoneNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/NumberCapabilities
  :cognitect.aws.pinpoint-sms-voice-v2/NumberCapabilityList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ReleasePhoneNumberResult/Status
  :cognitect.aws.pinpoint-sms-voice-v2/NumberStatus)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesRequest/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/PoolIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesRequest/Filters
  :cognitect.aws.pinpoint-sms-voice-v2/PoolOriginationIdentitiesFilterList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolFilter/Name
  :cognitect.aws.pinpoint-sms-voice-v2/PoolFilterName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PoolFilter/Values
  :cognitect.aws.pinpoint-sms-voice-v2/FilterValueList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationResult/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationResult/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationResult/EventDestination
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultMessageTypeRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountAttributesRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountAttributesRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultMessageTypeResult/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultMessageTypeResult/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultMessageTypeResult/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/OriginationIdentityArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/Keyword
  :cognitect.aws.pinpoint-sms-voice-v2/Keyword)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/KeywordMessage
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordMessage)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutKeywordResult/KeywordAction
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordAction)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeResult/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeResult/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeResult/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/SharedRoutesEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/PoolArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolResult/Status
  :cognitect.aws.pinpoint-sms-voice-v2/PoolStatus)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.pinpoint-sms-voice-v2/AmazonResourceName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultMessageTypeRequest/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteDefaultSenderIdRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsResult/OriginationIdentityArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsResult/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsResult/Keywords
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordInformationList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeKeywordsResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetFilter/Name
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetFilterName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetFilter/Values
  :cognitect.aws.pinpoint-sms-voice-v2/FilterValueList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityRequest/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/PoolIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityRequest/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneOrSenderIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityRequest/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AssociateOriginationIdentityRequest/ClientToken
  :cognitect.aws.pinpoint-sms-voice-v2/ClientToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersResult/OptOutListArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersResult/OptedOutNumbers
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutNumberInformationList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptedOutNumbersResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/MaxPricePerMinute
  :cognitect.aws.pinpoint-sms-voice-v2/MaxPrice)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/DryRun
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/DestinationPhoneNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/Context
  :cognitect.aws.pinpoint-sms-voice-v2/ContextMap)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/VoiceId
  :cognitect.aws.pinpoint-sms-voice-v2/VoiceId)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/VoiceMessageOriginationIdentity)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/MessageBodyTextType
  :cognitect.aws.pinpoint-sms-voice-v2/VoiceMessageBodyTextType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/TimeToLive
  :cognitect.aws.pinpoint-sms-voice-v2/TimeToLive)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageRequest/MessageBody
  :cognitect.aws.pinpoint-sms-voice-v2/VoiceMessageBody)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/SharedRoutesEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/PoolArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePoolResult/Status
  :cognitect.aws.pinpoint-sms-voice-v2/PoolStatus)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/EventDestinationName
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestinationName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/Enabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/MatchingEventTypes
  :cognitect.aws.pinpoint-sms-voice-v2/EventTypeList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/CloudWatchLogsDestination
  :cognitect.aws.pinpoint-sms-voice-v2/CloudWatchLogsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/KinesisFirehoseDestination
  :cognitect.aws.pinpoint-sms-voice-v2/KinesisFirehoseDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdateEventDestinationRequest/SnsDestination
  :cognitect.aws.pinpoint-sms-voice-v2/SnsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/DryRun
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/DestinationPhoneNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/Context
  :cognitect.aws.pinpoint-sms-voice-v2/ContextMap)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/MaxPrice
  :cognitect.aws.pinpoint-sms-voice-v2/MaxPrice)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/Keyword
  :cognitect.aws.pinpoint-sms-voice-v2/Keyword)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/TextMessageOriginationIdentity)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/DestinationCountryParameters
  :cognitect.aws.pinpoint-sms-voice-v2/DestinationCountryParameters)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/TimeToLive
  :cognitect.aws.pinpoint-sms-voice-v2/TimeToLive)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageRequest/MessageBody
  :cognitect.aws.pinpoint-sms-voice-v2/TextMessageBody)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.KinesisFirehoseDestination/IamRoleArn
  :cognitect.aws.pinpoint-sms-voice-v2/IamRoleArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.KinesisFirehoseDestination/DeliveryStreamArn
  :cognitect.aws.pinpoint-sms-voice-v2/DeliveryStreamArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/OptOutListArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/OptedOutNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/OptedOutTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptedOutNumberResult/EndUserOptedOut
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OptedOutNumberInformation/OptedOutNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OptedOutNumberInformation/OptedOutTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OptedOutNumberInformation/EndUserOptedOut
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/EventDestinationName
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestinationName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/Enabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/MatchingEventTypes
  :cognitect.aws.pinpoint-sms-voice-v2/EventTypeList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/CloudWatchLogsDestination
  :cognitect.aws.pinpoint-sms-voice-v2/CloudWatchLogsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/KinesisFirehoseDestination
  :cognitect.aws.pinpoint-sms-voice-v2/KinesisFirehoseDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.EventDestination/SnsDestination
  :cognitect.aws.pinpoint-sms-voice-v2/SnsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/EventDestinations
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestinationList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/DefaultMessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/DefaultSenderId
  :cognitect.aws.pinpoint-sms-voice-v2/SenderId)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ConfigurationSetInformation/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/NumberType
  :cognitect.aws.pinpoint-sms-voice-v2/NumberType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/PhoneNumberId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/MonthlyLeasingPrice
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/PhoneNumberArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/PhoneNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/NumberCapabilities
  :cognitect.aws.pinpoint-sms-voice-v2/NumberCapabilityList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberInformation/Status
  :cognitect.aws.pinpoint-sms-voice-v2/NumberStatus)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetTextMessageSpendLimitOverrideResult/MonthlyLimit
  :cognitect.aws.pinpoint-sms-voice-v2/MonthlyLimit)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/PhoneNumberId
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UpdatePhoneNumberRequest/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AccountAttribute/Name
  :cognitect.aws.pinpoint-sms-voice-v2/AccountAttributeName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AccountAttribute/Value
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdResult/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdResult/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdResult/SenderId
  :cognitect.aws.pinpoint-sms-voice-v2/SenderId)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/EventDestinationName
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestinationName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/MatchingEventTypes
  :cognitect.aws.pinpoint-sms-voice-v2/EventTypeList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/CloudWatchLogsDestination
  :cognitect.aws.pinpoint-sms-voice-v2/CloudWatchLogsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/KinesisFirehoseDestination
  :cognitect.aws.pinpoint-sms-voice-v2/KinesisFirehoseDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/SnsDestination
  :cognitect.aws.pinpoint-sms-voice-v2/SnsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateEventDestinationRequest/ClientToken
  :cognitect.aws.pinpoint-sms-voice-v2/ClientToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/OriginationIdentityArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/Keyword
  :cognitect.aws.pinpoint-sms-voice-v2/Keyword)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/KeywordMessage
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordMessage)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteKeywordResult/KeywordAction
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordAction)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSpendLimitsResult/SpendLimits
  :cognitect.aws.pinpoint-sms-voice-v2/SpendLimitList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSpendLimitsResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSpendLimitsRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeSpendLimitsRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersResult/PhoneNumbers
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberInformationList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsRequest/PoolIds
  :cognitect.aws.pinpoint-sms-voice-v2/PoolIdList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsRequest/Filters
  :cognitect.aws.pinpoint-sms-voice-v2/PoolFilterList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/SenderIdArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/SenderId
  :cognitect.aws.pinpoint-sms-voice-v2/SenderId)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/MessageTypes
  :cognitect.aws.pinpoint-sms-voice-v2/MessageTypeList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SenderIdInformation/MonthlyLeasingPrice
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OptOutListInformation/OptOutListArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OptOutListInformation/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OptOutListInformation/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SenderIdFilter/Name
  :cognitect.aws.pinpoint-sms-voice-v2/SenderIdFilterName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SenderIdFilter/Values
  :cognitect.aws.pinpoint-sms-voice-v2/FilterValueList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UntagResourceRequest/ResourceArn
  :cognitect.aws.pinpoint-sms-voice-v2/AmazonResourceName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.UntagResourceRequest/TagKeys
  :cognitect.aws.pinpoint-sms-voice-v2/TagKeyList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/ConfigurationSetArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/EventDestinations
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestinationList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/DefaultMessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/DefaultSenderId
  :cognitect.aws.pinpoint-sms-voice-v2/SenderId)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OriginationIdentityMetadata/OriginationIdentityArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OriginationIdentityMetadata/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OriginationIdentityMetadata/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OriginationIdentityMetadata/NumberCapabilities
  :cognitect.aws.pinpoint-sms-voice-v2/NumberCapabilityList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsResult/OptOutLists
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListInformationList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeOptOutListsResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendVoiceMessageResult/MessageId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeletePoolRequest/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/PoolIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SendTextMessageResult/MessageId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberRequest/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberRequest/OptedOutNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberFilter/Name
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberFilterName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PhoneNumberFilter/Values
  :cognitect.aws.pinpoint-sms-voice-v2/FilterValueList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteEventDestinationRequest/EventDestinationName
  :cognitect.aws.pinpoint-sms-voice-v2/EventDestinationName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.KeywordInformation/Keyword
  :cognitect.aws.pinpoint-sms-voice-v2/Keyword)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.KeywordInformation/KeywordMessage
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordMessage)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.KeywordInformation/KeywordAction
  :cognitect.aws.pinpoint-sms-voice-v2/KeywordAction)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/SelfManagedOptOutsEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/TagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/TwoWayEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/MessageType
  :cognitect.aws.pinpoint-sms-voice-v2/MessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/CreatedTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/TwoWayChannelArn
  :cognitect.aws.pinpoint-sms-voice-v2/TwoWayChannelArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/SharedRoutesEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/PoolArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/DeletionProtectionEnabled
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreatePoolResult/Status
  :cognitect.aws.pinpoint-sms-voice-v2/PoolStatus)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AccountLimit/Name
  :cognitect.aws.pinpoint-sms-voice-v2/AccountLimitName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AccountLimit/Used
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveLong)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.AccountLimit/Max
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveLong)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteConfigurationSetRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SpendLimit/Name
  :cognitect.aws.pinpoint-sms-voice-v2/SpendLimitName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SpendLimit/EnforcedLimit
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveLong)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SpendLimit/MaxLimit
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveLong)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SpendLimit/Overridden
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListRequest/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListRequest/Tags
  :cognitect.aws.pinpoint-sms-voice-v2/TagList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.CreateOptOutListRequest/ClientToken
  :cognitect.aws.pinpoint-sms-voice-v2/ClientToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityRequest/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/PoolIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityRequest/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneOrSenderIdOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityRequest/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityRequest/ClientToken
  :cognitect.aws.pinpoint-sms-voice-v2/ClientToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/OptOutListArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/OptedOutNumber
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumber)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/OptedOutTimestamp
  :cognitect.aws.pinpoint-sms-voice-v2/Timestamp)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.PutOptedOutNumberResult/EndUserOptedOut
  :cognitect.aws.pinpoint-sms-voice-v2/PrimitiveBoolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/PoolArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/OriginationIdentityArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/OriginationIdentity
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DisassociateOriginationIdentityResult/IsoCountryCode
  :cognitect.aws.pinpoint-sms-voice-v2/IsoCountryCode)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OptedOutFilter/Name
  :cognitect.aws.pinpoint-sms-voice-v2/OptedOutFilterName)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.OptedOutFilter/Values
  :cognitect.aws.pinpoint-sms-voice-v2/FilterValueList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountAttributesResult/AccountAttributes
  :cognitect.aws.pinpoint-sms-voice-v2/AccountAttributeList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribeAccountAttributesResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice-v2/ConfigurationSetNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetDefaultSenderIdRequest/SenderId
  :cognitect.aws.pinpoint-sms-voice-v2/SenderId)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesResult/PoolArn
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesResult/PoolId
  :cognitect.aws.pinpoint-sms-voice-v2/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesResult/OriginationIdentities
  :cognitect.aws.pinpoint-sms-voice-v2/OriginationIdentityMetadataList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.ListPoolOriginationIdentitiesResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsResult/Pools
  :cognitect.aws.pinpoint-sms-voice-v2/PoolInformationList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePoolsResult/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteOptOutListRequest/OptOutListName
  :cognitect.aws.pinpoint-sms-voice-v2/OptOutListNameOrArn)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DeleteVoiceMessageSpendLimitOverrideResult/MonthlyLimit
  :cognitect.aws.pinpoint-sms-voice-v2/MonthlyLimit)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.SetVoiceMessageSpendLimitOverrideResult/MonthlyLimit
  :cognitect.aws.pinpoint-sms-voice-v2/MonthlyLimit)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersRequest/PhoneNumberIds
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberIdList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersRequest/Filters
  :cognitect.aws.pinpoint-sms-voice-v2/PhoneNumberFilterList)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice-v2/NextToken)

(s/def
  :cognitect.aws.pinpoint-sms-voice-v2.DescribePhoneNumbersRequest/MaxResults
  :cognitect.aws.pinpoint-sms-voice-v2/MaxResults)

