;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.pinpoint-sms-voice.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def :cognitect.aws.pinpoint-sms-voice/EventType string?)

(s/def
  :cognitect.aws.pinpoint-sms-voice/CloudWatchLogsDestination
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.CloudWatchLogsDestination/LogGroupArn
     :cognitect.aws.pinpoint-sms-voice.CloudWatchLogsDestination/IamRoleArn]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/VoiceMessageContent
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.VoiceMessageContent/SSMLMessage
     :cognitect.aws.pinpoint-sms-voice.VoiceMessageContent/PlainTextMessage
     :cognitect.aws.pinpoint-sms-voice.VoiceMessageContent/CallInstructionsMessage]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/ListConfigurationSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.ListConfigurationSetsResponse/ConfigurationSets
     :cognitect.aws.pinpoint-sms-voice.ListConfigurationSetsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/CreateConfigurationSetRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.CreateConfigurationSetRequest/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/ListConfigurationSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.ListConfigurationSetsRequest/PageSize
     :cognitect.aws.pinpoint-sms-voice.ListConfigurationSetsRequest/NextToken]))

(s/def :cognitect.aws.pinpoint-sms-voice/NextTokenString string?)

(s/def
  :cognitect.aws.pinpoint-sms-voice/SnsDestination
  (s/keys :opt-un [:cognitect.aws.pinpoint-sms-voice.SnsDestination/TopicArn]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/GetConfigurationSetEventDestinationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.GetConfigurationSetEventDestinationsResponse/EventDestinations]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/EventTypes
  (s/coll-of :cognitect.aws.pinpoint-sms-voice/EventType))

(s/def
  :cognitect.aws.pinpoint-sms-voice/GetConfigurationSetEventDestinationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice.GetConfigurationSetEventDestinationsRequest/ConfigurationSetName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/SendVoiceMessageResponse
  (s/keys :opt-un [:cognitect.aws.pinpoint-sms-voice.SendVoiceMessageResponse/MessageId]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/CreateConfigurationSetEventDestinationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice.CreateConfigurationSetEventDestinationRequest/ConfigurationSetName]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.CreateConfigurationSetEventDestinationRequest/EventDestination
     :cognitect.aws.pinpoint-sms-voice.CreateConfigurationSetEventDestinationRequest/EventDestinationName]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/EventDestinations
  (s/coll-of :cognitect.aws.pinpoint-sms-voice/EventDestination))

(s/def :cognitect.aws.pinpoint-sms-voice/CreateConfigurationSetResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-sms-voice/DeleteConfigurationSetEventDestinationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice.DeleteConfigurationSetEventDestinationRequest/EventDestinationName
     :cognitect.aws.pinpoint-sms-voice.DeleteConfigurationSetEventDestinationRequest/ConfigurationSetName]))

(s/def :cognitect.aws.pinpoint-sms-voice/Boolean boolean?)

(s/def :cognitect.aws.pinpoint-sms-voice/UpdateConfigurationSetEventDestinationResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-sms-voice/UpdateConfigurationSetEventDestinationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice.UpdateConfigurationSetEventDestinationRequest/EventDestinationName
     :cognitect.aws.pinpoint-sms-voice.UpdateConfigurationSetEventDestinationRequest/ConfigurationSetName]
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.UpdateConfigurationSetEventDestinationRequest/EventDestination]))

(s/def :cognitect.aws.pinpoint-sms-voice/NonEmptyString string?)

(s/def :cognitect.aws.pinpoint-sms-voice/__string string?)

(s/def
  :cognitect.aws.pinpoint-sms-voice/CallInstructionsMessageType
  (s/keys :opt-un [:cognitect.aws.pinpoint-sms-voice.CallInstructionsMessageType/Text]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/SendVoiceMessageRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/CallerId
     :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/ConfigurationSetName
     :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/Content
     :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/OriginationPhoneNumber
     :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/DestinationPhoneNumber]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/KinesisFirehoseDestination
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.KinesisFirehoseDestination/IamRoleArn
     :cognitect.aws.pinpoint-sms-voice.KinesisFirehoseDestination/DeliveryStreamArn]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/EventDestination
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.EventDestination/SnsDestination
     :cognitect.aws.pinpoint-sms-voice.EventDestination/CloudWatchLogsDestination
     :cognitect.aws.pinpoint-sms-voice.EventDestination/Enabled
     :cognitect.aws.pinpoint-sms-voice.EventDestination/MatchingEventTypes
     :cognitect.aws.pinpoint-sms-voice.EventDestination/KinesisFirehoseDestination
     :cognitect.aws.pinpoint-sms-voice.EventDestination/Name]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/PlainTextMessageType
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.PlainTextMessageType/LanguageCode
     :cognitect.aws.pinpoint-sms-voice.PlainTextMessageType/VoiceId
     :cognitect.aws.pinpoint-sms-voice.PlainTextMessageType/Text]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/SSMLMessageType
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.SSMLMessageType/LanguageCode
     :cognitect.aws.pinpoint-sms-voice.SSMLMessageType/VoiceId
     :cognitect.aws.pinpoint-sms-voice.SSMLMessageType/Text]))

(s/def :cognitect.aws.pinpoint-sms-voice/CreateConfigurationSetEventDestinationResponse (s/keys))

(s/def
  :cognitect.aws.pinpoint-sms-voice/EventDestinationDefinition
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/SnsDestination
     :cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/CloudWatchLogsDestination
     :cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/Enabled
     :cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/MatchingEventTypes
     :cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/KinesisFirehoseDestination]))

(s/def
  :cognitect.aws.pinpoint-sms-voice/DeleteConfigurationSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint-sms-voice.DeleteConfigurationSetRequest/ConfigurationSetName]))

(s/def :cognitect.aws.pinpoint-sms-voice/DeleteConfigurationSetEventDestinationResponse (s/keys))

(s/def :cognitect.aws.pinpoint-sms-voice/DeleteConfigurationSetResponse (s/keys))

(s/def :cognitect.aws.pinpoint-sms-voice/WordCharactersWithDelimiters string?)

(s/def
  :cognitect.aws.pinpoint-sms-voice/ConfigurationSets
  (s/coll-of :cognitect.aws.pinpoint-sms-voice/WordCharactersWithDelimiters))

(s/def :cognitect.aws.pinpoint-sms-voice/String string?)

(s/def
  :cognitect.aws.pinpoint-sms-voice.CloudWatchLogsDestination/IamRoleArn
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.CloudWatchLogsDestination/LogGroupArn
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.VoiceMessageContent/CallInstructionsMessage
  :cognitect.aws.pinpoint-sms-voice/CallInstructionsMessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice.VoiceMessageContent/PlainTextMessage
  :cognitect.aws.pinpoint-sms-voice/PlainTextMessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice.VoiceMessageContent/SSMLMessage
  :cognitect.aws.pinpoint-sms-voice/SSMLMessageType)

(s/def
  :cognitect.aws.pinpoint-sms-voice.ListConfigurationSetsResponse/ConfigurationSets
  :cognitect.aws.pinpoint-sms-voice/ConfigurationSets)

(s/def
  :cognitect.aws.pinpoint-sms-voice.ListConfigurationSetsResponse/NextToken
  :cognitect.aws.pinpoint-sms-voice/NextTokenString)

(s/def
  :cognitect.aws.pinpoint-sms-voice.CreateConfigurationSetRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice/WordCharactersWithDelimiters)

(s/def
  :cognitect.aws.pinpoint-sms-voice.ListConfigurationSetsRequest/NextToken
  :cognitect.aws.pinpoint-sms-voice/__string)

(s/def
  :cognitect.aws.pinpoint-sms-voice.ListConfigurationSetsRequest/PageSize
  :cognitect.aws.pinpoint-sms-voice/__string)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SnsDestination/TopicArn
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.GetConfigurationSetEventDestinationsResponse/EventDestinations
  :cognitect.aws.pinpoint-sms-voice/EventDestinations)

(s/def
  :cognitect.aws.pinpoint-sms-voice.GetConfigurationSetEventDestinationsRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice/__string)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageResponse/MessageId
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.CreateConfigurationSetEventDestinationRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice/__string)

(s/def
  :cognitect.aws.pinpoint-sms-voice.CreateConfigurationSetEventDestinationRequest/EventDestination
  :cognitect.aws.pinpoint-sms-voice/EventDestinationDefinition)

(s/def
  :cognitect.aws.pinpoint-sms-voice.CreateConfigurationSetEventDestinationRequest/EventDestinationName
  :cognitect.aws.pinpoint-sms-voice/NonEmptyString)

(s/def
  :cognitect.aws.pinpoint-sms-voice.DeleteConfigurationSetEventDestinationRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice/__string)

(s/def
  :cognitect.aws.pinpoint-sms-voice.DeleteConfigurationSetEventDestinationRequest/EventDestinationName
  :cognitect.aws.pinpoint-sms-voice/__string)

(s/def
  :cognitect.aws.pinpoint-sms-voice.UpdateConfigurationSetEventDestinationRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice/__string)

(s/def
  :cognitect.aws.pinpoint-sms-voice.UpdateConfigurationSetEventDestinationRequest/EventDestination
  :cognitect.aws.pinpoint-sms-voice/EventDestinationDefinition)

(s/def
  :cognitect.aws.pinpoint-sms-voice.UpdateConfigurationSetEventDestinationRequest/EventDestinationName
  :cognitect.aws.pinpoint-sms-voice/__string)

(s/def
  :cognitect.aws.pinpoint-sms-voice.CallInstructionsMessageType/Text
  :cognitect.aws.pinpoint-sms-voice/NonEmptyString)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/CallerId
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice/WordCharactersWithDelimiters)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/Content
  :cognitect.aws.pinpoint-sms-voice/VoiceMessageContent)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/DestinationPhoneNumber
  :cognitect.aws.pinpoint-sms-voice/NonEmptyString)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SendVoiceMessageRequest/OriginationPhoneNumber
  :cognitect.aws.pinpoint-sms-voice/NonEmptyString)

(s/def
  :cognitect.aws.pinpoint-sms-voice.KinesisFirehoseDestination/DeliveryStreamArn
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.KinesisFirehoseDestination/IamRoleArn
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestination/CloudWatchLogsDestination
  :cognitect.aws.pinpoint-sms-voice/CloudWatchLogsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestination/Enabled
  :cognitect.aws.pinpoint-sms-voice/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestination/KinesisFirehoseDestination
  :cognitect.aws.pinpoint-sms-voice/KinesisFirehoseDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestination/MatchingEventTypes
  :cognitect.aws.pinpoint-sms-voice/EventTypes)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestination/Name
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestination/SnsDestination
  :cognitect.aws.pinpoint-sms-voice/SnsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice.PlainTextMessageType/LanguageCode
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.PlainTextMessageType/Text
  :cognitect.aws.pinpoint-sms-voice/NonEmptyString)

(s/def
  :cognitect.aws.pinpoint-sms-voice.PlainTextMessageType/VoiceId
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SSMLMessageType/LanguageCode
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SSMLMessageType/Text
  :cognitect.aws.pinpoint-sms-voice/NonEmptyString)

(s/def
  :cognitect.aws.pinpoint-sms-voice.SSMLMessageType/VoiceId
  :cognitect.aws.pinpoint-sms-voice/String)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/CloudWatchLogsDestination
  :cognitect.aws.pinpoint-sms-voice/CloudWatchLogsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/Enabled
  :cognitect.aws.pinpoint-sms-voice/Boolean)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/KinesisFirehoseDestination
  :cognitect.aws.pinpoint-sms-voice/KinesisFirehoseDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/MatchingEventTypes
  :cognitect.aws.pinpoint-sms-voice/EventTypes)

(s/def
  :cognitect.aws.pinpoint-sms-voice.EventDestinationDefinition/SnsDestination
  :cognitect.aws.pinpoint-sms-voice/SnsDestination)

(s/def
  :cognitect.aws.pinpoint-sms-voice.DeleteConfigurationSetRequest/ConfigurationSetName
  :cognitect.aws.pinpoint-sms-voice/__string)

