;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.pinpoint.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.pinpoint/UpdateAttributesRequest
  (s/keys :opt-un [:cognitect.aws.pinpoint.UpdateAttributesRequest/Blacklist]))

(s/def
  :cognitect.aws.pinpoint/SegmentBehaviors
  (s/keys :opt-un [:cognitect.aws.pinpoint.SegmentBehaviors/Recency]))

(s/def
  :cognitect.aws.pinpoint/MultiConditionalBranch
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.MultiConditionalBranch/Condition
     :cognitect.aws.pinpoint.MultiConditionalBranch/NextActivity]))

(s/def
  :cognitect.aws.pinpoint/ImportJobResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ImportJobResponse/JobStatus
     :cognitect.aws.pinpoint.ImportJobResponse/CreationDate
     :cognitect.aws.pinpoint.ImportJobResponse/Type
     :cognitect.aws.pinpoint.ImportJobResponse/Definition
     :cognitect.aws.pinpoint.ImportJobResponse/Id
     :cognitect.aws.pinpoint.ImportJobResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.ImportJobResponse/Failures
     :cognitect.aws.pinpoint.ImportJobResponse/CompletionDate
     :cognitect.aws.pinpoint.ImportJobResponse/TotalPieces
     :cognitect.aws.pinpoint.ImportJobResponse/TotalFailures
     :cognitect.aws.pinpoint.ImportJobResponse/FailedPieces
     :cognitect.aws.pinpoint.ImportJobResponse/CompletedPieces
     :cognitect.aws.pinpoint.ImportJobResponse/TotalProcessed]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyRunsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetJourneyRunsResponse/JourneyRunsResponse]))

(s/def
  :cognitect.aws.pinpoint/JourneySMSMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.JourneySMSMessage/SenderId
     :cognitect.aws.pinpoint.JourneySMSMessage/OriginationNumber
     :cognitect.aws.pinpoint.JourneySMSMessage/TemplateId
     :cognitect.aws.pinpoint.JourneySMSMessage/MessageType
     :cognitect.aws.pinpoint.JourneySMSMessage/EntityId]))

(s/def
  :cognitect.aws.pinpoint/SendUsersMessageResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SendUsersMessageResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.SendUsersMessageResponse/RequestId
     :cognitect.aws.pinpoint.SendUsersMessageResponse/Result]))

(s/def :cognitect.aws.pinpoint/RecencyType (s/spec string? :gen #(s/gen #{"INACTIVE" "ACTIVE"})))

(s/def
  :cognitect.aws.pinpoint/ListOfSegmentResponse
  (s/coll-of :cognitect.aws.pinpoint/SegmentResponse))

(s/def
  :cognitect.aws.pinpoint/SegmentGroup
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SegmentGroup/SourceSegments
     :cognitect.aws.pinpoint.SegmentGroup/Type
     :cognitect.aws.pinpoint.SegmentGroup/SourceType
     :cognitect.aws.pinpoint.SegmentGroup/Dimensions]))

(s/def
  :cognitect.aws.pinpoint/GetApplicationSettingsRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetApplicationSettingsRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/ListOfRandomSplitEntry
  (s/coll-of :cognitect.aws.pinpoint/RandomSplitEntry))

(s/def
  :cognitect.aws.pinpoint/UpdateGcmChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateGcmChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateGcmChannelRequest/GCMChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/WaitTime
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.WaitTime/WaitUntil :cognitect.aws.pinpoint.WaitTime/WaitFor]))

(s/def
  :cognitect.aws.pinpoint/ListOfSegmentDimensions
  (s/coll-of :cognitect.aws.pinpoint/SegmentDimensions))

(s/def
  :cognitect.aws.pinpoint/MessageResult
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.MessageResult/DeliveryStatus
     :cognitect.aws.pinpoint.MessageResult/StatusCode]
    :opt-un
    [:cognitect.aws.pinpoint.MessageResult/MessageId
     :cognitect.aws.pinpoint.MessageResult/StatusMessage
     :cognitect.aws.pinpoint.MessageResult/UpdatedToken]))

(s/def
  :cognitect.aws.pinpoint/JourneysResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.JourneysResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.JourneysResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/CampaignResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CampaignResponse/LastModifiedDate
     :cognitect.aws.pinpoint.CampaignResponse/CreationDate
     :cognitect.aws.pinpoint.CampaignResponse/SegmentId
     :cognitect.aws.pinpoint.CampaignResponse/SegmentVersion
     :cognitect.aws.pinpoint.CampaignResponse/Id
     :cognitect.aws.pinpoint.CampaignResponse/Arn
     :cognitect.aws.pinpoint.CampaignResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.CampaignResponse/DefaultState
     :cognitect.aws.pinpoint.CampaignResponse/CustomDeliveryConfiguration
     :cognitect.aws.pinpoint.CampaignResponse/AdditionalTreatments
     :cognitect.aws.pinpoint.CampaignResponse/tags
     :cognitect.aws.pinpoint.CampaignResponse/TreatmentDescription
     :cognitect.aws.pinpoint.CampaignResponse/Priority
     :cognitect.aws.pinpoint.CampaignResponse/TreatmentName
     :cognitect.aws.pinpoint.CampaignResponse/Limits
     :cognitect.aws.pinpoint.CampaignResponse/Description
     :cognitect.aws.pinpoint.CampaignResponse/IsPaused
     :cognitect.aws.pinpoint.CampaignResponse/Hook
     :cognitect.aws.pinpoint.CampaignResponse/MessageConfiguration
     :cognitect.aws.pinpoint.CampaignResponse/State
     :cognitect.aws.pinpoint.CampaignResponse/Version
     :cognitect.aws.pinpoint.CampaignResponse/Schedule
     :cognitect.aws.pinpoint.CampaignResponse/Name
     :cognitect.aws.pinpoint.CampaignResponse/HoldoutPercent
     :cognitect.aws.pinpoint.CampaignResponse/TemplateConfiguration]))

(s/def
  :cognitect.aws.pinpoint/DefaultPushNotificationMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.DefaultPushNotificationMessage/Body
     :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Title
     :cognitect.aws.pinpoint.DefaultPushNotificationMessage/SilentPush
     :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Url
     :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Substitutions
     :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Data
     :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Action]))

(s/def
  :cognitect.aws.pinpoint/SMSChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SMSChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.SMSChannelResponse/TransactionalMessagesPerSecond
     :cognitect.aws.pinpoint.SMSChannelResponse/HasCredential
     :cognitect.aws.pinpoint.SMSChannelResponse/ShortCode
     :cognitect.aws.pinpoint.SMSChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.SMSChannelResponse/Enabled
     :cognitect.aws.pinpoint.SMSChannelResponse/SenderId
     :cognitect.aws.pinpoint.SMSChannelResponse/PromotionalMessagesPerSecond
     :cognitect.aws.pinpoint.SMSChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.SMSChannelResponse/IsArchived
     :cognitect.aws.pinpoint.SMSChannelResponse/CreationDate
     :cognitect.aws.pinpoint.SMSChannelResponse/Version
     :cognitect.aws.pinpoint.SMSChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.SMSChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.TagResourceRequest/ResourceArn
     :cognitect.aws.pinpoint.TagResourceRequest/TagsModel]))

(s/def
  :cognitect.aws.pinpoint/APNSChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.APNSChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.APNSChannelResponse/HasCredential
     :cognitect.aws.pinpoint.APNSChannelResponse/HasTokenKey
     :cognitect.aws.pinpoint.APNSChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.APNSChannelResponse/Enabled
     :cognitect.aws.pinpoint.APNSChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.APNSChannelResponse/IsArchived
     :cognitect.aws.pinpoint.APNSChannelResponse/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.APNSChannelResponse/CreationDate
     :cognitect.aws.pinpoint.APNSChannelResponse/Version
     :cognitect.aws.pinpoint.APNSChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.APNSChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/ImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ImportJobRequest/Format
     :cognitect.aws.pinpoint.ImportJobRequest/S3Url
     :cognitect.aws.pinpoint.ImportJobRequest/RoleArn]
    :opt-un
    [:cognitect.aws.pinpoint.ImportJobRequest/DefineSegment
     :cognitect.aws.pinpoint.ImportJobRequest/RegisterEndpoints
     :cognitect.aws.pinpoint.ImportJobRequest/ExternalId
     :cognitect.aws.pinpoint.ImportJobRequest/SegmentId
     :cognitect.aws.pinpoint.ImportJobRequest/SegmentName]))

(s/def
  :cognitect.aws.pinpoint/UpdateTemplateActiveVersionResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateTemplateActiveVersionResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/GetRecommenderConfigurationResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetRecommenderConfigurationResponse/RecommenderConfigurationResponse]))

(s/def
  :cognitect.aws.pinpoint/CreateRecommenderConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateRecommenderConfigurationRequest/CreateRecommenderConfiguration]))

(s/def
  :cognitect.aws.pinpoint/CampaignDateRangeKpiResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/KpiResult
     :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/KpiName
     :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/EndTime
     :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/CampaignId
     :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/StartTime
     :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/APNSVoipChannelRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.APNSVoipChannelRequest/PrivateKey
     :cognitect.aws.pinpoint.APNSVoipChannelRequest/TokenKey
     :cognitect.aws.pinpoint.APNSVoipChannelRequest/Enabled
     :cognitect.aws.pinpoint.APNSVoipChannelRequest/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.APNSVoipChannelRequest/BundleId
     :cognitect.aws.pinpoint.APNSVoipChannelRequest/TokenKeyId
     :cognitect.aws.pinpoint.APNSVoipChannelRequest/TeamId
     :cognitect.aws.pinpoint.APNSVoipChannelRequest/Certificate]))

(s/def
  :cognitect.aws.pinpoint/GetEndpointRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetEndpointRequest/ApplicationId
     :cognitect.aws.pinpoint.GetEndpointRequest/EndpointId]))

(s/def
  :cognitect.aws.pinpoint/ApplicationResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ApplicationResponse/Id
     :cognitect.aws.pinpoint.ApplicationResponse/Arn
     :cognitect.aws.pinpoint.ApplicationResponse/Name]
    :opt-un
    [:cognitect.aws.pinpoint.ApplicationResponse/tags
     :cognitect.aws.pinpoint.ApplicationResponse/CreationDate]))

(s/def
  :cognitect.aws.pinpoint/CreateInAppTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateInAppTemplateResponse/TemplateCreateMessageBody]))

(s/def
  :cognitect.aws.pinpoint/GetApnsSandboxChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetApnsSandboxChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/MapOfChannelResponse
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/ChannelResponse))

(s/def
  :cognitect.aws.pinpoint/MapOfListOfOpenHoursRules
  (s/map-of :cognitect.aws.pinpoint/DayOfWeek :cognitect.aws.pinpoint/ListOfOpenHoursRules))

(s/def
  :cognitect.aws.pinpoint/JourneySchedule
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.JourneySchedule/EndTime
     :cognitect.aws.pinpoint.JourneySchedule/StartTime
     :cognitect.aws.pinpoint.JourneySchedule/Timezone]))

(s/def
  :cognitect.aws.pinpoint/DeleteApnsVoipChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteApnsVoipChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/PushNotificationTemplateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.PushNotificationTemplateRequest/DefaultSubstitutions
     :cognitect.aws.pinpoint.PushNotificationTemplateRequest/Default
     :cognitect.aws.pinpoint.PushNotificationTemplateRequest/ADM
     :cognitect.aws.pinpoint.PushNotificationTemplateRequest/GCM
     :cognitect.aws.pinpoint.PushNotificationTemplateRequest/APNS
     :cognitect.aws.pinpoint.PushNotificationTemplateRequest/tags
     :cognitect.aws.pinpoint.PushNotificationTemplateRequest/Baidu
     :cognitect.aws.pinpoint.PushNotificationTemplateRequest/RecommenderId
     :cognitect.aws.pinpoint.PushNotificationTemplateRequest/TemplateDescription]))

(s/def
  :cognitect.aws.pinpoint/UpdateEmailTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateEmailTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/GetApplicationDateRangeKpiRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/ApplicationId
     :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/KpiName]
    :opt-un
    [:cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/EndTime
     :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/PageSize
     :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/StartTime
     :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint/MapOfEventItemResponse
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/EventItemResponse))

(s/def
  :cognitect.aws.pinpoint/MapOfAttributeDimension
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/AttributeDimension))

(s/def
  :cognitect.aws.pinpoint/__TimezoneEstimationMethodsElement
  (s/spec string? :gen #(s/gen #{"POSTAL_CODE" "PHONE_NUMBER"})))

(s/def
  :cognitect.aws.pinpoint/AttributeType
  (s/spec
    string?
    :gen
    #(s/gen #{"ON" "CONTAINS" "BEFORE" "EXCLUSIVE" "AFTER" "INCLUSIVE" "BETWEEN"})))

(s/def :cognitect.aws.pinpoint/FilterType (s/spec string? :gen #(s/gen #{"SYSTEM" "ENDPOINT"})))

(s/def
  :cognitect.aws.pinpoint/DeleteSmsTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteSmsTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/RecencyDimension
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.RecencyDimension/Duration
     :cognitect.aws.pinpoint.RecencyDimension/RecencyType]))

(s/def
  :cognitect.aws.pinpoint/VoiceChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.VoiceChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.VoiceChannelResponse/HasCredential
     :cognitect.aws.pinpoint.VoiceChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.VoiceChannelResponse/Enabled
     :cognitect.aws.pinpoint.VoiceChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.VoiceChannelResponse/IsArchived
     :cognitect.aws.pinpoint.VoiceChannelResponse/CreationDate
     :cognitect.aws.pinpoint.VoiceChannelResponse/Version
     :cognitect.aws.pinpoint.VoiceChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.VoiceChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/GCMChannelRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.GCMChannelRequest/Enabled
     :cognitect.aws.pinpoint.GCMChannelRequest/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.GCMChannelRequest/ApiKey
     :cognitect.aws.pinpoint.GCMChannelRequest/ServiceJson]))

(s/def
  :cognitect.aws.pinpoint/UpdateAdmChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateAdmChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateAdmChannelRequest/ADMChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/DeleteEmailChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteEmailChannelResponse/EmailChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/MapOfAddressConfiguration
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/AddressConfiguration))

(s/def
  :cognitect.aws.pinpoint/AddressConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.AddressConfiguration/Context
     :cognitect.aws.pinpoint.AddressConfiguration/RawContent
     :cognitect.aws.pinpoint.AddressConfiguration/BodyOverride
     :cognitect.aws.pinpoint.AddressConfiguration/Substitutions
     :cognitect.aws.pinpoint.AddressConfiguration/TitleOverride
     :cognitect.aws.pinpoint.AddressConfiguration/ChannelType]))

(s/def
  :cognitect.aws.pinpoint/VerifyOTPMessageResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.VerifyOTPMessageResponse/VerificationResponse]))

(s/def
  :cognitect.aws.pinpoint/UpdateSmsTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateSmsTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.UpdateSmsTemplateRequest/SMSTemplateRequest]
    :opt-un
    [:cognitect.aws.pinpoint.UpdateSmsTemplateRequest/Version
     :cognitect.aws.pinpoint.UpdateSmsTemplateRequest/CreateNewVersion]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetSegmentRequest/SegmentId
     :cognitect.aws.pinpoint.GetSegmentRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/MapOf__string
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/__string))

(s/def
  :cognitect.aws.pinpoint/TemplateVersionResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.TemplateVersionResponse/LastModifiedDate
     :cognitect.aws.pinpoint.TemplateVersionResponse/CreationDate
     :cognitect.aws.pinpoint.TemplateVersionResponse/TemplateName
     :cognitect.aws.pinpoint.TemplateVersionResponse/TemplateType]
    :opt-un
    [:cognitect.aws.pinpoint.TemplateVersionResponse/DefaultSubstitutions
     :cognitect.aws.pinpoint.TemplateVersionResponse/Version
     :cognitect.aws.pinpoint.TemplateVersionResponse/TemplateDescription]))

(s/def
  :cognitect.aws.pinpoint/EndpointDemographic
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EndpointDemographic/Platform
     :cognitect.aws.pinpoint.EndpointDemographic/Locale
     :cognitect.aws.pinpoint.EndpointDemographic/Make
     :cognitect.aws.pinpoint.EndpointDemographic/Timezone
     :cognitect.aws.pinpoint.EndpointDemographic/Model
     :cognitect.aws.pinpoint.EndpointDemographic/PlatformVersion
     :cognitect.aws.pinpoint.EndpointDemographic/AppVersion
     :cognitect.aws.pinpoint.EndpointDemographic/ModelVersion]))

(s/def :cognitect.aws.pinpoint/__timestampUnix inst?)

(s/def
  :cognitect.aws.pinpoint/SetDimension
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SetDimension/Values]
    :opt-un
    [:cognitect.aws.pinpoint.SetDimension/DimensionType]))

(s/def
  :cognitect.aws.pinpoint/OpenHours
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.OpenHours/VOICE
     :cognitect.aws.pinpoint.OpenHours/CUSTOM
     :cognitect.aws.pinpoint.OpenHours/SMS
     :cognitect.aws.pinpoint.OpenHours/PUSH
     :cognitect.aws.pinpoint.OpenHours/EMAIL]))

(s/def
  :cognitect.aws.pinpoint/UpdateCampaignResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateCampaignResponse/CampaignResponse]))

(s/def
  :cognitect.aws.pinpoint/UpdateApnsVoipChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateApnsVoipChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateApnsVoipChannelRequest/APNSVoipChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/MapOfEndpointSendConfiguration
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/EndpointSendConfiguration))

(s/def
  :cognitect.aws.pinpoint/ListOfImportJobResponse
  (s/coll-of :cognitect.aws.pinpoint/ImportJobResponse))

(s/def
  :cognitect.aws.pinpoint/SegmentGroupList
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SegmentGroupList/Groups
     :cognitect.aws.pinpoint.SegmentGroupList/Include]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetCampaignRequest/CampaignId
     :cognitect.aws.pinpoint.GetCampaignRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/UpdateEndpointRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateEndpointRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateEndpointRequest/EndpointId
     :cognitect.aws.pinpoint.UpdateEndpointRequest/EndpointRequest]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyExecutionMetricsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyExecutionMetricsRequest/ApplicationId
     :cognitect.aws.pinpoint.GetJourneyExecutionMetricsRequest/JourneyId]
    :opt-un
    [:cognitect.aws.pinpoint.GetJourneyExecutionMetricsRequest/PageSize
     :cognitect.aws.pinpoint.GetJourneyExecutionMetricsRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint/DeleteApnsChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteApnsChannelResponse/APNSChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/InAppMessageCampaign
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.InAppMessageCampaign/SessionCap
     :cognitect.aws.pinpoint.InAppMessageCampaign/Priority
     :cognitect.aws.pinpoint.InAppMessageCampaign/InAppMessage
     :cognitect.aws.pinpoint.InAppMessageCampaign/TotalCap
     :cognitect.aws.pinpoint.InAppMessageCampaign/Schedule
     :cognitect.aws.pinpoint.InAppMessageCampaign/DailyCap
     :cognitect.aws.pinpoint.InAppMessageCampaign/CampaignId
     :cognitect.aws.pinpoint.InAppMessageCampaign/TreatmentId]))

(s/def
  :cognitect.aws.pinpoint/GetEmailTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetEmailTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.GetEmailTemplateRequest/Version]))

(s/def
  :cognitect.aws.pinpoint/DeleteAppRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteAppRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/MapOfEndpointMessageResult
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/EndpointMessageResult))

(s/def
  :cognitect.aws.pinpoint/EventFilter
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.EventFilter/FilterType
     :cognitect.aws.pinpoint.EventFilter/Dimensions]))

(s/def
  :cognitect.aws.pinpoint/ListOfJourneyResponse
  (s/coll-of :cognitect.aws.pinpoint/JourneyResponse))

(s/def
  :cognitect.aws.pinpoint/SegmentLocation
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SegmentLocation/Country
     :cognitect.aws.pinpoint.SegmentLocation/GPSPoint]))

(s/def
  :cognitect.aws.pinpoint/GetInAppTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetInAppTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.GetInAppTemplateRequest/Version]))

(s/def :cognitect.aws.pinpoint/__boolean boolean?)

(s/def
  :cognitect.aws.pinpoint/SendMessagesResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.SendMessagesResponse/MessageResponse]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetCampaignsResponse/CampaignsResponse]))

(s/def
  :cognitect.aws.pinpoint/AndroidPushNotificationTemplate
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Body
     :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/ImageUrl
     :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Title
     :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Sound
     :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/RawContent
     :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Url
     :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/SmallImageIconUrl
     :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/ImageIconUrl
     :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Action]))

(s/def
  :cognitect.aws.pinpoint/SendUsersMessagesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SendUsersMessagesRequest/ApplicationId
     :cognitect.aws.pinpoint.SendUsersMessagesRequest/SendUsersMessageRequest]))

(s/def
  :cognitect.aws.pinpoint/DeleteApnsVoipSandboxChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteApnsVoipSandboxChannelResponse/APNSVoipSandboxChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/ListOfMultiConditionalBranch
  (s/coll-of :cognitect.aws.pinpoint/MultiConditionalBranch))

(s/def
  :cognitect.aws.pinpoint/ExportJobResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ExportJobResponse/JobStatus
     :cognitect.aws.pinpoint.ExportJobResponse/CreationDate
     :cognitect.aws.pinpoint.ExportJobResponse/Type
     :cognitect.aws.pinpoint.ExportJobResponse/Definition
     :cognitect.aws.pinpoint.ExportJobResponse/Id
     :cognitect.aws.pinpoint.ExportJobResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.ExportJobResponse/Failures
     :cognitect.aws.pinpoint.ExportJobResponse/CompletionDate
     :cognitect.aws.pinpoint.ExportJobResponse/TotalPieces
     :cognitect.aws.pinpoint.ExportJobResponse/TotalFailures
     :cognitect.aws.pinpoint.ExportJobResponse/FailedPieces
     :cognitect.aws.pinpoint.ExportJobResponse/CompletedPieces
     :cognitect.aws.pinpoint.ExportJobResponse/TotalProcessed]))

(s/def
  :cognitect.aws.pinpoint/DeleteEmailTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteEmailTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/SegmentCondition
  (s/keys :req-un [:cognitect.aws.pinpoint.SegmentCondition/SegmentId]))

(s/def
  :cognitect.aws.pinpoint/UpdateVoiceChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateVoiceChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateVoiceChannelRequest/VoiceChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/__blob
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.pinpoint/CampaignLimits
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.CampaignLimits/Daily
     :cognitect.aws.pinpoint.CampaignLimits/MessagesPerSecond
     :cognitect.aws.pinpoint.CampaignLimits/Total
     :cognitect.aws.pinpoint.CampaignLimits/Session
     :cognitect.aws.pinpoint.CampaignLimits/MaximumDuration]))

(s/def
  :cognitect.aws.pinpoint/Message
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.Message/Body
     :cognitect.aws.pinpoint.Message/ImageUrl
     :cognitect.aws.pinpoint.Message/Title
     :cognitect.aws.pinpoint.Message/SilentPush
     :cognitect.aws.pinpoint.Message/TimeToLive
     :cognitect.aws.pinpoint.Message/RawContent
     :cognitect.aws.pinpoint.Message/Url
     :cognitect.aws.pinpoint.Message/JsonBody
     :cognitect.aws.pinpoint.Message/ImageSmallIconUrl
     :cognitect.aws.pinpoint.Message/MediaUrl
     :cognitect.aws.pinpoint.Message/ImageIconUrl
     :cognitect.aws.pinpoint.Message/Action]))

(s/def
  :cognitect.aws.pinpoint/DeleteEmailTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteEmailTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.DeleteEmailTemplateRequest/Version]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentExportJobsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetSegmentExportJobsResponse/ExportJobsResponse]))

(s/def
  :cognitect.aws.pinpoint/UpdateSegmentResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateSegmentResponse/SegmentResponse]))

(s/def
  :cognitect.aws.pinpoint/ADMChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ADMChannelRequest/ClientSecret
     :cognitect.aws.pinpoint.ADMChannelRequest/ClientId]
    :opt-un
    [:cognitect.aws.pinpoint.ADMChannelRequest/Enabled]))

(s/def
  :cognitect.aws.pinpoint/CreateJourneyRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateJourneyRequest/ApplicationId
     :cognitect.aws.pinpoint.CreateJourneyRequest/WriteJourneyRequest]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyRunsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyRunsRequest/ApplicationId
     :cognitect.aws.pinpoint.GetJourneyRunsRequest/JourneyId]
    :opt-un
    [:cognitect.aws.pinpoint.GetJourneyRunsRequest/PageSize
     :cognitect.aws.pinpoint.GetJourneyRunsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/JourneyExecutionActivityMetricsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/Metrics
     :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/JourneyId
     :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/LastEvaluatedTime
     :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/JourneyActivityId
     :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/ActivityType
     :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/WaitActivity
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.WaitActivity/WaitTime
     :cognitect.aws.pinpoint.WaitActivity/NextActivity]))

(s/def :cognitect.aws.pinpoint/ListOf__string (s/coll-of :cognitect.aws.pinpoint/__string))

(s/def
  :cognitect.aws.pinpoint/__long
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pinpoint/GetJourneyDateRangeKpiRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/JourneyId
     :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/ApplicationId
     :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/KpiName]
    :opt-un
    [:cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/EndTime
     :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/PageSize
     :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/StartTime
     :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint/GetImportJobResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetImportJobResponse/ImportJobResponse]))

(s/def
  :cognitect.aws.pinpoint/SendMessagesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SendMessagesRequest/ApplicationId
     :cognitect.aws.pinpoint.SendMessagesRequest/MessageRequest]))

(s/def
  :cognitect.aws.pinpoint/RandomSplitEntry
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.RandomSplitEntry/Percentage
     :cognitect.aws.pinpoint.RandomSplitEntry/NextActivity]))

(s/def
  :cognitect.aws.pinpoint/EventItemResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EventItemResponse/StatusCode
     :cognitect.aws.pinpoint.EventItemResponse/Message]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetSegmentVersionsRequest/SegmentId
     :cognitect.aws.pinpoint.GetSegmentVersionsRequest/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.GetSegmentVersionsRequest/PageSize
     :cognitect.aws.pinpoint.GetSegmentVersionsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/UpdateApplicationSettingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateApplicationSettingsRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateApplicationSettingsRequest/WriteApplicationSettingsRequest]))

(s/def
  :cognitect.aws.pinpoint/CampaignState
  (s/keys :opt-un [:cognitect.aws.pinpoint.CampaignState/CampaignStatus]))

(s/def
  :cognitect.aws.pinpoint/GetChannelsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetChannelsResponse/ChannelsResponse]))

(s/def
  :cognitect.aws.pinpoint/RecommenderConfigurationResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationProviderUri
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/LastModifiedDate
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/CreationDate
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationProviderRoleArn
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/Id]
    :opt-un
    [:cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationsDisplayName
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationTransformerUri
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationsPerMessage
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/Attributes
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationProviderIdType
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/Description
     :cognitect.aws.pinpoint.RecommenderConfigurationResponse/Name]))

(s/def
  :cognitect.aws.pinpoint/ActivityResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ActivityResponse/CampaignId
     :cognitect.aws.pinpoint.ActivityResponse/Id
     :cognitect.aws.pinpoint.ActivityResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.ActivityResponse/TotalEndpointCount
     :cognitect.aws.pinpoint.ActivityResponse/TimezonesCompletedCount
     :cognitect.aws.pinpoint.ActivityResponse/Start
     :cognitect.aws.pinpoint.ActivityResponse/End
     :cognitect.aws.pinpoint.ActivityResponse/Result
     :cognitect.aws.pinpoint.ActivityResponse/ExecutionMetrics
     :cognitect.aws.pinpoint.ActivityResponse/SuccessfulEndpointCount
     :cognitect.aws.pinpoint.ActivityResponse/State
     :cognitect.aws.pinpoint.ActivityResponse/ScheduledStart
     :cognitect.aws.pinpoint.ActivityResponse/TimezonesTotalCount
     :cognitect.aws.pinpoint.ActivityResponse/TreatmentId]))

(s/def
  :cognitect.aws.pinpoint/PutEventStreamRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.PutEventStreamRequest/ApplicationId
     :cognitect.aws.pinpoint.PutEventStreamRequest/WriteEventStream]))

(s/def
  :cognitect.aws.pinpoint/UpdateRecommenderConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationProviderUri
     :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationProviderRoleArn]
    :opt-un
    [:cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationsDisplayName
     :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationTransformerUri
     :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationsPerMessage
     :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/Attributes
     :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationProviderIdType
     :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/Description
     :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/Name]))

(s/def
  :cognitect.aws.pinpoint/UpdateVoiceTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateVoiceTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/HoldoutActivity
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.HoldoutActivity/Percentage]
    :opt-un
    [:cognitect.aws.pinpoint.HoldoutActivity/NextActivity]))

(s/def
  :cognitect.aws.pinpoint/DeleteUserEndpointsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteUserEndpointsRequest/ApplicationId
     :cognitect.aws.pinpoint.DeleteUserEndpointsRequest/UserId]))

(s/def
  :cognitect.aws.pinpoint/Schedule
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.Schedule/StartTime]
    :opt-un
    [:cognitect.aws.pinpoint.Schedule/EndTime
     :cognitect.aws.pinpoint.Schedule/QuietTime
     :cognitect.aws.pinpoint.Schedule/Timezone
     :cognitect.aws.pinpoint.Schedule/Frequency
     :cognitect.aws.pinpoint.Schedule/IsLocalTime
     :cognitect.aws.pinpoint.Schedule/EventFilter]))

(s/def
  :cognitect.aws.pinpoint/ResultRow
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ResultRow/GroupedBys :cognitect.aws.pinpoint.ResultRow/Values]))

(s/def
  :cognitect.aws.pinpoint/ImportJobResource
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ImportJobResource/Format
     :cognitect.aws.pinpoint.ImportJobResource/S3Url
     :cognitect.aws.pinpoint.ImportJobResource/RoleArn]
    :opt-un
    [:cognitect.aws.pinpoint.ImportJobResource/DefineSegment
     :cognitect.aws.pinpoint.ImportJobResource/RegisterEndpoints
     :cognitect.aws.pinpoint.ImportJobResource/ExternalId
     :cognitect.aws.pinpoint.ImportJobResource/SegmentId
     :cognitect.aws.pinpoint.ImportJobResource/SegmentName]))

(s/def
  :cognitect.aws.pinpoint/Template
  (s/keys :opt-un [:cognitect.aws.pinpoint.Template/Version :cognitect.aws.pinpoint.Template/Name]))

(s/def
  :cognitect.aws.pinpoint/DeleteVoiceChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteVoiceChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/GetApnsVoipChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetApnsVoipChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/SendOTPMessageResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.SendOTPMessageResponse/MessageResponse]))

(s/def
  :cognitect.aws.pinpoint/__double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.pinpoint/ListRecommenderConfigurationsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ListRecommenderConfigurationsResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.ListRecommenderConfigurationsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/SendUsersMessagesResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.SendUsersMessagesResponse/SendUsersMessageResponse]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentVersionResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetSegmentVersionResponse/SegmentResponse]))

(s/def
  :cognitect.aws.pinpoint/RemoveAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.RemoveAttributesRequest/AttributeType
     :cognitect.aws.pinpoint.RemoveAttributesRequest/ApplicationId
     :cognitect.aws.pinpoint.RemoveAttributesRequest/UpdateAttributesRequest]))

(s/def
  :cognitect.aws.pinpoint/GetGcmChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetGcmChannelResponse/GCMChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/DeleteSmsChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteSmsChannelResponse/SMSChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/SMSTemplateResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SMSTemplateResponse/LastModifiedDate
     :cognitect.aws.pinpoint.SMSTemplateResponse/CreationDate
     :cognitect.aws.pinpoint.SMSTemplateResponse/TemplateName
     :cognitect.aws.pinpoint.SMSTemplateResponse/TemplateType]
    :opt-un
    [:cognitect.aws.pinpoint.SMSTemplateResponse/DefaultSubstitutions
     :cognitect.aws.pinpoint.SMSTemplateResponse/Body
     :cognitect.aws.pinpoint.SMSTemplateResponse/tags
     :cognitect.aws.pinpoint.SMSTemplateResponse/RecommenderId
     :cognitect.aws.pinpoint.SMSTemplateResponse/Arn
     :cognitect.aws.pinpoint.SMSTemplateResponse/Version
     :cognitect.aws.pinpoint.SMSTemplateResponse/TemplateDescription]))

(s/def
  :cognitect.aws.pinpoint/TemplateVersionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.TemplateVersionsResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.TemplateVersionsResponse/NextToken
     :cognitect.aws.pinpoint.TemplateVersionsResponse/Message
     :cognitect.aws.pinpoint.TemplateVersionsResponse/RequestID]))

(s/def
  :cognitect.aws.pinpoint/GetAdmChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetAdmChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/ListOfExportJobResponse
  (s/coll-of :cognitect.aws.pinpoint/ExportJobResponse))

(s/def
  :cognitect.aws.pinpoint/GetCampaignActivitiesResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetCampaignActivitiesResponse/ActivitiesResponse]))

(s/def
  :cognitect.aws.pinpoint/GetImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetImportJobRequest/ApplicationId
     :cognitect.aws.pinpoint.GetImportJobRequest/JobId]))

(s/def
  :cognitect.aws.pinpoint/CampaignHook
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.CampaignHook/Mode
     :cognitect.aws.pinpoint.CampaignHook/LambdaFunctionName
     :cognitect.aws.pinpoint.CampaignHook/WebUrl]))

(s/def
  :cognitect.aws.pinpoint/DeletePushTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeletePushTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.DeletePushTemplateRequest/Version]))

(s/def
  :cognitect.aws.pinpoint/UpdateTemplateActiveVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateTemplateActiveVersionRequest/TemplateName
     :cognitect.aws.pinpoint.UpdateTemplateActiveVersionRequest/TemplateType
     :cognitect.aws.pinpoint.UpdateTemplateActiveVersionRequest/TemplateActiveVersionRequest]))

(s/def
  :cognitect.aws.pinpoint/EndpointBatchItem
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EndpointBatchItem/Address
     :cognitect.aws.pinpoint.EndpointBatchItem/EndpointStatus
     :cognitect.aws.pinpoint.EndpointBatchItem/RequestId
     :cognitect.aws.pinpoint.EndpointBatchItem/Location
     :cognitect.aws.pinpoint.EndpointBatchItem/Demographic
     :cognitect.aws.pinpoint.EndpointBatchItem/User
     :cognitect.aws.pinpoint.EndpointBatchItem/Attributes
     :cognitect.aws.pinpoint.EndpointBatchItem/EffectiveDate
     :cognitect.aws.pinpoint.EndpointBatchItem/OptOut
     :cognitect.aws.pinpoint.EndpointBatchItem/Id
     :cognitect.aws.pinpoint.EndpointBatchItem/ChannelType
     :cognitect.aws.pinpoint.EndpointBatchItem/Metrics]))

(s/def
  :cognitect.aws.pinpoint/ListOfMessageHeader
  (s/coll-of :cognitect.aws.pinpoint/MessageHeader))

(s/def
  :cognitect.aws.pinpoint/UpdateBaiduChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateBaiduChannelResponse/BaiduChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/MessageHeader
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.MessageHeader/Value :cognitect.aws.pinpoint.MessageHeader/Name]))

(s/def
  :cognitect.aws.pinpoint/GPSCoordinates
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GPSCoordinates/Latitude
     :cognitect.aws.pinpoint.GPSCoordinates/Longitude]))

(s/def
  :cognitect.aws.pinpoint/PhoneNumberValidateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.PhoneNumberValidateResponse/NumberValidateResponse]))

(s/def
  :cognitect.aws.pinpoint/EndpointLocation
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EndpointLocation/Longitude
     :cognitect.aws.pinpoint.EndpointLocation/Country
     :cognitect.aws.pinpoint.EndpointLocation/PostalCode
     :cognitect.aws.pinpoint.EndpointLocation/Latitude
     :cognitect.aws.pinpoint.EndpointLocation/City
     :cognitect.aws.pinpoint.EndpointLocation/Region]))

(s/def :cognitect.aws.pinpoint/Mode (s/spec string? :gen #(s/gen #{"FILTER" "DELIVERY"})))

(s/def
  :cognitect.aws.pinpoint/GetSegmentImportJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetSegmentImportJobsRequest/SegmentId
     :cognitect.aws.pinpoint.GetSegmentImportJobsRequest/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.GetSegmentImportJobsRequest/PageSize
     :cognitect.aws.pinpoint.GetSegmentImportJobsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/MapOfEventsBatch
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/EventsBatch))

(s/def
  :cognitect.aws.pinpoint/UpdateVoiceChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateVoiceChannelResponse/VoiceChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/APNSVoipSandboxChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/HasCredential
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/HasTokenKey
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/Enabled
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/IsArchived
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/CreationDate
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/Version
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetSegmentVersionRequest/SegmentId
     :cognitect.aws.pinpoint.GetSegmentVersionRequest/Version
     :cognitect.aws.pinpoint.GetSegmentVersionRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/UpdateInAppTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateInAppTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/GetGcmChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetGcmChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/JobStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"COMPLETED"
        "FAILING"
        "COMPLETING"
        "PENDING_JOB"
        "FAILED"
        "INITIALIZING"
        "PROCESSING"
        "PREPARING_FOR_INITIALIZATION"
        "CREATED"})))

(s/def
  :cognitect.aws.pinpoint/PutEventsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.PutEventsResponse/EventsResponse]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyExecutionActivityMetricsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsResponse/JourneyExecutionActivityMetricsResponse]))

(s/def
  :cognitect.aws.pinpoint/ListOfResultRowValue
  (s/coll-of :cognitect.aws.pinpoint/ResultRowValue))

(s/def
  :cognitect.aws.pinpoint/APNSVoipChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.APNSVoipChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.APNSVoipChannelResponse/HasCredential
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/HasTokenKey
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/Enabled
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/IsArchived
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/CreationDate
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/Version
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.APNSVoipChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/GetEventStreamRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetEventStreamRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/DeleteAdmChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteAdmChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/GetExportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetExportJobRequest/ApplicationId
     :cognitect.aws.pinpoint.GetExportJobRequest/JobId]))

(s/def
  :cognitect.aws.pinpoint/EmailMessageActivity
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EmailMessageActivity/MessageConfig
     :cognitect.aws.pinpoint.EmailMessageActivity/TemplateVersion
     :cognitect.aws.pinpoint.EmailMessageActivity/TemplateName
     :cognitect.aws.pinpoint.EmailMessageActivity/NextActivity]))

(s/def
  :cognitect.aws.pinpoint/ClosedDaysRule
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ClosedDaysRule/EndDateTime
     :cognitect.aws.pinpoint.ClosedDaysRule/Name
     :cognitect.aws.pinpoint.ClosedDaysRule/StartDateTime]))

(s/def
  :cognitect.aws.pinpoint/SimpleEmail
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SimpleEmail/HtmlPart
     :cognitect.aws.pinpoint.SimpleEmail/TextPart
     :cognitect.aws.pinpoint.SimpleEmail/Subject
     :cognitect.aws.pinpoint.SimpleEmail/Headers]))

(s/def
  :cognitect.aws.pinpoint/SendUsersMessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SendUsersMessageRequest/MessageConfiguration
     :cognitect.aws.pinpoint.SendUsersMessageRequest/Users]
    :opt-un
    [:cognitect.aws.pinpoint.SendUsersMessageRequest/Context
     :cognitect.aws.pinpoint.SendUsersMessageRequest/TraceId
     :cognitect.aws.pinpoint.SendUsersMessageRequest/TemplateConfiguration]))

(s/def
  :cognitect.aws.pinpoint/SegmentImportResource
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SegmentImportResource/Format
     :cognitect.aws.pinpoint.SegmentImportResource/S3Url
     :cognitect.aws.pinpoint.SegmentImportResource/Size
     :cognitect.aws.pinpoint.SegmentImportResource/ExternalId
     :cognitect.aws.pinpoint.SegmentImportResource/RoleArn]
    :opt-un
    [:cognitect.aws.pinpoint.SegmentImportResource/ChannelCounts]))

(s/def
  :cognitect.aws.pinpoint/EventStartCondition
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EventStartCondition/SegmentId
     :cognitect.aws.pinpoint.EventStartCondition/EventFilter]))

(s/def
  :cognitect.aws.pinpoint/DeleteApnsVoipSandboxChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteApnsVoipSandboxChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/ListOfTemplateVersionResponse
  (s/coll-of :cognitect.aws.pinpoint/TemplateVersionResponse))

(s/def
  :cognitect.aws.pinpoint/PhoneNumberValidateRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.PhoneNumberValidateRequest/NumberValidateRequest]))

(s/def
  :cognitect.aws.pinpoint/CreateInAppTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateInAppTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.CreateInAppTemplateRequest/InAppTemplateRequest]))

(s/def
  :cognitect.aws.pinpoint/CampaignEmailMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.CampaignEmailMessage/Body
     :cognitect.aws.pinpoint.CampaignEmailMessage/Title
     :cognitect.aws.pinpoint.CampaignEmailMessage/HtmlBody
     :cognitect.aws.pinpoint.CampaignEmailMessage/FromAddress
     :cognitect.aws.pinpoint.CampaignEmailMessage/Headers]))

(s/def
  :cognitect.aws.pinpoint/JourneyRunStatus
  (s/spec string? :gen #(s/gen #{"COMPLETED" "SCHEDULED" "CANCELLED" "RUNNING"})))

(s/def
  :cognitect.aws.pinpoint/JourneyExecutionMetricsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.JourneyExecutionMetricsResponse/Metrics
     :cognitect.aws.pinpoint.JourneyExecutionMetricsResponse/JourneyId
     :cognitect.aws.pinpoint.JourneyExecutionMetricsResponse/LastEvaluatedTime
     :cognitect.aws.pinpoint.JourneyExecutionMetricsResponse/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/GetUserEndpointsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetUserEndpointsResponse/EndpointsResponse]))

(s/def
  :cognitect.aws.pinpoint/ListTemplateVersionsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.ListTemplateVersionsResponse/TemplateVersionsResponse]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentVersionsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetSegmentVersionsResponse/SegmentsResponse]))

(s/def
  :cognitect.aws.pinpoint/MessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.MessageRequest/MessageConfiguration]
    :opt-un
    [:cognitect.aws.pinpoint.MessageRequest/Context
     :cognitect.aws.pinpoint.MessageRequest/TraceId
     :cognitect.aws.pinpoint.MessageRequest/Endpoints
     :cognitect.aws.pinpoint.MessageRequest/Addresses
     :cognitect.aws.pinpoint.MessageRequest/TemplateConfiguration]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyRunExecutionMetricsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsResponse/JourneyRunExecutionMetricsResponse]))

(s/def
  :cognitect.aws.pinpoint/GetEventStreamResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetEventStreamResponse/EventStream]))

(s/def
  :cognitect.aws.pinpoint/SimpleEmailPart
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SimpleEmailPart/Data :cognitect.aws.pinpoint.SimpleEmailPart/Charset]))

(s/def
  :cognitect.aws.pinpoint/BaseKpiResult
  (s/keys :req-un [:cognitect.aws.pinpoint.BaseKpiResult/Rows]))

(s/def
  :cognitect.aws.pinpoint/SegmentResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SegmentResponse/SegmentType
     :cognitect.aws.pinpoint.SegmentResponse/CreationDate
     :cognitect.aws.pinpoint.SegmentResponse/Id
     :cognitect.aws.pinpoint.SegmentResponse/Arn
     :cognitect.aws.pinpoint.SegmentResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.SegmentResponse/SegmentGroups
     :cognitect.aws.pinpoint.SegmentResponse/LastModifiedDate
     :cognitect.aws.pinpoint.SegmentResponse/tags
     :cognitect.aws.pinpoint.SegmentResponse/Dimensions
     :cognitect.aws.pinpoint.SegmentResponse/ImportDefinition
     :cognitect.aws.pinpoint.SegmentResponse/Version
     :cognitect.aws.pinpoint.SegmentResponse/Name]))

(s/def
  :cognitect.aws.pinpoint/NotFoundException
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.NotFoundException/Message
     :cognitect.aws.pinpoint.NotFoundException/RequestID]))

(s/def
  :cognitect.aws.pinpoint/ExportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ExportJobRequest/S3UrlPrefix
     :cognitect.aws.pinpoint.ExportJobRequest/RoleArn]
    :opt-un
    [:cognitect.aws.pinpoint.ExportJobRequest/SegmentVersion
     :cognitect.aws.pinpoint.ExportJobRequest/SegmentId]))

(s/def
  :cognitect.aws.pinpoint/GetEmailChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetEmailChannelResponse/EmailChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/AttributeDimension
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.AttributeDimension/Values]
    :opt-un
    [:cognitect.aws.pinpoint.AttributeDimension/AttributeType]))

(s/def
  :cognitect.aws.pinpoint/CreateCampaignResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateCampaignResponse/CampaignResponse]))

(s/def
  :cognitect.aws.pinpoint/SimpleCondition
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SimpleCondition/EventCondition
     :cognitect.aws.pinpoint.SimpleCondition/SegmentDimensions
     :cognitect.aws.pinpoint.SimpleCondition/SegmentCondition]))

(s/def
  :cognitect.aws.pinpoint/CreateImportJobResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateImportJobResponse/ImportJobResponse]))

(s/def
  :cognitect.aws.pinpoint/UpdateEndpointResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateEndpointResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/DeleteBaiduChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteBaiduChannelResponse/BaiduChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/Layout
  (s/spec
    string?
    :gen
    #(s/gen #{"OVERLAYS" "MIDDLE_BANNER" "BOTTOM_BANNER" "TOP_BANNER" "CAROUSEL" "MOBILE_FEED"})))

(s/def
  :cognitect.aws.pinpoint/EndpointRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EndpointRequest/Address
     :cognitect.aws.pinpoint.EndpointRequest/EndpointStatus
     :cognitect.aws.pinpoint.EndpointRequest/RequestId
     :cognitect.aws.pinpoint.EndpointRequest/Location
     :cognitect.aws.pinpoint.EndpointRequest/Demographic
     :cognitect.aws.pinpoint.EndpointRequest/User
     :cognitect.aws.pinpoint.EndpointRequest/Attributes
     :cognitect.aws.pinpoint.EndpointRequest/EffectiveDate
     :cognitect.aws.pinpoint.EndpointRequest/OptOut
     :cognitect.aws.pinpoint.EndpointRequest/ChannelType
     :cognitect.aws.pinpoint.EndpointRequest/Metrics]))

(s/def
  :cognitect.aws.pinpoint/WriteEventStream
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.WriteEventStream/RoleArn
     :cognitect.aws.pinpoint.WriteEventStream/DestinationStreamArn]))

(s/def
  :cognitect.aws.pinpoint/WriteTreatmentResource
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.WriteTreatmentResource/SizePercent]
    :opt-un
    [:cognitect.aws.pinpoint.WriteTreatmentResource/CustomDeliveryConfiguration
     :cognitect.aws.pinpoint.WriteTreatmentResource/TreatmentDescription
     :cognitect.aws.pinpoint.WriteTreatmentResource/TreatmentName
     :cognitect.aws.pinpoint.WriteTreatmentResource/MessageConfiguration
     :cognitect.aws.pinpoint.WriteTreatmentResource/Schedule
     :cognitect.aws.pinpoint.WriteTreatmentResource/TemplateConfiguration]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignVersionsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetCampaignVersionsResponse/CampaignsResponse]))

(s/def
  :cognitect.aws.pinpoint/EndpointItemResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EndpointItemResponse/StatusCode
     :cognitect.aws.pinpoint.EndpointItemResponse/Message]))

(s/def
  :cognitect.aws.pinpoint/WriteCampaignRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.WriteCampaignRequest/CustomDeliveryConfiguration
     :cognitect.aws.pinpoint.WriteCampaignRequest/AdditionalTreatments
     :cognitect.aws.pinpoint.WriteCampaignRequest/tags
     :cognitect.aws.pinpoint.WriteCampaignRequest/TreatmentDescription
     :cognitect.aws.pinpoint.WriteCampaignRequest/Priority
     :cognitect.aws.pinpoint.WriteCampaignRequest/TreatmentName
     :cognitect.aws.pinpoint.WriteCampaignRequest/Limits
     :cognitect.aws.pinpoint.WriteCampaignRequest/SegmentVersion
     :cognitect.aws.pinpoint.WriteCampaignRequest/Description
     :cognitect.aws.pinpoint.WriteCampaignRequest/IsPaused
     :cognitect.aws.pinpoint.WriteCampaignRequest/Hook
     :cognitect.aws.pinpoint.WriteCampaignRequest/MessageConfiguration
     :cognitect.aws.pinpoint.WriteCampaignRequest/SegmentId
     :cognitect.aws.pinpoint.WriteCampaignRequest/Schedule
     :cognitect.aws.pinpoint.WriteCampaignRequest/Name
     :cognitect.aws.pinpoint.WriteCampaignRequest/HoldoutPercent
     :cognitect.aws.pinpoint.WriteCampaignRequest/TemplateConfiguration]))

(s/def
  :cognitect.aws.pinpoint/GetApnsChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetApnsChannelResponse/APNSChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/UpdateEmailTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateEmailTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.UpdateEmailTemplateRequest/EmailTemplateRequest]
    :opt-un
    [:cognitect.aws.pinpoint.UpdateEmailTemplateRequest/Version
     :cognitect.aws.pinpoint.UpdateEmailTemplateRequest/CreateNewVersion]))

(s/def
  :cognitect.aws.pinpoint/Event
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.Event/EventType :cognitect.aws.pinpoint.Event/Timestamp]
    :opt-un
    [:cognitect.aws.pinpoint.Event/ClientSdkVersion
     :cognitect.aws.pinpoint.Event/SdkName
     :cognitect.aws.pinpoint.Event/Attributes
     :cognitect.aws.pinpoint.Event/AppTitle
     :cognitect.aws.pinpoint.Event/AppPackageName
     :cognitect.aws.pinpoint.Event/AppVersionCode
     :cognitect.aws.pinpoint.Event/Session
     :cognitect.aws.pinpoint.Event/Metrics]))

(s/def
  :cognitect.aws.pinpoint/MessageConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.MessageConfiguration/GCMMessage
     :cognitect.aws.pinpoint.MessageConfiguration/BaiduMessage
     :cognitect.aws.pinpoint.MessageConfiguration/ADMMessage
     :cognitect.aws.pinpoint.MessageConfiguration/DefaultMessage
     :cognitect.aws.pinpoint.MessageConfiguration/CustomMessage
     :cognitect.aws.pinpoint.MessageConfiguration/InAppMessage
     :cognitect.aws.pinpoint.MessageConfiguration/SMSMessage
     :cognitect.aws.pinpoint.MessageConfiguration/APNSMessage
     :cognitect.aws.pinpoint.MessageConfiguration/EmailMessage]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetSegmentResponse/SegmentResponse]))

(s/def
  :cognitect.aws.pinpoint/ListJourneysResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.ListJourneysResponse/JourneysResponse]))

(s/def
  :cognitect.aws.pinpoint/CreateEmailTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateEmailTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.CreateEmailTemplateRequest/EmailTemplateRequest]))

(s/def
  :cognitect.aws.pinpoint/WriteSegmentRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.WriteSegmentRequest/SegmentGroups
     :cognitect.aws.pinpoint.WriteSegmentRequest/tags
     :cognitect.aws.pinpoint.WriteSegmentRequest/Dimensions
     :cognitect.aws.pinpoint.WriteSegmentRequest/Name]))

(s/def
  :cognitect.aws.pinpoint/EndpointMessageResult
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.EndpointMessageResult/DeliveryStatus
     :cognitect.aws.pinpoint.EndpointMessageResult/StatusCode]
    :opt-un
    [:cognitect.aws.pinpoint.EndpointMessageResult/Address
     :cognitect.aws.pinpoint.EndpointMessageResult/MessageId
     :cognitect.aws.pinpoint.EndpointMessageResult/StatusMessage
     :cognitect.aws.pinpoint.EndpointMessageResult/UpdatedToken]))

(s/def
  :cognitect.aws.pinpoint/ListOfActivityResponse
  (s/coll-of :cognitect.aws.pinpoint/ActivityResponse))

(s/def
  :cognitect.aws.pinpoint/DeleteEventStreamRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteEventStreamRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/GetAppResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetAppResponse/ApplicationResponse]))

(s/def
  :cognitect.aws.pinpoint/GetEmailTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetEmailTemplateResponse/EmailTemplateResponse]))

(s/def
  :cognitect.aws.pinpoint/PutEventStreamResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.PutEventStreamResponse/EventStream]))

(s/def
  :cognitect.aws.pinpoint/GetSmsChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetSmsChannelResponse/SMSChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/MultiConditionalSplitActivity
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.MultiConditionalSplitActivity/DefaultActivity
     :cognitect.aws.pinpoint.MultiConditionalSplitActivity/Branches
     :cognitect.aws.pinpoint.MultiConditionalSplitActivity/EvaluationWaitTime]))

(s/def
  :cognitect.aws.pinpoint/GetApnsVoipSandboxChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetApnsVoipSandboxChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/UpdatePushTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdatePushTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/UpdateEndpointsBatchRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateEndpointsBatchRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateEndpointsBatchRequest/EndpointBatchRequest]))

(s/def
  :cognitect.aws.pinpoint/TemplateCreateMessageBody
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.TemplateCreateMessageBody/Message
     :cognitect.aws.pinpoint.TemplateCreateMessageBody/RequestID
     :cognitect.aws.pinpoint.TemplateCreateMessageBody/Arn]))

(s/def
  :cognitect.aws.pinpoint/AttributesResource
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.AttributesResource/AttributeType
     :cognitect.aws.pinpoint.AttributesResource/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.AttributesResource/Attributes]))

(s/def :cognitect.aws.pinpoint/TagsModel (s/keys :req-un [:cognitect.aws.pinpoint.TagsModel/tags]))

(s/def
  :cognitect.aws.pinpoint/TemplateResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.TemplateResponse/LastModifiedDate
     :cognitect.aws.pinpoint.TemplateResponse/CreationDate
     :cognitect.aws.pinpoint.TemplateResponse/TemplateName
     :cognitect.aws.pinpoint.TemplateResponse/TemplateType]
    :opt-un
    [:cognitect.aws.pinpoint.TemplateResponse/DefaultSubstitutions
     :cognitect.aws.pinpoint.TemplateResponse/tags
     :cognitect.aws.pinpoint.TemplateResponse/Arn
     :cognitect.aws.pinpoint.TemplateResponse/Version
     :cognitect.aws.pinpoint.TemplateResponse/TemplateDescription]))

(s/def
  :cognitect.aws.pinpoint/UpdateVoiceTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateVoiceTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.UpdateVoiceTemplateRequest/VoiceTemplateRequest]
    :opt-un
    [:cognitect.aws.pinpoint.UpdateVoiceTemplateRequest/Version
     :cognitect.aws.pinpoint.UpdateVoiceTemplateRequest/CreateNewVersion]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentExportJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetSegmentExportJobsRequest/SegmentId
     :cognitect.aws.pinpoint.GetSegmentExportJobsRequest/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.GetSegmentExportJobsRequest/PageSize
     :cognitect.aws.pinpoint.GetSegmentExportJobsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/DeleteCampaignRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteCampaignRequest/CampaignId
     :cognitect.aws.pinpoint.DeleteCampaignRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/DeleteEndpointResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteEndpointResponse/EndpointResponse]))

(s/def
  :cognitect.aws.pinpoint/MapOfListOf__string
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/ListOf__string))

(s/def
  :cognitect.aws.pinpoint/UpdateApnsSandboxChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateApnsSandboxChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateApnsSandboxChannelRequest/APNSSandboxChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/DeleteJourneyRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteJourneyRequest/JourneyId
     :cognitect.aws.pinpoint.DeleteJourneyRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/DeleteBaiduChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteBaiduChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/UpdateRecommenderConfigurationResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateRecommenderConfigurationResponse/RecommenderConfigurationResponse]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetSegmentsResponse/SegmentsResponse]))

(s/def
  :cognitect.aws.pinpoint/Frequency
  (s/spec
    string?
    :gen
    #(s/gen #{"EVENT" "ONCE" "MONTHLY" "WEEKLY" "IN_APP_EVENT" "DAILY" "HOURLY"})))

(s/def
  :cognitect.aws.pinpoint/UpdateInAppTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateInAppTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.UpdateInAppTemplateRequest/InAppTemplateRequest]
    :opt-un
    [:cognitect.aws.pinpoint.UpdateInAppTemplateRequest/Version
     :cognitect.aws.pinpoint.UpdateInAppTemplateRequest/CreateNewVersion]))

(s/def
  :cognitect.aws.pinpoint/BaiduMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.BaiduMessage/Body
     :cognitect.aws.pinpoint.BaiduMessage/ImageUrl
     :cognitect.aws.pinpoint.BaiduMessage/Title
     :cognitect.aws.pinpoint.BaiduMessage/SilentPush
     :cognitect.aws.pinpoint.BaiduMessage/Sound
     :cognitect.aws.pinpoint.BaiduMessage/TimeToLive
     :cognitect.aws.pinpoint.BaiduMessage/RawContent
     :cognitect.aws.pinpoint.BaiduMessage/Url
     :cognitect.aws.pinpoint.BaiduMessage/Substitutions
     :cognitect.aws.pinpoint.BaiduMessage/SmallImageIconUrl
     :cognitect.aws.pinpoint.BaiduMessage/IconReference
     :cognitect.aws.pinpoint.BaiduMessage/Data
     :cognitect.aws.pinpoint.BaiduMessage/ImageIconUrl
     :cognitect.aws.pinpoint.BaiduMessage/Action]))

(s/def
  :cognitect.aws.pinpoint/CreateSmsTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateSmsTemplateResponse/CreateTemplateMessageBody]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetJourneyResponse/JourneyResponse]))

(s/def
  :cognitect.aws.pinpoint/ListOfClosedDaysRules
  (s/coll-of :cognitect.aws.pinpoint/ClosedDaysRule))

(s/def
  :cognitect.aws.pinpoint/EventStream
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.EventStream/ApplicationId
     :cognitect.aws.pinpoint.EventStream/RoleArn
     :cognitect.aws.pinpoint.EventStream/DestinationStreamArn]
    :opt-un
    [:cognitect.aws.pinpoint.EventStream/LastModifiedDate
     :cognitect.aws.pinpoint.EventStream/ExternalId
     :cognitect.aws.pinpoint.EventStream/LastUpdatedBy]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyRunExecutionActivityMetricsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsResponse/JourneyRunExecutionActivityMetricsResponse]))

(s/def
  :cognitect.aws.pinpoint/JourneyRunResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.JourneyRunResponse/Status
     :cognitect.aws.pinpoint.JourneyRunResponse/LastUpdateTime
     :cognitect.aws.pinpoint.JourneyRunResponse/CreationTime
     :cognitect.aws.pinpoint.JourneyRunResponse/RunId]))

(s/def :cognitect.aws.pinpoint/Include (s/spec string? :gen #(s/gen #{"NONE" "ANY" "ALL"})))

(s/def
  :cognitect.aws.pinpoint/CreateSegmentRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateSegmentRequest/ApplicationId
     :cognitect.aws.pinpoint.CreateSegmentRequest/WriteSegmentRequest]))

(s/def
  :cognitect.aws.pinpoint/DeleteCampaignResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteCampaignResponse/CampaignResponse]))

(s/def
  :cognitect.aws.pinpoint/NumberValidateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.NumberValidateResponse/Carrier
     :cognitect.aws.pinpoint.NumberValidateResponse/CleansedPhoneNumberE164
     :cognitect.aws.pinpoint.NumberValidateResponse/PhoneTypeCode
     :cognitect.aws.pinpoint.NumberValidateResponse/Country
     :cognitect.aws.pinpoint.NumberValidateResponse/CountryCodeIso2
     :cognitect.aws.pinpoint.NumberValidateResponse/ZipCode
     :cognitect.aws.pinpoint.NumberValidateResponse/Timezone
     :cognitect.aws.pinpoint.NumberValidateResponse/CountryCodeNumeric
     :cognitect.aws.pinpoint.NumberValidateResponse/OriginalPhoneNumber
     :cognitect.aws.pinpoint.NumberValidateResponse/City
     :cognitect.aws.pinpoint.NumberValidateResponse/County
     :cognitect.aws.pinpoint.NumberValidateResponse/PhoneType
     :cognitect.aws.pinpoint.NumberValidateResponse/OriginalCountryCodeIso2
     :cognitect.aws.pinpoint.NumberValidateResponse/CleansedPhoneNumberNational]))

(s/def
  :cognitect.aws.pinpoint/GetInAppMessagesResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetInAppMessagesResponse/InAppMessagesResponse]))

(s/def
  :cognitect.aws.pinpoint/ListOf__EndpointTypesElement
  (s/coll-of :cognitect.aws.pinpoint/__EndpointTypesElement))

(s/def
  :cognitect.aws.pinpoint/APNSVoipSandboxChannelRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/PrivateKey
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/TokenKey
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/Enabled
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/BundleId
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/TokenKeyId
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/TeamId
     :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/Certificate]))

(s/def
  :cognitect.aws.pinpoint/GetInAppTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetInAppTemplateResponse/InAppTemplateResponse]))

(s/def
  :cognitect.aws.pinpoint/GetPushTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetPushTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.GetPushTemplateRequest/Version]))

(s/def
  :cognitect.aws.pinpoint/ADMMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ADMMessage/Body
     :cognitect.aws.pinpoint.ADMMessage/ImageUrl
     :cognitect.aws.pinpoint.ADMMessage/Title
     :cognitect.aws.pinpoint.ADMMessage/SilentPush
     :cognitect.aws.pinpoint.ADMMessage/ConsolidationKey
     :cognitect.aws.pinpoint.ADMMessage/Sound
     :cognitect.aws.pinpoint.ADMMessage/ExpiresAfter
     :cognitect.aws.pinpoint.ADMMessage/RawContent
     :cognitect.aws.pinpoint.ADMMessage/Url
     :cognitect.aws.pinpoint.ADMMessage/Substitutions
     :cognitect.aws.pinpoint.ADMMessage/SmallImageIconUrl
     :cognitect.aws.pinpoint.ADMMessage/IconReference
     :cognitect.aws.pinpoint.ADMMessage/Data
     :cognitect.aws.pinpoint.ADMMessage/ImageIconUrl
     :cognitect.aws.pinpoint.ADMMessage/Action
     :cognitect.aws.pinpoint.ADMMessage/MD5]))

(s/def
  :cognitect.aws.pinpoint/ListOfSimpleCondition
  (s/coll-of :cognitect.aws.pinpoint/SimpleCondition))

(s/def
  :cognitect.aws.pinpoint/DeleteSegmentRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteSegmentRequest/SegmentId
     :cognitect.aws.pinpoint.DeleteSegmentRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/DeleteVoiceTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteVoiceTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/EndpointSendConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EndpointSendConfiguration/Context
     :cognitect.aws.pinpoint.EndpointSendConfiguration/RawContent
     :cognitect.aws.pinpoint.EndpointSendConfiguration/BodyOverride
     :cognitect.aws.pinpoint.EndpointSendConfiguration/Substitutions
     :cognitect.aws.pinpoint.EndpointSendConfiguration/TitleOverride]))

(s/def
  :cognitect.aws.pinpoint/TemplateActiveVersionRequest
  (s/keys :opt-un [:cognitect.aws.pinpoint.TemplateActiveVersionRequest/Version]))

(s/def :cognitect.aws.pinpoint/ListOfResultRow (s/coll-of :cognitect.aws.pinpoint/ResultRow))

(s/def
  :cognitect.aws.pinpoint/ListOfInAppMessageContent
  (s/coll-of :cognitect.aws.pinpoint/InAppMessageContent))

(s/def
  :cognitect.aws.pinpoint/JourneyCustomMessage
  (s/keys :opt-un [:cognitect.aws.pinpoint.JourneyCustomMessage/Data]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentImportJobsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetSegmentImportJobsResponse/ImportJobsResponse]))

(s/def
  :cognitect.aws.pinpoint/APNSSandboxChannelRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.APNSSandboxChannelRequest/PrivateKey
     :cognitect.aws.pinpoint.APNSSandboxChannelRequest/TokenKey
     :cognitect.aws.pinpoint.APNSSandboxChannelRequest/Enabled
     :cognitect.aws.pinpoint.APNSSandboxChannelRequest/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.APNSSandboxChannelRequest/BundleId
     :cognitect.aws.pinpoint.APNSSandboxChannelRequest/TokenKeyId
     :cognitect.aws.pinpoint.APNSSandboxChannelRequest/TeamId
     :cognitect.aws.pinpoint.APNSSandboxChannelRequest/Certificate]))

(s/def :cognitect.aws.pinpoint/__string string?)

(s/def
  :cognitect.aws.pinpoint/EventsBatch
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.EventsBatch/Endpoint :cognitect.aws.pinpoint.EventsBatch/Events]))

(s/def
  :cognitect.aws.pinpoint/ExportJobsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ExportJobsResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.ExportJobsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/GetVoiceChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetVoiceChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/CreateRecommenderConfigurationResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateRecommenderConfigurationResponse/RecommenderConfigurationResponse]))

(s/def
  :cognitect.aws.pinpoint/EventDimensions
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EventDimensions/EventType
     :cognitect.aws.pinpoint.EventDimensions/Attributes
     :cognitect.aws.pinpoint.EventDimensions/Metrics]))

(s/def
  :cognitect.aws.pinpoint/GetExportJobsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetExportJobsResponse/ExportJobsResponse]))

(s/def
  :cognitect.aws.pinpoint/DeleteSmsTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteSmsTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.DeleteSmsTemplateRequest/Version]))

(s/def
  :cognitect.aws.pinpoint/JourneyLimits
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.JourneyLimits/MessagesPerSecond
     :cognitect.aws.pinpoint.JourneyLimits/TotalCap
     :cognitect.aws.pinpoint.JourneyLimits/EndpointReentryCap
     :cognitect.aws.pinpoint.JourneyLimits/TimeframeCap
     :cognitect.aws.pinpoint.JourneyLimits/DailyCap
     :cognitect.aws.pinpoint.JourneyLimits/EndpointReentryInterval]))

(s/def
  :cognitect.aws.pinpoint/TemplatesResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.TemplatesResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.TemplatesResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.pinpoint/CreateExportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateExportJobRequest/ApplicationId
     :cognitect.aws.pinpoint.CreateExportJobRequest/ExportJobRequest]))

(s/def
  :cognitect.aws.pinpoint/DeleteEndpointRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteEndpointRequest/ApplicationId
     :cognitect.aws.pinpoint.DeleteEndpointRequest/EndpointId]))

(s/def
  :cognitect.aws.pinpoint/ButtonAction
  (s/spec string? :gen #(s/gen #{"CLOSE" "LINK" "DEEP_LINK"})))

(s/def
  :cognitect.aws.pinpoint/CampaignCustomMessage
  (s/keys :opt-un [:cognitect.aws.pinpoint.CampaignCustomMessage/Data]))

(s/def
  :cognitect.aws.pinpoint/CreateAppRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateAppRequest/CreateApplicationRequest]))

(s/def
  :cognitect.aws.pinpoint/CreateVoiceTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateVoiceTemplateResponse/CreateTemplateMessageBody]))

(s/def
  :cognitect.aws.pinpoint/EmailTemplateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EmailTemplateRequest/DefaultSubstitutions
     :cognitect.aws.pinpoint.EmailTemplateRequest/tags
     :cognitect.aws.pinpoint.EmailTemplateRequest/HtmlPart
     :cognitect.aws.pinpoint.EmailTemplateRequest/RecommenderId
     :cognitect.aws.pinpoint.EmailTemplateRequest/TextPart
     :cognitect.aws.pinpoint.EmailTemplateRequest/Subject
     :cognitect.aws.pinpoint.EmailTemplateRequest/TemplateDescription
     :cognitect.aws.pinpoint.EmailTemplateRequest/Headers]))

(s/def
  :cognitect.aws.pinpoint/OverrideButtonConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.OverrideButtonConfiguration/ButtonAction]
    :opt-un
    [:cognitect.aws.pinpoint.OverrideButtonConfiguration/Link]))

(s/def
  :cognitect.aws.pinpoint/JourneyPushMessage
  (s/keys :opt-un [:cognitect.aws.pinpoint.JourneyPushMessage/TimeToLive]))

(s/def
  :cognitect.aws.pinpoint/GetExportJobResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetExportJobResponse/ExportJobResponse]))

(s/def
  :cognitect.aws.pinpoint/DeleteApnsVoipChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteApnsVoipChannelResponse/APNSVoipChannelResponse]))

(s/def :cognitect.aws.pinpoint/Format (s/spec string? :gen #(s/gen #{"CSV" "JSON"})))

(s/def
  :cognitect.aws.pinpoint/GetImportJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetImportJobsRequest/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.GetImportJobsRequest/PageSize
     :cognitect.aws.pinpoint.GetImportJobsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/UpdateJourneyRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateJourneyRequest/JourneyId
     :cognitect.aws.pinpoint.UpdateJourneyRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateJourneyRequest/WriteJourneyRequest]))

(s/def
  :cognitect.aws.pinpoint/ListOfWriteTreatmentResource
  (s/coll-of :cognitect.aws.pinpoint/WriteTreatmentResource))

(s/def
  :cognitect.aws.pinpoint/VoiceChannelRequest
  (s/keys :opt-un [:cognitect.aws.pinpoint.VoiceChannelRequest/Enabled]))

(s/def
  :cognitect.aws.pinpoint/VerifyOTPMessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.VerifyOTPMessageRequest/ApplicationId
     :cognitect.aws.pinpoint.VerifyOTPMessageRequest/VerifyOTPMessageRequestParameters]))

(s/def
  :cognitect.aws.pinpoint/ADMChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ADMChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.ADMChannelResponse/HasCredential
     :cognitect.aws.pinpoint.ADMChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.ADMChannelResponse/Enabled
     :cognitect.aws.pinpoint.ADMChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.ADMChannelResponse/IsArchived
     :cognitect.aws.pinpoint.ADMChannelResponse/CreationDate
     :cognitect.aws.pinpoint.ADMChannelResponse/Version
     :cognitect.aws.pinpoint.ADMChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.ADMChannelResponse/Id]))

(s/def :cognitect.aws.pinpoint/Alignment (s/spec string? :gen #(s/gen #{"LEFT" "CENTER" "RIGHT"})))

(s/def
  :cognitect.aws.pinpoint/DeleteApnsSandboxChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteApnsSandboxChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/CampaignStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"COMPLETED" "EXECUTING" "SCHEDULED" "INVALID" "DELETED" "PAUSED" "PENDING_NEXT_RUN"})))

(s/def
  :cognitect.aws.pinpoint/ListOfJourneyRunResponse
  (s/coll-of :cognitect.aws.pinpoint/JourneyRunResponse))

(s/def
  :cognitect.aws.pinpoint/SMSChannelRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SMSChannelRequest/ShortCode
     :cognitect.aws.pinpoint.SMSChannelRequest/Enabled
     :cognitect.aws.pinpoint.SMSChannelRequest/SenderId]))

(s/def
  :cognitect.aws.pinpoint/CustomMessageActivity
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.CustomMessageActivity/MessageConfig
     :cognitect.aws.pinpoint.CustomMessageActivity/EndpointTypes
     :cognitect.aws.pinpoint.CustomMessageActivity/TemplateVersion
     :cognitect.aws.pinpoint.CustomMessageActivity/TemplateName
     :cognitect.aws.pinpoint.CustomMessageActivity/DeliveryUri
     :cognitect.aws.pinpoint.CustomMessageActivity/NextActivity]))

(s/def
  :cognitect.aws.pinpoint/ListTemplatesResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.ListTemplatesResponse/TemplatesResponse]))

(s/def
  :cognitect.aws.pinpoint/GetAdmChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetAdmChannelResponse/ADMChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/DefaultPushNotificationTemplate
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Body
     :cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Title
     :cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Sound
     :cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Url
     :cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Action]))

(s/def
  :cognitect.aws.pinpoint/InternalServerErrorException
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.InternalServerErrorException/Message
     :cognitect.aws.pinpoint.InternalServerErrorException/RequestID]))

(s/def
  :cognitect.aws.pinpoint/CampaignSmsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.CampaignSmsMessage/Body
     :cognitect.aws.pinpoint.CampaignSmsMessage/SenderId
     :cognitect.aws.pinpoint.CampaignSmsMessage/OriginationNumber
     :cognitect.aws.pinpoint.CampaignSmsMessage/TemplateId
     :cognitect.aws.pinpoint.CampaignSmsMessage/MessageType
     :cognitect.aws.pinpoint.CampaignSmsMessage/EntityId]))

(s/def
  :cognitect.aws.pinpoint/CampaignsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CampaignsResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.CampaignsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/VoiceMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.VoiceMessage/Body
     :cognitect.aws.pinpoint.VoiceMessage/OriginationNumber
     :cognitect.aws.pinpoint.VoiceMessage/LanguageCode
     :cognitect.aws.pinpoint.VoiceMessage/Substitutions
     :cognitect.aws.pinpoint.VoiceMessage/VoiceId]))

(s/def
  :cognitect.aws.pinpoint/RandomSplitActivity
  (s/keys :opt-un [:cognitect.aws.pinpoint.RandomSplitActivity/Branches]))

(s/def
  :cognitect.aws.pinpoint/SMSMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SMSMessage/Body
     :cognitect.aws.pinpoint.SMSMessage/SenderId
     :cognitect.aws.pinpoint.SMSMessage/OriginationNumber
     :cognitect.aws.pinpoint.SMSMessage/Substitutions
     :cognitect.aws.pinpoint.SMSMessage/TemplateId
     :cognitect.aws.pinpoint.SMSMessage/Keyword
     :cognitect.aws.pinpoint.SMSMessage/MessageType
     :cognitect.aws.pinpoint.SMSMessage/MediaUrl
     :cognitect.aws.pinpoint.SMSMessage/EntityId]))

(s/def
  :cognitect.aws.pinpoint/DeleteJourneyResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteJourneyResponse/JourneyResponse]))

(s/def
  :cognitect.aws.pinpoint/GetEndpointResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetEndpointResponse/EndpointResponse]))

(s/def
  :cognitect.aws.pinpoint/CreateCampaignRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateCampaignRequest/ApplicationId
     :cognitect.aws.pinpoint.CreateCampaignRequest/WriteCampaignRequest]))

(s/def
  :cognitect.aws.pinpoint/UpdateCampaignRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateCampaignRequest/CampaignId
     :cognitect.aws.pinpoint.UpdateCampaignRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateCampaignRequest/WriteCampaignRequest]))

(s/def
  :cognitect.aws.pinpoint/GetRecommenderConfigurationRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetRecommenderConfigurationRequest/RecommenderId]))

(s/def
  :cognitect.aws.pinpoint/GetApplicationDateRangeKpiResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetApplicationDateRangeKpiResponse/ApplicationDateRangeKpiResponse]))

(s/def
  :cognitect.aws.pinpoint/GetEmailChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetEmailChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetCampaignResponse/CampaignResponse]))

(s/def
  :cognitect.aws.pinpoint/GetSmsChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetSmsChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/GCMChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GCMChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.GCMChannelResponse/HasCredential
     :cognitect.aws.pinpoint.GCMChannelResponse/Credential
     :cognitect.aws.pinpoint.GCMChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.GCMChannelResponse/Enabled
     :cognitect.aws.pinpoint.GCMChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.GCMChannelResponse/IsArchived
     :cognitect.aws.pinpoint.GCMChannelResponse/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.GCMChannelResponse/HasFcmServiceCredentials
     :cognitect.aws.pinpoint.GCMChannelResponse/CreationDate
     :cognitect.aws.pinpoint.GCMChannelResponse/Version
     :cognitect.aws.pinpoint.GCMChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.GCMChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/JourneyChannelSettings
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.JourneyChannelSettings/ConnectCampaignExecutionRoleArn
     :cognitect.aws.pinpoint.JourneyChannelSettings/ConnectCampaignArn]))

(s/def
  :cognitect.aws.pinpoint/SMSMessageActivity
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SMSMessageActivity/MessageConfig
     :cognitect.aws.pinpoint.SMSMessageActivity/TemplateVersion
     :cognitect.aws.pinpoint.SMSMessageActivity/TemplateName
     :cognitect.aws.pinpoint.SMSMessageActivity/NextActivity]))

(s/def
  :cognitect.aws.pinpoint/DeleteInAppTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteInAppTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/ImportJobsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ImportJobsResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.ImportJobsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/MapOfMetricDimension
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/MetricDimension))

(s/def
  :cognitect.aws.pinpoint/InAppMessagesResponse
  (s/keys :opt-un [:cognitect.aws.pinpoint.InAppMessagesResponse/InAppMessageCampaigns]))

(s/def
  :cognitect.aws.pinpoint/GetApnsSandboxChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetApnsSandboxChannelResponse/APNSSandboxChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/CreateApplicationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateApplicationRequest/Name]
    :opt-un
    [:cognitect.aws.pinpoint.CreateApplicationRequest/tags]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyRequest/JourneyId
     :cognitect.aws.pinpoint.GetJourneyRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/ListOfApplicationResponse
  (s/coll-of :cognitect.aws.pinpoint/ApplicationResponse))

(s/def
  :cognitect.aws.pinpoint/UpdateSmsChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateSmsChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateSmsChannelRequest/SMSChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/APNSPushNotificationTemplate
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.APNSPushNotificationTemplate/Body
     :cognitect.aws.pinpoint.APNSPushNotificationTemplate/Title
     :cognitect.aws.pinpoint.APNSPushNotificationTemplate/Sound
     :cognitect.aws.pinpoint.APNSPushNotificationTemplate/RawContent
     :cognitect.aws.pinpoint.APNSPushNotificationTemplate/Url
     :cognitect.aws.pinpoint.APNSPushNotificationTemplate/MediaUrl
     :cognitect.aws.pinpoint.APNSPushNotificationTemplate/Action]))

(s/def
  :cognitect.aws.pinpoint/GetSmsTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetSmsTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.GetSmsTemplateRequest/Version]))

(s/def
  :cognitect.aws.pinpoint/GetApnsChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetApnsChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/CreateExportJobResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateExportJobResponse/ExportJobResponse]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyDateRangeKpiResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyDateRangeKpiResponse/JourneyDateRangeKpiResponse]))

(s/def
  :cognitect.aws.pinpoint/ApplicationSettingsJourneyLimits
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ApplicationSettingsJourneyLimits/TotalCap
     :cognitect.aws.pinpoint.ApplicationSettingsJourneyLimits/TimeframeCap
     :cognitect.aws.pinpoint.ApplicationSettingsJourneyLimits/DailyCap]))

(s/def
  :cognitect.aws.pinpoint/SegmentReference
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SegmentReference/Id]
    :opt-un
    [:cognitect.aws.pinpoint.SegmentReference/Version]))

(s/def
  :cognitect.aws.pinpoint/VoiceTemplateResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.VoiceTemplateResponse/LastModifiedDate
     :cognitect.aws.pinpoint.VoiceTemplateResponse/CreationDate
     :cognitect.aws.pinpoint.VoiceTemplateResponse/TemplateName
     :cognitect.aws.pinpoint.VoiceTemplateResponse/TemplateType]
    :opt-un
    [:cognitect.aws.pinpoint.VoiceTemplateResponse/DefaultSubstitutions
     :cognitect.aws.pinpoint.VoiceTemplateResponse/Body
     :cognitect.aws.pinpoint.VoiceTemplateResponse/tags
     :cognitect.aws.pinpoint.VoiceTemplateResponse/LanguageCode
     :cognitect.aws.pinpoint.VoiceTemplateResponse/Arn
     :cognitect.aws.pinpoint.VoiceTemplateResponse/VoiceId
     :cognitect.aws.pinpoint.VoiceTemplateResponse/Version
     :cognitect.aws.pinpoint.VoiceTemplateResponse/TemplateDescription]))

(s/def
  :cognitect.aws.pinpoint/DeleteRecommenderConfigurationRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteRecommenderConfigurationRequest/RecommenderId]))

(s/def
  :cognitect.aws.pinpoint/UpdateEndpointsBatchResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateEndpointsBatchResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/MetricDimension
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.MetricDimension/ComparisonOperator
     :cognitect.aws.pinpoint.MetricDimension/Value]))

(s/def
  :cognitect.aws.pinpoint/ConditionalSplitActivity
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ConditionalSplitActivity/FalseActivity
     :cognitect.aws.pinpoint.ConditionalSplitActivity/TrueActivity
     :cognitect.aws.pinpoint.ConditionalSplitActivity/Condition
     :cognitect.aws.pinpoint.ConditionalSplitActivity/EvaluationWaitTime]))

(s/def
  :cognitect.aws.pinpoint/MapOfEvent
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/Event))

(s/def
  :cognitect.aws.pinpoint/ApplicationSettingsResource
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ApplicationSettingsResource/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.ApplicationSettingsResource/QuietTime
     :cognitect.aws.pinpoint.ApplicationSettingsResource/LastModifiedDate
     :cognitect.aws.pinpoint.ApplicationSettingsResource/Limits
     :cognitect.aws.pinpoint.ApplicationSettingsResource/JourneyLimits
     :cognitect.aws.pinpoint.ApplicationSettingsResource/CampaignHook]))

(s/def
  :cognitect.aws.pinpoint/MessageType
  (s/spec string? :gen #(s/gen #{"TRANSACTIONAL" "PROMOTIONAL"})))

(s/def
  :cognitect.aws.pinpoint/GetJourneyExecutionActivityMetricsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/JourneyActivityId
     :cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/ApplicationId
     :cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/JourneyId]
    :opt-un
    [:cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/PageSize
     :cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint/UpdateJourneyResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateJourneyResponse/JourneyResponse]))

(s/def :cognitect.aws.pinpoint/RawEmail (s/keys :opt-un [:cognitect.aws.pinpoint.RawEmail/Data]))

(s/def
  :cognitect.aws.pinpoint/DayOfWeek
  (s/spec
    string?
    :gen
    #(s/gen #{"WEDNESDAY" "SUNDAY" "THURSDAY" "TUESDAY" "FRIDAY" "SATURDAY" "MONDAY"})))

(s/def
  :cognitect.aws.pinpoint/UpdateApnsChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateApnsChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateApnsChannelRequest/APNSChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/APNSChannelRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.APNSChannelRequest/PrivateKey
     :cognitect.aws.pinpoint.APNSChannelRequest/TokenKey
     :cognitect.aws.pinpoint.APNSChannelRequest/Enabled
     :cognitect.aws.pinpoint.APNSChannelRequest/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.APNSChannelRequest/BundleId
     :cognitect.aws.pinpoint.APNSChannelRequest/TokenKeyId
     :cognitect.aws.pinpoint.APNSChannelRequest/TeamId
     :cognitect.aws.pinpoint.APNSChannelRequest/Certificate]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignVersionResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetCampaignVersionResponse/CampaignResponse]))

(s/def
  :cognitect.aws.pinpoint/MapOfItemResponse
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/ItemResponse))

(s/def
  :cognitect.aws.pinpoint/CreateSegmentResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateSegmentResponse/SegmentResponse]))

(s/def
  :cognitect.aws.pinpoint/GetVoiceChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetVoiceChannelResponse/VoiceChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/DefaultMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.DefaultMessage/Body
     :cognitect.aws.pinpoint.DefaultMessage/Substitutions]))

(s/def
  :cognitect.aws.pinpoint/UpdateJourneyStateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateJourneyStateRequest/JourneyId
     :cognitect.aws.pinpoint.UpdateJourneyStateRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateJourneyStateRequest/JourneyStateRequest]))

(s/def
  :cognitect.aws.pinpoint/DeleteInAppTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteInAppTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.DeleteInAppTemplateRequest/Version]))

(s/def
  :cognitect.aws.pinpoint/PublicEndpoint
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.PublicEndpoint/Address
     :cognitect.aws.pinpoint.PublicEndpoint/EndpointStatus
     :cognitect.aws.pinpoint.PublicEndpoint/RequestId
     :cognitect.aws.pinpoint.PublicEndpoint/Location
     :cognitect.aws.pinpoint.PublicEndpoint/Demographic
     :cognitect.aws.pinpoint.PublicEndpoint/User
     :cognitect.aws.pinpoint.PublicEndpoint/Attributes
     :cognitect.aws.pinpoint.PublicEndpoint/EffectiveDate
     :cognitect.aws.pinpoint.PublicEndpoint/OptOut
     :cognitect.aws.pinpoint.PublicEndpoint/ChannelType
     :cognitect.aws.pinpoint.PublicEndpoint/Metrics]))

(s/def
  :cognitect.aws.pinpoint/UpdateApnsVoipSandboxChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateApnsVoipSandboxChannelResponse/APNSVoipSandboxChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/JourneyStateRequest
  (s/keys :opt-un [:cognitect.aws.pinpoint.JourneyStateRequest/State]))

(s/def
  :cognitect.aws.pinpoint/Action
  (s/spec string? :gen #(s/gen #{"URL" "OPEN_APP" "DEEP_LINK"})))

(s/def
  :cognitect.aws.pinpoint/ApplicationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ApplicationsResponse/NextToken
     :cognitect.aws.pinpoint.ApplicationsResponse/Item]))

(s/def
  :cognitect.aws.pinpoint/ForbiddenException
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ForbiddenException/Message
     :cognitect.aws.pinpoint.ForbiddenException/RequestID]))

(s/def
  :cognitect.aws.pinpoint/GetApnsVoipChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetApnsVoipChannelResponse/APNSVoipChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/EmailMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EmailMessage/RawEmail
     :cognitect.aws.pinpoint.EmailMessage/SimpleEmail
     :cognitect.aws.pinpoint.EmailMessage/Body
     :cognitect.aws.pinpoint.EmailMessage/Substitutions
     :cognitect.aws.pinpoint.EmailMessage/FromAddress
     :cognitect.aws.pinpoint.EmailMessage/FeedbackForwardingAddress
     :cognitect.aws.pinpoint.EmailMessage/ReplyToAddresses]))

(s/def
  :cognitect.aws.pinpoint/BadRequestException
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.BadRequestException/Message
     :cognitect.aws.pinpoint.BadRequestException/RequestID]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetCampaignsRequest/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.GetCampaignsRequest/PageSize
     :cognitect.aws.pinpoint.GetCampaignsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/UpdateSmsChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateSmsChannelResponse/SMSChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/SendOTPMessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SendOTPMessageRequest/ApplicationId
     :cognitect.aws.pinpoint.SendOTPMessageRequest/SendOTPMessageRequestParameters]))

(s/def
  :cognitect.aws.pinpoint/UpdateApplicationSettingsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateApplicationSettingsResponse/ApplicationSettingsResource]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignDateRangeKpiRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/ApplicationId
     :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/KpiName
     :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/CampaignId]
    :opt-un
    [:cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/EndTime
     :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/PageSize
     :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/StartTime
     :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint/UpdateApnsChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateApnsChannelResponse/APNSChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/ListOfTreatmentResource
  (s/coll-of :cognitect.aws.pinpoint/TreatmentResource))

(s/def
  :cognitect.aws.pinpoint/GetBaiduChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetBaiduChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/ContactCenterActivity
  (s/keys :opt-un [:cognitect.aws.pinpoint.ContactCenterActivity/NextActivity]))

(s/def
  :cognitect.aws.pinpoint/JourneyResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.JourneyResponse/Name
     :cognitect.aws.pinpoint.JourneyResponse/Id
     :cognitect.aws.pinpoint.JourneyResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.JourneyResponse/Activities
     :cognitect.aws.pinpoint.JourneyResponse/RefreshFrequency
     :cognitect.aws.pinpoint.JourneyResponse/QuietTime
     :cognitect.aws.pinpoint.JourneyResponse/LocalTime
     :cognitect.aws.pinpoint.JourneyResponse/LastModifiedDate
     :cognitect.aws.pinpoint.JourneyResponse/TimezoneEstimationMethods
     :cognitect.aws.pinpoint.JourneyResponse/StartActivity
     :cognitect.aws.pinpoint.JourneyResponse/tags
     :cognitect.aws.pinpoint.JourneyResponse/RefreshOnSegmentUpdate
     :cognitect.aws.pinpoint.JourneyResponse/ClosedDays
     :cognitect.aws.pinpoint.JourneyResponse/Limits
     :cognitect.aws.pinpoint.JourneyResponse/StartCondition
     :cognitect.aws.pinpoint.JourneyResponse/JourneyChannelSettings
     :cognitect.aws.pinpoint.JourneyResponse/CreationDate
     :cognitect.aws.pinpoint.JourneyResponse/State
     :cognitect.aws.pinpoint.JourneyResponse/SendingSchedule
     :cognitect.aws.pinpoint.JourneyResponse/Schedule
     :cognitect.aws.pinpoint.JourneyResponse/OpenHours
     :cognitect.aws.pinpoint.JourneyResponse/WaitForQuietTime]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignDateRangeKpiResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetCampaignDateRangeKpiResponse/CampaignDateRangeKpiResponse]))

(s/def
  :cognitect.aws.pinpoint/UpdateSegmentRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateSegmentRequest/SegmentId
     :cognitect.aws.pinpoint.UpdateSegmentRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateSegmentRequest/WriteSegmentRequest]))

(s/def
  :cognitect.aws.pinpoint/UpdatePushTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdatePushTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.UpdatePushTemplateRequest/PushNotificationTemplateRequest]
    :opt-un
    [:cognitect.aws.pinpoint.UpdatePushTemplateRequest/Version
     :cognitect.aws.pinpoint.UpdatePushTemplateRequest/CreateNewVersion]))

(s/def
  :cognitect.aws.pinpoint/UpdateEmailChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateEmailChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateEmailChannelRequest/EmailChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/UpdateApnsSandboxChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateApnsSandboxChannelResponse/APNSSandboxChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/UpdateRecommenderConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateRecommenderConfigurationRequest/RecommenderId
     :cognitect.aws.pinpoint.UpdateRecommenderConfigurationRequest/UpdateRecommenderConfiguration]))

(s/def
  :cognitect.aws.pinpoint/CreateVoiceTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateVoiceTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.CreateVoiceTemplateRequest/VoiceTemplateRequest]))

(s/def
  :cognitect.aws.pinpoint/DeleteApnsSandboxChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteApnsSandboxChannelResponse/APNSSandboxChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/PushNotificationTemplateResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.PushNotificationTemplateResponse/LastModifiedDate
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/CreationDate
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/TemplateType
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.PushNotificationTemplateResponse/DefaultSubstitutions
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/Default
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/ADM
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/GCM
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/APNS
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/tags
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/Baidu
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/RecommenderId
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/Arn
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/Version
     :cognitect.aws.pinpoint.PushNotificationTemplateResponse/TemplateDescription]))

(s/def
  :cognitect.aws.pinpoint/CampaignEventFilter
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CampaignEventFilter/FilterType
     :cognitect.aws.pinpoint.CampaignEventFilter/Dimensions]))

(s/def
  :cognitect.aws.pinpoint/ListOfRecommenderConfigurationResponse
  (s/coll-of :cognitect.aws.pinpoint/RecommenderConfigurationResponse))

(s/def
  :cognitect.aws.pinpoint/SegmentDimensions
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SegmentDimensions/Behavior
     :cognitect.aws.pinpoint.SegmentDimensions/Location
     :cognitect.aws.pinpoint.SegmentDimensions/Demographic
     :cognitect.aws.pinpoint.SegmentDimensions/Attributes
     :cognitect.aws.pinpoint.SegmentDimensions/UserAttributes
     :cognitect.aws.pinpoint.SegmentDimensions/Metrics]))

(s/def
  :cognitect.aws.pinpoint/PayloadTooLargeException
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.PayloadTooLargeException/Message
     :cognitect.aws.pinpoint.PayloadTooLargeException/RequestID]))

(s/def
  :cognitect.aws.pinpoint/UpdateAdmChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateAdmChannelResponse/ADMChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/UpdateEmailChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateEmailChannelResponse/EmailChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/EndpointResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EndpointResponse/Address
     :cognitect.aws.pinpoint.EndpointResponse/CohortId
     :cognitect.aws.pinpoint.EndpointResponse/EndpointStatus
     :cognitect.aws.pinpoint.EndpointResponse/RequestId
     :cognitect.aws.pinpoint.EndpointResponse/Location
     :cognitect.aws.pinpoint.EndpointResponse/Demographic
     :cognitect.aws.pinpoint.EndpointResponse/User
     :cognitect.aws.pinpoint.EndpointResponse/Attributes
     :cognitect.aws.pinpoint.EndpointResponse/ApplicationId
     :cognitect.aws.pinpoint.EndpointResponse/CreationDate
     :cognitect.aws.pinpoint.EndpointResponse/EffectiveDate
     :cognitect.aws.pinpoint.EndpointResponse/OptOut
     :cognitect.aws.pinpoint.EndpointResponse/Id
     :cognitect.aws.pinpoint.EndpointResponse/ChannelType
     :cognitect.aws.pinpoint.EndpointResponse/Metrics]))

(s/def
  :cognitect.aws.pinpoint/GetAppsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetAppsResponse/ApplicationsResponse]))

(s/def
  :cognitect.aws.pinpoint/CreatePushTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreatePushTemplateResponse/CreateTemplateMessageBody]))

(s/def
  :cognitect.aws.pinpoint/GetRecommenderConfigurationsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetRecommenderConfigurationsResponse/ListRecommenderConfigurationsResponse]))

(s/def
  :cognitect.aws.pinpoint/DeleteApnsChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteApnsChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/DeleteEventStreamResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteEventStreamResponse/EventStream]))

(s/def
  :cognitect.aws.pinpoint/InAppTemplateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.InAppTemplateRequest/CustomConfig
     :cognitect.aws.pinpoint.InAppTemplateRequest/tags
     :cognitect.aws.pinpoint.InAppTemplateRequest/Content
     :cognitect.aws.pinpoint.InAppTemplateRequest/TemplateDescription
     :cognitect.aws.pinpoint.InAppTemplateRequest/Layout]))

(s/def
  :cognitect.aws.pinpoint/JourneyRunsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.JourneyRunsResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.JourneyRunsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/NumberValidateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.NumberValidateRequest/IsoCountryCode
     :cognitect.aws.pinpoint.NumberValidateRequest/PhoneNumber]))

(s/def
  :cognitect.aws.pinpoint/JourneyRunExecutionActivityMetricsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/Metrics
     :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/JourneyId
     :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/LastEvaluatedTime
     :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/JourneyActivityId
     :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/ActivityType
     :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/RunId
     :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/MapOfMessageResult
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/MessageResult))

(s/def
  :cognitect.aws.pinpoint/DeleteVoiceTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteVoiceTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.DeleteVoiceTemplateRequest/Version]))

(s/def
  :cognitect.aws.pinpoint/VerifyOTPMessageRequestParameters
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.VerifyOTPMessageRequestParameters/ReferenceId
     :cognitect.aws.pinpoint.VerifyOTPMessageRequestParameters/Otp
     :cognitect.aws.pinpoint.VerifyOTPMessageRequestParameters/DestinationIdentity]))

(s/def
  :cognitect.aws.pinpoint/MapOf__integer
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/__integer))

(s/def
  :cognitect.aws.pinpoint/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UntagResourceRequest/TagKeys
     :cognitect.aws.pinpoint.UntagResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.pinpoint/ListOf__TimezoneEstimationMethodsElement
  (s/coll-of :cognitect.aws.pinpoint/__TimezoneEstimationMethodsElement))

(s/def
  :cognitect.aws.pinpoint/DefaultButtonConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DefaultButtonConfiguration/ButtonAction
     :cognitect.aws.pinpoint.DefaultButtonConfiguration/Text]
    :opt-un
    [:cognitect.aws.pinpoint.DefaultButtonConfiguration/Link
     :cognitect.aws.pinpoint.DefaultButtonConfiguration/BorderRadius
     :cognitect.aws.pinpoint.DefaultButtonConfiguration/BackgroundColor
     :cognitect.aws.pinpoint.DefaultButtonConfiguration/TextColor]))

(s/def
  :cognitect.aws.pinpoint/GetRecommenderConfigurationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.GetRecommenderConfigurationsRequest/PageSize
     :cognitect.aws.pinpoint.GetRecommenderConfigurationsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/DeleteVoiceChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteVoiceChannelResponse/VoiceChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/GetSmsTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetSmsTemplateResponse/SMSTemplateResponse]))

(s/def
  :cognitect.aws.pinpoint/ListTemplateVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ListTemplateVersionsRequest/TemplateName
     :cognitect.aws.pinpoint.ListTemplateVersionsRequest/TemplateType]
    :opt-un
    [:cognitect.aws.pinpoint.ListTemplateVersionsRequest/PageSize
     :cognitect.aws.pinpoint.ListTemplateVersionsRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint/GetSegmentsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetSegmentsRequest/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.GetSegmentsRequest/PageSize
     :cognitect.aws.pinpoint.GetSegmentsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/ChannelResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ChannelResponse/HasCredential
     :cognitect.aws.pinpoint.ChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.ChannelResponse/Enabled
     :cognitect.aws.pinpoint.ChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.ChannelResponse/IsArchived
     :cognitect.aws.pinpoint.ChannelResponse/CreationDate
     :cognitect.aws.pinpoint.ChannelResponse/Version
     :cognitect.aws.pinpoint.ChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.ChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/PushMessageActivity
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.PushMessageActivity/MessageConfig
     :cognitect.aws.pinpoint.PushMessageActivity/TemplateVersion
     :cognitect.aws.pinpoint.PushMessageActivity/TemplateName
     :cognitect.aws.pinpoint.PushMessageActivity/NextActivity]))

(s/def
  :cognitect.aws.pinpoint/DimensionType
  (s/spec string? :gen #(s/gen #{"EXCLUSIVE" "INCLUSIVE"})))

(s/def
  :cognitect.aws.pinpoint/EmailTemplateResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.EmailTemplateResponse/LastModifiedDate
     :cognitect.aws.pinpoint.EmailTemplateResponse/CreationDate
     :cognitect.aws.pinpoint.EmailTemplateResponse/TemplateName
     :cognitect.aws.pinpoint.EmailTemplateResponse/TemplateType]
    :opt-un
    [:cognitect.aws.pinpoint.EmailTemplateResponse/DefaultSubstitutions
     :cognitect.aws.pinpoint.EmailTemplateResponse/tags
     :cognitect.aws.pinpoint.EmailTemplateResponse/HtmlPart
     :cognitect.aws.pinpoint.EmailTemplateResponse/RecommenderId
     :cognitect.aws.pinpoint.EmailTemplateResponse/TextPart
     :cognitect.aws.pinpoint.EmailTemplateResponse/Subject
     :cognitect.aws.pinpoint.EmailTemplateResponse/Arn
     :cognitect.aws.pinpoint.EmailTemplateResponse/Version
     :cognitect.aws.pinpoint.EmailTemplateResponse/TemplateDescription
     :cognitect.aws.pinpoint.EmailTemplateResponse/Headers]))

(s/def
  :cognitect.aws.pinpoint/InAppMessageContent
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.InAppMessageContent/ImageUrl
     :cognitect.aws.pinpoint.InAppMessageContent/HeaderConfig
     :cognitect.aws.pinpoint.InAppMessageContent/BackgroundColor
     :cognitect.aws.pinpoint.InAppMessageContent/SecondaryBtn
     :cognitect.aws.pinpoint.InAppMessageContent/PrimaryBtn
     :cognitect.aws.pinpoint.InAppMessageContent/BodyConfig]))

(s/def
  :cognitect.aws.pinpoint/Duration
  (s/spec string? :gen #(s/gen #{"DAY_14" "HR_24" "DAY_30" "DAY_7"})))

(s/def
  :cognitect.aws.pinpoint/__EndpointTypesElement
  (s/spec
    string?
    :gen
    #(s/gen
      #{"VOICE"
        "CUSTOM"
        "IN_APP"
        "SMS"
        "APNS_VOIP"
        "ADM"
        "BAIDU"
        "GCM"
        "APNS"
        "APNS_VOIP_SANDBOX"
        "PUSH"
        "APNS_SANDBOX"
        "EMAIL"})))

(s/def
  :cognitect.aws.pinpoint/ListOfEndpointResponse
  (s/coll-of :cognitect.aws.pinpoint/EndpointResponse))

(s/def
  :cognitect.aws.pinpoint/DeliveryStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"PERMANENT_FAILURE"
        "OPT_OUT"
        "TEMPORARY_FAILURE"
        "UNKNOWN_FAILURE"
        "DUPLICATE"
        "THROTTLED"
        "SUCCESSFUL"})))

(s/def :cognitect.aws.pinpoint/Operator (s/spec string? :gen #(s/gen #{"ANY" "ALL"})))

(s/def
  :cognitect.aws.pinpoint/DirectMessageConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.DirectMessageConfiguration/GCMMessage
     :cognitect.aws.pinpoint.DirectMessageConfiguration/BaiduMessage
     :cognitect.aws.pinpoint.DirectMessageConfiguration/ADMMessage
     :cognitect.aws.pinpoint.DirectMessageConfiguration/DefaultMessage
     :cognitect.aws.pinpoint.DirectMessageConfiguration/SMSMessage
     :cognitect.aws.pinpoint.DirectMessageConfiguration/VoiceMessage
     :cognitect.aws.pinpoint.DirectMessageConfiguration/DefaultPushNotificationMessage
     :cognitect.aws.pinpoint.DirectMessageConfiguration/APNSMessage
     :cognitect.aws.pinpoint.DirectMessageConfiguration/EmailMessage]))

(s/def
  :cognitect.aws.pinpoint/GetBaiduChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetBaiduChannelResponse/BaiduChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/TemplateType
  (s/spec string? :gen #(s/gen #{"VOICE" "SMS" "PUSH" "EMAIL" "INAPP"})))

(s/def
  :cognitect.aws.pinpoint/ListJourneysRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ListJourneysRequest/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.ListJourneysRequest/PageSize
     :cognitect.aws.pinpoint.ListJourneysRequest/Token]))

(s/def :cognitect.aws.pinpoint/Type (s/spec string? :gen #(s/gen #{"NONE" "ANY" "ALL"})))

(s/def :cognitect.aws.pinpoint/SegmentType (s/spec string? :gen #(s/gen #{"IMPORT" "DIMENSIONAL"})))

(s/def
  :cognitect.aws.pinpoint/GetVoiceTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetVoiceTemplateRequest/TemplateName]
    :opt-un
    [:cognitect.aws.pinpoint.GetVoiceTemplateRequest/Version]))

(s/def
  :cognitect.aws.pinpoint/CreateAppResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateAppResponse/ApplicationResponse]))

(s/def
  :cognitect.aws.pinpoint/UpdateBaiduChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateBaiduChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateBaiduChannelRequest/BaiduChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/ResultRowValue
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ResultRowValue/Type
     :cognitect.aws.pinpoint.ResultRowValue/Value
     :cognitect.aws.pinpoint.ResultRowValue/Key]))

(s/def
  :cognitect.aws.pinpoint/DeleteRecommenderConfigurationResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.DeleteRecommenderConfigurationResponse/RecommenderConfigurationResponse]))

(s/def
  :cognitect.aws.pinpoint/ListOfInAppMessageCampaign
  (s/coll-of :cognitect.aws.pinpoint/InAppMessageCampaign))

(s/def
  :cognitect.aws.pinpoint/GetApplicationSettingsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetApplicationSettingsResponse/ApplicationSettingsResource]))

(s/def
  :cognitect.aws.pinpoint/State
  (s/spec string? :gen #(s/gen #{"COMPLETED" "CLOSED" "DRAFT" "ACTIVE" "CANCELLED" "PAUSED"})))

(s/def
  :cognitect.aws.pinpoint/InAppTemplateResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.InAppTemplateResponse/LastModifiedDate
     :cognitect.aws.pinpoint.InAppTemplateResponse/CreationDate
     :cognitect.aws.pinpoint.InAppTemplateResponse/TemplateName
     :cognitect.aws.pinpoint.InAppTemplateResponse/TemplateType]
    :opt-un
    [:cognitect.aws.pinpoint.InAppTemplateResponse/CustomConfig
     :cognitect.aws.pinpoint.InAppTemplateResponse/tags
     :cognitect.aws.pinpoint.InAppTemplateResponse/Content
     :cognitect.aws.pinpoint.InAppTemplateResponse/Arn
     :cognitect.aws.pinpoint.InAppTemplateResponse/Version
     :cognitect.aws.pinpoint.InAppTemplateResponse/TemplateDescription
     :cognitect.aws.pinpoint.InAppTemplateResponse/Layout]))

(s/def
  :cognitect.aws.pinpoint/GetImportJobsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetImportJobsResponse/ImportJobsResponse]))

(s/def
  :cognitect.aws.pinpoint/APNSSandboxChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.APNSSandboxChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.APNSSandboxChannelResponse/HasCredential
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/HasTokenKey
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/Enabled
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/IsArchived
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/DefaultAuthenticationMethod
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/CreationDate
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/Version
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.APNSSandboxChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignActivitiesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetCampaignActivitiesRequest/ApplicationId
     :cognitect.aws.pinpoint.GetCampaignActivitiesRequest/CampaignId]
    :opt-un
    [:cognitect.aws.pinpoint.GetCampaignActivitiesRequest/PageSize
     :cognitect.aws.pinpoint.GetCampaignActivitiesRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/BaiduChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.BaiduChannelRequest/SecretKey
     :cognitect.aws.pinpoint.BaiduChannelRequest/ApiKey]
    :opt-un
    [:cognitect.aws.pinpoint.BaiduChannelRequest/Enabled]))

(s/def
  :cognitect.aws.pinpoint/GetPushTemplateResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetPushTemplateResponse/PushNotificationTemplateResponse]))

(s/def
  :cognitect.aws.pinpoint/InAppMessageHeaderConfig
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.InAppMessageHeaderConfig/Alignment
     :cognitect.aws.pinpoint.InAppMessageHeaderConfig/Header
     :cognitect.aws.pinpoint.InAppMessageHeaderConfig/TextColor]))

(s/def
  :cognitect.aws.pinpoint/CreateRecommenderConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationProviderUri
     :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationProviderRoleArn]
    :opt-un
    [:cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationsDisplayName
     :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationTransformerUri
     :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationsPerMessage
     :cognitect.aws.pinpoint.CreateRecommenderConfiguration/Attributes
     :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationProviderIdType
     :cognitect.aws.pinpoint.CreateRecommenderConfiguration/Description
     :cognitect.aws.pinpoint.CreateRecommenderConfiguration/Name]))

(s/def
  :cognitect.aws.pinpoint/GetChannelsRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetChannelsRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/OpenHoursRule
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.OpenHoursRule/EndTime
     :cognitect.aws.pinpoint.OpenHoursRule/StartTime]))

(s/def
  :cognitect.aws.pinpoint/PutEventsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.PutEventsRequest/ApplicationId
     :cognitect.aws.pinpoint.PutEventsRequest/EventsRequest]))

(s/def :cognitect.aws.pinpoint/__timestampIso8601 inst?)

(s/def
  :cognitect.aws.pinpoint/CreateJourneyResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateJourneyResponse/JourneyResponse]))

(s/def
  :cognitect.aws.pinpoint/VerificationResponse
  (s/keys :opt-un [:cognitect.aws.pinpoint.VerificationResponse/Valid]))

(s/def
  :cognitect.aws.pinpoint/MethodNotAllowedException
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.MethodNotAllowedException/Message
     :cognitect.aws.pinpoint.MethodNotAllowedException/RequestID]))

(s/def
  :cognitect.aws.pinpoint/Condition
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.Condition/Conditions :cognitect.aws.pinpoint.Condition/Operator]))

(s/def
  :cognitect.aws.pinpoint/QuietTime
  (s/keys :opt-un [:cognitect.aws.pinpoint.QuietTime/Start :cognitect.aws.pinpoint.QuietTime/End]))

(s/def
  :cognitect.aws.pinpoint/InAppMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.InAppMessage/CustomConfig
     :cognitect.aws.pinpoint.InAppMessage/Content
     :cognitect.aws.pinpoint.InAppMessage/Layout]))

(s/def
  :cognitect.aws.pinpoint/TemplateConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.TemplateConfiguration/VoiceTemplate
     :cognitect.aws.pinpoint.TemplateConfiguration/EmailTemplate
     :cognitect.aws.pinpoint.TemplateConfiguration/SMSTemplate
     :cognitect.aws.pinpoint.TemplateConfiguration/InAppTemplate
     :cognitect.aws.pinpoint.TemplateConfiguration/PushTemplate]))

(s/def
  :cognitect.aws.pinpoint/GetVoiceTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.GetVoiceTemplateResponse/VoiceTemplateResponse]))

(s/def
  :cognitect.aws.pinpoint/GetUserEndpointsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetUserEndpointsRequest/ApplicationId
     :cognitect.aws.pinpoint.GetUserEndpointsRequest/UserId]))

(s/def
  :cognitect.aws.pinpoint/MessageResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.MessageResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.MessageResponse/RequestId
     :cognitect.aws.pinpoint.MessageResponse/Result
     :cognitect.aws.pinpoint.MessageResponse/EndpointResult]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetCampaignVersionRequest/Version
     :cognitect.aws.pinpoint.GetCampaignVersionRequest/ApplicationId
     :cognitect.aws.pinpoint.GetCampaignVersionRequest/CampaignId]))

(s/def
  :cognitect.aws.pinpoint/ActivitiesResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ActivitiesResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.ActivitiesResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/ChannelType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"VOICE"
        "CUSTOM"
        "IN_APP"
        "SMS"
        "APNS_VOIP"
        "ADM"
        "BAIDU"
        "GCM"
        "APNS"
        "APNS_VOIP_SANDBOX"
        "PUSH"
        "APNS_SANDBOX"
        "EMAIL"})))

(s/def
  :cognitect.aws.pinpoint/ListTemplatesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ListTemplatesRequest/PageSize
     :cognitect.aws.pinpoint.ListTemplatesRequest/Prefix
     :cognitect.aws.pinpoint.ListTemplatesRequest/NextToken
     :cognitect.aws.pinpoint.ListTemplatesRequest/TemplateType]))

(s/def
  :cognitect.aws.pinpoint/VoiceTemplateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.VoiceTemplateRequest/DefaultSubstitutions
     :cognitect.aws.pinpoint.VoiceTemplateRequest/Body
     :cognitect.aws.pinpoint.VoiceTemplateRequest/tags
     :cognitect.aws.pinpoint.VoiceTemplateRequest/LanguageCode
     :cognitect.aws.pinpoint.VoiceTemplateRequest/VoiceId
     :cognitect.aws.pinpoint.VoiceTemplateRequest/TemplateDescription]))

(s/def
  :cognitect.aws.pinpoint/GetCampaignVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetCampaignVersionsRequest/ApplicationId
     :cognitect.aws.pinpoint.GetCampaignVersionsRequest/CampaignId]
    :opt-un
    [:cognitect.aws.pinpoint.GetCampaignVersionsRequest/PageSize
     :cognitect.aws.pinpoint.GetCampaignVersionsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/DeleteGcmChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteGcmChannelResponse/GCMChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/GPSPointDimension
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GPSPointDimension/Coordinates]
    :opt-un
    [:cognitect.aws.pinpoint.GPSPointDimension/RangeInKilometers]))

(s/def
  :cognitect.aws.pinpoint/BaiduChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.BaiduChannelResponse/Credential
     :cognitect.aws.pinpoint.BaiduChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.BaiduChannelResponse/HasCredential
     :cognitect.aws.pinpoint.BaiduChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.BaiduChannelResponse/Enabled
     :cognitect.aws.pinpoint.BaiduChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.BaiduChannelResponse/IsArchived
     :cognitect.aws.pinpoint.BaiduChannelResponse/CreationDate
     :cognitect.aws.pinpoint.BaiduChannelResponse/Version
     :cognitect.aws.pinpoint.BaiduChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.BaiduChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/DeleteGcmChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteGcmChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/JourneyRunExecutionMetricsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/Metrics
     :cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/JourneyId
     :cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/LastEvaluatedTime
     :cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/RunId
     :cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/CreateSmsTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateSmsTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.CreateSmsTemplateRequest/SMSTemplateRequest]))

(s/def
  :cognitect.aws.pinpoint/MessageBody
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.MessageBody/Message :cognitect.aws.pinpoint.MessageBody/RequestID]))

(s/def
  :cognitect.aws.pinpoint/EndpointsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.EndpointsResponse/Item]))

(s/def
  :cognitect.aws.pinpoint/GetAppsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.GetAppsRequest/PageSize :cognitect.aws.pinpoint.GetAppsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/EmailChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.EmailChannelResponse/Platform]
    :opt-un
    [:cognitect.aws.pinpoint.EmailChannelResponse/HasCredential
     :cognitect.aws.pinpoint.EmailChannelResponse/LastModifiedDate
     :cognitect.aws.pinpoint.EmailChannelResponse/ConfigurationSet
     :cognitect.aws.pinpoint.EmailChannelResponse/RoleArn
     :cognitect.aws.pinpoint.EmailChannelResponse/MessagesPerSecond
     :cognitect.aws.pinpoint.EmailChannelResponse/Enabled
     :cognitect.aws.pinpoint.EmailChannelResponse/ApplicationId
     :cognitect.aws.pinpoint.EmailChannelResponse/IsArchived
     :cognitect.aws.pinpoint.EmailChannelResponse/Identity
     :cognitect.aws.pinpoint.EmailChannelResponse/CreationDate
     :cognitect.aws.pinpoint.EmailChannelResponse/FromAddress
     :cognitect.aws.pinpoint.EmailChannelResponse/OrchestrationSendingRoleArn
     :cognitect.aws.pinpoint.EmailChannelResponse/Version
     :cognitect.aws.pinpoint.EmailChannelResponse/LastModifiedBy
     :cognitect.aws.pinpoint.EmailChannelResponse/Id]))

(s/def
  :cognitect.aws.pinpoint/Session
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.Session/StartTimestamp :cognitect.aws.pinpoint.Session/Id]
    :opt-un
    [:cognitect.aws.pinpoint.Session/StopTimestamp :cognitect.aws.pinpoint.Session/Duration]))

(s/def
  :cognitect.aws.pinpoint/CreateImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreateImportJobRequest/ApplicationId
     :cognitect.aws.pinpoint.CreateImportJobRequest/ImportJobRequest]))

(s/def
  :cognitect.aws.pinpoint/GetInAppMessagesRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetInAppMessagesRequest/ApplicationId
     :cognitect.aws.pinpoint.GetInAppMessagesRequest/EndpointId]))

(s/def
  :cognitect.aws.pinpoint/DeleteEmailChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteEmailChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/ListOfTemplateResponse
  (s/coll-of :cognitect.aws.pinpoint/TemplateResponse))

(s/def
  :cognitect.aws.pinpoint/UpdateGcmChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateGcmChannelResponse/GCMChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/RemoveAttributesResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.RemoveAttributesResponse/AttributesResource]))

(s/def
  :cognitect.aws.pinpoint/EndpointBatchRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.EndpointBatchRequest/Item]))

(s/def
  :cognitect.aws.pinpoint/DeleteAppResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteAppResponse/ApplicationResponse]))

(s/def
  :cognitect.aws.pinpoint/ExportJobResource
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ExportJobResource/S3UrlPrefix
     :cognitect.aws.pinpoint.ExportJobResource/RoleArn]
    :opt-un
    [:cognitect.aws.pinpoint.ExportJobResource/SegmentVersion
     :cognitect.aws.pinpoint.ExportJobResource/SegmentId]))

(s/def
  :cognitect.aws.pinpoint/MapOfMapOfEndpointMessageResult
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/MapOfEndpointMessageResult))

(s/def
  :cognitect.aws.pinpoint/MapOf__double
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/__double))

(s/def
  :cognitect.aws.pinpoint/CreateEmailTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.CreateEmailTemplateResponse/CreateTemplateMessageBody]))

(s/def
  :cognitect.aws.pinpoint/DeleteSmsChannelRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteSmsChannelRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/SendOTPMessageRequestParameters
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SendOTPMessageRequestParameters/BrandName
     :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/ReferenceId
     :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/Channel
     :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/DestinationIdentity
     :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/OriginationIdentity]
    :opt-un
    [:cognitect.aws.pinpoint.SendOTPMessageRequestParameters/TemplateId
     :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/CodeLength
     :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/AllowedAttempts
     :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/Language
     :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/EntityId
     :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/ValidityPeriod]))

(s/def
  :cognitect.aws.pinpoint/ListTagsForResourceResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.ListTagsForResourceResponse/TagsModel]))

(s/def
  :cognitect.aws.pinpoint/GetAppRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.GetAppRequest/ApplicationId]))

(s/def
  :cognitect.aws.pinpoint/APNSMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.APNSMessage/Category
     :cognitect.aws.pinpoint.APNSMessage/Body
     :cognitect.aws.pinpoint.APNSMessage/Title
     :cognitect.aws.pinpoint.APNSMessage/SilentPush
     :cognitect.aws.pinpoint.APNSMessage/Sound
     :cognitect.aws.pinpoint.APNSMessage/TimeToLive
     :cognitect.aws.pinpoint.APNSMessage/Priority
     :cognitect.aws.pinpoint.APNSMessage/RawContent
     :cognitect.aws.pinpoint.APNSMessage/ThreadId
     :cognitect.aws.pinpoint.APNSMessage/Url
     :cognitect.aws.pinpoint.APNSMessage/Badge
     :cognitect.aws.pinpoint.APNSMessage/Substitutions
     :cognitect.aws.pinpoint.APNSMessage/APNSPushType
     :cognitect.aws.pinpoint.APNSMessage/Data
     :cognitect.aws.pinpoint.APNSMessage/MediaUrl
     :cognitect.aws.pinpoint.APNSMessage/CollapseId
     :cognitect.aws.pinpoint.APNSMessage/Action
     :cognitect.aws.pinpoint.APNSMessage/PreferredAuthenticationMethod]))

(s/def
  :cognitect.aws.pinpoint/WriteApplicationSettingsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.WriteApplicationSettingsRequest/QuietTime
     :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/Limits
     :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/JourneyLimits
     :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/CampaignHook
     :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/EventTaggingEnabled
     :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/CloudWatchMetricsEnabled]))

(s/def
  :cognitect.aws.pinpoint/DeleteSegmentResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteSegmentResponse/SegmentResponse]))

(s/def
  :cognitect.aws.pinpoint/Activity
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.Activity/RandomSplit
     :cognitect.aws.pinpoint.Activity/ContactCenter
     :cognitect.aws.pinpoint.Activity/CUSTOM
     :cognitect.aws.pinpoint.Activity/SMS
     :cognitect.aws.pinpoint.Activity/Holdout
     :cognitect.aws.pinpoint.Activity/Wait
     :cognitect.aws.pinpoint.Activity/MultiCondition
     :cognitect.aws.pinpoint.Activity/Description
     :cognitect.aws.pinpoint.Activity/PUSH
     :cognitect.aws.pinpoint.Activity/EMAIL
     :cognitect.aws.pinpoint.Activity/ConditionalSplit]))

(s/def
  :cognitect.aws.pinpoint/UpdateJourneyStateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateJourneyStateResponse/JourneyResponse]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyRunExecutionMetricsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/RunId
     :cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/ApplicationId
     :cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/JourneyId]
    :opt-un
    [:cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/PageSize
     :cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint/GetApnsVoipSandboxChannelResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetApnsVoipSandboxChannelResponse/APNSVoipSandboxChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/DeleteAdmChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteAdmChannelResponse/ADMChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/CampaignInAppMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.CampaignInAppMessage/Body
     :cognitect.aws.pinpoint.CampaignInAppMessage/CustomConfig
     :cognitect.aws.pinpoint.CampaignInAppMessage/Content
     :cognitect.aws.pinpoint.CampaignInAppMessage/Layout]))

(s/def
  :cognitect.aws.pinpoint/InAppCampaignSchedule
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.InAppCampaignSchedule/QuietTime
     :cognitect.aws.pinpoint.InAppCampaignSchedule/EndDate
     :cognitect.aws.pinpoint.InAppCampaignSchedule/EventFilter]))

(s/def
  :cognitect.aws.pinpoint/__integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.pinpoint/EventsRequest
  (s/keys :req-un [:cognitect.aws.pinpoint.EventsRequest/BatchItem]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyRunExecutionActivityMetricsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/RunId
     :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/JourneyActivityId
     :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/JourneyId
     :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/PageSize
     :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/NextToken]))

(s/def
  :cognitect.aws.pinpoint/UpdateApnsVoipSandboxChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.UpdateApnsVoipSandboxChannelRequest/ApplicationId
     :cognitect.aws.pinpoint.UpdateApnsVoipSandboxChannelRequest/APNSVoipSandboxChannelRequest]))

(s/def
  :cognitect.aws.pinpoint/GetExportJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetExportJobsRequest/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.GetExportJobsRequest/PageSize
     :cognitect.aws.pinpoint.GetExportJobsRequest/Token]))

(s/def
  :cognitect.aws.pinpoint/JourneyEmailMessage
  (s/keys :opt-un [:cognitect.aws.pinpoint.JourneyEmailMessage/FromAddress]))

(s/def
  :cognitect.aws.pinpoint/InAppMessageButton
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.InAppMessageButton/Android
     :cognitect.aws.pinpoint.InAppMessageButton/DefaultConfig
     :cognitect.aws.pinpoint.InAppMessageButton/IOS
     :cognitect.aws.pinpoint.InAppMessageButton/Web]))

(s/def
  :cognitect.aws.pinpoint/SegmentDemographics
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SegmentDemographics/Platform
     :cognitect.aws.pinpoint.SegmentDemographics/Make
     :cognitect.aws.pinpoint.SegmentDemographics/Model
     :cognitect.aws.pinpoint.SegmentDemographics/DeviceType
     :cognitect.aws.pinpoint.SegmentDemographics/AppVersion
     :cognitect.aws.pinpoint.SegmentDemographics/Channel]))

(s/def
  :cognitect.aws.pinpoint/TooManyRequestsException
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.TooManyRequestsException/Message
     :cognitect.aws.pinpoint.TooManyRequestsException/RequestID]))

(s/def
  :cognitect.aws.pinpoint/StartCondition
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.StartCondition/SegmentStartCondition
     :cognitect.aws.pinpoint.StartCondition/EventStartCondition
     :cognitect.aws.pinpoint.StartCondition/Description]))

(s/def
  :cognitect.aws.pinpoint/JourneyDateRangeKpiResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/KpiResult
     :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/KpiName
     :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/JourneyId
     :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/EndTime
     :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/StartTime
     :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/UpdateApnsVoipChannelResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateApnsVoipChannelResponse/APNSVoipChannelResponse]))

(s/def
  :cognitect.aws.pinpoint/EndpointUser
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EndpointUser/UserId
     :cognitect.aws.pinpoint.EndpointUser/UserAttributes]))

(s/def
  :cognitect.aws.pinpoint/MapOfActivity
  (s/map-of :cognitect.aws.pinpoint/__string :cognitect.aws.pinpoint/Activity))

(s/def
  :cognitect.aws.pinpoint/InAppMessageBodyConfig
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.InAppMessageBodyConfig/Alignment
     :cognitect.aws.pinpoint.InAppMessageBodyConfig/TextColor
     :cognitect.aws.pinpoint.InAppMessageBodyConfig/Body]))

(s/def
  :cognitect.aws.pinpoint/ClosedDays
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ClosedDays/VOICE
     :cognitect.aws.pinpoint.ClosedDays/CUSTOM
     :cognitect.aws.pinpoint.ClosedDays/SMS
     :cognitect.aws.pinpoint.ClosedDays/PUSH
     :cognitect.aws.pinpoint.ClosedDays/EMAIL]))

(s/def
  :cognitect.aws.pinpoint/ChannelsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.ChannelsResponse/Channels]))

(s/def
  :cognitect.aws.pinpoint/TreatmentResource
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.TreatmentResource/Id
     :cognitect.aws.pinpoint.TreatmentResource/SizePercent]
    :opt-un
    [:cognitect.aws.pinpoint.TreatmentResource/CustomDeliveryConfiguration
     :cognitect.aws.pinpoint.TreatmentResource/TreatmentDescription
     :cognitect.aws.pinpoint.TreatmentResource/TreatmentName
     :cognitect.aws.pinpoint.TreatmentResource/MessageConfiguration
     :cognitect.aws.pinpoint.TreatmentResource/State
     :cognitect.aws.pinpoint.TreatmentResource/Schedule
     :cognitect.aws.pinpoint.TreatmentResource/TemplateConfiguration]))

(s/def :cognitect.aws.pinpoint/SourceType (s/spec string? :gen #(s/gen #{"NONE" "ANY" "ALL"})))

(s/def
  :cognitect.aws.pinpoint/SMSTemplateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.SMSTemplateRequest/DefaultSubstitutions
     :cognitect.aws.pinpoint.SMSTemplateRequest/Body
     :cognitect.aws.pinpoint.SMSTemplateRequest/tags
     :cognitect.aws.pinpoint.SMSTemplateRequest/RecommenderId
     :cognitect.aws.pinpoint.SMSTemplateRequest/TemplateDescription]))

(s/def
  :cognitect.aws.pinpoint/JourneyTimeframeCap
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.JourneyTimeframeCap/Days
     :cognitect.aws.pinpoint.JourneyTimeframeCap/Cap]))

(s/def
  :cognitect.aws.pinpoint/ListOfOpenHoursRules
  (s/coll-of :cognitect.aws.pinpoint/OpenHoursRule))

(s/def :cognitect.aws.pinpoint/ListOfSegmentGroup (s/coll-of :cognitect.aws.pinpoint/SegmentGroup))

(s/def
  :cognitect.aws.pinpoint/ListOfSegmentReference
  (s/coll-of :cognitect.aws.pinpoint/SegmentReference))

(s/def
  :cognitect.aws.pinpoint/ListOfEndpointBatchItem
  (s/coll-of :cognitect.aws.pinpoint/EndpointBatchItem))

(s/def
  :cognitect.aws.pinpoint/ListOfCampaignResponse
  (s/coll-of :cognitect.aws.pinpoint/CampaignResponse))

(s/def
  :cognitect.aws.pinpoint/DeleteUserEndpointsResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeleteUserEndpointsResponse/EndpointsResponse]))

(s/def
  :cognitect.aws.pinpoint/CreateTemplateMessageBody
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.CreateTemplateMessageBody/Message
     :cognitect.aws.pinpoint.CreateTemplateMessageBody/RequestID
     :cognitect.aws.pinpoint.CreateTemplateMessageBody/Arn]))

(s/def
  :cognitect.aws.pinpoint/WriteJourneyRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.WriteJourneyRequest/Name]
    :opt-un
    [:cognitect.aws.pinpoint.WriteJourneyRequest/Activities
     :cognitect.aws.pinpoint.WriteJourneyRequest/RefreshFrequency
     :cognitect.aws.pinpoint.WriteJourneyRequest/QuietTime
     :cognitect.aws.pinpoint.WriteJourneyRequest/LocalTime
     :cognitect.aws.pinpoint.WriteJourneyRequest/LastModifiedDate
     :cognitect.aws.pinpoint.WriteJourneyRequest/TimezoneEstimationMethods
     :cognitect.aws.pinpoint.WriteJourneyRequest/StartActivity
     :cognitect.aws.pinpoint.WriteJourneyRequest/RefreshOnSegmentUpdate
     :cognitect.aws.pinpoint.WriteJourneyRequest/ClosedDays
     :cognitect.aws.pinpoint.WriteJourneyRequest/Limits
     :cognitect.aws.pinpoint.WriteJourneyRequest/StartCondition
     :cognitect.aws.pinpoint.WriteJourneyRequest/JourneyChannelSettings
     :cognitect.aws.pinpoint.WriteJourneyRequest/CreationDate
     :cognitect.aws.pinpoint.WriteJourneyRequest/State
     :cognitect.aws.pinpoint.WriteJourneyRequest/SendingSchedule
     :cognitect.aws.pinpoint.WriteJourneyRequest/Schedule
     :cognitect.aws.pinpoint.WriteJourneyRequest/OpenHours
     :cognitect.aws.pinpoint.WriteJourneyRequest/WaitForQuietTime]))

(s/def
  :cognitect.aws.pinpoint/GetJourneyExecutionMetricsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.GetJourneyExecutionMetricsResponse/JourneyExecutionMetricsResponse]))

(s/def
  :cognitect.aws.pinpoint/EventCondition
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.EventCondition/MessageActivity
     :cognitect.aws.pinpoint.EventCondition/Dimensions]))

(s/def
  :cognitect.aws.pinpoint/UpdateSmsTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.UpdateSmsTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/SegmentsResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.SegmentsResponse/Item]
    :opt-un
    [:cognitect.aws.pinpoint.SegmentsResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/CustomDeliveryConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CustomDeliveryConfiguration/DeliveryUri]
    :opt-un
    [:cognitect.aws.pinpoint.CustomDeliveryConfiguration/EndpointTypes]))

(s/def
  :cognitect.aws.pinpoint/EventsResponse
  (s/keys :opt-un [:cognitect.aws.pinpoint.EventsResponse/Results]))

(s/def
  :cognitect.aws.pinpoint/ConflictException
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ConflictException/Message
     :cognitect.aws.pinpoint.ConflictException/RequestID]))

(s/def
  :cognitect.aws.pinpoint/EmailChannelRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.EmailChannelRequest/FromAddress
     :cognitect.aws.pinpoint.EmailChannelRequest/Identity]
    :opt-un
    [:cognitect.aws.pinpoint.EmailChannelRequest/ConfigurationSet
     :cognitect.aws.pinpoint.EmailChannelRequest/RoleArn
     :cognitect.aws.pinpoint.EmailChannelRequest/Enabled
     :cognitect.aws.pinpoint.EmailChannelRequest/OrchestrationSendingRoleArn]))

(s/def
  :cognitect.aws.pinpoint/GCMMessage
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.GCMMessage/CollapseKey
     :cognitect.aws.pinpoint.GCMMessage/RestrictedPackageName
     :cognitect.aws.pinpoint.GCMMessage/Body
     :cognitect.aws.pinpoint.GCMMessage/ImageUrl
     :cognitect.aws.pinpoint.GCMMessage/Title
     :cognitect.aws.pinpoint.GCMMessage/SilentPush
     :cognitect.aws.pinpoint.GCMMessage/Sound
     :cognitect.aws.pinpoint.GCMMessage/TimeToLive
     :cognitect.aws.pinpoint.GCMMessage/Priority
     :cognitect.aws.pinpoint.GCMMessage/RawContent
     :cognitect.aws.pinpoint.GCMMessage/Url
     :cognitect.aws.pinpoint.GCMMessage/Substitutions
     :cognitect.aws.pinpoint.GCMMessage/SmallImageIconUrl
     :cognitect.aws.pinpoint.GCMMessage/IconReference
     :cognitect.aws.pinpoint.GCMMessage/Data
     :cognitect.aws.pinpoint.GCMMessage/ImageIconUrl
     :cognitect.aws.pinpoint.GCMMessage/Action
     :cognitect.aws.pinpoint.GCMMessage/PreferredAuthenticationMethod]))

(s/def
  :cognitect.aws.pinpoint/DeletePushTemplateResponse
  (s/keys :req-un [:cognitect.aws.pinpoint.DeletePushTemplateResponse/MessageBody]))

(s/def
  :cognitect.aws.pinpoint/ApplicationDateRangeKpiResponse
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/KpiResult
     :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/KpiName
     :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/EndTime
     :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/StartTime
     :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/ApplicationId]
    :opt-un
    [:cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/NextToken]))

(s/def
  :cognitect.aws.pinpoint/CreatePushTemplateRequest
  (s/keys
    :req-un
    [:cognitect.aws.pinpoint.CreatePushTemplateRequest/TemplateName
     :cognitect.aws.pinpoint.CreatePushTemplateRequest/PushNotificationTemplateRequest]))

(s/def
  :cognitect.aws.pinpoint/ItemResponse
  (s/keys
    :opt-un
    [:cognitect.aws.pinpoint.ItemResponse/EventsItemResponse
     :cognitect.aws.pinpoint.ItemResponse/EndpointItemResponse]))

(s/def
  :cognitect.aws.pinpoint.UpdateAttributesRequest/Blacklist
  :cognitect.aws.pinpoint/ListOf__string)

(s/def :cognitect.aws.pinpoint.SegmentBehaviors/Recency :cognitect.aws.pinpoint/RecencyDimension)

(s/def
  :cognitect.aws.pinpoint.MultiConditionalBranch/Condition
  :cognitect.aws.pinpoint/SimpleCondition)

(s/def :cognitect.aws.pinpoint.MultiConditionalBranch/NextActivity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/CompletionDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/TotalPieces :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/TotalFailures :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/JobStatus :cognitect.aws.pinpoint/JobStatus)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/Failures :cognitect.aws.pinpoint/ListOf__string)

(s/def
  :cognitect.aws.pinpoint.ImportJobResponse/Definition
  :cognitect.aws.pinpoint/ImportJobResource)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/CompletedPieces :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/Type :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/FailedPieces :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/TotalProcessed :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ImportJobResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunsResponse/JourneyRunsResponse
  :cognitect.aws.pinpoint/JourneyRunsResponse)

(s/def :cognitect.aws.pinpoint.JourneySMSMessage/MessageType :cognitect.aws.pinpoint/MessageType)

(s/def :cognitect.aws.pinpoint.JourneySMSMessage/OriginationNumber :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneySMSMessage/SenderId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneySMSMessage/EntityId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneySMSMessage/TemplateId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendUsersMessageResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SendUsersMessageResponse/RequestId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendUsersMessageResponse/Result
  :cognitect.aws.pinpoint/MapOfMapOfEndpointMessageResult)

(s/def
  :cognitect.aws.pinpoint.SegmentGroup/Dimensions
  :cognitect.aws.pinpoint/ListOfSegmentDimensions)

(s/def
  :cognitect.aws.pinpoint.SegmentGroup/SourceSegments
  :cognitect.aws.pinpoint/ListOfSegmentReference)

(s/def :cognitect.aws.pinpoint.SegmentGroup/SourceType :cognitect.aws.pinpoint/SourceType)

(s/def :cognitect.aws.pinpoint.SegmentGroup/Type :cognitect.aws.pinpoint/Type)

(s/def
  :cognitect.aws.pinpoint.GetApplicationSettingsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateGcmChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateGcmChannelRequest/GCMChannelRequest
  :cognitect.aws.pinpoint/GCMChannelRequest)

(s/def :cognitect.aws.pinpoint.WaitTime/WaitFor :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WaitTime/WaitUntil :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MessageResult/DeliveryStatus :cognitect.aws.pinpoint/DeliveryStatus)

(s/def :cognitect.aws.pinpoint.MessageResult/MessageId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MessageResult/StatusCode :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.MessageResult/StatusMessage :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MessageResult/UpdatedToken :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneysResponse/Item :cognitect.aws.pinpoint/ListOfJourneyResponse)

(s/def :cognitect.aws.pinpoint.JourneysResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/LastModifiedDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/TreatmentName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/DefaultState :cognitect.aws.pinpoint/CampaignState)

(s/def :cognitect.aws.pinpoint.CampaignResponse/Schedule :cognitect.aws.pinpoint/Schedule)

(s/def :cognitect.aws.pinpoint.CampaignResponse/Id :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CampaignResponse/MessageConfiguration
  :cognitect.aws.pinpoint/MessageConfiguration)

(s/def :cognitect.aws.pinpoint.CampaignResponse/SegmentId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/Priority :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.CampaignResponse/Limits :cognitect.aws.pinpoint/CampaignLimits)

(s/def
  :cognitect.aws.pinpoint.CampaignResponse/AdditionalTreatments
  :cognitect.aws.pinpoint/ListOfTreatmentResource)

(s/def
  :cognitect.aws.pinpoint.CampaignResponse/TreatmentDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/Arn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/IsPaused :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.CampaignResponse/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/Description :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/State :cognitect.aws.pinpoint/CampaignState)

(s/def :cognitect.aws.pinpoint.CampaignResponse/Hook :cognitect.aws.pinpoint/CampaignHook)

(s/def
  :cognitect.aws.pinpoint.CampaignResponse/TemplateConfiguration
  :cognitect.aws.pinpoint/TemplateConfiguration)

(s/def :cognitect.aws.pinpoint.CampaignResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.CampaignResponse/HoldoutPercent :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.CampaignResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignResponse/SegmentVersion :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.CampaignResponse/CustomDeliveryConfiguration
  :cognitect.aws.pinpoint/CustomDeliveryConfiguration)

(s/def :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Action :cognitect.aws.pinpoint/Action)

(s/def :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Body :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Data
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.DefaultPushNotificationMessage/SilentPush
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Substitutions
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def
  :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Title
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DefaultPushNotificationMessage/Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/LastModifiedDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SMSChannelResponse/PromotionalMessagesPerSecond
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.SMSChannelResponse/TransactionalMessagesPerSecond
  :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/SenderId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/IsArchived :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/ShortCode :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/LastModifiedBy :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelResponse/HasCredential :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.TagResourceRequest/ResourceArn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TagResourceRequest/TagsModel :cognitect.aws.pinpoint/TagsModel)

(s/def
  :cognitect.aws.pinpoint.APNSChannelResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/IsArchived :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/LastModifiedBy :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSChannelResponse/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/HasTokenKey :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelResponse/HasCredential :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ImportJobRequest/DefineSegment :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ImportJobRequest/ExternalId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobRequest/Format :cognitect.aws.pinpoint/Format)

(s/def :cognitect.aws.pinpoint.ImportJobRequest/RegisterEndpoints :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ImportJobRequest/RoleArn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobRequest/S3Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobRequest/SegmentId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobRequest/SegmentName :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateTemplateActiveVersionResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def
  :cognitect.aws.pinpoint.GetRecommenderConfigurationResponse/RecommenderConfigurationResponse
  :cognitect.aws.pinpoint/RecommenderConfigurationResponse)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfigurationRequest/CreateRecommenderConfiguration
  :cognitect.aws.pinpoint/CreateRecommenderConfiguration)

(s/def
  :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/CampaignId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/EndTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/KpiName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/KpiResult
  :cognitect.aws.pinpoint/BaseKpiResult)

(s/def
  :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CampaignDateRangeKpiResponse/StartTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelRequest/BundleId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelRequest/Certificate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipChannelRequest/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelRequest/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelRequest/PrivateKey :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelRequest/TeamId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelRequest/TokenKey :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelRequest/TokenKeyId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetEndpointRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetEndpointRequest/EndpointId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ApplicationResponse/Arn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ApplicationResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ApplicationResponse/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ApplicationResponse/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.ApplicationResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateInAppTemplateResponse/TemplateCreateMessageBody
  :cognitect.aws.pinpoint/TemplateCreateMessageBody)

(s/def
  :cognitect.aws.pinpoint.GetApnsSandboxChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneySchedule/EndTime :cognitect.aws.pinpoint/__timestampIso8601)

(s/def :cognitect.aws.pinpoint.JourneySchedule/StartTime :cognitect.aws.pinpoint/__timestampIso8601)

(s/def :cognitect.aws.pinpoint.JourneySchedule/Timezone :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteApnsVoipChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateRequest/tags
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateRequest/GCM
  :cognitect.aws.pinpoint/AndroidPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateRequest/APNS
  :cognitect.aws.pinpoint/APNSPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateRequest/RecommenderId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateRequest/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateRequest/Baidu
  :cognitect.aws.pinpoint/AndroidPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateRequest/Default
  :cognitect.aws.pinpoint/DefaultPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateRequest/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateRequest/ADM
  :cognitect.aws.pinpoint/AndroidPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.UpdateEmailTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def
  :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/EndTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/KpiName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetApplicationDateRangeKpiRequest/StartTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.DeleteSmsTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def :cognitect.aws.pinpoint.RecencyDimension/Duration :cognitect.aws.pinpoint/Duration)

(s/def :cognitect.aws.pinpoint.RecencyDimension/RecencyType :cognitect.aws.pinpoint/RecencyType)

(s/def
  :cognitect.aws.pinpoint.VoiceChannelResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceChannelResponse/IsArchived :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.VoiceChannelResponse/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.VoiceChannelResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceChannelResponse/LastModifiedBy :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.VoiceChannelResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceChannelResponse/HasCredential :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.GCMChannelRequest/ApiKey :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GCMChannelRequest/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMChannelRequest/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.GCMChannelRequest/ServiceJson :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateAdmChannelRequest/ADMChannelRequest
  :cognitect.aws.pinpoint/ADMChannelRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateAdmChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteEmailChannelResponse/EmailChannelResponse
  :cognitect.aws.pinpoint/EmailChannelResponse)

(s/def :cognitect.aws.pinpoint.AddressConfiguration/BodyOverride :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.AddressConfiguration/ChannelType :cognitect.aws.pinpoint/ChannelType)

(s/def :cognitect.aws.pinpoint.AddressConfiguration/Context :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.AddressConfiguration/RawContent :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.AddressConfiguration/Substitutions
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.AddressConfiguration/TitleOverride :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.VerifyOTPMessageResponse/VerificationResponse
  :cognitect.aws.pinpoint/VerificationResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateSmsTemplateRequest/CreateNewVersion
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.UpdateSmsTemplateRequest/SMSTemplateRequest
  :cognitect.aws.pinpoint/SMSTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateSmsTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateSmsTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentRequest/SegmentId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TemplateVersionResponse/CreationDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TemplateVersionResponse/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TemplateVersionResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TemplateVersionResponse/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TemplateVersionResponse/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TemplateVersionResponse/TemplateType
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateVersionResponse/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointDemographic/AppVersion :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointDemographic/Locale :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointDemographic/Make :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointDemographic/Model :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointDemographic/ModelVersion :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointDemographic/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointDemographic/PlatformVersion :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointDemographic/Timezone :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SetDimension/DimensionType :cognitect.aws.pinpoint/DimensionType)

(s/def :cognitect.aws.pinpoint.SetDimension/Values :cognitect.aws.pinpoint/ListOf__string)

(s/def :cognitect.aws.pinpoint.OpenHours/EMAIL :cognitect.aws.pinpoint/MapOfListOfOpenHoursRules)

(s/def :cognitect.aws.pinpoint.OpenHours/SMS :cognitect.aws.pinpoint/MapOfListOfOpenHoursRules)

(s/def :cognitect.aws.pinpoint.OpenHours/PUSH :cognitect.aws.pinpoint/MapOfListOfOpenHoursRules)

(s/def :cognitect.aws.pinpoint.OpenHours/VOICE :cognitect.aws.pinpoint/MapOfListOfOpenHoursRules)

(s/def :cognitect.aws.pinpoint.OpenHours/CUSTOM :cognitect.aws.pinpoint/MapOfListOfOpenHoursRules)

(s/def
  :cognitect.aws.pinpoint.UpdateCampaignResponse/CampaignResponse
  :cognitect.aws.pinpoint/CampaignResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsVoipChannelRequest/APNSVoipChannelRequest
  :cognitect.aws.pinpoint/APNSVoipChannelRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsVoipChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentGroupList/Groups :cognitect.aws.pinpoint/ListOfSegmentGroup)

(s/def :cognitect.aws.pinpoint.SegmentGroupList/Include :cognitect.aws.pinpoint/Include)

(s/def :cognitect.aws.pinpoint.GetCampaignRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetCampaignRequest/CampaignId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateEndpointRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateEndpointRequest/EndpointId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateEndpointRequest/EndpointRequest
  :cognitect.aws.pinpoint/EndpointRequest)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionMetricsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionMetricsRequest/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionMetricsRequest/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionMetricsRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteApnsChannelResponse/APNSChannelResponse
  :cognitect.aws.pinpoint/APNSChannelResponse)

(s/def :cognitect.aws.pinpoint.InAppMessageCampaign/CampaignId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.InAppMessageCampaign/DailyCap :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.InAppMessageCampaign/InAppMessage
  :cognitect.aws.pinpoint/InAppMessage)

(s/def :cognitect.aws.pinpoint.InAppMessageCampaign/Priority :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.InAppMessageCampaign/Schedule
  :cognitect.aws.pinpoint/InAppCampaignSchedule)

(s/def :cognitect.aws.pinpoint.InAppMessageCampaign/SessionCap :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.InAppMessageCampaign/TotalCap :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.InAppMessageCampaign/TreatmentId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetEmailTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetEmailTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteAppRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EventFilter/Dimensions :cognitect.aws.pinpoint/EventDimensions)

(s/def :cognitect.aws.pinpoint.EventFilter/FilterType :cognitect.aws.pinpoint/FilterType)

(s/def :cognitect.aws.pinpoint.SegmentLocation/Country :cognitect.aws.pinpoint/SetDimension)

(s/def :cognitect.aws.pinpoint.SegmentLocation/GPSPoint :cognitect.aws.pinpoint/GPSPointDimension)

(s/def
  :cognitect.aws.pinpoint.GetInAppTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetInAppTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendMessagesResponse/MessageResponse
  :cognitect.aws.pinpoint/MessageResponse)

(s/def
  :cognitect.aws.pinpoint.GetCampaignsResponse/CampaignsResponse
  :cognitect.aws.pinpoint/CampaignsResponse)

(s/def :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Url :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/RawContent
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/ImageUrl
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Title
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/SmallImageIconUrl
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Body
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Sound
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/Action
  :cognitect.aws.pinpoint/Action)

(s/def
  :cognitect.aws.pinpoint.AndroidPushNotificationTemplate/ImageIconUrl
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendUsersMessagesRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendUsersMessagesRequest/SendUsersMessageRequest
  :cognitect.aws.pinpoint/SendUsersMessageRequest)

(s/def
  :cognitect.aws.pinpoint.DeleteApnsVoipSandboxChannelResponse/APNSVoipSandboxChannelResponse
  :cognitect.aws.pinpoint/APNSVoipSandboxChannelResponse)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/CompletionDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/TotalPieces :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/TotalFailures :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/JobStatus :cognitect.aws.pinpoint/JobStatus)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/Failures :cognitect.aws.pinpoint/ListOf__string)

(s/def
  :cognitect.aws.pinpoint.ExportJobResponse/Definition
  :cognitect.aws.pinpoint/ExportJobResource)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/CompletedPieces :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/Type :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/FailedPieces :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/TotalProcessed :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ExportJobResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteEmailTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def :cognitect.aws.pinpoint.SegmentCondition/SegmentId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateVoiceChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateVoiceChannelRequest/VoiceChannelRequest
  :cognitect.aws.pinpoint/VoiceChannelRequest)

(s/def :cognitect.aws.pinpoint.CampaignLimits/Daily :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.CampaignLimits/MaximumDuration :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.CampaignLimits/MessagesPerSecond :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.CampaignLimits/Total :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.CampaignLimits/Session :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.Message/Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Message/RawContent :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Message/ImageUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Message/JsonBody :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Message/ImageSmallIconUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Message/Title :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Message/MediaUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Message/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Message/Action :cognitect.aws.pinpoint/Action)

(s/def :cognitect.aws.pinpoint.Message/TimeToLive :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.Message/SilentPush :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.Message/ImageIconUrl :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteEmailTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteEmailTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetSegmentExportJobsResponse/ExportJobsResponse
  :cognitect.aws.pinpoint/ExportJobsResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateSegmentResponse/SegmentResponse
  :cognitect.aws.pinpoint/SegmentResponse)

(s/def :cognitect.aws.pinpoint.ADMChannelRequest/ClientId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMChannelRequest/ClientSecret :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMChannelRequest/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.CreateJourneyRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateJourneyRequest/WriteJourneyRequest
  :cognitect.aws.pinpoint/WriteJourneyRequest)

(s/def :cognitect.aws.pinpoint.GetJourneyRunsRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetJourneyRunsRequest/JourneyId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetJourneyRunsRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetJourneyRunsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/ActivityType
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/JourneyActivityId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/LastEvaluatedTime
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionActivityMetricsResponse/Metrics
  :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.WaitActivity/NextActivity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WaitActivity/WaitTime :cognitect.aws.pinpoint/WaitTime)

(s/def
  :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/EndTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/KpiName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyDateRangeKpiRequest/StartTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.GetImportJobResponse/ImportJobResponse
  :cognitect.aws.pinpoint/ImportJobResponse)

(s/def :cognitect.aws.pinpoint.SendMessagesRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendMessagesRequest/MessageRequest
  :cognitect.aws.pinpoint/MessageRequest)

(s/def :cognitect.aws.pinpoint.RandomSplitEntry/NextActivity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.RandomSplitEntry/Percentage :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.EventItemResponse/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EventItemResponse/StatusCode :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.GetSegmentVersionsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentVersionsRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentVersionsRequest/SegmentId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentVersionsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateApplicationSettingsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateApplicationSettingsRequest/WriteApplicationSettingsRequest
  :cognitect.aws.pinpoint/WriteApplicationSettingsRequest)

(s/def :cognitect.aws.pinpoint.CampaignState/CampaignStatus :cognitect.aws.pinpoint/CampaignStatus)

(s/def
  :cognitect.aws.pinpoint.GetChannelsResponse/ChannelsResponse
  :cognitect.aws.pinpoint/ChannelsResponse)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationsDisplayName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationTransformerUri
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.RecommenderConfigurationResponse/Id :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationProviderIdType
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationProviderRoleArn
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationProviderUri
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/Name
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/Description
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/Attributes
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/CreationDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RecommenderConfigurationResponse/RecommendationsPerMessage
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.ActivityResponse/TotalEndpointCount
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.ActivityResponse/SuccessfulEndpointCount
  :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ActivityResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ActivityResponse/TreatmentId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ActivityResponse/TimezonesCompletedCount
  :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ActivityResponse/Result :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ActivityResponse/ExecutionMetrics
  :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.ActivityResponse/ScheduledStart :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ActivityResponse/TimezonesTotalCount
  :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ActivityResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ActivityResponse/End :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ActivityResponse/State :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ActivityResponse/Start :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ActivityResponse/CampaignId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PutEventStreamRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PutEventStreamRequest/WriteEventStream
  :cognitect.aws.pinpoint/WriteEventStream)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationsDisplayName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationTransformerUri
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationProviderIdType
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationProviderRoleArn
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationProviderUri
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/Name :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/Description
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/Attributes
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfiguration/RecommendationsPerMessage
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.UpdateVoiceTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def :cognitect.aws.pinpoint.HoldoutActivity/NextActivity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.HoldoutActivity/Percentage :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.DeleteUserEndpointsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteUserEndpointsRequest/UserId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Schedule/EndTime :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Schedule/EventFilter :cognitect.aws.pinpoint/CampaignEventFilter)

(s/def :cognitect.aws.pinpoint.Schedule/Frequency :cognitect.aws.pinpoint/Frequency)

(s/def :cognitect.aws.pinpoint.Schedule/IsLocalTime :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.Schedule/QuietTime :cognitect.aws.pinpoint/QuietTime)

(s/def :cognitect.aws.pinpoint.Schedule/StartTime :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Schedule/Timezone :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ResultRow/GroupedBys :cognitect.aws.pinpoint/ListOfResultRowValue)

(s/def :cognitect.aws.pinpoint.ResultRow/Values :cognitect.aws.pinpoint/ListOfResultRowValue)

(s/def :cognitect.aws.pinpoint.ImportJobResource/DefineSegment :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ImportJobResource/ExternalId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobResource/Format :cognitect.aws.pinpoint/Format)

(s/def
  :cognitect.aws.pinpoint.ImportJobResource/RegisterEndpoints
  :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ImportJobResource/RoleArn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobResource/S3Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobResource/SegmentId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ImportJobResource/SegmentName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Template/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Template/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteVoiceChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetApnsVoipChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageResponse/MessageResponse
  :cognitect.aws.pinpoint/MessageResponse)

(s/def
  :cognitect.aws.pinpoint.ListRecommenderConfigurationsResponse/Item
  :cognitect.aws.pinpoint/ListOfRecommenderConfigurationResponse)

(s/def
  :cognitect.aws.pinpoint.ListRecommenderConfigurationsResponse/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendUsersMessagesResponse/SendUsersMessageResponse
  :cognitect.aws.pinpoint/SendUsersMessageResponse)

(s/def
  :cognitect.aws.pinpoint.GetSegmentVersionResponse/SegmentResponse
  :cognitect.aws.pinpoint/SegmentResponse)

(s/def
  :cognitect.aws.pinpoint.RemoveAttributesRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RemoveAttributesRequest/AttributeType
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RemoveAttributesRequest/UpdateAttributesRequest
  :cognitect.aws.pinpoint/UpdateAttributesRequest)

(s/def
  :cognitect.aws.pinpoint.GetGcmChannelResponse/GCMChannelResponse
  :cognitect.aws.pinpoint/GCMChannelResponse)

(s/def
  :cognitect.aws.pinpoint.DeleteSmsChannelResponse/SMSChannelResponse
  :cognitect.aws.pinpoint/SMSChannelResponse)

(s/def
  :cognitect.aws.pinpoint.SMSTemplateResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSTemplateResponse/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.SMSTemplateResponse/RecommenderId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SMSTemplateResponse/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSTemplateResponse/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSTemplateResponse/TemplateName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSTemplateResponse/Arn :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SMSTemplateResponse/TemplateType
  :cognitect.aws.pinpoint/TemplateType)

(s/def :cognitect.aws.pinpoint.SMSTemplateResponse/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSTemplateResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SMSTemplateResponse/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TemplateVersionsResponse/Item
  :cognitect.aws.pinpoint/ListOfTemplateVersionResponse)

(s/def :cognitect.aws.pinpoint.TemplateVersionsResponse/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateVersionsResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateVersionsResponse/RequestID :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetAdmChannelRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignActivitiesResponse/ActivitiesResponse
  :cognitect.aws.pinpoint/ActivitiesResponse)

(s/def :cognitect.aws.pinpoint.GetImportJobRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetImportJobRequest/JobId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignHook/LambdaFunctionName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignHook/Mode :cognitect.aws.pinpoint/Mode)

(s/def :cognitect.aws.pinpoint.CampaignHook/WebUrl :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeletePushTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeletePushTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateTemplateActiveVersionRequest/TemplateActiveVersionRequest
  :cognitect.aws.pinpoint/TemplateActiveVersionRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateTemplateActiveVersionRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateTemplateActiveVersionRequest/TemplateType
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/Id :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EndpointBatchItem/Demographic
  :cognitect.aws.pinpoint/EndpointDemographic)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/Address :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/Metrics :cognitect.aws.pinpoint/MapOf__double)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/RequestId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/User :cognitect.aws.pinpoint/EndpointUser)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/EffectiveDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/EndpointStatus :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EndpointBatchItem/Attributes
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/ChannelType :cognitect.aws.pinpoint/ChannelType)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/OptOut :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointBatchItem/Location :cognitect.aws.pinpoint/EndpointLocation)

(s/def
  :cognitect.aws.pinpoint.UpdateBaiduChannelResponse/BaiduChannelResponse
  :cognitect.aws.pinpoint/BaiduChannelResponse)

(s/def :cognitect.aws.pinpoint.MessageHeader/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MessageHeader/Value :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GPSCoordinates/Latitude :cognitect.aws.pinpoint/__double)

(s/def :cognitect.aws.pinpoint.GPSCoordinates/Longitude :cognitect.aws.pinpoint/__double)

(s/def
  :cognitect.aws.pinpoint.PhoneNumberValidateResponse/NumberValidateResponse
  :cognitect.aws.pinpoint/NumberValidateResponse)

(s/def :cognitect.aws.pinpoint.EndpointLocation/City :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointLocation/Country :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointLocation/Latitude :cognitect.aws.pinpoint/__double)

(s/def :cognitect.aws.pinpoint.EndpointLocation/Longitude :cognitect.aws.pinpoint/__double)

(s/def :cognitect.aws.pinpoint.EndpointLocation/PostalCode :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointLocation/Region :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetSegmentImportJobsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetSegmentImportJobsRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetSegmentImportJobsRequest/SegmentId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentImportJobsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateVoiceChannelResponse/VoiceChannelResponse
  :cognitect.aws.pinpoint/VoiceChannelResponse)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/IsArchived
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/Platform
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/Enabled
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/LastModifiedBy
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/HasTokenKey
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/Version
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/CreationDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelResponse/HasCredential
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.GetSegmentVersionRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentVersionRequest/SegmentId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentVersionRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateInAppTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def :cognitect.aws.pinpoint.GetGcmChannelRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PutEventsResponse/EventsResponse
  :cognitect.aws.pinpoint/EventsResponse)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsResponse/JourneyExecutionActivityMetricsResponse
  :cognitect.aws.pinpoint/JourneyExecutionActivityMetricsResponse)

(s/def
  :cognitect.aws.pinpoint.APNSVoipChannelResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelResponse/IsArchived :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelResponse/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.APNSVoipChannelResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipChannelResponse/LastModifiedBy
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipChannelResponse/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipChannelResponse/HasTokenKey
  :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSVoipChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.APNSVoipChannelResponse/CreationDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipChannelResponse/HasCredential
  :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.GetEventStreamRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteAdmChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetExportJobRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetExportJobRequest/JobId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailMessageActivity/MessageConfig
  :cognitect.aws.pinpoint/JourneyEmailMessage)

(s/def :cognitect.aws.pinpoint.EmailMessageActivity/NextActivity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailMessageActivity/TemplateName :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailMessageActivity/TemplateVersion
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ClosedDaysRule/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ClosedDaysRule/StartDateTime :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ClosedDaysRule/EndDateTime :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SimpleEmail/HtmlPart :cognitect.aws.pinpoint/SimpleEmailPart)

(s/def :cognitect.aws.pinpoint.SimpleEmail/Subject :cognitect.aws.pinpoint/SimpleEmailPart)

(s/def :cognitect.aws.pinpoint.SimpleEmail/TextPart :cognitect.aws.pinpoint/SimpleEmailPart)

(s/def :cognitect.aws.pinpoint.SimpleEmail/Headers :cognitect.aws.pinpoint/ListOfMessageHeader)

(s/def
  :cognitect.aws.pinpoint.SendUsersMessageRequest/Context
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.SendUsersMessageRequest/MessageConfiguration
  :cognitect.aws.pinpoint/DirectMessageConfiguration)

(s/def
  :cognitect.aws.pinpoint.SendUsersMessageRequest/TemplateConfiguration
  :cognitect.aws.pinpoint/TemplateConfiguration)

(s/def :cognitect.aws.pinpoint.SendUsersMessageRequest/TraceId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendUsersMessageRequest/Users
  :cognitect.aws.pinpoint/MapOfEndpointSendConfiguration)

(s/def
  :cognitect.aws.pinpoint.SegmentImportResource/ChannelCounts
  :cognitect.aws.pinpoint/MapOf__integer)

(s/def :cognitect.aws.pinpoint.SegmentImportResource/ExternalId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentImportResource/Format :cognitect.aws.pinpoint/Format)

(s/def :cognitect.aws.pinpoint.SegmentImportResource/RoleArn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentImportResource/S3Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentImportResource/Size :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.EventStartCondition/EventFilter :cognitect.aws.pinpoint/EventFilter)

(s/def :cognitect.aws.pinpoint.EventStartCondition/SegmentId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteApnsVoipSandboxChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PhoneNumberValidateRequest/NumberValidateRequest
  :cognitect.aws.pinpoint/NumberValidateRequest)

(s/def
  :cognitect.aws.pinpoint.CreateInAppTemplateRequest/InAppTemplateRequest
  :cognitect.aws.pinpoint/InAppTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.CreateInAppTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignEmailMessage/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignEmailMessage/FromAddress :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CampaignEmailMessage/Headers
  :cognitect.aws.pinpoint/ListOfMessageHeader)

(s/def :cognitect.aws.pinpoint.CampaignEmailMessage/HtmlBody :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignEmailMessage/Title :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionMetricsResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionMetricsResponse/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionMetricsResponse/LastEvaluatedTime
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyExecutionMetricsResponse/Metrics
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.GetUserEndpointsResponse/EndpointsResponse
  :cognitect.aws.pinpoint/EndpointsResponse)

(s/def
  :cognitect.aws.pinpoint.ListTemplateVersionsResponse/TemplateVersionsResponse
  :cognitect.aws.pinpoint/TemplateVersionsResponse)

(s/def
  :cognitect.aws.pinpoint.GetSegmentVersionsResponse/SegmentsResponse
  :cognitect.aws.pinpoint/SegmentsResponse)

(s/def
  :cognitect.aws.pinpoint.MessageRequest/Addresses
  :cognitect.aws.pinpoint/MapOfAddressConfiguration)

(s/def :cognitect.aws.pinpoint.MessageRequest/Context :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.MessageRequest/Endpoints
  :cognitect.aws.pinpoint/MapOfEndpointSendConfiguration)

(s/def
  :cognitect.aws.pinpoint.MessageRequest/MessageConfiguration
  :cognitect.aws.pinpoint/DirectMessageConfiguration)

(s/def
  :cognitect.aws.pinpoint.MessageRequest/TemplateConfiguration
  :cognitect.aws.pinpoint/TemplateConfiguration)

(s/def :cognitect.aws.pinpoint.MessageRequest/TraceId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsResponse/JourneyRunExecutionMetricsResponse
  :cognitect.aws.pinpoint/JourneyRunExecutionMetricsResponse)

(s/def
  :cognitect.aws.pinpoint.GetEventStreamResponse/EventStream
  :cognitect.aws.pinpoint/EventStream)

(s/def :cognitect.aws.pinpoint.SimpleEmailPart/Charset :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SimpleEmailPart/Data :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaseKpiResult/Rows :cognitect.aws.pinpoint/ListOfResultRow)

(s/def :cognitect.aws.pinpoint.SegmentResponse/LastModifiedDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentResponse/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.SegmentResponse/ImportDefinition
  :cognitect.aws.pinpoint/SegmentImportResource)

(s/def :cognitect.aws.pinpoint.SegmentResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentResponse/Dimensions :cognitect.aws.pinpoint/SegmentDimensions)

(s/def
  :cognitect.aws.pinpoint.SegmentResponse/SegmentGroups
  :cognitect.aws.pinpoint/SegmentGroupList)

(s/def :cognitect.aws.pinpoint.SegmentResponse/Arn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentResponse/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentResponse/SegmentType :cognitect.aws.pinpoint/SegmentType)

(s/def :cognitect.aws.pinpoint.SegmentResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.SegmentResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NotFoundException/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NotFoundException/RequestID :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobRequest/RoleArn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobRequest/S3UrlPrefix :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobRequest/SegmentId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobRequest/SegmentVersion :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.GetEmailChannelResponse/EmailChannelResponse
  :cognitect.aws.pinpoint/EmailChannelResponse)

(s/def
  :cognitect.aws.pinpoint.AttributeDimension/AttributeType
  :cognitect.aws.pinpoint/AttributeType)

(s/def :cognitect.aws.pinpoint.AttributeDimension/Values :cognitect.aws.pinpoint/ListOf__string)

(s/def
  :cognitect.aws.pinpoint.CreateCampaignResponse/CampaignResponse
  :cognitect.aws.pinpoint/CampaignResponse)

(s/def
  :cognitect.aws.pinpoint.SimpleCondition/EventCondition
  :cognitect.aws.pinpoint/EventCondition)

(s/def
  :cognitect.aws.pinpoint.SimpleCondition/SegmentCondition
  :cognitect.aws.pinpoint/SegmentCondition)

(s/def
  :cognitect.aws.pinpoint.SimpleCondition/SegmentDimensions
  :cognitect.aws.pinpoint/SegmentDimensions)

(s/def
  :cognitect.aws.pinpoint.CreateImportJobResponse/ImportJobResponse
  :cognitect.aws.pinpoint/ImportJobResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateEndpointResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def
  :cognitect.aws.pinpoint.DeleteBaiduChannelResponse/BaiduChannelResponse
  :cognitect.aws.pinpoint/BaiduChannelResponse)

(s/def
  :cognitect.aws.pinpoint.EndpointRequest/Demographic
  :cognitect.aws.pinpoint/EndpointDemographic)

(s/def :cognitect.aws.pinpoint.EndpointRequest/Address :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointRequest/Metrics :cognitect.aws.pinpoint/MapOf__double)

(s/def :cognitect.aws.pinpoint.EndpointRequest/RequestId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointRequest/User :cognitect.aws.pinpoint/EndpointUser)

(s/def :cognitect.aws.pinpoint.EndpointRequest/EffectiveDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointRequest/EndpointStatus :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EndpointRequest/Attributes
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.EndpointRequest/ChannelType :cognitect.aws.pinpoint/ChannelType)

(s/def :cognitect.aws.pinpoint.EndpointRequest/OptOut :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointRequest/Location :cognitect.aws.pinpoint/EndpointLocation)

(s/def
  :cognitect.aws.pinpoint.WriteEventStream/DestinationStreamArn
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WriteEventStream/RoleArn :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.WriteTreatmentResource/CustomDeliveryConfiguration
  :cognitect.aws.pinpoint/CustomDeliveryConfiguration)

(s/def
  :cognitect.aws.pinpoint.WriteTreatmentResource/MessageConfiguration
  :cognitect.aws.pinpoint/MessageConfiguration)

(s/def :cognitect.aws.pinpoint.WriteTreatmentResource/Schedule :cognitect.aws.pinpoint/Schedule)

(s/def :cognitect.aws.pinpoint.WriteTreatmentResource/SizePercent :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.WriteTreatmentResource/TemplateConfiguration
  :cognitect.aws.pinpoint/TemplateConfiguration)

(s/def
  :cognitect.aws.pinpoint.WriteTreatmentResource/TreatmentDescription
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.WriteTreatmentResource/TreatmentName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignVersionsResponse/CampaignsResponse
  :cognitect.aws.pinpoint/CampaignsResponse)

(s/def :cognitect.aws.pinpoint.EndpointItemResponse/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointItemResponse/StatusCode :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/TreatmentName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/Schedule :cognitect.aws.pinpoint/Schedule)

(s/def
  :cognitect.aws.pinpoint.WriteCampaignRequest/MessageConfiguration
  :cognitect.aws.pinpoint/MessageConfiguration)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/SegmentId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/Priority :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/Limits :cognitect.aws.pinpoint/CampaignLimits)

(s/def
  :cognitect.aws.pinpoint.WriteCampaignRequest/AdditionalTreatments
  :cognitect.aws.pinpoint/ListOfWriteTreatmentResource)

(s/def
  :cognitect.aws.pinpoint.WriteCampaignRequest/TreatmentDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/IsPaused :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/Description :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WriteCampaignRequest/Hook :cognitect.aws.pinpoint/CampaignHook)

(s/def
  :cognitect.aws.pinpoint.WriteCampaignRequest/TemplateConfiguration
  :cognitect.aws.pinpoint/TemplateConfiguration)

(s/def
  :cognitect.aws.pinpoint.WriteCampaignRequest/HoldoutPercent
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.WriteCampaignRequest/SegmentVersion
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.WriteCampaignRequest/CustomDeliveryConfiguration
  :cognitect.aws.pinpoint/CustomDeliveryConfiguration)

(s/def
  :cognitect.aws.pinpoint.GetApnsChannelResponse/APNSChannelResponse
  :cognitect.aws.pinpoint/APNSChannelResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateEmailTemplateRequest/CreateNewVersion
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.UpdateEmailTemplateRequest/EmailTemplateRequest
  :cognitect.aws.pinpoint/EmailTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateEmailTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateEmailTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Event/EventType :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Event/AppPackageName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Event/AppTitle :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Event/AppVersionCode :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Event/SdkName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Event/ClientSdkVersion :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Event/Metrics :cognitect.aws.pinpoint/MapOf__double)

(s/def :cognitect.aws.pinpoint.Event/Timestamp :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Event/Attributes :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.Event/Session :cognitect.aws.pinpoint/Session)

(s/def :cognitect.aws.pinpoint.MessageConfiguration/BaiduMessage :cognitect.aws.pinpoint/Message)

(s/def :cognitect.aws.pinpoint.MessageConfiguration/ADMMessage :cognitect.aws.pinpoint/Message)

(s/def
  :cognitect.aws.pinpoint.MessageConfiguration/SMSMessage
  :cognitect.aws.pinpoint/CampaignSmsMessage)

(s/def :cognitect.aws.pinpoint.MessageConfiguration/DefaultMessage :cognitect.aws.pinpoint/Message)

(s/def
  :cognitect.aws.pinpoint.MessageConfiguration/EmailMessage
  :cognitect.aws.pinpoint/CampaignEmailMessage)

(s/def
  :cognitect.aws.pinpoint.MessageConfiguration/InAppMessage
  :cognitect.aws.pinpoint/CampaignInAppMessage)

(s/def
  :cognitect.aws.pinpoint.MessageConfiguration/CustomMessage
  :cognitect.aws.pinpoint/CampaignCustomMessage)

(s/def :cognitect.aws.pinpoint.MessageConfiguration/APNSMessage :cognitect.aws.pinpoint/Message)

(s/def :cognitect.aws.pinpoint.MessageConfiguration/GCMMessage :cognitect.aws.pinpoint/Message)

(s/def
  :cognitect.aws.pinpoint.GetSegmentResponse/SegmentResponse
  :cognitect.aws.pinpoint/SegmentResponse)

(s/def
  :cognitect.aws.pinpoint.ListJourneysResponse/JourneysResponse
  :cognitect.aws.pinpoint/JourneysResponse)

(s/def
  :cognitect.aws.pinpoint.CreateEmailTemplateRequest/EmailTemplateRequest
  :cognitect.aws.pinpoint/EmailTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.CreateEmailTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.WriteSegmentRequest/Dimensions
  :cognitect.aws.pinpoint/SegmentDimensions)

(s/def :cognitect.aws.pinpoint.WriteSegmentRequest/Name :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.WriteSegmentRequest/SegmentGroups
  :cognitect.aws.pinpoint/SegmentGroupList)

(s/def :cognitect.aws.pinpoint.WriteSegmentRequest/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.EndpointMessageResult/Address :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EndpointMessageResult/DeliveryStatus
  :cognitect.aws.pinpoint/DeliveryStatus)

(s/def :cognitect.aws.pinpoint.EndpointMessageResult/MessageId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointMessageResult/StatusCode :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.EndpointMessageResult/StatusMessage :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointMessageResult/UpdatedToken :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteEventStreamRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetAppResponse/ApplicationResponse
  :cognitect.aws.pinpoint/ApplicationResponse)

(s/def
  :cognitect.aws.pinpoint.GetEmailTemplateResponse/EmailTemplateResponse
  :cognitect.aws.pinpoint/EmailTemplateResponse)

(s/def
  :cognitect.aws.pinpoint.PutEventStreamResponse/EventStream
  :cognitect.aws.pinpoint/EventStream)

(s/def
  :cognitect.aws.pinpoint.GetSmsChannelResponse/SMSChannelResponse
  :cognitect.aws.pinpoint/SMSChannelResponse)

(s/def
  :cognitect.aws.pinpoint.MultiConditionalSplitActivity/Branches
  :cognitect.aws.pinpoint/ListOfMultiConditionalBranch)

(s/def
  :cognitect.aws.pinpoint.MultiConditionalSplitActivity/DefaultActivity
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.MultiConditionalSplitActivity/EvaluationWaitTime
  :cognitect.aws.pinpoint/WaitTime)

(s/def
  :cognitect.aws.pinpoint.GetApnsVoipSandboxChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdatePushTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def
  :cognitect.aws.pinpoint.UpdateEndpointsBatchRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateEndpointsBatchRequest/EndpointBatchRequest
  :cognitect.aws.pinpoint/EndpointBatchRequest)

(s/def :cognitect.aws.pinpoint.TemplateCreateMessageBody/Arn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateCreateMessageBody/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateCreateMessageBody/RequestID :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.AttributesResource/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.AttributesResource/AttributeType :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.AttributesResource/Attributes :cognitect.aws.pinpoint/ListOf__string)

(s/def :cognitect.aws.pinpoint.TagsModel/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.TemplateResponse/LastModifiedDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateResponse/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.TemplateResponse/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateResponse/TemplateName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateResponse/Arn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateResponse/TemplateType :cognitect.aws.pinpoint/TemplateType)

(s/def :cognitect.aws.pinpoint.TemplateResponse/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TemplateResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TemplateResponse/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateVoiceTemplateRequest/CreateNewVersion
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.UpdateVoiceTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateVoiceTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateVoiceTemplateRequest/VoiceTemplateRequest
  :cognitect.aws.pinpoint/VoiceTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.GetSegmentExportJobsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetSegmentExportJobsRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetSegmentExportJobsRequest/SegmentId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentExportJobsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteCampaignRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteCampaignRequest/CampaignId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteEndpointResponse/EndpointResponse
  :cognitect.aws.pinpoint/EndpointResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsSandboxChannelRequest/APNSSandboxChannelRequest
  :cognitect.aws.pinpoint/APNSSandboxChannelRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsSandboxChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteJourneyRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteJourneyRequest/JourneyId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteBaiduChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfigurationResponse/RecommenderConfigurationResponse
  :cognitect.aws.pinpoint/RecommenderConfigurationResponse)

(s/def
  :cognitect.aws.pinpoint.GetSegmentsResponse/SegmentsResponse
  :cognitect.aws.pinpoint/SegmentsResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateInAppTemplateRequest/CreateNewVersion
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.UpdateInAppTemplateRequest/InAppTemplateRequest
  :cognitect.aws.pinpoint/InAppTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateInAppTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateInAppTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/IconReference :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/RawContent :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/ImageUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/Data :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/Title :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/SmallImageIconUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/Sound :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/Action :cognitect.aws.pinpoint/Action)

(s/def
  :cognitect.aws.pinpoint.BaiduMessage/Substitutions
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.BaiduMessage/TimeToLive :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.BaiduMessage/SilentPush :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.BaiduMessage/ImageIconUrl :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateSmsTemplateResponse/CreateTemplateMessageBody
  :cognitect.aws.pinpoint/CreateTemplateMessageBody)

(s/def
  :cognitect.aws.pinpoint.GetJourneyResponse/JourneyResponse
  :cognitect.aws.pinpoint/JourneyResponse)

(s/def :cognitect.aws.pinpoint.EventStream/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EventStream/DestinationStreamArn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EventStream/ExternalId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EventStream/LastModifiedDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EventStream/LastUpdatedBy :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EventStream/RoleArn :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsResponse/JourneyRunExecutionActivityMetricsResponse
  :cognitect.aws.pinpoint/JourneyRunExecutionActivityMetricsResponse)

(s/def :cognitect.aws.pinpoint.JourneyRunResponse/CreationTime :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyRunResponse/LastUpdateTime :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyRunResponse/RunId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyRunResponse/Status :cognitect.aws.pinpoint/JourneyRunStatus)

(s/def :cognitect.aws.pinpoint.CreateSegmentRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateSegmentRequest/WriteSegmentRequest
  :cognitect.aws.pinpoint/WriteSegmentRequest)

(s/def
  :cognitect.aws.pinpoint.DeleteCampaignResponse/CampaignResponse
  :cognitect.aws.pinpoint/CampaignResponse)

(s/def
  :cognitect.aws.pinpoint.NumberValidateResponse/OriginalPhoneNumber
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.NumberValidateResponse/CountryCodeIso2
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.NumberValidateResponse/CleansedPhoneNumberE164
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NumberValidateResponse/Carrier :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NumberValidateResponse/ZipCode :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NumberValidateResponse/City :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NumberValidateResponse/County :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.NumberValidateResponse/CleansedPhoneNumberNational
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NumberValidateResponse/Timezone :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NumberValidateResponse/PhoneType :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.NumberValidateResponse/CountryCodeNumeric
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.NumberValidateResponse/OriginalCountryCodeIso2
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NumberValidateResponse/Country :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.NumberValidateResponse/PhoneTypeCode
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.GetInAppMessagesResponse/InAppMessagesResponse
  :cognitect.aws.pinpoint/InAppMessagesResponse)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/BundleId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/Certificate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/Enabled
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/PrivateKey
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/TeamId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/TokenKey
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSVoipSandboxChannelRequest/TokenKeyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetInAppTemplateResponse/InAppTemplateResponse
  :cognitect.aws.pinpoint/InAppTemplateResponse)

(s/def :cognitect.aws.pinpoint.GetPushTemplateRequest/TemplateName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetPushTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/ExpiresAfter :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/IconReference :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/RawContent :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/ImageUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/Data :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/Title :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/SmallImageIconUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/Sound :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/Action :cognitect.aws.pinpoint/Action)

(s/def :cognitect.aws.pinpoint.ADMMessage/Substitutions :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/MD5 :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/ConsolidationKey :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMMessage/SilentPush :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ADMMessage/ImageIconUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteSegmentRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteSegmentRequest/SegmentId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteVoiceTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def
  :cognitect.aws.pinpoint.EndpointSendConfiguration/BodyOverride
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EndpointSendConfiguration/Context
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.EndpointSendConfiguration/RawContent
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EndpointSendConfiguration/Substitutions
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def
  :cognitect.aws.pinpoint.EndpointSendConfiguration/TitleOverride
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TemplateActiveVersionRequest/Version
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyCustomMessage/Data :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetSegmentImportJobsResponse/ImportJobsResponse
  :cognitect.aws.pinpoint/ImportJobsResponse)

(s/def :cognitect.aws.pinpoint.APNSSandboxChannelRequest/BundleId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelRequest/Certificate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelRequest/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSSandboxChannelRequest/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelRequest/PrivateKey
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSSandboxChannelRequest/TeamId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSSandboxChannelRequest/TokenKey :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelRequest/TokenKeyId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EventsBatch/Endpoint :cognitect.aws.pinpoint/PublicEndpoint)

(s/def :cognitect.aws.pinpoint.EventsBatch/Events :cognitect.aws.pinpoint/MapOfEvent)

(s/def
  :cognitect.aws.pinpoint.ExportJobsResponse/Item
  :cognitect.aws.pinpoint/ListOfExportJobResponse)

(s/def :cognitect.aws.pinpoint.ExportJobsResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetVoiceChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfigurationResponse/RecommenderConfigurationResponse
  :cognitect.aws.pinpoint/RecommenderConfigurationResponse)

(s/def
  :cognitect.aws.pinpoint.EventDimensions/Attributes
  :cognitect.aws.pinpoint/MapOfAttributeDimension)

(s/def :cognitect.aws.pinpoint.EventDimensions/EventType :cognitect.aws.pinpoint/SetDimension)

(s/def :cognitect.aws.pinpoint.EventDimensions/Metrics :cognitect.aws.pinpoint/MapOfMetricDimension)

(s/def
  :cognitect.aws.pinpoint.GetExportJobsResponse/ExportJobsResponse
  :cognitect.aws.pinpoint/ExportJobsResponse)

(s/def
  :cognitect.aws.pinpoint.DeleteSmsTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteSmsTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyLimits/DailyCap :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.JourneyLimits/EndpointReentryCap :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.JourneyLimits/MessagesPerSecond :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.JourneyLimits/EndpointReentryInterval
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyLimits/TimeframeCap
  :cognitect.aws.pinpoint/JourneyTimeframeCap)

(s/def :cognitect.aws.pinpoint.JourneyLimits/TotalCap :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.TemplatesResponse/Item
  :cognitect.aws.pinpoint/ListOfTemplateResponse)

(s/def :cognitect.aws.pinpoint.TemplatesResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateExportJobRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateExportJobRequest/ExportJobRequest
  :cognitect.aws.pinpoint/ExportJobRequest)

(s/def :cognitect.aws.pinpoint.DeleteEndpointRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteEndpointRequest/EndpointId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignCustomMessage/Data :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateAppRequest/CreateApplicationRequest
  :cognitect.aws.pinpoint/CreateApplicationRequest)

(s/def
  :cognitect.aws.pinpoint.CreateVoiceTemplateResponse/CreateTemplateMessageBody
  :cognitect.aws.pinpoint/CreateTemplateMessageBody)

(s/def
  :cognitect.aws.pinpoint.EmailTemplateRequest/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateRequest/HtmlPart :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateRequest/RecommenderId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateRequest/Subject :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailTemplateRequest/Headers
  :cognitect.aws.pinpoint/ListOfMessageHeader)

(s/def :cognitect.aws.pinpoint.EmailTemplateRequest/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.EmailTemplateRequest/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateRequest/TextPart :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.OverrideButtonConfiguration/ButtonAction
  :cognitect.aws.pinpoint/ButtonAction)

(s/def :cognitect.aws.pinpoint.OverrideButtonConfiguration/Link :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyPushMessage/TimeToLive :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetExportJobResponse/ExportJobResponse
  :cognitect.aws.pinpoint/ExportJobResponse)

(s/def
  :cognitect.aws.pinpoint.DeleteApnsVoipChannelResponse/APNSVoipChannelResponse
  :cognitect.aws.pinpoint/APNSVoipChannelResponse)

(s/def :cognitect.aws.pinpoint.GetImportJobsRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetImportJobsRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetImportJobsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateJourneyRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateJourneyRequest/JourneyId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateJourneyRequest/WriteJourneyRequest
  :cognitect.aws.pinpoint/WriteJourneyRequest)

(s/def :cognitect.aws.pinpoint.VoiceChannelRequest/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.VerifyOTPMessageRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.VerifyOTPMessageRequest/VerifyOTPMessageRequestParameters
  :cognitect.aws.pinpoint/VerifyOTPMessageRequestParameters)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/LastModifiedDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/IsArchived :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/LastModifiedBy :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ADMChannelResponse/HasCredential :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.DeleteApnsSandboxChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelRequest/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.SMSChannelRequest/SenderId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSChannelRequest/ShortCode :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CustomMessageActivity/DeliveryUri :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CustomMessageActivity/EndpointTypes
  :cognitect.aws.pinpoint/ListOf__EndpointTypesElement)

(s/def
  :cognitect.aws.pinpoint.CustomMessageActivity/MessageConfig
  :cognitect.aws.pinpoint/JourneyCustomMessage)

(s/def :cognitect.aws.pinpoint.CustomMessageActivity/NextActivity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CustomMessageActivity/TemplateName :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CustomMessageActivity/TemplateVersion
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ListTemplatesResponse/TemplatesResponse
  :cognitect.aws.pinpoint/TemplatesResponse)

(s/def
  :cognitect.aws.pinpoint.GetAdmChannelResponse/ADMChannelResponse
  :cognitect.aws.pinpoint/ADMChannelResponse)

(s/def
  :cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Action
  :cognitect.aws.pinpoint/Action)

(s/def
  :cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Body
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Sound
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Title
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DefaultPushNotificationTemplate/Url :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InternalServerErrorException/Message
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InternalServerErrorException/RequestID
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignSmsMessage/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignSmsMessage/MessageType :cognitect.aws.pinpoint/MessageType)

(s/def
  :cognitect.aws.pinpoint.CampaignSmsMessage/OriginationNumber
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignSmsMessage/SenderId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignSmsMessage/EntityId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CampaignSmsMessage/TemplateId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CampaignsResponse/Item
  :cognitect.aws.pinpoint/ListOfCampaignResponse)

(s/def :cognitect.aws.pinpoint.CampaignsResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceMessage/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceMessage/LanguageCode :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceMessage/OriginationNumber :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.VoiceMessage/Substitutions
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.VoiceMessage/VoiceId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.RandomSplitActivity/Branches
  :cognitect.aws.pinpoint/ListOfRandomSplitEntry)

(s/def :cognitect.aws.pinpoint.SMSMessage/TemplateId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSMessage/SenderId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSMessage/MediaUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSMessage/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSMessage/Keyword :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSMessage/OriginationNumber :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSMessage/MessageType :cognitect.aws.pinpoint/MessageType)

(s/def :cognitect.aws.pinpoint.SMSMessage/EntityId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSMessage/Substitutions :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def
  :cognitect.aws.pinpoint.DeleteJourneyResponse/JourneyResponse
  :cognitect.aws.pinpoint/JourneyResponse)

(s/def
  :cognitect.aws.pinpoint.GetEndpointResponse/EndpointResponse
  :cognitect.aws.pinpoint/EndpointResponse)

(s/def :cognitect.aws.pinpoint.CreateCampaignRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateCampaignRequest/WriteCampaignRequest
  :cognitect.aws.pinpoint/WriteCampaignRequest)

(s/def :cognitect.aws.pinpoint.UpdateCampaignRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateCampaignRequest/CampaignId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateCampaignRequest/WriteCampaignRequest
  :cognitect.aws.pinpoint/WriteCampaignRequest)

(s/def
  :cognitect.aws.pinpoint.GetRecommenderConfigurationRequest/RecommenderId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetApplicationDateRangeKpiResponse/ApplicationDateRangeKpiResponse
  :cognitect.aws.pinpoint/ApplicationDateRangeKpiResponse)

(s/def
  :cognitect.aws.pinpoint.GetEmailChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignResponse/CampaignResponse
  :cognitect.aws.pinpoint/CampaignResponse)

(s/def :cognitect.aws.pinpoint.GetSmsChannelRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/LastModifiedDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/IsArchived :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.GCMChannelResponse/HasFcmServiceCredentials
  :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/Credential :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/LastModifiedBy :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GCMChannelResponse/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMChannelResponse/HasCredential :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.JourneyChannelSettings/ConnectCampaignArn
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyChannelSettings/ConnectCampaignExecutionRoleArn
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SMSMessageActivity/MessageConfig
  :cognitect.aws.pinpoint/JourneySMSMessage)

(s/def :cognitect.aws.pinpoint.SMSMessageActivity/NextActivity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSMessageActivity/TemplateName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSMessageActivity/TemplateVersion :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteInAppTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def
  :cognitect.aws.pinpoint.ImportJobsResponse/Item
  :cognitect.aws.pinpoint/ListOfImportJobResponse)

(s/def :cognitect.aws.pinpoint.ImportJobsResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InAppMessagesResponse/InAppMessageCampaigns
  :cognitect.aws.pinpoint/ListOfInAppMessageCampaign)

(s/def
  :cognitect.aws.pinpoint.GetApnsSandboxChannelResponse/APNSSandboxChannelResponse
  :cognitect.aws.pinpoint/APNSSandboxChannelResponse)

(s/def :cognitect.aws.pinpoint.CreateApplicationRequest/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CreateApplicationRequest/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.GetJourneyRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetJourneyRequest/JourneyId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateSmsChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateSmsChannelRequest/SMSChannelRequest
  :cognitect.aws.pinpoint/SMSChannelRequest)

(s/def :cognitect.aws.pinpoint.APNSPushNotificationTemplate/Action :cognitect.aws.pinpoint/Action)

(s/def :cognitect.aws.pinpoint.APNSPushNotificationTemplate/Body :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSPushNotificationTemplate/MediaUrl
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSPushNotificationTemplate/RawContent
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSPushNotificationTemplate/Sound :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSPushNotificationTemplate/Title :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSPushNotificationTemplate/Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSmsTemplateRequest/TemplateName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSmsTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetApnsChannelRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateExportJobResponse/ExportJobResponse
  :cognitect.aws.pinpoint/ExportJobResponse)

(s/def
  :cognitect.aws.pinpoint.GetJourneyDateRangeKpiResponse/JourneyDateRangeKpiResponse
  :cognitect.aws.pinpoint/JourneyDateRangeKpiResponse)

(s/def
  :cognitect.aws.pinpoint.ApplicationSettingsJourneyLimits/DailyCap
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.ApplicationSettingsJourneyLimits/TimeframeCap
  :cognitect.aws.pinpoint/JourneyTimeframeCap)

(s/def
  :cognitect.aws.pinpoint.ApplicationSettingsJourneyLimits/TotalCap
  :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.SegmentReference/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SegmentReference/Version :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.VoiceTemplateResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateResponse/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.VoiceTemplateResponse/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateResponse/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateResponse/VoiceId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateResponse/TemplateName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateResponse/Arn :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.VoiceTemplateResponse/TemplateType
  :cognitect.aws.pinpoint/TemplateType)

(s/def :cognitect.aws.pinpoint.VoiceTemplateResponse/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.VoiceTemplateResponse/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateResponse/LanguageCode :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteRecommenderConfigurationRequest/RecommenderId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateEndpointsBatchResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def :cognitect.aws.pinpoint.MetricDimension/ComparisonOperator :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MetricDimension/Value :cognitect.aws.pinpoint/__double)

(s/def :cognitect.aws.pinpoint.ConditionalSplitActivity/Condition :cognitect.aws.pinpoint/Condition)

(s/def
  :cognitect.aws.pinpoint.ConditionalSplitActivity/EvaluationWaitTime
  :cognitect.aws.pinpoint/WaitTime)

(s/def
  :cognitect.aws.pinpoint.ConditionalSplitActivity/FalseActivity
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ConditionalSplitActivity/TrueActivity
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ApplicationSettingsResource/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ApplicationSettingsResource/CampaignHook
  :cognitect.aws.pinpoint/CampaignHook)

(s/def
  :cognitect.aws.pinpoint.ApplicationSettingsResource/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ApplicationSettingsResource/Limits
  :cognitect.aws.pinpoint/CampaignLimits)

(s/def
  :cognitect.aws.pinpoint.ApplicationSettingsResource/QuietTime
  :cognitect.aws.pinpoint/QuietTime)

(s/def
  :cognitect.aws.pinpoint.ApplicationSettingsResource/JourneyLimits
  :cognitect.aws.pinpoint/ApplicationSettingsJourneyLimits)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/JourneyActivityId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionActivityMetricsRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateJourneyResponse/JourneyResponse
  :cognitect.aws.pinpoint/JourneyResponse)

(s/def :cognitect.aws.pinpoint.RawEmail/Data :cognitect.aws.pinpoint/__blob)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsChannelRequest/APNSChannelRequest
  :cognitect.aws.pinpoint/APNSChannelRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelRequest/BundleId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelRequest/Certificate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSChannelRequest/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelRequest/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSChannelRequest/PrivateKey :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelRequest/TeamId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelRequest/TokenKey :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSChannelRequest/TokenKeyId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignVersionResponse/CampaignResponse
  :cognitect.aws.pinpoint/CampaignResponse)

(s/def
  :cognitect.aws.pinpoint.CreateSegmentResponse/SegmentResponse
  :cognitect.aws.pinpoint/SegmentResponse)

(s/def
  :cognitect.aws.pinpoint.GetVoiceChannelResponse/VoiceChannelResponse
  :cognitect.aws.pinpoint/VoiceChannelResponse)

(s/def :cognitect.aws.pinpoint.DefaultMessage/Body :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DefaultMessage/Substitutions
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def
  :cognitect.aws.pinpoint.UpdateJourneyStateRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateJourneyStateRequest/JourneyId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateJourneyStateRequest/JourneyStateRequest
  :cognitect.aws.pinpoint/JourneyStateRequest)

(s/def
  :cognitect.aws.pinpoint.DeleteInAppTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteInAppTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PublicEndpoint/Demographic
  :cognitect.aws.pinpoint/EndpointDemographic)

(s/def :cognitect.aws.pinpoint.PublicEndpoint/Address :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PublicEndpoint/Metrics :cognitect.aws.pinpoint/MapOf__double)

(s/def :cognitect.aws.pinpoint.PublicEndpoint/RequestId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PublicEndpoint/User :cognitect.aws.pinpoint/EndpointUser)

(s/def :cognitect.aws.pinpoint.PublicEndpoint/EffectiveDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PublicEndpoint/EndpointStatus :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PublicEndpoint/Attributes
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.PublicEndpoint/ChannelType :cognitect.aws.pinpoint/ChannelType)

(s/def :cognitect.aws.pinpoint.PublicEndpoint/OptOut :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PublicEndpoint/Location :cognitect.aws.pinpoint/EndpointLocation)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsVoipSandboxChannelResponse/APNSVoipSandboxChannelResponse
  :cognitect.aws.pinpoint/APNSVoipSandboxChannelResponse)

(s/def :cognitect.aws.pinpoint.JourneyStateRequest/State :cognitect.aws.pinpoint/State)

(s/def
  :cognitect.aws.pinpoint.ApplicationsResponse/Item
  :cognitect.aws.pinpoint/ListOfApplicationResponse)

(s/def :cognitect.aws.pinpoint.ApplicationsResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ForbiddenException/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ForbiddenException/RequestID :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetApnsVoipChannelResponse/APNSVoipChannelResponse
  :cognitect.aws.pinpoint/APNSVoipChannelResponse)

(s/def :cognitect.aws.pinpoint.EmailMessage/Body :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailMessage/FeedbackForwardingAddress
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailMessage/FromAddress :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailMessage/RawEmail :cognitect.aws.pinpoint/RawEmail)

(s/def :cognitect.aws.pinpoint.EmailMessage/ReplyToAddresses :cognitect.aws.pinpoint/ListOf__string)

(s/def :cognitect.aws.pinpoint.EmailMessage/SimpleEmail :cognitect.aws.pinpoint/SimpleEmail)

(s/def
  :cognitect.aws.pinpoint.EmailMessage/Substitutions
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.BadRequestException/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BadRequestException/RequestID :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetCampaignsRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetCampaignsRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetCampaignsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateSmsChannelResponse/SMSChannelResponse
  :cognitect.aws.pinpoint/SMSChannelResponse)

(s/def :cognitect.aws.pinpoint.SendOTPMessageRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequest/SendOTPMessageRequestParameters
  :cognitect.aws.pinpoint/SendOTPMessageRequestParameters)

(s/def
  :cognitect.aws.pinpoint.UpdateApplicationSettingsResponse/ApplicationSettingsResource
  :cognitect.aws.pinpoint/ApplicationSettingsResource)

(s/def
  :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/CampaignId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/EndTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/KpiName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignDateRangeKpiRequest/StartTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsChannelResponse/APNSChannelResponse
  :cognitect.aws.pinpoint/APNSChannelResponse)

(s/def
  :cognitect.aws.pinpoint.GetBaiduChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ContactCenterActivity/NextActivity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyResponse/LastModifiedDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyResponse/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.JourneyResponse/SendingSchedule :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.JourneyResponse/RefreshOnSegmentUpdate
  :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.JourneyResponse/OpenHours :cognitect.aws.pinpoint/OpenHours)

(s/def :cognitect.aws.pinpoint.JourneyResponse/Schedule :cognitect.aws.pinpoint/JourneySchedule)

(s/def :cognitect.aws.pinpoint.JourneyResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyResponse/LocalTime :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.JourneyResponse/WaitForQuietTime :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.JourneyResponse/Limits :cognitect.aws.pinpoint/JourneyLimits)

(s/def
  :cognitect.aws.pinpoint.JourneyResponse/JourneyChannelSettings
  :cognitect.aws.pinpoint/JourneyChannelSettings)

(s/def :cognitect.aws.pinpoint.JourneyResponse/StartActivity :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyResponse/TimezoneEstimationMethods
  :cognitect.aws.pinpoint/ListOf__TimezoneEstimationMethodsElement)

(s/def :cognitect.aws.pinpoint.JourneyResponse/RefreshFrequency :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyResponse/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyResponse/State :cognitect.aws.pinpoint/State)

(s/def :cognitect.aws.pinpoint.JourneyResponse/Activities :cognitect.aws.pinpoint/MapOfActivity)

(s/def :cognitect.aws.pinpoint.JourneyResponse/QuietTime :cognitect.aws.pinpoint/QuietTime)

(s/def :cognitect.aws.pinpoint.JourneyResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyResponse/StartCondition
  :cognitect.aws.pinpoint/StartCondition)

(s/def :cognitect.aws.pinpoint.JourneyResponse/ClosedDays :cognitect.aws.pinpoint/ClosedDays)

(s/def
  :cognitect.aws.pinpoint.GetCampaignDateRangeKpiResponse/CampaignDateRangeKpiResponse
  :cognitect.aws.pinpoint/CampaignDateRangeKpiResponse)

(s/def :cognitect.aws.pinpoint.UpdateSegmentRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdateSegmentRequest/SegmentId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateSegmentRequest/WriteSegmentRequest
  :cognitect.aws.pinpoint/WriteSegmentRequest)

(s/def
  :cognitect.aws.pinpoint.UpdatePushTemplateRequest/CreateNewVersion
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.UpdatePushTemplateRequest/PushNotificationTemplateRequest
  :cognitect.aws.pinpoint/PushNotificationTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.UpdatePushTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UpdatePushTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateEmailChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateEmailChannelRequest/EmailChannelRequest
  :cognitect.aws.pinpoint/EmailChannelRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsSandboxChannelResponse/APNSSandboxChannelResponse
  :cognitect.aws.pinpoint/APNSSandboxChannelResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfigurationRequest/RecommenderId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateRecommenderConfigurationRequest/UpdateRecommenderConfiguration
  :cognitect.aws.pinpoint/UpdateRecommenderConfiguration)

(s/def
  :cognitect.aws.pinpoint.CreateVoiceTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateVoiceTemplateRequest/VoiceTemplateRequest
  :cognitect.aws.pinpoint/VoiceTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.DeleteApnsSandboxChannelResponse/APNSSandboxChannelResponse
  :cognitect.aws.pinpoint/APNSSandboxChannelResponse)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/tags
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/GCM
  :cognitect.aws.pinpoint/AndroidPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/APNS
  :cognitect.aws.pinpoint/APNSPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/RecommenderId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/Baidu
  :cognitect.aws.pinpoint/AndroidPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/Arn
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/TemplateType
  :cognitect.aws.pinpoint/TemplateType)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/Version
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/Default
  :cognitect.aws.pinpoint/DefaultPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/CreationDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.PushNotificationTemplateResponse/ADM
  :cognitect.aws.pinpoint/AndroidPushNotificationTemplate)

(s/def
  :cognitect.aws.pinpoint.CampaignEventFilter/Dimensions
  :cognitect.aws.pinpoint/EventDimensions)

(s/def :cognitect.aws.pinpoint.CampaignEventFilter/FilterType :cognitect.aws.pinpoint/FilterType)

(s/def
  :cognitect.aws.pinpoint.SegmentDimensions/Attributes
  :cognitect.aws.pinpoint/MapOfAttributeDimension)

(s/def :cognitect.aws.pinpoint.SegmentDimensions/Behavior :cognitect.aws.pinpoint/SegmentBehaviors)

(s/def
  :cognitect.aws.pinpoint.SegmentDimensions/Demographic
  :cognitect.aws.pinpoint/SegmentDemographics)

(s/def :cognitect.aws.pinpoint.SegmentDimensions/Location :cognitect.aws.pinpoint/SegmentLocation)

(s/def
  :cognitect.aws.pinpoint.SegmentDimensions/Metrics
  :cognitect.aws.pinpoint/MapOfMetricDimension)

(s/def
  :cognitect.aws.pinpoint.SegmentDimensions/UserAttributes
  :cognitect.aws.pinpoint/MapOfAttributeDimension)

(s/def :cognitect.aws.pinpoint.PayloadTooLargeException/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PayloadTooLargeException/RequestID :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateAdmChannelResponse/ADMChannelResponse
  :cognitect.aws.pinpoint/ADMChannelResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateEmailChannelResponse/EmailChannelResponse
  :cognitect.aws.pinpoint/EmailChannelResponse)

(s/def :cognitect.aws.pinpoint.EndpointResponse/Id :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EndpointResponse/Demographic
  :cognitect.aws.pinpoint/EndpointDemographic)

(s/def :cognitect.aws.pinpoint.EndpointResponse/Address :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointResponse/Metrics :cognitect.aws.pinpoint/MapOf__double)

(s/def :cognitect.aws.pinpoint.EndpointResponse/CohortId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointResponse/RequestId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointResponse/User :cognitect.aws.pinpoint/EndpointUser)

(s/def :cognitect.aws.pinpoint.EndpointResponse/EffectiveDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointResponse/EndpointStatus :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EndpointResponse/Attributes
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.EndpointResponse/ChannelType :cognitect.aws.pinpoint/ChannelType)

(s/def :cognitect.aws.pinpoint.EndpointResponse/OptOut :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EndpointResponse/Location :cognitect.aws.pinpoint/EndpointLocation)

(s/def :cognitect.aws.pinpoint.EndpointResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetAppsResponse/ApplicationsResponse
  :cognitect.aws.pinpoint/ApplicationsResponse)

(s/def
  :cognitect.aws.pinpoint.CreatePushTemplateResponse/CreateTemplateMessageBody
  :cognitect.aws.pinpoint/CreateTemplateMessageBody)

(s/def
  :cognitect.aws.pinpoint.GetRecommenderConfigurationsResponse/ListRecommenderConfigurationsResponse
  :cognitect.aws.pinpoint/ListRecommenderConfigurationsResponse)

(s/def
  :cognitect.aws.pinpoint.DeleteApnsChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteEventStreamResponse/EventStream
  :cognitect.aws.pinpoint/EventStream)

(s/def
  :cognitect.aws.pinpoint.InAppTemplateRequest/Content
  :cognitect.aws.pinpoint/ListOfInAppMessageContent)

(s/def
  :cognitect.aws.pinpoint.InAppTemplateRequest/CustomConfig
  :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.InAppTemplateRequest/Layout :cognitect.aws.pinpoint/Layout)

(s/def :cognitect.aws.pinpoint.InAppTemplateRequest/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.InAppTemplateRequest/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunsResponse/Item
  :cognitect.aws.pinpoint/ListOfJourneyRunResponse)

(s/def :cognitect.aws.pinpoint.JourneyRunsResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.NumberValidateRequest/IsoCountryCode
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.NumberValidateRequest/PhoneNumber :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/ActivityType
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/JourneyActivityId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/LastEvaluatedTime
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/Metrics
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionActivityMetricsResponse/RunId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteVoiceTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DeleteVoiceTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.VerifyOTPMessageRequestParameters/DestinationIdentity
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.VerifyOTPMessageRequestParameters/Otp
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.VerifyOTPMessageRequestParameters/ReferenceId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UntagResourceRequest/ResourceArn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.UntagResourceRequest/TagKeys :cognitect.aws.pinpoint/ListOf__string)

(s/def
  :cognitect.aws.pinpoint.DefaultButtonConfiguration/BackgroundColor
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DefaultButtonConfiguration/BorderRadius
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.DefaultButtonConfiguration/ButtonAction
  :cognitect.aws.pinpoint/ButtonAction)

(s/def :cognitect.aws.pinpoint.DefaultButtonConfiguration/Link :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.DefaultButtonConfiguration/Text :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DefaultButtonConfiguration/TextColor
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetRecommenderConfigurationsRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetRecommenderConfigurationsRequest/Token
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteVoiceChannelResponse/VoiceChannelResponse
  :cognitect.aws.pinpoint/VoiceChannelResponse)

(s/def
  :cognitect.aws.pinpoint.GetSmsTemplateResponse/SMSTemplateResponse
  :cognitect.aws.pinpoint/SMSTemplateResponse)

(s/def
  :cognitect.aws.pinpoint.ListTemplateVersionsRequest/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ListTemplateVersionsRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ListTemplateVersionsRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ListTemplateVersionsRequest/TemplateType
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentsRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentsRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetSegmentsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ChannelResponse/LastModifiedDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ChannelResponse/IsArchived :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.ChannelResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ChannelResponse/LastModifiedBy :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.ChannelResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ChannelResponse/HasCredential :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.PushMessageActivity/MessageConfig
  :cognitect.aws.pinpoint/JourneyPushMessage)

(s/def :cognitect.aws.pinpoint.PushMessageActivity/NextActivity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PushMessageActivity/TemplateName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PushMessageActivity/TemplateVersion :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailTemplateResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateResponse/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateResponse/TextPart :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateResponse/RecommenderId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailTemplateResponse/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateResponse/Subject :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailTemplateResponse/Headers
  :cognitect.aws.pinpoint/ListOfMessageHeader)

(s/def :cognitect.aws.pinpoint.EmailTemplateResponse/TemplateName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateResponse/Arn :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailTemplateResponse/TemplateType
  :cognitect.aws.pinpoint/TemplateType)

(s/def :cognitect.aws.pinpoint.EmailTemplateResponse/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateResponse/HtmlPart :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailTemplateResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailTemplateResponse/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.InAppMessageContent/BackgroundColor :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InAppMessageContent/BodyConfig
  :cognitect.aws.pinpoint/InAppMessageBodyConfig)

(s/def
  :cognitect.aws.pinpoint.InAppMessageContent/HeaderConfig
  :cognitect.aws.pinpoint/InAppMessageHeaderConfig)

(s/def :cognitect.aws.pinpoint.InAppMessageContent/ImageUrl :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InAppMessageContent/PrimaryBtn
  :cognitect.aws.pinpoint/InAppMessageButton)

(s/def
  :cognitect.aws.pinpoint.InAppMessageContent/SecondaryBtn
  :cognitect.aws.pinpoint/InAppMessageButton)

(s/def
  :cognitect.aws.pinpoint.DirectMessageConfiguration/DefaultPushNotificationMessage
  :cognitect.aws.pinpoint/DefaultPushNotificationMessage)

(s/def
  :cognitect.aws.pinpoint.DirectMessageConfiguration/BaiduMessage
  :cognitect.aws.pinpoint/BaiduMessage)

(s/def
  :cognitect.aws.pinpoint.DirectMessageConfiguration/ADMMessage
  :cognitect.aws.pinpoint/ADMMessage)

(s/def
  :cognitect.aws.pinpoint.DirectMessageConfiguration/VoiceMessage
  :cognitect.aws.pinpoint/VoiceMessage)

(s/def
  :cognitect.aws.pinpoint.DirectMessageConfiguration/SMSMessage
  :cognitect.aws.pinpoint/SMSMessage)

(s/def
  :cognitect.aws.pinpoint.DirectMessageConfiguration/DefaultMessage
  :cognitect.aws.pinpoint/DefaultMessage)

(s/def
  :cognitect.aws.pinpoint.DirectMessageConfiguration/EmailMessage
  :cognitect.aws.pinpoint/EmailMessage)

(s/def
  :cognitect.aws.pinpoint.DirectMessageConfiguration/APNSMessage
  :cognitect.aws.pinpoint/APNSMessage)

(s/def
  :cognitect.aws.pinpoint.DirectMessageConfiguration/GCMMessage
  :cognitect.aws.pinpoint/GCMMessage)

(s/def
  :cognitect.aws.pinpoint.GetBaiduChannelResponse/BaiduChannelResponse
  :cognitect.aws.pinpoint/BaiduChannelResponse)

(s/def :cognitect.aws.pinpoint.ListJourneysRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ListJourneysRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ListJourneysRequest/Token :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetVoiceTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetVoiceTemplateRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateAppResponse/ApplicationResponse
  :cognitect.aws.pinpoint/ApplicationResponse)

(s/def
  :cognitect.aws.pinpoint.UpdateBaiduChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateBaiduChannelRequest/BaiduChannelRequest
  :cognitect.aws.pinpoint/BaiduChannelRequest)

(s/def :cognitect.aws.pinpoint.ResultRowValue/Key :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ResultRowValue/Type :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ResultRowValue/Value :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteRecommenderConfigurationResponse/RecommenderConfigurationResponse
  :cognitect.aws.pinpoint/RecommenderConfigurationResponse)

(s/def
  :cognitect.aws.pinpoint.GetApplicationSettingsResponse/ApplicationSettingsResource
  :cognitect.aws.pinpoint/ApplicationSettingsResource)

(s/def
  :cognitect.aws.pinpoint.InAppTemplateResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.InAppTemplateResponse/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.InAppTemplateResponse/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.InAppTemplateResponse/Layout :cognitect.aws.pinpoint/Layout)

(s/def
  :cognitect.aws.pinpoint.InAppTemplateResponse/CustomConfig
  :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.InAppTemplateResponse/TemplateName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.InAppTemplateResponse/Arn :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InAppTemplateResponse/TemplateType
  :cognitect.aws.pinpoint/TemplateType)

(s/def :cognitect.aws.pinpoint.InAppTemplateResponse/Version :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.InAppTemplateResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InAppTemplateResponse/Content
  :cognitect.aws.pinpoint/ListOfInAppMessageContent)

(s/def
  :cognitect.aws.pinpoint.GetImportJobsResponse/ImportJobsResponse
  :cognitect.aws.pinpoint/ImportJobsResponse)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSSandboxChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelResponse/IsArchived
  :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSSandboxChannelResponse/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSSandboxChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelResponse/LastModifiedBy
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelResponse/DefaultAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelResponse/HasTokenKey
  :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSSandboxChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelResponse/CreationDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSSandboxChannelResponse/HasCredential
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.GetCampaignActivitiesRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignActivitiesRequest/CampaignId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignActivitiesRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetCampaignActivitiesRequest/Token :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduChannelRequest/ApiKey :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduChannelRequest/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.BaiduChannelRequest/SecretKey :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetPushTemplateResponse/PushNotificationTemplateResponse
  :cognitect.aws.pinpoint/PushNotificationTemplateResponse)

(s/def :cognitect.aws.pinpoint.InAppMessageHeaderConfig/Alignment :cognitect.aws.pinpoint/Alignment)

(s/def :cognitect.aws.pinpoint.InAppMessageHeaderConfig/Header :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.InAppMessageHeaderConfig/TextColor :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationsDisplayName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationTransformerUri
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationProviderIdType
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationProviderRoleArn
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationProviderUri
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CreateRecommenderConfiguration/Name :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfiguration/Description
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfiguration/Attributes
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.CreateRecommenderConfiguration/RecommendationsPerMessage
  :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.GetChannelsRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.OpenHoursRule/StartTime :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.OpenHoursRule/EndTime :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PutEventsRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.PutEventsRequest/EventsRequest :cognitect.aws.pinpoint/EventsRequest)

(s/def
  :cognitect.aws.pinpoint.CreateJourneyResponse/JourneyResponse
  :cognitect.aws.pinpoint/JourneyResponse)

(s/def :cognitect.aws.pinpoint.VerificationResponse/Valid :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.MethodNotAllowedException/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MethodNotAllowedException/RequestID :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Condition/Conditions :cognitect.aws.pinpoint/ListOfSimpleCondition)

(s/def :cognitect.aws.pinpoint.Condition/Operator :cognitect.aws.pinpoint/Operator)

(s/def :cognitect.aws.pinpoint.QuietTime/End :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.QuietTime/Start :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InAppMessage/Content
  :cognitect.aws.pinpoint/ListOfInAppMessageContent)

(s/def :cognitect.aws.pinpoint.InAppMessage/CustomConfig :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.InAppMessage/Layout :cognitect.aws.pinpoint/Layout)

(s/def :cognitect.aws.pinpoint.TemplateConfiguration/EmailTemplate :cognitect.aws.pinpoint/Template)

(s/def :cognitect.aws.pinpoint.TemplateConfiguration/PushTemplate :cognitect.aws.pinpoint/Template)

(s/def :cognitect.aws.pinpoint.TemplateConfiguration/SMSTemplate :cognitect.aws.pinpoint/Template)

(s/def :cognitect.aws.pinpoint.TemplateConfiguration/VoiceTemplate :cognitect.aws.pinpoint/Template)

(s/def :cognitect.aws.pinpoint.TemplateConfiguration/InAppTemplate :cognitect.aws.pinpoint/Template)

(s/def
  :cognitect.aws.pinpoint.GetVoiceTemplateResponse/VoiceTemplateResponse
  :cognitect.aws.pinpoint/VoiceTemplateResponse)

(s/def
  :cognitect.aws.pinpoint.GetUserEndpointsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetUserEndpointsRequest/UserId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MessageResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.MessageResponse/EndpointResult
  :cognitect.aws.pinpoint/MapOfEndpointMessageResult)

(s/def :cognitect.aws.pinpoint.MessageResponse/RequestId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MessageResponse/Result :cognitect.aws.pinpoint/MapOfMessageResult)

(s/def
  :cognitect.aws.pinpoint.GetCampaignVersionRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignVersionRequest/CampaignId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetCampaignVersionRequest/Version :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ActivitiesResponse/Item
  :cognitect.aws.pinpoint/ListOfActivityResponse)

(s/def :cognitect.aws.pinpoint.ActivitiesResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ListTemplatesRequest/NextToken :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ListTemplatesRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ListTemplatesRequest/Prefix :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ListTemplatesRequest/TemplateType :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateRequest/Body :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.VoiceTemplateRequest/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateRequest/LanguageCode :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateRequest/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.VoiceTemplateRequest/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.VoiceTemplateRequest/VoiceId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignVersionsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetCampaignVersionsRequest/CampaignId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetCampaignVersionsRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetCampaignVersionsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteGcmChannelResponse/GCMChannelResponse
  :cognitect.aws.pinpoint/GCMChannelResponse)

(s/def :cognitect.aws.pinpoint.GPSPointDimension/Coordinates :cognitect.aws.pinpoint/GPSCoordinates)

(s/def :cognitect.aws.pinpoint.GPSPointDimension/RangeInKilometers :cognitect.aws.pinpoint/__double)

(s/def
  :cognitect.aws.pinpoint.BaiduChannelResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/IsArchived :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/Credential :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/LastModifiedBy :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.BaiduChannelResponse/HasCredential :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.DeleteGcmChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/LastEvaluatedTime
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/Metrics
  :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.JourneyRunExecutionMetricsResponse/RunId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateSmsTemplateRequest/SMSTemplateRequest
  :cognitect.aws.pinpoint/SMSTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.CreateSmsTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MessageBody/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.MessageBody/RequestID :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EndpointsResponse/Item
  :cognitect.aws.pinpoint/ListOfEndpointResponse)

(s/def :cognitect.aws.pinpoint.GetAppsRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetAppsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailChannelResponse/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/Identity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/Id :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailChannelResponse/OrchestrationSendingRoleArn
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailChannelResponse/ConfigurationSet
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailChannelResponse/MessagesPerSecond
  :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/IsArchived :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/RoleArn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/Platform :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/FromAddress :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/LastModifiedBy :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/Version :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/CreationDate :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelResponse/HasCredential :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.Session/Duration :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.Session/Id :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Session/StartTimestamp :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Session/StopTimestamp :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateImportJobRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CreateImportJobRequest/ImportJobRequest
  :cognitect.aws.pinpoint/ImportJobRequest)

(s/def
  :cognitect.aws.pinpoint.GetInAppMessagesRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetInAppMessagesRequest/EndpointId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeleteEmailChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateGcmChannelResponse/GCMChannelResponse
  :cognitect.aws.pinpoint/GCMChannelResponse)

(s/def
  :cognitect.aws.pinpoint.RemoveAttributesResponse/AttributesResource
  :cognitect.aws.pinpoint/AttributesResource)

(s/def
  :cognitect.aws.pinpoint.EndpointBatchRequest/Item
  :cognitect.aws.pinpoint/ListOfEndpointBatchItem)

(s/def
  :cognitect.aws.pinpoint.DeleteAppResponse/ApplicationResponse
  :cognitect.aws.pinpoint/ApplicationResponse)

(s/def :cognitect.aws.pinpoint.ExportJobResource/RoleArn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobResource/S3UrlPrefix :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobResource/SegmentId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ExportJobResource/SegmentVersion :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.CreateEmailTemplateResponse/CreateTemplateMessageBody
  :cognitect.aws.pinpoint/CreateTemplateMessageBody)

(s/def
  :cognitect.aws.pinpoint.DeleteSmsChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/TemplateId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/AllowedAttempts
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/BrandName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/Channel
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/ValidityPeriod
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/ReferenceId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/OriginationIdentity
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/EntityId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/CodeLength
  :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/DestinationIdentity
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SendOTPMessageRequestParameters/Language
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ListTagsForResourceResponse/TagsModel
  :cognitect.aws.pinpoint/TagsModel)

(s/def :cognitect.aws.pinpoint.GetAppRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/Badge :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.APNSMessage/RawContent :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSMessage/PreferredAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/Data :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/Title :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/MediaUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/Priority :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/Category :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/Sound :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/Action :cognitect.aws.pinpoint/Action)

(s/def :cognitect.aws.pinpoint.APNSMessage/APNSPushType :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.APNSMessage/Substitutions
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/TimeToLive :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.APNSMessage/SilentPush :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.APNSMessage/CollapseId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.APNSMessage/ThreadId :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/CampaignHook
  :cognitect.aws.pinpoint/CampaignHook)

(s/def
  :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/CloudWatchMetricsEnabled
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/EventTaggingEnabled
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/Limits
  :cognitect.aws.pinpoint/CampaignLimits)

(s/def
  :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/QuietTime
  :cognitect.aws.pinpoint/QuietTime)

(s/def
  :cognitect.aws.pinpoint.WriteApplicationSettingsRequest/JourneyLimits
  :cognitect.aws.pinpoint/ApplicationSettingsJourneyLimits)

(s/def
  :cognitect.aws.pinpoint.DeleteSegmentResponse/SegmentResponse
  :cognitect.aws.pinpoint/SegmentResponse)

(s/def :cognitect.aws.pinpoint.Activity/ContactCenter :cognitect.aws.pinpoint/ContactCenterActivity)

(s/def :cognitect.aws.pinpoint.Activity/CUSTOM :cognitect.aws.pinpoint/CustomMessageActivity)

(s/def :cognitect.aws.pinpoint.Activity/RandomSplit :cognitect.aws.pinpoint/RandomSplitActivity)

(s/def :cognitect.aws.pinpoint.Activity/SMS :cognitect.aws.pinpoint/SMSMessageActivity)

(s/def :cognitect.aws.pinpoint.Activity/PUSH :cognitect.aws.pinpoint/PushMessageActivity)

(s/def :cognitect.aws.pinpoint.Activity/Holdout :cognitect.aws.pinpoint/HoldoutActivity)

(s/def
  :cognitect.aws.pinpoint.Activity/ConditionalSplit
  :cognitect.aws.pinpoint/ConditionalSplitActivity)

(s/def :cognitect.aws.pinpoint.Activity/EMAIL :cognitect.aws.pinpoint/EmailMessageActivity)

(s/def
  :cognitect.aws.pinpoint.Activity/MultiCondition
  :cognitect.aws.pinpoint/MultiConditionalSplitActivity)

(s/def :cognitect.aws.pinpoint.Activity/Description :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.Activity/Wait :cognitect.aws.pinpoint/WaitActivity)

(s/def
  :cognitect.aws.pinpoint.UpdateJourneyStateResponse/JourneyResponse
  :cognitect.aws.pinpoint/JourneyResponse)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionMetricsRequest/RunId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetApnsVoipSandboxChannelResponse/APNSVoipSandboxChannelResponse
  :cognitect.aws.pinpoint/APNSVoipSandboxChannelResponse)

(s/def
  :cognitect.aws.pinpoint.DeleteAdmChannelResponse/ADMChannelResponse
  :cognitect.aws.pinpoint/ADMChannelResponse)

(s/def :cognitect.aws.pinpoint.CampaignInAppMessage/Body :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CampaignInAppMessage/Content
  :cognitect.aws.pinpoint/ListOfInAppMessageContent)

(s/def
  :cognitect.aws.pinpoint.CampaignInAppMessage/CustomConfig
  :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.CampaignInAppMessage/Layout :cognitect.aws.pinpoint/Layout)

(s/def :cognitect.aws.pinpoint.InAppCampaignSchedule/EndDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InAppCampaignSchedule/EventFilter
  :cognitect.aws.pinpoint/CampaignEventFilter)

(s/def :cognitect.aws.pinpoint.InAppCampaignSchedule/QuietTime :cognitect.aws.pinpoint/QuietTime)

(s/def :cognitect.aws.pinpoint.EventsRequest/BatchItem :cognitect.aws.pinpoint/MapOfEventsBatch)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/JourneyActivityId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/PageSize
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GetJourneyRunExecutionActivityMetricsRequest/RunId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsVoipSandboxChannelRequest/APNSVoipSandboxChannelRequest
  :cognitect.aws.pinpoint/APNSVoipSandboxChannelRequest)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsVoipSandboxChannelRequest/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetExportJobsRequest/ApplicationId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetExportJobsRequest/PageSize :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GetExportJobsRequest/Token :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyEmailMessage/FromAddress :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.InAppMessageButton/Android
  :cognitect.aws.pinpoint/OverrideButtonConfiguration)

(s/def
  :cognitect.aws.pinpoint.InAppMessageButton/DefaultConfig
  :cognitect.aws.pinpoint/DefaultButtonConfiguration)

(s/def
  :cognitect.aws.pinpoint.InAppMessageButton/IOS
  :cognitect.aws.pinpoint/OverrideButtonConfiguration)

(s/def
  :cognitect.aws.pinpoint.InAppMessageButton/Web
  :cognitect.aws.pinpoint/OverrideButtonConfiguration)

(s/def :cognitect.aws.pinpoint.SegmentDemographics/AppVersion :cognitect.aws.pinpoint/SetDimension)

(s/def :cognitect.aws.pinpoint.SegmentDemographics/Channel :cognitect.aws.pinpoint/SetDimension)

(s/def :cognitect.aws.pinpoint.SegmentDemographics/DeviceType :cognitect.aws.pinpoint/SetDimension)

(s/def :cognitect.aws.pinpoint.SegmentDemographics/Make :cognitect.aws.pinpoint/SetDimension)

(s/def :cognitect.aws.pinpoint.SegmentDemographics/Model :cognitect.aws.pinpoint/SetDimension)

(s/def :cognitect.aws.pinpoint.SegmentDemographics/Platform :cognitect.aws.pinpoint/SetDimension)

(s/def :cognitect.aws.pinpoint.TooManyRequestsException/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TooManyRequestsException/RequestID :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.StartCondition/Description :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.StartCondition/EventStartCondition
  :cognitect.aws.pinpoint/EventStartCondition)

(s/def
  :cognitect.aws.pinpoint.StartCondition/SegmentStartCondition
  :cognitect.aws.pinpoint/SegmentCondition)

(s/def
  :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/EndTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/JourneyId
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/KpiName :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/KpiResult
  :cognitect.aws.pinpoint/BaseKpiResult)

(s/def
  :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.JourneyDateRangeKpiResponse/StartTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.UpdateApnsVoipChannelResponse/APNSVoipChannelResponse
  :cognitect.aws.pinpoint/APNSVoipChannelResponse)

(s/def
  :cognitect.aws.pinpoint.EndpointUser/UserAttributes
  :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.EndpointUser/UserId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.InAppMessageBodyConfig/Alignment :cognitect.aws.pinpoint/Alignment)

(s/def :cognitect.aws.pinpoint.InAppMessageBodyConfig/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.InAppMessageBodyConfig/TextColor :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ClosedDays/EMAIL :cognitect.aws.pinpoint/ListOfClosedDaysRules)

(s/def :cognitect.aws.pinpoint.ClosedDays/SMS :cognitect.aws.pinpoint/ListOfClosedDaysRules)

(s/def :cognitect.aws.pinpoint.ClosedDays/PUSH :cognitect.aws.pinpoint/ListOfClosedDaysRules)

(s/def :cognitect.aws.pinpoint.ClosedDays/VOICE :cognitect.aws.pinpoint/ListOfClosedDaysRules)

(s/def :cognitect.aws.pinpoint.ClosedDays/CUSTOM :cognitect.aws.pinpoint/ListOfClosedDaysRules)

(s/def
  :cognitect.aws.pinpoint.ChannelsResponse/Channels
  :cognitect.aws.pinpoint/MapOfChannelResponse)

(s/def :cognitect.aws.pinpoint.TreatmentResource/TreatmentName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TreatmentResource/Schedule :cognitect.aws.pinpoint/Schedule)

(s/def :cognitect.aws.pinpoint.TreatmentResource/SizePercent :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.TreatmentResource/Id :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.TreatmentResource/MessageConfiguration
  :cognitect.aws.pinpoint/MessageConfiguration)

(s/def
  :cognitect.aws.pinpoint.TreatmentResource/TreatmentDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.TreatmentResource/State :cognitect.aws.pinpoint/CampaignState)

(s/def
  :cognitect.aws.pinpoint.TreatmentResource/TemplateConfiguration
  :cognitect.aws.pinpoint/TemplateConfiguration)

(s/def
  :cognitect.aws.pinpoint.TreatmentResource/CustomDeliveryConfiguration
  :cognitect.aws.pinpoint/CustomDeliveryConfiguration)

(s/def :cognitect.aws.pinpoint.SMSTemplateRequest/Body :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.SMSTemplateRequest/DefaultSubstitutions
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSTemplateRequest/RecommenderId :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.SMSTemplateRequest/tags :cognitect.aws.pinpoint/MapOf__string)

(s/def
  :cognitect.aws.pinpoint.SMSTemplateRequest/TemplateDescription
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.JourneyTimeframeCap/Cap :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.JourneyTimeframeCap/Days :cognitect.aws.pinpoint/__integer)

(s/def
  :cognitect.aws.pinpoint.DeleteUserEndpointsResponse/EndpointsResponse
  :cognitect.aws.pinpoint/EndpointsResponse)

(s/def :cognitect.aws.pinpoint.CreateTemplateMessageBody/Arn :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CreateTemplateMessageBody/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.CreateTemplateMessageBody/RequestID :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.WriteJourneyRequest/LastModifiedDate
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.WriteJourneyRequest/SendingSchedule
  :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.WriteJourneyRequest/RefreshOnSegmentUpdate
  :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/OpenHours :cognitect.aws.pinpoint/OpenHours)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/Schedule :cognitect.aws.pinpoint/JourneySchedule)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/LocalTime :cognitect.aws.pinpoint/__boolean)

(s/def
  :cognitect.aws.pinpoint.WriteJourneyRequest/WaitForQuietTime
  :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/Limits :cognitect.aws.pinpoint/JourneyLimits)

(s/def
  :cognitect.aws.pinpoint.WriteJourneyRequest/JourneyChannelSettings
  :cognitect.aws.pinpoint/JourneyChannelSettings)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/StartActivity :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.WriteJourneyRequest/TimezoneEstimationMethods
  :cognitect.aws.pinpoint/ListOf__TimezoneEstimationMethodsElement)

(s/def
  :cognitect.aws.pinpoint.WriteJourneyRequest/RefreshFrequency
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/Name :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/State :cognitect.aws.pinpoint/State)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/Activities :cognitect.aws.pinpoint/MapOfActivity)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/QuietTime :cognitect.aws.pinpoint/QuietTime)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/CreationDate :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.WriteJourneyRequest/StartCondition
  :cognitect.aws.pinpoint/StartCondition)

(s/def :cognitect.aws.pinpoint.WriteJourneyRequest/ClosedDays :cognitect.aws.pinpoint/ClosedDays)

(s/def
  :cognitect.aws.pinpoint.GetJourneyExecutionMetricsResponse/JourneyExecutionMetricsResponse
  :cognitect.aws.pinpoint/JourneyExecutionMetricsResponse)

(s/def :cognitect.aws.pinpoint.EventCondition/Dimensions :cognitect.aws.pinpoint/EventDimensions)

(s/def :cognitect.aws.pinpoint.EventCondition/MessageActivity :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.UpdateSmsTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def :cognitect.aws.pinpoint.SegmentsResponse/Item :cognitect.aws.pinpoint/ListOfSegmentResponse)

(s/def :cognitect.aws.pinpoint.SegmentsResponse/NextToken :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CustomDeliveryConfiguration/DeliveryUri
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.CustomDeliveryConfiguration/EndpointTypes
  :cognitect.aws.pinpoint/ListOf__EndpointTypesElement)

(s/def :cognitect.aws.pinpoint.EventsResponse/Results :cognitect.aws.pinpoint/MapOfItemResponse)

(s/def :cognitect.aws.pinpoint.ConflictException/Message :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.ConflictException/RequestID :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailChannelRequest/ConfigurationSet
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelRequest/Enabled :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.EmailChannelRequest/FromAddress :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelRequest/Identity :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.EmailChannelRequest/RoleArn :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.EmailChannelRequest/OrchestrationSendingRoleArn
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/Url :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/IconReference :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/CollapseKey :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/RawContent :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.GCMMessage/PreferredAuthenticationMethod
  :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/ImageUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/Data :cognitect.aws.pinpoint/MapOf__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/Title :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/SmallImageIconUrl :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/Body :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/Priority :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/RestrictedPackageName :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/Sound :cognitect.aws.pinpoint/__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/Action :cognitect.aws.pinpoint/Action)

(s/def :cognitect.aws.pinpoint.GCMMessage/Substitutions :cognitect.aws.pinpoint/MapOfListOf__string)

(s/def :cognitect.aws.pinpoint.GCMMessage/TimeToLive :cognitect.aws.pinpoint/__integer)

(s/def :cognitect.aws.pinpoint.GCMMessage/SilentPush :cognitect.aws.pinpoint/__boolean)

(s/def :cognitect.aws.pinpoint.GCMMessage/ImageIconUrl :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.DeletePushTemplateResponse/MessageBody
  :cognitect.aws.pinpoint/MessageBody)

(s/def
  :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/ApplicationId
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/EndTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/KpiName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/KpiResult
  :cognitect.aws.pinpoint/BaseKpiResult)

(s/def
  :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/NextToken
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ApplicationDateRangeKpiResponse/StartTime
  :cognitect.aws.pinpoint/__timestampIso8601)

(s/def
  :cognitect.aws.pinpoint.CreatePushTemplateRequest/PushNotificationTemplateRequest
  :cognitect.aws.pinpoint/PushNotificationTemplateRequest)

(s/def
  :cognitect.aws.pinpoint.CreatePushTemplateRequest/TemplateName
  :cognitect.aws.pinpoint/__string)

(s/def
  :cognitect.aws.pinpoint.ItemResponse/EndpointItemResponse
  :cognitect.aws.pinpoint/EndpointItemResponse)

(s/def
  :cognitect.aws.pinpoint.ItemResponse/EventsItemResponse
  :cognitect.aws.pinpoint/MapOfEventItemResponse)

