;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.qbusiness.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListPluginActions
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.qbusiness/Url
  (s/spec #(re-matches (re-pattern "(https?|ftp|file)://([^\\s]*)") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ValidationExceptionFields
  (s/coll-of :cognitect.aws.qbusiness/ValidationExceptionField))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListDataSourcesSyncJobs
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.qbusiness/ListDataAccessorsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListDataAccessorsRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListDataAccessorsRequest/maxResults
     :cognitect.aws.qbusiness.ListDataAccessorsRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/ThrottlingException
  (s/keys :req-un [:cognitect.aws.qbusiness.ThrottlingException/message]))

(s/def
  :cognitect.aws.qbusiness/IndexedTextDocument
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def :cognitect.aws.qbusiness/SubnetIds (s/coll-of :cognitect.aws.qbusiness/SubnetId))

(s/def :cognitect.aws.qbusiness/WebExperiences (s/coll-of :cognitect.aws.qbusiness/WebExperience))

(s/def
  :cognitect.aws.qbusiness/DeleteChatResponseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteChatResponseConfigurationRequest/applicationId
     :cognitect.aws.qbusiness.DeleteChatResponseConfigurationRequest/chatResponseConfigurationId]))

(s/def :cognitect.aws.qbusiness/Indices (s/coll-of :cognitect.aws.qbusiness/Index))

(s/def
  :cognitect.aws.qbusiness/WebExperienceStatus
  (s/spec string? :gen #(s/gen #{"PENDING_AUTH_CONFIG" "DELETING" "CREATING" "ACTIVE" "FAILED"})))

(s/def
  :cognitect.aws.qbusiness/DocumentEnrichmentConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentEnrichmentConfiguration/inlineConfigurations
     :cognitect.aws.qbusiness.DocumentEnrichmentConfiguration/postExtractionHookConfiguration
     :cognitect.aws.qbusiness.DocumentEnrichmentConfiguration/preExtractionHookConfiguration]))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListWebExperiencesRequest
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.qbusiness/Principal
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.Principal/group :cognitect.aws.qbusiness.Principal/user]))

(s/def
  :cognitect.aws.qbusiness/ExecutionId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/BasicAuthConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.BasicAuthConfiguration/secretArn
     :cognitect.aws.qbusiness.BasicAuthConfiguration/roleArn]))

(s/def
  :cognitect.aws.qbusiness/CreateDataSourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateDataSourceRequest/applicationId
     :cognitect.aws.qbusiness.CreateDataSourceRequest/indexId
     :cognitect.aws.qbusiness.CreateDataSourceRequest/displayName
     :cognitect.aws.qbusiness.CreateDataSourceRequest/configuration]
    :opt-un
    [:cognitect.aws.qbusiness.CreateDataSourceRequest/clientToken
     :cognitect.aws.qbusiness.CreateDataSourceRequest/vpcConfiguration
     :cognitect.aws.qbusiness.CreateDataSourceRequest/documentEnrichmentConfiguration
     :cognitect.aws.qbusiness.CreateDataSourceRequest/tags
     :cognitect.aws.qbusiness.CreateDataSourceRequest/roleArn
     :cognitect.aws.qbusiness.CreateDataSourceRequest/syncSchedule
     :cognitect.aws.qbusiness.CreateDataSourceRequest/mediaExtractionConfiguration
     :cognitect.aws.qbusiness.CreateDataSourceRequest/description]))

(s/def
  :cognitect.aws.qbusiness/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.TagResourceRequest/resourceARN
     :cognitect.aws.qbusiness.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.qbusiness/SamlAuthenticationUrl
  (s/spec #(re-matches (re-pattern "https://.*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ErrorCode
  (s/spec
    string?
    :gen
    #(s/gen #{"InternalError" "ResourceInactive" "InvalidRequest" "ResourceNotFound"})))

(s/def
  :cognitect.aws.qbusiness/GroupStatus
  (s/spec string? :gen #(s/gen #{"SUCCEEDED" "DELETING" "FAILED" "DELETED" "PROCESSING"})))

(s/def :cognitect.aws.qbusiness/DeleteIndexResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/ServiceQuotaExceededException
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ServiceQuotaExceededException/message
     :cognitect.aws.qbusiness.ServiceQuotaExceededException/resourceId
     :cognitect.aws.qbusiness.ServiceQuotaExceededException/resourceType]))

(s/def
  :cognitect.aws.qbusiness/InternalServerException
  (s/keys :req-un [:cognitect.aws.qbusiness.InternalServerException/message]))

(s/def
  :cognitect.aws.qbusiness/ContentRetrievalRule
  (s/keys :opt-un [:cognitect.aws.qbusiness.ContentRetrievalRule/eligibleDataSources]))

(s/def
  :cognitect.aws.qbusiness/Documents
  (s/coll-of :cognitect.aws.qbusiness/Document :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.qbusiness/ExampleChatMessages
  (s/coll-of :cognitect.aws.qbusiness/ExampleChatMessage :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.qbusiness/ActionPayloadFieldNameSeparator
  (s/spec
    (s/and string? #(<= 1 (count %) 1))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/ListPluginTypeActionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListPluginTypeActionsRequest/pluginType]
    :opt-un
    [:cognitect.aws.qbusiness.ListPluginTypeActionsRequest/maxResults
     :cognitect.aws.qbusiness.ListPluginTypeActionsRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/DocumentEnrichmentConditionOperator
  (s/spec
    string?
    :gen
    #(s/gen
      #{"NOT_EQUALS"
        "GREATER_THAN"
        "CONTAINS"
        "EXISTS"
        "LESS_THAN"
        "NOT_EXISTS"
        "NOT_CONTAINS"
        "BEGINS_WITH"
        "LESS_THAN_OR_EQUALS"
        "EQUALS"
        "GREATER_THAN_OR_EQUALS"})))

(s/def
  :cognitect.aws.qbusiness/GetChatResponseConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/createdAt
     :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/chatResponseConfigurationId
     :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/displayName
     :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/inUseConfiguration
     :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/chatResponseConfigurationArn
     :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/lastUpdateConfiguration]))

(s/def
  :cognitect.aws.qbusiness/ListConversationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListConversationsResponse/nextToken
     :cognitect.aws.qbusiness.ListConversationsResponse/conversations]))

(s/def
  :cognitect.aws.qbusiness/AccessControl
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.AccessControl/principals]
    :opt-un
    [:cognitect.aws.qbusiness.AccessControl/memberRelation]))

(s/def
  :cognitect.aws.qbusiness/MembershipType
  (s/spec string? :gen #(s/gen #{"INDEX" "DATASOURCE"})))

(s/def
  :cognitect.aws.qbusiness/EligibleDataSources
  (s/coll-of :cognitect.aws.qbusiness/EligibleDataSource :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.qbusiness/FailedAttachmentEvent
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.FailedAttachmentEvent/systemMessageId
     :cognitect.aws.qbusiness.FailedAttachmentEvent/conversationId
     :cognitect.aws.qbusiness.FailedAttachmentEvent/attachment
     :cognitect.aws.qbusiness.FailedAttachmentEvent/userMessageId]))

(s/def
  :cognitect.aws.qbusiness/ValidationExceptionField
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ValidationExceptionField/name
     :cognitect.aws.qbusiness.ValidationExceptionField/message]))

(s/def
  :cognitect.aws.qbusiness/MessageUsefulnessComment
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/AttachmentInput
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.AttachmentInput/copyFrom
     :cognitect.aws.qbusiness.AttachmentInput/name
     :cognitect.aws.qbusiness.AttachmentInput/data]))

(s/def :cognitect.aws.qbusiness/Actions (s/coll-of :cognitect.aws.qbusiness/ActionSummary))

(s/def
  :cognitect.aws.qbusiness/DeleteAttachmentRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteAttachmentRequest/applicationId
     :cognitect.aws.qbusiness.DeleteAttachmentRequest/conversationId
     :cognitect.aws.qbusiness.DeleteAttachmentRequest/attachmentId]
    :opt-un
    [:cognitect.aws.qbusiness.DeleteAttachmentRequest/userId]))

(s/def
  :cognitect.aws.qbusiness/Rules
  (s/coll-of :cognitect.aws.qbusiness/Rule :min-count 0 :max-count 10))

(s/def :cognitect.aws.qbusiness/ActionReviewPayloadFieldArrayItemJsonSchema (s/keys))

(s/def
  :cognitect.aws.qbusiness/AudioExtractionType
  (s/spec string? :gen #(s/gen #{"TRANSCRIPT" "SUMMARY"})))

(s/def
  :cognitect.aws.qbusiness/DocumentAclGroups
  (s/coll-of :cognitect.aws.qbusiness/DocumentAclGroup))

(s/def :cognitect.aws.qbusiness/CreateUserResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/ImageExtractionStatus
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/ListGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListGroupsResponse/nextToken
     :cognitect.aws.qbusiness.ListGroupsResponse/items]))

(s/def
  :cognitect.aws.qbusiness/AuthChallengeResponseEvent
  (s/keys :req-un [:cognitect.aws.qbusiness.AuthChallengeResponseEvent/responseMap]))

(s/def
  :cognitect.aws.qbusiness/AttributeType
  (s/spec string? :gen #(s/gen #{"STRING_LIST" "NUMBER" "DATE" "STRING"})))

(s/def
  :cognitect.aws.qbusiness/ListIndicesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListIndicesResponse/nextToken
     :cognitect.aws.qbusiness.ListIndicesResponse/indices]))

(s/def
  :cognitect.aws.qbusiness/ListChatResponseConfigurationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListChatResponseConfigurationsResponse/nextToken
     :cognitect.aws.qbusiness.ListChatResponseConfigurationsResponse/chatResponseConfigurations]))

(s/def
  :cognitect.aws.qbusiness/Tag
  (s/keys :req-un [:cognitect.aws.qbusiness.Tag/key :cognitect.aws.qbusiness.Tag/value]))

(s/def
  :cognitect.aws.qbusiness/GroupMembers
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GroupMembers/memberUsers
     :cognitect.aws.qbusiness.GroupMembers/memberGroups
     :cognitect.aws.qbusiness.GroupMembers/s3PathForGroupMembers]))

(s/def :cognitect.aws.qbusiness/DeleteAttachmentResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/ActionExecution
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ActionExecution/pluginId
     :cognitect.aws.qbusiness.ActionExecution/payload
     :cognitect.aws.qbusiness.ActionExecution/payloadFieldNameSeparator]))

(s/def
  :cognitect.aws.qbusiness/Rule
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.Rule/ruleType]
    :opt-un
    [:cognitect.aws.qbusiness.Rule/includedUsersAndGroups
     :cognitect.aws.qbusiness.Rule/ruleConfiguration
     :cognitect.aws.qbusiness.Rule/excludedUsersAndGroups]))

(s/def :cognitect.aws.qbusiness/OutputFormat (s/spec string? :gen #(s/gen #{"RAW" "EXTRACTED"})))

(s/def
  :cognitect.aws.qbusiness/EligibleDataSource
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.EligibleDataSource/dataSourceId
     :cognitect.aws.qbusiness.EligibleDataSource/indexId]))

(s/def
  :cognitect.aws.qbusiness/ErrorDetail
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ErrorDetail/errorMessage
     :cognitect.aws.qbusiness.ErrorDetail/errorCode]))

(s/def
  :cognitect.aws.qbusiness/SyncSchedule
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def :cognitect.aws.qbusiness/AttributeValueOperator (s/spec string? :gen #(s/gen #{"DELETE"})))

(s/def
  :cognitect.aws.qbusiness/CreatePluginResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CreatePluginResponse/pluginArn
     :cognitect.aws.qbusiness.CreatePluginResponse/pluginId
     :cognitect.aws.qbusiness.CreatePluginResponse/buildStatus]))

(s/def
  :cognitect.aws.qbusiness/AssociatedGroups
  (s/coll-of :cognitect.aws.qbusiness/AssociatedGroup))

(s/def
  :cognitect.aws.qbusiness/GetChatResponseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetChatResponseConfigurationRequest/applicationId
     :cognitect.aws.qbusiness.GetChatResponseConfigurationRequest/chatResponseConfigurationId]))

(s/def
  :cognitect.aws.qbusiness/InlineDocumentEnrichmentConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.InlineDocumentEnrichmentConfiguration/condition
     :cognitect.aws.qbusiness.InlineDocumentEnrichmentConfiguration/documentContentOperator
     :cognitect.aws.qbusiness.InlineDocumentEnrichmentConfiguration/target]))

(s/def
  :cognitect.aws.qbusiness/ListAttachmentsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListAttachmentsResponse/nextToken
     :cognitect.aws.qbusiness.ListAttachmentsResponse/attachments]))

(s/def :cognitect.aws.qbusiness/DocumentContentOperator (s/spec string? :gen #(s/gen #{"DELETE"})))

(s/def
  :cognitect.aws.qbusiness/Instruction
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def :cognitect.aws.qbusiness/DeleteGroupResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/CreateRetrieverRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateRetrieverRequest/applicationId
     :cognitect.aws.qbusiness.CreateRetrieverRequest/type
     :cognitect.aws.qbusiness.CreateRetrieverRequest/displayName
     :cognitect.aws.qbusiness.CreateRetrieverRequest/configuration]
    :opt-un
    [:cognitect.aws.qbusiness.CreateRetrieverRequest/clientToken
     :cognitect.aws.qbusiness.CreateRetrieverRequest/tags
     :cognitect.aws.qbusiness.CreateRetrieverRequest/roleArn]))

(s/def
  :cognitect.aws.qbusiness/SubscriptionId
  (s/spec
    (s/and string? #(<= 0 (count %) 1224))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1224) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/StopDataSourceSyncJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.StopDataSourceSyncJobRequest/dataSourceId
     :cognitect.aws.qbusiness.StopDataSourceSyncJobRequest/applicationId
     :cognitect.aws.qbusiness.StopDataSourceSyncJobRequest/indexId]))

(s/def
  :cognitect.aws.qbusiness/SystemMessageType
  (s/spec string? :gen #(s/gen #{"GROUNDED_RESPONSE" "RESPONSE"})))

(s/def
  :cognitect.aws.qbusiness/StatementId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9_-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/DeleteGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteGroupRequest/applicationId
     :cognitect.aws.qbusiness.DeleteGroupRequest/indexId
     :cognitect.aws.qbusiness.DeleteGroupRequest/groupName]
    :opt-un
    [:cognitect.aws.qbusiness.DeleteGroupRequest/dataSourceId]))

(s/def
  :cognitect.aws.qbusiness/PermissionCondition
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.PermissionCondition/conditionOperator
     :cognitect.aws.qbusiness.PermissionCondition/conditionKey
     :cognitect.aws.qbusiness.PermissionCondition/conditionValues]))

(s/def
  :cognitect.aws.qbusiness/DataSourceName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/BlockedPhrasesConfigurationUpdate
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.BlockedPhrasesConfigurationUpdate/blockedPhrasesToCreateOrUpdate
     :cognitect.aws.qbusiness.BlockedPhrasesConfigurationUpdate/blockedPhrasesToDelete
     :cognitect.aws.qbusiness.BlockedPhrasesConfigurationUpdate/systemMessageOverride]))

(s/def
  :cognitect.aws.qbusiness/DocumentAclUsers
  (s/coll-of :cognitect.aws.qbusiness/DocumentAclUser))

(s/def
  :cognitect.aws.qbusiness/IndexedTextBytes
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def :cognitect.aws.qbusiness/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/AttachmentsInput
  (s/coll-of :cognitect.aws.qbusiness/AttachmentInput :min-count 1))

(s/def
  :cognitect.aws.qbusiness/IndexCapacityInteger
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.qbusiness/QuickSightConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.QuickSightConfiguration/clientNamespace]))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListDataAccessors
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def :cognitect.aws.qbusiness/UpdateDataAccessorResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/DocumentDetailList
  (s/coll-of :cognitect.aws.qbusiness/DocumentDetails))

(s/def
  :cognitect.aws.qbusiness/DeleteWebExperienceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteWebExperienceRequest/applicationId
     :cognitect.aws.qbusiness.DeleteWebExperienceRequest/webExperienceId]))

(s/def
  :cognitect.aws.qbusiness/ActionSummary
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ActionSummary/actionIdentifier
     :cognitect.aws.qbusiness.ActionSummary/displayName
     :cognitect.aws.qbusiness.ActionSummary/instructionExample
     :cognitect.aws.qbusiness.ActionSummary/description]))

(s/def
  :cognitect.aws.qbusiness/TextDocumentStatistics
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.TextDocumentStatistics/indexedTextBytes
     :cognitect.aws.qbusiness.TextDocumentStatistics/indexedTextDocumentCount]))

(s/def
  :cognitect.aws.qbusiness/TextOutputEvent
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.TextOutputEvent/systemMessageId
     :cognitect.aws.qbusiness.TextOutputEvent/conversationId
     :cognitect.aws.qbusiness.TextOutputEvent/systemMessageType
     :cognitect.aws.qbusiness.TextOutputEvent/userMessageId
     :cognitect.aws.qbusiness.TextOutputEvent/systemMessage]))

(s/def
  :cognitect.aws.qbusiness/GetWebExperienceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetWebExperienceRequest/applicationId
     :cognitect.aws.qbusiness.GetWebExperienceRequest/webExperienceId]))

(s/def
  :cognitect.aws.qbusiness/SessionDurationInMinutes
  (s/spec (s/and int? #(<= 15 % 60)) :gen #(gen/choose 15 60)))

(s/def :cognitect.aws.qbusiness/UserMessage string?)

(s/def
  :cognitect.aws.qbusiness/RetrieverName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeCondition
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DocumentAttributeCondition/key
     :cognitect.aws.qbusiness.DocumentAttributeCondition/operator]
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAttributeCondition/value]))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListSubscriptions
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.qbusiness/AuthResponseKey
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/CancelSubscriptionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CancelSubscriptionResponse/currentSubscription
     :cognitect.aws.qbusiness.CancelSubscriptionResponse/nextSubscription
     :cognitect.aws.qbusiness.CancelSubscriptionResponse/subscriptionArn]))

(s/def :cognitect.aws.qbusiness/DeleteChatControlsConfigurationResponse (s/keys))

(s/def :cognitect.aws.qbusiness/Principals (s/coll-of :cognitect.aws.qbusiness/Principal))

(s/def
  :cognitect.aws.qbusiness/MetadataEvent
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.MetadataEvent/systemMessageId
     :cognitect.aws.qbusiness.MetadataEvent/conversationId
     :cognitect.aws.qbusiness.MetadataEvent/userMessageId
     :cognitect.aws.qbusiness.MetadataEvent/finalTextMessage
     :cognitect.aws.qbusiness.MetadataEvent/sourceAttributions]))

(s/def
  :cognitect.aws.qbusiness/DataAccessorExternalId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/AccessConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.AccessConfiguration/accessControls]
    :opt-un
    [:cognitect.aws.qbusiness.AccessConfiguration/memberRelation]))

(s/def
  :cognitect.aws.qbusiness/CreateChatResponseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/applicationId
     :cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/displayName
     :cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/responseConfigurations]
    :opt-un
    [:cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/clientToken
     :cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/tags]))

(s/def
  :cognitect.aws.qbusiness/HookConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.HookConfiguration/invocationCondition
     :cognitect.aws.qbusiness.HookConfiguration/roleArn
     :cognitect.aws.qbusiness.HookConfiguration/lambdaArn
     :cognitect.aws.qbusiness.HookConfiguration/s3BucketName]))

(s/def
  :cognitect.aws.qbusiness/UsersAndGroups
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.UsersAndGroups/userIds
     :cognitect.aws.qbusiness.UsersAndGroups/userGroups]))

(s/def
  :cognitect.aws.qbusiness/Message
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.Message/body
     :cognitect.aws.qbusiness.Message/actionReview
     :cognitect.aws.qbusiness.Message/time
     :cognitect.aws.qbusiness.Message/messageId
     :cognitect.aws.qbusiness.Message/type
     :cognitect.aws.qbusiness.Message/actionExecution
     :cognitect.aws.qbusiness.Message/attachments
     :cognitect.aws.qbusiness.Message/sourceAttribution]))

(s/def
  :cognitect.aws.qbusiness/ActionReviewEvent
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ActionReviewEvent/systemMessageId
     :cognitect.aws.qbusiness.ActionReviewEvent/pluginType
     :cognitect.aws.qbusiness.ActionReviewEvent/payloadFieldNameSeparator
     :cognitect.aws.qbusiness.ActionReviewEvent/conversationId
     :cognitect.aws.qbusiness.ActionReviewEvent/pluginId
     :cognitect.aws.qbusiness.ActionReviewEvent/userMessageId
     :cognitect.aws.qbusiness.ActionReviewEvent/payload]))

(s/def
  :cognitect.aws.qbusiness/PrincipalUser
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.PrincipalUser/access]
    :opt-un
    [:cognitect.aws.qbusiness.PrincipalUser/id
     :cognitect.aws.qbusiness.PrincipalUser/membershipType]))

(s/def
  :cognitect.aws.qbusiness/GroupSummary
  (s/keys :opt-un [:cognitect.aws.qbusiness.GroupSummary/groupName]))

(s/def
  :cognitect.aws.qbusiness/DataSourceSyncJob
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DataSourceSyncJob/executionId
     :cognitect.aws.qbusiness.DataSourceSyncJob/error
     :cognitect.aws.qbusiness.DataSourceSyncJob/startTime
     :cognitect.aws.qbusiness.DataSourceSyncJob/status
     :cognitect.aws.qbusiness.DataSourceSyncJob/endTime
     :cognitect.aws.qbusiness.DataSourceSyncJob/dataSourceErrorCode
     :cognitect.aws.qbusiness.DataSourceSyncJob/metrics]))

(s/def
  :cognitect.aws.qbusiness/CustomizationConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CustomizationConfiguration/fontUrl
     :cognitect.aws.qbusiness.CustomizationConfiguration/faviconUrl
     :cognitect.aws.qbusiness.CustomizationConfiguration/logoUrl
     :cognitect.aws.qbusiness.CustomizationConfiguration/customCSSUrl]))

(s/def
  :cognitect.aws.qbusiness/SourceAttribution
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.SourceAttribution/updatedAt
     :cognitect.aws.qbusiness.SourceAttribution/citationNumber
     :cognitect.aws.qbusiness.SourceAttribution/documentId
     :cognitect.aws.qbusiness.SourceAttribution/url
     :cognitect.aws.qbusiness.SourceAttribution/snippet
     :cognitect.aws.qbusiness.SourceAttribution/datasourceId
     :cognitect.aws.qbusiness.SourceAttribution/textMessageSegments
     :cognitect.aws.qbusiness.SourceAttribution/title
     :cognitect.aws.qbusiness.SourceAttribution/indexId]))

(s/def
  :cognitect.aws.qbusiness/CheckDocumentAccessResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CheckDocumentAccessResponse/documentAcl
     :cognitect.aws.qbusiness.CheckDocumentAccessResponse/hasAccess
     :cognitect.aws.qbusiness.CheckDocumentAccessResponse/userGroups
     :cognitect.aws.qbusiness.CheckDocumentAccessResponse/userAliases]))

(s/def
  :cognitect.aws.qbusiness/BrowserExtensionList
  (s/coll-of :cognitect.aws.qbusiness/BrowserExtension :min-count 0 :max-count 2))

(s/def
  :cognitect.aws.qbusiness/GetRetrieverResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetRetrieverResponse/applicationId
     :cognitect.aws.qbusiness.GetRetrieverResponse/updatedAt
     :cognitect.aws.qbusiness.GetRetrieverResponse/createdAt
     :cognitect.aws.qbusiness.GetRetrieverResponse/retrieverId
     :cognitect.aws.qbusiness.GetRetrieverResponse/displayName
     :cognitect.aws.qbusiness.GetRetrieverResponse/retrieverArn
     :cognitect.aws.qbusiness.GetRetrieverResponse/roleArn
     :cognitect.aws.qbusiness.GetRetrieverResponse/configuration
     :cognitect.aws.qbusiness.GetRetrieverResponse/status
     :cognitect.aws.qbusiness.GetRetrieverResponse/type]))

(s/def
  :cognitect.aws.qbusiness/InstanceArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:(aws|aws-us-gov|aws-cn|aws-iso|aws-iso-b):sso:::instance/(sso)?ins-[a-zA-Z0-9-.]{16}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/DocumentAclCondition
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAclCondition/users
     :cognitect.aws.qbusiness.DocumentAclCondition/memberRelation
     :cognitect.aws.qbusiness.DocumentAclCondition/groups]))

(s/def
  :cognitect.aws.qbusiness/GetUserResponse
  (s/keys :opt-un [:cognitect.aws.qbusiness.GetUserResponse/userAliases]))

(s/def
  :cognitect.aws.qbusiness/DataAccessorAuthenticationType
  (s/spec string? :gen #(s/gen #{"AWS_IAM_IDC_AUTH_CODE" "AWS_IAM_IDC_TTI"})))

(s/def
  :cognitect.aws.qbusiness/SourceAttributionMediaId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/PrincipalRoleArn
  (s/spec
    #(re-matches (re-pattern "arn:aws:iam::[0-9]{12}:role/[a-zA-Z0-9_/+=,.@-]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListAttachments
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.qbusiness/StringAttributeBoostingConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.StringAttributeBoostingConfiguration/boostingLevel]
    :opt-un
    [:cognitect.aws.qbusiness.StringAttributeBoostingConfiguration/attributeValueBoosting]))

(s/def
  :cognitect.aws.qbusiness/ValidationException
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ValidationException/message
     :cognitect.aws.qbusiness.ValidationException/reason]
    :opt-un
    [:cognitect.aws.qbusiness.ValidationException/fields]))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeValueStringValueString
  (s/spec
    (s/and string? #(<= 0 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/RetrieverArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ListPluginTypeMetadataRequest
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListPluginTypeMetadataRequest/maxResults
     :cognitect.aws.qbusiness.ListPluginTypeMetadataRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/GetMediaResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetMediaResponse/mediaBytes
     :cognitect.aws.qbusiness.GetMediaResponse/mediaMimeType]))

(s/def
  :cognitect.aws.qbusiness/AccessDeniedException
  (s/keys :req-un [:cognitect.aws.qbusiness.AccessDeniedException/message]))

(s/def
  :cognitect.aws.qbusiness/ErrorMessage
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/SamlConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.SamlConfiguration/metadataXML
     :cognitect.aws.qbusiness.SamlConfiguration/roleArn
     :cognitect.aws.qbusiness.SamlConfiguration/userIdAttribute]
    :opt-un
    [:cognitect.aws.qbusiness.SamlConfiguration/userGroupAttribute]))

(s/def
  :cognitect.aws.qbusiness/GetIndexResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetIndexResponse/applicationId
     :cognitect.aws.qbusiness.GetIndexResponse/indexArn
     :cognitect.aws.qbusiness.GetIndexResponse/updatedAt
     :cognitect.aws.qbusiness.GetIndexResponse/createdAt
     :cognitect.aws.qbusiness.GetIndexResponse/capacityConfiguration
     :cognitect.aws.qbusiness.GetIndexResponse/displayName
     :cognitect.aws.qbusiness.GetIndexResponse/error
     :cognitect.aws.qbusiness.GetIndexResponse/status
     :cognitect.aws.qbusiness.GetIndexResponse/type
     :cognitect.aws.qbusiness.GetIndexResponse/indexStatistics
     :cognitect.aws.qbusiness.GetIndexResponse/indexId
     :cognitect.aws.qbusiness.GetIndexResponse/description
     :cognitect.aws.qbusiness.GetIndexResponse/documentAttributeConfigurations]))

(s/def :cognitect.aws.qbusiness/UpdateRetrieverResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/CreateWebExperienceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateWebExperienceRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.CreateWebExperienceRequest/browserExtensionConfiguration
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/identityProviderConfiguration
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/clientToken
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/samplePromptsControlMode
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/welcomeMessage
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/tags
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/roleArn
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/customizationConfiguration
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/subtitle
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/title
     :cognitect.aws.qbusiness.CreateWebExperienceRequest/origins]))

(s/def
  :cognitect.aws.qbusiness/ValidationExceptionReason
  (s/spec string? :gen #(s/gen #{"FIELD_VALIDATION_FAILED" "CANNOT_PARSE" "UNKNOWN_OPERATION"})))

(s/def
  :cognitect.aws.qbusiness/DataSourceSyncJobs
  (s/coll-of :cognitect.aws.qbusiness/DataSourceSyncJob))

(s/def :cognitect.aws.qbusiness/DeletePluginResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/AttachmentInputEvent
  (s/keys :opt-un [:cognitect.aws.qbusiness.AttachmentInputEvent/attachment]))

(s/def :cognitect.aws.qbusiness/UpdateChatControlsConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/GetIndexRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetIndexRequest/applicationId
     :cognitect.aws.qbusiness.GetIndexRequest/indexId]))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeBoostingLevel
  (s/spec string? :gen #(s/gen #{"LOW" "VERY_HIGH" "NONE" "HIGH" "TWO" "ONE" "MEDIUM"})))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListPluginTypeActions
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.qbusiness/PermissionConditionKey
  (s/spec
    #(re-matches (re-pattern "aws:PrincipalTag/qbusiness-dataaccessor:[a-zA-Z]+.*") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/CreateApplicationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CreateApplicationResponse/applicationId
     :cognitect.aws.qbusiness.CreateApplicationResponse/applicationArn]))

(s/def
  :cognitect.aws.qbusiness/DocumentStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"INDEXED"
        "RECEIVED"
        "DELETING"
        "FAILED"
        "DELETED"
        "DOCUMENT_FAILED_TO_INDEX"
        "PROCESSING"
        "UPDATED"})))

(s/def
  :cognitect.aws.qbusiness/WebExperienceArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.qbusiness/UpdateChatResponseConfigurationResponse (s/keys))

(s/def :cognitect.aws.qbusiness/DataSources (s/coll-of :cognitect.aws.qbusiness/DataSource))

(s/def
  :cognitect.aws.qbusiness/ContentSource
  (s/keys :opt-un [:cognitect.aws.qbusiness.ContentSource/retriever]))

(s/def
  :cognitect.aws.qbusiness/ListApplicationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListApplicationsResponse/applications
     :cognitect.aws.qbusiness.ListApplicationsResponse/nextToken]))

(s/def :cognitect.aws.qbusiness/Messages (s/coll-of :cognitect.aws.qbusiness/Message))

(s/def :cognitect.aws.qbusiness/UserAliases (s/coll-of :cognitect.aws.qbusiness/UserAlias))

(s/def
  :cognitect.aws.qbusiness/UserAlias
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UserAlias/userId]
    :opt-un
    [:cognitect.aws.qbusiness.UserAlias/dataSourceId :cognitect.aws.qbusiness.UserAlias/indexId]))

(s/def :cognitect.aws.qbusiness/UpdateApplicationResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/AttachmentName
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/AttributeFilter
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.AttributeFilter/orAllFilters
     :cognitect.aws.qbusiness.AttributeFilter/greaterThan
     :cognitect.aws.qbusiness.AttributeFilter/notFilter
     :cognitect.aws.qbusiness.AttributeFilter/containsAny
     :cognitect.aws.qbusiness.AttributeFilter/lessThanOrEquals
     :cognitect.aws.qbusiness.AttributeFilter/andAllFilters
     :cognitect.aws.qbusiness.AttributeFilter/lessThan
     :cognitect.aws.qbusiness.AttributeFilter/greaterThanOrEquals
     :cognitect.aws.qbusiness.AttributeFilter/equalsTo
     :cognitect.aws.qbusiness.AttributeFilter/containsAll]))

(s/def
  :cognitect.aws.qbusiness/ListPluginTypeMetadataResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListPluginTypeMetadataResponse/nextToken
     :cognitect.aws.qbusiness.ListPluginTypeMetadataResponse/items]))

(s/def
  :cognitect.aws.qbusiness/Tags
  (s/coll-of :cognitect.aws.qbusiness/Tag :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.qbusiness/WebExperience
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.WebExperience/updatedAt
     :cognitect.aws.qbusiness.WebExperience/createdAt
     :cognitect.aws.qbusiness.WebExperience/status
     :cognitect.aws.qbusiness.WebExperience/webExperienceId
     :cognitect.aws.qbusiness.WebExperience/defaultEndpoint]))

(s/def
  :cognitect.aws.qbusiness/ResponseScope
  (s/spec string? :gen #(s/gen #{"EXTENDED_KNOWLEDGE_ENABLED" "ENTERPRISE_CONTENT_ONLY"})))

(s/def :cognitect.aws.qbusiness/EndOfInputEvent (s/keys))

(s/def
  :cognitect.aws.qbusiness/AudioExtractionStatus
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/ActionExecutionPayload
  (s/map-of
    :cognitect.aws.qbusiness/ActionPayloadFieldKey
    :cognitect.aws.qbusiness/ActionExecutionPayloadField))

(s/def
  :cognitect.aws.qbusiness/UserIdentifier
  (s/spec
    #(re-matches
      (re-pattern
        "([0-9a-f]{10}-|)[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.qbusiness/UpdateIndexResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/ListPluginsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListPluginsResponse/nextToken
     :cognitect.aws.qbusiness.ListPluginsResponse/plugins]))

(s/def
  :cognitect.aws.qbusiness/BlockedPhrase
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/PluginConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.PluginConfiguration/pluginId]))

(s/def
  :cognitect.aws.qbusiness/WebExperienceOrigins
  (s/coll-of :cognitect.aws.qbusiness/Origin :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.qbusiness/CreateSubscriptionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CreateSubscriptionResponse/currentSubscription
     :cognitect.aws.qbusiness.CreateSubscriptionResponse/nextSubscription
     :cognitect.aws.qbusiness.CreateSubscriptionResponse/subscriptionId
     :cognitect.aws.qbusiness.CreateSubscriptionResponse/subscriptionArn]))

(s/def
  :cognitect.aws.qbusiness/BrowserExtensionConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.BrowserExtensionConfiguration/enabledBrowserExtensions]))

(s/def
  :cognitect.aws.qbusiness/DeleteConversationRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteConversationRequest/conversationId
     :cognitect.aws.qbusiness.DeleteConversationRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.DeleteConversationRequest/userId]))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListMessages
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.qbusiness/ActionConfigurationList
  (s/coll-of :cognitect.aws.qbusiness/ActionConfiguration :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.qbusiness/BoostingDurationInSeconds
  (s/spec (s/and int? #(<= 0 % 999999999)) :gen #(gen/choose 0 999999999)))

(s/def :cognitect.aws.qbusiness/DeleteApplicationResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/PrincipalGroup
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.PrincipalGroup/access]
    :opt-un
    [:cognitect.aws.qbusiness.PrincipalGroup/name
     :cognitect.aws.qbusiness.PrincipalGroup/membershipType]))

(s/def
  :cognitect.aws.qbusiness/DocumentAclMembership
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAclMembership/memberRelation
     :cognitect.aws.qbusiness.DocumentAclMembership/conditions]))

(s/def
  :cognitect.aws.qbusiness/AudioExtractionConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.AudioExtractionConfiguration/audioExtractionStatus]))

(s/def :cognitect.aws.qbusiness/MemberRelation (s/spec string? :gen #(s/gen #{"AND" "OR"})))

(s/def :cognitect.aws.qbusiness/QueryText string?)

(s/def
  :cognitect.aws.qbusiness/SourceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.SourceDetails/videoSourceDetails
     :cognitect.aws.qbusiness.SourceDetails/audioSourceDetails
     :cognitect.aws.qbusiness.SourceDetails/imageSourceDetails]))

(s/def
  :cognitect.aws.qbusiness/UpdateSubscriptionRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateSubscriptionRequest/applicationId
     :cognitect.aws.qbusiness.UpdateSubscriptionRequest/subscriptionId
     :cognitect.aws.qbusiness.UpdateSubscriptionRequest/type]))

(s/def
  :cognitect.aws.qbusiness/RelevantContentList
  (s/coll-of :cognitect.aws.qbusiness/RelevantContent))

(s/def
  :cognitect.aws.qbusiness/ResponseConfigurations
  (s/map-of
    :cognitect.aws.qbusiness/ResponseConfigurationType
    :cognitect.aws.qbusiness/ResponseConfiguration
    :min-count
    1
    :max-count
    1))

(s/def
  :cognitect.aws.qbusiness/IndexArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.qbusiness/DeleteDataSourceResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/TextInputEvent
  (s/keys :req-un [:cognitect.aws.qbusiness.TextInputEvent/userMessage]))

(s/def
  :cognitect.aws.qbusiness/ListAttachmentsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListAttachmentsRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListAttachmentsRequest/conversationId
     :cognitect.aws.qbusiness.ListAttachmentsRequest/maxResults
     :cognitect.aws.qbusiness.ListAttachmentsRequest/nextToken
     :cognitect.aws.qbusiness.ListAttachmentsRequest/userId]))

(s/def
  :cognitect.aws.qbusiness/Title
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/PluginType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CUSTOM"
        "SMARTSHEET"
        "PAGERDUTY_ADVANCE"
        "SALESFORCE_CRM"
        "MICROSOFT_EXCHANGE"
        "JIRA_CLOUD"
        "GOOGLE_CALENDAR"
        "SERVICE_NOW"
        "MICROSOFT_TEAMS"
        "ATLASSIAN_CONFLUENCE"
        "QUICKSIGHT"
        "ASANA"
        "SALESFORCE"
        "ZENDESK"
        "SERVICENOW_NOW_PLATFORM"
        "JIRA"
        "ZENDESK_SUITE"})))

(s/def
  :cognitect.aws.qbusiness/DocumentDetails
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentDetails/updatedAt
     :cognitect.aws.qbusiness.DocumentDetails/documentId
     :cognitect.aws.qbusiness.DocumentDetails/createdAt
     :cognitect.aws.qbusiness.DocumentDetails/error
     :cognitect.aws.qbusiness.DocumentDetails/status]))

(s/def
  :cognitect.aws.qbusiness/SystemMessageOverride
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/AssociatedUser
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.AssociatedUser/id :cognitect.aws.qbusiness.AssociatedUser/type]))

(s/def :cognitect.aws.qbusiness/Applications (s/coll-of :cognitect.aws.qbusiness/Application))

(s/def
  :cognitect.aws.qbusiness/BlockedPhrasesConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.BlockedPhrasesConfiguration/systemMessageOverride
     :cognitect.aws.qbusiness.BlockedPhrasesConfiguration/blockedPhrases]))

(s/def
  :cognitect.aws.qbusiness/AttachmentsControlMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/Index
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.Index/updatedAt
     :cognitect.aws.qbusiness.Index/createdAt
     :cognitect.aws.qbusiness.Index/displayName
     :cognitect.aws.qbusiness.Index/status
     :cognitect.aws.qbusiness.Index/indexId]))

(s/def
  :cognitect.aws.qbusiness/LambdaArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:aws[a-zA-Z-]*:lambda:[a-z-]*-[0-9]:[0-9]{12}:function:[a-zA-Z0-9-_]+(/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})?(:[a-zA-Z0-9-_]+)?")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/Origin
  (s/spec
    #(re-matches (re-pattern "(http://|https://)[a-zA-Z0-9-_.]+(?::[0-9]{1,5})?") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/StringAttributeValueBoosting
  (s/map-of
    :cognitect.aws.qbusiness/String
    :cognitect.aws.qbusiness/StringAttributeValueBoostingLevel
    :min-count
    1
    :max-count
    10))

(s/def
  :cognitect.aws.qbusiness/ChatOutputStream
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ChatOutputStream/authChallengeRequestEvent
     :cognitect.aws.qbusiness.ChatOutputStream/metadataEvent
     :cognitect.aws.qbusiness.ChatOutputStream/failedAttachmentEvent
     :cognitect.aws.qbusiness.ChatOutputStream/textEvent
     :cognitect.aws.qbusiness.ChatOutputStream/actionReviewEvent]))

(s/def
  :cognitect.aws.qbusiness/MetricValue
  (s/spec #(re-matches (re-pattern "(([1-9][0-9]*)|0)") %) :gen #(gen/string)))

(s/def :cognitect.aws.qbusiness/Boolean boolean?)

(s/def
  :cognitect.aws.qbusiness/SamlMetadataXML
  (s/spec #(re-matches (re-pattern ".*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ActionPayloadFieldType
  (s/spec string? :gen #(s/gen #{"NUMBER" "ARRAY" "STRING" "BOOLEAN"})))

(s/def
  :cognitect.aws.qbusiness/GetRetrieverRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetRetrieverRequest/applicationId
     :cognitect.aws.qbusiness.GetRetrieverRequest/retrieverId]))

(s/def
  :cognitect.aws.qbusiness/CreateDataAccessorRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateDataAccessorRequest/applicationId
     :cognitect.aws.qbusiness.CreateDataAccessorRequest/principal
     :cognitect.aws.qbusiness.CreateDataAccessorRequest/actionConfigurations
     :cognitect.aws.qbusiness.CreateDataAccessorRequest/displayName]
    :opt-un
    [:cognitect.aws.qbusiness.CreateDataAccessorRequest/clientToken
     :cognitect.aws.qbusiness.CreateDataAccessorRequest/tags
     :cognitect.aws.qbusiness.CreateDataAccessorRequest/authenticationDetail]))

(s/def
  :cognitect.aws.qbusiness/UpdatePluginRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdatePluginRequest/applicationId
     :cognitect.aws.qbusiness.UpdatePluginRequest/pluginId]
    :opt-un
    [:cognitect.aws.qbusiness.UpdatePluginRequest/displayName
     :cognitect.aws.qbusiness.UpdatePluginRequest/authConfiguration
     :cognitect.aws.qbusiness.UpdatePluginRequest/customPluginConfiguration
     :cognitect.aws.qbusiness.UpdatePluginRequest/state
     :cognitect.aws.qbusiness.UpdatePluginRequest/serverUrl]))

(s/def
  :cognitect.aws.qbusiness/ListConversationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListConversationsRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListConversationsRequest/maxResults
     :cognitect.aws.qbusiness.ListConversationsRequest/nextToken
     :cognitect.aws.qbusiness.ListConversationsRequest/userId]))

(s/def
  :cognitect.aws.qbusiness/ChatMode
  (s/spec string? :gen #(s/gen #{"RETRIEVAL_MODE" "PLUGIN_MODE" "CREATOR_MODE"})))

(s/def :cognitect.aws.qbusiness/MemberUsers (s/coll-of :cognitect.aws.qbusiness/MemberUser))

(s/def
  :cognitect.aws.qbusiness/TextSegment
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.TextSegment/beginOffset
     :cognitect.aws.qbusiness.TextSegment/sourceDetails
     :cognitect.aws.qbusiness.TextSegment/snippetExcerpt
     :cognitect.aws.qbusiness.TextSegment/endOffset
     :cognitect.aws.qbusiness.TextSegment/mediaMimeType
     :cognitect.aws.qbusiness.TextSegment/mediaId]))

(s/def
  :cognitect.aws.qbusiness/ClientIdForOIDC
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9_.:/()*?=-]*") %) :gen #(gen/string)))

(s/def :cognitect.aws.qbusiness/SnippetExcerptText string?)

(s/def :cognitect.aws.qbusiness/UserGroups (s/coll-of :cognitect.aws.qbusiness/String))

(s/def
  :cognitect.aws.qbusiness/AuthChallengeRequest
  (s/keys :req-un [:cognitect.aws.qbusiness.AuthChallengeRequest/authorizationUrl]))

(s/def :cognitect.aws.qbusiness/GroupSummaryList (s/coll-of :cognitect.aws.qbusiness/GroupSummary))

(s/def
  :cognitect.aws.qbusiness/TopicConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.TopicConfiguration/name
     :cognitect.aws.qbusiness.TopicConfiguration/rules]
    :opt-un
    [:cognitect.aws.qbusiness.TopicConfiguration/exampleChatMessages
     :cognitect.aws.qbusiness.TopicConfiguration/description]))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListPlugins
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.qbusiness/QAppsControlMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/ResponseConfigurationSummary
  (s/spec
    (s/and string? #(<= 1 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.qbusiness/APISchemaType (s/spec string? :gen #(s/gen #{"OPEN_API_V3"})))

(s/def
  :cognitect.aws.qbusiness/AmazonResourceName
  (s/spec
    (s/and string? #(<= 1 (count %) 1011))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1011) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/VideoExtractionType
  (s/spec string? :gen #(s/gen #{"TRANSCRIPT" "SUMMARY"})))

(s/def
  :cognitect.aws.qbusiness/ListPluginsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListPluginsRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListPluginsRequest/maxResults
     :cognitect.aws.qbusiness.ListPluginsRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/ClientIdsForOIDC
  (s/coll-of :cognitect.aws.qbusiness/ClientIdForOIDC))

(s/def
  :cognitect.aws.qbusiness/CopyFromSource
  (s/keys :opt-un [:cognitect.aws.qbusiness.CopyFromSource/conversation]))

(s/def
  :cognitect.aws.qbusiness/SubscriptionDetails
  (s/keys :opt-un [:cognitect.aws.qbusiness.SubscriptionDetails/type]))

(s/def
  :cognitect.aws.qbusiness/UpdateIndexRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateIndexRequest/applicationId
     :cognitect.aws.qbusiness.UpdateIndexRequest/indexId]
    :opt-un
    [:cognitect.aws.qbusiness.UpdateIndexRequest/capacityConfiguration
     :cognitect.aws.qbusiness.UpdateIndexRequest/displayName
     :cognitect.aws.qbusiness.UpdateIndexRequest/description
     :cognitect.aws.qbusiness.UpdateIndexRequest/documentAttributeConfigurations]))

(s/def
  :cognitect.aws.qbusiness/GetDocumentContentRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetDocumentContentRequest/applicationId
     :cognitect.aws.qbusiness.GetDocumentContentRequest/indexId
     :cognitect.aws.qbusiness.GetDocumentContentRequest/documentId]
    :opt-un
    [:cognitect.aws.qbusiness.GetDocumentContentRequest/dataSourceId
     :cognitect.aws.qbusiness.GetDocumentContentRequest/outputFormat]))

(s/def
  :cognitect.aws.qbusiness/ScoreAttributes
  (s/keys :opt-un [:cognitect.aws.qbusiness.ScoreAttributes/scoreConfidence]))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeConfigurations
  (s/coll-of :cognitect.aws.qbusiness/DocumentAttributeConfiguration :min-count 1 :max-count 500))

(s/def
  :cognitect.aws.qbusiness/HallucinationReductionConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.HallucinationReductionConfiguration/hallucinationReductionControl]))

(s/def
  :cognitect.aws.qbusiness/BatchPutDocumentResponse
  (s/keys :opt-un [:cognitect.aws.qbusiness.BatchPutDocumentResponse/failedDocuments]))

(s/def
  :cognitect.aws.qbusiness/ChatInput
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ChatInput/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ChatInput/parentMessageId
     :cognitect.aws.qbusiness.ChatInput/clientToken
     :cognitect.aws.qbusiness.ChatInput/conversationId
     :cognitect.aws.qbusiness.ChatInput/userId
     :cognitect.aws.qbusiness.ChatInput/userGroups
     :cognitect.aws.qbusiness.ChatInput/inputStream]))

(s/def
  :cognitect.aws.qbusiness/StringListAttributeBoostingConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.StringListAttributeBoostingConfiguration/boostingLevel]))

(s/def :cognitect.aws.qbusiness/DeleteWebExperienceResponse (s/keys))

(s/def :cognitect.aws.qbusiness/Payload string?)

(s/def
  :cognitect.aws.qbusiness/MessageId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/CreateChatResponseConfigurationResponse
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateChatResponseConfigurationResponse/chatResponseConfigurationId
     :cognitect.aws.qbusiness.CreateChatResponseConfigurationResponse/chatResponseConfigurationArn]))

(s/def
  :cognitect.aws.qbusiness/NextToken
  (s/spec
    (s/and string? #(<= 1 (count %) 800))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 800) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/MediaId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/DocumentAclUser
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAclUser/id :cognitect.aws.qbusiness.DocumentAclUser/type]))

(s/def
  :cognitect.aws.qbusiness/CheckDocumentAccessRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CheckDocumentAccessRequest/applicationId
     :cognitect.aws.qbusiness.CheckDocumentAccessRequest/indexId
     :cognitect.aws.qbusiness.CheckDocumentAccessRequest/userId
     :cognitect.aws.qbusiness.CheckDocumentAccessRequest/documentId]
    :opt-un
    [:cognitect.aws.qbusiness.CheckDocumentAccessRequest/dataSourceId]))

(s/def
  :cognitect.aws.qbusiness/UpdateChatResponseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/applicationId
     :cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/chatResponseConfigurationId
     :cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/responseConfigurations]
    :opt-un
    [:cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/clientToken
     :cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/displayName]))

(s/def
  :cognitect.aws.qbusiness/GetWebExperienceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetWebExperienceResponse/applicationId
     :cognitect.aws.qbusiness.GetWebExperienceResponse/browserExtensionConfiguration
     :cognitect.aws.qbusiness.GetWebExperienceResponse/updatedAt
     :cognitect.aws.qbusiness.GetWebExperienceResponse/identityProviderConfiguration
     :cognitect.aws.qbusiness.GetWebExperienceResponse/samplePromptsControlMode
     :cognitect.aws.qbusiness.GetWebExperienceResponse/createdAt
     :cognitect.aws.qbusiness.GetWebExperienceResponse/welcomeMessage
     :cognitect.aws.qbusiness.GetWebExperienceResponse/roleArn
     :cognitect.aws.qbusiness.GetWebExperienceResponse/error
     :cognitect.aws.qbusiness.GetWebExperienceResponse/customizationConfiguration
     :cognitect.aws.qbusiness.GetWebExperienceResponse/status
     :cognitect.aws.qbusiness.GetWebExperienceResponse/webExperienceId
     :cognitect.aws.qbusiness.GetWebExperienceResponse/subtitle
     :cognitect.aws.qbusiness.GetWebExperienceResponse/title
     :cognitect.aws.qbusiness.GetWebExperienceResponse/origins
     :cognitect.aws.qbusiness.GetWebExperienceResponse/authenticationConfiguration
     :cognitect.aws.qbusiness.GetWebExperienceResponse/webExperienceArn
     :cognitect.aws.qbusiness.GetWebExperienceResponse/defaultEndpoint]))

(s/def
  :cognitect.aws.qbusiness/RetrieverType
  (s/spec string? :gen #(s/gen #{"KENDRA_INDEX" "NATIVE_INDEX"})))

(s/def :cognitect.aws.qbusiness/UpdateDataSourceResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/ContentBlockerRule
  (s/keys :opt-un [:cognitect.aws.qbusiness.ContentBlockerRule/systemMessageOverride]))

(s/def
  :cognitect.aws.qbusiness/GetApplicationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetApplicationResponse/identityType
     :cognitect.aws.qbusiness.GetApplicationResponse/applicationId
     :cognitect.aws.qbusiness.GetApplicationResponse/autoSubscriptionConfiguration
     :cognitect.aws.qbusiness.GetApplicationResponse/updatedAt
     :cognitect.aws.qbusiness.GetApplicationResponse/clientIdsForOIDC
     :cognitect.aws.qbusiness.GetApplicationResponse/qAppsConfiguration
     :cognitect.aws.qbusiness.GetApplicationResponse/quickSightConfiguration
     :cognitect.aws.qbusiness.GetApplicationResponse/personalizationConfiguration
     :cognitect.aws.qbusiness.GetApplicationResponse/createdAt
     :cognitect.aws.qbusiness.GetApplicationResponse/displayName
     :cognitect.aws.qbusiness.GetApplicationResponse/roleArn
     :cognitect.aws.qbusiness.GetApplicationResponse/error
     :cognitect.aws.qbusiness.GetApplicationResponse/encryptionConfiguration
     :cognitect.aws.qbusiness.GetApplicationResponse/status
     :cognitect.aws.qbusiness.GetApplicationResponse/iamIdentityProviderArn
     :cognitect.aws.qbusiness.GetApplicationResponse/attachmentsConfiguration
     :cognitect.aws.qbusiness.GetApplicationResponse/identityCenterApplicationArn
     :cognitect.aws.qbusiness.GetApplicationResponse/description
     :cognitect.aws.qbusiness.GetApplicationResponse/applicationArn]))

(s/def
  :cognitect.aws.qbusiness/SubscriptionPrincipal
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.SubscriptionPrincipal/group
     :cognitect.aws.qbusiness.SubscriptionPrincipal/user]))

(s/def :cognitect.aws.qbusiness/NoAuthConfiguration (s/keys))

(s/def
  :cognitect.aws.qbusiness/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.qbusiness/CreatePluginRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreatePluginRequest/applicationId
     :cognitect.aws.qbusiness.CreatePluginRequest/displayName
     :cognitect.aws.qbusiness.CreatePluginRequest/type
     :cognitect.aws.qbusiness.CreatePluginRequest/authConfiguration]
    :opt-un
    [:cognitect.aws.qbusiness.CreatePluginRequest/clientToken
     :cognitect.aws.qbusiness.CreatePluginRequest/tags
     :cognitect.aws.qbusiness.CreatePluginRequest/customPluginConfiguration
     :cognitect.aws.qbusiness.CreatePluginRequest/serverUrl]))

(s/def
  :cognitect.aws.qbusiness/IdentityType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AWS_IAM_IDP_SAML" "AWS_IAM_IDP_OIDC" "ANONYMOUS" "AWS_QUICKSIGHT_IDP" "AWS_IAM_IDC"})))

(s/def
  :cognitect.aws.qbusiness/ListPluginTypeActionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListPluginTypeActionsResponse/nextToken
     :cognitect.aws.qbusiness.ListPluginTypeActionsResponse/items]))

(s/def
  :cognitect.aws.qbusiness/ListMessagesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListMessagesResponse/nextToken
     :cognitect.aws.qbusiness.ListMessagesResponse/messages]))

(s/def
  :cognitect.aws.qbusiness/ListDocumentsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListDocumentsRequest/applicationId
     :cognitect.aws.qbusiness.ListDocumentsRequest/indexId]
    :opt-un
    [:cognitect.aws.qbusiness.ListDocumentsRequest/maxResults
     :cognitect.aws.qbusiness.ListDocumentsRequest/nextToken
     :cognitect.aws.qbusiness.ListDocumentsRequest/dataSourceIds]))

(s/def
  :cognitect.aws.qbusiness/OpenIDConnectProviderConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.OpenIDConnectProviderConfiguration/secretsArn
     :cognitect.aws.qbusiness.OpenIDConnectProviderConfiguration/secretsRole]))

(s/def
  :cognitect.aws.qbusiness/IdcApplicationArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:(aws|aws-us-gov|aws-cn|aws-iso|aws-iso-b):sso::\\d{12}:application/(sso)?ins-[a-zA-Z0-9-.]{16}/apl-[a-zA-Z0-9]{16}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/SystemMessageId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/FailedDocument
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.FailedDocument/dataSourceId
     :cognitect.aws.qbusiness.FailedDocument/error
     :cognitect.aws.qbusiness.FailedDocument/id]))

(s/def
  :cognitect.aws.qbusiness/MemberGroup
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.MemberGroup/groupName]
    :opt-un
    [:cognitect.aws.qbusiness.MemberGroup/type]))

(s/def
  :cognitect.aws.qbusiness/CreatorModeControl
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/GroupStatusDetail
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GroupStatusDetail/errorDetail
     :cognitect.aws.qbusiness.GroupStatusDetail/status
     :cognitect.aws.qbusiness.GroupStatusDetail/lastUpdatedAt]))

(s/def
  :cognitect.aws.qbusiness/GetDataAccessorRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetDataAccessorRequest/applicationId
     :cognitect.aws.qbusiness.GetDataAccessorRequest/dataAccessorId]))

(s/def
  :cognitect.aws.qbusiness/WebExperienceWelcomeMessage
  (s/spec
    (s/and string? #(<= 0 (count %) 300))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 300) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/ImageSourceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ImageSourceDetails/mediaMimeType
     :cognitect.aws.qbusiness.ImageSourceDetails/mediaId]))

(s/def :cognitect.aws.qbusiness/DataAccessors (s/coll-of :cognitect.aws.qbusiness/DataAccessor))

(s/def
  :cognitect.aws.qbusiness/ChatResponseConfigurations
  (s/coll-of :cognitect.aws.qbusiness/ChatResponseConfiguration))

(s/def
  :cognitect.aws.qbusiness/ApplicationArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/StringAttributeValueBoostingLevel
  (s/spec
    string?
    :gen
    #(s/gen #{"FOUR" "FIVE" "LOW" "VERY_HIGH" "HIGH" "THREE" "TWO" "ONE" "MEDIUM"})))

(s/def
  :cognitect.aws.qbusiness/DocumentAcl
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAcl/denyList :cognitect.aws.qbusiness.DocumentAcl/allowlist]))

(s/def :cognitect.aws.qbusiness/BlockedPhrases (s/coll-of :cognitect.aws.qbusiness/BlockedPhrase))

(s/def :cognitect.aws.qbusiness/DeleteDataAccessorResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/CustomCSSUrl
  (s/spec #(re-matches (re-pattern "(https?://[a-zA-Z0-9-_.+%/]+\\.css)?") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ActionReview
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ActionReview/pluginType
     :cognitect.aws.qbusiness.ActionReview/payloadFieldNameSeparator
     :cognitect.aws.qbusiness.ActionReview/pluginId
     :cognitect.aws.qbusiness.ActionReview/payload]))

(s/def
  :cognitect.aws.qbusiness/DocumentContent
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentContent/blob :cognitect.aws.qbusiness.DocumentContent/s3]))

(s/def
  :cognitect.aws.qbusiness/CreateDataAccessorResponse
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateDataAccessorResponse/dataAccessorId
     :cognitect.aws.qbusiness.CreateDataAccessorResponse/idcApplicationArn
     :cognitect.aws.qbusiness.CreateDataAccessorResponse/dataAccessorArn]))

(s/def
  :cognitect.aws.qbusiness/ListDataSourcesRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListDataSourcesRequest/applicationId
     :cognitect.aws.qbusiness.ListDataSourcesRequest/indexId]
    :opt-un
    [:cognitect.aws.qbusiness.ListDataSourcesRequest/maxResults
     :cognitect.aws.qbusiness.ListDataSourcesRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/Subscription
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.Subscription/principal
     :cognitect.aws.qbusiness.Subscription/currentSubscription
     :cognitect.aws.qbusiness.Subscription/nextSubscription
     :cognitect.aws.qbusiness.Subscription/subscriptionId
     :cognitect.aws.qbusiness.Subscription/subscriptionArn]))

(s/def
  :cognitect.aws.qbusiness/SearchRelevantContentResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.SearchRelevantContentResponse/nextToken
     :cognitect.aws.qbusiness.SearchRelevantContentResponse/relevantContent]))

(s/def
  :cognitect.aws.qbusiness/SnippetExcerpt
  (s/keys :opt-un [:cognitect.aws.qbusiness.SnippetExcerpt/text]))

(s/def
  :cognitect.aws.qbusiness/GetGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetGroupResponse/status
     :cognitect.aws.qbusiness.GetGroupResponse/statusHistory]))

(s/def
  :cognitect.aws.qbusiness/AttachmentsConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.AttachmentsConfiguration/attachmentsControlMode]))

(s/def
  :cognitect.aws.qbusiness/QAppsConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.QAppsConfiguration/qAppsControlMode]))

(s/def
  :cognitect.aws.qbusiness/ChatSyncInput
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ChatSyncInput/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ChatSyncInput/parentMessageId
     :cognitect.aws.qbusiness.ChatSyncInput/clientToken
     :cognitect.aws.qbusiness.ChatSyncInput/attributeFilter
     :cognitect.aws.qbusiness.ChatSyncInput/conversationId
     :cognitect.aws.qbusiness.ChatSyncInput/userId
     :cognitect.aws.qbusiness.ChatSyncInput/userGroups
     :cognitect.aws.qbusiness.ChatSyncInput/chatModeConfiguration
     :cognitect.aws.qbusiness.ChatSyncInput/userMessage
     :cognitect.aws.qbusiness.ChatSyncInput/actionExecution
     :cognitect.aws.qbusiness.ChatSyncInput/chatMode
     :cognitect.aws.qbusiness.ChatSyncInput/attachments
     :cognitect.aws.qbusiness.ChatSyncInput/authChallengeResponse]))

(s/def
  :cognitect.aws.qbusiness/PluginBuildStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DELETE_IN_PROGRESS"
        "UPDATE_IN_PROGRESS"
        "CREATE_FAILED"
        "READY"
        "CREATE_IN_PROGRESS"
        "DELETE_FAILED"
        "UPDATE_FAILED"})))

(s/def
  :cognitect.aws.qbusiness/PermissionConditionValues
  (s/coll-of :cognitect.aws.qbusiness/PermissionConditionValue :min-count 1 :max-count 1))

(s/def
  :cognitect.aws.qbusiness/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.qbusiness.ListTagsForResourceRequest/resourceARN]))

(s/def
  :cognitect.aws.qbusiness/StartDataSourceSyncJobResponse
  (s/keys :opt-un [:cognitect.aws.qbusiness.StartDataSourceSyncJobResponse/executionId]))

(s/def
  :cognitect.aws.qbusiness/ClientNamespace
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9._-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/NextToken1500
  (s/spec
    (s/and string? #(<= 1 (count %) 1500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/DeleteDataSourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteDataSourceRequest/applicationId
     :cognitect.aws.qbusiness.DeleteDataSourceRequest/indexId
     :cognitect.aws.qbusiness.DeleteDataSourceRequest/dataSourceId]))

(s/def
  :cognitect.aws.qbusiness/AttachmentsOutput
  (s/coll-of :cognitect.aws.qbusiness/AttachmentOutput))

(s/def
  :cognitect.aws.qbusiness/WebExperienceAuthConfiguration
  (s/keys :opt-un [:cognitect.aws.qbusiness.WebExperienceAuthConfiguration/samlConfiguration]))

(s/def
  :cognitect.aws.qbusiness/ApplicationName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/UserId
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ListWebExperiencesRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListWebExperiencesRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListWebExperiencesRequest/maxResults
     :cognitect.aws.qbusiness.ListWebExperiencesRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/QIamAction
  (s/spec #(re-matches (re-pattern "qbusiness:[a-zA-Z]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/DisplayName
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/SubscriptionType
  (s/spec string? :gen #(s/gen #{"Q_LITE" "Q_BUSINESS"})))

(s/def
  :cognitect.aws.qbusiness/UpdateChatControlsConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/orchestrationConfiguration
     :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/clientToken
     :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/blockedPhrasesConfigurationUpdate
     :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/creatorModeConfiguration
     :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/hallucinationReductionConfiguration
     :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/topicConfigurationsToDelete
     :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/topicConfigurationsToCreateOrUpdate
     :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/responseScope]))

(s/def :cognitect.aws.qbusiness/Plugins (s/coll-of :cognitect.aws.qbusiness/Plugin))

(s/def :cognitect.aws.qbusiness/DeleteChatResponseConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/RoleArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/RetrieverId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/MemberUser
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.MemberUser/userId]
    :opt-un
    [:cognitect.aws.qbusiness.MemberUser/type]))

(s/def :cognitect.aws.qbusiness/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/ListSubscriptionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListSubscriptionsRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListSubscriptionsRequest/maxResults
     :cognitect.aws.qbusiness.ListSubscriptionsRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/TopicConfigurationName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{0,35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/FaviconUrl
  (s/spec
    #(re-matches (re-pattern "(https?://[a-zA-Z0-9-_.+%/]+\\.(svg|ico))?") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/SecurityGroupId
  (s/spec #(re-matches (re-pattern "[-0-9a-zA-Z]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ListDataSourceSyncJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/dataSourceId
     :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/applicationId
     :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/indexId]
    :opt-un
    [:cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/statusFilter
     :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/maxResults
     :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/nextToken
     :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/startTime
     :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/endTime]))

(s/def
  :cognitect.aws.qbusiness/GetChatControlsConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/orchestrationConfiguration
     :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/nextToken
     :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/creatorModeConfiguration
     :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/hallucinationReductionConfiguration
     :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/responseScope
     :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/topicConfigurations
     :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/blockedPhrases]))

(s/def
  :cognitect.aws.qbusiness/CustomPluginConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CustomPluginConfiguration/description
     :cognitect.aws.qbusiness.CustomPluginConfiguration/apiSchemaType]
    :opt-un
    [:cognitect.aws.qbusiness.CustomPluginConfiguration/apiSchema]))

(s/def
  :cognitect.aws.qbusiness/WebExperienceSamplePromptsControlMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/ListGroupsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListGroupsRequest/applicationId
     :cognitect.aws.qbusiness.ListGroupsRequest/indexId
     :cognitect.aws.qbusiness.ListGroupsRequest/updatedEarlierThan]
    :opt-un
    [:cognitect.aws.qbusiness.ListGroupsRequest/dataSourceId
     :cognitect.aws.qbusiness.ListGroupsRequest/maxResults
     :cognitect.aws.qbusiness.ListGroupsRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/PersonalizationControlMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/ListDataSourceSyncJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListDataSourceSyncJobsResponse/nextToken
     :cognitect.aws.qbusiness.ListDataSourceSyncJobsResponse/history]))

(s/def
  :cognitect.aws.qbusiness/DeleteUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteUserRequest/applicationId
     :cognitect.aws.qbusiness.DeleteUserRequest/userId]))

(s/def
  :cognitect.aws.qbusiness/ChatModeConfiguration
  (s/keys :opt-un [:cognitect.aws.qbusiness.ChatModeConfiguration/pluginConfiguration]))

(s/def
  :cognitect.aws.qbusiness/StartDataSourceSyncJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.StartDataSourceSyncJobRequest/dataSourceId
     :cognitect.aws.qbusiness.StartDataSourceSyncJobRequest/applicationId
     :cognitect.aws.qbusiness.StartDataSourceSyncJobRequest/indexId]))

(s/def
  :cognitect.aws.qbusiness/DataAccessorExternalIds
  (s/coll-of :cognitect.aws.qbusiness/DataAccessorExternalId :min-count 1 :max-count 1))

(s/def
  :cognitect.aws.qbusiness/UpdateSubscriptionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.UpdateSubscriptionResponse/currentSubscription
     :cognitect.aws.qbusiness.UpdateSubscriptionResponse/nextSubscription
     :cognitect.aws.qbusiness.UpdateSubscriptionResponse/subscriptionArn]))

(s/def
  :cognitect.aws.qbusiness/TopicDescription
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/DataSourceSyncJobMetrics
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsFailed
     :cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsModified
     :cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsAdded
     :cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsDeleted
     :cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsScanned]))

(s/def
  :cognitect.aws.qbusiness/ListPluginTypeMetadataSummaries
  (s/coll-of :cognitect.aws.qbusiness/PluginTypeMetadataSummary))

(s/def
  :cognitect.aws.qbusiness/CreateAnonymousWebExperienceUrlRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateAnonymousWebExperienceUrlRequest/applicationId
     :cognitect.aws.qbusiness.CreateAnonymousWebExperienceUrlRequest/webExperienceId]
    :opt-un
    [:cognitect.aws.qbusiness.CreateAnonymousWebExperienceUrlRequest/sessionDurationInMinutes]))

(s/def
  :cognitect.aws.qbusiness/SubnetId
  (s/spec #(re-matches (re-pattern "[-0-9a-zA-Z]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/PluginDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/CreateUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateUserRequest/applicationId
     :cognitect.aws.qbusiness.CreateUserRequest/userId]
    :opt-un
    [:cognitect.aws.qbusiness.CreateUserRequest/clientToken
     :cognitect.aws.qbusiness.CreateUserRequest/userAliases]))

(s/def
  :cognitect.aws.qbusiness/DisassociatePermissionRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DisassociatePermissionRequest/applicationId
     :cognitect.aws.qbusiness.DisassociatePermissionRequest/statementId]))

(s/def
  :cognitect.aws.qbusiness/AuthChallengeRequestEvent
  (s/keys :req-un [:cognitect.aws.qbusiness.AuthChallengeRequestEvent/authorizationUrl]))

(s/def
  :cognitect.aws.qbusiness/KmsKeyId
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/ActionExecutionPayloadField
  (s/keys :req-un [:cognitect.aws.qbusiness.ActionExecutionPayloadField/value]))

(s/def
  :cognitect.aws.qbusiness/VideoExtractionStatus
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeBoostingOverrideMap
  (s/map-of
    :cognitect.aws.qbusiness/DocumentAttributeKey
    :cognitect.aws.qbusiness/DocumentAttributeBoostingConfiguration
    :min-count
    1))

(s/def
  :cognitect.aws.qbusiness/GetDocumentContentResponse
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetDocumentContentResponse/presignedUrl
     :cognitect.aws.qbusiness.GetDocumentContentResponse/mimeType]))

(s/def
  :cognitect.aws.qbusiness/UpdateApplicationRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateApplicationRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.UpdateApplicationRequest/autoSubscriptionConfiguration
     :cognitect.aws.qbusiness.UpdateApplicationRequest/qAppsConfiguration
     :cognitect.aws.qbusiness.UpdateApplicationRequest/personalizationConfiguration
     :cognitect.aws.qbusiness.UpdateApplicationRequest/displayName
     :cognitect.aws.qbusiness.UpdateApplicationRequest/roleArn
     :cognitect.aws.qbusiness.UpdateApplicationRequest/identityCenterInstanceArn
     :cognitect.aws.qbusiness.UpdateApplicationRequest/attachmentsConfiguration
     :cognitect.aws.qbusiness.UpdateApplicationRequest/description]))

(s/def
  :cognitect.aws.qbusiness/DocumentAclConditions
  (s/coll-of :cognitect.aws.qbusiness/DocumentAclCondition))

(s/def
  :cognitect.aws.qbusiness/GroupStatusDetails
  (s/coll-of :cognitect.aws.qbusiness/GroupStatusDetail))

(s/def
  :cognitect.aws.qbusiness/KendraIndexConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.KendraIndexConfiguration/indexId]))

(s/def :cognitect.aws.qbusiness/DeleteUserResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/ActionPayloadFieldKey
  (s/spec
    (s/and string? #(<= 1 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/ActionReviewPayload
  (s/map-of
    :cognitect.aws.qbusiness/ActionPayloadFieldKey
    :cognitect.aws.qbusiness/ActionReviewPayloadField))

(s/def
  :cognitect.aws.qbusiness/UpdateUserResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.UpdateUserResponse/userAliasesAdded
     :cognitect.aws.qbusiness.UpdateUserResponse/userAliasesDeleted
     :cognitect.aws.qbusiness.UpdateUserResponse/userAliasesUpdated]))

(s/def
  :cognitect.aws.qbusiness/ConversationId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListPluginTypeMetadata
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.qbusiness/CreateApplicationRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateApplicationRequest/displayName]
    :opt-un
    [:cognitect.aws.qbusiness.CreateApplicationRequest/identityType
     :cognitect.aws.qbusiness.CreateApplicationRequest/clientIdsForOIDC
     :cognitect.aws.qbusiness.CreateApplicationRequest/qAppsConfiguration
     :cognitect.aws.qbusiness.CreateApplicationRequest/quickSightConfiguration
     :cognitect.aws.qbusiness.CreateApplicationRequest/personalizationConfiguration
     :cognitect.aws.qbusiness.CreateApplicationRequest/clientToken
     :cognitect.aws.qbusiness.CreateApplicationRequest/tags
     :cognitect.aws.qbusiness.CreateApplicationRequest/roleArn
     :cognitect.aws.qbusiness.CreateApplicationRequest/encryptionConfiguration
     :cognitect.aws.qbusiness.CreateApplicationRequest/iamIdentityProviderArn
     :cognitect.aws.qbusiness.CreateApplicationRequest/identityCenterInstanceArn
     :cognitect.aws.qbusiness.CreateApplicationRequest/attachmentsConfiguration
     :cognitect.aws.qbusiness.CreateApplicationRequest/description]))

(s/def
  :cognitect.aws.qbusiness/PermissionConditions
  (s/coll-of :cognitect.aws.qbusiness/PermissionCondition :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.qbusiness/AttachmentStatus
  (s/spec string? :gen #(s/gen #{"SUCCESS" "FAILED"})))

(s/def
  :cognitect.aws.qbusiness/DataAccessor
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DataAccessor/principal
     :cognitect.aws.qbusiness.DataAccessor/updatedAt
     :cognitect.aws.qbusiness.DataAccessor/createdAt
     :cognitect.aws.qbusiness.DataAccessor/displayName
     :cognitect.aws.qbusiness.DataAccessor/dataAccessorArn
     :cognitect.aws.qbusiness.DataAccessor/dataAccessorId
     :cognitect.aws.qbusiness.DataAccessor/idcApplicationArn
     :cognitect.aws.qbusiness.DataAccessor/authenticationDetail]))

(s/def
  :cognitect.aws.qbusiness/CreateAnonymousWebExperienceUrlResponse
  (s/keys :opt-un [:cognitect.aws.qbusiness.CreateAnonymousWebExperienceUrlResponse/anonymousUrl]))

(s/def
  :cognitect.aws.qbusiness/ListWebExperiencesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListWebExperiencesResponse/nextToken
     :cognitect.aws.qbusiness.ListWebExperiencesResponse/webExperiences]))

(s/def
  :cognitect.aws.qbusiness/AssociatePermissionResponse
  (s/keys :opt-un [:cognitect.aws.qbusiness.AssociatePermissionResponse/statement]))

(s/def
  :cognitect.aws.qbusiness/CreateRetrieverResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CreateRetrieverResponse/retrieverId
     :cognitect.aws.qbusiness.CreateRetrieverResponse/retrieverArn]))

(s/def
  :cognitect.aws.qbusiness/ActionConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ActionConfiguration/action]
    :opt-un
    [:cognitect.aws.qbusiness.ActionConfiguration/filterConfiguration]))

(s/def
  :cognitect.aws.qbusiness/PermissionConditionOperator
  (s/spec string? :gen #(s/gen #{"StringEquals"})))

(s/def
  :cognitect.aws.qbusiness/CreateIndexRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateIndexRequest/applicationId
     :cognitect.aws.qbusiness.CreateIndexRequest/displayName]
    :opt-un
    [:cognitect.aws.qbusiness.CreateIndexRequest/clientToken
     :cognitect.aws.qbusiness.CreateIndexRequest/capacityConfiguration
     :cognitect.aws.qbusiness.CreateIndexRequest/tags
     :cognitect.aws.qbusiness.CreateIndexRequest/type
     :cognitect.aws.qbusiness.CreateIndexRequest/description]))

(s/def
  :cognitect.aws.qbusiness/ChatResponseConfigurationStatus
  (s/spec string? :gen #(s/gen #{"UPDATING" "CREATING" "ACTIVE" "FAILED"})))

(s/def :cognitect.aws.qbusiness/AccessControls (s/coll-of :cognitect.aws.qbusiness/AccessControl))

(s/def
  :cognitect.aws.qbusiness/AuthChallengeResponse
  (s/keys :req-un [:cognitect.aws.qbusiness.AuthChallengeResponse/responseMap]))

(s/def
  :cognitect.aws.qbusiness/DataSourceSyncJobStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"INCOMPLETE" "SYNCING_INDEXING" "SUCCEEDED" "FAILED" "SYNCING" "ABORTED" "STOPPING"})))

(s/def :cognitect.aws.qbusiness/DeleteConversationResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/RetrieverContentSource
  (s/keys :req-un [:cognitect.aws.qbusiness.RetrieverContentSource/retrieverId]))

(s/def
  :cognitect.aws.qbusiness/DocumentMetadataConfigurationName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9_][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/Attachment
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.Attachment/copyFrom
     :cognitect.aws.qbusiness.Attachment/createdAt
     :cognitect.aws.qbusiness.Attachment/md5chksum
     :cognitect.aws.qbusiness.Attachment/error
     :cognitect.aws.qbusiness.Attachment/conversationId
     :cognitect.aws.qbusiness.Attachment/name
     :cognitect.aws.qbusiness.Attachment/status
     :cognitect.aws.qbusiness.Attachment/fileType
     :cognitect.aws.qbusiness.Attachment/fileSize
     :cognitect.aws.qbusiness.Attachment/attachmentId]))

(s/def
  :cognitect.aws.qbusiness/AutoSubscriptionConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.AutoSubscriptionConfiguration/autoSubscribe]
    :opt-un
    [:cognitect.aws.qbusiness.AutoSubscriptionConfiguration/defaultSubscriptionType]))

(s/def
  :cognitect.aws.qbusiness/ListRetrieversResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListRetrieversResponse/nextToken
     :cognitect.aws.qbusiness.ListRetrieversResponse/retrievers]))

(s/def
  :cognitect.aws.qbusiness/ExampleChatMessage
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/AssociatePermissionRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.AssociatePermissionRequest/applicationId
     :cognitect.aws.qbusiness.AssociatePermissionRequest/statementId
     :cognitect.aws.qbusiness.AssociatePermissionRequest/actions
     :cognitect.aws.qbusiness.AssociatePermissionRequest/principal]
    :opt-un
    [:cognitect.aws.qbusiness.AssociatePermissionRequest/conditions]))

(s/def
  :cognitect.aws.qbusiness/GetDataSourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetDataSourceRequest/applicationId
     :cognitect.aws.qbusiness.GetDataSourceRequest/indexId
     :cognitect.aws.qbusiness.GetDataSourceRequest/dataSourceId]))

(s/def
  :cognitect.aws.qbusiness/GetGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetGroupRequest/applicationId
     :cognitect.aws.qbusiness.GetGroupRequest/indexId
     :cognitect.aws.qbusiness.GetGroupRequest/groupName]
    :opt-un
    [:cognitect.aws.qbusiness.GetGroupRequest/dataSourceId]))

(s/def :cognitect.aws.qbusiness/MessageType (s/spec string? :gen #(s/gen #{"SYSTEM" "USER"})))

(s/def
  :cognitect.aws.qbusiness/KendraIndexId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/InstructionCollection
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.InstructionCollection/targetAudience
     :cognitect.aws.qbusiness.InstructionCollection/tone
     :cognitect.aws.qbusiness.InstructionCollection/identity
     :cognitect.aws.qbusiness.InstructionCollection/perspective
     :cognitect.aws.qbusiness.InstructionCollection/outputStyle
     :cognitect.aws.qbusiness.InstructionCollection/examples
     :cognitect.aws.qbusiness.InstructionCollection/responseLength
     :cognitect.aws.qbusiness.InstructionCollection/customInstructions]))

(s/def
  :cognitect.aws.qbusiness/IndexId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListDocuments
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.qbusiness/GetChatControlsConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetChatControlsConfigurationRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.GetChatControlsConfigurationRequest/maxResults
     :cognitect.aws.qbusiness.GetChatControlsConfigurationRequest/nextToken]))

(s/def :cognitect.aws.qbusiness/StopDataSourceSyncJobResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/CreateWebExperienceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CreateWebExperienceResponse/webExperienceId
     :cognitect.aws.qbusiness.CreateWebExperienceResponse/webExperienceArn]))

(s/def
  :cognitect.aws.qbusiness/ActionReviewPayloadFieldAllowedValue
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ActionReviewPayloadFieldAllowedValue/displayValue
     :cognitect.aws.qbusiness.ActionReviewPayloadFieldAllowedValue/value]))

(s/def
  :cognitect.aws.qbusiness/DocumentId
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/MediaExtractionConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.MediaExtractionConfiguration/imageExtractionConfiguration
     :cognitect.aws.qbusiness.MediaExtractionConfiguration/audioExtractionConfiguration
     :cognitect.aws.qbusiness.MediaExtractionConfiguration/videoExtractionConfiguration]))

(s/def
  :cognitect.aws.qbusiness/Plugin
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.Plugin/updatedAt
     :cognitect.aws.qbusiness.Plugin/createdAt
     :cognitect.aws.qbusiness.Plugin/displayName
     :cognitect.aws.qbusiness.Plugin/pluginId
     :cognitect.aws.qbusiness.Plugin/type
     :cognitect.aws.qbusiness.Plugin/state
     :cognitect.aws.qbusiness.Plugin/serverUrl
     :cognitect.aws.qbusiness.Plugin/buildStatus]))

(s/def
  :cognitect.aws.qbusiness/ListRetrieversRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListRetrieversRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListRetrieversRequest/maxResults
     :cognitect.aws.qbusiness.ListRetrieversRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/GetDataSourceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetDataSourceResponse/applicationId
     :cognitect.aws.qbusiness.GetDataSourceResponse/updatedAt
     :cognitect.aws.qbusiness.GetDataSourceResponse/createdAt
     :cognitect.aws.qbusiness.GetDataSourceResponse/vpcConfiguration
     :cognitect.aws.qbusiness.GetDataSourceResponse/documentEnrichmentConfiguration
     :cognitect.aws.qbusiness.GetDataSourceResponse/displayName
     :cognitect.aws.qbusiness.GetDataSourceResponse/roleArn
     :cognitect.aws.qbusiness.GetDataSourceResponse/dataSourceId
     :cognitect.aws.qbusiness.GetDataSourceResponse/error
     :cognitect.aws.qbusiness.GetDataSourceResponse/configuration
     :cognitect.aws.qbusiness.GetDataSourceResponse/syncSchedule
     :cognitect.aws.qbusiness.GetDataSourceResponse/status
     :cognitect.aws.qbusiness.GetDataSourceResponse/mediaExtractionConfiguration
     :cognitect.aws.qbusiness.GetDataSourceResponse/type
     :cognitect.aws.qbusiness.GetDataSourceResponse/indexId
     :cognitect.aws.qbusiness.GetDataSourceResponse/dataSourceArn
     :cognitect.aws.qbusiness.GetDataSourceResponse/description]))

(s/def
  :cognitect.aws.qbusiness/AppliedOrchestrationConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.AppliedOrchestrationConfiguration/control]))

(s/def
  :cognitect.aws.qbusiness/EncryptionConfiguration
  (s/keys :opt-un [:cognitect.aws.qbusiness.EncryptionConfiguration/kmsKeyId]))

(s/def :cognitect.aws.qbusiness/Long (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.qbusiness/PluginArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/Retriever
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.Retriever/applicationId
     :cognitect.aws.qbusiness.Retriever/retrieverId
     :cognitect.aws.qbusiness.Retriever/displayName
     :cognitect.aws.qbusiness.Retriever/status
     :cognitect.aws.qbusiness.Retriever/type]))

(s/def
  :cognitect.aws.qbusiness/UpdateUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateUserRequest/applicationId
     :cognitect.aws.qbusiness.UpdateUserRequest/userId]
    :opt-un
    [:cognitect.aws.qbusiness.UpdateUserRequest/userAliasesToDelete
     :cognitect.aws.qbusiness.UpdateUserRequest/userAliasesToUpdate]))

(s/def
  :cognitect.aws.qbusiness/AppliedAttachmentsConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.AppliedAttachmentsConfiguration/attachmentsControlMode]))

(s/def
  :cognitect.aws.qbusiness/AppliedCreatorModeConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.AppliedCreatorModeConfiguration/creatorModeControl]))

(s/def
  :cognitect.aws.qbusiness/ChatResponseConfigurationDetail
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ChatResponseConfigurationDetail/updatedAt
     :cognitect.aws.qbusiness.ChatResponseConfigurationDetail/responseConfigurationSummary
     :cognitect.aws.qbusiness.ChatResponseConfigurationDetail/error
     :cognitect.aws.qbusiness.ChatResponseConfigurationDetail/status
     :cognitect.aws.qbusiness.ChatResponseConfigurationDetail/responseConfigurations]))

(s/def
  :cognitect.aws.qbusiness/ListDocumentsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListDocumentsResponse/documentDetailList
     :cognitect.aws.qbusiness.ListDocumentsResponse/nextToken]))

(s/def
  :cognitect.aws.qbusiness/UpdateDataAccessorRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateDataAccessorRequest/applicationId
     :cognitect.aws.qbusiness.UpdateDataAccessorRequest/dataAccessorId
     :cognitect.aws.qbusiness.UpdateDataAccessorRequest/actionConfigurations]
    :opt-un
    [:cognitect.aws.qbusiness.UpdateDataAccessorRequest/displayName
     :cognitect.aws.qbusiness.UpdateDataAccessorRequest/authenticationDetail]))

(s/def
  :cognitect.aws.qbusiness/DataSourceArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ActionFilterConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.ActionFilterConfiguration/documentAttributeFilter]))

(s/def
  :cognitect.aws.qbusiness/BatchPutDocumentRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.BatchPutDocumentRequest/applicationId
     :cognitect.aws.qbusiness.BatchPutDocumentRequest/indexId
     :cognitect.aws.qbusiness.BatchPutDocumentRequest/documents]
    :opt-un
    [:cognitect.aws.qbusiness.BatchPutDocumentRequest/roleArn
     :cognitect.aws.qbusiness.BatchPutDocumentRequest/dataSourceSyncId]))

(s/def
  :cognitect.aws.qbusiness/DateAttributeBoostingConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DateAttributeBoostingConfiguration/boostingLevel]
    :opt-un
    [:cognitect.aws.qbusiness.DateAttributeBoostingConfiguration/boostingDurationInSeconds]))

(s/def
  :cognitect.aws.qbusiness/SamlProviderConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.SamlProviderConfiguration/authenticationUrl]))

(s/def
  :cognitect.aws.qbusiness/ScoreConfidence
  (s/spec string? :gen #(s/gen #{"LOW" "VERY_HIGH" "NOT_AVAILABLE" "HIGH" "MEDIUM"})))

(s/def :cognitect.aws.qbusiness/ConversationTitle string?)

(s/def :cognitect.aws.qbusiness/MemberGroups (s/coll-of :cognitect.aws.qbusiness/MemberGroup))

(s/def
  :cognitect.aws.qbusiness/ActionReviewPayloadFieldAllowedValues
  (s/coll-of :cognitect.aws.qbusiness/ActionReviewPayloadFieldAllowedValue))

(s/def
  :cognitect.aws.qbusiness/MessageUsefulnessReason
  (s/spec
    string?
    :gen
    #(s/gen
      #{"NOT_FACTUALLY_CORRECT"
        "NOT_CONCISE"
        "NOT_HELPFUL"
        "FACTUALLY_CORRECT"
        "OTHER"
        "RELEVANT_SOURCES"
        "NOT_COMPLETE"
        "HELPFUL"
        "HARMFUL_OR_UNSAFE"
        "COMPLETE"
        "NOT_BASED_ON_DOCUMENTS"
        "INCORRECT_OR_MISSING_SOURCES"})))

(s/def
  :cognitect.aws.qbusiness/GetPolicyResponse
  (s/keys :opt-un [:cognitect.aws.qbusiness.GetPolicyResponse/policy]))

(s/def
  :cognitect.aws.qbusiness/DataAccessorAuthenticationDetail
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DataAccessorAuthenticationDetail/authenticationType]
    :opt-un
    [:cognitect.aws.qbusiness.DataAccessorAuthenticationDetail/externalIds
     :cognitect.aws.qbusiness.DataAccessorAuthenticationDetail/authenticationConfiguration]))

(s/def
  :cognitect.aws.qbusiness/DataSourceId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/DataAccessorAuthenticationConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DataAccessorAuthenticationConfiguration/idcTrustedTokenIssuerConfiguration]))

(s/def
  :cognitect.aws.qbusiness/DataSourceStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"UPDATING" "DELETING" "CREATING" "ACTIVE" "FAILED" "PENDING_CREATION"})))

(s/def
  :cognitect.aws.qbusiness/ChatResponseConfigurationArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/GetApplicationRequest
  (s/keys :req-un [:cognitect.aws.qbusiness.GetApplicationRequest/applicationId]))

(s/def
  :cognitect.aws.qbusiness/Application
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.Application/identityType
     :cognitect.aws.qbusiness.Application/applicationId
     :cognitect.aws.qbusiness.Application/updatedAt
     :cognitect.aws.qbusiness.Application/quickSightConfiguration
     :cognitect.aws.qbusiness.Application/createdAt
     :cognitect.aws.qbusiness.Application/displayName
     :cognitect.aws.qbusiness.Application/status]))

(s/def
  :cognitect.aws.qbusiness/GetUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetUserRequest/applicationId
     :cognitect.aws.qbusiness.GetUserRequest/userId]))

(s/def
  :cognitect.aws.qbusiness/ChatResponseConfigurationId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def :cognitect.aws.qbusiness/AttachmentList (s/coll-of :cognitect.aws.qbusiness/Attachment))

(s/def
  :cognitect.aws.qbusiness/IdentityProviderConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.IdentityProviderConfiguration/samlConfiguration
     :cognitect.aws.qbusiness.IdentityProviderConfiguration/openIDConnectConfiguration]))

(s/def
  :cognitect.aws.qbusiness/ListIndicesRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListIndicesRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListIndicesRequest/maxResults
     :cognitect.aws.qbusiness.ListIndicesRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/MaxResults
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.qbusiness/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UntagResourceRequest/resourceARN
     :cognitect.aws.qbusiness.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.qbusiness/DataAccessorName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/Conversation
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.Conversation/conversationId
     :cognitect.aws.qbusiness.Conversation/startTime
     :cognitect.aws.qbusiness.Conversation/title]))

(s/def
  :cognitect.aws.qbusiness/HallucinationReductionControl
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/DeleteIndexRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteIndexRequest/applicationId
     :cognitect.aws.qbusiness.DeleteIndexRequest/indexId]))

(s/def
  :cognitect.aws.qbusiness/VideoSourceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.VideoSourceDetails/endTimeMilliseconds
     :cognitect.aws.qbusiness.VideoSourceDetails/mediaMimeType
     :cognitect.aws.qbusiness.VideoSourceDetails/startTimeMilliseconds
     :cognitect.aws.qbusiness.VideoSourceDetails/videoExtractionType
     :cognitect.aws.qbusiness.VideoSourceDetails/mediaId]))

(s/def
  :cognitect.aws.qbusiness/MediaTooLargeException
  (s/keys :req-un [:cognitect.aws.qbusiness.MediaTooLargeException/message]))

(s/def
  :cognitect.aws.qbusiness/GroupIdentifier
  (s/spec
    #(re-matches
      (re-pattern
        "([0-9a-f]{10}-|)[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/AudioSourceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.AudioSourceDetails/audioExtractionType
     :cognitect.aws.qbusiness.AudioSourceDetails/endTimeMilliseconds
     :cognitect.aws.qbusiness.AudioSourceDetails/mediaMimeType
     :cognitect.aws.qbusiness.AudioSourceDetails/startTimeMilliseconds
     :cognitect.aws.qbusiness.AudioSourceDetails/mediaId]))

(s/def
  :cognitect.aws.qbusiness/NumberAttributeBoostingConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.NumberAttributeBoostingConfiguration/boostingLevel]
    :opt-un
    [:cognitect.aws.qbusiness.NumberAttributeBoostingConfiguration/boostingType]))

(s/def
  :cognitect.aws.qbusiness/ListPluginActionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListPluginActionsRequest/applicationId
     :cognitect.aws.qbusiness.ListPluginActionsRequest/pluginId]
    :opt-un
    [:cognitect.aws.qbusiness.ListPluginActionsRequest/maxResults
     :cognitect.aws.qbusiness.ListPluginActionsRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/Blob
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.qbusiness/PermissionConditionValue
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def :cognitect.aws.qbusiness/DisassociatePermissionResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/DataAccessorArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/AuthorizationResponseMap
  (s/map-of :cognitect.aws.qbusiness/AuthResponseKey :cognitect.aws.qbusiness/AuthResponseValue))

(s/def
  :cognitect.aws.qbusiness/BatchDeleteDocumentRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.BatchDeleteDocumentRequest/applicationId
     :cognitect.aws.qbusiness.BatchDeleteDocumentRequest/indexId
     :cognitect.aws.qbusiness.BatchDeleteDocumentRequest/documents]
    :opt-un
    [:cognitect.aws.qbusiness.BatchDeleteDocumentRequest/dataSourceSyncId]))

(s/def
  :cognitect.aws.qbusiness/SecretArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListGroupsRequest
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.qbusiness/Description
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/RetrieverConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.RetrieverConfiguration/nativeIndexConfiguration
     :cognitect.aws.qbusiness.RetrieverConfiguration/kendraIndexConfiguration]))

(s/def
  :cognitect.aws.qbusiness/GetMediaRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetMediaRequest/applicationId
     :cognitect.aws.qbusiness.GetMediaRequest/conversationId
     :cognitect.aws.qbusiness.GetMediaRequest/messageId
     :cognitect.aws.qbusiness.GetMediaRequest/mediaId]))

(s/def
  :cognitect.aws.qbusiness/ApplicationStatus
  (s/spec string? :gen #(s/gen #{"UPDATING" "DELETING" "CREATING" "ACTIVE" "FAILED"})))

(s/def :cognitect.aws.qbusiness/DeleteRetrieverResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/S3BucketName
  (s/spec #(re-matches (re-pattern "[a-z0-9][\\.\\-a-z0-9]{1,61}[a-z0-9]") %) :gen #(gen/string)))

(s/def :cognitect.aws.qbusiness/UpdateWebExperienceResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/DeleteDocument
  (s/keys :req-un [:cognitect.aws.qbusiness.DeleteDocument/documentId]))

(s/def
  :cognitect.aws.qbusiness/DocumentAclGroup
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAclGroup/name
     :cognitect.aws.qbusiness.DocumentAclGroup/type]))

(s/def
  :cognitect.aws.qbusiness/ApplicationId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ClientToken
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/DocumentAttribute
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DocumentAttribute/name
     :cognitect.aws.qbusiness.DocumentAttribute/value]))

(s/def
  :cognitect.aws.qbusiness/OrchestrationControl
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def :cognitect.aws.qbusiness/DataSourceConfiguration (s/keys))

(s/def
  :cognitect.aws.qbusiness/AttachmentOutput
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.AttachmentOutput/error
     :cognitect.aws.qbusiness.AttachmentOutput/conversationId
     :cognitect.aws.qbusiness.AttachmentOutput/name
     :cognitect.aws.qbusiness.AttachmentOutput/status
     :cognitect.aws.qbusiness.AttachmentOutput/attachmentId]))

(s/def
  :cognitect.aws.qbusiness/LicenseNotFoundException
  (s/keys :req-un [:cognitect.aws.qbusiness.LicenseNotFoundException/message]))

(s/def
  :cognitect.aws.qbusiness/ExternalResourceException
  (s/keys :req-un [:cognitect.aws.qbusiness.ExternalResourceException/message]))

(s/def
  :cognitect.aws.qbusiness/PersonalizationConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.PersonalizationConfiguration/personalizationControlMode]))

(s/def
  :cognitect.aws.qbusiness/ConfigurationEvent
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ConfigurationEvent/attributeFilter
     :cognitect.aws.qbusiness.ConfigurationEvent/chatModeConfiguration
     :cognitect.aws.qbusiness.ConfigurationEvent/chatMode]))

(s/def :cognitect.aws.qbusiness/Timestamp inst?)

(s/def
  :cognitect.aws.qbusiness/S3
  (s/keys :req-un [:cognitect.aws.qbusiness.S3/bucket :cognitect.aws.qbusiness.S3/key]))

(s/def
  :cognitect.aws.qbusiness/RuleConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.RuleConfiguration/contentRetrievalRule
     :cognitect.aws.qbusiness.RuleConfiguration/contentBlockerRule]))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeBoostingConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAttributeBoostingConfiguration/stringConfiguration
     :cognitect.aws.qbusiness.DocumentAttributeBoostingConfiguration/stringListConfiguration
     :cognitect.aws.qbusiness.DocumentAttributeBoostingConfiguration/numberConfiguration
     :cognitect.aws.qbusiness.DocumentAttributeBoostingConfiguration/dateConfiguration]))

(s/def
  :cognitect.aws.qbusiness/TopicConfigurations
  (s/coll-of :cognitect.aws.qbusiness/TopicConfiguration :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.qbusiness/OAuth2ClientCredentialConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.OAuth2ClientCredentialConfiguration/secretArn
     :cognitect.aws.qbusiness.OAuth2ClientCredentialConfiguration/roleArn]
    :opt-un
    [:cognitect.aws.qbusiness.OAuth2ClientCredentialConfiguration/tokenUrl
     :cognitect.aws.qbusiness.OAuth2ClientCredentialConfiguration/authorizationUrl]))

(s/def
  :cognitect.aws.qbusiness/WebExperienceSubtitle
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/SearchRelevantContentRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.SearchRelevantContentRequest/applicationId
     :cognitect.aws.qbusiness.SearchRelevantContentRequest/queryText
     :cognitect.aws.qbusiness.SearchRelevantContentRequest/contentSource]
    :opt-un
    [:cognitect.aws.qbusiness.SearchRelevantContentRequest/attributeFilter
     :cognitect.aws.qbusiness.SearchRelevantContentRequest/maxResults
     :cognitect.aws.qbusiness.SearchRelevantContentRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/PluginId
  (s/spec
    #(re-matches (re-pattern "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ContentType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"XSLT"
        "CSV"
        "XML"
        "PPT"
        "JSON"
        "MS_EXCEL"
        "MD"
        "HTML"
        "PLAIN_TEXT"
        "PDF"
        "RTF"
        "MS_WORD"})))

(s/def :cognitect.aws.qbusiness/PluginState (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/DataSourceVpcConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DataSourceVpcConfiguration/subnetIds
     :cognitect.aws.qbusiness.DataSourceVpcConfiguration/securityGroupIds]))

(s/def :cognitect.aws.qbusiness/TextSegmentList (s/coll-of :cognitect.aws.qbusiness/TextSegment))

(s/def
  :cognitect.aws.qbusiness/CreateDataSourceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CreateDataSourceResponse/dataSourceId
     :cognitect.aws.qbusiness.CreateDataSourceResponse/dataSourceArn]))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListApplications
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeKey
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9_][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/UpdateRetrieverRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateRetrieverRequest/applicationId
     :cognitect.aws.qbusiness.UpdateRetrieverRequest/retrieverId]
    :opt-un
    [:cognitect.aws.qbusiness.UpdateRetrieverRequest/displayName
     :cognitect.aws.qbusiness.UpdateRetrieverRequest/roleArn
     :cognitect.aws.qbusiness.UpdateRetrieverRequest/configuration]))

(s/def
  :cognitect.aws.qbusiness/GetPluginResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetPluginResponse/applicationId
     :cognitect.aws.qbusiness.GetPluginResponse/updatedAt
     :cognitect.aws.qbusiness.GetPluginResponse/createdAt
     :cognitect.aws.qbusiness.GetPluginResponse/displayName
     :cognitect.aws.qbusiness.GetPluginResponse/authConfiguration
     :cognitect.aws.qbusiness.GetPluginResponse/pluginArn
     :cognitect.aws.qbusiness.GetPluginResponse/pluginId
     :cognitect.aws.qbusiness.GetPluginResponse/customPluginConfiguration
     :cognitect.aws.qbusiness.GetPluginResponse/type
     :cognitect.aws.qbusiness.GetPluginResponse/state
     :cognitect.aws.qbusiness.GetPluginResponse/serverUrl
     :cognitect.aws.qbusiness.GetPluginResponse/buildStatus]))

(s/def
  :cognitect.aws.qbusiness/ConversationSource
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ConversationSource/conversationId
     :cognitect.aws.qbusiness.ConversationSource/attachmentId]))

(s/def
  :cognitect.aws.qbusiness/MessageUsefulnessFeedback
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.MessageUsefulnessFeedback/usefulness
     :cognitect.aws.qbusiness.MessageUsefulnessFeedback/submittedAt]
    :opt-un
    [:cognitect.aws.qbusiness.MessageUsefulnessFeedback/reason
     :cognitect.aws.qbusiness.MessageUsefulnessFeedback/comment]))

(s/def
  :cognitect.aws.qbusiness/ListMessagesRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListMessagesRequest/conversationId
     :cognitect.aws.qbusiness.ListMessagesRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListMessagesRequest/maxResults
     :cognitect.aws.qbusiness.ListMessagesRequest/nextToken
     :cognitect.aws.qbusiness.ListMessagesRequest/userId]))

(s/def :cognitect.aws.qbusiness/Subscriptions (s/coll-of :cognitect.aws.qbusiness/Subscription))

(s/def
  :cognitect.aws.qbusiness/CreateUserRequestUserAliasesList
  (s/coll-of :cognitect.aws.qbusiness/UserAlias :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListConversations
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.qbusiness/GetDataAccessorResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.GetDataAccessorResponse/principal
     :cognitect.aws.qbusiness.GetDataAccessorResponse/applicationId
     :cognitect.aws.qbusiness.GetDataAccessorResponse/updatedAt
     :cognitect.aws.qbusiness.GetDataAccessorResponse/actionConfigurations
     :cognitect.aws.qbusiness.GetDataAccessorResponse/createdAt
     :cognitect.aws.qbusiness.GetDataAccessorResponse/displayName
     :cognitect.aws.qbusiness.GetDataAccessorResponse/dataAccessorArn
     :cognitect.aws.qbusiness.GetDataAccessorResponse/dataAccessorId
     :cognitect.aws.qbusiness.GetDataAccessorResponse/idcApplicationArn
     :cognitect.aws.qbusiness.GetDataAccessorResponse/authenticationDetail]))

(s/def
  :cognitect.aws.qbusiness/ImageExtractionConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.ImageExtractionConfiguration/imageExtractionStatus]))

(s/def
  :cognitect.aws.qbusiness/PluginAuthConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.PluginAuthConfiguration/oAuth2ClientCredentialConfiguration
     :cognitect.aws.qbusiness.PluginAuthConfiguration/basicAuthConfiguration
     :cognitect.aws.qbusiness.PluginAuthConfiguration/idcAuthConfiguration
     :cognitect.aws.qbusiness.PluginAuthConfiguration/noAuthConfiguration]))

(s/def
  :cognitect.aws.qbusiness/GetPluginRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.GetPluginRequest/applicationId
     :cognitect.aws.qbusiness.GetPluginRequest/pluginId]))

(s/def
  :cognitect.aws.qbusiness/RuleType
  (s/spec string? :gen #(s/gen #{"CONTENT_BLOCKER_RULE" "CONTENT_RETRIEVAL_RULE"})))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAttributeConfiguration/name
     :cognitect.aws.qbusiness.DocumentAttributeConfiguration/type
     :cognitect.aws.qbusiness.DocumentAttributeConfiguration/search]))

(s/def
  :cognitect.aws.qbusiness/IndexStatus
  (s/spec string? :gen #(s/gen #{"UPDATING" "DELETING" "CREATING" "ACTIVE" "FAILED"})))

(s/def :cognitect.aws.qbusiness/AssociatedUsers (s/coll-of :cognitect.aws.qbusiness/AssociatedUser))

(s/def
  :cognitect.aws.qbusiness/SourceAttributions
  (s/coll-of :cognitect.aws.qbusiness/SourceAttribution))

(s/def
  :cognitect.aws.qbusiness/DataSource
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DataSource/updatedAt
     :cognitect.aws.qbusiness.DataSource/createdAt
     :cognitect.aws.qbusiness.DataSource/displayName
     :cognitect.aws.qbusiness.DataSource/dataSourceId
     :cognitect.aws.qbusiness.DataSource/status
     :cognitect.aws.qbusiness.DataSource/type]))

(s/def
  :cognitect.aws.qbusiness/SubscriptionArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/AttributeFilters
  (s/coll-of :cognitect.aws.qbusiness/AttributeFilter))

(s/def
  :cognitect.aws.qbusiness/RetrieverStatus
  (s/spec string? :gen #(s/gen #{"CREATING" "ACTIVE" "FAILED"})))

(s/def
  :cognitect.aws.qbusiness/S3ObjectKey
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/ListChatResponseConfigurationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ListChatResponseConfigurationsRequest/applicationId]
    :opt-un
    [:cognitect.aws.qbusiness.ListChatResponseConfigurationsRequest/maxResults
     :cognitect.aws.qbusiness.ListChatResponseConfigurationsRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/SecurityGroupIds
  (s/coll-of :cognitect.aws.qbusiness/SecurityGroupId :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.qbusiness/AuthResponseValue
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.qbusiness/DeleteDocuments (s/coll-of :cognitect.aws.qbusiness/DeleteDocument))

(s/def
  :cognitect.aws.qbusiness/DataSourceIds
  (s/coll-of :cognitect.aws.qbusiness/DataSourceId :min-count 1 :max-count 1))

(s/def :cognitect.aws.qbusiness/ReadAccessType (s/spec string? :gen #(s/gen #{"DENY" "ALLOW"})))

(s/def :cognitect.aws.qbusiness/UserIds (s/coll-of :cognitect.aws.qbusiness/String))

(s/def :cognitect.aws.qbusiness/ResponseConfigurationType (s/spec string? :gen #(s/gen #{"ALL"})))

(s/def
  :cognitect.aws.qbusiness/IdcTrustedTokenIssuerArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:aws:sso::[0-9]{12}:trustedTokenIssuer/(sso)?ins-[a-zA-Z0-9-.]{16}/tti-[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/TagKeys
  (s/coll-of :cognitect.aws.qbusiness/TagKey :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.qbusiness/MessageBody
  (s/spec #(re-matches (re-pattern "\\P{C}*$}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ChatInputStream
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ChatInputStream/configurationEvent
     :cognitect.aws.qbusiness.ChatInputStream/textEvent
     :cognitect.aws.qbusiness.ChatInputStream/attachmentEvent
     :cognitect.aws.qbusiness.ChatInputStream/endOfInputEvent
     :cognitect.aws.qbusiness.ChatInputStream/authChallengeResponseEvent
     :cognitect.aws.qbusiness.ChatInputStream/actionExecutionEvent]))

(s/def
  :cognitect.aws.qbusiness/AutoSubscriptionStatus
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/ChatResponseConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ChatResponseConfiguration/chatResponseConfigurationId
     :cognitect.aws.qbusiness.ChatResponseConfiguration/chatResponseConfigurationArn
     :cognitect.aws.qbusiness.ChatResponseConfiguration/displayName
     :cognitect.aws.qbusiness.ChatResponseConfiguration/status]
    :opt-un
    [:cognitect.aws.qbusiness.ChatResponseConfiguration/updatedAt
     :cognitect.aws.qbusiness.ChatResponseConfiguration/responseConfigurationSummary
     :cognitect.aws.qbusiness.ChatResponseConfiguration/createdAt]))

(s/def
  :cognitect.aws.qbusiness/DataAccessorIdcTrustedTokenIssuerConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DataAccessorIdcTrustedTokenIssuerConfiguration/idcTrustedTokenIssuerArn]))

(s/def
  :cognitect.aws.qbusiness/QIamActions
  (s/coll-of :cognitect.aws.qbusiness/QIamAction :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.qbusiness/IndexStatistics
  (s/keys :opt-un [:cognitect.aws.qbusiness.IndexStatistics/textDocumentStatistics]))

(s/def
  :cognitect.aws.qbusiness/ActionReviewPayloadField
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ActionReviewPayloadField/arrayItemJsonSchema
     :cognitect.aws.qbusiness.ActionReviewPayloadField/displayName
     :cognitect.aws.qbusiness.ActionReviewPayloadField/displayDescription
     :cognitect.aws.qbusiness.ActionReviewPayloadField/value
     :cognitect.aws.qbusiness.ActionReviewPayloadField/allowedValues
     :cognitect.aws.qbusiness.ActionReviewPayloadField/required
     :cognitect.aws.qbusiness.ActionReviewPayloadField/type
     :cognitect.aws.qbusiness.ActionReviewPayloadField/allowedFormat
     :cognitect.aws.qbusiness.ActionReviewPayloadField/displayOrder]))

(s/def
  :cognitect.aws.qbusiness/DataAccessorId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]{35}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeValue
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAttributeValue/stringListValue
     :cognitect.aws.qbusiness.DocumentAttributeValue/longValue
     :cognitect.aws.qbusiness.DocumentAttributeValue/dateValue
     :cognitect.aws.qbusiness.DocumentAttributeValue/stringValue]))

(s/def
  :cognitect.aws.qbusiness/NativeIndexConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.NativeIndexConfiguration/indexId]
    :opt-un
    [:cognitect.aws.qbusiness.NativeIndexConfiguration/boostingOverride
     :cognitect.aws.qbusiness.NativeIndexConfiguration/version]))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeStringListValue
  (s/coll-of :cognitect.aws.qbusiness/String))

(s/def
  :cognitect.aws.qbusiness/DeleteApplicationRequest
  (s/keys :req-un [:cognitect.aws.qbusiness.DeleteApplicationRequest/applicationId]))

(s/def
  :cognitect.aws.qbusiness/WebExperienceTitle
  (s/spec #(re-matches (re-pattern "[\\s\\S]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/PutGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.PutGroupRequest/applicationId
     :cognitect.aws.qbusiness.PutGroupRequest/indexId
     :cognitect.aws.qbusiness.PutGroupRequest/groupName
     :cognitect.aws.qbusiness.PutGroupRequest/type
     :cognitect.aws.qbusiness.PutGroupRequest/groupMembers]
    :opt-un
    [:cognitect.aws.qbusiness.PutGroupRequest/roleArn
     :cognitect.aws.qbusiness.PutGroupRequest/dataSourceId]))

(s/def
  :cognitect.aws.qbusiness/VideoExtractionConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.VideoExtractionConfiguration/videoExtractionStatus]))

(s/def
  :cognitect.aws.qbusiness/ChatOutput
  (s/keys :opt-un [:cognitect.aws.qbusiness.ChatOutput/outputStream]))

(s/def
  :cognitect.aws.qbusiness/PluginTypeCategory
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Communication"
        "Ticketing and incident management"
        "Project management"
        "Customer relationship management (CRM)"
        "Productivity"})))

(s/def
  :cognitect.aws.qbusiness/ListApplicationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListApplicationsRequest/maxResults
     :cognitect.aws.qbusiness.ListApplicationsRequest/nextToken]))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListRetrieversRequest
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.qbusiness/ListDataAccessorsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListDataAccessorsResponse/nextToken
     :cognitect.aws.qbusiness.ListDataAccessorsResponse/dataAccessors]))

(s/def :cognitect.aws.qbusiness/UpdatePluginResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.qbusiness.ListTagsForResourceResponse/tags]))

(s/def
  :cognitect.aws.qbusiness/NumberAttributeBoostingType
  (s/spec string? :gen #(s/gen #{"PRIORITIZE_LARGER_VALUES" "PRIORITIZE_SMALLER_VALUES"})))

(s/def
  :cognitect.aws.qbusiness/ActionExecutionEvent
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ActionExecutionEvent/pluginId
     :cognitect.aws.qbusiness.ActionExecutionEvent/payload
     :cognitect.aws.qbusiness.ActionExecutionEvent/payloadFieldNameSeparator]))

(s/def
  :cognitect.aws.qbusiness/IdcAuthConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.IdcAuthConfiguration/idcApplicationArn
     :cognitect.aws.qbusiness.IdcAuthConfiguration/roleArn]))

(s/def
  :cognitect.aws.qbusiness/FontUrl
  (s/spec
    #(re-matches (re-pattern "(https?://[a-zA-Z0-9-_.+%/]+\\.(ttf|woff|woff2|otf))?") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.qbusiness/IndexType (s/spec string? :gen #(s/gen #{"STARTER" "ENTERPRISE"})))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListIndices
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.qbusiness/IndexName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/AssociatedGroup
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.AssociatedGroup/name :cognitect.aws.qbusiness.AssociatedGroup/type]))

(s/def
  :cognitect.aws.qbusiness/CreateSubscriptionRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CreateSubscriptionRequest/applicationId
     :cognitect.aws.qbusiness.CreateSubscriptionRequest/principal
     :cognitect.aws.qbusiness.CreateSubscriptionRequest/type]
    :opt-un
    [:cognitect.aws.qbusiness.CreateSubscriptionRequest/clientToken]))

(s/def
  :cognitect.aws.qbusiness/WebExperienceId
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9-]*") %) :gen #(gen/string)))

(s/def :cognitect.aws.qbusiness/Retrievers (s/coll-of :cognitect.aws.qbusiness/Retriever))

(s/def
  :cognitect.aws.qbusiness/DataSourceUserId
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/MessageUsefulness
  (s/spec string? :gen #(s/gen #{"USEFUL" "NOT_USEFUL"})))

(s/def
  :cognitect.aws.qbusiness/ResponseConfiguration
  (s/keys :opt-un [:cognitect.aws.qbusiness.ResponseConfiguration/instructionCollection]))

(s/def
  :cognitect.aws.qbusiness/SamlAttribute
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributeTarget
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DocumentAttributeTarget/key]
    :opt-un
    [:cognitect.aws.qbusiness.DocumentAttributeTarget/attributeValueOperator
     :cognitect.aws.qbusiness.DocumentAttributeTarget/value]))

(s/def
  :cognitect.aws.qbusiness/AttachmentId
  (s/spec
    #(re-matches
      (re-pattern "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/PluginTypeMetadataSummary
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.PluginTypeMetadataSummary/type
     :cognitect.aws.qbusiness.PluginTypeMetadataSummary/category
     :cognitect.aws.qbusiness.PluginTypeMetadataSummary/description]))

(s/def
  :cognitect.aws.qbusiness/IndexCapacityConfiguration
  (s/keys :opt-un [:cognitect.aws.qbusiness.IndexCapacityConfiguration/units]))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForGetTopicConfigurations
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.qbusiness/GetPolicyRequest
  (s/keys :req-un [:cognitect.aws.qbusiness.GetPolicyRequest/applicationId]))

(s/def :cognitect.aws.qbusiness/Conversations (s/coll-of :cognitect.aws.qbusiness/Conversation))

(s/def
  :cognitect.aws.qbusiness/CancelSubscriptionRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.CancelSubscriptionRequest/applicationId
     :cognitect.aws.qbusiness.CancelSubscriptionRequest/subscriptionId]))

(s/def :cognitect.aws.qbusiness/PutGroupResponse (s/keys))

(s/def
  :cognitect.aws.qbusiness/Document
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.Document/id]
    :opt-un
    [:cognitect.aws.qbusiness.Document/documentEnrichmentConfiguration
     :cognitect.aws.qbusiness.Document/accessConfiguration
     :cognitect.aws.qbusiness.Document/mediaExtractionConfiguration
     :cognitect.aws.qbusiness.Document/content
     :cognitect.aws.qbusiness.Document/attributes
     :cognitect.aws.qbusiness.Document/title
     :cognitect.aws.qbusiness.Document/contentType]))

(s/def :cognitect.aws.qbusiness/FailedDocuments (s/coll-of :cognitect.aws.qbusiness/FailedDocument))

(s/def
  :cognitect.aws.qbusiness/IAMIdentityProviderArn
  (s/spec
    #(re-matches
      (re-pattern "arn:aws:iam::\\d{12}:(oidc-provider|saml-provider)/[a-zA-Z0-9_\\.\\/@\\-]+")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ListSubscriptionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListSubscriptionsResponse/nextToken
     :cognitect.aws.qbusiness.ListSubscriptionsResponse/subscriptions]))

(s/def
  :cognitect.aws.qbusiness/ChatSyncOutput
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ChatSyncOutput/systemMessageId
     :cognitect.aws.qbusiness.ChatSyncOutput/failedAttachments
     :cognitect.aws.qbusiness.ChatSyncOutput/conversationId
     :cognitect.aws.qbusiness.ChatSyncOutput/actionReview
     :cognitect.aws.qbusiness.ChatSyncOutput/authChallengeRequest
     :cognitect.aws.qbusiness.ChatSyncOutput/userMessageId
     :cognitect.aws.qbusiness.ChatSyncOutput/systemMessage
     :cognitect.aws.qbusiness.ChatSyncOutput/sourceAttributions]))

(s/def
  :cognitect.aws.qbusiness/RelevantContent
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.RelevantContent/documentId
     :cognitect.aws.qbusiness.RelevantContent/documentTitle
     :cognitect.aws.qbusiness.RelevantContent/documentUri
     :cognitect.aws.qbusiness.RelevantContent/scoreAttributes
     :cognitect.aws.qbusiness.RelevantContent/content
     :cognitect.aws.qbusiness.RelevantContent/documentAttributes]))

(s/def
  :cognitect.aws.qbusiness/MaxResultsIntegerForListDataSources
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.qbusiness/GroupName
  (s/spec #(re-matches (re-pattern "\\P{C}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/ListDataSourcesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListDataSourcesResponse/nextToken
     :cognitect.aws.qbusiness.ListDataSourcesResponse/dataSources]))

(s/def
  :cognitect.aws.qbusiness/String
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.qbusiness/LogoUrl
  (s/spec
    #(re-matches (re-pattern "(https?://[a-zA-Z0-9-_.+%/]+\\.(svg|png))?") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/BrowserExtension
  (s/spec string? :gen #(s/gen #{"CHROME" "FIREFOX"})))

(s/def
  :cognitect.aws.qbusiness/ListPluginActionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.ListPluginActionsResponse/nextToken
     :cognitect.aws.qbusiness.ListPluginActionsResponse/items]))

(s/def
  :cognitect.aws.qbusiness/UpdateWebExperienceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateWebExperienceRequest/applicationId
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/webExperienceId]
    :opt-un
    [:cognitect.aws.qbusiness.UpdateWebExperienceRequest/browserExtensionConfiguration
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/identityProviderConfiguration
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/samplePromptsControlMode
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/welcomeMessage
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/roleArn
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/customizationConfiguration
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/subtitle
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/title
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/origins
     :cognitect.aws.qbusiness.UpdateWebExperienceRequest/authenticationConfiguration]))

(s/def
  :cognitect.aws.qbusiness/PluginName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.qbusiness/CreateIndexResponse
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.CreateIndexResponse/indexArn
     :cognitect.aws.qbusiness.CreateIndexResponse/indexId]))

(s/def
  :cognitect.aws.qbusiness/PutFeedbackRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.PutFeedbackRequest/applicationId
     :cognitect.aws.qbusiness.PutFeedbackRequest/conversationId
     :cognitect.aws.qbusiness.PutFeedbackRequest/messageId]
    :opt-un
    [:cognitect.aws.qbusiness.PutFeedbackRequest/messageCopiedAt
     :cognitect.aws.qbusiness.PutFeedbackRequest/userId
     :cognitect.aws.qbusiness.PutFeedbackRequest/messageUsefulness]))

(s/def
  :cognitect.aws.qbusiness/InlineDocumentEnrichmentConfigurations
  (s/coll-of
    :cognitect.aws.qbusiness/InlineDocumentEnrichmentConfiguration
    :min-count
    1
    :max-count
    100))

(s/def
  :cognitect.aws.qbusiness/DeleteDataAccessorRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteDataAccessorRequest/applicationId
     :cognitect.aws.qbusiness.DeleteDataAccessorRequest/dataAccessorId]))

(s/def :cognitect.aws.qbusiness/ActionPayloadFieldValue (s/keys))

(s/def
  :cognitect.aws.qbusiness/ResourceNotFoundException
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ResourceNotFoundException/message
     :cognitect.aws.qbusiness.ResourceNotFoundException/resourceId
     :cognitect.aws.qbusiness.ResourceNotFoundException/resourceType]))

(s/def
  :cognitect.aws.qbusiness/ConflictException
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.ConflictException/message
     :cognitect.aws.qbusiness.ConflictException/resourceId
     :cognitect.aws.qbusiness.ConflictException/resourceType]))

(s/def
  :cognitect.aws.qbusiness/APISchema
  (s/keys
    :opt-un
    [:cognitect.aws.qbusiness.APISchema/s3 :cognitect.aws.qbusiness.APISchema/payload]))

(s/def
  :cognitect.aws.qbusiness/DocumentAttributes
  (s/coll-of :cognitect.aws.qbusiness/DocumentAttribute :min-count 1 :max-count 500))

(s/def
  :cognitect.aws.qbusiness/DeletePluginRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeletePluginRequest/applicationId
     :cognitect.aws.qbusiness.DeletePluginRequest/pluginId]))

(s/def
  :cognitect.aws.qbusiness/DeleteChatControlsConfigurationRequest
  (s/keys :req-un [:cognitect.aws.qbusiness.DeleteChatControlsConfigurationRequest/applicationId]))

(s/def
  :cognitect.aws.qbusiness/UpdateDataSourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.UpdateDataSourceRequest/applicationId
     :cognitect.aws.qbusiness.UpdateDataSourceRequest/indexId
     :cognitect.aws.qbusiness.UpdateDataSourceRequest/dataSourceId]
    :opt-un
    [:cognitect.aws.qbusiness.UpdateDataSourceRequest/vpcConfiguration
     :cognitect.aws.qbusiness.UpdateDataSourceRequest/documentEnrichmentConfiguration
     :cognitect.aws.qbusiness.UpdateDataSourceRequest/displayName
     :cognitect.aws.qbusiness.UpdateDataSourceRequest/roleArn
     :cognitect.aws.qbusiness.UpdateDataSourceRequest/configuration
     :cognitect.aws.qbusiness.UpdateDataSourceRequest/syncSchedule
     :cognitect.aws.qbusiness.UpdateDataSourceRequest/mediaExtractionConfiguration
     :cognitect.aws.qbusiness.UpdateDataSourceRequest/description]))

(s/def
  :cognitect.aws.qbusiness/BatchDeleteDocumentResponse
  (s/keys :opt-un [:cognitect.aws.qbusiness.BatchDeleteDocumentResponse/failedDocuments]))

(s/def
  :cognitect.aws.qbusiness/DeleteRetrieverRequest
  (s/keys
    :req-un
    [:cognitect.aws.qbusiness.DeleteRetrieverRequest/applicationId
     :cognitect.aws.qbusiness.DeleteRetrieverRequest/retrieverId]))

(s/def
  :cognitect.aws.qbusiness/OrchestrationConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.OrchestrationConfiguration/control]))

(s/def :cognitect.aws.qbusiness/Status (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.qbusiness/CreatorModeConfiguration
  (s/keys :req-un [:cognitect.aws.qbusiness.CreatorModeConfiguration/creatorModeControl]))

(s/def
  :cognitect.aws.qbusiness.ListDataAccessorsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.ListDataAccessorsRequest/nextToken
  :cognitect.aws.qbusiness/NextToken1500)

(s/def
  :cognitect.aws.qbusiness.ListDataAccessorsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListDataAccessors)

(s/def :cognitect.aws.qbusiness.ThrottlingException/message :cognitect.aws.qbusiness/ErrorMessage)

(s/def
  :cognitect.aws.qbusiness.DeleteChatResponseConfigurationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.DeleteChatResponseConfigurationRequest/chatResponseConfigurationId
  :cognitect.aws.qbusiness/ChatResponseConfigurationId)

(s/def
  :cognitect.aws.qbusiness.DocumentEnrichmentConfiguration/inlineConfigurations
  :cognitect.aws.qbusiness/InlineDocumentEnrichmentConfigurations)

(s/def
  :cognitect.aws.qbusiness.DocumentEnrichmentConfiguration/preExtractionHookConfiguration
  :cognitect.aws.qbusiness/HookConfiguration)

(s/def
  :cognitect.aws.qbusiness.DocumentEnrichmentConfiguration/postExtractionHookConfiguration
  :cognitect.aws.qbusiness/HookConfiguration)

(s/def :cognitect.aws.qbusiness.Principal/user :cognitect.aws.qbusiness/PrincipalUser)

(s/def :cognitect.aws.qbusiness.Principal/group :cognitect.aws.qbusiness/PrincipalGroup)

(s/def :cognitect.aws.qbusiness.BasicAuthConfiguration/secretArn :cognitect.aws.qbusiness/SecretArn)

(s/def :cognitect.aws.qbusiness.BasicAuthConfiguration/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceRequest/description
  :cognitect.aws.qbusiness/Description)

(s/def :cognitect.aws.qbusiness.CreateDataSourceRequest/tags :cognitect.aws.qbusiness/Tags)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceRequest/mediaExtractionConfiguration
  :cognitect.aws.qbusiness/MediaExtractionConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceRequest/displayName
  :cognitect.aws.qbusiness/DataSourceName)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceRequest/syncSchedule
  :cognitect.aws.qbusiness/SyncSchedule)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceRequest/vpcConfiguration
  :cognitect.aws.qbusiness/DataSourceVpcConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceRequest/documentEnrichmentConfiguration
  :cognitect.aws.qbusiness/DocumentEnrichmentConfiguration)

(s/def :cognitect.aws.qbusiness.CreateDataSourceRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceRequest/configuration
  :cognitect.aws.qbusiness/DataSourceConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceRequest/clientToken
  :cognitect.aws.qbusiness/ClientToken)

(s/def :cognitect.aws.qbusiness.CreateDataSourceRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.TagResourceRequest/resourceARN
  :cognitect.aws.qbusiness/AmazonResourceName)

(s/def :cognitect.aws.qbusiness.TagResourceRequest/tags :cognitect.aws.qbusiness/Tags)

(s/def
  :cognitect.aws.qbusiness.ServiceQuotaExceededException/message
  :cognitect.aws.qbusiness/ErrorMessage)

(s/def
  :cognitect.aws.qbusiness.ServiceQuotaExceededException/resourceId
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.ServiceQuotaExceededException/resourceType
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.InternalServerException/message
  :cognitect.aws.qbusiness/ErrorMessage)

(s/def
  :cognitect.aws.qbusiness.ContentRetrievalRule/eligibleDataSources
  :cognitect.aws.qbusiness/EligibleDataSources)

(s/def
  :cognitect.aws.qbusiness.ListPluginTypeActionsRequest/pluginType
  :cognitect.aws.qbusiness/PluginType)

(s/def
  :cognitect.aws.qbusiness.ListPluginTypeActionsRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListPluginTypeActionsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListPluginTypeActions)

(s/def
  :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/chatResponseConfigurationId
  :cognitect.aws.qbusiness/ChatResponseConfigurationId)

(s/def
  :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/chatResponseConfigurationArn
  :cognitect.aws.qbusiness/ChatResponseConfigurationArn)

(s/def
  :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/displayName
  :cognitect.aws.qbusiness/DisplayName)

(s/def
  :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/createdAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/inUseConfiguration
  :cognitect.aws.qbusiness/ChatResponseConfigurationDetail)

(s/def
  :cognitect.aws.qbusiness.GetChatResponseConfigurationResponse/lastUpdateConfiguration
  :cognitect.aws.qbusiness/ChatResponseConfigurationDetail)

(s/def
  :cognitect.aws.qbusiness.ListConversationsResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListConversationsResponse/conversations
  :cognitect.aws.qbusiness/Conversations)

(s/def :cognitect.aws.qbusiness.AccessControl/principals :cognitect.aws.qbusiness/Principals)

(s/def
  :cognitect.aws.qbusiness.AccessControl/memberRelation
  :cognitect.aws.qbusiness/MemberRelation)

(s/def
  :cognitect.aws.qbusiness.FailedAttachmentEvent/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def
  :cognitect.aws.qbusiness.FailedAttachmentEvent/userMessageId
  :cognitect.aws.qbusiness/MessageId)

(s/def
  :cognitect.aws.qbusiness.FailedAttachmentEvent/systemMessageId
  :cognitect.aws.qbusiness/MessageId)

(s/def
  :cognitect.aws.qbusiness.FailedAttachmentEvent/attachment
  :cognitect.aws.qbusiness/AttachmentOutput)

(s/def :cognitect.aws.qbusiness.ValidationExceptionField/name :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.ValidationExceptionField/message :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.AttachmentInput/data :cognitect.aws.qbusiness/Blob)

(s/def :cognitect.aws.qbusiness.AttachmentInput/name :cognitect.aws.qbusiness/AttachmentName)

(s/def :cognitect.aws.qbusiness.AttachmentInput/copyFrom :cognitect.aws.qbusiness/CopyFromSource)

(s/def
  :cognitect.aws.qbusiness.DeleteAttachmentRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.DeleteAttachmentRequest/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def
  :cognitect.aws.qbusiness.DeleteAttachmentRequest/attachmentId
  :cognitect.aws.qbusiness/AttachmentId)

(s/def :cognitect.aws.qbusiness.DeleteAttachmentRequest/userId :cognitect.aws.qbusiness/UserId)

(s/def :cognitect.aws.qbusiness.ListGroupsResponse/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def :cognitect.aws.qbusiness.ListGroupsResponse/items :cognitect.aws.qbusiness/GroupSummaryList)

(s/def
  :cognitect.aws.qbusiness.AuthChallengeResponseEvent/responseMap
  :cognitect.aws.qbusiness/AuthorizationResponseMap)

(s/def :cognitect.aws.qbusiness.ListIndicesResponse/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def :cognitect.aws.qbusiness.ListIndicesResponse/indices :cognitect.aws.qbusiness/Indices)

(s/def
  :cognitect.aws.qbusiness.ListChatResponseConfigurationsResponse/chatResponseConfigurations
  :cognitect.aws.qbusiness/ChatResponseConfigurations)

(s/def
  :cognitect.aws.qbusiness.ListChatResponseConfigurationsResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def :cognitect.aws.qbusiness.Tag/key :cognitect.aws.qbusiness/TagKey)

(s/def :cognitect.aws.qbusiness.Tag/value :cognitect.aws.qbusiness/TagValue)

(s/def :cognitect.aws.qbusiness.GroupMembers/memberGroups :cognitect.aws.qbusiness/MemberGroups)

(s/def :cognitect.aws.qbusiness.GroupMembers/memberUsers :cognitect.aws.qbusiness/MemberUsers)

(s/def :cognitect.aws.qbusiness.GroupMembers/s3PathForGroupMembers :cognitect.aws.qbusiness/S3)

(s/def :cognitect.aws.qbusiness.ActionExecution/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def
  :cognitect.aws.qbusiness.ActionExecution/payload
  :cognitect.aws.qbusiness/ActionExecutionPayload)

(s/def
  :cognitect.aws.qbusiness.ActionExecution/payloadFieldNameSeparator
  :cognitect.aws.qbusiness/ActionPayloadFieldNameSeparator)

(s/def :cognitect.aws.qbusiness.Rule/includedUsersAndGroups :cognitect.aws.qbusiness/UsersAndGroups)

(s/def :cognitect.aws.qbusiness.Rule/excludedUsersAndGroups :cognitect.aws.qbusiness/UsersAndGroups)

(s/def :cognitect.aws.qbusiness.Rule/ruleType :cognitect.aws.qbusiness/RuleType)

(s/def :cognitect.aws.qbusiness.Rule/ruleConfiguration :cognitect.aws.qbusiness/RuleConfiguration)

(s/def :cognitect.aws.qbusiness.EligibleDataSource/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.EligibleDataSource/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def :cognitect.aws.qbusiness.ErrorDetail/errorMessage :cognitect.aws.qbusiness/ErrorMessage)

(s/def :cognitect.aws.qbusiness.ErrorDetail/errorCode :cognitect.aws.qbusiness/ErrorCode)

(s/def :cognitect.aws.qbusiness.CreatePluginResponse/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def :cognitect.aws.qbusiness.CreatePluginResponse/pluginArn :cognitect.aws.qbusiness/PluginArn)

(s/def
  :cognitect.aws.qbusiness.CreatePluginResponse/buildStatus
  :cognitect.aws.qbusiness/PluginBuildStatus)

(s/def
  :cognitect.aws.qbusiness.GetChatResponseConfigurationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetChatResponseConfigurationRequest/chatResponseConfigurationId
  :cognitect.aws.qbusiness/ChatResponseConfigurationId)

(s/def
  :cognitect.aws.qbusiness.InlineDocumentEnrichmentConfiguration/condition
  :cognitect.aws.qbusiness/DocumentAttributeCondition)

(s/def
  :cognitect.aws.qbusiness.InlineDocumentEnrichmentConfiguration/target
  :cognitect.aws.qbusiness/DocumentAttributeTarget)

(s/def
  :cognitect.aws.qbusiness.InlineDocumentEnrichmentConfiguration/documentContentOperator
  :cognitect.aws.qbusiness/DocumentContentOperator)

(s/def
  :cognitect.aws.qbusiness.ListAttachmentsResponse/attachments
  :cognitect.aws.qbusiness/AttachmentList)

(s/def
  :cognitect.aws.qbusiness.ListAttachmentsResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.CreateRetrieverRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.CreateRetrieverRequest/type :cognitect.aws.qbusiness/RetrieverType)

(s/def
  :cognitect.aws.qbusiness.CreateRetrieverRequest/displayName
  :cognitect.aws.qbusiness/RetrieverName)

(s/def
  :cognitect.aws.qbusiness.CreateRetrieverRequest/configuration
  :cognitect.aws.qbusiness/RetrieverConfiguration)

(s/def :cognitect.aws.qbusiness.CreateRetrieverRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.CreateRetrieverRequest/clientToken
  :cognitect.aws.qbusiness/ClientToken)

(s/def :cognitect.aws.qbusiness.CreateRetrieverRequest/tags :cognitect.aws.qbusiness/Tags)

(s/def
  :cognitect.aws.qbusiness.StopDataSourceSyncJobRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.StopDataSourceSyncJobRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.StopDataSourceSyncJobRequest/indexId
  :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.DeleteGroupRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.DeleteGroupRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.DeleteGroupRequest/groupName :cognitect.aws.qbusiness/GroupName)

(s/def
  :cognitect.aws.qbusiness.DeleteGroupRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.PermissionCondition/conditionOperator
  :cognitect.aws.qbusiness/PermissionConditionOperator)

(s/def
  :cognitect.aws.qbusiness.PermissionCondition/conditionKey
  :cognitect.aws.qbusiness/PermissionConditionKey)

(s/def
  :cognitect.aws.qbusiness.PermissionCondition/conditionValues
  :cognitect.aws.qbusiness/PermissionConditionValues)

(s/def
  :cognitect.aws.qbusiness.BlockedPhrasesConfigurationUpdate/blockedPhrasesToCreateOrUpdate
  :cognitect.aws.qbusiness/BlockedPhrases)

(s/def
  :cognitect.aws.qbusiness.BlockedPhrasesConfigurationUpdate/blockedPhrasesToDelete
  :cognitect.aws.qbusiness/BlockedPhrases)

(s/def
  :cognitect.aws.qbusiness.BlockedPhrasesConfigurationUpdate/systemMessageOverride
  :cognitect.aws.qbusiness/SystemMessageOverride)

(s/def
  :cognitect.aws.qbusiness.QuickSightConfiguration/clientNamespace
  :cognitect.aws.qbusiness/ClientNamespace)

(s/def
  :cognitect.aws.qbusiness.DeleteWebExperienceRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.DeleteWebExperienceRequest/webExperienceId
  :cognitect.aws.qbusiness/WebExperienceId)

(s/def :cognitect.aws.qbusiness.ActionSummary/actionIdentifier :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.ActionSummary/displayName :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.ActionSummary/instructionExample :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.ActionSummary/description :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.TextDocumentStatistics/indexedTextBytes
  :cognitect.aws.qbusiness/IndexedTextBytes)

(s/def
  :cognitect.aws.qbusiness.TextDocumentStatistics/indexedTextDocumentCount
  :cognitect.aws.qbusiness/IndexedTextDocument)

(s/def
  :cognitect.aws.qbusiness.TextOutputEvent/systemMessageType
  :cognitect.aws.qbusiness/SystemMessageType)

(s/def
  :cognitect.aws.qbusiness.TextOutputEvent/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.TextOutputEvent/userMessageId :cognitect.aws.qbusiness/MessageId)

(s/def :cognitect.aws.qbusiness.TextOutputEvent/systemMessageId :cognitect.aws.qbusiness/MessageId)

(s/def :cognitect.aws.qbusiness.TextOutputEvent/systemMessage :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceRequest/webExperienceId
  :cognitect.aws.qbusiness/WebExperienceId)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeCondition/key
  :cognitect.aws.qbusiness/DocumentAttributeKey)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeCondition/operator
  :cognitect.aws.qbusiness/DocumentEnrichmentConditionOperator)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeCondition/value
  :cognitect.aws.qbusiness/DocumentAttributeValue)

(s/def
  :cognitect.aws.qbusiness.CancelSubscriptionResponse/subscriptionArn
  :cognitect.aws.qbusiness/SubscriptionArn)

(s/def
  :cognitect.aws.qbusiness.CancelSubscriptionResponse/currentSubscription
  :cognitect.aws.qbusiness/SubscriptionDetails)

(s/def
  :cognitect.aws.qbusiness.CancelSubscriptionResponse/nextSubscription
  :cognitect.aws.qbusiness/SubscriptionDetails)

(s/def
  :cognitect.aws.qbusiness.MetadataEvent/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.MetadataEvent/userMessageId :cognitect.aws.qbusiness/MessageId)

(s/def :cognitect.aws.qbusiness.MetadataEvent/systemMessageId :cognitect.aws.qbusiness/MessageId)

(s/def
  :cognitect.aws.qbusiness.MetadataEvent/sourceAttributions
  :cognitect.aws.qbusiness/SourceAttributions)

(s/def :cognitect.aws.qbusiness.MetadataEvent/finalTextMessage :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.AccessConfiguration/accessControls
  :cognitect.aws.qbusiness/AccessControls)

(s/def
  :cognitect.aws.qbusiness.AccessConfiguration/memberRelation
  :cognitect.aws.qbusiness/MemberRelation)

(s/def
  :cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/displayName
  :cognitect.aws.qbusiness/DisplayName)

(s/def
  :cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/clientToken
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/responseConfigurations
  :cognitect.aws.qbusiness/ResponseConfigurations)

(s/def
  :cognitect.aws.qbusiness.CreateChatResponseConfigurationRequest/tags
  :cognitect.aws.qbusiness/Tags)

(s/def
  :cognitect.aws.qbusiness.HookConfiguration/invocationCondition
  :cognitect.aws.qbusiness/DocumentAttributeCondition)

(s/def :cognitect.aws.qbusiness.HookConfiguration/lambdaArn :cognitect.aws.qbusiness/LambdaArn)

(s/def
  :cognitect.aws.qbusiness.HookConfiguration/s3BucketName
  :cognitect.aws.qbusiness/S3BucketName)

(s/def :cognitect.aws.qbusiness.HookConfiguration/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def :cognitect.aws.qbusiness.UsersAndGroups/userIds :cognitect.aws.qbusiness/UserIds)

(s/def :cognitect.aws.qbusiness.UsersAndGroups/userGroups :cognitect.aws.qbusiness/UserGroups)

(s/def :cognitect.aws.qbusiness.Message/messageId :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.Message/body :cognitect.aws.qbusiness/MessageBody)

(s/def :cognitect.aws.qbusiness.Message/time :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.Message/type :cognitect.aws.qbusiness/MessageType)

(s/def :cognitect.aws.qbusiness.Message/attachments :cognitect.aws.qbusiness/AttachmentsOutput)

(s/def
  :cognitect.aws.qbusiness.Message/sourceAttribution
  :cognitect.aws.qbusiness/SourceAttributions)

(s/def :cognitect.aws.qbusiness.Message/actionReview :cognitect.aws.qbusiness/ActionReview)

(s/def :cognitect.aws.qbusiness.Message/actionExecution :cognitect.aws.qbusiness/ActionExecution)

(s/def
  :cognitect.aws.qbusiness.ActionReviewEvent/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.ActionReviewEvent/userMessageId :cognitect.aws.qbusiness/MessageId)

(s/def
  :cognitect.aws.qbusiness.ActionReviewEvent/systemMessageId
  :cognitect.aws.qbusiness/MessageId)

(s/def :cognitect.aws.qbusiness.ActionReviewEvent/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def :cognitect.aws.qbusiness.ActionReviewEvent/pluginType :cognitect.aws.qbusiness/PluginType)

(s/def
  :cognitect.aws.qbusiness.ActionReviewEvent/payload
  :cognitect.aws.qbusiness/ActionReviewPayload)

(s/def
  :cognitect.aws.qbusiness.ActionReviewEvent/payloadFieldNameSeparator
  :cognitect.aws.qbusiness/ActionPayloadFieldNameSeparator)

(s/def :cognitect.aws.qbusiness.PrincipalUser/id :cognitect.aws.qbusiness/UserId)

(s/def :cognitect.aws.qbusiness.PrincipalUser/access :cognitect.aws.qbusiness/ReadAccessType)

(s/def
  :cognitect.aws.qbusiness.PrincipalUser/membershipType
  :cognitect.aws.qbusiness/MembershipType)

(s/def :cognitect.aws.qbusiness.GroupSummary/groupName :cognitect.aws.qbusiness/GroupName)

(s/def :cognitect.aws.qbusiness.DataSourceSyncJob/executionId :cognitect.aws.qbusiness/ExecutionId)

(s/def :cognitect.aws.qbusiness.DataSourceSyncJob/startTime :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.DataSourceSyncJob/endTime :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.DataSourceSyncJob/status
  :cognitect.aws.qbusiness/DataSourceSyncJobStatus)

(s/def :cognitect.aws.qbusiness.DataSourceSyncJob/error :cognitect.aws.qbusiness/ErrorDetail)

(s/def
  :cognitect.aws.qbusiness.DataSourceSyncJob/dataSourceErrorCode
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.DataSourceSyncJob/metrics
  :cognitect.aws.qbusiness/DataSourceSyncJobMetrics)

(s/def
  :cognitect.aws.qbusiness.CustomizationConfiguration/customCSSUrl
  :cognitect.aws.qbusiness/CustomCSSUrl)

(s/def :cognitect.aws.qbusiness.CustomizationConfiguration/logoUrl :cognitect.aws.qbusiness/LogoUrl)

(s/def :cognitect.aws.qbusiness.CustomizationConfiguration/fontUrl :cognitect.aws.qbusiness/FontUrl)

(s/def
  :cognitect.aws.qbusiness.CustomizationConfiguration/faviconUrl
  :cognitect.aws.qbusiness/FaviconUrl)

(s/def :cognitect.aws.qbusiness.SourceAttribution/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.SourceAttribution/citationNumber :cognitect.aws.qbusiness/Integer)

(s/def :cognitect.aws.qbusiness.SourceAttribution/snippet :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.SourceAttribution/textMessageSegments
  :cognitect.aws.qbusiness/TextSegmentList)

(s/def :cognitect.aws.qbusiness.SourceAttribution/title :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.SourceAttribution/documentId :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.SourceAttribution/indexId :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.SourceAttribution/url :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.SourceAttribution/datasourceId :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.CheckDocumentAccessResponse/userGroups
  :cognitect.aws.qbusiness/AssociatedGroups)

(s/def
  :cognitect.aws.qbusiness.CheckDocumentAccessResponse/userAliases
  :cognitect.aws.qbusiness/AssociatedUsers)

(s/def
  :cognitect.aws.qbusiness.CheckDocumentAccessResponse/hasAccess
  :cognitect.aws.qbusiness/Boolean)

(s/def
  :cognitect.aws.qbusiness.CheckDocumentAccessResponse/documentAcl
  :cognitect.aws.qbusiness/DocumentAcl)

(s/def :cognitect.aws.qbusiness.GetRetrieverResponse/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.GetRetrieverResponse/displayName
  :cognitect.aws.qbusiness/RetrieverName)

(s/def :cognitect.aws.qbusiness.GetRetrieverResponse/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.GetRetrieverResponse/type :cognitect.aws.qbusiness/RetrieverType)

(s/def
  :cognitect.aws.qbusiness.GetRetrieverResponse/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetRetrieverResponse/status
  :cognitect.aws.qbusiness/RetrieverStatus)

(s/def
  :cognitect.aws.qbusiness.GetRetrieverResponse/configuration
  :cognitect.aws.qbusiness/RetrieverConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetRetrieverResponse/retrieverId
  :cognitect.aws.qbusiness/RetrieverId)

(s/def
  :cognitect.aws.qbusiness.GetRetrieverResponse/retrieverArn
  :cognitect.aws.qbusiness/RetrieverArn)

(s/def :cognitect.aws.qbusiness.GetRetrieverResponse/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.DocumentAclCondition/memberRelation
  :cognitect.aws.qbusiness/MemberRelation)

(s/def
  :cognitect.aws.qbusiness.DocumentAclCondition/users
  :cognitect.aws.qbusiness/DocumentAclUsers)

(s/def
  :cognitect.aws.qbusiness.DocumentAclCondition/groups
  :cognitect.aws.qbusiness/DocumentAclGroups)

(s/def :cognitect.aws.qbusiness.GetUserResponse/userAliases :cognitect.aws.qbusiness/UserAliases)

(s/def
  :cognitect.aws.qbusiness.StringAttributeBoostingConfiguration/boostingLevel
  :cognitect.aws.qbusiness/DocumentAttributeBoostingLevel)

(s/def
  :cognitect.aws.qbusiness.StringAttributeBoostingConfiguration/attributeValueBoosting
  :cognitect.aws.qbusiness/StringAttributeValueBoosting)

(s/def :cognitect.aws.qbusiness.ValidationException/message :cognitect.aws.qbusiness/ErrorMessage)

(s/def
  :cognitect.aws.qbusiness.ValidationException/reason
  :cognitect.aws.qbusiness/ValidationExceptionReason)

(s/def
  :cognitect.aws.qbusiness.ValidationException/fields
  :cognitect.aws.qbusiness/ValidationExceptionFields)

(s/def
  :cognitect.aws.qbusiness.ListPluginTypeMetadataRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListPluginTypeMetadataRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListPluginTypeMetadata)

(s/def :cognitect.aws.qbusiness.GetMediaResponse/mediaBytes :cognitect.aws.qbusiness/Blob)

(s/def :cognitect.aws.qbusiness.GetMediaResponse/mediaMimeType :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.AccessDeniedException/message :cognitect.aws.qbusiness/ErrorMessage)

(s/def
  :cognitect.aws.qbusiness.SamlConfiguration/metadataXML
  :cognitect.aws.qbusiness/SamlMetadataXML)

(s/def :cognitect.aws.qbusiness.SamlConfiguration/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.SamlConfiguration/userIdAttribute
  :cognitect.aws.qbusiness/SamlAttribute)

(s/def
  :cognitect.aws.qbusiness.SamlConfiguration/userGroupAttribute
  :cognitect.aws.qbusiness/SamlAttribute)

(s/def :cognitect.aws.qbusiness.GetIndexResponse/description :cognitect.aws.qbusiness/Description)

(s/def
  :cognitect.aws.qbusiness.GetIndexResponse/capacityConfiguration
  :cognitect.aws.qbusiness/IndexCapacityConfiguration)

(s/def :cognitect.aws.qbusiness.GetIndexResponse/indexArn :cognitect.aws.qbusiness/IndexArn)

(s/def :cognitect.aws.qbusiness.GetIndexResponse/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.GetIndexResponse/displayName :cognitect.aws.qbusiness/IndexName)

(s/def :cognitect.aws.qbusiness.GetIndexResponse/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.GetIndexResponse/type :cognitect.aws.qbusiness/IndexType)

(s/def
  :cognitect.aws.qbusiness.GetIndexResponse/indexStatistics
  :cognitect.aws.qbusiness/IndexStatistics)

(s/def
  :cognitect.aws.qbusiness.GetIndexResponse/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.GetIndexResponse/status :cognitect.aws.qbusiness/IndexStatus)

(s/def :cognitect.aws.qbusiness.GetIndexResponse/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.GetIndexResponse/error :cognitect.aws.qbusiness/ErrorDetail)

(s/def
  :cognitect.aws.qbusiness.GetIndexResponse/documentAttributeConfigurations
  :cognitect.aws.qbusiness/DocumentAttributeConfigurations)

(s/def :cognitect.aws.qbusiness.CreateWebExperienceRequest/tags :cognitect.aws.qbusiness/Tags)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/origins
  :cognitect.aws.qbusiness/WebExperienceOrigins)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/welcomeMessage
  :cognitect.aws.qbusiness/WebExperienceWelcomeMessage)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/browserExtensionConfiguration
  :cognitect.aws.qbusiness/BrowserExtensionConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/title
  :cognitect.aws.qbusiness/WebExperienceTitle)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/customizationConfiguration
  :cognitect.aws.qbusiness/CustomizationConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/subtitle
  :cognitect.aws.qbusiness/WebExperienceSubtitle)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/identityProviderConfiguration
  :cognitect.aws.qbusiness/IdentityProviderConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/clientToken
  :cognitect.aws.qbusiness/ClientToken)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceRequest/samplePromptsControlMode
  :cognitect.aws.qbusiness/WebExperienceSamplePromptsControlMode)

(s/def :cognitect.aws.qbusiness.CreateWebExperienceRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.AttachmentInputEvent/attachment
  :cognitect.aws.qbusiness/AttachmentInput)

(s/def
  :cognitect.aws.qbusiness.GetIndexRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.GetIndexRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationResponse/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationResponse/applicationArn
  :cognitect.aws.qbusiness/ApplicationArn)

(s/def
  :cognitect.aws.qbusiness.ContentSource/retriever
  :cognitect.aws.qbusiness/RetrieverContentSource)

(s/def
  :cognitect.aws.qbusiness.ListApplicationsResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListApplicationsResponse/applications
  :cognitect.aws.qbusiness/Applications)

(s/def :cognitect.aws.qbusiness.UserAlias/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.UserAlias/dataSourceId :cognitect.aws.qbusiness/DataSourceId)

(s/def :cognitect.aws.qbusiness.UserAlias/userId :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.AttributeFilter/andAllFilters
  :cognitect.aws.qbusiness/AttributeFilters)

(s/def
  :cognitect.aws.qbusiness.AttributeFilter/greaterThan
  :cognitect.aws.qbusiness/DocumentAttribute)

(s/def
  :cognitect.aws.qbusiness.AttributeFilter/greaterThanOrEquals
  :cognitect.aws.qbusiness/DocumentAttribute)

(s/def :cognitect.aws.qbusiness.AttributeFilter/equalsTo :cognitect.aws.qbusiness/DocumentAttribute)

(s/def
  :cognitect.aws.qbusiness.AttributeFilter/orAllFilters
  :cognitect.aws.qbusiness/AttributeFilters)

(s/def
  :cognitect.aws.qbusiness.AttributeFilter/containsAll
  :cognitect.aws.qbusiness/DocumentAttribute)

(s/def
  :cognitect.aws.qbusiness.AttributeFilter/lessThanOrEquals
  :cognitect.aws.qbusiness/DocumentAttribute)

(s/def
  :cognitect.aws.qbusiness.AttributeFilter/containsAny
  :cognitect.aws.qbusiness/DocumentAttribute)

(s/def :cognitect.aws.qbusiness.AttributeFilter/notFilter :cognitect.aws.qbusiness/AttributeFilter)

(s/def :cognitect.aws.qbusiness.AttributeFilter/lessThan :cognitect.aws.qbusiness/DocumentAttribute)

(s/def
  :cognitect.aws.qbusiness.ListPluginTypeMetadataResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListPluginTypeMetadataResponse/items
  :cognitect.aws.qbusiness/ListPluginTypeMetadataSummaries)

(s/def
  :cognitect.aws.qbusiness.WebExperience/webExperienceId
  :cognitect.aws.qbusiness/WebExperienceId)

(s/def :cognitect.aws.qbusiness.WebExperience/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.WebExperience/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.WebExperience/defaultEndpoint :cognitect.aws.qbusiness/Url)

(s/def :cognitect.aws.qbusiness.WebExperience/status :cognitect.aws.qbusiness/WebExperienceStatus)

(s/def :cognitect.aws.qbusiness.ListPluginsResponse/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def :cognitect.aws.qbusiness.ListPluginsResponse/plugins :cognitect.aws.qbusiness/Plugins)

(s/def :cognitect.aws.qbusiness.PluginConfiguration/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def
  :cognitect.aws.qbusiness.CreateSubscriptionResponse/subscriptionId
  :cognitect.aws.qbusiness/SubscriptionId)

(s/def
  :cognitect.aws.qbusiness.CreateSubscriptionResponse/subscriptionArn
  :cognitect.aws.qbusiness/SubscriptionArn)

(s/def
  :cognitect.aws.qbusiness.CreateSubscriptionResponse/currentSubscription
  :cognitect.aws.qbusiness/SubscriptionDetails)

(s/def
  :cognitect.aws.qbusiness.CreateSubscriptionResponse/nextSubscription
  :cognitect.aws.qbusiness/SubscriptionDetails)

(s/def
  :cognitect.aws.qbusiness.BrowserExtensionConfiguration/enabledBrowserExtensions
  :cognitect.aws.qbusiness/BrowserExtensionList)

(s/def
  :cognitect.aws.qbusiness.DeleteConversationRequest/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def
  :cognitect.aws.qbusiness.DeleteConversationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.DeleteConversationRequest/userId :cognitect.aws.qbusiness/UserId)

(s/def :cognitect.aws.qbusiness.PrincipalGroup/name :cognitect.aws.qbusiness/GroupName)

(s/def :cognitect.aws.qbusiness.PrincipalGroup/access :cognitect.aws.qbusiness/ReadAccessType)

(s/def
  :cognitect.aws.qbusiness.PrincipalGroup/membershipType
  :cognitect.aws.qbusiness/MembershipType)

(s/def
  :cognitect.aws.qbusiness.DocumentAclMembership/memberRelation
  :cognitect.aws.qbusiness/MemberRelation)

(s/def
  :cognitect.aws.qbusiness.DocumentAclMembership/conditions
  :cognitect.aws.qbusiness/DocumentAclConditions)

(s/def
  :cognitect.aws.qbusiness.AudioExtractionConfiguration/audioExtractionStatus
  :cognitect.aws.qbusiness/AudioExtractionStatus)

(s/def
  :cognitect.aws.qbusiness.SourceDetails/imageSourceDetails
  :cognitect.aws.qbusiness/ImageSourceDetails)

(s/def
  :cognitect.aws.qbusiness.SourceDetails/audioSourceDetails
  :cognitect.aws.qbusiness/AudioSourceDetails)

(s/def
  :cognitect.aws.qbusiness.SourceDetails/videoSourceDetails
  :cognitect.aws.qbusiness/VideoSourceDetails)

(s/def
  :cognitect.aws.qbusiness.UpdateSubscriptionRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.UpdateSubscriptionRequest/subscriptionId
  :cognitect.aws.qbusiness/SubscriptionId)

(s/def
  :cognitect.aws.qbusiness.UpdateSubscriptionRequest/type
  :cognitect.aws.qbusiness/SubscriptionType)

(s/def :cognitect.aws.qbusiness.TextInputEvent/userMessage :cognitect.aws.qbusiness/UserMessage)

(s/def
  :cognitect.aws.qbusiness.ListAttachmentsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.ListAttachmentsRequest/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.ListAttachmentsRequest/userId :cognitect.aws.qbusiness/UserId)

(s/def :cognitect.aws.qbusiness.ListAttachmentsRequest/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListAttachmentsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListAttachments)

(s/def :cognitect.aws.qbusiness.DocumentDetails/documentId :cognitect.aws.qbusiness/DocumentId)

(s/def :cognitect.aws.qbusiness.DocumentDetails/status :cognitect.aws.qbusiness/DocumentStatus)

(s/def :cognitect.aws.qbusiness.DocumentDetails/error :cognitect.aws.qbusiness/ErrorDetail)

(s/def :cognitect.aws.qbusiness.DocumentDetails/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.DocumentDetails/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.AssociatedUser/id :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.AssociatedUser/type :cognitect.aws.qbusiness/MembershipType)

(s/def
  :cognitect.aws.qbusiness.BlockedPhrasesConfiguration/blockedPhrases
  :cognitect.aws.qbusiness/BlockedPhrases)

(s/def
  :cognitect.aws.qbusiness.BlockedPhrasesConfiguration/systemMessageOverride
  :cognitect.aws.qbusiness/SystemMessageOverride)

(s/def :cognitect.aws.qbusiness.Index/displayName :cognitect.aws.qbusiness/IndexName)

(s/def :cognitect.aws.qbusiness.Index/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.Index/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.Index/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.Index/status :cognitect.aws.qbusiness/IndexStatus)

(s/def :cognitect.aws.qbusiness.ChatOutputStream/textEvent :cognitect.aws.qbusiness/TextOutputEvent)

(s/def
  :cognitect.aws.qbusiness.ChatOutputStream/metadataEvent
  :cognitect.aws.qbusiness/MetadataEvent)

(s/def
  :cognitect.aws.qbusiness.ChatOutputStream/actionReviewEvent
  :cognitect.aws.qbusiness/ActionReviewEvent)

(s/def
  :cognitect.aws.qbusiness.ChatOutputStream/failedAttachmentEvent
  :cognitect.aws.qbusiness/FailedAttachmentEvent)

(s/def
  :cognitect.aws.qbusiness.ChatOutputStream/authChallengeRequestEvent
  :cognitect.aws.qbusiness/AuthChallengeRequestEvent)

(s/def
  :cognitect.aws.qbusiness.GetRetrieverRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetRetrieverRequest/retrieverId
  :cognitect.aws.qbusiness/RetrieverId)

(s/def
  :cognitect.aws.qbusiness.CreateDataAccessorRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.CreateDataAccessorRequest/principal
  :cognitect.aws.qbusiness/PrincipalRoleArn)

(s/def
  :cognitect.aws.qbusiness.CreateDataAccessorRequest/actionConfigurations
  :cognitect.aws.qbusiness/ActionConfigurationList)

(s/def
  :cognitect.aws.qbusiness.CreateDataAccessorRequest/clientToken
  :cognitect.aws.qbusiness/ClientToken)

(s/def
  :cognitect.aws.qbusiness.CreateDataAccessorRequest/displayName
  :cognitect.aws.qbusiness/DataAccessorName)

(s/def
  :cognitect.aws.qbusiness.CreateDataAccessorRequest/authenticationDetail
  :cognitect.aws.qbusiness/DataAccessorAuthenticationDetail)

(s/def :cognitect.aws.qbusiness.CreateDataAccessorRequest/tags :cognitect.aws.qbusiness/Tags)

(s/def
  :cognitect.aws.qbusiness.UpdatePluginRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.UpdatePluginRequest/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def :cognitect.aws.qbusiness.UpdatePluginRequest/displayName :cognitect.aws.qbusiness/PluginName)

(s/def :cognitect.aws.qbusiness.UpdatePluginRequest/state :cognitect.aws.qbusiness/PluginState)

(s/def :cognitect.aws.qbusiness.UpdatePluginRequest/serverUrl :cognitect.aws.qbusiness/Url)

(s/def
  :cognitect.aws.qbusiness.UpdatePluginRequest/customPluginConfiguration
  :cognitect.aws.qbusiness/CustomPluginConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdatePluginRequest/authConfiguration
  :cognitect.aws.qbusiness/PluginAuthConfiguration)

(s/def
  :cognitect.aws.qbusiness.ListConversationsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ListConversationsRequest/userId :cognitect.aws.qbusiness/UserId)

(s/def
  :cognitect.aws.qbusiness.ListConversationsRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListConversationsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListConversations)

(s/def :cognitect.aws.qbusiness.TextSegment/beginOffset :cognitect.aws.qbusiness/Integer)

(s/def :cognitect.aws.qbusiness.TextSegment/endOffset :cognitect.aws.qbusiness/Integer)

(s/def :cognitect.aws.qbusiness.TextSegment/snippetExcerpt :cognitect.aws.qbusiness/SnippetExcerpt)

(s/def
  :cognitect.aws.qbusiness.TextSegment/mediaId
  :cognitect.aws.qbusiness/SourceAttributionMediaId)

(s/def :cognitect.aws.qbusiness.TextSegment/mediaMimeType :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.TextSegment/sourceDetails :cognitect.aws.qbusiness/SourceDetails)

(s/def :cognitect.aws.qbusiness.AuthChallengeRequest/authorizationUrl :cognitect.aws.qbusiness/Url)

(s/def
  :cognitect.aws.qbusiness.TopicConfiguration/name
  :cognitect.aws.qbusiness/TopicConfigurationName)

(s/def
  :cognitect.aws.qbusiness.TopicConfiguration/description
  :cognitect.aws.qbusiness/TopicDescription)

(s/def
  :cognitect.aws.qbusiness.TopicConfiguration/exampleChatMessages
  :cognitect.aws.qbusiness/ExampleChatMessages)

(s/def :cognitect.aws.qbusiness.TopicConfiguration/rules :cognitect.aws.qbusiness/Rules)

(s/def
  :cognitect.aws.qbusiness.ListPluginsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ListPluginsRequest/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListPluginsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListPlugins)

(s/def
  :cognitect.aws.qbusiness.CopyFromSource/conversation
  :cognitect.aws.qbusiness/ConversationSource)

(s/def :cognitect.aws.qbusiness.SubscriptionDetails/type :cognitect.aws.qbusiness/SubscriptionType)

(s/def
  :cognitect.aws.qbusiness.UpdateIndexRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.UpdateIndexRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.UpdateIndexRequest/displayName
  :cognitect.aws.qbusiness/ApplicationName)

(s/def :cognitect.aws.qbusiness.UpdateIndexRequest/description :cognitect.aws.qbusiness/Description)

(s/def
  :cognitect.aws.qbusiness.UpdateIndexRequest/capacityConfiguration
  :cognitect.aws.qbusiness/IndexCapacityConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateIndexRequest/documentAttributeConfigurations
  :cognitect.aws.qbusiness/DocumentAttributeConfigurations)

(s/def
  :cognitect.aws.qbusiness.GetDocumentContentRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.GetDocumentContentRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.GetDocumentContentRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.GetDocumentContentRequest/documentId
  :cognitect.aws.qbusiness/DocumentId)

(s/def
  :cognitect.aws.qbusiness.GetDocumentContentRequest/outputFormat
  :cognitect.aws.qbusiness/OutputFormat)

(s/def
  :cognitect.aws.qbusiness.ScoreAttributes/scoreConfidence
  :cognitect.aws.qbusiness/ScoreConfidence)

(s/def
  :cognitect.aws.qbusiness.HallucinationReductionConfiguration/hallucinationReductionControl
  :cognitect.aws.qbusiness/HallucinationReductionControl)

(s/def
  :cognitect.aws.qbusiness.BatchPutDocumentResponse/failedDocuments
  :cognitect.aws.qbusiness/FailedDocuments)

(s/def :cognitect.aws.qbusiness.ChatInput/applicationId :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ChatInput/userId :cognitect.aws.qbusiness/UserId)

(s/def :cognitect.aws.qbusiness.ChatInput/userGroups :cognitect.aws.qbusiness/UserGroups)

(s/def :cognitect.aws.qbusiness.ChatInput/conversationId :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.ChatInput/parentMessageId :cognitect.aws.qbusiness/MessageId)

(s/def :cognitect.aws.qbusiness.ChatInput/clientToken :cognitect.aws.qbusiness/ClientToken)

(s/def :cognitect.aws.qbusiness.ChatInput/inputStream :cognitect.aws.qbusiness/ChatInputStream)

(s/def
  :cognitect.aws.qbusiness.StringListAttributeBoostingConfiguration/boostingLevel
  :cognitect.aws.qbusiness/DocumentAttributeBoostingLevel)

(s/def
  :cognitect.aws.qbusiness.CreateChatResponseConfigurationResponse/chatResponseConfigurationId
  :cognitect.aws.qbusiness/ChatResponseConfigurationId)

(s/def
  :cognitect.aws.qbusiness.CreateChatResponseConfigurationResponse/chatResponseConfigurationArn
  :cognitect.aws.qbusiness/ChatResponseConfigurationArn)

(s/def :cognitect.aws.qbusiness.DocumentAclUser/id :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.DocumentAclUser/type :cognitect.aws.qbusiness/MembershipType)

(s/def
  :cognitect.aws.qbusiness.CheckDocumentAccessRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.CheckDocumentAccessRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.CheckDocumentAccessRequest/userId :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.CheckDocumentAccessRequest/documentId
  :cognitect.aws.qbusiness/DocumentId)

(s/def
  :cognitect.aws.qbusiness.CheckDocumentAccessRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/chatResponseConfigurationId
  :cognitect.aws.qbusiness/ChatResponseConfigurationId)

(s/def
  :cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/displayName
  :cognitect.aws.qbusiness/DisplayName)

(s/def
  :cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/responseConfigurations
  :cognitect.aws.qbusiness/ResponseConfigurations)

(s/def
  :cognitect.aws.qbusiness.UpdateChatResponseConfigurationRequest/clientToken
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/origins
  :cognitect.aws.qbusiness/WebExperienceOrigins)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/defaultEndpoint
  :cognitect.aws.qbusiness/Url)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/updatedAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/welcomeMessage
  :cognitect.aws.qbusiness/WebExperienceWelcomeMessage)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/browserExtensionConfiguration
  :cognitect.aws.qbusiness/BrowserExtensionConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/createdAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/webExperienceId
  :cognitect.aws.qbusiness/WebExperienceId)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/authenticationConfiguration
  :cognitect.aws.qbusiness/WebExperienceAuthConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/title
  :cognitect.aws.qbusiness/WebExperienceTitle)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/customizationConfiguration
  :cognitect.aws.qbusiness/CustomizationConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/status
  :cognitect.aws.qbusiness/WebExperienceStatus)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/subtitle
  :cognitect.aws.qbusiness/WebExperienceSubtitle)

(s/def :cognitect.aws.qbusiness.GetWebExperienceResponse/error :cognitect.aws.qbusiness/ErrorDetail)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/identityProviderConfiguration
  :cognitect.aws.qbusiness/IdentityProviderConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/samplePromptsControlMode
  :cognitect.aws.qbusiness/WebExperienceSamplePromptsControlMode)

(s/def
  :cognitect.aws.qbusiness.GetWebExperienceResponse/webExperienceArn
  :cognitect.aws.qbusiness/WebExperienceArn)

(s/def :cognitect.aws.qbusiness.GetWebExperienceResponse/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.ContentBlockerRule/systemMessageOverride
  :cognitect.aws.qbusiness/SystemMessageOverride)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/description
  :cognitect.aws.qbusiness/Description)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/qAppsConfiguration
  :cognitect.aws.qbusiness/QAppsConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/identityCenterApplicationArn
  :cognitect.aws.qbusiness/IdcApplicationArn)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/autoSubscriptionConfiguration
  :cognitect.aws.qbusiness/AutoSubscriptionConfiguration)

(s/def :cognitect.aws.qbusiness.GetApplicationResponse/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/clientIdsForOIDC
  :cognitect.aws.qbusiness/ClientIdsForOIDC)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/displayName
  :cognitect.aws.qbusiness/ApplicationName)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/quickSightConfiguration
  :cognitect.aws.qbusiness/QuickSightConfiguration)

(s/def :cognitect.aws.qbusiness.GetApplicationResponse/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/personalizationConfiguration
  :cognitect.aws.qbusiness/PersonalizationConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/attachmentsConfiguration
  :cognitect.aws.qbusiness/AppliedAttachmentsConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/iamIdentityProviderArn
  :cognitect.aws.qbusiness/IAMIdentityProviderArn)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/status
  :cognitect.aws.qbusiness/ApplicationStatus)

(s/def :cognitect.aws.qbusiness.GetApplicationResponse/error :cognitect.aws.qbusiness/ErrorDetail)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/encryptionConfiguration
  :cognitect.aws.qbusiness/EncryptionConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/applicationArn
  :cognitect.aws.qbusiness/ApplicationArn)

(s/def
  :cognitect.aws.qbusiness.GetApplicationResponse/identityType
  :cognitect.aws.qbusiness/IdentityType)

(s/def :cognitect.aws.qbusiness.GetApplicationResponse/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def :cognitect.aws.qbusiness.SubscriptionPrincipal/user :cognitect.aws.qbusiness/UserIdentifier)

(s/def
  :cognitect.aws.qbusiness.SubscriptionPrincipal/group
  :cognitect.aws.qbusiness/GroupIdentifier)

(s/def
  :cognitect.aws.qbusiness.CreatePluginRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.CreatePluginRequest/displayName :cognitect.aws.qbusiness/PluginName)

(s/def :cognitect.aws.qbusiness.CreatePluginRequest/type :cognitect.aws.qbusiness/PluginType)

(s/def
  :cognitect.aws.qbusiness.CreatePluginRequest/authConfiguration
  :cognitect.aws.qbusiness/PluginAuthConfiguration)

(s/def :cognitect.aws.qbusiness.CreatePluginRequest/serverUrl :cognitect.aws.qbusiness/Url)

(s/def
  :cognitect.aws.qbusiness.CreatePluginRequest/customPluginConfiguration
  :cognitect.aws.qbusiness/CustomPluginConfiguration)

(s/def :cognitect.aws.qbusiness.CreatePluginRequest/tags :cognitect.aws.qbusiness/Tags)

(s/def
  :cognitect.aws.qbusiness.CreatePluginRequest/clientToken
  :cognitect.aws.qbusiness/ClientToken)

(s/def
  :cognitect.aws.qbusiness.ListPluginTypeActionsResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListPluginTypeActionsResponse/items
  :cognitect.aws.qbusiness/Actions)

(s/def :cognitect.aws.qbusiness.ListMessagesResponse/messages :cognitect.aws.qbusiness/Messages)

(s/def :cognitect.aws.qbusiness.ListMessagesResponse/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListDocumentsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ListDocumentsRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.ListDocumentsRequest/dataSourceIds
  :cognitect.aws.qbusiness/DataSourceIds)

(s/def :cognitect.aws.qbusiness.ListDocumentsRequest/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListDocumentsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListDocuments)

(s/def
  :cognitect.aws.qbusiness.OpenIDConnectProviderConfiguration/secretsArn
  :cognitect.aws.qbusiness/SecretArn)

(s/def
  :cognitect.aws.qbusiness.OpenIDConnectProviderConfiguration/secretsRole
  :cognitect.aws.qbusiness/RoleArn)

(s/def :cognitect.aws.qbusiness.FailedDocument/id :cognitect.aws.qbusiness/DocumentId)

(s/def :cognitect.aws.qbusiness.FailedDocument/error :cognitect.aws.qbusiness/ErrorDetail)

(s/def :cognitect.aws.qbusiness.FailedDocument/dataSourceId :cognitect.aws.qbusiness/DataSourceId)

(s/def :cognitect.aws.qbusiness.MemberGroup/groupName :cognitect.aws.qbusiness/GroupName)

(s/def :cognitect.aws.qbusiness.MemberGroup/type :cognitect.aws.qbusiness/MembershipType)

(s/def :cognitect.aws.qbusiness.GroupStatusDetail/status :cognitect.aws.qbusiness/GroupStatus)

(s/def :cognitect.aws.qbusiness.GroupStatusDetail/lastUpdatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.GroupStatusDetail/errorDetail :cognitect.aws.qbusiness/ErrorDetail)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorRequest/dataAccessorId
  :cognitect.aws.qbusiness/DataAccessorId)

(s/def :cognitect.aws.qbusiness.ImageSourceDetails/mediaId :cognitect.aws.qbusiness/MediaId)

(s/def :cognitect.aws.qbusiness.ImageSourceDetails/mediaMimeType :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.DocumentAcl/allowlist
  :cognitect.aws.qbusiness/DocumentAclMembership)

(s/def :cognitect.aws.qbusiness.DocumentAcl/denyList :cognitect.aws.qbusiness/DocumentAclMembership)

(s/def :cognitect.aws.qbusiness.ActionReview/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def :cognitect.aws.qbusiness.ActionReview/pluginType :cognitect.aws.qbusiness/PluginType)

(s/def :cognitect.aws.qbusiness.ActionReview/payload :cognitect.aws.qbusiness/ActionReviewPayload)

(s/def
  :cognitect.aws.qbusiness.ActionReview/payloadFieldNameSeparator
  :cognitect.aws.qbusiness/ActionPayloadFieldNameSeparator)

(s/def :cognitect.aws.qbusiness.DocumentContent/blob :cognitect.aws.qbusiness/Blob)

(s/def :cognitect.aws.qbusiness.DocumentContent/s3 :cognitect.aws.qbusiness/S3)

(s/def
  :cognitect.aws.qbusiness.CreateDataAccessorResponse/dataAccessorId
  :cognitect.aws.qbusiness/DataAccessorId)

(s/def
  :cognitect.aws.qbusiness.CreateDataAccessorResponse/idcApplicationArn
  :cognitect.aws.qbusiness/IdcApplicationArn)

(s/def
  :cognitect.aws.qbusiness.CreateDataAccessorResponse/dataAccessorArn
  :cognitect.aws.qbusiness/DataAccessorArn)

(s/def
  :cognitect.aws.qbusiness.ListDataSourcesRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ListDataSourcesRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.ListDataSourcesRequest/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListDataSourcesRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListDataSources)

(s/def :cognitect.aws.qbusiness.Subscription/subscriptionId :cognitect.aws.qbusiness/SubscriptionId)

(s/def
  :cognitect.aws.qbusiness.Subscription/subscriptionArn
  :cognitect.aws.qbusiness/SubscriptionArn)

(s/def
  :cognitect.aws.qbusiness.Subscription/principal
  :cognitect.aws.qbusiness/SubscriptionPrincipal)

(s/def
  :cognitect.aws.qbusiness.Subscription/currentSubscription
  :cognitect.aws.qbusiness/SubscriptionDetails)

(s/def
  :cognitect.aws.qbusiness.Subscription/nextSubscription
  :cognitect.aws.qbusiness/SubscriptionDetails)

(s/def
  :cognitect.aws.qbusiness.SearchRelevantContentResponse/relevantContent
  :cognitect.aws.qbusiness/RelevantContentList)

(s/def
  :cognitect.aws.qbusiness.SearchRelevantContentResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def :cognitect.aws.qbusiness.SnippetExcerpt/text :cognitect.aws.qbusiness/SnippetExcerptText)

(s/def :cognitect.aws.qbusiness.GetGroupResponse/status :cognitect.aws.qbusiness/GroupStatusDetail)

(s/def
  :cognitect.aws.qbusiness.GetGroupResponse/statusHistory
  :cognitect.aws.qbusiness/GroupStatusDetails)

(s/def
  :cognitect.aws.qbusiness.AttachmentsConfiguration/attachmentsControlMode
  :cognitect.aws.qbusiness/AttachmentsControlMode)

(s/def
  :cognitect.aws.qbusiness.QAppsConfiguration/qAppsControlMode
  :cognitect.aws.qbusiness/QAppsControlMode)

(s/def :cognitect.aws.qbusiness.ChatSyncInput/userGroups :cognitect.aws.qbusiness/UserGroups)

(s/def
  :cognitect.aws.qbusiness.ChatSyncInput/attributeFilter
  :cognitect.aws.qbusiness/AttributeFilter)

(s/def :cognitect.aws.qbusiness.ChatSyncInput/userMessage :cognitect.aws.qbusiness/UserMessage)

(s/def
  :cognitect.aws.qbusiness.ChatSyncInput/chatModeConfiguration
  :cognitect.aws.qbusiness/ChatModeConfiguration)

(s/def
  :cognitect.aws.qbusiness.ChatSyncInput/actionExecution
  :cognitect.aws.qbusiness/ActionExecution)

(s/def :cognitect.aws.qbusiness.ChatSyncInput/attachments :cognitect.aws.qbusiness/AttachmentsInput)

(s/def :cognitect.aws.qbusiness.ChatSyncInput/applicationId :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ChatSyncInput/chatMode :cognitect.aws.qbusiness/ChatMode)

(s/def :cognitect.aws.qbusiness.ChatSyncInput/userId :cognitect.aws.qbusiness/UserId)

(s/def :cognitect.aws.qbusiness.ChatSyncInput/parentMessageId :cognitect.aws.qbusiness/MessageId)

(s/def
  :cognitect.aws.qbusiness.ChatSyncInput/authChallengeResponse
  :cognitect.aws.qbusiness/AuthChallengeResponse)

(s/def
  :cognitect.aws.qbusiness.ChatSyncInput/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.ChatSyncInput/clientToken :cognitect.aws.qbusiness/ClientToken)

(s/def
  :cognitect.aws.qbusiness.ListTagsForResourceRequest/resourceARN
  :cognitect.aws.qbusiness/AmazonResourceName)

(s/def
  :cognitect.aws.qbusiness.StartDataSourceSyncJobResponse/executionId
  :cognitect.aws.qbusiness/ExecutionId)

(s/def
  :cognitect.aws.qbusiness.DeleteDataSourceRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.DeleteDataSourceRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.DeleteDataSourceRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.WebExperienceAuthConfiguration/samlConfiguration
  :cognitect.aws.qbusiness/SamlConfiguration)

(s/def
  :cognitect.aws.qbusiness.ListWebExperiencesRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.ListWebExperiencesRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListWebExperiencesRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListWebExperiencesRequest)

(s/def
  :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/blockedPhrasesConfigurationUpdate
  :cognitect.aws.qbusiness/BlockedPhrasesConfigurationUpdate)

(s/def
  :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/creatorModeConfiguration
  :cognitect.aws.qbusiness/CreatorModeConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/topicConfigurationsToCreateOrUpdate
  :cognitect.aws.qbusiness/TopicConfigurations)

(s/def
  :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/orchestrationConfiguration
  :cognitect.aws.qbusiness/OrchestrationConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/hallucinationReductionConfiguration
  :cognitect.aws.qbusiness/HallucinationReductionConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/responseScope
  :cognitect.aws.qbusiness/ResponseScope)

(s/def
  :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/clientToken
  :cognitect.aws.qbusiness/ClientToken)

(s/def
  :cognitect.aws.qbusiness.UpdateChatControlsConfigurationRequest/topicConfigurationsToDelete
  :cognitect.aws.qbusiness/TopicConfigurations)

(s/def :cognitect.aws.qbusiness.MemberUser/userId :cognitect.aws.qbusiness/DataSourceUserId)

(s/def :cognitect.aws.qbusiness.MemberUser/type :cognitect.aws.qbusiness/MembershipType)

(s/def
  :cognitect.aws.qbusiness.ListSubscriptionsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.ListSubscriptionsRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListSubscriptionsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListSubscriptions)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/indexId
  :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListDataSourcesSyncJobs)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/startTime
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/endTime
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsRequest/statusFilter
  :cognitect.aws.qbusiness/DataSourceSyncJobStatus)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/responseScope
  :cognitect.aws.qbusiness/ResponseScope)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/orchestrationConfiguration
  :cognitect.aws.qbusiness/AppliedOrchestrationConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/blockedPhrases
  :cognitect.aws.qbusiness/BlockedPhrasesConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/topicConfigurations
  :cognitect.aws.qbusiness/TopicConfigurations)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/creatorModeConfiguration
  :cognitect.aws.qbusiness/AppliedCreatorModeConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationResponse/hallucinationReductionConfiguration
  :cognitect.aws.qbusiness/HallucinationReductionConfiguration)

(s/def
  :cognitect.aws.qbusiness.CustomPluginConfiguration/description
  :cognitect.aws.qbusiness/PluginDescription)

(s/def
  :cognitect.aws.qbusiness.CustomPluginConfiguration/apiSchemaType
  :cognitect.aws.qbusiness/APISchemaType)

(s/def
  :cognitect.aws.qbusiness.CustomPluginConfiguration/apiSchema
  :cognitect.aws.qbusiness/APISchema)

(s/def
  :cognitect.aws.qbusiness.ListGroupsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ListGroupsRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.ListGroupsRequest/updatedEarlierThan
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.ListGroupsRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def :cognitect.aws.qbusiness.ListGroupsRequest/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListGroupsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListGroupsRequest)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsResponse/history
  :cognitect.aws.qbusiness/DataSourceSyncJobs)

(s/def
  :cognitect.aws.qbusiness.ListDataSourceSyncJobsResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.DeleteUserRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.DeleteUserRequest/userId :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.ChatModeConfiguration/pluginConfiguration
  :cognitect.aws.qbusiness/PluginConfiguration)

(s/def
  :cognitect.aws.qbusiness.StartDataSourceSyncJobRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.StartDataSourceSyncJobRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.StartDataSourceSyncJobRequest/indexId
  :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.UpdateSubscriptionResponse/subscriptionArn
  :cognitect.aws.qbusiness/SubscriptionArn)

(s/def
  :cognitect.aws.qbusiness.UpdateSubscriptionResponse/currentSubscription
  :cognitect.aws.qbusiness/SubscriptionDetails)

(s/def
  :cognitect.aws.qbusiness.UpdateSubscriptionResponse/nextSubscription
  :cognitect.aws.qbusiness/SubscriptionDetails)

(s/def
  :cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsAdded
  :cognitect.aws.qbusiness/MetricValue)

(s/def
  :cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsModified
  :cognitect.aws.qbusiness/MetricValue)

(s/def
  :cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsDeleted
  :cognitect.aws.qbusiness/MetricValue)

(s/def
  :cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsFailed
  :cognitect.aws.qbusiness/MetricValue)

(s/def
  :cognitect.aws.qbusiness.DataSourceSyncJobMetrics/documentsScanned
  :cognitect.aws.qbusiness/MetricValue)

(s/def
  :cognitect.aws.qbusiness.CreateAnonymousWebExperienceUrlRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.CreateAnonymousWebExperienceUrlRequest/webExperienceId
  :cognitect.aws.qbusiness/WebExperienceId)

(s/def
  :cognitect.aws.qbusiness.CreateAnonymousWebExperienceUrlRequest/sessionDurationInMinutes
  :cognitect.aws.qbusiness/SessionDurationInMinutes)

(s/def
  :cognitect.aws.qbusiness.CreateUserRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.CreateUserRequest/userId :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.CreateUserRequest/userAliases
  :cognitect.aws.qbusiness/CreateUserRequestUserAliasesList)

(s/def :cognitect.aws.qbusiness.CreateUserRequest/clientToken :cognitect.aws.qbusiness/ClientToken)

(s/def
  :cognitect.aws.qbusiness.DisassociatePermissionRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.DisassociatePermissionRequest/statementId
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.AuthChallengeRequestEvent/authorizationUrl
  :cognitect.aws.qbusiness/Url)

(s/def
  :cognitect.aws.qbusiness.ActionExecutionPayloadField/value
  :cognitect.aws.qbusiness/ActionPayloadFieldValue)

(s/def
  :cognitect.aws.qbusiness.GetDocumentContentResponse/presignedUrl
  :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.GetDocumentContentResponse/mimeType :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.UpdateApplicationRequest/description
  :cognitect.aws.qbusiness/Description)

(s/def
  :cognitect.aws.qbusiness.UpdateApplicationRequest/qAppsConfiguration
  :cognitect.aws.qbusiness/QAppsConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateApplicationRequest/autoSubscriptionConfiguration
  :cognitect.aws.qbusiness/AutoSubscriptionConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateApplicationRequest/identityCenterInstanceArn
  :cognitect.aws.qbusiness/InstanceArn)

(s/def
  :cognitect.aws.qbusiness.UpdateApplicationRequest/displayName
  :cognitect.aws.qbusiness/ApplicationName)

(s/def
  :cognitect.aws.qbusiness.UpdateApplicationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.UpdateApplicationRequest/personalizationConfiguration
  :cognitect.aws.qbusiness/PersonalizationConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateApplicationRequest/attachmentsConfiguration
  :cognitect.aws.qbusiness/AttachmentsConfiguration)

(s/def :cognitect.aws.qbusiness.UpdateApplicationRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.KendraIndexConfiguration/indexId
  :cognitect.aws.qbusiness/KendraIndexId)

(s/def
  :cognitect.aws.qbusiness.UpdateUserResponse/userAliasesAdded
  :cognitect.aws.qbusiness/UserAliases)

(s/def
  :cognitect.aws.qbusiness.UpdateUserResponse/userAliasesUpdated
  :cognitect.aws.qbusiness/UserAliases)

(s/def
  :cognitect.aws.qbusiness.UpdateUserResponse/userAliasesDeleted
  :cognitect.aws.qbusiness/UserAliases)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/description
  :cognitect.aws.qbusiness/Description)

(s/def :cognitect.aws.qbusiness.CreateApplicationRequest/tags :cognitect.aws.qbusiness/Tags)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/qAppsConfiguration
  :cognitect.aws.qbusiness/QAppsConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/identityCenterInstanceArn
  :cognitect.aws.qbusiness/InstanceArn)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/clientIdsForOIDC
  :cognitect.aws.qbusiness/ClientIdsForOIDC)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/displayName
  :cognitect.aws.qbusiness/ApplicationName)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/quickSightConfiguration
  :cognitect.aws.qbusiness/QuickSightConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/personalizationConfiguration
  :cognitect.aws.qbusiness/PersonalizationConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/attachmentsConfiguration
  :cognitect.aws.qbusiness/AttachmentsConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/iamIdentityProviderArn
  :cognitect.aws.qbusiness/IAMIdentityProviderArn)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/encryptionConfiguration
  :cognitect.aws.qbusiness/EncryptionConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/identityType
  :cognitect.aws.qbusiness/IdentityType)

(s/def
  :cognitect.aws.qbusiness.CreateApplicationRequest/clientToken
  :cognitect.aws.qbusiness/ClientToken)

(s/def :cognitect.aws.qbusiness.CreateApplicationRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def :cognitect.aws.qbusiness.DataAccessor/displayName :cognitect.aws.qbusiness/DataAccessorName)

(s/def :cognitect.aws.qbusiness.DataAccessor/dataAccessorId :cognitect.aws.qbusiness/DataAccessorId)

(s/def
  :cognitect.aws.qbusiness.DataAccessor/dataAccessorArn
  :cognitect.aws.qbusiness/DataAccessorArn)

(s/def
  :cognitect.aws.qbusiness.DataAccessor/idcApplicationArn
  :cognitect.aws.qbusiness/IdcApplicationArn)

(s/def :cognitect.aws.qbusiness.DataAccessor/principal :cognitect.aws.qbusiness/PrincipalRoleArn)

(s/def
  :cognitect.aws.qbusiness.DataAccessor/authenticationDetail
  :cognitect.aws.qbusiness/DataAccessorAuthenticationDetail)

(s/def :cognitect.aws.qbusiness.DataAccessor/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.DataAccessor/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.CreateAnonymousWebExperienceUrlResponse/anonymousUrl
  :cognitect.aws.qbusiness/Url)

(s/def
  :cognitect.aws.qbusiness.ListWebExperiencesResponse/webExperiences
  :cognitect.aws.qbusiness/WebExperiences)

(s/def
  :cognitect.aws.qbusiness.ListWebExperiencesResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.AssociatePermissionResponse/statement
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.CreateRetrieverResponse/retrieverId
  :cognitect.aws.qbusiness/RetrieverId)

(s/def
  :cognitect.aws.qbusiness.CreateRetrieverResponse/retrieverArn
  :cognitect.aws.qbusiness/RetrieverArn)

(s/def :cognitect.aws.qbusiness.ActionConfiguration/action :cognitect.aws.qbusiness/QIamAction)

(s/def
  :cognitect.aws.qbusiness.ActionConfiguration/filterConfiguration
  :cognitect.aws.qbusiness/ActionFilterConfiguration)

(s/def
  :cognitect.aws.qbusiness.CreateIndexRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.CreateIndexRequest/displayName :cognitect.aws.qbusiness/IndexName)

(s/def :cognitect.aws.qbusiness.CreateIndexRequest/description :cognitect.aws.qbusiness/Description)

(s/def :cognitect.aws.qbusiness.CreateIndexRequest/type :cognitect.aws.qbusiness/IndexType)

(s/def :cognitect.aws.qbusiness.CreateIndexRequest/tags :cognitect.aws.qbusiness/Tags)

(s/def
  :cognitect.aws.qbusiness.CreateIndexRequest/capacityConfiguration
  :cognitect.aws.qbusiness/IndexCapacityConfiguration)

(s/def :cognitect.aws.qbusiness.CreateIndexRequest/clientToken :cognitect.aws.qbusiness/ClientToken)

(s/def
  :cognitect.aws.qbusiness.AuthChallengeResponse/responseMap
  :cognitect.aws.qbusiness/AuthorizationResponseMap)

(s/def
  :cognitect.aws.qbusiness.RetrieverContentSource/retrieverId
  :cognitect.aws.qbusiness/RetrieverId)

(s/def :cognitect.aws.qbusiness.Attachment/fileSize :cognitect.aws.qbusiness/Integer)

(s/def :cognitect.aws.qbusiness.Attachment/fileType :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.Attachment/name :cognitect.aws.qbusiness/AttachmentName)

(s/def :cognitect.aws.qbusiness.Attachment/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.Attachment/md5chksum :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.Attachment/attachmentId :cognitect.aws.qbusiness/AttachmentId)

(s/def :cognitect.aws.qbusiness.Attachment/status :cognitect.aws.qbusiness/AttachmentStatus)

(s/def :cognitect.aws.qbusiness.Attachment/error :cognitect.aws.qbusiness/ErrorDetail)

(s/def :cognitect.aws.qbusiness.Attachment/conversationId :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.Attachment/copyFrom :cognitect.aws.qbusiness/CopyFromSource)

(s/def
  :cognitect.aws.qbusiness.AutoSubscriptionConfiguration/autoSubscribe
  :cognitect.aws.qbusiness/AutoSubscriptionStatus)

(s/def
  :cognitect.aws.qbusiness.AutoSubscriptionConfiguration/defaultSubscriptionType
  :cognitect.aws.qbusiness/SubscriptionType)

(s/def
  :cognitect.aws.qbusiness.ListRetrieversResponse/retrievers
  :cognitect.aws.qbusiness/Retrievers)

(s/def :cognitect.aws.qbusiness.ListRetrieversResponse/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.AssociatePermissionRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.AssociatePermissionRequest/statementId
  :cognitect.aws.qbusiness/StatementId)

(s/def
  :cognitect.aws.qbusiness.AssociatePermissionRequest/actions
  :cognitect.aws.qbusiness/QIamActions)

(s/def
  :cognitect.aws.qbusiness.AssociatePermissionRequest/conditions
  :cognitect.aws.qbusiness/PermissionConditions)

(s/def
  :cognitect.aws.qbusiness.AssociatePermissionRequest/principal
  :cognitect.aws.qbusiness/PrincipalRoleArn)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.GetDataSourceRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.GetGroupRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.GetGroupRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.GetGroupRequest/groupName :cognitect.aws.qbusiness/GroupName)

(s/def :cognitect.aws.qbusiness.GetGroupRequest/dataSourceId :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.InstructionCollection/responseLength
  :cognitect.aws.qbusiness/Instruction)

(s/def
  :cognitect.aws.qbusiness.InstructionCollection/targetAudience
  :cognitect.aws.qbusiness/Instruction)

(s/def
  :cognitect.aws.qbusiness.InstructionCollection/perspective
  :cognitect.aws.qbusiness/Instruction)

(s/def
  :cognitect.aws.qbusiness.InstructionCollection/outputStyle
  :cognitect.aws.qbusiness/Instruction)

(s/def :cognitect.aws.qbusiness.InstructionCollection/identity :cognitect.aws.qbusiness/Instruction)

(s/def :cognitect.aws.qbusiness.InstructionCollection/tone :cognitect.aws.qbusiness/Instruction)

(s/def
  :cognitect.aws.qbusiness.InstructionCollection/customInstructions
  :cognitect.aws.qbusiness/Instruction)

(s/def :cognitect.aws.qbusiness.InstructionCollection/examples :cognitect.aws.qbusiness/Instruction)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForGetTopicConfigurations)

(s/def
  :cognitect.aws.qbusiness.GetChatControlsConfigurationRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceResponse/webExperienceId
  :cognitect.aws.qbusiness/WebExperienceId)

(s/def
  :cognitect.aws.qbusiness.CreateWebExperienceResponse/webExperienceArn
  :cognitect.aws.qbusiness/WebExperienceArn)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadFieldAllowedValue/value
  :cognitect.aws.qbusiness/ActionPayloadFieldValue)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadFieldAllowedValue/displayValue
  :cognitect.aws.qbusiness/ActionPayloadFieldValue)

(s/def
  :cognitect.aws.qbusiness.MediaExtractionConfiguration/imageExtractionConfiguration
  :cognitect.aws.qbusiness/ImageExtractionConfiguration)

(s/def
  :cognitect.aws.qbusiness.MediaExtractionConfiguration/audioExtractionConfiguration
  :cognitect.aws.qbusiness/AudioExtractionConfiguration)

(s/def
  :cognitect.aws.qbusiness.MediaExtractionConfiguration/videoExtractionConfiguration
  :cognitect.aws.qbusiness/VideoExtractionConfiguration)

(s/def :cognitect.aws.qbusiness.Plugin/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def :cognitect.aws.qbusiness.Plugin/displayName :cognitect.aws.qbusiness/PluginName)

(s/def :cognitect.aws.qbusiness.Plugin/type :cognitect.aws.qbusiness/PluginType)

(s/def :cognitect.aws.qbusiness.Plugin/serverUrl :cognitect.aws.qbusiness/Url)

(s/def :cognitect.aws.qbusiness.Plugin/state :cognitect.aws.qbusiness/PluginState)

(s/def :cognitect.aws.qbusiness.Plugin/buildStatus :cognitect.aws.qbusiness/PluginBuildStatus)

(s/def :cognitect.aws.qbusiness.Plugin/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.Plugin/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.ListRetrieversRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ListRetrieversRequest/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListRetrieversRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListRetrieversRequest)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/description
  :cognitect.aws.qbusiness/Description)

(s/def :cognitect.aws.qbusiness.GetDataSourceResponse/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/mediaExtractionConfiguration
  :cognitect.aws.qbusiness/MediaExtractionConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/dataSourceArn
  :cognitect.aws.qbusiness/DataSourceArn)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/displayName
  :cognitect.aws.qbusiness/DataSourceName)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/syncSchedule
  :cognitect.aws.qbusiness/SyncSchedule)

(s/def :cognitect.aws.qbusiness.GetDataSourceResponse/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.GetDataSourceResponse/type :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/vpcConfiguration
  :cognitect.aws.qbusiness/DataSourceVpcConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/documentEnrichmentConfiguration
  :cognitect.aws.qbusiness/DocumentEnrichmentConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/status
  :cognitect.aws.qbusiness/DataSourceStatus)

(s/def :cognitect.aws.qbusiness.GetDataSourceResponse/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def :cognitect.aws.qbusiness.GetDataSourceResponse/error :cognitect.aws.qbusiness/ErrorDetail)

(s/def
  :cognitect.aws.qbusiness.GetDataSourceResponse/configuration
  :cognitect.aws.qbusiness/DataSourceConfiguration)

(s/def :cognitect.aws.qbusiness.GetDataSourceResponse/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.AppliedOrchestrationConfiguration/control
  :cognitect.aws.qbusiness/OrchestrationControl)

(s/def :cognitect.aws.qbusiness.EncryptionConfiguration/kmsKeyId :cognitect.aws.qbusiness/KmsKeyId)

(s/def :cognitect.aws.qbusiness.Retriever/applicationId :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.Retriever/retrieverId :cognitect.aws.qbusiness/RetrieverId)

(s/def :cognitect.aws.qbusiness.Retriever/type :cognitect.aws.qbusiness/RetrieverType)

(s/def :cognitect.aws.qbusiness.Retriever/status :cognitect.aws.qbusiness/RetrieverStatus)

(s/def :cognitect.aws.qbusiness.Retriever/displayName :cognitect.aws.qbusiness/RetrieverName)

(s/def
  :cognitect.aws.qbusiness.UpdateUserRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.UpdateUserRequest/userId :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.UpdateUserRequest/userAliasesToUpdate
  :cognitect.aws.qbusiness/UserAliases)

(s/def
  :cognitect.aws.qbusiness.UpdateUserRequest/userAliasesToDelete
  :cognitect.aws.qbusiness/UserAliases)

(s/def
  :cognitect.aws.qbusiness.AppliedAttachmentsConfiguration/attachmentsControlMode
  :cognitect.aws.qbusiness/AttachmentsControlMode)

(s/def
  :cognitect.aws.qbusiness.AppliedCreatorModeConfiguration/creatorModeControl
  :cognitect.aws.qbusiness/CreatorModeControl)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfigurationDetail/responseConfigurations
  :cognitect.aws.qbusiness/ResponseConfigurations)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfigurationDetail/responseConfigurationSummary
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfigurationDetail/status
  :cognitect.aws.qbusiness/ChatResponseConfigurationStatus)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfigurationDetail/error
  :cognitect.aws.qbusiness/ErrorDetail)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfigurationDetail/updatedAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.ListDocumentsResponse/documentDetailList
  :cognitect.aws.qbusiness/DocumentDetailList)

(s/def :cognitect.aws.qbusiness.ListDocumentsResponse/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.UpdateDataAccessorRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.UpdateDataAccessorRequest/dataAccessorId
  :cognitect.aws.qbusiness/DataAccessorId)

(s/def
  :cognitect.aws.qbusiness.UpdateDataAccessorRequest/actionConfigurations
  :cognitect.aws.qbusiness/ActionConfigurationList)

(s/def
  :cognitect.aws.qbusiness.UpdateDataAccessorRequest/authenticationDetail
  :cognitect.aws.qbusiness/DataAccessorAuthenticationDetail)

(s/def
  :cognitect.aws.qbusiness.UpdateDataAccessorRequest/displayName
  :cognitect.aws.qbusiness/DataAccessorName)

(s/def
  :cognitect.aws.qbusiness.ActionFilterConfiguration/documentAttributeFilter
  :cognitect.aws.qbusiness/AttributeFilter)

(s/def
  :cognitect.aws.qbusiness.BatchPutDocumentRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.BatchPutDocumentRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.BatchPutDocumentRequest/documents
  :cognitect.aws.qbusiness/Documents)

(s/def :cognitect.aws.qbusiness.BatchPutDocumentRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.BatchPutDocumentRequest/dataSourceSyncId
  :cognitect.aws.qbusiness/ExecutionId)

(s/def
  :cognitect.aws.qbusiness.DateAttributeBoostingConfiguration/boostingLevel
  :cognitect.aws.qbusiness/DocumentAttributeBoostingLevel)

(s/def
  :cognitect.aws.qbusiness.DateAttributeBoostingConfiguration/boostingDurationInSeconds
  :cognitect.aws.qbusiness/BoostingDurationInSeconds)

(s/def
  :cognitect.aws.qbusiness.SamlProviderConfiguration/authenticationUrl
  :cognitect.aws.qbusiness/SamlAuthenticationUrl)

(s/def :cognitect.aws.qbusiness.GetPolicyResponse/policy :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.DataAccessorAuthenticationDetail/authenticationType
  :cognitect.aws.qbusiness/DataAccessorAuthenticationType)

(s/def
  :cognitect.aws.qbusiness.DataAccessorAuthenticationDetail/authenticationConfiguration
  :cognitect.aws.qbusiness/DataAccessorAuthenticationConfiguration)

(s/def
  :cognitect.aws.qbusiness.DataAccessorAuthenticationDetail/externalIds
  :cognitect.aws.qbusiness/DataAccessorExternalIds)

(s/def
  :cognitect.aws.qbusiness.DataAccessorAuthenticationConfiguration/idcTrustedTokenIssuerConfiguration
  :cognitect.aws.qbusiness/DataAccessorIdcTrustedTokenIssuerConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetApplicationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.Application/displayName :cognitect.aws.qbusiness/ApplicationName)

(s/def :cognitect.aws.qbusiness.Application/applicationId :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.Application/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.Application/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.Application/status :cognitect.aws.qbusiness/ApplicationStatus)

(s/def :cognitect.aws.qbusiness.Application/identityType :cognitect.aws.qbusiness/IdentityType)

(s/def
  :cognitect.aws.qbusiness.Application/quickSightConfiguration
  :cognitect.aws.qbusiness/QuickSightConfiguration)

(s/def :cognitect.aws.qbusiness.GetUserRequest/applicationId :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.GetUserRequest/userId :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.IdentityProviderConfiguration/samlConfiguration
  :cognitect.aws.qbusiness/SamlProviderConfiguration)

(s/def
  :cognitect.aws.qbusiness.IdentityProviderConfiguration/openIDConnectConfiguration
  :cognitect.aws.qbusiness/OpenIDConnectProviderConfiguration)

(s/def
  :cognitect.aws.qbusiness.ListIndicesRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ListIndicesRequest/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListIndicesRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListIndices)

(s/def
  :cognitect.aws.qbusiness.UntagResourceRequest/resourceARN
  :cognitect.aws.qbusiness/AmazonResourceName)

(s/def :cognitect.aws.qbusiness.UntagResourceRequest/tagKeys :cognitect.aws.qbusiness/TagKeys)

(s/def :cognitect.aws.qbusiness.Conversation/conversationId :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.Conversation/title :cognitect.aws.qbusiness/ConversationTitle)

(s/def :cognitect.aws.qbusiness.Conversation/startTime :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.DeleteIndexRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.DeleteIndexRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.VideoSourceDetails/mediaId :cognitect.aws.qbusiness/MediaId)

(s/def :cognitect.aws.qbusiness.VideoSourceDetails/mediaMimeType :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.VideoSourceDetails/startTimeMilliseconds
  :cognitect.aws.qbusiness/Long)

(s/def
  :cognitect.aws.qbusiness.VideoSourceDetails/endTimeMilliseconds
  :cognitect.aws.qbusiness/Long)

(s/def
  :cognitect.aws.qbusiness.VideoSourceDetails/videoExtractionType
  :cognitect.aws.qbusiness/VideoExtractionType)

(s/def
  :cognitect.aws.qbusiness.MediaTooLargeException/message
  :cognitect.aws.qbusiness/ErrorMessage)

(s/def :cognitect.aws.qbusiness.AudioSourceDetails/mediaId :cognitect.aws.qbusiness/MediaId)

(s/def :cognitect.aws.qbusiness.AudioSourceDetails/mediaMimeType :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.AudioSourceDetails/startTimeMilliseconds
  :cognitect.aws.qbusiness/Long)

(s/def
  :cognitect.aws.qbusiness.AudioSourceDetails/endTimeMilliseconds
  :cognitect.aws.qbusiness/Long)

(s/def
  :cognitect.aws.qbusiness.AudioSourceDetails/audioExtractionType
  :cognitect.aws.qbusiness/AudioExtractionType)

(s/def
  :cognitect.aws.qbusiness.NumberAttributeBoostingConfiguration/boostingLevel
  :cognitect.aws.qbusiness/DocumentAttributeBoostingLevel)

(s/def
  :cognitect.aws.qbusiness.NumberAttributeBoostingConfiguration/boostingType
  :cognitect.aws.qbusiness/NumberAttributeBoostingType)

(s/def
  :cognitect.aws.qbusiness.ListPluginActionsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ListPluginActionsRequest/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def
  :cognitect.aws.qbusiness.ListPluginActionsRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListPluginActionsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListPluginActions)

(s/def
  :cognitect.aws.qbusiness.BatchDeleteDocumentRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.BatchDeleteDocumentRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.BatchDeleteDocumentRequest/documents
  :cognitect.aws.qbusiness/DeleteDocuments)

(s/def
  :cognitect.aws.qbusiness.BatchDeleteDocumentRequest/dataSourceSyncId
  :cognitect.aws.qbusiness/ExecutionId)

(s/def
  :cognitect.aws.qbusiness.RetrieverConfiguration/nativeIndexConfiguration
  :cognitect.aws.qbusiness/NativeIndexConfiguration)

(s/def
  :cognitect.aws.qbusiness.RetrieverConfiguration/kendraIndexConfiguration
  :cognitect.aws.qbusiness/KendraIndexConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetMediaRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetMediaRequest/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.GetMediaRequest/messageId :cognitect.aws.qbusiness/MessageId)

(s/def :cognitect.aws.qbusiness.GetMediaRequest/mediaId :cognitect.aws.qbusiness/MediaId)

(s/def :cognitect.aws.qbusiness.DeleteDocument/documentId :cognitect.aws.qbusiness/DocumentId)

(s/def :cognitect.aws.qbusiness.DocumentAclGroup/name :cognitect.aws.qbusiness/GroupName)

(s/def :cognitect.aws.qbusiness.DocumentAclGroup/type :cognitect.aws.qbusiness/MembershipType)

(s/def
  :cognitect.aws.qbusiness.DocumentAttribute/name
  :cognitect.aws.qbusiness/DocumentAttributeKey)

(s/def
  :cognitect.aws.qbusiness.DocumentAttribute/value
  :cognitect.aws.qbusiness/DocumentAttributeValue)

(s/def :cognitect.aws.qbusiness.AttachmentOutput/name :cognitect.aws.qbusiness/AttachmentName)

(s/def :cognitect.aws.qbusiness.AttachmentOutput/status :cognitect.aws.qbusiness/AttachmentStatus)

(s/def :cognitect.aws.qbusiness.AttachmentOutput/error :cognitect.aws.qbusiness/ErrorDetail)

(s/def :cognitect.aws.qbusiness.AttachmentOutput/attachmentId :cognitect.aws.qbusiness/AttachmentId)

(s/def
  :cognitect.aws.qbusiness.AttachmentOutput/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def
  :cognitect.aws.qbusiness.LicenseNotFoundException/message
  :cognitect.aws.qbusiness/ErrorMessage)

(s/def
  :cognitect.aws.qbusiness.ExternalResourceException/message
  :cognitect.aws.qbusiness/ErrorMessage)

(s/def
  :cognitect.aws.qbusiness.PersonalizationConfiguration/personalizationControlMode
  :cognitect.aws.qbusiness/PersonalizationControlMode)

(s/def :cognitect.aws.qbusiness.ConfigurationEvent/chatMode :cognitect.aws.qbusiness/ChatMode)

(s/def
  :cognitect.aws.qbusiness.ConfigurationEvent/chatModeConfiguration
  :cognitect.aws.qbusiness/ChatModeConfiguration)

(s/def
  :cognitect.aws.qbusiness.ConfigurationEvent/attributeFilter
  :cognitect.aws.qbusiness/AttributeFilter)

(s/def :cognitect.aws.qbusiness.S3/bucket :cognitect.aws.qbusiness/S3BucketName)

(s/def :cognitect.aws.qbusiness.S3/key :cognitect.aws.qbusiness/S3ObjectKey)

(s/def
  :cognitect.aws.qbusiness.RuleConfiguration/contentBlockerRule
  :cognitect.aws.qbusiness/ContentBlockerRule)

(s/def
  :cognitect.aws.qbusiness.RuleConfiguration/contentRetrievalRule
  :cognitect.aws.qbusiness/ContentRetrievalRule)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeBoostingConfiguration/numberConfiguration
  :cognitect.aws.qbusiness/NumberAttributeBoostingConfiguration)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeBoostingConfiguration/stringConfiguration
  :cognitect.aws.qbusiness/StringAttributeBoostingConfiguration)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeBoostingConfiguration/dateConfiguration
  :cognitect.aws.qbusiness/DateAttributeBoostingConfiguration)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeBoostingConfiguration/stringListConfiguration
  :cognitect.aws.qbusiness/StringListAttributeBoostingConfiguration)

(s/def
  :cognitect.aws.qbusiness.OAuth2ClientCredentialConfiguration/secretArn
  :cognitect.aws.qbusiness/SecretArn)

(s/def
  :cognitect.aws.qbusiness.OAuth2ClientCredentialConfiguration/roleArn
  :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.OAuth2ClientCredentialConfiguration/authorizationUrl
  :cognitect.aws.qbusiness/Url)

(s/def
  :cognitect.aws.qbusiness.OAuth2ClientCredentialConfiguration/tokenUrl
  :cognitect.aws.qbusiness/Url)

(s/def
  :cognitect.aws.qbusiness.SearchRelevantContentRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.SearchRelevantContentRequest/queryText
  :cognitect.aws.qbusiness/QueryText)

(s/def
  :cognitect.aws.qbusiness.SearchRelevantContentRequest/contentSource
  :cognitect.aws.qbusiness/ContentSource)

(s/def
  :cognitect.aws.qbusiness.SearchRelevantContentRequest/attributeFilter
  :cognitect.aws.qbusiness/AttributeFilter)

(s/def
  :cognitect.aws.qbusiness.SearchRelevantContentRequest/maxResults
  :cognitect.aws.qbusiness/MaxResults)

(s/def
  :cognitect.aws.qbusiness.SearchRelevantContentRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.DataSourceVpcConfiguration/subnetIds
  :cognitect.aws.qbusiness/SubnetIds)

(s/def
  :cognitect.aws.qbusiness.DataSourceVpcConfiguration/securityGroupIds
  :cognitect.aws.qbusiness/SecurityGroupIds)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceResponse/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.CreateDataSourceResponse/dataSourceArn
  :cognitect.aws.qbusiness/DataSourceArn)

(s/def
  :cognitect.aws.qbusiness.UpdateRetrieverRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.UpdateRetrieverRequest/retrieverId
  :cognitect.aws.qbusiness/RetrieverId)

(s/def
  :cognitect.aws.qbusiness.UpdateRetrieverRequest/configuration
  :cognitect.aws.qbusiness/RetrieverConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateRetrieverRequest/displayName
  :cognitect.aws.qbusiness/RetrieverName)

(s/def :cognitect.aws.qbusiness.UpdateRetrieverRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.GetPluginResponse/buildStatus
  :cognitect.aws.qbusiness/PluginBuildStatus)

(s/def :cognitect.aws.qbusiness.GetPluginResponse/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.GetPluginResponse/serverUrl :cognitect.aws.qbusiness/Url)

(s/def :cognitect.aws.qbusiness.GetPluginResponse/displayName :cognitect.aws.qbusiness/PluginName)

(s/def :cognitect.aws.qbusiness.GetPluginResponse/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.GetPluginResponse/type :cognitect.aws.qbusiness/PluginType)

(s/def :cognitect.aws.qbusiness.GetPluginResponse/state :cognitect.aws.qbusiness/PluginState)

(s/def
  :cognitect.aws.qbusiness.GetPluginResponse/authConfiguration
  :cognitect.aws.qbusiness/PluginAuthConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetPluginResponse/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.GetPluginResponse/pluginArn :cognitect.aws.qbusiness/PluginArn)

(s/def
  :cognitect.aws.qbusiness.GetPluginResponse/customPluginConfiguration
  :cognitect.aws.qbusiness/CustomPluginConfiguration)

(s/def :cognitect.aws.qbusiness.GetPluginResponse/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def
  :cognitect.aws.qbusiness.ConversationSource/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def
  :cognitect.aws.qbusiness.ConversationSource/attachmentId
  :cognitect.aws.qbusiness/AttachmentId)

(s/def
  :cognitect.aws.qbusiness.MessageUsefulnessFeedback/usefulness
  :cognitect.aws.qbusiness/MessageUsefulness)

(s/def
  :cognitect.aws.qbusiness.MessageUsefulnessFeedback/reason
  :cognitect.aws.qbusiness/MessageUsefulnessReason)

(s/def
  :cognitect.aws.qbusiness.MessageUsefulnessFeedback/comment
  :cognitect.aws.qbusiness/MessageUsefulnessComment)

(s/def
  :cognitect.aws.qbusiness.MessageUsefulnessFeedback/submittedAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.ListMessagesRequest/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def
  :cognitect.aws.qbusiness.ListMessagesRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.ListMessagesRequest/userId :cognitect.aws.qbusiness/UserId)

(s/def :cognitect.aws.qbusiness.ListMessagesRequest/nextToken :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListMessagesRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListMessages)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/updatedAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/idcApplicationArn
  :cognitect.aws.qbusiness/IdcApplicationArn)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/displayName
  :cognitect.aws.qbusiness/DataAccessorName)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/authenticationDetail
  :cognitect.aws.qbusiness/DataAccessorAuthenticationDetail)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/createdAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/actionConfigurations
  :cognitect.aws.qbusiness/ActionConfigurationList)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/principal
  :cognitect.aws.qbusiness/PrincipalRoleArn)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/dataAccessorArn
  :cognitect.aws.qbusiness/DataAccessorArn)

(s/def
  :cognitect.aws.qbusiness.GetDataAccessorResponse/dataAccessorId
  :cognitect.aws.qbusiness/DataAccessorId)

(s/def
  :cognitect.aws.qbusiness.ImageExtractionConfiguration/imageExtractionStatus
  :cognitect.aws.qbusiness/ImageExtractionStatus)

(s/def
  :cognitect.aws.qbusiness.PluginAuthConfiguration/basicAuthConfiguration
  :cognitect.aws.qbusiness/BasicAuthConfiguration)

(s/def
  :cognitect.aws.qbusiness.PluginAuthConfiguration/oAuth2ClientCredentialConfiguration
  :cognitect.aws.qbusiness/OAuth2ClientCredentialConfiguration)

(s/def
  :cognitect.aws.qbusiness.PluginAuthConfiguration/noAuthConfiguration
  :cognitect.aws.qbusiness/NoAuthConfiguration)

(s/def
  :cognitect.aws.qbusiness.PluginAuthConfiguration/idcAuthConfiguration
  :cognitect.aws.qbusiness/IdcAuthConfiguration)

(s/def
  :cognitect.aws.qbusiness.GetPluginRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.GetPluginRequest/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeConfiguration/name
  :cognitect.aws.qbusiness/DocumentMetadataConfigurationName)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeConfiguration/type
  :cognitect.aws.qbusiness/AttributeType)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeConfiguration/search
  :cognitect.aws.qbusiness/Status)

(s/def :cognitect.aws.qbusiness.DataSource/displayName :cognitect.aws.qbusiness/DataSourceName)

(s/def :cognitect.aws.qbusiness.DataSource/dataSourceId :cognitect.aws.qbusiness/DataSourceId)

(s/def :cognitect.aws.qbusiness.DataSource/type :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.DataSource/createdAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.DataSource/updatedAt :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.DataSource/status :cognitect.aws.qbusiness/DataSourceStatus)

(s/def
  :cognitect.aws.qbusiness.ListChatResponseConfigurationsRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.ListChatResponseConfigurationsRequest/maxResults
  :cognitect.aws.qbusiness/Integer)

(s/def
  :cognitect.aws.qbusiness.ListChatResponseConfigurationsRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ChatInputStream/configurationEvent
  :cognitect.aws.qbusiness/ConfigurationEvent)

(s/def :cognitect.aws.qbusiness.ChatInputStream/textEvent :cognitect.aws.qbusiness/TextInputEvent)

(s/def
  :cognitect.aws.qbusiness.ChatInputStream/attachmentEvent
  :cognitect.aws.qbusiness/AttachmentInputEvent)

(s/def
  :cognitect.aws.qbusiness.ChatInputStream/actionExecutionEvent
  :cognitect.aws.qbusiness/ActionExecutionEvent)

(s/def
  :cognitect.aws.qbusiness.ChatInputStream/endOfInputEvent
  :cognitect.aws.qbusiness/EndOfInputEvent)

(s/def
  :cognitect.aws.qbusiness.ChatInputStream/authChallengeResponseEvent
  :cognitect.aws.qbusiness/AuthChallengeResponseEvent)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfiguration/chatResponseConfigurationId
  :cognitect.aws.qbusiness/ChatResponseConfigurationId)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfiguration/chatResponseConfigurationArn
  :cognitect.aws.qbusiness/ChatResponseConfigurationArn)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfiguration/displayName
  :cognitect.aws.qbusiness/DisplayName)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfiguration/responseConfigurationSummary
  :cognitect.aws.qbusiness/ResponseConfigurationSummary)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfiguration/status
  :cognitect.aws.qbusiness/ChatResponseConfigurationStatus)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfiguration/createdAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.ChatResponseConfiguration/updatedAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.DataAccessorIdcTrustedTokenIssuerConfiguration/idcTrustedTokenIssuerArn
  :cognitect.aws.qbusiness/IdcTrustedTokenIssuerArn)

(s/def
  :cognitect.aws.qbusiness.IndexStatistics/textDocumentStatistics
  :cognitect.aws.qbusiness/TextDocumentStatistics)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadField/displayDescription
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadField/arrayItemJsonSchema
  :cognitect.aws.qbusiness/ActionReviewPayloadFieldArrayItemJsonSchema)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadField/displayName
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadField/value
  :cognitect.aws.qbusiness/ActionPayloadFieldValue)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadField/allowedFormat
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadField/type
  :cognitect.aws.qbusiness/ActionPayloadFieldType)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadField/displayOrder
  :cognitect.aws.qbusiness/Integer)

(s/def
  :cognitect.aws.qbusiness.ActionReviewPayloadField/allowedValues
  :cognitect.aws.qbusiness/ActionReviewPayloadFieldAllowedValues)

(s/def :cognitect.aws.qbusiness.ActionReviewPayloadField/required :cognitect.aws.qbusiness/Boolean)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeValue/stringValue
  :cognitect.aws.qbusiness/DocumentAttributeValueStringValueString)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeValue/stringListValue
  :cognitect.aws.qbusiness/DocumentAttributeStringListValue)

(s/def :cognitect.aws.qbusiness.DocumentAttributeValue/longValue :cognitect.aws.qbusiness/Long)

(s/def :cognitect.aws.qbusiness.DocumentAttributeValue/dateValue :cognitect.aws.qbusiness/Timestamp)

(s/def :cognitect.aws.qbusiness.NativeIndexConfiguration/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.NativeIndexConfiguration/version :cognitect.aws.qbusiness/Long)

(s/def
  :cognitect.aws.qbusiness.NativeIndexConfiguration/boostingOverride
  :cognitect.aws.qbusiness/DocumentAttributeBoostingOverrideMap)

(s/def
  :cognitect.aws.qbusiness.DeleteApplicationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.PutGroupRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.PutGroupRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.PutGroupRequest/groupName :cognitect.aws.qbusiness/GroupName)

(s/def :cognitect.aws.qbusiness.PutGroupRequest/dataSourceId :cognitect.aws.qbusiness/DataSourceId)

(s/def :cognitect.aws.qbusiness.PutGroupRequest/type :cognitect.aws.qbusiness/MembershipType)

(s/def :cognitect.aws.qbusiness.PutGroupRequest/groupMembers :cognitect.aws.qbusiness/GroupMembers)

(s/def :cognitect.aws.qbusiness.PutGroupRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.VideoExtractionConfiguration/videoExtractionStatus
  :cognitect.aws.qbusiness/VideoExtractionStatus)

(s/def :cognitect.aws.qbusiness.ChatOutput/outputStream :cognitect.aws.qbusiness/ChatOutputStream)

(s/def
  :cognitect.aws.qbusiness.ListApplicationsRequest/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListApplicationsRequest/maxResults
  :cognitect.aws.qbusiness/MaxResultsIntegerForListApplications)

(s/def
  :cognitect.aws.qbusiness.ListDataAccessorsResponse/dataAccessors
  :cognitect.aws.qbusiness/DataAccessors)

(s/def
  :cognitect.aws.qbusiness.ListDataAccessorsResponse/nextToken
  :cognitect.aws.qbusiness/NextToken1500)

(s/def :cognitect.aws.qbusiness.ListTagsForResourceResponse/tags :cognitect.aws.qbusiness/Tags)

(s/def :cognitect.aws.qbusiness.ActionExecutionEvent/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def
  :cognitect.aws.qbusiness.ActionExecutionEvent/payload
  :cognitect.aws.qbusiness/ActionExecutionPayload)

(s/def
  :cognitect.aws.qbusiness.ActionExecutionEvent/payloadFieldNameSeparator
  :cognitect.aws.qbusiness/ActionPayloadFieldNameSeparator)

(s/def
  :cognitect.aws.qbusiness.IdcAuthConfiguration/idcApplicationArn
  :cognitect.aws.qbusiness/IdcApplicationArn)

(s/def :cognitect.aws.qbusiness.IdcAuthConfiguration/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def :cognitect.aws.qbusiness.AssociatedGroup/name :cognitect.aws.qbusiness/GroupName)

(s/def :cognitect.aws.qbusiness.AssociatedGroup/type :cognitect.aws.qbusiness/MembershipType)

(s/def
  :cognitect.aws.qbusiness.CreateSubscriptionRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.CreateSubscriptionRequest/principal
  :cognitect.aws.qbusiness/SubscriptionPrincipal)

(s/def
  :cognitect.aws.qbusiness.CreateSubscriptionRequest/type
  :cognitect.aws.qbusiness/SubscriptionType)

(s/def
  :cognitect.aws.qbusiness.CreateSubscriptionRequest/clientToken
  :cognitect.aws.qbusiness/ClientToken)

(s/def
  :cognitect.aws.qbusiness.ResponseConfiguration/instructionCollection
  :cognitect.aws.qbusiness/InstructionCollection)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeTarget/key
  :cognitect.aws.qbusiness/DocumentAttributeKey)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeTarget/value
  :cognitect.aws.qbusiness/DocumentAttributeValue)

(s/def
  :cognitect.aws.qbusiness.DocumentAttributeTarget/attributeValueOperator
  :cognitect.aws.qbusiness/AttributeValueOperator)

(s/def :cognitect.aws.qbusiness.PluginTypeMetadataSummary/type :cognitect.aws.qbusiness/PluginType)

(s/def
  :cognitect.aws.qbusiness.PluginTypeMetadataSummary/category
  :cognitect.aws.qbusiness/PluginTypeCategory)

(s/def
  :cognitect.aws.qbusiness.PluginTypeMetadataSummary/description
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.IndexCapacityConfiguration/units
  :cognitect.aws.qbusiness/IndexCapacityInteger)

(s/def
  :cognitect.aws.qbusiness.GetPolicyRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.CancelSubscriptionRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.CancelSubscriptionRequest/subscriptionId
  :cognitect.aws.qbusiness/SubscriptionId)

(s/def :cognitect.aws.qbusiness.Document/id :cognitect.aws.qbusiness/DocumentId)

(s/def :cognitect.aws.qbusiness.Document/attributes :cognitect.aws.qbusiness/DocumentAttributes)

(s/def :cognitect.aws.qbusiness.Document/content :cognitect.aws.qbusiness/DocumentContent)

(s/def :cognitect.aws.qbusiness.Document/contentType :cognitect.aws.qbusiness/ContentType)

(s/def :cognitect.aws.qbusiness.Document/title :cognitect.aws.qbusiness/Title)

(s/def
  :cognitect.aws.qbusiness.Document/accessConfiguration
  :cognitect.aws.qbusiness/AccessConfiguration)

(s/def
  :cognitect.aws.qbusiness.Document/documentEnrichmentConfiguration
  :cognitect.aws.qbusiness/DocumentEnrichmentConfiguration)

(s/def
  :cognitect.aws.qbusiness.Document/mediaExtractionConfiguration
  :cognitect.aws.qbusiness/MediaExtractionConfiguration)

(s/def
  :cognitect.aws.qbusiness.ListSubscriptionsResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListSubscriptionsResponse/subscriptions
  :cognitect.aws.qbusiness/Subscriptions)

(s/def
  :cognitect.aws.qbusiness.ChatSyncOutput/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def :cognitect.aws.qbusiness.ChatSyncOutput/systemMessage :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.ChatSyncOutput/systemMessageId :cognitect.aws.qbusiness/MessageId)

(s/def :cognitect.aws.qbusiness.ChatSyncOutput/userMessageId :cognitect.aws.qbusiness/MessageId)

(s/def :cognitect.aws.qbusiness.ChatSyncOutput/actionReview :cognitect.aws.qbusiness/ActionReview)

(s/def
  :cognitect.aws.qbusiness.ChatSyncOutput/authChallengeRequest
  :cognitect.aws.qbusiness/AuthChallengeRequest)

(s/def
  :cognitect.aws.qbusiness.ChatSyncOutput/sourceAttributions
  :cognitect.aws.qbusiness/SourceAttributions)

(s/def
  :cognitect.aws.qbusiness.ChatSyncOutput/failedAttachments
  :cognitect.aws.qbusiness/AttachmentsOutput)

(s/def :cognitect.aws.qbusiness.RelevantContent/content :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.RelevantContent/documentId :cognitect.aws.qbusiness/DocumentId)

(s/def :cognitect.aws.qbusiness.RelevantContent/documentTitle :cognitect.aws.qbusiness/Title)

(s/def :cognitect.aws.qbusiness.RelevantContent/documentUri :cognitect.aws.qbusiness/Url)

(s/def
  :cognitect.aws.qbusiness.RelevantContent/documentAttributes
  :cognitect.aws.qbusiness/DocumentAttributes)

(s/def
  :cognitect.aws.qbusiness.RelevantContent/scoreAttributes
  :cognitect.aws.qbusiness/ScoreAttributes)

(s/def
  :cognitect.aws.qbusiness.ListDataSourcesResponse/dataSources
  :cognitect.aws.qbusiness/DataSources)

(s/def
  :cognitect.aws.qbusiness.ListDataSourcesResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def
  :cognitect.aws.qbusiness.ListPluginActionsResponse/nextToken
  :cognitect.aws.qbusiness/NextToken)

(s/def :cognitect.aws.qbusiness.ListPluginActionsResponse/items :cognitect.aws.qbusiness/Actions)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/origins
  :cognitect.aws.qbusiness/WebExperienceOrigins)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/welcomeMessage
  :cognitect.aws.qbusiness/WebExperienceWelcomeMessage)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/browserExtensionConfiguration
  :cognitect.aws.qbusiness/BrowserExtensionConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/webExperienceId
  :cognitect.aws.qbusiness/WebExperienceId)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/authenticationConfiguration
  :cognitect.aws.qbusiness/WebExperienceAuthConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/title
  :cognitect.aws.qbusiness/WebExperienceTitle)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/customizationConfiguration
  :cognitect.aws.qbusiness/CustomizationConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/subtitle
  :cognitect.aws.qbusiness/WebExperienceSubtitle)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/identityProviderConfiguration
  :cognitect.aws.qbusiness/IdentityProviderConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateWebExperienceRequest/samplePromptsControlMode
  :cognitect.aws.qbusiness/WebExperienceSamplePromptsControlMode)

(s/def :cognitect.aws.qbusiness.UpdateWebExperienceRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def :cognitect.aws.qbusiness.CreateIndexResponse/indexId :cognitect.aws.qbusiness/IndexId)

(s/def :cognitect.aws.qbusiness.CreateIndexResponse/indexArn :cognitect.aws.qbusiness/IndexArn)

(s/def
  :cognitect.aws.qbusiness.PutFeedbackRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.PutFeedbackRequest/userId :cognitect.aws.qbusiness/UserId)

(s/def
  :cognitect.aws.qbusiness.PutFeedbackRequest/conversationId
  :cognitect.aws.qbusiness/ConversationId)

(s/def
  :cognitect.aws.qbusiness.PutFeedbackRequest/messageId
  :cognitect.aws.qbusiness/SystemMessageId)

(s/def
  :cognitect.aws.qbusiness.PutFeedbackRequest/messageCopiedAt
  :cognitect.aws.qbusiness/Timestamp)

(s/def
  :cognitect.aws.qbusiness.PutFeedbackRequest/messageUsefulness
  :cognitect.aws.qbusiness/MessageUsefulnessFeedback)

(s/def
  :cognitect.aws.qbusiness.DeleteDataAccessorRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.DeleteDataAccessorRequest/dataAccessorId
  :cognitect.aws.qbusiness/DataAccessorId)

(s/def
  :cognitect.aws.qbusiness.ResourceNotFoundException/message
  :cognitect.aws.qbusiness/ErrorMessage)

(s/def
  :cognitect.aws.qbusiness.ResourceNotFoundException/resourceId
  :cognitect.aws.qbusiness/String)

(s/def
  :cognitect.aws.qbusiness.ResourceNotFoundException/resourceType
  :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.ConflictException/message :cognitect.aws.qbusiness/ErrorMessage)

(s/def :cognitect.aws.qbusiness.ConflictException/resourceId :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.ConflictException/resourceType :cognitect.aws.qbusiness/String)

(s/def :cognitect.aws.qbusiness.APISchema/payload :cognitect.aws.qbusiness/Payload)

(s/def :cognitect.aws.qbusiness.APISchema/s3 :cognitect.aws.qbusiness/S3)

(s/def
  :cognitect.aws.qbusiness.DeletePluginRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def :cognitect.aws.qbusiness.DeletePluginRequest/pluginId :cognitect.aws.qbusiness/PluginId)

(s/def
  :cognitect.aws.qbusiness.DeleteChatControlsConfigurationRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.UpdateDataSourceRequest/description
  :cognitect.aws.qbusiness/Description)

(s/def
  :cognitect.aws.qbusiness.UpdateDataSourceRequest/mediaExtractionConfiguration
  :cognitect.aws.qbusiness/MediaExtractionConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateDataSourceRequest/displayName
  :cognitect.aws.qbusiness/DataSourceName)

(s/def
  :cognitect.aws.qbusiness.UpdateDataSourceRequest/syncSchedule
  :cognitect.aws.qbusiness/SyncSchedule)

(s/def
  :cognitect.aws.qbusiness.UpdateDataSourceRequest/vpcConfiguration
  :cognitect.aws.qbusiness/DataSourceVpcConfiguration)

(s/def
  :cognitect.aws.qbusiness.UpdateDataSourceRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.UpdateDataSourceRequest/documentEnrichmentConfiguration
  :cognitect.aws.qbusiness/DocumentEnrichmentConfiguration)

(s/def :cognitect.aws.qbusiness.UpdateDataSourceRequest/indexId :cognitect.aws.qbusiness/IndexId)

(s/def
  :cognitect.aws.qbusiness.UpdateDataSourceRequest/dataSourceId
  :cognitect.aws.qbusiness/DataSourceId)

(s/def
  :cognitect.aws.qbusiness.UpdateDataSourceRequest/configuration
  :cognitect.aws.qbusiness/DataSourceConfiguration)

(s/def :cognitect.aws.qbusiness.UpdateDataSourceRequest/roleArn :cognitect.aws.qbusiness/RoleArn)

(s/def
  :cognitect.aws.qbusiness.BatchDeleteDocumentResponse/failedDocuments
  :cognitect.aws.qbusiness/FailedDocuments)

(s/def
  :cognitect.aws.qbusiness.DeleteRetrieverRequest/applicationId
  :cognitect.aws.qbusiness/ApplicationId)

(s/def
  :cognitect.aws.qbusiness.DeleteRetrieverRequest/retrieverId
  :cognitect.aws.qbusiness/RetrieverId)

(s/def
  :cognitect.aws.qbusiness.OrchestrationConfiguration/control
  :cognitect.aws.qbusiness/OrchestrationControl)

(s/def
  :cognitect.aws.qbusiness.CreatorModeConfiguration/creatorModeControl
  :cognitect.aws.qbusiness/CreatorModeControl)

