;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.route53.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def :cognitect.aws.route53/Port (s/spec (s/and int? #(<= 1 % 65535)) :gen #(gen/choose 1 65535)))

(s/def
  :cognitect.aws.route53/SearchString
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GetHostedZoneCountResponse
  (s/keys :req-un [:cognitect.aws.route53.GetHostedZoneCountResponse/HostedZoneCount]))

(s/def
  :cognitect.aws.route53/HostedZoneCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53/DeleteReusableDelegationSetRequest
  (s/keys :req-un [:cognitect.aws.route53.DeleteReusableDelegationSetRequest/Id]))

(s/def
  :cognitect.aws.route53/ListQueryLoggingConfigsResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListQueryLoggingConfigsResponse/QueryLoggingConfigs]
    :opt-un
    [:cognitect.aws.route53.ListQueryLoggingConfigsResponse/NextToken]))

(s/def
  :cognitect.aws.route53/GetHostedZoneResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetHostedZoneResponse/HostedZone]
    :opt-un
    [:cognitect.aws.route53.GetHostedZoneResponse/VPCs
     :cognitect.aws.route53.GetHostedZoneResponse/DelegationSet]))

(s/def
  :cognitect.aws.route53/CreateTrafficPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateTrafficPolicyRequest/Name
     :cognitect.aws.route53.CreateTrafficPolicyRequest/Document]
    :opt-un
    [:cognitect.aws.route53.CreateTrafficPolicyRequest/Comment]))

(s/def
  :cognitect.aws.route53/HealthCheckVersion
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53/VPC
  (s/keys :opt-un [:cognitect.aws.route53.VPC/VPCRegion :cognitect.aws.route53.VPC/VPCId]))

(s/def
  :cognitect.aws.route53/GetChangeRequest
  (s/keys :req-un [:cognitect.aws.route53.GetChangeRequest/Id]))

(s/def
  :cognitect.aws.route53/ListTrafficPolicyInstancesResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesResponse/TrafficPolicyInstances
     :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/IsTruncated
     :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesResponse/TrafficPolicyInstanceNameMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/HostedZoneIdMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/TrafficPolicyInstanceTypeMarker]))

(s/def
  :cognitect.aws.route53/GetAccountLimitResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetAccountLimitResponse/Limit
     :cognitect.aws.route53.GetAccountLimitResponse/Count]))

(s/def :cognitect.aws.route53/ResourceTagSetList (s/coll-of :cognitect.aws.route53/ResourceTagSet))

(s/def
  :cognitect.aws.route53/ResourceRecordSetWeight
  (s/spec (s/and int? #(<= 0 % 255)) :gen #(gen/choose 0 255)))

(s/def :cognitect.aws.route53/GetTrafficPolicyInstanceCountRequest (s/keys))

(s/def
  :cognitect.aws.route53/AlarmName
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GetDNSSECResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetDNSSECResponse/Status
     :cognitect.aws.route53.GetDNSSECResponse/KeySigningKeys]))

(s/def
  :cognitect.aws.route53/SubnetMask
  (s/spec
    (s/and string? #(<= 0 (count %) 3))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 0 3) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/TrafficPolicyInstanceId
  (s/spec
    (s/and string? #(<= 1 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 36) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.route53/DeleteTrafficPolicyResponse (s/keys))

(s/def
  :cognitect.aws.route53/GetTrafficPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetTrafficPolicyRequest/Id
     :cognitect.aws.route53.GetTrafficPolicyRequest/Version]))

(s/def :cognitect.aws.route53/TimeStamp inst?)

(s/def
  :cognitect.aws.route53/ListVPCAssociationAuthorizationsResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListVPCAssociationAuthorizationsResponse/HostedZoneId
     :cognitect.aws.route53.ListVPCAssociationAuthorizationsResponse/VPCs]
    :opt-un
    [:cognitect.aws.route53.ListVPCAssociationAuthorizationsResponse/NextToken]))

(s/def
  :cognitect.aws.route53/RRType
  (s/spec
    string?
    :gen
    #(s/gen #{"CAA" "CNAME" "TXT" "SRV" "AAAA" "DS" "NS" "PTR" "NAPTR" "A" "SPF" "SOA" "MX"})))

(s/def
  :cognitect.aws.route53/Tag
  (s/keys :opt-un [:cognitect.aws.route53.Tag/Key :cognitect.aws.route53.Tag/Value]))

(s/def
  :cognitect.aws.route53/DNSName
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ResourceRecordSet
  (s/keys
    :req-un
    [:cognitect.aws.route53.ResourceRecordSet/Name :cognitect.aws.route53.ResourceRecordSet/Type]
    :opt-un
    [:cognitect.aws.route53.ResourceRecordSet/AliasTarget
     :cognitect.aws.route53.ResourceRecordSet/GeoLocation
     :cognitect.aws.route53.ResourceRecordSet/TTL
     :cognitect.aws.route53.ResourceRecordSet/SetIdentifier
     :cognitect.aws.route53.ResourceRecordSet/Weight
     :cognitect.aws.route53.ResourceRecordSet/HealthCheckId
     :cognitect.aws.route53.ResourceRecordSet/MultiValueAnswer
     :cognitect.aws.route53.ResourceRecordSet/ResourceRecords
     :cognitect.aws.route53.ResourceRecordSet/Failover
     :cognitect.aws.route53.ResourceRecordSet/TrafficPolicyInstanceId
     :cognitect.aws.route53.ResourceRecordSet/Region]))

(s/def
  :cognitect.aws.route53/FullyQualifiedDomainName
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GeoLocationDetails
  (s/keys
    :opt-un
    [:cognitect.aws.route53.GeoLocationDetails/SubdivisionName
     :cognitect.aws.route53.GeoLocationDetails/CountryName
     :cognitect.aws.route53.GeoLocationDetails/CountryCode
     :cognitect.aws.route53.GeoLocationDetails/ContinentName
     :cognitect.aws.route53.GeoLocationDetails/ContinentCode
     :cognitect.aws.route53.GeoLocationDetails/SubdivisionCode]))

(s/def
  :cognitect.aws.route53/QueryLoggingConfigId
  (s/spec
    (s/and string? #(<= 1 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 36) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/RoutingControlArn
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/AccountLimitType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MAX_REUSABLE_DELEGATION_SETS_BY_OWNER" "MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER"
        "MAX_HEALTH_CHECKS_BY_OWNER" "MAX_TRAFFIC_POLICIES_BY_OWNER" "MAX_HOSTED_ZONES_BY_OWNER"})))

(s/def
  :cognitect.aws.route53/Dimension
  (s/keys :req-un [:cognitect.aws.route53.Dimension/Name :cognitect.aws.route53.Dimension/Value]))

(s/def :cognitect.aws.route53/DeleteHealthCheckResponse (s/keys))

(s/def :cognitect.aws.route53/VPCs (s/coll-of :cognitect.aws.route53/VPC :min-count 1))

(s/def
  :cognitect.aws.route53/CreateKeySigningKeyResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateKeySigningKeyResponse/ChangeInfo
     :cognitect.aws.route53.CreateKeySigningKeyResponse/KeySigningKey
     :cognitect.aws.route53.CreateKeySigningKeyResponse/Location]))

(s/def
  :cognitect.aws.route53/HealthCheckObservation
  (s/keys
    :opt-un
    [:cognitect.aws.route53.HealthCheckObservation/IPAddress
     :cognitect.aws.route53.HealthCheckObservation/Region
     :cognitect.aws.route53.HealthCheckObservation/StatusReport]))

(s/def
  :cognitect.aws.route53/AlarmIdentifier
  (s/keys
    :req-un
    [:cognitect.aws.route53.AlarmIdentifier/Region :cognitect.aws.route53.AlarmIdentifier/Name]))

(s/def
  :cognitect.aws.route53/ResourceRecordSetIdentifier
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/EvaluationPeriods
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53/DeleteTrafficPolicyInstanceRequest
  (s/keys :req-un [:cognitect.aws.route53.DeleteTrafficPolicyInstanceRequest/Id]))

(s/def
  :cognitect.aws.route53/RecordDataEntry
  (s/spec
    (s/and string? #(<= 0 (count %) 512))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 512) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/UsageCount
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53/ListTrafficPolicyVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTrafficPolicyVersionsRequest/Id]
    :opt-un
    [:cognitect.aws.route53.ListTrafficPolicyVersionsRequest/TrafficPolicyVersionMarker
     :cognitect.aws.route53.ListTrafficPolicyVersionsRequest/MaxItems]))

(s/def
  :cognitect.aws.route53/TrafficPolicyVersion
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.route53/GetHostedZoneRequest
  (s/keys :req-un [:cognitect.aws.route53.GetHostedZoneRequest/Id]))

(s/def :cognitect.aws.route53/IsPrivateZone boolean?)

(s/def :cognitect.aws.route53/Changes (s/coll-of :cognitect.aws.route53/Change :min-count 1))

(s/def :cognitect.aws.route53/TransportProtocol string?)

(s/def
  :cognitect.aws.route53/Message
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/Statistic
  (s/spec string? :gen #(s/gen #{"Sum" "Average" "SampleCount" "Minimum" "Maximum"})))

(s/def
  :cognitect.aws.route53/DimensionField
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ChangeTagsForResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ChangeTagsForResourceRequest/ResourceType
     :cognitect.aws.route53.ChangeTagsForResourceRequest/ResourceId]
    :opt-un
    [:cognitect.aws.route53.ChangeTagsForResourceRequest/RemoveTagKeys
     :cognitect.aws.route53.ChangeTagsForResourceRequest/AddTags]))

(s/def
  :cognitect.aws.route53/SigningKeyInteger
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53/DimensionList
  (s/coll-of :cognitect.aws.route53/Dimension :max-count 10))

(s/def
  :cognitect.aws.route53/CreateVPCAssociationAuthorizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateVPCAssociationAuthorizationRequest/HostedZoneId
     :cognitect.aws.route53.CreateVPCAssociationAuthorizationRequest/VPC]))

(s/def
  :cognitect.aws.route53/AliasTarget
  (s/keys
    :req-un
    [:cognitect.aws.route53.AliasTarget/HostedZoneId
     :cognitect.aws.route53.AliasTarget/DNSName
     :cognitect.aws.route53.AliasTarget/EvaluateTargetHealth]))

(s/def :cognitect.aws.route53/IPAddressCidr string?)

(s/def :cognitect.aws.route53/DNSRCode string?)

(s/def
  :cognitect.aws.route53/ListHostedZonesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53.ListHostedZonesRequest/DelegationSetId
     :cognitect.aws.route53.ListHostedZonesRequest/Marker
     :cognitect.aws.route53.ListHostedZonesRequest/MaxItems]))

(s/def
  :cognitect.aws.route53/ServeSignature
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/DeleteHostedZoneResponse
  (s/keys :req-un [:cognitect.aws.route53.DeleteHostedZoneResponse/ChangeInfo]))

(s/def
  :cognitect.aws.route53/TagList
  (s/coll-of :cognitect.aws.route53/Tag :min-count 1 :max-count 10))

(s/def :cognitect.aws.route53/DisassociateVPCComment string?)

(s/def
  :cognitect.aws.route53/CreateTrafficPolicyInstanceResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateTrafficPolicyInstanceResponse/TrafficPolicyInstance
     :cognitect.aws.route53.CreateTrafficPolicyInstanceResponse/Location]))

(s/def :cognitect.aws.route53/AWSAccountID string?)

(s/def
  :cognitect.aws.route53/TrafficPolicyInstances
  (s/coll-of :cognitect.aws.route53/TrafficPolicyInstance))

(s/def
  :cognitect.aws.route53/ResourceRecordSetFailover
  (s/spec string? :gen #(s/gen #{"SECONDARY" "PRIMARY"})))

(s/def :cognitect.aws.route53/HostedZones (s/coll-of :cognitect.aws.route53/HostedZone))

(s/def
  :cognitect.aws.route53/ListResourceRecordSetsRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListResourceRecordSetsRequest/HostedZoneId]
    :opt-un
    [:cognitect.aws.route53.ListResourceRecordSetsRequest/StartRecordType
     :cognitect.aws.route53.ListResourceRecordSetsRequest/StartRecordIdentifier
     :cognitect.aws.route53.ListResourceRecordSetsRequest/StartRecordName
     :cognitect.aws.route53.ListResourceRecordSetsRequest/MaxItems]))

(s/def
  :cognitect.aws.route53/GetHealthCheckLastFailureReasonRequest
  (s/keys :req-un [:cognitect.aws.route53.GetHealthCheckLastFailureReasonRequest/HealthCheckId]))

(s/def
  :cognitect.aws.route53/GeoLocationContinentCode
  (s/spec
    (s/and string? #(<= 2 (count %) 2))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 2 2) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/KeySigningKey
  (s/keys
    :opt-un
    [:cognitect.aws.route53.KeySigningKey/DSRecord
     :cognitect.aws.route53.KeySigningKey/SigningAlgorithmMnemonic
     :cognitect.aws.route53.KeySigningKey/LastModifiedDate
     :cognitect.aws.route53.KeySigningKey/StatusMessage
     :cognitect.aws.route53.KeySigningKey/DigestAlgorithmType
     :cognitect.aws.route53.KeySigningKey/Flag
     :cognitect.aws.route53.KeySigningKey/SigningAlgorithmType
     :cognitect.aws.route53.KeySigningKey/Status
     :cognitect.aws.route53.KeySigningKey/DNSKEYRecord
     :cognitect.aws.route53.KeySigningKey/CreatedDate
     :cognitect.aws.route53.KeySigningKey/DigestAlgorithmMnemonic
     :cognitect.aws.route53.KeySigningKey/DigestValue
     :cognitect.aws.route53.KeySigningKey/KeyTag
     :cognitect.aws.route53.KeySigningKey/Name
     :cognitect.aws.route53.KeySigningKey/PublicKey
     :cognitect.aws.route53.KeySigningKey/KmsArn]))

(s/def
  :cognitect.aws.route53/ListTrafficPolicyInstancesByPolicyResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/TrafficPolicyInstances
     :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/IsTruncated
     :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/TrafficPolicyInstanceNameMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/HostedZoneIdMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/TrafficPolicyInstanceTypeMarker]))

(s/def
  :cognitect.aws.route53/RequestInterval
  (s/spec (s/and int? #(<= 10 % 30)) :gen #(gen/choose 10 30)))

(s/def
  :cognitect.aws.route53/HealthCheckNonce
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ListHostedZonesByNameResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListHostedZonesByNameResponse/HostedZones
     :cognitect.aws.route53.ListHostedZonesByNameResponse/IsTruncated
     :cognitect.aws.route53.ListHostedZonesByNameResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListHostedZonesByNameResponse/NextHostedZoneId
     :cognitect.aws.route53.ListHostedZonesByNameResponse/HostedZoneId
     :cognitect.aws.route53.ListHostedZonesByNameResponse/DNSName
     :cognitect.aws.route53.ListHostedZonesByNameResponse/NextDNSName]))

(s/def :cognitect.aws.route53/AssociateVPCComment string?)

(s/def
  :cognitect.aws.route53/TestDNSAnswerResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.TestDNSAnswerResponse/Nameserver
     :cognitect.aws.route53.TestDNSAnswerResponse/RecordName
     :cognitect.aws.route53.TestDNSAnswerResponse/RecordType
     :cognitect.aws.route53.TestDNSAnswerResponse/RecordData
     :cognitect.aws.route53.TestDNSAnswerResponse/ResponseCode
     :cognitect.aws.route53.TestDNSAnswerResponse/Protocol]))

(s/def
  :cognitect.aws.route53/SigningKeyName
  (s/spec
    (s/and string? #(<= 3 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 3 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ChangeBatch
  (s/keys
    :req-un
    [:cognitect.aws.route53.ChangeBatch/Changes]
    :opt-un
    [:cognitect.aws.route53.ChangeBatch/Comment]))

(s/def
  :cognitect.aws.route53/ResourceId
  (s/spec
    (s/and string? #(>= 32 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 32) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/HostedZoneLimitType
  (s/spec string? :gen #(s/gen #{"MAX_VPCS_ASSOCIATED_BY_ZONE" "MAX_RRSETS_BY_ZONE"})))

(s/def
  :cognitect.aws.route53/TrafficPolicySummary
  (s/keys
    :req-un
    [:cognitect.aws.route53.TrafficPolicySummary/Id
     :cognitect.aws.route53.TrafficPolicySummary/Name
     :cognitect.aws.route53.TrafficPolicySummary/Type
     :cognitect.aws.route53.TrafficPolicySummary/LatestVersion
     :cognitect.aws.route53.TrafficPolicySummary/TrafficPolicyCount]))

(s/def :cognitect.aws.route53/DeleteVPCAssociationAuthorizationResponse (s/keys))

(s/def :cognitect.aws.route53/GetHealthCheckCountRequest (s/keys))

(s/def
  :cognitect.aws.route53/HealthCheckType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"RECOVERY_CONTROL" "TCP" "CALCULATED" "HTTP_STR_MATCH" "HTTPS_STR_MATCH"
        "CLOUDWATCH_METRIC" "HTTPS" "HTTP"})))

(s/def
  :cognitect.aws.route53/DeleteVPCAssociationAuthorizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.DeleteVPCAssociationAuthorizationRequest/HostedZoneId
     :cognitect.aws.route53.DeleteVPCAssociationAuthorizationRequest/VPC]))

(s/def
  :cognitect.aws.route53/HostedZoneRRSetCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53/CreateTrafficPolicyVersionResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateTrafficPolicyVersionResponse/TrafficPolicy
     :cognitect.aws.route53.CreateTrafficPolicyVersionResponse/Location]))

(s/def
  :cognitect.aws.route53/ResourceRecordSets
  (s/coll-of :cognitect.aws.route53/ResourceRecordSet))

(s/def
  :cognitect.aws.route53/ResourceRecord
  (s/keys :req-un [:cognitect.aws.route53.ResourceRecord/Value]))

(s/def
  :cognitect.aws.route53/HealthCheckCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.route53/DelegationSets (s/coll-of :cognitect.aws.route53/DelegationSet))

(s/def
  :cognitect.aws.route53/DeleteKeySigningKeyResponse
  (s/keys :req-un [:cognitect.aws.route53.DeleteKeySigningKeyResponse/ChangeInfo]))

(s/def
  :cognitect.aws.route53/TrafficPolicyId
  (s/spec
    (s/and string? #(<= 1 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 36) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/TrafficPolicySummaries
  (s/coll-of :cognitect.aws.route53/TrafficPolicySummary))

(s/def
  :cognitect.aws.route53/DelegationSet
  (s/keys
    :req-un
    [:cognitect.aws.route53.DelegationSet/NameServers]
    :opt-un
    [:cognitect.aws.route53.DelegationSet/CallerReference :cognitect.aws.route53.DelegationSet/Id]))

(s/def
  :cognitect.aws.route53/ComparisonOperator
  (s/spec
    string?
    :gen
    #(s/gen
      #{"LessThanThreshold" "GreaterThanThreshold" "LessThanOrEqualToThreshold"
        "GreaterThanOrEqualToThreshold"})))

(s/def
  :cognitect.aws.route53/InsufficientDataHealthStatus
  (s/spec string? :gen #(s/gen #{"Healthy" "LastKnownStatus" "Unhealthy"})))

(s/def
  :cognitect.aws.route53/DeleteQueryLoggingConfigRequest
  (s/keys :req-un [:cognitect.aws.route53.DeleteQueryLoggingConfigRequest/Id]))

(s/def
  :cognitect.aws.route53/DeactivateKeySigningKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.DeactivateKeySigningKeyRequest/HostedZoneId
     :cognitect.aws.route53.DeactivateKeySigningKeyRequest/Name]))

(s/def
  :cognitect.aws.route53/TrafficPolicyVersionMarker
  (s/spec
    (s/and string? #(>= 4 (count %)))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/SigningKeyStatus
  (s/spec
    (s/and string? #(<= 5 (count %) 150))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 5 150) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/CreateKeySigningKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateKeySigningKeyRequest/CallerReference
     :cognitect.aws.route53.CreateKeySigningKeyRequest/HostedZoneId
     :cognitect.aws.route53.CreateKeySigningKeyRequest/KeyManagementServiceArn
     :cognitect.aws.route53.CreateKeySigningKeyRequest/Name
     :cognitect.aws.route53.CreateKeySigningKeyRequest/Status]))

(s/def
  :cognitect.aws.route53/Nameserver
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/CreateTrafficPolicyVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateTrafficPolicyVersionRequest/Id
     :cognitect.aws.route53.CreateTrafficPolicyVersionRequest/Document]
    :opt-un
    [:cognitect.aws.route53.CreateTrafficPolicyVersionRequest/Comment]))

(s/def
  :cognitect.aws.route53/SigningKeyTag
  (s/spec (s/and int? #(<= 0 % 65536)) :gen #(gen/choose 0 65536)))

(s/def
  :cognitect.aws.route53/DeleteHealthCheckRequest
  (s/keys :req-un [:cognitect.aws.route53.DeleteHealthCheckRequest/HealthCheckId]))

(s/def
  :cognitect.aws.route53/ListVPCAssociationAuthorizationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListVPCAssociationAuthorizationsRequest/HostedZoneId]
    :opt-un
    [:cognitect.aws.route53.ListVPCAssociationAuthorizationsRequest/NextToken
     :cognitect.aws.route53.ListVPCAssociationAuthorizationsRequest/MaxResults]))

(s/def
  :cognitect.aws.route53/GeoLocationContinentName
  (s/spec
    (s/and string? #(<= 1 (count %) 32))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 32) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GetHealthCheckRequest
  (s/keys :req-un [:cognitect.aws.route53.GetHealthCheckRequest/HealthCheckId]))

(s/def
  :cognitect.aws.route53/HostedZoneOwner
  (s/keys
    :opt-un
    [:cognitect.aws.route53.HostedZoneOwner/OwningAccount
     :cognitect.aws.route53.HostedZoneOwner/OwningService]))

(s/def
  :cognitect.aws.route53/GeoLocationSubdivisionName
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GeoLocationCountryName
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GetReusableDelegationSetLimitRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetReusableDelegationSetLimitRequest/Type
     :cognitect.aws.route53.GetReusableDelegationSetLimitRequest/DelegationSetId]))

(s/def
  :cognitect.aws.route53/ListTrafficPoliciesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53.ListTrafficPoliciesRequest/TrafficPolicyIdMarker
     :cognitect.aws.route53.ListTrafficPoliciesRequest/MaxItems]))

(s/def
  :cognitect.aws.route53/AssociateVPCWithHostedZoneResponse
  (s/keys :req-un [:cognitect.aws.route53.AssociateVPCWithHostedZoneResponse/ChangeInfo]))

(s/def
  :cognitect.aws.route53/ResourceRecords
  (s/coll-of :cognitect.aws.route53/ResourceRecord :min-count 1))

(s/def :cognitect.aws.route53/DeleteReusableDelegationSetResponse (s/keys))

(s/def
  :cognitect.aws.route53/VPCId
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/FailureThreshold
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.route53/UpdateHostedZoneCommentResponse
  (s/keys :req-un [:cognitect.aws.route53.UpdateHostedZoneCommentResponse/HostedZone]))

(s/def :cognitect.aws.route53/PageTruncated boolean?)

(s/def
  :cognitect.aws.route53/QueryLoggingConfig
  (s/keys
    :req-un
    [:cognitect.aws.route53.QueryLoggingConfig/Id
     :cognitect.aws.route53.QueryLoggingConfig/HostedZoneId
     :cognitect.aws.route53.QueryLoggingConfig/CloudWatchLogsLogGroupArn]))

(s/def
  :cognitect.aws.route53/ListHostedZonesByVPCRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListHostedZonesByVPCRequest/VPCId
     :cognitect.aws.route53.ListHostedZonesByVPCRequest/VPCRegion]
    :opt-un
    [:cognitect.aws.route53.ListHostedZonesByVPCRequest/NextToken
     :cognitect.aws.route53.ListHostedZonesByVPCRequest/MaxItems]))

(s/def :cognitect.aws.route53/CheckerIpRanges (s/coll-of :cognitect.aws.route53/IPAddressCidr))

(s/def
  :cognitect.aws.route53/ResettableElementName
  (s/spec
    string?
    :gen
    #(s/gen #{"ChildHealthChecks" "Regions" "ResourcePath" "FullyQualifiedDomainName"})))

(s/def
  :cognitect.aws.route53/GetQueryLoggingConfigRequest
  (s/keys :req-un [:cognitect.aws.route53.GetQueryLoggingConfigRequest/Id]))

(s/def
  :cognitect.aws.route53/GetGeoLocationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53.GetGeoLocationRequest/CountryCode
     :cognitect.aws.route53.GetGeoLocationRequest/ContinentCode
     :cognitect.aws.route53.GetGeoLocationRequest/SubdivisionCode]))

(s/def
  :cognitect.aws.route53/HealthCheckRegion
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ap-northeast-1" "eu-west-1" "ap-southeast-2" "sa-east-1" "ap-southeast-1" "us-west-2"
        "us-east-1" "us-west-1"})))

(s/def
  :cognitect.aws.route53/DeleteKeySigningKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.DeleteKeySigningKeyRequest/HostedZoneId
     :cognitect.aws.route53.DeleteKeySigningKeyRequest/Name]))

(s/def
  :cognitect.aws.route53/PageMarker
  (s/spec
    (s/and string? #(>= 64 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ListTagsForResourcesResponse
  (s/keys :req-un [:cognitect.aws.route53.ListTagsForResourcesResponse/ResourceTagSets]))

(s/def
  :cognitect.aws.route53/ListHostedZonesByVPCResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListHostedZonesByVPCResponse/HostedZoneSummaries
     :cognitect.aws.route53.ListHostedZonesByVPCResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListHostedZonesByVPCResponse/NextToken]))

(s/def
  :cognitect.aws.route53/CreateReusableDelegationSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateReusableDelegationSetRequest/CallerReference]
    :opt-un
    [:cognitect.aws.route53.CreateReusableDelegationSetRequest/HostedZoneId]))

(s/def
  :cognitect.aws.route53/ResourceRecordSetRegion
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ap-northeast-1" "eu-south-1" "eu-west-1" "ap-east-1" "ap-northeast-3" "us-east-2"
        "ap-southeast-2" "cn-north-1" "sa-east-1" "ap-southeast-1" "cn-northwest-1"
        "ap-northeast-2" "eu-west-3" "af-south-1" "ap-southeast-3" "ca-central-1" "eu-central-1"
        "eu-west-2" "me-south-1" "us-west-2" "us-east-1" "us-west-1" "ap-south-1" "eu-north-1"})))

(s/def
  :cognitect.aws.route53/ListTrafficPolicyInstancesByPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/TrafficPolicyId
     :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/TrafficPolicyVersion]
    :opt-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/TrafficPolicyInstanceNameMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/MaxItems
     :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/HostedZoneIdMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/TrafficPolicyInstanceTypeMarker]))

(s/def
  :cognitect.aws.route53/DeactivateKeySigningKeyResponse
  (s/keys :req-un [:cognitect.aws.route53.DeactivateKeySigningKeyResponse/ChangeInfo]))

(s/def
  :cognitect.aws.route53/DeleteTrafficPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.DeleteTrafficPolicyRequest/Id
     :cognitect.aws.route53.DeleteTrafficPolicyRequest/Version]))

(s/def
  :cognitect.aws.route53/CreateHealthCheckRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateHealthCheckRequest/CallerReference
     :cognitect.aws.route53.CreateHealthCheckRequest/HealthCheckConfig]))

(s/def
  :cognitect.aws.route53/CloudWatchAlarmConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.route53.CloudWatchAlarmConfiguration/EvaluationPeriods
     :cognitect.aws.route53.CloudWatchAlarmConfiguration/Threshold
     :cognitect.aws.route53.CloudWatchAlarmConfiguration/ComparisonOperator
     :cognitect.aws.route53.CloudWatchAlarmConfiguration/Period
     :cognitect.aws.route53.CloudWatchAlarmConfiguration/MetricName
     :cognitect.aws.route53.CloudWatchAlarmConfiguration/Namespace
     :cognitect.aws.route53.CloudWatchAlarmConfiguration/Statistic]
    :opt-un
    [:cognitect.aws.route53.CloudWatchAlarmConfiguration/Dimensions]))

(s/def
  :cognitect.aws.route53/GetGeoLocationResponse
  (s/keys :req-un [:cognitect.aws.route53.GetGeoLocationResponse/GeoLocationDetails]))

(s/def
  :cognitect.aws.route53/TrafficPolicyDocument
  (s/spec
    (s/and string? #(>= 102400 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 102400) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GetHealthCheckResponse
  (s/keys :req-un [:cognitect.aws.route53.GetHealthCheckResponse/HealthCheck]))

(s/def
  :cognitect.aws.route53/TagValue
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ActivateKeySigningKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ActivateKeySigningKeyRequest/HostedZoneId
     :cognitect.aws.route53.ActivateKeySigningKeyRequest/Name]))

(s/def
  :cognitect.aws.route53/ResettableElementNameList
  (s/coll-of :cognitect.aws.route53/ResettableElementName :max-count 64))

(s/def
  :cognitect.aws.route53/HostedZone
  (s/keys
    :req-un
    [:cognitect.aws.route53.HostedZone/Id
     :cognitect.aws.route53.HostedZone/Name
     :cognitect.aws.route53.HostedZone/CallerReference]
    :opt-un
    [:cognitect.aws.route53.HostedZone/Config
     :cognitect.aws.route53.HostedZone/LinkedService
     :cognitect.aws.route53.HostedZone/ResourceRecordSetCount]))

(s/def
  :cognitect.aws.route53/TagResourceId
  (s/spec
    (s/and string? #(>= 64 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GeoLocationCountryCode
  (s/spec
    (s/and string? #(<= 1 (count %) 2))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.route53/KeySigningKeys (s/coll-of :cognitect.aws.route53/KeySigningKey))

(s/def
  :cognitect.aws.route53/Nonce
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/Threshold
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.route53/ListReusableDelegationSetsResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListReusableDelegationSetsResponse/DelegationSets
     :cognitect.aws.route53.ListReusableDelegationSetsResponse/Marker
     :cognitect.aws.route53.ListReusableDelegationSetsResponse/IsTruncated
     :cognitect.aws.route53.ListReusableDelegationSetsResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListReusableDelegationSetsResponse/NextMarker]))

(s/def
  :cognitect.aws.route53/CreateQueryLoggingConfigResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateQueryLoggingConfigResponse/QueryLoggingConfig
     :cognitect.aws.route53.CreateQueryLoggingConfigResponse/Location]))

(s/def
  :cognitect.aws.route53/ListTagsForResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTagsForResourceRequest/ResourceType
     :cognitect.aws.route53.ListTagsForResourceRequest/ResourceId]))

(s/def
  :cognitect.aws.route53/ChangeInfo
  (s/keys
    :req-un
    [:cognitect.aws.route53.ChangeInfo/Id
     :cognitect.aws.route53.ChangeInfo/Status
     :cognitect.aws.route53.ChangeInfo/SubmittedAt]
    :opt-un
    [:cognitect.aws.route53.ChangeInfo/Comment]))

(s/def
  :cognitect.aws.route53/GetReusableDelegationSetResponse
  (s/keys :req-un [:cognitect.aws.route53.GetReusableDelegationSetResponse/DelegationSet]))

(s/def
  :cognitect.aws.route53/AssociateVPCWithHostedZoneRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.AssociateVPCWithHostedZoneRequest/HostedZoneId
     :cognitect.aws.route53.AssociateVPCWithHostedZoneRequest/VPC]
    :opt-un
    [:cognitect.aws.route53.AssociateVPCWithHostedZoneRequest/Comment]))

(s/def
  :cognitect.aws.route53/TagResourceIdList
  (s/coll-of :cognitect.aws.route53/TagResourceId :min-count 1 :max-count 10))

(s/def :cognitect.aws.route53/CloudWatchLogsLogGroupArn string?)

(s/def
  :cognitect.aws.route53/GetAccountLimitRequest
  (s/keys :req-un [:cognitect.aws.route53.GetAccountLimitRequest/Type]))

(s/def
  :cognitect.aws.route53/ActivateKeySigningKeyResponse
  (s/keys :req-un [:cognitect.aws.route53.ActivateKeySigningKeyResponse/ChangeInfo]))

(s/def
  :cognitect.aws.route53/Change
  (s/keys
    :req-un
    [:cognitect.aws.route53.Change/Action :cognitect.aws.route53.Change/ResourceRecordSet]))

(s/def :cognitect.aws.route53/TrafficPolicies (s/coll-of :cognitect.aws.route53/TrafficPolicy))

(s/def :cognitect.aws.route53/MeasureLatency boolean?)

(s/def
  :cognitect.aws.route53/TTL
  (s/spec (s/and int? #(<= 0 % 2147483647)) :gen #(gen/choose 0 2147483647)))

(s/def
  :cognitect.aws.route53/ListTrafficPolicyInstancesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesRequest/TrafficPolicyInstanceNameMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesRequest/MaxItems
     :cognitect.aws.route53.ListTrafficPolicyInstancesRequest/HostedZoneIdMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesRequest/TrafficPolicyInstanceTypeMarker]))

(s/def
  :cognitect.aws.route53/HealthCheckRegionList
  (s/coll-of :cognitect.aws.route53/HealthCheckRegion :min-count 3 :max-count 64))

(s/def :cognitect.aws.route53/EnableSNI boolean?)

(s/def
  :cognitect.aws.route53/GetReusableDelegationSetRequest
  (s/keys :req-un [:cognitect.aws.route53.GetReusableDelegationSetRequest/Id]))

(s/def
  :cognitect.aws.route53/HealthCheck
  (s/keys
    :req-un
    [:cognitect.aws.route53.HealthCheck/Id
     :cognitect.aws.route53.HealthCheck/CallerReference
     :cognitect.aws.route53.HealthCheck/HealthCheckConfig
     :cognitect.aws.route53.HealthCheck/HealthCheckVersion]
    :opt-un
    [:cognitect.aws.route53.HealthCheck/LinkedService
     :cognitect.aws.route53.HealthCheck/CloudWatchAlarmConfiguration]))

(s/def
  :cognitect.aws.route53/HealthThreshold
  (s/spec (s/and int? #(<= 0 % 256)) :gen #(gen/choose 0 256)))

(s/def
  :cognitect.aws.route53/StatusReport
  (s/keys
    :opt-un
    [:cognitect.aws.route53.StatusReport/CheckedTime :cognitect.aws.route53.StatusReport/Status]))

(s/def
  :cognitect.aws.route53/GetChangeResponse
  (s/keys :req-un [:cognitect.aws.route53.GetChangeResponse/ChangeInfo]))

(s/def :cognitect.aws.route53/HealthChecks (s/coll-of :cognitect.aws.route53/HealthCheck))

(s/def
  :cognitect.aws.route53/TestDNSAnswerRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.TestDNSAnswerRequest/HostedZoneId
     :cognitect.aws.route53.TestDNSAnswerRequest/RecordName
     :cognitect.aws.route53.TestDNSAnswerRequest/RecordType]
    :opt-un
    [:cognitect.aws.route53.TestDNSAnswerRequest/EDNS0ClientSubnetMask
     :cognitect.aws.route53.TestDNSAnswerRequest/EDNS0ClientSubnetIP
     :cognitect.aws.route53.TestDNSAnswerRequest/ResolverIP]))

(s/def
  :cognitect.aws.route53/HealthCheckId
  (s/spec
    (s/and string? #(>= 64 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ResourcePath
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/CreateHostedZoneRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateHostedZoneRequest/Name
     :cognitect.aws.route53.CreateHostedZoneRequest/CallerReference]
    :opt-un
    [:cognitect.aws.route53.CreateHostedZoneRequest/DelegationSetId
     :cognitect.aws.route53.CreateHostedZoneRequest/HostedZoneConfig
     :cognitect.aws.route53.CreateHostedZoneRequest/VPC]))

(s/def
  :cognitect.aws.route53/TrafficPolicyInstanceCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53/ListTrafficPolicyInstancesByHostedZoneRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneRequest/HostedZoneId]
    :opt-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneRequest/TrafficPolicyInstanceNameMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneRequest/MaxItems
     :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneRequest/TrafficPolicyInstanceTypeMarker]))

(s/def :cognitect.aws.route53/PageMaxItems string?)

(s/def
  :cognitect.aws.route53/ListTrafficPolicyInstancesByHostedZoneResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/TrafficPolicyInstances
     :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/IsTruncated
     :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/TrafficPolicyInstanceNameMarker
     :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/TrafficPolicyInstanceTypeMarker]))

(s/def
  :cognitect.aws.route53/ChangeResourceRecordSetsRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ChangeResourceRecordSetsRequest/HostedZoneId
     :cognitect.aws.route53.ChangeResourceRecordSetsRequest/ChangeBatch]))

(s/def :cognitect.aws.route53/ChangeTagsForResourceResponse (s/keys))

(s/def
  :cognitect.aws.route53/ChildHealthCheckList
  (s/coll-of :cognitect.aws.route53/HealthCheckId :max-count 256))

(s/def
  :cognitect.aws.route53/CreateTrafficPolicyResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateTrafficPolicyResponse/TrafficPolicy
     :cognitect.aws.route53.CreateTrafficPolicyResponse/Location]))

(s/def
  :cognitect.aws.route53/UpdateTrafficPolicyCommentResponse
  (s/keys :req-un [:cognitect.aws.route53.UpdateTrafficPolicyCommentResponse/TrafficPolicy]))

(s/def
  :cognitect.aws.route53/DisableHostedZoneDNSSECRequest
  (s/keys :req-un [:cognitect.aws.route53.DisableHostedZoneDNSSECRequest/HostedZoneId]))

(s/def
  :cognitect.aws.route53/Namespace
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GetTrafficPolicyInstanceCountResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetTrafficPolicyInstanceCountResponse/TrafficPolicyInstanceCount]))

(s/def
  :cognitect.aws.route53/Period
  (s/spec (s/and int? #(<= 60 %)) :gen #(gen/choose 60 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53/ListTrafficPolicyVersionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTrafficPolicyVersionsResponse/TrafficPolicies
     :cognitect.aws.route53.ListTrafficPolicyVersionsResponse/IsTruncated
     :cognitect.aws.route53.ListTrafficPolicyVersionsResponse/TrafficPolicyVersionMarker
     :cognitect.aws.route53.ListTrafficPolicyVersionsResponse/MaxItems]))

(s/def
  :cognitect.aws.route53/HostedZoneOwningService
  (s/spec
    (s/and string? #(>= 128 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ListHostedZonesResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListHostedZonesResponse/HostedZones
     :cognitect.aws.route53.ListHostedZonesResponse/Marker
     :cognitect.aws.route53.ListHostedZonesResponse/IsTruncated
     :cognitect.aws.route53.ListHostedZonesResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListHostedZonesResponse/NextMarker]))

(s/def :cognitect.aws.route53/Disabled boolean?)

(s/def
  :cognitect.aws.route53/VPCRegion
  (s/spec
    string?
    :gen
    #(s/gen
      #{"us-gov-east-1" "ap-northeast-1" "eu-south-1" "eu-west-1" "us-isob-east-1" "ap-east-1"
        "ap-northeast-3" "us-east-2" "ap-southeast-2" "cn-north-1" "sa-east-1" "ap-southeast-1"
        "ap-northeast-2" "eu-west-3" "us-iso-west-1" "us-iso-east-1" "af-south-1" "ap-southeast-3"
        "ca-central-1" "eu-central-1" "eu-west-2" "us-gov-west-1" "me-south-1" "us-west-2"
        "us-east-1" "us-west-1" "ap-south-1" "eu-north-1"})))

(s/def
  :cognitect.aws.route53/GetHealthCheckStatusResponse
  (s/keys :req-un [:cognitect.aws.route53.GetHealthCheckStatusResponse/HealthCheckObservations]))

(s/def
  :cognitect.aws.route53/EnableHostedZoneDNSSECRequest
  (s/keys :req-un [:cognitect.aws.route53.EnableHostedZoneDNSSECRequest/HostedZoneId]))

(s/def :cognitect.aws.route53/ResourceRecordSetMultiValueAnswer boolean?)

(s/def
  :cognitect.aws.route53/CreateTrafficPolicyInstanceRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/HostedZoneId
     :cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/Name
     :cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/TTL
     :cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/TrafficPolicyId
     :cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/TrafficPolicyVersion]))

(s/def
  :cognitect.aws.route53/HostedZoneSummaries
  (s/coll-of :cognitect.aws.route53/HostedZoneSummary))

(s/def :cognitect.aws.route53/Inverted boolean?)

(s/def
  :cognitect.aws.route53/LimitValue
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53/HealthCheckConfig
  (s/keys
    :req-un
    [:cognitect.aws.route53.HealthCheckConfig/Type]
    :opt-un
    [:cognitect.aws.route53.HealthCheckConfig/InsufficientDataHealthStatus
     :cognitect.aws.route53.HealthCheckConfig/Disabled
     :cognitect.aws.route53.HealthCheckConfig/SearchString
     :cognitect.aws.route53.HealthCheckConfig/RoutingControlArn
     :cognitect.aws.route53.HealthCheckConfig/FailureThreshold
     :cognitect.aws.route53.HealthCheckConfig/ChildHealthChecks
     :cognitect.aws.route53.HealthCheckConfig/Regions
     :cognitect.aws.route53.HealthCheckConfig/Port
     :cognitect.aws.route53.HealthCheckConfig/IPAddress
     :cognitect.aws.route53.HealthCheckConfig/ResourcePath
     :cognitect.aws.route53.HealthCheckConfig/AlarmIdentifier
     :cognitect.aws.route53.HealthCheckConfig/EnableSNI
     :cognitect.aws.route53.HealthCheckConfig/MeasureLatency
     :cognitect.aws.route53.HealthCheckConfig/HealthThreshold
     :cognitect.aws.route53.HealthCheckConfig/RequestInterval
     :cognitect.aws.route53.HealthCheckConfig/FullyQualifiedDomainName
     :cognitect.aws.route53.HealthCheckConfig/Inverted]))

(s/def
  :cognitect.aws.route53/GetDNSSECRequest
  (s/keys :req-un [:cognitect.aws.route53.GetDNSSECRequest/HostedZoneId]))

(s/def
  :cognitect.aws.route53/UpdateTrafficPolicyInstanceResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.UpdateTrafficPolicyInstanceResponse/TrafficPolicyInstance]))

(s/def :cognitect.aws.route53/DeleteQueryLoggingConfigResponse (s/keys))

(s/def
  :cognitect.aws.route53/GeoLocation
  (s/keys
    :opt-un
    [:cognitect.aws.route53.GeoLocation/CountryCode
     :cognitect.aws.route53.GeoLocation/ContinentCode
     :cognitect.aws.route53.GeoLocation/SubdivisionCode]))

(s/def
  :cognitect.aws.route53/ReusableDelegationSetLimitType
  (s/spec string? :gen #(s/gen #{"MAX_ZONES_BY_REUSABLE_DELEGATION_SET"})))

(s/def
  :cognitect.aws.route53/QueryLoggingConfigs
  (s/coll-of :cognitect.aws.route53/QueryLoggingConfig))

(s/def
  :cognitect.aws.route53/HostedZoneConfig
  (s/keys
    :opt-un
    [:cognitect.aws.route53.HostedZoneConfig/Comment
     :cognitect.aws.route53.HostedZoneConfig/PrivateZone]))

(s/def
  :cognitect.aws.route53/EnableHostedZoneDNSSECResponse
  (s/keys :req-un [:cognitect.aws.route53.EnableHostedZoneDNSSECResponse/ChangeInfo]))

(s/def
  :cognitect.aws.route53/ListHealthChecksRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53.ListHealthChecksRequest/Marker
     :cognitect.aws.route53.ListHealthChecksRequest/MaxItems]))

(s/def :cognitect.aws.route53/MaxResults string?)

(s/def
  :cognitect.aws.route53/ServicePrincipal
  (s/spec
    (s/and string? #(>= 128 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/TagKey
  (s/spec
    (s/and string? #(>= 128 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GetHostedZoneLimitRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetHostedZoneLimitRequest/Type
     :cognitect.aws.route53.GetHostedZoneLimitRequest/HostedZoneId]))

(s/def
  :cognitect.aws.route53/TagResourceType
  (s/spec string? :gen #(s/gen #{"healthcheck" "hostedzone"})))

(s/def
  :cognitect.aws.route53/GetHealthCheckStatusRequest
  (s/keys :req-un [:cognitect.aws.route53.GetHealthCheckStatusRequest/HealthCheckId]))

(s/def
  :cognitect.aws.route53/UpdateTrafficPolicyInstanceRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.UpdateTrafficPolicyInstanceRequest/Id
     :cognitect.aws.route53.UpdateTrafficPolicyInstanceRequest/TTL
     :cognitect.aws.route53.UpdateTrafficPolicyInstanceRequest/TrafficPolicyId
     :cognitect.aws.route53.UpdateTrafficPolicyInstanceRequest/TrafficPolicyVersion]))

(s/def :cognitect.aws.route53/GetCheckerIpRangesRequest (s/keys))

(s/def
  :cognitect.aws.route53/UpdateHostedZoneCommentRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.UpdateHostedZoneCommentRequest/Id]
    :opt-un
    [:cognitect.aws.route53.UpdateHostedZoneCommentRequest/Comment]))

(s/def
  :cognitect.aws.route53/UpdateHealthCheckResponse
  (s/keys :req-un [:cognitect.aws.route53.UpdateHealthCheckResponse/HealthCheck]))

(s/def
  :cognitect.aws.route53/ReusableDelegationSetLimit
  (s/keys
    :req-un
    [:cognitect.aws.route53.ReusableDelegationSetLimit/Type
     :cognitect.aws.route53.ReusableDelegationSetLimit/Value]))

(s/def
  :cognitect.aws.route53/CreateHealthCheckResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateHealthCheckResponse/HealthCheck
     :cognitect.aws.route53.CreateHealthCheckResponse/Location]))

(s/def
  :cognitect.aws.route53/ListHealthChecksResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListHealthChecksResponse/HealthChecks
     :cognitect.aws.route53.ListHealthChecksResponse/Marker
     :cognitect.aws.route53.ListHealthChecksResponse/IsTruncated
     :cognitect.aws.route53.ListHealthChecksResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListHealthChecksResponse/NextMarker]))

(s/def
  :cognitect.aws.route53/SigningKeyStatusMessage
  (s/spec
    (s/and string? #(<= 0 (count %) 512))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 512) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ChangeResourceRecordSetsResponse
  (s/keys :req-un [:cognitect.aws.route53.ChangeResourceRecordSetsResponse/ChangeInfo]))

(s/def
  :cognitect.aws.route53/ListGeoLocationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53.ListGeoLocationsRequest/StartSubdivisionCode
     :cognitect.aws.route53.ListGeoLocationsRequest/StartContinentCode
     :cognitect.aws.route53.ListGeoLocationsRequest/StartCountryCode
     :cognitect.aws.route53.ListGeoLocationsRequest/MaxItems]))

(s/def
  :cognitect.aws.route53/HealthCheckObservations
  (s/coll-of :cognitect.aws.route53/HealthCheckObservation))

(s/def
  :cognitect.aws.route53/HostedZoneSummary
  (s/keys
    :req-un
    [:cognitect.aws.route53.HostedZoneSummary/HostedZoneId
     :cognitect.aws.route53.HostedZoneSummary/Name
     :cognitect.aws.route53.HostedZoneSummary/Owner]))

(s/def
  :cognitect.aws.route53/LinkedService
  (s/keys
    :opt-un
    [:cognitect.aws.route53.LinkedService/ServicePrincipal
     :cognitect.aws.route53.LinkedService/Description]))

(s/def
  :cognitect.aws.route53/GetHostedZoneLimitResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetHostedZoneLimitResponse/Limit
     :cognitect.aws.route53.GetHostedZoneLimitResponse/Count]))

(s/def
  :cognitect.aws.route53/GetCheckerIpRangesResponse
  (s/keys :req-un [:cognitect.aws.route53.GetCheckerIpRangesResponse/CheckerIpRanges]))

(s/def
  :cognitect.aws.route53/ChangeAction
  (s/spec string? :gen #(s/gen #{"DELETE" "CREATE" "UPSERT"})))

(s/def :cognitect.aws.route53/AliasHealthEnabled boolean?)

(s/def
  :cognitect.aws.route53/TrafficPolicyComment
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/TrafficPolicyName
  (s/spec
    (s/and string? #(>= 512 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 512) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/DisassociateVPCFromHostedZoneRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.DisassociateVPCFromHostedZoneRequest/HostedZoneId
     :cognitect.aws.route53.DisassociateVPCFromHostedZoneRequest/VPC]
    :opt-un
    [:cognitect.aws.route53.DisassociateVPCFromHostedZoneRequest/Comment]))

(s/def
  :cognitect.aws.route53/ListGeoLocationsResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListGeoLocationsResponse/GeoLocationDetailsList
     :cognitect.aws.route53.ListGeoLocationsResponse/IsTruncated
     :cognitect.aws.route53.ListGeoLocationsResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListGeoLocationsResponse/NextSubdivisionCode
     :cognitect.aws.route53.ListGeoLocationsResponse/NextContinentCode
     :cognitect.aws.route53.ListGeoLocationsResponse/NextCountryCode]))

(s/def
  :cognitect.aws.route53/DeleteHostedZoneRequest
  (s/keys :req-un [:cognitect.aws.route53.DeleteHostedZoneRequest/Id]))

(s/def :cognitect.aws.route53/ChangeStatus (s/spec string? :gen #(s/gen #{"INSYNC" "PENDING"})))

(s/def :cognitect.aws.route53/TrafficPolicyInstanceState string?)

(s/def
  :cognitect.aws.route53/IPAddress
  (s/spec
    #(re-matches
      (re-pattern
        "(^((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))$|^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$)")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.route53/GetTrafficPolicyInstanceRequest
  (s/keys :req-un [:cognitect.aws.route53.GetTrafficPolicyInstanceRequest/Id]))

(s/def
  :cognitect.aws.route53/ListTrafficPoliciesResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTrafficPoliciesResponse/TrafficPolicySummaries
     :cognitect.aws.route53.ListTrafficPoliciesResponse/IsTruncated
     :cognitect.aws.route53.ListTrafficPoliciesResponse/TrafficPolicyIdMarker
     :cognitect.aws.route53.ListTrafficPoliciesResponse/MaxItems]))

(s/def
  :cognitect.aws.route53/CreateQueryLoggingConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateQueryLoggingConfigRequest/HostedZoneId
     :cognitect.aws.route53.CreateQueryLoggingConfigRequest/CloudWatchLogsLogGroupArn]))

(s/def
  :cognitect.aws.route53/DisableHostedZoneDNSSECResponse
  (s/keys :req-un [:cognitect.aws.route53.DisableHostedZoneDNSSECResponse/ChangeInfo]))

(s/def
  :cognitect.aws.route53/RData
  (s/spec
    (s/and string? #(>= 4000 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/GeoLocationSubdivisionCode
  (s/spec
    (s/and string? #(<= 1 (count %) 3))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 1 3) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ListReusableDelegationSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53.ListReusableDelegationSetsRequest/Marker
     :cognitect.aws.route53.ListReusableDelegationSetsRequest/MaxItems]))

(s/def
  :cognitect.aws.route53/AccountLimit
  (s/keys
    :req-un
    [:cognitect.aws.route53.AccountLimit/Type :cognitect.aws.route53.AccountLimit/Value]))

(s/def
  :cognitect.aws.route53/TrafficPolicyInstance
  (s/keys
    :req-un
    [:cognitect.aws.route53.TrafficPolicyInstance/Id
     :cognitect.aws.route53.TrafficPolicyInstance/HostedZoneId
     :cognitect.aws.route53.TrafficPolicyInstance/Name
     :cognitect.aws.route53.TrafficPolicyInstance/TTL
     :cognitect.aws.route53.TrafficPolicyInstance/State
     :cognitect.aws.route53.TrafficPolicyInstance/Message
     :cognitect.aws.route53.TrafficPolicyInstance/TrafficPolicyId
     :cognitect.aws.route53.TrafficPolicyInstance/TrafficPolicyVersion
     :cognitect.aws.route53.TrafficPolicyInstance/TrafficPolicyType]))

(s/def
  :cognitect.aws.route53/MetricName
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/UpdateTrafficPolicyCommentRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.UpdateTrafficPolicyCommentRequest/Id
     :cognitect.aws.route53.UpdateTrafficPolicyCommentRequest/Version
     :cognitect.aws.route53.UpdateTrafficPolicyCommentRequest/Comment]))

(s/def
  :cognitect.aws.route53/CreateReusableDelegationSetResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateReusableDelegationSetResponse/DelegationSet
     :cognitect.aws.route53.CreateReusableDelegationSetResponse/Location]))

(s/def
  :cognitect.aws.route53/GeoLocationDetailsList
  (s/coll-of :cognitect.aws.route53/GeoLocationDetails))

(s/def
  :cognitect.aws.route53/ListTagsForResourceResponse
  (s/keys :req-un [:cognitect.aws.route53.ListTagsForResourceResponse/ResourceTagSet]))

(s/def
  :cognitect.aws.route53/DelegationSetNameServers
  (s/coll-of :cognitect.aws.route53/DNSName :min-count 1))

(s/def
  :cognitect.aws.route53/GetHealthCheckCountResponse
  (s/keys :req-un [:cognitect.aws.route53.GetHealthCheckCountResponse/HealthCheckCount]))

(s/def
  :cognitect.aws.route53/TrafficPolicy
  (s/keys
    :req-un
    [:cognitect.aws.route53.TrafficPolicy/Id
     :cognitect.aws.route53.TrafficPolicy/Version
     :cognitect.aws.route53.TrafficPolicy/Name
     :cognitect.aws.route53.TrafficPolicy/Type
     :cognitect.aws.route53.TrafficPolicy/Document]
    :opt-un
    [:cognitect.aws.route53.TrafficPolicy/Comment]))

(s/def
  :cognitect.aws.route53/PaginationToken
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/CloudWatchRegion
  (s/spec
    string?
    :gen
    #(s/gen
      #{"us-gov-east-1" "ap-northeast-1" "eu-south-1" "eu-west-1" "us-isob-east-1" "ap-east-1"
        "ap-northeast-3" "us-east-2" "ap-southeast-2" "cn-north-1" "sa-east-1" "ap-southeast-1"
        "cn-northwest-1" "ap-northeast-2" "eu-west-3" "us-iso-west-1" "us-iso-east-1" "af-south-1"
        "ap-southeast-3" "ca-central-1" "eu-central-1" "eu-west-2" "us-gov-west-1" "me-south-1"
        "us-west-2" "us-east-1" "us-west-1" "ap-south-1" "eu-north-1"})))

(s/def
  :cognitect.aws.route53/CreateHostedZoneResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateHostedZoneResponse/HostedZone
     :cognitect.aws.route53.CreateHostedZoneResponse/ChangeInfo
     :cognitect.aws.route53.CreateHostedZoneResponse/DelegationSet
     :cognitect.aws.route53.CreateHostedZoneResponse/Location]
    :opt-un
    [:cognitect.aws.route53.CreateHostedZoneResponse/VPC]))

(s/def :cognitect.aws.route53/RecordData (s/coll-of :cognitect.aws.route53/RecordDataEntry))

(s/def :cognitect.aws.route53/SigningKeyString string?)

(s/def
  :cognitect.aws.route53/ListResourceRecordSetsResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListResourceRecordSetsResponse/ResourceRecordSets
     :cognitect.aws.route53.ListResourceRecordSetsResponse/IsTruncated
     :cognitect.aws.route53.ListResourceRecordSetsResponse/MaxItems]
    :opt-un
    [:cognitect.aws.route53.ListResourceRecordSetsResponse/NextRecordType
     :cognitect.aws.route53.ListResourceRecordSetsResponse/NextRecordName
     :cognitect.aws.route53.ListResourceRecordSetsResponse/NextRecordIdentifier]))

(s/def
  :cognitect.aws.route53/ListTagsForResourcesRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.ListTagsForResourcesRequest/ResourceType
     :cognitect.aws.route53.ListTagsForResourcesRequest/ResourceIds]))

(s/def
  :cognitect.aws.route53/ResourceDescription
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53/ListHostedZonesByNameRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53.ListHostedZonesByNameRequest/HostedZoneId
     :cognitect.aws.route53.ListHostedZonesByNameRequest/DNSName
     :cognitect.aws.route53.ListHostedZonesByNameRequest/MaxItems]))

(s/def :cognitect.aws.route53/GetHostedZoneCountRequest (s/keys))

(s/def
  :cognitect.aws.route53/ListQueryLoggingConfigsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53.ListQueryLoggingConfigsRequest/NextToken
     :cognitect.aws.route53.ListQueryLoggingConfigsRequest/HostedZoneId
     :cognitect.aws.route53.ListQueryLoggingConfigsRequest/MaxResults]))

(s/def
  :cognitect.aws.route53/GetHealthCheckLastFailureReasonResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetHealthCheckLastFailureReasonResponse/HealthCheckObservations]))

(s/def
  :cognitect.aws.route53/GetTrafficPolicyInstanceResponse
  (s/keys :req-un [:cognitect.aws.route53.GetTrafficPolicyInstanceResponse/TrafficPolicyInstance]))

(s/def
  :cognitect.aws.route53/ResourceTagSet
  (s/keys
    :opt-un
    [:cognitect.aws.route53.ResourceTagSet/Tags
     :cognitect.aws.route53.ResourceTagSet/ResourceId
     :cognitect.aws.route53.ResourceTagSet/ResourceType]))

(s/def
  :cognitect.aws.route53/GetQueryLoggingConfigResponse
  (s/keys :req-un [:cognitect.aws.route53.GetQueryLoggingConfigResponse/QueryLoggingConfig]))

(s/def
  :cognitect.aws.route53/CreateVPCAssociationAuthorizationResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.CreateVPCAssociationAuthorizationResponse/HostedZoneId
     :cognitect.aws.route53.CreateVPCAssociationAuthorizationResponse/VPC]))

(s/def
  :cognitect.aws.route53/GetTrafficPolicyResponse
  (s/keys :req-un [:cognitect.aws.route53.GetTrafficPolicyResponse/TrafficPolicy]))

(s/def
  :cognitect.aws.route53/UpdateHealthCheckRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53.UpdateHealthCheckRequest/HealthCheckId]
    :opt-un
    [:cognitect.aws.route53.UpdateHealthCheckRequest/InsufficientDataHealthStatus
     :cognitect.aws.route53.UpdateHealthCheckRequest/Disabled
     :cognitect.aws.route53.UpdateHealthCheckRequest/SearchString
     :cognitect.aws.route53.UpdateHealthCheckRequest/HealthCheckVersion
     :cognitect.aws.route53.UpdateHealthCheckRequest/FailureThreshold
     :cognitect.aws.route53.UpdateHealthCheckRequest/ChildHealthChecks
     :cognitect.aws.route53.UpdateHealthCheckRequest/Regions
     :cognitect.aws.route53.UpdateHealthCheckRequest/Port
     :cognitect.aws.route53.UpdateHealthCheckRequest/IPAddress
     :cognitect.aws.route53.UpdateHealthCheckRequest/ResourcePath
     :cognitect.aws.route53.UpdateHealthCheckRequest/AlarmIdentifier
     :cognitect.aws.route53.UpdateHealthCheckRequest/EnableSNI
     :cognitect.aws.route53.UpdateHealthCheckRequest/ResetElements
     :cognitect.aws.route53.UpdateHealthCheckRequest/HealthThreshold
     :cognitect.aws.route53.UpdateHealthCheckRequest/FullyQualifiedDomainName
     :cognitect.aws.route53.UpdateHealthCheckRequest/Inverted]))

(s/def
  :cognitect.aws.route53/GetReusableDelegationSetLimitResponse
  (s/keys
    :req-un
    [:cognitect.aws.route53.GetReusableDelegationSetLimitResponse/Limit
     :cognitect.aws.route53.GetReusableDelegationSetLimitResponse/Count]))

(s/def
  :cognitect.aws.route53/HostedZoneLimit
  (s/keys
    :req-un
    [:cognitect.aws.route53.HostedZoneLimit/Type :cognitect.aws.route53.HostedZoneLimit/Value]))

(s/def
  :cognitect.aws.route53/TagKeyList
  (s/coll-of :cognitect.aws.route53/TagKey :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.route53/DNSSECStatus
  (s/keys
    :opt-un
    [:cognitect.aws.route53.DNSSECStatus/StatusMessage
     :cognitect.aws.route53.DNSSECStatus/ServeSignature]))

(s/def
  :cognitect.aws.route53/DisassociateVPCFromHostedZoneResponse
  (s/keys :req-un [:cognitect.aws.route53.DisassociateVPCFromHostedZoneResponse/ChangeInfo]))

(s/def :cognitect.aws.route53/Status string?)

(s/def
  :cognitect.aws.route53/ResourceURI
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.route53/DeleteTrafficPolicyInstanceResponse (s/keys))

(s/def
  :cognitect.aws.route53.GetHostedZoneCountResponse/HostedZoneCount
  :cognitect.aws.route53/HostedZoneCount)

(s/def
  :cognitect.aws.route53.DeleteReusableDelegationSetRequest/Id
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListQueryLoggingConfigsResponse/QueryLoggingConfigs
  :cognitect.aws.route53/QueryLoggingConfigs)

(s/def
  :cognitect.aws.route53.ListQueryLoggingConfigsResponse/NextToken
  :cognitect.aws.route53/PaginationToken)

(s/def :cognitect.aws.route53.GetHostedZoneResponse/HostedZone :cognitect.aws.route53/HostedZone)

(s/def
  :cognitect.aws.route53.GetHostedZoneResponse/DelegationSet
  :cognitect.aws.route53/DelegationSet)

(s/def :cognitect.aws.route53.GetHostedZoneResponse/VPCs :cognitect.aws.route53/VPCs)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyRequest/Name
  :cognitect.aws.route53/TrafficPolicyName)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyRequest/Document
  :cognitect.aws.route53/TrafficPolicyDocument)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyRequest/Comment
  :cognitect.aws.route53/TrafficPolicyComment)

(s/def :cognitect.aws.route53.VPC/VPCRegion :cognitect.aws.route53/VPCRegion)

(s/def :cognitect.aws.route53.VPC/VPCId :cognitect.aws.route53/VPCId)

(s/def :cognitect.aws.route53.GetChangeRequest/Id :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/TrafficPolicyInstances
  :cognitect.aws.route53/TrafficPolicyInstances)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/HostedZoneIdMarker
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/TrafficPolicyInstanceNameMarker
  :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/TrafficPolicyInstanceTypeMarker
  :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesResponse/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def :cognitect.aws.route53.GetAccountLimitResponse/Limit :cognitect.aws.route53/AccountLimit)

(s/def :cognitect.aws.route53.GetAccountLimitResponse/Count :cognitect.aws.route53/UsageCount)

(s/def :cognitect.aws.route53.GetDNSSECResponse/Status :cognitect.aws.route53/DNSSECStatus)

(s/def
  :cognitect.aws.route53.GetDNSSECResponse/KeySigningKeys
  :cognitect.aws.route53/KeySigningKeys)

(s/def :cognitect.aws.route53.GetTrafficPolicyRequest/Id :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.GetTrafficPolicyRequest/Version
  :cognitect.aws.route53/TrafficPolicyVersion)

(s/def
  :cognitect.aws.route53.ListVPCAssociationAuthorizationsResponse/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListVPCAssociationAuthorizationsResponse/NextToken
  :cognitect.aws.route53/PaginationToken)

(s/def
  :cognitect.aws.route53.ListVPCAssociationAuthorizationsResponse/VPCs
  :cognitect.aws.route53/VPCs)

(s/def :cognitect.aws.route53.Tag/Key :cognitect.aws.route53/TagKey)

(s/def :cognitect.aws.route53.Tag/Value :cognitect.aws.route53/TagValue)

(s/def
  :cognitect.aws.route53.ResourceRecordSet/TrafficPolicyInstanceId
  :cognitect.aws.route53/TrafficPolicyInstanceId)

(s/def :cognitect.aws.route53.ResourceRecordSet/AliasTarget :cognitect.aws.route53/AliasTarget)

(s/def
  :cognitect.aws.route53.ResourceRecordSet/MultiValueAnswer
  :cognitect.aws.route53/ResourceRecordSetMultiValueAnswer)

(s/def
  :cognitect.aws.route53.ResourceRecordSet/Failover
  :cognitect.aws.route53/ResourceRecordSetFailover)

(s/def
  :cognitect.aws.route53.ResourceRecordSet/ResourceRecords
  :cognitect.aws.route53/ResourceRecords)

(s/def
  :cognitect.aws.route53.ResourceRecordSet/SetIdentifier
  :cognitect.aws.route53/ResourceRecordSetIdentifier)

(s/def :cognitect.aws.route53.ResourceRecordSet/TTL :cognitect.aws.route53/TTL)

(s/def
  :cognitect.aws.route53.ResourceRecordSet/Region
  :cognitect.aws.route53/ResourceRecordSetRegion)

(s/def :cognitect.aws.route53.ResourceRecordSet/HealthCheckId :cognitect.aws.route53/HealthCheckId)

(s/def :cognitect.aws.route53.ResourceRecordSet/GeoLocation :cognitect.aws.route53/GeoLocation)

(s/def :cognitect.aws.route53.ResourceRecordSet/Name :cognitect.aws.route53/DNSName)

(s/def :cognitect.aws.route53.ResourceRecordSet/Type :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.ResourceRecordSet/Weight
  :cognitect.aws.route53/ResourceRecordSetWeight)

(s/def
  :cognitect.aws.route53.GeoLocationDetails/ContinentCode
  :cognitect.aws.route53/GeoLocationContinentCode)

(s/def
  :cognitect.aws.route53.GeoLocationDetails/ContinentName
  :cognitect.aws.route53/GeoLocationContinentName)

(s/def
  :cognitect.aws.route53.GeoLocationDetails/CountryCode
  :cognitect.aws.route53/GeoLocationCountryCode)

(s/def
  :cognitect.aws.route53.GeoLocationDetails/CountryName
  :cognitect.aws.route53/GeoLocationCountryName)

(s/def
  :cognitect.aws.route53.GeoLocationDetails/SubdivisionCode
  :cognitect.aws.route53/GeoLocationSubdivisionCode)

(s/def
  :cognitect.aws.route53.GeoLocationDetails/SubdivisionName
  :cognitect.aws.route53/GeoLocationSubdivisionName)

(s/def :cognitect.aws.route53.Dimension/Name :cognitect.aws.route53/DimensionField)

(s/def :cognitect.aws.route53.Dimension/Value :cognitect.aws.route53/DimensionField)

(s/def
  :cognitect.aws.route53.CreateKeySigningKeyResponse/ChangeInfo
  :cognitect.aws.route53/ChangeInfo)

(s/def
  :cognitect.aws.route53.CreateKeySigningKeyResponse/KeySigningKey
  :cognitect.aws.route53/KeySigningKey)

(s/def
  :cognitect.aws.route53.CreateKeySigningKeyResponse/Location
  :cognitect.aws.route53/ResourceURI)

(s/def
  :cognitect.aws.route53.HealthCheckObservation/Region
  :cognitect.aws.route53/HealthCheckRegion)

(s/def :cognitect.aws.route53.HealthCheckObservation/IPAddress :cognitect.aws.route53/IPAddress)

(s/def
  :cognitect.aws.route53.HealthCheckObservation/StatusReport
  :cognitect.aws.route53/StatusReport)

(s/def :cognitect.aws.route53.AlarmIdentifier/Region :cognitect.aws.route53/CloudWatchRegion)

(s/def :cognitect.aws.route53.AlarmIdentifier/Name :cognitect.aws.route53/AlarmName)

(s/def
  :cognitect.aws.route53.DeleteTrafficPolicyInstanceRequest/Id
  :cognitect.aws.route53/TrafficPolicyInstanceId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyVersionsRequest/Id
  :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyVersionsRequest/TrafficPolicyVersionMarker
  :cognitect.aws.route53/TrafficPolicyVersionMarker)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyVersionsRequest/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def :cognitect.aws.route53.GetHostedZoneRequest/Id :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ChangeTagsForResourceRequest/ResourceType
  :cognitect.aws.route53/TagResourceType)

(s/def
  :cognitect.aws.route53.ChangeTagsForResourceRequest/ResourceId
  :cognitect.aws.route53/TagResourceId)

(s/def :cognitect.aws.route53.ChangeTagsForResourceRequest/AddTags :cognitect.aws.route53/TagList)

(s/def
  :cognitect.aws.route53.ChangeTagsForResourceRequest/RemoveTagKeys
  :cognitect.aws.route53/TagKeyList)

(s/def
  :cognitect.aws.route53.CreateVPCAssociationAuthorizationRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.CreateVPCAssociationAuthorizationRequest/VPC
  :cognitect.aws.route53/VPC)

(s/def :cognitect.aws.route53.AliasTarget/HostedZoneId :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.AliasTarget/DNSName :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.AliasTarget/EvaluateTargetHealth
  :cognitect.aws.route53/AliasHealthEnabled)

(s/def :cognitect.aws.route53.ListHostedZonesRequest/Marker :cognitect.aws.route53/PageMarker)

(s/def :cognitect.aws.route53.ListHostedZonesRequest/MaxItems :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ListHostedZonesRequest/DelegationSetId
  :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.DeleteHostedZoneResponse/ChangeInfo :cognitect.aws.route53/ChangeInfo)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyInstanceResponse/TrafficPolicyInstance
  :cognitect.aws.route53/TrafficPolicyInstance)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyInstanceResponse/Location
  :cognitect.aws.route53/ResourceURI)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsRequest/StartRecordName
  :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsRequest/StartRecordType
  :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsRequest/StartRecordIdentifier
  :cognitect.aws.route53/ResourceRecordSetIdentifier)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsRequest/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.GetHealthCheckLastFailureReasonRequest/HealthCheckId
  :cognitect.aws.route53/HealthCheckId)

(s/def :cognitect.aws.route53.KeySigningKey/LastModifiedDate :cognitect.aws.route53/TimeStamp)

(s/def
  :cognitect.aws.route53.KeySigningKey/SigningAlgorithmType
  :cognitect.aws.route53/SigningKeyInteger)

(s/def :cognitect.aws.route53.KeySigningKey/DNSKEYRecord :cognitect.aws.route53/SigningKeyString)

(s/def
  :cognitect.aws.route53.KeySigningKey/DigestAlgorithmMnemonic
  :cognitect.aws.route53/SigningKeyString)

(s/def :cognitect.aws.route53.KeySigningKey/CreatedDate :cognitect.aws.route53/TimeStamp)

(s/def :cognitect.aws.route53.KeySigningKey/KmsArn :cognitect.aws.route53/SigningKeyString)

(s/def
  :cognitect.aws.route53.KeySigningKey/DigestAlgorithmType
  :cognitect.aws.route53/SigningKeyInteger)

(s/def :cognitect.aws.route53.KeySigningKey/KeyTag :cognitect.aws.route53/SigningKeyTag)

(s/def :cognitect.aws.route53.KeySigningKey/PublicKey :cognitect.aws.route53/SigningKeyString)

(s/def :cognitect.aws.route53.KeySigningKey/Flag :cognitect.aws.route53/SigningKeyInteger)

(s/def :cognitect.aws.route53.KeySigningKey/DSRecord :cognitect.aws.route53/SigningKeyString)

(s/def
  :cognitect.aws.route53.KeySigningKey/SigningAlgorithmMnemonic
  :cognitect.aws.route53/SigningKeyString)

(s/def :cognitect.aws.route53.KeySigningKey/Name :cognitect.aws.route53/SigningKeyName)

(s/def :cognitect.aws.route53.KeySigningKey/DigestValue :cognitect.aws.route53/SigningKeyString)

(s/def
  :cognitect.aws.route53.KeySigningKey/StatusMessage
  :cognitect.aws.route53/SigningKeyStatusMessage)

(s/def :cognitect.aws.route53.KeySigningKey/Status :cognitect.aws.route53/SigningKeyStatus)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/TrafficPolicyInstances
  :cognitect.aws.route53/TrafficPolicyInstances)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/HostedZoneIdMarker
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/TrafficPolicyInstanceNameMarker
  :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/TrafficPolicyInstanceTypeMarker
  :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyResponse/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ListHostedZonesByNameResponse/HostedZones
  :cognitect.aws.route53/HostedZones)

(s/def :cognitect.aws.route53.ListHostedZonesByNameResponse/DNSName :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListHostedZonesByNameResponse/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListHostedZonesByNameResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def
  :cognitect.aws.route53.ListHostedZonesByNameResponse/NextDNSName
  :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListHostedZonesByNameResponse/NextHostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListHostedZonesByNameResponse/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def :cognitect.aws.route53.TestDNSAnswerResponse/Nameserver :cognitect.aws.route53/Nameserver)

(s/def :cognitect.aws.route53.TestDNSAnswerResponse/RecordName :cognitect.aws.route53/DNSName)

(s/def :cognitect.aws.route53.TestDNSAnswerResponse/RecordType :cognitect.aws.route53/RRType)

(s/def :cognitect.aws.route53.TestDNSAnswerResponse/RecordData :cognitect.aws.route53/RecordData)

(s/def :cognitect.aws.route53.TestDNSAnswerResponse/ResponseCode :cognitect.aws.route53/DNSRCode)

(s/def
  :cognitect.aws.route53.TestDNSAnswerResponse/Protocol
  :cognitect.aws.route53/TransportProtocol)

(s/def :cognitect.aws.route53.ChangeBatch/Comment :cognitect.aws.route53/ResourceDescription)

(s/def :cognitect.aws.route53.ChangeBatch/Changes :cognitect.aws.route53/Changes)

(s/def :cognitect.aws.route53.TrafficPolicySummary/Id :cognitect.aws.route53/TrafficPolicyId)

(s/def :cognitect.aws.route53.TrafficPolicySummary/Name :cognitect.aws.route53/TrafficPolicyName)

(s/def :cognitect.aws.route53.TrafficPolicySummary/Type :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.TrafficPolicySummary/LatestVersion
  :cognitect.aws.route53/TrafficPolicyVersion)

(s/def
  :cognitect.aws.route53.TrafficPolicySummary/TrafficPolicyCount
  :cognitect.aws.route53/TrafficPolicyVersion)

(s/def
  :cognitect.aws.route53.DeleteVPCAssociationAuthorizationRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.DeleteVPCAssociationAuthorizationRequest/VPC
  :cognitect.aws.route53/VPC)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyVersionResponse/TrafficPolicy
  :cognitect.aws.route53/TrafficPolicy)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyVersionResponse/Location
  :cognitect.aws.route53/ResourceURI)

(s/def :cognitect.aws.route53.ResourceRecord/Value :cognitect.aws.route53/RData)

(s/def
  :cognitect.aws.route53.DeleteKeySigningKeyResponse/ChangeInfo
  :cognitect.aws.route53/ChangeInfo)

(s/def :cognitect.aws.route53.DelegationSet/Id :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.DelegationSet/CallerReference :cognitect.aws.route53/Nonce)

(s/def
  :cognitect.aws.route53.DelegationSet/NameServers
  :cognitect.aws.route53/DelegationSetNameServers)

(s/def
  :cognitect.aws.route53.DeleteQueryLoggingConfigRequest/Id
  :cognitect.aws.route53/QueryLoggingConfigId)

(s/def
  :cognitect.aws.route53.DeactivateKeySigningKeyRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.DeactivateKeySigningKeyRequest/Name
  :cognitect.aws.route53/SigningKeyName)

(s/def
  :cognitect.aws.route53.CreateKeySigningKeyRequest/CallerReference
  :cognitect.aws.route53/Nonce)

(s/def
  :cognitect.aws.route53.CreateKeySigningKeyRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.CreateKeySigningKeyRequest/KeyManagementServiceArn
  :cognitect.aws.route53/SigningKeyString)

(s/def :cognitect.aws.route53.CreateKeySigningKeyRequest/Name :cognitect.aws.route53/SigningKeyName)

(s/def
  :cognitect.aws.route53.CreateKeySigningKeyRequest/Status
  :cognitect.aws.route53/SigningKeyStatus)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyVersionRequest/Id
  :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyVersionRequest/Document
  :cognitect.aws.route53/TrafficPolicyDocument)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyVersionRequest/Comment
  :cognitect.aws.route53/TrafficPolicyComment)

(s/def
  :cognitect.aws.route53.DeleteHealthCheckRequest/HealthCheckId
  :cognitect.aws.route53/HealthCheckId)

(s/def
  :cognitect.aws.route53.ListVPCAssociationAuthorizationsRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListVPCAssociationAuthorizationsRequest/NextToken
  :cognitect.aws.route53/PaginationToken)

(s/def
  :cognitect.aws.route53.ListVPCAssociationAuthorizationsRequest/MaxResults
  :cognitect.aws.route53/MaxResults)

(s/def
  :cognitect.aws.route53.GetHealthCheckRequest/HealthCheckId
  :cognitect.aws.route53/HealthCheckId)

(s/def :cognitect.aws.route53.HostedZoneOwner/OwningAccount :cognitect.aws.route53/AWSAccountID)

(s/def
  :cognitect.aws.route53.HostedZoneOwner/OwningService
  :cognitect.aws.route53/HostedZoneOwningService)

(s/def
  :cognitect.aws.route53.GetReusableDelegationSetLimitRequest/Type
  :cognitect.aws.route53/ReusableDelegationSetLimitType)

(s/def
  :cognitect.aws.route53.GetReusableDelegationSetLimitRequest/DelegationSetId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListTrafficPoliciesRequest/TrafficPolicyIdMarker
  :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.ListTrafficPoliciesRequest/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.AssociateVPCWithHostedZoneResponse/ChangeInfo
  :cognitect.aws.route53/ChangeInfo)

(s/def
  :cognitect.aws.route53.UpdateHostedZoneCommentResponse/HostedZone
  :cognitect.aws.route53/HostedZone)

(s/def :cognitect.aws.route53.QueryLoggingConfig/Id :cognitect.aws.route53/QueryLoggingConfigId)

(s/def :cognitect.aws.route53.QueryLoggingConfig/HostedZoneId :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.QueryLoggingConfig/CloudWatchLogsLogGroupArn
  :cognitect.aws.route53/CloudWatchLogsLogGroupArn)

(s/def :cognitect.aws.route53.ListHostedZonesByVPCRequest/VPCId :cognitect.aws.route53/VPCId)

(s/def
  :cognitect.aws.route53.ListHostedZonesByVPCRequest/VPCRegion
  :cognitect.aws.route53/VPCRegion)

(s/def
  :cognitect.aws.route53.ListHostedZonesByVPCRequest/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ListHostedZonesByVPCRequest/NextToken
  :cognitect.aws.route53/PaginationToken)

(s/def
  :cognitect.aws.route53.GetQueryLoggingConfigRequest/Id
  :cognitect.aws.route53/QueryLoggingConfigId)

(s/def
  :cognitect.aws.route53.GetGeoLocationRequest/ContinentCode
  :cognitect.aws.route53/GeoLocationContinentCode)

(s/def
  :cognitect.aws.route53.GetGeoLocationRequest/CountryCode
  :cognitect.aws.route53/GeoLocationCountryCode)

(s/def
  :cognitect.aws.route53.GetGeoLocationRequest/SubdivisionCode
  :cognitect.aws.route53/GeoLocationSubdivisionCode)

(s/def
  :cognitect.aws.route53.DeleteKeySigningKeyRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.DeleteKeySigningKeyRequest/Name :cognitect.aws.route53/SigningKeyName)

(s/def
  :cognitect.aws.route53.ListTagsForResourcesResponse/ResourceTagSets
  :cognitect.aws.route53/ResourceTagSetList)

(s/def
  :cognitect.aws.route53.ListHostedZonesByVPCResponse/HostedZoneSummaries
  :cognitect.aws.route53/HostedZoneSummaries)

(s/def
  :cognitect.aws.route53.ListHostedZonesByVPCResponse/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ListHostedZonesByVPCResponse/NextToken
  :cognitect.aws.route53/PaginationToken)

(s/def
  :cognitect.aws.route53.CreateReusableDelegationSetRequest/CallerReference
  :cognitect.aws.route53/Nonce)

(s/def
  :cognitect.aws.route53.CreateReusableDelegationSetRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/TrafficPolicyId
  :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/TrafficPolicyVersion
  :cognitect.aws.route53/TrafficPolicyVersion)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/HostedZoneIdMarker
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/TrafficPolicyInstanceNameMarker
  :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/TrafficPolicyInstanceTypeMarker
  :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByPolicyRequest/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.DeactivateKeySigningKeyResponse/ChangeInfo
  :cognitect.aws.route53/ChangeInfo)

(s/def :cognitect.aws.route53.DeleteTrafficPolicyRequest/Id :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.DeleteTrafficPolicyRequest/Version
  :cognitect.aws.route53/TrafficPolicyVersion)

(s/def
  :cognitect.aws.route53.CreateHealthCheckRequest/CallerReference
  :cognitect.aws.route53/HealthCheckNonce)

(s/def
  :cognitect.aws.route53.CreateHealthCheckRequest/HealthCheckConfig
  :cognitect.aws.route53/HealthCheckConfig)

(s/def
  :cognitect.aws.route53.CloudWatchAlarmConfiguration/EvaluationPeriods
  :cognitect.aws.route53/EvaluationPeriods)

(s/def
  :cognitect.aws.route53.CloudWatchAlarmConfiguration/Threshold
  :cognitect.aws.route53/Threshold)

(s/def
  :cognitect.aws.route53.CloudWatchAlarmConfiguration/ComparisonOperator
  :cognitect.aws.route53/ComparisonOperator)

(s/def :cognitect.aws.route53.CloudWatchAlarmConfiguration/Period :cognitect.aws.route53/Period)

(s/def
  :cognitect.aws.route53.CloudWatchAlarmConfiguration/MetricName
  :cognitect.aws.route53/MetricName)

(s/def
  :cognitect.aws.route53.CloudWatchAlarmConfiguration/Namespace
  :cognitect.aws.route53/Namespace)

(s/def
  :cognitect.aws.route53.CloudWatchAlarmConfiguration/Statistic
  :cognitect.aws.route53/Statistic)

(s/def
  :cognitect.aws.route53.CloudWatchAlarmConfiguration/Dimensions
  :cognitect.aws.route53/DimensionList)

(s/def
  :cognitect.aws.route53.GetGeoLocationResponse/GeoLocationDetails
  :cognitect.aws.route53/GeoLocationDetails)

(s/def :cognitect.aws.route53.GetHealthCheckResponse/HealthCheck :cognitect.aws.route53/HealthCheck)

(s/def
  :cognitect.aws.route53.ActivateKeySigningKeyRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ActivateKeySigningKeyRequest/Name
  :cognitect.aws.route53/SigningKeyName)

(s/def :cognitect.aws.route53.HostedZone/Id :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.HostedZone/Name :cognitect.aws.route53/DNSName)

(s/def :cognitect.aws.route53.HostedZone/CallerReference :cognitect.aws.route53/Nonce)

(s/def :cognitect.aws.route53.HostedZone/Config :cognitect.aws.route53/HostedZoneConfig)

(s/def
  :cognitect.aws.route53.HostedZone/ResourceRecordSetCount
  :cognitect.aws.route53/HostedZoneRRSetCount)

(s/def :cognitect.aws.route53.HostedZone/LinkedService :cognitect.aws.route53/LinkedService)

(s/def
  :cognitect.aws.route53.ListReusableDelegationSetsResponse/DelegationSets
  :cognitect.aws.route53/DelegationSets)

(s/def
  :cognitect.aws.route53.ListReusableDelegationSetsResponse/Marker
  :cognitect.aws.route53/PageMarker)

(s/def
  :cognitect.aws.route53.ListReusableDelegationSetsResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def
  :cognitect.aws.route53.ListReusableDelegationSetsResponse/NextMarker
  :cognitect.aws.route53/PageMarker)

(s/def
  :cognitect.aws.route53.ListReusableDelegationSetsResponse/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.CreateQueryLoggingConfigResponse/QueryLoggingConfig
  :cognitect.aws.route53/QueryLoggingConfig)

(s/def
  :cognitect.aws.route53.CreateQueryLoggingConfigResponse/Location
  :cognitect.aws.route53/ResourceURI)

(s/def
  :cognitect.aws.route53.ListTagsForResourceRequest/ResourceType
  :cognitect.aws.route53/TagResourceType)

(s/def
  :cognitect.aws.route53.ListTagsForResourceRequest/ResourceId
  :cognitect.aws.route53/TagResourceId)

(s/def :cognitect.aws.route53.ChangeInfo/Id :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.ChangeInfo/Status :cognitect.aws.route53/ChangeStatus)

(s/def :cognitect.aws.route53.ChangeInfo/SubmittedAt :cognitect.aws.route53/TimeStamp)

(s/def :cognitect.aws.route53.ChangeInfo/Comment :cognitect.aws.route53/ResourceDescription)

(s/def
  :cognitect.aws.route53.GetReusableDelegationSetResponse/DelegationSet
  :cognitect.aws.route53/DelegationSet)

(s/def
  :cognitect.aws.route53.AssociateVPCWithHostedZoneRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.AssociateVPCWithHostedZoneRequest/VPC :cognitect.aws.route53/VPC)

(s/def
  :cognitect.aws.route53.AssociateVPCWithHostedZoneRequest/Comment
  :cognitect.aws.route53/AssociateVPCComment)

(s/def :cognitect.aws.route53.GetAccountLimitRequest/Type :cognitect.aws.route53/AccountLimitType)

(s/def
  :cognitect.aws.route53.ActivateKeySigningKeyResponse/ChangeInfo
  :cognitect.aws.route53/ChangeInfo)

(s/def :cognitect.aws.route53.Change/Action :cognitect.aws.route53/ChangeAction)

(s/def :cognitect.aws.route53.Change/ResourceRecordSet :cognitect.aws.route53/ResourceRecordSet)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesRequest/HostedZoneIdMarker
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesRequest/TrafficPolicyInstanceNameMarker
  :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesRequest/TrafficPolicyInstanceTypeMarker
  :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesRequest/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def :cognitect.aws.route53.GetReusableDelegationSetRequest/Id :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.HealthCheck/Id :cognitect.aws.route53/HealthCheckId)

(s/def :cognitect.aws.route53.HealthCheck/CallerReference :cognitect.aws.route53/HealthCheckNonce)

(s/def :cognitect.aws.route53.HealthCheck/LinkedService :cognitect.aws.route53/LinkedService)

(s/def
  :cognitect.aws.route53.HealthCheck/HealthCheckConfig
  :cognitect.aws.route53/HealthCheckConfig)

(s/def
  :cognitect.aws.route53.HealthCheck/HealthCheckVersion
  :cognitect.aws.route53/HealthCheckVersion)

(s/def
  :cognitect.aws.route53.HealthCheck/CloudWatchAlarmConfiguration
  :cognitect.aws.route53/CloudWatchAlarmConfiguration)

(s/def :cognitect.aws.route53.StatusReport/Status :cognitect.aws.route53/Status)

(s/def :cognitect.aws.route53.StatusReport/CheckedTime :cognitect.aws.route53/TimeStamp)

(s/def :cognitect.aws.route53.GetChangeResponse/ChangeInfo :cognitect.aws.route53/ChangeInfo)

(s/def :cognitect.aws.route53.TestDNSAnswerRequest/HostedZoneId :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.TestDNSAnswerRequest/RecordName :cognitect.aws.route53/DNSName)

(s/def :cognitect.aws.route53.TestDNSAnswerRequest/RecordType :cognitect.aws.route53/RRType)

(s/def :cognitect.aws.route53.TestDNSAnswerRequest/ResolverIP :cognitect.aws.route53/IPAddress)

(s/def
  :cognitect.aws.route53.TestDNSAnswerRequest/EDNS0ClientSubnetIP
  :cognitect.aws.route53/IPAddress)

(s/def
  :cognitect.aws.route53.TestDNSAnswerRequest/EDNS0ClientSubnetMask
  :cognitect.aws.route53/SubnetMask)

(s/def :cognitect.aws.route53.CreateHostedZoneRequest/Name :cognitect.aws.route53/DNSName)

(s/def :cognitect.aws.route53.CreateHostedZoneRequest/VPC :cognitect.aws.route53/VPC)

(s/def :cognitect.aws.route53.CreateHostedZoneRequest/CallerReference :cognitect.aws.route53/Nonce)

(s/def
  :cognitect.aws.route53.CreateHostedZoneRequest/HostedZoneConfig
  :cognitect.aws.route53/HostedZoneConfig)

(s/def
  :cognitect.aws.route53.CreateHostedZoneRequest/DelegationSetId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneRequest/TrafficPolicyInstanceNameMarker
  :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneRequest/TrafficPolicyInstanceTypeMarker
  :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneRequest/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/TrafficPolicyInstances
  :cognitect.aws.route53/TrafficPolicyInstances)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/TrafficPolicyInstanceNameMarker
  :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/TrafficPolicyInstanceTypeMarker
  :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyInstancesByHostedZoneResponse/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ChangeResourceRecordSetsRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ChangeResourceRecordSetsRequest/ChangeBatch
  :cognitect.aws.route53/ChangeBatch)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyResponse/TrafficPolicy
  :cognitect.aws.route53/TrafficPolicy)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyResponse/Location
  :cognitect.aws.route53/ResourceURI)

(s/def
  :cognitect.aws.route53.UpdateTrafficPolicyCommentResponse/TrafficPolicy
  :cognitect.aws.route53/TrafficPolicy)

(s/def
  :cognitect.aws.route53.DisableHostedZoneDNSSECRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.GetTrafficPolicyInstanceCountResponse/TrafficPolicyInstanceCount
  :cognitect.aws.route53/TrafficPolicyInstanceCount)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyVersionsResponse/TrafficPolicies
  :cognitect.aws.route53/TrafficPolicies)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyVersionsResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyVersionsResponse/TrafficPolicyVersionMarker
  :cognitect.aws.route53/TrafficPolicyVersionMarker)

(s/def
  :cognitect.aws.route53.ListTrafficPolicyVersionsResponse/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ListHostedZonesResponse/HostedZones
  :cognitect.aws.route53/HostedZones)

(s/def :cognitect.aws.route53.ListHostedZonesResponse/Marker :cognitect.aws.route53/PageMarker)

(s/def
  :cognitect.aws.route53.ListHostedZonesResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def :cognitect.aws.route53.ListHostedZonesResponse/NextMarker :cognitect.aws.route53/PageMarker)

(s/def :cognitect.aws.route53.ListHostedZonesResponse/MaxItems :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.GetHealthCheckStatusResponse/HealthCheckObservations
  :cognitect.aws.route53/HealthCheckObservations)

(s/def
  :cognitect.aws.route53.EnableHostedZoneDNSSECRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/Name
  :cognitect.aws.route53/DNSName)

(s/def :cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/TTL :cognitect.aws.route53/TTL)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/TrafficPolicyId
  :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.CreateTrafficPolicyInstanceRequest/TrafficPolicyVersion
  :cognitect.aws.route53/TrafficPolicyVersion)

(s/def :cognitect.aws.route53.HealthCheckConfig/Port :cognitect.aws.route53/Port)

(s/def :cognitect.aws.route53.HealthCheckConfig/SearchString :cognitect.aws.route53/SearchString)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/FullyQualifiedDomainName
  :cognitect.aws.route53/FullyQualifiedDomainName)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/RoutingControlArn
  :cognitect.aws.route53/RoutingControlArn)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/AlarmIdentifier
  :cognitect.aws.route53/AlarmIdentifier)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/RequestInterval
  :cognitect.aws.route53/RequestInterval)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/InsufficientDataHealthStatus
  :cognitect.aws.route53/InsufficientDataHealthStatus)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/FailureThreshold
  :cognitect.aws.route53/FailureThreshold)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/MeasureLatency
  :cognitect.aws.route53/MeasureLatency)

(s/def :cognitect.aws.route53.HealthCheckConfig/EnableSNI :cognitect.aws.route53/EnableSNI)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/HealthThreshold
  :cognitect.aws.route53/HealthThreshold)

(s/def :cognitect.aws.route53.HealthCheckConfig/ResourcePath :cognitect.aws.route53/ResourcePath)

(s/def :cognitect.aws.route53.HealthCheckConfig/Disabled :cognitect.aws.route53/Disabled)

(s/def :cognitect.aws.route53.HealthCheckConfig/Inverted :cognitect.aws.route53/Inverted)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/ChildHealthChecks
  :cognitect.aws.route53/ChildHealthCheckList)

(s/def :cognitect.aws.route53.HealthCheckConfig/Type :cognitect.aws.route53/HealthCheckType)

(s/def :cognitect.aws.route53.HealthCheckConfig/IPAddress :cognitect.aws.route53/IPAddress)

(s/def
  :cognitect.aws.route53.HealthCheckConfig/Regions
  :cognitect.aws.route53/HealthCheckRegionList)

(s/def :cognitect.aws.route53.GetDNSSECRequest/HostedZoneId :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.UpdateTrafficPolicyInstanceResponse/TrafficPolicyInstance
  :cognitect.aws.route53/TrafficPolicyInstance)

(s/def
  :cognitect.aws.route53.GeoLocation/ContinentCode
  :cognitect.aws.route53/GeoLocationContinentCode)

(s/def :cognitect.aws.route53.GeoLocation/CountryCode :cognitect.aws.route53/GeoLocationCountryCode)

(s/def
  :cognitect.aws.route53.GeoLocation/SubdivisionCode
  :cognitect.aws.route53/GeoLocationSubdivisionCode)

(s/def :cognitect.aws.route53.HostedZoneConfig/Comment :cognitect.aws.route53/ResourceDescription)

(s/def :cognitect.aws.route53.HostedZoneConfig/PrivateZone :cognitect.aws.route53/IsPrivateZone)

(s/def
  :cognitect.aws.route53.EnableHostedZoneDNSSECResponse/ChangeInfo
  :cognitect.aws.route53/ChangeInfo)

(s/def :cognitect.aws.route53.ListHealthChecksRequest/Marker :cognitect.aws.route53/PageMarker)

(s/def :cognitect.aws.route53.ListHealthChecksRequest/MaxItems :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.GetHostedZoneLimitRequest/Type
  :cognitect.aws.route53/HostedZoneLimitType)

(s/def
  :cognitect.aws.route53.GetHostedZoneLimitRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.GetHealthCheckStatusRequest/HealthCheckId
  :cognitect.aws.route53/HealthCheckId)

(s/def
  :cognitect.aws.route53.UpdateTrafficPolicyInstanceRequest/Id
  :cognitect.aws.route53/TrafficPolicyInstanceId)

(s/def :cognitect.aws.route53.UpdateTrafficPolicyInstanceRequest/TTL :cognitect.aws.route53/TTL)

(s/def
  :cognitect.aws.route53.UpdateTrafficPolicyInstanceRequest/TrafficPolicyId
  :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.UpdateTrafficPolicyInstanceRequest/TrafficPolicyVersion
  :cognitect.aws.route53/TrafficPolicyVersion)

(s/def :cognitect.aws.route53.UpdateHostedZoneCommentRequest/Id :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.UpdateHostedZoneCommentRequest/Comment
  :cognitect.aws.route53/ResourceDescription)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckResponse/HealthCheck
  :cognitect.aws.route53/HealthCheck)

(s/def
  :cognitect.aws.route53.ReusableDelegationSetLimit/Type
  :cognitect.aws.route53/ReusableDelegationSetLimitType)

(s/def :cognitect.aws.route53.ReusableDelegationSetLimit/Value :cognitect.aws.route53/LimitValue)

(s/def
  :cognitect.aws.route53.CreateHealthCheckResponse/HealthCheck
  :cognitect.aws.route53/HealthCheck)

(s/def :cognitect.aws.route53.CreateHealthCheckResponse/Location :cognitect.aws.route53/ResourceURI)

(s/def
  :cognitect.aws.route53.ListHealthChecksResponse/HealthChecks
  :cognitect.aws.route53/HealthChecks)

(s/def :cognitect.aws.route53.ListHealthChecksResponse/Marker :cognitect.aws.route53/PageMarker)

(s/def
  :cognitect.aws.route53.ListHealthChecksResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def :cognitect.aws.route53.ListHealthChecksResponse/NextMarker :cognitect.aws.route53/PageMarker)

(s/def :cognitect.aws.route53.ListHealthChecksResponse/MaxItems :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ChangeResourceRecordSetsResponse/ChangeInfo
  :cognitect.aws.route53/ChangeInfo)

(s/def
  :cognitect.aws.route53.ListGeoLocationsRequest/StartContinentCode
  :cognitect.aws.route53/GeoLocationContinentCode)

(s/def
  :cognitect.aws.route53.ListGeoLocationsRequest/StartCountryCode
  :cognitect.aws.route53/GeoLocationCountryCode)

(s/def
  :cognitect.aws.route53.ListGeoLocationsRequest/StartSubdivisionCode
  :cognitect.aws.route53/GeoLocationSubdivisionCode)

(s/def :cognitect.aws.route53.ListGeoLocationsRequest/MaxItems :cognitect.aws.route53/PageMaxItems)

(s/def :cognitect.aws.route53.HostedZoneSummary/HostedZoneId :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.HostedZoneSummary/Name :cognitect.aws.route53/DNSName)

(s/def :cognitect.aws.route53.HostedZoneSummary/Owner :cognitect.aws.route53/HostedZoneOwner)

(s/def
  :cognitect.aws.route53.LinkedService/ServicePrincipal
  :cognitect.aws.route53/ServicePrincipal)

(s/def :cognitect.aws.route53.LinkedService/Description :cognitect.aws.route53/ResourceDescription)

(s/def
  :cognitect.aws.route53.GetHostedZoneLimitResponse/Limit
  :cognitect.aws.route53/HostedZoneLimit)

(s/def :cognitect.aws.route53.GetHostedZoneLimitResponse/Count :cognitect.aws.route53/UsageCount)

(s/def
  :cognitect.aws.route53.GetCheckerIpRangesResponse/CheckerIpRanges
  :cognitect.aws.route53/CheckerIpRanges)

(s/def
  :cognitect.aws.route53.DisassociateVPCFromHostedZoneRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.DisassociateVPCFromHostedZoneRequest/VPC :cognitect.aws.route53/VPC)

(s/def
  :cognitect.aws.route53.DisassociateVPCFromHostedZoneRequest/Comment
  :cognitect.aws.route53/DisassociateVPCComment)

(s/def
  :cognitect.aws.route53.ListGeoLocationsResponse/GeoLocationDetailsList
  :cognitect.aws.route53/GeoLocationDetailsList)

(s/def
  :cognitect.aws.route53.ListGeoLocationsResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def
  :cognitect.aws.route53.ListGeoLocationsResponse/NextContinentCode
  :cognitect.aws.route53/GeoLocationContinentCode)

(s/def
  :cognitect.aws.route53.ListGeoLocationsResponse/NextCountryCode
  :cognitect.aws.route53/GeoLocationCountryCode)

(s/def
  :cognitect.aws.route53.ListGeoLocationsResponse/NextSubdivisionCode
  :cognitect.aws.route53/GeoLocationSubdivisionCode)

(s/def :cognitect.aws.route53.ListGeoLocationsResponse/MaxItems :cognitect.aws.route53/PageMaxItems)

(s/def :cognitect.aws.route53.DeleteHostedZoneRequest/Id :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.GetTrafficPolicyInstanceRequest/Id
  :cognitect.aws.route53/TrafficPolicyInstanceId)

(s/def
  :cognitect.aws.route53.ListTrafficPoliciesResponse/TrafficPolicySummaries
  :cognitect.aws.route53/TrafficPolicySummaries)

(s/def
  :cognitect.aws.route53.ListTrafficPoliciesResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def
  :cognitect.aws.route53.ListTrafficPoliciesResponse/TrafficPolicyIdMarker
  :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.ListTrafficPoliciesResponse/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.CreateQueryLoggingConfigRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.CreateQueryLoggingConfigRequest/CloudWatchLogsLogGroupArn
  :cognitect.aws.route53/CloudWatchLogsLogGroupArn)

(s/def
  :cognitect.aws.route53.DisableHostedZoneDNSSECResponse/ChangeInfo
  :cognitect.aws.route53/ChangeInfo)

(s/def
  :cognitect.aws.route53.ListReusableDelegationSetsRequest/Marker
  :cognitect.aws.route53/PageMarker)

(s/def
  :cognitect.aws.route53.ListReusableDelegationSetsRequest/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def :cognitect.aws.route53.AccountLimit/Type :cognitect.aws.route53/AccountLimitType)

(s/def :cognitect.aws.route53.AccountLimit/Value :cognitect.aws.route53/LimitValue)

(s/def
  :cognitect.aws.route53.TrafficPolicyInstance/TrafficPolicyVersion
  :cognitect.aws.route53/TrafficPolicyVersion)

(s/def :cognitect.aws.route53.TrafficPolicyInstance/Message :cognitect.aws.route53/Message)

(s/def
  :cognitect.aws.route53.TrafficPolicyInstance/Id
  :cognitect.aws.route53/TrafficPolicyInstanceId)

(s/def
  :cognitect.aws.route53.TrafficPolicyInstance/TrafficPolicyId
  :cognitect.aws.route53/TrafficPolicyId)

(s/def :cognitect.aws.route53.TrafficPolicyInstance/TrafficPolicyType :cognitect.aws.route53/RRType)

(s/def :cognitect.aws.route53.TrafficPolicyInstance/TTL :cognitect.aws.route53/TTL)

(s/def :cognitect.aws.route53.TrafficPolicyInstance/HostedZoneId :cognitect.aws.route53/ResourceId)

(s/def :cognitect.aws.route53.TrafficPolicyInstance/Name :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.TrafficPolicyInstance/State
  :cognitect.aws.route53/TrafficPolicyInstanceState)

(s/def
  :cognitect.aws.route53.UpdateTrafficPolicyCommentRequest/Id
  :cognitect.aws.route53/TrafficPolicyId)

(s/def
  :cognitect.aws.route53.UpdateTrafficPolicyCommentRequest/Version
  :cognitect.aws.route53/TrafficPolicyVersion)

(s/def
  :cognitect.aws.route53.UpdateTrafficPolicyCommentRequest/Comment
  :cognitect.aws.route53/TrafficPolicyComment)

(s/def
  :cognitect.aws.route53.CreateReusableDelegationSetResponse/DelegationSet
  :cognitect.aws.route53/DelegationSet)

(s/def
  :cognitect.aws.route53.CreateReusableDelegationSetResponse/Location
  :cognitect.aws.route53/ResourceURI)

(s/def
  :cognitect.aws.route53.ListTagsForResourceResponse/ResourceTagSet
  :cognitect.aws.route53/ResourceTagSet)

(s/def
  :cognitect.aws.route53.GetHealthCheckCountResponse/HealthCheckCount
  :cognitect.aws.route53/HealthCheckCount)

(s/def :cognitect.aws.route53.TrafficPolicy/Id :cognitect.aws.route53/TrafficPolicyId)

(s/def :cognitect.aws.route53.TrafficPolicy/Version :cognitect.aws.route53/TrafficPolicyVersion)

(s/def :cognitect.aws.route53.TrafficPolicy/Name :cognitect.aws.route53/TrafficPolicyName)

(s/def :cognitect.aws.route53.TrafficPolicy/Type :cognitect.aws.route53/RRType)

(s/def :cognitect.aws.route53.TrafficPolicy/Document :cognitect.aws.route53/TrafficPolicyDocument)

(s/def :cognitect.aws.route53.TrafficPolicy/Comment :cognitect.aws.route53/TrafficPolicyComment)

(s/def :cognitect.aws.route53.CreateHostedZoneResponse/HostedZone :cognitect.aws.route53/HostedZone)

(s/def :cognitect.aws.route53.CreateHostedZoneResponse/ChangeInfo :cognitect.aws.route53/ChangeInfo)

(s/def
  :cognitect.aws.route53.CreateHostedZoneResponse/DelegationSet
  :cognitect.aws.route53/DelegationSet)

(s/def :cognitect.aws.route53.CreateHostedZoneResponse/VPC :cognitect.aws.route53/VPC)

(s/def :cognitect.aws.route53.CreateHostedZoneResponse/Location :cognitect.aws.route53/ResourceURI)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsResponse/ResourceRecordSets
  :cognitect.aws.route53/ResourceRecordSets)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsResponse/IsTruncated
  :cognitect.aws.route53/PageTruncated)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsResponse/NextRecordName
  :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsResponse/NextRecordType
  :cognitect.aws.route53/RRType)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsResponse/NextRecordIdentifier
  :cognitect.aws.route53/ResourceRecordSetIdentifier)

(s/def
  :cognitect.aws.route53.ListResourceRecordSetsResponse/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ListTagsForResourcesRequest/ResourceType
  :cognitect.aws.route53/TagResourceType)

(s/def
  :cognitect.aws.route53.ListTagsForResourcesRequest/ResourceIds
  :cognitect.aws.route53/TagResourceIdList)

(s/def :cognitect.aws.route53.ListHostedZonesByNameRequest/DNSName :cognitect.aws.route53/DNSName)

(s/def
  :cognitect.aws.route53.ListHostedZonesByNameRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListHostedZonesByNameRequest/MaxItems
  :cognitect.aws.route53/PageMaxItems)

(s/def
  :cognitect.aws.route53.ListQueryLoggingConfigsRequest/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.ListQueryLoggingConfigsRequest/NextToken
  :cognitect.aws.route53/PaginationToken)

(s/def
  :cognitect.aws.route53.ListQueryLoggingConfigsRequest/MaxResults
  :cognitect.aws.route53/MaxResults)

(s/def
  :cognitect.aws.route53.GetHealthCheckLastFailureReasonResponse/HealthCheckObservations
  :cognitect.aws.route53/HealthCheckObservations)

(s/def
  :cognitect.aws.route53.GetTrafficPolicyInstanceResponse/TrafficPolicyInstance
  :cognitect.aws.route53/TrafficPolicyInstance)

(s/def :cognitect.aws.route53.ResourceTagSet/ResourceType :cognitect.aws.route53/TagResourceType)

(s/def :cognitect.aws.route53.ResourceTagSet/ResourceId :cognitect.aws.route53/TagResourceId)

(s/def :cognitect.aws.route53.ResourceTagSet/Tags :cognitect.aws.route53/TagList)

(s/def
  :cognitect.aws.route53.GetQueryLoggingConfigResponse/QueryLoggingConfig
  :cognitect.aws.route53/QueryLoggingConfig)

(s/def
  :cognitect.aws.route53.CreateVPCAssociationAuthorizationResponse/HostedZoneId
  :cognitect.aws.route53/ResourceId)

(s/def
  :cognitect.aws.route53.CreateVPCAssociationAuthorizationResponse/VPC
  :cognitect.aws.route53/VPC)

(s/def
  :cognitect.aws.route53.GetTrafficPolicyResponse/TrafficPolicy
  :cognitect.aws.route53/TrafficPolicy)

(s/def :cognitect.aws.route53.UpdateHealthCheckRequest/Port :cognitect.aws.route53/Port)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/SearchString
  :cognitect.aws.route53/SearchString)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/HealthCheckVersion
  :cognitect.aws.route53/HealthCheckVersion)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/FullyQualifiedDomainName
  :cognitect.aws.route53/FullyQualifiedDomainName)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/AlarmIdentifier
  :cognitect.aws.route53/AlarmIdentifier)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/ResetElements
  :cognitect.aws.route53/ResettableElementNameList)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/InsufficientDataHealthStatus
  :cognitect.aws.route53/InsufficientDataHealthStatus)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/FailureThreshold
  :cognitect.aws.route53/FailureThreshold)

(s/def :cognitect.aws.route53.UpdateHealthCheckRequest/EnableSNI :cognitect.aws.route53/EnableSNI)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/HealthThreshold
  :cognitect.aws.route53/HealthThreshold)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/HealthCheckId
  :cognitect.aws.route53/HealthCheckId)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/ResourcePath
  :cognitect.aws.route53/ResourcePath)

(s/def :cognitect.aws.route53.UpdateHealthCheckRequest/Disabled :cognitect.aws.route53/Disabled)

(s/def :cognitect.aws.route53.UpdateHealthCheckRequest/Inverted :cognitect.aws.route53/Inverted)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/ChildHealthChecks
  :cognitect.aws.route53/ChildHealthCheckList)

(s/def :cognitect.aws.route53.UpdateHealthCheckRequest/IPAddress :cognitect.aws.route53/IPAddress)

(s/def
  :cognitect.aws.route53.UpdateHealthCheckRequest/Regions
  :cognitect.aws.route53/HealthCheckRegionList)

(s/def
  :cognitect.aws.route53.GetReusableDelegationSetLimitResponse/Limit
  :cognitect.aws.route53/ReusableDelegationSetLimit)

(s/def
  :cognitect.aws.route53.GetReusableDelegationSetLimitResponse/Count
  :cognitect.aws.route53/UsageCount)

(s/def :cognitect.aws.route53.HostedZoneLimit/Type :cognitect.aws.route53/HostedZoneLimitType)

(s/def :cognitect.aws.route53.HostedZoneLimit/Value :cognitect.aws.route53/LimitValue)

(s/def :cognitect.aws.route53.DNSSECStatus/ServeSignature :cognitect.aws.route53/ServeSignature)

(s/def
  :cognitect.aws.route53.DNSSECStatus/StatusMessage
  :cognitect.aws.route53/SigningKeyStatusMessage)

(s/def
  :cognitect.aws.route53.DisassociateVPCFromHostedZoneResponse/ChangeInfo
  :cognitect.aws.route53/ChangeInfo)

