;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.route53domains.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.route53domains/Label
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/ResendContactReachabilityEmailRequest
  (s/keys :opt-un [:cognitect.aws.route53domains.ResendContactReachabilityEmailRequest/domainName]))

(s/def
  :cognitect.aws.route53domains/DomainPriceList
  (s/coll-of :cognitect.aws.route53domains/DomainPrice))

(s/def
  :cognitect.aws.route53domains/ExtraParamName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CA_LEGAL_TYPE"
        "DOCUMENT_NUMBER"
        "ES_IDENTIFICATION"
        "ES_IDENTIFICATION_TYPE"
        "BIRTH_COUNTRY"
        "AU_ID_NUMBER"
        "BIRTH_CITY"
        "IT_NATIONALITY"
        "RU_PASSPORT_DATA"
        "FI_BUSINESS_NUMBER"
        "AU_ID_TYPE"
        "BIRTH_DATE_IN_YYYY_MM_DD"
        "VAT_NUMBER"
        "IT_PIN"
        "ES_LEGAL_FORM"
        "BRAND_NUMBER"
        "FI_ID_NUMBER"
        "IT_REGISTRANT_ENTITY_TYPE"
        "BIRTH_DEPARTMENT"
        "UK_COMPANY_NUMBER"
        "UK_CONTACT_TYPE"
        "FI_ORGANIZATION_TYPE"
        "DUNS_NUMBER"
        "AU_PRIORITY_TOKEN"
        "SG_ID_NUMBER"
        "EU_COUNTRY_OF_CITIZENSHIP"
        "CA_LEGAL_REPRESENTATIVE_CAPACITY"
        "CA_LEGAL_REPRESENTATIVE"
        "CA_BUSINESS_ENTITY_TYPE"
        "FI_NATIONALITY"
        "SE_ID_NUMBER"})))

(s/def
  :cognitect.aws.route53domains/ListDomainsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ListDomainsRequest/Marker
     :cognitect.aws.route53domains.ListDomainsRequest/FilterConditions
     :cognitect.aws.route53domains.ListDomainsRequest/MaxItems
     :cognitect.aws.route53domains.ListDomainsRequest/SortCondition]))

(s/def
  :cognitect.aws.route53domains/AssociateDelegationSignerToDomainResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.AssociateDelegationSignerToDomainResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/BillingRecords
  (s/coll-of :cognitect.aws.route53domains/BillingRecord))

(s/def :cognitect.aws.route53domains/GlueIpList (s/coll-of :cognitect.aws.route53domains/GlueIp))

(s/def
  :cognitect.aws.route53domains/DnssecSigningAttributes
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.DnssecSigningAttributes/Algorithm
     :cognitect.aws.route53domains.DnssecSigningAttributes/Flags
     :cognitect.aws.route53domains.DnssecSigningAttributes/PublicKey]))

(s/def
  :cognitect.aws.route53domains/RetrieveDomainAuthCodeRequest
  (s/keys :req-un [:cognitect.aws.route53domains.RetrieveDomainAuthCodeRequest/DomainName]))

(s/def
  :cognitect.aws.route53domains/AssociateDelegationSignerToDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.AssociateDelegationSignerToDomainRequest/DomainName
     :cognitect.aws.route53domains.AssociateDelegationSignerToDomainRequest/SigningAttributes]))

(s/def
  :cognitect.aws.route53domains/SortCondition
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.SortCondition/Name
     :cognitect.aws.route53domains.SortCondition/SortOrder]))

(s/def
  :cognitect.aws.route53domains/DomainPriceName
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/DnssecKeyList
  (s/coll-of :cognitect.aws.route53domains/DnssecKey))

(s/def
  :cognitect.aws.route53domains/Tag
  (s/keys :opt-un [:cognitect.aws.route53domains.Tag/Key :cognitect.aws.route53domains.Tag/Value]))

(s/def
  :cognitect.aws.route53domains/CheckDomainTransferabilityRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.CheckDomainTransferabilityRequest/DomainName]
    :opt-un
    [:cognitect.aws.route53domains.CheckDomainTransferabilityRequest/AuthCode]))

(s/def
  :cognitect.aws.route53domains/OperationStatusList
  (s/coll-of :cognitect.aws.route53domains/OperationStatus :max-count 5))

(s/def
  :cognitect.aws.route53domains/CheckDomainAvailabilityRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.CheckDomainAvailabilityRequest/DomainName]
    :opt-un
    [:cognitect.aws.route53domains.CheckDomainAvailabilityRequest/IdnLangCode]))

(s/def
  :cognitect.aws.route53domains/OperationId
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/AcceptDomainTransferFromAnotherAwsAccountResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.AcceptDomainTransferFromAnotherAwsAccountResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/UpdateDomainContactPrivacyResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.UpdateDomainContactPrivacyResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/ExtraParam
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.ExtraParam/Name :cognitect.aws.route53domains.ExtraParam/Value]))

(s/def
  :cognitect.aws.route53domains/DeleteDomainRequest
  (s/keys :req-un [:cognitect.aws.route53domains.DeleteDomainRequest/DomainName]))

(s/def
  :cognitect.aws.route53domains/ListPricesPageMaxItems
  (s/spec (s/and int? #(>= 1000 %)) :gen #(gen/choose Long/MIN_VALUE 1000)))

(s/def
  :cognitect.aws.route53domains/DnssecPublicKey
  (s/spec
    (s/and string? #(>= 32768 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 32768) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/LangCode
  (s/spec #(re-matches (re-pattern "|[A-Za-z]{2,3}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.route53domains/ContactDetail
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ContactDetail/ExtraParams
     :cognitect.aws.route53domains.ContactDetail/Email
     :cognitect.aws.route53domains.ContactDetail/ZipCode
     :cognitect.aws.route53domains.ContactDetail/CountryCode
     :cognitect.aws.route53domains.ContactDetail/OrganizationName
     :cognitect.aws.route53domains.ContactDetail/AddressLine1
     :cognitect.aws.route53domains.ContactDetail/Fax
     :cognitect.aws.route53domains.ContactDetail/AddressLine2
     :cognitect.aws.route53domains.ContactDetail/City
     :cognitect.aws.route53domains.ContactDetail/State
     :cognitect.aws.route53domains.ContactDetail/LastName
     :cognitect.aws.route53domains.ContactDetail/ContactType
     :cognitect.aws.route53domains.ContactDetail/FirstName
     :cognitect.aws.route53domains.ContactDetail/PhoneNumber]))

(s/def
  :cognitect.aws.route53domains/ListPricesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ListPricesResponse/NextPageMarker
     :cognitect.aws.route53domains.ListPricesResponse/Prices]))

(s/def :cognitect.aws.route53domains/Message string?)

(s/def
  :cognitect.aws.route53domains/TLDRulesViolation
  (s/keys :opt-un [:cognitect.aws.route53domains.TLDRulesViolation/message]))

(s/def :cognitect.aws.route53domains/EnableDomainAutoRenewResponse (s/keys))

(s/def
  :cognitect.aws.route53domains/ListTagsForDomainResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.ListTagsForDomainResponse/TagList]))

(s/def
  :cognitect.aws.route53domains/RegisterDomainResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.RegisterDomainResponse/OperationId]))

(s/def :cognitect.aws.route53domains/ErrorMessage string?)

(s/def :cognitect.aws.route53domains/TagList (s/coll-of :cognitect.aws.route53domains/Tag))

(s/def
  :cognitect.aws.route53domains/AccountId
  (s/spec #(re-matches (re-pattern "^(\\d{12})$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.route53domains/FilterConditions
  (s/coll-of :cognitect.aws.route53domains/FilterCondition))

(s/def
  :cognitect.aws.route53domains/DomainName
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/ZipCode
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/AddressLine
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.route53domains/RegistrarName string?)

(s/def
  :cognitect.aws.route53domains/DeleteTagsForDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.DeleteTagsForDomainRequest/DomainName
     :cognitect.aws.route53domains.DeleteTagsForDomainRequest/TagsToDelete]))

(s/def
  :cognitect.aws.route53domains/DomainAvailability
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AVAILABLE"
        "PENDING"
        "INVALID_NAME_FOR_TLD"
        "UNAVAILABLE"
        "DONT_KNOW"
        "UNAVAILABLE_RESTRICTED"
        "UNAVAILABLE_PREMIUM"
        "RESERVED"
        "AVAILABLE_PREORDER"
        "AVAILABLE_RESERVED"})))

(s/def
  :cognitect.aws.route53domains/CountryCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CR"
        "TG"
        "TJ"
        "ZA"
        "IM"
        "PE"
        "LC"
        "CH"
        "RU"
        "MP"
        "CK"
        "SI"
        "AU"
        "KR"
        "IT"
        "TP"
        "FI"
        "GF"
        "SC"
        "SX"
        "TT"
        "TK"
        "MY"
        "SY"
        "MN"
        "TF"
        "KP"
        "AM"
        "DZ"
        "UY"
        "TD"
        "DJ"
        "BI"
        "MK"
        "MU"
        "LI"
        "NU"
        "GR"
        "GY"
        "CG"
        "NF"
        "ML"
        "AX"
        "GM"
        "SA"
        "CX"
        "BH"
        "NE"
        "BN"
        "MF"
        "CD"
        "DK"
        "BJ"
        "ME"
        "SJ"
        "BO"
        "JO"
        "CV"
        "VE"
        "CI"
        "UZ"
        "TN"
        "IS"
        "EH"
        "AC"
        "TM"
        "GA"
        "LS"
        "TZ"
        "AT"
        "LT"
        "NP"
        "BG"
        "IL"
        "GU"
        "PK"
        "PT"
        "HR"
        "VU"
        "PF"
        "BM"
        "MR"
        "GE"
        "HU"
        "TW"
        "MM"
        "VG"
        "YE"
        "SR"
        "PN"
        "VA"
        "AN"
        "PR"
        "KW"
        "SE"
        "GB"
        "VN"
        "CF"
        "PA"
        "VC"
        "JP"
        "IR"
        "AF"
        "LY"
        "MZ"
        "RO"
        "QA"
        "CM"
        "GG"
        "BY"
        "SD"
        "BQ"
        "MO"
        "KY"
        "AR"
        "BR"
        "ZW"
        "NR"
        "NZ"
        "AW"
        "FJ"
        "ID"
        "SV"
        "CN"
        "FM"
        "HT"
        "CC"
        "RW"
        "BA"
        "TL"
        "JM"
        "KM"
        "KE"
        "WS"
        "TO"
        "PY"
        "SH"
        "CY"
        "GH"
        "MA"
        "SG"
        "LK"
        "PH"
        "SM"
        "WF"
        "TR"
        "PS"
        "BZ"
        "CU"
        "TV"
        "AD"
        "SB"
        "DM"
        "LR"
        "OM"
        "SO"
        "DO"
        "AL"
        "BL"
        "FR"
        "GW"
        "MS"
        "BB"
        "CA"
        "MG"
        "KH"
        "LA"
        "GP"
        "BV"
        "HN"
        "TH"
        "DE"
        "LB"
        "KZ"
        "AS"
        "EC"
        "NO"
        "AO"
        "FK"
        "ET"
        "GS"
        "MD"
        "AG"
        "BE"
        "MV"
        "SZ"
        "CZ"
        "CL"
        "BT"
        "NL"
        "EG"
        "MQ"
        "SN"
        "FO"
        "EE"
        "AQ"
        "ST"
        "KN"
        "BW"
        "MH"
        "NI"
        "PG"
        "VI"
        "IQ"
        "KG"
        "US"
        "ZM"
        "MC"
        "GI"
        "NC"
        "GT"
        "BF"
        "YT"
        "LU"
        "UA"
        "IE"
        "LV"
        "GD"
        "MW"
        "BS"
        "AZ"
        "SK"
        "GQ"
        "TC"
        "RE"
        "IN"
        "ES"
        "GL"
        "KI"
        "HK"
        "CO"
        "SS"
        "RS"
        "IO"
        "NG"
        "UG"
        "CW"
        "SL"
        "ER"
        "JE"
        "AE"
        "HM"
        "PM"
        "BD"
        "MT"
        "AI"
        "GN"
        "PW"
        "NA"
        "MX"
        "PL"})))

(s/def
  :cognitect.aws.route53domains/GetContactReachabilityStatusRequest
  (s/keys :opt-un [:cognitect.aws.route53domains.GetContactReachabilityStatusRequest/domainName]))

(s/def
  :cognitect.aws.route53domains/UpdateDomainNameserversResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.UpdateDomainNameserversResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/Email
  (s/spec
    (s/and string? #(>= 254 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 254) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/DomainLimitExceeded
  (s/keys :opt-un [:cognitect.aws.route53domains.DomainLimitExceeded/message]))

(s/def
  :cognitect.aws.route53domains/DuplicateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.DuplicateRequest/message
     :cognitect.aws.route53domains.DuplicateRequest/requestId]))

(s/def
  :cognitect.aws.route53domains/DomainAuthCode
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.route53domains/DeleteTagsForDomainResponse (s/keys))

(s/def
  :cognitect.aws.route53domains/City
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/GetDomainSuggestionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.GetDomainSuggestionsRequest/DomainName
     :cognitect.aws.route53domains.GetDomainSuggestionsRequest/SuggestionCount
     :cognitect.aws.route53domains.GetDomainSuggestionsRequest/OnlyAvailable]))

(s/def
  :cognitect.aws.route53domains/TransferDomainToAnotherAwsAccountRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.TransferDomainToAnotherAwsAccountRequest/DomainName
     :cognitect.aws.route53domains.TransferDomainToAnotherAwsAccountRequest/AccountId]))

(s/def
  :cognitect.aws.route53domains/DisassociateDelegationSignerFromDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.DisassociateDelegationSignerFromDomainRequest/DomainName
     :cognitect.aws.route53domains.DisassociateDelegationSignerFromDomainRequest/Id]))

(s/def
  :cognitect.aws.route53domains/EnableDomainAutoRenewRequest
  (s/keys :req-un [:cognitect.aws.route53domains.EnableDomainAutoRenewRequest/DomainName]))

(s/def :cognitect.aws.route53domains/Boolean boolean?)

(s/def
  :cognitect.aws.route53domains/PushDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.PushDomainRequest/DomainName
     :cognitect.aws.route53domains.PushDomainRequest/Target]))

(s/def
  :cognitect.aws.route53domains/Nameserver
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.Nameserver/Name]
    :opt-un
    [:cognitect.aws.route53domains.Nameserver/GlueIps]))

(s/def :cognitect.aws.route53domains/UpdateTagsForDomainResponse (s/keys))

(s/def
  :cognitect.aws.route53domains/ContactName
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/ResendOperationAuthorizationRequest
  (s/keys :req-un [:cognitect.aws.route53domains.ResendOperationAuthorizationRequest/OperationId]))

(s/def :cognitect.aws.route53domains/RegistryDomainId string?)

(s/def
  :cognitect.aws.route53domains/DomainPrice
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.DomainPrice/ChangeOwnershipPrice
     :cognitect.aws.route53domains.DomainPrice/TransferPrice
     :cognitect.aws.route53domains.DomainPrice/RegistrationPrice
     :cognitect.aws.route53domains.DomainPrice/RenewalPrice
     :cognitect.aws.route53domains.DomainPrice/RestorationPrice
     :cognitect.aws.route53domains.DomainPrice/Name]))

(s/def
  :cognitect.aws.route53domains/CancelDomainTransferToAnotherAwsAccountResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.CancelDomainTransferToAnotherAwsAccountResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/PageMarker
  (s/spec
    (s/and string? #(>= 4096 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/UpdateDomainContactRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.UpdateDomainContactRequest/DomainName]
    :opt-un
    [:cognitect.aws.route53domains.UpdateDomainContactRequest/AdminContact
     :cognitect.aws.route53domains.UpdateDomainContactRequest/TechContact
     :cognitect.aws.route53domains.UpdateDomainContactRequest/RegistrantContact
     :cognitect.aws.route53domains.UpdateDomainContactRequest/BillingContact
     :cognitect.aws.route53domains.UpdateDomainContactRequest/Consent]))

(s/def
  :cognitect.aws.route53domains/Currency
  (s/spec
    (s/and string? #(<= 3 (count %) 3))
    :gen
    (fn [] (gen/fmap #(apply str %) (gen/bind (gen/choose 3 3) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/ContactType
  (s/spec string? :gen #(s/gen #{"PUBLIC_BODY" "ASSOCIATION" "COMPANY" "PERSON" "RESELLER"})))

(s/def
  :cognitect.aws.route53domains/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53domains/GetDomainSuggestionsResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.GetDomainSuggestionsResponse/SuggestionsList]))

(s/def
  :cognitect.aws.route53domains/InvalidInput
  (s/keys :opt-un [:cognitect.aws.route53domains.InvalidInput/message]))

(s/def
  :cognitect.aws.route53domains/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/DisassociateDelegationSignerFromDomainResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.DisassociateDelegationSignerFromDomainResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/DisableDomainTransferLockResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.DisableDomainTransferLockResponse/OperationId]))

(s/def :cognitect.aws.route53domains/Reseller string?)

(s/def
  :cognitect.aws.route53domains/NullableInteger
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53domains/EnableDomainTransferLockRequest
  (s/keys :req-un [:cognitect.aws.route53domains.EnableDomainTransferLockRequest/DomainName]))

(s/def
  :cognitect.aws.route53domains/BillingRecord
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.BillingRecord/InvoiceId
     :cognitect.aws.route53domains.BillingRecord/Operation
     :cognitect.aws.route53domains.BillingRecord/BillDate
     :cognitect.aws.route53domains.BillingRecord/Price
     :cognitect.aws.route53domains.BillingRecord/DomainName]))

(s/def
  :cognitect.aws.route53domains/OperationSummary
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.OperationSummary/Type
     :cognitect.aws.route53domains.OperationSummary/LastUpdatedDate
     :cognitect.aws.route53domains.OperationSummary/Status
     :cognitect.aws.route53domains.OperationSummary/StatusFlag
     :cognitect.aws.route53domains.OperationSummary/SubmittedDate
     :cognitect.aws.route53domains.OperationSummary/Message
     :cognitect.aws.route53domains.OperationSummary/OperationId
     :cognitect.aws.route53domains.OperationSummary/DomainName]))

(s/def
  :cognitect.aws.route53domains/Values
  (s/coll-of :cognitect.aws.route53domains/Value :min-count 1 :max-count 1))

(s/def :cognitect.aws.route53domains/DomainStatus string?)

(s/def
  :cognitect.aws.route53domains/CheckDomainTransferabilityResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.CheckDomainTransferabilityResponse/Message
     :cognitect.aws.route53domains.CheckDomainTransferabilityResponse/Transferability]))

(s/def
  :cognitect.aws.route53domains/Price
  (s/spec
    (s/and double? #(<= 0.0 %))
    :gen
    #(gen/double* {:infinite? false, :NaN? false, :min 0.0})))

(s/def :cognitect.aws.route53domains/DisableDomainAutoRenewResponse (s/keys))

(s/def
  :cognitect.aws.route53domains/DnssecKey
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.DnssecKey/Digest
     :cognitect.aws.route53domains.DnssecKey/DigestType
     :cognitect.aws.route53domains.DnssecKey/Algorithm
     :cognitect.aws.route53domains.DnssecKey/Flags
     :cognitect.aws.route53domains.DnssecKey/KeyTag
     :cognitect.aws.route53domains.DnssecKey/Id
     :cognitect.aws.route53domains.DnssecKey/PublicKey]))

(s/def
  :cognitect.aws.route53domains/PriceWithCurrency
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.PriceWithCurrency/Price
     :cognitect.aws.route53domains.PriceWithCurrency/Currency]))

(s/def :cognitect.aws.route53domains/RequestId string?)

(s/def
  :cognitect.aws.route53domains/GlueIp
  (s/spec
    (s/and string? #(>= 45 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 45) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/UnsupportedTLD
  (s/keys :opt-un [:cognitect.aws.route53domains.UnsupportedTLD/message]))

(s/def
  :cognitect.aws.route53domains/DisableDomainAutoRenewRequest
  (s/keys :req-un [:cognitect.aws.route53domains.DisableDomainAutoRenewRequest/DomainName]))

(s/def
  :cognitect.aws.route53domains/UpdateDomainContactPrivacyRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/DomainName]
    :opt-un
    [:cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/AdminPrivacy
     :cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/RegistrantPrivacy
     :cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/BillingPrivacy
     :cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/TechPrivacy]))

(s/def
  :cognitect.aws.route53domains/ListDomainsAttributeName
  (s/spec string? :gen #(s/gen #{"Expiry" "DomainName"})))

(s/def :cognitect.aws.route53domains/InvoiceId string?)

(s/def
  :cognitect.aws.route53domains/ExtraParamList
  (s/coll-of :cognitect.aws.route53domains/ExtraParam))

(s/def
  :cognitect.aws.route53domains/OperationSummaryList
  (s/coll-of :cognitect.aws.route53domains/OperationSummary))

(s/def
  :cognitect.aws.route53domains/DnssecLimitExceeded
  (s/keys :opt-un [:cognitect.aws.route53domains.DnssecLimitExceeded/message]))

(s/def
  :cognitect.aws.route53domains/FIAuthKey
  (s/spec
    (s/and string? #(<= 0 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/ContactNumber
  (s/spec
    (s/and string? #(>= 30 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 30) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/UpdateDomainContactResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.UpdateDomainContactResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/ExtraParamValue
  (s/spec
    (s/and string? #(>= 2048 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.route53domains/Password string?)

(s/def
  :cognitect.aws.route53domains/OperationLimitExceeded
  (s/keys :opt-un [:cognitect.aws.route53domains.OperationLimitExceeded/message]))

(s/def
  :cognitect.aws.route53domains/DurationInYears
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.route53domains/ListOperationsSortAttributeName
  (s/spec string? :gen #(s/gen #{"SubmittedDate"})))

(s/def
  :cognitect.aws.route53domains/PageMaxItems
  (s/spec (s/and int? #(>= 100 %)) :gen #(gen/choose Long/MIN_VALUE 100)))

(s/def
  :cognitect.aws.route53domains/CurrentExpiryYear
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.route53domains/DomainSummary
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.DomainSummary/TransferLock
     :cognitect.aws.route53domains.DomainSummary/Expiry
     :cognitect.aws.route53domains.DomainSummary/AutoRenew
     :cognitect.aws.route53domains.DomainSummary/DomainName]))

(s/def
  :cognitect.aws.route53domains/GetDomainDetailRequest
  (s/keys :req-un [:cognitect.aws.route53domains.GetDomainDetailRequest/DomainName]))

(s/def
  :cognitect.aws.route53domains/RegisterDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.RegisterDomainRequest/DomainName
     :cognitect.aws.route53domains.RegisterDomainRequest/DurationInYears
     :cognitect.aws.route53domains.RegisterDomainRequest/AdminContact
     :cognitect.aws.route53domains.RegisterDomainRequest/RegistrantContact
     :cognitect.aws.route53domains.RegisterDomainRequest/TechContact]
    :opt-un
    [:cognitect.aws.route53domains.RegisterDomainRequest/IdnLangCode
     :cognitect.aws.route53domains.RegisterDomainRequest/PrivacyProtectBillingContact
     :cognitect.aws.route53domains.RegisterDomainRequest/PrivacyProtectRegistrantContact
     :cognitect.aws.route53domains.RegisterDomainRequest/AutoRenew
     :cognitect.aws.route53domains.RegisterDomainRequest/PrivacyProtectAdminContact
     :cognitect.aws.route53domains.RegisterDomainRequest/PrivacyProtectTechContact
     :cognitect.aws.route53domains.RegisterDomainRequest/BillingContact]))

(s/def
  :cognitect.aws.route53domains/RenewDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.RenewDomainRequest/DomainName
     :cognitect.aws.route53domains.RenewDomainRequest/CurrentExpiryYear]
    :opt-un
    [:cognitect.aws.route53domains.RenewDomainRequest/DurationInYears]))

(s/def
  :cognitect.aws.route53domains/DomainSuggestionsList
  (s/coll-of :cognitect.aws.route53domains/DomainSuggestion))

(s/def
  :cognitect.aws.route53domains/RenewDomainResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.RenewDomainResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/TldName
  (s/spec
    (s/and string? #(<= 2 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 2 255) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.route53domains/SortOrder (s/spec string? :gen #(s/gen #{"DESC" "ASC"})))

(s/def
  :cognitect.aws.route53domains/AcceptDomainTransferFromAnotherAwsAccountRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.AcceptDomainTransferFromAnotherAwsAccountRequest/DomainName
     :cognitect.aws.route53domains.AcceptDomainTransferFromAnotherAwsAccountRequest/Password]))

(s/def
  :cognitect.aws.route53domains/ListDomainsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ListDomainsResponse/Domains
     :cognitect.aws.route53domains.ListDomainsResponse/NextPageMarker]))

(s/def
  :cognitect.aws.route53domains/TransferDomainToAnotherAwsAccountResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.TransferDomainToAnotherAwsAccountResponse/Password
     :cognitect.aws.route53domains.TransferDomainToAnotherAwsAccountResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/OperationStatus
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "ERROR" "SUBMITTED" "FAILED" "SUCCESSFUL"})))

(s/def
  :cognitect.aws.route53domains/CheckDomainAvailabilityResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.CheckDomainAvailabilityResponse/Availability]))

(s/def
  :cognitect.aws.route53domains/UpdateDomainNameserversRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.UpdateDomainNameserversRequest/DomainName
     :cognitect.aws.route53domains.UpdateDomainNameserversRequest/Nameservers]
    :opt-un
    [:cognitect.aws.route53domains.UpdateDomainNameserversRequest/FIAuthKey]))

(s/def
  :cognitect.aws.route53domains/GetOperationDetailResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.GetOperationDetailResponse/Type
     :cognitect.aws.route53domains.GetOperationDetailResponse/LastUpdatedDate
     :cognitect.aws.route53domains.GetOperationDetailResponse/Status
     :cognitect.aws.route53domains.GetOperationDetailResponse/StatusFlag
     :cognitect.aws.route53domains.GetOperationDetailResponse/SubmittedDate
     :cognitect.aws.route53domains.GetOperationDetailResponse/Message
     :cognitect.aws.route53domains.GetOperationDetailResponse/OperationId
     :cognitect.aws.route53domains.GetOperationDetailResponse/DomainName]))

(s/def
  :cognitect.aws.route53domains/DisableDomainTransferLockRequest
  (s/keys :req-un [:cognitect.aws.route53domains.DisableDomainTransferLockRequest/DomainName]))

(s/def
  :cognitect.aws.route53domains/DomainStatusList
  (s/coll-of :cognitect.aws.route53domains/DomainStatus))

(s/def
  :cognitect.aws.route53domains/ViewBillingResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ViewBillingResponse/NextPageMarker
     :cognitect.aws.route53domains.ViewBillingResponse/BillingRecords]))

(s/def
  :cognitect.aws.route53domains/Transferable
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DOMAIN_IN_OWN_ACCOUNT"
        "TRANSFERABLE"
        "UNTRANSFERABLE"
        "PREMIUM_DOMAIN"
        "DONT_KNOW"
        "DOMAIN_IN_ANOTHER_ACCOUNT"})))

(s/def
  :cognitect.aws.route53domains/Value
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/DomainSummaryList
  (s/coll-of :cognitect.aws.route53domains/DomainSummary))

(s/def
  :cognitect.aws.route53domains/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/ListOperationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ListOperationsRequest/SortBy
     :cognitect.aws.route53domains.ListOperationsRequest/Type
     :cognitect.aws.route53domains.ListOperationsRequest/Marker
     :cognitect.aws.route53domains.ListOperationsRequest/SortOrder
     :cognitect.aws.route53domains.ListOperationsRequest/Status
     :cognitect.aws.route53domains.ListOperationsRequest/SubmittedSince
     :cognitect.aws.route53domains.ListOperationsRequest/MaxItems]))

(s/def
  :cognitect.aws.route53domains/ListTagsForDomainRequest
  (s/keys :req-un [:cognitect.aws.route53domains.ListTagsForDomainRequest/DomainName]))

(s/def
  :cognitect.aws.route53domains/Operator
  (s/spec string? :gen #(s/gen #{"GE" "LE" "BEGINS_WITH"})))

(s/def :cognitect.aws.route53domains/Timestamp inst?)

(s/def
  :cognitect.aws.route53domains/State
  (s/spec
    (s/and string? #(>= 255 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.route53domains/NameserverList
  (s/coll-of :cognitect.aws.route53domains/Nameserver))

(s/def
  :cognitect.aws.route53domains/TransferDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.TransferDomainRequest/DomainName
     :cognitect.aws.route53domains.TransferDomainRequest/DurationInYears
     :cognitect.aws.route53domains.TransferDomainRequest/AdminContact
     :cognitect.aws.route53domains.TransferDomainRequest/RegistrantContact
     :cognitect.aws.route53domains.TransferDomainRequest/TechContact]
    :opt-un
    [:cognitect.aws.route53domains.TransferDomainRequest/IdnLangCode
     :cognitect.aws.route53domains.TransferDomainRequest/PrivacyProtectBillingContact
     :cognitect.aws.route53domains.TransferDomainRequest/Nameservers
     :cognitect.aws.route53domains.TransferDomainRequest/PrivacyProtectRegistrantContact
     :cognitect.aws.route53domains.TransferDomainRequest/AutoRenew
     :cognitect.aws.route53domains.TransferDomainRequest/AuthCode
     :cognitect.aws.route53domains.TransferDomainRequest/PrivacyProtectAdminContact
     :cognitect.aws.route53domains.TransferDomainRequest/PrivacyProtectTechContact
     :cognitect.aws.route53domains.TransferDomainRequest/BillingContact]))

(s/def :cognitect.aws.route53domains/RegistrarWhoIsServer string?)

(s/def
  :cognitect.aws.route53domains/DomainSuggestion
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.DomainSuggestion/DomainName
     :cognitect.aws.route53domains.DomainSuggestion/Availability]))

(s/def
  :cognitect.aws.route53domains/HostName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9_\\-.]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.route53domains/StatusFlag
  (s/spec
    string?
    :gen
    #(s/gen
      #{"PENDING_ACCEPTANCE"
        "PENDING_PAYMENT_VERIFICATION"
        "PENDING_CUSTOMER_ACTION"
        "PENDING_AUTHORIZATION"
        "PENDING_SUPPORT_CASE"})))

(s/def
  :cognitect.aws.route53domains/Consent
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.Consent/MaxPrice
     :cognitect.aws.route53domains.Consent/Currency]))

(s/def
  :cognitect.aws.route53domains/GetOperationDetailRequest
  (s/keys :req-un [:cognitect.aws.route53domains.GetOperationDetailRequest/OperationId]))

(s/def
  :cognitect.aws.route53domains/RejectDomainTransferFromAnotherAwsAccountRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.RejectDomainTransferFromAnotherAwsAccountRequest/DomainName]))

(s/def
  :cognitect.aws.route53domains/ListOperationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ListOperationsResponse/NextPageMarker
     :cognitect.aws.route53domains.ListOperationsResponse/Operations]))

(s/def
  :cognitect.aws.route53domains/DomainTransferability
  (s/keys :opt-un [:cognitect.aws.route53domains.DomainTransferability/Transferable]))

(s/def
  :cognitect.aws.route53domains/OperationType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"EXPIRE_DOMAIN"
        "CHANGE_DOMAIN_OWNER"
        "CHANGE_PRIVACY_PROTECTION"
        "REMOVE_DNSSEC"
        "REGISTER_DOMAIN"
        "RELEASE_TO_GANDI"
        "DISABLE_AUTORENEW"
        "ADD_DNSSEC"
        "UPDATE_DOMAIN_CONTACT"
        "ENABLE_AUTORENEW"
        "RESTORE_DOMAIN"
        "UPDATE_NAMESERVER"
        "DOMAIN_LOCK"
        "INTERNAL_TRANSFER_IN_DOMAIN"
        "PUSH_DOMAIN"
        "RENEW_DOMAIN"
        "TRANSFER_ON_RENEW"
        "TRANSFER_OUT_DOMAIN"
        "DELETE_DOMAIN"
        "TRANSFER_IN_DOMAIN"
        "INTERNAL_TRANSFER_OUT_DOMAIN"})))

(s/def
  :cognitect.aws.route53domains/ReachabilityStatus
  (s/spec string? :gen #(s/gen #{"EXPIRED" "DONE" "PENDING"})))

(s/def
  :cognitect.aws.route53domains/ListPricesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ListPricesRequest/Marker
     :cognitect.aws.route53domains.ListPricesRequest/Tld
     :cognitect.aws.route53domains.ListPricesRequest/MaxItems]))

(s/def
  :cognitect.aws.route53domains/RetrieveDomainAuthCodeResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.RetrieveDomainAuthCodeResponse/AuthCode]))

(s/def
  :cognitect.aws.route53domains/DeleteDomainResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.DeleteDomainResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/RejectDomainTransferFromAnotherAwsAccountResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.RejectDomainTransferFromAnotherAwsAccountResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/GetDomainDetailResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.GetDomainDetailResponse/WhoIsServer
     :cognitect.aws.route53domains.GetDomainDetailResponse/DnsSec
     :cognitect.aws.route53domains.GetDomainDetailResponse/AdminContact
     :cognitect.aws.route53domains.GetDomainDetailResponse/AdminPrivacy
     :cognitect.aws.route53domains.GetDomainDetailResponse/TechContact
     :cognitect.aws.route53domains.GetDomainDetailResponse/RegistryDomainId
     :cognitect.aws.route53domains.GetDomainDetailResponse/RegistrantPrivacy
     :cognitect.aws.route53domains.GetDomainDetailResponse/RegistrantContact
     :cognitect.aws.route53domains.GetDomainDetailResponse/BillingPrivacy
     :cognitect.aws.route53domains.GetDomainDetailResponse/ExpirationDate
     :cognitect.aws.route53domains.GetDomainDetailResponse/Nameservers
     :cognitect.aws.route53domains.GetDomainDetailResponse/AbuseContactEmail
     :cognitect.aws.route53domains.GetDomainDetailResponse/AutoRenew
     :cognitect.aws.route53domains.GetDomainDetailResponse/UpdatedDate
     :cognitect.aws.route53domains.GetDomainDetailResponse/RegistrarUrl
     :cognitect.aws.route53domains.GetDomainDetailResponse/RegistrarName
     :cognitect.aws.route53domains.GetDomainDetailResponse/TechPrivacy
     :cognitect.aws.route53domains.GetDomainDetailResponse/DnssecKeys
     :cognitect.aws.route53domains.GetDomainDetailResponse/CreationDate
     :cognitect.aws.route53domains.GetDomainDetailResponse/DomainName
     :cognitect.aws.route53domains.GetDomainDetailResponse/BillingContact
     :cognitect.aws.route53domains.GetDomainDetailResponse/Reseller
     :cognitect.aws.route53domains.GetDomainDetailResponse/StatusList
     :cognitect.aws.route53domains.GetDomainDetailResponse/AbuseContactPhone]))

(s/def
  :cognitect.aws.route53domains/FilterCondition
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.FilterCondition/Name
     :cognitect.aws.route53domains.FilterCondition/Operator
     :cognitect.aws.route53domains.FilterCondition/Values]))

(s/def
  :cognitect.aws.route53domains/CancelDomainTransferToAnotherAwsAccountRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.CancelDomainTransferToAnotherAwsAccountRequest/DomainName]))

(s/def
  :cognitect.aws.route53domains/EnableDomainTransferLockResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.EnableDomainTransferLockResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains/OperationTypeList
  (s/coll-of :cognitect.aws.route53domains/OperationType :max-count 21))

(s/def
  :cognitect.aws.route53domains/UpdateTagsForDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.route53domains.UpdateTagsForDomainRequest/DomainName]
    :opt-un
    [:cognitect.aws.route53domains.UpdateTagsForDomainRequest/TagsToUpdate]))

(s/def :cognitect.aws.route53domains/String string?)

(s/def
  :cognitect.aws.route53domains/ResendContactReachabilityEmailResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ResendContactReachabilityEmailResponse/isAlreadyVerified
     :cognitect.aws.route53domains.ResendContactReachabilityEmailResponse/emailAddress
     :cognitect.aws.route53domains.ResendContactReachabilityEmailResponse/domainName]))

(s/def :cognitect.aws.route53domains/RegistrarUrl string?)

(s/def :cognitect.aws.route53domains/DNSSec string?)

(s/def
  :cognitect.aws.route53domains/GetContactReachabilityStatusResponse
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.GetContactReachabilityStatusResponse/domainName
     :cognitect.aws.route53domains.GetContactReachabilityStatusResponse/status]))

(s/def
  :cognitect.aws.route53domains/ViewBillingRequest
  (s/keys
    :opt-un
    [:cognitect.aws.route53domains.ViewBillingRequest/Start
     :cognitect.aws.route53domains.ViewBillingRequest/End
     :cognitect.aws.route53domains.ViewBillingRequest/Marker
     :cognitect.aws.route53domains.ViewBillingRequest/MaxItems]))

(s/def :cognitect.aws.route53domains/TagKeyList (s/coll-of :cognitect.aws.route53domains/TagKey))

(s/def
  :cognitect.aws.route53domains/TransferDomainResponse
  (s/keys :opt-un [:cognitect.aws.route53domains.TransferDomainResponse/OperationId]))

(s/def
  :cognitect.aws.route53domains.ResendContactReachabilityEmailRequest/domainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.ListDomainsRequest/FilterConditions
  :cognitect.aws.route53domains/FilterConditions)

(s/def
  :cognitect.aws.route53domains.ListDomainsRequest/SortCondition
  :cognitect.aws.route53domains/SortCondition)

(s/def
  :cognitect.aws.route53domains.ListDomainsRequest/Marker
  :cognitect.aws.route53domains/PageMarker)

(s/def
  :cognitect.aws.route53domains.ListDomainsRequest/MaxItems
  :cognitect.aws.route53domains/PageMaxItems)

(s/def
  :cognitect.aws.route53domains.AssociateDelegationSignerToDomainResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.DnssecSigningAttributes/Algorithm
  :cognitect.aws.route53domains/NullableInteger)

(s/def
  :cognitect.aws.route53domains.DnssecSigningAttributes/Flags
  :cognitect.aws.route53domains/NullableInteger)

(s/def
  :cognitect.aws.route53domains.DnssecSigningAttributes/PublicKey
  :cognitect.aws.route53domains/DnssecPublicKey)

(s/def
  :cognitect.aws.route53domains.RetrieveDomainAuthCodeRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.AssociateDelegationSignerToDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.AssociateDelegationSignerToDomainRequest/SigningAttributes
  :cognitect.aws.route53domains/DnssecSigningAttributes)

(s/def
  :cognitect.aws.route53domains.SortCondition/Name
  :cognitect.aws.route53domains/ListDomainsAttributeName)

(s/def
  :cognitect.aws.route53domains.SortCondition/SortOrder
  :cognitect.aws.route53domains/SortOrder)

(s/def :cognitect.aws.route53domains.Tag/Key :cognitect.aws.route53domains/TagKey)

(s/def :cognitect.aws.route53domains.Tag/Value :cognitect.aws.route53domains/TagValue)

(s/def
  :cognitect.aws.route53domains.CheckDomainTransferabilityRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.CheckDomainTransferabilityRequest/AuthCode
  :cognitect.aws.route53domains/DomainAuthCode)

(s/def
  :cognitect.aws.route53domains.CheckDomainAvailabilityRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.CheckDomainAvailabilityRequest/IdnLangCode
  :cognitect.aws.route53domains/LangCode)

(s/def
  :cognitect.aws.route53domains.AcceptDomainTransferFromAnotherAwsAccountResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactPrivacyResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def :cognitect.aws.route53domains.ExtraParam/Name :cognitect.aws.route53domains/ExtraParamName)

(s/def :cognitect.aws.route53domains.ExtraParam/Value :cognitect.aws.route53domains/ExtraParamValue)

(s/def
  :cognitect.aws.route53domains.DeleteDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.ContactDetail/FirstName
  :cognitect.aws.route53domains/ContactName)

(s/def :cognitect.aws.route53domains.ContactDetail/Fax :cognitect.aws.route53domains/ContactNumber)

(s/def :cognitect.aws.route53domains.ContactDetail/ZipCode :cognitect.aws.route53domains/ZipCode)

(s/def
  :cognitect.aws.route53domains.ContactDetail/CountryCode
  :cognitect.aws.route53domains/CountryCode)

(s/def
  :cognitect.aws.route53domains.ContactDetail/ExtraParams
  :cognitect.aws.route53domains/ExtraParamList)

(s/def :cognitect.aws.route53domains.ContactDetail/Email :cognitect.aws.route53domains/Email)

(s/def :cognitect.aws.route53domains.ContactDetail/City :cognitect.aws.route53domains/City)

(s/def
  :cognitect.aws.route53domains.ContactDetail/OrganizationName
  :cognitect.aws.route53domains/ContactName)

(s/def
  :cognitect.aws.route53domains.ContactDetail/ContactType
  :cognitect.aws.route53domains/ContactType)

(s/def
  :cognitect.aws.route53domains.ContactDetail/LastName
  :cognitect.aws.route53domains/ContactName)

(s/def
  :cognitect.aws.route53domains.ContactDetail/AddressLine2
  :cognitect.aws.route53domains/AddressLine)

(s/def
  :cognitect.aws.route53domains.ContactDetail/PhoneNumber
  :cognitect.aws.route53domains/ContactNumber)

(s/def :cognitect.aws.route53domains.ContactDetail/State :cognitect.aws.route53domains/State)

(s/def
  :cognitect.aws.route53domains.ContactDetail/AddressLine1
  :cognitect.aws.route53domains/AddressLine)

(s/def
  :cognitect.aws.route53domains.ListPricesResponse/Prices
  :cognitect.aws.route53domains/DomainPriceList)

(s/def
  :cognitect.aws.route53domains.ListPricesResponse/NextPageMarker
  :cognitect.aws.route53domains/PageMarker)

(s/def
  :cognitect.aws.route53domains.TLDRulesViolation/message
  :cognitect.aws.route53domains/ErrorMessage)

(s/def
  :cognitect.aws.route53domains.ListTagsForDomainResponse/TagList
  :cognitect.aws.route53domains/TagList)

(s/def
  :cognitect.aws.route53domains.RegisterDomainResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.DeleteTagsForDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.DeleteTagsForDomainRequest/TagsToDelete
  :cognitect.aws.route53domains/TagKeyList)

(s/def
  :cognitect.aws.route53domains.GetContactReachabilityStatusRequest/domainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.UpdateDomainNameserversResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.DomainLimitExceeded/message
  :cognitect.aws.route53domains/ErrorMessage)

(s/def
  :cognitect.aws.route53domains.DuplicateRequest/requestId
  :cognitect.aws.route53domains/RequestId)

(s/def
  :cognitect.aws.route53domains.DuplicateRequest/message
  :cognitect.aws.route53domains/ErrorMessage)

(s/def
  :cognitect.aws.route53domains.GetDomainSuggestionsRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.GetDomainSuggestionsRequest/SuggestionCount
  :cognitect.aws.route53domains/Integer)

(s/def
  :cognitect.aws.route53domains.GetDomainSuggestionsRequest/OnlyAvailable
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.TransferDomainToAnotherAwsAccountRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.TransferDomainToAnotherAwsAccountRequest/AccountId
  :cognitect.aws.route53domains/AccountId)

(s/def
  :cognitect.aws.route53domains.DisassociateDelegationSignerFromDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.DisassociateDelegationSignerFromDomainRequest/Id
  :cognitect.aws.route53domains/String)

(s/def
  :cognitect.aws.route53domains.EnableDomainAutoRenewRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.PushDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def :cognitect.aws.route53domains.PushDomainRequest/Target :cognitect.aws.route53domains/Label)

(s/def :cognitect.aws.route53domains.Nameserver/Name :cognitect.aws.route53domains/HostName)

(s/def :cognitect.aws.route53domains.Nameserver/GlueIps :cognitect.aws.route53domains/GlueIpList)

(s/def
  :cognitect.aws.route53domains.ResendOperationAuthorizationRequest/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def :cognitect.aws.route53domains.DomainPrice/Name :cognitect.aws.route53domains/DomainPriceName)

(s/def
  :cognitect.aws.route53domains.DomainPrice/RegistrationPrice
  :cognitect.aws.route53domains/PriceWithCurrency)

(s/def
  :cognitect.aws.route53domains.DomainPrice/TransferPrice
  :cognitect.aws.route53domains/PriceWithCurrency)

(s/def
  :cognitect.aws.route53domains.DomainPrice/RenewalPrice
  :cognitect.aws.route53domains/PriceWithCurrency)

(s/def
  :cognitect.aws.route53domains.DomainPrice/ChangeOwnershipPrice
  :cognitect.aws.route53domains/PriceWithCurrency)

(s/def
  :cognitect.aws.route53domains.DomainPrice/RestorationPrice
  :cognitect.aws.route53domains/PriceWithCurrency)

(s/def
  :cognitect.aws.route53domains.CancelDomainTransferToAnotherAwsAccountResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactRequest/AdminContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactRequest/RegistrantContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactRequest/TechContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactRequest/Consent
  :cognitect.aws.route53domains/Consent)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactRequest/BillingContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.GetDomainSuggestionsResponse/SuggestionsList
  :cognitect.aws.route53domains/DomainSuggestionsList)

(s/def
  :cognitect.aws.route53domains.InvalidInput/message
  :cognitect.aws.route53domains/ErrorMessage)

(s/def
  :cognitect.aws.route53domains.DisassociateDelegationSignerFromDomainResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.DisableDomainTransferLockResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.EnableDomainTransferLockRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.BillingRecord/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.BillingRecord/Operation
  :cognitect.aws.route53domains/OperationType)

(s/def
  :cognitect.aws.route53domains.BillingRecord/InvoiceId
  :cognitect.aws.route53domains/InvoiceId)

(s/def :cognitect.aws.route53domains.BillingRecord/BillDate :cognitect.aws.route53domains/Timestamp)

(s/def :cognitect.aws.route53domains.BillingRecord/Price :cognitect.aws.route53domains/Price)

(s/def
  :cognitect.aws.route53domains.OperationSummary/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.OperationSummary/Status
  :cognitect.aws.route53domains/OperationStatus)

(s/def
  :cognitect.aws.route53domains.OperationSummary/Type
  :cognitect.aws.route53domains/OperationType)

(s/def
  :cognitect.aws.route53domains.OperationSummary/SubmittedDate
  :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.OperationSummary/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.OperationSummary/Message
  :cognitect.aws.route53domains/ErrorMessage)

(s/def
  :cognitect.aws.route53domains.OperationSummary/StatusFlag
  :cognitect.aws.route53domains/StatusFlag)

(s/def
  :cognitect.aws.route53domains.OperationSummary/LastUpdatedDate
  :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.CheckDomainTransferabilityResponse/Transferability
  :cognitect.aws.route53domains/DomainTransferability)

(s/def
  :cognitect.aws.route53domains.CheckDomainTransferabilityResponse/Message
  :cognitect.aws.route53domains/Message)

(s/def
  :cognitect.aws.route53domains.DnssecKey/Algorithm
  :cognitect.aws.route53domains/NullableInteger)

(s/def :cognitect.aws.route53domains.DnssecKey/Flags :cognitect.aws.route53domains/NullableInteger)

(s/def
  :cognitect.aws.route53domains.DnssecKey/PublicKey
  :cognitect.aws.route53domains/DnssecPublicKey)

(s/def
  :cognitect.aws.route53domains.DnssecKey/DigestType
  :cognitect.aws.route53domains/NullableInteger)

(s/def :cognitect.aws.route53domains.DnssecKey/Digest :cognitect.aws.route53domains/String)

(s/def :cognitect.aws.route53domains.DnssecKey/KeyTag :cognitect.aws.route53domains/NullableInteger)

(s/def :cognitect.aws.route53domains.DnssecKey/Id :cognitect.aws.route53domains/String)

(s/def :cognitect.aws.route53domains.PriceWithCurrency/Price :cognitect.aws.route53domains/Price)

(s/def
  :cognitect.aws.route53domains.PriceWithCurrency/Currency
  :cognitect.aws.route53domains/Currency)

(s/def
  :cognitect.aws.route53domains.UnsupportedTLD/message
  :cognitect.aws.route53domains/ErrorMessage)

(s/def
  :cognitect.aws.route53domains.DisableDomainAutoRenewRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/AdminPrivacy
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/RegistrantPrivacy
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/TechPrivacy
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactPrivacyRequest/BillingPrivacy
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.DnssecLimitExceeded/message
  :cognitect.aws.route53domains/ErrorMessage)

(s/def
  :cognitect.aws.route53domains.UpdateDomainContactResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.OperationLimitExceeded/message
  :cognitect.aws.route53domains/ErrorMessage)

(s/def
  :cognitect.aws.route53domains.DomainSummary/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def :cognitect.aws.route53domains.DomainSummary/AutoRenew :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.DomainSummary/TransferLock
  :cognitect.aws.route53domains/Boolean)

(s/def :cognitect.aws.route53domains.DomainSummary/Expiry :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/AutoRenew
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/PrivacyProtectTechContact
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/TechContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/PrivacyProtectRegistrantContact
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/IdnLangCode
  :cognitect.aws.route53domains/LangCode)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/PrivacyProtectBillingContact
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/RegistrantContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/AdminContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/DurationInYears
  :cognitect.aws.route53domains/DurationInYears)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/BillingContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.RegisterDomainRequest/PrivacyProtectAdminContact
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.RenewDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.RenewDomainRequest/DurationInYears
  :cognitect.aws.route53domains/DurationInYears)

(s/def
  :cognitect.aws.route53domains.RenewDomainRequest/CurrentExpiryYear
  :cognitect.aws.route53domains/CurrentExpiryYear)

(s/def
  :cognitect.aws.route53domains.RenewDomainResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.AcceptDomainTransferFromAnotherAwsAccountRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.AcceptDomainTransferFromAnotherAwsAccountRequest/Password
  :cognitect.aws.route53domains/Password)

(s/def
  :cognitect.aws.route53domains.ListDomainsResponse/Domains
  :cognitect.aws.route53domains/DomainSummaryList)

(s/def
  :cognitect.aws.route53domains.ListDomainsResponse/NextPageMarker
  :cognitect.aws.route53domains/PageMarker)

(s/def
  :cognitect.aws.route53domains.TransferDomainToAnotherAwsAccountResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.TransferDomainToAnotherAwsAccountResponse/Password
  :cognitect.aws.route53domains/Password)

(s/def
  :cognitect.aws.route53domains.CheckDomainAvailabilityResponse/Availability
  :cognitect.aws.route53domains/DomainAvailability)

(s/def
  :cognitect.aws.route53domains.UpdateDomainNameserversRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.UpdateDomainNameserversRequest/FIAuthKey
  :cognitect.aws.route53domains/FIAuthKey)

(s/def
  :cognitect.aws.route53domains.UpdateDomainNameserversRequest/Nameservers
  :cognitect.aws.route53domains/NameserverList)

(s/def
  :cognitect.aws.route53domains.GetOperationDetailResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.GetOperationDetailResponse/Status
  :cognitect.aws.route53domains/OperationStatus)

(s/def
  :cognitect.aws.route53domains.GetOperationDetailResponse/Message
  :cognitect.aws.route53domains/ErrorMessage)

(s/def
  :cognitect.aws.route53domains.GetOperationDetailResponse/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.GetOperationDetailResponse/Type
  :cognitect.aws.route53domains/OperationType)

(s/def
  :cognitect.aws.route53domains.GetOperationDetailResponse/SubmittedDate
  :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.GetOperationDetailResponse/LastUpdatedDate
  :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.GetOperationDetailResponse/StatusFlag
  :cognitect.aws.route53domains/StatusFlag)

(s/def
  :cognitect.aws.route53domains.DisableDomainTransferLockRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.ViewBillingResponse/NextPageMarker
  :cognitect.aws.route53domains/PageMarker)

(s/def
  :cognitect.aws.route53domains.ViewBillingResponse/BillingRecords
  :cognitect.aws.route53domains/BillingRecords)

(s/def
  :cognitect.aws.route53domains.ListOperationsRequest/SubmittedSince
  :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.ListOperationsRequest/Marker
  :cognitect.aws.route53domains/PageMarker)

(s/def
  :cognitect.aws.route53domains.ListOperationsRequest/MaxItems
  :cognitect.aws.route53domains/PageMaxItems)

(s/def
  :cognitect.aws.route53domains.ListOperationsRequest/Status
  :cognitect.aws.route53domains/OperationStatusList)

(s/def
  :cognitect.aws.route53domains.ListOperationsRequest/Type
  :cognitect.aws.route53domains/OperationTypeList)

(s/def
  :cognitect.aws.route53domains.ListOperationsRequest/SortBy
  :cognitect.aws.route53domains/ListOperationsSortAttributeName)

(s/def
  :cognitect.aws.route53domains.ListOperationsRequest/SortOrder
  :cognitect.aws.route53domains/SortOrder)

(s/def
  :cognitect.aws.route53domains.ListTagsForDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/AutoRenew
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/PrivacyProtectTechContact
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/TechContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/Nameservers
  :cognitect.aws.route53domains/NameserverList)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/PrivacyProtectRegistrantContact
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/IdnLangCode
  :cognitect.aws.route53domains/LangCode)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/PrivacyProtectBillingContact
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/RegistrantContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/AdminContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/AuthCode
  :cognitect.aws.route53domains/DomainAuthCode)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/DurationInYears
  :cognitect.aws.route53domains/DurationInYears)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/BillingContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.TransferDomainRequest/PrivacyProtectAdminContact
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.DomainSuggestion/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.DomainSuggestion/Availability
  :cognitect.aws.route53domains/String)

(s/def :cognitect.aws.route53domains.Consent/MaxPrice :cognitect.aws.route53domains/Price)

(s/def :cognitect.aws.route53domains.Consent/Currency :cognitect.aws.route53domains/Currency)

(s/def
  :cognitect.aws.route53domains.GetOperationDetailRequest/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.RejectDomainTransferFromAnotherAwsAccountRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.ListOperationsResponse/Operations
  :cognitect.aws.route53domains/OperationSummaryList)

(s/def
  :cognitect.aws.route53domains.ListOperationsResponse/NextPageMarker
  :cognitect.aws.route53domains/PageMarker)

(s/def
  :cognitect.aws.route53domains.DomainTransferability/Transferable
  :cognitect.aws.route53domains/Transferable)

(s/def :cognitect.aws.route53domains.ListPricesRequest/Tld :cognitect.aws.route53domains/TldName)

(s/def
  :cognitect.aws.route53domains.ListPricesRequest/Marker
  :cognitect.aws.route53domains/PageMarker)

(s/def
  :cognitect.aws.route53domains.ListPricesRequest/MaxItems
  :cognitect.aws.route53domains/ListPricesPageMaxItems)

(s/def
  :cognitect.aws.route53domains.RetrieveDomainAuthCodeResponse/AuthCode
  :cognitect.aws.route53domains/DomainAuthCode)

(s/def
  :cognitect.aws.route53domains.DeleteDomainResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.RejectDomainTransferFromAnotherAwsAccountResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/AutoRenew
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/TechContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/Nameservers
  :cognitect.aws.route53domains/NameserverList)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/AbuseContactEmail
  :cognitect.aws.route53domains/Email)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/RegistrantContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/StatusList
  :cognitect.aws.route53domains/DomainStatusList)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/RegistrarName
  :cognitect.aws.route53domains/RegistrarName)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/AbuseContactPhone
  :cognitect.aws.route53domains/ContactNumber)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/DnsSec
  :cognitect.aws.route53domains/DNSSec)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/AdminContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/ExpirationDate
  :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/BillingPrivacy
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/RegistryDomainId
  :cognitect.aws.route53domains/RegistryDomainId)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/DnssecKeys
  :cognitect.aws.route53domains/DnssecKeyList)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/WhoIsServer
  :cognitect.aws.route53domains/RegistrarWhoIsServer)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/Reseller
  :cognitect.aws.route53domains/Reseller)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/AdminPrivacy
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/TechPrivacy
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/BillingContact
  :cognitect.aws.route53domains/ContactDetail)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/UpdatedDate
  :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/CreationDate
  :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/RegistrantPrivacy
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.GetDomainDetailResponse/RegistrarUrl
  :cognitect.aws.route53domains/RegistrarUrl)

(s/def
  :cognitect.aws.route53domains.FilterCondition/Name
  :cognitect.aws.route53domains/ListDomainsAttributeName)

(s/def
  :cognitect.aws.route53domains.FilterCondition/Operator
  :cognitect.aws.route53domains/Operator)

(s/def :cognitect.aws.route53domains.FilterCondition/Values :cognitect.aws.route53domains/Values)

(s/def
  :cognitect.aws.route53domains.CancelDomainTransferToAnotherAwsAccountRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.EnableDomainTransferLockResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

(s/def
  :cognitect.aws.route53domains.UpdateTagsForDomainRequest/DomainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.UpdateTagsForDomainRequest/TagsToUpdate
  :cognitect.aws.route53domains/TagList)

(s/def
  :cognitect.aws.route53domains.ResendContactReachabilityEmailResponse/domainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.ResendContactReachabilityEmailResponse/emailAddress
  :cognitect.aws.route53domains/Email)

(s/def
  :cognitect.aws.route53domains.ResendContactReachabilityEmailResponse/isAlreadyVerified
  :cognitect.aws.route53domains/Boolean)

(s/def
  :cognitect.aws.route53domains.GetContactReachabilityStatusResponse/domainName
  :cognitect.aws.route53domains/DomainName)

(s/def
  :cognitect.aws.route53domains.GetContactReachabilityStatusResponse/status
  :cognitect.aws.route53domains/ReachabilityStatus)

(s/def
  :cognitect.aws.route53domains.ViewBillingRequest/Start
  :cognitect.aws.route53domains/Timestamp)

(s/def :cognitect.aws.route53domains.ViewBillingRequest/End :cognitect.aws.route53domains/Timestamp)

(s/def
  :cognitect.aws.route53domains.ViewBillingRequest/Marker
  :cognitect.aws.route53domains/PageMarker)

(s/def
  :cognitect.aws.route53domains.ViewBillingRequest/MaxItems
  :cognitect.aws.route53domains/PageMaxItems)

(s/def
  :cognitect.aws.route53domains.TransferDomainResponse/OperationId
  :cognitect.aws.route53domains/OperationId)

