;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.savingsplans.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.savingsplans/SavingsPlanType
  (s/spec string? :gen #(s/gen #{"Compute" "SageMaker" "EC2Instance"})))

(s/def
  :cognitect.aws.savingsplans/DescribeSavingsPlansResponse
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.DescribeSavingsPlansResponse/savingsPlans
     :cognitect.aws.savingsplans.DescribeSavingsPlansResponse/nextToken]))

(s/def
  :cognitect.aws.savingsplans/DeleteQueuedSavingsPlanRequest
  (s/keys :req-un [:cognitect.aws.savingsplans.DeleteQueuedSavingsPlanRequest/savingsPlanId]))

(s/def
  :cognitect.aws.savingsplans/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.savingsplans.TagResourceRequest/resourceArn
     :cognitect.aws.savingsplans.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.savingsplans/CurrencyList
  (s/coll-of :cognitect.aws.savingsplans/CurrencyCode))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanIdList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanId))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanProductType
  (s/spec string? :gen #(s/gen #{"Fargate" "SageMaker" "EC2" "Lambda"})))

(s/def :cognitect.aws.savingsplans/DeleteQueuedSavingsPlanResponse (s/keys))

(s/def
  :cognitect.aws.savingsplans/TagMap
  (s/map-of :cognitect.aws.savingsplans/TagKey :cognitect.aws.savingsplans/TagValue))

(s/def :cognitect.aws.savingsplans/UUIDs (s/coll-of :cognitect.aws.savingsplans/UUID))

(s/def :cognitect.aws.savingsplans/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanRate))

(s/def :cognitect.aws.savingsplans/EC2InstanceFamily string?)

(s/def
  :cognitect.aws.savingsplans/SavingsPlanUsageType
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_ \\/.:-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateServiceCode
  (s/spec
    string?
    :gen
    #(s/gen #{"AmazonECS" "AWSLambda" "AmazonEKS" "AmazonSageMaker" "AmazonEC2"})))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateFilterName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"tenancy" "productType" "operation" "region" "serviceCode" "instanceType" "usageType"
        "productDescription"})))

(s/def
  :cognitect.aws.savingsplans/DescribeSavingsPlansOfferingRatesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/products
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/serviceCodes
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/savingsPlanTypes
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/filters
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/maxResults
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/nextToken
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/usageTypes
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/savingsPlanOfferingIds
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/savingsPlanPaymentOptions
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/operations]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanUsageTypeList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanUsageType))

(s/def
  :cognitect.aws.savingsplans/DescribeSavingsPlansOfferingsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsResponse/nextToken
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsResponse/searchResults]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanServiceCode
  (s/spec #(re-matches (re-pattern "^[a-zA-Z]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.savingsplans/SavingsPlanOfferingId string?)

(s/def :cognitect.aws.savingsplans/ListOfStrings (s/coll-of :cognitect.aws.savingsplans/String))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanPaymentOptionList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanPaymentOption))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingRateProperty
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanOfferingRateProperty/name
     :cognitect.aws.savingsplans.SavingsPlanOfferingRateProperty/value]))

(s/def
  :cognitect.aws.savingsplans/DescribeSavingsPlanRatesRequest
  (s/keys
    :req-un
    [:cognitect.aws.savingsplans.DescribeSavingsPlanRatesRequest/savingsPlanId]
    :opt-un
    [:cognitect.aws.savingsplans.DescribeSavingsPlanRatesRequest/filters
     :cognitect.aws.savingsplans.DescribeSavingsPlanRatesRequest/maxResults
     :cognitect.aws.savingsplans.DescribeSavingsPlanRatesRequest/nextToken]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanState
  (s/spec
    string?
    :gen
    #(s/gen #{"queued" "queued-deleted" "payment-pending" "payment-failed" "active" "retired"})))

(s/def :cognitect.aws.savingsplans/CurrencyCode (s/spec string? :gen #(s/gen #{"CNY" "USD"})))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRatePropertyList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanRateProperty))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateOperationList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanRateOperation))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRate
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanRate/properties
     :cognitect.aws.savingsplans.SavingsPlanRate/currency
     :cognitect.aws.savingsplans.SavingsPlanRate/rate
     :cognitect.aws.savingsplans.SavingsPlanRate/productType
     :cognitect.aws.savingsplans.SavingsPlanRate/operation
     :cognitect.aws.savingsplans.SavingsPlanRate/serviceCode
     :cognitect.aws.savingsplans.SavingsPlanRate/usageType
     :cognitect.aws.savingsplans.SavingsPlanRate/unit]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateUsageType
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_ \\/.:-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOperation
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_ \\/.:-]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:aws:[a-z]+:([a-z]{2}-[a-z]+-\\d{1}|):(\\d{12}):savingsplan\\/([0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12})$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingRate
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanOfferingRate/properties
     :cognitect.aws.savingsplans.SavingsPlanOfferingRate/savingsPlanOffering
     :cognitect.aws.savingsplans.SavingsPlanOfferingRate/rate
     :cognitect.aws.savingsplans.SavingsPlanOfferingRate/productType
     :cognitect.aws.savingsplans.SavingsPlanOfferingRate/operation
     :cognitect.aws.savingsplans.SavingsPlanOfferingRate/serviceCode
     :cognitect.aws.savingsplans.SavingsPlanOfferingRate/usageType
     :cognitect.aws.savingsplans.SavingsPlanOfferingRate/unit]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlansFilterName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"upfront" "payment-option" "term" "savings-plan-type" "start" "region"
        "ec2-instance-family" "commitment" "end"})))

(s/def
  :cognitect.aws.savingsplans/DescribeSavingsPlanRatesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.DescribeSavingsPlanRatesResponse/nextToken
     :cognitect.aws.savingsplans.DescribeSavingsPlanRatesResponse/savingsPlanId
     :cognitect.aws.savingsplans.DescribeSavingsPlanRatesResponse/searchResults]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateUnit
  (s/spec string? :gen #(s/gen #{"Request" "Lambda-GB-Second" "Hrs"})))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlan))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateOperation
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_ \\/.:-]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.savingsplans/SavingsPlansDuration
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.savingsplans/TermDurationInSeconds
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingRateFiltersList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanOfferingRateFilterElement))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanArnList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanArn :max-count 100))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingFilterElement
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanOfferingFilterElement/values
     :cognitect.aws.savingsplans.SavingsPlanOfferingFilterElement/name]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateFilterList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanRateFilter))

(s/def
  :cognitect.aws.savingsplans/DurationsList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlansDuration))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRatePropertyKey
  (s/spec
    string?
    :gen
    #(s/gen #{"tenancy" "region" "instanceType" "productDescription" "instanceFamily"})))

(s/def
  :cognitect.aws.savingsplans/ParentSavingsPlanOffering
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.ParentSavingsPlanOffering/planDescription
     :cognitect.aws.savingsplans.ParentSavingsPlanOffering/durationSeconds
     :cognitect.aws.savingsplans.ParentSavingsPlanOffering/planType
     :cognitect.aws.savingsplans.ParentSavingsPlanOffering/currency
     :cognitect.aws.savingsplans.ParentSavingsPlanOffering/paymentOption
     :cognitect.aws.savingsplans.ParentSavingsPlanOffering/offeringId]))

(s/def
  :cognitect.aws.savingsplans/DescribeSavingsPlansOfferingsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/descriptions
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/paymentOptions
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/offeringIds
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/serviceCodes
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/filters
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/maxResults
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/nextToken
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/productType
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/currencies
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/usageTypes
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/planTypes
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/durations
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/operations]))

(s/def
  :cognitect.aws.savingsplans/CreateSavingsPlanRequest
  (s/keys
    :req-un
    [:cognitect.aws.savingsplans.CreateSavingsPlanRequest/savingsPlanOfferingId
     :cognitect.aws.savingsplans.CreateSavingsPlanRequest/commitment]
    :opt-un
    [:cognitect.aws.savingsplans.CreateSavingsPlanRequest/purchaseTime
     :cognitect.aws.savingsplans.CreateSavingsPlanRequest/clientToken
     :cognitect.aws.savingsplans.CreateSavingsPlanRequest/upfrontPaymentAmount
     :cognitect.aws.savingsplans.CreateSavingsPlanRequest/tags]))

(s/def :cognitect.aws.savingsplans/TagValue string?)

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateServiceCodeList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanRateServiceCode))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingRateFilterElement
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanOfferingRateFilterElement/values
     :cognitect.aws.savingsplans.SavingsPlanOfferingRateFilterElement/name]))

(s/def
  :cognitect.aws.savingsplans/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.savingsplans.ListTagsForResourceRequest/resourceArn]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanServiceCodeList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanServiceCode))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOffering
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanOffering/properties
     :cognitect.aws.savingsplans.SavingsPlanOffering/durationSeconds
     :cognitect.aws.savingsplans.SavingsPlanOffering/planType
     :cognitect.aws.savingsplans.SavingsPlanOffering/currency
     :cognitect.aws.savingsplans.SavingsPlanOffering/productTypes
     :cognitect.aws.savingsplans.SavingsPlanOffering/operation
     :cognitect.aws.savingsplans.SavingsPlanOffering/serviceCode
     :cognitect.aws.savingsplans.SavingsPlanOffering/usageType
     :cognitect.aws.savingsplans.SavingsPlanOffering/paymentOption
     :cognitect.aws.savingsplans.SavingsPlanOffering/offeringId
     :cognitect.aws.savingsplans.SavingsPlanOffering/description]))

(s/def :cognitect.aws.savingsplans/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.savingsplans/DescribeSavingsPlansRequest
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.DescribeSavingsPlansRequest/savingsPlanIds
     :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/states
     :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/filters
     :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/maxResults
     :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/nextToken
     :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/savingsPlanArns]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingsList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanOffering))

(s/def :cognitect.aws.savingsplans/Region string?)

(s/def
  :cognitect.aws.savingsplans/SavingsPlanPaymentOption
  (s/spec string? :gen #(s/gen #{"All Upfront" "No Upfront" "Partial Upfront"})))

(s/def
  :cognitect.aws.savingsplans/CreateSavingsPlanResponse
  (s/keys :opt-un [:cognitect.aws.savingsplans.CreateSavingsPlanResponse/savingsPlanId]))

(s/def :cognitect.aws.savingsplans/SavingsPlanRatePricePerUnit string?)

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingProperty
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanOfferingProperty/name
     :cognitect.aws.savingsplans.SavingsPlanOfferingProperty/value]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanDescription
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_\\- ]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingRatePropertyList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanOfferingRateProperty))

(s/def :cognitect.aws.savingsplans/SavingsPlanId string?)

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateFilter
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanRateFilter/values
     :cognitect.aws.savingsplans.SavingsPlanRateFilter/name]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOperationList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanOperation))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingFilterAttribute
  (s/spec string? :gen #(s/gen #{"region" "instanceFamily"})))

(s/def
  :cognitect.aws.savingsplans/SavingsPlan
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlan/savingsPlanType
     :cognitect.aws.savingsplans.SavingsPlan/ec2InstanceFamily
     :cognitect.aws.savingsplans.SavingsPlan/upfrontPaymentAmount
     :cognitect.aws.savingsplans.SavingsPlan/currency
     :cognitect.aws.savingsplans.SavingsPlan/tags
     :cognitect.aws.savingsplans.SavingsPlan/productTypes
     :cognitect.aws.savingsplans.SavingsPlan/savingsPlanArn
     :cognitect.aws.savingsplans.SavingsPlan/start
     :cognitect.aws.savingsplans.SavingsPlan/region
     :cognitect.aws.savingsplans.SavingsPlan/recurringPaymentAmount
     :cognitect.aws.savingsplans.SavingsPlan/savingsPlanId
     :cognitect.aws.savingsplans.SavingsPlan/commitment
     :cognitect.aws.savingsplans.SavingsPlan/state
     :cognitect.aws.savingsplans.SavingsPlan/termDurationInSeconds
     :cognitect.aws.savingsplans.SavingsPlan/paymentOption
     :cognitect.aws.savingsplans.SavingsPlan/offeringId
     :cognitect.aws.savingsplans.SavingsPlan/end
     :cognitect.aws.savingsplans.SavingsPlan/description]))

(s/def :cognitect.aws.savingsplans/Amount string?)

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateProperty
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanRateProperty/name
     :cognitect.aws.savingsplans.SavingsPlanRateProperty/value]))

(s/def
  :cognitect.aws.savingsplans/PageSize
  (s/spec (s/and int? #(<= 0 % 1000)) :gen #(gen/choose 0 1000)))

(s/def
  :cognitect.aws.savingsplans/MaxResults
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.savingsplans/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.savingsplans.UntagResourceRequest/resourceArn
     :cognitect.aws.savingsplans.UntagResourceRequest/tagKeys]))

(s/def :cognitect.aws.savingsplans/TagKey string?)

(s/def
  :cognitect.aws.savingsplans/DescribeSavingsPlansOfferingRatesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesResponse/nextToken
     :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesResponse/searchResults]))

(s/def :cognitect.aws.savingsplans/ClientToken string?)

(s/def
  :cognitect.aws.savingsplans/UUID
  (s/spec #(re-matches (re-pattern "[a-f0-9]+(-[a-f0-9]+)*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingPropertyList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanOfferingProperty))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateFilterAttribute
  (s/spec
    string?
    :gen
    #(s/gen
      #{"productId" "tenancy" "region" "instanceType" "productDescription" "instanceFamily"})))

(s/def
  :cognitect.aws.savingsplans/FilterValuesList
  (s/coll-of :cognitect.aws.savingsplans/JsonSafeFilterValueString))

(s/def
  :cognitect.aws.savingsplans/JsonSafeFilterValueString
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_ \\/.\\:\\-\\(\\)]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.savingsplans/DateTime inst?)

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingPropertyKey
  (s/spec string? :gen #(s/gen #{"region" "instanceFamily"})))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanStateList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanState))

(s/def
  :cognitect.aws.savingsplans/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.savingsplans.ListTagsForResourceResponse/tags]))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingRatesList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanOfferingRate))

(s/def
  :cognitect.aws.savingsplans/PaginationToken
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9/=\\+]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanFilterList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanFilter))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanFilter
  (s/keys
    :opt-un
    [:cognitect.aws.savingsplans.SavingsPlanFilter/values
     :cognitect.aws.savingsplans.SavingsPlanFilter/name]))

(s/def :cognitect.aws.savingsplans/String string?)

(s/def
  :cognitect.aws.savingsplans/SavingsPlanTypeList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanType))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanOfferingFiltersList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanOfferingFilterElement))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanRateUsageTypeList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanRateUsageType))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanDescriptionsList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanDescription))

(s/def
  :cognitect.aws.savingsplans/SavingsPlanProductTypeList
  (s/coll-of :cognitect.aws.savingsplans/SavingsPlanProductType))

(s/def :cognitect.aws.savingsplans/TagKeyList (s/coll-of :cognitect.aws.savingsplans/TagKey))

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansResponse/savingsPlans
  :cognitect.aws.savingsplans/SavingsPlanList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansResponse/nextToken
  :cognitect.aws.savingsplans/PaginationToken)

(s/def
  :cognitect.aws.savingsplans.DeleteQueuedSavingsPlanRequest/savingsPlanId
  :cognitect.aws.savingsplans/SavingsPlanId)

(s/def
  :cognitect.aws.savingsplans.TagResourceRequest/resourceArn
  :cognitect.aws.savingsplans/SavingsPlanArn)

(s/def :cognitect.aws.savingsplans.TagResourceRequest/tags :cognitect.aws.savingsplans/TagMap)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/serviceCodes
  :cognitect.aws.savingsplans/SavingsPlanRateServiceCodeList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/filters
  :cognitect.aws.savingsplans/SavingsPlanOfferingRateFiltersList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/savingsPlanOfferingIds
  :cognitect.aws.savingsplans/UUIDs)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/savingsPlanPaymentOptions
  :cognitect.aws.savingsplans/SavingsPlanPaymentOptionList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/products
  :cognitect.aws.savingsplans/SavingsPlanProductTypeList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/usageTypes
  :cognitect.aws.savingsplans/SavingsPlanRateUsageTypeList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/savingsPlanTypes
  :cognitect.aws.savingsplans/SavingsPlanTypeList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/operations
  :cognitect.aws.savingsplans/SavingsPlanRateOperationList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/nextToken
  :cognitect.aws.savingsplans/PaginationToken)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesRequest/maxResults
  :cognitect.aws.savingsplans/PageSize)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsResponse/searchResults
  :cognitect.aws.savingsplans/SavingsPlanOfferingsList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsResponse/nextToken
  :cognitect.aws.savingsplans/PaginationToken)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRateProperty/name
  :cognitect.aws.savingsplans/JsonSafeFilterValueString)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRateProperty/value
  :cognitect.aws.savingsplans/JsonSafeFilterValueString)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlanRatesRequest/savingsPlanId
  :cognitect.aws.savingsplans/SavingsPlanId)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlanRatesRequest/filters
  :cognitect.aws.savingsplans/SavingsPlanRateFilterList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlanRatesRequest/nextToken
  :cognitect.aws.savingsplans/PaginationToken)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlanRatesRequest/maxResults
  :cognitect.aws.savingsplans/MaxResults)

(s/def :cognitect.aws.savingsplans.SavingsPlanRate/rate :cognitect.aws.savingsplans/Amount)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRate/currency
  :cognitect.aws.savingsplans/CurrencyCode)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRate/unit
  :cognitect.aws.savingsplans/SavingsPlanRateUnit)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRate/productType
  :cognitect.aws.savingsplans/SavingsPlanProductType)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRate/serviceCode
  :cognitect.aws.savingsplans/SavingsPlanRateServiceCode)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRate/usageType
  :cognitect.aws.savingsplans/SavingsPlanRateUsageType)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRate/operation
  :cognitect.aws.savingsplans/SavingsPlanRateOperation)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRate/properties
  :cognitect.aws.savingsplans/SavingsPlanRatePropertyList)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRate/savingsPlanOffering
  :cognitect.aws.savingsplans/ParentSavingsPlanOffering)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRate/rate
  :cognitect.aws.savingsplans/SavingsPlanRatePricePerUnit)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRate/unit
  :cognitect.aws.savingsplans/SavingsPlanRateUnit)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRate/productType
  :cognitect.aws.savingsplans/SavingsPlanProductType)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRate/serviceCode
  :cognitect.aws.savingsplans/SavingsPlanRateServiceCode)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRate/usageType
  :cognitect.aws.savingsplans/SavingsPlanRateUsageType)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRate/operation
  :cognitect.aws.savingsplans/SavingsPlanRateOperation)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRate/properties
  :cognitect.aws.savingsplans/SavingsPlanOfferingRatePropertyList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlanRatesResponse/savingsPlanId
  :cognitect.aws.savingsplans/SavingsPlanId)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlanRatesResponse/searchResults
  :cognitect.aws.savingsplans/SavingsPlanRateList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlanRatesResponse/nextToken
  :cognitect.aws.savingsplans/PaginationToken)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingFilterElement/name
  :cognitect.aws.savingsplans/SavingsPlanOfferingFilterAttribute)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingFilterElement/values
  :cognitect.aws.savingsplans/FilterValuesList)

(s/def
  :cognitect.aws.savingsplans.ParentSavingsPlanOffering/offeringId
  :cognitect.aws.savingsplans/UUID)

(s/def
  :cognitect.aws.savingsplans.ParentSavingsPlanOffering/paymentOption
  :cognitect.aws.savingsplans/SavingsPlanPaymentOption)

(s/def
  :cognitect.aws.savingsplans.ParentSavingsPlanOffering/planType
  :cognitect.aws.savingsplans/SavingsPlanType)

(s/def
  :cognitect.aws.savingsplans.ParentSavingsPlanOffering/durationSeconds
  :cognitect.aws.savingsplans/SavingsPlansDuration)

(s/def
  :cognitect.aws.savingsplans.ParentSavingsPlanOffering/currency
  :cognitect.aws.savingsplans/CurrencyCode)

(s/def
  :cognitect.aws.savingsplans.ParentSavingsPlanOffering/planDescription
  :cognitect.aws.savingsplans/SavingsPlanDescription)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/paymentOptions
  :cognitect.aws.savingsplans/SavingsPlanPaymentOptionList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/serviceCodes
  :cognitect.aws.savingsplans/SavingsPlanServiceCodeList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/filters
  :cognitect.aws.savingsplans/SavingsPlanOfferingFiltersList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/usageTypes
  :cognitect.aws.savingsplans/SavingsPlanUsageTypeList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/productType
  :cognitect.aws.savingsplans/SavingsPlanProductType)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/currencies
  :cognitect.aws.savingsplans/CurrencyList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/planTypes
  :cognitect.aws.savingsplans/SavingsPlanTypeList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/operations
  :cognitect.aws.savingsplans/SavingsPlanOperationList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/offeringIds
  :cognitect.aws.savingsplans/UUIDs)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/durations
  :cognitect.aws.savingsplans/DurationsList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/nextToken
  :cognitect.aws.savingsplans/PaginationToken)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/descriptions
  :cognitect.aws.savingsplans/SavingsPlanDescriptionsList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingsRequest/maxResults
  :cognitect.aws.savingsplans/PageSize)

(s/def
  :cognitect.aws.savingsplans.CreateSavingsPlanRequest/savingsPlanOfferingId
  :cognitect.aws.savingsplans/SavingsPlanOfferingId)

(s/def
  :cognitect.aws.savingsplans.CreateSavingsPlanRequest/commitment
  :cognitect.aws.savingsplans/Amount)

(s/def
  :cognitect.aws.savingsplans.CreateSavingsPlanRequest/upfrontPaymentAmount
  :cognitect.aws.savingsplans/Amount)

(s/def
  :cognitect.aws.savingsplans.CreateSavingsPlanRequest/purchaseTime
  :cognitect.aws.savingsplans/DateTime)

(s/def
  :cognitect.aws.savingsplans.CreateSavingsPlanRequest/clientToken
  :cognitect.aws.savingsplans/ClientToken)

(s/def :cognitect.aws.savingsplans.CreateSavingsPlanRequest/tags :cognitect.aws.savingsplans/TagMap)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRateFilterElement/name
  :cognitect.aws.savingsplans/SavingsPlanRateFilterAttribute)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingRateFilterElement/values
  :cognitect.aws.savingsplans/FilterValuesList)

(s/def
  :cognitect.aws.savingsplans.ListTagsForResourceRequest/resourceArn
  :cognitect.aws.savingsplans/SavingsPlanArn)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/description
  :cognitect.aws.savingsplans/SavingsPlanDescription)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/properties
  :cognitect.aws.savingsplans/SavingsPlanOfferingPropertyList)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/operation
  :cognitect.aws.savingsplans/SavingsPlanOperation)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/usageType
  :cognitect.aws.savingsplans/SavingsPlanUsageType)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/durationSeconds
  :cognitect.aws.savingsplans/SavingsPlansDuration)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/currency
  :cognitect.aws.savingsplans/CurrencyCode)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/paymentOption
  :cognitect.aws.savingsplans/SavingsPlanPaymentOption)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/planType
  :cognitect.aws.savingsplans/SavingsPlanType)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/serviceCode
  :cognitect.aws.savingsplans/SavingsPlanServiceCode)

(s/def :cognitect.aws.savingsplans.SavingsPlanOffering/offeringId :cognitect.aws.savingsplans/UUID)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOffering/productTypes
  :cognitect.aws.savingsplans/SavingsPlanProductTypeList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/savingsPlanArns
  :cognitect.aws.savingsplans/SavingsPlanArnList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/savingsPlanIds
  :cognitect.aws.savingsplans/SavingsPlanIdList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/nextToken
  :cognitect.aws.savingsplans/PaginationToken)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/maxResults
  :cognitect.aws.savingsplans/MaxResults)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/states
  :cognitect.aws.savingsplans/SavingsPlanStateList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansRequest/filters
  :cognitect.aws.savingsplans/SavingsPlanFilterList)

(s/def
  :cognitect.aws.savingsplans.CreateSavingsPlanResponse/savingsPlanId
  :cognitect.aws.savingsplans/SavingsPlanId)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingProperty/name
  :cognitect.aws.savingsplans/SavingsPlanOfferingPropertyKey)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanOfferingProperty/value
  :cognitect.aws.savingsplans/JsonSafeFilterValueString)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRateFilter/name
  :cognitect.aws.savingsplans/SavingsPlanRateFilterName)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRateFilter/values
  :cognitect.aws.savingsplans/ListOfStrings)

(s/def :cognitect.aws.savingsplans.SavingsPlan/description :cognitect.aws.savingsplans/String)

(s/def :cognitect.aws.savingsplans.SavingsPlan/tags :cognitect.aws.savingsplans/TagMap)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/upfrontPaymentAmount
  :cognitect.aws.savingsplans/Amount)

(s/def :cognitect.aws.savingsplans.SavingsPlan/start :cognitect.aws.savingsplans/String)

(s/def :cognitect.aws.savingsplans.SavingsPlan/commitment :cognitect.aws.savingsplans/Amount)

(s/def :cognitect.aws.savingsplans.SavingsPlan/state :cognitect.aws.savingsplans/SavingsPlanState)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/savingsPlanType
  :cognitect.aws.savingsplans/SavingsPlanType)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/savingsPlanId
  :cognitect.aws.savingsplans/SavingsPlanId)

(s/def :cognitect.aws.savingsplans.SavingsPlan/region :cognitect.aws.savingsplans/Region)

(s/def :cognitect.aws.savingsplans.SavingsPlan/currency :cognitect.aws.savingsplans/CurrencyCode)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/paymentOption
  :cognitect.aws.savingsplans/SavingsPlanPaymentOption)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/savingsPlanArn
  :cognitect.aws.savingsplans/SavingsPlanArn)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/termDurationInSeconds
  :cognitect.aws.savingsplans/TermDurationInSeconds)

(s/def :cognitect.aws.savingsplans.SavingsPlan/end :cognitect.aws.savingsplans/String)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/offeringId
  :cognitect.aws.savingsplans/SavingsPlanOfferingId)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/recurringPaymentAmount
  :cognitect.aws.savingsplans/Amount)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/ec2InstanceFamily
  :cognitect.aws.savingsplans/EC2InstanceFamily)

(s/def
  :cognitect.aws.savingsplans.SavingsPlan/productTypes
  :cognitect.aws.savingsplans/SavingsPlanProductTypeList)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRateProperty/name
  :cognitect.aws.savingsplans/SavingsPlanRatePropertyKey)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanRateProperty/value
  :cognitect.aws.savingsplans/JsonSafeFilterValueString)

(s/def
  :cognitect.aws.savingsplans.UntagResourceRequest/resourceArn
  :cognitect.aws.savingsplans/SavingsPlanArn)

(s/def
  :cognitect.aws.savingsplans.UntagResourceRequest/tagKeys
  :cognitect.aws.savingsplans/TagKeyList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesResponse/searchResults
  :cognitect.aws.savingsplans/SavingsPlanOfferingRatesList)

(s/def
  :cognitect.aws.savingsplans.DescribeSavingsPlansOfferingRatesResponse/nextToken
  :cognitect.aws.savingsplans/PaginationToken)

(s/def
  :cognitect.aws.savingsplans.ListTagsForResourceResponse/tags
  :cognitect.aws.savingsplans/TagMap)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanFilter/name
  :cognitect.aws.savingsplans/SavingsPlansFilterName)

(s/def
  :cognitect.aws.savingsplans.SavingsPlanFilter/values
  :cognitect.aws.savingsplans/ListOfStrings)

