;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.servicecatalog.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.servicecatalog/UpdatePortfolioOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.UpdatePortfolioOutput/Tags
     :cognitect.aws.servicecatalog.UpdatePortfolioOutput/PortfolioDetail]))

(s/def
  :cognitect.aws.servicecatalog/ProvisionProductOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.ProvisionProductOutput/RecordDetail]))

(s/def
  :cognitect.aws.servicecatalog/ProvisionProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ProvisionProductInput/ProductId
     :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisionedProductName
     :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisionToken]
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisionProductInput/PathId
     :cognitect.aws.servicecatalog.ProvisionProductInput/Tags
     :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisioningParameters
     :cognitect.aws.servicecatalog.ProvisionProductInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ProvisionProductInput/NotificationArns
     :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisioningPreferences]))

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactPropertyName string?)

(s/def
  :cognitect.aws.servicecatalog/ResourceChange
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ResourceChange/PhysicalResourceId
     :cognitect.aws.servicecatalog.ResourceChange/LogicalResourceId
     :cognitect.aws.servicecatalog.ResourceChange/Details
     :cognitect.aws.servicecatalog.ResourceChange/ResourceType
     :cognitect.aws.servicecatalog.ResourceChange/Replacement
     :cognitect.aws.servicecatalog.ResourceChange/Action
     :cognitect.aws.servicecatalog.ResourceChange/Scope]))

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductNameOrArn
  (s/spec
    #(re-matches
      (re-pattern
        "[a-zA-Z0-9][a-zA-Z0-9._-]{0,127}|arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/ShareDetails
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ShareDetails/SuccessfulShares
     :cognitect.aws.servicecatalog.ShareDetails/ShareErrors]))

(s/def
  :cognitect.aws.servicecatalog/ListResourcesForTagOptionInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListResourcesForTagOptionInput/TagOptionId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListResourcesForTagOptionInput/PageSize
     :cognitect.aws.servicecatalog.ListResourcesForTagOptionInput/ResourceType
     :cognitect.aws.servicecatalog.ListResourcesForTagOptionInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/RecordError
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.RecordError/Description
     :cognitect.aws.servicecatalog.RecordError/Code]))

(s/def
  :cognitect.aws.servicecatalog/ProductType
  (s/spec
    (s/and string? #(>= 8191 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 8191) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/DescribeTagOptionOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.DescribeTagOptionOutput/TagOptionDetail]))

(s/def
  :cognitect.aws.servicecatalog/UpdateServiceActionInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.UpdateServiceActionInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateServiceActionInput/AcceptLanguage
     :cognitect.aws.servicecatalog.UpdateServiceActionInput/Description
     :cognitect.aws.servicecatalog.UpdateServiceActionInput/Definition
     :cognitect.aws.servicecatalog.UpdateServiceActionInput/Name]))

(s/def
  :cognitect.aws.servicecatalog/Principal
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.Principal/PrincipalType
     :cognitect.aws.servicecatalog.Principal/PrincipalARN]))

(s/def
  :cognitect.aws.servicecatalog/StackSetAccounts
  (s/coll-of :cognitect.aws.servicecatalog/AccountId))

(s/def :cognitect.aws.servicecatalog/ProductViewFilterBy string?)

(s/def :cognitect.aws.servicecatalog/AcceptPortfolioShareOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/ListRecordHistoryOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListRecordHistoryOutput/RecordDetails
     :cognitect.aws.servicecatalog.ListRecordHistoryOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/ErrorCode string?)

(s/def
  :cognitect.aws.servicecatalog/PortfolioDescription
  (s/spec
    (s/and string? #(>= 2000 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ConstraintDescription
  (s/spec
    (s/and string? #(>= 2000 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ListRecordHistorySearchFilter
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListRecordHistorySearchFilter/Key
     :cognitect.aws.servicecatalog.ListRecordHistorySearchFilter/Value]))

(s/def :cognitect.aws.servicecatalog/ResourceType string?)

(s/def
  :cognitect.aws.servicecatalog/SearchProductsAsAdminOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.SearchProductsAsAdminOutput/ProductViewDetails
     :cognitect.aws.servicecatalog.SearchProductsAsAdminOutput/NextPageToken]))

(s/def
  :cognitect.aws.servicecatalog/ProductViewAggregations
  (s/map-of
    :cognitect.aws.servicecatalog/ProductViewAggregationType
    :cognitect.aws.servicecatalog/ProductViewAggregationValues))

(s/def
  :cognitect.aws.servicecatalog/UpdateServiceActionOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.UpdateServiceActionOutput/ServiceActionDetail]))

(s/def
  :cognitect.aws.servicecatalog/ListTagOptionsInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListTagOptionsInput/PageSize
     :cognitect.aws.servicecatalog.ListTagOptionsInput/Filters
     :cognitect.aws.servicecatalog.ListTagOptionsInput/PageToken]))

(s/def :cognitect.aws.servicecatalog/OrganizationNodeType string?)

(s/def
  :cognitect.aws.servicecatalog/ListBudgetsForResourceOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListBudgetsForResourceOutput/Budgets
     :cognitect.aws.servicecatalog.ListBudgetsForResourceOutput/NextPageToken]))

(s/def
  :cognitect.aws.servicecatalog/AssociateBudgetWithResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.AssociateBudgetWithResourceInput/BudgetName
     :cognitect.aws.servicecatalog.AssociateBudgetWithResourceInput/ResourceId]))

(s/def
  :cognitect.aws.servicecatalog/OrganizationNodes
  (s/coll-of :cognitect.aws.servicecatalog/OrganizationNode))

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactCreatedTime inst?)

(s/def
  :cognitect.aws.servicecatalog/CreateServiceActionInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.CreateServiceActionInput/Name
     :cognitect.aws.servicecatalog.CreateServiceActionInput/DefinitionType
     :cognitect.aws.servicecatalog.CreateServiceActionInput/Definition
     :cognitect.aws.servicecatalog.CreateServiceActionInput/IdempotencyToken]
    :opt-un
    [:cognitect.aws.servicecatalog.CreateServiceActionInput/AcceptLanguage
     :cognitect.aws.servicecatalog.CreateServiceActionInput/Description]))

(s/def
  :cognitect.aws.servicecatalog/DeletePortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DeletePortfolioInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DeletePortfolioInput/AcceptLanguage]))

(s/def :cognitect.aws.servicecatalog/AccessLevelFilterKey string?)

(s/def :cognitect.aws.servicecatalog/OutputKey string?)

(s/def :cognitect.aws.servicecatalog/DeleteProvisioningArtifactOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/AccessLevelFilterValue string?)

(s/def
  :cognitect.aws.servicecatalog/ParameterValue
  (s/spec
    (s/and string? #(>= 4096 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/Tag
  (s/keys :req-un [:cognitect.aws.servicecatalog.Tag/Key :cognitect.aws.servicecatalog.Tag/Value]))

(s/def
  :cognitect.aws.servicecatalog/TotalResultsCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.servicecatalog/CopyProductStatus string?)

(s/def :cognitect.aws.servicecatalog/HasDefaultPath boolean?)

(s/def
  :cognitect.aws.servicecatalog/SupportUrl
  (s/spec
    (s/and string? #(>= 2083 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2083) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/LaunchPathSummary
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.LaunchPathSummary/Tags
     :cognitect.aws.servicecatalog.LaunchPathSummary/ConstraintSummaries
     :cognitect.aws.servicecatalog.LaunchPathSummary/Name
     :cognitect.aws.servicecatalog.LaunchPathSummary/Id]))

(s/def
  :cognitect.aws.servicecatalog/ServiceActionAssociation
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ServiceActionAssociation/ServiceActionId
     :cognitect.aws.servicecatalog.ServiceActionAssociation/ProductId
     :cognitect.aws.servicecatalog.ServiceActionAssociation/ProvisioningArtifactId]))

(s/def
  :cognitect.aws.servicecatalog/ListProvisioningArtifactsInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListProvisioningArtifactsInput/ProductId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListProvisioningArtifactsInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/DisassociateServiceActionFromProvisioningArtifactInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DisassociateServiceActionFromProvisioningArtifactInput/ProductId
     :cognitect.aws.servicecatalog.DisassociateServiceActionFromProvisioningArtifactInput/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.DisassociateServiceActionFromProvisioningArtifactInput/ServiceActionId]
    :opt-un
    [:cognitect.aws.servicecatalog.DisassociateServiceActionFromProvisioningArtifactInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/PlanResourceType
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ListOrganizationPortfolioAccessOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessOutput/OrganizationNodes
     :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessOutput/NextPageToken]))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifact
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisioningArtifact/Guidance
     :cognitect.aws.servicecatalog.ProvisioningArtifact/CreatedTime
     :cognitect.aws.servicecatalog.ProvisioningArtifact/Description
     :cognitect.aws.servicecatalog.ProvisioningArtifact/Name
     :cognitect.aws.servicecatalog.ProvisioningArtifact/Id]))

(s/def :cognitect.aws.servicecatalog/CloudWatchDashboardName string?)

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactActive boolean?)

(s/def
  :cognitect.aws.servicecatalog/CreateProvisioningArtifactOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.CreateProvisioningArtifactOutput/Info
     :cognitect.aws.servicecatalog.CreateProvisioningArtifactOutput/ProvisioningArtifactDetail
     :cognitect.aws.servicecatalog.CreateProvisioningArtifactOutput/Status]))

(s/def
  :cognitect.aws.servicecatalog/StackSetFailureTolerancePercentage
  (s/spec (s/and int? #(<= 0 % 100)) :gen #(gen/choose 0 100)))

(s/def
  :cognitect.aws.servicecatalog/ListConstraintsForPortfolioOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListConstraintsForPortfolioOutput/ConstraintDetails
     :cognitect.aws.servicecatalog.ListConstraintsForPortfolioOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactGuidance string?)

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductPlanDetails
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/StatusMessage
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/PathId
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/Tags
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProvisionProductId
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/Status
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProvisioningParameters
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/CreatedTime
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/PlanType
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/NotificationArns
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/PlanName
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/UpdatedTime
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProductId
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProvisionProductName
     :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/PlanId]))

(s/def
  :cognitect.aws.servicecatalog/CreateProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.CreateProductInput/Name
     :cognitect.aws.servicecatalog.CreateProductInput/Owner
     :cognitect.aws.servicecatalog.CreateProductInput/ProductType
     :cognitect.aws.servicecatalog.CreateProductInput/ProvisioningArtifactParameters
     :cognitect.aws.servicecatalog.CreateProductInput/IdempotencyToken]
    :opt-un
    [:cognitect.aws.servicecatalog.CreateProductInput/SupportDescription
     :cognitect.aws.servicecatalog.CreateProductInput/Tags
     :cognitect.aws.servicecatalog.CreateProductInput/AcceptLanguage
     :cognitect.aws.servicecatalog.CreateProductInput/Description
     :cognitect.aws.servicecatalog.CreateProductInput/Distributor
     :cognitect.aws.servicecatalog.CreateProductInput/SupportUrl
     :cognitect.aws.servicecatalog.CreateProductInput/SupportEmail]))

(s/def :cognitect.aws.servicecatalog/ProvisionedProductViewFilterValue string?)

(s/def :cognitect.aws.servicecatalog/EvaluationType string?)

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductAttribute
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisionedProductAttribute/UserArnSession
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Type
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/StatusMessage
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Tags
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Status
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/CreatedTime
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/PhysicalId
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Arn
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/IdempotencyToken
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Name
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/ProductId
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/LastRecordId
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/UserArn
     :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Id]))

(s/def :cognitect.aws.servicecatalog/NoEcho boolean?)

(s/def
  :cognitect.aws.servicecatalog/TagOptionValues
  (s/coll-of :cognitect.aws.servicecatalog/TagOptionValue))

(s/def
  :cognitect.aws.servicecatalog/ListResourcesForTagOptionOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListResourcesForTagOptionOutput/ResourceDetails
     :cognitect.aws.servicecatalog.ListResourcesForTagOptionOutput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/UpdateProvisionedProductOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.UpdateProvisionedProductOutput/RecordDetail]))

(s/def :cognitect.aws.servicecatalog/DisassociateTagOptionFromResourceOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactDescription string?)

(s/def
  :cognitect.aws.servicecatalog/ParameterKey
  (s/spec
    (s/and string? #(<= 1 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/BudgetDetail
  (s/keys :opt-un [:cognitect.aws.servicecatalog.BudgetDetail/BudgetName]))

(s/def
  :cognitect.aws.servicecatalog/ExecutionParameterKey
  (s/spec
    (s/and string? #(<= 1 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ListPortfoliosForProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListPortfoliosForProductInput/ProductId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListPortfoliosForProductInput/PageSize
     :cognitect.aws.servicecatalog.ListPortfoliosForProductInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListPortfoliosForProductInput/PageToken]))

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactInfoValue string?)

(s/def
  :cognitect.aws.servicecatalog/ListAcceptedPortfolioSharesInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesInput/PageSize
     :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesInput/PortfolioShareType
     :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/ListStackInstancesForProvisionedProductOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductOutput/StackInstances
     :cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductOutput/NextPageToken]))

(s/def
  :cognitect.aws.servicecatalog/CloudWatchDashboard
  (s/keys :opt-un [:cognitect.aws.servicecatalog.CloudWatchDashboard/Name]))

(s/def
  :cognitect.aws.servicecatalog/ResourceChangeDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ResourceChangeDetail/Evaluation
     :cognitect.aws.servicecatalog.ResourceChangeDetail/Target
     :cognitect.aws.servicecatalog.ResourceChangeDetail/CausingEntity]))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactDetails
  (s/coll-of :cognitect.aws.servicecatalog/ProvisioningArtifactDetail))

(s/def
  :cognitect.aws.servicecatalog/OrganizationNodeValue
  (s/spec
    #(re-matches
      (re-pattern
        "(^[0-9]{12}$)|(^arn:aws:organizations::\\d{12}:organization\\/o-[a-z0-9]{10,32})|(^o-[a-z0-9]{10,32}$)|(^arn:aws:organizations::\\d{12}:ou\\/o-[a-z0-9]{10,32}\\/ou-[0-9a-z]{4,32}-[0-9a-z]{8,32}$)|(^ou-[0-9a-z]{4,32}-[a-z0-9]{8,32}$)")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.servicecatalog/Principals (s/coll-of :cognitect.aws.servicecatalog/Principal))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningParameter
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisioningParameter/Key
     :cognitect.aws.servicecatalog.ProvisioningParameter/Value]))

(s/def :cognitect.aws.servicecatalog/Message string?)

(s/def
  :cognitect.aws.servicecatalog/AssociateProductWithPortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.AssociateProductWithPortfolioInput/ProductId
     :cognitect.aws.servicecatalog.AssociateProductWithPortfolioInput/PortfolioId]
    :opt-un
    [:cognitect.aws.servicecatalog.AssociateProductWithPortfolioInput/SourcePortfolioId
     :cognitect.aws.servicecatalog.AssociateProductWithPortfolioInput/AcceptLanguage]))

(s/def :cognitect.aws.servicecatalog/DeleteServiceActionOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/UpdateProvisioningParameters
  (s/coll-of :cognitect.aws.servicecatalog/UpdateProvisioningParameter))

(s/def
  :cognitect.aws.servicecatalog/TagOptionSummaries
  (s/coll-of :cognitect.aws.servicecatalog/TagOptionSummary))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactSummary
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisioningArtifactSummary/CreatedTime
     :cognitect.aws.servicecatalog.ProvisioningArtifactSummary/Description
     :cognitect.aws.servicecatalog.ProvisioningArtifactSummary/Name
     :cognitect.aws.servicecatalog.ProvisioningArtifactSummary/ProvisioningArtifactMetadata
     :cognitect.aws.servicecatalog.ProvisioningArtifactSummary/Id]))

(s/def
  :cognitect.aws.servicecatalog/ExecutionParameters
  (s/coll-of :cognitect.aws.servicecatalog/ExecutionParameter))

(s/def
  :cognitect.aws.servicecatalog/BatchDisassociateServiceActionFromProvisioningArtifactInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.BatchDisassociateServiceActionFromProvisioningArtifactInput/ServiceActionAssociations]
    :opt-un
    [:cognitect.aws.servicecatalog.BatchDisassociateServiceActionFromProvisioningArtifactInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/NotificationArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductViewFilterValues
  (s/coll-of :cognitect.aws.servicecatalog/ProvisionedProductViewFilterValue))

(s/def
  :cognitect.aws.servicecatalog/TerminateProvisionedProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.TerminateProvisionedProductInput/TerminateToken]
    :opt-un
    [:cognitect.aws.servicecatalog.TerminateProvisionedProductInput/ProvisionedProductName
     :cognitect.aws.servicecatalog.TerminateProvisionedProductInput/IgnoreErrors
     :cognitect.aws.servicecatalog.TerminateProvisionedProductInput/AcceptLanguage
     :cognitect.aws.servicecatalog.TerminateProvisionedProductInput/ProvisionedProductId]))

(s/def
  :cognitect.aws.servicecatalog/DescribeProvisioningParametersInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeProvisioningParametersInput/ProductId
     :cognitect.aws.servicecatalog.DescribeProvisioningParametersInput/ProvisioningArtifactId]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProvisioningParametersInput/PathId
     :cognitect.aws.servicecatalog.DescribeProvisioningParametersInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/StackSetMaxConcurrencyCount
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.servicecatalog/UpdateProvisioningParameter
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateProvisioningParameter/Key
     :cognitect.aws.servicecatalog.UpdateProvisioningParameter/Value
     :cognitect.aws.servicecatalog.UpdateProvisioningParameter/UsePreviousValue]))

(s/def
  :cognitect.aws.servicecatalog/CreateProvisioningArtifactInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.CreateProvisioningArtifactInput/ProductId
     :cognitect.aws.servicecatalog.CreateProvisioningArtifactInput/Parameters
     :cognitect.aws.servicecatalog.CreateProvisioningArtifactInput/IdempotencyToken]
    :opt-un
    [:cognitect.aws.servicecatalog.CreateProvisioningArtifactInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ExecutionParameterType
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductName
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9._-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/AccountId
  (s/spec #(re-matches (re-pattern "^[0-9]{12}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/RecordDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.RecordDetail/RecordTags
     :cognitect.aws.servicecatalog.RecordDetail/ProvisionedProductName
     :cognitect.aws.servicecatalog.RecordDetail/PathId
     :cognitect.aws.servicecatalog.RecordDetail/Status
     :cognitect.aws.servicecatalog.RecordDetail/CreatedTime
     :cognitect.aws.servicecatalog.RecordDetail/RecordId
     :cognitect.aws.servicecatalog.RecordDetail/RecordType
     :cognitect.aws.servicecatalog.RecordDetail/ProvisionedProductId
     :cognitect.aws.servicecatalog.RecordDetail/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.RecordDetail/RecordErrors
     :cognitect.aws.servicecatalog.RecordDetail/UpdatedTime
     :cognitect.aws.servicecatalog.RecordDetail/ProductId
     :cognitect.aws.servicecatalog.RecordDetail/ProvisionedProductType]))

(s/def
  :cognitect.aws.servicecatalog/UpdateProvisioningArtifactOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateProvisioningArtifactOutput/Info
     :cognitect.aws.servicecatalog.UpdateProvisioningArtifactOutput/ProvisioningArtifactDetail
     :cognitect.aws.servicecatalog.UpdateProvisioningArtifactOutput/Status]))

(s/def :cognitect.aws.servicecatalog/PortfolioName string?)

(s/def
  :cognitect.aws.servicecatalog/Id
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_\\-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/ServiceActionDefinitionMap
  (s/map-of
    :cognitect.aws.servicecatalog/ServiceActionDefinitionKey
    :cognitect.aws.servicecatalog/ServiceActionDefinitionValue
    :min-count
    1
    :max-count
    100))

(s/def
  :cognitect.aws.servicecatalog/BatchAssociateServiceActionWithProvisioningArtifactOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.BatchAssociateServiceActionWithProvisioningArtifactOutput/FailedServiceActionAssociations]))

(s/def :cognitect.aws.servicecatalog/ProvisionedProductStatusMessage string?)

(s/def
  :cognitect.aws.servicecatalog/DescribeProvisioningParametersOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/ProvisioningArtifactParameters
     :cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/UsageInstructions
     :cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/TagOptions
     :cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/ProvisioningArtifactPreferences
     :cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/ConstraintSummaries]))

(s/def
  :cognitect.aws.servicecatalog/DescribeProductViewOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProductViewOutput/ProductViewSummary
     :cognitect.aws.servicecatalog.DescribeProductViewOutput/ProvisioningArtifacts]))

(s/def
  :cognitect.aws.servicecatalog/StackSetFailureToleranceCount
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.servicecatalog/DescribeProductAsAdminInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeProductAsAdminInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProductAsAdminInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ListLaunchPathsInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListLaunchPathsInput/ProductId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListLaunchPathsInput/PageSize
     :cognitect.aws.servicecatalog.ListLaunchPathsInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListLaunchPathsInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/ListPortfoliosInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListPortfoliosInput/PageSize
     :cognitect.aws.servicecatalog.ListPortfoliosInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListPortfoliosInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/ProductArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/UpdateProvisioningPreferences
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetAccounts
     :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetOperationType
     :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetFailureTolerancePercentage
     :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetMaxConcurrencyPercentage
     :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetMaxConcurrencyCount
     :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetFailureToleranceCount
     :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetRegions]))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactPreferences
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisioningArtifactPreferences/StackSetAccounts
     :cognitect.aws.servicecatalog.ProvisioningArtifactPreferences/StackSetRegions]))

(s/def
  :cognitect.aws.servicecatalog/SearchProductsInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.SearchProductsInput/SortBy
     :cognitect.aws.servicecatalog.SearchProductsInput/PageSize
     :cognitect.aws.servicecatalog.SearchProductsInput/SortOrder
     :cognitect.aws.servicecatalog.SearchProductsInput/AcceptLanguage
     :cognitect.aws.servicecatalog.SearchProductsInput/Filters
     :cognitect.aws.servicecatalog.SearchProductsInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/PageToken
  (s/spec
    #(re-matches (re-pattern "[\\u0009\\u000a\\u000d\\u0020-\\uD7FF\\uE000-\\uFFFD]*") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/UsageInstruction
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.UsageInstruction/Type
     :cognitect.aws.servicecatalog.UsageInstruction/Value]))

(s/def
  :cognitect.aws.servicecatalog/ListServiceActionsForProvisioningArtifactOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactOutput/ServiceActionSummaries
     :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactOutput/NextPageToken]))

(s/def
  :cognitect.aws.servicecatalog/AllowedValues
  (s/coll-of :cognitect.aws.servicecatalog/AllowedValue))

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductPlans
  (s/coll-of :cognitect.aws.servicecatalog/ProvisionedProductPlanSummary))

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactPropertyValue string?)

(s/def
  :cognitect.aws.servicecatalog/ListProvisionedProductPlansInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/PageSize
     :cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/AccessLevelFilter
     :cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/ProvisionProductId
     :cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/DescribeRecordInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeRecordInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeRecordInput/PageSize
     :cognitect.aws.servicecatalog.DescribeRecordInput/AcceptLanguage
     :cognitect.aws.servicecatalog.DescribeRecordInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/Tags
  (s/coll-of :cognitect.aws.servicecatalog/Tag :max-count 50))

(s/def
  :cognitect.aws.servicecatalog/SourceProvisioningArtifactPropertiesMap
  (s/map-of
    :cognitect.aws.servicecatalog/ProvisioningArtifactPropertyName
    :cognitect.aws.servicecatalog/ProvisioningArtifactPropertyValue))

(s/def
  :cognitect.aws.servicecatalog/ListProvisionedProductPlansOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListProvisionedProductPlansOutput/ProvisionedProductPlans
     :cognitect.aws.servicecatalog.ListProvisionedProductPlansOutput/NextPageToken]))

(s/def
  :cognitect.aws.servicecatalog/DeleteServiceActionInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DeleteServiceActionInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DeleteServiceActionInput/AcceptLanguage]))

(s/def :cognitect.aws.servicecatalog/Verbose boolean?)

(s/def
  :cognitect.aws.servicecatalog/SourceProvisioningArtifactProperties
  (s/coll-of :cognitect.aws.servicecatalog/SourceProvisioningArtifactPropertiesMap))

(s/def :cognitect.aws.servicecatalog/ResourceId string?)

(s/def :cognitect.aws.servicecatalog/RecordStatus string?)

(s/def
  :cognitect.aws.servicecatalog/DescribeTagOptionInput
  (s/keys :req-un [:cognitect.aws.servicecatalog.DescribeTagOptionInput/Id]))

(s/def
  :cognitect.aws.servicecatalog/TagOptionKey
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/ResourceChangeDetails
  (s/coll-of :cognitect.aws.servicecatalog/ResourceChangeDetail))

(s/def
  :cognitect.aws.servicecatalog/CopyProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.CopyProductInput/SourceProductArn
     :cognitect.aws.servicecatalog.CopyProductInput/IdempotencyToken]
    :opt-un
    [:cognitect.aws.servicecatalog.CopyProductInput/TargetProductId
     :cognitect.aws.servicecatalog.CopyProductInput/SourceProvisioningArtifactIdentifiers
     :cognitect.aws.servicecatalog.CopyProductInput/CopyOptions
     :cognitect.aws.servicecatalog.CopyProductInput/AcceptLanguage
     :cognitect.aws.servicecatalog.CopyProductInput/TargetProductName]))

(s/def
  :cognitect.aws.servicecatalog/SearchProvisionedProductsPageSize
  (s/spec (s/and int? #(<= 0 % 100)) :gen #(gen/choose 0 100)))

(s/def
  :cognitect.aws.servicecatalog/ListProvisioningArtifactsForServiceActionOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionOutput/ProvisioningArtifactViews
     :cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/ProvisionedProductViewFilterBy string?)

(s/def
  :cognitect.aws.servicecatalog/AssociateServiceActionWithProvisioningArtifactInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.AssociateServiceActionWithProvisioningArtifactInput/ProductId
     :cognitect.aws.servicecatalog.AssociateServiceActionWithProvisioningArtifactInput/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.AssociateServiceActionWithProvisioningArtifactInput/ServiceActionId]
    :opt-un
    [:cognitect.aws.servicecatalog.AssociateServiceActionWithProvisioningArtifactInput/AcceptLanguage]))

(s/def :cognitect.aws.servicecatalog/UsePreviousValue boolean?)

(s/def :cognitect.aws.servicecatalog/AccessStatus string?)

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductFilters
  (s/map-of
    :cognitect.aws.servicecatalog/ProvisionedProductViewFilterBy
    :cognitect.aws.servicecatalog/ProvisionedProductViewFilterValues))

(s/def :cognitect.aws.servicecatalog/IgnoreErrors boolean?)

(s/def
  :cognitect.aws.servicecatalog/ListServiceActionsForProvisioningArtifactInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/ProductId
     :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/ProvisioningArtifactId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/PageSize
     :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/CreateServiceActionOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.CreateServiceActionOutput/ServiceActionDetail]))

(s/def
  :cognitect.aws.servicecatalog/ProductViewFilters
  (s/map-of
    :cognitect.aws.servicecatalog/ProductViewFilterBy
    :cognitect.aws.servicecatalog/ProductViewFilterValues))

(s/def
  :cognitect.aws.servicecatalog/DeleteProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DeleteProductInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DeleteProductInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/SuccessfulShares
  (s/coll-of :cognitect.aws.servicecatalog/AccountId))

(s/def
  :cognitect.aws.servicecatalog/PrincipalARN
  (s/spec
    (s/and string? #(<= 1 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/AssociateTagOptionWithResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.AssociateTagOptionWithResourceInput/ResourceId
     :cognitect.aws.servicecatalog.AssociateTagOptionWithResourceInput/TagOptionId]))

(s/def
  :cognitect.aws.servicecatalog/DescribeProductViewInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeProductViewInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProductViewInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ParameterConstraints
  (s/keys :opt-un [:cognitect.aws.servicecatalog.ParameterConstraints/AllowedValues]))

(s/def
  :cognitect.aws.servicecatalog/CopyOptions
  (s/coll-of :cognitect.aws.servicecatalog/CopyOption))

(s/def :cognitect.aws.servicecatalog/GetAWSOrganizationsAccessStatusInput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/CloudWatchDashboards
  (s/coll-of :cognitect.aws.servicecatalog/CloudWatchDashboard))

(s/def
  :cognitect.aws.servicecatalog/ShareError
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ShareError/Accounts
     :cognitect.aws.servicecatalog.ShareError/Message
     :cognitect.aws.servicecatalog.ShareError/Error]))

(s/def
  :cognitect.aws.servicecatalog/DescribePortfolioShareStatusOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/PortfolioShareToken
     :cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/PortfolioId
     :cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/OrganizationNodeValue
     :cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/Status
     :cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/ShareDetails]))

(s/def
  :cognitect.aws.servicecatalog/AssociatePrincipalWithPortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.AssociatePrincipalWithPortfolioInput/PortfolioId
     :cognitect.aws.servicecatalog.AssociatePrincipalWithPortfolioInput/PrincipalARN
     :cognitect.aws.servicecatalog.AssociatePrincipalWithPortfolioInput/PrincipalType]
    :opt-un
    [:cognitect.aws.servicecatalog.AssociatePrincipalWithPortfolioInput/AcceptLanguage]))

(s/def :cognitect.aws.servicecatalog/EnableAWSOrganizationsAccessOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/AllowedValue string?)

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductAttributes
  (s/coll-of :cognitect.aws.servicecatalog/ProvisionedProductAttribute))

(s/def
  :cognitect.aws.servicecatalog/ProductViewSummary
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProductViewSummary/SupportDescription
     :cognitect.aws.servicecatalog.ProductViewSummary/Type
     :cognitect.aws.servicecatalog.ProductViewSummary/ShortDescription
     :cognitect.aws.servicecatalog.ProductViewSummary/HasDefaultPath
     :cognitect.aws.servicecatalog.ProductViewSummary/Owner
     :cognitect.aws.servicecatalog.ProductViewSummary/Distributor
     :cognitect.aws.servicecatalog.ProductViewSummary/Name
     :cognitect.aws.servicecatalog.ProductViewSummary/SupportUrl
     :cognitect.aws.servicecatalog.ProductViewSummary/ProductId
     :cognitect.aws.servicecatalog.ProductViewSummary/SupportEmail
     :cognitect.aws.servicecatalog.ProductViewSummary/Id]))

(s/def :cognitect.aws.servicecatalog/ServiceActionDefinitionType string?)

(s/def :cognitect.aws.servicecatalog/CausingEntity string?)

(s/def
  :cognitect.aws.servicecatalog/UpdateTagOptionOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.UpdateTagOptionOutput/TagOptionDetail]))

(s/def :cognitect.aws.servicecatalog/EnableAWSOrganizationsAccessInput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/UpdateProvisioningArtifactInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/ProductId
     :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/ProvisioningArtifactId]
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/Active
     :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/Guidance
     :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/AcceptLanguage
     :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/Description
     :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/Name]))

(s/def :cognitect.aws.servicecatalog/AssociateServiceActionWithProvisioningArtifactOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/ListPortfoliosOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListPortfoliosOutput/PortfolioDetails
     :cognitect.aws.servicecatalog.ListPortfoliosOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/StatusDetail string?)

(s/def
  :cognitect.aws.servicecatalog/ProductViewShortDescription
  (s/spec
    (s/and string? #(>= 8191 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 8191) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/CreateProvisionedProductPlanInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/PlanName
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/PlanType
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/ProductId
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/ProvisionedProductName
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/IdempotencyToken]
    :opt-un
    [:cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/PathId
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/Tags
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/ProvisioningParameters
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/AcceptLanguage
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/NotificationArns]))

(s/def
  :cognitect.aws.servicecatalog/CreatePortfolioOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.CreatePortfolioOutput/Tags
     :cognitect.aws.servicecatalog.CreatePortfolioOutput/PortfolioDetail]))

(s/def
  :cognitect.aws.servicecatalog/DescribeConstraintOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeConstraintOutput/ConstraintDetail
     :cognitect.aws.servicecatalog.DescribeConstraintOutput/Status
     :cognitect.aws.servicecatalog.DescribeConstraintOutput/ConstraintParameters]))

(s/def :cognitect.aws.servicecatalog/DeleteProvisionedProductPlanOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/RecordType string?)

(s/def
  :cognitect.aws.servicecatalog/Scope
  (s/coll-of :cognitect.aws.servicecatalog/ResourceAttribute))

(s/def
  :cognitect.aws.servicecatalog/ServiceActionSummary
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ServiceActionSummary/DefinitionType
     :cognitect.aws.servicecatalog.ServiceActionSummary/Description
     :cognitect.aws.servicecatalog.ServiceActionSummary/Name
     :cognitect.aws.servicecatalog.ServiceActionSummary/Id]))

(s/def
  :cognitect.aws.servicecatalog/CreatePortfolioShareInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.CreatePortfolioShareInput/PortfolioId]
    :opt-un
    [:cognitect.aws.servicecatalog.CreatePortfolioShareInput/AcceptLanguage
     :cognitect.aws.servicecatalog.CreatePortfolioShareInput/AccountId
     :cognitect.aws.servicecatalog.CreatePortfolioShareInput/OrganizationNode]))

(s/def
  :cognitect.aws.servicecatalog/ListTagOptionsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListTagOptionsOutput/TagOptionDetails
     :cognitect.aws.servicecatalog.ListTagOptionsOutput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactInfo
  (s/map-of
    :cognitect.aws.servicecatalog/ProvisioningArtifactInfoKey
    :cognitect.aws.servicecatalog/ProvisioningArtifactInfoValue
    :min-count
    1
    :max-count
    100))

(s/def :cognitect.aws.servicecatalog/DisassociateBudgetFromResourceOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/DeleteConstraintOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/ServiceActionName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_\\-.]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/UpdateConstraintInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.UpdateConstraintInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateConstraintInput/Parameters
     :cognitect.aws.servicecatalog.UpdateConstraintInput/AcceptLanguage
     :cognitect.aws.servicecatalog.UpdateConstraintInput/Description]))

(s/def
  :cognitect.aws.servicecatalog/TagOptionDetails
  (s/coll-of :cognitect.aws.servicecatalog/TagOptionDetail))

(s/def :cognitect.aws.servicecatalog/PhysicalId string?)

(s/def
  :cognitect.aws.servicecatalog/LaunchPathSummaries
  (s/coll-of :cognitect.aws.servicecatalog/LaunchPathSummary))

(s/def :cognitect.aws.servicecatalog/AssociatePrincipalWithPortfolioOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/UserArnSession string?)

(s/def
  :cognitect.aws.servicecatalog/SearchProvisionedProductsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.SearchProvisionedProductsOutput/TotalResultsCount
     :cognitect.aws.servicecatalog.SearchProvisionedProductsOutput/ProvisionedProducts
     :cognitect.aws.servicecatalog.SearchProvisionedProductsOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/PhysicalResourceId string?)

(s/def :cognitect.aws.servicecatalog/DeleteProductOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/ResourceDetails
  (s/coll-of :cognitect.aws.servicecatalog/ResourceDetail))

(s/def
  :cognitect.aws.servicecatalog/DescribePortfolioShareStatusInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribePortfolioShareStatusInput/PortfolioShareToken]))

(s/def
  :cognitect.aws.servicecatalog/ListAcceptedPortfolioSharesOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesOutput/PortfolioDetails
     :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/ProductViewFilterValue string?)

(s/def
  :cognitect.aws.servicecatalog/ServiceActionDescription
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/CreateProductOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.CreateProductOutput/ProductViewDetail
     :cognitect.aws.servicecatalog.CreateProductOutput/Tags
     :cognitect.aws.servicecatalog.CreateProductOutput/ProvisioningArtifactDetail]))

(s/def :cognitect.aws.servicecatalog/ConstraintParameters string?)

(s/def
  :cognitect.aws.servicecatalog/DescribeProductOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProductOutput/ProductViewSummary
     :cognitect.aws.servicecatalog.DescribeProductOutput/Budgets
     :cognitect.aws.servicecatalog.DescribeProductOutput/ProvisioningArtifacts]))

(s/def
  :cognitect.aws.servicecatalog/ProductViewDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProductViewDetail/ProductARN
     :cognitect.aws.servicecatalog.ProductViewDetail/Status
     :cognitect.aws.servicecatalog.ProductViewDetail/CreatedTime
     :cognitect.aws.servicecatalog.ProductViewDetail/ProductViewSummary]))

(s/def :cognitect.aws.servicecatalog/AssociateBudgetWithResourceOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/PrincipalType string?)

(s/def
  :cognitect.aws.servicecatalog/ExecutionParameterValueList
  (s/coll-of :cognitect.aws.servicecatalog/ExecutionParameterValue :min-count 0 :max-count 25))

(s/def
  :cognitect.aws.servicecatalog/TagValue
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/ListConstraintsForPortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/PortfolioId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/PageSize
     :cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/ProductId
     :cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/DeleteProvisioningArtifactInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DeleteProvisioningArtifactInput/ProductId
     :cognitect.aws.servicecatalog.DeleteProvisioningArtifactInput/ProvisioningArtifactId]
    :opt-un
    [:cognitect.aws.servicecatalog.DeleteProvisioningArtifactInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ListTagOptionsFilters
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListTagOptionsFilters/Active
     :cognitect.aws.servicecatalog.ListTagOptionsFilters/Key
     :cognitect.aws.servicecatalog.ListTagOptionsFilters/Value]))

(s/def :cognitect.aws.servicecatalog/Replacement string?)

(s/def :cognitect.aws.servicecatalog/DisassociatePrincipalFromPortfolioOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactType string?)

(s/def
  :cognitect.aws.servicecatalog/ProviderName
  (s/spec
    (s/and string? #(<= 1 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.servicecatalog/ResourceDetailCreatedTime inst?)

(s/def
  :cognitect.aws.servicecatalog/DisassociatePrincipalFromPortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DisassociatePrincipalFromPortfolioInput/PortfolioId
     :cognitect.aws.servicecatalog.DisassociatePrincipalFromPortfolioInput/PrincipalARN]
    :opt-un
    [:cognitect.aws.servicecatalog.DisassociatePrincipalFromPortfolioInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/FailedServiceActionAssociation
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.FailedServiceActionAssociation/ServiceActionId
     :cognitect.aws.servicecatalog.FailedServiceActionAssociation/ErrorMessage
     :cognitect.aws.servicecatalog.FailedServiceActionAssociation/ErrorCode
     :cognitect.aws.servicecatalog.FailedServiceActionAssociation/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.FailedServiceActionAssociation/ProductId]))

(s/def
  :cognitect.aws.servicecatalog/BatchDisassociateServiceActionFromProvisioningArtifactOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.BatchDisassociateServiceActionFromProvisioningArtifactOutput/FailedServiceActionAssociations]))

(s/def
  :cognitect.aws.servicecatalog/ListServiceActionsInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListServiceActionsInput/PageSize
     :cognitect.aws.servicecatalog.ListServiceActionsInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListServiceActionsInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/ResourceChanges
  (s/coll-of :cognitect.aws.servicecatalog/ResourceChange))

(s/def
  :cognitect.aws.servicecatalog/StackInstances
  (s/coll-of :cognitect.aws.servicecatalog/StackInstance))

(s/def
  :cognitect.aws.servicecatalog/DescribeProductAsAdminOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/ProvisioningArtifactSummaries
     :cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/ProductViewDetail
     :cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/Tags
     :cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/TagOptions
     :cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/Budgets]))

(s/def
  :cognitect.aws.servicecatalog/ExecutionParameter
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ExecutionParameter/Type
     :cognitect.aws.servicecatalog.ExecutionParameter/DefaultValues
     :cognitect.aws.servicecatalog.ExecutionParameter/Name]))

(s/def
  :cognitect.aws.servicecatalog/UpdateProvisionedProductPropertiesInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesInput/ProvisionedProductId
     :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesInput/ProvisionedProductProperties
     :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesInput/IdempotencyToken]
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ConstraintSummary
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ConstraintSummary/Type
     :cognitect.aws.servicecatalog.ConstraintSummary/Description]))

(s/def :cognitect.aws.servicecatalog/SortField string?)

(s/def
  :cognitect.aws.servicecatalog/ListStackInstancesForProvisionedProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductInput/ProvisionedProductId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductInput/PageSize
     :cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductInput/PageToken]))

(s/def :cognitect.aws.servicecatalog/TagOptionActive boolean?)

(s/def
  :cognitect.aws.servicecatalog/SearchProvisionedProductsInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.SearchProvisionedProductsInput/SortBy
     :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/PageSize
     :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/AccessLevelFilter
     :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/SortOrder
     :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/AcceptLanguage
     :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/Filters
     :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/PageToken]))

(s/def :cognitect.aws.servicecatalog/ProductViewSortBy string?)

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactSummaries
  (s/coll-of :cognitect.aws.servicecatalog/ProvisioningArtifactSummary))

(s/def
  :cognitect.aws.servicecatalog/DescribeProvisionedProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeProvisionedProductInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProvisionedProductInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/OrganizationNode
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.OrganizationNode/Type
     :cognitect.aws.servicecatalog.OrganizationNode/Value]))

(s/def :cognitect.aws.servicecatalog/UserArn string?)

(s/def
  :cognitect.aws.servicecatalog/ExecuteProvisionedProductPlanInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ExecuteProvisionedProductPlanInput/PlanId
     :cognitect.aws.servicecatalog.ExecuteProvisionedProductPlanInput/IdempotencyToken]
    :opt-un
    [:cognitect.aws.servicecatalog.ExecuteProvisionedProductPlanInput/AcceptLanguage]))

(s/def :cognitect.aws.servicecatalog/SearchFilterKey string?)

(s/def
  :cognitect.aws.servicecatalog/DeletePortfolioShareInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DeletePortfolioShareInput/PortfolioId]
    :opt-un
    [:cognitect.aws.servicecatalog.DeletePortfolioShareInput/AcceptLanguage
     :cognitect.aws.servicecatalog.DeletePortfolioShareInput/AccountId
     :cognitect.aws.servicecatalog.DeletePortfolioShareInput/OrganizationNode]))

(s/def
  :cognitect.aws.servicecatalog/PortfolioDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.PortfolioDetail/ARN
     :cognitect.aws.servicecatalog.PortfolioDetail/CreatedTime
     :cognitect.aws.servicecatalog.PortfolioDetail/DisplayName
     :cognitect.aws.servicecatalog.PortfolioDetail/Description
     :cognitect.aws.servicecatalog.PortfolioDetail/ProviderName
     :cognitect.aws.servicecatalog.PortfolioDetail/Id]))

(s/def
  :cognitect.aws.servicecatalog/UpdateProvisionedProductPropertiesOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesOutput/Status
     :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesOutput/RecordId
     :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesOutput/ProvisionedProductId
     :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesOutput/ProvisionedProductProperties]))

(s/def :cognitect.aws.servicecatalog/DeleteTagOptionOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/ProductSource string?)

(s/def :cognitect.aws.servicecatalog/ProvisionedProductStatus string?)

(s/def
  :cognitect.aws.servicecatalog/DescribeProvisionedProductPlanOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProvisionedProductPlanOutput/ResourceChanges
     :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanOutput/ProvisionedProductPlanDetails
     :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanOutput/NextPageToken]))

(s/def
  :cognitect.aws.servicecatalog/RecordDetails
  (s/coll-of :cognitect.aws.servicecatalog/RecordDetail))

(s/def
  :cognitect.aws.servicecatalog/UpdateConstraintOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateConstraintOutput/ConstraintDetail
     :cognitect.aws.servicecatalog.UpdateConstraintOutput/Status
     :cognitect.aws.servicecatalog.UpdateConstraintOutput/ConstraintParameters]))

(s/def
  :cognitect.aws.servicecatalog/PortfolioDisplayName
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/RecordTagKey
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/UpdateTagOptionInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.UpdateTagOptionInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateTagOptionInput/Active
     :cognitect.aws.servicecatalog.UpdateTagOptionInput/Value]))

(s/def :cognitect.aws.servicecatalog/ShareStatus string?)

(s/def
  :cognitect.aws.servicecatalog/NotificationArns
  (s/coll-of :cognitect.aws.servicecatalog/NotificationArn :max-count 5))

(s/def
  :cognitect.aws.servicecatalog/RecordOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.RecordOutput/Description
     :cognitect.aws.servicecatalog.RecordOutput/OutputValue
     :cognitect.aws.servicecatalog.RecordOutput/OutputKey]))

(s/def
  :cognitect.aws.servicecatalog/ResourceARN
  (s/spec
    (s/and string? #(<= 1 (count %) 150))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 150) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactParameter
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisioningArtifactParameter/ParameterType
     :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/ParameterKey
     :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/IsNoEcho
     :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/Description
     :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/DefaultValue
     :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/ParameterConstraints]))

(s/def :cognitect.aws.servicecatalog/Region string?)

(s/def
  :cognitect.aws.servicecatalog/ConstraintType
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/DescribePortfolioOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribePortfolioOutput/Tags
     :cognitect.aws.servicecatalog.DescribePortfolioOutput/TagOptions
     :cognitect.aws.servicecatalog.DescribePortfolioOutput/PortfolioDetail
     :cognitect.aws.servicecatalog.DescribePortfolioOutput/Budgets]))

(s/def
  :cognitect.aws.servicecatalog/DescribeServiceActionExecutionParametersOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeServiceActionExecutionParametersOutput/ServiceActionParameters]))

(s/def
  :cognitect.aws.servicecatalog/ProductViewSummaries
  (s/coll-of :cognitect.aws.servicecatalog/ProductViewSummary))

(s/def
  :cognitect.aws.servicecatalog/TerminateProvisionedProductOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.TerminateProvisionedProductOutput/RecordDetail]))

(s/def
  :cognitect.aws.servicecatalog/ListPrincipalsForPortfolioOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListPrincipalsForPortfolioOutput/NextPageToken
     :cognitect.aws.servicecatalog.ListPrincipalsForPortfolioOutput/Principals]))

(s/def
  :cognitect.aws.servicecatalog/FailedServiceActionAssociations
  (s/coll-of :cognitect.aws.servicecatalog/FailedServiceActionAssociation :max-count 50))

(s/def
  :cognitect.aws.servicecatalog/DeleteTagOptionInput
  (s/keys :req-un [:cognitect.aws.servicecatalog.DeleteTagOptionInput/Id]))

(s/def
  :cognitect.aws.servicecatalog/DescribeCopyProductStatusInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeCopyProductStatusInput/CopyProductToken]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeCopyProductStatusInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactView
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisioningArtifactView/ProvisioningArtifact
     :cognitect.aws.servicecatalog.ProvisioningArtifactView/ProductViewSummary]))

(s/def
  :cognitect.aws.servicecatalog/AccessLevelFilter
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.AccessLevelFilter/Key
     :cognitect.aws.servicecatalog.AccessLevelFilter/Value]))

(s/def :cognitect.aws.servicecatalog/CopyOption string?)

(s/def :cognitect.aws.servicecatalog/ServiceActionAssociationErrorCode string?)

(s/def :cognitect.aws.servicecatalog/ProvisionedProductPlanStatus string?)

(s/def
  :cognitect.aws.servicecatalog/ListPortfoliosForProductOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListPortfoliosForProductOutput/PortfolioDetails
     :cognitect.aws.servicecatalog.ListPortfoliosForProductOutput/NextPageToken]))

(s/def
  :cognitect.aws.servicecatalog/ProductViewName
  (s/spec
    (s/and string? #(>= 8191 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 8191) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/RecordTags
  (s/coll-of :cognitect.aws.servicecatalog/RecordTag :max-count 50))

(s/def
  :cognitect.aws.servicecatalog/ConstraintDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ConstraintDetail/Type
     :cognitect.aws.servicecatalog.ConstraintDetail/Description
     :cognitect.aws.servicecatalog.ConstraintDetail/ConstraintId
     :cognitect.aws.servicecatalog.ConstraintDetail/Owner]))

(s/def
  :cognitect.aws.servicecatalog/DisassociateProductFromPortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DisassociateProductFromPortfolioInput/ProductId
     :cognitect.aws.servicecatalog.DisassociateProductFromPortfolioInput/PortfolioId]
    :opt-un
    [:cognitect.aws.servicecatalog.DisassociateProductFromPortfolioInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/PortfolioDetails
  (s/coll-of :cognitect.aws.servicecatalog/PortfolioDetail))

(s/def
  :cognitect.aws.servicecatalog/DisassociateServiceActionFromProvisioningArtifactOutput
  (s/keys))

(s/def :cognitect.aws.servicecatalog/Namespaces (s/coll-of :cognitect.aws.servicecatalog/AccountId))

(s/def
  :cognitect.aws.servicecatalog/ListPortfolioAccessOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListPortfolioAccessOutput/AccountIds
     :cognitect.aws.servicecatalog.ListPortfolioAccessOutput/NextPageToken]))

(s/def
  :cognitect.aws.servicecatalog/ListBudgetsForResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListBudgetsForResourceInput/ResourceId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListBudgetsForResourceInput/PageSize
     :cognitect.aws.servicecatalog.ListBudgetsForResourceInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListBudgetsForResourceInput/PageToken]))

(s/def :cognitect.aws.servicecatalog/PortfolioShareType string?)

(s/def :cognitect.aws.servicecatalog/SearchFilterValue string?)

(s/def
  :cognitect.aws.servicecatalog/DescribeServiceActionExecutionParametersInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeServiceActionExecutionParametersInput/ProvisionedProductId
     :cognitect.aws.servicecatalog.DescribeServiceActionExecutionParametersInput/ServiceActionId]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeServiceActionExecutionParametersInput/AcceptLanguage]))

(s/def :cognitect.aws.servicecatalog/ResourceDetailId string?)

(s/def :cognitect.aws.servicecatalog/CreationTime inst?)

(s/def
  :cognitect.aws.servicecatalog/PropertyKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.servicecatalog/SortOrder string?)

(s/def :cognitect.aws.servicecatalog/RejectPortfolioShareOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/ListServiceActionsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListServiceActionsOutput/ServiceActionSummaries
     :cognitect.aws.servicecatalog.ListServiceActionsOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/DeletePortfolioOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/DescribeConstraintInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeConstraintInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeConstraintInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ListProvisioningArtifactsForServiceActionInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionInput/ServiceActionId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionInput/PageSize
     :cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionInput/PageToken]))

(s/def :cognitect.aws.servicecatalog/InstructionValue string?)

(s/def
  :cognitect.aws.servicecatalog/IdempotencyToken
  (s/spec #(re-matches (re-pattern "[a-zA-Z0-9][a-zA-Z0-9_-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/DescribeProvisionedProductOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProvisionedProductOutput/CloudWatchDashboards
     :cognitect.aws.servicecatalog.DescribeProvisionedProductOutput/ProvisionedProductDetail]))

(s/def
  :cognitect.aws.servicecatalog/ServiceActionAssociations
  (s/coll-of :cognitect.aws.servicecatalog/ServiceActionAssociation :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.servicecatalog/DescribeRecordOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeRecordOutput/RecordDetail
     :cognitect.aws.servicecatalog.DescribeRecordOutput/RecordOutputs
     :cognitect.aws.servicecatalog.DescribeRecordOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/DisableAWSOrganizationsAccessOutput (s/keys))

(s/def :cognitect.aws.servicecatalog/ResourceDetailARN string?)

(s/def :cognitect.aws.servicecatalog/ParameterType string?)

(s/def
  :cognitect.aws.servicecatalog/CreateConstraintInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.CreateConstraintInput/PortfolioId
     :cognitect.aws.servicecatalog.CreateConstraintInput/ProductId
     :cognitect.aws.servicecatalog.CreateConstraintInput/Parameters
     :cognitect.aws.servicecatalog.CreateConstraintInput/Type
     :cognitect.aws.servicecatalog.CreateConstraintInput/IdempotencyToken]
    :opt-un
    [:cognitect.aws.servicecatalog.CreateConstraintInput/AcceptLanguage
     :cognitect.aws.servicecatalog.CreateConstraintInput/Description]))

(s/def
  :cognitect.aws.servicecatalog/ConstraintDetails
  (s/coll-of :cognitect.aws.servicecatalog/ConstraintDetail))

(s/def
  :cognitect.aws.servicecatalog/ServiceActionDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ServiceActionDetail/Definition
     :cognitect.aws.servicecatalog.ServiceActionDetail/ServiceActionSummary]))

(s/def
  :cognitect.aws.servicecatalog/ListProvisioningArtifactsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListProvisioningArtifactsOutput/ProvisioningArtifactDetails
     :cognitect.aws.servicecatalog.ListProvisioningArtifactsOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/ProvisionedProductPlanType string?)

(s/def
  :cognitect.aws.servicecatalog/ProductViewAggregationValues
  (s/coll-of :cognitect.aws.servicecatalog/ProductViewAggregationValue))

(s/def
  :cognitect.aws.servicecatalog/ProductViewFilterValues
  (s/coll-of :cognitect.aws.servicecatalog/ProductViewFilterValue))

(s/def
  :cognitect.aws.servicecatalog/CreateTagOptionOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.CreateTagOptionOutput/TagOptionDetail]))

(s/def
  :cognitect.aws.servicecatalog/DeleteConstraintInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DeleteConstraintInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DeleteConstraintInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/StackInstance
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.StackInstance/StackInstanceStatus
     :cognitect.aws.servicecatalog.StackInstance/Account
     :cognitect.aws.servicecatalog.StackInstance/Region]))

(s/def
  :cognitect.aws.servicecatalog/AddTags
  (s/coll-of :cognitect.aws.servicecatalog/Tag :max-count 20))

(s/def
  :cognitect.aws.servicecatalog/UpdateProductOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateProductOutput/ProductViewDetail
     :cognitect.aws.servicecatalog.UpdateProductOutput/Tags]))

(s/def
  :cognitect.aws.servicecatalog/ExecuteProvisionedProductServiceActionOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionOutput/RecordDetail]))

(s/def
  :cognitect.aws.servicecatalog/SearchProductsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.SearchProductsOutput/ProductViewAggregations
     :cognitect.aws.servicecatalog.SearchProductsOutput/ProductViewSummaries
     :cognitect.aws.servicecatalog.SearchProductsOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/LogicalResourceId string?)

(s/def
  :cognitect.aws.servicecatalog/DescribeProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeProductInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProductInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ServiceActionAssociationErrorMessage
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.servicecatalog/AssociateProductWithPortfolioOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/TagOptionDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.TagOptionDetail/Active
     :cognitect.aws.servicecatalog.TagOptionDetail/Key
     :cognitect.aws.servicecatalog.TagOptionDetail/Value
     :cognitect.aws.servicecatalog.TagOptionDetail/Id]))

(s/def
  :cognitect.aws.servicecatalog/DescribePortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribePortfolioInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribePortfolioInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ExecuteProvisionedProductServiceActionInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/ProvisionedProductId
     :cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/ServiceActionId
     :cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/ExecuteToken]
    :opt-un
    [:cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/Parameters
     :cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/AcceptLanguage]))

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactInfoKey string?)

(s/def :cognitect.aws.servicecatalog/StackSetOperationType string?)

(s/def
  :cognitect.aws.servicecatalog/ScanProvisionedProductsInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ScanProvisionedProductsInput/PageSize
     :cognitect.aws.servicecatalog.ScanProvisionedProductsInput/AccessLevelFilter
     :cognitect.aws.servicecatalog.ScanProvisionedProductsInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ScanProvisionedProductsInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/DeletePortfolioShareOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.DeletePortfolioShareOutput/PortfolioShareToken]))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactProperties
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ProvisioningArtifactProperties/Info]
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisioningArtifactProperties/Type
     :cognitect.aws.servicecatalog.ProvisioningArtifactProperties/DisableTemplateValidation
     :cognitect.aws.servicecatalog.ProvisioningArtifactProperties/Description
     :cognitect.aws.servicecatalog.ProvisioningArtifactProperties/Name]))

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductProperties
  (s/map-of
    :cognitect.aws.servicecatalog/PropertyKey
    :cognitect.aws.servicecatalog/PropertyValue
    :min-count
    1
    :max-count
    100))

(s/def
  :cognitect.aws.servicecatalog/SupportDescription
  (s/spec
    (s/and string? #(>= 8191 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 8191) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ProductViewOwner
  (s/spec
    (s/and string? #(>= 8191 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 8191) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/PageSize
  (s/spec (s/and int? #(<= 0 % 20)) :gen #(gen/choose 0 20)))

(s/def
  :cognitect.aws.servicecatalog/StatusMessage
  (s/spec
    #(re-matches (re-pattern "[\\u0009\\u000a\\u000d\\u0020-\\uD7FF\\uE000-\\uFFFD]*") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningParameters
  (s/coll-of :cognitect.aws.servicecatalog/ProvisioningParameter))

(s/def
  :cognitect.aws.servicecatalog/TagKey
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def :cognitect.aws.servicecatalog/AssociateTagOptionWithResourceOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/BatchAssociateServiceActionWithProvisioningArtifactInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.BatchAssociateServiceActionWithProvisioningArtifactInput/ServiceActionAssociations]
    :opt-un
    [:cognitect.aws.servicecatalog.BatchAssociateServiceActionWithProvisioningArtifactInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/CreatePortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.CreatePortfolioInput/DisplayName
     :cognitect.aws.servicecatalog.CreatePortfolioInput/ProviderName
     :cognitect.aws.servicecatalog.CreatePortfolioInput/IdempotencyToken]
    :opt-un
    [:cognitect.aws.servicecatalog.CreatePortfolioInput/Tags
     :cognitect.aws.servicecatalog.CreatePortfolioInput/AcceptLanguage
     :cognitect.aws.servicecatalog.CreatePortfolioInput/Description]))

(s/def
  :cognitect.aws.servicecatalog/UsageInstructions
  (s/coll-of :cognitect.aws.servicecatalog/UsageInstruction))

(s/def
  :cognitect.aws.servicecatalog/CopyProductOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.CopyProductOutput/CopyProductToken]))

(s/def
  :cognitect.aws.servicecatalog/ApproximateCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.servicecatalog/DisassociateTagOptionFromResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DisassociateTagOptionFromResourceInput/ResourceId
     :cognitect.aws.servicecatalog.DisassociateTagOptionFromResourceInput/TagOptionId]))

(s/def
  :cognitect.aws.servicecatalog/RecordTag
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.RecordTag/Key :cognitect.aws.servicecatalog.RecordTag/Value]))

(s/def
  :cognitect.aws.servicecatalog/DisassociateBudgetFromResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DisassociateBudgetFromResourceInput/BudgetName
     :cognitect.aws.servicecatalog.DisassociateBudgetFromResourceInput/ResourceId]))

(s/def :cognitect.aws.servicecatalog/Description string?)

(s/def
  :cognitect.aws.servicecatalog/StackSetMaxConcurrencyPercentage
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def :cognitect.aws.servicecatalog/DefaultValue string?)

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductDetails
  (s/coll-of :cognitect.aws.servicecatalog/ProvisionedProductDetail))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningPreferences
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetAccounts
     :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetFailureTolerancePercentage
     :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetMaxConcurrencyPercentage
     :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetMaxConcurrencyCount
     :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetFailureToleranceCount
     :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetRegions]))

(s/def
  :cognitect.aws.servicecatalog/ProductViewAggregationValue
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProductViewAggregationValue/ApproximateCount
     :cognitect.aws.servicecatalog.ProductViewAggregationValue/Value]))

(s/def
  :cognitect.aws.servicecatalog/UpdatePortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.UpdatePortfolioInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.UpdatePortfolioInput/RemoveTags
     :cognitect.aws.servicecatalog.UpdatePortfolioInput/DisplayName
     :cognitect.aws.servicecatalog.UpdatePortfolioInput/AcceptLanguage
     :cognitect.aws.servicecatalog.UpdatePortfolioInput/Description
     :cognitect.aws.servicecatalog.UpdatePortfolioInput/ProviderName
     :cognitect.aws.servicecatalog.UpdatePortfolioInput/AddTags]))

(s/def
  :cognitect.aws.servicecatalog/ShareErrors
  (s/coll-of :cognitect.aws.servicecatalog/ShareError))

(s/def :cognitect.aws.servicecatalog/ChangeAction string?)

(s/def :cognitect.aws.servicecatalog/ResourceDetailDescription string?)

(s/def :cognitect.aws.servicecatalog/Error string?)

(s/def :cognitect.aws.servicecatalog/CreatedTime inst?)

(s/def
  :cognitect.aws.servicecatalog/ProductViewDetails
  (s/coll-of :cognitect.aws.servicecatalog/ProductViewDetail))

(s/def
  :cognitect.aws.servicecatalog/AcceptPortfolioShareInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.AcceptPortfolioShareInput/PortfolioId]
    :opt-un
    [:cognitect.aws.servicecatalog.AcceptPortfolioShareInput/AcceptLanguage
     :cognitect.aws.servicecatalog.AcceptPortfolioShareInput/PortfolioShareType]))

(s/def
  :cognitect.aws.servicecatalog/StackSetRegions
  (s/coll-of :cognitect.aws.servicecatalog/Region))

(s/def
  :cognitect.aws.servicecatalog/AcceptLanguage
  (s/spec
    (s/and string? #(>= 100 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 100) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.servicecatalog/ProvisioningArtifactName string?)

(s/def :cognitect.aws.servicecatalog/UpdatedTime inst?)

(s/def
  :cognitect.aws.servicecatalog/ResourceTargetDefinition
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ResourceTargetDefinition/RequiresRecreation
     :cognitect.aws.servicecatalog.ResourceTargetDefinition/Attribute
     :cognitect.aws.servicecatalog.ResourceTargetDefinition/Name]))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactParameters
  (s/coll-of :cognitect.aws.servicecatalog/ProvisioningArtifactParameter))

(s/def :cognitect.aws.servicecatalog/ErrorDescription string?)

(s/def :cognitect.aws.servicecatalog/RequiresRecreation string?)

(s/def
  :cognitect.aws.servicecatalog/ExecutionParameterMap
  (s/map-of
    :cognitect.aws.servicecatalog/ExecutionParameterKey
    :cognitect.aws.servicecatalog/ExecutionParameterValueList
    :min-count
    1
    :max-count
    200))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Active
     :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Type
     :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Guidance
     :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/CreatedTime
     :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Description
     :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Name
     :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Id]))

(s/def
  :cognitect.aws.servicecatalog/ListPortfolioAccessInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListPortfolioAccessInput/PortfolioId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListPortfolioAccessInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/RecordOutputs
  (s/coll-of :cognitect.aws.servicecatalog/RecordOutput))

(s/def
  :cognitect.aws.servicecatalog/DescribeProvisioningArtifactOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProvisioningArtifactOutput/Info
     :cognitect.aws.servicecatalog.DescribeProvisioningArtifactOutput/ProvisioningArtifactDetail
     :cognitect.aws.servicecatalog.DescribeProvisioningArtifactOutput/Status]))

(s/def
  :cognitect.aws.servicecatalog/BudgetName
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductPlanSummary
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/ProvisionProductId
     :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/PlanType
     :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/PlanName
     :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/ProvisionProductName
     :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/PlanId]))

(s/def
  :cognitect.aws.servicecatalog/RejectPortfolioShareInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.RejectPortfolioShareInput/PortfolioId]
    :opt-un
    [:cognitect.aws.servicecatalog.RejectPortfolioShareInput/AcceptLanguage
     :cognitect.aws.servicecatalog.RejectPortfolioShareInput/PortfolioShareType]))

(s/def
  :cognitect.aws.servicecatalog/ProvisionedProductDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ProvisionedProductDetail/Type
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/StatusMessage
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/Status
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/CreatedTime
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/Arn
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/IdempotencyToken
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/Name
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/ProductId
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/LastRecordId
     :cognitect.aws.servicecatalog.ProvisionedProductDetail/Id]))

(s/def :cognitect.aws.servicecatalog/TagKeys (s/coll-of :cognitect.aws.servicecatalog/TagKey))

(s/def :cognitect.aws.servicecatalog/PropertyName string?)

(s/def
  :cognitect.aws.servicecatalog/SupportEmail
  (s/spec
    (s/and string? #(>= 254 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 254) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifactViews
  (s/coll-of :cognitect.aws.servicecatalog/ProvisioningArtifactView))

(s/def :cognitect.aws.servicecatalog/ProvisionedProductType string?)

(s/def :cognitect.aws.servicecatalog/StackInstanceStatus string?)

(s/def
  :cognitect.aws.servicecatalog/ListLaunchPathsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListLaunchPathsOutput/LaunchPathSummaries
     :cognitect.aws.servicecatalog.ListLaunchPathsOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/ServiceActionDefinitionKey string?)

(s/def
  :cognitect.aws.servicecatalog/CreatePortfolioShareOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.CreatePortfolioShareOutput/PortfolioShareToken]))

(s/def :cognitect.aws.servicecatalog/ResourceDetailName string?)

(s/def
  :cognitect.aws.servicecatalog/DescribeProvisionedProductPlanInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeProvisionedProductPlanInput/PlanId]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProvisionedProductPlanInput/PageSize
     :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanInput/AcceptLanguage
     :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanInput/PageToken]))

(s/def :cognitect.aws.servicecatalog/DisassociateProductFromPortfolioOutput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/TagOptionId
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/GetAWSOrganizationsAccessStatusOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.GetAWSOrganizationsAccessStatusOutput/AccessStatus]))

(s/def :cognitect.aws.servicecatalog/InstructionType string?)

(s/def
  :cognitect.aws.servicecatalog/RecordErrors
  (s/coll-of :cognitect.aws.servicecatalog/RecordError))

(s/def
  :cognitect.aws.servicecatalog/CreateTagOptionInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.CreateTagOptionInput/Key
     :cognitect.aws.servicecatalog.CreateTagOptionInput/Value]))

(s/def
  :cognitect.aws.servicecatalog/ResourceDetail
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ResourceDetail/ARN
     :cognitect.aws.servicecatalog.ResourceDetail/CreatedTime
     :cognitect.aws.servicecatalog.ResourceDetail/Description
     :cognitect.aws.servicecatalog.ResourceDetail/Name
     :cognitect.aws.servicecatalog.ResourceDetail/Id]))

(s/def
  :cognitect.aws.servicecatalog/ExecuteProvisionedProductPlanOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.ExecuteProvisionedProductPlanOutput/RecordDetail]))

(s/def :cognitect.aws.servicecatalog/OutputValue string?)

(s/def
  :cognitect.aws.servicecatalog/TagOptionSummary
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.TagOptionSummary/Key
     :cognitect.aws.servicecatalog.TagOptionSummary/Values]))

(s/def :cognitect.aws.servicecatalog/ProvisionedProductPlanName string?)

(s/def
  :cognitect.aws.servicecatalog/ListRecordHistoryInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ListRecordHistoryInput/PageSize
     :cognitect.aws.servicecatalog.ListRecordHistoryInput/AccessLevelFilter
     :cognitect.aws.servicecatalog.ListRecordHistoryInput/SearchFilter
     :cognitect.aws.servicecatalog.ListRecordHistoryInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListRecordHistoryInput/PageToken]))

(s/def :cognitect.aws.servicecatalog/DisableAWSOrganizationsAccessInput (s/keys))

(s/def
  :cognitect.aws.servicecatalog/DescribeServiceActionOutput
  (s/keys :opt-un [:cognitect.aws.servicecatalog.DescribeServiceActionOutput/ServiceActionDetail]))

(s/def
  :cognitect.aws.servicecatalog/RecordTagValue
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-%@]*)$") %) :gen #(gen/string)))

(s/def :cognitect.aws.servicecatalog/ProductViewAggregationType string?)

(s/def
  :cognitect.aws.servicecatalog/ProvisioningArtifacts
  (s/coll-of :cognitect.aws.servicecatalog/ProvisioningArtifact))

(s/def
  :cognitect.aws.servicecatalog/DescribeCopyProductStatusOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeCopyProductStatusOutput/TargetProductId
     :cognitect.aws.servicecatalog.DescribeCopyProductStatusOutput/StatusDetail
     :cognitect.aws.servicecatalog.DescribeCopyProductStatusOutput/CopyProductStatus]))

(s/def
  :cognitect.aws.servicecatalog/ServiceActionDefinitionValue
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/ListPrincipalsForPortfolioInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListPrincipalsForPortfolioInput/PortfolioId]
    :opt-un
    [:cognitect.aws.servicecatalog.ListPrincipalsForPortfolioInput/PageSize
     :cognitect.aws.servicecatalog.ListPrincipalsForPortfolioInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListPrincipalsForPortfolioInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/UpdateProvisionedProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.UpdateProvisionedProductInput/UpdateToken]
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisionedProductName
     :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/PathId
     :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/Tags
     :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisioningParameters
     :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/AcceptLanguage
     :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisionedProductId
     :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisioningPreferences
     :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProductId]))

(s/def
  :cognitect.aws.servicecatalog/SearchProductsAsAdminInput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.SearchProductsAsAdminInput/ProductSource
     :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/PortfolioId
     :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/SortBy
     :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/PageSize
     :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/SortOrder
     :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/AcceptLanguage
     :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/Filters
     :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/PageToken]))

(s/def :cognitect.aws.servicecatalog/AttributeValue string?)

(s/def
  :cognitect.aws.servicecatalog/CreateProvisionedProductPlanOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/ProvisionedProductName
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/ProvisionProductId
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/PlanName
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/PlanId]))

(s/def
  :cognitect.aws.servicecatalog/DescribeServiceActionInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeServiceActionInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeServiceActionInput/AcceptLanguage]))

(s/def
  :cognitect.aws.servicecatalog/ListOrganizationPortfolioAccessInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/PortfolioId
     :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/OrganizationNodeType]
    :opt-un
    [:cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/PageSize
     :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/AcceptLanguage
     :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/PageToken]))

(s/def
  :cognitect.aws.servicecatalog/CreateConstraintOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.CreateConstraintOutput/ConstraintDetail
     :cognitect.aws.servicecatalog.CreateConstraintOutput/Status
     :cognitect.aws.servicecatalog.CreateConstraintOutput/ConstraintParameters]))

(s/def
  :cognitect.aws.servicecatalog/PropertyValue
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.servicecatalog/DescribeProvisioningArtifactInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DescribeProvisioningArtifactInput/ProvisioningArtifactId
     :cognitect.aws.servicecatalog.DescribeProvisioningArtifactInput/ProductId]
    :opt-un
    [:cognitect.aws.servicecatalog.DescribeProvisioningArtifactInput/AcceptLanguage
     :cognitect.aws.servicecatalog.DescribeProvisioningArtifactInput/Verbose]))

(s/def
  :cognitect.aws.servicecatalog/TagOptionValue
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.servicecatalog/ServiceActionSummaries
  (s/coll-of :cognitect.aws.servicecatalog/ServiceActionSummary))

(s/def
  :cognitect.aws.servicecatalog/DeleteProvisionedProductPlanInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.DeleteProvisionedProductPlanInput/PlanId]
    :opt-un
    [:cognitect.aws.servicecatalog.DeleteProvisionedProductPlanInput/IgnoreErrors
     :cognitect.aws.servicecatalog.DeleteProvisionedProductPlanInput/AcceptLanguage]))

(s/def :cognitect.aws.servicecatalog/Budgets (s/coll-of :cognitect.aws.servicecatalog/BudgetDetail))

(s/def :cognitect.aws.servicecatalog/ProvisionedProductId string?)

(s/def
  :cognitect.aws.servicecatalog/ExecutionParameterValue
  (s/spec
    (s/and string? #(<= 0 (count %) 512))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 512) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.servicecatalog/AccountIds (s/coll-of :cognitect.aws.servicecatalog/AccountId))

(s/def
  :cognitect.aws.servicecatalog/UpdateProductInput
  (s/keys
    :req-un
    [:cognitect.aws.servicecatalog.UpdateProductInput/Id]
    :opt-un
    [:cognitect.aws.servicecatalog.UpdateProductInput/RemoveTags
     :cognitect.aws.servicecatalog.UpdateProductInput/SupportDescription
     :cognitect.aws.servicecatalog.UpdateProductInput/AcceptLanguage
     :cognitect.aws.servicecatalog.UpdateProductInput/Description
     :cognitect.aws.servicecatalog.UpdateProductInput/Owner
     :cognitect.aws.servicecatalog.UpdateProductInput/Distributor
     :cognitect.aws.servicecatalog.UpdateProductInput/AddTags
     :cognitect.aws.servicecatalog.UpdateProductInput/Name
     :cognitect.aws.servicecatalog.UpdateProductInput/SupportUrl
     :cognitect.aws.servicecatalog.UpdateProductInput/SupportEmail]))

(s/def :cognitect.aws.servicecatalog/DisableTemplateValidation boolean?)

(s/def :cognitect.aws.servicecatalog/ResourceAttribute string?)

(s/def
  :cognitect.aws.servicecatalog/ScanProvisionedProductsOutput
  (s/keys
    :opt-un
    [:cognitect.aws.servicecatalog.ScanProvisionedProductsOutput/ProvisionedProducts
     :cognitect.aws.servicecatalog.ScanProvisionedProductsOutput/NextPageToken]))

(s/def :cognitect.aws.servicecatalog/ProductViewDistributor string?)

(s/def
  :cognitect.aws.servicecatalog/ConstraintSummaries
  (s/coll-of :cognitect.aws.servicecatalog/ConstraintSummary))

(s/def :cognitect.aws.servicecatalog/LastRequestId string?)

(s/def :cognitect.aws.servicecatalog/Status string?)

(s/def
  :cognitect.aws.servicecatalog.UpdatePortfolioOutput/PortfolioDetail
  :cognitect.aws.servicecatalog/PortfolioDetail)

(s/def :cognitect.aws.servicecatalog.UpdatePortfolioOutput/Tags :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.ProvisionProductOutput/RecordDetail
  :cognitect.aws.servicecatalog/RecordDetail)

(s/def
  :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisionedProductName
  :cognitect.aws.servicecatalog/ProvisionedProductName)

(s/def :cognitect.aws.servicecatalog.ProvisionProductInput/Tags :cognitect.aws.servicecatalog/Tags)

(s/def :cognitect.aws.servicecatalog.ProvisionProductInput/PathId :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionProductInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionProductInput/NotificationArns
  :cognitect.aws.servicecatalog/NotificationArns)

(s/def
  :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisioningParameters
  :cognitect.aws.servicecatalog/ProvisioningParameters)

(s/def
  :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisioningPreferences
  :cognitect.aws.servicecatalog/ProvisioningPreferences)

(s/def
  :cognitect.aws.servicecatalog.ProvisionProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ProvisionProductInput/ProvisionToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.ResourceChange/Action
  :cognitect.aws.servicecatalog/ChangeAction)

(s/def
  :cognitect.aws.servicecatalog.ResourceChange/LogicalResourceId
  :cognitect.aws.servicecatalog/LogicalResourceId)

(s/def
  :cognitect.aws.servicecatalog.ResourceChange/PhysicalResourceId
  :cognitect.aws.servicecatalog/PhysicalResourceId)

(s/def
  :cognitect.aws.servicecatalog.ResourceChange/ResourceType
  :cognitect.aws.servicecatalog/PlanResourceType)

(s/def
  :cognitect.aws.servicecatalog.ResourceChange/Replacement
  :cognitect.aws.servicecatalog/Replacement)

(s/def :cognitect.aws.servicecatalog.ResourceChange/Scope :cognitect.aws.servicecatalog/Scope)

(s/def
  :cognitect.aws.servicecatalog.ResourceChange/Details
  :cognitect.aws.servicecatalog/ResourceChangeDetails)

(s/def
  :cognitect.aws.servicecatalog.ShareDetails/SuccessfulShares
  :cognitect.aws.servicecatalog/SuccessfulShares)

(s/def
  :cognitect.aws.servicecatalog.ShareDetails/ShareErrors
  :cognitect.aws.servicecatalog/ShareErrors)

(s/def
  :cognitect.aws.servicecatalog.ListResourcesForTagOptionInput/TagOptionId
  :cognitect.aws.servicecatalog/TagOptionId)

(s/def
  :cognitect.aws.servicecatalog.ListResourcesForTagOptionInput/ResourceType
  :cognitect.aws.servicecatalog/ResourceType)

(s/def
  :cognitect.aws.servicecatalog.ListResourcesForTagOptionInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListResourcesForTagOptionInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def :cognitect.aws.servicecatalog.RecordError/Code :cognitect.aws.servicecatalog/ErrorCode)

(s/def
  :cognitect.aws.servicecatalog.RecordError/Description
  :cognitect.aws.servicecatalog/ErrorDescription)

(s/def
  :cognitect.aws.servicecatalog.DescribeTagOptionOutput/TagOptionDetail
  :cognitect.aws.servicecatalog/TagOptionDetail)

(s/def :cognitect.aws.servicecatalog.UpdateServiceActionInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateServiceActionInput/Name
  :cognitect.aws.servicecatalog/ServiceActionName)

(s/def
  :cognitect.aws.servicecatalog.UpdateServiceActionInput/Definition
  :cognitect.aws.servicecatalog/ServiceActionDefinitionMap)

(s/def
  :cognitect.aws.servicecatalog.UpdateServiceActionInput/Description
  :cognitect.aws.servicecatalog/ServiceActionDescription)

(s/def
  :cognitect.aws.servicecatalog.UpdateServiceActionInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.Principal/PrincipalARN
  :cognitect.aws.servicecatalog/PrincipalARN)

(s/def
  :cognitect.aws.servicecatalog.Principal/PrincipalType
  :cognitect.aws.servicecatalog/PrincipalType)

(s/def
  :cognitect.aws.servicecatalog.ListRecordHistoryOutput/RecordDetails
  :cognitect.aws.servicecatalog/RecordDetails)

(s/def
  :cognitect.aws.servicecatalog.ListRecordHistoryOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListRecordHistorySearchFilter/Key
  :cognitect.aws.servicecatalog/SearchFilterKey)

(s/def
  :cognitect.aws.servicecatalog.ListRecordHistorySearchFilter/Value
  :cognitect.aws.servicecatalog/SearchFilterValue)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminOutput/ProductViewDetails
  :cognitect.aws.servicecatalog/ProductViewDetails)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.UpdateServiceActionOutput/ServiceActionDetail
  :cognitect.aws.servicecatalog/ServiceActionDetail)

(s/def
  :cognitect.aws.servicecatalog.ListTagOptionsInput/Filters
  :cognitect.aws.servicecatalog/ListTagOptionsFilters)

(s/def
  :cognitect.aws.servicecatalog.ListTagOptionsInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListTagOptionsInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListBudgetsForResourceOutput/Budgets
  :cognitect.aws.servicecatalog/Budgets)

(s/def
  :cognitect.aws.servicecatalog.ListBudgetsForResourceOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.AssociateBudgetWithResourceInput/BudgetName
  :cognitect.aws.servicecatalog/BudgetName)

(s/def
  :cognitect.aws.servicecatalog.AssociateBudgetWithResourceInput/ResourceId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreateServiceActionInput/Name
  :cognitect.aws.servicecatalog/ServiceActionName)

(s/def
  :cognitect.aws.servicecatalog.CreateServiceActionInput/DefinitionType
  :cognitect.aws.servicecatalog/ServiceActionDefinitionType)

(s/def
  :cognitect.aws.servicecatalog.CreateServiceActionInput/Definition
  :cognitect.aws.servicecatalog/ServiceActionDefinitionMap)

(s/def
  :cognitect.aws.servicecatalog.CreateServiceActionInput/Description
  :cognitect.aws.servicecatalog/ServiceActionDescription)

(s/def
  :cognitect.aws.servicecatalog.CreateServiceActionInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CreateServiceActionInput/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.DeletePortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.DeletePortfolioInput/Id :cognitect.aws.servicecatalog/Id)

(s/def :cognitect.aws.servicecatalog.Tag/Key :cognitect.aws.servicecatalog/TagKey)

(s/def :cognitect.aws.servicecatalog.Tag/Value :cognitect.aws.servicecatalog/TagValue)

(s/def :cognitect.aws.servicecatalog.LaunchPathSummary/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.LaunchPathSummary/ConstraintSummaries
  :cognitect.aws.servicecatalog/ConstraintSummaries)

(s/def :cognitect.aws.servicecatalog.LaunchPathSummary/Tags :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.LaunchPathSummary/Name
  :cognitect.aws.servicecatalog/PortfolioName)

(s/def
  :cognitect.aws.servicecatalog.ServiceActionAssociation/ServiceActionId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ServiceActionAssociation/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ServiceActionAssociation/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DisassociateServiceActionFromProvisioningArtifactInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DisassociateServiceActionFromProvisioningArtifactInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DisassociateServiceActionFromProvisioningArtifactInput/ServiceActionId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DisassociateServiceActionFromProvisioningArtifactInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessOutput/OrganizationNodes
  :cognitect.aws.servicecatalog/OrganizationNodes)

(s/def
  :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def :cognitect.aws.servicecatalog.ProvisioningArtifact/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifact/Name
  :cognitect.aws.servicecatalog/ProvisioningArtifactName)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifact/Description
  :cognitect.aws.servicecatalog/ProvisioningArtifactDescription)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifact/CreatedTime
  :cognitect.aws.servicecatalog/ProvisioningArtifactCreatedTime)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifact/Guidance
  :cognitect.aws.servicecatalog/ProvisioningArtifactGuidance)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisioningArtifactOutput/ProvisioningArtifactDetail
  :cognitect.aws.servicecatalog/ProvisioningArtifactDetail)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisioningArtifactOutput/Info
  :cognitect.aws.servicecatalog/ProvisioningArtifactInfo)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisioningArtifactOutput/Status
  :cognitect.aws.servicecatalog/Status)

(s/def
  :cognitect.aws.servicecatalog.ListConstraintsForPortfolioOutput/ConstraintDetails
  :cognitect.aws.servicecatalog/ConstraintDetails)

(s/def
  :cognitect.aws.servicecatalog.ListConstraintsForPortfolioOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProvisionProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/Tags
  :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/PathId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/NotificationArns
  :cognitect.aws.servicecatalog/NotificationArns)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/PlanType
  :cognitect.aws.servicecatalog/ProvisionedProductPlanType)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProvisionProductName
  :cognitect.aws.servicecatalog/ProvisionedProductName)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/PlanId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/StatusMessage
  :cognitect.aws.servicecatalog/StatusMessage)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/ProvisioningParameters
  :cognitect.aws.servicecatalog/UpdateProvisioningParameters)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/CreatedTime
  :cognitect.aws.servicecatalog/CreatedTime)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/UpdatedTime
  :cognitect.aws.servicecatalog/UpdatedTime)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/PlanName
  :cognitect.aws.servicecatalog/ProvisionedProductPlanName)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanDetails/Status
  :cognitect.aws.servicecatalog/ProvisionedProductPlanStatus)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/ProductType
  :cognitect.aws.servicecatalog/ProductType)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/SupportUrl
  :cognitect.aws.servicecatalog/SupportUrl)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/Owner
  :cognitect.aws.servicecatalog/ProductViewOwner)

(s/def :cognitect.aws.servicecatalog.CreateProductInput/Tags :cognitect.aws.servicecatalog/AddTags)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/Distributor
  :cognitect.aws.servicecatalog/ProductViewOwner)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/SupportDescription
  :cognitect.aws.servicecatalog/SupportDescription)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/Name
  :cognitect.aws.servicecatalog/ProductViewName)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/Description
  :cognitect.aws.servicecatalog/ProductViewShortDescription)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/ProvisioningArtifactParameters
  :cognitect.aws.servicecatalog/ProvisioningArtifactProperties)

(s/def
  :cognitect.aws.servicecatalog.CreateProductInput/SupportEmail
  :cognitect.aws.servicecatalog/SupportEmail)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Id
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Tags
  :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/PhysicalId
  :cognitect.aws.servicecatalog/PhysicalId)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/UserArnSession
  :cognitect.aws.servicecatalog/UserArnSession)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/UserArn
  :cognitect.aws.servicecatalog/UserArn)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Arn
  :cognitect.aws.servicecatalog/ProvisionedProductNameOrArn)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Name
  :cognitect.aws.servicecatalog/ProvisionedProductNameOrArn)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/StatusMessage
  :cognitect.aws.servicecatalog/ProvisionedProductStatusMessage)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Type
  :cognitect.aws.servicecatalog/ProvisionedProductType)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/CreatedTime
  :cognitect.aws.servicecatalog/CreatedTime)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/LastRecordId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductAttribute/Status
  :cognitect.aws.servicecatalog/ProvisionedProductStatus)

(s/def
  :cognitect.aws.servicecatalog.ListResourcesForTagOptionOutput/ResourceDetails
  :cognitect.aws.servicecatalog/ResourceDetails)

(s/def
  :cognitect.aws.servicecatalog.ListResourcesForTagOptionOutput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductOutput/RecordDetail
  :cognitect.aws.servicecatalog/RecordDetail)

(s/def
  :cognitect.aws.servicecatalog.BudgetDetail/BudgetName
  :cognitect.aws.servicecatalog/BudgetName)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosForProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosForProductInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosForProductInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosForProductInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesInput/PortfolioShareType
  :cognitect.aws.servicecatalog/PortfolioShareType)

(s/def
  :cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductOutput/StackInstances
  :cognitect.aws.servicecatalog/StackInstances)

(s/def
  :cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.CloudWatchDashboard/Name
  :cognitect.aws.servicecatalog/CloudWatchDashboardName)

(s/def
  :cognitect.aws.servicecatalog.ResourceChangeDetail/Target
  :cognitect.aws.servicecatalog/ResourceTargetDefinition)

(s/def
  :cognitect.aws.servicecatalog.ResourceChangeDetail/Evaluation
  :cognitect.aws.servicecatalog/EvaluationType)

(s/def
  :cognitect.aws.servicecatalog.ResourceChangeDetail/CausingEntity
  :cognitect.aws.servicecatalog/CausingEntity)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningParameter/Key
  :cognitect.aws.servicecatalog/ParameterKey)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningParameter/Value
  :cognitect.aws.servicecatalog/ParameterValue)

(s/def
  :cognitect.aws.servicecatalog.AssociateProductWithPortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.AssociateProductWithPortfolioInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.AssociateProductWithPortfolioInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.AssociateProductWithPortfolioInput/SourcePortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactSummary/Id
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactSummary/Name
  :cognitect.aws.servicecatalog/ProvisioningArtifactName)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactSummary/Description
  :cognitect.aws.servicecatalog/ProvisioningArtifactDescription)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactSummary/CreatedTime
  :cognitect.aws.servicecatalog/ProvisioningArtifactCreatedTime)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactSummary/ProvisioningArtifactMetadata
  :cognitect.aws.servicecatalog/ProvisioningArtifactInfo)

(s/def
  :cognitect.aws.servicecatalog.BatchDisassociateServiceActionFromProvisioningArtifactInput/ServiceActionAssociations
  :cognitect.aws.servicecatalog/ServiceActionAssociations)

(s/def
  :cognitect.aws.servicecatalog.BatchDisassociateServiceActionFromProvisioningArtifactInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.TerminateProvisionedProductInput/ProvisionedProductName
  :cognitect.aws.servicecatalog/ProvisionedProductNameOrArn)

(s/def
  :cognitect.aws.servicecatalog.TerminateProvisionedProductInput/ProvisionedProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.TerminateProvisionedProductInput/TerminateToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.TerminateProvisionedProductInput/IgnoreErrors
  :cognitect.aws.servicecatalog/IgnoreErrors)

(s/def
  :cognitect.aws.servicecatalog.TerminateProvisionedProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningParametersInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningParametersInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningParametersInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningParametersInput/PathId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningParameter/Key
  :cognitect.aws.servicecatalog/ParameterKey)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningParameter/Value
  :cognitect.aws.servicecatalog/ParameterValue)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningParameter/UsePreviousValue
  :cognitect.aws.servicecatalog/UsePreviousValue)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisioningArtifactInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisioningArtifactInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisioningArtifactInput/Parameters
  :cognitect.aws.servicecatalog/ProvisioningArtifactProperties)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisioningArtifactInput/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.RecordDetail/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.RecordDetail/ProvisionedProductName
  :cognitect.aws.servicecatalog/ProvisionedProductName)

(s/def :cognitect.aws.servicecatalog.RecordDetail/RecordId :cognitect.aws.servicecatalog/Id)

(s/def :cognitect.aws.servicecatalog.RecordDetail/PathId :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.RecordDetail/RecordType
  :cognitect.aws.servicecatalog/RecordType)

(s/def :cognitect.aws.servicecatalog.RecordDetail/ProductId :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.RecordDetail/RecordTags
  :cognitect.aws.servicecatalog/RecordTags)

(s/def
  :cognitect.aws.servicecatalog.RecordDetail/CreatedTime
  :cognitect.aws.servicecatalog/CreatedTime)

(s/def
  :cognitect.aws.servicecatalog.RecordDetail/UpdatedTime
  :cognitect.aws.servicecatalog/UpdatedTime)

(s/def
  :cognitect.aws.servicecatalog.RecordDetail/ProvisionedProductType
  :cognitect.aws.servicecatalog/ProvisionedProductType)

(s/def
  :cognitect.aws.servicecatalog.RecordDetail/RecordErrors
  :cognitect.aws.servicecatalog/RecordErrors)

(s/def
  :cognitect.aws.servicecatalog.RecordDetail/ProvisionedProductId
  :cognitect.aws.servicecatalog/Id)

(s/def :cognitect.aws.servicecatalog.RecordDetail/Status :cognitect.aws.servicecatalog/RecordStatus)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactOutput/ProvisioningArtifactDetail
  :cognitect.aws.servicecatalog/ProvisioningArtifactDetail)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactOutput/Info
  :cognitect.aws.servicecatalog/ProvisioningArtifactInfo)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactOutput/Status
  :cognitect.aws.servicecatalog/Status)

(s/def
  :cognitect.aws.servicecatalog.BatchAssociateServiceActionWithProvisioningArtifactOutput/FailedServiceActionAssociations
  :cognitect.aws.servicecatalog/FailedServiceActionAssociations)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/ProvisioningArtifactParameters
  :cognitect.aws.servicecatalog/ProvisioningArtifactParameters)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/ConstraintSummaries
  :cognitect.aws.servicecatalog/ConstraintSummaries)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/UsageInstructions
  :cognitect.aws.servicecatalog/UsageInstructions)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/TagOptions
  :cognitect.aws.servicecatalog/TagOptionSummaries)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningParametersOutput/ProvisioningArtifactPreferences
  :cognitect.aws.servicecatalog/ProvisioningArtifactPreferences)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductViewOutput/ProductViewSummary
  :cognitect.aws.servicecatalog/ProductViewSummary)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductViewOutput/ProvisioningArtifacts
  :cognitect.aws.servicecatalog/ProvisioningArtifacts)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductAsAdminInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductAsAdminInput/Id
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListLaunchPathsInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListLaunchPathsInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListLaunchPathsInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListLaunchPathsInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetAccounts
  :cognitect.aws.servicecatalog/StackSetAccounts)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetRegions
  :cognitect.aws.servicecatalog/StackSetRegions)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetFailureToleranceCount
  :cognitect.aws.servicecatalog/StackSetFailureToleranceCount)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetFailureTolerancePercentage
  :cognitect.aws.servicecatalog/StackSetFailureTolerancePercentage)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetMaxConcurrencyCount
  :cognitect.aws.servicecatalog/StackSetMaxConcurrencyCount)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetMaxConcurrencyPercentage
  :cognitect.aws.servicecatalog/StackSetMaxConcurrencyPercentage)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningPreferences/StackSetOperationType
  :cognitect.aws.servicecatalog/StackSetOperationType)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactPreferences/StackSetAccounts
  :cognitect.aws.servicecatalog/StackSetAccounts)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactPreferences/StackSetRegions
  :cognitect.aws.servicecatalog/StackSetRegions)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsInput/Filters
  :cognitect.aws.servicecatalog/ProductViewFilters)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsInput/SortBy
  :cognitect.aws.servicecatalog/ProductViewSortBy)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsInput/SortOrder
  :cognitect.aws.servicecatalog/SortOrder)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.UsageInstruction/Type
  :cognitect.aws.servicecatalog/InstructionType)

(s/def
  :cognitect.aws.servicecatalog.UsageInstruction/Value
  :cognitect.aws.servicecatalog/InstructionValue)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactOutput/ServiceActionSummaries
  :cognitect.aws.servicecatalog/ServiceActionSummaries)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/ProvisionProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListProvisionedProductPlansInput/AccessLevelFilter
  :cognitect.aws.servicecatalog/AccessLevelFilter)

(s/def
  :cognitect.aws.servicecatalog.DescribeRecordInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.DescribeRecordInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeRecordInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DescribeRecordInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListProvisionedProductPlansOutput/ProvisionedProductPlans
  :cognitect.aws.servicecatalog/ProvisionedProductPlans)

(s/def
  :cognitect.aws.servicecatalog.ListProvisionedProductPlansOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def :cognitect.aws.servicecatalog.DeleteServiceActionInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DeleteServiceActionInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DescribeTagOptionInput/Id
  :cognitect.aws.servicecatalog/TagOptionId)

(s/def
  :cognitect.aws.servicecatalog.CopyProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CopyProductInput/SourceProductArn
  :cognitect.aws.servicecatalog/ProductArn)

(s/def
  :cognitect.aws.servicecatalog.CopyProductInput/TargetProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CopyProductInput/TargetProductName
  :cognitect.aws.servicecatalog/ProductViewName)

(s/def
  :cognitect.aws.servicecatalog.CopyProductInput/SourceProvisioningArtifactIdentifiers
  :cognitect.aws.servicecatalog/SourceProvisioningArtifactProperties)

(s/def
  :cognitect.aws.servicecatalog.CopyProductInput/CopyOptions
  :cognitect.aws.servicecatalog/CopyOptions)

(s/def
  :cognitect.aws.servicecatalog.CopyProductInput/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionOutput/ProvisioningArtifactViews
  :cognitect.aws.servicecatalog/ProvisioningArtifactViews)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.AssociateServiceActionWithProvisioningArtifactInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.AssociateServiceActionWithProvisioningArtifactInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.AssociateServiceActionWithProvisioningArtifactInput/ServiceActionId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.AssociateServiceActionWithProvisioningArtifactInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsForProvisioningArtifactInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CreateServiceActionOutput/ServiceActionDetail
  :cognitect.aws.servicecatalog/ServiceActionDetail)

(s/def
  :cognitect.aws.servicecatalog.DeleteProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.DeleteProductInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.AssociateTagOptionWithResourceInput/ResourceId
  :cognitect.aws.servicecatalog/ResourceId)

(s/def
  :cognitect.aws.servicecatalog.AssociateTagOptionWithResourceInput/TagOptionId
  :cognitect.aws.servicecatalog/TagOptionId)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductViewInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.DescribeProductViewInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ParameterConstraints/AllowedValues
  :cognitect.aws.servicecatalog/AllowedValues)

(s/def :cognitect.aws.servicecatalog.ShareError/Accounts :cognitect.aws.servicecatalog/Namespaces)

(s/def :cognitect.aws.servicecatalog.ShareError/Message :cognitect.aws.servicecatalog/Message)

(s/def :cognitect.aws.servicecatalog.ShareError/Error :cognitect.aws.servicecatalog/Error)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/PortfolioShareToken
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/OrganizationNodeValue
  :cognitect.aws.servicecatalog/OrganizationNodeValue)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/Status
  :cognitect.aws.servicecatalog/ShareStatus)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioShareStatusOutput/ShareDetails
  :cognitect.aws.servicecatalog/ShareDetails)

(s/def
  :cognitect.aws.servicecatalog.AssociatePrincipalWithPortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.AssociatePrincipalWithPortfolioInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.AssociatePrincipalWithPortfolioInput/PrincipalARN
  :cognitect.aws.servicecatalog/PrincipalARN)

(s/def
  :cognitect.aws.servicecatalog.AssociatePrincipalWithPortfolioInput/PrincipalType
  :cognitect.aws.servicecatalog/PrincipalType)

(s/def
  :cognitect.aws.servicecatalog.ProductViewSummary/HasDefaultPath
  :cognitect.aws.servicecatalog/HasDefaultPath)

(s/def
  :cognitect.aws.servicecatalog.ProductViewSummary/SupportUrl
  :cognitect.aws.servicecatalog/SupportUrl)

(s/def :cognitect.aws.servicecatalog.ProductViewSummary/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProductViewSummary/Owner
  :cognitect.aws.servicecatalog/ProductViewOwner)

(s/def :cognitect.aws.servicecatalog.ProductViewSummary/ProductId :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProductViewSummary/Distributor
  :cognitect.aws.servicecatalog/ProductViewDistributor)

(s/def
  :cognitect.aws.servicecatalog.ProductViewSummary/SupportDescription
  :cognitect.aws.servicecatalog/SupportDescription)

(s/def
  :cognitect.aws.servicecatalog.ProductViewSummary/Name
  :cognitect.aws.servicecatalog/ProductViewName)

(s/def
  :cognitect.aws.servicecatalog.ProductViewSummary/ShortDescription
  :cognitect.aws.servicecatalog/ProductViewShortDescription)

(s/def
  :cognitect.aws.servicecatalog.ProductViewSummary/Type
  :cognitect.aws.servicecatalog/ProductType)

(s/def
  :cognitect.aws.servicecatalog.ProductViewSummary/SupportEmail
  :cognitect.aws.servicecatalog/SupportEmail)

(s/def
  :cognitect.aws.servicecatalog.UpdateTagOptionOutput/TagOptionDetail
  :cognitect.aws.servicecatalog/TagOptionDetail)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/Name
  :cognitect.aws.servicecatalog/ProvisioningArtifactName)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/Description
  :cognitect.aws.servicecatalog/ProvisioningArtifactDescription)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/Active
  :cognitect.aws.servicecatalog/ProvisioningArtifactActive)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisioningArtifactInput/Guidance
  :cognitect.aws.servicecatalog/ProvisioningArtifactGuidance)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosOutput/PortfolioDetails
  :cognitect.aws.servicecatalog/PortfolioDetails)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/ProvisionedProductName
  :cognitect.aws.servicecatalog/ProvisionedProductName)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/Tags
  :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/PathId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/NotificationArns
  :cognitect.aws.servicecatalog/NotificationArns)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/PlanType
  :cognitect.aws.servicecatalog/ProvisionedProductPlanType)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/ProvisioningParameters
  :cognitect.aws.servicecatalog/UpdateProvisioningParameters)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanInput/PlanName
  :cognitect.aws.servicecatalog/ProvisionedProductPlanName)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioOutput/PortfolioDetail
  :cognitect.aws.servicecatalog/PortfolioDetail)

(s/def :cognitect.aws.servicecatalog.CreatePortfolioOutput/Tags :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.DescribeConstraintOutput/ConstraintDetail
  :cognitect.aws.servicecatalog/ConstraintDetail)

(s/def
  :cognitect.aws.servicecatalog.DescribeConstraintOutput/ConstraintParameters
  :cognitect.aws.servicecatalog/ConstraintParameters)

(s/def
  :cognitect.aws.servicecatalog.DescribeConstraintOutput/Status
  :cognitect.aws.servicecatalog/Status)

(s/def :cognitect.aws.servicecatalog.ServiceActionSummary/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ServiceActionSummary/Name
  :cognitect.aws.servicecatalog/ServiceActionName)

(s/def
  :cognitect.aws.servicecatalog.ServiceActionSummary/Description
  :cognitect.aws.servicecatalog/ServiceActionDescription)

(s/def
  :cognitect.aws.servicecatalog.ServiceActionSummary/DefinitionType
  :cognitect.aws.servicecatalog/ServiceActionDefinitionType)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioShareInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioShareInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioShareInput/AccountId
  :cognitect.aws.servicecatalog/AccountId)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioShareInput/OrganizationNode
  :cognitect.aws.servicecatalog/OrganizationNode)

(s/def
  :cognitect.aws.servicecatalog.ListTagOptionsOutput/TagOptionDetails
  :cognitect.aws.servicecatalog/TagOptionDetails)

(s/def
  :cognitect.aws.servicecatalog.ListTagOptionsOutput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.UpdateConstraintInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.UpdateConstraintInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateConstraintInput/Description
  :cognitect.aws.servicecatalog/ConstraintDescription)

(s/def
  :cognitect.aws.servicecatalog.UpdateConstraintInput/Parameters
  :cognitect.aws.servicecatalog/ConstraintParameters)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsOutput/ProvisionedProducts
  :cognitect.aws.servicecatalog/ProvisionedProductAttributes)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsOutput/TotalResultsCount
  :cognitect.aws.servicecatalog/TotalResultsCount)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioShareStatusInput/PortfolioShareToken
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesOutput/PortfolioDetails
  :cognitect.aws.servicecatalog/PortfolioDetails)

(s/def
  :cognitect.aws.servicecatalog.ListAcceptedPortfolioSharesOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.CreateProductOutput/ProductViewDetail
  :cognitect.aws.servicecatalog/ProductViewDetail)

(s/def
  :cognitect.aws.servicecatalog.CreateProductOutput/ProvisioningArtifactDetail
  :cognitect.aws.servicecatalog/ProvisioningArtifactDetail)

(s/def :cognitect.aws.servicecatalog.CreateProductOutput/Tags :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductOutput/ProductViewSummary
  :cognitect.aws.servicecatalog/ProductViewSummary)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductOutput/ProvisioningArtifacts
  :cognitect.aws.servicecatalog/ProvisioningArtifacts)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductOutput/Budgets
  :cognitect.aws.servicecatalog/Budgets)

(s/def
  :cognitect.aws.servicecatalog.ProductViewDetail/ProductViewSummary
  :cognitect.aws.servicecatalog/ProductViewSummary)

(s/def :cognitect.aws.servicecatalog.ProductViewDetail/Status :cognitect.aws.servicecatalog/Status)

(s/def
  :cognitect.aws.servicecatalog.ProductViewDetail/ProductARN
  :cognitect.aws.servicecatalog/ResourceARN)

(s/def
  :cognitect.aws.servicecatalog.ProductViewDetail/CreatedTime
  :cognitect.aws.servicecatalog/CreatedTime)

(s/def
  :cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListConstraintsForPortfolioInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DeleteProvisioningArtifactInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DeleteProvisioningArtifactInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DeleteProvisioningArtifactInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListTagOptionsFilters/Key
  :cognitect.aws.servicecatalog/TagOptionKey)

(s/def
  :cognitect.aws.servicecatalog.ListTagOptionsFilters/Value
  :cognitect.aws.servicecatalog/TagOptionValue)

(s/def
  :cognitect.aws.servicecatalog.ListTagOptionsFilters/Active
  :cognitect.aws.servicecatalog/TagOptionActive)

(s/def
  :cognitect.aws.servicecatalog.DisassociatePrincipalFromPortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DisassociatePrincipalFromPortfolioInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DisassociatePrincipalFromPortfolioInput/PrincipalARN
  :cognitect.aws.servicecatalog/PrincipalARN)

(s/def
  :cognitect.aws.servicecatalog.FailedServiceActionAssociation/ServiceActionId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.FailedServiceActionAssociation/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.FailedServiceActionAssociation/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.FailedServiceActionAssociation/ErrorCode
  :cognitect.aws.servicecatalog/ServiceActionAssociationErrorCode)

(s/def
  :cognitect.aws.servicecatalog.FailedServiceActionAssociation/ErrorMessage
  :cognitect.aws.servicecatalog/ServiceActionAssociationErrorMessage)

(s/def
  :cognitect.aws.servicecatalog.BatchDisassociateServiceActionFromProvisioningArtifactOutput/FailedServiceActionAssociations
  :cognitect.aws.servicecatalog/FailedServiceActionAssociations)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/ProductViewDetail
  :cognitect.aws.servicecatalog/ProductViewDetail)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/ProvisioningArtifactSummaries
  :cognitect.aws.servicecatalog/ProvisioningArtifactSummaries)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/Tags
  :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/TagOptions
  :cognitect.aws.servicecatalog/TagOptionDetails)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductAsAdminOutput/Budgets
  :cognitect.aws.servicecatalog/Budgets)

(s/def
  :cognitect.aws.servicecatalog.ExecutionParameter/Name
  :cognitect.aws.servicecatalog/ExecutionParameterKey)

(s/def
  :cognitect.aws.servicecatalog.ExecutionParameter/Type
  :cognitect.aws.servicecatalog/ExecutionParameterType)

(s/def
  :cognitect.aws.servicecatalog.ExecutionParameter/DefaultValues
  :cognitect.aws.servicecatalog/ExecutionParameterValueList)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesInput/ProvisionedProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesInput/ProvisionedProductProperties
  :cognitect.aws.servicecatalog/ProvisionedProductProperties)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesInput/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.ConstraintSummary/Type
  :cognitect.aws.servicecatalog/ConstraintType)

(s/def
  :cognitect.aws.servicecatalog.ConstraintSummary/Description
  :cognitect.aws.servicecatalog/ConstraintDescription)

(s/def
  :cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductInput/ProvisionedProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListStackInstancesForProvisionedProductInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/AccessLevelFilter
  :cognitect.aws.servicecatalog/AccessLevelFilter)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/Filters
  :cognitect.aws.servicecatalog/ProvisionedProductFilters)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/SortBy
  :cognitect.aws.servicecatalog/SortField)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/SortOrder
  :cognitect.aws.servicecatalog/SortOrder)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/PageSize
  :cognitect.aws.servicecatalog/SearchProvisionedProductsPageSize)

(s/def
  :cognitect.aws.servicecatalog.SearchProvisionedProductsInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductInput/Id
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.OrganizationNode/Type
  :cognitect.aws.servicecatalog/OrganizationNodeType)

(s/def
  :cognitect.aws.servicecatalog.OrganizationNode/Value
  :cognitect.aws.servicecatalog/OrganizationNodeValue)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductPlanInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductPlanInput/PlanId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductPlanInput/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.DeletePortfolioShareInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DeletePortfolioShareInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DeletePortfolioShareInput/AccountId
  :cognitect.aws.servicecatalog/AccountId)

(s/def
  :cognitect.aws.servicecatalog.DeletePortfolioShareInput/OrganizationNode
  :cognitect.aws.servicecatalog/OrganizationNode)

(s/def :cognitect.aws.servicecatalog.PortfolioDetail/Id :cognitect.aws.servicecatalog/Id)

(s/def :cognitect.aws.servicecatalog.PortfolioDetail/ARN :cognitect.aws.servicecatalog/ResourceARN)

(s/def
  :cognitect.aws.servicecatalog.PortfolioDetail/DisplayName
  :cognitect.aws.servicecatalog/PortfolioDisplayName)

(s/def
  :cognitect.aws.servicecatalog.PortfolioDetail/Description
  :cognitect.aws.servicecatalog/PortfolioDescription)

(s/def
  :cognitect.aws.servicecatalog.PortfolioDetail/CreatedTime
  :cognitect.aws.servicecatalog/CreationTime)

(s/def
  :cognitect.aws.servicecatalog.PortfolioDetail/ProviderName
  :cognitect.aws.servicecatalog/ProviderName)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesOutput/ProvisionedProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesOutput/ProvisionedProductProperties
  :cognitect.aws.servicecatalog/ProvisionedProductProperties)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesOutput/RecordId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductPropertiesOutput/Status
  :cognitect.aws.servicecatalog/RecordStatus)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanOutput/ProvisionedProductPlanDetails
  :cognitect.aws.servicecatalog/ProvisionedProductPlanDetails)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanOutput/ResourceChanges
  :cognitect.aws.servicecatalog/ResourceChanges)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.UpdateConstraintOutput/ConstraintDetail
  :cognitect.aws.servicecatalog/ConstraintDetail)

(s/def
  :cognitect.aws.servicecatalog.UpdateConstraintOutput/ConstraintParameters
  :cognitect.aws.servicecatalog/ConstraintParameters)

(s/def
  :cognitect.aws.servicecatalog.UpdateConstraintOutput/Status
  :cognitect.aws.servicecatalog/Status)

(s/def
  :cognitect.aws.servicecatalog.UpdateTagOptionInput/Id
  :cognitect.aws.servicecatalog/TagOptionId)

(s/def
  :cognitect.aws.servicecatalog.UpdateTagOptionInput/Value
  :cognitect.aws.servicecatalog/TagOptionValue)

(s/def
  :cognitect.aws.servicecatalog.UpdateTagOptionInput/Active
  :cognitect.aws.servicecatalog/TagOptionActive)

(s/def :cognitect.aws.servicecatalog.RecordOutput/OutputKey :cognitect.aws.servicecatalog/OutputKey)

(s/def
  :cognitect.aws.servicecatalog.RecordOutput/OutputValue
  :cognitect.aws.servicecatalog/OutputValue)

(s/def
  :cognitect.aws.servicecatalog.RecordOutput/Description
  :cognitect.aws.servicecatalog/Description)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/ParameterKey
  :cognitect.aws.servicecatalog/ParameterKey)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/DefaultValue
  :cognitect.aws.servicecatalog/DefaultValue)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/ParameterType
  :cognitect.aws.servicecatalog/ParameterType)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/IsNoEcho
  :cognitect.aws.servicecatalog/NoEcho)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/Description
  :cognitect.aws.servicecatalog/Description)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactParameter/ParameterConstraints
  :cognitect.aws.servicecatalog/ParameterConstraints)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioOutput/PortfolioDetail
  :cognitect.aws.servicecatalog/PortfolioDetail)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioOutput/Tags
  :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioOutput/TagOptions
  :cognitect.aws.servicecatalog/TagOptionDetails)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioOutput/Budgets
  :cognitect.aws.servicecatalog/Budgets)

(s/def
  :cognitect.aws.servicecatalog.DescribeServiceActionExecutionParametersOutput/ServiceActionParameters
  :cognitect.aws.servicecatalog/ExecutionParameters)

(s/def
  :cognitect.aws.servicecatalog.TerminateProvisionedProductOutput/RecordDetail
  :cognitect.aws.servicecatalog/RecordDetail)

(s/def
  :cognitect.aws.servicecatalog.ListPrincipalsForPortfolioOutput/Principals
  :cognitect.aws.servicecatalog/Principals)

(s/def
  :cognitect.aws.servicecatalog.ListPrincipalsForPortfolioOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DeleteTagOptionInput/Id
  :cognitect.aws.servicecatalog/TagOptionId)

(s/def
  :cognitect.aws.servicecatalog.DescribeCopyProductStatusInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DescribeCopyProductStatusInput/CopyProductToken
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactView/ProductViewSummary
  :cognitect.aws.servicecatalog/ProductViewSummary)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactView/ProvisioningArtifact
  :cognitect.aws.servicecatalog/ProvisioningArtifact)

(s/def
  :cognitect.aws.servicecatalog.AccessLevelFilter/Key
  :cognitect.aws.servicecatalog/AccessLevelFilterKey)

(s/def
  :cognitect.aws.servicecatalog.AccessLevelFilter/Value
  :cognitect.aws.servicecatalog/AccessLevelFilterValue)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosForProductOutput/PortfolioDetails
  :cognitect.aws.servicecatalog/PortfolioDetails)

(s/def
  :cognitect.aws.servicecatalog.ListPortfoliosForProductOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def :cognitect.aws.servicecatalog.ConstraintDetail/ConstraintId :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ConstraintDetail/Type
  :cognitect.aws.servicecatalog/ConstraintType)

(s/def
  :cognitect.aws.servicecatalog.ConstraintDetail/Description
  :cognitect.aws.servicecatalog/ConstraintDescription)

(s/def :cognitect.aws.servicecatalog.ConstraintDetail/Owner :cognitect.aws.servicecatalog/AccountId)

(s/def
  :cognitect.aws.servicecatalog.DisassociateProductFromPortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DisassociateProductFromPortfolioInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DisassociateProductFromPortfolioInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListPortfolioAccessOutput/AccountIds
  :cognitect.aws.servicecatalog/AccountIds)

(s/def
  :cognitect.aws.servicecatalog.ListPortfolioAccessOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListBudgetsForResourceInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListBudgetsForResourceInput/ResourceId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListBudgetsForResourceInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListBudgetsForResourceInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DescribeServiceActionExecutionParametersInput/ProvisionedProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeServiceActionExecutionParametersInput/ServiceActionId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeServiceActionExecutionParametersInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsOutput/ServiceActionSummaries
  :cognitect.aws.servicecatalog/ServiceActionSummaries)

(s/def
  :cognitect.aws.servicecatalog.ListServiceActionsOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DescribeConstraintInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.DescribeConstraintInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionInput/ServiceActionId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsForServiceActionInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductOutput/ProvisionedProductDetail
  :cognitect.aws.servicecatalog/ProvisionedProductDetail)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductOutput/CloudWatchDashboards
  :cognitect.aws.servicecatalog/CloudWatchDashboards)

(s/def
  :cognitect.aws.servicecatalog.DescribeRecordOutput/RecordDetail
  :cognitect.aws.servicecatalog/RecordDetail)

(s/def
  :cognitect.aws.servicecatalog.DescribeRecordOutput/RecordOutputs
  :cognitect.aws.servicecatalog/RecordOutputs)

(s/def
  :cognitect.aws.servicecatalog.DescribeRecordOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintInput/Parameters
  :cognitect.aws.servicecatalog/ConstraintParameters)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintInput/Type
  :cognitect.aws.servicecatalog/ConstraintType)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintInput/Description
  :cognitect.aws.servicecatalog/ConstraintDescription)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintInput/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.ServiceActionDetail/ServiceActionSummary
  :cognitect.aws.servicecatalog/ServiceActionSummary)

(s/def
  :cognitect.aws.servicecatalog.ServiceActionDetail/Definition
  :cognitect.aws.servicecatalog/ServiceActionDefinitionMap)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsOutput/ProvisioningArtifactDetails
  :cognitect.aws.servicecatalog/ProvisioningArtifactDetails)

(s/def
  :cognitect.aws.servicecatalog.ListProvisioningArtifactsOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.CreateTagOptionOutput/TagOptionDetail
  :cognitect.aws.servicecatalog/TagOptionDetail)

(s/def
  :cognitect.aws.servicecatalog.DeleteConstraintInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.DeleteConstraintInput/Id :cognitect.aws.servicecatalog/Id)

(s/def :cognitect.aws.servicecatalog.StackInstance/Account :cognitect.aws.servicecatalog/AccountId)

(s/def :cognitect.aws.servicecatalog.StackInstance/Region :cognitect.aws.servicecatalog/Region)

(s/def
  :cognitect.aws.servicecatalog.StackInstance/StackInstanceStatus
  :cognitect.aws.servicecatalog/StackInstanceStatus)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductOutput/ProductViewDetail
  :cognitect.aws.servicecatalog/ProductViewDetail)

(s/def :cognitect.aws.servicecatalog.UpdateProductOutput/Tags :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionOutput/RecordDetail
  :cognitect.aws.servicecatalog/RecordDetail)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsOutput/ProductViewSummaries
  :cognitect.aws.servicecatalog/ProductViewSummaries)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsOutput/ProductViewAggregations
  :cognitect.aws.servicecatalog/ProductViewAggregations)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DescribeProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.DescribeProductInput/Id :cognitect.aws.servicecatalog/Id)

(s/def :cognitect.aws.servicecatalog.TagOptionDetail/Key :cognitect.aws.servicecatalog/TagOptionKey)

(s/def
  :cognitect.aws.servicecatalog.TagOptionDetail/Value
  :cognitect.aws.servicecatalog/TagOptionValue)

(s/def
  :cognitect.aws.servicecatalog.TagOptionDetail/Active
  :cognitect.aws.servicecatalog/TagOptionActive)

(s/def :cognitect.aws.servicecatalog.TagOptionDetail/Id :cognitect.aws.servicecatalog/TagOptionId)

(s/def
  :cognitect.aws.servicecatalog.DescribePortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.DescribePortfolioInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/ProvisionedProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/ServiceActionId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/ExecuteToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductServiceActionInput/Parameters
  :cognitect.aws.servicecatalog/ExecutionParameterMap)

(s/def
  :cognitect.aws.servicecatalog.ScanProvisionedProductsInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ScanProvisionedProductsInput/AccessLevelFilter
  :cognitect.aws.servicecatalog/AccessLevelFilter)

(s/def
  :cognitect.aws.servicecatalog.ScanProvisionedProductsInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ScanProvisionedProductsInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DeletePortfolioShareOutput/PortfolioShareToken
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactProperties/Name
  :cognitect.aws.servicecatalog/ProvisioningArtifactName)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactProperties/Description
  :cognitect.aws.servicecatalog/ProvisioningArtifactDescription)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactProperties/Info
  :cognitect.aws.servicecatalog/ProvisioningArtifactInfo)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactProperties/Type
  :cognitect.aws.servicecatalog/ProvisioningArtifactType)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactProperties/DisableTemplateValidation
  :cognitect.aws.servicecatalog/DisableTemplateValidation)

(s/def
  :cognitect.aws.servicecatalog.BatchAssociateServiceActionWithProvisioningArtifactInput/ServiceActionAssociations
  :cognitect.aws.servicecatalog/ServiceActionAssociations)

(s/def
  :cognitect.aws.servicecatalog.BatchAssociateServiceActionWithProvisioningArtifactInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioInput/DisplayName
  :cognitect.aws.servicecatalog/PortfolioDisplayName)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioInput/Description
  :cognitect.aws.servicecatalog/PortfolioDescription)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioInput/ProviderName
  :cognitect.aws.servicecatalog/ProviderName)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioInput/Tags
  :cognitect.aws.servicecatalog/AddTags)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioInput/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.CopyProductOutput/CopyProductToken
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DisassociateTagOptionFromResourceInput/ResourceId
  :cognitect.aws.servicecatalog/ResourceId)

(s/def
  :cognitect.aws.servicecatalog.DisassociateTagOptionFromResourceInput/TagOptionId
  :cognitect.aws.servicecatalog/TagOptionId)

(s/def :cognitect.aws.servicecatalog.RecordTag/Key :cognitect.aws.servicecatalog/RecordTagKey)

(s/def :cognitect.aws.servicecatalog.RecordTag/Value :cognitect.aws.servicecatalog/RecordTagValue)

(s/def
  :cognitect.aws.servicecatalog.DisassociateBudgetFromResourceInput/BudgetName
  :cognitect.aws.servicecatalog/BudgetName)

(s/def
  :cognitect.aws.servicecatalog.DisassociateBudgetFromResourceInput/ResourceId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetAccounts
  :cognitect.aws.servicecatalog/StackSetAccounts)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetRegions
  :cognitect.aws.servicecatalog/StackSetRegions)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetFailureToleranceCount
  :cognitect.aws.servicecatalog/StackSetFailureToleranceCount)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetFailureTolerancePercentage
  :cognitect.aws.servicecatalog/StackSetFailureTolerancePercentage)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetMaxConcurrencyCount
  :cognitect.aws.servicecatalog/StackSetMaxConcurrencyCount)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningPreferences/StackSetMaxConcurrencyPercentage
  :cognitect.aws.servicecatalog/StackSetMaxConcurrencyPercentage)

(s/def
  :cognitect.aws.servicecatalog.ProductViewAggregationValue/Value
  :cognitect.aws.servicecatalog/AttributeValue)

(s/def
  :cognitect.aws.servicecatalog.ProductViewAggregationValue/ApproximateCount
  :cognitect.aws.servicecatalog/ApproximateCount)

(s/def
  :cognitect.aws.servicecatalog.UpdatePortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def :cognitect.aws.servicecatalog.UpdatePortfolioInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdatePortfolioInput/DisplayName
  :cognitect.aws.servicecatalog/PortfolioDisplayName)

(s/def
  :cognitect.aws.servicecatalog.UpdatePortfolioInput/Description
  :cognitect.aws.servicecatalog/PortfolioDescription)

(s/def
  :cognitect.aws.servicecatalog.UpdatePortfolioInput/ProviderName
  :cognitect.aws.servicecatalog/ProviderName)

(s/def
  :cognitect.aws.servicecatalog.UpdatePortfolioInput/AddTags
  :cognitect.aws.servicecatalog/AddTags)

(s/def
  :cognitect.aws.servicecatalog.UpdatePortfolioInput/RemoveTags
  :cognitect.aws.servicecatalog/TagKeys)

(s/def
  :cognitect.aws.servicecatalog.AcceptPortfolioShareInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.AcceptPortfolioShareInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.AcceptPortfolioShareInput/PortfolioShareType
  :cognitect.aws.servicecatalog/PortfolioShareType)

(s/def
  :cognitect.aws.servicecatalog.ResourceTargetDefinition/Attribute
  :cognitect.aws.servicecatalog/ResourceAttribute)

(s/def
  :cognitect.aws.servicecatalog.ResourceTargetDefinition/Name
  :cognitect.aws.servicecatalog/PropertyName)

(s/def
  :cognitect.aws.servicecatalog.ResourceTargetDefinition/RequiresRecreation
  :cognitect.aws.servicecatalog/RequiresRecreation)

(s/def :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Name
  :cognitect.aws.servicecatalog/ProvisioningArtifactName)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Description
  :cognitect.aws.servicecatalog/ProvisioningArtifactName)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Type
  :cognitect.aws.servicecatalog/ProvisioningArtifactType)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/CreatedTime
  :cognitect.aws.servicecatalog/CreationTime)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Active
  :cognitect.aws.servicecatalog/ProvisioningArtifactActive)

(s/def
  :cognitect.aws.servicecatalog.ProvisioningArtifactDetail/Guidance
  :cognitect.aws.servicecatalog/ProvisioningArtifactGuidance)

(s/def
  :cognitect.aws.servicecatalog.ListPortfolioAccessInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListPortfolioAccessInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningArtifactOutput/ProvisioningArtifactDetail
  :cognitect.aws.servicecatalog/ProvisioningArtifactDetail)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningArtifactOutput/Info
  :cognitect.aws.servicecatalog/ProvisioningArtifactInfo)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningArtifactOutput/Status
  :cognitect.aws.servicecatalog/Status)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/PlanName
  :cognitect.aws.servicecatalog/ProvisionedProductPlanName)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/PlanId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/ProvisionProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/ProvisionProductName
  :cognitect.aws.servicecatalog/ProvisionedProductName)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/PlanType
  :cognitect.aws.servicecatalog/ProvisionedProductPlanType)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductPlanSummary/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.RejectPortfolioShareInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.RejectPortfolioShareInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.RejectPortfolioShareInput/PortfolioShareType
  :cognitect.aws.servicecatalog/PortfolioShareType)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/Id
  :cognitect.aws.servicecatalog/ProvisionedProductId)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/IdempotencyToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/Arn
  :cognitect.aws.servicecatalog/ProvisionedProductNameOrArn)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/Name
  :cognitect.aws.servicecatalog/ProvisionedProductNameOrArn)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/StatusMessage
  :cognitect.aws.servicecatalog/ProvisionedProductStatusMessage)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/Type
  :cognitect.aws.servicecatalog/ProvisionedProductType)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/CreatedTime
  :cognitect.aws.servicecatalog/CreatedTime)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/LastRecordId
  :cognitect.aws.servicecatalog/LastRequestId)

(s/def
  :cognitect.aws.servicecatalog.ProvisionedProductDetail/Status
  :cognitect.aws.servicecatalog/ProvisionedProductStatus)

(s/def
  :cognitect.aws.servicecatalog.ListLaunchPathsOutput/LaunchPathSummaries
  :cognitect.aws.servicecatalog/LaunchPathSummaries)

(s/def
  :cognitect.aws.servicecatalog.ListLaunchPathsOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.CreatePortfolioShareOutput/PortfolioShareToken
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanInput/PlanId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisionedProductPlanInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.GetAWSOrganizationsAccessStatusOutput/AccessStatus
  :cognitect.aws.servicecatalog/AccessStatus)

(s/def
  :cognitect.aws.servicecatalog.CreateTagOptionInput/Key
  :cognitect.aws.servicecatalog/TagOptionKey)

(s/def
  :cognitect.aws.servicecatalog.CreateTagOptionInput/Value
  :cognitect.aws.servicecatalog/TagOptionValue)

(s/def
  :cognitect.aws.servicecatalog.ResourceDetail/Id
  :cognitect.aws.servicecatalog/ResourceDetailId)

(s/def
  :cognitect.aws.servicecatalog.ResourceDetail/ARN
  :cognitect.aws.servicecatalog/ResourceDetailARN)

(s/def
  :cognitect.aws.servicecatalog.ResourceDetail/Name
  :cognitect.aws.servicecatalog/ResourceDetailName)

(s/def
  :cognitect.aws.servicecatalog.ResourceDetail/Description
  :cognitect.aws.servicecatalog/ResourceDetailDescription)

(s/def
  :cognitect.aws.servicecatalog.ResourceDetail/CreatedTime
  :cognitect.aws.servicecatalog/ResourceDetailCreatedTime)

(s/def
  :cognitect.aws.servicecatalog.ExecuteProvisionedProductPlanOutput/RecordDetail
  :cognitect.aws.servicecatalog/RecordDetail)

(s/def
  :cognitect.aws.servicecatalog.TagOptionSummary/Key
  :cognitect.aws.servicecatalog/TagOptionKey)

(s/def
  :cognitect.aws.servicecatalog.TagOptionSummary/Values
  :cognitect.aws.servicecatalog/TagOptionValues)

(s/def
  :cognitect.aws.servicecatalog.ListRecordHistoryInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListRecordHistoryInput/AccessLevelFilter
  :cognitect.aws.servicecatalog/AccessLevelFilter)

(s/def
  :cognitect.aws.servicecatalog.ListRecordHistoryInput/SearchFilter
  :cognitect.aws.servicecatalog/ListRecordHistorySearchFilter)

(s/def
  :cognitect.aws.servicecatalog.ListRecordHistoryInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListRecordHistoryInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.DescribeServiceActionOutput/ServiceActionDetail
  :cognitect.aws.servicecatalog/ServiceActionDetail)

(s/def
  :cognitect.aws.servicecatalog.DescribeCopyProductStatusOutput/CopyProductStatus
  :cognitect.aws.servicecatalog/CopyProductStatus)

(s/def
  :cognitect.aws.servicecatalog.DescribeCopyProductStatusOutput/TargetProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeCopyProductStatusOutput/StatusDetail
  :cognitect.aws.servicecatalog/StatusDetail)

(s/def
  :cognitect.aws.servicecatalog.ListPrincipalsForPortfolioInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListPrincipalsForPortfolioInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListPrincipalsForPortfolioInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.ListPrincipalsForPortfolioInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisionedProductName
  :cognitect.aws.servicecatalog/ProvisionedProductNameOrArn)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/Tags
  :cognitect.aws.servicecatalog/Tags)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/PathId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisioningParameters
  :cognitect.aws.servicecatalog/UpdateProvisioningParameters)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisioningPreferences
  :cognitect.aws.servicecatalog/UpdateProvisioningPreferences)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/ProvisionedProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProvisionedProductInput/UpdateToken
  :cognitect.aws.servicecatalog/IdempotencyToken)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/Filters
  :cognitect.aws.servicecatalog/ProductViewFilters)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/SortBy
  :cognitect.aws.servicecatalog/ProductViewSortBy)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/SortOrder
  :cognitect.aws.servicecatalog/SortOrder)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.SearchProductsAsAdminInput/ProductSource
  :cognitect.aws.servicecatalog/ProductSource)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/PlanName
  :cognitect.aws.servicecatalog/ProvisionedProductPlanName)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/PlanId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/ProvisionProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/ProvisionedProductName
  :cognitect.aws.servicecatalog/ProvisionedProductName)

(s/def
  :cognitect.aws.servicecatalog.CreateProvisionedProductPlanOutput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def :cognitect.aws.servicecatalog.DescribeServiceActionInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeServiceActionInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/PortfolioId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/OrganizationNodeType
  :cognitect.aws.servicecatalog/OrganizationNodeType)

(s/def
  :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/PageToken
  :cognitect.aws.servicecatalog/PageToken)

(s/def
  :cognitect.aws.servicecatalog.ListOrganizationPortfolioAccessInput/PageSize
  :cognitect.aws.servicecatalog/PageSize)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintOutput/ConstraintDetail
  :cognitect.aws.servicecatalog/ConstraintDetail)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintOutput/ConstraintParameters
  :cognitect.aws.servicecatalog/ConstraintParameters)

(s/def
  :cognitect.aws.servicecatalog.CreateConstraintOutput/Status
  :cognitect.aws.servicecatalog/Status)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningArtifactInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningArtifactInput/ProvisioningArtifactId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningArtifactInput/ProductId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DescribeProvisioningArtifactInput/Verbose
  :cognitect.aws.servicecatalog/Verbose)

(s/def
  :cognitect.aws.servicecatalog.DeleteProvisionedProductPlanInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.DeleteProvisionedProductPlanInput/PlanId
  :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.DeleteProvisionedProductPlanInput/IgnoreErrors
  :cognitect.aws.servicecatalog/IgnoreErrors)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/SupportUrl
  :cognitect.aws.servicecatalog/SupportUrl)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/RemoveTags
  :cognitect.aws.servicecatalog/TagKeys)

(s/def :cognitect.aws.servicecatalog.UpdateProductInput/Id :cognitect.aws.servicecatalog/Id)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/Owner
  :cognitect.aws.servicecatalog/ProductViewOwner)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/Distributor
  :cognitect.aws.servicecatalog/ProductViewOwner)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/AddTags
  :cognitect.aws.servicecatalog/AddTags)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/SupportDescription
  :cognitect.aws.servicecatalog/SupportDescription)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/Name
  :cognitect.aws.servicecatalog/ProductViewName)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/Description
  :cognitect.aws.servicecatalog/ProductViewShortDescription)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/AcceptLanguage
  :cognitect.aws.servicecatalog/AcceptLanguage)

(s/def
  :cognitect.aws.servicecatalog.UpdateProductInput/SupportEmail
  :cognitect.aws.servicecatalog/SupportEmail)

(s/def
  :cognitect.aws.servicecatalog.ScanProvisionedProductsOutput/ProvisionedProducts
  :cognitect.aws.servicecatalog/ProvisionedProductDetails)

(s/def
  :cognitect.aws.servicecatalog.ScanProvisionedProductsOutput/NextPageToken
  :cognitect.aws.servicecatalog/PageToken)

