;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.signer.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def :cognitect.aws.signer/SigningParameterValue string?)

(s/def
  :cognitect.aws.signer/RemoveProfilePermissionResponse
  (s/keys :opt-un [:cognitect.aws.signer.RemoveProfilePermissionResponse/revisionId]))

(s/def
  :cognitect.aws.signer/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.TagResourceRequest/resourceArn
     :cognitect.aws.signer.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.signer/ListSigningPlatformsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.signer.ListSigningPlatformsResponse/nextToken
     :cognitect.aws.signer.ListSigningPlatformsResponse/platforms]))

(s/def
  :cognitect.aws.signer/ImageFormat
  (s/spec string? :gen #(s/gen #{"JSONEmbedded" "JSONDetached" "JSON"})))

(s/def :cognitect.aws.signer/PlatformId string?)

(s/def
  :cognitect.aws.signer/ListSigningPlatformsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.signer.ListSigningPlatformsRequest/maxResults
     :cognitect.aws.signer.ListSigningPlatformsRequest/nextToken
     :cognitect.aws.signer.ListSigningPlatformsRequest/target
     :cognitect.aws.signer.ListSigningPlatformsRequest/partner
     :cognitect.aws.signer.ListSigningPlatformsRequest/category]))

(s/def
  :cognitect.aws.signer/CancelSigningProfileRequest
  (s/keys :req-un [:cognitect.aws.signer.CancelSigningProfileRequest/profileName]))

(s/def :cognitect.aws.signer/StatusReason string?)

(s/def
  :cognitect.aws.signer/SigningProfileStatus
  (s/spec string? :gen #(s/gen #{"Active" "Canceled" "Revoked"})))

(s/def
  :cognitect.aws.signer/S3SignedObject
  (s/keys
    :opt-un
    [:cognitect.aws.signer.S3SignedObject/bucketName :cognitect.aws.signer.S3SignedObject/key]))

(s/def
  :cognitect.aws.signer/RevocationReasonString
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.signer/Prefix string?)

(s/def
  :cognitect.aws.signer/TagMap
  (s/map-of
    :cognitect.aws.signer/TagKey
    :cognitect.aws.signer/TagValue
    :min-count
    1
    :max-count
    200))

(s/def :cognitect.aws.signer/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.signer/SigningProfile
  (s/keys
    :opt-un
    [:cognitect.aws.signer.SigningProfile/signatureValidityPeriod
     :cognitect.aws.signer.SigningProfile/arn
     :cognitect.aws.signer.SigningProfile/signingParameters
     :cognitect.aws.signer.SigningProfile/tags
     :cognitect.aws.signer.SigningProfile/profileVersion
     :cognitect.aws.signer.SigningProfile/signingMaterial
     :cognitect.aws.signer.SigningProfile/status
     :cognitect.aws.signer.SigningProfile/platformDisplayName
     :cognitect.aws.signer.SigningProfile/profileName
     :cognitect.aws.signer.SigningProfile/profileVersionArn
     :cognitect.aws.signer.SigningProfile/platformId]))

(s/def
  :cognitect.aws.signer/PutSigningProfileResponse
  (s/keys
    :opt-un
    [:cognitect.aws.signer.PutSigningProfileResponse/arn
     :cognitect.aws.signer.PutSigningProfileResponse/profileVersion
     :cognitect.aws.signer.PutSigningProfileResponse/profileVersionArn]))

(s/def
  :cognitect.aws.signer/AddProfilePermissionRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.AddProfilePermissionRequest/action
     :cognitect.aws.signer.AddProfilePermissionRequest/principal
     :cognitect.aws.signer.AddProfilePermissionRequest/statementId
     :cognitect.aws.signer.AddProfilePermissionRequest/profileName]
    :opt-un
    [:cognitect.aws.signer.AddProfilePermissionRequest/revisionId
     :cognitect.aws.signer.AddProfilePermissionRequest/profileVersion]))

(s/def
  :cognitect.aws.signer/StartSigningJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.signer.StartSigningJobResponse/jobOwner
     :cognitect.aws.signer.StartSigningJobResponse/jobId]))

(s/def :cognitect.aws.signer/HashAlgorithms (s/coll-of :cognitect.aws.signer/HashAlgorithm))

(s/def :cognitect.aws.signer/JobId string?)

(s/def
  :cognitect.aws.signer/Permission
  (s/keys
    :opt-un
    [:cognitect.aws.signer.Permission/principal
     :cognitect.aws.signer.Permission/statementId
     :cognitect.aws.signer.Permission/profileVersion
     :cognitect.aws.signer.Permission/action]))

(s/def :cognitect.aws.signer/SigningPlatforms (s/coll-of :cognitect.aws.signer/SigningPlatform))

(s/def
  :cognitect.aws.signer/AccountId
  (s/spec #(re-matches (re-pattern "^[0-9]{12}$") %) :gen #(gen/string)))

(s/def :cognitect.aws.signer/ImageFormats (s/coll-of :cognitect.aws.signer/ImageFormat))

(s/def
  :cognitect.aws.signer/DescribeSigningJobResponse
  (s/keys
    :opt-un
    [:cognitect.aws.signer.DescribeSigningJobResponse/overrides
     :cognitect.aws.signer.DescribeSigningJobResponse/signingParameters
     :cognitect.aws.signer.DescribeSigningJobResponse/createdAt
     :cognitect.aws.signer.DescribeSigningJobResponse/revocationRecord
     :cognitect.aws.signer.DescribeSigningJobResponse/completedAt
     :cognitect.aws.signer.DescribeSigningJobResponse/profileVersion
     :cognitect.aws.signer.DescribeSigningJobResponse/signingMaterial
     :cognitect.aws.signer.DescribeSigningJobResponse/status
     :cognitect.aws.signer.DescribeSigningJobResponse/platformDisplayName
     :cognitect.aws.signer.DescribeSigningJobResponse/requestedBy
     :cognitect.aws.signer.DescribeSigningJobResponse/source
     :cognitect.aws.signer.DescribeSigningJobResponse/signatureExpiresAt
     :cognitect.aws.signer.DescribeSigningJobResponse/jobInvoker
     :cognitect.aws.signer.DescribeSigningJobResponse/signedObject
     :cognitect.aws.signer.DescribeSigningJobResponse/jobOwner
     :cognitect.aws.signer.DescribeSigningJobResponse/profileName
     :cognitect.aws.signer.DescribeSigningJobResponse/statusReason
     :cognitect.aws.signer.DescribeSigningJobResponse/platformId
     :cognitect.aws.signer.DescribeSigningJobResponse/jobId]))

(s/def
  :cognitect.aws.signer/ProfileVersion
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9]{10}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.signer/HashAlgorithmOptions
  (s/keys
    :req-un
    [:cognitect.aws.signer.HashAlgorithmOptions/allowedValues
     :cognitect.aws.signer.HashAlgorithmOptions/defaultValue]))

(s/def :cognitect.aws.signer/Key string?)

(s/def :cognitect.aws.signer/Destination (s/keys :opt-un [:cognitect.aws.signer.Destination/s3]))

(s/def :cognitect.aws.signer/SignedObject (s/keys :opt-un [:cognitect.aws.signer.SignedObject/s3]))

(s/def
  :cognitect.aws.signer/MaxSizeInMB
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.signer/SigningStatus
  (s/spec string? :gen #(s/gen #{"Failed" "Succeeded" "InProgress"})))

(s/def :cognitect.aws.signer/ValidityType (s/spec string? :gen #(s/gen #{"DAYS" "YEARS" "MONTHS"})))

(s/def
  :cognitect.aws.signer/StartSigningJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.StartSigningJobRequest/source
     :cognitect.aws.signer.StartSigningJobRequest/destination
     :cognitect.aws.signer.StartSigningJobRequest/profileName
     :cognitect.aws.signer.StartSigningJobRequest/clientRequestToken]
    :opt-un
    [:cognitect.aws.signer.StartSigningJobRequest/profileOwner]))

(s/def :cognitect.aws.signer/SigningParameterKey string?)

(s/def :cognitect.aws.signer/HashAlgorithm (s/spec string? :gen #(s/gen #{"SHA1" "SHA256"})))

(s/def
  :cognitect.aws.signer/GetSigningProfileResponse
  (s/keys
    :opt-un
    [:cognitect.aws.signer.GetSigningProfileResponse/signatureValidityPeriod
     :cognitect.aws.signer.GetSigningProfileResponse/overrides
     :cognitect.aws.signer.GetSigningProfileResponse/arn
     :cognitect.aws.signer.GetSigningProfileResponse/signingParameters
     :cognitect.aws.signer.GetSigningProfileResponse/tags
     :cognitect.aws.signer.GetSigningProfileResponse/revocationRecord
     :cognitect.aws.signer.GetSigningProfileResponse/profileVersion
     :cognitect.aws.signer.GetSigningProfileResponse/signingMaterial
     :cognitect.aws.signer.GetSigningProfileResponse/status
     :cognitect.aws.signer.GetSigningProfileResponse/platformDisplayName
     :cognitect.aws.signer.GetSigningProfileResponse/profileName
     :cognitect.aws.signer.GetSigningProfileResponse/statusReason
     :cognitect.aws.signer.GetSigningProfileResponse/profileVersionArn
     :cognitect.aws.signer.GetSigningProfileResponse/platformId]))

(s/def
  :cognitect.aws.signer/ListProfilePermissionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.signer.ListProfilePermissionsResponse/permissions
     :cognitect.aws.signer.ListProfilePermissionsResponse/revisionId
     :cognitect.aws.signer.ListProfilePermissionsResponse/nextToken
     :cognitect.aws.signer.ListProfilePermissionsResponse/policySizeBytes]))

(s/def :cognitect.aws.signer/NextToken string?)

(s/def :cognitect.aws.signer/string string?)

(s/def :cognitect.aws.signer/Permissions (s/coll-of :cognitect.aws.signer/Permission))

(s/def :cognitect.aws.signer/Integer (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.signer/TagValue
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.signer/ClientRequestToken string?)

(s/def
  :cognitect.aws.signer/GetSigningPlatformRequest
  (s/keys :req-un [:cognitect.aws.signer.GetSigningPlatformRequest/platformId]))

(s/def
  :cognitect.aws.signer/PolicySizeBytes
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.signer/Category (s/spec string? :gen #(s/gen #{"AWSIoT"})))

(s/def
  :cognitect.aws.signer/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.signer.ListTagsForResourceRequest/resourceArn]))

(s/def :cognitect.aws.signer/SigningJobs (s/coll-of :cognitect.aws.signer/SigningJob))

(s/def
  :cognitect.aws.signer/S3Source
  (s/keys
    :req-un
    [:cognitect.aws.signer.S3Source/bucketName
     :cognitect.aws.signer.S3Source/key
     :cognitect.aws.signer.S3Source/version]))

(s/def :cognitect.aws.signer/DisplayName string?)

(s/def :cognitect.aws.signer/EncryptionAlgorithm (s/spec string? :gen #(s/gen #{"RSA" "ECDSA"})))

(s/def :cognitect.aws.signer/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.signer/GetSigningProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.GetSigningProfileRequest/profileName]
    :opt-un
    [:cognitect.aws.signer.GetSigningProfileRequest/profileOwner]))

(s/def
  :cognitect.aws.signer/SigningPlatform
  (s/keys
    :opt-un
    [:cognitect.aws.signer.SigningPlatform/signingConfiguration
     :cognitect.aws.signer.SigningPlatform/displayName
     :cognitect.aws.signer.SigningPlatform/signingImageFormat
     :cognitect.aws.signer.SigningPlatform/maxSizeInMB
     :cognitect.aws.signer.SigningPlatform/revocationSupported
     :cognitect.aws.signer.SigningPlatform/target
     :cognitect.aws.signer.SigningPlatform/partner
     :cognitect.aws.signer.SigningPlatform/platformId
     :cognitect.aws.signer.SigningPlatform/category]))

(s/def
  :cognitect.aws.signer/ListSigningProfilesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.signer.ListSigningProfilesResponse/nextToken
     :cognitect.aws.signer.ListSigningProfilesResponse/profiles]))

(s/def
  :cognitect.aws.signer/SigningJobRevocationRecord
  (s/keys
    :opt-un
    [:cognitect.aws.signer.SigningJobRevocationRecord/revokedAt
     :cognitect.aws.signer.SigningJobRevocationRecord/reason
     :cognitect.aws.signer.SigningJobRevocationRecord/revokedBy]))

(s/def
  :cognitect.aws.signer/SigningImageFormat
  (s/keys
    :req-un
    [:cognitect.aws.signer.SigningImageFormat/supportedFormats
     :cognitect.aws.signer.SigningImageFormat/defaultFormat]))

(s/def
  :cognitect.aws.signer/RevokeSigningProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.RevokeSigningProfileRequest/profileVersion
     :cognitect.aws.signer.RevokeSigningProfileRequest/reason
     :cognitect.aws.signer.RevokeSigningProfileRequest/effectiveTime
     :cognitect.aws.signer.RevokeSigningProfileRequest/profileName]))

(s/def
  :cognitect.aws.signer/GetSigningPlatformResponse
  (s/keys
    :opt-un
    [:cognitect.aws.signer.GetSigningPlatformResponse/signingConfiguration
     :cognitect.aws.signer.GetSigningPlatformResponse/displayName
     :cognitect.aws.signer.GetSigningPlatformResponse/signingImageFormat
     :cognitect.aws.signer.GetSigningPlatformResponse/maxSizeInMB
     :cognitect.aws.signer.GetSigningPlatformResponse/revocationSupported
     :cognitect.aws.signer.GetSigningPlatformResponse/target
     :cognitect.aws.signer.GetSigningPlatformResponse/partner
     :cognitect.aws.signer.GetSigningPlatformResponse/platformId
     :cognitect.aws.signer.GetSigningPlatformResponse/category]))

(s/def
  :cognitect.aws.signer/SigningParameters
  (s/map-of :cognitect.aws.signer/SigningParameterKey :cognitect.aws.signer/SigningParameterValue))

(s/def
  :cognitect.aws.signer/EncryptionAlgorithmOptions
  (s/keys
    :req-un
    [:cognitect.aws.signer.EncryptionAlgorithmOptions/allowedValues
     :cognitect.aws.signer.EncryptionAlgorithmOptions/defaultValue]))

(s/def
  :cognitect.aws.signer/ListProfilePermissionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.ListProfilePermissionsRequest/profileName]
    :opt-un
    [:cognitect.aws.signer.ListProfilePermissionsRequest/nextToken]))

(s/def
  :cognitect.aws.signer/SigningConfigurationOverrides
  (s/keys
    :opt-un
    [:cognitect.aws.signer.SigningConfigurationOverrides/encryptionAlgorithm
     :cognitect.aws.signer.SigningConfigurationOverrides/hashAlgorithm]))

(s/def
  :cognitect.aws.signer/EncryptionAlgorithms
  (s/coll-of :cognitect.aws.signer/EncryptionAlgorithm))

(s/def
  :cognitect.aws.signer/Arn
  (s/spec
    (s/and string? #(<= 20 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 20 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.signer/ProfileName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_]{2,}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.signer/SigningConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.signer.SigningConfiguration/encryptionAlgorithmOptions
     :cognitect.aws.signer.SigningConfiguration/hashAlgorithmOptions]))

(s/def :cognitect.aws.signer/BucketName string?)

(s/def :cognitect.aws.signer/MaxResults (s/spec (s/and int? #(<= 1 % 25)) :gen #(gen/choose 1 25)))

(s/def
  :cognitect.aws.signer/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.UntagResourceRequest/resourceArn
     :cognitect.aws.signer.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.signer/TagKey
  (s/spec #(re-matches (re-pattern "^(?!aws:)[a-zA-Z+-=._:/]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.signer/RequestedBy string?)

(s/def :cognitect.aws.signer/CertificateArn string?)

(s/def :cognitect.aws.signer/SigningProfiles (s/coll-of :cognitect.aws.signer/SigningProfile))

(s/def
  :cognitect.aws.signer/AddProfilePermissionResponse
  (s/keys :opt-un [:cognitect.aws.signer.AddProfilePermissionResponse/revisionId]))

(s/def :cognitect.aws.signer/bool boolean?)

(s/def :cognitect.aws.signer/Timestamp inst?)

(s/def
  :cognitect.aws.signer/SignatureValidityPeriod
  (s/keys
    :opt-un
    [:cognitect.aws.signer.SignatureValidityPeriod/value
     :cognitect.aws.signer.SignatureValidityPeriod/type]))

(s/def
  :cognitect.aws.signer/ListSigningJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.signer.ListSigningJobsRequest/maxResults
     :cognitect.aws.signer.ListSigningJobsRequest/nextToken
     :cognitect.aws.signer.ListSigningJobsRequest/status
     :cognitect.aws.signer.ListSigningJobsRequest/requestedBy
     :cognitect.aws.signer.ListSigningJobsRequest/jobInvoker
     :cognitect.aws.signer.ListSigningJobsRequest/signatureExpiresBefore
     :cognitect.aws.signer.ListSigningJobsRequest/platformId
     :cognitect.aws.signer.ListSigningJobsRequest/signatureExpiresAfter
     :cognitect.aws.signer.ListSigningJobsRequest/isRevoked]))

(s/def :cognitect.aws.signer/Source (s/keys :opt-un [:cognitect.aws.signer.Source/s3]))

(s/def
  :cognitect.aws.signer/PutSigningProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.PutSigningProfileRequest/profileName
     :cognitect.aws.signer.PutSigningProfileRequest/platformId]
    :opt-un
    [:cognitect.aws.signer.PutSigningProfileRequest/signatureValidityPeriod
     :cognitect.aws.signer.PutSigningProfileRequest/overrides
     :cognitect.aws.signer.PutSigningProfileRequest/signingParameters
     :cognitect.aws.signer.PutSigningProfileRequest/tags
     :cognitect.aws.signer.PutSigningProfileRequest/signingMaterial]))

(s/def
  :cognitect.aws.signer/ListSigningProfilesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.signer.ListSigningProfilesRequest/maxResults
     :cognitect.aws.signer.ListSigningProfilesRequest/nextToken
     :cognitect.aws.signer.ListSigningProfilesRequest/includeCanceled
     :cognitect.aws.signer.ListSigningProfilesRequest/statuses
     :cognitect.aws.signer.ListSigningProfilesRequest/platformId]))

(s/def
  :cognitect.aws.signer/SigningProfileRevocationRecord
  (s/keys
    :opt-un
    [:cognitect.aws.signer.SigningProfileRevocationRecord/revokedAt
     :cognitect.aws.signer.SigningProfileRevocationRecord/revocationEffectiveFrom
     :cognitect.aws.signer.SigningProfileRevocationRecord/revokedBy]))

(s/def :cognitect.aws.signer/Statuses (s/coll-of :cognitect.aws.signer/SigningProfileStatus))

(s/def
  :cognitect.aws.signer/RevokeSignatureRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.RevokeSignatureRequest/reason
     :cognitect.aws.signer.RevokeSignatureRequest/jobId]
    :opt-un
    [:cognitect.aws.signer.RevokeSignatureRequest/jobOwner]))

(s/def :cognitect.aws.signer/Version string?)

(s/def
  :cognitect.aws.signer/S3Destination
  (s/keys
    :opt-un
    [:cognitect.aws.signer.S3Destination/prefix :cognitect.aws.signer.S3Destination/bucketName]))

(s/def
  :cognitect.aws.signer/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.signer.ListTagsForResourceResponse/tags]))

(s/def
  :cognitect.aws.signer/SigningJob
  (s/keys
    :opt-un
    [:cognitect.aws.signer.SigningJob/createdAt
     :cognitect.aws.signer.SigningJob/profileVersion
     :cognitect.aws.signer.SigningJob/signingMaterial
     :cognitect.aws.signer.SigningJob/status
     :cognitect.aws.signer.SigningJob/platformDisplayName
     :cognitect.aws.signer.SigningJob/source
     :cognitect.aws.signer.SigningJob/signatureExpiresAt
     :cognitect.aws.signer.SigningJob/jobInvoker
     :cognitect.aws.signer.SigningJob/signedObject
     :cognitect.aws.signer.SigningJob/jobOwner
     :cognitect.aws.signer.SigningJob/profileName
     :cognitect.aws.signer.SigningJob/platformId
     :cognitect.aws.signer.SigningJob/jobId
     :cognitect.aws.signer.SigningJob/isRevoked]))

(s/def
  :cognitect.aws.signer/RemoveProfilePermissionRequest
  (s/keys
    :req-un
    [:cognitect.aws.signer.RemoveProfilePermissionRequest/revisionId
     :cognitect.aws.signer.RemoveProfilePermissionRequest/profileName
     :cognitect.aws.signer.RemoveProfilePermissionRequest/statementId]))

(s/def
  :cognitect.aws.signer/DescribeSigningJobRequest
  (s/keys :req-un [:cognitect.aws.signer.DescribeSigningJobRequest/jobId]))

(s/def
  :cognitect.aws.signer/SigningPlatformOverrides
  (s/keys
    :opt-un
    [:cognitect.aws.signer.SigningPlatformOverrides/signingConfiguration
     :cognitect.aws.signer.SigningPlatformOverrides/signingImageFormat]))

(s/def :cognitect.aws.signer/String string?)

(s/def
  :cognitect.aws.signer/ListSigningJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.signer.ListSigningJobsResponse/nextToken
     :cognitect.aws.signer.ListSigningJobsResponse/jobs]))

(s/def
  :cognitect.aws.signer/TagKeyList
  (s/coll-of :cognitect.aws.signer/TagKey :min-count 1 :max-count 200))

(s/def
  :cognitect.aws.signer/SigningMaterial
  (s/keys :req-un [:cognitect.aws.signer.SigningMaterial/certificateArn]))

(s/def
  :cognitect.aws.signer.RemoveProfilePermissionResponse/revisionId
  :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.TagResourceRequest/resourceArn :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.TagResourceRequest/tags :cognitect.aws.signer/TagMap)

(s/def
  :cognitect.aws.signer.ListSigningPlatformsResponse/platforms
  :cognitect.aws.signer/SigningPlatforms)

(s/def :cognitect.aws.signer.ListSigningPlatformsResponse/nextToken :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.ListSigningPlatformsRequest/category :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.ListSigningPlatformsRequest/partner :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.ListSigningPlatformsRequest/target :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.ListSigningPlatformsRequest/maxResults
  :cognitect.aws.signer/MaxResults)

(s/def :cognitect.aws.signer.ListSigningPlatformsRequest/nextToken :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.CancelSigningProfileRequest/profileName
  :cognitect.aws.signer/ProfileName)

(s/def :cognitect.aws.signer.S3SignedObject/bucketName :cognitect.aws.signer/BucketName)

(s/def :cognitect.aws.signer.S3SignedObject/key :cognitect.aws.signer/Key)

(s/def :cognitect.aws.signer.SigningProfile/profileVersionArn :cognitect.aws.signer/Arn)

(s/def :cognitect.aws.signer.SigningProfile/tags :cognitect.aws.signer/TagMap)

(s/def
  :cognitect.aws.signer.SigningProfile/signatureValidityPeriod
  :cognitect.aws.signer/SignatureValidityPeriod)

(s/def :cognitect.aws.signer.SigningProfile/profileName :cognitect.aws.signer/ProfileName)

(s/def :cognitect.aws.signer.SigningProfile/platformDisplayName :cognitect.aws.signer/DisplayName)

(s/def :cognitect.aws.signer.SigningProfile/signingMaterial :cognitect.aws.signer/SigningMaterial)

(s/def :cognitect.aws.signer.SigningProfile/status :cognitect.aws.signer/SigningProfileStatus)

(s/def :cognitect.aws.signer.SigningProfile/profileVersion :cognitect.aws.signer/ProfileVersion)

(s/def
  :cognitect.aws.signer.SigningProfile/signingParameters
  :cognitect.aws.signer/SigningParameters)

(s/def :cognitect.aws.signer.SigningProfile/arn :cognitect.aws.signer/string)

(s/def :cognitect.aws.signer.SigningProfile/platformId :cognitect.aws.signer/PlatformId)

(s/def :cognitect.aws.signer.PutSigningProfileResponse/arn :cognitect.aws.signer/string)

(s/def
  :cognitect.aws.signer.PutSigningProfileResponse/profileVersion
  :cognitect.aws.signer/ProfileVersion)

(s/def :cognitect.aws.signer.PutSigningProfileResponse/profileVersionArn :cognitect.aws.signer/Arn)

(s/def
  :cognitect.aws.signer.AddProfilePermissionRequest/profileName
  :cognitect.aws.signer/ProfileName)

(s/def
  :cognitect.aws.signer.AddProfilePermissionRequest/profileVersion
  :cognitect.aws.signer/ProfileVersion)

(s/def :cognitect.aws.signer.AddProfilePermissionRequest/action :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.AddProfilePermissionRequest/principal :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.AddProfilePermissionRequest/revisionId :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.AddProfilePermissionRequest/statementId :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.StartSigningJobResponse/jobId :cognitect.aws.signer/JobId)

(s/def :cognitect.aws.signer.StartSigningJobResponse/jobOwner :cognitect.aws.signer/AccountId)

(s/def :cognitect.aws.signer.Permission/action :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.Permission/principal :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.Permission/statementId :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.Permission/profileVersion :cognitect.aws.signer/ProfileVersion)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/overrides
  :cognitect.aws.signer/SigningPlatformOverrides)

(s/def :cognitect.aws.signer.DescribeSigningJobResponse/jobOwner :cognitect.aws.signer/AccountId)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/profileName
  :cognitect.aws.signer/ProfileName)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/platformDisplayName
  :cognitect.aws.signer/DisplayName)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/signatureExpiresAt
  :cognitect.aws.signer/Timestamp)

(s/def :cognitect.aws.signer.DescribeSigningJobResponse/completedAt :cognitect.aws.signer/Timestamp)

(s/def :cognitect.aws.signer.DescribeSigningJobResponse/createdAt :cognitect.aws.signer/Timestamp)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/statusReason
  :cognitect.aws.signer/StatusReason)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/requestedBy
  :cognitect.aws.signer/RequestedBy)

(s/def :cognitect.aws.signer.DescribeSigningJobResponse/source :cognitect.aws.signer/Source)

(s/def :cognitect.aws.signer.DescribeSigningJobResponse/jobInvoker :cognitect.aws.signer/AccountId)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/signingMaterial
  :cognitect.aws.signer/SigningMaterial)

(s/def :cognitect.aws.signer.DescribeSigningJobResponse/status :cognitect.aws.signer/SigningStatus)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/profileVersion
  :cognitect.aws.signer/ProfileVersion)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/signingParameters
  :cognitect.aws.signer/SigningParameters)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/revocationRecord
  :cognitect.aws.signer/SigningJobRevocationRecord)

(s/def
  :cognitect.aws.signer.DescribeSigningJobResponse/signedObject
  :cognitect.aws.signer/SignedObject)

(s/def :cognitect.aws.signer.DescribeSigningJobResponse/jobId :cognitect.aws.signer/JobId)

(s/def :cognitect.aws.signer.DescribeSigningJobResponse/platformId :cognitect.aws.signer/PlatformId)

(s/def
  :cognitect.aws.signer.HashAlgorithmOptions/allowedValues
  :cognitect.aws.signer/HashAlgorithms)

(s/def :cognitect.aws.signer.HashAlgorithmOptions/defaultValue :cognitect.aws.signer/HashAlgorithm)

(s/def :cognitect.aws.signer.Destination/s3 :cognitect.aws.signer/S3Destination)

(s/def :cognitect.aws.signer.SignedObject/s3 :cognitect.aws.signer/S3SignedObject)

(s/def :cognitect.aws.signer.StartSigningJobRequest/source :cognitect.aws.signer/Source)

(s/def :cognitect.aws.signer.StartSigningJobRequest/destination :cognitect.aws.signer/Destination)

(s/def :cognitect.aws.signer.StartSigningJobRequest/profileName :cognitect.aws.signer/ProfileName)

(s/def
  :cognitect.aws.signer.StartSigningJobRequest/clientRequestToken
  :cognitect.aws.signer/ClientRequestToken)

(s/def :cognitect.aws.signer.StartSigningJobRequest/profileOwner :cognitect.aws.signer/AccountId)

(s/def :cognitect.aws.signer.GetSigningProfileResponse/profileVersionArn :cognitect.aws.signer/Arn)

(s/def :cognitect.aws.signer.GetSigningProfileResponse/tags :cognitect.aws.signer/TagMap)

(s/def
  :cognitect.aws.signer.GetSigningProfileResponse/signatureValidityPeriod
  :cognitect.aws.signer/SignatureValidityPeriod)

(s/def
  :cognitect.aws.signer.GetSigningProfileResponse/overrides
  :cognitect.aws.signer/SigningPlatformOverrides)

(s/def
  :cognitect.aws.signer.GetSigningProfileResponse/profileName
  :cognitect.aws.signer/ProfileName)

(s/def
  :cognitect.aws.signer.GetSigningProfileResponse/platformDisplayName
  :cognitect.aws.signer/DisplayName)

(s/def :cognitect.aws.signer.GetSigningProfileResponse/statusReason :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.GetSigningProfileResponse/signingMaterial
  :cognitect.aws.signer/SigningMaterial)

(s/def
  :cognitect.aws.signer.GetSigningProfileResponse/status
  :cognitect.aws.signer/SigningProfileStatus)

(s/def
  :cognitect.aws.signer.GetSigningProfileResponse/profileVersion
  :cognitect.aws.signer/ProfileVersion)

(s/def
  :cognitect.aws.signer.GetSigningProfileResponse/signingParameters
  :cognitect.aws.signer/SigningParameters)

(s/def
  :cognitect.aws.signer.GetSigningProfileResponse/revocationRecord
  :cognitect.aws.signer/SigningProfileRevocationRecord)

(s/def :cognitect.aws.signer.GetSigningProfileResponse/arn :cognitect.aws.signer/string)

(s/def :cognitect.aws.signer.GetSigningProfileResponse/platformId :cognitect.aws.signer/PlatformId)

(s/def :cognitect.aws.signer.ListProfilePermissionsResponse/revisionId :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.ListProfilePermissionsResponse/policySizeBytes
  :cognitect.aws.signer/PolicySizeBytes)

(s/def
  :cognitect.aws.signer.ListProfilePermissionsResponse/permissions
  :cognitect.aws.signer/Permissions)

(s/def :cognitect.aws.signer.ListProfilePermissionsResponse/nextToken :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.GetSigningPlatformRequest/platformId :cognitect.aws.signer/PlatformId)

(s/def :cognitect.aws.signer.ListTagsForResourceRequest/resourceArn :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.S3Source/bucketName :cognitect.aws.signer/BucketName)

(s/def :cognitect.aws.signer.S3Source/key :cognitect.aws.signer/Key)

(s/def :cognitect.aws.signer.S3Source/version :cognitect.aws.signer/Version)

(s/def :cognitect.aws.signer.GetSigningProfileRequest/profileName :cognitect.aws.signer/ProfileName)

(s/def :cognitect.aws.signer.GetSigningProfileRequest/profileOwner :cognitect.aws.signer/AccountId)

(s/def :cognitect.aws.signer.SigningPlatform/revocationSupported :cognitect.aws.signer/bool)

(s/def :cognitect.aws.signer.SigningPlatform/category :cognitect.aws.signer/Category)

(s/def :cognitect.aws.signer.SigningPlatform/partner :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.SigningPlatform/signingImageFormat
  :cognitect.aws.signer/SigningImageFormat)

(s/def :cognitect.aws.signer.SigningPlatform/displayName :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.SigningPlatform/signingConfiguration
  :cognitect.aws.signer/SigningConfiguration)

(s/def :cognitect.aws.signer.SigningPlatform/target :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.SigningPlatform/maxSizeInMB :cognitect.aws.signer/MaxSizeInMB)

(s/def :cognitect.aws.signer.SigningPlatform/platformId :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.ListSigningProfilesResponse/profiles
  :cognitect.aws.signer/SigningProfiles)

(s/def :cognitect.aws.signer.ListSigningProfilesResponse/nextToken :cognitect.aws.signer/NextToken)

(s/def :cognitect.aws.signer.SigningJobRevocationRecord/reason :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.SigningJobRevocationRecord/revokedAt :cognitect.aws.signer/Timestamp)

(s/def :cognitect.aws.signer.SigningJobRevocationRecord/revokedBy :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.SigningImageFormat/supportedFormats :cognitect.aws.signer/ImageFormats)

(s/def :cognitect.aws.signer.SigningImageFormat/defaultFormat :cognitect.aws.signer/ImageFormat)

(s/def
  :cognitect.aws.signer.RevokeSigningProfileRequest/profileName
  :cognitect.aws.signer/ProfileName)

(s/def
  :cognitect.aws.signer.RevokeSigningProfileRequest/profileVersion
  :cognitect.aws.signer/ProfileVersion)

(s/def
  :cognitect.aws.signer.RevokeSigningProfileRequest/reason
  :cognitect.aws.signer/RevocationReasonString)

(s/def
  :cognitect.aws.signer.RevokeSigningProfileRequest/effectiveTime
  :cognitect.aws.signer/Timestamp)

(s/def
  :cognitect.aws.signer.GetSigningPlatformResponse/revocationSupported
  :cognitect.aws.signer/bool)

(s/def :cognitect.aws.signer.GetSigningPlatformResponse/category :cognitect.aws.signer/Category)

(s/def :cognitect.aws.signer.GetSigningPlatformResponse/partner :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.GetSigningPlatformResponse/signingImageFormat
  :cognitect.aws.signer/SigningImageFormat)

(s/def
  :cognitect.aws.signer.GetSigningPlatformResponse/displayName
  :cognitect.aws.signer/DisplayName)

(s/def
  :cognitect.aws.signer.GetSigningPlatformResponse/signingConfiguration
  :cognitect.aws.signer/SigningConfiguration)

(s/def :cognitect.aws.signer.GetSigningPlatformResponse/target :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.GetSigningPlatformResponse/maxSizeInMB
  :cognitect.aws.signer/MaxSizeInMB)

(s/def :cognitect.aws.signer.GetSigningPlatformResponse/platformId :cognitect.aws.signer/PlatformId)

(s/def
  :cognitect.aws.signer.EncryptionAlgorithmOptions/allowedValues
  :cognitect.aws.signer/EncryptionAlgorithms)

(s/def
  :cognitect.aws.signer.EncryptionAlgorithmOptions/defaultValue
  :cognitect.aws.signer/EncryptionAlgorithm)

(s/def
  :cognitect.aws.signer.ListProfilePermissionsRequest/profileName
  :cognitect.aws.signer/ProfileName)

(s/def :cognitect.aws.signer.ListProfilePermissionsRequest/nextToken :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.SigningConfigurationOverrides/encryptionAlgorithm
  :cognitect.aws.signer/EncryptionAlgorithm)

(s/def
  :cognitect.aws.signer.SigningConfigurationOverrides/hashAlgorithm
  :cognitect.aws.signer/HashAlgorithm)

(s/def
  :cognitect.aws.signer.SigningConfiguration/encryptionAlgorithmOptions
  :cognitect.aws.signer/EncryptionAlgorithmOptions)

(s/def
  :cognitect.aws.signer.SigningConfiguration/hashAlgorithmOptions
  :cognitect.aws.signer/HashAlgorithmOptions)

(s/def :cognitect.aws.signer.UntagResourceRequest/resourceArn :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.UntagResourceRequest/tagKeys :cognitect.aws.signer/TagKeyList)

(s/def :cognitect.aws.signer.AddProfilePermissionResponse/revisionId :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.SignatureValidityPeriod/value :cognitect.aws.signer/Integer)

(s/def :cognitect.aws.signer.SignatureValidityPeriod/type :cognitect.aws.signer/ValidityType)

(s/def
  :cognitect.aws.signer.ListSigningJobsRequest/signatureExpiresAfter
  :cognitect.aws.signer/Timestamp)

(s/def
  :cognitect.aws.signer.ListSigningJobsRequest/signatureExpiresBefore
  :cognitect.aws.signer/Timestamp)

(s/def :cognitect.aws.signer.ListSigningJobsRequest/requestedBy :cognitect.aws.signer/RequestedBy)

(s/def :cognitect.aws.signer.ListSigningJobsRequest/jobInvoker :cognitect.aws.signer/AccountId)

(s/def :cognitect.aws.signer.ListSigningJobsRequest/status :cognitect.aws.signer/SigningStatus)

(s/def :cognitect.aws.signer.ListSigningJobsRequest/nextToken :cognitect.aws.signer/NextToken)

(s/def :cognitect.aws.signer.ListSigningJobsRequest/isRevoked :cognitect.aws.signer/bool)

(s/def :cognitect.aws.signer.ListSigningJobsRequest/maxResults :cognitect.aws.signer/MaxResults)

(s/def :cognitect.aws.signer.ListSigningJobsRequest/platformId :cognitect.aws.signer/PlatformId)

(s/def :cognitect.aws.signer.Source/s3 :cognitect.aws.signer/S3Source)

(s/def :cognitect.aws.signer.PutSigningProfileRequest/profileName :cognitect.aws.signer/ProfileName)

(s/def
  :cognitect.aws.signer.PutSigningProfileRequest/signingMaterial
  :cognitect.aws.signer/SigningMaterial)

(s/def
  :cognitect.aws.signer.PutSigningProfileRequest/signatureValidityPeriod
  :cognitect.aws.signer/SignatureValidityPeriod)

(s/def :cognitect.aws.signer.PutSigningProfileRequest/platformId :cognitect.aws.signer/PlatformId)

(s/def
  :cognitect.aws.signer.PutSigningProfileRequest/overrides
  :cognitect.aws.signer/SigningPlatformOverrides)

(s/def
  :cognitect.aws.signer.PutSigningProfileRequest/signingParameters
  :cognitect.aws.signer/SigningParameters)

(s/def :cognitect.aws.signer.PutSigningProfileRequest/tags :cognitect.aws.signer/TagMap)

(s/def :cognitect.aws.signer.ListSigningProfilesRequest/includeCanceled :cognitect.aws.signer/bool)

(s/def :cognitect.aws.signer.ListSigningProfilesRequest/maxResults :cognitect.aws.signer/MaxResults)

(s/def :cognitect.aws.signer.ListSigningProfilesRequest/nextToken :cognitect.aws.signer/NextToken)

(s/def :cognitect.aws.signer.ListSigningProfilesRequest/platformId :cognitect.aws.signer/PlatformId)

(s/def :cognitect.aws.signer.ListSigningProfilesRequest/statuses :cognitect.aws.signer/Statuses)

(s/def
  :cognitect.aws.signer.SigningProfileRevocationRecord/revocationEffectiveFrom
  :cognitect.aws.signer/Timestamp)

(s/def
  :cognitect.aws.signer.SigningProfileRevocationRecord/revokedAt
  :cognitect.aws.signer/Timestamp)

(s/def :cognitect.aws.signer.SigningProfileRevocationRecord/revokedBy :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.RevokeSignatureRequest/jobId :cognitect.aws.signer/JobId)

(s/def :cognitect.aws.signer.RevokeSignatureRequest/jobOwner :cognitect.aws.signer/AccountId)

(s/def
  :cognitect.aws.signer.RevokeSignatureRequest/reason
  :cognitect.aws.signer/RevocationReasonString)

(s/def :cognitect.aws.signer.S3Destination/bucketName :cognitect.aws.signer/BucketName)

(s/def :cognitect.aws.signer.S3Destination/prefix :cognitect.aws.signer/Prefix)

(s/def :cognitect.aws.signer.ListTagsForResourceResponse/tags :cognitect.aws.signer/TagMap)

(s/def :cognitect.aws.signer.SigningJob/jobOwner :cognitect.aws.signer/AccountId)

(s/def :cognitect.aws.signer.SigningJob/profileName :cognitect.aws.signer/ProfileName)

(s/def :cognitect.aws.signer.SigningJob/platformDisplayName :cognitect.aws.signer/DisplayName)

(s/def :cognitect.aws.signer.SigningJob/signatureExpiresAt :cognitect.aws.signer/Timestamp)

(s/def :cognitect.aws.signer.SigningJob/createdAt :cognitect.aws.signer/Timestamp)

(s/def :cognitect.aws.signer.SigningJob/source :cognitect.aws.signer/Source)

(s/def :cognitect.aws.signer.SigningJob/jobInvoker :cognitect.aws.signer/AccountId)

(s/def :cognitect.aws.signer.SigningJob/signingMaterial :cognitect.aws.signer/SigningMaterial)

(s/def :cognitect.aws.signer.SigningJob/status :cognitect.aws.signer/SigningStatus)

(s/def :cognitect.aws.signer.SigningJob/profileVersion :cognitect.aws.signer/ProfileVersion)

(s/def :cognitect.aws.signer.SigningJob/signedObject :cognitect.aws.signer/SignedObject)

(s/def :cognitect.aws.signer.SigningJob/jobId :cognitect.aws.signer/JobId)

(s/def :cognitect.aws.signer.SigningJob/isRevoked :cognitect.aws.signer/bool)

(s/def :cognitect.aws.signer.SigningJob/platformId :cognitect.aws.signer/PlatformId)

(s/def
  :cognitect.aws.signer.RemoveProfilePermissionRequest/profileName
  :cognitect.aws.signer/ProfileName)

(s/def :cognitect.aws.signer.RemoveProfilePermissionRequest/revisionId :cognitect.aws.signer/String)

(s/def
  :cognitect.aws.signer.RemoveProfilePermissionRequest/statementId
  :cognitect.aws.signer/String)

(s/def :cognitect.aws.signer.DescribeSigningJobRequest/jobId :cognitect.aws.signer/JobId)

(s/def
  :cognitect.aws.signer.SigningPlatformOverrides/signingConfiguration
  :cognitect.aws.signer/SigningConfigurationOverrides)

(s/def
  :cognitect.aws.signer.SigningPlatformOverrides/signingImageFormat
  :cognitect.aws.signer/ImageFormat)

(s/def :cognitect.aws.signer.ListSigningJobsResponse/jobs :cognitect.aws.signer/SigningJobs)

(s/def :cognitect.aws.signer.ListSigningJobsResponse/nextToken :cognitect.aws.signer/NextToken)

(s/def :cognitect.aws.signer.SigningMaterial/certificateArn :cognitect.aws.signer/CertificateArn)

