;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.sms.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def :cognitect.aws.sms/LogicalId string?)

(s/def :cognitect.aws.sms/ImportAppCatalogResponse (s/keys))

(s/def
  :cognitect.aws.sms/GetAppReplicationConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetAppReplicationConfigurationResponse/serverGroupReplicationConfigurations]))

(s/def :cognitect.aws.sms/VPC string?)

(s/def
  :cognitect.aws.sms/ReplicationJobState
  (s/spec
    string?
    :gen
    #(s/gen
      #{"COMPLETED" "FAILING" "PENDING" "DELETING" "ACTIVE" "FAILED" "DELETED"
        "PAUSED_ON_FAILURE"})))

(s/def
  :cognitect.aws.sms/DeleteAppLaunchConfigurationRequest
  (s/keys :opt-un [:cognitect.aws.sms.DeleteAppLaunchConfigurationRequest/appId]))

(s/def
  :cognitect.aws.sms/ServerReplicationParameters
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ServerReplicationParameters/kmsKeyId
     :cognitect.aws.sms.ServerReplicationParameters/runOnce
     :cognitect.aws.sms.ServerReplicationParameters/seedTime
     :cognitect.aws.sms.ServerReplicationParameters/licenseType
     :cognitect.aws.sms.ServerReplicationParameters/encrypted
     :cognitect.aws.sms.ServerReplicationParameters/numberOfRecentAmisToKeep
     :cognitect.aws.sms.ServerReplicationParameters/frequency]))

(s/def
  :cognitect.aws.sms/GenerateChangeSetRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GenerateChangeSetRequest/changesetFormat
     :cognitect.aws.sms.GenerateChangeSetRequest/appId]))

(s/def :cognitect.aws.sms/ReplicationJobTerminated boolean?)

(s/def :cognitect.aws.sms/DeleteAppReplicationConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.sms/TotalServers
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.sms/AppValidationConfigurations
  (s/coll-of :cognitect.aws.sms/AppValidationConfiguration))

(s/def :cognitect.aws.sms/DeleteReplicationJobResponse (s/keys))

(s/def :cognitect.aws.sms/AutoLaunch boolean?)

(s/def
  :cognitect.aws.sms/ServerLaunchConfigurations
  (s/coll-of :cognitect.aws.sms/ServerLaunchConfiguration))

(s/def :cognitect.aws.sms/DisassociateConnectorResponse (s/keys))

(s/def
  :cognitect.aws.sms/Tag
  (s/keys :opt-un [:cognitect.aws.sms.Tag/key :cognitect.aws.sms.Tag/value]))

(s/def :cognitect.aws.sms/DeleteAppLaunchConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.sms/ReplicationRunStageDetails
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ReplicationRunStageDetails/stageProgress
     :cognitect.aws.sms.ReplicationRunStageDetails/stage]))

(s/def
  :cognitect.aws.sms/GenerateChangeSetResponse
  (s/keys :opt-un [:cognitect.aws.sms.GenerateChangeSetResponse/s3Location]))

(s/def
  :cognitect.aws.sms/SSMValidationParameters
  (s/keys
    :opt-un
    [:cognitect.aws.sms.SSMValidationParameters/command
     :cognitect.aws.sms.SSMValidationParameters/scriptType
     :cognitect.aws.sms.SSMValidationParameters/outputS3BucketName
     :cognitect.aws.sms.SSMValidationParameters/source
     :cognitect.aws.sms.SSMValidationParameters/instanceId
     :cognitect.aws.sms.SSMValidationParameters/executionTimeoutSeconds]))

(s/def :cognitect.aws.sms/OutputFormat (s/spec string? :gen #(s/gen #{"YAML" "JSON"})))

(s/def
  :cognitect.aws.sms/AppValidationConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.sms.AppValidationConfiguration/appValidationStrategy
     :cognitect.aws.sms.AppValidationConfiguration/name
     :cognitect.aws.sms.AppValidationConfiguration/ssmValidationParameters
     :cognitect.aws.sms.AppValidationConfiguration/validationId]))

(s/def :cognitect.aws.sms/LaunchAppResponse (s/keys))

(s/def
  :cognitect.aws.sms/VmServerAddress
  (s/keys
    :opt-un
    [:cognitect.aws.sms.VmServerAddress/vmManagerId :cognitect.aws.sms.VmServerAddress/vmId]))

(s/def
  :cognitect.aws.sms/Server
  (s/keys
    :opt-un
    [:cognitect.aws.sms.Server/replicationJobTerminated
     :cognitect.aws.sms.Server/serverType
     :cognitect.aws.sms.Server/vmServer
     :cognitect.aws.sms.Server/serverId
     :cognitect.aws.sms.Server/replicationJobId]))

(s/def :cognitect.aws.sms/AmiId string?)

(s/def :cognitect.aws.sms/AppStatusMessage string?)

(s/def
  :cognitect.aws.sms/AppIdWithValidation
  (s/spec #(re-matches (re-pattern "^app-[0-9a-f]{17}$") %) :gen #(gen/string)))

(s/def :cognitect.aws.sms/ImportServerCatalogResponse (s/keys))

(s/def
  :cognitect.aws.sms/DeleteAppRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.DeleteAppRequest/forceTerminateApp
     :cognitect.aws.sms.DeleteAppRequest/forceStopAppReplication
     :cognitect.aws.sms.DeleteAppRequest/appId]))

(s/def
  :cognitect.aws.sms/PutAppValidationConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.sms.PutAppValidationConfigurationRequest/appId]
    :opt-un
    [:cognitect.aws.sms.PutAppValidationConfigurationRequest/appValidationConfigurations
     :cognitect.aws.sms.PutAppValidationConfigurationRequest/serverGroupValidationConfigurations]))

(s/def
  :cognitect.aws.sms/ConnectorCapabilityList
  (s/coll-of :cognitect.aws.sms/ConnectorCapability))

(s/def
  :cognitect.aws.sms/ValidationStatusMessage
  (s/spec
    (s/and string? #(>= 2500 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.sms/ServerValidationConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ServerValidationConfiguration/server
     :cognitect.aws.sms.ServerValidationConfiguration/name
     :cognitect.aws.sms.ServerValidationConfiguration/validationId
     :cognitect.aws.sms.ServerValidationConfiguration/serverValidationStrategy
     :cognitect.aws.sms.ServerValidationConfiguration/userDataValidationParameters]))

(s/def :cognitect.aws.sms/ValidationOutputList (s/coll-of :cognitect.aws.sms/ValidationOutput))

(s/def :cognitect.aws.sms/IpAddress string?)

(s/def
  :cognitect.aws.sms/GetAppValidationConfigurationRequest
  (s/keys :req-un [:cognitect.aws.sms.GetAppValidationConfigurationRequest/appId]))

(s/def :cognitect.aws.sms/ServerGroupName string?)

(s/def
  :cognitect.aws.sms/ExecutionTimeoutSeconds
  (s/spec (s/and int? #(<= 60 % 28800)) :gen #(gen/choose 60 28800)))

(s/def :cognitect.aws.sms/ConnectorStatus (s/spec string? :gen #(s/gen #{"HEALTHY" "UNHEALTHY"})))

(s/def
  :cognitect.aws.sms/ValidationStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"IN_PROGRESS" "READY_FOR_VALIDATION" "PENDING" "SUCCEEDED" "FAILED"})))

(s/def
  :cognitect.aws.sms/StartOnDemandAppReplicationRequest
  (s/keys
    :req-un
    [:cognitect.aws.sms.StartOnDemandAppReplicationRequest/appId]
    :opt-un
    [:cognitect.aws.sms.StartOnDemandAppReplicationRequest/description]))

(s/def
  :cognitect.aws.sms/VmServer
  (s/keys
    :opt-un
    [:cognitect.aws.sms.VmServer/vmManagerType
     :cognitect.aws.sms.VmServer/vmManagerName
     :cognitect.aws.sms.VmServer/vmServerAddress
     :cognitect.aws.sms.VmServer/vmName
     :cognitect.aws.sms.VmServer/vmPath]))

(s/def :cognitect.aws.sms/PutAppReplicationConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.sms/DisassociateConnectorRequest
  (s/keys :req-un [:cognitect.aws.sms.DisassociateConnectorRequest/connectorId]))

(s/def :cognitect.aws.sms/SSMOutput (s/keys :opt-un [:cognitect.aws.sms.SSMOutput/s3Location]))

(s/def :cognitect.aws.sms/Subnet string?)

(s/def :cognitect.aws.sms/UserData (s/keys :opt-un [:cognitect.aws.sms.UserData/s3Location]))

(s/def :cognitect.aws.sms/ServerList (s/coll-of :cognitect.aws.sms/Server))

(s/def
  :cognitect.aws.sms/ScriptType
  (s/spec string? :gen #(s/gen #{"SHELL_SCRIPT" "POWERSHELL_SCRIPT"})))

(s/def
  :cognitect.aws.sms/StartOnDemandReplicationRunRequest
  (s/keys
    :req-un
    [:cognitect.aws.sms.StartOnDemandReplicationRunRequest/replicationJobId]
    :opt-un
    [:cognitect.aws.sms.StartOnDemandReplicationRunRequest/description]))

(s/def
  :cognitect.aws.sms/GetServersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetServersResponse/lastModifiedOn
     :cognitect.aws.sms.GetServersResponse/serverCatalogStatus
     :cognitect.aws.sms.GetServersResponse/nextToken
     :cognitect.aws.sms.GetServersResponse/serverList]))

(s/def :cognitect.aws.sms/SecurityGroup string?)

(s/def
  :cognitect.aws.sms/TotalServerGroups
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.sms/Tags (s/coll-of :cognitect.aws.sms/Tag))

(s/def
  :cognitect.aws.sms/InstanceId
  (s/spec #(re-matches (re-pattern "(^i-(\\w{8}|\\w{17})$)|(^mi-\\w{17}$)") %) :gen #(gen/string)))

(s/def :cognitect.aws.sms/AppLaunchStatusMessage string?)

(s/def :cognitect.aws.sms/InstanceType string?)

(s/def :cognitect.aws.sms/EC2KeyName string?)

(s/def
  :cognitect.aws.sms/ReplicationRunType
  (s/spec string? :gen #(s/gen #{"ON_DEMAND" "AUTOMATIC"})))

(s/def :cognitect.aws.sms/StartOnDemandAppReplicationResponse (s/keys))

(s/def :cognitect.aws.sms/StackId string?)

(s/def :cognitect.aws.sms/ServerValidationStrategy (s/spec string? :gen #(s/gen #{"USERDATA"})))

(s/def
  :cognitect.aws.sms/GetAppLaunchConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetAppLaunchConfigurationResponse/autoLaunch
     :cognitect.aws.sms.GetAppLaunchConfigurationResponse/roleName
     :cognitect.aws.sms.GetAppLaunchConfigurationResponse/appId
     :cognitect.aws.sms.GetAppLaunchConfigurationResponse/serverGroupLaunchConfigurations]))

(s/def
  :cognitect.aws.sms/ServerReplicationConfigurations
  (s/coll-of :cognitect.aws.sms/ServerReplicationConfiguration))

(s/def
  :cognitect.aws.sms/GetReplicationJobsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetReplicationJobsRequest/maxResults
     :cognitect.aws.sms.GetReplicationJobsRequest/nextToken
     :cognitect.aws.sms.GetReplicationJobsRequest/replicationJobId]))

(s/def :cognitect.aws.sms/VmPath string?)

(s/def
  :cognitect.aws.sms/ServerGroupLaunchConfigurations
  (s/coll-of :cognitect.aws.sms/ServerGroupLaunchConfiguration))

(s/def
  :cognitect.aws.sms/GetConnectorsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetConnectorsRequest/maxResults
     :cognitect.aws.sms.GetConnectorsRequest/nextToken]))

(s/def :cognitect.aws.sms/ConnectorList (s/coll-of :cognitect.aws.sms/Connector))

(s/def :cognitect.aws.sms/ServerGroups (s/coll-of :cognitect.aws.sms/ServerGroup))

(s/def :cognitect.aws.sms/ReplicationRunStageProgress string?)

(s/def :cognitect.aws.sms/ImportedAppId string?)

(s/def :cognitect.aws.sms/ReplicationJobStatusMessage string?)

(s/def
  :cognitect.aws.sms/ValidationOutput
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ValidationOutput/latestValidationTime
     :cognitect.aws.sms.ValidationOutput/name
     :cognitect.aws.sms.ValidationOutput/status
     :cognitect.aws.sms.ValidationOutput/appValidationOutput
     :cognitect.aws.sms.ValidationOutput/statusMessage
     :cognitect.aws.sms.ValidationOutput/validationId
     :cognitect.aws.sms.ValidationOutput/serverValidationOutput]))

(s/def
  :cognitect.aws.sms/S3Location
  (s/keys :opt-un [:cognitect.aws.sms.S3Location/bucket :cognitect.aws.sms.S3Location/key]))

(s/def
  :cognitect.aws.sms/AppStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"UPDATING" "DELETING" "CREATING" "ACTIVE" "DELETED" "DELETE_FAILED"})))

(s/def :cognitect.aws.sms/RoleName string?)

(s/def
  :cognitect.aws.sms/GetAppResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetAppResponse/tags
     :cognitect.aws.sms.GetAppResponse/appSummary
     :cognitect.aws.sms.GetAppResponse/serverGroups]))

(s/def
  :cognitect.aws.sms/S3KeyName
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.sms/UpdateReplicationJobResponse (s/keys))

(s/def :cognitect.aws.sms/AppReplicationStatusMessage string?)

(s/def
  :cognitect.aws.sms/ServerValidationOutput
  (s/keys :opt-un [:cognitect.aws.sms.ServerValidationOutput/server]))

(s/def :cognitect.aws.sms/TerminateAppResponse (s/keys))

(s/def :cognitect.aws.sms/NextToken string?)

(s/def
  :cognitect.aws.sms/LaunchOrder
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.sms/PutAppReplicationConfigurationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.PutAppReplicationConfigurationRequest/appId
     :cognitect.aws.sms.PutAppReplicationConfigurationRequest/serverGroupReplicationConfigurations]))

(s/def :cognitect.aws.sms/Frequency (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.sms/GetConnectorsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetConnectorsResponse/connectorList
     :cognitect.aws.sms.GetConnectorsResponse/nextToken]))

(s/def :cognitect.aws.sms/VmName string?)

(s/def :cognitect.aws.sms/ServerGroupId string?)

(s/def :cognitect.aws.sms/VmManagerId string?)

(s/def
  :cognitect.aws.sms/UpdateReplicationJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.sms.UpdateReplicationJobRequest/replicationJobId]
    :opt-un
    [:cognitect.aws.sms.UpdateReplicationJobRequest/kmsKeyId
     :cognitect.aws.sms.UpdateReplicationJobRequest/licenseType
     :cognitect.aws.sms.UpdateReplicationJobRequest/encrypted
     :cognitect.aws.sms.UpdateReplicationJobRequest/roleName
     :cognitect.aws.sms.UpdateReplicationJobRequest/nextReplicationRunStartTime
     :cognitect.aws.sms.UpdateReplicationJobRequest/description
     :cognitect.aws.sms.UpdateReplicationJobRequest/numberOfRecentAmisToKeep
     :cognitect.aws.sms.UpdateReplicationJobRequest/frequency]))

(s/def
  :cognitect.aws.sms/ServerCatalogStatus
  (s/spec string? :gen #(s/gen #{"EXPIRED" "AVAILABLE" "NOT_IMPORTED" "DELETED" "IMPORTING"})))

(s/def
  :cognitect.aws.sms/UpdateAppRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.UpdateAppRequest/tags
     :cognitect.aws.sms.UpdateAppRequest/name
     :cognitect.aws.sms.UpdateAppRequest/roleName
     :cognitect.aws.sms.UpdateAppRequest/appId
     :cognitect.aws.sms.UpdateAppRequest/serverGroups
     :cognitect.aws.sms.UpdateAppRequest/description]))

(s/def :cognitect.aws.sms/ServerId string?)

(s/def
  :cognitect.aws.sms/NumberOfRecentAmisToKeep
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.sms/CreateReplicationJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.sms.CreateReplicationJobRequest/serverId
     :cognitect.aws.sms.CreateReplicationJobRequest/seedReplicationTime]
    :opt-un
    [:cognitect.aws.sms.CreateReplicationJobRequest/kmsKeyId
     :cognitect.aws.sms.CreateReplicationJobRequest/runOnce
     :cognitect.aws.sms.CreateReplicationJobRequest/licenseType
     :cognitect.aws.sms.CreateReplicationJobRequest/encrypted
     :cognitect.aws.sms.CreateReplicationJobRequest/roleName
     :cognitect.aws.sms.CreateReplicationJobRequest/description
     :cognitect.aws.sms.CreateReplicationJobRequest/numberOfRecentAmisToKeep
     :cognitect.aws.sms.CreateReplicationJobRequest/frequency]))

(s/def :cognitect.aws.sms/VmManagerName string?)

(s/def :cognitect.aws.sms/TagValue string?)

(s/def
  :cognitect.aws.sms/GenerateTemplateResponse
  (s/keys :opt-un [:cognitect.aws.sms.GenerateTemplateResponse/s3Location]))

(s/def
  :cognitect.aws.sms/ReplicationRun
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ReplicationRun/stageDetails
     :cognitect.aws.sms.ReplicationRun/amiId
     :cognitect.aws.sms.ReplicationRun/kmsKeyId
     :cognitect.aws.sms.ReplicationRun/replicationRunId
     :cognitect.aws.sms.ReplicationRun/encrypted
     :cognitect.aws.sms.ReplicationRun/statusMessage
     :cognitect.aws.sms.ReplicationRun/type
     :cognitect.aws.sms.ReplicationRun/state
     :cognitect.aws.sms.ReplicationRun/completedTime
     :cognitect.aws.sms.ReplicationRun/description
     :cognitect.aws.sms.ReplicationRun/scheduledStartTime]))

(s/def
  :cognitect.aws.sms/UserDataValidationParameters
  (s/keys
    :opt-un
    [:cognitect.aws.sms.UserDataValidationParameters/scriptType
     :cognitect.aws.sms.UserDataValidationParameters/source]))

(s/def :cognitect.aws.sms/Encrypted boolean?)

(s/def
  :cognitect.aws.sms/GetReplicationRunsRequest
  (s/keys
    :req-un
    [:cognitect.aws.sms.GetReplicationRunsRequest/replicationJobId]
    :opt-un
    [:cognitect.aws.sms.GetReplicationRunsRequest/maxResults
     :cognitect.aws.sms.GetReplicationRunsRequest/nextToken]))

(s/def :cognitect.aws.sms/MacAddress string?)

(s/def :cognitect.aws.sms/PutAppLaunchConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.sms/LaunchDetails
  (s/keys
    :opt-un
    [:cognitect.aws.sms.LaunchDetails/stackId
     :cognitect.aws.sms.LaunchDetails/stackName
     :cognitect.aws.sms.LaunchDetails/latestLaunchTime]))

(s/def
  :cognitect.aws.sms/CreateReplicationJobResponse
  (s/keys :opt-un [:cognitect.aws.sms.CreateReplicationJobResponse/replicationJobId]))

(s/def
  :cognitect.aws.sms/CreateAppRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.CreateAppRequest/clientToken
     :cognitect.aws.sms.CreateAppRequest/tags
     :cognitect.aws.sms.CreateAppRequest/name
     :cognitect.aws.sms.CreateAppRequest/roleName
     :cognitect.aws.sms.CreateAppRequest/serverGroups
     :cognitect.aws.sms.CreateAppRequest/description]))

(s/def
  :cognitect.aws.sms/AppSummary
  (s/keys
    :opt-un
    [:cognitect.aws.sms.AppSummary/launchStatusMessage
     :cognitect.aws.sms.AppSummary/lastModified
     :cognitect.aws.sms.AppSummary/totalServerGroups
     :cognitect.aws.sms.AppSummary/launchConfigurationStatus
     :cognitect.aws.sms.AppSummary/importedAppId
     :cognitect.aws.sms.AppSummary/replicationStatus
     :cognitect.aws.sms.AppSummary/launchStatus
     :cognitect.aws.sms.AppSummary/totalServers
     :cognitect.aws.sms.AppSummary/latestReplicationTime
     :cognitect.aws.sms.AppSummary/replicationStatusMessage
     :cognitect.aws.sms.AppSummary/name
     :cognitect.aws.sms.AppSummary/replicationConfigurationStatus
     :cognitect.aws.sms.AppSummary/status
     :cognitect.aws.sms.AppSummary/launchDetails
     :cognitect.aws.sms.AppSummary/statusMessage
     :cognitect.aws.sms.AppSummary/roleName
     :cognitect.aws.sms.AppSummary/appId
     :cognitect.aws.sms.AppSummary/creationTime
     :cognitect.aws.sms.AppSummary/description]))

(s/def :cognitect.aws.sms/StartAppReplicationResponse (s/keys))

(s/def
  :cognitect.aws.sms/NotificationContext
  (s/keys
    :opt-un
    [:cognitect.aws.sms.NotificationContext/status
     :cognitect.aws.sms.NotificationContext/statusMessage
     :cognitect.aws.sms.NotificationContext/validationId]))

(s/def
  :cognitect.aws.sms/Command
  (s/spec
    (s/and string? #(<= 1 (count %) 64000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.sms/AppValidationOutput
  (s/keys :opt-un [:cognitect.aws.sms.AppValidationOutput/ssmOutput]))

(s/def
  :cognitect.aws.sms/NotifyAppValidationOutputRequest
  (s/keys
    :req-un
    [:cognitect.aws.sms.NotifyAppValidationOutputRequest/appId]
    :opt-un
    [:cognitect.aws.sms.NotifyAppValidationOutputRequest/notificationContext]))

(s/def
  :cognitect.aws.sms/GetReplicationRunsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetReplicationRunsResponse/replicationJob
     :cognitect.aws.sms.GetReplicationRunsResponse/nextToken
     :cognitect.aws.sms.GetReplicationRunsResponse/replicationRunList]))

(s/def
  :cognitect.aws.sms/ServerGroup
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ServerGroup/name
     :cognitect.aws.sms.ServerGroup/serverList
     :cognitect.aws.sms.ServerGroup/serverGroupId]))

(s/def
  :cognitect.aws.sms/LaunchAppRequest
  (s/keys :opt-un [:cognitect.aws.sms.LaunchAppRequest/appId]))

(s/def :cognitect.aws.sms/ReplicationRunStage string?)

(s/def
  :cognitect.aws.sms/GetAppValidationConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetAppValidationConfigurationResponse/appValidationConfigurations
     :cognitect.aws.sms.GetAppValidationConfigurationResponse/serverGroupValidationConfigurations]))

(s/def
  :cognitect.aws.sms/StartAppReplicationRequest
  (s/keys :opt-un [:cognitect.aws.sms.StartAppReplicationRequest/appId]))

(s/def :cognitect.aws.sms/AppIds (s/coll-of :cognitect.aws.sms/AppId))

(s/def
  :cognitect.aws.sms/ServerGroupReplicationConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ServerGroupReplicationConfiguration/serverReplicationConfigurations
     :cognitect.aws.sms.ServerGroupReplicationConfiguration/serverGroupId]))

(s/def :cognitect.aws.sms/AppValidationStrategy (s/spec string? :gen #(s/gen #{"SSM"})))

(s/def
  :cognitect.aws.sms/AppReplicationConfigurationStatus
  (s/spec string? :gen #(s/gen #{"CONFIGURED" "NOT_CONFIGURED"})))

(s/def :cognitect.aws.sms/KmsKeyId string?)

(s/def :cognitect.aws.sms/VmServerAddressList (s/coll-of :cognitect.aws.sms/VmServerAddress))

(s/def :cognitect.aws.sms/ReplicationRunList (s/coll-of :cognitect.aws.sms/ReplicationRun))

(s/def
  :cognitect.aws.sms/GenerateTemplateRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GenerateTemplateRequest/templateFormat
     :cognitect.aws.sms.GenerateTemplateRequest/appId]))

(s/def
  :cognitect.aws.sms/ListAppsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ListAppsResponse/nextToken :cognitect.aws.sms.ListAppsResponse/apps]))

(s/def :cognitect.aws.sms/AssociatePublicIpAddress boolean?)

(s/def :cognitect.aws.sms/ConnectorId string?)

(s/def
  :cognitect.aws.sms/AppLaunchStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"PARTIALLY_LAUNCHED" "CONFIGURATION_IN_PROGRESS" "TERMINATED" "LAUNCH_IN_PROGRESS"
        "VALIDATION_IN_PROGRESS" "CONFIGURATION_INVALID" "LAUNCHED" "TERMINATE_IN_PROGRESS"
        "LAUNCH_FAILED" "DELTA_LAUNCH_FAILED" "READY_FOR_LAUNCH" "READY_FOR_CONFIGURATION"
        "LAUNCH_PENDING" "TERMINATE_FAILED" "DELTA_LAUNCH_IN_PROGRESS"})))

(s/def
  :cognitect.aws.sms/ImportAppCatalogRequest
  (s/keys :opt-un [:cognitect.aws.sms.ImportAppCatalogRequest/roleName]))

(s/def :cognitect.aws.sms/AppId string?)

(s/def :cognitect.aws.sms/LicenseType (s/spec string? :gen #(s/gen #{"AWS" "BYOL"})))

(s/def
  :cognitect.aws.sms/GetAppValidationOutputRequest
  (s/keys :req-un [:cognitect.aws.sms.GetAppValidationOutputRequest/appId]))

(s/def
  :cognitect.aws.sms/ServerReplicationConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ServerReplicationConfiguration/serverReplicationParameters
     :cognitect.aws.sms.ServerReplicationConfiguration/server]))

(s/def
  :cognitect.aws.sms/UpdateAppResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.UpdateAppResponse/tags
     :cognitect.aws.sms.UpdateAppResponse/appSummary
     :cognitect.aws.sms.UpdateAppResponse/serverGroups]))

(s/def
  :cognitect.aws.sms/DeleteAppValidationConfigurationRequest
  (s/keys :req-un [:cognitect.aws.sms.DeleteAppValidationConfigurationRequest/appId]))

(s/def
  :cognitect.aws.sms/DeleteReplicationJobRequest
  (s/keys :req-un [:cognitect.aws.sms.DeleteReplicationJobRequest/replicationJobId]))

(s/def :cognitect.aws.sms/StackName string?)

(s/def
  :cognitect.aws.sms/ServerGroupValidationConfigurations
  (s/coll-of :cognitect.aws.sms/ServerGroupValidationConfiguration))

(s/def
  :cognitect.aws.sms/ServerGroupLaunchConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ServerGroupLaunchConfiguration/launchOrder
     :cognitect.aws.sms.ServerGroupLaunchConfiguration/serverLaunchConfigurations
     :cognitect.aws.sms.ServerGroupLaunchConfiguration/serverGroupId]))

(s/def
  :cognitect.aws.sms/StartOnDemandReplicationRunResponse
  (s/keys :opt-un [:cognitect.aws.sms.StartOnDemandReplicationRunResponse/replicationRunId]))

(s/def :cognitect.aws.sms/BucketName string?)

(s/def :cognitect.aws.sms/MaxResults (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.sms/TagKey string?)

(s/def
  :cognitect.aws.sms/AppReplicationStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"REPLICATION_FAILED" "DELTA_REPLICATION_FAILED" "REPLICATION_STOP_FAILED"
        "REPLICATION_PENDING" "DELTA_REPLICATION_IN_PROGRESS" "CONFIGURATION_IN_PROGRESS"
        "DELTA_REPLICATED" "VALIDATION_IN_PROGRESS" "READY_FOR_REPLICATION" "REPLICATED"
        "CONFIGURATION_INVALID" "REPLICATION_STOPPED" "REPLICATION_IN_PROGRESS"
        "PARTIALLY_REPLICATED" "REPLICATION_STOPPING" "READY_FOR_CONFIGURATION"})))

(s/def :cognitect.aws.sms/VmId string?)

(s/def :cognitect.aws.sms/ReplicationRunId string?)

(s/def
  :cognitect.aws.sms/ListAppsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ListAppsRequest/maxResults
     :cognitect.aws.sms.ListAppsRequest/nextToken
     :cognitect.aws.sms.ListAppsRequest/appIds]))

(s/def :cognitect.aws.sms/Description string?)

(s/def :cognitect.aws.sms/Apps (s/coll-of :cognitect.aws.sms/AppSummary))

(s/def
  :cognitect.aws.sms/VmManagerType
  (s/spec string? :gen #(s/gen #{"HYPERV-MANAGER" "VSPHERE" "SCVMM"})))

(s/def :cognitect.aws.sms/ConnectorVersion string?)

(s/def
  :cognitect.aws.sms/S3BucketName
  (s/spec
    (s/and string? #(<= 3 (count %) 63))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 3 63) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.sms/ClientToken string?)

(s/def
  :cognitect.aws.sms/CreateAppResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.CreateAppResponse/tags
     :cognitect.aws.sms.CreateAppResponse/appSummary
     :cognitect.aws.sms.CreateAppResponse/serverGroups]))

(s/def :cognitect.aws.sms/ReplicationJobList (s/coll-of :cognitect.aws.sms/ReplicationJob))

(s/def :cognitect.aws.sms/DeleteServerCatalogRequest (s/keys))

(s/def :cognitect.aws.sms/Timestamp inst?)

(s/def :cognitect.aws.sms/AppName string?)

(s/def :cognitect.aws.sms/ForceTerminateApp boolean?)

(s/def
  :cognitect.aws.sms/DeleteAppReplicationConfigurationRequest
  (s/keys :opt-un [:cognitect.aws.sms.DeleteAppReplicationConfigurationRequest/appId]))

(s/def
  :cognitect.aws.sms/ValidationId
  (s/spec #(re-matches (re-pattern "^val-[0-9a-f]{17}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.sms/ReplicationRunState
  (s/spec
    string?
    :gen
    #(s/gen #{"COMPLETED" "MISSED" "PENDING" "DELETING" "ACTIVE" "FAILED" "DELETED"})))

(s/def :cognitect.aws.sms/Source (s/keys :opt-un [:cognitect.aws.sms.Source/s3Location]))

(s/def :cognitect.aws.sms/NotifyAppValidationOutputResponse (s/keys))

(s/def :cognitect.aws.sms/ImportServerCatalogRequest (s/keys))

(s/def :cognitect.aws.sms/AppDescription string?)

(s/def
  :cognitect.aws.sms/StopAppReplicationRequest
  (s/keys :opt-un [:cognitect.aws.sms.StopAppReplicationRequest/appId]))

(s/def
  :cognitect.aws.sms/GetReplicationJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetReplicationJobsResponse/nextToken
     :cognitect.aws.sms.GetReplicationJobsResponse/replicationJobList]))

(s/def
  :cognitect.aws.sms/ServerLaunchConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ServerLaunchConfiguration/logicalId
     :cognitect.aws.sms.ServerLaunchConfiguration/associatePublicIpAddress
     :cognitect.aws.sms.ServerLaunchConfiguration/iamInstanceProfileName
     :cognitect.aws.sms.ServerLaunchConfiguration/subnet
     :cognitect.aws.sms.ServerLaunchConfiguration/vpc
     :cognitect.aws.sms.ServerLaunchConfiguration/ec2KeyName
     :cognitect.aws.sms.ServerLaunchConfiguration/server
     :cognitect.aws.sms.ServerLaunchConfiguration/configureScript
     :cognitect.aws.sms.ServerLaunchConfiguration/userData
     :cognitect.aws.sms.ServerLaunchConfiguration/securityGroup
     :cognitect.aws.sms.ServerLaunchConfiguration/instanceType
     :cognitect.aws.sms.ServerLaunchConfiguration/configureScriptType]))

(s/def :cognitect.aws.sms/ReplicationJobId string?)

(s/def :cognitect.aws.sms/ForceStopAppReplication boolean?)

(s/def
  :cognitect.aws.sms/Connector
  (s/keys
    :opt-un
    [:cognitect.aws.sms.Connector/vmManagerId
     :cognitect.aws.sms.Connector/vmManagerType
     :cognitect.aws.sms.Connector/capabilityList
     :cognitect.aws.sms.Connector/vmManagerName
     :cognitect.aws.sms.Connector/connectorId
     :cognitect.aws.sms.Connector/macAddress
     :cognitect.aws.sms.Connector/associatedOn
     :cognitect.aws.sms.Connector/status
     :cognitect.aws.sms.Connector/version
     :cognitect.aws.sms.Connector/ipAddress]))

(s/def :cognitect.aws.sms/RunOnce boolean?)

(s/def
  :cognitect.aws.sms/NonEmptyStringWithMaxLen255
  (s/spec #(re-matches (re-pattern "^[\\S]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.sms/GetAppReplicationConfigurationRequest
  (s/keys :opt-un [:cognitect.aws.sms.GetAppReplicationConfigurationRequest/appId]))

(s/def
  :cognitect.aws.sms/ReplicationJob
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ReplicationJob/kmsKeyId
     :cognitect.aws.sms.ReplicationJob/runOnce
     :cognitect.aws.sms.ReplicationJob/licenseType
     :cognitect.aws.sms.ReplicationJob/seedReplicationTime
     :cognitect.aws.sms.ReplicationJob/encrypted
     :cognitect.aws.sms.ReplicationJob/serverType
     :cognitect.aws.sms.ReplicationJob/latestAmiId
     :cognitect.aws.sms.ReplicationJob/statusMessage
     :cognitect.aws.sms.ReplicationJob/replicationRunList
     :cognitect.aws.sms.ReplicationJob/roleName
     :cognitect.aws.sms.ReplicationJob/nextReplicationRunStartTime
     :cognitect.aws.sms.ReplicationJob/vmServer
     :cognitect.aws.sms.ReplicationJob/serverId
     :cognitect.aws.sms.ReplicationJob/state
     :cognitect.aws.sms.ReplicationJob/replicationJobId
     :cognitect.aws.sms.ReplicationJob/description
     :cognitect.aws.sms.ReplicationJob/numberOfRecentAmisToKeep
     :cognitect.aws.sms.ReplicationJob/frequency]))

(s/def :cognitect.aws.sms/DeleteServerCatalogResponse (s/keys))

(s/def :cognitect.aws.sms/DeleteAppResponse (s/keys))

(s/def :cognitect.aws.sms/ServerType (s/spec string? :gen #(s/gen #{"VIRTUAL_MACHINE"})))

(s/def :cognitect.aws.sms/PutAppValidationConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.sms/TerminateAppRequest
  (s/keys :opt-un [:cognitect.aws.sms.TerminateAppRequest/appId]))

(s/def
  :cognitect.aws.sms/ServerGroupValidationConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.sms.ServerGroupValidationConfiguration/serverValidationConfigurations
     :cognitect.aws.sms.ServerGroupValidationConfiguration/serverGroupId]))

(s/def :cognitect.aws.sms/GetAppRequest (s/keys :opt-un [:cognitect.aws.sms.GetAppRequest/appId]))

(s/def
  :cognitect.aws.sms/ServerGroupReplicationConfigurations
  (s/coll-of :cognitect.aws.sms/ServerGroupReplicationConfiguration))

(s/def :cognitect.aws.sms/StopAppReplicationResponse (s/keys))

(s/def
  :cognitect.aws.sms/ServerValidationConfigurations
  (s/coll-of :cognitect.aws.sms/ServerValidationConfiguration))

(s/def
  :cognitect.aws.sms/ConnectorCapability
  (s/spec
    string?
    :gen
    #(s/gen #{"SMS_OPTIMIZED" "HYPERV-MANAGER" "VSPHERE" "SCVMM" "SNAPSHOT_BATCHING"})))

(s/def
  :cognitect.aws.sms/PutAppLaunchConfigurationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.PutAppLaunchConfigurationRequest/autoLaunch
     :cognitect.aws.sms.PutAppLaunchConfigurationRequest/roleName
     :cognitect.aws.sms.PutAppLaunchConfigurationRequest/appId
     :cognitect.aws.sms.PutAppLaunchConfigurationRequest/serverGroupLaunchConfigurations]))

(s/def :cognitect.aws.sms/ReplicationRunStatusMessage string?)

(s/def :cognitect.aws.sms/DeleteAppValidationConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.sms/GetAppLaunchConfigurationRequest
  (s/keys :opt-un [:cognitect.aws.sms.GetAppLaunchConfigurationRequest/appId]))

(s/def
  :cognitect.aws.sms/GetServersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sms.GetServersRequest/maxResults
     :cognitect.aws.sms.GetServersRequest/nextToken
     :cognitect.aws.sms.GetServersRequest/vmServerAddressList]))

(s/def
  :cognitect.aws.sms/AppLaunchConfigurationStatus
  (s/spec string? :gen #(s/gen #{"CONFIGURED" "NOT_CONFIGURED"})))

(s/def
  :cognitect.aws.sms/GetAppValidationOutputResponse
  (s/keys :opt-un [:cognitect.aws.sms.GetAppValidationOutputResponse/validationOutputList]))

(s/def
  :cognitect.aws.sms.GetAppReplicationConfigurationResponse/serverGroupReplicationConfigurations
  :cognitect.aws.sms/ServerGroupReplicationConfigurations)

(s/def :cognitect.aws.sms.DeleteAppLaunchConfigurationRequest/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.ServerReplicationParameters/seedTime :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.ServerReplicationParameters/frequency :cognitect.aws.sms/Frequency)

(s/def :cognitect.aws.sms.ServerReplicationParameters/runOnce :cognitect.aws.sms/RunOnce)

(s/def :cognitect.aws.sms.ServerReplicationParameters/licenseType :cognitect.aws.sms/LicenseType)

(s/def
  :cognitect.aws.sms.ServerReplicationParameters/numberOfRecentAmisToKeep
  :cognitect.aws.sms/NumberOfRecentAmisToKeep)

(s/def :cognitect.aws.sms.ServerReplicationParameters/encrypted :cognitect.aws.sms/Encrypted)

(s/def :cognitect.aws.sms.ServerReplicationParameters/kmsKeyId :cognitect.aws.sms/KmsKeyId)

(s/def :cognitect.aws.sms.GenerateChangeSetRequest/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.GenerateChangeSetRequest/changesetFormat :cognitect.aws.sms/OutputFormat)

(s/def :cognitect.aws.sms.Tag/key :cognitect.aws.sms/TagKey)

(s/def :cognitect.aws.sms.Tag/value :cognitect.aws.sms/TagValue)

(s/def :cognitect.aws.sms.ReplicationRunStageDetails/stage :cognitect.aws.sms/ReplicationRunStage)

(s/def
  :cognitect.aws.sms.ReplicationRunStageDetails/stageProgress
  :cognitect.aws.sms/ReplicationRunStageProgress)

(s/def :cognitect.aws.sms.GenerateChangeSetResponse/s3Location :cognitect.aws.sms/S3Location)

(s/def :cognitect.aws.sms.SSMValidationParameters/source :cognitect.aws.sms/Source)

(s/def :cognitect.aws.sms.SSMValidationParameters/instanceId :cognitect.aws.sms/InstanceId)

(s/def :cognitect.aws.sms.SSMValidationParameters/scriptType :cognitect.aws.sms/ScriptType)

(s/def :cognitect.aws.sms.SSMValidationParameters/command :cognitect.aws.sms/Command)

(s/def
  :cognitect.aws.sms.SSMValidationParameters/executionTimeoutSeconds
  :cognitect.aws.sms/ExecutionTimeoutSeconds)

(s/def :cognitect.aws.sms.SSMValidationParameters/outputS3BucketName :cognitect.aws.sms/BucketName)

(s/def :cognitect.aws.sms.AppValidationConfiguration/validationId :cognitect.aws.sms/ValidationId)

(s/def
  :cognitect.aws.sms.AppValidationConfiguration/name
  :cognitect.aws.sms/NonEmptyStringWithMaxLen255)

(s/def
  :cognitect.aws.sms.AppValidationConfiguration/appValidationStrategy
  :cognitect.aws.sms/AppValidationStrategy)

(s/def
  :cognitect.aws.sms.AppValidationConfiguration/ssmValidationParameters
  :cognitect.aws.sms/SSMValidationParameters)

(s/def :cognitect.aws.sms.VmServerAddress/vmManagerId :cognitect.aws.sms/VmManagerId)

(s/def :cognitect.aws.sms.VmServerAddress/vmId :cognitect.aws.sms/VmId)

(s/def :cognitect.aws.sms.Server/serverId :cognitect.aws.sms/ServerId)

(s/def :cognitect.aws.sms.Server/serverType :cognitect.aws.sms/ServerType)

(s/def :cognitect.aws.sms.Server/vmServer :cognitect.aws.sms/VmServer)

(s/def :cognitect.aws.sms.Server/replicationJobId :cognitect.aws.sms/ReplicationJobId)

(s/def
  :cognitect.aws.sms.Server/replicationJobTerminated
  :cognitect.aws.sms/ReplicationJobTerminated)

(s/def :cognitect.aws.sms.DeleteAppRequest/appId :cognitect.aws.sms/AppId)

(s/def
  :cognitect.aws.sms.DeleteAppRequest/forceStopAppReplication
  :cognitect.aws.sms/ForceStopAppReplication)

(s/def :cognitect.aws.sms.DeleteAppRequest/forceTerminateApp :cognitect.aws.sms/ForceTerminateApp)

(s/def
  :cognitect.aws.sms.PutAppValidationConfigurationRequest/appId
  :cognitect.aws.sms/AppIdWithValidation)

(s/def
  :cognitect.aws.sms.PutAppValidationConfigurationRequest/appValidationConfigurations
  :cognitect.aws.sms/AppValidationConfigurations)

(s/def
  :cognitect.aws.sms.PutAppValidationConfigurationRequest/serverGroupValidationConfigurations
  :cognitect.aws.sms/ServerGroupValidationConfigurations)

(s/def :cognitect.aws.sms.ServerValidationConfiguration/server :cognitect.aws.sms/Server)

(s/def
  :cognitect.aws.sms.ServerValidationConfiguration/validationId
  :cognitect.aws.sms/ValidationId)

(s/def
  :cognitect.aws.sms.ServerValidationConfiguration/name
  :cognitect.aws.sms/NonEmptyStringWithMaxLen255)

(s/def
  :cognitect.aws.sms.ServerValidationConfiguration/serverValidationStrategy
  :cognitect.aws.sms/ServerValidationStrategy)

(s/def
  :cognitect.aws.sms.ServerValidationConfiguration/userDataValidationParameters
  :cognitect.aws.sms/UserDataValidationParameters)

(s/def
  :cognitect.aws.sms.GetAppValidationConfigurationRequest/appId
  :cognitect.aws.sms/AppIdWithValidation)

(s/def :cognitect.aws.sms.StartOnDemandAppReplicationRequest/appId :cognitect.aws.sms/AppId)

(s/def
  :cognitect.aws.sms.StartOnDemandAppReplicationRequest/description
  :cognitect.aws.sms/Description)

(s/def :cognitect.aws.sms.VmServer/vmServerAddress :cognitect.aws.sms/VmServerAddress)

(s/def :cognitect.aws.sms.VmServer/vmName :cognitect.aws.sms/VmName)

(s/def :cognitect.aws.sms.VmServer/vmManagerName :cognitect.aws.sms/VmManagerName)

(s/def :cognitect.aws.sms.VmServer/vmManagerType :cognitect.aws.sms/VmManagerType)

(s/def :cognitect.aws.sms.VmServer/vmPath :cognitect.aws.sms/VmPath)

(s/def :cognitect.aws.sms.DisassociateConnectorRequest/connectorId :cognitect.aws.sms/ConnectorId)

(s/def :cognitect.aws.sms.SSMOutput/s3Location :cognitect.aws.sms/S3Location)

(s/def :cognitect.aws.sms.UserData/s3Location :cognitect.aws.sms/S3Location)

(s/def
  :cognitect.aws.sms.StartOnDemandReplicationRunRequest/replicationJobId
  :cognitect.aws.sms/ReplicationJobId)

(s/def
  :cognitect.aws.sms.StartOnDemandReplicationRunRequest/description
  :cognitect.aws.sms/Description)

(s/def :cognitect.aws.sms.GetServersResponse/lastModifiedOn :cognitect.aws.sms/Timestamp)

(s/def
  :cognitect.aws.sms.GetServersResponse/serverCatalogStatus
  :cognitect.aws.sms/ServerCatalogStatus)

(s/def :cognitect.aws.sms.GetServersResponse/serverList :cognitect.aws.sms/ServerList)

(s/def :cognitect.aws.sms.GetServersResponse/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.GetAppLaunchConfigurationResponse/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.GetAppLaunchConfigurationResponse/roleName :cognitect.aws.sms/RoleName)

(s/def
  :cognitect.aws.sms.GetAppLaunchConfigurationResponse/autoLaunch
  :cognitect.aws.sms/AutoLaunch)

(s/def
  :cognitect.aws.sms.GetAppLaunchConfigurationResponse/serverGroupLaunchConfigurations
  :cognitect.aws.sms/ServerGroupLaunchConfigurations)

(s/def
  :cognitect.aws.sms.GetReplicationJobsRequest/replicationJobId
  :cognitect.aws.sms/ReplicationJobId)

(s/def :cognitect.aws.sms.GetReplicationJobsRequest/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.GetReplicationJobsRequest/maxResults :cognitect.aws.sms/MaxResults)

(s/def :cognitect.aws.sms.GetConnectorsRequest/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.GetConnectorsRequest/maxResults :cognitect.aws.sms/MaxResults)

(s/def :cognitect.aws.sms.ValidationOutput/validationId :cognitect.aws.sms/ValidationId)

(s/def :cognitect.aws.sms.ValidationOutput/name :cognitect.aws.sms/NonEmptyStringWithMaxLen255)

(s/def :cognitect.aws.sms.ValidationOutput/status :cognitect.aws.sms/ValidationStatus)

(s/def :cognitect.aws.sms.ValidationOutput/statusMessage :cognitect.aws.sms/ValidationStatusMessage)

(s/def :cognitect.aws.sms.ValidationOutput/latestValidationTime :cognitect.aws.sms/Timestamp)

(s/def
  :cognitect.aws.sms.ValidationOutput/appValidationOutput
  :cognitect.aws.sms/AppValidationOutput)

(s/def
  :cognitect.aws.sms.ValidationOutput/serverValidationOutput
  :cognitect.aws.sms/ServerValidationOutput)

(s/def :cognitect.aws.sms.S3Location/bucket :cognitect.aws.sms/S3BucketName)

(s/def :cognitect.aws.sms.S3Location/key :cognitect.aws.sms/S3KeyName)

(s/def :cognitect.aws.sms.GetAppResponse/appSummary :cognitect.aws.sms/AppSummary)

(s/def :cognitect.aws.sms.GetAppResponse/serverGroups :cognitect.aws.sms/ServerGroups)

(s/def :cognitect.aws.sms.GetAppResponse/tags :cognitect.aws.sms/Tags)

(s/def :cognitect.aws.sms.ServerValidationOutput/server :cognitect.aws.sms/Server)

(s/def :cognitect.aws.sms.PutAppReplicationConfigurationRequest/appId :cognitect.aws.sms/AppId)

(s/def
  :cognitect.aws.sms.PutAppReplicationConfigurationRequest/serverGroupReplicationConfigurations
  :cognitect.aws.sms/ServerGroupReplicationConfigurations)

(s/def :cognitect.aws.sms.GetConnectorsResponse/connectorList :cognitect.aws.sms/ConnectorList)

(s/def :cognitect.aws.sms.GetConnectorsResponse/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.UpdateReplicationJobRequest/roleName :cognitect.aws.sms/RoleName)

(s/def :cognitect.aws.sms.UpdateReplicationJobRequest/description :cognitect.aws.sms/Description)

(s/def :cognitect.aws.sms.UpdateReplicationJobRequest/licenseType :cognitect.aws.sms/LicenseType)

(s/def
  :cognitect.aws.sms.UpdateReplicationJobRequest/replicationJobId
  :cognitect.aws.sms/ReplicationJobId)

(s/def :cognitect.aws.sms.UpdateReplicationJobRequest/kmsKeyId :cognitect.aws.sms/KmsKeyId)

(s/def
  :cognitect.aws.sms.UpdateReplicationJobRequest/numberOfRecentAmisToKeep
  :cognitect.aws.sms/NumberOfRecentAmisToKeep)

(s/def :cognitect.aws.sms.UpdateReplicationJobRequest/frequency :cognitect.aws.sms/Frequency)

(s/def
  :cognitect.aws.sms.UpdateReplicationJobRequest/nextReplicationRunStartTime
  :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.UpdateReplicationJobRequest/encrypted :cognitect.aws.sms/Encrypted)

(s/def :cognitect.aws.sms.UpdateAppRequest/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.UpdateAppRequest/name :cognitect.aws.sms/AppName)

(s/def :cognitect.aws.sms.UpdateAppRequest/description :cognitect.aws.sms/AppDescription)

(s/def :cognitect.aws.sms.UpdateAppRequest/roleName :cognitect.aws.sms/RoleName)

(s/def :cognitect.aws.sms.UpdateAppRequest/serverGroups :cognitect.aws.sms/ServerGroups)

(s/def :cognitect.aws.sms.UpdateAppRequest/tags :cognitect.aws.sms/Tags)

(s/def :cognitect.aws.sms.CreateReplicationJobRequest/roleName :cognitect.aws.sms/RoleName)

(s/def :cognitect.aws.sms.CreateReplicationJobRequest/description :cognitect.aws.sms/Description)

(s/def :cognitect.aws.sms.CreateReplicationJobRequest/licenseType :cognitect.aws.sms/LicenseType)

(s/def :cognitect.aws.sms.CreateReplicationJobRequest/kmsKeyId :cognitect.aws.sms/KmsKeyId)

(s/def :cognitect.aws.sms.CreateReplicationJobRequest/serverId :cognitect.aws.sms/ServerId)

(s/def
  :cognitect.aws.sms.CreateReplicationJobRequest/numberOfRecentAmisToKeep
  :cognitect.aws.sms/NumberOfRecentAmisToKeep)

(s/def :cognitect.aws.sms.CreateReplicationJobRequest/frequency :cognitect.aws.sms/Frequency)

(s/def
  :cognitect.aws.sms.CreateReplicationJobRequest/seedReplicationTime
  :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.CreateReplicationJobRequest/encrypted :cognitect.aws.sms/Encrypted)

(s/def :cognitect.aws.sms.CreateReplicationJobRequest/runOnce :cognitect.aws.sms/RunOnce)

(s/def :cognitect.aws.sms.GenerateTemplateResponse/s3Location :cognitect.aws.sms/S3Location)

(s/def :cognitect.aws.sms.ReplicationRun/description :cognitect.aws.sms/Description)

(s/def :cognitect.aws.sms.ReplicationRun/kmsKeyId :cognitect.aws.sms/KmsKeyId)

(s/def
  :cognitect.aws.sms.ReplicationRun/statusMessage
  :cognitect.aws.sms/ReplicationRunStatusMessage)

(s/def :cognitect.aws.sms.ReplicationRun/type :cognitect.aws.sms/ReplicationRunType)

(s/def :cognitect.aws.sms.ReplicationRun/state :cognitect.aws.sms/ReplicationRunState)

(s/def :cognitect.aws.sms.ReplicationRun/amiId :cognitect.aws.sms/AmiId)

(s/def :cognitect.aws.sms.ReplicationRun/completedTime :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.ReplicationRun/replicationRunId :cognitect.aws.sms/ReplicationRunId)

(s/def :cognitect.aws.sms.ReplicationRun/encrypted :cognitect.aws.sms/Encrypted)

(s/def :cognitect.aws.sms.ReplicationRun/scheduledStartTime :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.ReplicationRun/stageDetails :cognitect.aws.sms/ReplicationRunStageDetails)

(s/def :cognitect.aws.sms.UserDataValidationParameters/source :cognitect.aws.sms/Source)

(s/def :cognitect.aws.sms.UserDataValidationParameters/scriptType :cognitect.aws.sms/ScriptType)

(s/def
  :cognitect.aws.sms.GetReplicationRunsRequest/replicationJobId
  :cognitect.aws.sms/ReplicationJobId)

(s/def :cognitect.aws.sms.GetReplicationRunsRequest/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.GetReplicationRunsRequest/maxResults :cognitect.aws.sms/MaxResults)

(s/def :cognitect.aws.sms.LaunchDetails/latestLaunchTime :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.LaunchDetails/stackName :cognitect.aws.sms/StackName)

(s/def :cognitect.aws.sms.LaunchDetails/stackId :cognitect.aws.sms/StackId)

(s/def
  :cognitect.aws.sms.CreateReplicationJobResponse/replicationJobId
  :cognitect.aws.sms/ReplicationJobId)

(s/def :cognitect.aws.sms.CreateAppRequest/name :cognitect.aws.sms/AppName)

(s/def :cognitect.aws.sms.CreateAppRequest/description :cognitect.aws.sms/AppDescription)

(s/def :cognitect.aws.sms.CreateAppRequest/roleName :cognitect.aws.sms/RoleName)

(s/def :cognitect.aws.sms.CreateAppRequest/clientToken :cognitect.aws.sms/ClientToken)

(s/def :cognitect.aws.sms.CreateAppRequest/serverGroups :cognitect.aws.sms/ServerGroups)

(s/def :cognitect.aws.sms.CreateAppRequest/tags :cognitect.aws.sms/Tags)

(s/def :cognitect.aws.sms.AppSummary/totalServers :cognitect.aws.sms/TotalServers)

(s/def :cognitect.aws.sms.AppSummary/roleName :cognitect.aws.sms/RoleName)

(s/def :cognitect.aws.sms.AppSummary/creationTime :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.AppSummary/description :cognitect.aws.sms/AppDescription)

(s/def
  :cognitect.aws.sms.AppSummary/launchConfigurationStatus
  :cognitect.aws.sms/AppLaunchConfigurationStatus)

(s/def :cognitect.aws.sms.AppSummary/launchDetails :cognitect.aws.sms/LaunchDetails)

(s/def
  :cognitect.aws.sms.AppSummary/replicationConfigurationStatus
  :cognitect.aws.sms/AppReplicationConfigurationStatus)

(s/def :cognitect.aws.sms.AppSummary/name :cognitect.aws.sms/AppName)

(s/def :cognitect.aws.sms.AppSummary/totalServerGroups :cognitect.aws.sms/TotalServerGroups)

(s/def :cognitect.aws.sms.AppSummary/statusMessage :cognitect.aws.sms/AppStatusMessage)

(s/def :cognitect.aws.sms.AppSummary/importedAppId :cognitect.aws.sms/ImportedAppId)

(s/def :cognitect.aws.sms.AppSummary/launchStatusMessage :cognitect.aws.sms/AppLaunchStatusMessage)

(s/def :cognitect.aws.sms.AppSummary/replicationStatus :cognitect.aws.sms/AppReplicationStatus)

(s/def :cognitect.aws.sms.AppSummary/lastModified :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.AppSummary/status :cognitect.aws.sms/AppStatus)

(s/def :cognitect.aws.sms.AppSummary/launchStatus :cognitect.aws.sms/AppLaunchStatus)

(s/def
  :cognitect.aws.sms.AppSummary/replicationStatusMessage
  :cognitect.aws.sms/AppReplicationStatusMessage)

(s/def :cognitect.aws.sms.AppSummary/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.AppSummary/latestReplicationTime :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.NotificationContext/validationId :cognitect.aws.sms/ValidationId)

(s/def :cognitect.aws.sms.NotificationContext/status :cognitect.aws.sms/ValidationStatus)

(s/def
  :cognitect.aws.sms.NotificationContext/statusMessage
  :cognitect.aws.sms/ValidationStatusMessage)

(s/def :cognitect.aws.sms.AppValidationOutput/ssmOutput :cognitect.aws.sms/SSMOutput)

(s/def
  :cognitect.aws.sms.NotifyAppValidationOutputRequest/appId
  :cognitect.aws.sms/AppIdWithValidation)

(s/def
  :cognitect.aws.sms.NotifyAppValidationOutputRequest/notificationContext
  :cognitect.aws.sms/NotificationContext)

(s/def
  :cognitect.aws.sms.GetReplicationRunsResponse/replicationJob
  :cognitect.aws.sms/ReplicationJob)

(s/def
  :cognitect.aws.sms.GetReplicationRunsResponse/replicationRunList
  :cognitect.aws.sms/ReplicationRunList)

(s/def :cognitect.aws.sms.GetReplicationRunsResponse/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.ServerGroup/serverGroupId :cognitect.aws.sms/ServerGroupId)

(s/def :cognitect.aws.sms.ServerGroup/name :cognitect.aws.sms/ServerGroupName)

(s/def :cognitect.aws.sms.ServerGroup/serverList :cognitect.aws.sms/ServerList)

(s/def :cognitect.aws.sms.LaunchAppRequest/appId :cognitect.aws.sms/AppId)

(s/def
  :cognitect.aws.sms.GetAppValidationConfigurationResponse/appValidationConfigurations
  :cognitect.aws.sms/AppValidationConfigurations)

(s/def
  :cognitect.aws.sms.GetAppValidationConfigurationResponse/serverGroupValidationConfigurations
  :cognitect.aws.sms/ServerGroupValidationConfigurations)

(s/def :cognitect.aws.sms.StartAppReplicationRequest/appId :cognitect.aws.sms/AppId)

(s/def
  :cognitect.aws.sms.ServerGroupReplicationConfiguration/serverGroupId
  :cognitect.aws.sms/ServerGroupId)

(s/def
  :cognitect.aws.sms.ServerGroupReplicationConfiguration/serverReplicationConfigurations
  :cognitect.aws.sms/ServerReplicationConfigurations)

(s/def :cognitect.aws.sms.GenerateTemplateRequest/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.GenerateTemplateRequest/templateFormat :cognitect.aws.sms/OutputFormat)

(s/def :cognitect.aws.sms.ListAppsResponse/apps :cognitect.aws.sms/Apps)

(s/def :cognitect.aws.sms.ListAppsResponse/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.ImportAppCatalogRequest/roleName :cognitect.aws.sms/RoleName)

(s/def
  :cognitect.aws.sms.GetAppValidationOutputRequest/appId
  :cognitect.aws.sms/AppIdWithValidation)

(s/def :cognitect.aws.sms.ServerReplicationConfiguration/server :cognitect.aws.sms/Server)

(s/def
  :cognitect.aws.sms.ServerReplicationConfiguration/serverReplicationParameters
  :cognitect.aws.sms/ServerReplicationParameters)

(s/def :cognitect.aws.sms.UpdateAppResponse/appSummary :cognitect.aws.sms/AppSummary)

(s/def :cognitect.aws.sms.UpdateAppResponse/serverGroups :cognitect.aws.sms/ServerGroups)

(s/def :cognitect.aws.sms.UpdateAppResponse/tags :cognitect.aws.sms/Tags)

(s/def
  :cognitect.aws.sms.DeleteAppValidationConfigurationRequest/appId
  :cognitect.aws.sms/AppIdWithValidation)

(s/def
  :cognitect.aws.sms.DeleteReplicationJobRequest/replicationJobId
  :cognitect.aws.sms/ReplicationJobId)

(s/def
  :cognitect.aws.sms.ServerGroupLaunchConfiguration/serverGroupId
  :cognitect.aws.sms/ServerGroupId)

(s/def :cognitect.aws.sms.ServerGroupLaunchConfiguration/launchOrder :cognitect.aws.sms/LaunchOrder)

(s/def
  :cognitect.aws.sms.ServerGroupLaunchConfiguration/serverLaunchConfigurations
  :cognitect.aws.sms/ServerLaunchConfigurations)

(s/def
  :cognitect.aws.sms.StartOnDemandReplicationRunResponse/replicationRunId
  :cognitect.aws.sms/ReplicationRunId)

(s/def :cognitect.aws.sms.ListAppsRequest/appIds :cognitect.aws.sms/AppIds)

(s/def :cognitect.aws.sms.ListAppsRequest/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.ListAppsRequest/maxResults :cognitect.aws.sms/MaxResults)

(s/def :cognitect.aws.sms.CreateAppResponse/appSummary :cognitect.aws.sms/AppSummary)

(s/def :cognitect.aws.sms.CreateAppResponse/serverGroups :cognitect.aws.sms/ServerGroups)

(s/def :cognitect.aws.sms.CreateAppResponse/tags :cognitect.aws.sms/Tags)

(s/def :cognitect.aws.sms.DeleteAppReplicationConfigurationRequest/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.Source/s3Location :cognitect.aws.sms/S3Location)

(s/def :cognitect.aws.sms.StopAppReplicationRequest/appId :cognitect.aws.sms/AppId)

(s/def
  :cognitect.aws.sms.GetReplicationJobsResponse/replicationJobList
  :cognitect.aws.sms/ReplicationJobList)

(s/def :cognitect.aws.sms.GetReplicationJobsResponse/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.ServerLaunchConfiguration/ec2KeyName :cognitect.aws.sms/EC2KeyName)

(s/def :cognitect.aws.sms.ServerLaunchConfiguration/userData :cognitect.aws.sms/UserData)

(s/def
  :cognitect.aws.sms.ServerLaunchConfiguration/associatePublicIpAddress
  :cognitect.aws.sms/AssociatePublicIpAddress)

(s/def :cognitect.aws.sms.ServerLaunchConfiguration/instanceType :cognitect.aws.sms/InstanceType)

(s/def :cognitect.aws.sms.ServerLaunchConfiguration/server :cognitect.aws.sms/Server)

(s/def
  :cognitect.aws.sms.ServerLaunchConfiguration/configureScriptType
  :cognitect.aws.sms/ScriptType)

(s/def
  :cognitect.aws.sms.ServerLaunchConfiguration/iamInstanceProfileName
  :cognitect.aws.sms/RoleName)

(s/def :cognitect.aws.sms.ServerLaunchConfiguration/vpc :cognitect.aws.sms/VPC)

(s/def :cognitect.aws.sms.ServerLaunchConfiguration/securityGroup :cognitect.aws.sms/SecurityGroup)

(s/def :cognitect.aws.sms.ServerLaunchConfiguration/configureScript :cognitect.aws.sms/S3Location)

(s/def :cognitect.aws.sms.ServerLaunchConfiguration/subnet :cognitect.aws.sms/Subnet)

(s/def :cognitect.aws.sms.ServerLaunchConfiguration/logicalId :cognitect.aws.sms/LogicalId)

(s/def :cognitect.aws.sms.Connector/macAddress :cognitect.aws.sms/MacAddress)

(s/def :cognitect.aws.sms.Connector/vmManagerType :cognitect.aws.sms/VmManagerType)

(s/def :cognitect.aws.sms.Connector/capabilityList :cognitect.aws.sms/ConnectorCapabilityList)

(s/def :cognitect.aws.sms.Connector/vmManagerId :cognitect.aws.sms/VmManagerId)

(s/def :cognitect.aws.sms.Connector/status :cognitect.aws.sms/ConnectorStatus)

(s/def :cognitect.aws.sms.Connector/ipAddress :cognitect.aws.sms/IpAddress)

(s/def :cognitect.aws.sms.Connector/version :cognitect.aws.sms/ConnectorVersion)

(s/def :cognitect.aws.sms.Connector/connectorId :cognitect.aws.sms/ConnectorId)

(s/def :cognitect.aws.sms.Connector/associatedOn :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.Connector/vmManagerName :cognitect.aws.sms/VmManagerName)

(s/def :cognitect.aws.sms.GetAppReplicationConfigurationRequest/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.ReplicationJob/roleName :cognitect.aws.sms/RoleName)

(s/def :cognitect.aws.sms.ReplicationJob/description :cognitect.aws.sms/Description)

(s/def :cognitect.aws.sms.ReplicationJob/licenseType :cognitect.aws.sms/LicenseType)

(s/def :cognitect.aws.sms.ReplicationJob/replicationJobId :cognitect.aws.sms/ReplicationJobId)

(s/def :cognitect.aws.sms.ReplicationJob/kmsKeyId :cognitect.aws.sms/KmsKeyId)

(s/def :cognitect.aws.sms.ReplicationJob/serverId :cognitect.aws.sms/ServerId)

(s/def
  :cognitect.aws.sms.ReplicationJob/numberOfRecentAmisToKeep
  :cognitect.aws.sms/NumberOfRecentAmisToKeep)

(s/def
  :cognitect.aws.sms.ReplicationJob/statusMessage
  :cognitect.aws.sms/ReplicationJobStatusMessage)

(s/def :cognitect.aws.sms.ReplicationJob/frequency :cognitect.aws.sms/Frequency)

(s/def :cognitect.aws.sms.ReplicationJob/state :cognitect.aws.sms/ReplicationJobState)

(s/def :cognitect.aws.sms.ReplicationJob/vmServer :cognitect.aws.sms/VmServer)

(s/def :cognitect.aws.sms.ReplicationJob/replicationRunList :cognitect.aws.sms/ReplicationRunList)

(s/def :cognitect.aws.sms.ReplicationJob/serverType :cognitect.aws.sms/ServerType)

(s/def :cognitect.aws.sms.ReplicationJob/seedReplicationTime :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.ReplicationJob/latestAmiId :cognitect.aws.sms/AmiId)

(s/def :cognitect.aws.sms.ReplicationJob/nextReplicationRunStartTime :cognitect.aws.sms/Timestamp)

(s/def :cognitect.aws.sms.ReplicationJob/encrypted :cognitect.aws.sms/Encrypted)

(s/def :cognitect.aws.sms.ReplicationJob/runOnce :cognitect.aws.sms/RunOnce)

(s/def :cognitect.aws.sms.TerminateAppRequest/appId :cognitect.aws.sms/AppId)

(s/def
  :cognitect.aws.sms.ServerGroupValidationConfiguration/serverGroupId
  :cognitect.aws.sms/ServerGroupId)

(s/def
  :cognitect.aws.sms.ServerGroupValidationConfiguration/serverValidationConfigurations
  :cognitect.aws.sms/ServerValidationConfigurations)

(s/def :cognitect.aws.sms.GetAppRequest/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.PutAppLaunchConfigurationRequest/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.PutAppLaunchConfigurationRequest/roleName :cognitect.aws.sms/RoleName)

(s/def :cognitect.aws.sms.PutAppLaunchConfigurationRequest/autoLaunch :cognitect.aws.sms/AutoLaunch)

(s/def
  :cognitect.aws.sms.PutAppLaunchConfigurationRequest/serverGroupLaunchConfigurations
  :cognitect.aws.sms/ServerGroupLaunchConfigurations)

(s/def :cognitect.aws.sms.GetAppLaunchConfigurationRequest/appId :cognitect.aws.sms/AppId)

(s/def :cognitect.aws.sms.GetServersRequest/nextToken :cognitect.aws.sms/NextToken)

(s/def :cognitect.aws.sms.GetServersRequest/maxResults :cognitect.aws.sms/MaxResults)

(s/def
  :cognitect.aws.sms.GetServersRequest/vmServerAddressList
  :cognitect.aws.sms/VmServerAddressList)

(s/def
  :cognitect.aws.sms.GetAppValidationOutputResponse/validationOutputList
  :cognitect.aws.sms/ValidationOutputList)

