;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.ssm-incidents.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.ssm-incidents/Url
  (s/spec
    (s/and string? #(<= 0 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/MetricDefinition
  (s/spec
    (s/and string? #(<= 0 (count %) 4000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/UpdateReplicationSetAction
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.UpdateReplicationSetAction/deleteRegionAction
     :cognitect.aws.ssm-incidents.UpdateReplicationSetAction/addRegionAction]))

(s/def
  :cognitect.aws.ssm-incidents/AttributeValueList
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.AttributeValueList/stringValues
     :cognitect.aws.ssm-incidents.AttributeValueList/integerValues]))

(s/def
  :cognitect.aws.ssm-incidents/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.TagResourceRequest/resourceArn
     :cognitect.aws.ssm-incidents.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.ssm-incidents/ListRelatedItemsOutput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ListRelatedItemsOutput/relatedItems]
    :opt-un
    [:cognitect.aws.ssm-incidents.ListRelatedItemsOutput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/UpdateIncidentRecordInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/arn]
    :opt-un
    [:cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/clientToken
     :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/notificationTargets
     :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/summary
     :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/status
     :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/impact
     :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/title
     :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/chatChannel]))

(s/def
  :cognitect.aws.ssm-incidents/GetIncidentRecordOutput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.GetIncidentRecordOutput/incidentRecord]))

(s/def
  :cognitect.aws.ssm-incidents/CreateResponsePlanInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.CreateResponsePlanInput/incidentTemplate
     :cognitect.aws.ssm-incidents.CreateResponsePlanInput/name]
    :opt-un
    [:cognitect.aws.ssm-incidents.CreateResponsePlanInput/clientToken
     :cognitect.aws.ssm-incidents.CreateResponsePlanInput/displayName
     :cognitect.aws.ssm-incidents.CreateResponsePlanInput/tags
     :cognitect.aws.ssm-incidents.CreateResponsePlanInput/chatChannel
     :cognitect.aws.ssm-incidents.CreateResponsePlanInput/integrations
     :cognitect.aws.ssm-incidents.CreateResponsePlanInput/engagements
     :cognitect.aws.ssm-incidents.CreateResponsePlanInput/actions]))

(s/def
  :cognitect.aws.ssm-incidents/ResourcePolicy
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ResourcePolicy/policyDocument
     :cognitect.aws.ssm-incidents.ResourcePolicy/policyId
     :cognitect.aws.ssm-incidents.ResourcePolicy/ramResourceShareRegion]))

(s/def
  :cognitect.aws.ssm-incidents/StartIncidentOutput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.StartIncidentOutput/incidentRecordArn]))

(s/def
  :cognitect.aws.ssm-incidents/TimelineEventType
  (s/spec
    (s/and string? #(<= 0 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/Integrations
  (s/coll-of :cognitect.aws.ssm-incidents/Integration :min-count 0 :max-count 1))

(s/def
  :cognitect.aws.ssm-incidents/StringListMemberString
  (s/spec
    (s/and string? #(<= 0 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/GetReplicationSetInput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.GetReplicationSetInput/arn]))

(s/def
  :cognitect.aws.ssm-incidents/ListTimelineEventsInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ListTimelineEventsInput/incidentRecordArn]
    :opt-un
    [:cognitect.aws.ssm-incidents.ListTimelineEventsInput/sortBy
     :cognitect.aws.ssm-incidents.ListTimelineEventsInput/filters
     :cognitect.aws.ssm-incidents.ListTimelineEventsInput/maxResults
     :cognitect.aws.ssm-incidents.ListTimelineEventsInput/nextToken
     :cognitect.aws.ssm-incidents.ListTimelineEventsInput/sortOrder]))

(s/def
  :cognitect.aws.ssm-incidents/TagMap
  (s/map-of
    :cognitect.aws.ssm-incidents/TagKey
    :cognitect.aws.ssm-incidents/TagValue
    :min-count
    1
    :max-count
    50))

(s/def
  :cognitect.aws.ssm-incidents/RegionName
  (s/spec
    (s/and string? #(<= 0 (count %) 20))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 20) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/ItemType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"PARENT" "TASK" "OTHER" "ANALYSIS" "INCIDENT" "ATTACHMENT" "INVOLVED_RESOURCE" "AUTOMATION"
        "METRIC"})))

(s/def :cognitect.aws.ssm-incidents/Impact (s/spec (s/and int? #(<= 1 % 5)) :gen #(gen/choose 1 5)))

(s/def
  :cognitect.aws.ssm-incidents/EventReferenceList
  (s/coll-of :cognitect.aws.ssm-incidents/EventReference :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.ssm-incidents/GetTimelineEventOutput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.GetTimelineEventOutput/event]))

(s/def :cognitect.aws.ssm-incidents/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/ResourcePolicyList
  (s/coll-of :cognitect.aws.ssm-incidents/ResourcePolicy :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.ssm-incidents/UpdateReplicationSetInputActionsList
  (s/coll-of :cognitect.aws.ssm-incidents/UpdateReplicationSetAction :min-count 1 :max-count 1))

(s/def :cognitect.aws.ssm-incidents/DeleteIncidentRecordOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/Filter
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.Filter/condition :cognitect.aws.ssm-incidents.Filter/key]))

(s/def
  :cognitect.aws.ssm-incidents/ReplicationSetArnList
  (s/coll-of :cognitect.aws.ssm-incidents/Arn))

(s/def
  :cognitect.aws.ssm-incidents/RelatedItemTitleString
  (s/spec
    (s/and string? #(<= 0 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/GetReplicationSetOutput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.GetReplicationSetOutput/replicationSet]))

(s/def
  :cognitect.aws.ssm-incidents/RegionMapInputValue
  (s/keys :opt-un [:cognitect.aws.ssm-incidents.RegionMapInputValue/sseKmsKeyId]))

(s/def
  :cognitect.aws.ssm-incidents/GetResourcePoliciesInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.GetResourcePoliciesInput/resourceArn]
    :opt-un
    [:cognitect.aws.ssm-incidents.GetResourcePoliciesInput/maxResults
     :cognitect.aws.ssm-incidents.GetResourcePoliciesInput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/AddRegionAction
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.AddRegionAction/regionName]
    :opt-un
    [:cognitect.aws.ssm-incidents.AddRegionAction/sseKmsKeyId]))

(s/def
  :cognitect.aws.ssm-incidents/ResponsePlanName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9-_]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ssm-incidents/UpdateReplicationSetInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.UpdateReplicationSetInput/actions
     :cognitect.aws.ssm-incidents.UpdateReplicationSetInput/arn]
    :opt-un
    [:cognitect.aws.ssm-incidents.UpdateReplicationSetInput/clientToken]))

(s/def
  :cognitect.aws.ssm-incidents/ListIncidentRecordsInput
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.ListIncidentRecordsInput/filters
     :cognitect.aws.ssm-incidents.ListIncidentRecordsInput/maxResults
     :cognitect.aws.ssm-incidents.ListIncidentRecordsInput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/PagerDutyIncidentDetailIdString
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.ssm-incidents/UpdateIncidentRecordOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/RelatedItemList
  (s/coll-of :cognitect.aws.ssm-incidents/RelatedItem :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.ssm-incidents/PagerDutyConfigurationSecretIdString
  (s/spec
    (s/and string? #(<= 1 (count %) 512))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 512) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/UpdateDeletionProtectionInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.UpdateDeletionProtectionInput/arn
     :cognitect.aws.ssm-incidents.UpdateDeletionProtectionInput/deletionProtected]
    :opt-un
    [:cognitect.aws.ssm-incidents.UpdateDeletionProtectionInput/clientToken]))

(s/def
  :cognitect.aws.ssm-incidents/IncidentRecord
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.IncidentRecord/arn
     :cognitect.aws.ssm-incidents.IncidentRecord/creationTime
     :cognitect.aws.ssm-incidents.IncidentRecord/dedupeString
     :cognitect.aws.ssm-incidents.IncidentRecord/impact
     :cognitect.aws.ssm-incidents.IncidentRecord/incidentRecordSource
     :cognitect.aws.ssm-incidents.IncidentRecord/lastModifiedBy
     :cognitect.aws.ssm-incidents.IncidentRecord/lastModifiedTime
     :cognitect.aws.ssm-incidents.IncidentRecord/status
     :cognitect.aws.ssm-incidents.IncidentRecord/title]
    :opt-un
    [:cognitect.aws.ssm-incidents.IncidentRecord/notificationTargets
     :cognitect.aws.ssm-incidents.IncidentRecord/summary
     :cognitect.aws.ssm-incidents.IncidentRecord/automationExecutions
     :cognitect.aws.ssm-incidents.IncidentRecord/chatChannel
     :cognitect.aws.ssm-incidents.IncidentRecord/resolvedTime]))

(s/def
  :cognitect.aws.ssm-incidents/GetResourcePoliciesOutput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.GetResourcePoliciesOutput/resourcePolicies]
    :opt-un
    [:cognitect.aws.ssm-incidents.GetResourcePoliciesOutput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/SsmTargetAccount
  (s/spec string? :gen #(s/gen #{"IMPACTED_ACCOUNT" "RESPONSE_PLAN_OWNER_ACCOUNT"})))

(s/def
  :cognitect.aws.ssm-incidents/SsmParametersKeyString
  (s/spec
    (s/and string? #(<= 1 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/NotificationTargetSet
  (s/coll-of :cognitect.aws.ssm-incidents/NotificationTargetItem :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.ssm-incidents/DynamicSsmParameterValue
  (s/keys :opt-un [:cognitect.aws.ssm-incidents.DynamicSsmParameterValue/variable]))

(s/def
  :cognitect.aws.ssm-incidents/DeleteResourcePolicyInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.DeleteResourcePolicyInput/policyId
     :cognitect.aws.ssm-incidents.DeleteResourcePolicyInput/resourceArn]))

(s/def
  :cognitect.aws.ssm-incidents/DeleteResponsePlanInput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.DeleteResponsePlanInput/arn]))

(s/def :cognitect.aws.ssm-incidents/DeleteReplicationSetOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/SsmParameterValuesMemberString
  (s/spec
    (s/and string? #(<= 0 (count %) 512))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 512) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/ListIncidentRecordsOutput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ListIncidentRecordsOutput/incidentRecordSummaries]
    :opt-un
    [:cognitect.aws.ssm-incidents.ListIncidentRecordsOutput/nextToken]))

(s/def :cognitect.aws.ssm-incidents/UpdateRelatedItemsOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/ListResponsePlansInput
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.ListResponsePlansInput/maxResults
     :cognitect.aws.ssm-incidents.ListResponsePlansInput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/DeleteTimelineEventInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.DeleteTimelineEventInput/eventId
     :cognitect.aws.ssm-incidents.DeleteTimelineEventInput/incidentRecordArn]))

(s/def
  :cognitect.aws.ssm-incidents/GetIncidentRecordInput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.GetIncidentRecordInput/arn]))

(s/def
  :cognitect.aws.ssm-incidents/Integration
  (s/keys :opt-un [:cognitect.aws.ssm-incidents.Integration/pagerDutyConfiguration]))

(s/def
  :cognitect.aws.ssm-incidents/PutResourcePolicyInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.PutResourcePolicyInput/policy
     :cognitect.aws.ssm-incidents.PutResourcePolicyInput/resourceArn]))

(s/def
  :cognitect.aws.ssm-incidents/IncidentTemplate
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.IncidentTemplate/impact
     :cognitect.aws.ssm-incidents.IncidentTemplate/title]
    :opt-un
    [:cognitect.aws.ssm-incidents.IncidentTemplate/dedupeString
     :cognitect.aws.ssm-incidents.IncidentTemplate/incidentTags
     :cognitect.aws.ssm-incidents.IncidentTemplate/notificationTargets
     :cognitect.aws.ssm-incidents.IncidentTemplate/summary]))

(s/def
  :cognitect.aws.ssm-incidents/ListResponsePlansOutput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ListResponsePlansOutput/responsePlanSummaries]
    :opt-un
    [:cognitect.aws.ssm-incidents.ListResponsePlansOutput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/IncidentSource
  (s/spec
    (s/and string? #(<= 0 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/TriggerDetails
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.TriggerDetails/source
     :cognitect.aws.ssm-incidents.TriggerDetails/timestamp]
    :opt-un
    [:cognitect.aws.ssm-incidents.TriggerDetails/triggerArn
     :cognitect.aws.ssm-incidents.TriggerDetails/rawData]))

(s/def
  :cognitect.aws.ssm-incidents/FilterKeyString
  (s/spec
    (s/and string? #(<= 0 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/CreateReplicationSetInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.CreateReplicationSetInput/regions]
    :opt-un
    [:cognitect.aws.ssm-incidents.CreateReplicationSetInput/clientToken
     :cognitect.aws.ssm-incidents.CreateReplicationSetInput/tags]))

(s/def
  :cognitect.aws.ssm-incidents/CreateResponsePlanOutput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.CreateResponsePlanOutput/arn]))

(s/def
  :cognitect.aws.ssm-incidents/PagerDutyIncidentConfiguration
  (s/keys :req-un [:cognitect.aws.ssm-incidents.PagerDutyIncidentConfiguration/serviceId]))

(s/def :cognitect.aws.ssm-incidents/Boolean boolean?)

(s/def
  :cognitect.aws.ssm-incidents/SsmContactsArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws(-cn|-us-gov)?:ssm-contacts:[a-z0-9-]*:([0-9]{12}):contact/[a-z0-9_-]+$")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.ssm-incidents/UpdateResponsePlanOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/IncidentTitle
  (s/spec
    (s/and string? #(<= 0 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 200) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.ssm-incidents/UpdateReplicationSetOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/ListReplicationSetsOutput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ListReplicationSetsOutput/replicationSetArns]
    :opt-un
    [:cognitect.aws.ssm-incidents.ListReplicationSetsOutput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/RawData
  (s/spec
    (s/and string? #(<= 0 (count %) 4000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/ActionsList
  (s/coll-of :cognitect.aws.ssm-incidents/Action :min-count 0 :max-count 1))

(s/def
  :cognitect.aws.ssm-incidents/SseKmsKey
  (s/spec
    (s/and string? #(<= 0 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/NextToken
  (s/spec
    (s/and string? #(<= 0 (count %) 2000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.ssm-incidents/UpdateTimelineEventOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/GetResponsePlanOutput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.GetResponsePlanOutput/arn
     :cognitect.aws.ssm-incidents.GetResponsePlanOutput/incidentTemplate
     :cognitect.aws.ssm-incidents.GetResponsePlanOutput/name]
    :opt-un
    [:cognitect.aws.ssm-incidents.GetResponsePlanOutput/displayName
     :cognitect.aws.ssm-incidents.GetResponsePlanOutput/chatChannel
     :cognitect.aws.ssm-incidents.GetResponsePlanOutput/integrations
     :cognitect.aws.ssm-incidents.GetResponsePlanOutput/engagements
     :cognitect.aws.ssm-incidents.GetResponsePlanOutput/actions]))

(s/def
  :cognitect.aws.ssm-incidents/ChatChannel
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.ChatChannel/chatbotSns
     :cognitect.aws.ssm-incidents.ChatChannel/empty]))

(s/def
  :cognitect.aws.ssm-incidents/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.ssm-incidents/NotificationTargetItem
  (s/keys :opt-un [:cognitect.aws.ssm-incidents.NotificationTargetItem/snsTopicArn]))

(s/def
  :cognitect.aws.ssm-incidents/TimelineEvent
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.TimelineEvent/eventData
     :cognitect.aws.ssm-incidents.TimelineEvent/eventId
     :cognitect.aws.ssm-incidents.TimelineEvent/eventTime
     :cognitect.aws.ssm-incidents.TimelineEvent/eventType
     :cognitect.aws.ssm-incidents.TimelineEvent/eventUpdatedTime
     :cognitect.aws.ssm-incidents.TimelineEvent/incidentRecordArn]
    :opt-un
    [:cognitect.aws.ssm-incidents.TimelineEvent/eventReferences]))

(s/def
  :cognitect.aws.ssm-incidents/TagValue
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9 _=@:.+-/]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ssm-incidents/UpdateRelatedItemsInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.UpdateRelatedItemsInput/incidentRecordArn
     :cognitect.aws.ssm-incidents.UpdateRelatedItemsInput/relatedItemsUpdate]
    :opt-un
    [:cognitect.aws.ssm-incidents.UpdateRelatedItemsInput/clientToken]))

(s/def
  :cognitect.aws.ssm-incidents/CreateTimelineEventInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.CreateTimelineEventInput/eventData
     :cognitect.aws.ssm-incidents.CreateTimelineEventInput/eventTime
     :cognitect.aws.ssm-incidents.CreateTimelineEventInput/eventType
     :cognitect.aws.ssm-incidents.CreateTimelineEventInput/incidentRecordArn]
    :opt-un
    [:cognitect.aws.ssm-incidents.CreateTimelineEventInput/clientToken
     :cognitect.aws.ssm-incidents.CreateTimelineEventInput/eventReferences]))

(s/def
  :cognitect.aws.ssm-incidents/StartIncidentInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.StartIncidentInput/responsePlanArn]
    :opt-un
    [:cognitect.aws.ssm-incidents.StartIncidentInput/clientToken
     :cognitect.aws.ssm-incidents.StartIncidentInput/relatedItems
     :cognitect.aws.ssm-incidents.StartIncidentInput/impact
     :cognitect.aws.ssm-incidents.StartIncidentInput/title
     :cognitect.aws.ssm-incidents.StartIncidentInput/triggerDetails]))

(s/def
  :cognitect.aws.ssm-incidents/SsmAutomation
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.SsmAutomation/documentName
     :cognitect.aws.ssm-incidents.SsmAutomation/roleArn]
    :opt-un
    [:cognitect.aws.ssm-incidents.SsmAutomation/dynamicParameters
     :cognitect.aws.ssm-incidents.SsmAutomation/documentVersion
     :cognitect.aws.ssm-incidents.SsmAutomation/targetAccount
     :cognitect.aws.ssm-incidents.SsmAutomation/parameters]))

(s/def
  :cognitect.aws.ssm-incidents/CreateReplicationSetOutput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.CreateReplicationSetOutput/arn]))

(s/def
  :cognitect.aws.ssm-incidents/GetTimelineEventInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.GetTimelineEventInput/eventId
     :cognitect.aws.ssm-incidents.GetTimelineEventInput/incidentRecordArn]))

(s/def
  :cognitect.aws.ssm-incidents/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.ssm-incidents.ListTagsForResourceRequest/resourceArn]))

(s/def
  :cognitect.aws.ssm-incidents/TagMapUpdate
  (s/map-of
    :cognitect.aws.ssm-incidents/TagKey
    :cognitect.aws.ssm-incidents/TagValue
    :min-count
    0
    :max-count
    50))

(s/def
  :cognitect.aws.ssm-incidents/IncidentSummary
  (s/spec
    (s/and string? #(<= 0 (count %) 4000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/DeleteRegionAction
  (s/keys :req-un [:cognitect.aws.ssm-incidents.DeleteRegionAction/regionName]))

(s/def
  :cognitect.aws.ssm-incidents/ReplicationSet
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ReplicationSet/createdBy
     :cognitect.aws.ssm-incidents.ReplicationSet/createdTime
     :cognitect.aws.ssm-incidents.ReplicationSet/deletionProtected
     :cognitect.aws.ssm-incidents.ReplicationSet/lastModifiedBy
     :cognitect.aws.ssm-incidents.ReplicationSet/lastModifiedTime
     :cognitect.aws.ssm-incidents.ReplicationSet/regionMap
     :cognitect.aws.ssm-incidents.ReplicationSet/status]
    :opt-un
    [:cognitect.aws.ssm-incidents.ReplicationSet/arn]))

(s/def
  :cognitect.aws.ssm-incidents/UpdateTimelineEventInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventId
     :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/incidentRecordArn]
    :opt-un
    [:cognitect.aws.ssm-incidents.UpdateTimelineEventInput/clientToken
     :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventReferences
     :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventType
     :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventData
     :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventTime]))

(s/def
  :cognitect.aws.ssm-incidents/RoleArn
  (s/spec
    #(re-matches (re-pattern "^arn:aws(-cn|-us-gov)?:iam::([0-9]{12})?:role/.+$") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.ssm-incidents/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/FilterList
  (s/coll-of :cognitect.aws.ssm-incidents/Filter :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.ssm-incidents/PagerDutyConfigurationNameString
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/PagerDutyIncidentConfigurationServiceIdString
  (s/spec
    (s/and string? #(<= 1 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/SsmParameters
  (s/map-of
    :cognitect.aws.ssm-incidents/SsmParametersKeyString
    :cognitect.aws.ssm-incidents/SsmParameterValues
    :min-count
    1
    :max-count
    200))

(s/def
  :cognitect.aws.ssm-incidents/EngagementSet
  (s/coll-of :cognitect.aws.ssm-incidents/SsmContactsArn :min-count 0 :max-count 5))

(s/def
  :cognitect.aws.ssm-incidents/DeleteIncidentRecordInput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.DeleteIncidentRecordInput/arn]))

(s/def
  :cognitect.aws.ssm-incidents/RegionStatus
  (s/spec string? :gen #(s/gen #{"DELETING" "CREATING" "ACTIVE" "FAILED"})))

(s/def :cognitect.aws.ssm-incidents/DeleteResponsePlanOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/RelatedItem
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.RelatedItem/identifier]
    :opt-un
    [:cognitect.aws.ssm-incidents.RelatedItem/generatedId
     :cognitect.aws.ssm-incidents.RelatedItem/title]))

(s/def :cognitect.aws.ssm-incidents/EmptyChatChannel (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/SsmAutomationDocumentVersionString
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/IncidentRecordSummary
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.IncidentRecordSummary/arn
     :cognitect.aws.ssm-incidents.IncidentRecordSummary/creationTime
     :cognitect.aws.ssm-incidents.IncidentRecordSummary/impact
     :cognitect.aws.ssm-incidents.IncidentRecordSummary/incidentRecordSource
     :cognitect.aws.ssm-incidents.IncidentRecordSummary/status
     :cognitect.aws.ssm-incidents.IncidentRecordSummary/title]
    :opt-un
    [:cognitect.aws.ssm-incidents.IncidentRecordSummary/resolvedTime]))

(s/def
  :cognitect.aws.ssm-incidents/SnsArn
  (s/spec
    (s/and string? #(<= 0 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/SortOrder
  (s/spec string? :gen #(s/gen #{"ASCENDING" "DESCENDING"})))

(s/def
  :cognitect.aws.ssm-incidents/PutResourcePolicyOutput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.PutResourcePolicyOutput/policyId]))

(s/def
  :cognitect.aws.ssm-incidents/UpdateResponsePlanInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.UpdateResponsePlanInput/arn]
    :opt-un
    [:cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateTitle
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/clientToken
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateImpact
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/displayName
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateTags
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/chatChannel
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateNotificationTargets
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/integrations
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateDedupeString
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/engagements
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateSummary
     :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/actions]))

(s/def
  :cognitect.aws.ssm-incidents/RegionInfo
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.RegionInfo/status
     :cognitect.aws.ssm-incidents.RegionInfo/statusUpdateDateTime]
    :opt-un
    [:cognitect.aws.ssm-incidents.RegionInfo/sseKmsKeyId
     :cognitect.aws.ssm-incidents.RegionInfo/statusMessage]))

(s/def
  :cognitect.aws.ssm-incidents/Action
  (s/keys :opt-un [:cognitect.aws.ssm-incidents.Action/ssmAutomation]))

(s/def
  :cognitect.aws.ssm-incidents/Arn
  (s/spec
    #(re-matches (re-pattern "^arn:aws(-cn|-us-gov)?:[a-z0-9-]*:[a-z0-9-]*:([0-9]{12})?:.+$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ssm-incidents/SsmParameterValues
  (s/coll-of
    :cognitect.aws.ssm-incidents/SsmParameterValuesMemberString
    :min-count
    0
    :max-count
    100))

(s/def
  :cognitect.aws.ssm-incidents/DynamicSsmParameters
  (s/map-of
    :cognitect.aws.ssm-incidents/DynamicSsmParametersKeyString
    :cognitect.aws.ssm-incidents/DynamicSsmParameterValue
    :min-count
    1
    :max-count
    200))

(s/def
  :cognitect.aws.ssm-incidents/CreateTimelineEventOutput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.CreateTimelineEventOutput/eventId
     :cognitect.aws.ssm-incidents.CreateTimelineEventOutput/incidentRecordArn]))

(s/def :cognitect.aws.ssm-incidents/DeleteResourcePolicyOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/RelatedItemsUpdate
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.RelatedItemsUpdate/itemToAdd
     :cognitect.aws.ssm-incidents.RelatedItemsUpdate/itemToRemove]))

(s/def
  :cognitect.aws.ssm-incidents/ListTimelineEventsOutput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ListTimelineEventsOutput/eventSummaries]
    :opt-un
    [:cognitect.aws.ssm-incidents.ListTimelineEventsOutput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/PagerDutyIncidentDetailSecretIdString
  (s/spec
    (s/and string? #(<= 1 (count %) 512))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 512) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/SsmAutomationDocumentNameString
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_\\-.:/]{3,128}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ssm-incidents/MaxResults
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.ssm-incidents/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.UntagResourceRequest/resourceArn
     :cognitect.aws.ssm-incidents.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.ssm-incidents/ServicePrincipal
  (s/spec
    (s/and string? #(<= 0 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/ItemValue
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.ItemValue/url
     :cognitect.aws.ssm-incidents.ItemValue/arn
     :cognitect.aws.ssm-incidents.ItemValue/pagerDutyIncidentDetail
     :cognitect.aws.ssm-incidents.ItemValue/metricDefinition]))

(s/def
  :cognitect.aws.ssm-incidents/TagKey
  (s/spec #(re-matches (re-pattern "^(?!aws:)[A-Za-z0-9 _=@:.+-/]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ssm-incidents/VariableType
  (s/spec string? :gen #(s/gen #{"INCIDENT_RECORD_ARN" "INVOLVED_RESOURCES"})))

(s/def
  :cognitect.aws.ssm-incidents/ListReplicationSetsInput
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.ListReplicationSetsInput/maxResults
     :cognitect.aws.ssm-incidents.ListReplicationSetsInput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/EventSummaryList
  (s/coll-of :cognitect.aws.ssm-incidents/EventSummary :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.ssm-incidents/ChatbotSnsConfigurationSet
  (s/coll-of :cognitect.aws.ssm-incidents/SnsArn :min-count 1 :max-count 5))

(s/def
  :cognitect.aws.ssm-incidents/PolicyId
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/ClientToken
  (s/spec
    (s/and string? #(<= 0 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.ssm-incidents/Timestamp inst?)

(s/def
  :cognitect.aws.ssm-incidents/IncidentRecordSource
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.IncidentRecordSource/createdBy
     :cognitect.aws.ssm-incidents.IncidentRecordSource/source]
    :opt-un
    [:cognitect.aws.ssm-incidents.IncidentRecordSource/invokedBy
     :cognitect.aws.ssm-incidents.IncidentRecordSource/resourceArn]))

(s/def
  :cognitect.aws.ssm-incidents/GetResponsePlanInput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.GetResponsePlanInput/arn]))

(s/def
  :cognitect.aws.ssm-incidents/StringList
  (s/coll-of :cognitect.aws.ssm-incidents/StringListMemberString :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.ssm-incidents/UUID
  (s/spec
    (s/and string? #(<= 0 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 50) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.ssm-incidents/DeleteTimelineEventOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/IncidentRecordSummaryList
  (s/coll-of :cognitect.aws.ssm-incidents/IncidentRecordSummary :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.ssm-incidents/GeneratedId
  (s/spec
    #(re-matches
      (re-pattern
        "^related-item/(ANALYSIS|INCIDENT|METRIC|PARENT|ATTACHMENT|OTHER|AUTOMATION|INVOLVED_RESOURCE|TASK)/([0-9]|[A-F]){32}$")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.ssm-incidents/UpdateDeletionProtectionOutput (s/keys))

(s/def
  :cognitect.aws.ssm-incidents/RegionMapInput
  (s/map-of
    :cognitect.aws.ssm-incidents/RegionName
    :cognitect.aws.ssm-incidents/RegionMapInputValue
    :min-count
    1
    :max-count
    3))

(s/def
  :cognitect.aws.ssm-incidents/Condition
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.Condition/after
     :cognitect.aws.ssm-incidents.Condition/before
     :cognitect.aws.ssm-incidents.Condition/equals]))

(s/def
  :cognitect.aws.ssm-incidents/ResponsePlanDisplayName
  (s/spec
    (s/and string? #(<= 0 (count %) 200))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 200) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/ListRelatedItemsInput
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ListRelatedItemsInput/incidentRecordArn]
    :opt-un
    [:cognitect.aws.ssm-incidents.ListRelatedItemsInput/maxResults
     :cognitect.aws.ssm-incidents.ListRelatedItemsInput/nextToken]))

(s/def
  :cognitect.aws.ssm-incidents/DynamicSsmParametersKeyString
  (s/spec
    (s/and string? #(<= 1 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/ResponsePlanSummaryList
  (s/coll-of :cognitect.aws.ssm-incidents/ResponsePlanSummary :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.ssm-incidents/IntegerList
  (s/coll-of :cognitect.aws.ssm-incidents/Integer :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.ssm-incidents/TimelineEventSort
  (s/spec string? :gen #(s/gen #{"EVENT_TIME"})))

(s/def
  :cognitect.aws.ssm-incidents/ResponsePlanSummary
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ResponsePlanSummary/arn
     :cognitect.aws.ssm-incidents.ResponsePlanSummary/name]
    :opt-un
    [:cognitect.aws.ssm-incidents.ResponsePlanSummary/displayName]))

(s/def
  :cognitect.aws.ssm-incidents/RegionInfoMap
  (s/map-of :cognitect.aws.ssm-incidents/RegionName :cognitect.aws.ssm-incidents/RegionInfo))

(s/def
  :cognitect.aws.ssm-incidents/ListTagsForResourceResponse
  (s/keys :req-un [:cognitect.aws.ssm-incidents.ListTagsForResourceResponse/tags]))

(s/def
  :cognitect.aws.ssm-incidents/PagerDutyConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.PagerDutyConfiguration/name
     :cognitect.aws.ssm-incidents.PagerDutyConfiguration/pagerDutyIncidentConfiguration
     :cognitect.aws.ssm-incidents.PagerDutyConfiguration/secretId]))

(s/def
  :cognitect.aws.ssm-incidents/EventReference
  (s/keys
    :opt-un
    [:cognitect.aws.ssm-incidents.EventReference/resource
     :cognitect.aws.ssm-incidents.EventReference/relatedItemId]))

(s/def
  :cognitect.aws.ssm-incidents/AutomationExecution
  (s/keys :opt-un [:cognitect.aws.ssm-incidents.AutomationExecution/ssmExecutionArn]))

(s/def
  :cognitect.aws.ssm-incidents/IncidentRecordStatus
  (s/spec string? :gen #(s/gen #{"OPEN" "RESOLVED"})))

(s/def
  :cognitect.aws.ssm-incidents/ReplicationSetStatus
  (s/spec string? :gen #(s/gen #{"UPDATING" "DELETING" "CREATING" "ACTIVE" "FAILED"})))

(s/def
  :cognitect.aws.ssm-incidents/DedupeString
  (s/spec
    (s/and string? #(<= 0 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/ItemIdentifier
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.ItemIdentifier/type
     :cognitect.aws.ssm-incidents.ItemIdentifier/value]))

(s/def
  :cognitect.aws.ssm-incidents/DeleteReplicationSetInput
  (s/keys :req-un [:cognitect.aws.ssm-incidents.DeleteReplicationSetInput/arn]))

(s/def :cognitect.aws.ssm-incidents/String string?)

(s/def
  :cognitect.aws.ssm-incidents/EventSummary
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.EventSummary/eventId
     :cognitect.aws.ssm-incidents.EventSummary/eventTime
     :cognitect.aws.ssm-incidents.EventSummary/eventType
     :cognitect.aws.ssm-incidents.EventSummary/eventUpdatedTime
     :cognitect.aws.ssm-incidents.EventSummary/incidentRecordArn]
    :opt-un
    [:cognitect.aws.ssm-incidents.EventSummary/eventReferences]))

(s/def
  :cognitect.aws.ssm-incidents/Policy
  (s/spec
    (s/and string? #(<= 0 (count %) 4000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 4000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents/AutomationExecutionSet
  (s/coll-of :cognitect.aws.ssm-incidents/AutomationExecution :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.ssm-incidents/TagKeyList
  (s/coll-of :cognitect.aws.ssm-incidents/TagKey :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.ssm-incidents/PagerDutyIncidentDetail
  (s/keys
    :req-un
    [:cognitect.aws.ssm-incidents.PagerDutyIncidentDetail/id]
    :opt-un
    [:cognitect.aws.ssm-incidents.PagerDutyIncidentDetail/secretId
     :cognitect.aws.ssm-incidents.PagerDutyIncidentDetail/autoResolve]))

(s/def
  :cognitect.aws.ssm-incidents/EventData
  (s/spec
    (s/and string? #(<= 0 (count %) 12000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 12000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ssm-incidents.UpdateReplicationSetAction/addRegionAction
  :cognitect.aws.ssm-incidents/AddRegionAction)

(s/def
  :cognitect.aws.ssm-incidents.UpdateReplicationSetAction/deleteRegionAction
  :cognitect.aws.ssm-incidents/DeleteRegionAction)

(s/def
  :cognitect.aws.ssm-incidents.AttributeValueList/integerValues
  :cognitect.aws.ssm-incidents/IntegerList)

(s/def
  :cognitect.aws.ssm-incidents.AttributeValueList/stringValues
  :cognitect.aws.ssm-incidents/StringList)

(s/def
  :cognitect.aws.ssm-incidents.TagResourceRequest/resourceArn
  :cognitect.aws.ssm-incidents/String)

(s/def :cognitect.aws.ssm-incidents.TagResourceRequest/tags :cognitect.aws.ssm-incidents/TagMap)

(s/def
  :cognitect.aws.ssm-incidents.ListRelatedItemsOutput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.ListRelatedItemsOutput/relatedItems
  :cognitect.aws.ssm-incidents/RelatedItemList)

(s/def :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/chatChannel
  :cognitect.aws.ssm-incidents/ChatChannel)

(s/def
  :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def
  :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/impact
  :cognitect.aws.ssm-incidents/Impact)

(s/def
  :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/notificationTargets
  :cognitect.aws.ssm-incidents/NotificationTargetSet)

(s/def
  :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/status
  :cognitect.aws.ssm-incidents/IncidentRecordStatus)

(s/def
  :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/summary
  :cognitect.aws.ssm-incidents/IncidentSummary)

(s/def
  :cognitect.aws.ssm-incidents.UpdateIncidentRecordInput/title
  :cognitect.aws.ssm-incidents/IncidentTitle)

(s/def
  :cognitect.aws.ssm-incidents.GetIncidentRecordOutput/incidentRecord
  :cognitect.aws.ssm-incidents/IncidentRecord)

(s/def
  :cognitect.aws.ssm-incidents.CreateResponsePlanInput/tags
  :cognitect.aws.ssm-incidents/TagMap)

(s/def
  :cognitect.aws.ssm-incidents.CreateResponsePlanInput/chatChannel
  :cognitect.aws.ssm-incidents/ChatChannel)

(s/def
  :cognitect.aws.ssm-incidents.CreateResponsePlanInput/incidentTemplate
  :cognitect.aws.ssm-incidents/IncidentTemplate)

(s/def
  :cognitect.aws.ssm-incidents.CreateResponsePlanInput/engagements
  :cognitect.aws.ssm-incidents/EngagementSet)

(s/def
  :cognitect.aws.ssm-incidents.CreateResponsePlanInput/integrations
  :cognitect.aws.ssm-incidents/Integrations)

(s/def
  :cognitect.aws.ssm-incidents.CreateResponsePlanInput/displayName
  :cognitect.aws.ssm-incidents/ResponsePlanDisplayName)

(s/def
  :cognitect.aws.ssm-incidents.CreateResponsePlanInput/name
  :cognitect.aws.ssm-incidents/ResponsePlanName)

(s/def
  :cognitect.aws.ssm-incidents.CreateResponsePlanInput/actions
  :cognitect.aws.ssm-incidents/ActionsList)

(s/def
  :cognitect.aws.ssm-incidents.CreateResponsePlanInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def
  :cognitect.aws.ssm-incidents.ResourcePolicy/policyDocument
  :cognitect.aws.ssm-incidents/Policy)

(s/def :cognitect.aws.ssm-incidents.ResourcePolicy/policyId :cognitect.aws.ssm-incidents/PolicyId)

(s/def
  :cognitect.aws.ssm-incidents.ResourcePolicy/ramResourceShareRegion
  :cognitect.aws.ssm-incidents/String)

(s/def
  :cognitect.aws.ssm-incidents.StartIncidentOutput/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.GetReplicationSetInput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.ListTimelineEventsInput/filters
  :cognitect.aws.ssm-incidents/FilterList)

(s/def
  :cognitect.aws.ssm-incidents.ListTimelineEventsInput/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.ListTimelineEventsInput/maxResults
  :cognitect.aws.ssm-incidents/MaxResults)

(s/def
  :cognitect.aws.ssm-incidents.ListTimelineEventsInput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.ListTimelineEventsInput/sortBy
  :cognitect.aws.ssm-incidents/TimelineEventSort)

(s/def
  :cognitect.aws.ssm-incidents.ListTimelineEventsInput/sortOrder
  :cognitect.aws.ssm-incidents/SortOrder)

(s/def
  :cognitect.aws.ssm-incidents.GetTimelineEventOutput/event
  :cognitect.aws.ssm-incidents/TimelineEvent)

(s/def :cognitect.aws.ssm-incidents.Filter/condition :cognitect.aws.ssm-incidents/Condition)

(s/def :cognitect.aws.ssm-incidents.Filter/key :cognitect.aws.ssm-incidents/FilterKeyString)

(s/def
  :cognitect.aws.ssm-incidents.GetReplicationSetOutput/replicationSet
  :cognitect.aws.ssm-incidents/ReplicationSet)

(s/def
  :cognitect.aws.ssm-incidents.RegionMapInputValue/sseKmsKeyId
  :cognitect.aws.ssm-incidents/SseKmsKey)

(s/def
  :cognitect.aws.ssm-incidents.GetResourcePoliciesInput/maxResults
  :cognitect.aws.ssm-incidents/MaxResults)

(s/def
  :cognitect.aws.ssm-incidents.GetResourcePoliciesInput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.GetResourcePoliciesInput/resourceArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.AddRegionAction/regionName
  :cognitect.aws.ssm-incidents/RegionName)

(s/def
  :cognitect.aws.ssm-incidents.AddRegionAction/sseKmsKeyId
  :cognitect.aws.ssm-incidents/SseKmsKey)

(s/def
  :cognitect.aws.ssm-incidents.UpdateReplicationSetInput/actions
  :cognitect.aws.ssm-incidents/UpdateReplicationSetInputActionsList)

(s/def :cognitect.aws.ssm-incidents.UpdateReplicationSetInput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.UpdateReplicationSetInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def
  :cognitect.aws.ssm-incidents.ListIncidentRecordsInput/filters
  :cognitect.aws.ssm-incidents/FilterList)

(s/def
  :cognitect.aws.ssm-incidents.ListIncidentRecordsInput/maxResults
  :cognitect.aws.ssm-incidents/MaxResults)

(s/def
  :cognitect.aws.ssm-incidents.ListIncidentRecordsInput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.UpdateDeletionProtectionInput/arn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.UpdateDeletionProtectionInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def
  :cognitect.aws.ssm-incidents.UpdateDeletionProtectionInput/deletionProtected
  :cognitect.aws.ssm-incidents/Boolean)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/creationTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def :cognitect.aws.ssm-incidents.IncidentRecord/lastModifiedBy :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/incidentRecordSource
  :cognitect.aws.ssm-incidents/IncidentRecordSource)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/chatChannel
  :cognitect.aws.ssm-incidents/ChatChannel)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/notificationTargets
  :cognitect.aws.ssm-incidents/NotificationTargetSet)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/automationExecutions
  :cognitect.aws.ssm-incidents/AutomationExecutionSet)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/dedupeString
  :cognitect.aws.ssm-incidents/DedupeString)

(s/def :cognitect.aws.ssm-incidents.IncidentRecord/title :cognitect.aws.ssm-incidents/IncidentTitle)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/summary
  :cognitect.aws.ssm-incidents/IncidentSummary)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/lastModifiedTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/status
  :cognitect.aws.ssm-incidents/IncidentRecordStatus)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecord/resolvedTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def :cognitect.aws.ssm-incidents.IncidentRecord/impact :cognitect.aws.ssm-incidents/Impact)

(s/def :cognitect.aws.ssm-incidents.IncidentRecord/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.GetResourcePoliciesOutput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.GetResourcePoliciesOutput/resourcePolicies
  :cognitect.aws.ssm-incidents/ResourcePolicyList)

(s/def
  :cognitect.aws.ssm-incidents.DynamicSsmParameterValue/variable
  :cognitect.aws.ssm-incidents/VariableType)

(s/def
  :cognitect.aws.ssm-incidents.DeleteResourcePolicyInput/policyId
  :cognitect.aws.ssm-incidents/PolicyId)

(s/def
  :cognitect.aws.ssm-incidents.DeleteResourcePolicyInput/resourceArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.DeleteResponsePlanInput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.ListIncidentRecordsOutput/incidentRecordSummaries
  :cognitect.aws.ssm-incidents/IncidentRecordSummaryList)

(s/def
  :cognitect.aws.ssm-incidents.ListIncidentRecordsOutput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.ListResponsePlansInput/maxResults
  :cognitect.aws.ssm-incidents/MaxResults)

(s/def
  :cognitect.aws.ssm-incidents.ListResponsePlansInput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.DeleteTimelineEventInput/eventId
  :cognitect.aws.ssm-incidents/UUID)

(s/def
  :cognitect.aws.ssm-incidents.DeleteTimelineEventInput/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.GetIncidentRecordInput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.Integration/pagerDutyConfiguration
  :cognitect.aws.ssm-incidents/PagerDutyConfiguration)

(s/def
  :cognitect.aws.ssm-incidents.PutResourcePolicyInput/policy
  :cognitect.aws.ssm-incidents/Policy)

(s/def
  :cognitect.aws.ssm-incidents.PutResourcePolicyInput/resourceArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.IncidentTemplate/dedupeString
  :cognitect.aws.ssm-incidents/DedupeString)

(s/def :cognitect.aws.ssm-incidents.IncidentTemplate/impact :cognitect.aws.ssm-incidents/Impact)

(s/def
  :cognitect.aws.ssm-incidents.IncidentTemplate/incidentTags
  :cognitect.aws.ssm-incidents/TagMap)

(s/def
  :cognitect.aws.ssm-incidents.IncidentTemplate/notificationTargets
  :cognitect.aws.ssm-incidents/NotificationTargetSet)

(s/def
  :cognitect.aws.ssm-incidents.IncidentTemplate/summary
  :cognitect.aws.ssm-incidents/IncidentSummary)

(s/def
  :cognitect.aws.ssm-incidents.IncidentTemplate/title
  :cognitect.aws.ssm-incidents/IncidentTitle)

(s/def
  :cognitect.aws.ssm-incidents.ListResponsePlansOutput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.ListResponsePlansOutput/responsePlanSummaries
  :cognitect.aws.ssm-incidents/ResponsePlanSummaryList)

(s/def :cognitect.aws.ssm-incidents.TriggerDetails/rawData :cognitect.aws.ssm-incidents/RawData)

(s/def
  :cognitect.aws.ssm-incidents.TriggerDetails/source
  :cognitect.aws.ssm-incidents/IncidentSource)

(s/def :cognitect.aws.ssm-incidents.TriggerDetails/timestamp :cognitect.aws.ssm-incidents/Timestamp)

(s/def :cognitect.aws.ssm-incidents.TriggerDetails/triggerArn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.CreateReplicationSetInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def
  :cognitect.aws.ssm-incidents.CreateReplicationSetInput/regions
  :cognitect.aws.ssm-incidents/RegionMapInput)

(s/def
  :cognitect.aws.ssm-incidents.CreateReplicationSetInput/tags
  :cognitect.aws.ssm-incidents/TagMap)

(s/def :cognitect.aws.ssm-incidents.CreateResponsePlanOutput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.PagerDutyIncidentConfiguration/serviceId
  :cognitect.aws.ssm-incidents/PagerDutyIncidentConfigurationServiceIdString)

(s/def
  :cognitect.aws.ssm-incidents.ListReplicationSetsOutput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.ListReplicationSetsOutput/replicationSetArns
  :cognitect.aws.ssm-incidents/ReplicationSetArnList)

(s/def
  :cognitect.aws.ssm-incidents.GetResponsePlanOutput/actions
  :cognitect.aws.ssm-incidents/ActionsList)

(s/def :cognitect.aws.ssm-incidents.GetResponsePlanOutput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.GetResponsePlanOutput/chatChannel
  :cognitect.aws.ssm-incidents/ChatChannel)

(s/def
  :cognitect.aws.ssm-incidents.GetResponsePlanOutput/displayName
  :cognitect.aws.ssm-incidents/ResponsePlanDisplayName)

(s/def
  :cognitect.aws.ssm-incidents.GetResponsePlanOutput/engagements
  :cognitect.aws.ssm-incidents/EngagementSet)

(s/def
  :cognitect.aws.ssm-incidents.GetResponsePlanOutput/incidentTemplate
  :cognitect.aws.ssm-incidents/IncidentTemplate)

(s/def
  :cognitect.aws.ssm-incidents.GetResponsePlanOutput/integrations
  :cognitect.aws.ssm-incidents/Integrations)

(s/def
  :cognitect.aws.ssm-incidents.GetResponsePlanOutput/name
  :cognitect.aws.ssm-incidents/ResponsePlanName)

(s/def
  :cognitect.aws.ssm-incidents.ChatChannel/chatbotSns
  :cognitect.aws.ssm-incidents/ChatbotSnsConfigurationSet)

(s/def :cognitect.aws.ssm-incidents.ChatChannel/empty :cognitect.aws.ssm-incidents/EmptyChatChannel)

(s/def
  :cognitect.aws.ssm-incidents.NotificationTargetItem/snsTopicArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.TimelineEvent/eventData :cognitect.aws.ssm-incidents/EventData)

(s/def :cognitect.aws.ssm-incidents.TimelineEvent/eventId :cognitect.aws.ssm-incidents/UUID)

(s/def
  :cognitect.aws.ssm-incidents.TimelineEvent/eventReferences
  :cognitect.aws.ssm-incidents/EventReferenceList)

(s/def :cognitect.aws.ssm-incidents.TimelineEvent/eventTime :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.TimelineEvent/eventType
  :cognitect.aws.ssm-incidents/TimelineEventType)

(s/def
  :cognitect.aws.ssm-incidents.TimelineEvent/eventUpdatedTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.TimelineEvent/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.UpdateRelatedItemsInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def
  :cognitect.aws.ssm-incidents.UpdateRelatedItemsInput/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.UpdateRelatedItemsInput/relatedItemsUpdate
  :cognitect.aws.ssm-incidents/RelatedItemsUpdate)

(s/def
  :cognitect.aws.ssm-incidents.CreateTimelineEventInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def
  :cognitect.aws.ssm-incidents.CreateTimelineEventInput/eventData
  :cognitect.aws.ssm-incidents/EventData)

(s/def
  :cognitect.aws.ssm-incidents.CreateTimelineEventInput/eventReferences
  :cognitect.aws.ssm-incidents/EventReferenceList)

(s/def
  :cognitect.aws.ssm-incidents.CreateTimelineEventInput/eventTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.CreateTimelineEventInput/eventType
  :cognitect.aws.ssm-incidents/TimelineEventType)

(s/def
  :cognitect.aws.ssm-incidents.CreateTimelineEventInput/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.StartIncidentInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def :cognitect.aws.ssm-incidents.StartIncidentInput/impact :cognitect.aws.ssm-incidents/Impact)

(s/def
  :cognitect.aws.ssm-incidents.StartIncidentInput/relatedItems
  :cognitect.aws.ssm-incidents/RelatedItemList)

(s/def
  :cognitect.aws.ssm-incidents.StartIncidentInput/responsePlanArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.StartIncidentInput/title
  :cognitect.aws.ssm-incidents/IncidentTitle)

(s/def
  :cognitect.aws.ssm-incidents.StartIncidentInput/triggerDetails
  :cognitect.aws.ssm-incidents/TriggerDetails)

(s/def
  :cognitect.aws.ssm-incidents.SsmAutomation/documentName
  :cognitect.aws.ssm-incidents/SsmAutomationDocumentNameString)

(s/def
  :cognitect.aws.ssm-incidents.SsmAutomation/documentVersion
  :cognitect.aws.ssm-incidents/SsmAutomationDocumentVersionString)

(s/def
  :cognitect.aws.ssm-incidents.SsmAutomation/dynamicParameters
  :cognitect.aws.ssm-incidents/DynamicSsmParameters)

(s/def
  :cognitect.aws.ssm-incidents.SsmAutomation/parameters
  :cognitect.aws.ssm-incidents/SsmParameters)

(s/def :cognitect.aws.ssm-incidents.SsmAutomation/roleArn :cognitect.aws.ssm-incidents/RoleArn)

(s/def
  :cognitect.aws.ssm-incidents.SsmAutomation/targetAccount
  :cognitect.aws.ssm-incidents/SsmTargetAccount)

(s/def :cognitect.aws.ssm-incidents.CreateReplicationSetOutput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.GetTimelineEventInput/eventId :cognitect.aws.ssm-incidents/UUID)

(s/def
  :cognitect.aws.ssm-incidents.GetTimelineEventInput/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.ListTagsForResourceRequest/resourceArn
  :cognitect.aws.ssm-incidents/String)

(s/def
  :cognitect.aws.ssm-incidents.DeleteRegionAction/regionName
  :cognitect.aws.ssm-incidents/RegionName)

(s/def :cognitect.aws.ssm-incidents.ReplicationSet/arn :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.ReplicationSet/createdBy :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.ReplicationSet/createdTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.ReplicationSet/deletionProtected
  :cognitect.aws.ssm-incidents/Boolean)

(s/def :cognitect.aws.ssm-incidents.ReplicationSet/lastModifiedBy :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.ReplicationSet/lastModifiedTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.ReplicationSet/regionMap
  :cognitect.aws.ssm-incidents/RegionInfoMap)

(s/def
  :cognitect.aws.ssm-incidents.ReplicationSet/status
  :cognitect.aws.ssm-incidents/ReplicationSetStatus)

(s/def
  :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def
  :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventData
  :cognitect.aws.ssm-incidents/EventData)

(s/def
  :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventId
  :cognitect.aws.ssm-incidents/UUID)

(s/def
  :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventReferences
  :cognitect.aws.ssm-incidents/EventReferenceList)

(s/def
  :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/eventType
  :cognitect.aws.ssm-incidents/TimelineEventType)

(s/def
  :cognitect.aws.ssm-incidents.UpdateTimelineEventInput/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.DeleteIncidentRecordInput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.RelatedItem/generatedId
  :cognitect.aws.ssm-incidents/GeneratedId)

(s/def
  :cognitect.aws.ssm-incidents.RelatedItem/identifier
  :cognitect.aws.ssm-incidents/ItemIdentifier)

(s/def
  :cognitect.aws.ssm-incidents.RelatedItem/title
  :cognitect.aws.ssm-incidents/RelatedItemTitleString)

(s/def :cognitect.aws.ssm-incidents.IncidentRecordSummary/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecordSummary/creationTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecordSummary/impact
  :cognitect.aws.ssm-incidents/Impact)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecordSummary/incidentRecordSource
  :cognitect.aws.ssm-incidents/IncidentRecordSource)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecordSummary/resolvedTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecordSummary/status
  :cognitect.aws.ssm-incidents/IncidentRecordStatus)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecordSummary/title
  :cognitect.aws.ssm-incidents/IncidentTitle)

(s/def
  :cognitect.aws.ssm-incidents.PutResourcePolicyOutput/policyId
  :cognitect.aws.ssm-incidents/PolicyId)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/chatChannel
  :cognitect.aws.ssm-incidents/ChatChannel)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/engagements
  :cognitect.aws.ssm-incidents/EngagementSet)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/integrations
  :cognitect.aws.ssm-incidents/Integrations)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/displayName
  :cognitect.aws.ssm-incidents/ResponsePlanDisplayName)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateTags
  :cognitect.aws.ssm-incidents/TagMapUpdate)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateSummary
  :cognitect.aws.ssm-incidents/IncidentSummary)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateImpact
  :cognitect.aws.ssm-incidents/Impact)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/actions
  :cognitect.aws.ssm-incidents/ActionsList)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateNotificationTargets
  :cognitect.aws.ssm-incidents/NotificationTargetSet)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateDedupeString
  :cognitect.aws.ssm-incidents/DedupeString)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/incidentTemplateTitle
  :cognitect.aws.ssm-incidents/IncidentTitle)

(s/def :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.UpdateResponsePlanInput/clientToken
  :cognitect.aws.ssm-incidents/ClientToken)

(s/def :cognitect.aws.ssm-incidents.RegionInfo/sseKmsKeyId :cognitect.aws.ssm-incidents/SseKmsKey)

(s/def :cognitect.aws.ssm-incidents.RegionInfo/status :cognitect.aws.ssm-incidents/RegionStatus)

(s/def :cognitect.aws.ssm-incidents.RegionInfo/statusMessage :cognitect.aws.ssm-incidents/String)

(s/def
  :cognitect.aws.ssm-incidents.RegionInfo/statusUpdateDateTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def :cognitect.aws.ssm-incidents.Action/ssmAutomation :cognitect.aws.ssm-incidents/SsmAutomation)

(s/def
  :cognitect.aws.ssm-incidents.CreateTimelineEventOutput/eventId
  :cognitect.aws.ssm-incidents/UUID)

(s/def
  :cognitect.aws.ssm-incidents.CreateTimelineEventOutput/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.RelatedItemsUpdate/itemToAdd
  :cognitect.aws.ssm-incidents/RelatedItem)

(s/def
  :cognitect.aws.ssm-incidents.RelatedItemsUpdate/itemToRemove
  :cognitect.aws.ssm-incidents/ItemIdentifier)

(s/def
  :cognitect.aws.ssm-incidents.ListTimelineEventsOutput/eventSummaries
  :cognitect.aws.ssm-incidents/EventSummaryList)

(s/def
  :cognitect.aws.ssm-incidents.ListTimelineEventsOutput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def
  :cognitect.aws.ssm-incidents.UntagResourceRequest/resourceArn
  :cognitect.aws.ssm-incidents/String)

(s/def
  :cognitect.aws.ssm-incidents.UntagResourceRequest/tagKeys
  :cognitect.aws.ssm-incidents/TagKeyList)

(s/def :cognitect.aws.ssm-incidents.ItemValue/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.ItemValue/metricDefinition
  :cognitect.aws.ssm-incidents/MetricDefinition)

(s/def
  :cognitect.aws.ssm-incidents.ItemValue/pagerDutyIncidentDetail
  :cognitect.aws.ssm-incidents/PagerDutyIncidentDetail)

(s/def :cognitect.aws.ssm-incidents.ItemValue/url :cognitect.aws.ssm-incidents/Url)

(s/def
  :cognitect.aws.ssm-incidents.ListReplicationSetsInput/maxResults
  :cognitect.aws.ssm-incidents/MaxResults)

(s/def
  :cognitect.aws.ssm-incidents.ListReplicationSetsInput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def :cognitect.aws.ssm-incidents.IncidentRecordSource/createdBy :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecordSource/invokedBy
  :cognitect.aws.ssm-incidents/ServicePrincipal)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecordSource/resourceArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.IncidentRecordSource/source
  :cognitect.aws.ssm-incidents/IncidentSource)

(s/def :cognitect.aws.ssm-incidents.GetResponsePlanInput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.Condition/after :cognitect.aws.ssm-incidents/Timestamp)

(s/def :cognitect.aws.ssm-incidents.Condition/before :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.Condition/equals
  :cognitect.aws.ssm-incidents/AttributeValueList)

(s/def
  :cognitect.aws.ssm-incidents.ListRelatedItemsInput/incidentRecordArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.ListRelatedItemsInput/maxResults
  :cognitect.aws.ssm-incidents/MaxResults)

(s/def
  :cognitect.aws.ssm-incidents.ListRelatedItemsInput/nextToken
  :cognitect.aws.ssm-incidents/NextToken)

(s/def :cognitect.aws.ssm-incidents.ResponsePlanSummary/arn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.ResponsePlanSummary/displayName
  :cognitect.aws.ssm-incidents/ResponsePlanDisplayName)

(s/def
  :cognitect.aws.ssm-incidents.ResponsePlanSummary/name
  :cognitect.aws.ssm-incidents/ResponsePlanName)

(s/def
  :cognitect.aws.ssm-incidents.ListTagsForResourceResponse/tags
  :cognitect.aws.ssm-incidents/TagMap)

(s/def
  :cognitect.aws.ssm-incidents.PagerDutyConfiguration/name
  :cognitect.aws.ssm-incidents/PagerDutyConfigurationNameString)

(s/def
  :cognitect.aws.ssm-incidents.PagerDutyConfiguration/pagerDutyIncidentConfiguration
  :cognitect.aws.ssm-incidents/PagerDutyIncidentConfiguration)

(s/def
  :cognitect.aws.ssm-incidents.PagerDutyConfiguration/secretId
  :cognitect.aws.ssm-incidents/PagerDutyConfigurationSecretIdString)

(s/def
  :cognitect.aws.ssm-incidents.EventReference/relatedItemId
  :cognitect.aws.ssm-incidents/GeneratedId)

(s/def :cognitect.aws.ssm-incidents.EventReference/resource :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.AutomationExecution/ssmExecutionArn
  :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.ItemIdentifier/type :cognitect.aws.ssm-incidents/ItemType)

(s/def :cognitect.aws.ssm-incidents.ItemIdentifier/value :cognitect.aws.ssm-incidents/ItemValue)

(s/def :cognitect.aws.ssm-incidents.DeleteReplicationSetInput/arn :cognitect.aws.ssm-incidents/Arn)

(s/def :cognitect.aws.ssm-incidents.EventSummary/eventId :cognitect.aws.ssm-incidents/UUID)

(s/def
  :cognitect.aws.ssm-incidents.EventSummary/eventReferences
  :cognitect.aws.ssm-incidents/EventReferenceList)

(s/def :cognitect.aws.ssm-incidents.EventSummary/eventTime :cognitect.aws.ssm-incidents/Timestamp)

(s/def
  :cognitect.aws.ssm-incidents.EventSummary/eventType
  :cognitect.aws.ssm-incidents/TimelineEventType)

(s/def
  :cognitect.aws.ssm-incidents.EventSummary/eventUpdatedTime
  :cognitect.aws.ssm-incidents/Timestamp)

(s/def :cognitect.aws.ssm-incidents.EventSummary/incidentRecordArn :cognitect.aws.ssm-incidents/Arn)

(s/def
  :cognitect.aws.ssm-incidents.PagerDutyIncidentDetail/autoResolve
  :cognitect.aws.ssm-incidents/Boolean)

(s/def
  :cognitect.aws.ssm-incidents.PagerDutyIncidentDetail/id
  :cognitect.aws.ssm-incidents/PagerDutyIncidentDetailIdString)

(s/def
  :cognitect.aws.ssm-incidents.PagerDutyIncidentDetail/secretId
  :cognitect.aws.ssm-incidents/PagerDutyIncidentDetailSecretIdString)

