;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.states.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.states/LambdaFunctionTimedOutEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.LambdaFunctionTimedOutEventDetails/error
     :cognitect.aws.states.LambdaFunctionTimedOutEventDetails/cause]))

(s/def
  :cognitect.aws.states/TaskTimedOutEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskTimedOutEventDetails/resourceType
     :cognitect.aws.states.TaskTimedOutEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskTimedOutEventDetails/error
     :cognitect.aws.states.TaskTimedOutEventDetails/cause]))

(s/def
  :cognitect.aws.states/ExecutionAbortedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ExecutionAbortedEventDetails/error
     :cognitect.aws.states.ExecutionAbortedEventDetails/cause]))

(s/def
  :cognitect.aws.states/ListStateMachinesOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListStateMachinesOutput/stateMachines]
    :opt-un
    [:cognitect.aws.states.ListStateMachinesOutput/nextToken]))

(s/def
  :cognitect.aws.states/TaskToken
  (s/with-gen
    (s/and string? #(<= 1 (count %) 1024))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 1024 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/StartExecutionOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.StartExecutionOutput/executionArn
     :cognitect.aws.states.StartExecutionOutput/startDate]))

(s/def :cognitect.aws.states/DeleteActivityOutput (s/keys))

(s/def
  :cognitect.aws.states/Identity
  (s/with-gen
    (s/and string? #(>= 256 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or nil 0) (or 256 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/DeleteActivityInput
  (s/keys :req-un [:cognitect.aws.states.DeleteActivityInput/activityArn]))

(s/def
  :cognitect.aws.states/TaskScheduledEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskScheduledEventDetails/resourceType
     :cognitect.aws.states.TaskScheduledEventDetails/resource
     :cognitect.aws.states.TaskScheduledEventDetails/region
     :cognitect.aws.states.TaskScheduledEventDetails/parameters]
    :opt-un
    [:cognitect.aws.states.TaskScheduledEventDetails/timeoutInSeconds]))

(s/def
  :cognitect.aws.states/DescribeStateMachineForExecutionInput
  (s/keys :req-un [:cognitect.aws.states.DescribeStateMachineForExecutionInput/executionArn]))

(s/def
  :cognitect.aws.states/ExecutionFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ExecutionFailedEventDetails/error
     :cognitect.aws.states.ExecutionFailedEventDetails/cause]))

(s/def :cognitect.aws.states/ActivityList (s/coll-of :cognitect.aws.states/ActivityListItem))

(s/def
  :cognitect.aws.states/ActivityFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ActivityFailedEventDetails/error
     :cognitect.aws.states.ActivityFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/TaskFailedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskFailedEventDetails/resourceType
     :cognitect.aws.states.TaskFailedEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskFailedEventDetails/error
     :cognitect.aws.states.TaskFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/SensitiveCause
  (s/with-gen
    (s/and string? #(<= 0 (count %) 32768))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 0 0) (or 32768 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/LambdaFunctionScheduledEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.LambdaFunctionScheduledEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.LambdaFunctionScheduledEventDetails/timeoutInSeconds
     :cognitect.aws.states.LambdaFunctionScheduledEventDetails/input]))

(s/def
  :cognitect.aws.states/CreateActivityInput
  (s/keys :req-un [:cognitect.aws.states.CreateActivityInput/name]))

(s/def
  :cognitect.aws.states/CreateStateMachineOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.CreateStateMachineOutput/stateMachineArn
     :cognitect.aws.states.CreateStateMachineOutput/creationDate]))

(s/def
  :cognitect.aws.states/ListStateMachinesInput
  (s/keys
    :opt-un
    [:cognitect.aws.states.ListStateMachinesInput/maxResults
     :cognitect.aws.states.ListStateMachinesInput/nextToken]))

(s/def :cognitect.aws.states/SendTaskHeartbeatOutput (s/keys))

(s/def
  :cognitect.aws.states/PageToken
  (s/with-gen
    (s/and string? #(<= 1 (count %) 1024))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 1024 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/StateMachineListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.StateMachineListItem/stateMachineArn
     :cognitect.aws.states.StateMachineListItem/name
     :cognitect.aws.states.StateMachineListItem/creationDate]))

(s/def
  :cognitect.aws.states/StateEnteredEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.StateEnteredEventDetails/name]
    :opt-un
    [:cognitect.aws.states.StateEnteredEventDetails/input]))

(s/def
  :cognitect.aws.states/SensitiveData
  (s/with-gen
    (s/and string? #(>= 32768 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or nil 0) (or 32768 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/ExecutionStartedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ExecutionStartedEventDetails/roleArn
     :cognitect.aws.states.ExecutionStartedEventDetails/input]))

(s/def
  :cognitect.aws.states/ActivityListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.ActivityListItem/activityArn
     :cognitect.aws.states.ActivityListItem/name
     :cognitect.aws.states.ActivityListItem/creationDate]))

(s/def
  :cognitect.aws.states/ActivitySucceededEventDetails
  (s/keys :opt-un [:cognitect.aws.states.ActivitySucceededEventDetails/output]))

(s/def :cognitect.aws.states/SendTaskFailureOutput (s/keys))

(s/def
  :cognitect.aws.states/ExecutionStatus
  #{"TIMED_OUT" "SUCCEEDED" "FAILED" "ABORTED" "RUNNING"})

(s/def
  :cognitect.aws.states/TaskSucceededEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskSucceededEventDetails/resourceType
     :cognitect.aws.states.TaskSucceededEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskSucceededEventDetails/output]))

(s/def :cognitect.aws.states/StateMachineStatus #{"DELETING" "ACTIVE"})

(s/def
  :cognitect.aws.states/ActivityTimedOutEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ActivityTimedOutEventDetails/error
     :cognitect.aws.states.ActivityTimedOutEventDetails/cause]))

(s/def
  :cognitect.aws.states/GetExecutionHistoryInput
  (s/keys
    :req-un
    [:cognitect.aws.states.GetExecutionHistoryInput/executionArn]
    :opt-un
    [:cognitect.aws.states.GetExecutionHistoryInput/maxResults
     :cognitect.aws.states.GetExecutionHistoryInput/nextToken
     :cognitect.aws.states.GetExecutionHistoryInput/reverseOrder]))

(s/def
  :cognitect.aws.states/ListActivitiesOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListActivitiesOutput/activities]
    :opt-un
    [:cognitect.aws.states.ListActivitiesOutput/nextToken]))

(s/def
  :cognitect.aws.states/UpdateStateMachineInput
  (s/keys
    :req-un
    [:cognitect.aws.states.UpdateStateMachineInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.UpdateStateMachineInput/roleArn
     :cognitect.aws.states.UpdateStateMachineInput/definition]))

(s/def :cognitect.aws.states/ReverseOrder boolean?)

(s/def
  :cognitect.aws.states/StopExecutionOutput
  (s/keys :req-un [:cognitect.aws.states.StopExecutionOutput/stopDate]))

(s/def
  :cognitect.aws.states/GetActivityTaskOutput
  (s/keys
    :opt-un
    [:cognitect.aws.states.GetActivityTaskOutput/taskToken
     :cognitect.aws.states.GetActivityTaskOutput/input]))

(s/def
  :cognitect.aws.states/ExecutionTimedOutEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ExecutionTimedOutEventDetails/error
     :cognitect.aws.states.ExecutionTimedOutEventDetails/cause]))

(s/def
  :cognitect.aws.states/TaskSubmittedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskSubmittedEventDetails/resourceType
     :cognitect.aws.states.TaskSubmittedEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskSubmittedEventDetails/output]))

(s/def
  :cognitect.aws.states/SensitiveError
  (s/with-gen
    (s/and string? #(<= 0 (count %) 256))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 0 0) (or 256 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/Definition
  (s/with-gen
    (s/and string? #(<= 1 (count %) 1048576))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 1048576 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.states/SendTaskSuccessOutput (s/keys))

(s/def
  :cognitect.aws.states/ActivityScheduledEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.ActivityScheduledEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.ActivityScheduledEventDetails/heartbeatInSeconds
     :cognitect.aws.states.ActivityScheduledEventDetails/timeoutInSeconds
     :cognitect.aws.states.ActivityScheduledEventDetails/input]))

(s/def :cognitect.aws.states/ExecutionList (s/coll-of :cognitect.aws.states/ExecutionListItem))

(s/def
  :cognitect.aws.states/TaskSubmitFailedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskSubmitFailedEventDetails/resourceType
     :cognitect.aws.states.TaskSubmitFailedEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskSubmitFailedEventDetails/error
     :cognitect.aws.states.TaskSubmitFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/LambdaFunctionStartFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.LambdaFunctionStartFailedEventDetails/error
     :cognitect.aws.states.LambdaFunctionStartFailedEventDetails/cause]))

(s/def :cognitect.aws.states/HistoryEventList (s/coll-of :cognitect.aws.states/HistoryEvent))

(s/def
  :cognitect.aws.states/LambdaFunctionScheduleFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.LambdaFunctionScheduleFailedEventDetails/error
     :cognitect.aws.states.LambdaFunctionScheduleFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/DescribeExecutionInput
  (s/keys :req-un [:cognitect.aws.states.DescribeExecutionInput/executionArn]))

(s/def
  :cognitect.aws.states/ListActivitiesInput
  (s/keys
    :opt-un
    [:cognitect.aws.states.ListActivitiesInput/maxResults
     :cognitect.aws.states.ListActivitiesInput/nextToken]))

(s/def
  :cognitect.aws.states/ActivityStartedEventDetails
  (s/keys :opt-un [:cognitect.aws.states.ActivityStartedEventDetails/workerName]))

(s/def
  :cognitect.aws.states/SendTaskFailureInput
  (s/keys
    :req-un
    [:cognitect.aws.states.SendTaskFailureInput/taskToken]
    :opt-un
    [:cognitect.aws.states.SendTaskFailureInput/error
     :cognitect.aws.states.SendTaskFailureInput/cause]))

(s/def
  :cognitect.aws.states/ListExecutionsOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListExecutionsOutput/executions]
    :opt-un
    [:cognitect.aws.states.ListExecutionsOutput/nextToken]))

(s/def
  :cognitect.aws.states/DescribeStateMachineInput
  (s/keys :req-un [:cognitect.aws.states.DescribeStateMachineInput/stateMachineArn]))

(s/def
  :cognitect.aws.states/CreateActivityOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.CreateActivityOutput/activityArn
     :cognitect.aws.states.CreateActivityOutput/creationDate]))

(s/def
  :cognitect.aws.states/StopExecutionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.StopExecutionInput/executionArn]
    :opt-un
    [:cognitect.aws.states.StopExecutionInput/error
     :cognitect.aws.states.StopExecutionInput/cause]))

(s/def
  :cognitect.aws.states/ExecutionSucceededEventDetails
  (s/keys :opt-un [:cognitect.aws.states.ExecutionSucceededEventDetails/output]))

(s/def
  :cognitect.aws.states/DescribeStateMachineForExecutionOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeStateMachineForExecutionOutput/stateMachineArn
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/name
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/definition
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/roleArn
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/updateDate]))

(s/def
  :cognitect.aws.states/Arn
  (s/with-gen
    (s/and string? #(<= 1 (count %) 256))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 256 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/LambdaFunctionSucceededEventDetails
  (s/keys :opt-un [:cognitect.aws.states.LambdaFunctionSucceededEventDetails/output]))

(s/def
  :cognitect.aws.states/SendTaskSuccessInput
  (s/keys
    :req-un
    [:cognitect.aws.states.SendTaskSuccessInput/taskToken
     :cognitect.aws.states.SendTaskSuccessInput/output]))

(s/def
  :cognitect.aws.states/LambdaFunctionFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.LambdaFunctionFailedEventDetails/error
     :cognitect.aws.states.LambdaFunctionFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/CreateStateMachineInput
  (s/keys
    :req-un
    [:cognitect.aws.states.CreateStateMachineInput/name
     :cognitect.aws.states.CreateStateMachineInput/definition
     :cognitect.aws.states.CreateStateMachineInput/roleArn]))

(s/def
  :cognitect.aws.states/TaskStartFailedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskStartFailedEventDetails/resourceType
     :cognitect.aws.states.TaskStartFailedEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskStartFailedEventDetails/error
     :cognitect.aws.states.TaskStartFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/Name
  (s/with-gen
    (s/and string? #(<= 1 (count %) 80))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 80 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/PageSize
  (s/with-gen
    (s/and int? #(<= 0 % 1000))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 1000 Long/MAX_VALUE))))

(s/def :cognitect.aws.states/DeleteStateMachineOutput (s/keys))

(s/def
  :cognitect.aws.states/TaskStartedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskStartedEventDetails/resourceType
     :cognitect.aws.states.TaskStartedEventDetails/resource]))

(s/def
  :cognitect.aws.states/DescribeActivityOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeActivityOutput/activityArn
     :cognitect.aws.states.DescribeActivityOutput/name
     :cognitect.aws.states.DescribeActivityOutput/creationDate]))

(s/def
  :cognitect.aws.states/ConnectorParameters
  (s/with-gen
    (s/and string? #(<= 0 (count %) 32768))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 0 0) (or 32768 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/StartExecutionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.StartExecutionInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.StartExecutionInput/name
     :cognitect.aws.states.StartExecutionInput/input]))

(s/def
  :cognitect.aws.states/ExecutionListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.ExecutionListItem/executionArn
     :cognitect.aws.states.ExecutionListItem/stateMachineArn
     :cognitect.aws.states.ExecutionListItem/name
     :cognitect.aws.states.ExecutionListItem/status
     :cognitect.aws.states.ExecutionListItem/startDate]
    :opt-un
    [:cognitect.aws.states.ExecutionListItem/stopDate]))

(s/def :cognitect.aws.states/Timestamp inst?)

(s/def
  :cognitect.aws.states/ListExecutionsInput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListExecutionsInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.ListExecutionsInput/statusFilter
     :cognitect.aws.states.ListExecutionsInput/maxResults
     :cognitect.aws.states.ListExecutionsInput/nextToken]))

(s/def
  :cognitect.aws.states/UpdateStateMachineOutput
  (s/keys :req-un [:cognitect.aws.states.UpdateStateMachineOutput/updateDate]))

(s/def
  :cognitect.aws.states/TimeoutInSeconds
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.states/DescribeActivityInput
  (s/keys :req-un [:cognitect.aws.states.DescribeActivityInput/activityArn]))

(s/def
  :cognitect.aws.states/GetExecutionHistoryOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.GetExecutionHistoryOutput/events]
    :opt-un
    [:cognitect.aws.states.GetExecutionHistoryOutput/nextToken]))

(s/def
  :cognitect.aws.states/HistoryEvent
  (s/keys
    :req-un
    [:cognitect.aws.states.HistoryEvent/timestamp
     :cognitect.aws.states.HistoryEvent/type
     :cognitect.aws.states.HistoryEvent/id]
    :opt-un
    [:cognitect.aws.states.HistoryEvent/activityStartedEventDetails
     :cognitect.aws.states.HistoryEvent/executionAbortedEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionTimedOutEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionFailedEventDetails
     :cognitect.aws.states.HistoryEvent/executionStartedEventDetails
     :cognitect.aws.states.HistoryEvent/taskSubmitFailedEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionScheduledEventDetails
     :cognitect.aws.states.HistoryEvent/activitySucceededEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionScheduleFailedEventDetails
     :cognitect.aws.states.HistoryEvent/executionTimedOutEventDetails
     :cognitect.aws.states.HistoryEvent/taskSucceededEventDetails
     :cognitect.aws.states.HistoryEvent/previousEventId
     :cognitect.aws.states.HistoryEvent/executionFailedEventDetails
     :cognitect.aws.states.HistoryEvent/stateExitedEventDetails
     :cognitect.aws.states.HistoryEvent/activityScheduleFailedEventDetails
     :cognitect.aws.states.HistoryEvent/executionSucceededEventDetails
     :cognitect.aws.states.HistoryEvent/activityFailedEventDetails
     :cognitect.aws.states.HistoryEvent/taskSubmittedEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionSucceededEventDetails
     :cognitect.aws.states.HistoryEvent/taskScheduledEventDetails
     :cognitect.aws.states.HistoryEvent/activityScheduledEventDetails
     :cognitect.aws.states.HistoryEvent/stateEnteredEventDetails
     :cognitect.aws.states.HistoryEvent/taskTimedOutEventDetails
     :cognitect.aws.states.HistoryEvent/taskFailedEventDetails
     :cognitect.aws.states.HistoryEvent/taskStartedEventDetails
     :cognitect.aws.states.HistoryEvent/taskStartFailedEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionStartFailedEventDetails
     :cognitect.aws.states.HistoryEvent/activityTimedOutEventDetails]))

(s/def
  :cognitect.aws.states/ActivityScheduleFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ActivityScheduleFailedEventDetails/error
     :cognitect.aws.states.ActivityScheduleFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/GetActivityTaskInput
  (s/keys
    :req-un
    [:cognitect.aws.states.GetActivityTaskInput/activityArn]
    :opt-un
    [:cognitect.aws.states.GetActivityTaskInput/workerName]))

(s/def
  :cognitect.aws.states/DescribeExecutionOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeExecutionOutput/executionArn
     :cognitect.aws.states.DescribeExecutionOutput/stateMachineArn
     :cognitect.aws.states.DescribeExecutionOutput/status
     :cognitect.aws.states.DescribeExecutionOutput/startDate
     :cognitect.aws.states.DescribeExecutionOutput/input]
    :opt-un
    [:cognitect.aws.states.DescribeExecutionOutput/output
     :cognitect.aws.states.DescribeExecutionOutput/name
     :cognitect.aws.states.DescribeExecutionOutput/stopDate]))

(s/def
  :cognitect.aws.states/DescribeStateMachineOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeStateMachineOutput/stateMachineArn
     :cognitect.aws.states.DescribeStateMachineOutput/name
     :cognitect.aws.states.DescribeStateMachineOutput/definition
     :cognitect.aws.states.DescribeStateMachineOutput/roleArn
     :cognitect.aws.states.DescribeStateMachineOutput/creationDate]
    :opt-un
    [:cognitect.aws.states.DescribeStateMachineOutput/status]))

(s/def
  :cognitect.aws.states/SendTaskHeartbeatInput
  (s/keys :req-un [:cognitect.aws.states.SendTaskHeartbeatInput/taskToken]))

(s/def
  :cognitect.aws.states/HistoryEventType
  #{"LambdaFunctionStartFailed" "TaskSubmitted" "LambdaFunctionSucceeded" "ActivityTimedOut"
    "WaitStateAborted" "SucceedStateEntered" "ActivityScheduled" "ParallelStateAborted"
    "ParallelStateSucceeded" "ExecutionTimedOut" "ChoiceStateExited" "TaskSubmitFailed"
    "ExecutionFailed" "TaskSucceeded" "ActivityFailed" "ChoiceStateEntered"
    "LambdaFunctionScheduled" "TaskScheduled" "TaskStarted" "FailStateEntered" "WaitStateExited"
    "ActivityScheduleFailed" "SucceedStateExited" "TaskStateEntered" "PassStateExited"
    "LambdaFunctionFailed" "PassStateEntered" "TaskFailed" "TaskStartFailed"
    "LambdaFunctionTimedOut" "ParallelStateFailed" "ActivitySucceeded" "LambdaFunctionStarted"
    "ExecutionSucceeded" "ActivityStarted" "WaitStateEntered" "ParallelStateEntered"
    "ExecutionStarted" "ExecutionAborted" "ParallelStateStarted" "LambdaFunctionScheduleFailed"
    "ParallelStateExited" "TaskStateAborted" "TaskTimedOut" "TaskStateExited"})

(s/def
  :cognitect.aws.states/DeleteStateMachineInput
  (s/keys :req-un [:cognitect.aws.states.DeleteStateMachineInput/stateMachineArn]))

(s/def
  :cognitect.aws.states/StateMachineList
  (s/coll-of :cognitect.aws.states/StateMachineListItem))

(s/def
  :cognitect.aws.states/EventId
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.states/StateExitedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.StateExitedEventDetails/name]
    :opt-un
    [:cognitect.aws.states.StateExitedEventDetails/output]))

(s/def
  :cognitect.aws.states.LambdaFunctionTimedOutEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.LambdaFunctionTimedOutEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.TaskTimedOutEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskTimedOutEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskTimedOutEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.TaskTimedOutEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.ExecutionAbortedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.ExecutionAbortedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.ListStateMachinesOutput/stateMachines
  :cognitect.aws.states/StateMachineList)

(s/def :cognitect.aws.states.ListStateMachinesOutput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.StartExecutionOutput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StartExecutionOutput/startDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DeleteActivityInput/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.TaskScheduledEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskScheduledEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskScheduledEventDetails/region :cognitect.aws.states/Name)

(s/def
  :cognitect.aws.states.TaskScheduledEventDetails/parameters
  :cognitect.aws.states/ConnectorParameters)

(s/def
  :cognitect.aws.states.TaskScheduledEventDetails/timeoutInSeconds
  :cognitect.aws.states/TimeoutInSeconds)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionInput/executionArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ExecutionFailedEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.ExecutionFailedEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.ActivityFailedEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.ActivityFailedEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.TaskFailedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskFailedEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskFailedEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.TaskFailedEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.LambdaFunctionScheduledEventDetails/resource :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduledEventDetails/input
  :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduledEventDetails/timeoutInSeconds
  :cognitect.aws.states/TimeoutInSeconds)

(s/def :cognitect.aws.states.CreateActivityInput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.CreateStateMachineOutput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.CreateStateMachineOutput/creationDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.ListStateMachinesInput/maxResults :cognitect.aws.states/PageSize)

(s/def :cognitect.aws.states.ListStateMachinesInput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.StateMachineListItem/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StateMachineListItem/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StateMachineListItem/creationDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.StateEnteredEventDetails/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StateEnteredEventDetails/input :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.ExecutionStartedEventDetails/input :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.ExecutionStartedEventDetails/roleArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ActivityListItem/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ActivityListItem/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.ActivityListItem/creationDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.ActivitySucceededEventDetails/output
  :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.TaskSucceededEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSucceededEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSucceededEventDetails/output :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.ActivityTimedOutEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.ActivityTimedOutEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.GetExecutionHistoryInput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.GetExecutionHistoryInput/maxResults :cognitect.aws.states/PageSize)

(s/def
  :cognitect.aws.states.GetExecutionHistoryInput/reverseOrder
  :cognitect.aws.states/ReverseOrder)

(s/def :cognitect.aws.states.GetExecutionHistoryInput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.ListActivitiesOutput/activities :cognitect.aws.states/ActivityList)

(s/def :cognitect.aws.states.ListActivitiesOutput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.UpdateStateMachineInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.UpdateStateMachineInput/definition :cognitect.aws.states/Definition)

(s/def :cognitect.aws.states.UpdateStateMachineInput/roleArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StopExecutionOutput/stopDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.GetActivityTaskOutput/taskToken :cognitect.aws.states/TaskToken)

(s/def :cognitect.aws.states.GetActivityTaskOutput/input :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.ExecutionTimedOutEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.ExecutionTimedOutEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.TaskSubmittedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSubmittedEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSubmittedEventDetails/output :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.ActivityScheduledEventDetails/resource :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.ActivityScheduledEventDetails/input
  :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.ActivityScheduledEventDetails/timeoutInSeconds
  :cognitect.aws.states/TimeoutInSeconds)

(s/def
  :cognitect.aws.states.ActivityScheduledEventDetails/heartbeatInSeconds
  :cognitect.aws.states/TimeoutInSeconds)

(s/def :cognitect.aws.states.TaskSubmitFailedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSubmitFailedEventDetails/resource :cognitect.aws.states/Name)

(s/def
  :cognitect.aws.states.TaskSubmitFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.TaskSubmitFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.LambdaFunctionStartFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.LambdaFunctionStartFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduleFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduleFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.DescribeExecutionInput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ListActivitiesInput/maxResults :cognitect.aws.states/PageSize)

(s/def :cognitect.aws.states.ListActivitiesInput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.ActivityStartedEventDetails/workerName :cognitect.aws.states/Identity)

(s/def :cognitect.aws.states.SendTaskFailureInput/taskToken :cognitect.aws.states/TaskToken)

(s/def :cognitect.aws.states.SendTaskFailureInput/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.SendTaskFailureInput/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.ListExecutionsOutput/executions :cognitect.aws.states/ExecutionList)

(s/def :cognitect.aws.states.ListExecutionsOutput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.DescribeStateMachineInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.CreateActivityOutput/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.CreateActivityOutput/creationDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.StopExecutionInput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StopExecutionInput/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.StopExecutionInput/cause :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.ExecutionSucceededEventDetails/output
  :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/stateMachineArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeStateMachineForExecutionOutput/name :cognitect.aws.states/Name)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/definition
  :cognitect.aws.states/Definition)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/roleArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/updateDate
  :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.LambdaFunctionSucceededEventDetails/output
  :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.SendTaskSuccessInput/taskToken :cognitect.aws.states/TaskToken)

(s/def :cognitect.aws.states.SendTaskSuccessInput/output :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.LambdaFunctionFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.LambdaFunctionFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.CreateStateMachineInput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.CreateStateMachineInput/definition :cognitect.aws.states/Definition)

(s/def :cognitect.aws.states.CreateStateMachineInput/roleArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.TaskStartFailedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskStartFailedEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskStartFailedEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.TaskStartFailedEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.TaskStartedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskStartedEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.DescribeActivityOutput/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeActivityOutput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.DescribeActivityOutput/creationDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.StartExecutionInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StartExecutionInput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StartExecutionInput/input :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.ExecutionListItem/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ExecutionListItem/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ExecutionListItem/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.ExecutionListItem/status :cognitect.aws.states/ExecutionStatus)

(s/def :cognitect.aws.states.ExecutionListItem/startDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.ExecutionListItem/stopDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.ListExecutionsInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ListExecutionsInput/statusFilter :cognitect.aws.states/ExecutionStatus)

(s/def :cognitect.aws.states.ListExecutionsInput/maxResults :cognitect.aws.states/PageSize)

(s/def :cognitect.aws.states.ListExecutionsInput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.UpdateStateMachineOutput/updateDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DescribeActivityInput/activityArn :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.GetExecutionHistoryOutput/events
  :cognitect.aws.states/HistoryEventList)

(s/def :cognitect.aws.states.GetExecutionHistoryOutput/nextToken :cognitect.aws.states/PageToken)

(s/def
  :cognitect.aws.states.HistoryEvent/taskScheduledEventDetails
  :cognitect.aws.states/TaskScheduledEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionTimedOutEventDetails
  :cognitect.aws.states/ExecutionTimedOutEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activityTimedOutEventDetails
  :cognitect.aws.states/ActivityTimedOutEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskStartedEventDetails
  :cognitect.aws.states/TaskStartedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/stateEnteredEventDetails
  :cognitect.aws.states/StateEnteredEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionScheduleFailedEventDetails
  :cognitect.aws.states/LambdaFunctionScheduleFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionSucceededEventDetails
  :cognitect.aws.states/ExecutionSucceededEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskStartFailedEventDetails
  :cognitect.aws.states/TaskStartFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/stateExitedEventDetails
  :cognitect.aws.states/StateExitedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activitySucceededEventDetails
  :cognitect.aws.states/ActivitySucceededEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionStartFailedEventDetails
  :cognitect.aws.states/LambdaFunctionStartFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskSubmittedEventDetails
  :cognitect.aws.states/TaskSubmittedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionFailedEventDetails
  :cognitect.aws.states/ExecutionFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionTimedOutEventDetails
  :cognitect.aws.states/LambdaFunctionTimedOutEventDetails)

(s/def :cognitect.aws.states.HistoryEvent/type :cognitect.aws.states/HistoryEventType)

(s/def
  :cognitect.aws.states.HistoryEvent/activityStartedEventDetails
  :cognitect.aws.states/ActivityStartedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activityFailedEventDetails
  :cognitect.aws.states/ActivityFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionStartedEventDetails
  :cognitect.aws.states/ExecutionStartedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionScheduledEventDetails
  :cognitect.aws.states/LambdaFunctionScheduledEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskSucceededEventDetails
  :cognitect.aws.states/TaskSucceededEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activityScheduledEventDetails
  :cognitect.aws.states/ActivityScheduledEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskTimedOutEventDetails
  :cognitect.aws.states/TaskTimedOutEventDetails)

(s/def :cognitect.aws.states.HistoryEvent/id :cognitect.aws.states/EventId)

(s/def :cognitect.aws.states.HistoryEvent/previousEventId :cognitect.aws.states/EventId)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionSucceededEventDetails
  :cognitect.aws.states/LambdaFunctionSucceededEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskFailedEventDetails
  :cognitect.aws.states/TaskFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionAbortedEventDetails
  :cognitect.aws.states/ExecutionAbortedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskSubmitFailedEventDetails
  :cognitect.aws.states/TaskSubmitFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activityScheduleFailedEventDetails
  :cognitect.aws.states/ActivityScheduleFailedEventDetails)

(s/def :cognitect.aws.states.HistoryEvent/timestamp :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionFailedEventDetails
  :cognitect.aws.states/LambdaFunctionFailedEventDetails)

(s/def
  :cognitect.aws.states.ActivityScheduleFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.ActivityScheduleFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.GetActivityTaskInput/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.GetActivityTaskInput/workerName :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.DescribeExecutionOutput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeExecutionOutput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeExecutionOutput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.DescribeExecutionOutput/status :cognitect.aws.states/ExecutionStatus)

(s/def :cognitect.aws.states.DescribeExecutionOutput/startDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DescribeExecutionOutput/stopDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DescribeExecutionOutput/input :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.DescribeExecutionOutput/output :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/name :cognitect.aws.states/Name)

(s/def
  :cognitect.aws.states.DescribeStateMachineOutput/status
  :cognitect.aws.states/StateMachineStatus)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/definition :cognitect.aws.states/Definition)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/roleArn :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.DescribeStateMachineOutput/creationDate
  :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.SendTaskHeartbeatInput/taskToken :cognitect.aws.states/TaskToken)

(s/def :cognitect.aws.states.DeleteStateMachineInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StateExitedEventDetails/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StateExitedEventDetails/output :cognitect.aws.states/SensitiveData)

