;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.states.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.states/HistoryEventExecutionDataDetails
  (s/keys :opt-un [:cognitect.aws.states.HistoryEventExecutionDataDetails/truncated]))

(s/def
  :cognitect.aws.states/ValidateStateMachineDefinitionDiagnostic
  (s/keys
    :req-un
    [:cognitect.aws.states.ValidateStateMachineDefinitionDiagnostic/severity
     :cognitect.aws.states.ValidateStateMachineDefinitionDiagnostic/code
     :cognitect.aws.states.ValidateStateMachineDefinitionDiagnostic/message]
    :opt-un
    [:cognitect.aws.states.ValidateStateMachineDefinitionDiagnostic/location]))

(s/def
  :cognitect.aws.states/ExecutionLimitExceeded
  (s/keys :opt-un [:cognitect.aws.states.ExecutionLimitExceeded/message]))

(s/def
  :cognitect.aws.states/UnsignedInteger
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.states/LambdaFunctionTimedOutEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.LambdaFunctionTimedOutEventDetails/error
     :cognitect.aws.states.LambdaFunctionTimedOutEventDetails/cause]))

(s/def
  :cognitect.aws.states/TaskTimedOutEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskTimedOutEventDetails/resourceType
     :cognitect.aws.states.TaskTimedOutEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskTimedOutEventDetails/error
     :cognitect.aws.states.TaskTimedOutEventDetails/cause]))

(s/def
  :cognitect.aws.states/ServiceQuotaExceededException
  (s/keys :opt-un [:cognitect.aws.states.ServiceQuotaExceededException/message]))

(s/def
  :cognitect.aws.states/ExecutionAbortedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ExecutionAbortedEventDetails/error
     :cognitect.aws.states.ExecutionAbortedEventDetails/cause]))

(s/def
  :cognitect.aws.states/ExecutionRedriveFilter
  (s/spec string? :gen #(s/gen #{"NOT_REDRIVEN" "REDRIVEN"})))

(s/def
  :cognitect.aws.states/ListTagsForResourceInput
  (s/keys :req-un [:cognitect.aws.states.ListTagsForResourceInput/resourceArn]))

(s/def
  :cognitect.aws.states/TaskCredentials
  (s/keys :opt-un [:cognitect.aws.states.TaskCredentials/roleArn]))

(s/def
  :cognitect.aws.states/CharacterRestrictedName
  (s/spec
    #(re-matches (re-pattern "^(?=.*[a-zA-Z_\\-\\.])[a-zA-Z0-9_\\-\\.]+$") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.states/IncludeExecutionDataGetExecutionHistory boolean?)

(s/def
  :cognitect.aws.states/ListStateMachinesOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListStateMachinesOutput/stateMachines]
    :opt-un
    [:cognitect.aws.states.ListStateMachinesOutput/nextToken]))

(s/def
  :cognitect.aws.states/KmsAccessDeniedException
  (s/keys :opt-un [:cognitect.aws.states.KmsAccessDeniedException/message]))

(s/def
  :cognitect.aws.states/ListTagsForResourceOutput
  (s/keys :opt-un [:cognitect.aws.states.ListTagsForResourceOutput/tags]))

(s/def
  :cognitect.aws.states/MapStateStartedEventDetails
  (s/keys :opt-un [:cognitect.aws.states.MapStateStartedEventDetails/length]))

(s/def
  :cognitect.aws.states/TaskToken
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.states/HTTPProtocol string?)

(s/def
  :cognitect.aws.states/IncludedData
  (s/spec string? :gen #(s/gen #{"METADATA_ONLY" "ALL_DATA"})))

(s/def
  :cognitect.aws.states/ListStateMachineVersionsInput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListStateMachineVersionsInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.ListStateMachineVersionsInput/maxResults
     :cognitect.aws.states.ListStateMachineVersionsInput/nextToken]))

(s/def
  :cognitect.aws.states/Tag
  (s/keys :opt-un [:cognitect.aws.states.Tag/key :cognitect.aws.states.Tag/value]))

(s/def
  :cognitect.aws.states/StartExecutionOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.StartExecutionOutput/executionArn
     :cognitect.aws.states.StartExecutionOutput/startDate]))

(s/def
  :cognitect.aws.states/EvaluationFailedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.EvaluationFailedEventDetails/state]
    :opt-un
    [:cognitect.aws.states.EvaluationFailedEventDetails/error
     :cognitect.aws.states.EvaluationFailedEventDetails/cause
     :cognitect.aws.states.EvaluationFailedEventDetails/location]))

(s/def :cognitect.aws.states/DeleteActivityOutput (s/keys))

(s/def
  :cognitect.aws.states/VersionDescription
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/CreateStateMachineAliasInput
  (s/keys
    :req-un
    [:cognitect.aws.states.CreateStateMachineAliasInput/name
     :cognitect.aws.states.CreateStateMachineAliasInput/routingConfiguration]
    :opt-un
    [:cognitect.aws.states.CreateStateMachineAliasInput/description]))

(s/def
  :cognitect.aws.states/ExecutionDoesNotExist
  (s/keys :opt-un [:cognitect.aws.states.ExecutionDoesNotExist/message]))

(s/def :cognitect.aws.states/HTTPStatusMessage string?)

(s/def :cognitect.aws.states/LogLevel (s/spec string? :gen #(s/gen #{"ERROR" "FATAL" "OFF" "ALL"})))

(s/def
  :cognitect.aws.states/ValidateStateMachineDefinitionDiagnosticList
  (s/coll-of :cognitect.aws.states/ValidateStateMachineDefinitionDiagnostic))

(s/def
  :cognitect.aws.states/RedriveExecutionOutput
  (s/keys :req-un [:cognitect.aws.states.RedriveExecutionOutput/redriveDate]))

(s/def
  :cognitect.aws.states/ValidateStateMachineDefinitionOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ValidateStateMachineDefinitionOutput/result
     :cognitect.aws.states.ValidateStateMachineDefinitionOutput/diagnostics]
    :opt-un
    [:cognitect.aws.states.ValidateStateMachineDefinitionOutput/truncated]))

(s/def
  :cognitect.aws.states/ListStateMachineVersionsOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListStateMachineVersionsOutput/stateMachineVersions]
    :opt-un
    [:cognitect.aws.states.ListStateMachineVersionsOutput/nextToken]))

(s/def
  :cognitect.aws.states/RedriveExecutionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.RedriveExecutionInput/executionArn]
    :opt-un
    [:cognitect.aws.states.RedriveExecutionInput/clientToken]))

(s/def
  :cognitect.aws.states/ValidateStateMachineDefinitionMaxResult
  (s/spec (s/and int? #(<= 0 % 100)) :gen #(gen/choose 0 100)))

(s/def
  :cognitect.aws.states/Identity
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.states/DeleteStateMachineAliasOutput (s/keys))

(s/def
  :cognitect.aws.states/InvalidToken
  (s/keys :opt-un [:cognitect.aws.states.InvalidToken/message]))

(s/def
  :cognitect.aws.states/StateMachineVersionListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.StateMachineVersionListItem/stateMachineVersionArn
     :cognitect.aws.states.StateMachineVersionListItem/creationDate]))

(s/def
  :cognitect.aws.states/DeleteActivityInput
  (s/keys :req-un [:cognitect.aws.states.DeleteActivityInput/activityArn]))

(s/def
  :cognitect.aws.states/StateMachineAlreadyExists
  (s/keys :opt-un [:cognitect.aws.states.StateMachineAlreadyExists/message]))

(s/def
  :cognitect.aws.states/BilledDuration
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.states/TaskScheduledEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskScheduledEventDetails/resourceType
     :cognitect.aws.states.TaskScheduledEventDetails/resource
     :cognitect.aws.states.TaskScheduledEventDetails/region
     :cognitect.aws.states.TaskScheduledEventDetails/parameters]
    :opt-un
    [:cognitect.aws.states.TaskScheduledEventDetails/taskCredentials
     :cognitect.aws.states.TaskScheduledEventDetails/heartbeatInSeconds
     :cognitect.aws.states.TaskScheduledEventDetails/timeoutInSeconds]))

(s/def
  :cognitect.aws.states/DescribeStateMachineForExecutionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeStateMachineForExecutionInput/executionArn]
    :opt-un
    [:cognitect.aws.states.DescribeStateMachineForExecutionInput/includedData]))

(s/def
  :cognitect.aws.states/InvalidExecutionInput
  (s/keys :opt-un [:cognitect.aws.states.InvalidExecutionInput/message]))

(s/def
  :cognitect.aws.states/ExecutionFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ExecutionFailedEventDetails/error
     :cognitect.aws.states.ExecutionFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/DeleteStateMachineAliasInput
  (s/keys :req-un [:cognitect.aws.states.DeleteStateMachineAliasInput/stateMachineAliasArn]))

(s/def :cognitect.aws.states/ActivityList (s/coll-of :cognitect.aws.states/ActivityListItem))

(s/def
  :cognitect.aws.states/KmsThrottlingException
  (s/keys :opt-un [:cognitect.aws.states.KmsThrottlingException/message]))

(s/def
  :cognitect.aws.states/StartSyncExecutionOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.StartSyncExecutionOutput/executionArn
     :cognitect.aws.states.StartSyncExecutionOutput/startDate
     :cognitect.aws.states.StartSyncExecutionOutput/stopDate
     :cognitect.aws.states.StartSyncExecutionOutput/status]
    :opt-un
    [:cognitect.aws.states.StartSyncExecutionOutput/traceHeader
     :cognitect.aws.states.StartSyncExecutionOutput/outputDetails
     :cognitect.aws.states.StartSyncExecutionOutput/output
     :cognitect.aws.states.StartSyncExecutionOutput/billingDetails
     :cognitect.aws.states.StartSyncExecutionOutput/error
     :cognitect.aws.states.StartSyncExecutionOutput/name
     :cognitect.aws.states.StartSyncExecutionOutput/cause
     :cognitect.aws.states.StartSyncExecutionOutput/input
     :cognitect.aws.states.StartSyncExecutionOutput/inputDetails
     :cognitect.aws.states.StartSyncExecutionOutput/stateMachineArn]))

(s/def
  :cognitect.aws.states/ValidationException
  (s/keys
    :opt-un
    [:cognitect.aws.states.ValidationException/message
     :cognitect.aws.states.ValidationException/reason]))

(s/def
  :cognitect.aws.states/ActivityFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ActivityFailedEventDetails/error
     :cognitect.aws.states.ActivityFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/DescribeStateMachineAliasInput
  (s/keys :req-un [:cognitect.aws.states.DescribeStateMachineAliasInput/stateMachineAliasArn]))

(s/def
  :cognitect.aws.states/UpdateMapRunInput
  (s/keys
    :req-un
    [:cognitect.aws.states.UpdateMapRunInput/mapRunArn]
    :opt-un
    [:cognitect.aws.states.UpdateMapRunInput/toleratedFailurePercentage
     :cognitect.aws.states.UpdateMapRunInput/toleratedFailureCount
     :cognitect.aws.states.UpdateMapRunInput/maxConcurrency]))

(s/def
  :cognitect.aws.states/TaskFailedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskFailedEventDetails/resourceType
     :cognitect.aws.states.TaskFailedEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskFailedEventDetails/error
     :cognitect.aws.states.TaskFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/SensitiveCause
  (s/spec
    (s/and string? #(<= 0 (count %) 32768))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 32768) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.states/ErrorMessage string?)

(s/def :cognitect.aws.states/TagList (s/coll-of :cognitect.aws.states/Tag))

(s/def
  :cognitect.aws.states/LambdaFunctionScheduledEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.LambdaFunctionScheduledEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.LambdaFunctionScheduledEventDetails/taskCredentials
     :cognitect.aws.states.LambdaFunctionScheduledEventDetails/timeoutInSeconds
     :cognitect.aws.states.LambdaFunctionScheduledEventDetails/input
     :cognitect.aws.states.LambdaFunctionScheduledEventDetails/inputDetails]))

(s/def
  :cognitect.aws.states/ValidationExceptionReason
  (s/spec
    string?
    :gen
    #(s/gen
      #{"API_DOES_NOT_SUPPORT_LABELED_ARNS"
        "CANNOT_UPDATE_COMPLETED_MAP_RUN"
        "INVALID_ROUTING_CONFIGURATION"
        "MISSING_REQUIRED_PARAMETER"})))

(s/def :cognitect.aws.states/LogDestinationList (s/coll-of :cognitect.aws.states/LogDestination))

(s/def
  :cognitect.aws.states/MapRunStatus
  (s/spec string? :gen #(s/gen #{"SUCCEEDED" "FAILED" "ABORTED" "RUNNING"})))

(s/def
  :cognitect.aws.states/MaxConcurrency
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.states/CreateActivityInput
  (s/keys
    :req-un
    [:cognitect.aws.states.CreateActivityInput/name]
    :opt-un
    [:cognitect.aws.states.CreateActivityInput/tags
     :cognitect.aws.states.CreateActivityInput/encryptionConfiguration]))

(s/def
  :cognitect.aws.states/BilledMemoryUsed
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.states/CloudWatchLogsLogGroup
  (s/keys :opt-un [:cognitect.aws.states.CloudWatchLogsLogGroup/logGroupArn]))

(s/def
  :cognitect.aws.states/CreateStateMachineOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.CreateStateMachineOutput/stateMachineArn
     :cognitect.aws.states.CreateStateMachineOutput/creationDate]
    :opt-un
    [:cognitect.aws.states.CreateStateMachineOutput/stateMachineVersionArn]))

(s/def
  :cognitect.aws.states/ListStateMachinesInput
  (s/keys
    :opt-un
    [:cognitect.aws.states.ListStateMachinesInput/maxResults
     :cognitect.aws.states.ListStateMachinesInput/nextToken]))

(s/def :cognitect.aws.states/SendTaskHeartbeatOutput (s/keys))

(s/def :cognitect.aws.states/VariableValue string?)

(s/def
  :cognitect.aws.states/PageToken
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/LogDestination
  (s/keys :opt-un [:cognitect.aws.states.LogDestination/cloudWatchLogsLogGroup]))

(s/def
  :cognitect.aws.states/StateMachineListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.StateMachineListItem/stateMachineArn
     :cognitect.aws.states.StateMachineListItem/name
     :cognitect.aws.states.StateMachineListItem/type
     :cognitect.aws.states.StateMachineListItem/creationDate]))

(s/def
  :cognitect.aws.states/StateMachineDeleting
  (s/keys :opt-un [:cognitect.aws.states.StateMachineDeleting/message]))

(s/def
  :cognitect.aws.states/StateEnteredEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.StateEnteredEventDetails/name]
    :opt-un
    [:cognitect.aws.states.StateEnteredEventDetails/input
     :cognitect.aws.states.StateEnteredEventDetails/inputDetails]))

(s/def
  :cognitect.aws.states/InspectionData
  (s/keys
    :opt-un
    [:cognitect.aws.states.InspectionData/afterInputPath
     :cognitect.aws.states.InspectionData/afterResultSelector
     :cognitect.aws.states.InspectionData/afterParameters
     :cognitect.aws.states.InspectionData/request
     :cognitect.aws.states.InspectionData/variables
     :cognitect.aws.states.InspectionData/input
     :cognitect.aws.states.InspectionData/afterResultPath
     :cognitect.aws.states.InspectionData/response
     :cognitect.aws.states.InspectionData/afterArguments
     :cognitect.aws.states.InspectionData/result]))

(s/def
  :cognitect.aws.states/SensitiveData
  (s/spec
    (s/and string? #(>= 262144 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 262144) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/MapRunItemCounts
  (s/keys
    :req-un
    [:cognitect.aws.states.MapRunItemCounts/pending
     :cognitect.aws.states.MapRunItemCounts/running
     :cognitect.aws.states.MapRunItemCounts/succeeded
     :cognitect.aws.states.MapRunItemCounts/failed
     :cognitect.aws.states.MapRunItemCounts/timedOut
     :cognitect.aws.states.MapRunItemCounts/aborted
     :cognitect.aws.states.MapRunItemCounts/total
     :cognitect.aws.states.MapRunItemCounts/resultsWritten]
    :opt-un
    [:cognitect.aws.states.MapRunItemCounts/failuresNotRedrivable
     :cognitect.aws.states.MapRunItemCounts/pendingRedrive]))

(s/def
  :cognitect.aws.states/ExecutionStartedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ExecutionStartedEventDetails/stateMachineAliasArn
     :cognitect.aws.states.ExecutionStartedEventDetails/stateMachineVersionArn
     :cognitect.aws.states.ExecutionStartedEventDetails/roleArn
     :cognitect.aws.states.ExecutionStartedEventDetails/input
     :cognitect.aws.states.ExecutionStartedEventDetails/inputDetails]))

(s/def
  :cognitect.aws.states/ActivityDoesNotExist
  (s/keys :opt-un [:cognitect.aws.states.ActivityDoesNotExist/message]))

(s/def
  :cognitect.aws.states/ActivityListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.ActivityListItem/activityArn
     :cognitect.aws.states.ActivityListItem/name
     :cognitect.aws.states.ActivityListItem/creationDate]))

(s/def
  :cognitect.aws.states/CloudWatchEventsExecutionDataDetails
  (s/keys :opt-un [:cognitect.aws.states.CloudWatchEventsExecutionDataDetails/included]))

(s/def
  :cognitect.aws.states/DescribeMapRunOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeMapRunOutput/mapRunArn
     :cognitect.aws.states.DescribeMapRunOutput/executionArn
     :cognitect.aws.states.DescribeMapRunOutput/status
     :cognitect.aws.states.DescribeMapRunOutput/startDate
     :cognitect.aws.states.DescribeMapRunOutput/maxConcurrency
     :cognitect.aws.states.DescribeMapRunOutput/toleratedFailurePercentage
     :cognitect.aws.states.DescribeMapRunOutput/toleratedFailureCount
     :cognitect.aws.states.DescribeMapRunOutput/itemCounts
     :cognitect.aws.states.DescribeMapRunOutput/executionCounts]
    :opt-un
    [:cognitect.aws.states.DescribeMapRunOutput/redriveDate
     :cognitect.aws.states.DescribeMapRunOutput/redriveCount
     :cognitect.aws.states.DescribeMapRunOutput/stopDate]))

(s/def
  :cognitect.aws.states/ActivitySucceededEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ActivitySucceededEventDetails/outputDetails
     :cognitect.aws.states.ActivitySucceededEventDetails/output]))

(s/def :cognitect.aws.states/SendTaskFailureOutput (s/keys))

(s/def
  :cognitect.aws.states/ExecutionStatus
  (s/spec
    string?
    :gen
    #(s/gen #{"TIMED_OUT" "PENDING_REDRIVE" "SUCCEEDED" "FAILED" "ABORTED" "RUNNING"})))

(s/def
  :cognitect.aws.states/RoutingConfigurationList
  (s/coll-of :cognitect.aws.states/RoutingConfigurationListItem :min-count 1 :max-count 2))

(s/def
  :cognitect.aws.states/TracingConfiguration
  (s/keys :opt-un [:cognitect.aws.states.TracingConfiguration/enabled]))

(s/def
  :cognitect.aws.states/TooManyTags
  (s/keys
    :opt-un
    [:cognitect.aws.states.TooManyTags/message :cognitect.aws.states.TooManyTags/resourceName]))

(s/def
  :cognitect.aws.states/ActivityLimitExceeded
  (s/keys :opt-un [:cognitect.aws.states.ActivityLimitExceeded/message]))

(s/def
  :cognitect.aws.states/TaskSucceededEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskSucceededEventDetails/resourceType
     :cognitect.aws.states.TaskSucceededEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskSucceededEventDetails/outputDetails
     :cognitect.aws.states.TaskSucceededEventDetails/output]))

(s/def
  :cognitect.aws.states/StateMachineStatus
  (s/spec string? :gen #(s/gen #{"DELETING" "ACTIVE"})))

(s/def
  :cognitect.aws.states/ActivityTimedOutEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ActivityTimedOutEventDetails/error
     :cognitect.aws.states.ActivityTimedOutEventDetails/cause]))

(s/def :cognitect.aws.states/IncludeExecutionData boolean?)

(s/def :cognitect.aws.states/HTTPBody string?)

(s/def :cognitect.aws.states/includedDetails boolean?)

(s/def
  :cognitect.aws.states/TagResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.states.TagResourceInput/resourceArn
     :cognitect.aws.states.TagResourceInput/tags]))

(s/def
  :cognitect.aws.states/StateMachineDoesNotExist
  (s/keys :opt-un [:cognitect.aws.states.StateMachineDoesNotExist/message]))

(s/def
  :cognitect.aws.states/InvalidOutput
  (s/keys :opt-un [:cognitect.aws.states.InvalidOutput/message]))

(s/def
  :cognitect.aws.states/GetExecutionHistoryInput
  (s/keys
    :req-un
    [:cognitect.aws.states.GetExecutionHistoryInput/executionArn]
    :opt-un
    [:cognitect.aws.states.GetExecutionHistoryInput/maxResults
     :cognitect.aws.states.GetExecutionHistoryInput/nextToken
     :cognitect.aws.states.GetExecutionHistoryInput/reverseOrder
     :cognitect.aws.states.GetExecutionHistoryInput/includeExecutionData]))

(s/def
  :cognitect.aws.states/TaskTimedOut
  (s/keys :opt-un [:cognitect.aws.states.TaskTimedOut/message]))

(s/def
  :cognitect.aws.states/ListActivitiesOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListActivitiesOutput/activities]
    :opt-un
    [:cognitect.aws.states.ListActivitiesOutput/nextToken]))

(s/def
  :cognitect.aws.states/ToleratedFailureCount
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.states/UpdateStateMachineInput
  (s/keys
    :req-un
    [:cognitect.aws.states.UpdateStateMachineInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.UpdateStateMachineInput/roleArn
     :cognitect.aws.states.UpdateStateMachineInput/encryptionConfiguration
     :cognitect.aws.states.UpdateStateMachineInput/publish
     :cognitect.aws.states.UpdateStateMachineInput/definition
     :cognitect.aws.states.UpdateStateMachineInput/tracingConfiguration
     :cognitect.aws.states.UpdateStateMachineInput/loggingConfiguration
     :cognitect.aws.states.UpdateStateMachineInput/versionDescription]))

(s/def :cognitect.aws.states/ReverseOrder boolean?)

(s/def
  :cognitect.aws.states/InspectionDataResponse
  (s/keys
    :opt-un
    [:cognitect.aws.states.InspectionDataResponse/protocol
     :cognitect.aws.states.InspectionDataResponse/body
     :cognitect.aws.states.InspectionDataResponse/statusCode
     :cognitect.aws.states.InspectionDataResponse/statusMessage
     :cognitect.aws.states.InspectionDataResponse/headers]))

(s/def :cognitect.aws.states/TagResourceOutput (s/keys))

(s/def
  :cognitect.aws.states/ActivityAlreadyExists
  (s/keys :opt-un [:cognitect.aws.states.ActivityAlreadyExists/message]))

(s/def
  :cognitect.aws.states/StopExecutionOutput
  (s/keys :req-un [:cognitect.aws.states.StopExecutionOutput/stopDate]))

(s/def
  :cognitect.aws.states/DescribeMapRunInput
  (s/keys :req-un [:cognitect.aws.states.DescribeMapRunInput/mapRunArn]))

(s/def
  :cognitect.aws.states/InvalidEncryptionConfiguration
  (s/keys :opt-un [:cognitect.aws.states.InvalidEncryptionConfiguration/message]))

(s/def
  :cognitect.aws.states/GetActivityTaskOutput
  (s/keys
    :opt-un
    [:cognitect.aws.states.GetActivityTaskOutput/taskToken
     :cognitect.aws.states.GetActivityTaskOutput/input]))

(s/def
  :cognitect.aws.states/ExecutionTimedOutEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ExecutionTimedOutEventDetails/error
     :cognitect.aws.states.ExecutionTimedOutEventDetails/cause]))

(s/def :cognitect.aws.states/ValidateStateMachineDefinitionLocation string?)

(s/def
  :cognitect.aws.states/MissingRequiredParameter
  (s/keys :opt-un [:cognitect.aws.states.MissingRequiredParameter/message]))

(s/def
  :cognitect.aws.states/InspectionDataRequest
  (s/keys
    :opt-un
    [:cognitect.aws.states.InspectionDataRequest/protocol
     :cognitect.aws.states.InspectionDataRequest/url
     :cognitect.aws.states.InspectionDataRequest/body
     :cognitect.aws.states.InspectionDataRequest/method
     :cognitect.aws.states.InspectionDataRequest/headers]))

(s/def
  :cognitect.aws.states/TaskSubmittedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskSubmittedEventDetails/resourceType
     :cognitect.aws.states.TaskSubmittedEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskSubmittedEventDetails/outputDetails
     :cognitect.aws.states.TaskSubmittedEventDetails/output]))

(s/def :cognitect.aws.states/MapRunList (s/coll-of :cognitect.aws.states/MapRunListItem))

(s/def
  :cognitect.aws.states/StateName
  (s/spec
    (s/and string? #(<= 1 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 80) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/SensitiveError
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/DescribeStateMachineAliasOutput
  (s/keys
    :opt-un
    [:cognitect.aws.states.DescribeStateMachineAliasOutput/creationDate
     :cognitect.aws.states.DescribeStateMachineAliasOutput/updateDate
     :cognitect.aws.states.DescribeStateMachineAliasOutput/stateMachineAliasArn
     :cognitect.aws.states.DescribeStateMachineAliasOutput/routingConfiguration
     :cognitect.aws.states.DescribeStateMachineAliasOutput/name
     :cognitect.aws.states.DescribeStateMachineAliasOutput/description]))

(s/def
  :cognitect.aws.states/Definition
  (s/spec
    (s/and string? #(<= 1 (count %) 1048576))
    :gen
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose 1 1048576) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.states/Publish boolean?)

(s/def
  :cognitect.aws.states/AssignedVariablesDetails
  (s/keys :opt-un [:cognitect.aws.states.AssignedVariablesDetails/truncated]))

(s/def :cognitect.aws.states/SendTaskSuccessOutput (s/keys))

(s/def
  :cognitect.aws.states/ActivityScheduledEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.ActivityScheduledEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.ActivityScheduledEventDetails/heartbeatInSeconds
     :cognitect.aws.states.ActivityScheduledEventDetails/timeoutInSeconds
     :cognitect.aws.states.ActivityScheduledEventDetails/input
     :cognitect.aws.states.ActivityScheduledEventDetails/inputDetails]))

(s/def
  :cognitect.aws.states/PublishStateMachineVersionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.PublishStateMachineVersionInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.PublishStateMachineVersionInput/revisionId
     :cognitect.aws.states.PublishStateMachineVersionInput/description]))

(s/def
  :cognitect.aws.states/InspectionLevel
  (s/spec string? :gen #(s/gen #{"TRACE" "DEBUG" "INFO"})))

(s/def
  :cognitect.aws.states/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/EncryptionType
  (s/spec string? :gen #(s/gen #{"CUSTOMER_MANAGED_KMS_KEY" "AWS_OWNED_KEY"})))

(s/def :cognitect.aws.states/ExecutionList (s/coll-of :cognitect.aws.states/ExecutionListItem))

(s/def
  :cognitect.aws.states/RedriveCount
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.states/InvalidDefinition
  (s/keys :opt-un [:cognitect.aws.states.InvalidDefinition/message]))

(s/def
  :cognitect.aws.states/TaskSubmitFailedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskSubmitFailedEventDetails/resourceType
     :cognitect.aws.states.TaskSubmitFailedEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskSubmitFailedEventDetails/error
     :cognitect.aws.states.TaskSubmitFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/LambdaFunctionStartFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.LambdaFunctionStartFailedEventDetails/error
     :cognitect.aws.states.LambdaFunctionStartFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/KmsKeyState
  (s/spec
    string?
    :gen
    #(s/gen #{"DISABLED" "PENDING_IMPORT" "UNAVAILABLE" "CREATING" "PENDING_DELETION"})))

(s/def :cognitect.aws.states/ValidateStateMachineDefinitionMessage string?)

(s/def :cognitect.aws.states/HistoryEventList (s/coll-of :cognitect.aws.states/HistoryEvent))

(s/def
  :cognitect.aws.states/LambdaFunctionScheduleFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.LambdaFunctionScheduleFailedEventDetails/error
     :cognitect.aws.states.LambdaFunctionScheduleFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/ActivityWorkerLimitExceeded
  (s/keys :opt-un [:cognitect.aws.states.ActivityWorkerLimitExceeded/message]))

(s/def
  :cognitect.aws.states/StartSyncExecutionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.StartSyncExecutionInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.StartSyncExecutionInput/traceHeader
     :cognitect.aws.states.StartSyncExecutionInput/name
     :cognitect.aws.states.StartSyncExecutionInput/input
     :cognitect.aws.states.StartSyncExecutionInput/includedData]))

(s/def
  :cognitect.aws.states/TestExecutionStatus
  (s/spec string? :gen #(s/gen #{"CAUGHT_ERROR" "RETRIABLE" "SUCCEEDED" "FAILED"})))

(s/def
  :cognitect.aws.states/DescribeExecutionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeExecutionInput/executionArn]
    :opt-un
    [:cognitect.aws.states.DescribeExecutionInput/includedData]))

(s/def
  :cognitect.aws.states/MapRunListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.MapRunListItem/executionArn
     :cognitect.aws.states.MapRunListItem/mapRunArn
     :cognitect.aws.states.MapRunListItem/stateMachineArn
     :cognitect.aws.states.MapRunListItem/startDate]
    :opt-un
    [:cognitect.aws.states.MapRunListItem/stopDate]))

(s/def
  :cognitect.aws.states/ListStateMachineAliasesInput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListStateMachineAliasesInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.ListStateMachineAliasesInput/maxResults
     :cognitect.aws.states.ListStateMachineAliasesInput/nextToken]))

(s/def
  :cognitect.aws.states/MapRunFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.MapRunFailedEventDetails/error
     :cognitect.aws.states.MapRunFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/ValidateStateMachineDefinitionResultCode
  (s/spec string? :gen #(s/gen #{"FAIL" "OK"})))

(s/def
  :cognitect.aws.states/ListActivitiesInput
  (s/keys
    :opt-un
    [:cognitect.aws.states.ListActivitiesInput/maxResults
     :cognitect.aws.states.ListActivitiesInput/nextToken]))

(s/def
  :cognitect.aws.states/SyncExecutionStatus
  (s/spec string? :gen #(s/gen #{"TIMED_OUT" "SUCCEEDED" "FAILED"})))

(s/def
  :cognitect.aws.states/ActivityStartedEventDetails
  (s/keys :opt-un [:cognitect.aws.states.ActivityStartedEventDetails/workerName]))

(s/def
  :cognitect.aws.states/KmsKeyId
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/TestStateInput
  (s/keys
    :req-un
    [:cognitect.aws.states.TestStateInput/definition]
    :opt-un
    [:cognitect.aws.states.TestStateInput/revealSecrets
     :cognitect.aws.states.TestStateInput/roleArn
     :cognitect.aws.states.TestStateInput/inspectionLevel
     :cognitect.aws.states.TestStateInput/variables
     :cognitect.aws.states.TestStateInput/input]))

(s/def
  :cognitect.aws.states/SendTaskFailureInput
  (s/keys
    :req-un
    [:cognitect.aws.states.SendTaskFailureInput/taskToken]
    :opt-un
    [:cognitect.aws.states.SendTaskFailureInput/error
     :cognitect.aws.states.SendTaskFailureInput/cause]))

(s/def
  :cognitect.aws.states/UntagResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.states.UntagResourceInput/resourceArn
     :cognitect.aws.states.UntagResourceInput/tagKeys]))

(s/def
  :cognitect.aws.states/ValidateStateMachineDefinitionSeverity
  (s/spec string? :gen #(s/gen #{"WARNING" "ERROR"})))

(s/def
  :cognitect.aws.states/ListExecutionsOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListExecutionsOutput/executions]
    :opt-un
    [:cognitect.aws.states.ListExecutionsOutput/nextToken]))

(s/def
  :cognitect.aws.states/ToleratedFailurePercentage
  (s/spec
    (s/and double? #(<= 0 % 100))
    :gen
    #(gen/double* {:infinite? false, :NaN? false, :min 0, :max 100})))

(s/def
  :cognitect.aws.states/DescribeStateMachineInput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeStateMachineInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.DescribeStateMachineInput/includedData]))

(s/def
  :cognitect.aws.states/CreateActivityOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.CreateActivityOutput/activityArn
     :cognitect.aws.states.CreateActivityOutput/creationDate]))

(s/def
  :cognitect.aws.states/DeleteStateMachineVersionInput
  (s/keys :req-un [:cognitect.aws.states.DeleteStateMachineVersionInput/stateMachineVersionArn]))

(s/def
  :cognitect.aws.states/VariableReferences
  (s/map-of :cognitect.aws.states/StateName :cognitect.aws.states/VariableNameList))

(s/def :cognitect.aws.states/DeleteStateMachineVersionOutput (s/keys))

(s/def :cognitect.aws.states/HTTPStatusCode string?)

(s/def :cognitect.aws.states/HTTPMethod string?)

(s/def
  :cognitect.aws.states/StopExecutionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.StopExecutionInput/executionArn]
    :opt-un
    [:cognitect.aws.states.StopExecutionInput/error
     :cognitect.aws.states.StopExecutionInput/cause]))

(s/def
  :cognitect.aws.states/ExecutionSucceededEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ExecutionSucceededEventDetails/outputDetails
     :cognitect.aws.states.ExecutionSucceededEventDetails/output]))

(s/def
  :cognitect.aws.states/LongObject
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def :cognitect.aws.states/VariableNameList (s/coll-of :cognitect.aws.states/VariableName))

(s/def
  :cognitect.aws.states/ExecutionRedrivenEventDetails
  (s/keys :opt-un [:cognitect.aws.states.ExecutionRedrivenEventDetails/redriveCount]))

(s/def
  :cognitect.aws.states/EncryptionConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.states.EncryptionConfiguration/type]
    :opt-un
    [:cognitect.aws.states.EncryptionConfiguration/kmsDataKeyReusePeriodSeconds
     :cognitect.aws.states.EncryptionConfiguration/kmsKeyId]))

(s/def
  :cognitect.aws.states/DescribeStateMachineForExecutionOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeStateMachineForExecutionOutput/stateMachineArn
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/name
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/definition
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/roleArn
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/updateDate]
    :opt-un
    [:cognitect.aws.states.DescribeStateMachineForExecutionOutput/variableReferences
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/revisionId
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/label
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/encryptionConfiguration
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/mapRunArn
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/tracingConfiguration
     :cognitect.aws.states.DescribeStateMachineForExecutionOutput/loggingConfiguration]))

(s/def
  :cognitect.aws.states/UpdateStateMachineAliasOutput
  (s/keys :req-un [:cognitect.aws.states.UpdateStateMachineAliasOutput/updateDate]))

(s/def
  :cognitect.aws.states/SensitiveDataJobInput
  (s/spec
    (s/and string? #(>= 262144 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 262144) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/Arn
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.states/truncated boolean?)

(s/def
  :cognitect.aws.states/BillingDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.BillingDetails/billedDurationInMilliseconds
     :cognitect.aws.states.BillingDetails/billedMemoryUsedInMB]))

(s/def
  :cognitect.aws.states/UnsignedLong
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.states/InvalidLoggingConfiguration
  (s/keys :opt-un [:cognitect.aws.states.InvalidLoggingConfiguration/message]))

(s/def
  :cognitect.aws.states/LambdaFunctionSucceededEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.LambdaFunctionSucceededEventDetails/outputDetails
     :cognitect.aws.states.LambdaFunctionSucceededEventDetails/output]))

(s/def
  :cognitect.aws.states/SendTaskSuccessInput
  (s/keys
    :req-un
    [:cognitect.aws.states.SendTaskSuccessInput/taskToken
     :cognitect.aws.states.SendTaskSuccessInput/output]))

(s/def
  :cognitect.aws.states/LambdaFunctionFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.LambdaFunctionFailedEventDetails/error
     :cognitect.aws.states.LambdaFunctionFailedEventDetails/cause]))

(s/def :cognitect.aws.states/RevisionId string?)

(s/def :cognitect.aws.states/RevealSecrets boolean?)

(s/def
  :cognitect.aws.states/LoggingConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.states.LoggingConfiguration/level
     :cognitect.aws.states.LoggingConfiguration/destinations
     :cognitect.aws.states.LoggingConfiguration/includeExecutionData]))

(s/def
  :cognitect.aws.states/CreateStateMachineInput
  (s/keys
    :req-un
    [:cognitect.aws.states.CreateStateMachineInput/name
     :cognitect.aws.states.CreateStateMachineInput/definition
     :cognitect.aws.states.CreateStateMachineInput/roleArn]
    :opt-un
    [:cognitect.aws.states.CreateStateMachineInput/tags
     :cognitect.aws.states.CreateStateMachineInput/encryptionConfiguration
     :cognitect.aws.states.CreateStateMachineInput/publish
     :cognitect.aws.states.CreateStateMachineInput/type
     :cognitect.aws.states.CreateStateMachineInput/tracingConfiguration
     :cognitect.aws.states.CreateStateMachineInput/loggingConfiguration
     :cognitect.aws.states.CreateStateMachineInput/versionDescription]))

(s/def
  :cognitect.aws.states/ResourceNotFound
  (s/keys
    :opt-un
    [:cognitect.aws.states.ResourceNotFound/message
     :cognitect.aws.states.ResourceNotFound/resourceName]))

(s/def
  :cognitect.aws.states/TaskStartFailedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskStartFailedEventDetails/resourceType
     :cognitect.aws.states.TaskStartFailedEventDetails/resource]
    :opt-un
    [:cognitect.aws.states.TaskStartFailedEventDetails/error
     :cognitect.aws.states.TaskStartFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/StateMachineAliasListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.StateMachineAliasListItem/stateMachineAliasArn
     :cognitect.aws.states.StateMachineAliasListItem/creationDate]))

(s/def
  :cognitect.aws.states/MapRunExecutionCounts
  (s/keys
    :req-un
    [:cognitect.aws.states.MapRunExecutionCounts/pending
     :cognitect.aws.states.MapRunExecutionCounts/running
     :cognitect.aws.states.MapRunExecutionCounts/succeeded
     :cognitect.aws.states.MapRunExecutionCounts/failed
     :cognitect.aws.states.MapRunExecutionCounts/timedOut
     :cognitect.aws.states.MapRunExecutionCounts/aborted
     :cognitect.aws.states.MapRunExecutionCounts/total
     :cognitect.aws.states.MapRunExecutionCounts/resultsWritten]
    :opt-un
    [:cognitect.aws.states.MapRunExecutionCounts/failuresNotRedrivable
     :cognitect.aws.states.MapRunExecutionCounts/pendingRedrive]))

(s/def
  :cognitect.aws.states/ExecutionNotRedrivable
  (s/keys :opt-un [:cognitect.aws.states.ExecutionNotRedrivable/message]))

(s/def
  :cognitect.aws.states/TraceHeader
  (s/spec #(re-matches (re-pattern "\\p{ASCII}*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.states/Name
  (s/spec
    (s/and string? #(<= 1 (count %) 80))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 80) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.states/UntagResourceOutput (s/keys))

(s/def
  :cognitect.aws.states/PageSize
  (s/spec (s/and int? #(<= 0 % 1000)) :gen #(gen/choose 0 1000)))

(s/def
  :cognitect.aws.states/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.states/DeleteStateMachineOutput (s/keys))

(s/def
  :cognitect.aws.states/StateMachineType
  (s/spec string? :gen #(s/gen #{"EXPRESS" "STANDARD"})))

(s/def
  :cognitect.aws.states/TaskStartedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.TaskStartedEventDetails/resourceType
     :cognitect.aws.states.TaskStartedEventDetails/resource]))

(s/def
  :cognitect.aws.states/DescribeActivityOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeActivityOutput/activityArn
     :cognitect.aws.states.DescribeActivityOutput/name
     :cognitect.aws.states.DescribeActivityOutput/creationDate]
    :opt-un
    [:cognitect.aws.states.DescribeActivityOutput/encryptionConfiguration]))

(s/def
  :cognitect.aws.states/PublishStateMachineVersionOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.PublishStateMachineVersionOutput/creationDate
     :cognitect.aws.states.PublishStateMachineVersionOutput/stateMachineVersionArn]))

(s/def
  :cognitect.aws.states/ConnectorParameters
  (s/spec
    (s/and string? #(<= 0 (count %) 262144))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 262144) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/StartExecutionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.StartExecutionInput/stateMachineArn]
    :opt-un
    [:cognitect.aws.states.StartExecutionInput/traceHeader
     :cognitect.aws.states.StartExecutionInput/name
     :cognitect.aws.states.StartExecutionInput/input]))

(s/def :cognitect.aws.states/InvalidArn (s/keys :opt-un [:cognitect.aws.states.InvalidArn/message]))

(s/def
  :cognitect.aws.states/ExecutionListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.ExecutionListItem/executionArn
     :cognitect.aws.states.ExecutionListItem/stateMachineArn
     :cognitect.aws.states.ExecutionListItem/name
     :cognitect.aws.states.ExecutionListItem/status
     :cognitect.aws.states.ExecutionListItem/startDate]
    :opt-un
    [:cognitect.aws.states.ExecutionListItem/itemCount
     :cognitect.aws.states.ExecutionListItem/redriveDate
     :cognitect.aws.states.ExecutionListItem/stateMachineAliasArn
     :cognitect.aws.states.ExecutionListItem/stateMachineVersionArn
     :cognitect.aws.states.ExecutionListItem/redriveCount
     :cognitect.aws.states.ExecutionListItem/mapRunArn
     :cognitect.aws.states.ExecutionListItem/stopDate]))

(s/def :cognitect.aws.states/Enabled boolean?)

(s/def :cognitect.aws.states/UpdateMapRunOutput (s/keys))

(s/def
  :cognitect.aws.states/ClientToken
  (s/spec #(re-matches (re-pattern "[!-~]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.states/ListMapRunsOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListMapRunsOutput/mapRuns]
    :opt-un
    [:cognitect.aws.states.ListMapRunsOutput/nextToken]))

(s/def :cognitect.aws.states/Timestamp inst?)

(s/def
  :cognitect.aws.states/ExecutionAlreadyExists
  (s/keys :opt-un [:cognitect.aws.states.ExecutionAlreadyExists/message]))

(s/def
  :cognitect.aws.states/StateMachineTypeNotSupported
  (s/keys :opt-un [:cognitect.aws.states.StateMachineTypeNotSupported/message]))

(s/def
  :cognitect.aws.states/InvalidTracingConfiguration
  (s/keys :opt-un [:cognitect.aws.states.InvalidTracingConfiguration/message]))

(s/def
  :cognitect.aws.states/MapRunStartedEventDetails
  (s/keys :opt-un [:cognitect.aws.states.MapRunStartedEventDetails/mapRunArn]))

(s/def
  :cognitect.aws.states/AssignedVariables
  (s/map-of :cognitect.aws.states/VariableName :cognitect.aws.states/VariableValue))

(s/def
  :cognitect.aws.states/ListExecutionsInput
  (s/keys
    :opt-un
    [:cognitect.aws.states.ListExecutionsInput/statusFilter
     :cognitect.aws.states.ListExecutionsInput/redriveFilter
     :cognitect.aws.states.ListExecutionsInput/maxResults
     :cognitect.aws.states.ListExecutionsInput/nextToken
     :cognitect.aws.states.ListExecutionsInput/mapRunArn
     :cognitect.aws.states.ListExecutionsInput/stateMachineArn]))

(s/def
  :cognitect.aws.states/UpdateStateMachineOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.UpdateStateMachineOutput/updateDate]
    :opt-un
    [:cognitect.aws.states.UpdateStateMachineOutput/revisionId
     :cognitect.aws.states.UpdateStateMachineOutput/stateMachineVersionArn]))

(s/def
  :cognitect.aws.states/TimeoutInSeconds
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.states/StateMachineVersionList
  (s/coll-of :cognitect.aws.states/StateMachineVersionListItem))

(s/def
  :cognitect.aws.states/DescribeActivityInput
  (s/keys :req-un [:cognitect.aws.states.DescribeActivityInput/activityArn]))

(s/def
  :cognitect.aws.states/GetExecutionHistoryOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.GetExecutionHistoryOutput/events]
    :opt-un
    [:cognitect.aws.states.GetExecutionHistoryOutput/nextToken]))

(s/def
  :cognitect.aws.states/HistoryEvent
  (s/keys
    :req-un
    [:cognitect.aws.states.HistoryEvent/timestamp
     :cognitect.aws.states.HistoryEvent/type
     :cognitect.aws.states.HistoryEvent/id]
    :opt-un
    [:cognitect.aws.states.HistoryEvent/activityStartedEventDetails
     :cognitect.aws.states.HistoryEvent/executionAbortedEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionTimedOutEventDetails
     :cognitect.aws.states.HistoryEvent/mapRunRedrivenEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionFailedEventDetails
     :cognitect.aws.states.HistoryEvent/executionStartedEventDetails
     :cognitect.aws.states.HistoryEvent/mapRunStartedEventDetails
     :cognitect.aws.states.HistoryEvent/taskSubmitFailedEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionScheduledEventDetails
     :cognitect.aws.states.HistoryEvent/activitySucceededEventDetails
     :cognitect.aws.states.HistoryEvent/mapRunFailedEventDetails
     :cognitect.aws.states.HistoryEvent/evaluationFailedEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionScheduleFailedEventDetails
     :cognitect.aws.states.HistoryEvent/executionTimedOutEventDetails
     :cognitect.aws.states.HistoryEvent/executionRedrivenEventDetails
     :cognitect.aws.states.HistoryEvent/mapIterationStartedEventDetails
     :cognitect.aws.states.HistoryEvent/taskSucceededEventDetails
     :cognitect.aws.states.HistoryEvent/mapIterationFailedEventDetails
     :cognitect.aws.states.HistoryEvent/previousEventId
     :cognitect.aws.states.HistoryEvent/executionFailedEventDetails
     :cognitect.aws.states.HistoryEvent/stateExitedEventDetails
     :cognitect.aws.states.HistoryEvent/activityScheduleFailedEventDetails
     :cognitect.aws.states.HistoryEvent/executionSucceededEventDetails
     :cognitect.aws.states.HistoryEvent/activityFailedEventDetails
     :cognitect.aws.states.HistoryEvent/taskSubmittedEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionSucceededEventDetails
     :cognitect.aws.states.HistoryEvent/taskScheduledEventDetails
     :cognitect.aws.states.HistoryEvent/activityScheduledEventDetails
     :cognitect.aws.states.HistoryEvent/stateEnteredEventDetails
     :cognitect.aws.states.HistoryEvent/taskTimedOutEventDetails
     :cognitect.aws.states.HistoryEvent/taskFailedEventDetails
     :cognitect.aws.states.HistoryEvent/taskStartedEventDetails
     :cognitect.aws.states.HistoryEvent/taskStartFailedEventDetails
     :cognitect.aws.states.HistoryEvent/lambdaFunctionStartFailedEventDetails
     :cognitect.aws.states.HistoryEvent/mapIterationAbortedEventDetails
     :cognitect.aws.states.HistoryEvent/mapStateStartedEventDetails
     :cognitect.aws.states.HistoryEvent/activityTimedOutEventDetails
     :cognitect.aws.states.HistoryEvent/mapIterationSucceededEventDetails]))

(s/def
  :cognitect.aws.states/ListStateMachineAliasesOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListStateMachineAliasesOutput/stateMachineAliases]
    :opt-un
    [:cognitect.aws.states.ListStateMachineAliasesOutput/nextToken]))

(s/def :cognitect.aws.states/URL string?)

(s/def
  :cognitect.aws.states/AliasDescription
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/ActivityScheduleFailedEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.ActivityScheduleFailedEventDetails/error
     :cognitect.aws.states.ActivityScheduleFailedEventDetails/cause]))

(s/def
  :cognitect.aws.states/ExecutionRedriveStatus
  (s/spec string? :gen #(s/gen #{"NOT_REDRIVABLE" "REDRIVABLE" "REDRIVABLE_BY_MAP_RUN"})))

(s/def
  :cognitect.aws.states/GetActivityTaskInput
  (s/keys
    :req-un
    [:cognitect.aws.states.GetActivityTaskInput/activityArn]
    :opt-un
    [:cognitect.aws.states.GetActivityTaskInput/workerName]))

(s/def :cognitect.aws.states/HTTPHeaders string?)

(s/def
  :cognitect.aws.states/ListExecutionsPageToken
  (s/spec
    (s/and string? #(<= 1 (count %) 3096))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 3096) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/DescribeExecutionOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeExecutionOutput/executionArn
     :cognitect.aws.states.DescribeExecutionOutput/stateMachineArn
     :cognitect.aws.states.DescribeExecutionOutput/status
     :cognitect.aws.states.DescribeExecutionOutput/startDate]
    :opt-un
    [:cognitect.aws.states.DescribeExecutionOutput/traceHeader
     :cognitect.aws.states.DescribeExecutionOutput/redriveDate
     :cognitect.aws.states.DescribeExecutionOutput/outputDetails
     :cognitect.aws.states.DescribeExecutionOutput/output
     :cognitect.aws.states.DescribeExecutionOutput/stateMachineAliasArn
     :cognitect.aws.states.DescribeExecutionOutput/stateMachineVersionArn
     :cognitect.aws.states.DescribeExecutionOutput/error
     :cognitect.aws.states.DescribeExecutionOutput/name
     :cognitect.aws.states.DescribeExecutionOutput/cause
     :cognitect.aws.states.DescribeExecutionOutput/redriveCount
     :cognitect.aws.states.DescribeExecutionOutput/input
     :cognitect.aws.states.DescribeExecutionOutput/mapRunArn
     :cognitect.aws.states.DescribeExecutionOutput/redriveStatus
     :cognitect.aws.states.DescribeExecutionOutput/inputDetails
     :cognitect.aws.states.DescribeExecutionOutput/stopDate
     :cognitect.aws.states.DescribeExecutionOutput/redriveStatusReason]))

(s/def :cognitect.aws.states/ValidateStateMachineDefinitionCode string?)

(s/def
  :cognitect.aws.states/UpdateStateMachineAliasInput
  (s/keys
    :req-un
    [:cognitect.aws.states.UpdateStateMachineAliasInput/stateMachineAliasArn]
    :opt-un
    [:cognitect.aws.states.UpdateStateMachineAliasInput/routingConfiguration
     :cognitect.aws.states.UpdateStateMachineAliasInput/description]))

(s/def
  :cognitect.aws.states/StateMachineAliasList
  (s/coll-of :cognitect.aws.states/StateMachineAliasListItem))

(s/def
  :cognitect.aws.states/DescribeStateMachineOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.DescribeStateMachineOutput/stateMachineArn
     :cognitect.aws.states.DescribeStateMachineOutput/name
     :cognitect.aws.states.DescribeStateMachineOutput/definition
     :cognitect.aws.states.DescribeStateMachineOutput/roleArn
     :cognitect.aws.states.DescribeStateMachineOutput/type
     :cognitect.aws.states.DescribeStateMachineOutput/creationDate]
    :opt-un
    [:cognitect.aws.states.DescribeStateMachineOutput/variableReferences
     :cognitect.aws.states.DescribeStateMachineOutput/revisionId
     :cognitect.aws.states.DescribeStateMachineOutput/label
     :cognitect.aws.states.DescribeStateMachineOutput/encryptionConfiguration
     :cognitect.aws.states.DescribeStateMachineOutput/status
     :cognitect.aws.states.DescribeStateMachineOutput/tracingConfiguration
     :cognitect.aws.states.DescribeStateMachineOutput/loggingConfiguration
     :cognitect.aws.states.DescribeStateMachineOutput/description]))

(s/def
  :cognitect.aws.states/SendTaskHeartbeatInput
  (s/keys :req-un [:cognitect.aws.states.SendTaskHeartbeatInput/taskToken]))

(s/def
  :cognitect.aws.states/RoutingConfigurationListItem
  (s/keys
    :req-un
    [:cognitect.aws.states.RoutingConfigurationListItem/stateMachineVersionArn
     :cognitect.aws.states.RoutingConfigurationListItem/weight]))

(s/def
  :cognitect.aws.states/ValidateStateMachineDefinitionInput
  (s/keys
    :req-un
    [:cognitect.aws.states.ValidateStateMachineDefinitionInput/definition]
    :opt-un
    [:cognitect.aws.states.ValidateStateMachineDefinitionInput/maxResults
     :cognitect.aws.states.ValidateStateMachineDefinitionInput/type
     :cognitect.aws.states.ValidateStateMachineDefinitionInput/severity]))

(s/def
  :cognitect.aws.states/TaskDoesNotExist
  (s/keys :opt-un [:cognitect.aws.states.TaskDoesNotExist/message]))

(s/def
  :cognitect.aws.states/EvaluationFailureLocation
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.states/MapIterationEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.MapIterationEventDetails/index
     :cognitect.aws.states.MapIterationEventDetails/name]))

(s/def
  :cognitect.aws.states/HistoryEventType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MapIterationStarted"
        "LambdaFunctionStartFailed"
        "TaskSubmitted"
        "MapIterationAborted"
        "LambdaFunctionSucceeded"
        "MapStateExited"
        "ActivityTimedOut"
        "WaitStateAborted"
        "SucceedStateEntered"
        "ActivityScheduled"
        "ParallelStateAborted"
        "MapIterationSucceeded"
        "MapStateAborted"
        "ParallelStateSucceeded"
        "ExecutionTimedOut"
        "ChoiceStateExited"
        "TaskSubmitFailed"
        "ExecutionFailed"
        "TaskSucceeded"
        "ActivityFailed"
        "EvaluationFailed"
        "MapRunAborted"
        "ChoiceStateEntered"
        "LambdaFunctionScheduled"
        "TaskScheduled"
        "MapIterationFailed"
        "MapStateEntered"
        "TaskStarted"
        "MapRunStarted"
        "MapStateSucceeded"
        "FailStateEntered"
        "WaitStateExited"
        "MapStateStarted"
        "MapRunRedriven"
        "ActivityScheduleFailed"
        "SucceedStateExited"
        "TaskStateEntered"
        "PassStateExited"
        "LambdaFunctionFailed"
        "MapStateFailed"
        "PassStateEntered"
        "TaskFailed"
        "TaskStartFailed"
        "MapRunSucceeded"
        "LambdaFunctionTimedOut"
        "ParallelStateFailed"
        "ActivitySucceeded"
        "LambdaFunctionStarted"
        "ExecutionSucceeded"
        "ActivityStarted"
        "WaitStateEntered"
        "ParallelStateEntered"
        "ExecutionStarted"
        "ExecutionAborted"
        "ParallelStateStarted"
        "LambdaFunctionScheduleFailed"
        "ExecutionRedriven"
        "ParallelStateExited"
        "TaskStateAborted"
        "TaskTimedOut"
        "MapRunFailed"
        "TaskStateExited"})))

(s/def :cognitect.aws.states/ValidateStateMachineDefinitionTruncated boolean?)

(s/def
  :cognitect.aws.states/DeleteStateMachineInput
  (s/keys :req-un [:cognitect.aws.states.DeleteStateMachineInput/stateMachineArn]))

(s/def
  :cognitect.aws.states/StateMachineList
  (s/coll-of :cognitect.aws.states/StateMachineListItem))

(s/def
  :cognitect.aws.states/InvalidName
  (s/keys :opt-un [:cognitect.aws.states.InvalidName/message]))

(s/def :cognitect.aws.states/VariableName string?)

(s/def :cognitect.aws.states/EventId (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.states/StateExitedEventDetails
  (s/keys
    :req-un
    [:cognitect.aws.states.StateExitedEventDetails/name]
    :opt-un
    [:cognitect.aws.states.StateExitedEventDetails/outputDetails
     :cognitect.aws.states.StateExitedEventDetails/output
     :cognitect.aws.states.StateExitedEventDetails/assignedVariablesDetails
     :cognitect.aws.states.StateExitedEventDetails/assignedVariables]))

(s/def
  :cognitect.aws.states/TestStateOutput
  (s/keys
    :opt-un
    [:cognitect.aws.states.TestStateOutput/output
     :cognitect.aws.states.TestStateOutput/inspectionData
     :cognitect.aws.states.TestStateOutput/error
     :cognitect.aws.states.TestStateOutput/nextState
     :cognitect.aws.states.TestStateOutput/cause
     :cognitect.aws.states.TestStateOutput/status]))

(s/def
  :cognitect.aws.states/StateMachineLimitExceeded
  (s/keys :opt-un [:cognitect.aws.states.StateMachineLimitExceeded/message]))

(s/def
  :cognitect.aws.states/MapRunRedrivenEventDetails
  (s/keys
    :opt-un
    [:cognitect.aws.states.MapRunRedrivenEventDetails/redriveCount
     :cognitect.aws.states.MapRunRedrivenEventDetails/mapRunArn]))

(s/def
  :cognitect.aws.states/VersionWeight
  (s/spec (s/and int? #(<= 0 % 100)) :gen #(gen/choose 0 100)))

(s/def
  :cognitect.aws.states/ListMapRunsInput
  (s/keys
    :req-un
    [:cognitect.aws.states.ListMapRunsInput/executionArn]
    :opt-un
    [:cognitect.aws.states.ListMapRunsInput/maxResults
     :cognitect.aws.states.ListMapRunsInput/nextToken]))

(s/def
  :cognitect.aws.states/CreateStateMachineAliasOutput
  (s/keys
    :req-un
    [:cognitect.aws.states.CreateStateMachineAliasOutput/stateMachineAliasArn
     :cognitect.aws.states.CreateStateMachineAliasOutput/creationDate]))

(s/def
  :cognitect.aws.states/ConflictException
  (s/keys :opt-un [:cognitect.aws.states.ConflictException/message]))

(s/def :cognitect.aws.states/TagKeyList (s/coll-of :cognitect.aws.states/TagKey))

(s/def
  :cognitect.aws.states/LongArn
  (s/spec
    (s/and string? #(<= 1 (count %) 2000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2000) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.states/MapRunLabel string?)

(s/def
  :cognitect.aws.states/KmsDataKeyReusePeriodSeconds
  (s/spec (s/and int? #(<= 60 % 900)) :gen #(gen/choose 60 900)))

(s/def
  :cognitect.aws.states/KmsInvalidStateException
  (s/keys
    :opt-un
    [:cognitect.aws.states.KmsInvalidStateException/message
     :cognitect.aws.states.KmsInvalidStateException/kmsKeyState]))

(s/def
  :cognitect.aws.states.HistoryEventExecutionDataDetails/truncated
  :cognitect.aws.states/truncated)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionDiagnostic/severity
  :cognitect.aws.states/ValidateStateMachineDefinitionSeverity)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionDiagnostic/code
  :cognitect.aws.states/ValidateStateMachineDefinitionCode)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionDiagnostic/message
  :cognitect.aws.states/ValidateStateMachineDefinitionMessage)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionDiagnostic/location
  :cognitect.aws.states/ValidateStateMachineDefinitionLocation)

(s/def :cognitect.aws.states.ExecutionLimitExceeded/message :cognitect.aws.states/ErrorMessage)

(s/def
  :cognitect.aws.states.LambdaFunctionTimedOutEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.LambdaFunctionTimedOutEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.TaskTimedOutEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskTimedOutEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskTimedOutEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.TaskTimedOutEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.ServiceQuotaExceededException/message
  :cognitect.aws.states/ErrorMessage)

(s/def
  :cognitect.aws.states.ExecutionAbortedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.ExecutionAbortedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.ListTagsForResourceInput/resourceArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.TaskCredentials/roleArn :cognitect.aws.states/LongArn)

(s/def
  :cognitect.aws.states.ListStateMachinesOutput/stateMachines
  :cognitect.aws.states/StateMachineList)

(s/def :cognitect.aws.states.ListStateMachinesOutput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.KmsAccessDeniedException/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.ListTagsForResourceOutput/tags :cognitect.aws.states/TagList)

(s/def
  :cognitect.aws.states.MapStateStartedEventDetails/length
  :cognitect.aws.states/UnsignedInteger)

(s/def
  :cognitect.aws.states.ListStateMachineVersionsInput/stateMachineArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.ListStateMachineVersionsInput/nextToken
  :cognitect.aws.states/PageToken)

(s/def
  :cognitect.aws.states.ListStateMachineVersionsInput/maxResults
  :cognitect.aws.states/PageSize)

(s/def :cognitect.aws.states.Tag/key :cognitect.aws.states/TagKey)

(s/def :cognitect.aws.states.Tag/value :cognitect.aws.states/TagValue)

(s/def :cognitect.aws.states.StartExecutionOutput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StartExecutionOutput/startDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.EvaluationFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.EvaluationFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.EvaluationFailedEventDetails/location
  :cognitect.aws.states/EvaluationFailureLocation)

(s/def :cognitect.aws.states.EvaluationFailedEventDetails/state :cognitect.aws.states/StateName)

(s/def
  :cognitect.aws.states.CreateStateMachineAliasInput/description
  :cognitect.aws.states/AliasDescription)

(s/def
  :cognitect.aws.states.CreateStateMachineAliasInput/name
  :cognitect.aws.states/CharacterRestrictedName)

(s/def
  :cognitect.aws.states.CreateStateMachineAliasInput/routingConfiguration
  :cognitect.aws.states/RoutingConfigurationList)

(s/def :cognitect.aws.states.ExecutionDoesNotExist/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.RedriveExecutionOutput/redriveDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionOutput/result
  :cognitect.aws.states/ValidateStateMachineDefinitionResultCode)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionOutput/diagnostics
  :cognitect.aws.states/ValidateStateMachineDefinitionDiagnosticList)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionOutput/truncated
  :cognitect.aws.states/ValidateStateMachineDefinitionTruncated)

(s/def
  :cognitect.aws.states.ListStateMachineVersionsOutput/stateMachineVersions
  :cognitect.aws.states/StateMachineVersionList)

(s/def
  :cognitect.aws.states.ListStateMachineVersionsOutput/nextToken
  :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.RedriveExecutionInput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.RedriveExecutionInput/clientToken :cognitect.aws.states/ClientToken)

(s/def :cognitect.aws.states.InvalidToken/message :cognitect.aws.states/ErrorMessage)

(s/def
  :cognitect.aws.states.StateMachineVersionListItem/stateMachineVersionArn
  :cognitect.aws.states/LongArn)

(s/def
  :cognitect.aws.states.StateMachineVersionListItem/creationDate
  :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DeleteActivityInput/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StateMachineAlreadyExists/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.TaskScheduledEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskScheduledEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskScheduledEventDetails/region :cognitect.aws.states/Name)

(s/def
  :cognitect.aws.states.TaskScheduledEventDetails/parameters
  :cognitect.aws.states/ConnectorParameters)

(s/def
  :cognitect.aws.states.TaskScheduledEventDetails/timeoutInSeconds
  :cognitect.aws.states/TimeoutInSeconds)

(s/def
  :cognitect.aws.states.TaskScheduledEventDetails/heartbeatInSeconds
  :cognitect.aws.states/TimeoutInSeconds)

(s/def
  :cognitect.aws.states.TaskScheduledEventDetails/taskCredentials
  :cognitect.aws.states/TaskCredentials)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionInput/executionArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionInput/includedData
  :cognitect.aws.states/IncludedData)

(s/def :cognitect.aws.states.InvalidExecutionInput/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.ExecutionFailedEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.ExecutionFailedEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.DeleteStateMachineAliasInput/stateMachineAliasArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.KmsThrottlingException/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/stopDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/startDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/output :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.StartSyncExecutionOutput/status
  :cognitect.aws.states/SyncExecutionStatus)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/input :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.StartSyncExecutionOutput/outputDetails
  :cognitect.aws.states/CloudWatchEventsExecutionDataDetails)

(s/def
  :cognitect.aws.states.StartSyncExecutionOutput/billingDetails
  :cognitect.aws.states/BillingDetails)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/traceHeader :cognitect.aws.states/TraceHeader)

(s/def
  :cognitect.aws.states.StartSyncExecutionOutput/inputDetails
  :cognitect.aws.states/CloudWatchEventsExecutionDataDetails)

(s/def :cognitect.aws.states.StartSyncExecutionOutput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ValidationException/message :cognitect.aws.states/ErrorMessage)

(s/def
  :cognitect.aws.states.ValidationException/reason
  :cognitect.aws.states/ValidationExceptionReason)

(s/def :cognitect.aws.states.ActivityFailedEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.ActivityFailedEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.DescribeStateMachineAliasInput/stateMachineAliasArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.UpdateMapRunInput/mapRunArn :cognitect.aws.states/LongArn)

(s/def :cognitect.aws.states.UpdateMapRunInput/maxConcurrency :cognitect.aws.states/MaxConcurrency)

(s/def
  :cognitect.aws.states.UpdateMapRunInput/toleratedFailurePercentage
  :cognitect.aws.states/ToleratedFailurePercentage)

(s/def
  :cognitect.aws.states.UpdateMapRunInput/toleratedFailureCount
  :cognitect.aws.states/ToleratedFailureCount)

(s/def :cognitect.aws.states.TaskFailedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskFailedEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskFailedEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.TaskFailedEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.LambdaFunctionScheduledEventDetails/resource :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduledEventDetails/input
  :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduledEventDetails/inputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduledEventDetails/timeoutInSeconds
  :cognitect.aws.states/TimeoutInSeconds)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduledEventDetails/taskCredentials
  :cognitect.aws.states/TaskCredentials)

(s/def :cognitect.aws.states.CreateActivityInput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.CreateActivityInput/tags :cognitect.aws.states/TagList)

(s/def
  :cognitect.aws.states.CreateActivityInput/encryptionConfiguration
  :cognitect.aws.states/EncryptionConfiguration)

(s/def :cognitect.aws.states.CloudWatchLogsLogGroup/logGroupArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.CreateStateMachineOutput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.CreateStateMachineOutput/creationDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.CreateStateMachineOutput/stateMachineVersionArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ListStateMachinesInput/maxResults :cognitect.aws.states/PageSize)

(s/def :cognitect.aws.states.ListStateMachinesInput/nextToken :cognitect.aws.states/PageToken)

(s/def
  :cognitect.aws.states.LogDestination/cloudWatchLogsLogGroup
  :cognitect.aws.states/CloudWatchLogsLogGroup)

(s/def :cognitect.aws.states.StateMachineListItem/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StateMachineListItem/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StateMachineListItem/type :cognitect.aws.states/StateMachineType)

(s/def :cognitect.aws.states.StateMachineListItem/creationDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.StateMachineDeleting/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.StateEnteredEventDetails/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StateEnteredEventDetails/input :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.StateEnteredEventDetails/inputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def :cognitect.aws.states.InspectionData/response :cognitect.aws.states/InspectionDataResponse)

(s/def :cognitect.aws.states.InspectionData/request :cognitect.aws.states/InspectionDataRequest)

(s/def :cognitect.aws.states.InspectionData/afterInputPath :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.InspectionData/variables :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.InspectionData/afterParameters :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.InspectionData/afterArguments :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.InspectionData/result :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.InspectionData/input :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.InspectionData/afterResultPath :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.InspectionData/afterResultSelector :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.MapRunItemCounts/resultsWritten :cognitect.aws.states/UnsignedLong)

(s/def
  :cognitect.aws.states.MapRunItemCounts/failuresNotRedrivable
  :cognitect.aws.states/LongObject)

(s/def :cognitect.aws.states.MapRunItemCounts/pending :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunItemCounts/aborted :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunItemCounts/running :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunItemCounts/total :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunItemCounts/timedOut :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunItemCounts/pendingRedrive :cognitect.aws.states/LongObject)

(s/def :cognitect.aws.states.MapRunItemCounts/failed :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunItemCounts/succeeded :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.ExecutionStartedEventDetails/input :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.ExecutionStartedEventDetails/inputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def :cognitect.aws.states.ExecutionStartedEventDetails/roleArn :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.ExecutionStartedEventDetails/stateMachineAliasArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.ExecutionStartedEventDetails/stateMachineVersionArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ActivityDoesNotExist/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.ActivityListItem/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ActivityListItem/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.ActivityListItem/creationDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.CloudWatchEventsExecutionDataDetails/included
  :cognitect.aws.states/includedDetails)

(s/def
  :cognitect.aws.states.DescribeMapRunOutput/maxConcurrency
  :cognitect.aws.states/MaxConcurrency)

(s/def
  :cognitect.aws.states.DescribeMapRunOutput/toleratedFailurePercentage
  :cognitect.aws.states/ToleratedFailurePercentage)

(s/def :cognitect.aws.states.DescribeMapRunOutput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeMapRunOutput/stopDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DescribeMapRunOutput/redriveDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DescribeMapRunOutput/startDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.DescribeMapRunOutput/executionCounts
  :cognitect.aws.states/MapRunExecutionCounts)

(s/def :cognitect.aws.states.DescribeMapRunOutput/redriveCount :cognitect.aws.states/RedriveCount)

(s/def :cognitect.aws.states.DescribeMapRunOutput/mapRunArn :cognitect.aws.states/LongArn)

(s/def
  :cognitect.aws.states.DescribeMapRunOutput/toleratedFailureCount
  :cognitect.aws.states/ToleratedFailureCount)

(s/def :cognitect.aws.states.DescribeMapRunOutput/status :cognitect.aws.states/MapRunStatus)

(s/def :cognitect.aws.states.DescribeMapRunOutput/itemCounts :cognitect.aws.states/MapRunItemCounts)

(s/def
  :cognitect.aws.states.ActivitySucceededEventDetails/output
  :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.ActivitySucceededEventDetails/outputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def :cognitect.aws.states.TracingConfiguration/enabled :cognitect.aws.states/Enabled)

(s/def :cognitect.aws.states.TooManyTags/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.TooManyTags/resourceName :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ActivityLimitExceeded/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.TaskSucceededEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSucceededEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSucceededEventDetails/output :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.TaskSucceededEventDetails/outputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def
  :cognitect.aws.states.ActivityTimedOutEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.ActivityTimedOutEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.TagResourceInput/resourceArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.TagResourceInput/tags :cognitect.aws.states/TagList)

(s/def :cognitect.aws.states.StateMachineDoesNotExist/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.InvalidOutput/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.GetExecutionHistoryInput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.GetExecutionHistoryInput/maxResults :cognitect.aws.states/PageSize)

(s/def
  :cognitect.aws.states.GetExecutionHistoryInput/reverseOrder
  :cognitect.aws.states/ReverseOrder)

(s/def :cognitect.aws.states.GetExecutionHistoryInput/nextToken :cognitect.aws.states/PageToken)

(s/def
  :cognitect.aws.states.GetExecutionHistoryInput/includeExecutionData
  :cognitect.aws.states/IncludeExecutionDataGetExecutionHistory)

(s/def :cognitect.aws.states.TaskTimedOut/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.ListActivitiesOutput/activities :cognitect.aws.states/ActivityList)

(s/def :cognitect.aws.states.ListActivitiesOutput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.UpdateStateMachineInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.UpdateStateMachineInput/definition :cognitect.aws.states/Definition)

(s/def :cognitect.aws.states.UpdateStateMachineInput/roleArn :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.UpdateStateMachineInput/loggingConfiguration
  :cognitect.aws.states/LoggingConfiguration)

(s/def
  :cognitect.aws.states.UpdateStateMachineInput/tracingConfiguration
  :cognitect.aws.states/TracingConfiguration)

(s/def :cognitect.aws.states.UpdateStateMachineInput/publish :cognitect.aws.states/Publish)

(s/def
  :cognitect.aws.states.UpdateStateMachineInput/versionDescription
  :cognitect.aws.states/VersionDescription)

(s/def
  :cognitect.aws.states.UpdateStateMachineInput/encryptionConfiguration
  :cognitect.aws.states/EncryptionConfiguration)

(s/def :cognitect.aws.states.InspectionDataResponse/protocol :cognitect.aws.states/HTTPProtocol)

(s/def :cognitect.aws.states.InspectionDataResponse/statusCode :cognitect.aws.states/HTTPStatusCode)

(s/def
  :cognitect.aws.states.InspectionDataResponse/statusMessage
  :cognitect.aws.states/HTTPStatusMessage)

(s/def :cognitect.aws.states.InspectionDataResponse/headers :cognitect.aws.states/HTTPHeaders)

(s/def :cognitect.aws.states.InspectionDataResponse/body :cognitect.aws.states/HTTPBody)

(s/def :cognitect.aws.states.ActivityAlreadyExists/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.StopExecutionOutput/stopDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DescribeMapRunInput/mapRunArn :cognitect.aws.states/LongArn)

(s/def
  :cognitect.aws.states.InvalidEncryptionConfiguration/message
  :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.GetActivityTaskOutput/taskToken :cognitect.aws.states/TaskToken)

(s/def
  :cognitect.aws.states.GetActivityTaskOutput/input
  :cognitect.aws.states/SensitiveDataJobInput)

(s/def
  :cognitect.aws.states.ExecutionTimedOutEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.ExecutionTimedOutEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.MissingRequiredParameter/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.InspectionDataRequest/protocol :cognitect.aws.states/HTTPProtocol)

(s/def :cognitect.aws.states.InspectionDataRequest/method :cognitect.aws.states/HTTPMethod)

(s/def :cognitect.aws.states.InspectionDataRequest/url :cognitect.aws.states/URL)

(s/def :cognitect.aws.states.InspectionDataRequest/headers :cognitect.aws.states/HTTPHeaders)

(s/def :cognitect.aws.states.InspectionDataRequest/body :cognitect.aws.states/HTTPBody)

(s/def :cognitect.aws.states.TaskSubmittedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSubmittedEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSubmittedEventDetails/output :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.TaskSubmittedEventDetails/outputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def
  :cognitect.aws.states.DescribeStateMachineAliasOutput/stateMachineAliasArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeStateMachineAliasOutput/name :cognitect.aws.states/Name)

(s/def
  :cognitect.aws.states.DescribeStateMachineAliasOutput/description
  :cognitect.aws.states/AliasDescription)

(s/def
  :cognitect.aws.states.DescribeStateMachineAliasOutput/routingConfiguration
  :cognitect.aws.states/RoutingConfigurationList)

(s/def
  :cognitect.aws.states.DescribeStateMachineAliasOutput/creationDate
  :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.DescribeStateMachineAliasOutput/updateDate
  :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.AssignedVariablesDetails/truncated :cognitect.aws.states/truncated)

(s/def :cognitect.aws.states.ActivityScheduledEventDetails/resource :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.ActivityScheduledEventDetails/input
  :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.ActivityScheduledEventDetails/inputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def
  :cognitect.aws.states.ActivityScheduledEventDetails/timeoutInSeconds
  :cognitect.aws.states/TimeoutInSeconds)

(s/def
  :cognitect.aws.states.ActivityScheduledEventDetails/heartbeatInSeconds
  :cognitect.aws.states/TimeoutInSeconds)

(s/def
  :cognitect.aws.states.PublishStateMachineVersionInput/stateMachineArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.PublishStateMachineVersionInput/revisionId
  :cognitect.aws.states/RevisionId)

(s/def
  :cognitect.aws.states.PublishStateMachineVersionInput/description
  :cognitect.aws.states/VersionDescription)

(s/def :cognitect.aws.states.InvalidDefinition/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.TaskSubmitFailedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskSubmitFailedEventDetails/resource :cognitect.aws.states/Name)

(s/def
  :cognitect.aws.states.TaskSubmitFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.TaskSubmitFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.LambdaFunctionStartFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.LambdaFunctionStartFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduleFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.LambdaFunctionScheduleFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.ActivityWorkerLimitExceeded/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.StartSyncExecutionInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StartSyncExecutionInput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StartSyncExecutionInput/input :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.StartSyncExecutionInput/traceHeader :cognitect.aws.states/TraceHeader)

(s/def
  :cognitect.aws.states.StartSyncExecutionInput/includedData
  :cognitect.aws.states/IncludedData)

(s/def :cognitect.aws.states.DescribeExecutionInput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeExecutionInput/includedData :cognitect.aws.states/IncludedData)

(s/def :cognitect.aws.states.MapRunListItem/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.MapRunListItem/mapRunArn :cognitect.aws.states/LongArn)

(s/def :cognitect.aws.states.MapRunListItem/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.MapRunListItem/startDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.MapRunListItem/stopDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.ListStateMachineAliasesInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ListStateMachineAliasesInput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.ListStateMachineAliasesInput/maxResults :cognitect.aws.states/PageSize)

(s/def :cognitect.aws.states.MapRunFailedEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.MapRunFailedEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.ListActivitiesInput/maxResults :cognitect.aws.states/PageSize)

(s/def :cognitect.aws.states.ListActivitiesInput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.ActivityStartedEventDetails/workerName :cognitect.aws.states/Identity)

(s/def :cognitect.aws.states.TestStateInput/definition :cognitect.aws.states/Definition)

(s/def :cognitect.aws.states.TestStateInput/roleArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.TestStateInput/input :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.TestStateInput/inspectionLevel :cognitect.aws.states/InspectionLevel)

(s/def :cognitect.aws.states.TestStateInput/revealSecrets :cognitect.aws.states/RevealSecrets)

(s/def :cognitect.aws.states.TestStateInput/variables :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.SendTaskFailureInput/taskToken :cognitect.aws.states/TaskToken)

(s/def :cognitect.aws.states.SendTaskFailureInput/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.SendTaskFailureInput/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.UntagResourceInput/resourceArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.UntagResourceInput/tagKeys :cognitect.aws.states/TagKeyList)

(s/def :cognitect.aws.states.ListExecutionsOutput/executions :cognitect.aws.states/ExecutionList)

(s/def
  :cognitect.aws.states.ListExecutionsOutput/nextToken
  :cognitect.aws.states/ListExecutionsPageToken)

(s/def :cognitect.aws.states.DescribeStateMachineInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.DescribeStateMachineInput/includedData
  :cognitect.aws.states/IncludedData)

(s/def :cognitect.aws.states.CreateActivityOutput/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.CreateActivityOutput/creationDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.DeleteStateMachineVersionInput/stateMachineVersionArn
  :cognitect.aws.states/LongArn)

(s/def :cognitect.aws.states.StopExecutionInput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StopExecutionInput/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.StopExecutionInput/cause :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.ExecutionSucceededEventDetails/output
  :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.ExecutionSucceededEventDetails/outputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def
  :cognitect.aws.states.ExecutionRedrivenEventDetails/redriveCount
  :cognitect.aws.states/RedriveCount)

(s/def :cognitect.aws.states.EncryptionConfiguration/kmsKeyId :cognitect.aws.states/KmsKeyId)

(s/def
  :cognitect.aws.states.EncryptionConfiguration/kmsDataKeyReusePeriodSeconds
  :cognitect.aws.states/KmsDataKeyReusePeriodSeconds)

(s/def :cognitect.aws.states.EncryptionConfiguration/type :cognitect.aws.states/EncryptionType)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/loggingConfiguration
  :cognitect.aws.states/LoggingConfiguration)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/definition
  :cognitect.aws.states/Definition)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/updateDate
  :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DescribeStateMachineForExecutionOutput/name :cognitect.aws.states/Name)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/revisionId
  :cognitect.aws.states/RevisionId)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/mapRunArn
  :cognitect.aws.states/LongArn)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/label
  :cognitect.aws.states/MapRunLabel)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/variableReferences
  :cognitect.aws.states/VariableReferences)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/tracingConfiguration
  :cognitect.aws.states/TracingConfiguration)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/encryptionConfiguration
  :cognitect.aws.states/EncryptionConfiguration)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/stateMachineArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.DescribeStateMachineForExecutionOutput/roleArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.UpdateStateMachineAliasOutput/updateDate
  :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.BillingDetails/billedMemoryUsedInMB
  :cognitect.aws.states/BilledMemoryUsed)

(s/def
  :cognitect.aws.states.BillingDetails/billedDurationInMilliseconds
  :cognitect.aws.states/BilledDuration)

(s/def :cognitect.aws.states.InvalidLoggingConfiguration/message :cognitect.aws.states/ErrorMessage)

(s/def
  :cognitect.aws.states.LambdaFunctionSucceededEventDetails/output
  :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.LambdaFunctionSucceededEventDetails/outputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def :cognitect.aws.states.SendTaskSuccessInput/taskToken :cognitect.aws.states/TaskToken)

(s/def :cognitect.aws.states.SendTaskSuccessInput/output :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.LambdaFunctionFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.LambdaFunctionFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.LoggingConfiguration/level :cognitect.aws.states/LogLevel)

(s/def
  :cognitect.aws.states.LoggingConfiguration/includeExecutionData
  :cognitect.aws.states/IncludeExecutionData)

(s/def
  :cognitect.aws.states.LoggingConfiguration/destinations
  :cognitect.aws.states/LogDestinationList)

(s/def :cognitect.aws.states.CreateStateMachineInput/tags :cognitect.aws.states/TagList)

(s/def
  :cognitect.aws.states.CreateStateMachineInput/loggingConfiguration
  :cognitect.aws.states/LoggingConfiguration)

(s/def :cognitect.aws.states.CreateStateMachineInput/definition :cognitect.aws.states/Definition)

(s/def
  :cognitect.aws.states.CreateStateMachineInput/versionDescription
  :cognitect.aws.states/VersionDescription)

(s/def :cognitect.aws.states.CreateStateMachineInput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.CreateStateMachineInput/type :cognitect.aws.states/StateMachineType)

(s/def
  :cognitect.aws.states.CreateStateMachineInput/tracingConfiguration
  :cognitect.aws.states/TracingConfiguration)

(s/def
  :cognitect.aws.states.CreateStateMachineInput/encryptionConfiguration
  :cognitect.aws.states/EncryptionConfiguration)

(s/def :cognitect.aws.states.CreateStateMachineInput/publish :cognitect.aws.states/Publish)

(s/def :cognitect.aws.states.CreateStateMachineInput/roleArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ResourceNotFound/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.ResourceNotFound/resourceName :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.TaskStartFailedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskStartFailedEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskStartFailedEventDetails/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.TaskStartFailedEventDetails/cause :cognitect.aws.states/SensitiveCause)

(s/def
  :cognitect.aws.states.StateMachineAliasListItem/stateMachineAliasArn
  :cognitect.aws.states/LongArn)

(s/def :cognitect.aws.states.StateMachineAliasListItem/creationDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.MapRunExecutionCounts/resultsWritten
  :cognitect.aws.states/UnsignedLong)

(s/def
  :cognitect.aws.states.MapRunExecutionCounts/failuresNotRedrivable
  :cognitect.aws.states/LongObject)

(s/def :cognitect.aws.states.MapRunExecutionCounts/pending :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunExecutionCounts/aborted :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunExecutionCounts/running :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunExecutionCounts/total :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunExecutionCounts/timedOut :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunExecutionCounts/pendingRedrive :cognitect.aws.states/LongObject)

(s/def :cognitect.aws.states.MapRunExecutionCounts/failed :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.MapRunExecutionCounts/succeeded :cognitect.aws.states/UnsignedLong)

(s/def :cognitect.aws.states.ExecutionNotRedrivable/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.TaskStartedEventDetails/resourceType :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.TaskStartedEventDetails/resource :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.DescribeActivityOutput/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeActivityOutput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.DescribeActivityOutput/creationDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.DescribeActivityOutput/encryptionConfiguration
  :cognitect.aws.states/EncryptionConfiguration)

(s/def
  :cognitect.aws.states.PublishStateMachineVersionOutput/creationDate
  :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.PublishStateMachineVersionOutput/stateMachineVersionArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StartExecutionInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.StartExecutionInput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StartExecutionInput/input :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.StartExecutionInput/traceHeader :cognitect.aws.states/TraceHeader)

(s/def :cognitect.aws.states.InvalidArn/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.ExecutionListItem/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.ExecutionListItem/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ExecutionListItem/stopDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.ExecutionListItem/stateMachineVersionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ExecutionListItem/redriveDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.ExecutionListItem/startDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.ExecutionListItem/redriveCount :cognitect.aws.states/RedriveCount)

(s/def :cognitect.aws.states.ExecutionListItem/mapRunArn :cognitect.aws.states/LongArn)

(s/def :cognitect.aws.states.ExecutionListItem/status :cognitect.aws.states/ExecutionStatus)

(s/def :cognitect.aws.states.ExecutionListItem/stateMachineAliasArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ExecutionListItem/itemCount :cognitect.aws.states/UnsignedInteger)

(s/def :cognitect.aws.states.ExecutionListItem/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ListMapRunsOutput/mapRuns :cognitect.aws.states/MapRunList)

(s/def :cognitect.aws.states.ListMapRunsOutput/nextToken :cognitect.aws.states/PageToken)

(s/def :cognitect.aws.states.ExecutionAlreadyExists/message :cognitect.aws.states/ErrorMessage)

(s/def
  :cognitect.aws.states.StateMachineTypeNotSupported/message
  :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.InvalidTracingConfiguration/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.MapRunStartedEventDetails/mapRunArn :cognitect.aws.states/LongArn)

(s/def :cognitect.aws.states.ListExecutionsInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ListExecutionsInput/statusFilter :cognitect.aws.states/ExecutionStatus)

(s/def :cognitect.aws.states.ListExecutionsInput/maxResults :cognitect.aws.states/PageSize)

(s/def
  :cognitect.aws.states.ListExecutionsInput/nextToken
  :cognitect.aws.states/ListExecutionsPageToken)

(s/def :cognitect.aws.states.ListExecutionsInput/mapRunArn :cognitect.aws.states/LongArn)

(s/def
  :cognitect.aws.states.ListExecutionsInput/redriveFilter
  :cognitect.aws.states/ExecutionRedriveFilter)

(s/def :cognitect.aws.states.UpdateStateMachineOutput/updateDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.UpdateStateMachineOutput/revisionId :cognitect.aws.states/RevisionId)

(s/def
  :cognitect.aws.states.UpdateStateMachineOutput/stateMachineVersionArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeActivityInput/activityArn :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.GetExecutionHistoryOutput/events
  :cognitect.aws.states/HistoryEventList)

(s/def :cognitect.aws.states.GetExecutionHistoryOutput/nextToken :cognitect.aws.states/PageToken)

(s/def
  :cognitect.aws.states.HistoryEvent/taskScheduledEventDetails
  :cognitect.aws.states/TaskScheduledEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionTimedOutEventDetails
  :cognitect.aws.states/ExecutionTimedOutEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/mapIterationAbortedEventDetails
  :cognitect.aws.states/MapIterationEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activityTimedOutEventDetails
  :cognitect.aws.states/ActivityTimedOutEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/mapRunStartedEventDetails
  :cognitect.aws.states/MapRunStartedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskStartedEventDetails
  :cognitect.aws.states/TaskStartedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/mapIterationFailedEventDetails
  :cognitect.aws.states/MapIterationEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/mapRunRedrivenEventDetails
  :cognitect.aws.states/MapRunRedrivenEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/stateEnteredEventDetails
  :cognitect.aws.states/StateEnteredEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/mapIterationSucceededEventDetails
  :cognitect.aws.states/MapIterationEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionScheduleFailedEventDetails
  :cognitect.aws.states/LambdaFunctionScheduleFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionSucceededEventDetails
  :cognitect.aws.states/ExecutionSucceededEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskStartFailedEventDetails
  :cognitect.aws.states/TaskStartFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/stateExitedEventDetails
  :cognitect.aws.states/StateExitedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/mapStateStartedEventDetails
  :cognitect.aws.states/MapStateStartedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activitySucceededEventDetails
  :cognitect.aws.states/ActivitySucceededEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionStartFailedEventDetails
  :cognitect.aws.states/LambdaFunctionStartFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/mapRunFailedEventDetails
  :cognitect.aws.states/MapRunFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskSubmittedEventDetails
  :cognitect.aws.states/TaskSubmittedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionFailedEventDetails
  :cognitect.aws.states/ExecutionFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/mapIterationStartedEventDetails
  :cognitect.aws.states/MapIterationEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionTimedOutEventDetails
  :cognitect.aws.states/LambdaFunctionTimedOutEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/evaluationFailedEventDetails
  :cognitect.aws.states/EvaluationFailedEventDetails)

(s/def :cognitect.aws.states.HistoryEvent/type :cognitect.aws.states/HistoryEventType)

(s/def
  :cognitect.aws.states.HistoryEvent/activityStartedEventDetails
  :cognitect.aws.states/ActivityStartedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activityFailedEventDetails
  :cognitect.aws.states/ActivityFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionStartedEventDetails
  :cognitect.aws.states/ExecutionStartedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionScheduledEventDetails
  :cognitect.aws.states/LambdaFunctionScheduledEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskSucceededEventDetails
  :cognitect.aws.states/TaskSucceededEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activityScheduledEventDetails
  :cognitect.aws.states/ActivityScheduledEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskTimedOutEventDetails
  :cognitect.aws.states/TaskTimedOutEventDetails)

(s/def :cognitect.aws.states.HistoryEvent/id :cognitect.aws.states/EventId)

(s/def :cognitect.aws.states.HistoryEvent/previousEventId :cognitect.aws.states/EventId)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionSucceededEventDetails
  :cognitect.aws.states/LambdaFunctionSucceededEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionRedrivenEventDetails
  :cognitect.aws.states/ExecutionRedrivenEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskFailedEventDetails
  :cognitect.aws.states/TaskFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/executionAbortedEventDetails
  :cognitect.aws.states/ExecutionAbortedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/taskSubmitFailedEventDetails
  :cognitect.aws.states/TaskSubmitFailedEventDetails)

(s/def
  :cognitect.aws.states.HistoryEvent/activityScheduleFailedEventDetails
  :cognitect.aws.states/ActivityScheduleFailedEventDetails)

(s/def :cognitect.aws.states.HistoryEvent/timestamp :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.HistoryEvent/lambdaFunctionFailedEventDetails
  :cognitect.aws.states/LambdaFunctionFailedEventDetails)

(s/def
  :cognitect.aws.states.ListStateMachineAliasesOutput/stateMachineAliases
  :cognitect.aws.states/StateMachineAliasList)

(s/def
  :cognitect.aws.states.ListStateMachineAliasesOutput/nextToken
  :cognitect.aws.states/PageToken)

(s/def
  :cognitect.aws.states.ActivityScheduleFailedEventDetails/error
  :cognitect.aws.states/SensitiveError)

(s/def
  :cognitect.aws.states.ActivityScheduleFailedEventDetails/cause
  :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.GetActivityTaskInput/activityArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.GetActivityTaskInput/workerName :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.DescribeExecutionOutput/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.DescribeExecutionOutput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.DescribeExecutionOutput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeExecutionOutput/stopDate :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.DescribeExecutionOutput/stateMachineVersionArn
  :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeExecutionOutput/redriveDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DescribeExecutionOutput/startDate :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.DescribeExecutionOutput/output :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.DescribeExecutionOutput/redriveCount
  :cognitect.aws.states/RedriveCount)

(s/def :cognitect.aws.states.DescribeExecutionOutput/mapRunArn :cognitect.aws.states/LongArn)

(s/def
  :cognitect.aws.states.DescribeExecutionOutput/redriveStatus
  :cognitect.aws.states/ExecutionRedriveStatus)

(s/def :cognitect.aws.states.DescribeExecutionOutput/status :cognitect.aws.states/ExecutionStatus)

(s/def
  :cognitect.aws.states.DescribeExecutionOutput/redriveStatusReason
  :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.DescribeExecutionOutput/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.DescribeExecutionOutput/stateMachineAliasArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeExecutionOutput/input :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.DescribeExecutionOutput/outputDetails
  :cognitect.aws.states/CloudWatchEventsExecutionDataDetails)

(s/def :cognitect.aws.states.DescribeExecutionOutput/traceHeader :cognitect.aws.states/TraceHeader)

(s/def
  :cognitect.aws.states.DescribeExecutionOutput/inputDetails
  :cognitect.aws.states/CloudWatchEventsExecutionDataDetails)

(s/def :cognitect.aws.states.DescribeExecutionOutput/stateMachineArn :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.UpdateStateMachineAliasInput/stateMachineAliasArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.UpdateStateMachineAliasInput/description
  :cognitect.aws.states/AliasDescription)

(s/def
  :cognitect.aws.states.UpdateStateMachineAliasInput/routingConfiguration
  :cognitect.aws.states/RoutingConfigurationList)

(s/def
  :cognitect.aws.states.DescribeStateMachineOutput/description
  :cognitect.aws.states/VersionDescription)

(s/def
  :cognitect.aws.states.DescribeStateMachineOutput/loggingConfiguration
  :cognitect.aws.states/LoggingConfiguration)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/definition :cognitect.aws.states/Definition)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/revisionId :cognitect.aws.states/RevisionId)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/type :cognitect.aws.states/StateMachineType)

(s/def
  :cognitect.aws.states.DescribeStateMachineOutput/status
  :cognitect.aws.states/StateMachineStatus)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/label :cognitect.aws.states/MapRunLabel)

(s/def
  :cognitect.aws.states.DescribeStateMachineOutput/variableReferences
  :cognitect.aws.states/VariableReferences)

(s/def
  :cognitect.aws.states.DescribeStateMachineOutput/tracingConfiguration
  :cognitect.aws.states/TracingConfiguration)

(s/def
  :cognitect.aws.states.DescribeStateMachineOutput/creationDate
  :cognitect.aws.states/Timestamp)

(s/def
  :cognitect.aws.states.DescribeStateMachineOutput/encryptionConfiguration
  :cognitect.aws.states/EncryptionConfiguration)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.DescribeStateMachineOutput/roleArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.SendTaskHeartbeatInput/taskToken :cognitect.aws.states/TaskToken)

(s/def
  :cognitect.aws.states.RoutingConfigurationListItem/stateMachineVersionArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.RoutingConfigurationListItem/weight
  :cognitect.aws.states/VersionWeight)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionInput/definition
  :cognitect.aws.states/Definition)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionInput/type
  :cognitect.aws.states/StateMachineType)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionInput/severity
  :cognitect.aws.states/ValidateStateMachineDefinitionSeverity)

(s/def
  :cognitect.aws.states.ValidateStateMachineDefinitionInput/maxResults
  :cognitect.aws.states/ValidateStateMachineDefinitionMaxResult)

(s/def :cognitect.aws.states.TaskDoesNotExist/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.MapIterationEventDetails/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.MapIterationEventDetails/index :cognitect.aws.states/UnsignedInteger)

(s/def :cognitect.aws.states.DeleteStateMachineInput/stateMachineArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.InvalidName/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.StateExitedEventDetails/name :cognitect.aws.states/Name)

(s/def :cognitect.aws.states.StateExitedEventDetails/output :cognitect.aws.states/SensitiveData)

(s/def
  :cognitect.aws.states.StateExitedEventDetails/outputDetails
  :cognitect.aws.states/HistoryEventExecutionDataDetails)

(s/def
  :cognitect.aws.states.StateExitedEventDetails/assignedVariables
  :cognitect.aws.states/AssignedVariables)

(s/def
  :cognitect.aws.states.StateExitedEventDetails/assignedVariablesDetails
  :cognitect.aws.states/AssignedVariablesDetails)

(s/def :cognitect.aws.states.TestStateOutput/output :cognitect.aws.states/SensitiveData)

(s/def :cognitect.aws.states.TestStateOutput/error :cognitect.aws.states/SensitiveError)

(s/def :cognitect.aws.states.TestStateOutput/cause :cognitect.aws.states/SensitiveCause)

(s/def :cognitect.aws.states.TestStateOutput/inspectionData :cognitect.aws.states/InspectionData)

(s/def :cognitect.aws.states.TestStateOutput/nextState :cognitect.aws.states/StateName)

(s/def :cognitect.aws.states.TestStateOutput/status :cognitect.aws.states/TestExecutionStatus)

(s/def :cognitect.aws.states.StateMachineLimitExceeded/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.MapRunRedrivenEventDetails/mapRunArn :cognitect.aws.states/LongArn)

(s/def
  :cognitect.aws.states.MapRunRedrivenEventDetails/redriveCount
  :cognitect.aws.states/RedriveCount)

(s/def :cognitect.aws.states.ListMapRunsInput/executionArn :cognitect.aws.states/Arn)

(s/def :cognitect.aws.states.ListMapRunsInput/maxResults :cognitect.aws.states/PageSize)

(s/def :cognitect.aws.states.ListMapRunsInput/nextToken :cognitect.aws.states/PageToken)

(s/def
  :cognitect.aws.states.CreateStateMachineAliasOutput/stateMachineAliasArn
  :cognitect.aws.states/Arn)

(s/def
  :cognitect.aws.states.CreateStateMachineAliasOutput/creationDate
  :cognitect.aws.states/Timestamp)

(s/def :cognitect.aws.states.ConflictException/message :cognitect.aws.states/ErrorMessage)

(s/def :cognitect.aws.states.KmsInvalidStateException/kmsKeyState :cognitect.aws.states/KmsKeyState)

(s/def :cognitect.aws.states.KmsInvalidStateException/message :cognitect.aws.states/ErrorMessage)

