;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.supplychain.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.supplychain/ConfigurationJobStatus
  (s/spec string? :gen #(s/gen #{"SUCCESS" "IN_PROGRESS" "NEW" "QUEUED" "FAILED"})))

(s/def
  :cognitect.aws.supplychain/DataIntegrationEventGroupId
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/SendDataIntegrationEventRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.SendDataIntegrationEventRequest/instanceId
     :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventType
     :cognitect.aws.supplychain.SendDataIntegrationEventRequest/data
     :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventGroupId]
    :opt-un
    [:cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventTimestamp
     :cognitect.aws.supplychain.SendDataIntegrationEventRequest/clientToken]))

(s/def
  :cognitect.aws.supplychain/GetBillOfMaterialsImportJobResponse
  (s/keys :req-un [:cognitect.aws.supplychain.GetBillOfMaterialsImportJobResponse/job]))

(s/def
  :cognitect.aws.supplychain/SendDataIntegrationEventResponse
  (s/keys :req-un [:cognitect.aws.supplychain.SendDataIntegrationEventResponse/eventId]))

(s/def
  :cognitect.aws.supplychain/CreateBillOfMaterialsImportJobResponse
  (s/keys :req-un [:cognitect.aws.supplychain.CreateBillOfMaterialsImportJobResponse/jobId]))

(s/def
  :cognitect.aws.supplychain/BillOfMaterialsImportJob
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.BillOfMaterialsImportJob/instanceId
     :cognitect.aws.supplychain.BillOfMaterialsImportJob/jobId
     :cognitect.aws.supplychain.BillOfMaterialsImportJob/status
     :cognitect.aws.supplychain.BillOfMaterialsImportJob/s3uri]
    :opt-un
    [:cognitect.aws.supplychain.BillOfMaterialsImportJob/message]))

(s/def
  :cognitect.aws.supplychain/GetBillOfMaterialsImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.GetBillOfMaterialsImportJobRequest/instanceId
     :cognitect.aws.supplychain.GetBillOfMaterialsImportJobRequest/jobId]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationEventData
  (s/spec
    (s/and string? #(<= 1 (count %) 1048576))
    :gen
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose 1 1048576) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/ClientToken
  (s/spec
    (s/and string? #(<= 33 (count %) 126))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 33 126) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/DataIntegrationEventType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"scn.data.reservation"
        "scn.data.inboundorder"
        "scn.data.processheader"
        "scn.data.inboundorderlineschedule"
        "scn.data.inventorylevel"
        "scn.data.shipmentstoporder"
        "scn.data.processoperation"
        "scn.data.processproduct"
        "scn.data.shipment"
        "scn.data.supplyplan"
        "scn.data.shipmentstop"
        "scn.data.outboundshipment"
        "scn.data.outboundorderline"
        "scn.data.forecast"
        "scn.data.inboundorderline"})))

(s/def
  :cognitect.aws.supplychain/UUID
  (s/spec
    #(re-matches (re-pattern "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.supplychain/SyntheticTimestamp_epoch_seconds inst?)

(s/def
  :cognitect.aws.supplychain/ConfigurationS3Uri
  (s/spec
    #(re-matches (re-pattern "[sS]3://[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]/.+") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.supplychain/String string?)

(s/def
  :cognitect.aws.supplychain/CreateBillOfMaterialsImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/instanceId
     :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/s3uri]
    :opt-un
    [:cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/clientToken]))

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventType
  :cognitect.aws.supplychain/DataIntegrationEventType)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/data
  :cognitect.aws.supplychain/DataIntegrationEventData)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventGroupId
  :cognitect.aws.supplychain/DataIntegrationEventGroupId)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventTimestamp
  :cognitect.aws.supplychain/SyntheticTimestamp_epoch_seconds)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/clientToken
  :cognitect.aws.supplychain/ClientToken)

(s/def
  :cognitect.aws.supplychain.GetBillOfMaterialsImportJobResponse/job
  :cognitect.aws.supplychain/BillOfMaterialsImportJob)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventResponse/eventId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobResponse/jobId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.BillOfMaterialsImportJob/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def :cognitect.aws.supplychain.BillOfMaterialsImportJob/jobId :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.BillOfMaterialsImportJob/status
  :cognitect.aws.supplychain/ConfigurationJobStatus)

(s/def
  :cognitect.aws.supplychain.BillOfMaterialsImportJob/s3uri
  :cognitect.aws.supplychain/ConfigurationS3Uri)

(s/def
  :cognitect.aws.supplychain.BillOfMaterialsImportJob/message
  :cognitect.aws.supplychain/String)

(s/def
  :cognitect.aws.supplychain.GetBillOfMaterialsImportJobRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.GetBillOfMaterialsImportJobRequest/jobId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/s3uri
  :cognitect.aws.supplychain/ConfigurationS3Uri)

(s/def
  :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/clientToken
  :cognitect.aws.supplychain/ClientToken)

