;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.supplychain.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.supplychain/InstanceNameList
  (s/coll-of :cognitect.aws.supplychain/InstanceName :min-count 0 :max-count 10))

(s/def
  :cognitect.aws.supplychain/ThrottlingException
  (s/keys :opt-un [:cognitect.aws.supplychain.ThrottlingException/message]))

(s/def
  :cognitect.aws.supplychain/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.TagResourceRequest/resourceArn
     :cognitect.aws.supplychain.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.supplychain/ServiceQuotaExceededException
  (s/keys :opt-un [:cognitect.aws.supplychain.ServiceQuotaExceededException/message]))

(s/def
  :cognitect.aws.supplychain/InternalServerException
  (s/keys :opt-un [:cognitect.aws.supplychain.InternalServerException/message]))

(s/def
  :cognitect.aws.supplychain/GetInstanceResponse
  (s/keys :req-un [:cognitect.aws.supplychain.GetInstanceResponse/instance]))

(s/def
  :cognitect.aws.supplychain/CreateDataLakeDatasetResponse
  (s/keys :req-un [:cognitect.aws.supplychain.CreateDataLakeDatasetResponse/dataset]))

(s/def
  :cognitect.aws.supplychain/ConfigurationJobStatus
  (s/spec string? :gen #(s/gen #{"SUCCESS" "IN_PROGRESS" "NEW" "QUEUED" "FAILED"})))

(s/def
  :cognitect.aws.supplychain/GetDataIntegrationFlowResponse
  (s/keys :req-un [:cognitect.aws.supplychain.GetDataIntegrationFlowResponse/flow]))

(s/def
  :cognitect.aws.supplychain/UpdateInstanceResponse
  (s/keys :req-un [:cognitect.aws.supplychain.UpdateInstanceResponse/instance]))

(s/def
  :cognitect.aws.supplychain/TagMap
  (s/map-of
    :cognitect.aws.supplychain/TagKey
    :cognitect.aws.supplychain/TagValue
    :min-count
    0
    :max-count
    200))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowTarget
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataIntegrationFlowTarget/targetType]
    :opt-un
    [:cognitect.aws.supplychain.DataIntegrationFlowTarget/s3Target
     :cognitect.aws.supplychain.DataIntegrationFlowTarget/datasetTarget]))

(s/def :cognitect.aws.supplychain/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowTransformationType
  (s/spec string? :gen #(s/gen #{"NONE" "SQL"})))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetSchemaName
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/DataIntegrationEventGroupId
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowTransformation
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataIntegrationFlowTransformation/transformationType]
    :opt-un
    [:cognitect.aws.supplychain.DataIntegrationFlowTransformation/sqlTransformation]))

(s/def
  :cognitect.aws.supplychain/CreateDataIntegrationFlowResponse
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.CreateDataIntegrationFlowResponse/instanceId
     :cognitect.aws.supplychain.CreateDataIntegrationFlowResponse/name]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowNextToken
  (s/spec
    (s/and string? #(<= 1 (count %) 65535))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 65535) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/InstanceWebAppDnsDomain
  (s/spec #(re-matches (re-pattern "(?![-])[a-zA-Z0-9-]{1,62}[a-zA-Z0-9]") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetSchemaField
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataLakeDatasetSchemaField/name
     :cognitect.aws.supplychain.DataLakeDatasetSchemaField/type
     :cognitect.aws.supplychain.DataLakeDatasetSchemaField/isRequired]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowSQLTransformationConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataIntegrationFlowSQLTransformationConfiguration/query]))

(s/def
  :cognitect.aws.supplychain/DeleteInstanceResponse
  (s/keys :req-un [:cognitect.aws.supplychain.DeleteInstanceResponse/instance]))

(s/def
  :cognitect.aws.supplychain/ValidationException
  (s/keys :opt-un [:cognitect.aws.supplychain.ValidationException/message]))

(s/def
  :cognitect.aws.supplychain/GetDataIntegrationFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.GetDataIntegrationFlowRequest/instanceId
     :cognitect.aws.supplychain.GetDataIntegrationFlowRequest/name]))

(s/def
  :cognitect.aws.supplychain/AccessDeniedException
  (s/keys :opt-un [:cognitect.aws.supplychain.AccessDeniedException/message]))

(s/def
  :cognitect.aws.supplychain/SendDataIntegrationEventRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.SendDataIntegrationEventRequest/instanceId
     :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventType
     :cognitect.aws.supplychain.SendDataIntegrationEventRequest/data
     :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventGroupId]
    :opt-un
    [:cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventTimestamp
     :cognitect.aws.supplychain.SendDataIntegrationEventRequest/clientToken]))

(s/def
  :cognitect.aws.supplychain/GetBillOfMaterialsImportJobResponse
  (s/keys :req-un [:cognitect.aws.supplychain.GetBillOfMaterialsImportJobResponse/job]))

(s/def
  :cognitect.aws.supplychain/GetDataLakeDatasetResponse
  (s/keys :req-un [:cognitect.aws.supplychain.GetDataLakeDatasetResponse/dataset]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowSourceList
  (s/coll-of :cognitect.aws.supplychain/DataIntegrationFlowSource :min-count 1 :max-count 40))

(s/def
  :cognitect.aws.supplychain/AwsAccountId
  (s/spec #(re-matches (re-pattern "[0-9]{12}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/GetDataLakeDatasetRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.GetDataLakeDatasetRequest/instanceId
     :cognitect.aws.supplychain.GetDataLakeDatasetRequest/namespace
     :cognitect.aws.supplychain.GetDataLakeDatasetRequest/name]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowS3TargetConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataIntegrationFlowS3TargetConfiguration/bucketName
     :cognitect.aws.supplychain.DataIntegrationFlowS3TargetConfiguration/prefix]
    :opt-un
    [:cognitect.aws.supplychain.DataIntegrationFlowS3TargetConfiguration/options]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowSourceType
  (s/spec string? :gen #(s/gen #{"DATASET" "S3"})))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowSourceName
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9_]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetMaxResults
  (s/spec (s/and int? #(<= 0 % 20)) :gen #(gen/choose 0 20)))

(s/def
  :cognitect.aws.supplychain/InstanceName
  (s/spec
    #(re-matches (re-pattern "(?![ _ʼ'%-])[a-zA-Z0-9 _ʼ'%-]{0,62}[a-zA-Z0-9]") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.supplychain/SendDataIntegrationEventResponse
  (s/keys :req-un [:cognitect.aws.supplychain.SendDataIntegrationEventResponse/eventId]))

(s/def
  :cognitect.aws.supplychain/UpdateDataLakeDatasetResponse
  (s/keys :req-un [:cognitect.aws.supplychain.UpdateDataLakeDatasetResponse/dataset]))

(s/def
  :cognitect.aws.supplychain/KmsKeyArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[a-z0-9][-.a-z0-9]{0,62}:kms:([a-z0-9][-.a-z0-9]{0,62})?:([a-z0-9][-.a-z0-9]{0,62})?:key/.{0,1019}")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.supplychain/Boolean boolean?)

(s/def
  :cognitect.aws.supplychain/CreateBillOfMaterialsImportJobResponse
  (s/keys :req-un [:cognitect.aws.supplychain.CreateBillOfMaterialsImportJobResponse/jobId]))

(s/def
  :cognitect.aws.supplychain/CreateInstanceRequest
  (s/keys
    :opt-un
    [:cognitect.aws.supplychain.CreateInstanceRequest/webAppDnsDomain
     :cognitect.aws.supplychain.CreateInstanceRequest/instanceName
     :cognitect.aws.supplychain.CreateInstanceRequest/clientToken
     :cognitect.aws.supplychain.CreateInstanceRequest/tags
     :cognitect.aws.supplychain.CreateInstanceRequest/kmsKeyArn
     :cognitect.aws.supplychain.CreateInstanceRequest/instanceDescription]))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetNamespace
  (s/spec #(re-matches (re-pattern "[a-z]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/DeleteDataIntegrationFlowResponse
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DeleteDataIntegrationFlowResponse/instanceId
     :cognitect.aws.supplychain.DeleteDataIntegrationFlowResponse/name]))

(s/def
  :cognitect.aws.supplychain/CreateDataLakeDatasetRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.CreateDataLakeDatasetRequest/instanceId
     :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/namespace
     :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/name]
    :opt-un
    [:cognitect.aws.supplychain.CreateDataLakeDatasetRequest/tags
     :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/schema
     :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/description]))

(s/def :cognitect.aws.supplychain/InstanceList (s/coll-of :cognitect.aws.supplychain/Instance))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetSchema
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataLakeDatasetSchema/name
     :cognitect.aws.supplychain.DataLakeDatasetSchema/fields]))

(s/def
  :cognitect.aws.supplychain/DeleteDataLakeDatasetResponse
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DeleteDataLakeDatasetResponse/instanceId
     :cognitect.aws.supplychain.DeleteDataLakeDatasetResponse/namespace
     :cognitect.aws.supplychain.DeleteDataLakeDatasetResponse/name]))

(s/def
  :cognitect.aws.supplychain/ListInstancesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.supplychain.ListInstancesRequest/instanceNameFilter
     :cognitect.aws.supplychain.ListInstancesRequest/instanceStateFilter
     :cognitect.aws.supplychain.ListInstancesRequest/maxResults
     :cognitect.aws.supplychain.ListInstancesRequest/nextToken]))

(s/def
  :cognitect.aws.supplychain/CreateInstanceResponse
  (s/keys :req-un [:cognitect.aws.supplychain.CreateInstanceResponse/instance]))

(s/def
  :cognitect.aws.supplychain/GetInstanceRequest
  (s/keys :req-un [:cognitect.aws.supplychain.GetInstanceRequest/instanceId]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowS3Options
  (s/keys :opt-un [:cognitect.aws.supplychain.DataIntegrationFlowS3Options/fileType]))

(s/def
  :cognitect.aws.supplychain/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/ListDataIntegrationFlowsResponse
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.ListDataIntegrationFlowsResponse/flows]
    :opt-un
    [:cognitect.aws.supplychain.ListDataIntegrationFlowsResponse/nextToken]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowFileType
  (s/spec string? :gen #(s/gen #{"CSV" "PARQUET" "JSON"})))

(s/def
  :cognitect.aws.supplychain/UpdateDataIntegrationFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/instanceId
     :cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/name]
    :opt-un
    [:cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/sources
     :cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/transformation
     :cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/target]))

(s/def
  :cognitect.aws.supplychain/DeleteDataIntegrationFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DeleteDataIntegrationFlowRequest/instanceId
     :cognitect.aws.supplychain.DeleteDataIntegrationFlowRequest/name]))

(s/def
  :cognitect.aws.supplychain/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.supplychain.ListTagsForResourceRequest/resourceArn]))

(s/def
  :cognitect.aws.supplychain/DatasetIdentifier
  (s/spec #(re-matches (re-pattern "[-_/A-Za-z0-9:]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/BillOfMaterialsImportJob
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.BillOfMaterialsImportJob/instanceId
     :cognitect.aws.supplychain.BillOfMaterialsImportJob/jobId
     :cognitect.aws.supplychain.BillOfMaterialsImportJob/status
     :cognitect.aws.supplychain.BillOfMaterialsImportJob/s3uri]
    :opt-un
    [:cognitect.aws.supplychain.BillOfMaterialsImportJob/message]))

(s/def :cognitect.aws.supplychain/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetNextToken
  (s/spec
    (s/and string? #(<= 1 (count %) 65535))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 65535) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowDatasetSourceConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataIntegrationFlowDatasetSourceConfiguration/datasetIdentifier]
    :opt-un
    [:cognitect.aws.supplychain.DataIntegrationFlowDatasetSourceConfiguration/options]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowDatasetTargetConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataIntegrationFlowDatasetTargetConfiguration/datasetIdentifier]
    :opt-un
    [:cognitect.aws.supplychain.DataIntegrationFlowDatasetTargetConfiguration/options]))

(s/def
  :cognitect.aws.supplychain/InstanceDescription
  (s/spec #(re-matches (re-pattern "([a-zA-Z0-9., _ʼ'%-]){0,500}") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/ListDataLakeDatasetsRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.ListDataLakeDatasetsRequest/instanceId
     :cognitect.aws.supplychain.ListDataLakeDatasetsRequest/namespace]
    :opt-un
    [:cognitect.aws.supplychain.ListDataLakeDatasetsRequest/maxResults
     :cognitect.aws.supplychain.ListDataLakeDatasetsRequest/nextToken]))

(s/def
  :cognitect.aws.supplychain/DataLakeDataset
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataLakeDataset/instanceId
     :cognitect.aws.supplychain.DataLakeDataset/namespace
     :cognitect.aws.supplychain.DataLakeDataset/name
     :cognitect.aws.supplychain.DataLakeDataset/arn
     :cognitect.aws.supplychain.DataLakeDataset/schema
     :cognitect.aws.supplychain.DataLakeDataset/createdTime
     :cognitect.aws.supplychain.DataLakeDataset/lastModifiedTime]
    :opt-un
    [:cognitect.aws.supplychain.DataLakeDataset/description]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowMaxResults
  (s/spec (s/and int? #(<= 0 % 20)) :gen #(gen/choose 0 20)))

(s/def
  :cognitect.aws.supplychain/GetBillOfMaterialsImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.GetBillOfMaterialsImportJobRequest/instanceId
     :cognitect.aws.supplychain.GetBillOfMaterialsImportJobRequest/jobId]))

(s/def
  :cognitect.aws.supplychain/AscResourceArn
  (s/spec
    #(re-matches
      (re-pattern
        "arn:aws:scn(?::([a-z0-9-]+):([0-9]+):instance)?/([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})[-_./A-Za-z0-9]*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowDatasetOptions
  (s/keys
    :opt-un
    [:cognitect.aws.supplychain.DataIntegrationFlowDatasetOptions/loadType
     :cognitect.aws.supplychain.DataIntegrationFlowDatasetOptions/dedupeRecords]))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetSchemaFieldType
  (s/spec string? :gen #(s/gen #{"TIMESTAMP" "DOUBLE" "STRING" "INT"})))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlow
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataIntegrationFlow/instanceId
     :cognitect.aws.supplychain.DataIntegrationFlow/name
     :cognitect.aws.supplychain.DataIntegrationFlow/sources
     :cognitect.aws.supplychain.DataIntegrationFlow/transformation
     :cognitect.aws.supplychain.DataIntegrationFlow/target
     :cognitect.aws.supplychain.DataIntegrationFlow/createdTime
     :cognitect.aws.supplychain.DataIntegrationFlow/lastModifiedTime]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowLoadType
  (s/spec string? :gen #(s/gen #{"INCREMENTAL" "REPLACE"})))

(s/def
  :cognitect.aws.supplychain/DataIntegrationEventData
  (s/spec
    (s/and string? #(<= 1 (count %) 1048576))
    :gen
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose 1 1048576) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetName
  (s/spec #(re-matches (re-pattern "[a-z0-9_]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/Instance
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.Instance/instanceId
     :cognitect.aws.supplychain.Instance/awsAccountId
     :cognitect.aws.supplychain.Instance/state]
    :opt-un
    [:cognitect.aws.supplychain.Instance/webAppDnsDomain
     :cognitect.aws.supplychain.Instance/instanceName
     :cognitect.aws.supplychain.Instance/errorMessage
     :cognitect.aws.supplychain.Instance/createdTime
     :cognitect.aws.supplychain.Instance/lastModifiedTime
     :cognitect.aws.supplychain.Instance/kmsKeyArn
     :cognitect.aws.supplychain.Instance/instanceDescription
     :cognitect.aws.supplychain.Instance/versionNumber]))

(s/def
  :cognitect.aws.supplychain/UpdateDataIntegrationFlowResponse
  (s/keys :req-un [:cognitect.aws.supplychain.UpdateDataIntegrationFlowResponse/flow]))

(s/def
  :cognitect.aws.supplychain/InstanceNextToken
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/InstanceMaxResults
  (s/spec (s/and int? #(<= 0 % 20)) :gen #(gen/choose 0 20)))

(s/def
  :cognitect.aws.supplychain/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.UntagResourceRequest/resourceArn
     :cognitect.aws.supplychain.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.supplychain/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetSchemaFieldList
  (s/coll-of :cognitect.aws.supplychain/DataLakeDatasetSchemaField :min-count 1 :max-count 500))

(s/def
  :cognitect.aws.supplychain/InstanceStateList
  (s/coll-of :cognitect.aws.supplychain/InstanceState :min-count 0 :max-count 6))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowName
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowSQLQuery
  (s/spec
    (s/and string? #(<= 1 (count %) 65535))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 65535) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/S3BucketName
  (s/spec #(re-matches (re-pattern "[a-z0-9][a-z0-9.-]*[a-z0-9]") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/ClientToken
  (s/spec
    (s/and string? #(<= 33 (count %) 126))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 33 126) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/DataIntegrationEventType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"scn.data.reservation"
        "scn.data.inboundorder"
        "scn.data.processheader"
        "scn.data.inboundorderlineschedule"
        "scn.data.inventorylevel"
        "scn.data.shipmentstoporder"
        "scn.data.processoperation"
        "scn.data.processproduct"
        "scn.data.shipment"
        "scn.data.supplyplan"
        "scn.data.shipmentstop"
        "scn.data.outboundshipment"
        "scn.data.outboundorderline"
        "scn.data.forecast"
        "scn.data.inboundorderline"})))

(s/def :cognitect.aws.supplychain/Timestamp inst?)

(s/def
  :cognitect.aws.supplychain/InstanceState
  (s/spec
    string?
    :gen
    #(s/gen #{"DeleteFailed" "Active" "Deleting" "Deleted" "Initializing" "CreateFailed"})))

(s/def
  :cognitect.aws.supplychain/UUID
  (s/spec
    #(re-matches (re-pattern "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.supplychain/SyntheticTimestamp_epoch_seconds inst?)

(s/def
  :cognitect.aws.supplychain/ListDataLakeDatasetsResponse
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.ListDataLakeDatasetsResponse/datasets]
    :opt-un
    [:cognitect.aws.supplychain.ListDataLakeDatasetsResponse/nextToken]))

(s/def
  :cognitect.aws.supplychain/ListDataIntegrationFlowsRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.ListDataIntegrationFlowsRequest/instanceId]
    :opt-un
    [:cognitect.aws.supplychain.ListDataIntegrationFlowsRequest/maxResults
     :cognitect.aws.supplychain.ListDataIntegrationFlowsRequest/nextToken]))

(s/def
  :cognitect.aws.supplychain/Double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowS3Prefix
  (s/spec #(re-matches (re-pattern "[/A-Za-z0-9._-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/DeleteInstanceRequest
  (s/keys :req-un [:cognitect.aws.supplychain.DeleteInstanceRequest/instanceId]))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetSchemaFieldName
  (s/spec #(re-matches (re-pattern "[a-z0-9_]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.supplychain/DeleteDataLakeDatasetRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DeleteDataLakeDatasetRequest/instanceId
     :cognitect.aws.supplychain.DeleteDataLakeDatasetRequest/namespace
     :cognitect.aws.supplychain.DeleteDataLakeDatasetRequest/name]))

(s/def
  :cognitect.aws.supplychain/ListTagsForResourceResponse
  (s/keys :req-un [:cognitect.aws.supplychain.ListTagsForResourceResponse/tags]))

(s/def
  :cognitect.aws.supplychain/ConfigurationS3Uri
  (s/spec
    #(re-matches (re-pattern "[sS]3://[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]/.+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.supplychain/ListInstancesResponse
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.ListInstancesResponse/instances]
    :opt-un
    [:cognitect.aws.supplychain.ListInstancesResponse/nextToken]))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetList
  (s/coll-of :cognitect.aws.supplychain/DataLakeDataset :min-count 1 :max-count 20))

(s/def
  :cognitect.aws.supplychain/UpdateInstanceRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.UpdateInstanceRequest/instanceId]
    :opt-un
    [:cognitect.aws.supplychain.UpdateInstanceRequest/instanceName
     :cognitect.aws.supplychain.UpdateInstanceRequest/instanceDescription]))

(s/def
  :cognitect.aws.supplychain/CreateDataIntegrationFlowRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/instanceId
     :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/name
     :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/sources
     :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/transformation
     :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/target]
    :opt-un
    [:cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/tags]))

(s/def
  :cognitect.aws.supplychain/DataLakeDatasetDescription
  (s/spec
    (s/and string? #(<= 1 (count %) 500))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 500) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowS3SourceConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataIntegrationFlowS3SourceConfiguration/bucketName
     :cognitect.aws.supplychain.DataIntegrationFlowS3SourceConfiguration/prefix]
    :opt-un
    [:cognitect.aws.supplychain.DataIntegrationFlowS3SourceConfiguration/options]))

(s/def :cognitect.aws.supplychain/String string?)

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowTargetType
  (s/spec string? :gen #(s/gen #{"DATASET" "S3"})))

(s/def
  :cognitect.aws.supplychain/CreateBillOfMaterialsImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/instanceId
     :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/s3uri]
    :opt-un
    [:cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/clientToken]))

(s/def
  :cognitect.aws.supplychain/UpdateDataLakeDatasetRequest
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.UpdateDataLakeDatasetRequest/instanceId
     :cognitect.aws.supplychain.UpdateDataLakeDatasetRequest/namespace
     :cognitect.aws.supplychain.UpdateDataLakeDatasetRequest/name]
    :opt-un
    [:cognitect.aws.supplychain.UpdateDataLakeDatasetRequest/description]))

(s/def
  :cognitect.aws.supplychain/ResourceNotFoundException
  (s/keys :opt-un [:cognitect.aws.supplychain.ResourceNotFoundException/message]))

(s/def
  :cognitect.aws.supplychain/ConflictException
  (s/keys :opt-un [:cognitect.aws.supplychain.ConflictException/message]))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowList
  (s/coll-of :cognitect.aws.supplychain/DataIntegrationFlow))

(s/def
  :cognitect.aws.supplychain/TagKeyList
  (s/coll-of :cognitect.aws.supplychain/TagKey :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.supplychain/DataIntegrationFlowSource
  (s/keys
    :req-un
    [:cognitect.aws.supplychain.DataIntegrationFlowSource/sourceType
     :cognitect.aws.supplychain.DataIntegrationFlowSource/sourceName]
    :opt-un
    [:cognitect.aws.supplychain.DataIntegrationFlowSource/s3Source
     :cognitect.aws.supplychain.DataIntegrationFlowSource/datasetSource]))

(s/def :cognitect.aws.supplychain.ThrottlingException/message :cognitect.aws.supplychain/String)

(s/def
  :cognitect.aws.supplychain.TagResourceRequest/resourceArn
  :cognitect.aws.supplychain/AscResourceArn)

(s/def :cognitect.aws.supplychain.TagResourceRequest/tags :cognitect.aws.supplychain/TagMap)

(s/def
  :cognitect.aws.supplychain.ServiceQuotaExceededException/message
  :cognitect.aws.supplychain/String)

(s/def :cognitect.aws.supplychain.InternalServerException/message :cognitect.aws.supplychain/String)

(s/def :cognitect.aws.supplychain.GetInstanceResponse/instance :cognitect.aws.supplychain/Instance)

(s/def
  :cognitect.aws.supplychain.CreateDataLakeDatasetResponse/dataset
  :cognitect.aws.supplychain/DataLakeDataset)

(s/def
  :cognitect.aws.supplychain.GetDataIntegrationFlowResponse/flow
  :cognitect.aws.supplychain/DataIntegrationFlow)

(s/def
  :cognitect.aws.supplychain.UpdateInstanceResponse/instance
  :cognitect.aws.supplychain/Instance)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowTarget/targetType
  :cognitect.aws.supplychain/DataIntegrationFlowTargetType)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowTarget/s3Target
  :cognitect.aws.supplychain/DataIntegrationFlowS3TargetConfiguration)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowTarget/datasetTarget
  :cognitect.aws.supplychain/DataIntegrationFlowDatasetTargetConfiguration)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowTransformation/transformationType
  :cognitect.aws.supplychain/DataIntegrationFlowTransformationType)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowTransformation/sqlTransformation
  :cognitect.aws.supplychain/DataIntegrationFlowSQLTransformationConfiguration)

(s/def
  :cognitect.aws.supplychain.CreateDataIntegrationFlowResponse/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.CreateDataIntegrationFlowResponse/name
  :cognitect.aws.supplychain/DataIntegrationFlowName)

(s/def
  :cognitect.aws.supplychain.DataLakeDatasetSchemaField/name
  :cognitect.aws.supplychain/DataLakeDatasetSchemaFieldName)

(s/def
  :cognitect.aws.supplychain.DataLakeDatasetSchemaField/type
  :cognitect.aws.supplychain/DataLakeDatasetSchemaFieldType)

(s/def
  :cognitect.aws.supplychain.DataLakeDatasetSchemaField/isRequired
  :cognitect.aws.supplychain/Boolean)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowSQLTransformationConfiguration/query
  :cognitect.aws.supplychain/DataIntegrationFlowSQLQuery)

(s/def
  :cognitect.aws.supplychain.DeleteInstanceResponse/instance
  :cognitect.aws.supplychain/Instance)

(s/def :cognitect.aws.supplychain.ValidationException/message :cognitect.aws.supplychain/String)

(s/def
  :cognitect.aws.supplychain.GetDataIntegrationFlowRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.GetDataIntegrationFlowRequest/name
  :cognitect.aws.supplychain/DataIntegrationFlowName)

(s/def :cognitect.aws.supplychain.AccessDeniedException/message :cognitect.aws.supplychain/String)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventType
  :cognitect.aws.supplychain/DataIntegrationEventType)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/data
  :cognitect.aws.supplychain/DataIntegrationEventData)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventGroupId
  :cognitect.aws.supplychain/DataIntegrationEventGroupId)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/eventTimestamp
  :cognitect.aws.supplychain/SyntheticTimestamp_epoch_seconds)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventRequest/clientToken
  :cognitect.aws.supplychain/ClientToken)

(s/def
  :cognitect.aws.supplychain.GetBillOfMaterialsImportJobResponse/job
  :cognitect.aws.supplychain/BillOfMaterialsImportJob)

(s/def
  :cognitect.aws.supplychain.GetDataLakeDatasetResponse/dataset
  :cognitect.aws.supplychain/DataLakeDataset)

(s/def
  :cognitect.aws.supplychain.GetDataLakeDatasetRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.GetDataLakeDatasetRequest/namespace
  :cognitect.aws.supplychain/DataLakeDatasetNamespace)

(s/def
  :cognitect.aws.supplychain.GetDataLakeDatasetRequest/name
  :cognitect.aws.supplychain/DataLakeDatasetName)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowS3TargetConfiguration/bucketName
  :cognitect.aws.supplychain/S3BucketName)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowS3TargetConfiguration/prefix
  :cognitect.aws.supplychain/DataIntegrationFlowS3Prefix)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowS3TargetConfiguration/options
  :cognitect.aws.supplychain/DataIntegrationFlowS3Options)

(s/def
  :cognitect.aws.supplychain.SendDataIntegrationEventResponse/eventId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.UpdateDataLakeDatasetResponse/dataset
  :cognitect.aws.supplychain/DataLakeDataset)

(s/def
  :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobResponse/jobId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.CreateInstanceRequest/instanceName
  :cognitect.aws.supplychain/InstanceName)

(s/def
  :cognitect.aws.supplychain.CreateInstanceRequest/instanceDescription
  :cognitect.aws.supplychain/InstanceDescription)

(s/def
  :cognitect.aws.supplychain.CreateInstanceRequest/kmsKeyArn
  :cognitect.aws.supplychain/KmsKeyArn)

(s/def
  :cognitect.aws.supplychain.CreateInstanceRequest/webAppDnsDomain
  :cognitect.aws.supplychain/InstanceWebAppDnsDomain)

(s/def :cognitect.aws.supplychain.CreateInstanceRequest/tags :cognitect.aws.supplychain/TagMap)

(s/def
  :cognitect.aws.supplychain.CreateInstanceRequest/clientToken
  :cognitect.aws.supplychain/ClientToken)

(s/def
  :cognitect.aws.supplychain.DeleteDataIntegrationFlowResponse/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.DeleteDataIntegrationFlowResponse/name
  :cognitect.aws.supplychain/DataIntegrationFlowName)

(s/def
  :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/namespace
  :cognitect.aws.supplychain/DataLakeDatasetNamespace)

(s/def
  :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/name
  :cognitect.aws.supplychain/DataLakeDatasetName)

(s/def
  :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/schema
  :cognitect.aws.supplychain/DataLakeDatasetSchema)

(s/def
  :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/description
  :cognitect.aws.supplychain/DataLakeDatasetDescription)

(s/def
  :cognitect.aws.supplychain.CreateDataLakeDatasetRequest/tags
  :cognitect.aws.supplychain/TagMap)

(s/def
  :cognitect.aws.supplychain.DataLakeDatasetSchema/name
  :cognitect.aws.supplychain/DataLakeDatasetSchemaName)

(s/def
  :cognitect.aws.supplychain.DataLakeDatasetSchema/fields
  :cognitect.aws.supplychain/DataLakeDatasetSchemaFieldList)

(s/def
  :cognitect.aws.supplychain.DeleteDataLakeDatasetResponse/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.DeleteDataLakeDatasetResponse/namespace
  :cognitect.aws.supplychain/DataLakeDatasetNamespace)

(s/def
  :cognitect.aws.supplychain.DeleteDataLakeDatasetResponse/name
  :cognitect.aws.supplychain/DataLakeDatasetName)

(s/def
  :cognitect.aws.supplychain.ListInstancesRequest/nextToken
  :cognitect.aws.supplychain/InstanceNextToken)

(s/def
  :cognitect.aws.supplychain.ListInstancesRequest/maxResults
  :cognitect.aws.supplychain/InstanceMaxResults)

(s/def
  :cognitect.aws.supplychain.ListInstancesRequest/instanceNameFilter
  :cognitect.aws.supplychain/InstanceNameList)

(s/def
  :cognitect.aws.supplychain.ListInstancesRequest/instanceStateFilter
  :cognitect.aws.supplychain/InstanceStateList)

(s/def
  :cognitect.aws.supplychain.CreateInstanceResponse/instance
  :cognitect.aws.supplychain/Instance)

(s/def :cognitect.aws.supplychain.GetInstanceRequest/instanceId :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowS3Options/fileType
  :cognitect.aws.supplychain/DataIntegrationFlowFileType)

(s/def
  :cognitect.aws.supplychain.ListDataIntegrationFlowsResponse/flows
  :cognitect.aws.supplychain/DataIntegrationFlowList)

(s/def
  :cognitect.aws.supplychain.ListDataIntegrationFlowsResponse/nextToken
  :cognitect.aws.supplychain/DataIntegrationFlowNextToken)

(s/def
  :cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/name
  :cognitect.aws.supplychain/DataIntegrationFlowName)

(s/def
  :cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/sources
  :cognitect.aws.supplychain/DataIntegrationFlowSourceList)

(s/def
  :cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/transformation
  :cognitect.aws.supplychain/DataIntegrationFlowTransformation)

(s/def
  :cognitect.aws.supplychain.UpdateDataIntegrationFlowRequest/target
  :cognitect.aws.supplychain/DataIntegrationFlowTarget)

(s/def
  :cognitect.aws.supplychain.DeleteDataIntegrationFlowRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.DeleteDataIntegrationFlowRequest/name
  :cognitect.aws.supplychain/DataIntegrationFlowName)

(s/def
  :cognitect.aws.supplychain.ListTagsForResourceRequest/resourceArn
  :cognitect.aws.supplychain/AscResourceArn)

(s/def
  :cognitect.aws.supplychain.BillOfMaterialsImportJob/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def :cognitect.aws.supplychain.BillOfMaterialsImportJob/jobId :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.BillOfMaterialsImportJob/status
  :cognitect.aws.supplychain/ConfigurationJobStatus)

(s/def
  :cognitect.aws.supplychain.BillOfMaterialsImportJob/s3uri
  :cognitect.aws.supplychain/ConfigurationS3Uri)

(s/def
  :cognitect.aws.supplychain.BillOfMaterialsImportJob/message
  :cognitect.aws.supplychain/String)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowDatasetSourceConfiguration/datasetIdentifier
  :cognitect.aws.supplychain/DatasetIdentifier)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowDatasetSourceConfiguration/options
  :cognitect.aws.supplychain/DataIntegrationFlowDatasetOptions)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowDatasetTargetConfiguration/datasetIdentifier
  :cognitect.aws.supplychain/DatasetIdentifier)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowDatasetTargetConfiguration/options
  :cognitect.aws.supplychain/DataIntegrationFlowDatasetOptions)

(s/def
  :cognitect.aws.supplychain.ListDataLakeDatasetsRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.ListDataLakeDatasetsRequest/namespace
  :cognitect.aws.supplychain/DataLakeDatasetNamespace)

(s/def
  :cognitect.aws.supplychain.ListDataLakeDatasetsRequest/nextToken
  :cognitect.aws.supplychain/DataLakeDatasetNextToken)

(s/def
  :cognitect.aws.supplychain.ListDataLakeDatasetsRequest/maxResults
  :cognitect.aws.supplychain/DataLakeDatasetMaxResults)

(s/def :cognitect.aws.supplychain.DataLakeDataset/instanceId :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.DataLakeDataset/namespace
  :cognitect.aws.supplychain/DataLakeDatasetNamespace)

(s/def
  :cognitect.aws.supplychain.DataLakeDataset/name
  :cognitect.aws.supplychain/DataLakeDatasetName)

(s/def :cognitect.aws.supplychain.DataLakeDataset/arn :cognitect.aws.supplychain/AscResourceArn)

(s/def
  :cognitect.aws.supplychain.DataLakeDataset/schema
  :cognitect.aws.supplychain/DataLakeDatasetSchema)

(s/def
  :cognitect.aws.supplychain.DataLakeDataset/description
  :cognitect.aws.supplychain/DataLakeDatasetDescription)

(s/def :cognitect.aws.supplychain.DataLakeDataset/createdTime :cognitect.aws.supplychain/Timestamp)

(s/def
  :cognitect.aws.supplychain.DataLakeDataset/lastModifiedTime
  :cognitect.aws.supplychain/Timestamp)

(s/def
  :cognitect.aws.supplychain.GetBillOfMaterialsImportJobRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.GetBillOfMaterialsImportJobRequest/jobId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowDatasetOptions/loadType
  :cognitect.aws.supplychain/DataIntegrationFlowLoadType)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowDatasetOptions/dedupeRecords
  :cognitect.aws.supplychain/Boolean)

(s/def :cognitect.aws.supplychain.DataIntegrationFlow/instanceId :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlow/name
  :cognitect.aws.supplychain/DataIntegrationFlowName)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlow/sources
  :cognitect.aws.supplychain/DataIntegrationFlowSourceList)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlow/transformation
  :cognitect.aws.supplychain/DataIntegrationFlowTransformation)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlow/target
  :cognitect.aws.supplychain/DataIntegrationFlowTarget)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlow/createdTime
  :cognitect.aws.supplychain/Timestamp)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlow/lastModifiedTime
  :cognitect.aws.supplychain/Timestamp)

(s/def :cognitect.aws.supplychain.Instance/kmsKeyArn :cognitect.aws.supplychain/KmsKeyArn)

(s/def :cognitect.aws.supplychain.Instance/errorMessage :cognitect.aws.supplychain/String)

(s/def :cognitect.aws.supplychain.Instance/instanceId :cognitect.aws.supplychain/UUID)

(s/def :cognitect.aws.supplychain.Instance/instanceName :cognitect.aws.supplychain/InstanceName)

(s/def :cognitect.aws.supplychain.Instance/state :cognitect.aws.supplychain/InstanceState)

(s/def :cognitect.aws.supplychain.Instance/versionNumber :cognitect.aws.supplychain/Double)

(s/def :cognitect.aws.supplychain.Instance/awsAccountId :cognitect.aws.supplychain/AwsAccountId)

(s/def
  :cognitect.aws.supplychain.Instance/webAppDnsDomain
  :cognitect.aws.supplychain/InstanceWebAppDnsDomain)

(s/def :cognitect.aws.supplychain.Instance/lastModifiedTime :cognitect.aws.supplychain/Timestamp)

(s/def :cognitect.aws.supplychain.Instance/createdTime :cognitect.aws.supplychain/Timestamp)

(s/def
  :cognitect.aws.supplychain.Instance/instanceDescription
  :cognitect.aws.supplychain/InstanceDescription)

(s/def
  :cognitect.aws.supplychain.UpdateDataIntegrationFlowResponse/flow
  :cognitect.aws.supplychain/DataIntegrationFlow)

(s/def
  :cognitect.aws.supplychain.UntagResourceRequest/resourceArn
  :cognitect.aws.supplychain/AscResourceArn)

(s/def
  :cognitect.aws.supplychain.UntagResourceRequest/tagKeys
  :cognitect.aws.supplychain/TagKeyList)

(s/def
  :cognitect.aws.supplychain.ListDataLakeDatasetsResponse/datasets
  :cognitect.aws.supplychain/DataLakeDatasetList)

(s/def
  :cognitect.aws.supplychain.ListDataLakeDatasetsResponse/nextToken
  :cognitect.aws.supplychain/DataLakeDatasetNextToken)

(s/def
  :cognitect.aws.supplychain.ListDataIntegrationFlowsRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.ListDataIntegrationFlowsRequest/nextToken
  :cognitect.aws.supplychain/DataIntegrationFlowNextToken)

(s/def
  :cognitect.aws.supplychain.ListDataIntegrationFlowsRequest/maxResults
  :cognitect.aws.supplychain/DataIntegrationFlowMaxResults)

(s/def :cognitect.aws.supplychain.DeleteInstanceRequest/instanceId :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.DeleteDataLakeDatasetRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.DeleteDataLakeDatasetRequest/namespace
  :cognitect.aws.supplychain/DataLakeDatasetNamespace)

(s/def
  :cognitect.aws.supplychain.DeleteDataLakeDatasetRequest/name
  :cognitect.aws.supplychain/DataLakeDatasetName)

(s/def
  :cognitect.aws.supplychain.ListTagsForResourceResponse/tags
  :cognitect.aws.supplychain/TagMap)

(s/def
  :cognitect.aws.supplychain.ListInstancesResponse/instances
  :cognitect.aws.supplychain/InstanceList)

(s/def
  :cognitect.aws.supplychain.ListInstancesResponse/nextToken
  :cognitect.aws.supplychain/InstanceNextToken)

(s/def :cognitect.aws.supplychain.UpdateInstanceRequest/instanceId :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.UpdateInstanceRequest/instanceName
  :cognitect.aws.supplychain/InstanceName)

(s/def
  :cognitect.aws.supplychain.UpdateInstanceRequest/instanceDescription
  :cognitect.aws.supplychain/InstanceDescription)

(s/def
  :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/name
  :cognitect.aws.supplychain/DataIntegrationFlowName)

(s/def
  :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/sources
  :cognitect.aws.supplychain/DataIntegrationFlowSourceList)

(s/def
  :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/transformation
  :cognitect.aws.supplychain/DataIntegrationFlowTransformation)

(s/def
  :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/target
  :cognitect.aws.supplychain/DataIntegrationFlowTarget)

(s/def
  :cognitect.aws.supplychain.CreateDataIntegrationFlowRequest/tags
  :cognitect.aws.supplychain/TagMap)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowS3SourceConfiguration/bucketName
  :cognitect.aws.supplychain/S3BucketName)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowS3SourceConfiguration/prefix
  :cognitect.aws.supplychain/DataIntegrationFlowS3Prefix)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowS3SourceConfiguration/options
  :cognitect.aws.supplychain/DataIntegrationFlowS3Options)

(s/def
  :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/s3uri
  :cognitect.aws.supplychain/ConfigurationS3Uri)

(s/def
  :cognitect.aws.supplychain.CreateBillOfMaterialsImportJobRequest/clientToken
  :cognitect.aws.supplychain/ClientToken)

(s/def
  :cognitect.aws.supplychain.UpdateDataLakeDatasetRequest/instanceId
  :cognitect.aws.supplychain/UUID)

(s/def
  :cognitect.aws.supplychain.UpdateDataLakeDatasetRequest/namespace
  :cognitect.aws.supplychain/DataLakeDatasetNamespace)

(s/def
  :cognitect.aws.supplychain.UpdateDataLakeDatasetRequest/name
  :cognitect.aws.supplychain/DataLakeDatasetName)

(s/def
  :cognitect.aws.supplychain.UpdateDataLakeDatasetRequest/description
  :cognitect.aws.supplychain/DataLakeDatasetDescription)

(s/def
  :cognitect.aws.supplychain.ResourceNotFoundException/message
  :cognitect.aws.supplychain/String)

(s/def :cognitect.aws.supplychain.ConflictException/message :cognitect.aws.supplychain/String)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowSource/sourceType
  :cognitect.aws.supplychain/DataIntegrationFlowSourceType)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowSource/sourceName
  :cognitect.aws.supplychain/DataIntegrationFlowSourceName)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowSource/s3Source
  :cognitect.aws.supplychain/DataIntegrationFlowS3SourceConfiguration)

(s/def
  :cognitect.aws.supplychain.DataIntegrationFlowSource/datasetSource
  :cognitect.aws.supplychain/DataIntegrationFlowDatasetSourceConfiguration)

