;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.waf-regional.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.waf-regional/UpdateRuleGroupResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateRuleGroupResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/CreateRateBasedRuleResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateRateBasedRuleResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateRateBasedRuleResponse/Rule]))

(s/def
  :cognitect.aws.waf-regional/CreateIPSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateIPSetResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateIPSetResponse/IPSet]))

(s/def
  :cognitect.aws.waf-regional/UpdateRegexPatternSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateRegexPatternSetRequest/RegexPatternSetId
     :cognitect.aws.waf-regional.UpdateRegexPatternSetRequest/Updates
     :cognitect.aws.waf-regional.UpdateRegexPatternSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/DeleteSizeConstraintSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteSizeConstraintSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ByteMatchSet
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.ByteMatchSet/ByteMatchSetId
     :cognitect.aws.waf-regional.ByteMatchSet/ByteMatchTuples]
    :opt-un
    [:cognitect.aws.waf-regional.ByteMatchSet/Name]))

(s/def
  :cognitect.aws.waf-regional/SqlInjectionMatchSetSummaries
  (s/coll-of :cognitect.aws.waf-regional/SqlInjectionMatchSetSummary))

(s/def
  :cognitect.aws.waf-regional/GetByteMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetByteMatchSetResponse/ByteMatchSet]))

(s/def
  :cognitect.aws.waf-regional/ListRulesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRulesRequest/Limit
     :cognitect.aws.waf-regional.ListRulesRequest/NextMarker]))

(s/def :cognitect.aws.waf-regional/ResourceType #{"APPLICATION_LOAD_BALANCER" "API_GATEWAY"})

(s/def
  :cognitect.aws.waf-regional/ActivatedRules
  (s/coll-of :cognitect.aws.waf-regional/ActivatedRule))

(s/def
  :cognitect.aws.waf-regional/CreateRateBasedRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateRateBasedRuleRequest/Name
     :cognitect.aws.waf-regional.CreateRateBasedRuleRequest/MetricName
     :cognitect.aws.waf-regional.CreateRateBasedRuleRequest/RateKey
     :cognitect.aws.waf-regional.CreateRateBasedRuleRequest/RateLimit
     :cognitect.aws.waf-regional.CreateRateBasedRuleRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/UpdateXssMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateXssMatchSetRequest/XssMatchSetId
     :cognitect.aws.waf-regional.UpdateXssMatchSetRequest/ChangeToken
     :cognitect.aws.waf-regional.UpdateXssMatchSetRequest/Updates]))

(s/def
  :cognitect.aws.waf-regional/UpdateByteMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateByteMatchSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/UpdateRateBasedRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateRateBasedRuleRequest/RuleId
     :cognitect.aws.waf-regional.UpdateRateBasedRuleRequest/ChangeToken
     :cognitect.aws.waf-regional.UpdateRateBasedRuleRequest/Updates
     :cognitect.aws.waf-regional.UpdateRateBasedRuleRequest/RateLimit]))

(s/def
  :cognitect.aws.waf-regional/UpdateXssMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateXssMatchSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/SampledHTTPRequests
  (s/coll-of :cognitect.aws.waf-regional/SampledHTTPRequest))

(s/def
  :cognitect.aws.waf-regional/ListWebACLsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListWebACLsResponse/WebACLs
     :cognitect.aws.waf-regional.ListWebACLsResponse/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/SampleWeight
  (s/with-gen (s/and int? #(<= 0 %)) #(gen/choose (or 0 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.waf-regional/RegexMatchSetUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RegexMatchSetUpdate/Action
     :cognitect.aws.waf-regional.RegexMatchSetUpdate/RegexMatchTuple]))

(s/def
  :cognitect.aws.waf-regional/GeoMatchSetSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.GeoMatchSetSummary/GeoMatchSetId
     :cognitect.aws.waf-regional.GeoMatchSetSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/SqlInjectionMatchSetSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SqlInjectionMatchSetSummary/SqlInjectionMatchSetId
     :cognitect.aws.waf-regional.SqlInjectionMatchSetSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/RuleGroupUpdates
  (s/coll-of :cognitect.aws.waf-regional/RuleGroupUpdate :min-count 1))

(s/def :cognitect.aws.waf-regional/RuleUpdates (s/coll-of :cognitect.aws.waf-regional/RuleUpdate))

(s/def
  :cognitect.aws.waf-regional/SizeConstraint
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SizeConstraint/FieldToMatch
     :cognitect.aws.waf-regional.SizeConstraint/TextTransformation
     :cognitect.aws.waf-regional.SizeConstraint/ComparisonOperator
     :cognitect.aws.waf-regional.SizeConstraint/Size]))

(s/def
  :cognitect.aws.waf-regional/GetRateBasedRuleManagedKeysRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.GetRateBasedRuleManagedKeysRequest/RuleId]
    :opt-un
    [:cognitect.aws.waf-regional.GetRateBasedRuleManagedKeysRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/RulePriority
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.waf-regional/GetPermissionPolicyRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetPermissionPolicyRequest/ResourceArn]))

(s/def
  :cognitect.aws.waf-regional/GetRuleRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetRuleRequest/RuleId]))

(s/def :cognitect.aws.waf-regional/WafActionType #{"COUNT" "BLOCK" "ALLOW"})

(s/def
  :cognitect.aws.waf-regional/XssMatchTuples
  (s/coll-of :cognitect.aws.waf-regional/XssMatchTuple))

(s/def
  :cognitect.aws.waf-regional/HTTPHeader
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.HTTPHeader/Value :cognitect.aws.waf-regional.HTTPHeader/Name]))

(s/def
  :cognitect.aws.waf-regional/Rule
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.Rule/RuleId :cognitect.aws.waf-regional.Rule/Predicates]
    :opt-un
    [:cognitect.aws.waf-regional.Rule/MetricName :cognitect.aws.waf-regional.Rule/Name]))

(s/def
  :cognitect.aws.waf-regional/UpdateSizeConstraintSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateSizeConstraintSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/DeleteIPSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteIPSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/CreateGeoMatchSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateGeoMatchSetResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateGeoMatchSetResponse/GeoMatchSet]))

(s/def :cognitect.aws.waf-regional/WafOverrideActionType #{"COUNT" "NONE"})

(s/def
  :cognitect.aws.waf-regional/PolicyString
  (s/with-gen
    (s/and string? #(<= 1 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or nil 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.waf-regional/ActivatedRule
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.ActivatedRule/Priority
     :cognitect.aws.waf-regional.ActivatedRule/RuleId]
    :opt-un
    [:cognitect.aws.waf-regional.ActivatedRule/Type
     :cognitect.aws.waf-regional.ActivatedRule/OverrideAction
     :cognitect.aws.waf-regional.ActivatedRule/ExcludedRules
     :cognitect.aws.waf-regional.ActivatedRule/Action]))

(s/def
  :cognitect.aws.waf-regional/PaginationLimit
  (s/with-gen
    (s/and int? #(<= 0 % 100))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 100 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.waf-regional/RegexPatternSetUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RegexPatternSetUpdate/Action
     :cognitect.aws.waf-regional.RegexPatternSetUpdate/RegexPatternString]))

(s/def
  :cognitect.aws.waf-regional/ListActivatedRulesInRuleGroupRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupRequest/Limit
     :cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupRequest/RuleGroupId
     :cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/RegexMatchSetSummaries
  (s/coll-of :cognitect.aws.waf-regional/RegexMatchSetSummary))

(s/def
  :cognitect.aws.waf-regional/UpdateRateBasedRuleResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateRateBasedRuleResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ListGeoMatchSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListGeoMatchSetsRequest/Limit
     :cognitect.aws.waf-regional.ListGeoMatchSetsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/RateBasedRule
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RateBasedRule/RuleId
     :cognitect.aws.waf-regional.RateBasedRule/MatchPredicates
     :cognitect.aws.waf-regional.RateBasedRule/RateKey
     :cognitect.aws.waf-regional.RateBasedRule/RateLimit]
    :opt-un
    [:cognitect.aws.waf-regional.RateBasedRule/MetricName
     :cognitect.aws.waf-regional.RateBasedRule/Name]))

(s/def
  :cognitect.aws.waf-regional/RuleSummaries
  (s/coll-of :cognitect.aws.waf-regional/RuleSummary))

(s/def
  :cognitect.aws.waf-regional/GetSizeConstraintSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetSizeConstraintSetResponse/SizeConstraintSet]))

(s/def
  :cognitect.aws.waf-regional/ExcludedRule
  (s/keys :req-un [:cognitect.aws.waf-regional.ExcludedRule/RuleId]))

(s/def
  :cognitect.aws.waf-regional/ByteMatchSetSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.ByteMatchSetSummary/ByteMatchSetId
     :cognitect.aws.waf-regional.ByteMatchSetSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/RegexPatternSetSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RegexPatternSetSummary/RegexPatternSetId
     :cognitect.aws.waf-regional.RegexPatternSetSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/GetRuleResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetRuleResponse/Rule]))

(s/def
  :cognitect.aws.waf-regional/SizeConstraintSetSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SizeConstraintSetSummary/SizeConstraintSetId
     :cognitect.aws.waf-regional.SizeConstraintSetSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/Size
  (s/with-gen
    (s/and int? #(<= 0 % 21474836480))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 21474836480 Long/MAX_VALUE))))

(s/def :cognitect.aws.waf-regional/MatchFieldData string?)

(s/def
  :cognitect.aws.waf-regional/RuleGroup
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RuleGroup/RuleGroupId]
    :opt-un
    [:cognitect.aws.waf-regional.RuleGroup/MetricName :cognitect.aws.waf-regional.RuleGroup/Name]))

(s/def
  :cognitect.aws.waf-regional/UpdateRegexPatternSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateRegexPatternSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ListRateBasedRulesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRateBasedRulesResponse/NextMarker
     :cognitect.aws.waf-regional.ListRateBasedRulesResponse/Rules]))

(s/def
  :cognitect.aws.waf-regional/Predicate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.Predicate/Negated
     :cognitect.aws.waf-regional.Predicate/Type
     :cognitect.aws.waf-regional.Predicate/DataId]))

(s/def
  :cognitect.aws.waf-regional/RegexMatchSetSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RegexMatchSetSummary/RegexMatchSetId
     :cognitect.aws.waf-regional.RegexMatchSetSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/RegexMatchSet
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.RegexMatchSet/RegexMatchSetId
     :cognitect.aws.waf-regional.RegexMatchSet/RegexMatchTuples
     :cognitect.aws.waf-regional.RegexMatchSet/Name]))

(s/def
  :cognitect.aws.waf-regional/TextTransformation
  #{"HTML_ENTITY_DECODE" "URL_DECODE" "LOWERCASE" "NONE" "COMPRESS_WHITE_SPACE" "CMD_LINE"})

(s/def
  :cognitect.aws.waf-regional/DeleteLoggingConfigurationRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.DeleteLoggingConfigurationRequest/ResourceArn]))

(s/def
  :cognitect.aws.waf-regional/RuleGroupSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RuleGroupSummary/RuleGroupId
     :cognitect.aws.waf-regional.RuleGroupSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/IPSetSummaries
  (s/coll-of :cognitect.aws.waf-regional/IPSetSummary))

(s/def :cognitect.aws.waf-regional/Predicates (s/coll-of :cognitect.aws.waf-regional/Predicate))

(s/def
  :cognitect.aws.waf-regional/PositionalConstraint
  #{"CONTAINS" "EXACTLY" "CONTAINS_WORD" "ENDS_WITH" "STARTS_WITH"})

(s/def
  :cognitect.aws.waf-regional/WafOverrideAction
  (s/keys :req-un [:cognitect.aws.waf-regional.WafOverrideAction/Type]))

(s/def
  :cognitect.aws.waf-regional/SubscribedRuleGroupSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SubscribedRuleGroupSummary/RuleGroupId
     :cognitect.aws.waf-regional.SubscribedRuleGroupSummary/Name
     :cognitect.aws.waf-regional.SubscribedRuleGroupSummary/MetricName]))

(s/def
  :cognitect.aws.waf-regional/GetSizeConstraintSetRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetSizeConstraintSetRequest/SizeConstraintSetId]))

(s/def
  :cognitect.aws.waf-regional/RegexMatchSetUpdates
  (s/coll-of :cognitect.aws.waf-regional/RegexMatchSetUpdate :min-count 1))

(s/def
  :cognitect.aws.waf-regional/SizeConstraintSetUpdates
  (s/coll-of :cognitect.aws.waf-regional/SizeConstraintSetUpdate :min-count 1))

(s/def
  :cognitect.aws.waf-regional/RegexPatternSetSummaries
  (s/coll-of :cognitect.aws.waf-regional/RegexPatternSetSummary))

(s/def
  :cognitect.aws.waf-regional/WebACL
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.WebACL/WebACLId
     :cognitect.aws.waf-regional.WebACL/DefaultAction
     :cognitect.aws.waf-regional.WebACL/Rules]
    :opt-un
    [:cognitect.aws.waf-regional.WebACL/WebACLArn
     :cognitect.aws.waf-regional.WebACL/MetricName
     :cognitect.aws.waf-regional.WebACL/Name]))

(s/def
  :cognitect.aws.waf-regional/ListResourcesForWebACLResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.ListResourcesForWebACLResponse/ResourceArns]))

(s/def
  :cognitect.aws.waf-regional/GetWebACLForResourceRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetWebACLForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.waf-regional/IPSetSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.IPSetSummary/IPSetId
     :cognitect.aws.waf-regional.IPSetSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/UpdateSizeConstraintSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateSizeConstraintSetRequest/SizeConstraintSetId
     :cognitect.aws.waf-regional.UpdateSizeConstraintSetRequest/ChangeToken
     :cognitect.aws.waf-regional.UpdateSizeConstraintSetRequest/Updates]))

(s/def :cognitect.aws.waf-regional/ManagedKeys (s/coll-of :cognitect.aws.waf-regional/ManagedKey))

(s/def
  :cognitect.aws.waf-regional/WebACLUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.WebACLUpdate/Action
     :cognitect.aws.waf-regional.WebACLUpdate/ActivatedRule]))

(s/def
  :cognitect.aws.waf-regional/ByteMatchTuple
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.ByteMatchTuple/FieldToMatch
     :cognitect.aws.waf-regional.ByteMatchTuple/TargetString
     :cognitect.aws.waf-regional.ByteMatchTuple/TextTransformation
     :cognitect.aws.waf-regional.ByteMatchTuple/PositionalConstraint]))

(s/def :cognitect.aws.waf-regional/ResourceArns (s/coll-of :cognitect.aws.waf-regional/ResourceArn))

(s/def
  :cognitect.aws.waf-regional/ResourceId
  (s/with-gen
    (s/and string? #(<= 1 (count %) 128))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 128 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.waf-regional/WebACLUpdates
  (s/coll-of :cognitect.aws.waf-regional/WebACLUpdate))

(s/def
  :cognitect.aws.waf-regional/PutLoggingConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.PutLoggingConfigurationResponse/LoggingConfiguration]))

(s/def
  :cognitect.aws.waf-regional/ListRulesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRulesResponse/NextMarker
     :cognitect.aws.waf-regional.ListRulesResponse/Rules]))

(s/def
  :cognitect.aws.waf-regional/ListRuleGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRuleGroupsRequest/Limit
     :cognitect.aws.waf-regional.ListRuleGroupsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/DeleteIPSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteIPSetRequest/IPSetId
     :cognitect.aws.waf-regional.DeleteIPSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/GetRateBasedRuleManagedKeysResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.GetRateBasedRuleManagedKeysResponse/ManagedKeys
     :cognitect.aws.waf-regional.GetRateBasedRuleManagedKeysResponse/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/IPSetDescriptor
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.IPSetDescriptor/Type
     :cognitect.aws.waf-regional.IPSetDescriptor/Value]))

(s/def
  :cognitect.aws.waf-regional/IPSetDescriptors
  (s/coll-of :cognitect.aws.waf-regional/IPSetDescriptor))

(s/def :cognitect.aws.waf-regional/HeaderValue string?)

(s/def
  :cognitect.aws.waf-regional/RegexPatternSet
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RegexPatternSet/RegexPatternSetId
     :cognitect.aws.waf-regional.RegexPatternSet/RegexPatternStrings]
    :opt-un
    [:cognitect.aws.waf-regional.RegexPatternSet/Name]))

(s/def
  :cognitect.aws.waf-regional/GetChangeTokenStatusRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetChangeTokenStatusRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/DeleteRegexPatternSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteRegexPatternSetRequest/RegexPatternSetId
     :cognitect.aws.waf-regional.DeleteRegexPatternSetRequest/ChangeToken]))

(s/def :cognitect.aws.waf-regional/ChangeTokenStatus #{"INSYNC" "PENDING" "PROVISIONED"})

(s/def
  :cognitect.aws.waf-regional/ListSubscribedRuleGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListSubscribedRuleGroupsRequest/Limit
     :cognitect.aws.waf-regional.ListSubscribedRuleGroupsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/GetRegexPatternSetRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetRegexPatternSetRequest/RegexPatternSetId]))

(s/def
  :cognitect.aws.waf-regional/GeoMatchSet
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.GeoMatchSet/GeoMatchSetId
     :cognitect.aws.waf-regional.GeoMatchSet/GeoMatchConstraints]
    :opt-un
    [:cognitect.aws.waf-regional.GeoMatchSet/Name]))

(s/def
  :cognitect.aws.waf-regional/ListSqlInjectionMatchSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListSqlInjectionMatchSetsRequest/Limit
     :cognitect.aws.waf-regional.ListSqlInjectionMatchSetsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/GeoMatchConstraints
  (s/coll-of :cognitect.aws.waf-regional/GeoMatchConstraint))

(s/def
  :cognitect.aws.waf-regional/ListGeoMatchSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListGeoMatchSetsResponse/NextMarker
     :cognitect.aws.waf-regional.ListGeoMatchSetsResponse/GeoMatchSets]))

(s/def :cognitect.aws.waf-regional/ComparisonOperator #{"NE" "LT" "GE" "LE" "EQ" "GT"})

(s/def
  :cognitect.aws.waf-regional/ListByteMatchSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListByteMatchSetsRequest/Limit
     :cognitect.aws.waf-regional.ListByteMatchSetsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/SampledHTTPRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SampledHTTPRequest/Request
     :cognitect.aws.waf-regional.SampledHTTPRequest/Weight]
    :opt-un
    [:cognitect.aws.waf-regional.SampledHTTPRequest/RuleWithinRuleGroup
     :cognitect.aws.waf-regional.SampledHTTPRequest/Timestamp
     :cognitect.aws.waf-regional.SampledHTTPRequest/Action]))

(s/def
  :cognitect.aws.waf-regional/RegexPatternStrings
  (s/coll-of :cognitect.aws.waf-regional/RegexPatternString :max-count 10))

(s/def
  :cognitect.aws.waf-regional/TimeWindow
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.TimeWindow/StartTime
     :cognitect.aws.waf-regional.TimeWindow/EndTime]))

(s/def
  :cognitect.aws.waf-regional/GetRuleGroupResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetRuleGroupResponse/RuleGroup]))

(s/def
  :cognitect.aws.waf-regional/FieldToMatch
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.FieldToMatch/Type]
    :opt-un
    [:cognitect.aws.waf-regional.FieldToMatch/Data]))

(s/def
  :cognitect.aws.waf-regional/MatchFieldType
  #{"SINGLE_QUERY_ARG" "QUERY_STRING" "METHOD" "HEADER" "URI" "ALL_QUERY_ARGS" "BODY"})

(s/def
  :cognitect.aws.waf-regional/RegexPatternSetUpdates
  (s/coll-of :cognitect.aws.waf-regional/RegexPatternSetUpdate :min-count 1))

(s/def
  :cognitect.aws.waf-regional/GetRateBasedRuleResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetRateBasedRuleResponse/Rule]))

(s/def
  :cognitect.aws.waf-regional/GetGeoMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetGeoMatchSetResponse/GeoMatchSet]))

(s/def
  :cognitect.aws.waf-regional/CreateByteMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateByteMatchSetRequest/Name
     :cognitect.aws.waf-regional.CreateByteMatchSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ListByteMatchSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListByteMatchSetsResponse/ByteMatchSets
     :cognitect.aws.waf-regional.ListByteMatchSetsResponse/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/SqlInjectionMatchSet
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SqlInjectionMatchSet/SqlInjectionMatchSetId
     :cognitect.aws.waf-regional.SqlInjectionMatchSet/SqlInjectionMatchTuples]
    :opt-un
    [:cognitect.aws.waf-regional.SqlInjectionMatchSet/Name]))

(s/def
  :cognitect.aws.waf-regional/CreateXssMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateXssMatchSetRequest/Name
     :cognitect.aws.waf-regional.CreateXssMatchSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/DisassociateWebACLRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.DisassociateWebACLRequest/ResourceArn]))

(s/def :cognitect.aws.waf-regional/IPSetDescriptorType #{"IPV4" "IPV6"})

(s/def :cognitect.aws.waf-regional/DeletePermissionPolicyResponse (s/keys))

(s/def
  :cognitect.aws.waf-regional/ListSqlInjectionMatchSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListSqlInjectionMatchSetsResponse/SqlInjectionMatchSets
     :cognitect.aws.waf-regional.ListSqlInjectionMatchSetsResponse/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/XssMatchTuple
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.XssMatchTuple/FieldToMatch
     :cognitect.aws.waf-regional.XssMatchTuple/TextTransformation]))

(s/def
  :cognitect.aws.waf-regional/CreateSqlInjectionMatchSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateSqlInjectionMatchSetResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateSqlInjectionMatchSetResponse/SqlInjectionMatchSet]))

(s/def
  :cognitect.aws.waf-regional/DeleteByteMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteByteMatchSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/GetPermissionPolicyResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetPermissionPolicyResponse/Policy]))

(s/def
  :cognitect.aws.waf-regional/GetRuleGroupRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetRuleGroupRequest/RuleGroupId]))

(s/def
  :cognitect.aws.waf-regional/CreateSizeConstraintSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateSizeConstraintSetResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateSizeConstraintSetResponse/SizeConstraintSet]))

(s/def
  :cognitect.aws.waf-regional/ListSizeConstraintSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListSizeConstraintSetsRequest/Limit
     :cognitect.aws.waf-regional.ListSizeConstraintSetsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/XssMatchSetUpdates
  (s/coll-of :cognitect.aws.waf-regional/XssMatchSetUpdate :min-count 1))

(s/def
  :cognitect.aws.waf-regional/GeoMatchConstraintValue
  #{"CR" "TG" "TJ" "ZA" "IM" "PE" "LC" "CH" "RU" "MP" "CK" "SI" "AU" "KR" "IT" "FI" "GF" "SC" "SX"
    "TT" "TK" "MY" "SY" "MN" "TF" "KP" "AM" "DZ" "UY" "TD" "DJ" "BI" "MK" "MU" "LI" "NU" "GR" "GY"
    "CG" "NF" "ML" "AX" "GM" "SA" "CX" "BH" "NE" "BN" "MF" "CD" "DK" "BJ" "ME" "SJ" "BO" "JO" "CV"
    "VE" "CI" "UZ" "TN" "IS" "EH" "TM" "GA" "LS" "TZ" "AT" "LT" "NP" "BG" "IL" "GU" "PK" "PT" "HR"
    "VU" "PF" "BM" "MR" "GE" "HU" "TW" "MM" "VG" "YE" "SR" "PN" "VA" "PR" "KW" "SE" "GB" "UM" "VN"
    "CF" "PA" "VC" "JP" "IR" "AF" "LY" "MZ" "RO" "QA" "CM" "GG" "BY" "SD" "BQ" "MO" "KY" "AR" "BR"
    "ZW" "NR" "NZ" "AW" "FJ" "ID" "SV" "CN" "FM" "HT" "CC" "RW" "BA" "TL" "JM" "KM" "KE" "WS" "TO"
    "PY" "SH" "CY" "GH" "MA" "SG" "LK" "PH" "SM" "WF" "TR" "PS" "BZ" "CU" "TV" "AD" "SB" "DM" "LR"
    "OM" "SO" "DO" "AL" "BL" "FR" "GW" "MS" "BB" "CA" "MG" "KH" "LA" "GP" "BV" "HN" "TH" "DE" "LB"
    "KZ" "AS" "EC" "NO" "AO" "FK" "ET" "GS" "MD" "AG" "BE" "MV" "SZ" "CZ" "CL" "BT" "NL" "EG" "MQ"
    "SN" "FO" "EE" "AQ" "ST" "KN" "BW" "MH" "NI" "PG" "VI" "IQ" "KG" "US" "ZM" "MC" "GI" "NC" "GT"
    "BF" "YT" "LU" "UA" "IE" "LV" "GD" "MW" "BS" "AZ" "SK" "GQ" "TC" "RE" "IN" "ES" "GL" "KI" "HK"
    "CO" "SS" "RS" "IO" "NG" "UG" "CW" "SL" "ER" "JE" "AE" "HM" "PM" "BD" "MT" "AI" "GN" "PW" "NA"
    "MX" "PL"})

(s/def
  :cognitect.aws.waf-regional/DeleteRuleGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteRuleGroupRequest/RuleGroupId
     :cognitect.aws.waf-regional.DeleteRuleGroupRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/UpdateRuleResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateRuleResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/UpdateWebACLRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateWebACLRequest/WebACLId
     :cognitect.aws.waf-regional.UpdateWebACLRequest/ChangeToken]
    :opt-un
    [:cognitect.aws.waf-regional.UpdateWebACLRequest/DefaultAction
     :cognitect.aws.waf-regional.UpdateWebACLRequest/Updates]))

(s/def :cognitect.aws.waf-regional/IPString string?)

(s/def
  :cognitect.aws.waf-regional/CreateIPSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateIPSetRequest/Name
     :cognitect.aws.waf-regional.CreateIPSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/GetByteMatchSetRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetByteMatchSetRequest/ByteMatchSetId]))

(s/def
  :cognitect.aws.waf-regional/RuleUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RuleUpdate/Action
     :cognitect.aws.waf-regional.RuleUpdate/Predicate]))

(s/def
  :cognitect.aws.waf-regional/SizeConstraintSetUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SizeConstraintSetUpdate/Action
     :cognitect.aws.waf-regional.SizeConstraintSetUpdate/SizeConstraint]))

(s/def
  :cognitect.aws.waf-regional/CreateRegexMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateRegexMatchSetRequest/Name
     :cognitect.aws.waf-regional.CreateRegexMatchSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ListRegexPatternSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRegexPatternSetsResponse/RegexPatternSets
     :cognitect.aws.waf-regional.ListRegexPatternSetsResponse/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/DeleteRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteRuleRequest/RuleId
     :cognitect.aws.waf-regional.DeleteRuleRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/DeleteGeoMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteGeoMatchSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/UpdateByteMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateByteMatchSetRequest/ByteMatchSetId
     :cognitect.aws.waf-regional.UpdateByteMatchSetRequest/ChangeToken
     :cognitect.aws.waf-regional.UpdateByteMatchSetRequest/Updates]))

(s/def
  :cognitect.aws.waf-regional/GetRegexMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetRegexMatchSetResponse/RegexMatchSet]))

(s/def
  :cognitect.aws.waf-regional/XssMatchSetUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.XssMatchSetUpdate/Action
     :cognitect.aws.waf-regional.XssMatchSetUpdate/XssMatchTuple]))

(s/def
  :cognitect.aws.waf-regional/GetChangeTokenStatusResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetChangeTokenStatusResponse/ChangeTokenStatus]))

(s/def
  :cognitect.aws.waf-regional/DeleteSizeConstraintSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteSizeConstraintSetRequest/SizeConstraintSetId
     :cognitect.aws.waf-regional.DeleteSizeConstraintSetRequest/ChangeToken]))

(s/def :cognitect.aws.waf-regional/HeaderName string?)

(s/def
  :cognitect.aws.waf-regional/RegexMatchTuple
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RegexMatchTuple/FieldToMatch
     :cognitect.aws.waf-regional.RegexMatchTuple/TextTransformation
     :cognitect.aws.waf-regional.RegexMatchTuple/RegexPatternSetId]))

(s/def
  :cognitect.aws.waf-regional/GetRateBasedRuleRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetRateBasedRuleRequest/RuleId]))

(s/def
  :cognitect.aws.waf-regional/ListLoggingConfigurationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListLoggingConfigurationsRequest/Limit
     :cognitect.aws.waf-regional.ListLoggingConfigurationsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/GeoMatchSetSummaries
  (s/coll-of :cognitect.aws.waf-regional/GeoMatchSetSummary))

(s/def
  :cognitect.aws.waf-regional/IPSetUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.IPSetUpdate/Action
     :cognitect.aws.waf-regional.IPSetUpdate/IPSetDescriptor]))

(s/def
  :cognitect.aws.waf-regional/UpdateWebACLResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateWebACLResponse/ChangeToken]))

(s/def :cognitect.aws.waf-regional/DeleteLoggingConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.waf-regional/GetSqlInjectionMatchSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.GetSqlInjectionMatchSetResponse/SqlInjectionMatchSet]))

(s/def
  :cognitect.aws.waf-regional/DeleteWebACLRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteWebACLRequest/WebACLId
     :cognitect.aws.waf-regional.DeleteWebACLRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/GetLoggingConfigurationRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetLoggingConfigurationRequest/ResourceArn]))

(s/def
  :cognitect.aws.waf-regional/CreateWebACLRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateWebACLRequest/Name
     :cognitect.aws.waf-regional.CreateWebACLRequest/MetricName
     :cognitect.aws.waf-regional.CreateWebACLRequest/DefaultAction
     :cognitect.aws.waf-regional.CreateWebACLRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ListActivatedRulesInRuleGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupResponse/ActivatedRules
     :cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupResponse/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/CreateRegexPatternSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateRegexPatternSetResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateRegexPatternSetResponse/RegexPatternSet]))

(s/def
  :cognitect.aws.waf-regional/SqlInjectionMatchSetUpdates
  (s/coll-of :cognitect.aws.waf-regional/SqlInjectionMatchSetUpdate :min-count 1))

(s/def :cognitect.aws.waf-regional/IPSetDescriptorValue string?)

(s/def
  :cognitect.aws.waf-regional/IPSet
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.IPSet/IPSetId :cognitect.aws.waf-regional.IPSet/IPSetDescriptors]
    :opt-un
    [:cognitect.aws.waf-regional.IPSet/Name]))

(s/def
  :cognitect.aws.waf-regional/ListRegexMatchSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRegexMatchSetsResponse/RegexMatchSets
     :cognitect.aws.waf-regional.ListRegexMatchSetsResponse/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/CreateByteMatchSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateByteMatchSetResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateByteMatchSetResponse/ByteMatchSet]))

(s/def
  :cognitect.aws.waf-regional/DeleteXssMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteXssMatchSetRequest/XssMatchSetId
     :cognitect.aws.waf-regional.DeleteXssMatchSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ListRegexPatternSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRegexPatternSetsRequest/Limit
     :cognitect.aws.waf-regional.ListRegexPatternSetsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/GeoMatchConstraint
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.GeoMatchConstraint/Type
     :cognitect.aws.waf-regional.GeoMatchConstraint/Value]))

(s/def
  :cognitect.aws.waf-regional/DeleteXssMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteXssMatchSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/GetXssMatchSetRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetXssMatchSetRequest/XssMatchSetId]))

(s/def
  :cognitect.aws.waf-regional/GetWebACLResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetWebACLResponse/WebACL]))

(s/def
  :cognitect.aws.waf-regional/RuleGroupUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RuleGroupUpdate/Action
     :cognitect.aws.waf-regional.RuleGroupUpdate/ActivatedRule]))

(s/def
  :cognitect.aws.waf-regional/PopulationSize
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.waf-regional/CreateRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateRuleRequest/Name
     :cognitect.aws.waf-regional.CreateRuleRequest/MetricName
     :cognitect.aws.waf-regional.CreateRuleRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/GetRegexMatchSetRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetRegexMatchSetRequest/RegexMatchSetId]))

(s/def
  :cognitect.aws.waf-regional/CreateGeoMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateGeoMatchSetRequest/Name
     :cognitect.aws.waf-regional.CreateGeoMatchSetRequest/ChangeToken]))

(s/def :cognitect.aws.waf-regional/HTTPVersion string?)

(s/def
  :cognitect.aws.waf-regional/GetLoggingConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.GetLoggingConfigurationResponse/LoggingConfiguration]))

(s/def
  :cognitect.aws.waf-regional/RuleSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.RuleSummary/RuleId :cognitect.aws.waf-regional.RuleSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/SizeConstraintSetSummaries
  (s/coll-of :cognitect.aws.waf-regional/SizeConstraintSetSummary))

(s/def
  :cognitect.aws.waf-regional/DeleteWebACLResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteWebACLResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/SqlInjectionMatchSetUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SqlInjectionMatchSetUpdate/Action
     :cognitect.aws.waf-regional.SqlInjectionMatchSetUpdate/SqlInjectionMatchTuple]))

(s/def
  :cognitect.aws.waf-regional/GetGeoMatchSetRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetGeoMatchSetRequest/GeoMatchSetId]))

(s/def :cognitect.aws.waf-regional/ManagedKey string?)

(s/def
  :cognitect.aws.waf-regional/ByteMatchSetUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.ByteMatchSetUpdate/Action
     :cognitect.aws.waf-regional.ByteMatchSetUpdate/ByteMatchTuple]))

(s/def
  :cognitect.aws.waf-regional/CreateRuleGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateRuleGroupResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateRuleGroupResponse/RuleGroup]))

(s/def
  :cognitect.aws.waf-regional/CreateWebACLResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateWebACLResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateWebACLResponse/WebACL]))

(s/def
  :cognitect.aws.waf-regional/GetWebACLRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetWebACLRequest/WebACLId]))

(s/def
  :cognitect.aws.waf-regional/SubscribedRuleGroupSummaries
  (s/coll-of :cognitect.aws.waf-regional/SubscribedRuleGroupSummary))

(s/def :cognitect.aws.waf-regional/HTTPMethod string?)

(s/def :cognitect.aws.waf-regional/GeoMatchConstraintType #{"Country"})

(s/def
  :cognitect.aws.waf-regional/UpdateSqlInjectionMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateSqlInjectionMatchSetRequest/SqlInjectionMatchSetId
     :cognitect.aws.waf-regional.UpdateSqlInjectionMatchSetRequest/ChangeToken
     :cognitect.aws.waf-regional.UpdateSqlInjectionMatchSetRequest/Updates]))

(s/def
  :cognitect.aws.waf-regional/GetWebACLForResourceResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetWebACLForResourceResponse/WebACLSummary]))

(s/def
  :cognitect.aws.waf-regional/GetRegexPatternSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetRegexPatternSetResponse/RegexPatternSet]))

(s/def :cognitect.aws.waf-regional/Action string?)

(s/def
  :cognitect.aws.waf-regional/AssociateWebACLRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.AssociateWebACLRequest/WebACLId
     :cognitect.aws.waf-regional.AssociateWebACLRequest/ResourceArn]))

(s/def
  :cognitect.aws.waf-regional/ListRegexMatchSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRegexMatchSetsRequest/Limit
     :cognitect.aws.waf-regional.ListRegexMatchSetsRequest/NextMarker]))

(s/def :cognitect.aws.waf-regional/RateKey #{"IP"})

(s/def
  :cognitect.aws.waf-regional/CreateRegexMatchSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateRegexMatchSetResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateRegexMatchSetResponse/RegexMatchSet]))

(s/def
  :cognitect.aws.waf-regional/UpdateRegexMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateRegexMatchSetRequest/RegexMatchSetId
     :cognitect.aws.waf-regional.UpdateRegexMatchSetRequest/Updates
     :cognitect.aws.waf-regional.UpdateRegexMatchSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/LoggingConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.LoggingConfiguration/ResourceArn
     :cognitect.aws.waf-regional.LoggingConfiguration/LogDestinationConfigs]
    :opt-un
    [:cognitect.aws.waf-regional.LoggingConfiguration/RedactedFields]))

(s/def
  :cognitect.aws.waf-regional/NextMarker
  (s/with-gen
    (s/and string? #(<= 1 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or nil 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.waf-regional/DisassociateWebACLResponse (s/keys))

(s/def
  :cognitect.aws.waf-regional/ListRuleGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRuleGroupsResponse/NextMarker
     :cognitect.aws.waf-regional.ListRuleGroupsResponse/RuleGroups]))

(s/def
  :cognitect.aws.waf-regional/DeleteRuleResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteRuleResponse/ChangeToken]))

(s/def :cognitect.aws.waf-regional/AssociateWebACLResponse (s/keys))

(s/def
  :cognitect.aws.waf-regional/UpdateRuleGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateRuleGroupRequest/RuleGroupId
     :cognitect.aws.waf-regional.UpdateRuleGroupRequest/Updates
     :cognitect.aws.waf-regional.UpdateRuleGroupRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/GeoMatchSetUpdates
  (s/coll-of :cognitect.aws.waf-regional/GeoMatchSetUpdate :min-count 1))

(s/def
  :cognitect.aws.waf-regional/DeleteRateBasedRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteRateBasedRuleRequest/RuleId
     :cognitect.aws.waf-regional.DeleteRateBasedRuleRequest/ChangeToken]))

(s/def :cognitect.aws.waf-regional/Negated boolean?)

(s/def
  :cognitect.aws.waf-regional/DeleteSqlInjectionMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteSqlInjectionMatchSetRequest/SqlInjectionMatchSetId
     :cognitect.aws.waf-regional.DeleteSqlInjectionMatchSetRequest/ChangeToken]))

(s/def :cognitect.aws.waf-regional/PutPermissionPolicyResponse (s/keys))

(s/def
  :cognitect.aws.waf-regional/ListResourcesForWebACLRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.ListResourcesForWebACLRequest/WebACLId]
    :opt-un
    [:cognitect.aws.waf-regional.ListResourcesForWebACLRequest/ResourceType]))

(s/def
  :cognitect.aws.waf-regional/GetSampledRequestsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.GetSampledRequestsResponse/TimeWindow
     :cognitect.aws.waf-regional.GetSampledRequestsResponse/PopulationSize
     :cognitect.aws.waf-regional.GetSampledRequestsResponse/SampledRequests]))

(s/def
  :cognitect.aws.waf-regional/CreateSizeConstraintSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateSizeConstraintSetRequest/Name
     :cognitect.aws.waf-regional.CreateSizeConstraintSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/CreateRegexPatternSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateRegexPatternSetRequest/Name
     :cognitect.aws.waf-regional.CreateRegexPatternSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/GetSampledRequestsRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.GetSampledRequestsRequest/WebAclId
     :cognitect.aws.waf-regional.GetSampledRequestsRequest/RuleId
     :cognitect.aws.waf-regional.GetSampledRequestsRequest/TimeWindow
     :cognitect.aws.waf-regional.GetSampledRequestsRequest/MaxItems]))

(s/def
  :cognitect.aws.waf-regional/XssMatchSetSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.XssMatchSetSummary/XssMatchSetId
     :cognitect.aws.waf-regional.XssMatchSetSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/WafAction
  (s/keys :req-un [:cognitect.aws.waf-regional.WafAction/Type]))

(s/def
  :cognitect.aws.waf-regional/DeleteSqlInjectionMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteSqlInjectionMatchSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/LogDestinationConfigs
  (s/coll-of :cognitect.aws.waf-regional/ResourceArn :min-count 1 :max-count 1))

(s/def
  :cognitect.aws.waf-regional/DeleteRegexMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteRegexMatchSetRequest/RegexMatchSetId
     :cognitect.aws.waf-regional.DeleteRegexMatchSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ListRateBasedRulesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListRateBasedRulesRequest/Limit
     :cognitect.aws.waf-regional.ListRateBasedRulesRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/XssMatchSetSummaries
  (s/coll-of :cognitect.aws.waf-regional/XssMatchSetSummary))

(s/def
  :cognitect.aws.waf-regional/HTTPRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.HTTPRequest/Country
     :cognitect.aws.waf-regional.HTTPRequest/HTTPVersion
     :cognitect.aws.waf-regional.HTTPRequest/Method
     :cognitect.aws.waf-regional.HTTPRequest/ClientIP
     :cognitect.aws.waf-regional.HTTPRequest/URI
     :cognitect.aws.waf-regional.HTTPRequest/Headers]))

(s/def :cognitect.aws.waf-regional/Timestamp inst?)

(s/def :cognitect.aws.waf-regional/WafRuleType #{"REGULAR" "RATE_BASED" "GROUP"})

(s/def
  :cognitect.aws.waf-regional/UpdateIPSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateIPSetRequest/IPSetId
     :cognitect.aws.waf-regional.UpdateIPSetRequest/ChangeToken
     :cognitect.aws.waf-regional.UpdateIPSetRequest/Updates]))

(s/def :cognitect.aws.waf-regional/ChangeAction #{"DELETE" "INSERT"})

(s/def
  :cognitect.aws.waf-regional/SqlInjectionMatchTuples
  (s/coll-of :cognitect.aws.waf-regional/SqlInjectionMatchTuple))

(s/def :cognitect.aws.waf-regional/Country string?)

(s/def
  :cognitect.aws.waf-regional/GetIPSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetIPSetResponse/IPSet]))

(s/def
  :cognitect.aws.waf-regional/ResourceArn
  (s/with-gen
    (s/and string? #(<= 1 (count %) 1224))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 1224 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.waf-regional/UpdateRuleRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateRuleRequest/RuleId
     :cognitect.aws.waf-regional.UpdateRuleRequest/ChangeToken
     :cognitect.aws.waf-regional.UpdateRuleRequest/Updates]))

(s/def
  :cognitect.aws.waf-regional/PutLoggingConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.PutLoggingConfigurationRequest/LoggingConfiguration]))

(s/def
  :cognitect.aws.waf-regional/DeleteRegexMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteRegexMatchSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/RedactedFields
  (s/coll-of :cognitect.aws.waf-regional/FieldToMatch))

(s/def
  :cognitect.aws.waf-regional/UpdateGeoMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.UpdateGeoMatchSetRequest/GeoMatchSetId
     :cognitect.aws.waf-regional.UpdateGeoMatchSetRequest/ChangeToken
     :cognitect.aws.waf-regional.UpdateGeoMatchSetRequest/Updates]))

(s/def
  :cognitect.aws.waf-regional/PredicateType
  #{"SizeConstraint" "XssMatch" "GeoMatch" "SqlInjectionMatch" "ByteMatch" "RegexMatch" "IPMatch"})

(s/def
  :cognitect.aws.waf-regional/WebACLSummary
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.WebACLSummary/WebACLId
     :cognitect.aws.waf-regional.WebACLSummary/Name]))

(s/def
  :cognitect.aws.waf-regional/ChangeToken
  (s/with-gen
    (s/and string? #(<= 1 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or nil 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.waf-regional/CreateSqlInjectionMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateSqlInjectionMatchSetRequest/Name
     :cognitect.aws.waf-regional.CreateSqlInjectionMatchSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/UpdateGeoMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateGeoMatchSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ByteMatchSetSummaries
  (s/coll-of :cognitect.aws.waf-regional/ByteMatchSetSummary))

(s/def
  :cognitect.aws.waf-regional/XssMatchSet
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.XssMatchSet/XssMatchSetId
     :cognitect.aws.waf-regional.XssMatchSet/XssMatchTuples]
    :opt-un
    [:cognitect.aws.waf-regional.XssMatchSet/Name]))

(s/def
  :cognitect.aws.waf-regional/ListIPSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListIPSetsRequest/Limit
     :cognitect.aws.waf-regional.ListIPSetsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/DeleteRuleGroupResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteRuleGroupResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/SizeConstraintSet
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SizeConstraintSet/SizeConstraintSetId
     :cognitect.aws.waf-regional.SizeConstraintSet/SizeConstraints]
    :opt-un
    [:cognitect.aws.waf-regional.SizeConstraintSet/Name]))

(s/def
  :cognitect.aws.waf-regional/DeletePermissionPolicyRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.DeletePermissionPolicyRequest/ResourceArn]))

(s/def
  :cognitect.aws.waf-regional/RegexPatternString
  (s/with-gen
    (s/and string? #(<= 1 (count %)))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or nil 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.waf-regional/GetChangeTokenRequest (s/keys))

(s/def
  :cognitect.aws.waf-regional/CreateRuleResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateRuleResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateRuleResponse/Rule]))

(s/def
  :cognitect.aws.waf-regional/UpdateRegexMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateRegexMatchSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ListXssMatchSetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListXssMatchSetsRequest/Limit
     :cognitect.aws.waf-regional.ListXssMatchSetsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/CreateRuleGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.CreateRuleGroupRequest/Name
     :cognitect.aws.waf-regional.CreateRuleGroupRequest/MetricName
     :cognitect.aws.waf-regional.CreateRuleGroupRequest/ChangeToken]))

(s/def :cognitect.aws.waf-regional/HTTPHeaders (s/coll-of :cognitect.aws.waf-regional/HTTPHeader))

(s/def
  :cognitect.aws.waf-regional/SqlInjectionMatchTuple
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.SqlInjectionMatchTuple/FieldToMatch
     :cognitect.aws.waf-regional.SqlInjectionMatchTuple/TextTransformation]))

(s/def
  :cognitect.aws.waf-regional/UpdateSqlInjectionMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateSqlInjectionMatchSetResponse/ChangeToken]))

(s/def :cognitect.aws.waf-regional/MetricName string?)

(s/def
  :cognitect.aws.waf-regional/ByteMatchTuples
  (s/coll-of :cognitect.aws.waf-regional/ByteMatchTuple))

(s/def
  :cognitect.aws.waf-regional/ListWebACLsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListWebACLsRequest/Limit
     :cognitect.aws.waf-regional.ListWebACLsRequest/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/LoggingConfigurations
  (s/coll-of :cognitect.aws.waf-regional/LoggingConfiguration))

(s/def
  :cognitect.aws.waf-regional/SizeConstraints
  (s/coll-of :cognitect.aws.waf-regional/SizeConstraint))

(s/def
  :cognitect.aws.waf-regional/GetChangeTokenResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetChangeTokenResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/RateLimit
  (s/with-gen
    (s/and int? #(<= 2000 % 2000000000))
    #(gen/choose (or 2000 Long/MIN_VALUE) (or 2000000000 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.waf-regional/CreateXssMatchSetResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.CreateXssMatchSetResponse/ChangeToken
     :cognitect.aws.waf-regional.CreateXssMatchSetResponse/XssMatchSet]))

(s/def
  :cognitect.aws.waf-regional/ListSubscribedRuleGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListSubscribedRuleGroupsResponse/NextMarker
     :cognitect.aws.waf-regional.ListSubscribedRuleGroupsResponse/RuleGroups]))

(s/def
  :cognitect.aws.waf-regional/ResourceName
  (s/with-gen
    (s/and string? #(<= 1 (count %) 128))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 128 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.waf-regional/RuleGroupSummaries
  (s/coll-of :cognitect.aws.waf-regional/RuleGroupSummary))

(s/def
  :cognitect.aws.waf-regional/GetIPSetRequest
  (s/keys :req-un [:cognitect.aws.waf-regional.GetIPSetRequest/IPSetId]))

(s/def
  :cognitect.aws.waf-regional/GetSampledRequestsMaxItems
  (s/with-gen
    (s/and int? #(<= 1 % 500))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 500 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.waf-regional/ListSizeConstraintSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListSizeConstraintSetsResponse/SizeConstraintSets
     :cognitect.aws.waf-regional.ListSizeConstraintSetsResponse/NextMarker]))

(s/def :cognitect.aws.waf-regional/URIString string?)

(s/def
  :cognitect.aws.waf-regional/ByteMatchSetUpdates
  (s/coll-of :cognitect.aws.waf-regional/ByteMatchSetUpdate :min-count 1))

(s/def
  :cognitect.aws.waf-regional/ListIPSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListIPSetsResponse/NextMarker
     :cognitect.aws.waf-regional.ListIPSetsResponse/IPSets]))

(s/def
  :cognitect.aws.waf-regional/WebACLSummaries
  (s/coll-of :cognitect.aws.waf-regional/WebACLSummary))

(s/def
  :cognitect.aws.waf-regional/GetSqlInjectionMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.GetSqlInjectionMatchSetRequest/SqlInjectionMatchSetId]))

(s/def
  :cognitect.aws.waf-regional/DeleteRegexPatternSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteRegexPatternSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/IPSetUpdates
  (s/coll-of :cognitect.aws.waf-regional/IPSetUpdate :min-count 1))

(s/def
  :cognitect.aws.waf-regional/DeleteGeoMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteGeoMatchSetRequest/GeoMatchSetId
     :cognitect.aws.waf-regional.DeleteGeoMatchSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/GeoMatchSetUpdate
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.GeoMatchSetUpdate/Action
     :cognitect.aws.waf-regional.GeoMatchSetUpdate/GeoMatchConstraint]))

(s/def
  :cognitect.aws.waf-regional/DeleteByteMatchSetRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.DeleteByteMatchSetRequest/ByteMatchSetId
     :cognitect.aws.waf-regional.DeleteByteMatchSetRequest/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/RegexMatchTuples
  (s/coll-of :cognitect.aws.waf-regional/RegexMatchTuple))

(s/def
  :cognitect.aws.waf-regional/ListXssMatchSetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListXssMatchSetsResponse/XssMatchSets
     :cognitect.aws.waf-regional.ListXssMatchSetsResponse/NextMarker]))

(s/def
  :cognitect.aws.waf-regional/DeleteRateBasedRuleResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.DeleteRateBasedRuleResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/PutPermissionPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.waf-regional.PutPermissionPolicyRequest/ResourceArn
     :cognitect.aws.waf-regional.PutPermissionPolicyRequest/Policy]))

(s/def
  :cognitect.aws.waf-regional/ListLoggingConfigurationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.waf-regional.ListLoggingConfigurationsResponse/NextMarker
     :cognitect.aws.waf-regional.ListLoggingConfigurationsResponse/LoggingConfigurations]))

(s/def
  :cognitect.aws.waf-regional/GetXssMatchSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.GetXssMatchSetResponse/XssMatchSet]))

(s/def
  :cognitect.aws.waf-regional/ExcludedRules
  (s/coll-of :cognitect.aws.waf-regional/ExcludedRule))

(s/def
  :cognitect.aws.waf-regional/UpdateIPSetResponse
  (s/keys :opt-un [:cognitect.aws.waf-regional.UpdateIPSetResponse/ChangeToken]))

(s/def
  :cognitect.aws.waf-regional/ByteMatchTargetString
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.waf-regional.UpdateRuleGroupResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.CreateRateBasedRuleResponse/Rule
  :cognitect.aws.waf-regional/RateBasedRule)

(s/def
  :cognitect.aws.waf-regional.CreateRateBasedRuleResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def :cognitect.aws.waf-regional.CreateIPSetResponse/IPSet :cognitect.aws.waf-regional/IPSet)

(s/def
  :cognitect.aws.waf-regional.CreateIPSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateRegexPatternSetRequest/RegexPatternSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateRegexPatternSetRequest/Updates
  :cognitect.aws.waf-regional/RegexPatternSetUpdates)

(s/def
  :cognitect.aws.waf-regional.UpdateRegexPatternSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteSizeConstraintSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ByteMatchSet/ByteMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.ByteMatchSet/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.ByteMatchSet/ByteMatchTuples
  :cognitect.aws.waf-regional/ByteMatchTuples)

(s/def
  :cognitect.aws.waf-regional.GetByteMatchSetResponse/ByteMatchSet
  :cognitect.aws.waf-regional/ByteMatchSet)

(s/def
  :cognitect.aws.waf-regional.ListRulesRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRulesRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.CreateRateBasedRuleRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateRateBasedRuleRequest/MetricName
  :cognitect.aws.waf-regional/MetricName)

(s/def
  :cognitect.aws.waf-regional.CreateRateBasedRuleRequest/RateKey
  :cognitect.aws.waf-regional/RateKey)

(s/def
  :cognitect.aws.waf-regional.CreateRateBasedRuleRequest/RateLimit
  :cognitect.aws.waf-regional/RateLimit)

(s/def
  :cognitect.aws.waf-regional.CreateRateBasedRuleRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateXssMatchSetRequest/XssMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateXssMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateXssMatchSetRequest/Updates
  :cognitect.aws.waf-regional/XssMatchSetUpdates)

(s/def
  :cognitect.aws.waf-regional.UpdateByteMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateRateBasedRuleRequest/RuleId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateRateBasedRuleRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateRateBasedRuleRequest/Updates
  :cognitect.aws.waf-regional/RuleUpdates)

(s/def
  :cognitect.aws.waf-regional.UpdateRateBasedRuleRequest/RateLimit
  :cognitect.aws.waf-regional/RateLimit)

(s/def
  :cognitect.aws.waf-regional.UpdateXssMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListWebACLsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListWebACLsResponse/WebACLs
  :cognitect.aws.waf-regional/WebACLSummaries)

(s/def
  :cognitect.aws.waf-regional.RegexMatchSetUpdate/Action
  :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.RegexMatchSetUpdate/RegexMatchTuple
  :cognitect.aws.waf-regional/RegexMatchTuple)

(s/def
  :cognitect.aws.waf-regional.GeoMatchSetSummary/GeoMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.GeoMatchSetSummary/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.SqlInjectionMatchSetSummary/SqlInjectionMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.SqlInjectionMatchSetSummary/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.SizeConstraint/FieldToMatch
  :cognitect.aws.waf-regional/FieldToMatch)

(s/def
  :cognitect.aws.waf-regional.SizeConstraint/TextTransformation
  :cognitect.aws.waf-regional/TextTransformation)

(s/def
  :cognitect.aws.waf-regional.SizeConstraint/ComparisonOperator
  :cognitect.aws.waf-regional/ComparisonOperator)

(s/def :cognitect.aws.waf-regional.SizeConstraint/Size :cognitect.aws.waf-regional/Size)

(s/def
  :cognitect.aws.waf-regional.GetRateBasedRuleManagedKeysRequest/RuleId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.GetRateBasedRuleManagedKeysRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.GetPermissionPolicyRequest/ResourceArn
  :cognitect.aws.waf-regional/ResourceArn)

(s/def :cognitect.aws.waf-regional.GetRuleRequest/RuleId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.HTTPHeader/Name :cognitect.aws.waf-regional/HeaderName)

(s/def :cognitect.aws.waf-regional.HTTPHeader/Value :cognitect.aws.waf-regional/HeaderValue)

(s/def :cognitect.aws.waf-regional.Rule/RuleId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.Rule/Name :cognitect.aws.waf-regional/ResourceName)

(s/def :cognitect.aws.waf-regional.Rule/MetricName :cognitect.aws.waf-regional/MetricName)

(s/def :cognitect.aws.waf-regional.Rule/Predicates :cognitect.aws.waf-regional/Predicates)

(s/def
  :cognitect.aws.waf-regional.UpdateSizeConstraintSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteIPSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.CreateGeoMatchSetResponse/GeoMatchSet
  :cognitect.aws.waf-regional/GeoMatchSet)

(s/def
  :cognitect.aws.waf-regional.CreateGeoMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def :cognitect.aws.waf-regional.ActivatedRule/Priority :cognitect.aws.waf-regional/RulePriority)

(s/def :cognitect.aws.waf-regional.ActivatedRule/RuleId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.ActivatedRule/Action :cognitect.aws.waf-regional/WafAction)

(s/def
  :cognitect.aws.waf-regional.ActivatedRule/OverrideAction
  :cognitect.aws.waf-regional/WafOverrideAction)

(s/def :cognitect.aws.waf-regional.ActivatedRule/Type :cognitect.aws.waf-regional/WafRuleType)

(s/def
  :cognitect.aws.waf-regional.ActivatedRule/ExcludedRules
  :cognitect.aws.waf-regional/ExcludedRules)

(s/def
  :cognitect.aws.waf-regional.RegexPatternSetUpdate/Action
  :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.RegexPatternSetUpdate/RegexPatternString
  :cognitect.aws.waf-regional/RegexPatternString)

(s/def
  :cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupRequest/RuleGroupId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.UpdateRateBasedRuleResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListGeoMatchSetsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListGeoMatchSetsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def :cognitect.aws.waf-regional.RateBasedRule/RuleId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.RateBasedRule/Name :cognitect.aws.waf-regional/ResourceName)

(s/def :cognitect.aws.waf-regional.RateBasedRule/MetricName :cognitect.aws.waf-regional/MetricName)

(s/def
  :cognitect.aws.waf-regional.RateBasedRule/MatchPredicates
  :cognitect.aws.waf-regional/Predicates)

(s/def :cognitect.aws.waf-regional.RateBasedRule/RateKey :cognitect.aws.waf-regional/RateKey)

(s/def :cognitect.aws.waf-regional.RateBasedRule/RateLimit :cognitect.aws.waf-regional/RateLimit)

(s/def
  :cognitect.aws.waf-regional.GetSizeConstraintSetResponse/SizeConstraintSet
  :cognitect.aws.waf-regional/SizeConstraintSet)

(s/def :cognitect.aws.waf-regional.ExcludedRule/RuleId :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.ByteMatchSetSummary/ByteMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.ByteMatchSetSummary/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.RegexPatternSetSummary/RegexPatternSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.RegexPatternSetSummary/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def :cognitect.aws.waf-regional.GetRuleResponse/Rule :cognitect.aws.waf-regional/Rule)

(s/def
  :cognitect.aws.waf-regional.SizeConstraintSetSummary/SizeConstraintSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.SizeConstraintSetSummary/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def :cognitect.aws.waf-regional.RuleGroup/RuleGroupId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.RuleGroup/Name :cognitect.aws.waf-regional/ResourceName)

(s/def :cognitect.aws.waf-regional.RuleGroup/MetricName :cognitect.aws.waf-regional/MetricName)

(s/def
  :cognitect.aws.waf-regional.UpdateRegexPatternSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListRateBasedRulesResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRateBasedRulesResponse/Rules
  :cognitect.aws.waf-regional/RuleSummaries)

(s/def :cognitect.aws.waf-regional.Predicate/Negated :cognitect.aws.waf-regional/Negated)

(s/def :cognitect.aws.waf-regional.Predicate/Type :cognitect.aws.waf-regional/PredicateType)

(s/def :cognitect.aws.waf-regional.Predicate/DataId :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.RegexMatchSetSummary/RegexMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.RegexMatchSetSummary/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.RegexMatchSet/RegexMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.RegexMatchSet/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.RegexMatchSet/RegexMatchTuples
  :cognitect.aws.waf-regional/RegexMatchTuples)

(s/def
  :cognitect.aws.waf-regional.DeleteLoggingConfigurationRequest/ResourceArn
  :cognitect.aws.waf-regional/ResourceArn)

(s/def
  :cognitect.aws.waf-regional.RuleGroupSummary/RuleGroupId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.RuleGroupSummary/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.WafOverrideAction/Type
  :cognitect.aws.waf-regional/WafOverrideActionType)

(s/def
  :cognitect.aws.waf-regional.SubscribedRuleGroupSummary/RuleGroupId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.SubscribedRuleGroupSummary/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.SubscribedRuleGroupSummary/MetricName
  :cognitect.aws.waf-regional/MetricName)

(s/def
  :cognitect.aws.waf-regional.GetSizeConstraintSetRequest/SizeConstraintSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.WebACL/WebACLId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.WebACL/Name :cognitect.aws.waf-regional/ResourceName)

(s/def :cognitect.aws.waf-regional.WebACL/MetricName :cognitect.aws.waf-regional/MetricName)

(s/def :cognitect.aws.waf-regional.WebACL/DefaultAction :cognitect.aws.waf-regional/WafAction)

(s/def :cognitect.aws.waf-regional.WebACL/Rules :cognitect.aws.waf-regional/ActivatedRules)

(s/def :cognitect.aws.waf-regional.WebACL/WebACLArn :cognitect.aws.waf-regional/ResourceArn)

(s/def
  :cognitect.aws.waf-regional.ListResourcesForWebACLResponse/ResourceArns
  :cognitect.aws.waf-regional/ResourceArns)

(s/def
  :cognitect.aws.waf-regional.GetWebACLForResourceRequest/ResourceArn
  :cognitect.aws.waf-regional/ResourceArn)

(s/def :cognitect.aws.waf-regional.IPSetSummary/IPSetId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.IPSetSummary/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.UpdateSizeConstraintSetRequest/SizeConstraintSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateSizeConstraintSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateSizeConstraintSetRequest/Updates
  :cognitect.aws.waf-regional/SizeConstraintSetUpdates)

(s/def :cognitect.aws.waf-regional.WebACLUpdate/Action :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.WebACLUpdate/ActivatedRule
  :cognitect.aws.waf-regional/ActivatedRule)

(s/def
  :cognitect.aws.waf-regional.ByteMatchTuple/FieldToMatch
  :cognitect.aws.waf-regional/FieldToMatch)

(s/def
  :cognitect.aws.waf-regional.ByteMatchTuple/TargetString
  :cognitect.aws.waf-regional/ByteMatchTargetString)

(s/def
  :cognitect.aws.waf-regional.ByteMatchTuple/TextTransformation
  :cognitect.aws.waf-regional/TextTransformation)

(s/def
  :cognitect.aws.waf-regional.ByteMatchTuple/PositionalConstraint
  :cognitect.aws.waf-regional/PositionalConstraint)

(s/def
  :cognitect.aws.waf-regional.PutLoggingConfigurationResponse/LoggingConfiguration
  :cognitect.aws.waf-regional/LoggingConfiguration)

(s/def
  :cognitect.aws.waf-regional.ListRulesResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRulesResponse/Rules
  :cognitect.aws.waf-regional/RuleSummaries)

(s/def
  :cognitect.aws.waf-regional.ListRuleGroupsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRuleGroupsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.DeleteIPSetRequest/IPSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteIPSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GetRateBasedRuleManagedKeysResponse/ManagedKeys
  :cognitect.aws.waf-regional/ManagedKeys)

(s/def
  :cognitect.aws.waf-regional.GetRateBasedRuleManagedKeysResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.IPSetDescriptor/Type
  :cognitect.aws.waf-regional/IPSetDescriptorType)

(s/def
  :cognitect.aws.waf-regional.IPSetDescriptor/Value
  :cognitect.aws.waf-regional/IPSetDescriptorValue)

(s/def
  :cognitect.aws.waf-regional.RegexPatternSet/RegexPatternSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.RegexPatternSet/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.RegexPatternSet/RegexPatternStrings
  :cognitect.aws.waf-regional/RegexPatternStrings)

(s/def
  :cognitect.aws.waf-regional.GetChangeTokenStatusRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteRegexPatternSetRequest/RegexPatternSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteRegexPatternSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListSubscribedRuleGroupsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListSubscribedRuleGroupsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.GetRegexPatternSetRequest/RegexPatternSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.GeoMatchSet/GeoMatchSetId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.GeoMatchSet/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.GeoMatchSet/GeoMatchConstraints
  :cognitect.aws.waf-regional/GeoMatchConstraints)

(s/def
  :cognitect.aws.waf-regional.ListSqlInjectionMatchSetsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListSqlInjectionMatchSetsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.ListGeoMatchSetsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListGeoMatchSetsResponse/GeoMatchSets
  :cognitect.aws.waf-regional/GeoMatchSetSummaries)

(s/def
  :cognitect.aws.waf-regional.ListByteMatchSetsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListByteMatchSetsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.SampledHTTPRequest/Request
  :cognitect.aws.waf-regional/HTTPRequest)

(s/def
  :cognitect.aws.waf-regional.SampledHTTPRequest/Weight
  :cognitect.aws.waf-regional/SampleWeight)

(s/def
  :cognitect.aws.waf-regional.SampledHTTPRequest/Timestamp
  :cognitect.aws.waf-regional/Timestamp)

(s/def :cognitect.aws.waf-regional.SampledHTTPRequest/Action :cognitect.aws.waf-regional/Action)

(s/def
  :cognitect.aws.waf-regional.SampledHTTPRequest/RuleWithinRuleGroup
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.TimeWindow/StartTime :cognitect.aws.waf-regional/Timestamp)

(s/def :cognitect.aws.waf-regional.TimeWindow/EndTime :cognitect.aws.waf-regional/Timestamp)

(s/def
  :cognitect.aws.waf-regional.GetRuleGroupResponse/RuleGroup
  :cognitect.aws.waf-regional/RuleGroup)

(s/def :cognitect.aws.waf-regional.FieldToMatch/Type :cognitect.aws.waf-regional/MatchFieldType)

(s/def :cognitect.aws.waf-regional.FieldToMatch/Data :cognitect.aws.waf-regional/MatchFieldData)

(s/def
  :cognitect.aws.waf-regional.GetRateBasedRuleResponse/Rule
  :cognitect.aws.waf-regional/RateBasedRule)

(s/def
  :cognitect.aws.waf-regional.GetGeoMatchSetResponse/GeoMatchSet
  :cognitect.aws.waf-regional/GeoMatchSet)

(s/def
  :cognitect.aws.waf-regional.CreateByteMatchSetRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateByteMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListByteMatchSetsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListByteMatchSetsResponse/ByteMatchSets
  :cognitect.aws.waf-regional/ByteMatchSetSummaries)

(s/def
  :cognitect.aws.waf-regional.SqlInjectionMatchSet/SqlInjectionMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.SqlInjectionMatchSet/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.SqlInjectionMatchSet/SqlInjectionMatchTuples
  :cognitect.aws.waf-regional/SqlInjectionMatchTuples)

(s/def
  :cognitect.aws.waf-regional.CreateXssMatchSetRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateXssMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DisassociateWebACLRequest/ResourceArn
  :cognitect.aws.waf-regional/ResourceArn)

(s/def
  :cognitect.aws.waf-regional.ListSqlInjectionMatchSetsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListSqlInjectionMatchSetsResponse/SqlInjectionMatchSets
  :cognitect.aws.waf-regional/SqlInjectionMatchSetSummaries)

(s/def
  :cognitect.aws.waf-regional.XssMatchTuple/FieldToMatch
  :cognitect.aws.waf-regional/FieldToMatch)

(s/def
  :cognitect.aws.waf-regional.XssMatchTuple/TextTransformation
  :cognitect.aws.waf-regional/TextTransformation)

(s/def
  :cognitect.aws.waf-regional.CreateSqlInjectionMatchSetResponse/SqlInjectionMatchSet
  :cognitect.aws.waf-regional/SqlInjectionMatchSet)

(s/def
  :cognitect.aws.waf-regional.CreateSqlInjectionMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteByteMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GetPermissionPolicyResponse/Policy
  :cognitect.aws.waf-regional/PolicyString)

(s/def
  :cognitect.aws.waf-regional.GetRuleGroupRequest/RuleGroupId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.CreateSizeConstraintSetResponse/SizeConstraintSet
  :cognitect.aws.waf-regional/SizeConstraintSet)

(s/def
  :cognitect.aws.waf-regional.CreateSizeConstraintSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListSizeConstraintSetsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListSizeConstraintSetsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.DeleteRuleGroupRequest/RuleGroupId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteRuleGroupRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateRuleResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateWebACLRequest/WebACLId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateWebACLRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateWebACLRequest/Updates
  :cognitect.aws.waf-regional/WebACLUpdates)

(s/def
  :cognitect.aws.waf-regional.UpdateWebACLRequest/DefaultAction
  :cognitect.aws.waf-regional/WafAction)

(s/def :cognitect.aws.waf-regional.CreateIPSetRequest/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateIPSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GetByteMatchSetRequest/ByteMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.RuleUpdate/Action :cognitect.aws.waf-regional/ChangeAction)

(s/def :cognitect.aws.waf-regional.RuleUpdate/Predicate :cognitect.aws.waf-regional/Predicate)

(s/def
  :cognitect.aws.waf-regional.SizeConstraintSetUpdate/Action
  :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.SizeConstraintSetUpdate/SizeConstraint
  :cognitect.aws.waf-regional/SizeConstraint)

(s/def
  :cognitect.aws.waf-regional.CreateRegexMatchSetRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateRegexMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListRegexPatternSetsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRegexPatternSetsResponse/RegexPatternSets
  :cognitect.aws.waf-regional/RegexPatternSetSummaries)

(s/def :cognitect.aws.waf-regional.DeleteRuleRequest/RuleId :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteRuleRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteGeoMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateByteMatchSetRequest/ByteMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateByteMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateByteMatchSetRequest/Updates
  :cognitect.aws.waf-regional/ByteMatchSetUpdates)

(s/def
  :cognitect.aws.waf-regional.GetRegexMatchSetResponse/RegexMatchSet
  :cognitect.aws.waf-regional/RegexMatchSet)

(s/def
  :cognitect.aws.waf-regional.XssMatchSetUpdate/Action
  :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.XssMatchSetUpdate/XssMatchTuple
  :cognitect.aws.waf-regional/XssMatchTuple)

(s/def
  :cognitect.aws.waf-regional.GetChangeTokenStatusResponse/ChangeTokenStatus
  :cognitect.aws.waf-regional/ChangeTokenStatus)

(s/def
  :cognitect.aws.waf-regional.DeleteSizeConstraintSetRequest/SizeConstraintSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteSizeConstraintSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.RegexMatchTuple/FieldToMatch
  :cognitect.aws.waf-regional/FieldToMatch)

(s/def
  :cognitect.aws.waf-regional.RegexMatchTuple/TextTransformation
  :cognitect.aws.waf-regional/TextTransformation)

(s/def
  :cognitect.aws.waf-regional.RegexMatchTuple/RegexPatternSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.GetRateBasedRuleRequest/RuleId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.ListLoggingConfigurationsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListLoggingConfigurationsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def :cognitect.aws.waf-regional.IPSetUpdate/Action :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.IPSetUpdate/IPSetDescriptor
  :cognitect.aws.waf-regional/IPSetDescriptor)

(s/def
  :cognitect.aws.waf-regional.UpdateWebACLResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GetSqlInjectionMatchSetResponse/SqlInjectionMatchSet
  :cognitect.aws.waf-regional/SqlInjectionMatchSet)

(s/def
  :cognitect.aws.waf-regional.DeleteWebACLRequest/WebACLId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteWebACLRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GetLoggingConfigurationRequest/ResourceArn
  :cognitect.aws.waf-regional/ResourceArn)

(s/def
  :cognitect.aws.waf-regional.CreateWebACLRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateWebACLRequest/MetricName
  :cognitect.aws.waf-regional/MetricName)

(s/def
  :cognitect.aws.waf-regional.CreateWebACLRequest/DefaultAction
  :cognitect.aws.waf-regional/WafAction)

(s/def
  :cognitect.aws.waf-regional.CreateWebACLRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListActivatedRulesInRuleGroupResponse/ActivatedRules
  :cognitect.aws.waf-regional/ActivatedRules)

(s/def
  :cognitect.aws.waf-regional.CreateRegexPatternSetResponse/RegexPatternSet
  :cognitect.aws.waf-regional/RegexPatternSet)

(s/def
  :cognitect.aws.waf-regional.CreateRegexPatternSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def :cognitect.aws.waf-regional.IPSet/IPSetId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.IPSet/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.IPSet/IPSetDescriptors
  :cognitect.aws.waf-regional/IPSetDescriptors)

(s/def
  :cognitect.aws.waf-regional.ListRegexMatchSetsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRegexMatchSetsResponse/RegexMatchSets
  :cognitect.aws.waf-regional/RegexMatchSetSummaries)

(s/def
  :cognitect.aws.waf-regional.CreateByteMatchSetResponse/ByteMatchSet
  :cognitect.aws.waf-regional/ByteMatchSet)

(s/def
  :cognitect.aws.waf-regional.CreateByteMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteXssMatchSetRequest/XssMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteXssMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListRegexPatternSetsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRegexPatternSetsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.GeoMatchConstraint/Type
  :cognitect.aws.waf-regional/GeoMatchConstraintType)

(s/def
  :cognitect.aws.waf-regional.GeoMatchConstraint/Value
  :cognitect.aws.waf-regional/GeoMatchConstraintValue)

(s/def
  :cognitect.aws.waf-regional.DeleteXssMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GetXssMatchSetRequest/XssMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.GetWebACLResponse/WebACL :cognitect.aws.waf-regional/WebACL)

(s/def :cognitect.aws.waf-regional.RuleGroupUpdate/Action :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.RuleGroupUpdate/ActivatedRule
  :cognitect.aws.waf-regional/ActivatedRule)

(s/def :cognitect.aws.waf-regional.CreateRuleRequest/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateRuleRequest/MetricName
  :cognitect.aws.waf-regional/MetricName)

(s/def
  :cognitect.aws.waf-regional.CreateRuleRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GetRegexMatchSetRequest/RegexMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.CreateGeoMatchSetRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateGeoMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GetLoggingConfigurationResponse/LoggingConfiguration
  :cognitect.aws.waf-regional/LoggingConfiguration)

(s/def :cognitect.aws.waf-regional.RuleSummary/RuleId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.RuleSummary/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.DeleteWebACLResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.SqlInjectionMatchSetUpdate/Action
  :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.SqlInjectionMatchSetUpdate/SqlInjectionMatchTuple
  :cognitect.aws.waf-regional/SqlInjectionMatchTuple)

(s/def
  :cognitect.aws.waf-regional.GetGeoMatchSetRequest/GeoMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.ByteMatchSetUpdate/Action
  :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.ByteMatchSetUpdate/ByteMatchTuple
  :cognitect.aws.waf-regional/ByteMatchTuple)

(s/def
  :cognitect.aws.waf-regional.CreateRuleGroupResponse/RuleGroup
  :cognitect.aws.waf-regional/RuleGroup)

(s/def
  :cognitect.aws.waf-regional.CreateRuleGroupResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def :cognitect.aws.waf-regional.CreateWebACLResponse/WebACL :cognitect.aws.waf-regional/WebACL)

(s/def
  :cognitect.aws.waf-regional.CreateWebACLResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def :cognitect.aws.waf-regional.GetWebACLRequest/WebACLId :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateSqlInjectionMatchSetRequest/SqlInjectionMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateSqlInjectionMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateSqlInjectionMatchSetRequest/Updates
  :cognitect.aws.waf-regional/SqlInjectionMatchSetUpdates)

(s/def
  :cognitect.aws.waf-regional.GetWebACLForResourceResponse/WebACLSummary
  :cognitect.aws.waf-regional/WebACLSummary)

(s/def
  :cognitect.aws.waf-regional.GetRegexPatternSetResponse/RegexPatternSet
  :cognitect.aws.waf-regional/RegexPatternSet)

(s/def
  :cognitect.aws.waf-regional.AssociateWebACLRequest/WebACLId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.AssociateWebACLRequest/ResourceArn
  :cognitect.aws.waf-regional/ResourceArn)

(s/def
  :cognitect.aws.waf-regional.ListRegexMatchSetsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRegexMatchSetsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.CreateRegexMatchSetResponse/RegexMatchSet
  :cognitect.aws.waf-regional/RegexMatchSet)

(s/def
  :cognitect.aws.waf-regional.CreateRegexMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateRegexMatchSetRequest/RegexMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateRegexMatchSetRequest/Updates
  :cognitect.aws.waf-regional/RegexMatchSetUpdates)

(s/def
  :cognitect.aws.waf-regional.UpdateRegexMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.LoggingConfiguration/ResourceArn
  :cognitect.aws.waf-regional/ResourceArn)

(s/def
  :cognitect.aws.waf-regional.LoggingConfiguration/LogDestinationConfigs
  :cognitect.aws.waf-regional/LogDestinationConfigs)

(s/def
  :cognitect.aws.waf-regional.LoggingConfiguration/RedactedFields
  :cognitect.aws.waf-regional/RedactedFields)

(s/def
  :cognitect.aws.waf-regional.ListRuleGroupsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRuleGroupsResponse/RuleGroups
  :cognitect.aws.waf-regional/RuleGroupSummaries)

(s/def
  :cognitect.aws.waf-regional.DeleteRuleResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateRuleGroupRequest/RuleGroupId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateRuleGroupRequest/Updates
  :cognitect.aws.waf-regional/RuleGroupUpdates)

(s/def
  :cognitect.aws.waf-regional.UpdateRuleGroupRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteRateBasedRuleRequest/RuleId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteRateBasedRuleRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteSqlInjectionMatchSetRequest/SqlInjectionMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteSqlInjectionMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListResourcesForWebACLRequest/WebACLId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.ListResourcesForWebACLRequest/ResourceType
  :cognitect.aws.waf-regional/ResourceType)

(s/def
  :cognitect.aws.waf-regional.GetSampledRequestsResponse/SampledRequests
  :cognitect.aws.waf-regional/SampledHTTPRequests)

(s/def
  :cognitect.aws.waf-regional.GetSampledRequestsResponse/PopulationSize
  :cognitect.aws.waf-regional/PopulationSize)

(s/def
  :cognitect.aws.waf-regional.GetSampledRequestsResponse/TimeWindow
  :cognitect.aws.waf-regional/TimeWindow)

(s/def
  :cognitect.aws.waf-regional.CreateSizeConstraintSetRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateSizeConstraintSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.CreateRegexPatternSetRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateRegexPatternSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GetSampledRequestsRequest/WebAclId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.GetSampledRequestsRequest/RuleId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.GetSampledRequestsRequest/TimeWindow
  :cognitect.aws.waf-regional/TimeWindow)

(s/def
  :cognitect.aws.waf-regional.GetSampledRequestsRequest/MaxItems
  :cognitect.aws.waf-regional/GetSampledRequestsMaxItems)

(s/def
  :cognitect.aws.waf-regional.XssMatchSetSummary/XssMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.XssMatchSetSummary/Name :cognitect.aws.waf-regional/ResourceName)

(s/def :cognitect.aws.waf-regional.WafAction/Type :cognitect.aws.waf-regional/WafActionType)

(s/def
  :cognitect.aws.waf-regional.DeleteSqlInjectionMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteRegexMatchSetRequest/RegexMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteRegexMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListRateBasedRulesRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListRateBasedRulesRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def :cognitect.aws.waf-regional.HTTPRequest/ClientIP :cognitect.aws.waf-regional/IPString)

(s/def :cognitect.aws.waf-regional.HTTPRequest/Country :cognitect.aws.waf-regional/Country)

(s/def :cognitect.aws.waf-regional.HTTPRequest/URI :cognitect.aws.waf-regional/URIString)

(s/def :cognitect.aws.waf-regional.HTTPRequest/Method :cognitect.aws.waf-regional/HTTPMethod)

(s/def :cognitect.aws.waf-regional.HTTPRequest/HTTPVersion :cognitect.aws.waf-regional/HTTPVersion)

(s/def :cognitect.aws.waf-regional.HTTPRequest/Headers :cognitect.aws.waf-regional/HTTPHeaders)

(s/def
  :cognitect.aws.waf-regional.UpdateIPSetRequest/IPSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateIPSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateIPSetRequest/Updates
  :cognitect.aws.waf-regional/IPSetUpdates)

(s/def :cognitect.aws.waf-regional.GetIPSetResponse/IPSet :cognitect.aws.waf-regional/IPSet)

(s/def :cognitect.aws.waf-regional.UpdateRuleRequest/RuleId :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateRuleRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateRuleRequest/Updates
  :cognitect.aws.waf-regional/RuleUpdates)

(s/def
  :cognitect.aws.waf-regional.PutLoggingConfigurationRequest/LoggingConfiguration
  :cognitect.aws.waf-regional/LoggingConfiguration)

(s/def
  :cognitect.aws.waf-regional.DeleteRegexMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateGeoMatchSetRequest/GeoMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.UpdateGeoMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateGeoMatchSetRequest/Updates
  :cognitect.aws.waf-regional/GeoMatchSetUpdates)

(s/def :cognitect.aws.waf-regional.WebACLSummary/WebACLId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.WebACLSummary/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateSqlInjectionMatchSetRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateSqlInjectionMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateGeoMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def :cognitect.aws.waf-regional.XssMatchSet/XssMatchSetId :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.XssMatchSet/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.XssMatchSet/XssMatchTuples
  :cognitect.aws.waf-regional/XssMatchTuples)

(s/def
  :cognitect.aws.waf-regional.ListIPSetsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListIPSetsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.DeleteRuleGroupResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.SizeConstraintSet/SizeConstraintSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def :cognitect.aws.waf-regional.SizeConstraintSet/Name :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.SizeConstraintSet/SizeConstraints
  :cognitect.aws.waf-regional/SizeConstraints)

(s/def
  :cognitect.aws.waf-regional.DeletePermissionPolicyRequest/ResourceArn
  :cognitect.aws.waf-regional/ResourceArn)

(s/def :cognitect.aws.waf-regional.CreateRuleResponse/Rule :cognitect.aws.waf-regional/Rule)

(s/def
  :cognitect.aws.waf-regional.CreateRuleResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.UpdateRegexMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListXssMatchSetsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListXssMatchSetsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.CreateRuleGroupRequest/Name
  :cognitect.aws.waf-regional/ResourceName)

(s/def
  :cognitect.aws.waf-regional.CreateRuleGroupRequest/MetricName
  :cognitect.aws.waf-regional/MetricName)

(s/def
  :cognitect.aws.waf-regional.CreateRuleGroupRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.SqlInjectionMatchTuple/FieldToMatch
  :cognitect.aws.waf-regional/FieldToMatch)

(s/def
  :cognitect.aws.waf-regional.SqlInjectionMatchTuple/TextTransformation
  :cognitect.aws.waf-regional/TextTransformation)

(s/def
  :cognitect.aws.waf-regional.UpdateSqlInjectionMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListWebACLsRequest/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListWebACLsRequest/Limit
  :cognitect.aws.waf-regional/PaginationLimit)

(s/def
  :cognitect.aws.waf-regional.GetChangeTokenResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.CreateXssMatchSetResponse/XssMatchSet
  :cognitect.aws.waf-regional/XssMatchSet)

(s/def
  :cognitect.aws.waf-regional.CreateXssMatchSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListSubscribedRuleGroupsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListSubscribedRuleGroupsResponse/RuleGroups
  :cognitect.aws.waf-regional/SubscribedRuleGroupSummaries)

(s/def :cognitect.aws.waf-regional.GetIPSetRequest/IPSetId :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.ListSizeConstraintSetsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListSizeConstraintSetsResponse/SizeConstraintSets
  :cognitect.aws.waf-regional/SizeConstraintSetSummaries)

(s/def
  :cognitect.aws.waf-regional.ListIPSetsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListIPSetsResponse/IPSets
  :cognitect.aws.waf-regional/IPSetSummaries)

(s/def
  :cognitect.aws.waf-regional.GetSqlInjectionMatchSetRequest/SqlInjectionMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteRegexPatternSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.DeleteGeoMatchSetRequest/GeoMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteGeoMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.GeoMatchSetUpdate/Action
  :cognitect.aws.waf-regional/ChangeAction)

(s/def
  :cognitect.aws.waf-regional.GeoMatchSetUpdate/GeoMatchConstraint
  :cognitect.aws.waf-regional/GeoMatchConstraint)

(s/def
  :cognitect.aws.waf-regional.DeleteByteMatchSetRequest/ByteMatchSetId
  :cognitect.aws.waf-regional/ResourceId)

(s/def
  :cognitect.aws.waf-regional.DeleteByteMatchSetRequest/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.ListXssMatchSetsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.ListXssMatchSetsResponse/XssMatchSets
  :cognitect.aws.waf-regional/XssMatchSetSummaries)

(s/def
  :cognitect.aws.waf-regional.DeleteRateBasedRuleResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

(s/def
  :cognitect.aws.waf-regional.PutPermissionPolicyRequest/ResourceArn
  :cognitect.aws.waf-regional/ResourceArn)

(s/def
  :cognitect.aws.waf-regional.PutPermissionPolicyRequest/Policy
  :cognitect.aws.waf-regional/PolicyString)

(s/def
  :cognitect.aws.waf-regional.ListLoggingConfigurationsResponse/LoggingConfigurations
  :cognitect.aws.waf-regional/LoggingConfigurations)

(s/def
  :cognitect.aws.waf-regional.ListLoggingConfigurationsResponse/NextMarker
  :cognitect.aws.waf-regional/NextMarker)

(s/def
  :cognitect.aws.waf-regional.GetXssMatchSetResponse/XssMatchSet
  :cognitect.aws.waf-regional/XssMatchSet)

(s/def
  :cognitect.aws.waf-regional.UpdateIPSetResponse/ChangeToken
  :cognitect.aws.waf-regional/ChangeToken)

