/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.Signer;
import com.amazonaws.util.IOUtils;
import com.datorama.oss.timbermill.AWSRequestSigningApacheInterceptor;
import com.datorama.oss.timbermill.MaxRetriesException;
import com.datorama.oss.timbermill.common.Constants;
import com.datorama.oss.timbermill.common.DbBulkRequest;
import com.datorama.oss.timbermill.common.DiskHandler;
import com.datorama.oss.timbermill.common.ElasticsearchUtil;
import com.datorama.oss.timbermill.common.exceptions.MaximumInsertTriesException;
import com.datorama.oss.timbermill.unit.Task;
import com.datorama.oss.timbermill.unit.TaskStatus;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.LazilyParsedNumber;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.indices.rollover.RolloverRequest;
import org.elasticsearch.client.indices.rollover.RolloverResponse;
import org.elasticsearch.client.tasks.GetTaskRequest;
import org.elasticsearch.client.tasks.GetTaskResponse;
import org.elasticsearch.client.tasks.TaskSubmissionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchClient {
    public static final TermsQueryBuilder PARTIALS_QUERY = new TermsQueryBuilder("status", new Object[]{TaskStatus.PARTIAL_ERROR, TaskStatus.PARTIAL_INFO_ONLY, TaskStatus.PARTIAL_SUCCESS, TaskStatus.UNTERMINATED});
    public static final String[] ALL_TASK_FIELDS = new String[]{"*"};
    public AtomicInteger numOfBulksPersistedToDisk = new AtomicInteger(0);
    public int numOfSuccessfulBulksFromDisk = 0;
    public int numOfFetchedMaxTimes = 0;
    public int numOfCouldNotBeInserted = 0;
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchClient.class);
    private static final String TTL_FIELD = "meta.dateToDelete";
    private static final String[] PARENT_FIELD_TO_FETCH = new String[]{"orphan", "primaryId", "ctx.*", "parentsPath", "name"};
    private final RestHighLevelClient client;
    private final int indexBulkSize;
    private final ExecutorService executorService;
    private long maxIndexAge;
    private long maxIndexSizeInGB;
    private long maxIndexDocs;
    private String currentIndex;
    private String oldIndex;
    private int numOfElasticSearchActionsTries;
    private int maxBulkIndexFetches;
    private LinkedBlockingQueue<Pair<DbBulkRequest, Integer>> failedRequests = new LinkedBlockingQueue(100000);
    private DiskHandler diskHandler;
    private int searchMaxSize;

    public ElasticsearchClient(String elasticUrl, int indexBulkSize, int indexingThreads, String awsRegion, String elasticUser, String elasticPassword, long maxIndexAge, long maxIndexSizeInGB, long maxIndexDocs, int numOfElasticSearchActionsTries, int maxBulkIndexFetches, int searchMaxSize, Map<String, Object> params, String diskHandlerStrategy) {
        this.diskHandler = this.getDiskHandler(diskHandlerStrategy, params);
        if (this.diskHandler != null && this.diskHandler.isCreatedSuccessfully()) {
            this.numOfBulksPersistedToDisk = new AtomicInteger(this.diskHandler.failedBulksAmount());
        }
        this.validateProperties(indexBulkSize, indexingThreads, maxIndexAge, maxIndexSizeInGB, maxIndexDocs, numOfElasticSearchActionsTries, numOfElasticSearchActionsTries);
        this.indexBulkSize = indexBulkSize;
        this.searchMaxSize = searchMaxSize;
        this.maxIndexAge = maxIndexAge;
        this.maxIndexSizeInGB = maxIndexSizeInGB;
        this.maxIndexDocs = maxIndexDocs;
        this.numOfElasticSearchActionsTries = numOfElasticSearchActionsTries;
        this.maxBulkIndexFetches = maxBulkIndexFetches;
        this.executorService = Executors.newFixedThreadPool(indexingThreads);
        HttpHost httpHost = HttpHost.create((String)elasticUrl);
        LOG.info("Connecting to Elasticsearch at url {}", (Object)httpHost.toURI());
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{httpHost});
        if (!StringUtils.isEmpty((CharSequence)awsRegion)) {
            LOG.info("Trying to connect to AWS Elasticsearch");
            AWS4Signer signer = new AWS4Signer();
            String serviceName = "es";
            signer.setServiceName(serviceName);
            signer.setRegionName(awsRegion);
            AWSRequestSigningApacheInterceptor interceptor = new AWSRequestSigningApacheInterceptor(serviceName, (Signer)signer, (AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
            builder.setHttpClientConfigCallback(callback -> callback.addInterceptorLast(interceptor));
        }
        if (!StringUtils.isEmpty((CharSequence)elasticUser)) {
            LOG.info("Connection to Elasticsearch using user {}", (Object)elasticUser);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(elasticUser, elasticPassword));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticsearchClient.lambda$new$1((CredentialsProvider)credentialsProvider, arg_0));
        }
        this.client = new RestHighLevelClient(builder);
    }

    private DiskHandler getDiskHandler(String diskHandlerStrategy, Map<String, Object> params) {
        DiskHandler diskHandler = null;
        if (diskHandlerStrategy != null && !diskHandlerStrategy.toLowerCase().equals("none") && !(diskHandler = ElasticsearchUtil.getDiskHandler(diskHandlerStrategy, params)).isCreatedSuccessfully()) {
            diskHandler = null;
        }
        return diskHandler;
    }

    private void validateProperties(int indexBulkSize, int indexingThreads, long maxIndexAge, long maxIndexSizeInGB, long maxIndexDocs, int numOfMergedTasksTries, int numOfElasticSearchActionsTries) {
        if (indexBulkSize < 1) {
            throw new RuntimeException("Index bulk size property should be larger than 0");
        }
        if (indexingThreads < 1) {
            throw new RuntimeException("Indexing threads property should be larger than 0");
        }
        if (maxIndexAge < 1L) {
            throw new RuntimeException("Index max age property should be larger than 0");
        }
        if (maxIndexSizeInGB < 1L) {
            throw new RuntimeException("Index max size property should be larger than 0");
        }
        if (maxIndexDocs < 1L) {
            throw new RuntimeException("Index max docs property should be larger than 0");
        }
        if (numOfMergedTasksTries < 0) {
            throw new RuntimeException("Max merge tasks retries property should not be below 0");
        }
        if (numOfElasticSearchActionsTries < 0) {
            throw new RuntimeException("Max elasticsearch actions tries property should not be below 0");
        }
    }

    public String getCurrentIndex() {
        return this.currentIndex;
    }

    public String getOldIndex() {
        return this.oldIndex;
    }

    public void setCurrentIndex(String currentIndex) {
        this.currentIndex = currentIndex;
    }

    public void setOldIndex(String oldIndex) {
        this.oldIndex = oldIndex;
    }

    Map<String, Task> fetchIndexedTasks(Set<String> tasksToFetch) {
        Map<String, Task> fetchedTasks = Collections.emptyMap();
        if (!tasksToFetch.isEmpty()) {
            fetchedTasks = this.getNonOrphansTasksByIds(tasksToFetch);
            for (String taskId : tasksToFetch) {
                if (fetchedTasks.containsKey(taskId)) continue;
                LOG.debug("Couldn't find missing parent task with ID {} in Elasticsearch", (Object)taskId);
            }
        }
        return fetchedTasks;
    }

    public Task getTaskById(String taskId) {
        Map<String, Task> tasksByIds = this.getTasksByIds(null, Sets.newHashSet((Object[])new String[]{taskId}), "Test", ALL_TASK_FIELDS, Strings.EMPTY_ARRAY);
        return tasksByIds.get(taskId);
    }

    public List<Task> getMultipleTasksByIds(String taskId) {
        IdsQueryBuilder idsQueryBuilder = QueryBuilders.idsQuery().addIds(new String[]{taskId});
        Map<String, List<Task>> map = this.runScrollQuery(null, (QueryBuilder)idsQueryBuilder, "Test", Strings.EMPTY_ARRAY, ALL_TASK_FIELDS);
        return map.get(taskId);
    }

    public Map<String, Task> getTasksByIds(String index, Set<String> taskIds, String functionDescription, String[] taskFieldsToInclude, String[] taskFieldsToExclude) {
        IdsQueryBuilder idsQueryBuilder = QueryBuilders.idsQuery();
        for (String taskId : taskIds) {
            idsQueryBuilder.addIds(new String[]{taskId});
        }
        return this.getSingleTaskByIds((AbstractQueryBuilder)idsQueryBuilder, index, functionDescription, taskFieldsToInclude, taskFieldsToExclude);
    }

    private Map<String, Task> getNonOrphansTasksByIds(Set<String> taskIds) {
        IdsQueryBuilder idsQueryBuilder = QueryBuilders.idsQuery();
        for (String taskId : taskIds) {
            idsQueryBuilder.addIds(new String[]{taskId});
        }
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"orphan", (boolean)true);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ExistsQueryBuilder startedTaskQueryBuilder = QueryBuilders.existsQuery((String)"primaryId");
        boolQueryBuilder.filter((QueryBuilder)idsQueryBuilder);
        boolQueryBuilder.filter((QueryBuilder)startedTaskQueryBuilder);
        boolQueryBuilder.mustNot((QueryBuilder)termQueryBuilder);
        return this.getSingleTaskByIds((AbstractQueryBuilder)boolQueryBuilder, null, "Fetch previously indexed parent tasks", PARENT_FIELD_TO_FETCH, Strings.EMPTY_ARRAY);
    }

    public Map<String, Task> getSingleTaskByIds(AbstractQueryBuilder queryBuilder, String index, String functionDescription, String[] taskFieldsToInclude, String[] taskFieldsToExclude) {
        HashMap retMap = Maps.newHashMap();
        Map<String, List<Task>> tasks = this.runScrollQuery(index, (QueryBuilder)queryBuilder, functionDescription, taskFieldsToInclude, taskFieldsToExclude);
        for (Map.Entry<String, List<Task>> entry : tasks.entrySet()) {
            List<Task> tasksList = entry.getValue();
            String taskId = entry.getKey();
            if (tasksList.size() == 1) {
                retMap.put(taskId, tasksList.get(0));
                continue;
            }
            LOG.warn("Fetched multiple tasks per id [{}] from Elasticsearch. Tasks: {}", (Object)taskId, tasksList);
        }
        return retMap;
    }

    void indexMetaDataTasks(String env, Collection<String> metadataEvents) {
        String index = this.createTimbermillAlias(env);
        BulkRequest bulkRequest = new BulkRequest();
        for (String metadataEvent : metadataEvents) {
            IndexRequest indexRequest = new IndexRequest(index, "_doc").source(metadataEvent, XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        try {
            this.runWithRetries(() -> this.client.bulk(bulkRequest, RequestOptions.DEFAULT), 1, "Index metadata tasks");
        }
        catch (MaxRetriesException e) {
            LOG.error("Couldn't index metadata event with events {} to elasticsearch cluster.", (Object)metadataEvents.toString());
        }
    }

    void indexMetaDataTask(String env, String metadataEvent) {
        String index = this.createTimbermillAlias(env);
        IndexRequest indexRequest = new IndexRequest(index, "_doc").source(metadataEvent, XContentType.JSON);
        try {
            this.runWithRetries(() -> this.client.index(indexRequest, RequestOptions.DEFAULT), 1, "Index metadata tasks");
        }
        catch (MaxRetriesException e) {
            LOG.error("Couldn't index metadata event with events {} to elasticsearch cluster.", (Object)metadataEvent);
        }
    }

    public void close() {
        try {
            if (this.isWithPersistence()) {
                this.diskHandler.close();
            }
            this.client.close();
        }
        catch (IOException e) {
            throw new ElasticsearchException((Throwable)e);
        }
    }

    private boolean sendDbBulkRequest(DbBulkRequest dbBulkRequest, int retryNum) {
        boolean isSucceeded = false;
        BulkRequest request = dbBulkRequest.getRequest();
        int numberOfActions = request.numberOfActions();
        LOG.debug("Batch of {} index requests sent to Elasticsearch. Batch size: {} bytes", (Object)numberOfActions, (Object)request.estimatedSizeInBytes());
        if (retryNum > 0) {
            LOG.warn("Retry Number {}/{} for requests of size {}", new Object[]{retryNum, this.numOfElasticSearchActionsTries, request.estimatedSizeInBytes()});
        }
        try {
            BulkResponse responses = this.bulk(dbBulkRequest, RequestOptions.DEFAULT);
            if (responses.hasFailures()) {
                this.handleBulkRequestFailure(dbBulkRequest, retryNum, responses, responses.buildFailureMessage());
            } else {
                if (dbBulkRequest.getTimesFetched() > 0) {
                    ++this.numOfSuccessfulBulksFromDisk;
                }
                LOG.debug("Batch of size {}{} finished successfully. Took: {} millis.", new Object[]{numberOfActions, dbBulkRequest.getTimesFetched() > 0 ? ", that was fetched from disk," : "", responses.getTook().millis()});
                isSucceeded = true;
            }
        }
        catch (Throwable t) {
            this.handleBulkRequestFailure(dbBulkRequest, retryNum, null, t.getMessage());
        }
        return isSucceeded;
    }

    public BulkResponse bulk(DbBulkRequest request, RequestOptions requestOptions) throws IOException {
        return this.client.bulk(request.getRequest(), requestOptions);
    }

    public void index(Map<String, Task> tasksMap, String index) {
        Collection<Pair<Future, DbBulkRequest>> futuresRequests = this.createFuturesRequests(tasksMap, index);
        for (Pair<Future, DbBulkRequest> futureRequest : futuresRequests) {
            try {
                ((Future)futureRequest.getLeft()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("An error was thrown while indexing a batch", (Throwable)e);
                this.failedRequests.offer((Pair<DbBulkRequest, Integer>)Pair.of((Object)futureRequest.getRight(), (Object)0));
            }
        }
    }

    void rolloverIndex(String timbermillAlias) {
        try {
            RolloverRequest rolloverRequest = new RolloverRequest(timbermillAlias, null);
            rolloverRequest.addMaxIndexAgeCondition(new TimeValue(this.maxIndexAge, TimeUnit.DAYS));
            rolloverRequest.addMaxIndexSizeCondition(new ByteSizeValue(this.maxIndexSizeInGB, ByteSizeUnit.GB));
            rolloverRequest.addMaxIndexDocsCondition(this.maxIndexDocs);
            RolloverResponse rolloverResponse = (RolloverResponse)this.runWithRetries(() -> this.client.indices().rollover(rolloverRequest, RequestOptions.DEFAULT), 1, "Rollover alias " + timbermillAlias);
            if (rolloverResponse.isRolledOver()) {
                LOG.info("Index {} rolled over, new index is [{}]", (Object)rolloverResponse.getOldIndex(), (Object)rolloverResponse.getNewIndex());
                this.currentIndex = rolloverResponse.getNewIndex();
                this.oldIndex = rolloverResponse.getOldIndex();
                this.moveTasksFromOldToNewIndex();
            }
        }
        catch (Exception e) {
            LOG.error("Could not rollovered index " + timbermillAlias);
        }
    }

    private void moveTasksFromOldToNewIndex() {
        boolean success = this.reindexPartialTasks();
        if (success) {
            this.deleteByQuery(this.oldIndex, PARTIALS_QUERY.toString());
        }
    }

    private boolean reindexPartialTasks() {
        ReindexRequest reindexRequest = new ReindexRequest();
        reindexRequest.setSourceIndices(new String[]{this.oldIndex});
        reindexRequest.setDestIndex(this.currentIndex);
        reindexRequest.setConflicts("proceed");
        reindexRequest.setSourceQuery((QueryBuilder)PARTIALS_QUERY);
        try {
            TaskSubmissionResponse taskSubmissionResponse = (TaskSubmissionResponse)this.runWithRetries(() -> this.client.submitReindexTask(reindexRequest, RequestOptions.DEFAULT), 1, "Reindex partials tasks from old index to new");
            String task = taskSubmissionResponse.getTask();
            LOG.info("Reindexing partials tasks from old index [{}] to new index [{}]. Task ID: {}", new Object[]{this.oldIndex, this.currentIndex, task});
            boolean keepPolling = true;
            ZonedDateTime startTime = ZonedDateTime.now();
            while (keepPolling && this.timeoutPolling(startTime)) {
                String[] split = task.split(":");
                if (split.length != 2) {
                    LOG.error("Failed migration after rollover");
                    return false;
                }
                GetTaskRequest getTaskRequest = new GetTaskRequest(split[0], Long.parseLong(split[1]));
                Optional optionalResponse = this.client.tasks().get(getTaskRequest, RequestOptions.DEFAULT);
                if (optionalResponse.isPresent()) {
                    GetTaskResponse taskResponse = (GetTaskResponse)optionalResponse.get();
                    keepPolling = !taskResponse.isCompleted();
                    continue;
                }
                LOG.error("Failed migration after rollover");
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("Failed migration after rollover");
            return false;
        }
        return true;
    }

    private boolean timeoutPolling(ZonedDateTime startTime) {
        return ZonedDateTime.now().minusMinutes(10L).isBefore(startTime);
    }

    public void indexAndDeleteTasks(Map<String, Task> previousIndexPartialTasks) {
        if (!previousIndexPartialTasks.isEmpty()) {
            LOG.info("Starting migration between old index [{}] and new index [{}]", (Object)this.oldIndex, (Object)this.currentIndex);
            this.index(previousIndexPartialTasks, this.currentIndex);
            this.deleteTasksFromIndex(previousIndexPartialTasks.keySet(), this.oldIndex);
            LOG.info("Successfully migrated {} tasks to new index [{}]", (Object)previousIndexPartialTasks.size(), (Object)this.currentIndex);
        }
    }

    private Collection<Pair<Future, DbBulkRequest>> createFuturesRequests(Map<String, Task> tasksMap, String index) {
        Collection<UpdateRequest> requests = this.createUpdateRequests(tasksMap, index);
        BulkRequest request = new BulkRequest();
        ArrayList<Pair<Future, DbBulkRequest>> futures = new ArrayList<Pair<Future, DbBulkRequest>>();
        for (UpdateRequest updateRequest : requests) {
            request.add(updateRequest);
            if (request.estimatedSizeInBytes() <= (long)this.indexBulkSize) continue;
            DbBulkRequest dbBulkRequest = new DbBulkRequest(request);
            this.addRequestToFutures(dbBulkRequest, futures);
            request = new BulkRequest();
        }
        if (!request.requests().isEmpty()) {
            DbBulkRequest dbBulkRequest = new DbBulkRequest(request);
            this.addRequestToFutures(dbBulkRequest, futures);
        }
        return futures;
    }

    private void addRequestToFutures(DbBulkRequest request, Collection<Pair<Future, DbBulkRequest>> futures) {
        Future<Boolean> future = this.executorService.submit(() -> this.sendDbBulkRequest(request, 0));
        futures.add((Pair<Future, DbBulkRequest>)Pair.of(future, (Object)request));
    }

    private Collection<UpdateRequest> createUpdateRequests(Map<String, Task> tasksMap, String index) {
        ArrayList<UpdateRequest> requests = new ArrayList<UpdateRequest>();
        for (Map.Entry<String, Task> taskEntry : tasksMap.entrySet()) {
            Task task = taskEntry.getValue();
            try {
                UpdateRequest updateRequest = task.getUpdateRequest(index, taskEntry.getKey());
                requests.add(updateRequest);
            }
            catch (Throwable t) {
                LOG.error("Failed while creating update request. task:" + task.toString(), t);
            }
        }
        return requests;
    }

    public void bootstrapElasticsearch(int numberOfShards, int numberOfReplicas, int maxTotalFields) {
        try {
            this.putIndexTemplate(numberOfShards, numberOfReplicas, maxTotalFields);
            this.puStoredScript();
        }
        catch (MaxRetriesException e) {
            throw new RuntimeException(e);
        }
    }

    private void puStoredScript() throws MaxRetriesException {
        PutStoredScriptRequest request = new PutStoredScriptRequest();
        request.id("timbermill-script");
        String content = "{\n  \"script\": {\n    \"lang\": \"painless\",\n    \"source\": \"if (params.orphan != null && !params.orphan) {            ctx._source.orphan = false;        }        if (params.dateToDelete != null) {            ctx._source.meta.dateToDelete = params.dateToDelete;        }        if (params.status != null){        if (ctx._source.string == null){                ctx._source.string =  new HashMap();        }        if (params.status.equals( \\\"CORRUPTED\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;        }        if (ctx._source.status.equals( \\\"SUCCESS\\\" ) || ctx._source.status.equals( \\\"ERROR\\\" )){            if(params.status.equals( \\\"SUCCESS\\\" ) || params.status.equals( \\\"ERROR\\\" )){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_CLOSED\\\");            }            else if (params.status.equals( \\\"UNTERMINATED\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_STARTED\\\");            }            else if (params.status.equals( \\\"PARTIAL_SUCCESS\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_CLOSED\\\");            }            else if (params.status.equals( \\\"PARTIAL_ERROR\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_CLOSED\\\");            }        }        else if (ctx._source.status.equals( \\\"UNTERMINATED\\\")){            if(params.status.equals( \\\"SUCCESS\\\" ) || params.status.equals( \\\"ERROR\\\" )){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_STARTED\\\");            }            else if (params.status.equals( \\\"UNTERMINATED\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_STARTED\\\");            }            else if (params.status.equals( \\\"PARTIAL_SUCCESS\\\")){                long taskBegin = ZonedDateTime.parse(ctx._source.meta.taskBegin, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant().toEpochMilli();                ctx._source.meta.duration = params.taskEndMillis - taskBegin;                ctx._source.meta.taskEnd = params.taskEnd;                ctx._source.status =  \\\"SUCCESS\\\" ;            }            else if (params.status.equals( \\\"PARTIAL_ERROR\\\")){                long taskBegin = ZonedDateTime.parse(ctx._source.meta.taskBegin, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant().toEpochMilli();                ctx._source.meta.duration = params.taskEndMillis - taskBegin;                ctx._source.meta.taskEnd = params.taskEnd;                ctx._source.status = \\\"ERROR\\\";            }        }        else if (ctx._source.status.equals( \\\"PARTIAL_SUCCESS\\\")){            if(params.status.equals( \\\"SUCCESS\\\" ) || params.status.equals( \\\"ERROR\\\" )){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_CLOSED\\\");            }            if (params.status.equals( \\\"UNTERMINATED\\\")){                long taskEnd = ZonedDateTime.parse(ctx._source.meta.taskEnd, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant().toEpochMilli();                ctx._source.meta.duration = taskEnd - params.taskBeginMillis;                ctx._source.meta.taskBegin = params.taskBegin;                ctx._source.status =  \\\"SUCCESS\\\" ;            }            else if (params.status.equals( \\\"PARTIAL_SUCCESS\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_CLOSED\\\");            }            else if (params.status.equals( \\\"PARTIAL_ERROR\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_CLOSED\\\");            }        }        else if (ctx._source.status.equals( \\\"PARTIAL_ERROR\\\")){            if(params.status.equals( \\\"SUCCESS\\\" ) || params.status.equals( \\\"ERROR\\\" )){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_CLOSED\\\");            }            else if (params.status.equals( \\\"UNTERMINATED\\\")){                long taskEnd = ZonedDateTime.parse(ctx._source.meta.taskEnd, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant().toEpochMilli();                ctx._source.meta.duration = taskEnd - params.taskBeginMillis;                ctx._source.meta.taskBegin = params.taskBegin;                ctx._source.status =  \\\"ERROR\\\" ;            }            else if (params.status.equals( \\\"PARTIAL_SUCCESS\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_CLOSED\\\");            }            else if (params.status.equals( \\\"PARTIAL_ERROR\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;                ctx._source.string.put(\\\"corruptedReason\\\",\\\"ALREADY_CLOSED\\\");            }            else if (params.status.equals( \\\"CORRUPTED\\\")){                ctx._source.status =  \\\"CORRUPTED\\\" ;            }        }        else if (ctx._source.status.equals( \\\"PARTIAL_INFO_ONLY\\\")){            if(params.status.equals( \\\"SUCCESS\\\" ) || params.status.equals( \\\"ERROR\\\" )){                ctx._source.meta.duration = params.taskEndMillis - params.taskBeginMillis;                ctx._source.meta.taskEnd = params.taskEnd;                ctx._source.meta.taskBegin = params.taskBegin;                ctx._source.status = params.status;            }            else if (params.status.equals( \\\"UNTERMINATED\\\")){                ctx._source.meta.taskBegin = params.taskBegin;                ctx._source.status = params.status;            }            else if (params.status.equals( \\\"PARTIAL_SUCCESS\\\")){                ctx._source.meta.taskEnd = params.taskEnd;                ctx._source.status = params.status;            }            else if (params.status.equals( \\\"PARTIAL_ERROR\\\")){                ctx._source.meta.taskEnd = params.taskEnd;                ctx._source.status = params.status;            }        }        else {            ctx._source.status =  \\\"CORRUPTED\\\" ;        }        }        if (params.contx != null) {            if (ctx._source.ctx == null) {                ctx._source.ctx = params.contx;            }            else {                ctx._source.ctx.putAll(params.contx);            }        }        if (params.string != null) {            if (ctx._source.string == null) {                ctx._source.string = params.string;            }            else {                ctx._source.string.putAll(params.string);            }        }        if (params.text != null) {            if (ctx._source.text == null) {                ctx._source.text = params.text;            }            else {                ctx._source.text.putAll(params.text);            }        }        if (params.metric != null) {            if (ctx._source.metric == null) {                ctx._source.metric = params.metric;            }            else {                ctx._source.metric.putAll(params.metric);            }        }        if (params.logi != null) {            if (ctx._source.log == null) {                ctx._source.log = params.logi;            } else {                ctx._source.log += '\\n' + params.logi;            }        }        if (params.name != null) {            ctx._source.name = params.name;        }        if (params.parentId != null) {            ctx._source.parentId = params.parentId;        }        if (params.primaryId != null) {            ctx._source.primaryId = params.primaryId;        }        if (params.primary != null && ctx._source.primary == null) {            ctx._source.primary = params.primary;        }        if (params.parentsPath != null) {            ctx._source.parentsPath = params.parentsPath;        }        if (params.orphan != null && params.orphan) {            ctx._source.orphan = true;        }\"\n  }\n}";
        request.content((BytesReference)new BytesArray(content), XContentType.JSON);
        this.runWithRetries(() -> this.client.putScript(request, RequestOptions.DEFAULT), 1, "Put Timbermill stored script");
    }

    private void putIndexTemplate(int numberOfShards, int numberOfReplicas, int maxTotalFields) throws MaxRetriesException {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest("timbermill2-template");
        request.patterns((List)Lists.newArrayList((Object[])new String[]{"timbermill2*"}));
        request.settings(Settings.builder().put("index.mapping.total_fields.limit", maxTotalFields).put("number_of_shards", numberOfShards).put("number_of_replicas", numberOfReplicas));
        request.mapping("   {\"dynamic_templates\": [\n      {\n        \"env\": {\n          \"path_match\":   \"env\",\n          \"mapping\": {\n            \"type\":       \"keyword\"\n          }\n        }\n      },\n            {\n        \"name\": {\n          \"path_match\":   \"name\",\n          \"mapping\": {\n            \"type\":       \"keyword\"\n          }\n        }\n      },\n            {\n        \"status\": {\n          \"path_match\":   \"status\",\n          \"mapping\": {\n            \"type\":       \"keyword\"\n          }\n        }\n      },\n            {\n        \"parentId\": {\n          \"path_match\":   \"parentId\",\n          \"mapping\": {\n            \"type\":       \"keyword\"\n          }\n        }\n      },\n            {\n        \"primaryId\": {\n          \"path_match\":   \"primaryId\",\n          \"mapping\": {\n            \"type\":       \"keyword\"\n          }\n        }\n      },\n                  {\n        \"log\": {\n          \"path_match\":   \"log\",\n          \"mapping\": {\n            \"type\":       \"text\"\n          }\n        }\n      },\n      {\n        \"context\": {\n          \"path_match\":   \"ctx.*\",\n          \"mapping\": {\n            \"type\":       \"keyword\"\n          }\n        }\n      },\n      {\n        \"string\": {\n          \"path_match\":   \"string.*\",\n          \"mapping\": {\n            \"type\":       \"keyword\"\n          }\n        }\n      },\n      {\n        \"text\": {\n          \"path_match\":   \"text.*\",\n          \"mapping\": {\n            \"type\":       \"text\"\n          }\n        }\n      },\n            {\n        \"metric\": {\n          \"path_match\":   \"metric.*\",\n          \"mapping\": {\n            \"type\":       \"double\"\n          }\n        }\n      }\n    ]\n  }\n}", XContentType.JSON);
        this.runWithRetries(() -> this.client.indices().putTemplate(request, RequestOptions.DEFAULT), 1, "Put Timbermill Index Template");
    }

    String createTimbermillAlias(String env) {
        String timbermillAlias = ElasticsearchUtil.getTimbermillIndexAlias(env);
        String initialIndex = this.getInitialIndex(timbermillAlias);
        GetAliasesRequest requestWithAlias = new GetAliasesRequest(new String[]{timbermillAlias});
        try {
            boolean exists;
            GetAliasesResponse response = (GetAliasesResponse)this.runWithRetries(() -> this.client.indices().getAlias(requestWithAlias, RequestOptions.DEFAULT), 1, "Create Timbermill Alias for env " + env);
            boolean bl = exists = !response.getAliases().isEmpty();
            if (!exists) {
                CreateIndexRequest request = new CreateIndexRequest(initialIndex);
                Alias alias = new Alias(timbermillAlias);
                request.alias(alias);
                this.runWithRetries(() -> this.client.indices().create(request, RequestOptions.DEFAULT), 1, "Create index alias " + timbermillAlias + " for index " + initialIndex);
                this.currentIndex = initialIndex;
            }
        }
        catch (MaxRetriesException e) {
            LOG.error("Failed creating Timbermill Alias " + timbermillAlias + ", going to use index " + initialIndex);
        }
        return timbermillAlias;
    }

    private String getInitialIndex(String timbermillAlias) {
        String initialSerial = ElasticsearchUtil.getIndexSerial(1);
        return timbermillAlias + "-" + initialSerial;
    }

    private Map<String, List<Task>> runScrollQuery(String index, QueryBuilder query, String functionDescription, String[] taskFieldsToInclude, String[] taskFieldsToExclude) {
        SearchRequest searchRequest = index == null ? new SearchRequest() : new SearchRequest(new String[]{index});
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        searchRequest.scroll(scroll);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.fetchSource(taskFieldsToInclude, taskFieldsToExclude);
        searchSourceBuilder.query(query);
        searchSourceBuilder.size(this.searchMaxSize);
        searchRequest.source(searchSourceBuilder);
        ArrayList<SearchResponse> searchResponses = new ArrayList<SearchResponse>();
        try {
            boolean keepScrolling;
            SearchResponse searchResponse = (SearchResponse)this.runWithRetries(() -> this.client.search(searchRequest, RequestOptions.DEFAULT), 1, "Initial search for " + functionDescription);
            String scrollId = searchResponse.getScrollId();
            searchResponses.add(searchResponse);
            SearchHit[] searchHits = searchResponse.getHits().getHits();
            boolean bl = keepScrolling = searchHits != null && searchHits.length > 0;
            while (keepScrolling) {
                SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
                scrollRequest.scroll(scroll);
                SearchResponse scrollResponse = (SearchResponse)this.runWithRetries(() -> this.client.scroll(scrollRequest, RequestOptions.DEFAULT), 1, "Scroll search for scroll id: " + scrollId + " for " + functionDescription);
                scrollId = scrollResponse.getScrollId();
                searchResponses.add(scrollResponse);
                SearchHit[] scrollHits = scrollResponse.getHits().getHits();
                keepScrolling = scrollHits != null && scrollHits.length > 0;
            }
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(scrollId);
            try {
                ClearScrollResponse clearScrollResponse = this.client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                boolean succeeded = clearScrollResponse.isSucceeded();
                if (!succeeded) {
                    LOG.error("Couldn't clear scroll id [{}] for fetching partial tasks in index [{}]", (Object)scrollId, (Object)index);
                }
            }
            catch (Throwable e) {
                LOG.error("Couldn't clear scroll id [{}] for fetching partial tasks in index [{}]", (Object)scrollId, (Object)index);
            }
        }
        catch (MaxRetriesException e) {
            LOG.error("Error while running search query.", (Throwable)e);
        }
        return this.addHitsToMap(searchResponses);
    }

    private ActionResponse runWithRetries(Callable<ActionResponse> callable, int tryNum, String functionDescription) throws MaxRetriesException {
        if (tryNum > 1) {
            LOG.info("Retry # {}/{} for [{}]", new Object[]{tryNum, this.numOfElasticSearchActionsTries, functionDescription});
        }
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (tryNum <= this.numOfElasticSearchActionsTries) {
                double sleep = Math.pow(2.0, tryNum);
                LOG.warn("Retry # " + tryNum + "/" + this.numOfElasticSearchActionsTries + " for [" + functionDescription + "] failed. Going to sleep " + sleep + " seconds.", (Throwable)e);
                try {
                    Thread.sleep((long)(sleep * 1000.0));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.runWithRetries(callable, tryNum + 1, functionDescription);
            }
            LOG.error("Reached maximum retries (" + this.numOfElasticSearchActionsTries + ") attempts for [" + functionDescription + "]", (Throwable)e);
            throw new MaxRetriesException();
        }
    }

    private Map<String, List<Task>> addHitsToMap(List<SearchResponse> searchResponses) {
        HashMap tasks = Maps.newHashMap();
        for (SearchResponse searchResponse : searchResponses) {
            SearchHit[] hits;
            for (SearchHit searchHit : hits = searchResponse.getHits().getHits()) {
                String sourceAsString = searchHit.getSourceAsString();
                Task task = (Task)Constants.GSON.fromJson(sourceAsString, Task.class);
                this.fixMetrics(task);
                String id = searchHit.getId();
                if (!tasks.containsKey(id)) {
                    tasks.put(id, Lists.newArrayList((Object[])new Task[]{task}));
                    continue;
                }
                ((List)tasks.get(id)).add(task);
            }
        }
        return tasks;
    }

    private void fixMetrics(Task task) {
        Map<String, Number> metric = task.getMetric();
        HashMap<String, Double> newMetrics = new HashMap<String, Double>();
        for (Map.Entry<String, Number> entry : metric.entrySet()) {
            Number newValue;
            Number value = entry.getValue();
            if (!(value instanceof LazilyParsedNumber)) continue;
            if (value.toString().contains(".")) {
                newValue = value.doubleValue();
                newMetrics.put(entry.getKey(), (Double)newValue);
                continue;
            }
            newValue = value.longValue();
            newMetrics.put(entry.getKey(), (Double)newValue);
        }
        metric.putAll(newMetrics);
    }

    private void deleteTasksFromIndex(Set<String> idsSet, String index) {
        LOG.info("Deleting tasks from  index [{}]", (Object)index);
        ArrayList ids = new ArrayList();
        idsSet.forEach(id -> ids.add('\"' + id + '\"'));
        String query = "{\n        \"ids\" : {\n            \"values\" : " + ((Object)ids).toString() + " \n        }\n    }";
        this.deleteByQuery(index, query);
    }

    public void deleteExpiredTasks() {
        LOG.info("About to delete expired tasks");
        String query = "{\n    \"bool\": {\n      \"must\": [\n    {\n    \"range\": {\n      \"meta.dateToDelete\": {\n        \"lte\": \"now\"\n      }\n    }\n    }\n      ]\n    }\n  }";
        this.deleteByQuery("*", query);
    }

    private void deleteByQuery(String index, String query) {
        Request request = new Request("POST", "/" + index + "/_delete_by_query");
        request.addParameter("conflicts", "proceed");
        request.addParameter("wait_for_completion", "false");
        String fullQuery = "{\n    \"query\": " + query + "\n}";
        request.setJsonEntity(fullQuery);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            InputStream content = response.getEntity().getContent();
            String json = IOUtils.toString((InputStream)content);
            JsonObject asJsonObject = new JsonParser().parse(json).getAsJsonObject();
            JsonElement task = asJsonObject.get("task");
            if (task != null) {
                LOG.info("Task id {} for deletion by query", (Object)task);
            } else {
                LOG.error("Delete by query didn't return taskId. Response was {}", (Object)json);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not perform deletion.", (Throwable)e);
        }
    }

    long countByName(String name, String env) throws IOException {
        CountRequest countRequest = new CountRequest();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)name)).must((QueryBuilder)QueryBuilders.matchQuery((String)"env", (Object)env)));
        countRequest.source(searchSourceBuilder);
        CountResponse countResponse = this.client.count(countRequest, RequestOptions.DEFAULT);
        return countResponse.getCount();
    }

    public void retryFailedRequestsFromMemory() {
        if (!this.failedRequests.isEmpty()) {
            LOG.info("------------------ Failed Requests From Memory Retry Start ------------------");
            List<Pair<DbBulkRequest, Integer>> list = this.memoryFailedRequestsAsList();
            for (Pair<DbBulkRequest, Integer> entry : list) {
                DbBulkRequest dbBulkRequest = (DbBulkRequest)entry.getKey();
                Integer retryNum = (Integer)entry.getValue();
                this.sendDbBulkRequest(dbBulkRequest, retryNum + 1);
            }
            LOG.info("------------------ Failed Requests From Memory Retry End ------------------");
        }
    }

    public boolean hasFailedRequests() {
        return this.failedRequests.size() > 0;
    }

    void handleBulkRequestFailure(DbBulkRequest dbBulkRequest, int retryNum, BulkResponse responses, String failureMessage) {
        LOG.warn("Bulk index of size {} has failed.", (Object)dbBulkRequest.getRequest().estimatedSizeInBytes());
        if (failureMessage.contains("type=null_pointer_exception")) {
            DbBulkRequest failedRequest = this.extractFailedRequestsFromBulk(dbBulkRequest, responses);
            LOG.error("Null Pointer Exception Error in script. Requests:");
            failedRequest.getRequest().requests().forEach(r -> LOG.error(r.toString()));
        } else if (retryNum >= this.numOfElasticSearchActionsTries) {
            LOG.error("Reached maximum retries ({}) attempt to index. Failure message: {}", (Object)this.numOfElasticSearchActionsTries, (Object)failureMessage);
            if (this.isWithPersistence()) {
                if (dbBulkRequest.getTimesFetched() < this.maxBulkIndexFetches) {
                    DbBulkRequest updatedDbBulkRequest = this.extractFailedRequestsFromBulk(dbBulkRequest, responses);
                    try {
                        this.diskHandler.persistToDisk(updatedDbBulkRequest);
                        if (dbBulkRequest.getTimesFetched() == 0) {
                            this.numOfBulksPersistedToDisk.incrementAndGet();
                        }
                    }
                    catch (MaximumInsertTriesException e) {
                        LOG.error("Tasks of failed bulk will not be indexed because couldn't be persisted to disk for the maximum times ({}).", (Object)e.getMaximumTriesNumber());
                        ++this.numOfCouldNotBeInserted;
                    }
                } else {
                    LOG.error("Tasks of failed bulk {} will not be indexed because it was fetched maximum times ({}).", (Object)dbBulkRequest.getId(), (Object)this.maxBulkIndexFetches);
                    ++this.numOfFetchedMaxTimes;
                }
            } else {
                LOG.error("Tasks of failed bulk will not be indexed because it was fetched maximum times ({}).", (Object)this.maxBulkIndexFetches);
            }
        } else {
            LOG.warn("Failed while trying to bulk index tasks, failure message: {}. Going to retry.", (Object)failureMessage);
            DbBulkRequest updatedDbBulkRequest = this.extractFailedRequestsFromBulk(dbBulkRequest, responses);
            this.failedRequests.offer((Pair<DbBulkRequest, Integer>)Pair.of((Object)updatedDbBulkRequest, (Object)retryNum));
        }
    }

    private DbBulkRequest extractFailedRequestsFromBulk(DbBulkRequest dbBulkRequest, BulkResponse bulkResponses) {
        if (bulkResponses != null) {
            List requests = dbBulkRequest.getRequest().requests();
            BulkItemResponse[] responses = bulkResponses.getItems();
            BulkRequest failedRequestsBulk = new BulkRequest();
            int length = requests.size();
            for (int i = 0; i < length; ++i) {
                if (!responses[i].isFailed()) continue;
                failedRequestsBulk.add((DocWriteRequest)requests.get(i));
            }
            dbBulkRequest = new DbBulkRequest(failedRequestsBulk).setId(dbBulkRequest.getId()).setTimesFetched(dbBulkRequest.getTimesFetched()).setInsertTime(dbBulkRequest.getInsertTime());
        }
        return dbBulkRequest;
    }

    public boolean isWithPersistence() {
        return this.diskHandler != null;
    }

    public boolean retryFailedRequestsFromDisk() {
        this.dailyResetCounters();
        boolean keepRunning = false;
        LOG.info("Persistence Status: {} persisted to disk, {} re-processed successfully, {} failed after max retries from db since 00:00, {} couldn't be inserted to db since 00:00", new Object[]{this.numOfBulksPersistedToDisk, this.numOfSuccessfulBulksFromDisk, this.numOfFetchedMaxTimes, this.numOfCouldNotBeInserted});
        if (this.diskHandler.hasFailedBulks()) {
            keepRunning = true;
            int successBulks = 0;
            LOG.info("------------------ Retry Failed-Requests From Disk Start ------------------");
            List<DbBulkRequest> failedRequestsFromDisk = this.diskHandler.fetchAndDeleteFailedBulks();
            if (failedRequestsFromDisk.size() == 0) {
                keepRunning = false;
            }
            for (DbBulkRequest dbBulkRequest : failedRequestsFromDisk) {
                if (!this.sendDbBulkRequest(dbBulkRequest, 0)) {
                    keepRunning = false;
                    continue;
                }
                ++successBulks;
            }
            LOG.info("------------------ Retry Failed-Requests From Disk End ({}/{} fetched bulks re-processed successfully) ------------------", (Object)successBulks, (Object)failedRequestsFromDisk.size());
        } else {
            LOG.info("There are no failed bulks to fetch from disk");
        }
        return keepRunning;
    }

    List<Pair<DbBulkRequest, Integer>> memoryFailedRequestsAsList() {
        LinkedList list = Lists.newLinkedList();
        this.failedRequests.drainTo(list);
        return list;
    }

    private void dailyResetCounters() {
        LocalTime now = LocalTime.now();
        LocalTime start = LocalTime.parse("23:58:55");
        LocalTime stop = LocalTime.parse("23:59:05");
        if (now.isAfter(start) && now.isBefore(stop)) {
            this.numOfFetchedMaxTimes = 0;
            this.numOfCouldNotBeInserted = 0;
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$new$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

