/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.common;

import com.datorama.oss.timbermill.common.DbBulkRequest;
import com.datorama.oss.timbermill.common.exceptions.MaximumInsertTriesException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface DiskHandler {
    public List<DbBulkRequest> fetchAndDeleteFailedBulks();

    public void persistToDisk(DbBulkRequest var1) throws MaximumInsertTriesException;

    public boolean hasFailedBulks();

    public boolean isCreatedSuccessfully();

    public static Map<String, Object> buildDiskHandlerParams(int maxFetchedBulksInOneTime, int maxInsertTries, String locationInDisk) {
        HashMap<String, Object> diskHandlerParams = new HashMap<String, Object>();
        diskHandlerParams.put("MAX_FETCHED_BULKS_IN_ONE_TIME", maxFetchedBulksInOneTime);
        diskHandlerParams.put("MAX_INSERT_TRIES", maxInsertTries);
        diskHandlerParams.put("LOCATION_IN_DISK", locationInDisk);
        return diskHandlerParams;
    }

    public int failedBulksAmount();

    public void close();
}

