/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.common;

import com.datorama.oss.timbermill.common.DbBulkRequest;
import com.datorama.oss.timbermill.common.DiskHandler;
import com.datorama.oss.timbermill.common.exceptions.MaximumInsertTriesException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SQLJetDiskHandler
implements DiskHandler {
    static final String MAX_FETCHED_BULKS_IN_ONE_TIME = "MAX_FETCHED_BULKS_IN_ONE_TIME";
    static final String MAX_INSERT_TRIES = "MAX_INSERT_TRIES";
    static final String LOCATION_IN_DISK = "LOCATION_IN_DISK";
    private static final String DB_NAME = "timbermillJet.db";
    private static final String FAILED_BULKS_TABLE_NAME = "failed_bulks";
    private static final String ID = "id";
    private static final String FAILED_TASK = "failedTask";
    private static final String INSERT_TIME = "insertTime";
    private static final String TIMES_FETCHED = "timesFetched";
    private static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS failed_bulks (id INTEGER PRIMARY KEY AUTOINCREMENT, failedTask BLOB NOT NULL, insertTime TEXT, timesFetched INTEGER)";
    private static final Logger LOG = LoggerFactory.getLogger(SQLJetDiskHandler.class);
    private int maxFetchedBulksInOneTime;
    private int maxInsertTries;
    private String locationInDisk;
    private SqlJetDb db;
    private ISqlJetTable table;

    SQLJetDiskHandler(int maxFetchedBulks, int maxInsertTries, String locationInDisk) {
        this.maxFetchedBulksInOneTime = maxFetchedBulks;
        this.maxInsertTries = maxInsertTries;
        this.locationInDisk = locationInDisk;
        this.init();
    }

    private void init() {
        if (!StringUtils.isEmpty((CharSequence)this.locationInDisk)) {
            this.locationInDisk = this.locationInDisk + "/";
        }
        File dbFile = new File(this.locationInDisk + DB_NAME);
        try {
            this.db = SqlJetDb.open((File)dbFile, (boolean)true);
            if (!this.db.getOptions().isAutovacuum()) {
                this.db.getOptions().setAutovacuum(true);
            }
            this.db.beginTransaction(SqlJetTransactionMode.WRITE);
            this.db.getOptions().setUserVersion(1);
            this.db.createTable(CREATE_TABLE);
            this.table = this.db.getTable(FAILED_BULKS_TABLE_NAME);
            LOG.info("SQLite was created successfully: CREATE TABLE IF NOT EXISTS failed_bulks (id INTEGER PRIMARY KEY AUTOINCREMENT, failedTask BLOB NOT NULL, insertTime TEXT, timesFetched INTEGER)");
            this.silentDbCommit();
        }
        catch (Exception e) {
            LOG.error("Creation of DB has failed", (Throwable)e);
            this.silentCloseDb();
        }
    }

    @Override
    public List<DbBulkRequest> fetchAndDeleteFailedBulks() {
        return this.fetchFailedBulks(true);
    }

    @Override
    public void persistToDisk(DbBulkRequest dbBulkRequest) throws MaximumInsertTriesException {
        this.persistToDisk(dbBulkRequest, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFailedBulks() {
        boolean returnValue = false;
        ISqlJetCursor resultCursor = null;
        try {
            this.db.beginTransaction(SqlJetTransactionMode.READ_ONLY);
            resultCursor = this.table.lookup(this.table.getPrimaryKeyIndexName(), new Object[0]);
            returnValue = !resultCursor.eof();
            this.closeCursor(resultCursor);
        }
        catch (Exception e) {
            LOG.error("Checking how many bulks are in SQLite has failed.");
        }
        finally {
            this.closeCursor(resultCursor);
        }
        return returnValue;
    }

    @Override
    public boolean isCreatedSuccessfully() {
        boolean ret;
        boolean bl = ret = this.db != null;
        if (!ret) {
            LOG.error("SQLite wasn't initialized successfully.");
        }
        return ret;
    }

    @Override
    public void close() {
        try {
            this.db.dropTable(FAILED_BULKS_TABLE_NAME);
            this.db.createTable(CREATE_TABLE);
            this.table = this.db.getTable(FAILED_BULKS_TABLE_NAME);
            LOG.info("Recreated table successfully.");
            this.db.commit();
        }
        catch (Exception e) {
            LOG.warn("Drop table {} has failed", (Object)FAILED_BULKS_TABLE_NAME, (Object)e);
        }
    }

    @Override
    public int failedBulksAmount() {
        return this.fetchFailedBulks(false).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistToDisk(DbBulkRequest dbBulkRequest, long sleepTimeIfFails) throws MaximumInsertTriesException {
        int retryNum = 0;
        while (retryNum++ < this.maxInsertTries) {
            try {
                if (dbBulkRequest.getTimesFetched() > 0) {
                    int timesFetched = dbBulkRequest.getTimesFetched();
                    LOG.info("Inserting bulk request with id: {} to disk, that was fetched {} {}.", new Object[]{dbBulkRequest.getId(), timesFetched, timesFetched > 1 ? "times" : "time"});
                } else {
                    LOG.info("Inserting bulk request to disk for the first time.");
                }
                this.db.beginTransaction(SqlJetTransactionMode.WRITE);
                dbBulkRequest.setInsertTime(DateTime.now().toString());
                this.table.insert(new Object[]{this.serializeBulkRequest(dbBulkRequest.getRequest()), dbBulkRequest.getInsertTime(), dbBulkRequest.getTimesFetched()});
                LOG.info("Bulk request was inserted successfully to disk.");
                break;
            }
            catch (Exception e) {
                LOG.error("Insertion of bulk has failed for the {}th time. Error message: {}", (Object)retryNum, (Object)e);
                this.silentThreadSleep(sleepTimeIfFails);
                sleepTimeIfFails *= 2L;
                if (retryNum != this.maxInsertTries) continue;
                throw new MaximumInsertTriesException(this.maxInsertTries);
            }
            finally {
                this.silentDbCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DbBulkRequest> fetchFailedBulks(boolean deleteAfterFetch) {
        ArrayList<DbBulkRequest> dbBulkRequests = new ArrayList<DbBulkRequest>();
        ISqlJetCursor resultCursor = null;
        try {
            int fetchedCount;
            LOG.info("Fetching from SQLite...");
            this.db.beginTransaction(SqlJetTransactionMode.WRITE);
            resultCursor = this.table.lookup(this.table.getPrimaryKeyIndexName(), new Object[0]);
            for (fetchedCount = 0; fetchedCount < this.maxFetchedBulksInOneTime && !resultCursor.eof(); ++fetchedCount) {
                DbBulkRequest dbBulkRequest = this.createDbBulkRequestFromCursor(resultCursor);
                dbBulkRequests.add(dbBulkRequest);
                if (deleteAfterFetch) {
                    resultCursor.delete();
                    continue;
                }
                resultCursor.next();
            }
            LOG.info("Fetched successfully. Number of fetched bulks: {}.", (Object)fetchedCount);
            this.closeCursor(resultCursor);
            this.silentDbCommit();
        }
        catch (Exception e) {
            LOG.error("Fetching has failed.", (Throwable)e);
        }
        finally {
            this.closeCursor(resultCursor);
            this.silentDbCommit();
        }
        return dbBulkRequests;
    }

    private DbBulkRequest createDbBulkRequestFromCursor(ISqlJetCursor resultCursor) throws IOException, SqlJetException {
        BulkRequest request = this.deserializeBulkRequest(resultCursor.getBlobAsArray(FAILED_TASK));
        DbBulkRequest dbBulkRequest = new DbBulkRequest(request);
        dbBulkRequest.setId((int)resultCursor.getInteger(ID));
        dbBulkRequest.setInsertTime(resultCursor.getString(INSERT_TIME));
        dbBulkRequest.setTimesFetched((int)resultCursor.getInteger(TIMES_FETCHED) + 1);
        return dbBulkRequest;
    }

    private byte[] serializeBulkRequest(BulkRequest request) throws IOException {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            request.writeTo((StreamOutput)out);
            byte[] byArray = out.bytes().toBytesRef().bytes;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BulkRequest deserializeBulkRequest(byte[] bulkRequestBytes) throws IOException {
        try (StreamInput stream = null;){
            BulkRequest request = new BulkRequest();
            stream = StreamInput.wrap((byte[])bulkRequestBytes);
            request.readFrom(stream);
            BulkRequest bulkRequest = request;
            return bulkRequest;
        }
    }

    private void closeCursor(ISqlJetCursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            LOG.error("Closing cursor has failed", (Throwable)e);
        }
    }

    private void silentDbCommit() {
        try {
            this.db.commit();
        }
        catch (Exception e) {
            LOG.error("Commit updates has failed", (Throwable)e);
        }
    }

    private void silentCloseDb() {
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (Exception e) {
                LOG.error("Closing SQLite has failed", (Throwable)e);
            }
            this.db = null;
        }
    }

    private void silentThreadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (Exception e) {
            LOG.warn("Making thread sleep has failed", (Throwable)e);
        }
    }
}

