/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.cron;

import com.datorama.oss.timbermill.ElasticsearchClient;
import com.datorama.oss.timbermill.unit.Task;
import com.google.common.collect.Maps;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksMergerJobs
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(TasksMergerJobs.class);
    private ElasticsearchClient client;

    public void execute(JobExecutionContext context) {
        this.client = (ElasticsearchClient)context.getJobDetail().getJobDataMap().get((Object)"client");
        String currentIndex = this.client.getCurrentIndex();
        String previousIndex = this.client.getOldIndex();
        if (this.indexExists(previousIndex)) {
            LOG.info("About to merge partial tasks between indices");
            int size = this.migrateMatchingTasksToNewIndexPartialTasks(currentIndex, previousIndex);
            LOG.info("Finished merging {} partial tasks.", (Object)size);
        }
    }

    private boolean indexExists(String index) {
        return index != null;
    }

    private int migrateMatchingTasksToNewIndexPartialTasks(String currentIndex, String previousIndex) {
        Map<Object, Object> previousIndexMatchingTasks = Maps.newHashMap();
        String functionDescription = "Migrate old tasks to new index'es partial tasks";
        Map<String, Task> singleTaskByIds = this.client.getSingleTaskByIds((AbstractQueryBuilder)ElasticsearchClient.PARTIALS_QUERY, currentIndex, functionDescription, Strings.EMPTY_ARRAY, ElasticsearchClient.ALL_TASK_FIELDS);
        if (!singleTaskByIds.isEmpty()) {
            previousIndexMatchingTasks = this.client.getTasksByIds(previousIndex, singleTaskByIds.keySet(), functionDescription, ElasticsearchClient.ALL_TASK_FIELDS, Strings.EMPTY_ARRAY);
            this.client.indexAndDeleteTasks(previousIndexMatchingTasks);
        }
        return previousIndexMatchingTasks.size();
    }
}

