/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.plugins;

import com.datorama.oss.timbermill.plugins.TaskLogPlugin;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PluginsConfig.class);
    private static JsonDeserializer<TaskLogPlugin> deserializer = (json, typeOfT, context) -> {
        Class<?> klass;
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("class");
        String className = prim.getAsString();
        if (className.indexOf(46) == -1) {
            className = "com.datorama.oss.timbermill.plugins." + className;
        }
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new JsonParseException(e.getMessage());
        }
        return (TaskLogPlugin)context.deserialize((JsonElement)jsonObject, klass);
    };

    public static Collection<TaskLogPlugin> initPluginsFromJson(String pluginsJson) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(TaskLogPlugin.class, deserializer);
        Gson customGson = gsonBuilder.create();
        Type listType = new TypeToken<ArrayList<TaskLogPlugin>>(){}.getType();
        Collection ret = (Collection)customGson.fromJson(pluginsJson, listType);
        int i = 1;
        for (TaskLogPlugin p : ret) {
            if (p.getName() == null) {
                p.setName(p.getClass().getSimpleName() + "_" + i);
            }
            ++i;
        }
        LOG.info("Loaded " + ret.size() + " plugins: " + ret);
        LOG.info("Parsed json: " + new Gson().toJson((Object)ret));
        return ret;
    }
}

