/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.plugins;

import com.datorama.oss.timbermill.plugins.TaskLogPlugin;
import com.datorama.oss.timbermill.plugins.TaskMatcher;
import com.datorama.oss.timbermill.unit.Event;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class SwitchCasePlugin
extends TaskLogPlugin {
    private static final long serialVersionUID = 1154980374224187763L;
    private final TaskMatcher taskMatcher;
    private final String searchField;
    private final String outputAttribute;
    private final Collection<CaseRule> switchCase;

    public SwitchCasePlugin(String name, TaskMatcher taskMatcher, String searchField, String outputAttribute, Collection<CaseRule> switchCase) {
        super(name);
        this.taskMatcher = taskMatcher;
        this.searchField = searchField;
        this.outputAttribute = outputAttribute;
        this.switchCase = switchCase;
    }

    @Override
    public void apply(Collection<Event> events) {
        events.stream().filter(e -> e.getText() != null && e.getText().containsKey(this.searchField)).filter(e -> this.taskMatcher.matches((Event)e)).forEach(e -> {
            String searchText = (String)e.getText().get(this.searchField);
            if (searchText != null) {
                for (CaseRule caseRule : this.switchCase) {
                    if (!caseRule.matches(searchText)) continue;
                    if (e.getStrings() == null) {
                        e.setStrings((Map)Maps.newHashMap());
                    }
                    e.getStrings().put(this.outputAttribute, caseRule.getOutput());
                    break;
                }
            }
        });
    }

    public static class CaseRule
    implements Serializable {
        private static final long serialVersionUID = 642071029855386301L;
        private Collection<String> match;
        private String output;

        public CaseRule() {
        }

        public CaseRule(Collection<String> match, String output) {
            this.match = match;
            this.output = output;
        }

        boolean matches(String searchText) {
            if (this.match == null) {
                return true;
            }
            for (String searchPattern : this.match) {
                if (!searchText.contains(searchPattern)) continue;
                return true;
            }
            return false;
        }

        String getOutput() {
            return this.output;
        }
    }
}

