/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.unit;

import com.datorama.oss.timbermill.common.ElasticsearchUtil;
import com.datorama.oss.timbermill.common.TimbermillDatesUtils;
import com.datorama.oss.timbermill.unit.Task;
import com.datorama.oss.timbermill.unit.TaskStatus;
import java.time.ZonedDateTime;
import java.util.Map;

public class IndexEvent
extends Task {
    private IndexEvent(String env, Integer fetchedAmount, ZonedDateTime startTime, ZonedDateTime endTime, TaskStatus status, Integer eventsAmount, String exception, long defaultDaysRotation) {
        this.setName("metadata_timbermill_index");
        this.setEnv(env);
        Map<String, Number> metric = this.getMetric();
        metric.put("eventsAmount", eventsAmount);
        metric.put("fetchedAmount", fetchedAmount);
        this.setStatus(status);
        if (exception != null) {
            this.getText().put("exception", exception);
        }
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        long indexerDuration = ElasticsearchUtil.getTimesDuration(startTime, endTime);
        this.setDuration(indexerDuration);
        this.setDateToDelete(TimbermillDatesUtils.getDateToDeleteWithDefault((long)defaultDaysRotation));
    }

    public IndexEvent(String env, Integer fetchedAmount, ZonedDateTime startTime, ZonedDateTime endTime, Integer eventsAmount, long defaultDaysRotation) {
        this(env, fetchedAmount, startTime, endTime, TaskStatus.SUCCESS, eventsAmount, null, defaultDaysRotation);
    }
}

