/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.unit;

import com.datorama.oss.timbermill.common.Constants;
import com.datorama.oss.timbermill.common.ElasticsearchUtil;
import com.datorama.oss.timbermill.unit.Event;
import com.datorama.oss.timbermill.unit.TaskMetaData;
import com.datorama.oss.timbermill.unit.TaskStatus;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    private static final Logger LOG = LoggerFactory.getLogger(Task.class);
    private static final String OLD_EVENT_ID_DELIMITER = "_";
    private static final String TIMBERMILL_SUFFIX = "_timbermill2";
    private String env;
    private String name;
    private TaskStatus status;
    private String parentId;
    private String primaryId;
    private List<String> parentsPath;
    private TaskMetaData meta = new TaskMetaData();
    private Map<String, String> ctx = new HashMap<String, String>();
    private Map<String, String> string = new HashMap<String, String>();
    private Map<String, String> text = new HashMap<String, String>();
    private Map<String, Number> metric = new HashMap<String, Number>();
    private String log;
    private Boolean orphan;

    public Task() {
    }

    public Task(List<Event> events, long daysRotation) {
        Map<String, List<Event>> collect = events.stream().collect(Collectors.groupingBy(e -> e.isAdoptedEvent() ? "ADOPTED" : "REGULAR"));
        if (collect.containsKey("REGULAR")) {
            for (Event e2 : collect.get("REGULAR")) {
                ZonedDateTime dateToDelete;
                String env = e2.getEnv();
                if (this.env != null && !this.env.equals(env)) {
                    throw new RuntimeException("Timbermill events with same id must have same env " + this.env + " !=" + env);
                }
                this.env = env;
                String name = e2.getName();
                if (name == null) {
                    name = Task.getNameFromId(name, e2.getTaskId());
                }
                String parentId = e2.getParentId();
                ZonedDateTime startTime = e2.getTime();
                ZonedDateTime endTime = e2.getEndTime();
                if (this.name == null) {
                    this.name = name;
                }
                if (this.parentId == null) {
                    this.parentId = parentId;
                } else if (parentId != null && !this.parentId.equals(parentId)) {
                    LOG.warn("Found different parentId for same task. Flagged task [{}] as corrupted. parentId 1 [{}], parentId 2 [{}]", new Object[]{e2.getTaskId(), this.parentId, parentId});
                    this.status = TaskStatus.CORRUPTED;
                    this.string.put("corruptedReason", "Different parentIds");
                }
                if (this.getStartTime() == null) {
                    this.setStartTime(startTime);
                }
                if (this.getEndTime() == null) {
                    this.setEndTime(endTime);
                }
                if ((dateToDelete = e2.getDateToDelete(daysRotation)) != null) {
                    this.setDateToDelete(dateToDelete);
                }
                this.status = e2.getStatusFromExistingStatus(this.status);
                if (e2.getStrings() != null && !e2.getStrings().isEmpty()) {
                    this.string.putAll(e2.getStrings());
                }
                if (e2.getText() != null && !e2.getText().isEmpty()) {
                    this.text.putAll(e2.getText());
                }
                if (e2.getMetrics() != null && !e2.getMetrics().isEmpty()) {
                    this.metric.putAll(e2.getMetrics());
                }
                if (e2.getLogs() != null && !e2.getLogs().isEmpty()) {
                    this.log = this.log != null ? this.log + '\n' + StringUtils.join((Iterable)e2.getLogs(), (char)'\n') : StringUtils.join((Iterable)e2.getLogs(), (char)'\n');
                }
                String primaryId = e2.getPrimaryId();
                if (this.primaryId == null) {
                    this.primaryId = primaryId;
                } else if (primaryId != null && !this.primaryId.equals(primaryId)) {
                    if (this.primaryId.equals(e2.getTaskId())) {
                        this.primaryId = primaryId;
                    } else if (!primaryId.equals(e2.getTaskId())) {
                        LOG.warn(Constants.GSON.toJson(events));
                        LOG.warn("Found different primaryId for same task. Flagged task [{}] as corrupted. primaryId 1 [{}], primaryId 2 [{}]", new Object[]{e2.getTaskId(), this.primaryId, primaryId});
                        this.status = TaskStatus.CORRUPTED;
                        this.string.put("corruptedReason", "Different primaryIds");
                    }
                }
                List parentsPath = e2.getParentsPath();
                if (this.parentsPath == null) {
                    this.parentsPath = parentsPath;
                } else if (parentsPath != null && !parentsPath.equals(this.parentsPath)) {
                    LOG.warn(Constants.GSON.toJson(events));
                    LOG.warn("Found different parentsPath for same task. Flagged task [{}] as corrupted. parentsPath 1 [{}], parentsPath 2 [{}]", new Object[]{e2.getTaskId(), this.parentsPath, parentsPath});
                    this.status = TaskStatus.CORRUPTED;
                    this.string.put("corruptedReason", "Different parentsPaths");
                }
                if (e2.getContext() != null && !e2.getContext().isEmpty()) {
                    this.ctx.putAll(e2.getContext());
                }
                if (e2.isOrphan() == null) continue;
                if (this.orphan == null) {
                    this.orphan = e2.isOrphan();
                    continue;
                }
                this.orphan = this.orphan != false || e2.isOrphan() != false;
            }
        }
        ZonedDateTime startTime = this.getStartTime();
        ZonedDateTime endTime = this.getEndTime();
        if (this.isComplete()) {
            long duration = ElasticsearchUtil.getTimesDuration(startTime, endTime);
            this.setDuration(duration);
        }
        if (collect.containsKey("ADOPTED")) {
            List<Event> adoptedEvents = collect.get("ADOPTED");
            if (adoptedEvents.size() > 1) {
                LOG.warn("More than 1 adopted events. Events {}", adoptedEvents);
            }
            for (Event adoptedEvent : adoptedEvents) {
                String primaryId = adoptedEvent.getPrimaryId();
                if (primaryId == null) {
                    LOG.warn("No primary ID for adopted event. Adopted {} \n Task {}", (Object)adoptedEvent.toString(), (Object)this.toString());
                } else {
                    this.primaryId = primaryId;
                }
                List parentsPath = adoptedEvent.getParentsPath();
                if (parentsPath == null || parentsPath.isEmpty()) {
                    LOG.warn("Empty parent path for adopted event. Adopted {} \n Task {}", (Object)adoptedEvent.toString(), (Object)this.toString());
                } else {
                    this.parentsPath = parentsPath;
                }
                Map adoptedContext = adoptedEvent.getContext();
                if (adoptedContext != null && !adoptedContext.isEmpty()) {
                    for (Map.Entry entry : adoptedContext.entrySet()) {
                        this.ctx.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                this.orphan = false;
            }
        }
    }

    private boolean isComplete() {
        return this.status == TaskStatus.SUCCESS || this.status == TaskStatus.ERROR;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getPrimaryId() {
        return this.primaryId;
    }

    public void setPrimaryId(String primaryId) {
        this.primaryId = primaryId;
    }

    public ZonedDateTime getStartTime() {
        return this.meta.getTaskBegin();
    }

    public void setStartTime(ZonedDateTime startTime) {
        this.meta.setTaskBegin(startTime);
    }

    public ZonedDateTime getEndTime() {
        return this.meta.getTaskEnd();
    }

    public void setEndTime(ZonedDateTime endTime) {
        this.meta.setTaskEnd(endTime);
    }

    public ZonedDateTime getDateToDelete() {
        return this.meta.getDateToDelete();
    }

    public void setDateToDelete(ZonedDateTime dateToDelete) {
        this.meta.setDateToDelete(dateToDelete);
    }

    public Long getDuration() {
        return this.meta.getDuration();
    }

    public void setDuration(Long duration) {
        this.meta.setDuration(duration);
    }

    public Map<String, String> getString() {
        return this.string;
    }

    public void setString(Map<String, String> string) {
        this.string = string;
    }

    public Map<String, Number> getMetric() {
        return this.metric;
    }

    public void setMetric(Map<String, Number> metric) {
        this.metric = metric;
    }

    public Map<String, String> getText() {
        return this.text;
    }

    public void setText(Map<String, String> text) {
        this.text = text;
    }

    public Map<String, String> getCtx() {
        return this.ctx;
    }

    public void setCtx(Map<String, String> ctx) {
        this.ctx = ctx;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public List<String> getParentsPath() {
        return this.parentsPath;
    }

    public void setParentsPath(List<String> parentsPath) {
        this.parentsPath = parentsPath;
    }

    public void setMeta(TaskMetaData meta) {
        this.meta = meta;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public Boolean isOrphan() {
        return this.orphan;
    }

    public void setOrphan(Boolean orphan) {
        this.orphan = orphan;
    }

    public UpdateRequest getUpdateRequest(String index, String taskId) {
        UpdateRequest updateRequest = new UpdateRequest(index, "_doc", taskId);
        updateRequest.upsert(Constants.GSON.toJson((Object)this), XContentType.JSON);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.getStartTime() != null) {
            params.put("taskBegin", this.getStartTime().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            params.put("taskBeginMillis", this.getStartTime().toInstant().toEpochMilli());
        }
        if (this.getEndTime() != null) {
            params.put("taskEnd", this.getEndTime().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            params.put("taskEndMillis", this.getEndTime().toInstant().toEpochMilli());
        }
        if (this.getDateToDelete() != null) {
            params.put("dateToDelete", this.getDateToDelete().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        params.put("name", this.name);
        params.put("parentId", this.parentId);
        params.put("primaryId", this.primaryId);
        params.put("contx", this.ctx);
        params.put("string", this.string);
        params.put("text", this.text);
        params.put("metric", this.metric);
        params.put("logi", this.log);
        params.put("parentsPath", this.parentsPath);
        params.put("status", this.status != null ? this.status.toString() : "");
        if (this.orphan != null) {
            params.put("orphan", this.orphan);
        }
        Script script = new Script(ScriptType.STORED, null, "timbermill-script", params);
        updateRequest.script(script);
        return updateRequest;
    }

    public String toString() {
        return "Task{env='" + this.env + '\'' + ", name='" + this.name + '\'' + ", status=" + this.status + ", parentId='" + this.parentId + '\'' + ", primaryId='" + this.primaryId + '\'' + ", parentsPath=" + this.parentsPath + ", meta={" + this.meta + "}, ctx=" + this.ctx + ", string=" + this.string + ", text=" + this.text + ", metric=" + this.metric + ", log='" + this.log + '\'' + ", orphan=" + this.orphan + '}';
    }

    public static String getNameFromId(String name, String taskId) {
        try {
            if (name == null) {
                String[] split;
                String taskIdToUse = taskId;
                if (taskIdToUse.endsWith(TIMBERMILL_SUFFIX)) {
                    taskIdToUse = taskIdToUse.substring(0, taskIdToUse.length() - TIMBERMILL_SUFFIX.length());
                }
                if ((split = taskIdToUse.split("___")).length == 1) {
                    split = taskIdToUse.split(OLD_EVENT_ID_DELIMITER);
                    CharSequence[] newSplit = Arrays.copyOf(split, split.length - 2);
                    return String.join((CharSequence)OLD_EVENT_ID_DELIMITER, newSplit);
                }
                return split[0];
            }
            return name;
        }
        catch (Exception e) {
            LOG.warn("Couldn't get name from ID {}", (Object)taskId);
            return taskId;
        }
    }
}

