/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.ftp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.CloseableByteBufferHandler;
import com.davfx.ninio.core.FailableCloseableByteBufferHandler;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.Ready;
import com.davfx.ninio.core.ReadyConnection;
import com.davfx.ninio.core.ReadyFactory;
import com.davfx.ninio.core.SocketReady;
import com.davfx.ninio.ftp.FtpClientHandler;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FtpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpClient.class);
    private final Queue queue;
    private final ReadyFactory readyFactory;
    private final Address address;
    private final String login;
    private final String password;
    private static final Charset USASCII_CHARSET = Charset.forName("US-ASCII");
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char PATH_SEPARATOR = '/';

    public FtpClient(Queue queue, ReadyFactory readyFactory, Address address, String login, String password) {
        this.queue = queue;
        this.readyFactory = readyFactory;
        this.address = address;
        this.login = login;
        this.password = password;
    }

    public void connect(final FtpClientHandler clientHandler) {
        this.queue.post(new Runnable(){

            @Override
            public void run() {
                Ready ready = FtpClient.this.readyFactory.create(FtpClient.this.queue);
                ready.connect(FtpClient.this.address, new ReadyConnection(){
                    private FtpResponseReader reader = null;

                    public void handle(Address address, ByteBuffer buffer) {
                        this.reader.handle(address, buffer);
                    }

                    public void failed(IOException e) {
                        clientHandler.failed(e);
                    }

                    public void connected(FailableCloseableByteBufferHandler write) {
                        this.reader = new FtpResponseReader(FtpClient.this.queue, FtpClient.this.login, FtpClient.this.password, clientHandler, (CloseableByteBufferHandler)write);
                        clientHandler.launched(new FtpClientHandler.Callback(){

                            public void close() {
                                reader.close();
                            }

                            @Override
                            public void list(String path, FtpClientHandler.Callback.ListCallback callback) {
                                reader.list(path, callback);
                            }

                            @Override
                            public void download(String path, FtpClientHandler.Callback.DownloadCallback handler) {
                                reader.download(path, handler);
                            }
                        });
                    }

                    public void close() {
                        this.reader.close();
                    }
                });
            }
        });
    }

    private static final class LineReader {
        private final StringBuilder line = new StringBuilder();
        private boolean lastCharCR = false;

        public static ByteBuffer toBuffer(String s) {
            return ByteBuffer.wrap((s + '\r' + '\n').getBytes(USASCII_CHARSET));
        }

        public String handle(ByteBuffer buffer) {
            while (buffer.hasRemaining()) {
                char c = (char)buffer.get();
                if (this.lastCharCR) {
                    this.lastCharCR = false;
                    if (c == '\n') {
                        String l = this.line.toString();
                        this.line.setLength(0);
                        return l;
                    }
                    this.line.append('\r');
                    if (c == '\r') {
                        this.lastCharCR = true;
                        continue;
                    }
                    this.line.append(c);
                    continue;
                }
                if (c == '\r') {
                    this.lastCharCR = true;
                    continue;
                }
                this.line.append(c);
            }
            return null;
        }
    }

    private static final class FtpResponseReader
    implements CloseableByteBufferHandler,
    FtpClientHandler.Callback {
        private final String login;
        private final String password;
        private final CloseableByteBufferHandler write;
        private Address dataAddress;
        private CloseableByteBufferHandler data = null;
        private State state = State._CONNECTING;
        private final Deque<List<String>> toDownloadSplitPaths = new LinkedList<List<String>>();
        private final Deque<String> toDownloadRawPaths = new LinkedList<String>();
        private boolean idle = false;
        private boolean dataFinished = false;
        private boolean retrFinished = false;
        private final Deque<String> currentDirectory = new LinkedList<String>();
        private String goTo;
        private String fileToRetr;
        private String currentRawPath;
        private final Queue queue;
        private boolean closed = false;
        private final LineReader lineReader = new LineReader();
        private final FtpClientHandler handler;
        private FtpClientHandler.Callback.DownloadCallback downloadCallback = null;
        private FtpClientHandler.Callback.ListCallback listCallback = null;
        private final Set<String> list = new TreeSet<String>();

        public FtpResponseReader(Queue queue, String login, String password, FtpClientHandler handler, CloseableByteBufferHandler write) {
            this.queue = queue;
            this.handler = handler;
            this.write = write;
            this.login = login;
            this.password = password;
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.write.close();
                this.handler.close();
            }
        }

        @Override
        public void list(String path, FtpClientHandler.Callback.ListCallback callback) {
            if (this.data != null) {
                this.data.close();
                this.data = null;
            }
            this.listCallback = callback;
            this.downloadCallback = null;
            this.list.clear();
            if (path.charAt(path.length() - 1) != '/') {
                throw new IllegalArgumentException("Path must finish with '/'");
            }
            this.download(path);
        }

        @Override
        public void download(String path, FtpClientHandler.Callback.DownloadCallback handler) {
            if (this.data != null) {
                this.data.close();
                this.data = null;
            }
            this.downloadCallback = handler;
            this.listCallback = null;
            this.list.clear();
            if (path.charAt(path.length() - 1) == '/') {
                throw new IllegalArgumentException("Path cannot finish with '/'");
            }
            this.download(path);
        }

        public void handle(Address address, ByteBuffer buffer) {
            if (this.closed) {
                return;
            }
            try {
                while (true) {
                    int code;
                    String line;
                    if ((line = this.lineReader.handle(buffer)) == null) {
                        return;
                    }
                    LOGGER.debug("Line read: {}", (Object)line);
                    if (line.length() >= 1 && line.charAt(0) == ' ') continue;
                    if (line.length() < 4) {
                        throw new IOException("Invalid response");
                    }
                    if (line.charAt(3) == '-') continue;
                    try {
                        code = Integer.parseInt(line.substring(0, 3));
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Invalid response code");
                    }
                    String message = line.substring(4);
                    this.handleLine(code, message);
                }
            }
            catch (IOException e) {
                if (this.data != null) {
                    this.data.close();
                    this.data = null;
                }
                if (!this.closed) {
                    this.closed = true;
                    this.write.close();
                    this.handler.failed(e);
                }
                return;
            }
        }

        private void checkCode(int code, int ... required) throws IOException {
            for (int r : required) {
                if (code != r) continue;
                return;
            }
            throw new IOException("Response code " + code + " should be " + required);
        }

        private void writeLine(String line) {
            if (this.closed) {
                return;
            }
            this.write.handle(null, LineReader.toBuffer(line));
        }

        private void handleLine(int code, String message) throws IOException {
            switch (this.state) {
                case _CONNECTING: {
                    this.checkCode(code, 220);
                    LOGGER.debug("Writing login: {}", (Object)this.login);
                    this.writeLine("USER " + this.login);
                    this.state = State.USER;
                    break;
                }
                case USER: {
                    this.checkCode(code, 331);
                    LOGGER.debug("Writing password: {}", (Object)this.password);
                    this.writeLine("PASS " + this.password);
                    this.state = State.PASS;
                    break;
                }
                case PASS: {
                    if (code == 530) {
                        this.closed = true;
                        this.write.close();
                        this.handler.authenticationFailed();
                        return;
                    }
                    this.checkCode(code, 230);
                    this.writeLine("MODE S");
                    this.state = State.MODE;
                    break;
                }
                case MODE: {
                    this.checkCode(code, 200);
                    if (!this.toDownloadSplitPaths.isEmpty()) {
                        this.moveToDir();
                        break;
                    }
                    this.idle = true;
                    break;
                }
                case CWD: {
                    if (code == 550) {
                        Object c;
                        this.toDownloadSplitPaths.removeFirst();
                        String rawPath = this.toDownloadRawPaths.removeFirst();
                        if (this.downloadCallback != null) {
                            c = this.downloadCallback;
                            this.downloadCallback = null;
                            c.doesNotExist(rawPath);
                        }
                        if (this.listCallback != null) {
                            c = this.listCallback;
                            this.listCallback = null;
                            c.doesNotExist(rawPath);
                        }
                        if (!this.toDownloadSplitPaths.isEmpty()) {
                            this.moveToDir();
                        } else {
                            this.idle = true;
                        }
                        return;
                    }
                    this.checkCode(code, 250);
                    this.currentDirectory.addLast(this.goTo);
                    this.moveToDir();
                    break;
                }
                case CDUP: {
                    this.checkCode(code, 250);
                    this.currentDirectory.removeLast();
                    this.moveToDir();
                    break;
                }
                case PASV: {
                    int port;
                    this.checkCode(code, 227);
                    int u = message.indexOf(40);
                    if (u < 0) {
                        throw new IOException("Missing opening paranthesis");
                    }
                    int v = message.indexOf(41, u + 1);
                    if (v < 0) {
                        throw new IOException("Missing closing paranthesis");
                    }
                    List<String> ss = FtpResponseReader.split(message.substring(u + 1, v), ',');
                    if (ss.size() != 6) {
                        throw new IOException("Invalid address");
                    }
                    String host = ss.get(0) + "." + ss.get(1) + "." + ss.get(2) + "." + ss.get(3);
                    try {
                        port = Integer.parseInt(ss.get(4)) * 256 + Integer.parseInt(ss.get(5));
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Invalid address");
                    }
                    this.dataAddress = new Address(host, port);
                    LOGGER.debug("Data address: {}", (Object)this.dataAddress);
                    this.currentRawPath = this.toDownloadRawPaths.removeFirst();
                    List<String> path = this.toDownloadSplitPaths.removeFirst();
                    String file = path.get(path.size() - 1);
                    if (file.isEmpty()) {
                        new SocketReady(this.queue.getSelector(), this.queue.allocator()).connect(this.dataAddress, new ReadyConnection(){
                            private final LineReader lineReader = new LineReader();

                            public void handle(Address address, ByteBuffer buffer) {
                                String name;
                                if (FtpResponseReader.this.closed) {
                                    return;
                                }
                                if (FtpResponseReader.this.listCallback == null) {
                                    return;
                                }
                                while ((name = this.lineReader.handle(buffer)) != null) {
                                    if (name.equals(".") || name.equals("..")) continue;
                                    FtpResponseReader.this.list.add(name);
                                }
                            }

                            public void failed(IOException e) {
                                if (FtpResponseReader.this.closed) {
                                    return;
                                }
                                if (FtpResponseReader.this.listCallback == null) {
                                    return;
                                }
                                LOGGER.debug("Connection failed: {}", (Object)FtpResponseReader.this.dataAddress, (Object)e);
                                FtpResponseReader.this.listCallback.failed(e);
                            }

                            public void connected(FailableCloseableByteBufferHandler write) {
                                FtpResponseReader.this.data = (CloseableByteBufferHandler)write;
                            }

                            public void close() {
                                if (FtpResponseReader.this.closed) {
                                    return;
                                }
                                FtpResponseReader.this.dataFinished = true;
                                if (FtpResponseReader.this.retrFinished) {
                                    if (FtpResponseReader.this.listCallback != null) {
                                        FtpResponseReader.this.listCallback.handle(FtpResponseReader.this.list);
                                    }
                                    FtpResponseReader.this.dataFinished = false;
                                    FtpResponseReader.this.retrFinished = false;
                                }
                            }
                        });
                        LOGGER.debug("Listing: {}", (Object)this.currentRawPath);
                        this.writeLine("TYPE A");
                        this.state = State.TYPE_A;
                        break;
                    }
                    new SocketReady(this.queue.getSelector(), this.queue.allocator()).connect(this.dataAddress, new ReadyConnection(){

                        public void handle(Address address, ByteBuffer buffer) {
                            if (FtpResponseReader.this.closed) {
                                return;
                            }
                            if (FtpResponseReader.this.downloadCallback == null) {
                                return;
                            }
                            FtpResponseReader.this.downloadCallback.handle(null, buffer);
                        }

                        public void failed(IOException e) {
                            if (FtpResponseReader.this.closed) {
                                return;
                            }
                            if (FtpResponseReader.this.downloadCallback == null) {
                                return;
                            }
                            LOGGER.debug("Connection failed: {}", (Object)FtpResponseReader.this.dataAddress, (Object)e);
                            FtpResponseReader.this.downloadCallback.failed(e);
                        }

                        public void connected(FailableCloseableByteBufferHandler write) {
                            FtpResponseReader.this.data = (CloseableByteBufferHandler)write;
                        }

                        public void close() {
                            if (FtpResponseReader.this.closed) {
                                return;
                            }
                            FtpResponseReader.this.dataFinished = true;
                            if (FtpResponseReader.this.retrFinished) {
                                if (FtpResponseReader.this.downloadCallback != null) {
                                    FtpResponseReader.this.downloadCallback.close();
                                }
                                FtpResponseReader.this.dataFinished = false;
                                FtpResponseReader.this.retrFinished = false;
                            }
                        }
                    });
                    LOGGER.debug("Getting: {}", (Object)file);
                    this.fileToRetr = file;
                    this.writeLine("TYPE I");
                    this.state = State.TYPE_I;
                    break;
                }
                case TYPE_I: {
                    this.checkCode(code, 200);
                    this.writeLine("RETR " + this.fileToRetr);
                    this.state = State.RETR;
                    break;
                }
                case TYPE_A: {
                    this.checkCode(code, 200);
                    this.writeLine("NLST");
                    this.state = State.NLST;
                    break;
                }
                case RETR: {
                    if (code == 550) {
                        Object c;
                        if (this.downloadCallback != null) {
                            c = this.downloadCallback;
                            this.downloadCallback = null;
                            c.doesNotExist(this.currentRawPath);
                        }
                        if (this.listCallback != null) {
                            c = this.listCallback;
                            this.listCallback = null;
                            c.doesNotExist(this.currentRawPath);
                        }
                        if (this.data != null) {
                            this.data.close();
                            this.data = null;
                        }
                        if (!this.toDownloadSplitPaths.isEmpty()) {
                            this.moveToDir();
                        } else {
                            this.idle = true;
                        }
                        return;
                    }
                    this.checkCode(code, 150, 125);
                    this.state = State.RETR_;
                    break;
                }
                case RETR_: {
                    this.checkCode(code, 226);
                    this.retrFinished = true;
                    if (this.dataFinished) {
                        Object c;
                        if (this.downloadCallback != null) {
                            c = this.downloadCallback;
                            this.downloadCallback = null;
                            c.close();
                        }
                        if (this.listCallback != null) {
                            c = this.listCallback;
                            this.listCallback = null;
                            c.handle(this.list);
                        }
                        this.dataFinished = false;
                        this.retrFinished = false;
                    }
                    if (!this.toDownloadSplitPaths.isEmpty()) {
                        this.moveToDir();
                        break;
                    }
                    this.idle = true;
                    break;
                }
                case NLST: {
                    if (code == 550) {
                        Object c;
                        if (this.downloadCallback != null) {
                            c = this.downloadCallback;
                            this.downloadCallback = null;
                            c.doesNotExist(this.currentRawPath);
                        }
                        if (this.listCallback != null) {
                            c = this.listCallback;
                            this.listCallback = null;
                            c.doesNotExist(this.currentRawPath);
                        }
                        if (this.data != null) {
                            this.data.close();
                            this.data = null;
                        }
                        if (!this.toDownloadSplitPaths.isEmpty()) {
                            this.moveToDir();
                        } else {
                            this.idle = true;
                        }
                        return;
                    }
                    this.checkCode(code, 150, 125);
                    this.state = State.NLST_;
                    break;
                }
                case NLST_: {
                    this.checkCode(code, 226);
                    this.retrFinished = true;
                    if (this.dataFinished) {
                        Object c;
                        if (this.downloadCallback != null) {
                            c = this.downloadCallback;
                            this.downloadCallback = null;
                            c.close();
                        }
                        if (this.listCallback != null) {
                            c = this.listCallback;
                            this.listCallback = null;
                            c.handle(this.list);
                        }
                        this.dataFinished = false;
                        this.retrFinished = false;
                    }
                    if (this.data != null) {
                        this.data.close();
                        this.data = null;
                    }
                    if (!this.toDownloadSplitPaths.isEmpty()) {
                        this.moveToDir();
                        break;
                    }
                    this.idle = true;
                }
            }
        }

        private void moveToDir() {
            List<String> path = this.toDownloadSplitPaths.getFirst();
            int i = 0;
            boolean goUp = false;
            for (String c : this.currentDirectory) {
                if (i == path.size() - 1) {
                    goUp = true;
                    break;
                }
                String p = path.get(i);
                if (!c.equals(p)) {
                    goUp = true;
                    break;
                }
                ++i;
            }
            if (goUp) {
                LOGGER.debug("CD ..");
                this.writeLine("CDUP");
                this.state = State.CDUP;
                return;
            }
            if (i < path.size() - 1) {
                this.goTo = path.get(i);
                LOGGER.debug("CD " + this.goTo);
                this.writeLine("CWD " + this.goTo);
                this.state = State.CWD;
                return;
            }
            this.writeLine("PASV");
            this.state = State.PASV;
        }

        private void download(String path) {
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Path cannot be empty");
            }
            if (path.charAt(0) != '/') {
                throw new IllegalArgumentException("Path must be absolute (must start with '/')");
            }
            path = path.substring(1);
            this.toDownloadRawPaths.addLast(path);
            this.toDownloadSplitPaths.addLast(FtpResponseReader.split(path, '/'));
            if (!this.idle) {
                return;
            }
            this.idle = false;
            this.moveToDir();
        }

        private static List<String> split(String s, char c) {
            return Splitter.on((char)c).splitToList((CharSequence)s);
        }

        private static enum State {
            _CONNECTING,
            USER,
            PASS,
            TYPE_I,
            TYPE_A,
            MODE,
            CWD,
            CDUP,
            PASV,
            RETR,
            RETR_,
            NLST,
            NLST_;

        }
    }
}

