/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.ftp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Failable;
import com.davfx.ninio.ftp.FtpClientHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToFileDownloadCallback
implements FtpClientHandler.Callback.DownloadCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToFileDownloadCallback.class);
    private final Failable end;
    private final File file;
    private IOException error = null;
    private OutputStream out = null;

    public ToFileDownloadCallback(File file, Failable end) {
        this.file = file;
        this.end = end;
    }

    @Override
    public void doesNotExist(String path) {
        LOGGER.debug("Does not exist: {}", (Object)path);
        this.end.failed(new IOException("Does not exist: " + path));
    }

    public void failed(IOException e) {
        this.end.failed(e);
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                LOGGER.error("File could not be properly closed: {}", (Object)this.file, (Object)ioe);
                this.error = ioe;
            }
            this.out = null;
        }
        this.end.failed(this.error);
    }

    public void handle(Address address, ByteBuffer buffer) {
        System.out.println(buffer.remaining());
        if (this.error != null) {
            return;
        }
        if (this.out == null) {
            try {
                this.out = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException ioe) {
                LOGGER.error("File could not be created: {}", (Object)this.file, (Object)ioe);
                this.error = ioe;
                this.out = null;
            }
        }
        if (this.out != null) {
            try {
                this.out.write(buffer.array(), buffer.position(), buffer.remaining());
            }
            catch (IOException ioe) {
                LOGGER.error("Could not write to: {}", (Object)this.file, (Object)ioe);
                this.error = ioe;
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.out = null;
            }
        }
    }
}

