/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AuthRemoteEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthRemoteEngine.class);
    private static final int ENCRYPTION_MARGIN = 64;
    private int bootCount = 0;
    private int time = 0;
    private byte[] id = new byte[0];
    private final String authLogin;
    private final String authPassword;
    private final String privLogin;
    private final String privPassword;
    private final MessageDigest messageDigest;
    private int packetNumber = 0;
    private byte[] encryptionParameters = new byte[8];
    private final SecureRandom random = new SecureRandom();
    private final String privEncryptionAlgorithm;
    private final Cipher cipher;
    private final int privKeyLength;
    private long timeResetAt = 0L;
    private boolean ready = false;

    public AuthRemoteEngine(String authLogin, String authPassword, String authDigestAlgorithm, String privLogin, String privPassword, String privEncryptionAlgorithm) {
        this.authLogin = authLogin;
        this.authPassword = authPassword;
        this.privLogin = privLogin;
        this.privPassword = privPassword;
        this.privEncryptionAlgorithm = privEncryptionAlgorithm;
        try {
            this.messageDigest = MessageDigest.getInstance(authDigestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            this.cipher = Cipher.getInstance(privEncryptionAlgorithm + "/" + (privEncryptionAlgorithm.equals("AES") ? "CFB" : "CBC") + "/" + (privEncryptionAlgorithm.equals("AES") ? "NoPadding" : "PKCS5Padding"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        this.privKeyLength = privEncryptionAlgorithm.equals("AES") ? 16 : 8;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady() {
        this.ready = true;
    }

    public String getAuthLogin() {
        return this.authLogin;
    }

    public String getPrivLogin() {
        return this.privLogin;
    }

    public int incPacketNumber() {
        int n = this.packetNumber++;
        return n;
    }

    public byte[] getEncryptionParameters() {
        return this.encryptionParameters;
    }

    public byte[] getId() {
        return this.id;
    }

    public void setId(byte[] id) {
        this.id = id;
    }

    public void setEncryptionParameters(byte[] encryptionParameters) {
        this.encryptionParameters = encryptionParameters;
    }

    public int getBootCount() {
        return this.bootCount;
    }

    public void setBootCount(int bootCount) {
        this.bootCount = bootCount;
    }

    public int getTime() {
        return this.time;
    }

    public void renewTime() {
        if (this.timeResetAt > 0L) {
            int oldTime = this.time;
            this.time += (int)((System.currentTimeMillis() - this.timeResetAt) / 1000L);
            LOGGER.trace("Auth engine time: {} -> {}", (Object)oldTime, (Object)this.time);
        }
    }

    public void resetTime(int time) {
        this.timeResetAt = System.currentTimeMillis();
        this.time = time;
    }

    public byte[] getAuthKey() {
        return this.getKey(this.authPassword);
    }

    private byte[] getPrivKey() {
        return this.getKey(this.privPassword);
    }

    private byte[] getKey(String password) {
        byte[] b;
        byte[] passwordBytes = password.getBytes(Charsets.UTF_8);
        int passwordIndex = 0;
        for (int count = 0; count < 0x100000; count += b.length) {
            b = new byte[64];
            for (int i = 0; i < b.length; ++i) {
                b[i] = passwordBytes[passwordIndex % passwordBytes.length];
                ++passwordIndex;
            }
            this.messageDigest.update(b);
        }
        byte[] digest = this.messageDigest.digest();
        this.messageDigest.reset();
        this.messageDigest.update(digest);
        this.messageDigest.update(this.id);
        this.messageDigest.update(digest);
        return this.messageDigest.digest();
    }

    public byte[] hash(ByteBuffer message) {
        int i;
        ByteBuffer messageDup = message.duplicate();
        byte[] digest = this.getAuthKey();
        byte[] k_ipad = new byte[64];
        byte[] k_opad = new byte[64];
        for (i = 0; i < digest.length; ++i) {
            k_ipad[i] = (byte)(digest[i] ^ 0x36);
            k_opad[i] = (byte)(digest[i] ^ 0x5C);
        }
        for (i = digest.length; i < 64; ++i) {
            k_ipad[i] = 54;
            k_opad[i] = 92;
        }
        this.messageDigest.update(k_ipad);
        this.messageDigest.update(messageDup);
        byte[] newDigest = this.messageDigest.digest();
        this.messageDigest.reset();
        this.messageDigest.update(k_opad);
        this.messageDigest.update(newDigest);
        newDigest = this.messageDigest.digest();
        byte[] k = new byte[12];
        System.arraycopy(newDigest, 0, k, 0, k.length);
        return k;
    }

    public ByteBuffer encrypt(ByteBuffer decryptedBuffer) {
        byte[] iv;
        byte[] encryptionKey = this.getPrivKey();
        int salt = this.random.nextInt();
        if (this.privEncryptionAlgorithm.equals("AES")) {
            iv = new byte[16];
            ByteBuffer ivb = ByteBuffer.wrap(iv);
            ivb.putInt(this.getBootCount());
            ivb.putInt(this.getTime());
            ivb.putInt(0);
            ivb.putInt(salt);
            ByteBuffer bb = ByteBuffer.wrap(this.encryptionParameters);
            bb.putInt(0);
            bb.putInt(salt);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(this.encryptionParameters);
            bb.putInt(this.getBootCount());
            bb.putInt(salt);
            iv = new byte[8];
            for (int i = 0; i < iv.length; ++i) {
                iv[i] = (byte)(encryptionKey[iv.length + i] ^ this.encryptionParameters[i]);
            }
        }
        try {
            this.cipher.init(1, (Key)new SecretKeySpec(encryptionKey, 0, this.privKeyLength, this.privEncryptionAlgorithm), new IvParameterSpec(iv));
            ByteBuffer b = ByteBuffer.allocate(decryptedBuffer.remaining() + 64);
            this.cipher.doFinal(decryptedBuffer, b);
            b.flip();
            return b;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer decrypt(ByteBuffer encryptedBuffer) {
        byte[] iv;
        byte[] decryptionKey = this.getPrivKey();
        if (this.privEncryptionAlgorithm.equals("AES")) {
            iv = new byte[16];
            ByteBuffer ivb = ByteBuffer.wrap(iv);
            ivb.putInt(this.getBootCount());
            ivb.putInt(this.getTime());
            ByteBuffer bb = ByteBuffer.wrap(this.encryptionParameters);
            ivb.putInt(bb.getInt());
            ivb.putInt(bb.getInt());
        } else {
            iv = new byte[8];
            for (int i = 0; i < 8; ++i) {
                iv[i] = (byte)(decryptionKey[8 + i] ^ this.encryptionParameters[i]);
            }
        }
        try {
            SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, this.privKeyLength, this.privEncryptionAlgorithm);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            this.cipher.init(2, (Key)key, ivSpec);
            ByteBuffer b = ByteBuffer.allocate(encryptedBuffer.remaining() + 64);
            this.cipher.doFinal(encryptedBuffer, b);
            b.flip();
            return b;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

