/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.Oid;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;

public final class BerReader {
    private final ByteBuffer buffer;
    private final Deque<Integer> toReadLengthPositions = new LinkedList<Integer>();

    public BerReader(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    private int doReadType(ByteBuffer buffer) throws IOException {
        int b = buffer.get() & 0xFF;
        if ((b & 0x80) == 128) {
            throw new IOException("No such object");
        }
        return b;
    }

    private static int doReadLength(ByteBuffer buffer) throws IOException {
        int lengthbyte = buffer.get() & 0xFF;
        if ((lengthbyte & 0x80) == 128) {
            if ((lengthbyte &= 0xFFFFFF7F) == 0) {
                throw new IOException("Indefinite lengths are not supported");
            }
            if (lengthbyte > 4) {
                throw new IOException("Data length > 4 bytes are not supported");
            }
            int length = 0;
            for (int i = 0; i < lengthbyte; ++i) {
                length <<= 8;
                length |= buffer.get() & 0xFF;
            }
            if (length < 0) {
                throw new IOException("SNMP does not support data lengths > 2^31");
            }
            return length;
        }
        return lengthbyte;
    }

    private static int doReadInteger(ByteBuffer buffer, int length) throws IOException {
        int value = 0;
        for (int i = 0; i < length; ++i) {
            int b = buffer.get() & 0xFF;
            if (i == 0 && (b & 0x80) == 128) {
                value = -1;
            }
            value <<= 8;
            value |= b;
        }
        return value;
    }

    private static long doReadLong(ByteBuffer buffer, int length) throws IOException {
        int value = 0;
        for (int i = 0; i < length; ++i) {
            int b = buffer.get() & 0xFF;
            if (i == 0 && (b & 0x80) == 128) {
                value = -1;
            }
            value <<= 8;
            value |= b;
        }
        return value;
    }

    private static float doReadFloat(ByteBuffer buffer, int length) throws IOException {
        return buffer.getFloat();
    }

    private static double doReadDouble(ByteBuffer buffer, int length) throws IOException {
        return buffer.getDouble();
    }

    private static BigInteger doReadUnsignedLongInteger(ByteBuffer buffer, int length) throws IOException {
        byte[] b = new byte[length];
        buffer.get(b);
        return new BigInteger(b);
    }

    public int readInteger() throws IOException {
        int type = this.doReadType(this.buffer);
        if (type != 2) {
            throw new IOException("Wrong ASN.1 type. Not an integer: " + type);
        }
        int length = BerReader.doReadLength(this.buffer);
        return BerReader.doReadInteger(this.buffer, length);
    }

    private static int[] doReadOid(ByteBuffer buffer, int length) throws IOException {
        LinkedList<Integer> values = new LinkedList<Integer>();
        if (length == 0) {
            throw new IOException("Invalid OID");
        }
        int b = buffer.get() & 0xFF;
        values.add(b / 40);
        values.add(b % 40);
        --length;
        int value = 0;
        while (length > 0) {
            b = buffer.get() & 0xFF;
            value <<= 7;
            value |= b & 0xFFFFFF7F;
            if ((b & 0x80) == 0) {
                values.add(value);
                value = 0;
            }
            --length;
        }
        int[] v = new int[values.size()];
        int i = 0;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            int val;
            v[i] = val = ((Integer)iterator.next()).intValue();
            ++i;
        }
        return v;
    }

    public Oid readOid() throws IOException {
        int type = this.doReadType(this.buffer);
        if (type != 6) {
            throw new IOException("Wrong type. Not an OID: " + type);
        }
        int length = BerReader.doReadLength(this.buffer);
        return new Oid(BerReader.doReadOid(this.buffer, length));
    }

    private static ByteBuffer doReadString(ByteBuffer buffer, int length) throws IOException {
        ByteBuffer b = ByteBuffer.wrap(buffer.array(), buffer.position(), length);
        buffer.position(buffer.position() + length);
        return b;
    }

    public ByteBuffer readBytes() throws IOException {
        int type = this.doReadType(this.buffer);
        if (type != 4) {
            throw new IOException("Wrong ASN.1 type. Not a string: " + type);
        }
        int length = BerReader.doReadLength(this.buffer);
        return BerReader.doReadString(this.buffer, length);
    }

    public void readNull() throws IOException {
        int type = this.doReadType(this.buffer);
        if (type != 5) {
            throw new IOException("Wrong ASN.1 type. Not a null: " + type);
        }
        BerReader.doReadLength(this.buffer);
    }

    public int beginReadSequence() throws IOException {
        int type = this.buffer.get() & 0xFF;
        if (type != 48 && type != 162 && type != 168 && type != 160 && type != 161 && type != 165) {
            throw new IOException("Wrong ASN.1 type. Not a sequence: " + type);
        }
        int length = BerReader.doReadLength(this.buffer);
        this.toReadLengthPositions.addFirst(this.buffer.position() + length);
        return type;
    }

    public void endReadSequence() throws IOException {
        int position = this.toReadLengthPositions.removeFirst();
        if (position != this.buffer.position()) {
            throw new IOException("Bad sequence: " + position + "!=" + this.buffer.position());
        }
    }

    public boolean hasRemainingInSequence() {
        int position = this.toReadLengthPositions.getFirst();
        return this.buffer.position() < position;
    }

    public String readValue() throws IOException {
        return BerReader.doReadValue(this.buffer, false);
    }

    private static String doReadValue(ByteBuffer buffer, boolean opaque) throws IOException {
        int type = buffer.get() & 0xFF;
        if ((type & 0x80) == 128) {
            if (!opaque) {
                int l = BerReader.doReadLength(buffer);
                BerReader.doReadString(buffer, l);
                return null;
            }
            type = buffer.get() & 0xFF;
        } else if (opaque) {
            int l = BerReader.doReadLength(buffer);
            BerReader.doReadString(buffer, l);
            return null;
        }
        int length = BerReader.doReadLength(buffer);
        if (type == 2) {
            return String.valueOf(BerReader.doReadInteger(buffer, length));
        }
        if (type == 67) {
            return String.valueOf(BerReader.doReadUnsignedLongInteger(buffer, length));
        }
        if (type == 65 || type == 66 || type == 70 || type == 71) {
            return String.valueOf(BerReader.doReadUnsignedLongInteger(buffer, length));
        }
        if (type == 5) {
            if (length != 0) {
                throw new IOException("Invalid Null encoding, length is not zero");
            }
            return null;
        }
        if (type == 6) {
            return new Oid(BerReader.doReadOid(buffer, length)).toString();
        }
        if (type == 64) {
            return BerReader.asIpString(BerReader.doReadString(buffer, length));
        }
        if (type == 4) {
            return BerReader.string(BerReader.doReadString(buffer, length));
        }
        if (type == 68) {
            ByteBuffer wrapped = BerReader.doReadString(buffer, length);
            return BerReader.doReadValue(wrapped, true);
        }
        if (type == 120) {
            return String.valueOf(BerReader.doReadFloat(buffer, length));
        }
        if (type == 121) {
            return String.valueOf(BerReader.doReadDouble(buffer, length));
        }
        if (type == 122) {
            return String.valueOf(BerReader.doReadLong(buffer, length));
        }
        if (type == 123) {
            return String.valueOf(BerReader.doReadUnsignedLongInteger(buffer, length));
        }
        return BerReader.string(BerReader.doReadString(buffer, length));
    }

    private static String asIpString(ByteBuffer bb) {
        ByteBuffer bytes = bb.duplicate();
        if (bytes.remaining() == 4) {
            StringBuilder b = new StringBuilder();
            while (bytes.hasRemaining()) {
                int k = bytes.get() & 0xFF;
                if (b.length() > 0) {
                    b.append('.');
                }
                b.append(String.valueOf(k));
            }
            return b.toString();
        }
        StringBuilder b = new StringBuilder();
        while (bytes.hasRemaining()) {
            int k = (bytes.get() & 0xFF) << 8 | bytes.get() & 0xFF;
            String s = Integer.toHexString(k);
            if (b.length() > 0) {
                b.append(':');
            }
            b.append(s);
        }
        return b.toString();
    }

    private static String string(ByteBuffer bb) {
        ByteBuffer bytes = bb.duplicate();
        while (bytes.hasRemaining()) {
            int c = bytes.get() & 0xFF;
            if ((c >= 32 || c == 10 || c == 13) && c < 127) continue;
            return BaseEncoding.base16().encode(bb.array(), bb.position(), bb.remaining());
        }
        return BerPacketUtils.string(bb);
    }
}

