/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.BerPacket;
import com.davfx.ninio.snmp.BerPacketUtils;
import java.nio.ByteBuffer;

public final class BytesBerPacket
implements BerPacket {
    private final ByteBuffer lengthBuffer;
    private final int length;
    private final ByteBuffer s;

    public BytesBerPacket(ByteBuffer s) {
        this.s = s;
        this.length = s.remaining();
        this.lengthBuffer = BerPacketUtils.lengthBuffer(this.length);
    }

    @Override
    public void write(ByteBuffer buffer) {
        BerPacketUtils.writeHeader(4, this.lengthBuffer, buffer);
        int p = this.s.position();
        buffer.put(this.s);
        this.s.position(p);
    }

    @Override
    public ByteBuffer lengthBuffer() {
        return this.lengthBuffer;
    }

    @Override
    public int length() {
        return this.length;
    }
}

