/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.Result;
import com.davfx.ninio.snmp.SnmpClientHandler;
import com.davfx.util.ConfigUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Date;

public final class CacheFailSnmpClientHandler
implements SnmpClientHandler {
    private static final Config CONFIG = ConfigFactory.load();
    private static final double EXPIRATION = ConfigUtils.getDuration((Config)CONFIG, (String)"ninio.snmp.cache.fail.expiration");
    private final SnmpClientHandler wrappee;
    private Date failedExpiration = null;
    private IOException failedError = null;

    public CacheFailSnmpClientHandler(SnmpClientHandler wrappee) {
        this.wrappee = wrappee;
    }

    public void close() {
        this.wrappee.close();
    }

    public void failed(IOException e) {
        this.wrappee.failed(e);
    }

    @Override
    public void launched(final SnmpClientHandler.Callback callback) {
        this.wrappee.launched(new SnmpClientHandler.Callback(){

            public void close() {
                callback.close();
            }

            @Override
            public void get(Oid oid, final SnmpClientHandler.Callback.GetCallback getCallback) {
                Date now = new Date();
                if (CacheFailSnmpClientHandler.this.failedExpiration != null && CacheFailSnmpClientHandler.this.failedExpiration.before(now)) {
                    CacheFailSnmpClientHandler.this.failedExpiration = null;
                    CacheFailSnmpClientHandler.this.failedError = null;
                }
                if (CacheFailSnmpClientHandler.this.failedError != null) {
                    getCallback.failed(CacheFailSnmpClientHandler.this.failedError);
                    return;
                }
                callback.get(oid, new SnmpClientHandler.Callback.GetCallback(){

                    public void failed(IOException e) {
                        CacheFailSnmpClientHandler.this.failedExpiration = new Date(System.currentTimeMillis() + (long)(EXPIRATION * 1000.0));
                        CacheFailSnmpClientHandler.this.failedError = e;
                        getCallback.failed(e);
                    }

                    public void close() {
                        getCallback.close();
                    }

                    @Override
                    public void result(Result result) {
                        getCallback.result(result);
                    }
                });
            }
        });
    }
}

